// Generated by gtkmmproc -- DO NOT MODIFY!


#include <libgdamm/datamodel.h>
#include <libgdamm/private/datamodel_p.h>

/* $Id: datamodel.ccg,v 1.11 2006/11/08 01:42:01 murrayc Exp $ */
// -*- C++ -*- // this is for the .ccg, I realize gensig puts one in

/* datamodel.cc
 * 
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/serverprovider.h>
#include <libgda/gda-data-model.h>
#include <libgda/gda-data-model-extra.h>
#include <libgda/gda-data-model-array.h>
#include <libgda/gda-enum-types.h>


namespace Gnome
{

namespace Gda
{
     
Value DataModel::get_value_at(int col, int row) const
{
  //Note that the function does not return a new value, so we should not free it:
  return(Value(gda_data_model_get_value_at(const_cast<GdaDataModel*>(gobj()), col, row)));
}

Value DataModel::get_value_at(const Glib::ustring& column_name, int row) const
{
  //Note that the function does not return a new value, so we should not free it:
  return(Value(gda_data_model_get_value_at_col_name(const_cast<GdaDataModel*>(gobj()), column_name.c_str(), row)));
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool DataModel::export_to_file(DataModelIOFormat format, const std::string& file, const Glib::ArrayHandle<int>& cols, const Glib::ArrayHandle<int>& rows, const Glib::RefPtr<ParameterList>& options)
#else
bool DataModel::export_to_file(DataModelIOFormat format, const std::string& file, const Glib::ArrayHandle<int>& cols, const Glib::ArrayHandle<int>& rows, const Glib::RefPtr<ParameterList>& options, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_data_model_export_to_file(gobj(), static_cast<GdaDataModelIOFormat>(format), file.c_str(), cols.data(), cols.size(), rows.data(), rows.size(), const_cast<GdaParameterList*>(options->gobj()), &gerror);
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;
}

Glib::ustring DataModel::export_to_string(DataModelIOFormat format, const Glib::ArrayHandle<int>& cols, const Glib::ArrayHandle<int>& rows, const Glib::RefPtr<ParameterList>& options)
{
  gchar* retvalue = gda_data_model_export_to_string(gobj(), static_cast<GdaDataModelIOFormat>(format), cols.data(), cols.size(), rows.data(), rows.size(), options->gobj());
  Glib::ustring cppretvalue(retvalue);
  g_free(retvalue);

  return cppretvalue;
}


} /* namespace Gda */

} /* namespace Gnome */


namespace
{


static void DataModel_signal_row_inserted_callback(GdaDataModel* self, gint row,void* data)
{
  using namespace Gnome::Gda;
  typedef sigc::slot< void,int > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(row
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo DataModel_signal_row_inserted_info =
{
  "row_inserted",
  (GCallback) &DataModel_signal_row_inserted_callback,
  (GCallback) &DataModel_signal_row_inserted_callback
};


static void DataModel_signal_row_updated_callback(GdaDataModel* self, gint row,void* data)
{
  using namespace Gnome::Gda;
  typedef sigc::slot< void,int > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(row
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo DataModel_signal_row_updated_info =
{
  "row_updated",
  (GCallback) &DataModel_signal_row_updated_callback,
  (GCallback) &DataModel_signal_row_updated_callback
};


static void DataModel_signal_row_removed_callback(GdaDataModel* self, gint row,void* data)
{
  using namespace Gnome::Gda;
  typedef sigc::slot< void,int > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(row
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo DataModel_signal_row_removed_info =
{
  "row_removed",
  (GCallback) &DataModel_signal_row_removed_callback,
  (GCallback) &DataModel_signal_row_removed_callback
};


static const Glib::SignalProxyInfo DataModel_signal_reset_info =
{
  "reset",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


} // anonymous namespace

// static
GType Glib::Value<Gnome::Gda::DataModelAccessFlags>::value_type()
{
  return gda_data_model_access_flags_get_type();
}

// static
GType Glib::Value<Gnome::Gda::DataModelHint>::value_type()
{
  return gda_data_model_hint_get_type();
}

// static
GType Glib::Value<Gnome::Gda::DataModelIOFormat>::value_type()
{
  return gda_data_model_io_format_get_type();
}


namespace Glib
{

Glib::RefPtr<Gnome::Gda::DataModel> wrap(GdaDataModel* object, bool take_copy)
{
  return Glib::RefPtr<Gnome::Gda::DataModel>( dynamic_cast<Gnome::Gda::DataModel*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} // namespace Glib


namespace Gnome
{

namespace Gda
{


/* The *_Class implementation: */

const Glib::Interface_Class& DataModel_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Interface_Class has to know the interface init function
    // in order to add interfaces to implementing types.
    class_init_func_ = &DataModel_Class::iface_init_function;

    // We can not derive from another interface, and it is not necessary anyway.
    gtype_ = gda_data_model_get_type();
  }

  return *this;
}

void DataModel_Class::iface_init_function(void* g_iface, void*)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_iface);

  //This is just to avoid an "unused variable" warning when there are no vfuncs or signal handlers to connect.
  //This is a temporary fix until I find out why I can not seem to derive a GtkFileChooser interface. murrayc
  g_assert(klass != 0); 

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  klass->row_inserted = &row_inserted_callback;
  klass->row_updated = &row_updated_callback;
  klass->row_removed = &row_removed_callback;
  klass->reset = &reset_callback;
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void DataModel_Class::row_inserted_callback(GdaDataModel* self, gint row)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_row_inserted(row
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->row_inserted)
    (*base->row_inserted)(self, row);
}
void DataModel_Class::row_updated_callback(GdaDataModel* self, gint row)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_row_updated(row
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->row_updated)
    (*base->row_updated)(self, row);
}
void DataModel_Class::row_removed_callback(GdaDataModel* self, gint row)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_row_removed(row
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->row_removed)
    (*base->row_removed)(self, row);
}
void DataModel_Class::reset_callback(GdaDataModel* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_reset();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(self), CppObjectType::get_type()) // Get the interface.
)    );

  // Call the original underlying C function:
  if(base && base->reset)
    (*base->reset)(self);
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* DataModel_Class::wrap_new(GObject* object)
{
  return new DataModel((GdaDataModel*)(object));
}


/* The implementation: */

DataModel::DataModel()
:
  Glib::Interface(datamodel_class_.init())
{}

DataModel::DataModel(GdaDataModel* castitem)
:
  Glib::Interface((GObject*)(castitem))
{}

DataModel::~DataModel()
{}

// static
void DataModel::add_interface(GType gtype_implementer)
{
  datamodel_class_.init().add_interface(gtype_implementer);
}

DataModel::CppClassType DataModel::datamodel_class_; // initialize static member

GType DataModel::get_type()
{
  return datamodel_class_.init().get_type();
}

GType DataModel::get_base_type()
{
  return gda_data_model_get_type();
}


void DataModel::freeze()
{
gda_data_model_freeze(gobj()); 
}

void DataModel::thaw()
{
gda_data_model_thaw(gobj()); 
}

int DataModel::get_n_rows() const
{
  return gda_data_model_get_n_rows(const_cast<GdaDataModel*>(gobj()));
}

int DataModel::get_n_columns() const
{
  return gda_data_model_get_n_columns(const_cast<GdaDataModel*>(gobj()));
}

Glib::RefPtr<Column> DataModel::describe_column(int col)
{
  return Glib::wrap(gda_data_model_describe_column(gobj(), col));
}

Glib::RefPtr<const Column> DataModel::describe_column(int col) const
{
  return Glib::wrap(gda_data_model_describe_column(const_cast<GdaDataModel*>(gobj()), col));
}

int DataModel::get_column_index(const Glib::ustring& name) const
{
  return gda_data_model_get_column_index_by_name(const_cast<GdaDataModel*>(gobj()), name.c_str());
}

Glib::ustring DataModel::get_column_title(int col) const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gda_data_model_get_column_title(const_cast<GdaDataModel*>(gobj()), col));
}

void DataModel::set_column_title(int col, const Glib::ustring& title)
{
gda_data_model_set_column_title(gobj(), col, title.c_str()); 
}

ValueAttribute DataModel::get_attributes_at(int col, int row)
{
  return ((ValueAttribute)(gda_data_model_get_attributes_at(gobj(), col, row)));
}

Glib::RefPtr<DataModelIter> DataModel::create_iter()
{
  return Glib::wrap(gda_data_model_create_iter(gobj()));
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool DataModel::set_value_at(int col, int row, const Value& value)
#else
bool DataModel::set_value_at(int col, int row, const Value& value, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_data_model_set_value_at(gobj(), col, row, (value).gobj(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool DataModel::set_values(int row, const ValueList& values)
#else
bool DataModel::set_values(int row, const ValueList& values, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_data_model_set_values(gobj(), row, values.data(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

bool DataModel::is_updatable() const
{
  return gda_data_model_is_updatable(const_cast<GdaDataModel*>(gobj()));
}

DataModelAccessFlags DataModel::get_access_flags() const
{
  return ((DataModelAccessFlags)(gda_data_model_get_access_flags(const_cast<GdaDataModel*>(gobj()))));
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
int DataModel::append_values(const ValueList& values)
#else
int DataModel::append_values(const ValueList& values, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  int retvalue = gda_data_model_append_values(gobj(), values.data(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool DataModel::append_row()
#else
bool DataModel::append_row(std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_data_model_append_row(gobj(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool DataModel::remove_row(int row)
#else
bool DataModel::remove_row(int row, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_data_model_remove_row(gobj(), row, &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

int DataModel::get_row_from_values(const ValueSList& values, const Glib::ArrayHandle<int>& cols_index)
{
  return gda_data_model_get_row_from_values(gobj(), values.data(), const_cast<gint*>((cols_index).data()));
}

void DataModel::send_hint(DataModelHint hint, const Value& hint_value)
{
gda_data_model_send_hint(gobj(), ((GdaDataModelHint)(hint)), (hint_value).gobj()); 
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool DataModel::import_from_model(const Glib::RefPtr<DataModel>& from, bool overwrite, GHashTable * cols_trans)
#else
bool DataModel::import_from_model(const Glib::RefPtr<DataModel>& from, bool overwrite, GHashTable * cols_trans, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_data_model_import_from_model(gobj(), Glib::unwrap(from), static_cast<int>(overwrite), cols_trans, &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool DataModel::import_from_string(const Glib::ustring& string, GHashTable * cols_trans, const Glib::RefPtr<const ParameterList>& options)
#else
bool DataModel::import_from_string(const Glib::ustring& string, GHashTable * cols_trans, const Glib::RefPtr<const ParameterList>& options, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_data_model_import_from_string(gobj(), string.c_str(), cols_trans, const_cast<GdaParameterList*>(Glib::unwrap(options)), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool DataModel::import_from_file(const std::string& file, GHashTable * cols_trans, const Glib::RefPtr<const ParameterList>& options)
#else
bool DataModel::import_from_file(const std::string& file, GHashTable * cols_trans, const Glib::RefPtr<const ParameterList>& options, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = gda_data_model_import_from_file(gobj(), file.c_str(), cols_trans, const_cast<GdaParameterList*>(Glib::unwrap(options)), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

void DataModel::dump(FILE* to_stream) const
{
gda_data_model_dump(const_cast<GdaDataModel*>(gobj()), to_stream); 
}

Glib::ustring DataModel::dump_as_string() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gda_data_model_dump_as_string(const_cast<GdaDataModel*>(gobj())));
}

bool DataModel::move_iter_at_row_default(const Glib::RefPtr<DataModelIter>& iter, int row)
{
  return gda_data_model_move_iter_at_row_default(gobj(), Glib::unwrap(iter), row);
}

bool DataModel::move_iter_next_default(const Glib::RefPtr<DataModelIter>& iter)
{
  return gda_data_model_move_iter_next_default(gobj(), Glib::unwrap(iter));
}

bool DataModel::move_iter_prev_default(const Glib::RefPtr<DataModelIter>& iter)
{
  return gda_data_model_move_iter_prev_default(gobj(), Glib::unwrap(iter));
}

void DataModel::signal_emit_changed()
{
gda_data_model_signal_emit_changed(gobj()); 
}


Glib::SignalProxy1< void,int > DataModel::signal_row_inserted()
{
  return Glib::SignalProxy1< void,int >(this, &DataModel_signal_row_inserted_info);
}


Glib::SignalProxy1< void,int > DataModel::signal_row_updated()
{
  return Glib::SignalProxy1< void,int >(this, &DataModel_signal_row_updated_info);
}


Glib::SignalProxy1< void,int > DataModel::signal_row_removed()
{
  return Glib::SignalProxy1< void,int >(this, &DataModel_signal_row_removed_info);
}


Glib::SignalProxy0< void > DataModel::signal_reset()
{
  return Glib::SignalProxy0< void >(this, &DataModel_signal_reset_info);
}


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Gnome::Gda::DataModel::on_row_inserted(int row)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->row_inserted)
    (*base->row_inserted)(gobj(),row);
}
void Gnome::Gda::DataModel::on_row_updated(int row)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->row_updated)
    (*base->row_updated)(gobj(),row);
}
void Gnome::Gda::DataModel::on_row_removed(int row)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->row_removed)
    (*base->row_removed)(gobj(),row);
}
void Gnome::Gda::DataModel::on_reset()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_interface_peek_parent( // Get the parent interface of the interface (The original underlying C interface).
g_type_interface_peek(G_OBJECT_GET_CLASS(gobject_), CppObjectType::get_type()) // Get the interface.
)  );

  if(base && base->reset)
    (*base->reset)(gobj());
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gda

} // namespace Gnome


