#include <gio/gio.h>

#if defined (__ELF__) && ( __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 6))
# define SECTION __attribute__ ((section (".gresource.bdb"), aligned (8)))
#else
# define SECTION
#endif

static const SECTION union { const guint8 data[464]; const double alignment; void * const ptr;}  bdb_resource_data = { {
  0x47, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x18, 0x00, 0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x28, 0x04, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
  0x03, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
  0xd4, 0xb5, 0x02, 0x00, 0xff, 0xff, 0xff, 0xff, 
  0x90, 0x00, 0x00, 0x00, 0x01, 0x00, 0x4c, 0x00, 
  0x94, 0x00, 0x00, 0x00, 0x98, 0x00, 0x00, 0x00, 
  0xa5, 0x0b, 0x85, 0xed, 0x03, 0x00, 0x00, 0x00, 
  0x98, 0x00, 0x00, 0x00, 0x04, 0x00, 0x4c, 0x00, 
  0x9c, 0x00, 0x00, 0x00, 0xa0, 0x00, 0x00, 0x00, 
  0xc5, 0x5d, 0x9f, 0x09, 0x01, 0x00, 0x00, 0x00, 
  0xa0, 0x00, 0x00, 0x00, 0x15, 0x00, 0x76, 0x00, 
  0xb8, 0x00, 0x00, 0x00, 0xc7, 0x01, 0x00, 0x00, 
  0x4e, 0xa1, 0xe1, 0x7d, 0x00, 0x00, 0x00, 0x00, 
  0xc7, 0x01, 0x00, 0x00, 0x05, 0x00, 0x4c, 0x00, 
  0xcc, 0x01, 0x00, 0x00, 0xd0, 0x01, 0x00, 0x00, 
  0x2f, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 
  0x62, 0x64, 0x62, 0x2f, 0x02, 0x00, 0x00, 0x00, 
  0x62, 0x64, 0x62, 0x5f, 0x73, 0x70, 0x65, 0x63, 
  0x73, 0x5f, 0x64, 0x73, 0x6e, 0x2e, 0x72, 0x61, 
  0x77, 0x2e, 0x78, 0x6d, 0x6c, 0x00, 0x00, 0x00, 
  0x18, 0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
  0x78, 0xda, 0x8d, 0x91, 0x4f, 0x6b, 0xc3, 0x30, 
  0x0c, 0xc5, 0xef, 0xfd, 0x14, 0xc2, 0xf7, 0x2e, 
  0xdb, 0x75, 0xd8, 0x2d, 0xc9, 0x9c, 0x42, 0x59, 
  0xff, 0x91, 0x75, 0xe7, 0xe1, 0xc6, 0x6a, 0x62, 
  0xea, 0xc6, 0xc1, 0x4e, 0xb6, 0xe5, 0xdb, 0x4f, 
  0x81, 0x11, 0xd2, 0xad, 0x85, 0x1e, 0x9f, 0xa4, 
  0x27, 0xfd, 0x78, 0xe2, 0xf3, 0xef, 0xb3, 0x85, 
  0x4f, 0xf4, 0xc1, 0xb8, 0x4a, 0xb0, 0xa7, 0x87, 
  0x47, 0x36, 0x9f, 0x4d, 0xb8, 0x56, 0x8d, 0x9a, 
  0x06, 0x6c, 0xa6, 0xa1, 0xc6, 0x7c, 0x36, 0x01, 
  0xe0, 0xb5, 0xf2, 0xea, 0x8c, 0x0d, 0x0d, 0xf6, 
  0x72, 0x5c, 0x00, 0xa3, 0x05, 0x93, 0xc9, 0xc7, 
  0x26, 0x5e, 0xa7, 0x0c, 0x2a, 0x2a, 0x92, 0x24, 
  0xff, 0x41, 0x05, 0x84, 0xa3, 0xb1, 0xc8, 0x40, 
  0x63, 0xc8, 0xbd, 0x60, 0x09, 0xfa, 0x13, 0x5a, 
  0xec, 0x40, 0x26, 0xa0, 0xc7, 0x13, 0xbd, 0x09, 
  0x1a, 0x07, 0x07, 0x84, 0x36, 0xa0, 0x66, 0x50, 
  0x50, 0xbb, 0xab, 0x69, 0x51, 0x91, 0x97, 0x74, 
  0xc7, 0x7b, 0xd5, 0xd1, 0xea, 0xd6, 0x5a, 0x77, 
  0x12, 0x6c, 0x11, 0xaf, 0xde, 0x52, 0x16, 0xdd, 
  0xe2, 0x90, 0xcb, 0x6c, 0xc0, 0x30, 0x1e, 0xf3, 
  0xc6, 0xf9, 0x6e, 0x40, 0x18, 0x2a, 0xf0, 0x55, 
  0xa2, 0xa7, 0xa3, 0x25, 0x5e, 0xa2, 0x80, 0x09, 
  0x10, 0x68, 0xe0, 0x4e, 0x0a, 0xa8, 0x6d, 0x5b, 
  0x18, 0x4a, 0xae, 0xf7, 0x06, 0xb4, 0xcf, 0xeb, 
  0xad, 0x4c, 0xc5, 0x6e, 0xf9, 0xf2, 0xba, 0xd8, 
  0xae, 0x64, 0x9a, 0xdd, 0xc6, 0xdc, 0xc5, 0xd9, 
  0xfe, 0x5f, 0x5c, 0xbd, 0x1c, 0x58, 0x37, 0x7d, 
  0x2a, 0xee, 0x78, 0xc9, 0x68, 0xaa, 0x2b, 0xcc, 
  0x77, 0x47, 0xb7, 0xcf, 0xde, 0x7f, 0x93, 0xe3, 
  0xd1, 0xf8, 0xa3, 0x3c, 0xfa, 0xf3, 0xf1, 0x1f, 
  0x07, 0xca, 0xb1, 0x13, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x28, 0x75, 0x75, 0x61, 0x79, 0x29, 0x73, 
  0x70, 0x65, 0x63, 0x2f, 0x01, 0x00, 0x00, 0x00
} };

static GStaticResource static_resource = { bdb_resource_data.data, sizeof (bdb_resource_data.data), NULL, NULL, NULL };
extern GResource *bdb_get_resource (void);
GResource *bdb_get_resource (void)
{
  return g_static_resource_get_resource (&static_resource);
}
/*
  If G_HAS_CONSTRUCTORS is true then the compiler support *both* constructors and
  destructors, in a sane way, including e.g. on library unload. If not you're on
  your own.

  Some compilers need #pragma to handle this, which does not work with macros,
  so the way you need to use this is (for constructors):

  #ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
  #pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(my_constructor)
  #endif
  G_DEFINE_CONSTRUCTOR(my_constructor)
  static void my_constructor(void) {
   ...
  }

*/

#ifndef __GTK_DOC_IGNORE__

#if  __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 7)

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR(_func) static void __attribute__((constructor)) _func (void);
#define G_DEFINE_DESTRUCTOR(_func) static void __attribute__((destructor)) _func (void);

#elif defined (_MSC_VER) && (_MSC_VER >= 1500)
/* Visual studio 2008 and later has _Pragma */

#define G_HAS_CONSTRUCTORS 1

/* We do some weird things to avoid the constructors being optimized
 * away on VS2015 if WholeProgramOptimization is enabled. First we
 * make a reference to the array from the wrapper to make sure its
 * references. Then we use a pragma to make sure the wrapper function
 * symbol is always included at the link stage. Also, the symbols
 * need to be extern (but not dllexport), even though they are not
 * really used from another object file.
 */

/* We need to account for differences between the mangling of symbols
 * for Win32 (x86) and x64 programs, as symbols on Win32 are prefixed
 * with an underscore but symbols on x64 are not.
 */
#ifdef _WIN64
#define G_MSVC_SYMBOL_PREFIX ""
#else
#define G_MSVC_SYMBOL_PREFIX "_"
#endif

#define G_DEFINE_CONSTRUCTOR(_func) G_MSVC_CTOR (_func, G_MSVC_SYMBOL_PREFIX)
#define G_DEFINE_DESTRUCTOR(_func) G_MSVC_DTOR (_func, G_MSVC_SYMBOL_PREFIX)

#define G_MSVC_CTOR(_func,_sym_prefix) \
  static void _func(void); \
  extern int (* _array ## _func)(void);              \
  int _func ## _wrapper(void) { _func(); g_slist_find (NULL,  _array ## _func); return 0; } \
  __pragma(comment(linker,"/include:" _sym_prefix # _func "_wrapper")) \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) int (* _array ## _func)(void) = _func ## _wrapper;

#define G_MSVC_DTOR(_func,_sym_prefix) \
  static void _func(void); \
  extern int (* _array ## _func)(void);              \
  int _func ## _constructor(void) { atexit (_func); g_slist_find (NULL,  _array ## _func); return 0; } \
   __pragma(comment(linker,"/include:" _sym_prefix # _func "_constructor")) \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) int (* _array ## _func)(void) = _func ## _constructor;

#elif defined (_MSC_VER)

#define G_HAS_CONSTRUCTORS 1

/* Pre Visual studio 2008 must use #pragma section */
#define G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA 1
#define G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA 1

#define G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(_func) \
  section(".CRT$XCU",read)
#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _wrapper(void) { _func(); return 0; } \
  __declspec(allocate(".CRT$XCU")) static int (*p)(void) = _func ## _wrapper;

#define G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(_func) \
  section(".CRT$XCU",read)
#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void); \
  static int _func ## _constructor(void) { atexit (_func); return 0; } \
  __declspec(allocate(".CRT$XCU")) static int (* _array ## _func)(void) = _func ## _constructor;

#elif defined(__SUNPRO_C)

/* This is not tested, but i believe it should work, based on:
 * http://opensource.apple.com/source/OpenSSL098/OpenSSL098-35/src/fips/fips_premain.c
 */

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA 1
#define G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA 1

#define G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(_func) \
  init(_func)
#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void);

#define G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(_func) \
  fini(_func)
#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void);

#else

/* constructors not supported for this compiler */

#endif

#endif /* __GTK_DOC_IGNORE__ */

#ifdef G_HAS_CONSTRUCTORS

#ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(resource_constructor)
#endif
G_DEFINE_CONSTRUCTOR(resource_constructor)
#ifdef G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(resource_destructor)
#endif
G_DEFINE_DESTRUCTOR(resource_destructor)

#else
#warning "Constructor not supported on this compiler, linking in resources will not work"
#endif

static void resource_constructor (void)
{
  g_static_resource_init (&static_resource);
}

static void resource_destructor (void)
{
  g_static_resource_fini (&static_resource);
}
