/* CheckDataObject.c generated by valac 0.16.0, the Vala compiler
 * generated from CheckDataObject.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * libgdadata Unit Tests
 * Copyright (C) Daniel Espinosa Ortiz 2011 <esodan@gmail.com>
 * 
 * libgda is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * libgda is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgda/data/libgdadata.h>
#include <stdlib.h>
#include <string.h>
#include <libgda/libgda.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <gee.h>


#define CHECK_TYPE_RECORD (check_record_get_type ())
#define CHECK_RECORD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHECK_TYPE_RECORD, CheckRecord))
#define CHECK_RECORD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHECK_TYPE_RECORD, CheckRecordClass))
#define CHECK_IS_RECORD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHECK_TYPE_RECORD))
#define CHECK_IS_RECORD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHECK_TYPE_RECORD))
#define CHECK_RECORD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHECK_TYPE_RECORD, CheckRecordClass))

typedef struct _CheckRecord CheckRecord;
typedef struct _CheckRecordClass CheckRecordClass;
typedef struct _CheckRecordPrivate CheckRecordPrivate;

#define CHECK_TYPE_TESTS (check_tests_get_type ())
#define CHECK_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHECK_TYPE_TESTS, CheckTests))
#define CHECK_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHECK_TYPE_TESTS, CheckTestsClass))
#define CHECK_IS_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHECK_TYPE_TESTS))
#define CHECK_IS_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHECK_TYPE_TESTS))
#define CHECK_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHECK_TYPE_TESTS, CheckTestsClass))

typedef struct _CheckTests CheckTests;
typedef struct _CheckTestsClass CheckTestsClass;
typedef struct _CheckTestsPrivate CheckTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _CheckRecord {
	GdaDataRecord parent_instance;
	CheckRecordPrivate * priv;
};

struct _CheckRecordClass {
	GdaDataRecordClass parent_class;
};

struct _CheckTests {
	GObject parent_instance;
	CheckTestsPrivate * priv;
};

struct _CheckTestsClass {
	GObjectClass parent_class;
};

struct _CheckTestsPrivate {
	GdaConnection* _connection;
};


static gpointer check_record_parent_class = NULL;
extern gchar* check_record_t;
gchar* check_record_t = NULL;
static gpointer check_tests_parent_class = NULL;

GType check_record_get_type (void) G_GNUC_CONST;
enum  {
	CHECK_RECORD_DUMMY_PROPERTY
};
CheckRecord* check_record_new (void);
CheckRecord* check_record_construct (GType object_type);
static void check_record_finalize (GObject* obj);
GType check_tests_get_type (void) G_GNUC_CONST;
#define CHECK_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CHECK_TYPE_TESTS, CheckTestsPrivate))
enum  {
	CHECK_TESTS_DUMMY_PROPERTY,
	CHECK_TESTS_CONNECTION
};
static CheckTests* check_tests_new (void);
static CheckTests* check_tests_construct (GType object_type);
void check_tests_set_connection (CheckTests* self, GdaConnection* value);
GdaConnection* check_tests_get_connection (CheckTests* self);
gint check_tests_t1 (CheckTests* self, GError** error);
static void _vala_GValue_free (GValue* self);
gint check_tests_t2 (CheckTests* self, GError** error);
static GValue* _g_value_dup (GValue* self);
gint check_tests_main (gchar** args, int args_length1);
static void check_tests_finalize (GObject* obj);
static void _vala_check_tests_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_check_tests_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


CheckRecord* check_record_construct (GType object_type) {
	CheckRecord * self = NULL;
	self = (CheckRecord*) gda_data_record_construct (object_type);
	return self;
}


CheckRecord* check_record_new (void) {
	return check_record_construct (CHECK_TYPE_RECORD);
}


static void check_record_class_init (CheckRecordClass * klass) {
	gchar* _tmp0_;
	check_record_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = check_record_finalize;
	_tmp0_ = g_strdup ("user");
	check_record_t = _tmp0_;
}


static void check_record_instance_init (CheckRecord * self) {
}


static void check_record_finalize (GObject* obj) {
	CheckRecord * self;
	self = CHECK_RECORD (obj);
	G_OBJECT_CLASS (check_record_parent_class)->finalize (obj);
}


GType check_record_get_type (void) {
	static volatile gsize check_record_type_id__volatile = 0;
	if (g_once_init_enter (&check_record_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheckRecordClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) check_record_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckRecord), 0, (GInstanceInitFunc) check_record_instance_init, NULL };
		GType check_record_type_id;
		check_record_type_id = g_type_register_static (GDA_DATA_TYPE_RECORD, "CheckRecord", &g_define_type_info, 0);
		g_once_init_leave (&check_record_type_id__volatile, check_record_type_id);
	}
	return check_record_type_id__volatile;
}


static CheckTests* check_tests_construct (GType object_type) {
	CheckTests * self = NULL;
	GError * _inner_error_ = NULL;
	self = (CheckTests*) g_object_new (object_type, NULL);
	{
		FILE* _tmp0_;
		GdaConnection* _tmp1_ = NULL;
		GdaConnection* _tmp2_;
		GdaConnection* _tmp3_;
		FILE* _tmp4_;
		GdaConnection* _tmp5_;
		GdaConnection* _tmp6_;
		GdaConnection* _tmp7_;
		FILE* _tmp8_;
		GdaConnection* _tmp9_;
		GdaConnection* _tmp10_;
		GdaConnection* _tmp11_;
		GdaConnection* _tmp12_;
		g_unlink ("dataobject.db");
		_tmp0_ = stdout;
		fprintf (_tmp0_, "Creating Database...\n");
		_tmp1_ = gda_connection_open_from_string ("SQLite", "DB_DIR=.;DB_NAME=dataobject", NULL, GDA_CONNECTION_OPTIONS_NONE, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp2_;
		check_tests_set_connection (self, _tmp3_);
		_g_object_unref0 (_tmp3_);
		_tmp4_ = stdout;
		fprintf (_tmp4_, "Creating table 'user'...\n");
		_tmp5_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp5_, "CREATE TABLE user (id integer PRIMARY KEY AUTOINCREMENT, name string, " \
"city string)", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp6_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp6_, "INSERT INTO user (id, name, city) VALUES (1, \"Daniel\", \"Mexico\")", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp7_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp7_, "INSERT INTO user (id, name, city) VALUES (2, \"Jhon\", \"USA\")", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp8_ = stdout;
		fprintf (_tmp8_, "Creating table 'company'...\n");
		_tmp9_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp9_, "CREATE TABLE company (id int PRIMARY KEY, name string, responsability " \
"string)", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp10_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp10_, "INSERT INTO company (id, name, responsability) VALUES (1, \"Telcsa\", " \
"\"Programing\")", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp11_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp11_, "INSERT INTO company (id, name, responsability) VALUES (2, \"Viasa\", \"" \
"Accessories\")", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp12_ = self->priv->_connection;
		gda_connection_update_meta_store (_tmp12_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = stdout;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		fprintf (_tmp13_, "Couln't create temporary database...\nERROR: %s\n", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


static CheckTests* check_tests_new (void) {
	return check_tests_construct (CHECK_TYPE_TESTS);
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


gint check_tests_t1 (CheckTests* self, GError** error) {
	gint result = 0;
	FILE* _tmp0_;
	gint fails;
	FILE* _tmp1_;
	CheckRecord* _tmp2_;
	CheckRecord* r;
	FILE* _tmp3_;
	CheckRecord* _tmp4_;
	GdaConnection* _tmp5_;
	FILE* _tmp6_;
	GdaDataTable* _tmp7_;
	GdaDataTable* t;
	FILE* _tmp8_;
	GdaDataTable* _tmp9_;
	FILE* _tmp10_;
	GdaDataTable* _tmp11_;
	GdaConnection* _tmp12_;
	FILE* _tmp13_;
	CheckRecord* _tmp14_;
	GdaDataTable* _tmp15_;
	FILE* _tmp16_;
	GdaDataField* _tmp17_;
	GdaDataField* k;
	FILE* _tmp18_;
	FILE* _tmp86_;
	CheckRecord* _tmp87_;
	GdaDataDbTable* _tmp88_;
	GdaDataDbTable* _tmp89_;
	const gchar* _tmp90_;
	const gchar* _tmp91_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	gchar* _tmp95_;
	CheckRecord* _tmp96_;
	GdaDataDbTable* _tmp97_;
	GdaDataDbTable* _tmp98_;
	FILE* _tmp99_;
	CheckRecord* _tmp100_;
	gchar* _tmp101_ = NULL;
	gchar* _tmp102_;
	FILE* _tmp103_;
	CheckRecord* _tmp104_;
	GdaDataDbField* _tmp105_ = NULL;
	GdaDataDbField* _tmp106_;
	GdaDataDbField* _tmp107_;
	GValue* _tmp108_;
	GValue* _tmp109_;
	gint _tmp110_;
	gint i;
	gint _tmp111_;
	FILE* _tmp116_;
	CheckRecord* _tmp117_;
	GdaDataDbField* _tmp118_ = NULL;
	GdaDataDbField* _tmp119_;
	GdaDataDbField* _tmp120_;
	GValue* _tmp121_;
	GValue* _tmp122_;
	gchar* _tmp123_;
	gchar* _tmp124_;
	gchar* vdb;
	const gchar* _tmp125_;
	FILE* _tmp135_;
	FILE* _tmp158_;
	FILE* _tmp189_;
	FILE* _tmp206_;
	GdaDataTable* _tmp207_;
	GdaDataTable* t2;
	GdaDataTable* _tmp208_;
	GdaDataTable* _tmp209_;
	GdaConnection* _tmp210_;
	CheckRecord* _tmp211_;
	GdaDataTable* _tmp212_;
	FILE* _tmp213_;
	CheckRecord* _tmp214_;
	GdaDataDbTable* _tmp215_;
	GdaDataDbTable* _tmp216_;
	const gchar* _tmp217_;
	const gchar* _tmp218_;
	gchar* _tmp219_;
	gchar* _tmp220_;
	gchar* _tmp221_;
	gchar* _tmp222_;
	FILE* _tmp240_;
	gchar* _tmp261_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = stdout;
	fprintf (_tmp0_, ">>> NEW TEST: GdaData.DbRecord API tests\n");
	fails = 0;
	_tmp1_ = stdout;
	fprintf (_tmp1_, "Creating new record\n");
	_tmp2_ = check_record_new ();
	r = _tmp2_;
	_tmp3_ = stdout;
	fprintf (_tmp3_, "Setting connection\n");
	_tmp4_ = r;
	_tmp5_ = self->priv->_connection;
	gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp4_, _tmp5_);
	_tmp6_ = stdout;
	fprintf (_tmp6_, "Setting up DbTable\n");
	_tmp7_ = gda_data_table_new ();
	t = _tmp7_;
	_tmp8_ = stdout;
	fprintf (_tmp8_, "Setting DbTable name\n");
	_tmp9_ = t;
	gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp9_, "user");
	_tmp10_ = stdout;
	fprintf (_tmp10_, "Setting DbTable connection\n");
	_tmp11_ = t;
	_tmp12_ = self->priv->_connection;
	gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp11_, _tmp12_);
	_tmp13_ = stdout;
	fprintf (_tmp13_, ">>> Setting table to record\n");
	_tmp14_ = r;
	_tmp15_ = t;
	gda_data_db_record_set_table ((GdaDataDbRecord*) _tmp14_, (GdaDataDbTable*) _tmp15_);
	_tmp16_ = stdout;
	fprintf (_tmp16_, ">>> Setting up Key 'id'\n");
	_tmp17_ = gda_data_field_new ("id", GDA_DATA_DB_FIELD_ATTRIBUTE_NONE);
	k = _tmp17_;
	_tmp18_ = stdout;
	fprintf (_tmp18_, "Setting record ID to 1...");
	{
		GdaDataField* _tmp19_;
		GValue* _tmp20_ = NULL;
		CheckRecord* _tmp21_;
		GdaDataField* _tmp22_;
		CheckRecord* _tmp51_;
		FILE* _tmp80_;
		_tmp19_ = k;
		_tmp20_ = g_new0 (GValue, 1);
		g_value_init (_tmp20_, G_TYPE_INT);
		g_value_set_int (_tmp20_, 1);
		gda_data_db_field_set_value ((GdaDataDbField*) _tmp19_, _tmp20_);
		__vala_GValue_free0 (_tmp20_);
		_tmp21_ = r;
		_tmp22_ = k;
		gda_data_db_record_set_key ((GdaDataDbRecord*) _tmp21_, (GdaDataDbField*) _tmp22_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		{
			CheckRecord* _tmp23_;
			GeeCollection* _tmp24_;
			GeeCollection* _tmp25_;
			GeeCollection* _tmp26_;
			GeeIterator* _tmp27_ = NULL;
			GeeIterator* _tmp28_;
			GeeIterator* _kv_it;
			_tmp23_ = r;
			_tmp24_ = gda_data_db_record_get_keys ((GdaDataDbRecord*) _tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = _tmp25_;
			_tmp27_ = gee_iterable_iterator ((GeeIterable*) _tmp26_);
			_tmp28_ = _tmp27_;
			_g_object_unref0 (_tmp26_);
			_kv_it = _tmp28_;
			while (TRUE) {
				GeeIterator* _tmp29_;
				gboolean _tmp30_ = FALSE;
				GeeIterator* _tmp31_;
				gpointer _tmp32_ = NULL;
				GdaDataDbField* kv;
				FILE* _tmp33_;
				GdaDataDbField* _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				GdaDataDbField* _tmp41_;
				GValue* _tmp42_;
				GValue* _tmp43_;
				GValue _tmp44_;
				gchar* _tmp45_ = NULL;
				gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				_tmp29_ = _kv_it;
				_tmp30_ = gee_iterator_next (_tmp29_);
				if (!_tmp30_) {
					break;
				}
				_tmp31_ = _kv_it;
				_tmp32_ = gee_iterator_get (_tmp31_);
				kv = (GdaDataDbField*) _tmp32_;
				_tmp33_ = stdout;
				_tmp34_ = kv;
				_tmp35_ = gda_data_db_field_get_name (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = g_strconcat ("KEY: ", _tmp36_, NULL);
				_tmp38_ = _tmp37_;
				_tmp39_ = g_strconcat (_tmp38_, " VALUE: ", NULL);
				_tmp40_ = _tmp39_;
				_tmp41_ = kv;
				_tmp42_ = gda_data_db_field_get_value (_tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = *_tmp43_;
				_tmp45_ = gda_value_stringify (&_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = g_strconcat (_tmp40_, _tmp46_, NULL);
				_tmp48_ = _tmp47_;
				_tmp49_ = g_strconcat (_tmp48_, "\n", NULL);
				_tmp50_ = _tmp49_;
				fprintf (_tmp33_, "%s", _tmp50_);
				_g_free0 (_tmp50_);
				_g_free0 (_tmp48_);
				_g_free0 (_tmp46_);
				_g_free0 (_tmp40_);
				_g_free0 (_tmp38_);
				_g_object_unref0 (kv);
			}
			_g_object_unref0 (_kv_it);
		}
		_tmp51_ = r;
		gda_data_db_object_update ((GdaDataDbObject*) _tmp51_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		{
			CheckRecord* _tmp52_;
			GeeCollection* _tmp53_;
			GeeCollection* _tmp54_;
			GeeCollection* _tmp55_;
			GeeIterator* _tmp56_ = NULL;
			GeeIterator* _tmp57_;
			GeeIterator* _kv_it;
			_tmp52_ = r;
			_tmp53_ = gda_data_db_record_get_fields ((GdaDataDbRecord*) _tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = _tmp54_;
			_tmp56_ = gee_iterable_iterator ((GeeIterable*) _tmp55_);
			_tmp57_ = _tmp56_;
			_g_object_unref0 (_tmp55_);
			_kv_it = _tmp57_;
			while (TRUE) {
				GeeIterator* _tmp58_;
				gboolean _tmp59_ = FALSE;
				GeeIterator* _tmp60_;
				gpointer _tmp61_ = NULL;
				GdaDataDbField* kv;
				FILE* _tmp62_;
				GdaDataDbField* _tmp63_;
				const gchar* _tmp64_;
				const gchar* _tmp65_;
				gchar* _tmp66_;
				gchar* _tmp67_;
				gchar* _tmp68_;
				gchar* _tmp69_;
				GdaDataDbField* _tmp70_;
				GValue* _tmp71_;
				GValue* _tmp72_;
				GValue _tmp73_;
				gchar* _tmp74_ = NULL;
				gchar* _tmp75_;
				gchar* _tmp76_;
				gchar* _tmp77_;
				gchar* _tmp78_;
				gchar* _tmp79_;
				_tmp58_ = _kv_it;
				_tmp59_ = gee_iterator_next (_tmp58_);
				if (!_tmp59_) {
					break;
				}
				_tmp60_ = _kv_it;
				_tmp61_ = gee_iterator_get (_tmp60_);
				kv = (GdaDataDbField*) _tmp61_;
				_tmp62_ = stdout;
				_tmp63_ = kv;
				_tmp64_ = gda_data_db_field_get_name (_tmp63_);
				_tmp65_ = _tmp64_;
				_tmp66_ = g_strconcat ("FIELD: ", _tmp65_, NULL);
				_tmp67_ = _tmp66_;
				_tmp68_ = g_strconcat (_tmp67_, " VALUE: ", NULL);
				_tmp69_ = _tmp68_;
				_tmp70_ = kv;
				_tmp71_ = gda_data_db_field_get_value (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = *_tmp72_;
				_tmp74_ = gda_value_stringify (&_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = g_strconcat (_tmp69_, _tmp75_, NULL);
				_tmp77_ = _tmp76_;
				_tmp78_ = g_strconcat (_tmp77_, "\n", NULL);
				_tmp79_ = _tmp78_;
				fprintf (_tmp62_, "%s", _tmp79_);
				_g_free0 (_tmp79_);
				_g_free0 (_tmp77_);
				_g_free0 (_tmp75_);
				_g_free0 (_tmp69_);
				_g_free0 (_tmp67_);
				_g_object_unref0 (kv);
			}
			_g_object_unref0 (_kv_it);
		}
		_tmp80_ = stdout;
		fprintf (_tmp80_, "PASS\n");
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		gint _tmp81_;
		FILE* _tmp82_;
		gint _tmp83_;
		GError* _tmp84_;
		const gchar* _tmp85_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp81_ = fails;
		fails = _tmp81_ + 1;
		_tmp82_ = stdout;
		_tmp83_ = fails;
		_tmp84_ = e;
		_tmp85_ = _tmp84_->message;
		fprintf (_tmp82_, "FAIL: %i\nCouln't set ID...ERROR: %s\n", _tmp83_, _tmp85_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (k);
		_g_object_unref0 (t);
		_g_object_unref0 (r);
		return 0;
	}
	_tmp86_ = stdout;
	_tmp87_ = r;
	_tmp88_ = gda_data_db_record_get_table ((GdaDataDbRecord*) _tmp87_);
	_tmp89_ = _tmp88_;
	_tmp90_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp89_);
	_tmp91_ = _tmp90_;
	_tmp92_ = g_strconcat ("DbRecord points to, in table ", _tmp91_, NULL);
	_tmp93_ = _tmp92_;
	_tmp94_ = g_strconcat (_tmp93_, ":\n", NULL);
	_tmp95_ = _tmp94_;
	_tmp96_ = r;
	_tmp97_ = gda_data_db_record_get_table ((GdaDataDbRecord*) _tmp96_);
	_tmp98_ = _tmp97_;
	fprintf (_tmp86_, _tmp95_, _tmp98_);
	_g_free0 (_tmp95_);
	_g_free0 (_tmp93_);
	_tmp99_ = stdout;
	_tmp100_ = r;
	_tmp101_ = gda_data_db_record_to_string ((GdaDataDbRecord*) _tmp100_);
	_tmp102_ = _tmp101_;
	fprintf (_tmp99_, "%s\n", _tmp102_);
	_g_free0 (_tmp102_);
	_tmp103_ = stdout;
	fprintf (_tmp103_, "Getting ID value...");
	_tmp104_ = r;
	_tmp105_ = gda_data_db_record_get_key ((GdaDataDbRecord*) _tmp104_, "id", &_inner_error_);
	_tmp106_ = _tmp105_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (k);
		_g_object_unref0 (t);
		_g_object_unref0 (r);
		return 0;
	}
	_tmp107_ = _tmp106_;
	_tmp108_ = gda_data_db_field_get_value (_tmp107_);
	_tmp109_ = _tmp108_;
	_tmp110_ = g_value_get_int (_tmp109_);
	_g_object_unref0 (_tmp107_);
	i = _tmp110_;
	_tmp111_ = i;
	if (_tmp111_ != 1) {
		gint _tmp112_;
		FILE* _tmp113_;
		gint _tmp114_;
		_tmp112_ = fails;
		fails = _tmp112_ + 1;
		_tmp113_ = stdout;
		_tmp114_ = fails;
		fprintf (_tmp113_, "FAIL: %i\n", _tmp114_);
	} else {
		FILE* _tmp115_;
		_tmp115_ = stdout;
		fprintf (_tmp115_, "PASS\n");
	}
	_tmp116_ = stdout;
	fprintf (_tmp116_, "Getting value at 'name'...");
	_tmp117_ = r;
	_tmp118_ = gda_data_db_record_get_field ((GdaDataDbRecord*) _tmp117_, "name", &_inner_error_);
	_tmp119_ = _tmp118_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (k);
		_g_object_unref0 (t);
		_g_object_unref0 (r);
		return 0;
	}
	_tmp120_ = _tmp119_;
	_tmp121_ = gda_data_db_field_get_value (_tmp120_);
	_tmp122_ = _tmp121_;
	_tmp123_ = g_strdup (g_value_get_string (_tmp122_));
	_tmp124_ = _tmp123_;
	_g_object_unref0 (_tmp120_);
	vdb = _tmp124_;
	_tmp125_ = vdb;
	if (_tmp125_ == NULL) {
		gint _tmp126_;
		FILE* _tmp127_;
		gint _tmp128_;
		_tmp126_ = fails;
		fails = _tmp126_ + 1;
		_tmp127_ = stdout;
		_tmp128_ = fails;
		fprintf (_tmp127_, "FAIL: %i\n", _tmp128_);
	} else {
		const gchar* _tmp129_;
		_tmp129_ = vdb;
		if (g_strcmp0 (_tmp129_, "Daniel") != 0) {
			gint _tmp130_;
			FILE* _tmp131_;
			gint _tmp132_;
			const gchar* _tmp133_;
			_tmp130_ = fails;
			fails = _tmp130_ + 1;
			_tmp131_ = stdout;
			_tmp132_ = fails;
			_tmp133_ = vdb;
			fprintf (_tmp131_, "FAIL: %i\n" \
"ERROR: Value not match. Expected 'Daniel' but value is %s:\n", _tmp132_, _tmp133_);
		} else {
			FILE* _tmp134_;
			_tmp134_ = stdout;
			fprintf (_tmp134_, "PASS\n");
		}
	}
	_tmp135_ = stdout;
	fprintf (_tmp135_, "Setting value at 'name'...");
	{
		CheckRecord* _tmp136_;
		GdaDataDbField* _tmp137_ = NULL;
		GdaDataDbField* f;
		GdaDataDbField* _tmp138_;
		GValue* _tmp139_ = NULL;
		CheckRecord* _tmp140_;
		GdaDataDbField* _tmp141_;
		FILE* _tmp142_;
		CheckRecord* _tmp143_;
		GdaDataDbTable* _tmp144_;
		GdaDataDbTable* _tmp145_;
		const gchar* _tmp146_;
		const gchar* _tmp147_;
		FILE* _tmp148_;
		CheckRecord* _tmp149_;
		gchar* _tmp150_ = NULL;
		gchar* _tmp151_;
		FILE* _tmp152_;
		_tmp136_ = r;
		_tmp137_ = gda_data_db_record_get_field ((GdaDataDbRecord*) _tmp136_, "name", &_inner_error_);
		f = _tmp137_;
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		_tmp138_ = f;
		_tmp139_ = g_new0 (GValue, 1);
		g_value_init (_tmp139_, G_TYPE_STRING);
		g_value_set_string (_tmp139_, "Daniel Espinosa");
		gda_data_db_field_set_value (_tmp138_, _tmp139_);
		__vala_GValue_free0 (_tmp139_);
		_tmp140_ = r;
		_tmp141_ = f;
		gda_data_db_record_set_field ((GdaDataDbRecord*) _tmp140_, _tmp141_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (f);
			goto __catch2_g_error;
		}
		_tmp142_ = stdout;
		_tmp143_ = r;
		_tmp144_ = gda_data_db_record_get_table ((GdaDataDbRecord*) _tmp143_);
		_tmp145_ = _tmp144_;
		_tmp146_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp145_);
		_tmp147_ = _tmp146_;
		fprintf (_tmp142_, "DataObject points to in memory modified value, in table '%s':\n", _tmp147_);
		_tmp148_ = stdout;
		_tmp149_ = r;
		_tmp150_ = gda_data_db_record_to_string ((GdaDataDbRecord*) _tmp149_);
		_tmp151_ = _tmp150_;
		fprintf (_tmp148_, "%s\n", _tmp151_);
		_g_free0 (_tmp151_);
		_tmp152_ = stdout;
		fprintf (_tmp152_, "PASS\n");
		_g_object_unref0 (f);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		gint _tmp153_;
		FILE* _tmp154_;
		gint _tmp155_;
		GError* _tmp156_;
		const gchar* _tmp157_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp153_ = fails;
		fails = _tmp153_ + 1;
		_tmp154_ = stdout;
		_tmp155_ = fails;
		_tmp156_ = e;
		_tmp157_ = _tmp156_->message;
		fprintf (_tmp154_, "FAIL: %i\nCouln't modify record...ERROR: %s\n", _tmp155_, _tmp157_);
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (vdb);
		_g_object_unref0 (k);
		_g_object_unref0 (t);
		_g_object_unref0 (r);
		return 0;
	}
	_tmp158_ = stdout;
	fprintf (_tmp158_, "Saving changes...");
	{
		CheckRecord* _tmp159_;
		FILE* _tmp160_;
		CheckRecord* _tmp161_;
		GdaDataDbTable* _tmp162_;
		GdaDataDbTable* _tmp163_;
		const gchar* _tmp164_;
		const gchar* _tmp165_;
		FILE* _tmp166_;
		CheckRecord* _tmp167_;
		gchar* _tmp168_ = NULL;
		gchar* _tmp169_;
		FILE* _tmp170_;
		_tmp159_ = r;
		gda_data_db_object_save ((GdaDataDbObject*) _tmp159_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		_tmp160_ = stdout;
		_tmp161_ = r;
		_tmp162_ = gda_data_db_record_get_table ((GdaDataDbRecord*) _tmp161_);
		_tmp163_ = _tmp162_;
		_tmp164_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp163_);
		_tmp165_ = _tmp164_;
		fprintf (_tmp160_, "DataObject points to modified value, in table '%s':\n", _tmp165_);
		_tmp166_ = stdout;
		_tmp167_ = r;
		_tmp168_ = gda_data_db_record_to_string ((GdaDataDbRecord*) _tmp167_);
		_tmp169_ = _tmp168_;
		fprintf (_tmp166_, "%s\n", _tmp169_);
		_g_free0 (_tmp169_);
		_tmp170_ = stdout;
		fprintf (_tmp170_, "PASS\n");
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		gint _tmp171_;
		FILE* _tmp172_;
		gint _tmp173_;
		GError* _tmp174_;
		const gchar* _tmp175_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp171_ = fails;
		fails = _tmp171_ + 1;
		_tmp172_ = stdout;
		_tmp173_ = fails;
		_tmp174_ = e;
		_tmp175_ = _tmp174_->message;
		fprintf (_tmp172_, "FAIL: %i\nCouln't SAVE...ERROR: %s\n", _tmp173_, _tmp175_);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (vdb);
		_g_object_unref0 (k);
		_g_object_unref0 (t);
		_g_object_unref0 (r);
		return 0;
	}
	{
		FILE* _tmp176_;
		GdaConnection* _tmp177_;
		FILE* _tmp178_;
		_tmp176_ = stdout;
		fprintf (_tmp176_, "Simulating external database update...");
		_tmp177_ = self->priv->_connection;
		gda_connection_execute_non_select_command (_tmp177_, "UPDATE user SET name = \"Jhon Strauss\", city =\"New Jersey\"", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		_tmp178_ = stdout;
		fprintf (_tmp178_, "PASS\n");
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		gint _tmp179_;
		FILE* _tmp180_;
		gint _tmp181_;
		CheckRecord* _tmp182_;
		GdaDataDbTable* _tmp183_;
		GdaDataDbTable* _tmp184_;
		const gchar* _tmp185_;
		const gchar* _tmp186_;
		GError* _tmp187_;
		const gchar* _tmp188_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp179_ = fails;
		fails = _tmp179_ + 1;
		_tmp180_ = stdout;
		_tmp181_ = fails;
		_tmp182_ = r;
		_tmp183_ = gda_data_db_record_get_table ((GdaDataDbRecord*) _tmp182_);
		_tmp184_ = _tmp183_;
		_tmp185_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp184_);
		_tmp186_ = _tmp185_;
		_tmp187_ = e;
		_tmp188_ = _tmp187_->message;
		fprintf (_tmp180_, "FAIL: %i\nCouln't manual update table '%s'...ERROR: %s\n", _tmp181_, _tmp186_, _tmp188_);
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (vdb);
		_g_object_unref0 (k);
		_g_object_unref0 (t);
		_g_object_unref0 (r);
		return 0;
	}
	_tmp189_ = stdout;
	fprintf (_tmp189_, "Updating values from database...");
	{
		CheckRecord* _tmp190_;
		FILE* _tmp191_;
		CheckRecord* _tmp192_;
		GdaDataDbTable* _tmp193_;
		GdaDataDbTable* _tmp194_;
		const gchar* _tmp195_;
		const gchar* _tmp196_;
		FILE* _tmp197_;
		CheckRecord* _tmp198_;
		gchar* _tmp199_ = NULL;
		gchar* _tmp200_;
		_tmp190_ = r;
		gda_data_db_object_update ((GdaDataDbObject*) _tmp190_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		_tmp191_ = stdout;
		_tmp192_ = r;
		_tmp193_ = gda_data_db_record_get_table ((GdaDataDbRecord*) _tmp192_);
		_tmp194_ = _tmp193_;
		_tmp195_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp194_);
		_tmp196_ = _tmp195_;
		fprintf (_tmp191_, "DataObject points to actual stored values, in table '%s':\n", _tmp196_);
		_tmp197_ = stdout;
		_tmp198_ = r;
		_tmp199_ = gda_data_db_record_to_string ((GdaDataDbRecord*) _tmp198_);
		_tmp200_ = _tmp199_;
		fprintf (_tmp197_, "%s\n", _tmp200_);
		_g_free0 (_tmp200_);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		gint _tmp201_;
		FILE* _tmp202_;
		gint _tmp203_;
		GError* _tmp204_;
		const gchar* _tmp205_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp201_ = fails;
		fails = _tmp201_ + 1;
		_tmp202_ = stdout;
		_tmp203_ = fails;
		_tmp204_ = e;
		_tmp205_ = _tmp204_->message;
		fprintf (_tmp202_, "FAIL: %i\nCouln't UPDATE...ERROR: %s\n", _tmp203_, _tmp205_);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (vdb);
		_g_object_unref0 (k);
		_g_object_unref0 (t);
		_g_object_unref0 (r);
		return 0;
	}
	_tmp206_ = stdout;
	fprintf (_tmp206_, "Setting a new Table... \n");
	_tmp207_ = gda_data_table_new ();
	t2 = _tmp207_;
	_tmp208_ = t2;
	gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp208_, "company");
	_tmp209_ = t2;
	_tmp210_ = self->priv->_connection;
	gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp209_, _tmp210_);
	_tmp211_ = r;
	_tmp212_ = t2;
	gda_data_db_record_set_table ((GdaDataDbRecord*) _tmp211_, (GdaDataDbTable*) _tmp212_);
	_tmp213_ = stdout;
	_tmp214_ = r;
	_tmp215_ = gda_data_db_record_get_table ((GdaDataDbRecord*) _tmp214_);
	_tmp216_ = _tmp215_;
	_tmp217_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp216_);
	_tmp218_ = _tmp217_;
	_tmp219_ = g_strconcat ("Updating values from database using a new table '", _tmp218_, NULL);
	_tmp220_ = _tmp219_;
	_tmp221_ = g_strconcat (_tmp220_, "'...", NULL);
	_tmp222_ = _tmp221_;
	fprintf (_tmp213_, "%s", _tmp222_);
	_g_free0 (_tmp222_);
	_g_free0 (_tmp220_);
	{
		CheckRecord* _tmp223_;
		FILE* _tmp224_;
		CheckRecord* _tmp225_;
		GdaDataDbTable* _tmp226_;
		GdaDataDbTable* _tmp227_;
		const gchar* _tmp228_;
		const gchar* _tmp229_;
		FILE* _tmp230_;
		CheckRecord* _tmp231_;
		gchar* _tmp232_ = NULL;
		gchar* _tmp233_;
		FILE* _tmp234_;
		_tmp223_ = r;
		gda_data_db_object_update ((GdaDataDbObject*) _tmp223_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
		_tmp224_ = stdout;
		_tmp225_ = r;
		_tmp226_ = gda_data_db_record_get_table ((GdaDataDbRecord*) _tmp225_);
		_tmp227_ = _tmp226_;
		_tmp228_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp227_);
		_tmp229_ = _tmp228_;
		fprintf (_tmp224_, "DataObject points to actual stored values, in table '%s':\n", _tmp229_);
		_tmp230_ = stdout;
		_tmp231_ = r;
		_tmp232_ = gda_data_db_record_to_string ((GdaDataDbRecord*) _tmp231_);
		_tmp233_ = _tmp232_;
		fprintf (_tmp230_, "%s\n", _tmp233_);
		_g_free0 (_tmp233_);
		_tmp234_ = stdout;
		fprintf (_tmp234_, "PASS\n");
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		gint _tmp235_;
		FILE* _tmp236_;
		gint _tmp237_;
		GError* _tmp238_;
		const gchar* _tmp239_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp235_ = fails;
		fails = _tmp235_ + 1;
		_tmp236_ = stdout;
		_tmp237_ = fails;
		_tmp238_ = e;
		_tmp239_ = _tmp238_->message;
		fprintf (_tmp236_, "FAIL: %i\nCouln't UPDATE...ERROR: %s\n", _tmp237_, _tmp239_);
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (t2);
		_g_free0 (vdb);
		_g_object_unref0 (k);
		_g_object_unref0 (t);
		_g_object_unref0 (r);
		return 0;
	}
	_tmp240_ = stdout;
	fprintf (_tmp240_, "Setting ID to 2...");
	{
		GdaDataField* _tmp241_;
		GValue* _tmp242_ = NULL;
		CheckRecord* _tmp243_;
		GdaDataField* _tmp244_;
		FILE* _tmp245_;
		CheckRecord* _tmp246_;
		GdaDataDbTable* _tmp247_;
		GdaDataDbTable* _tmp248_;
		const gchar* _tmp249_;
		const gchar* _tmp250_;
		FILE* _tmp251_;
		CheckRecord* _tmp252_;
		gchar* _tmp253_ = NULL;
		gchar* _tmp254_;
		FILE* _tmp255_;
		_tmp241_ = k;
		_tmp242_ = g_new0 (GValue, 1);
		g_value_init (_tmp242_, G_TYPE_INT);
		g_value_set_int (_tmp242_, 2);
		gda_data_db_field_set_value ((GdaDataDbField*) _tmp241_, _tmp242_);
		__vala_GValue_free0 (_tmp242_);
		_tmp243_ = r;
		_tmp244_ = k;
		gda_data_db_record_set_key ((GdaDataDbRecord*) _tmp243_, (GdaDataDbField*) _tmp244_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		_tmp245_ = stdout;
		_tmp246_ = r;
		_tmp247_ = gda_data_db_record_get_table ((GdaDataDbRecord*) _tmp246_);
		_tmp248_ = _tmp247_;
		_tmp249_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp248_);
		_tmp250_ = _tmp249_;
		fprintf (_tmp245_, "DataObject points to actual stored values, in table '%s':\n", _tmp250_);
		_tmp251_ = stdout;
		_tmp252_ = r;
		_tmp253_ = gda_data_db_record_to_string ((GdaDataDbRecord*) _tmp252_);
		_tmp254_ = _tmp253_;
		fprintf (_tmp251_, "%s\n", _tmp254_);
		_g_free0 (_tmp254_);
		_tmp255_ = stdout;
		fprintf (_tmp255_, "PASS\n");
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		gint _tmp256_;
		FILE* _tmp257_;
		gint _tmp258_;
		GError* _tmp259_;
		const gchar* _tmp260_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp256_ = fails;
		fails = _tmp256_ + 1;
		_tmp257_ = stdout;
		_tmp258_ = fails;
		_tmp259_ = e;
		_tmp260_ = _tmp259_->message;
		fprintf (_tmp257_, "FAIL: %i\nCouln't set ID...ERROR: %s\n", _tmp258_, _tmp260_);
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (t2);
		_g_free0 (vdb);
		_g_object_unref0 (k);
		_g_object_unref0 (t);
		_g_object_unref0 (r);
		return 0;
	}
	_tmp261_ = g_strdup ("user");
	_g_free0 (check_record_t);
	check_record_t = _tmp261_;
	result = fails;
	_g_object_unref0 (t2);
	_g_free0 (vdb);
	_g_object_unref0 (k);
	_g_object_unref0 (t);
	_g_object_unref0 (r);
	return result;
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


gint check_tests_t2 (CheckTests* self, GError** error) {
	gint result = 0;
	FILE* _tmp0_;
	gint fails;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = stdout;
	fprintf (_tmp0_, ">>> NEW TEST: Gda.DbRecord - Adding/Deleting objects to DB...\n");
	fails = 0;
	{
		CheckRecord* _tmp1_;
		CheckRecord* n;
		CheckRecord* _tmp2_;
		GdaConnection* _tmp3_;
		GdaDataTable* _tmp4_;
		GdaDataTable* t;
		GdaDataTable* _tmp5_;
		GdaDataTable* _tmp6_;
		GdaConnection* _tmp7_;
		CheckRecord* _tmp8_;
		GdaDataTable* _tmp9_;
		GeeHashMap* _tmp10_;
		GeeHashMap* f;
		GeeHashMap* _tmp11_;
		GValue* _tmp12_ = NULL;
		GeeHashMap* _tmp13_;
		GValue* _tmp14_ = NULL;
		GeeHashMap* _tmp15_;
		GValue* _tmp16_ = NULL;
		FILE* _tmp33_;
		CheckRecord* _tmp34_;
		GdaDataDbTable* _tmp35_;
		GdaDataDbTable* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		FILE* _tmp39_;
		CheckRecord* _tmp40_;
		gchar* _tmp41_ = NULL;
		gchar* _tmp42_;
		CheckRecord* _tmp43_;
		CheckRecord* _tmp44_;
		GdaConnection* _tmp45_;
		GdaConnection* _tmp46_;
		GdaDataModel* _tmp47_ = NULL;
		GdaDataModel* m;
		FILE* _tmp48_;
		GdaDataModel* _tmp49_;
		gchar* _tmp50_ = NULL;
		gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		GdaDataModel* _tmp56_;
		gint _tmp57_ = 0;
		CheckRecord* _tmp61_;
		CheckRecord* r;
		CheckRecord* _tmp62_;
		GdaConnection* _tmp63_;
		CheckRecord* _tmp64_;
		GdaDataTable* _tmp65_;
		CheckRecord* _tmp66_;
		GValue* _tmp67_ = NULL;
		CheckRecord* _tmp68_;
		CheckRecord* _tmp69_;
		GdaConnection* _tmp70_;
		GdaConnection* _tmp71_;
		GdaDataModel* _tmp72_ = NULL;
		GdaDataModel* m2;
		FILE* _tmp73_;
		GdaDataModel* _tmp74_;
		gchar* _tmp75_ = NULL;
		gchar* _tmp76_;
		gchar* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		gchar* _tmp80_;
		GdaDataModel* _tmp81_;
		gint _tmp82_ = 0;
		_tmp1_ = check_record_new ();
		n = _tmp1_;
		_tmp2_ = n;
		_tmp3_ = self->priv->_connection;
		gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp2_, _tmp3_);
		_tmp4_ = gda_data_table_new ();
		t = _tmp4_;
		_tmp5_ = t;
		gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp5_, "user");
		_tmp6_ = t;
		_tmp7_ = self->priv->_connection;
		gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp6_, _tmp7_);
		_tmp8_ = n;
		_tmp9_ = t;
		gda_data_db_record_set_table ((GdaDataDbRecord*) _tmp8_, (GdaDataDbTable*) _tmp9_);
		_tmp10_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_VALUE, (GBoxedCopyFunc) _g_value_dup, _vala_GValue_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		f = _tmp10_;
		_tmp11_ = f;
		_tmp12_ = g_new0 (GValue, 1);
		g_value_init (_tmp12_, G_TYPE_INT);
		g_value_set_int (_tmp12_, 3);
		gee_abstract_map_set ((GeeAbstractMap*) _tmp11_, "id", _tmp12_);
		__vala_GValue_free0 (_tmp12_);
		_tmp13_ = f;
		_tmp14_ = g_new0 (GValue, 1);
		g_value_init (_tmp14_, G_TYPE_STRING);
		g_value_set_string (_tmp14_, "GdaDataNewName");
		gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, "name", _tmp14_);
		__vala_GValue_free0 (_tmp14_);
		_tmp15_ = f;
		_tmp16_ = g_new0 (GValue, 1);
		g_value_init (_tmp16_, G_TYPE_STRING);
		g_value_set_string (_tmp16_, "GdaDataNewCity");
		gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, "city", _tmp16_);
		__vala_GValue_free0 (_tmp16_);
		{
			GeeHashMap* _tmp17_;
			GeeSet* _tmp18_;
			GeeSet* _tmp19_;
			GeeSet* _tmp20_;
			GeeIterator* _tmp21_ = NULL;
			GeeIterator* _tmp22_;
			GeeIterator* _k_it;
			_tmp17_ = f;
			_tmp18_ = gee_abstract_map_get_keys ((GeeMap*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = _tmp19_;
			_tmp21_ = gee_iterable_iterator ((GeeIterable*) _tmp20_);
			_tmp22_ = _tmp21_;
			_g_object_unref0 (_tmp20_);
			_k_it = _tmp22_;
			while (TRUE) {
				GeeIterator* _tmp23_;
				gboolean _tmp24_ = FALSE;
				GeeIterator* _tmp25_;
				gpointer _tmp26_ = NULL;
				gchar* k;
				CheckRecord* _tmp27_;
				const gchar* _tmp28_;
				GeeHashMap* _tmp29_;
				const gchar* _tmp30_;
				gpointer _tmp31_ = NULL;
				GValue* _tmp32_;
				_tmp23_ = _k_it;
				_tmp24_ = gee_iterator_next (_tmp23_);
				if (!_tmp24_) {
					break;
				}
				_tmp25_ = _k_it;
				_tmp26_ = gee_iterator_get (_tmp25_);
				k = (gchar*) _tmp26_;
				_tmp27_ = n;
				_tmp28_ = k;
				_tmp29_ = f;
				_tmp30_ = k;
				_tmp31_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp29_, _tmp30_);
				_tmp32_ = (GValue*) _tmp31_;
				gda_data_db_record_set_field_value ((GdaDataDbRecord*) _tmp27_, _tmp28_, _tmp32_, &_inner_error_);
				__vala_GValue_free0 (_tmp32_);
				if (_inner_error_ != NULL) {
					_g_free0 (k);
					_g_object_unref0 (_k_it);
					_g_object_unref0 (f);
					_g_object_unref0 (t);
					_g_object_unref0 (n);
					goto __catch8_g_error;
				}
				_g_free0 (k);
			}
			_g_object_unref0 (_k_it);
		}
		_tmp33_ = stdout;
		_tmp34_ = n;
		_tmp35_ = gda_data_db_record_get_table ((GdaDataDbRecord*) _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = gda_data_db_named_object_get_name ((GdaDataDbNamedObject*) _tmp36_);
		_tmp38_ = _tmp37_;
		fprintf (_tmp33_, "DbRecord in memory values, to added to table '%s':\n", _tmp38_);
		_tmp39_ = stdout;
		_tmp40_ = n;
		_tmp41_ = gda_data_db_record_to_string ((GdaDataDbRecord*) _tmp40_);
		_tmp42_ = _tmp41_;
		fprintf (_tmp39_, "%s\n", _tmp42_);
		_g_free0 (_tmp42_);
		_tmp43_ = n;
		gda_data_db_object_append ((GdaDataDbObject*) _tmp43_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (f);
			_g_object_unref0 (t);
			_g_object_unref0 (n);
			goto __catch8_g_error;
		}
		_tmp44_ = n;
		_tmp45_ = gda_data_db_object_get_connection ((GdaDataDbObject*) _tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = gda_connection_execute_select_command (_tmp46_, "SELECT * FROM user", &_inner_error_);
		m = _tmp47_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (f);
			_g_object_unref0 (t);
			_g_object_unref0 (n);
			goto __catch8_g_error;
		}
		_tmp48_ = stdout;
		_tmp49_ = m;
		_tmp50_ = gda_data_model_dump_as_string (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = g_strconcat ("All records:\n", _tmp51_, NULL);
		_tmp53_ = _tmp52_;
		_tmp54_ = g_strconcat (_tmp53_, "\n", NULL);
		_tmp55_ = _tmp54_;
		fprintf (_tmp48_, "%s", _tmp55_);
		_g_free0 (_tmp55_);
		_g_free0 (_tmp53_);
		_g_free0 (_tmp51_);
		_tmp56_ = m;
		_tmp57_ = gda_data_model_get_n_rows (_tmp56_);
		if (_tmp57_ != 3) {
			gint _tmp58_;
			FILE* _tmp59_;
			_tmp58_ = fails;
			fails = _tmp58_ + 1;
			_tmp59_ = stdout;
			fprintf (_tmp59_, "FAIL\n");
		} else {
			FILE* _tmp60_;
			_tmp60_ = stdout;
			fprintf (_tmp60_, "PASS\n");
		}
		_tmp61_ = check_record_new ();
		r = _tmp61_;
		_tmp62_ = r;
		_tmp63_ = self->priv->_connection;
		gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp62_, _tmp63_);
		_tmp64_ = r;
		_tmp65_ = t;
		gda_data_db_record_set_table ((GdaDataDbRecord*) _tmp64_, (GdaDataDbTable*) _tmp65_);
		_tmp66_ = r;
		_tmp67_ = g_new0 (GValue, 1);
		g_value_init (_tmp67_, G_TYPE_INT);
		g_value_set_int (_tmp67_, 3);
		gda_data_db_record_set_key_value ((GdaDataDbRecord*) _tmp66_, "id", _tmp67_, &_inner_error_);
		__vala_GValue_free0 (_tmp67_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (r);
			_g_object_unref0 (m);
			_g_object_unref0 (f);
			_g_object_unref0 (t);
			_g_object_unref0 (n);
			goto __catch8_g_error;
		}
		_tmp68_ = r;
		gda_data_db_object_drop ((GdaDataDbObject*) _tmp68_, FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (r);
			_g_object_unref0 (m);
			_g_object_unref0 (f);
			_g_object_unref0 (t);
			_g_object_unref0 (n);
			goto __catch8_g_error;
		}
		_tmp69_ = n;
		_tmp70_ = gda_data_db_object_get_connection ((GdaDataDbObject*) _tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = gda_connection_execute_select_command (_tmp71_, "SELECT * FROM user", &_inner_error_);
		m2 = _tmp72_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (r);
			_g_object_unref0 (m);
			_g_object_unref0 (f);
			_g_object_unref0 (t);
			_g_object_unref0 (n);
			goto __catch8_g_error;
		}
		_tmp73_ = stdout;
		_tmp74_ = m2;
		_tmp75_ = gda_data_model_dump_as_string (_tmp74_);
		_tmp76_ = _tmp75_;
		_tmp77_ = g_strconcat ("All records:\n", _tmp76_, NULL);
		_tmp78_ = _tmp77_;
		_tmp79_ = g_strconcat (_tmp78_, "\n", NULL);
		_tmp80_ = _tmp79_;
		fprintf (_tmp73_, "%s", _tmp80_);
		_g_free0 (_tmp80_);
		_g_free0 (_tmp78_);
		_g_free0 (_tmp76_);
		_tmp81_ = m2;
		_tmp82_ = gda_data_model_get_n_rows (_tmp81_);
		if (_tmp82_ != 2) {
			gint _tmp83_;
			FILE* _tmp84_;
			_tmp83_ = fails;
			fails = _tmp83_ + 1;
			_tmp84_ = stdout;
			fprintf (_tmp84_, "FAIL\n");
		} else {
			FILE* _tmp85_;
			_tmp85_ = stdout;
			fprintf (_tmp85_, "PASS\n");
		}
		_g_object_unref0 (m2);
		_g_object_unref0 (r);
		_g_object_unref0 (m);
		_g_object_unref0 (f);
		_g_object_unref0 (t);
		_g_object_unref0 (n);
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		gint _tmp86_;
		FILE* _tmp87_;
		gint _tmp88_;
		GError* _tmp89_;
		const gchar* _tmp90_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp86_ = fails;
		fails = _tmp86_ + 1;
		_tmp87_ = stdout;
		_tmp88_ = fails;
		_tmp89_ = e;
		_tmp90_ = _tmp89_->message;
		fprintf (_tmp87_, "FAIL: %i\nCouln't set add new record...-ERROR: %s\n", _tmp88_, _tmp90_);
		_g_error_free0 (e);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	result = fails;
	return result;
}


gint check_tests_main (gchar** args, int args_length1) {
	gint result = 0;
	FILE* _tmp0_;
	gint failures;
	CheckTests* _tmp1_;
	CheckTests* app;
	gint _tmp15_ = 0;
	gint _tmp16_;
	gint _tmp17_;
	GError * _inner_error_ = NULL;
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Checking GdaData.DbRecord implementation...\n");
	failures = 0;
	_tmp1_ = check_tests_new ();
	app = _tmp1_;
	{
		CheckTests* _tmp2_;
		gint _tmp3_ = 0;
		gint _tmp4_;
		gint _tmp5_;
		CheckTests* _tmp6_;
		gint _tmp7_ = 0;
		gint _tmp8_;
		gint _tmp9_;
		_tmp2_ = app;
		_tmp3_ = check_tests_t1 (_tmp2_, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		_tmp5_ = failures;
		failures = _tmp5_ + _tmp4_;
		_tmp6_ = app;
		_tmp7_ = check_tests_t2 (_tmp6_, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		_tmp9_ = failures;
		failures = _tmp9_ + _tmp8_;
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		FILE* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = stdout;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		_tmp13_ = g_strconcat ("ERROR: ", _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		fprintf (_tmp10_, "%s", _tmp14_);
		_g_free0 (_tmp14_);
		_g_error_free0 (e);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (app);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp16_ = failures;
	if (_tmp16_ != 0) {
		_tmp15_ = 1;
	} else {
		_tmp15_ = 0;
	}
	_tmp17_ = _tmp15_;
	result = _tmp17_;
	_g_object_unref0 (app);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return check_tests_main (argv, argc);
}


GdaConnection* check_tests_get_connection (CheckTests* self) {
	GdaConnection* result;
	GdaConnection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_connection;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void check_tests_set_connection (CheckTests* self, GdaConnection* value) {
	GdaConnection* _tmp0_;
	GdaConnection* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_connection);
	self->priv->_connection = _tmp1_;
	g_object_notify ((GObject *) self, "connection");
}


static void check_tests_class_init (CheckTestsClass * klass) {
	check_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CheckTestsPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_check_tests_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_check_tests_set_property;
	G_OBJECT_CLASS (klass)->finalize = check_tests_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHECK_TESTS_CONNECTION, g_param_spec_object ("connection", "connection", "connection", gda_connection_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void check_tests_instance_init (CheckTests * self) {
	self->priv = CHECK_TESTS_GET_PRIVATE (self);
}


static void check_tests_finalize (GObject* obj) {
	CheckTests * self;
	self = CHECK_TESTS (obj);
	_g_object_unref0 (self->priv->_connection);
	G_OBJECT_CLASS (check_tests_parent_class)->finalize (obj);
}


GType check_tests_get_type (void) {
	static volatile gsize check_tests_type_id__volatile = 0;
	if (g_once_init_enter (&check_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheckTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) check_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckTests), 0, (GInstanceInitFunc) check_tests_instance_init, NULL };
		GType check_tests_type_id;
		check_tests_type_id = g_type_register_static (G_TYPE_OBJECT, "CheckTests", &g_define_type_info, 0);
		g_once_init_leave (&check_tests_type_id__volatile, check_tests_type_id);
	}
	return check_tests_type_id__volatile;
}


static void _vala_check_tests_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	CheckTests * self;
	self = CHECK_TESTS (object);
	switch (property_id) {
		case CHECK_TESTS_CONNECTION:
		g_value_set_object (value, check_tests_get_connection (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_check_tests_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	CheckTests * self;
	self = CHECK_TESTS (object);
	switch (property_id) {
		case CHECK_TESTS_CONNECTION:
		check_tests_set_connection (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



