/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 36 "./parser.y"

#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <libgda/sql-parser/gda-sql-parser-private.h>
#include <libgda/sql-parser/gda-statement-struct-util.h>
#include <libgda/sql-parser/gda-statement-struct-trans.h>
#include <libgda/sql-parser/gda-statement-struct-insert.h>
#include <libgda/sql-parser/gda-statement-struct-update.h>
#include <libgda/sql-parser/gda-statement-struct-delete.h>
#include <libgda/sql-parser/gda-statement-struct-select.h>
#include <libgda/sql-parser/gda-statement-struct-compound.h>
#include <libgda/sql-parser/gda-statement-struct-parts.h>
#include <assert.h>

typedef struct {
	GValue *fname;
	GdaSqlExpr *expr;
} UpdateSet;

typedef struct {
	gboolean    distinct;
	GdaSqlExpr *expr;
} Distinct;

typedef struct {
	GdaSqlExpr *count;
	GdaSqlExpr *offset;
} Limit;

typedef struct {
	GSList *when_list;
	GSList *then_list;
} CaseBody;

static GdaSqlOperatorType
sql_operation_string_to_operator (const gchar *op)
{
	switch (g_ascii_toupper (*op)) {
	case 'A':
		return GDA_SQL_OPERATOR_TYPE_AND;
	case 'O':
		return GDA_SQL_OPERATOR_TYPE_OR;
	case 'N':
		return GDA_SQL_OPERATOR_TYPE_NOT;
	case '=':
		return GDA_SQL_OPERATOR_TYPE_EQ;
	case 'I':
		if (op[1] == 'S')
			return GDA_SQL_OPERATOR_TYPE_IS;
		else if (op[1] == 'N')
			return GDA_SQL_OPERATOR_TYPE_IN;
		break;
	case 'L':
		return GDA_SQL_OPERATOR_TYPE_LIKE;
	case 'B':
		return GDA_SQL_OPERATOR_TYPE_BETWEEN;
	case '>':
		if (op[1] == '=')
			return GDA_SQL_OPERATOR_TYPE_GEQ;
		else if (op[1] == 0)
			return GDA_SQL_OPERATOR_TYPE_GT;
		break;
	case '<':
		if (op[1] == '=')
			return GDA_SQL_OPERATOR_TYPE_LEQ;
		else if (op[1] == '>')
			return GDA_SQL_OPERATOR_TYPE_DIFF;
		else if (op[1] == 0)
			return GDA_SQL_OPERATOR_TYPE_LT;
		break;
	case '!':
		if (op[1] == '=')
			return GDA_SQL_OPERATOR_TYPE_DIFF;
		else if (op[1] == '~') {
			if (op[2] == 0)
				return GDA_SQL_OPERATOR_TYPE_NOT_REGEXP;
			else if (op[2] == '*')
				return GDA_SQL_OPERATOR_TYPE_NOT_REGEXP_CI;
		}
		break;
	case '~':
		if (op[1] == '*')
			return GDA_SQL_OPERATOR_TYPE_REGEXP_CI;
		else if (op[1] == 0)
			return GDA_SQL_OPERATOR_TYPE_REGEXP;
		break;
	case 'S':
		return GDA_SQL_OPERATOR_TYPE_SIMILAR;
	case '|':
		if (op[1] == '|')
			return GDA_SQL_OPERATOR_TYPE_CONCAT;
		else
			return GDA_SQL_OPERATOR_TYPE_BITOR;
	case '+':
		return GDA_SQL_OPERATOR_TYPE_PLUS;
	case '-':
		return GDA_SQL_OPERATOR_TYPE_MINUS;
	case '*':
		return GDA_SQL_OPERATOR_TYPE_STAR;
	case '/':
		return GDA_SQL_OPERATOR_TYPE_DIV;
	case '%':
		return GDA_SQL_OPERATOR_TYPE_REM;
	case '&':
		return GDA_SQL_OPERATOR_TYPE_BITAND;
	}
	g_error ("Unhandled operator named '%s'\n", op);
	return 0;
}

static GdaSqlOperatorType
string_to_op_type (GValue *value)
{
	GdaSqlOperatorType op;
	op = sql_operation_string_to_operator (g_value_get_string (value));
	g_value_reset (value);
	g_free (value);
	return op;
}

static GdaSqlExpr *
compose_multiple_expr (GdaSqlOperatorType op, GdaSqlExpr *left, GdaSqlExpr *right) {
	GdaSqlExpr *ret;
	if (left->cond && (left->cond->operator_type == op)) {
		ret = left;
		ret->cond->operands = g_slist_append (ret->cond->operands, right);
	}
	else {
		GdaSqlOperation *cond;
		ret = gda_sql_expr_new (NULL);
		cond = gda_sql_operation_new (GDA_SQL_ANY_PART (ret));
		ret->cond = cond;
		cond->operator_type = op;
		cond->operands = g_slist_prepend (NULL, right);
		GDA_SQL_ANY_PART (right)->parent = GDA_SQL_ANY_PART (cond);
		cond->operands = g_slist_prepend (cond->operands, left);
		GDA_SQL_ANY_PART (left)->parent = GDA_SQL_ANY_PART (cond);
	}
	return ret;
}

static GdaSqlExpr *
create_two_expr (GdaSqlOperatorType op, GdaSqlExpr *left, GdaSqlExpr *right) {
	GdaSqlExpr *ret;
	GdaSqlOperation *cond;
	ret = gda_sql_expr_new (NULL);
	cond = gda_sql_operation_new (GDA_SQL_ANY_PART (ret));
	ret->cond = cond;
	cond->operator_type = op;
	cond->operands = g_slist_prepend (NULL, right);
	GDA_SQL_ANY_PART (right)->parent = GDA_SQL_ANY_PART (cond);
	cond->operands = g_slist_prepend (cond->operands, left);
	GDA_SQL_ANY_PART (left)->parent = GDA_SQL_ANY_PART (cond);
	return ret;
}

static GdaSqlExpr *
create_uni_expr (GdaSqlOperatorType op, GdaSqlExpr *expr) {
	GdaSqlExpr *ret;
	GdaSqlOperation *cond;
	ret = gda_sql_expr_new (NULL);
	cond = gda_sql_operation_new (GDA_SQL_ANY_PART (ret));
	ret->cond = cond;
	cond->operator_type = op;
	cond->operands = g_slist_prepend (NULL, expr);
	GDA_SQL_ANY_PART (expr)->parent = GDA_SQL_ANY_PART (cond);
	return ret;
}

static GdaSqlStatement *
compose_multiple_compounds (GdaSqlStatementCompoundType ctype, GdaSqlStatement *left, GdaSqlStatement *right) {
	GdaSqlStatement *ret;
	GdaSqlStatementCompound *lc = (GdaSqlStatementCompound*) left->contents;
	if (lc->compound_type == ctype) {
		GdaSqlStatementCompound *rc = (GdaSqlStatementCompound*) right->contents;
		if (!rc->stmt_list->next || rc->compound_type == ctype) {
			GSList *list;
			for (list = rc->stmt_list; list; list = list->next)
				GDA_SQL_ANY_PART (((GdaSqlStatement*)list->data)->contents)->parent = GDA_SQL_ANY_PART (lc);

			ret = left;
			lc->stmt_list = g_slist_concat (lc->stmt_list, rc->stmt_list);
			rc->stmt_list = NULL;
			gda_sql_statement_free (right);
		}
	}
	else {
		ret = gda_sql_statement_new (GDA_SQL_STATEMENT_COMPOUND);
		gda_sql_statement_compound_set_type (ret, ctype);
		gda_sql_statement_compound_take_stmt (ret, left);
		gda_sql_statement_compound_take_stmt (ret, right);
	}
	return ret;
}

#line 207 "parser.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    gda_lemon_oracle_parserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is gda_lemon_oracle_parserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    gda_lemon_oracle_parserARG_SDECL     A static variable declaration for the %extra_argument
**    gda_lemon_oracle_parserARG_PDECL     A parameter declaration for the %extra_argument
**    gda_lemon_oracle_parserARG_STORE     Code to store %extra_argument into yypParser
**    gda_lemon_oracle_parserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 208
#define YYACTIONTYPE unsigned short int
#define gda_lemon_oracle_parserTOKENTYPE GValue *
typedef union {
  gda_lemon_oracle_parserTOKENTYPE yy0;
  Limit yy20;
  GdaSqlSelectFrom * yy59;
  GdaSqlExpr* yy122;
  Distinct * yy189;
  gboolean yy216;
  GdaSqlSelectTarget * yy224;
  GSList * yy247;
  CaseBody yy263;
  GdaTransactionIsolation yy307;
  GdaSqlStatement * yy308;
  GdaSqlSelectJoinType yy317;
  GdaSqlExpr * yy328;
  GValue * yy361;
  GdaSqlOperatorType yy381;
  GSList* yy393;
  GdaSqlParamSpec * yy405;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define gda_lemon_oracle_parserARG_SDECL GdaSqlParserIface *pdata;
#define gda_lemon_oracle_parserARG_PDECL ,GdaSqlParserIface *pdata
#define gda_lemon_oracle_parserARG_FETCH GdaSqlParserIface *pdata = yypParser->pdata
#define gda_lemon_oracle_parserARG_STORE yypParser->pdata = pdata
#define YYNSTATE 359
#define YYNRULE 195
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   286,   63,   15,   15,   16,   18,   18,   23,  267,  287,
 /*    10 */   160,   28,   24,   24,   24,   24,   27,   27,   27,   27,
 /*    20 */    27,   26,   20,   20,   65,  370,   15,   15,   16,   18,
 /*    30 */    18,   23,  291,  220,  221,  187,  188,  189,  219,  370,
 /*    40 */   370,   54,  162,  323,  142,  143,  144,  285,   65,  290,
 /*    50 */   245,  246,  131,  127,  256,  289,  257,  258,  259,  260,
 /*    60 */   267,   22,   21,  184,   13,  210,  270,  288,   25,   25,
 /*    70 */    28,   24,   24,   24,   24,   27,   27,   27,   27,   27,
 /*    80 */   267,   20,   20,   55,  124,   15,   15,   16,   18,   18,
 /*    90 */    23,   26,  202,   52,  139,   75,  252,   42,   27,   27,
 /*   100 */    27,   27,   27,   14,   20,   20,  306,   65,   15,   15,
 /*   110 */    16,   18,   18,   23,  336,  163,  155,  311,  241,  346,
 /*   120 */   329,  167,  267,  276,  134,  257,  258,  259,  260,  200,
 /*   130 */    65,   22,   21,  184,   13,  210,  270,  182,   25,   25,
 /*   140 */    28,   24,   24,   24,   24,   27,   27,   27,   27,   27,
 /*   150 */   207,   20,   20,  252,  248,   15,   15,   16,   18,   18,
 /*   160 */    23,   26,  252,  123,   24,   24,   24,   24,   27,   27,
 /*   170 */    27,   27,   27,  252,   20,   20,  395,   65,   15,   15,
 /*   180 */    16,   18,   18,   23,   43,  116,   56,  555,  133,  202,
 /*   190 */   118,  307,  316,  140,  122,  245,  246,  251,  329,  254,
 /*   200 */    65,   22,   21,  184,   13,  210,  270,  248,   25,   25,
 /*   210 */    28,   24,   24,   24,   24,   27,   27,   27,   27,   27,
 /*   220 */   308,   20,   20,  252,  313,   15,   15,   16,   18,   18,
 /*   230 */    23,  202,   27,  250,   20,   20,  226,   26,   15,   15,
 /*   240 */    16,   18,   18,   23,  369,  323,   53,   65,   16,   18,
 /*   250 */    18,   23,  253,  202,  251,  209,  321,  322,  369,  369,
 /*   260 */    65,   80,  323,  251,  264,  347,   23,  202,   65,  304,
 /*   270 */   273,  329,  274,  190,  251,  317,   53,   22,   21,  184,
 /*   280 */    13,  210,  270,   65,   25,   25,   28,   24,   24,   24,
 /*   290 */    24,   27,   27,   27,   27,   27,  125,   20,   20,  272,
 /*   300 */   275,   15,   15,   16,   18,   18,   23,   26,  206,  253,
 /*   310 */   205,  202,  261,  205,  265,  202,   62,  304,  253,   93,
 /*   320 */   310,  198,  333,   65,  251,  247,  318,   82,  202,  253,
 /*   330 */   244,  320,  295,  142,  143,  144,  319,  141,  312,  204,
 /*   340 */   255,  213,  204,  255,  252,  150,   30,   22,   21,  184,
 /*   350 */    13,  210,  270,  252,   25,   25,   28,   24,   24,   24,
 /*   360 */    24,   27,   27,   27,   27,   27,  191,   20,   20,  222,
 /*   370 */   199,   15,   15,   16,   18,   18,   23,  175,  252,  253,
 /*   380 */   176,  325,  192,   26,  206,  230,  205,  202,  183,  205,
 /*   390 */   174,  185,   92,   65,  248,   92,  362,  248,  142,  143,
 /*   400 */   144,  228,  130,  172,  362,  362,  362,  331,  348,  297,
 /*   410 */   159,  132,  227,  329,  214,  204,  255,  352,  204,  255,
 /*   420 */   248,  252,   66,   22,   21,  184,   13,  210,  270,  248,
 /*   430 */    25,   25,   28,   24,   24,   24,   24,   27,   27,   27,
 /*   440 */    27,   27,  203,   20,   20,  251,  223,   15,   15,   16,
 /*   450 */    18,   18,   23,  177,  251,  142,  143,  144,  178,  202,
 /*   460 */   202,  302,  205,   26,  186,  202,  330,  205,   92,   65,
 /*   470 */   248,  349,  329,   84,  350,  248,  262,  180,  351,  251,
 /*   480 */   268,  234,  231,  135,  142,  143,  144,  334,  142,  143,
 /*   490 */   144,  204,  255,  329,   77,  337,  204,  255,  126,    6,
 /*   500 */   253,  329,   37,   22,   21,  184,   13,  210,  270,  253,
 /*   510 */    25,   25,   28,   24,   24,   24,   24,   27,   27,   27,
 /*   520 */    27,   27,  251,   20,   20,  134,  299,   15,   15,   16,
 /*   530 */    18,   18,   23,  145,  253,  173,   81,   70,  202,  193,
 /*   540 */   205,  211,  202,   26,  205,  279,   61,  327,  328,   65,
 /*   550 */    84,  283,  248,  142,  143,  144,  157,  216,  172,  142,
 /*   560 */   143,  144,  305,  224,  142,  143,  144,  340,  341,  204,
 /*   570 */   255,  342,  343,  204,  255,  248,  202,  253,  164,  344,
 /*   580 */   345,  194,   40,   22,   21,  184,   13,  210,  270,  252,
 /*   590 */    25,   25,   28,   24,   24,   24,   24,   27,   27,   27,
 /*   600 */    27,   27,  158,   20,   20,  358,   77,   15,   15,   16,
 /*   610 */    18,   18,   23,   26,  202,  201,  205,  202,  202,  205,
 /*   620 */   166,  195,  101,  249,  281,   92,  202,  179,  242,   65,
 /*   630 */   236,  202,  248,  243,   36,  218,   38,  134,  395,  314,
 /*   640 */   248,  269,   17,   76,  248,  204,  255,   78,  204,  255,
 /*   650 */    79,   14,  151,   22,   29,  184,   13,  210,  270,   17,
 /*   660 */    25,   25,   28,   24,   24,   24,   24,   27,   27,   27,
 /*   670 */    27,   27,   65,   20,   20,  280,  303,   15,   15,   16,
 /*   680 */    18,   18,   23,   26,  202,  165,  205,  202,  196,  205,
 /*   690 */   251,  197,   92,   17,   67,   92,  353,   39,  136,   65,
 /*   700 */   217,   45,  354,   17,  152,   68,  153,  323,  154,  215,
 /*   710 */    41,  355,  284,  156,   17,  204,  255,   47,  204,  255,
 /*   720 */    17,  301,   53,   22,   31,  184,   13,  210,  270,   67,
 /*   730 */    25,   25,   28,   24,   24,   24,   24,   27,   27,   27,
 /*   740 */    27,   27,  225,   20,   20,  253,  309,   15,   15,   16,
 /*   750 */    18,   18,   23,   26,  202,  229,  205,  324,  202,  332,
 /*   760 */   205,  335,  112,   69,  180,  339,   88,   64,  240,   65,
 /*   770 */    58,   72,  235,  239,  357,  170,   74,  237,  171,  359,
 /*   780 */   360,  128,  144,  129,  168,  204,  255,    1,  120,  204,
 /*   790 */   255,  121,   19,    2,   21,  184,   13,  210,  270,  266,
 /*   800 */    25,   25,   28,   24,   24,   24,   24,   27,   27,   27,
 /*   810 */    27,   27,  271,   20,   20,  252,  169,   15,   15,   16,
 /*   820 */    18,   18,   23,   26,  208,  202,    3,  205,  202,  282,
 /*   830 */   205,    8,  202,  119,  205,   44,  138,    9,   46,   65,
 /*   840 */    89,  292,  293,  294,  296,  298,  300,   57,   48,  315,
 /*   850 */   181,  326,  232,  338,  233,  161,  204,  255,   10,  204,
 /*   860 */   255,   71,   11,  204,  255,  184,   13,  210,  270,  238,
 /*   870 */    25,   25,   28,   24,   24,   24,   24,   27,   27,   27,
 /*   880 */    27,   27,   34,   20,   20,  252,   12,   15,   15,   16,
 /*   890 */    18,   18,   23,  318,  208,  356,   73,   59,  320,   49,
 /*   900 */    50,  556,  556,  319,   33,   32,  263,  556,  556,   65,
 /*   910 */   556,  556,  556,   35,    5,  202,  251,  205,  252,  556,
 /*   920 */   556,  556,  556,  137,  556,  556,  556,  208,  556,  556,
 /*   930 */   229,  556,  273,  191,  274,  556,  202,  556,  205,  556,
 /*   940 */   556,  556,  556,  556,   85,  134,  204,  255,  556,  556,
 /*   950 */   556,  556,   34,  556,  556,  556,  556,    7,  556,  556,
 /*   960 */   556,  272,  275,  212,  556,  556,  277,  204,  255,  556,
 /*   970 */   556,  253,  556,  556,   33,   32,  556,  556,  556,  556,
 /*   980 */   556,  556,  556,   35,    5,   34,  251,  252,  556,  556,
 /*   990 */   202,  556,  205,  202,  556,  205,  208,   51,  117,  556,
 /*  1000 */   556,  107,  273,  556,  274,  556,  556,   33,   32,  263,
 /*  1010 */   556,  252,  556,  556,  556,  134,   35,    4,  556,  251,
 /*  1020 */   208,  204,  255,  556,  204,  255,  556,    7,  556,  556,
 /*  1030 */   556,  272,  275,  212,  556,  273,  277,  274,  556,  556,
 /*  1040 */   202,  253,  205,  556,  556,  556,  556,  556,  106,  556,
 /*  1050 */   556,  202,  556,  205,   34,  556,  556,  556,  278,  146,
 /*  1060 */     7,  556,  556,  556,  272,  275,  212,  252,  556,  277,
 /*  1070 */   556,  204,  255,  556,  253,  556,   33,   32,   34,  318,
 /*  1080 */   556,  556,  204,  255,  320,   35,    4,  556,  251,  319,
 /*  1090 */   556,  556,  556,  556,  556,  556,  556,  556,  556,  556,
 /*  1100 */    33,   32,  556,  556,  273,  556,  274,  556,  556,   35,
 /*  1110 */     4,  556,  251,  556,  556,  202,  229,  205,  556,  191,
 /*  1120 */   556,  556,  556,  114,  556,  556,  556,  556,  273,    7,
 /*  1130 */   274,  556,  556,  272,  275,  212,  556,  556,  277,  556,
 /*  1140 */   556,  556,  556,  253,  556,  556,  204,  255,  556,  556,
 /*  1150 */   556,  556,  556,    7,  556,  556,  556,  272,  275,  212,
 /*  1160 */   556,  556,  277,  202,  556,  205,  556,  253,  251,  556,
 /*  1170 */   556,  110,  202,  556,  205,  556,  556,  202,  556,  205,
 /*  1180 */   111,  202,  556,  205,  556,  115,  556,  556,  556,   90,
 /*  1190 */   202,  556,  205,  556,  204,  255,  556,  202,  113,  205,
 /*  1200 */   556,  556,  556,  204,  255,   91,  556,  556,  204,  255,
 /*  1210 */   556,  556,  204,  255,  556,  556,  556,  556,  202,  556,
 /*  1220 */   205,  204,  255,  253,  556,  556,  108,  556,  204,  255,
 /*  1230 */   202,  556,  205,  556,  202,  556,  205,  202,  147,  205,
 /*  1240 */   556,  556,  148,  556,  202,  109,  205,  556,  556,  204,
 /*  1250 */   255,  556,  149,  556,  556,  202,  556,  205,  556,  556,
 /*  1260 */   556,  204,  255,   86,  556,  204,  255,  556,  204,  255,
 /*  1270 */   202,  556,  205,  556,  556,  204,  255,  556,   94,  556,
 /*  1280 */   202,  556,  205,  556,  556,  556,  204,  255,   95,  202,
 /*  1290 */   556,  205,  556,  556,  556,  556,  556,   87,  202,  556,
 /*  1300 */   205,  204,  255,  556,  556,  202,   96,  205,  202,  556,
 /*  1310 */   205,  204,  255,   83,  556,  556,   97,  202,  556,  205,
 /*  1320 */   204,  255,  556,  556,  556,   98,  556,  556,  556,  204,
 /*  1330 */   255,  556,  556,  202,  556,  205,  204,  255,  556,  204,
 /*  1340 */   255,   60,  202,  556,  205,  556,  556,  556,  204,  255,
 /*  1350 */    99,  202,  556,  205,  556,  202,  556,  205,  556,  100,
 /*  1360 */   202,  556,  205,  102,  204,  255,  556,  202,  103,  205,
 /*  1370 */   556,  556,  556,  204,  255,  104,  556,  556,  556,  556,
 /*  1380 */   556,  556,  204,  255,  556,  556,  204,  255,  202,  556,
 /*  1390 */   205,  204,  255,  556,  556,  556,  105,  556,  204,  255,
 /*  1400 */   556,  556,  556,  556,  556,  556,  556,  556,  556,  556,
 /*  1410 */   556,  556,  556,  556,  556,  556,  556,  556,  556,  204,
 /*  1420 */   255,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */     5,    8,   90,   91,   92,   93,   94,   95,  202,   14,
 /*    10 */    17,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*    20 */    84,   26,   86,   87,  112,  101,   90,   91,   92,   93,
 /*    30 */    94,   95,  102,  103,  104,  105,  106,  107,  108,  115,
 /*    40 */   116,   48,   49,  119,  109,  110,  111,  189,  112,  119,
 /*    50 */   115,  116,   59,   60,  151,  196,  153,  154,  155,  156,
 /*    60 */   202,   66,   67,   68,   69,   70,   71,  189,   73,   74,
 /*    70 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*    80 */   202,   86,   87,  164,  165,   90,   91,   92,   93,   94,
 /*    90 */    95,   26,  169,  100,  171,  119,    1,   32,   80,   81,
 /*   100 */    82,   83,   84,  127,   86,   87,    1,  112,   90,   91,
 /*   110 */    92,   93,   94,   95,  163,  122,  193,  197,  125,  168,
 /*   120 */   169,  128,  202,  151,  131,  153,  154,  155,  156,  161,
 /*   130 */   112,   66,   67,   68,   69,   70,   71,  162,   73,   74,
 /*   140 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   150 */   169,   86,   87,    1,  179,   90,   91,   92,   93,   94,
 /*   160 */    95,   26,    1,  166,   76,   77,   78,   79,   80,   81,
 /*   170 */    82,   83,   84,    1,   86,   87,   50,  112,   90,   91,
 /*   180 */    92,   93,   94,   95,  119,  191,  192,  159,  160,  169,
 /*   190 */   162,  171,  163,  164,  165,  115,  116,  102,  169,  169,
 /*   200 */   112,   66,   67,   68,   69,   70,   71,  179,   73,   74,
 /*   210 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   220 */   200,   86,   87,    1,  130,   90,   91,   92,   93,   94,
 /*   230 */    95,  169,   84,  171,   86,   87,  142,   26,   90,   91,
 /*   240 */    92,   93,   94,   95,  101,  119,  141,  112,   92,   93,
 /*   250 */    94,   95,  157,  169,  102,  171,   57,   58,  115,  116,
 /*   260 */   112,  100,  119,  102,   92,  163,   95,  169,  112,  171,
 /*   270 */   118,  169,  120,  175,  102,  164,  141,   66,   67,   68,
 /*   280 */    69,   70,   71,  112,   73,   74,   75,   76,   77,   78,
 /*   290 */    79,   80,   81,   82,   83,   84,  166,   86,   87,  147,
 /*   300 */   148,   90,   91,   92,   93,   94,   95,   26,  169,  157,
 /*   310 */   171,  169,  101,  171,   92,  169,  177,  171,  157,  177,
 /*   320 */   119,  175,  164,  112,  102,  101,   13,  126,  169,  157,
 /*   330 */   171,   18,  102,  109,  110,  111,   23,  178,  199,  200,
 /*   340 */   201,   70,  200,  201,    1,  203,   75,   66,   67,   68,
 /*   350 */    69,   70,   71,    1,   73,   74,   75,   76,   77,   78,
 /*   360 */    79,   80,   81,   82,   83,   84,   53,   86,   87,  139,
 /*   370 */   161,   90,   91,   92,   93,   94,   95,  162,    1,  157,
 /*   380 */   162,   52,   53,   26,  169,   56,  171,  169,  173,  171,
 /*   390 */   101,  173,  177,  112,  179,  177,  101,  179,  109,  110,
 /*   400 */   111,  160,   59,  162,  109,  110,  111,  163,  169,  102,
 /*   410 */   166,   59,  162,  169,  199,  200,  201,  169,  200,  201,
 /*   420 */   179,    1,  141,   66,   67,   68,   69,   70,   71,  179,
 /*   430 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   440 */    83,   84,  169,   86,   87,  102,  139,   90,   91,   92,
 /*   450 */    93,   94,   95,  162,  102,  109,  110,  111,  162,  169,
 /*   460 */   169,  171,  171,   26,  173,  169,  163,  171,  177,  112,
 /*   470 */   179,  169,  169,  177,  169,  179,  101,   57,  169,  102,
 /*   480 */   101,   61,   62,  182,  109,  110,  111,  163,  109,  110,
 /*   490 */   111,  200,  201,  169,  100,  163,  200,  201,  121,  198,
 /*   500 */   157,  169,  145,   66,   67,   68,   69,   70,   71,  157,
 /*   510 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   520 */    83,   84,  102,   86,   87,  131,  102,   90,   91,   92,
 /*   530 */    93,   94,   95,  183,  157,  162,  181,  117,  169,   23,
 /*   540 */   171,  205,  169,   26,  171,  101,  177,   54,   55,  112,
 /*   550 */   177,  101,  179,  109,  110,  111,  101,  188,  162,  109,
 /*   560 */   110,  111,  197,  139,  109,  110,  111,   63,   64,  200,
 /*   570 */   201,   63,   64,  200,  201,  179,  169,  157,  171,   63,
 /*   580 */    64,   65,  145,   66,   67,   68,   69,   70,   71,    1,
 /*   590 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   600 */    83,   84,  166,   86,   87,  176,  100,   90,   91,   92,
 /*   610 */    93,   94,   95,   26,  169,  162,  171,  169,  169,  171,
 /*   620 */   171,  173,  177,  162,  101,  177,  169,  162,  171,  112,
 /*   630 */   124,  169,  179,  171,  144,  190,  146,  131,   50,  130,
 /*   640 */   179,  101,  119,  180,  179,  200,  201,  180,  200,  201,
 /*   650 */   180,  127,  176,   66,   67,   68,   69,   70,   71,  119,
 /*   660 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   670 */    83,   84,  112,   86,   87,  101,  101,   90,   91,   92,
 /*   680 */    93,   94,   95,   26,  169,  101,  171,  169,  173,  171,
 /*   690 */   102,  173,  177,  119,  119,  177,  101,  144,  204,  112,
 /*   700 */   136,  135,  101,  119,  184,  117,  185,  119,  186,  133,
 /*   710 */   132,  101,  187,  194,  119,  200,  201,  138,  200,  201,
 /*   720 */   119,  195,  141,   66,   67,   68,   69,   70,   71,  119,
 /*   730 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   740 */    83,   84,  137,   86,   87,  157,  197,   90,   91,   92,
 /*   750 */    93,   94,   95,   26,  169,   50,  171,  165,  169,  165,
 /*   760 */   171,  117,  177,  167,   57,  168,  177,  167,   66,  112,
 /*   770 */   100,  172,  170,  119,  176,  206,  170,  174,  206,    0,
 /*   780 */     0,  140,  111,  140,  150,  200,  201,  100,  140,  200,
 /*   790 */   201,  140,  100,  100,   67,   68,   69,   70,   71,  101,
 /*   800 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   810 */    83,   84,   17,   86,   87,    1,  150,   90,   91,   92,
 /*   820 */    93,   94,   95,   26,   10,  169,  100,  171,  169,  101,
 /*   830 */   171,  134,  169,  177,  171,  119,  177,  134,  119,  112,
 /*   840 */   177,  102,  102,  102,  102,  102,  102,  100,  138,  101,
 /*   850 */    51,   53,  118,  120,  119,  118,  200,  201,  100,  200,
 /*   860 */   201,  123,  100,  200,  201,   68,   69,   70,   71,  119,
 /*   870 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   880 */    83,   84,   68,   86,   87,    1,  100,   90,   91,   92,
 /*   890 */    93,   94,   95,   13,   10,    1,  126,  129,   18,   74,
 /*   900 */    74,  207,  207,   23,   90,   91,   92,  207,  207,  112,
 /*   910 */   207,  207,  207,   99,  100,  169,  102,  171,    1,  207,
 /*   920 */   207,  207,  207,  177,  207,  207,  207,   10,  207,  207,
 /*   930 */    50,  207,  118,   53,  120,  207,  169,  207,  171,  207,
 /*   940 */   207,  207,  207,  207,  177,  131,  200,  201,  207,  207,
 /*   950 */   207,  207,   68,  207,  207,  207,  207,  143,  207,  207,
 /*   960 */   207,  147,  148,  149,  207,  207,  152,  200,  201,  207,
 /*   970 */   207,  157,  207,  207,   90,   91,  207,  207,  207,  207,
 /*   980 */   207,  207,  207,   99,  100,   68,  102,    1,  207,  207,
 /*   990 */   169,  207,  171,  169,  207,  171,   10,  117,  177,  207,
 /*  1000 */   207,  177,  118,  207,  120,  207,  207,   90,   91,   92,
 /*  1010 */   207,    1,  207,  207,  207,  131,   99,  100,  207,  102,
 /*  1020 */    10,  200,  201,  207,  200,  201,  207,  143,  207,  207,
 /*  1030 */   207,  147,  148,  149,  207,  118,  152,  120,  207,  207,
 /*  1040 */   169,  157,  171,  207,  207,  207,  207,  207,  177,  207,
 /*  1050 */   207,  169,  207,  171,   68,  207,  207,  207,   72,  177,
 /*  1060 */   143,  207,  207,  207,  147,  148,  149,    1,  207,  152,
 /*  1070 */   207,  200,  201,  207,  157,  207,   90,   91,   68,   13,
 /*  1080 */   207,  207,  200,  201,   18,   99,  100,  207,  102,   23,
 /*  1090 */   207,  207,  207,  207,  207,  207,  207,  207,  207,  207,
 /*  1100 */    90,   91,  207,  207,  118,  207,  120,  207,  207,   99,
 /*  1110 */   100,  207,  102,  207,  207,  169,   50,  171,  207,   53,
 /*  1120 */   207,  207,  207,  177,  207,  207,  207,  207,  118,  143,
 /*  1130 */   120,  207,  207,  147,  148,  149,  207,  207,  152,  207,
 /*  1140 */   207,  207,  207,  157,  207,  207,  200,  201,  207,  207,
 /*  1150 */   207,  207,  207,  143,  207,  207,  207,  147,  148,  149,
 /*  1160 */   207,  207,  152,  169,  207,  171,  207,  157,  102,  207,
 /*  1170 */   207,  177,  169,  207,  171,  207,  207,  169,  207,  171,
 /*  1180 */   177,  169,  207,  171,  207,  177,  207,  207,  207,  177,
 /*  1190 */   169,  207,  171,  207,  200,  201,  207,  169,  177,  171,
 /*  1200 */   207,  207,  207,  200,  201,  177,  207,  207,  200,  201,
 /*  1210 */   207,  207,  200,  201,  207,  207,  207,  207,  169,  207,
 /*  1220 */   171,  200,  201,  157,  207,  207,  177,  207,  200,  201,
 /*  1230 */   169,  207,  171,  207,  169,  207,  171,  169,  177,  171,
 /*  1240 */   207,  207,  177,  207,  169,  177,  171,  207,  207,  200,
 /*  1250 */   201,  207,  177,  207,  207,  169,  207,  171,  207,  207,
 /*  1260 */   207,  200,  201,  177,  207,  200,  201,  207,  200,  201,
 /*  1270 */   169,  207,  171,  207,  207,  200,  201,  207,  177,  207,
 /*  1280 */   169,  207,  171,  207,  207,  207,  200,  201,  177,  169,
 /*  1290 */   207,  171,  207,  207,  207,  207,  207,  177,  169,  207,
 /*  1300 */   171,  200,  201,  207,  207,  169,  177,  171,  169,  207,
 /*  1310 */   171,  200,  201,  177,  207,  207,  177,  169,  207,  171,
 /*  1320 */   200,  201,  207,  207,  207,  177,  207,  207,  207,  200,
 /*  1330 */   201,  207,  207,  169,  207,  171,  200,  201,  207,  200,
 /*  1340 */   201,  177,  169,  207,  171,  207,  207,  207,  200,  201,
 /*  1350 */   177,  169,  207,  171,  207,  169,  207,  171,  207,  177,
 /*  1360 */   169,  207,  171,  177,  200,  201,  207,  169,  177,  171,
 /*  1370 */   207,  207,  207,  200,  201,  177,  207,  207,  207,  207,
 /*  1380 */   207,  207,  200,  201,  207,  207,  200,  201,  169,  207,
 /*  1390 */   171,  200,  201,  207,  207,  207,  177,  207,  200,  201,
 /*  1400 */   207,  207,  207,  207,  207,  207,  207,  207,  207,  207,
 /*  1410 */   207,  207,  207,  207,  207,  207,  207,  207,  207,  200,
 /*  1420 */   201,
};
#define YY_SHIFT_USE_DFLT (-98)
#define YY_SHIFT_MAX 244
static const short yy_shift_ofst[] = {
 /*     0 */    -7,  814,  884,  884,  884,  884,  917, 1010, 1010, 1010,
 /*    10 */  1010, 1010, 1010,  986, 1010, 1010, 1010, 1010, 1010, 1010,
 /*    20 */  1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010,
 /*    30 */  1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010,
 /*    40 */  1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010, 1010,
 /*    50 */  1010, 1066,   -7,  152,  420,  588,  161,   95,   95,   95,
 /*    60 */    -5,   -5,  135,  880,  377,   95,   95,   95,   95,   95,
 /*    70 */    95,   95,  506,   95,   95,   95,  394,  394,  394,  394,
 /*    80 */   394,  -98,  -98,   65,  211,  281,  357,  437,  517,  517,
 /*    90 */   587,  657,  517,  517,  517,  517,  517,  517,  517,  517,
 /*   100 */   517,  517,  517,  517,  517,  517,  727,  797,  797,  797,
 /*   110 */   -64,  -64,  -64,   88,   18,  148,  -70,  -88,  -65,  156,
 /*   120 */   172,  222,  -76,  313,  143,  313,  343,  352,   95,   95,
 /*   130 */    95,   95,   95,   80,   94,  201,  490,  171,  171,  105,
 /*   140 */   126,  -24,  509,  509,  509,  524,  560,  560,  560,  560,
 /*   150 */   553,  564,  566,  576,  578,  579,  605,  581,  705,  705,
 /*   160 */   644,  707,  644,  702,  670,  654,  524,  702,  -98,  -98,
 /*   170 */   -97,  -28,  224,  289,  295,  375,  379,  444,  450,  455,
 /*   180 */   516,  329,  346,  523,  271,  540,  574,  230,  307,  424,
 /*   190 */   575,  199,  493,  504,  508,  584,  595,  601,  610,  779,
 /*   200 */   780,  671,  641,  643,  634,  687,  648,  651,  692,  698,
 /*   210 */   693,  795,  666,  726,  728,  697,  716,  703,  719,  739,
 /*   220 */   740,  741,  742,  743,  744,  747,  710,  671,  748,  799,
 /*   230 */   798,  734,  735,  733,  737,  738,  758,  750,  762,  786,
 /*   240 */   894,  770,  768,  825,  826,
};
#define YY_REDUCE_USE_DFLT (-195)
#define YY_REDUCE_MAX 169
static const short yy_reduce_ofst[] = {
 /*     0 */    28,  215,  218,  291,  296,  373,  139,  142,  369,  445,
 /*    10 */   448,  515,  518,  585,  589,  656,  659,  663,  746,  767,
 /*    20 */   821,  824,  871,  882,  946,  994, 1003, 1008, 1012, 1021,
 /*    30 */  1028, 1049, 1061, 1065, 1068, 1075, 1086, 1101, 1111, 1120,
 /*    40 */  1129, 1136, 1139, 1148, 1164, 1173, 1182, 1186, 1191, 1198,
 /*    50 */  1219,   29,  241,   20,  -49,  244,  -77,   98,  146,  159,
 /*    60 */  -142, -122,  -80,  -81,  102,   62,   84,  290,  303,  324,
 /*    70 */   332,  407,  -25,  449,  457,  462,  250,  396,  453,  461,
 /*    80 */   465,  301,   -6, -194, -194, -194, -194, -194, -194, -194,
 /*    90 */  -194, -194, -194, -194, -194, -194, -194, -194, -194, -194,
 /*   100 */  -194, -194, -194, -194, -194, -194, -194, -194, -194, -194,
 /*   110 */  -194, -194, -194, -194, -194, -194, -141, -194,  -32, -194,
 /*   120 */   -19,   30,   -3,  111,  130,  158,  239,  248,  273,   30,
 /*   130 */   302,  305,  309,  209,  355,  350,  336, -194, -194,  365,
 /*   140 */   436,  429,  463,  467,  470,  476, -194, -194, -194, -194,
 /*   150 */   494,  520,  521,  522,  525,  519,  526,  549,  592,  594,
 /*   160 */   596,  597,  600,  602,  599,  603,  598,  606,  569,  572,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   554,  491,  491,  491,  554,  554,  554,  529,  554,  554,
 /*    10 */   491,  491,  491,  554,  554,  554,  554,  554,  554,  554,
 /*    20 */   554,  554,  554,  554,  554,  554,  554,  554,  554,  554,
 /*    30 */   554,  554,  554,  554,  554,  554,  554,  554,  554,  554,
 /*    40 */   554,  554,  554,  554,  554,  554,  554,  554,  554,  554,
 /*    50 */   554,  401,  554,  554,  401,  401,  554,  554,  554,  554,
 /*    60 */   447,  447,  484,  365,  401,  554,  554,  554,  401,  401,
 /*    70 */   401,  554,  554,  554,  554,  554,  554,  554,  554,  554,
 /*    80 */   554,  476,  457,  438,  554,  554,  554,  554,  426,  492,
 /*    90 */   554,  554,  493,  528,  530,  532,  531,  439,  440,  449,
 /*   100 */   489,  490,  459,  488,  428,  429,  510,  509,  517,  518,
 /*   110 */   513,  514,  521,  516,  512,  515,  453,  506,  554,  503,
 /*   120 */   554,  554,  395,  554,  395,  554,  554,  554,  554,  554,
 /*   130 */   554,  554,  554,  554,  485,  452,  533,  505,  504,  484,
 /*   140 */   371,  425,  434,  434,  434,  425,  511,  507,  508,  519,
 /*   150 */   554,  450,  448,  441,  437,  460,  456,  484,  554,  554,
 /*   160 */   393,  381,  393,  416,  420,  413,  425,  416,  543,  543,
 /*   170 */   554,  554,  554,  554,  522,  554,  554,  554,  554,  554,
 /*   180 */   554,  554,  415,  554,  554,  554,  554,  554,  554,  554,
 /*   190 */   554,  554,  554,  385,  386,  554,  554,  554,  554,  554,
 /*   200 */   554,  432,  551,  552,  495,  497,  551,  552,  554,  554,
 /*   210 */   554,  554,  554,  554,  554,  554,  442,  554,  451,  554,
 /*   220 */   554,  554,  554,  554,  554,  554,  487,  431,  554,  554,
 /*   230 */   554,  554,  379,  554,  554,  554,  554,  414,  554,  554,
 /*   240 */   554,  554,  554,  554,  554,  363,  364,  362,  430,  433,
 /*   250 */   502,  548,  549,  550,  553,  494,  541,  544,  545,  546,
 /*   260 */   547,  496,  499,  479,  480,  481,  501,  520,  524,  523,
 /*   270 */   534,  527,  536,  537,  538,  539,  540,  542,  535,  526,
 /*   280 */   525,  498,  500,  522,  436,  443,  445,  446,  444,  458,
 /*   290 */   461,  462,  463,  464,  465,  466,  467,  468,  469,  470,
 /*   300 */   471,  454,  422,  455,  423,  472,  473,  482,  483,  474,
 /*   310 */   475,  477,  478,  486,  435,  361,  366,  373,  403,  404,
 /*   320 */   405,  406,  407,  396,  372,  397,  398,  399,  400,  402,
 /*   330 */   367,  368,  374,  375,  376,  394,  377,  378,  380,  382,
 /*   340 */   389,  390,  391,  392,  387,  388,  383,  384,  411,  412,
 /*   350 */   408,  409,  410,  418,  419,  421,  417,  424,  427,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         ID => nothing */
    1,  /*      ABORT => ID */
    1,  /*      AFTER => ID */
    1,  /*    ANALYZE => ID */
    1,  /*        ASC => ID */
    1,  /*     ATTACH => ID */
    1,  /*     BEFORE => ID */
    1,  /*      BEGIN => ID */
    1,  /*    CASCADE => ID */
    1,  /*       CAST => ID */
    1,  /*   CONFLICT => ID */
    1,  /*   DATABASE => ID */
    1,  /*   DEFERRED => ID */
    1,  /*       DESC => ID */
    1,  /*     DETACH => ID */
    1,  /*       EACH => ID */
    1,  /*        END => ID */
    1,  /*  EXCLUSIVE => ID */
    1,  /*    EXPLAIN => ID */
    1,  /*       FAIL => ID */
    1,  /*        FOR => ID */
    1,  /*     IGNORE => ID */
    1,  /*  IMMEDIATE => ID */
    1,  /*  INITIALLY => ID */
    1,  /*    INSTEAD => ID */
    1,  /*       LIKE => ID */
    1,  /*      MATCH => ID */
    1,  /*       PLAN => ID */
    1,  /*      QUERY => ID */
    1,  /*        KEY => ID */
    1,  /*         OF => ID */
    1,  /*     OFFSET => ID */
    1,  /*     PRAGMA => ID */
    1,  /*      RAISE => ID */
    1,  /*    REPLACE => ID */
    1,  /*   RESTRICT => ID */
    1,  /*        ROW => ID */
    1,  /*       TEMP => ID */
    1,  /*    TRIGGER => ID */
    1,  /*     VACUUM => ID */
    1,  /*       VIEW => ID */
    1,  /*    VIRTUAL => ID */
    1,  /*    REINDEX => ID */
    1,  /*     RENAME => ID */
    1,  /*   CTIME_KW => ID */
    1,  /*         IF => ID */
    1,  /*  DELIMITER => ID */
    1,  /*     COMMIT => ID */
    1,  /*   ROLLBACK => ID */
    1,  /*  ISOLATION => ID */
    1,  /*      LEVEL => ID */
    1,  /* SERIALIZABLE => ID */
    1,  /*       READ => ID */
    1,  /*  COMMITTED => ID */
    1,  /* UNCOMMITTED => ID */
    1,  /* REPEATABLE => ID */
    1,  /*      WRITE => ID */
    1,  /*       ONLY => ID */
    1,  /*  SAVEPOINT => ID */
    1,  /*    RELEASE => ID */
    1,  /*    COMMENT => ID */
    1,  /*      FORCE => ID */
    1,  /*       WAIT => ID */
    1,  /*     NOWAIT => ID */
    1,  /*      BATCH => ID */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*        NOT => nothing */
    0,  /*         IS => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*       DIFF => nothing */
    0,  /*         EQ => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         GT => nothing */
    0,  /*        LEQ => nothing */
    0,  /*         LT => nothing */
    0,  /*        GEQ => nothing */
    0,  /*     REGEXP => nothing */
    0,  /*  REGEXP_CI => nothing */
    0,  /* NOT_REGEXP => nothing */
    0,  /* NOT_REGEXP_CI => nothing */
    0,  /*    SIMILAR => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*    NATURAL => nothing */
    0,  /*       LEFT => nothing */
    0,  /*      RIGHT => nothing */
    0,  /*       FULL => nothing */
    0,  /*      CROSS => nothing */
    0,  /*      UNION => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     PGCAST => nothing */
    0,  /*    ILLEGAL => nothing */
    0,  /* SQLCOMMENT => nothing */
    0,  /*       SEMI => nothing */
    0,  /* END_OF_FILE => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*     STRING => nothing */
    0,  /*      COMMA => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*         TO => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*     DELETE => nothing */
    0,  /*       FROM => nothing */
    0,  /*      WHERE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*        SET => nothing */
    0,  /*        ALL => nothing */
    0,  /*     SELECT => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      GROUP => nothing */
    0,  /*      USING => nothing */
    0,  /*         ON => nothing */
    0,  /*      OUTER => nothing */
    0,  /*        DOT => nothing */
    0,  /*         AS => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*       NULL => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*  UNSPECVAL => nothing */
    0,  /*  LSBRACKET => nothing */
    0,  /*  RSBRACKET => nothing */
    0,  /* SIMPLEPARAM => nothing */
    0,  /*      PNAME => nothing */
    0,  /*     PDESCR => nothing */
    0,  /*      PTYPE => nothing */
    0,  /*    PNULLOK => nothing */
    0,  /*    TEXTUAL => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  gda_lemon_oracle_parserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void gda_lemon_oracle_parserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "ID",            "ABORT",         "AFTER",       
  "ANALYZE",       "ASC",           "ATTACH",        "BEFORE",      
  "BEGIN",         "CASCADE",       "CAST",          "CONFLICT",    
  "DATABASE",      "DEFERRED",      "DESC",          "DETACH",      
  "EACH",          "END",           "EXCLUSIVE",     "EXPLAIN",     
  "FAIL",          "FOR",           "IGNORE",        "IMMEDIATE",   
  "INITIALLY",     "INSTEAD",       "LIKE",          "MATCH",       
  "PLAN",          "QUERY",         "KEY",           "OF",          
  "OFFSET",        "PRAGMA",        "RAISE",         "REPLACE",     
  "RESTRICT",      "ROW",           "TEMP",          "TRIGGER",     
  "VACUUM",        "VIEW",          "VIRTUAL",       "REINDEX",     
  "RENAME",        "CTIME_KW",      "IF",            "DELIMITER",   
  "COMMIT",        "ROLLBACK",      "ISOLATION",     "LEVEL",       
  "SERIALIZABLE",  "READ",          "COMMITTED",     "UNCOMMITTED", 
  "REPEATABLE",    "WRITE",         "ONLY",          "SAVEPOINT",   
  "RELEASE",       "COMMENT",       "FORCE",         "WAIT",        
  "NOWAIT",        "BATCH",         "OR",            "AND",         
  "NOT",           "IS",            "IN",            "ISNULL",      
  "NOTNULL",       "DIFF",          "EQ",            "BETWEEN",     
  "GT",            "LEQ",           "LT",            "GEQ",         
  "REGEXP",        "REGEXP_CI",     "NOT_REGEXP",    "NOT_REGEXP_CI",
  "SIMILAR",       "ESCAPE",        "BITAND",        "BITOR",       
  "LSHIFT",        "RSHIFT",        "PLUS",          "MINUS",       
  "STAR",          "SLASH",         "REM",           "CONCAT",      
  "COLLATE",       "UMINUS",        "UPLUS",         "BITNOT",      
  "LP",            "RP",            "JOIN",          "INNER",       
  "NATURAL",       "LEFT",          "RIGHT",         "FULL",        
  "CROSS",         "UNION",         "EXCEPT",        "INTERSECT",   
  "PGCAST",        "ILLEGAL",       "SQLCOMMENT",    "SEMI",        
  "END_OF_FILE",   "TRANSACTION",   "STRING",        "COMMA",       
  "INTEGER",       "TO",            "INSERT",        "INTO",        
  "VALUES",        "DELETE",        "FROM",          "WHERE",       
  "UPDATE",        "SET",           "ALL",           "SELECT",      
  "LIMIT",         "ORDER",         "BY",            "HAVING",      
  "GROUP",         "USING",         "ON",            "OUTER",       
  "DOT",           "AS",            "DISTINCT",      "CASE",        
  "WHEN",          "THEN",          "ELSE",          "NULL",        
  "FLOAT",         "UNSPECVAL",     "LSBRACKET",     "RSBRACKET",   
  "SIMPLEPARAM",   "PNAME",         "PDESCR",        "PTYPE",       
  "PNULLOK",       "TEXTUAL",       "error",         "stmt",        
  "cmd",           "eos",           "compound",      "nm_opt",      
  "transtype",     "transilev",     "opt_comma",     "trans_opt_kw",
  "ora_commit_write",  "nm",            "opt_on_conflict",  "fullname",    
  "inscollist_opt",  "exprlist",      "ins_extra_values",  "inscollist",  
  "where_opt",     "expr",          "setlist",       "selectcmd",   
  "opt_compound_all",  "distinct",      "selcollist",    "from",        
  "groupby_opt",   "having_opt",    "orderby_opt",   "limit_opt",   
  "sortlist",      "sortorder",     "nexprlist",     "seltablist",  
  "stl_prefix",    "seltarget",     "on_cond",       "using_opt",   
  "jointype",      "as",            "sclp",          "starname",    
  "value",         "pvalue",        "uni_op",        "case_operand",
  "case_exprlist",  "case_else",     "paramspec",   
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "stmt ::= cmd eos",
 /*   1 */ "stmt ::= compound eos",
 /*   2 */ "cmd ::= LP cmd RP",
 /*   3 */ "compound ::= LP compound RP",
 /*   4 */ "eos ::= SEMI",
 /*   5 */ "eos ::= END_OF_FILE",
 /*   6 */ "cmd ::= BEGIN",
 /*   7 */ "cmd ::= BEGIN TRANSACTION nm_opt",
 /*   8 */ "cmd ::= BEGIN transtype TRANSACTION nm_opt",
 /*   9 */ "cmd ::= BEGIN transtype nm_opt",
 /*  10 */ "cmd ::= BEGIN transilev",
 /*  11 */ "cmd ::= BEGIN TRANSACTION transilev",
 /*  12 */ "cmd ::= BEGIN TRANSACTION transtype",
 /*  13 */ "cmd ::= BEGIN TRANSACTION transtype opt_comma transilev",
 /*  14 */ "cmd ::= BEGIN TRANSACTION transilev opt_comma transtype",
 /*  15 */ "cmd ::= BEGIN transtype opt_comma transilev",
 /*  16 */ "cmd ::= BEGIN transilev opt_comma transtype",
 /*  17 */ "cmd ::= END trans_opt_kw nm_opt",
 /*  18 */ "cmd ::= COMMIT nm_opt",
 /*  19 */ "cmd ::= COMMIT TRANSACTION nm_opt",
 /*  20 */ "cmd ::= COMMIT FORCE STRING",
 /*  21 */ "cmd ::= COMMIT FORCE STRING COMMA INTEGER",
 /*  22 */ "cmd ::= COMMIT COMMENT STRING",
 /*  23 */ "cmd ::= COMMIT COMMENT STRING ora_commit_write",
 /*  24 */ "cmd ::= COMMIT ora_commit_write",
 /*  25 */ "cmd ::= ROLLBACK trans_opt_kw nm_opt",
 /*  26 */ "ora_commit_write ::= WRITE IMMEDIATE",
 /*  27 */ "ora_commit_write ::= WRITE BATCH",
 /*  28 */ "ora_commit_write ::= WRITE WAIT",
 /*  29 */ "ora_commit_write ::= WRITE NOWAIT",
 /*  30 */ "ora_commit_write ::= WRITE IMMEDIATE WAIT",
 /*  31 */ "ora_commit_write ::= WRITE IMMEDIATE NOWAIT",
 /*  32 */ "ora_commit_write ::= WRITE BATCH WAIT",
 /*  33 */ "ora_commit_write ::= WRITE BATCH NOWAIT",
 /*  34 */ "trans_opt_kw ::=",
 /*  35 */ "trans_opt_kw ::= TRANSACTION",
 /*  36 */ "opt_comma ::=",
 /*  37 */ "opt_comma ::= COMMA",
 /*  38 */ "transilev ::= ISOLATION LEVEL SERIALIZABLE",
 /*  39 */ "transilev ::= ISOLATION LEVEL REPEATABLE READ",
 /*  40 */ "transilev ::= ISOLATION LEVEL READ COMMITTED",
 /*  41 */ "transilev ::= ISOLATION LEVEL READ UNCOMMITTED",
 /*  42 */ "nm_opt ::=",
 /*  43 */ "nm_opt ::= nm",
 /*  44 */ "transtype ::= DEFERRED",
 /*  45 */ "transtype ::= IMMEDIATE",
 /*  46 */ "transtype ::= EXCLUSIVE",
 /*  47 */ "transtype ::= READ WRITE",
 /*  48 */ "transtype ::= READ ONLY",
 /*  49 */ "cmd ::= SAVEPOINT nm",
 /*  50 */ "cmd ::= RELEASE SAVEPOINT nm",
 /*  51 */ "cmd ::= RELEASE nm",
 /*  52 */ "cmd ::= ROLLBACK trans_opt_kw TO nm",
 /*  53 */ "cmd ::= ROLLBACK trans_opt_kw TO SAVEPOINT nm",
 /*  54 */ "cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP exprlist RP",
 /*  55 */ "cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP exprlist RP ins_extra_values",
 /*  56 */ "cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt compound",
 /*  57 */ "opt_on_conflict ::=",
 /*  58 */ "opt_on_conflict ::= OR ID",
 /*  59 */ "ins_extra_values ::= ins_extra_values COMMA LP exprlist RP",
 /*  60 */ "ins_extra_values ::= COMMA LP exprlist RP",
 /*  61 */ "inscollist_opt ::=",
 /*  62 */ "inscollist_opt ::= LP inscollist RP",
 /*  63 */ "inscollist ::= inscollist COMMA fullname",
 /*  64 */ "inscollist ::= fullname",
 /*  65 */ "cmd ::= DELETE FROM fullname where_opt",
 /*  66 */ "where_opt ::=",
 /*  67 */ "where_opt ::= WHERE expr",
 /*  68 */ "cmd ::= UPDATE opt_on_conflict fullname SET setlist where_opt",
 /*  69 */ "setlist ::= setlist COMMA fullname EQ expr",
 /*  70 */ "setlist ::= fullname EQ expr",
 /*  71 */ "compound ::= selectcmd",
 /*  72 */ "compound ::= compound UNION opt_compound_all compound",
 /*  73 */ "compound ::= compound EXCEPT opt_compound_all compound",
 /*  74 */ "compound ::= compound INTERSECT opt_compound_all compound",
 /*  75 */ "opt_compound_all ::=",
 /*  76 */ "opt_compound_all ::= ALL",
 /*  77 */ "selectcmd ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /*  78 */ "limit_opt ::=",
 /*  79 */ "limit_opt ::= LIMIT expr",
 /*  80 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /*  81 */ "limit_opt ::= LIMIT expr COMMA expr",
 /*  82 */ "orderby_opt ::=",
 /*  83 */ "orderby_opt ::= ORDER BY sortlist",
 /*  84 */ "sortlist ::= sortlist COMMA expr sortorder",
 /*  85 */ "sortlist ::= expr sortorder",
 /*  86 */ "sortorder ::= ASC",
 /*  87 */ "sortorder ::= DESC",
 /*  88 */ "sortorder ::=",
 /*  89 */ "having_opt ::=",
 /*  90 */ "having_opt ::= HAVING expr",
 /*  91 */ "groupby_opt ::=",
 /*  92 */ "groupby_opt ::= GROUP BY nexprlist",
 /*  93 */ "from ::=",
 /*  94 */ "from ::= FROM seltablist",
 /*  95 */ "seltablist ::= stl_prefix seltarget on_cond using_opt",
 /*  96 */ "using_opt ::= USING LP inscollist RP",
 /*  97 */ "using_opt ::=",
 /*  98 */ "stl_prefix ::=",
 /*  99 */ "stl_prefix ::= seltablist jointype",
 /* 100 */ "on_cond ::= ON expr",
 /* 101 */ "on_cond ::=",
 /* 102 */ "jointype ::= COMMA",
 /* 103 */ "jointype ::= JOIN",
 /* 104 */ "jointype ::= CROSS JOIN",
 /* 105 */ "jointype ::= INNER JOIN",
 /* 106 */ "jointype ::= NATURAL JOIN",
 /* 107 */ "jointype ::= LEFT JOIN",
 /* 108 */ "jointype ::= LEFT OUTER JOIN",
 /* 109 */ "jointype ::= RIGHT JOIN",
 /* 110 */ "jointype ::= RIGHT OUTER JOIN",
 /* 111 */ "jointype ::= FULL JOIN",
 /* 112 */ "jointype ::= FULL OUTER JOIN",
 /* 113 */ "seltarget ::= fullname as",
 /* 114 */ "seltarget ::= fullname ID",
 /* 115 */ "seltarget ::= LP compound RP as",
 /* 116 */ "sclp ::= selcollist COMMA",
 /* 117 */ "sclp ::=",
 /* 118 */ "selcollist ::= sclp expr as",
 /* 119 */ "selcollist ::= sclp starname",
 /* 120 */ "starname ::= STAR",
 /* 121 */ "starname ::= nm DOT STAR",
 /* 122 */ "starname ::= nm DOT nm DOT STAR",
 /* 123 */ "as ::= AS fullname",
 /* 124 */ "as ::= AS value",
 /* 125 */ "as ::=",
 /* 126 */ "distinct ::=",
 /* 127 */ "distinct ::= ALL",
 /* 128 */ "distinct ::= DISTINCT",
 /* 129 */ "distinct ::= DISTINCT ON expr",
 /* 130 */ "nexprlist ::= nexprlist COMMA expr",
 /* 131 */ "nexprlist ::= expr",
 /* 132 */ "exprlist ::=",
 /* 133 */ "exprlist ::= exprlist COMMA expr",
 /* 134 */ "exprlist ::= expr",
 /* 135 */ "expr ::= pvalue",
 /* 136 */ "expr ::= value",
 /* 137 */ "expr ::= LP expr RP",
 /* 138 */ "expr ::= fullname",
 /* 139 */ "expr ::= fullname LP exprlist RP",
 /* 140 */ "expr ::= fullname LP compound RP",
 /* 141 */ "expr ::= fullname LP starname RP",
 /* 142 */ "expr ::= CAST LP expr AS fullname RP",
 /* 143 */ "expr ::= expr PGCAST fullname",
 /* 144 */ "expr ::= expr PLUS|MINUS expr",
 /* 145 */ "expr ::= expr STAR expr",
 /* 146 */ "expr ::= expr SLASH|REM expr",
 /* 147 */ "expr ::= expr BITAND|BITOR expr",
 /* 148 */ "expr ::= MINUS expr",
 /* 149 */ "expr ::= PLUS expr",
 /* 150 */ "expr ::= expr AND expr",
 /* 151 */ "expr ::= expr OR expr",
 /* 152 */ "expr ::= expr CONCAT expr",
 /* 153 */ "expr ::= expr GT|LEQ|GEQ|LT expr",
 /* 154 */ "expr ::= expr DIFF|EQ expr",
 /* 155 */ "expr ::= expr LIKE expr",
 /* 156 */ "expr ::= expr REGEXP|REGEXP_CI|NOT_REGEXP|NOT_REGEXP_CI|SIMILAR expr",
 /* 157 */ "expr ::= expr BETWEEN expr AND expr",
 /* 158 */ "expr ::= expr NOT BETWEEN expr AND expr",
 /* 159 */ "expr ::= NOT expr",
 /* 160 */ "expr ::= BITNOT expr",
 /* 161 */ "expr ::= expr uni_op",
 /* 162 */ "expr ::= expr IS expr",
 /* 163 */ "expr ::= LP compound RP",
 /* 164 */ "expr ::= expr IN LP exprlist RP",
 /* 165 */ "expr ::= expr IN LP compound RP",
 /* 166 */ "expr ::= expr NOT IN LP exprlist RP",
 /* 167 */ "expr ::= expr NOT IN LP compound RP",
 /* 168 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 169 */ "case_operand ::= expr",
 /* 170 */ "case_operand ::=",
 /* 171 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 172 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 173 */ "case_else ::= ELSE expr",
 /* 174 */ "case_else ::=",
 /* 175 */ "uni_op ::= ISNULL",
 /* 176 */ "uni_op ::= IS NOTNULL",
 /* 177 */ "value ::= NULL",
 /* 178 */ "value ::= STRING",
 /* 179 */ "value ::= INTEGER",
 /* 180 */ "value ::= FLOAT",
 /* 181 */ "pvalue ::= UNSPECVAL LSBRACKET paramspec RSBRACKET",
 /* 182 */ "pvalue ::= value LSBRACKET paramspec RSBRACKET",
 /* 183 */ "pvalue ::= SIMPLEPARAM",
 /* 184 */ "paramspec ::=",
 /* 185 */ "paramspec ::= paramspec PNAME",
 /* 186 */ "paramspec ::= paramspec PDESCR",
 /* 187 */ "paramspec ::= paramspec PTYPE",
 /* 188 */ "paramspec ::= paramspec PNULLOK",
 /* 189 */ "nm ::= JOIN",
 /* 190 */ "nm ::= ID",
 /* 191 */ "nm ::= TEXTUAL",
 /* 192 */ "fullname ::= nm",
 /* 193 */ "fullname ::= nm DOT nm",
 /* 194 */ "fullname ::= nm DOT nm DOT nm",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to gda_lemon_oracle_parser and gda_lemon_oracle_parserFree.
*/
void *gda_lemon_oracle_parserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#if YYSTACKDEPTH<=0
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 1: /* ID */
    case 2: /* ABORT */
    case 3: /* AFTER */
    case 4: /* ANALYZE */
    case 5: /* ASC */
    case 6: /* ATTACH */
    case 7: /* BEFORE */
    case 8: /* BEGIN */
    case 9: /* CASCADE */
    case 10: /* CAST */
    case 11: /* CONFLICT */
    case 12: /* DATABASE */
    case 13: /* DEFERRED */
    case 14: /* DESC */
    case 15: /* DETACH */
    case 16: /* EACH */
    case 17: /* END */
    case 18: /* EXCLUSIVE */
    case 19: /* EXPLAIN */
    case 20: /* FAIL */
    case 21: /* FOR */
    case 22: /* IGNORE */
    case 23: /* IMMEDIATE */
    case 24: /* INITIALLY */
    case 25: /* INSTEAD */
    case 26: /* LIKE */
    case 27: /* MATCH */
    case 28: /* PLAN */
    case 29: /* QUERY */
    case 30: /* KEY */
    case 31: /* OF */
    case 32: /* OFFSET */
    case 33: /* PRAGMA */
    case 34: /* RAISE */
    case 35: /* REPLACE */
    case 36: /* RESTRICT */
    case 37: /* ROW */
    case 38: /* TEMP */
    case 39: /* TRIGGER */
    case 40: /* VACUUM */
    case 41: /* VIEW */
    case 42: /* VIRTUAL */
    case 43: /* REINDEX */
    case 44: /* RENAME */
    case 45: /* CTIME_KW */
    case 46: /* IF */
    case 47: /* DELIMITER */
    case 48: /* COMMIT */
    case 49: /* ROLLBACK */
    case 50: /* ISOLATION */
    case 51: /* LEVEL */
    case 52: /* SERIALIZABLE */
    case 53: /* READ */
    case 54: /* COMMITTED */
    case 55: /* UNCOMMITTED */
    case 56: /* REPEATABLE */
    case 57: /* WRITE */
    case 58: /* ONLY */
    case 59: /* SAVEPOINT */
    case 60: /* RELEASE */
    case 61: /* COMMENT */
    case 62: /* FORCE */
    case 63: /* WAIT */
    case 64: /* NOWAIT */
    case 65: /* BATCH */
    case 66: /* OR */
    case 67: /* AND */
    case 68: /* NOT */
    case 69: /* IS */
    case 70: /* IN */
    case 71: /* ISNULL */
    case 72: /* NOTNULL */
    case 73: /* DIFF */
    case 74: /* EQ */
    case 75: /* BETWEEN */
    case 76: /* GT */
    case 77: /* LEQ */
    case 78: /* LT */
    case 79: /* GEQ */
    case 80: /* REGEXP */
    case 81: /* REGEXP_CI */
    case 82: /* NOT_REGEXP */
    case 83: /* NOT_REGEXP_CI */
    case 84: /* SIMILAR */
    case 85: /* ESCAPE */
    case 86: /* BITAND */
    case 87: /* BITOR */
    case 88: /* LSHIFT */
    case 89: /* RSHIFT */
    case 90: /* PLUS */
    case 91: /* MINUS */
    case 92: /* STAR */
    case 93: /* SLASH */
    case 94: /* REM */
    case 95: /* CONCAT */
    case 96: /* COLLATE */
    case 97: /* UMINUS */
    case 98: /* UPLUS */
    case 99: /* BITNOT */
    case 100: /* LP */
    case 101: /* RP */
    case 102: /* JOIN */
    case 103: /* INNER */
    case 104: /* NATURAL */
    case 105: /* LEFT */
    case 106: /* RIGHT */
    case 107: /* FULL */
    case 108: /* CROSS */
    case 109: /* UNION */
    case 110: /* EXCEPT */
    case 111: /* INTERSECT */
    case 112: /* PGCAST */
    case 113: /* ILLEGAL */
    case 114: /* SQLCOMMENT */
    case 115: /* SEMI */
    case 116: /* END_OF_FILE */
    case 117: /* TRANSACTION */
    case 118: /* STRING */
    case 119: /* COMMA */
    case 120: /* INTEGER */
    case 121: /* TO */
    case 122: /* INSERT */
    case 123: /* INTO */
    case 124: /* VALUES */
    case 125: /* DELETE */
    case 126: /* FROM */
    case 127: /* WHERE */
    case 128: /* UPDATE */
    case 129: /* SET */
    case 130: /* ALL */
    case 131: /* SELECT */
    case 132: /* LIMIT */
    case 133: /* ORDER */
    case 134: /* BY */
    case 135: /* HAVING */
    case 136: /* GROUP */
    case 137: /* USING */
    case 138: /* ON */
    case 139: /* OUTER */
    case 140: /* DOT */
    case 141: /* AS */
    case 142: /* DISTINCT */
    case 143: /* CASE */
    case 144: /* WHEN */
    case 145: /* THEN */
    case 146: /* ELSE */
    case 147: /* NULL */
    case 148: /* FLOAT */
    case 149: /* UNSPECVAL */
    case 150: /* LSBRACKET */
    case 151: /* RSBRACKET */
    case 152: /* SIMPLEPARAM */
    case 153: /* PNAME */
    case 154: /* PDESCR */
    case 155: /* PTYPE */
    case 156: /* PNULLOK */
    case 157: /* TEXTUAL */
#line 9 "./parser.y"
{if ((yypminor->yy0)) {
#ifdef GDA_DEBUG_NO
		 gchar *str = gda_sql_value_stringify ((yypminor->yy0));
		 g_print ("___ token destructor /%s/\n", str)
		 g_free (str);
#endif
		 g_value_unset ((yypminor->yy0)); g_free ((yypminor->yy0));}}
#line 1453 "parser.c"
      break;
    case 159: /* stmt */
#line 278 "./parser.y"
{g_print ("Statement destroyed by parser: %p\n", (yypminor->yy308)); gda_sql_statement_free ((yypminor->yy308));}
#line 1458 "parser.c"
      break;
    case 160: /* cmd */
    case 162: /* compound */
    case 179: /* selectcmd */
#line 301 "./parser.y"
{gda_sql_statement_free ((yypminor->yy308));}
#line 1465 "parser.c"
      break;
    case 172: /* inscollist_opt */
    case 175: /* inscollist */
    case 195: /* using_opt */
#line 478 "./parser.y"
{if ((yypminor->yy393)) {g_slist_foreach ((yypminor->yy393), (GFunc) gda_sql_field_free, NULL); g_slist_free ((yypminor->yy393));}}
#line 1472 "parser.c"
      break;
    case 173: /* exprlist */
    case 190: /* nexprlist */
#line 764 "./parser.y"
{if ((yypminor->yy247)) {g_slist_foreach ((yypminor->yy247), (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy247));}}
#line 1478 "parser.c"
      break;
    case 174: /* ins_extra_values */
#line 467 "./parser.y"
{GSList *list;
		for (list = (yypminor->yy393); list; list = list->next) {
			g_slist_foreach ((GSList*) list->data, (GFunc) gda_sql_field_free, NULL); 
			g_slist_free ((GSList*) list->data);
		}
		g_slist_free ((yypminor->yy393));
}
#line 1489 "parser.c"
      break;
    case 176: /* where_opt */
    case 177: /* expr */
    case 185: /* having_opt */
    case 194: /* on_cond */
    case 201: /* pvalue */
#line 500 "./parser.y"
{gda_sql_expr_free ((yypminor->yy328));}
#line 1498 "parser.c"
      break;
    case 178: /* setlist */
#line 520 "./parser.y"
{GSList *list;
	for (list = (yypminor->yy393); list; list = list->next) {
		UpdateSet *set = (UpdateSet*) list->data;
		g_value_reset (set->fname); g_free (set->fname);
		gda_sql_expr_free (set->expr);
		g_free (set);
	}
	g_slist_free ((yypminor->yy393));
}
#line 1511 "parser.c"
      break;
    case 181: /* distinct */
#line 750 "./parser.y"
{if ((yypminor->yy189)) {if ((yypminor->yy189)->expr) gda_sql_expr_free ((yypminor->yy189)->expr); g_free ((yypminor->yy189));}}
#line 1516 "parser.c"
      break;
    case 182: /* selcollist */
    case 198: /* sclp */
#line 707 "./parser.y"
{g_slist_foreach ((yypminor->yy247), (GFunc) gda_sql_select_field_free, NULL); g_slist_free ((yypminor->yy247));}
#line 1522 "parser.c"
      break;
    case 183: /* from */
    case 191: /* seltablist */
    case 192: /* stl_prefix */
#line 633 "./parser.y"
{gda_sql_select_from_free ((yypminor->yy59));}
#line 1529 "parser.c"
      break;
    case 184: /* groupby_opt */
#line 628 "./parser.y"
{if ((yypminor->yy393)) {g_slist_foreach ((yypminor->yy393), (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy393));}}
#line 1534 "parser.c"
      break;
    case 186: /* orderby_opt */
    case 188: /* sortlist */
#line 597 "./parser.y"
{if ((yypminor->yy247)) {g_slist_foreach ((yypminor->yy247), (GFunc) gda_sql_select_order_free, NULL); g_slist_free ((yypminor->yy247));}}
#line 1540 "parser.c"
      break;
    case 187: /* limit_opt */
#line 590 "./parser.y"
{gda_sql_expr_free ((yypminor->yy20).count); gda_sql_expr_free ((yypminor->yy20).offset);}
#line 1545 "parser.c"
      break;
    case 193: /* seltarget */
#line 692 "./parser.y"
{gda_sql_select_target_free ((yypminor->yy224));}
#line 1550 "parser.c"
      break;
    case 203: /* case_operand */
    case 205: /* case_else */
#line 928 "./parser.y"
{gda_sql_expr_free ((yypminor->yy122));}
#line 1556 "parser.c"
      break;
    case 204: /* case_exprlist */
#line 933 "./parser.y"
{g_slist_foreach ((yypminor->yy263).when_list, (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy263).when_list);
	g_slist_foreach ((yypminor->yy263).then_list, (GFunc) gda_sql_expr_free, NULL); g_slist_free ((yypminor->yy263).then_list);}
#line 1562 "parser.c"
      break;
    case 206: /* paramspec */
#line 971 "./parser.y"
{gda_sql_param_spec_free ((yypminor->yy405));}
#line 1567 "parser.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from gda_lemon_oracle_parserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void gda_lemon_oracle_parserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      int iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  assert( stateno<=YY_REDUCE_MAX );
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  assert( i>=0 && i<YY_SZ_ACTTAB );
  assert( yy_lookahead[i]==iLookAhead );
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   gda_lemon_oracle_parserARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
#line 25 "./parser.y"

	gda_sql_parser_set_overflow_error (pdata->parser);
#line 1721 "parser.c"
   gda_lemon_oracle_parserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 159, 2 },
  { 159, 2 },
  { 160, 3 },
  { 162, 3 },
  { 161, 1 },
  { 161, 1 },
  { 160, 1 },
  { 160, 3 },
  { 160, 4 },
  { 160, 3 },
  { 160, 2 },
  { 160, 3 },
  { 160, 3 },
  { 160, 5 },
  { 160, 5 },
  { 160, 4 },
  { 160, 4 },
  { 160, 3 },
  { 160, 2 },
  { 160, 3 },
  { 160, 3 },
  { 160, 5 },
  { 160, 3 },
  { 160, 4 },
  { 160, 2 },
  { 160, 3 },
  { 168, 2 },
  { 168, 2 },
  { 168, 2 },
  { 168, 2 },
  { 168, 3 },
  { 168, 3 },
  { 168, 3 },
  { 168, 3 },
  { 167, 0 },
  { 167, 1 },
  { 166, 0 },
  { 166, 1 },
  { 165, 3 },
  { 165, 4 },
  { 165, 4 },
  { 165, 4 },
  { 163, 0 },
  { 163, 1 },
  { 164, 1 },
  { 164, 1 },
  { 164, 1 },
  { 164, 2 },
  { 164, 2 },
  { 160, 2 },
  { 160, 3 },
  { 160, 2 },
  { 160, 4 },
  { 160, 5 },
  { 160, 9 },
  { 160, 10 },
  { 160, 6 },
  { 170, 0 },
  { 170, 2 },
  { 174, 5 },
  { 174, 4 },
  { 172, 0 },
  { 172, 3 },
  { 175, 3 },
  { 175, 1 },
  { 160, 4 },
  { 176, 0 },
  { 176, 2 },
  { 160, 6 },
  { 178, 5 },
  { 178, 3 },
  { 162, 1 },
  { 162, 4 },
  { 162, 4 },
  { 162, 4 },
  { 180, 0 },
  { 180, 1 },
  { 179, 9 },
  { 187, 0 },
  { 187, 2 },
  { 187, 4 },
  { 187, 4 },
  { 186, 0 },
  { 186, 3 },
  { 188, 4 },
  { 188, 2 },
  { 189, 1 },
  { 189, 1 },
  { 189, 0 },
  { 185, 0 },
  { 185, 2 },
  { 184, 0 },
  { 184, 3 },
  { 183, 0 },
  { 183, 2 },
  { 191, 4 },
  { 195, 4 },
  { 195, 0 },
  { 192, 0 },
  { 192, 2 },
  { 194, 2 },
  { 194, 0 },
  { 196, 1 },
  { 196, 1 },
  { 196, 2 },
  { 196, 2 },
  { 196, 2 },
  { 196, 2 },
  { 196, 3 },
  { 196, 2 },
  { 196, 3 },
  { 196, 2 },
  { 196, 3 },
  { 193, 2 },
  { 193, 2 },
  { 193, 4 },
  { 198, 2 },
  { 198, 0 },
  { 182, 3 },
  { 182, 2 },
  { 199, 1 },
  { 199, 3 },
  { 199, 5 },
  { 197, 2 },
  { 197, 2 },
  { 197, 0 },
  { 181, 0 },
  { 181, 1 },
  { 181, 1 },
  { 181, 3 },
  { 190, 3 },
  { 190, 1 },
  { 173, 0 },
  { 173, 3 },
  { 173, 1 },
  { 177, 1 },
  { 177, 1 },
  { 177, 3 },
  { 177, 1 },
  { 177, 4 },
  { 177, 4 },
  { 177, 4 },
  { 177, 6 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 2 },
  { 177, 2 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 5 },
  { 177, 6 },
  { 177, 2 },
  { 177, 2 },
  { 177, 2 },
  { 177, 3 },
  { 177, 3 },
  { 177, 5 },
  { 177, 5 },
  { 177, 6 },
  { 177, 6 },
  { 177, 5 },
  { 203, 1 },
  { 203, 0 },
  { 204, 5 },
  { 204, 4 },
  { 205, 2 },
  { 205, 0 },
  { 202, 1 },
  { 202, 2 },
  { 200, 1 },
  { 200, 1 },
  { 200, 1 },
  { 200, 1 },
  { 201, 4 },
  { 201, 4 },
  { 201, 1 },
  { 206, 0 },
  { 206, 2 },
  { 206, 2 },
  { 206, 2 },
  { 206, 2 },
  { 169, 1 },
  { 169, 1 },
  { 169, 1 },
  { 171, 1 },
  { 171, 3 },
  { 171, 5 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  gda_lemon_oracle_parserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  memset(&yygotominor, 0, sizeof(yygotominor));


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0: /* stmt ::= cmd eos */
#line 279 "./parser.y"
{pdata->parsed_statement = yymsp[-1].minor.yy308;}
#line 2024 "parser.c"
        break;
      case 1: /* stmt ::= compound eos */
#line 280 "./parser.y"
{
	GdaSqlStatementCompound *scompound = (GdaSqlStatementCompound *) yymsp[-1].minor.yy308->contents;
	if (scompound->stmt_list->next)
		/* real compound (multiple statements) */
		pdata->parsed_statement = yymsp[-1].minor.yy308;
	else {
		/* false compound (only 1 select) */
		pdata->parsed_statement = (GdaSqlStatement*) scompound->stmt_list->data;
		GDA_SQL_ANY_PART (pdata->parsed_statement->contents)->parent = NULL;
		g_slist_free (scompound->stmt_list);
		scompound->stmt_list = NULL;
		gda_sql_statement_free (yymsp[-1].minor.yy308);
	}
}
#line 2042 "parser.c"
        break;
      case 2: /* cmd ::= LP cmd RP */
      case 3: /* compound ::= LP compound RP */
#line 294 "./parser.y"
{yygotominor.yy308 = yymsp[-1].minor.yy308;  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 2050 "parser.c"
        break;
      case 4: /* eos ::= SEMI */
#line 297 "./parser.y"
{
  yy_destructor(115,&yymsp[0].minor);
}
#line 2057 "parser.c"
        break;
      case 5: /* eos ::= END_OF_FILE */
#line 298 "./parser.y"
{
  yy_destructor(116,&yymsp[0].minor);
}
#line 2064 "parser.c"
        break;
      case 6: /* cmd ::= BEGIN */
#line 306 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);  yy_destructor(8,&yymsp[0].minor);
}
#line 2070 "parser.c"
        break;
      case 7: /* cmd ::= BEGIN TRANSACTION nm_opt */
#line 307 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					 gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(8,&yymsp[-2].minor);
  yy_destructor(117,&yymsp[-1].minor);
}
#line 2079 "parser.c"
        break;
      case 8: /* cmd ::= BEGIN transtype TRANSACTION nm_opt */
#line 311 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
						      gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[-2].minor.yy361);
						      gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(8,&yymsp[-3].minor);
  yy_destructor(117,&yymsp[-1].minor);
}
#line 2089 "parser.c"
        break;
      case 9: /* cmd ::= BEGIN transtype nm_opt */
#line 316 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					  gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[-1].minor.yy361);
					  gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(8,&yymsp[-2].minor);
}
#line 2098 "parser.c"
        break;
      case 10: /* cmd ::= BEGIN transilev */
#line 321 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
				gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[0].minor.yy307);
  yy_destructor(8,&yymsp[-1].minor);
}
#line 2106 "parser.c"
        break;
      case 11: /* cmd ::= BEGIN TRANSACTION transilev */
#line 325 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					    gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[0].minor.yy307);
  yy_destructor(8,&yymsp[-2].minor);
  yy_destructor(117,&yymsp[-1].minor);
}
#line 2115 "parser.c"
        break;
      case 12: /* cmd ::= BEGIN TRANSACTION transtype */
#line 329 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
					    gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(8,&yymsp[-2].minor);
  yy_destructor(117,&yymsp[-1].minor);
}
#line 2124 "parser.c"
        break;
      case 13: /* cmd ::= BEGIN TRANSACTION transtype opt_comma transilev */
#line 333 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
								   gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[-2].minor.yy361);
								   gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[0].minor.yy307);
  yy_destructor(8,&yymsp[-4].minor);
  yy_destructor(117,&yymsp[-3].minor);
}
#line 2134 "parser.c"
        break;
      case 14: /* cmd ::= BEGIN TRANSACTION transilev opt_comma transtype */
#line 338 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
								   gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[0].minor.yy361);
								   gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[-2].minor.yy307);
  yy_destructor(8,&yymsp[-4].minor);
  yy_destructor(117,&yymsp[-3].minor);
}
#line 2144 "parser.c"
        break;
      case 15: /* cmd ::= BEGIN transtype opt_comma transilev */
#line 343 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
						       gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[-2].minor.yy361);
						       gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[0].minor.yy307);
  yy_destructor(8,&yymsp[-3].minor);
}
#line 2153 "parser.c"
        break;
      case 16: /* cmd ::= BEGIN transilev opt_comma transtype */
#line 348 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_BEGIN);
						       gda_sql_statement_trans_take_mode (yygotominor.yy308, yymsp[0].minor.yy361);
						       gda_sql_statement_trans_set_isol_level (yygotominor.yy308, yymsp[-2].minor.yy307);
  yy_destructor(8,&yymsp[-3].minor);
}
#line 2162 "parser.c"
        break;
      case 17: /* cmd ::= END trans_opt_kw nm_opt */
#line 353 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);
					gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(17,&yymsp[-2].minor);
}
#line 2170 "parser.c"
        break;
      case 18: /* cmd ::= COMMIT nm_opt */
#line 357 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);
			      gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(48,&yymsp[-1].minor);
}
#line 2178 "parser.c"
        break;
      case 19: /* cmd ::= COMMIT TRANSACTION nm_opt */
#line 361 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);
					  gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(48,&yymsp[-2].minor);
  yy_destructor(117,&yymsp[-1].minor);
}
#line 2187 "parser.c"
        break;
      case 20: /* cmd ::= COMMIT FORCE STRING */
#line 365 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(48,&yymsp[-2].minor);
  yy_destructor(62,&yymsp[-1].minor);
  yy_destructor(118,&yymsp[0].minor);
}
#line 2195 "parser.c"
        break;
      case 21: /* cmd ::= COMMIT FORCE STRING COMMA INTEGER */
#line 366 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(48,&yymsp[-4].minor);
  yy_destructor(62,&yymsp[-3].minor);
  yy_destructor(118,&yymsp[-2].minor);
  yy_destructor(119,&yymsp[-1].minor);
  yy_destructor(120,&yymsp[0].minor);
}
#line 2205 "parser.c"
        break;
      case 22: /* cmd ::= COMMIT COMMENT STRING */
#line 367 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(48,&yymsp[-2].minor);
  yy_destructor(61,&yymsp[-1].minor);
  yy_destructor(118,&yymsp[0].minor);
}
#line 2213 "parser.c"
        break;
      case 23: /* cmd ::= COMMIT COMMENT STRING ora_commit_write */
#line 368 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(48,&yymsp[-3].minor);
  yy_destructor(61,&yymsp[-2].minor);
  yy_destructor(118,&yymsp[-1].minor);
}
#line 2221 "parser.c"
        break;
      case 24: /* cmd ::= COMMIT ora_commit_write */
#line 369 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMMIT);  yy_destructor(48,&yymsp[-1].minor);
}
#line 2227 "parser.c"
        break;
      case 25: /* cmd ::= ROLLBACK trans_opt_kw nm_opt */
#line 371 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_ROLLBACK);
					     gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(49,&yymsp[-2].minor);
}
#line 2235 "parser.c"
        break;
      case 26: /* ora_commit_write ::= WRITE IMMEDIATE */
#line 375 "./parser.y"
{
  yy_destructor(57,&yymsp[-1].minor);
  yy_destructor(23,&yymsp[0].minor);
}
#line 2243 "parser.c"
        break;
      case 27: /* ora_commit_write ::= WRITE BATCH */
#line 376 "./parser.y"
{
  yy_destructor(57,&yymsp[-1].minor);
  yy_destructor(65,&yymsp[0].minor);
}
#line 2251 "parser.c"
        break;
      case 28: /* ora_commit_write ::= WRITE WAIT */
#line 377 "./parser.y"
{
  yy_destructor(57,&yymsp[-1].minor);
  yy_destructor(63,&yymsp[0].minor);
}
#line 2259 "parser.c"
        break;
      case 29: /* ora_commit_write ::= WRITE NOWAIT */
#line 378 "./parser.y"
{
  yy_destructor(57,&yymsp[-1].minor);
  yy_destructor(64,&yymsp[0].minor);
}
#line 2267 "parser.c"
        break;
      case 30: /* ora_commit_write ::= WRITE IMMEDIATE WAIT */
#line 379 "./parser.y"
{
  yy_destructor(57,&yymsp[-2].minor);
  yy_destructor(23,&yymsp[-1].minor);
  yy_destructor(63,&yymsp[0].minor);
}
#line 2276 "parser.c"
        break;
      case 31: /* ora_commit_write ::= WRITE IMMEDIATE NOWAIT */
#line 380 "./parser.y"
{
  yy_destructor(57,&yymsp[-2].minor);
  yy_destructor(23,&yymsp[-1].minor);
  yy_destructor(64,&yymsp[0].minor);
}
#line 2285 "parser.c"
        break;
      case 32: /* ora_commit_write ::= WRITE BATCH WAIT */
#line 381 "./parser.y"
{
  yy_destructor(57,&yymsp[-2].minor);
  yy_destructor(65,&yymsp[-1].minor);
  yy_destructor(63,&yymsp[0].minor);
}
#line 2294 "parser.c"
        break;
      case 33: /* ora_commit_write ::= WRITE BATCH NOWAIT */
#line 382 "./parser.y"
{
  yy_destructor(57,&yymsp[-2].minor);
  yy_destructor(65,&yymsp[-1].minor);
  yy_destructor(64,&yymsp[0].minor);
}
#line 2303 "parser.c"
        break;
      case 34: /* trans_opt_kw ::= */
      case 36: /* opt_comma ::= */
#line 384 "./parser.y"
{
}
#line 2310 "parser.c"
        break;
      case 35: /* trans_opt_kw ::= TRANSACTION */
#line 385 "./parser.y"
{
  yy_destructor(117,&yymsp[0].minor);
}
#line 2317 "parser.c"
        break;
      case 37: /* opt_comma ::= COMMA */
#line 388 "./parser.y"
{
  yy_destructor(119,&yymsp[0].minor);
}
#line 2324 "parser.c"
        break;
      case 38: /* transilev ::= ISOLATION LEVEL SERIALIZABLE */
#line 391 "./parser.y"
{yygotominor.yy307 = GDA_TRANSACTION_ISOLATION_SERIALIZABLE;  yy_destructor(50,&yymsp[-2].minor);
  yy_destructor(51,&yymsp[-1].minor);
  yy_destructor(52,&yymsp[0].minor);
}
#line 2332 "parser.c"
        break;
      case 39: /* transilev ::= ISOLATION LEVEL REPEATABLE READ */
#line 392 "./parser.y"
{yygotominor.yy307 = GDA_TRANSACTION_ISOLATION_REPEATABLE_READ;  yy_destructor(50,&yymsp[-3].minor);
  yy_destructor(51,&yymsp[-2].minor);
  yy_destructor(56,&yymsp[-1].minor);
  yy_destructor(53,&yymsp[0].minor);
}
#line 2341 "parser.c"
        break;
      case 40: /* transilev ::= ISOLATION LEVEL READ COMMITTED */
#line 393 "./parser.y"
{yygotominor.yy307 = GDA_TRANSACTION_ISOLATION_READ_COMMITTED;  yy_destructor(50,&yymsp[-3].minor);
  yy_destructor(51,&yymsp[-2].minor);
  yy_destructor(53,&yymsp[-1].minor);
  yy_destructor(54,&yymsp[0].minor);
}
#line 2350 "parser.c"
        break;
      case 41: /* transilev ::= ISOLATION LEVEL READ UNCOMMITTED */
#line 394 "./parser.y"
{yygotominor.yy307 = GDA_TRANSACTION_ISOLATION_READ_UNCOMMITTED;  yy_destructor(50,&yymsp[-3].minor);
  yy_destructor(51,&yymsp[-2].minor);
  yy_destructor(53,&yymsp[-1].minor);
  yy_destructor(55,&yymsp[0].minor);
}
#line 2359 "parser.c"
        break;
      case 42: /* nm_opt ::= */
      case 57: /* opt_on_conflict ::= */
      case 125: /* as ::= */
#line 396 "./parser.y"
{yygotominor.yy361 = NULL;}
#line 2366 "parser.c"
        break;
      case 43: /* nm_opt ::= nm */
      case 192: /* fullname ::= nm */
#line 397 "./parser.y"
{yygotominor.yy361 = yymsp[0].minor.yy361;}
#line 2372 "parser.c"
        break;
      case 44: /* transtype ::= DEFERRED */
      case 45: /* transtype ::= IMMEDIATE */
      case 46: /* transtype ::= EXCLUSIVE */
      case 120: /* starname ::= STAR */
      case 178: /* value ::= STRING */
      case 179: /* value ::= INTEGER */
      case 180: /* value ::= FLOAT */
      case 189: /* nm ::= JOIN */
      case 190: /* nm ::= ID */
      case 191: /* nm ::= TEXTUAL */
#line 399 "./parser.y"
{yygotominor.yy361 = yymsp[0].minor.yy0;}
#line 2386 "parser.c"
        break;
      case 47: /* transtype ::= READ WRITE */
#line 402 "./parser.y"
{yygotominor.yy361 = g_new0 (GValue, 1);
			      g_value_init (yygotominor.yy361, G_TYPE_STRING);
			      g_value_set_string (yygotominor.yy361, "READ_WRITE");
  yy_destructor(53,&yymsp[-1].minor);
  yy_destructor(57,&yymsp[0].minor);
}
#line 2396 "parser.c"
        break;
      case 48: /* transtype ::= READ ONLY */
#line 406 "./parser.y"
{yygotominor.yy361 = g_new0 (GValue, 1);
			     g_value_init (yygotominor.yy361, G_TYPE_STRING);
			     g_value_set_string (yygotominor.yy361, "READ_ONLY");
  yy_destructor(53,&yymsp[-1].minor);
  yy_destructor(58,&yymsp[0].minor);
}
#line 2406 "parser.c"
        break;
      case 49: /* cmd ::= SAVEPOINT nm */
#line 414 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_SAVEPOINT);
				    gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(59,&yymsp[-1].minor);
}
#line 2414 "parser.c"
        break;
      case 50: /* cmd ::= RELEASE SAVEPOINT nm */
#line 418 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_DELETE_SAVEPOINT);
				     gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(60,&yymsp[-2].minor);
  yy_destructor(59,&yymsp[-1].minor);
}
#line 2423 "parser.c"
        break;
      case 51: /* cmd ::= RELEASE nm */
#line 422 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_DELETE_SAVEPOINT);
			   gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(60,&yymsp[-1].minor);
}
#line 2431 "parser.c"
        break;
      case 52: /* cmd ::= ROLLBACK trans_opt_kw TO nm */
#line 426 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_ROLLBACK_SAVEPOINT);
					    gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(49,&yymsp[-3].minor);
  yy_destructor(121,&yymsp[-1].minor);
}
#line 2440 "parser.c"
        break;
      case 53: /* cmd ::= ROLLBACK trans_opt_kw TO SAVEPOINT nm */
#line 430 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_ROLLBACK_SAVEPOINT);
						      gda_sql_statement_trans_take_name (yygotominor.yy308, yymsp[0].minor.yy361);
  yy_destructor(49,&yymsp[-4].minor);
  yy_destructor(121,&yymsp[-2].minor);
  yy_destructor(59,&yymsp[-1].minor);
}
#line 2450 "parser.c"
        break;
      case 54: /* cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP exprlist RP */
#line 437 "./parser.y"
{
	yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_INSERT);
	gda_sql_statement_insert_take_table_name (yygotominor.yy308, yymsp[-5].minor.yy361);
	gda_sql_statement_insert_take_fields_list (yygotominor.yy308, yymsp[-4].minor.yy393);
	gda_sql_statement_insert_take_1_values_list (yygotominor.yy308, yymsp[-1].minor.yy247);
	gda_sql_statement_insert_take_on_conflict (yygotominor.yy308, yymsp[-7].minor.yy361);
  yy_destructor(122,&yymsp[-8].minor);
  yy_destructor(123,&yymsp[-6].minor);
  yy_destructor(124,&yymsp[-3].minor);
  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 2466 "parser.c"
        break;
      case 55: /* cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt VALUES LP exprlist RP ins_extra_values */
#line 445 "./parser.y"
{
	yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_INSERT);
	gda_sql_statement_insert_take_table_name (yygotominor.yy308, yymsp[-6].minor.yy361);
	gda_sql_statement_insert_take_fields_list (yygotominor.yy308, yymsp[-5].minor.yy393);
	gda_sql_statement_insert_take_1_values_list (yygotominor.yy308, yymsp[-2].minor.yy247);
	gda_sql_statement_insert_take_extra_values_list (yygotominor.yy308, yymsp[0].minor.yy393);
	gda_sql_statement_insert_take_on_conflict (yygotominor.yy308, yymsp[-8].minor.yy361);
  yy_destructor(122,&yymsp[-9].minor);
  yy_destructor(123,&yymsp[-7].minor);
  yy_destructor(124,&yymsp[-4].minor);
  yy_destructor(100,&yymsp[-3].minor);
  yy_destructor(101,&yymsp[-1].minor);
}
#line 2483 "parser.c"
        break;
      case 56: /* cmd ::= INSERT opt_on_conflict INTO fullname inscollist_opt compound */
#line 454 "./parser.y"
{
        yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_INSERT);
        gda_sql_statement_insert_take_table_name (yygotominor.yy308, yymsp[-2].minor.yy361);
        gda_sql_statement_insert_take_fields_list (yygotominor.yy308, yymsp[-1].minor.yy393);
        gda_sql_statement_insert_take_select (yygotominor.yy308, yymsp[0].minor.yy308);
        gda_sql_statement_insert_take_on_conflict (yygotominor.yy308, yymsp[-4].minor.yy361);
  yy_destructor(122,&yymsp[-5].minor);
  yy_destructor(123,&yymsp[-3].minor);
}
#line 2496 "parser.c"
        break;
      case 58: /* opt_on_conflict ::= OR ID */
#line 464 "./parser.y"
{yygotominor.yy361 = yymsp[0].minor.yy0;  yy_destructor(66,&yymsp[-1].minor);
}
#line 2502 "parser.c"
        break;
      case 59: /* ins_extra_values ::= ins_extra_values COMMA LP exprlist RP */
#line 474 "./parser.y"
{yygotominor.yy393 = g_slist_append (yymsp[-4].minor.yy393, yymsp[-1].minor.yy247);  yy_destructor(119,&yymsp[-3].minor);
  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 2510 "parser.c"
        break;
      case 60: /* ins_extra_values ::= COMMA LP exprlist RP */
#line 475 "./parser.y"
{yygotominor.yy393 = g_slist_append (NULL, yymsp[-1].minor.yy247);  yy_destructor(119,&yymsp[-3].minor);
  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 2518 "parser.c"
        break;
      case 61: /* inscollist_opt ::= */
      case 97: /* using_opt ::= */
#line 479 "./parser.y"
{yygotominor.yy393 = NULL;}
#line 2524 "parser.c"
        break;
      case 62: /* inscollist_opt ::= LP inscollist RP */
#line 480 "./parser.y"
{yygotominor.yy393 = yymsp[-1].minor.yy393;  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 2531 "parser.c"
        break;
      case 63: /* inscollist ::= inscollist COMMA fullname */
#line 484 "./parser.y"
{GdaSqlField *field;
						    field = gda_sql_field_new (NULL);
						    gda_sql_field_take_name (field, yymsp[0].minor.yy361);
						    yygotominor.yy393 = g_slist_append (yymsp[-2].minor.yy393, field);
  yy_destructor(119,&yymsp[-1].minor);
}
#line 2541 "parser.c"
        break;
      case 64: /* inscollist ::= fullname */
#line 489 "./parser.y"
{GdaSqlField *field = gda_sql_field_new (NULL);
				gda_sql_field_take_name (field, yymsp[0].minor.yy361);
				yygotominor.yy393 = g_slist_prepend (NULL, field);
}
#line 2549 "parser.c"
        break;
      case 65: /* cmd ::= DELETE FROM fullname where_opt */
#line 495 "./parser.y"
{yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_DELETE); 
						  gda_sql_statement_delete_take_table_name (yygotominor.yy308, yymsp[-1].minor.yy361);
						  gda_sql_statement_delete_take_condition (yygotominor.yy308, yymsp[0].minor.yy328);  yy_destructor(125,&yymsp[-3].minor);
  yy_destructor(126,&yymsp[-2].minor);
}
#line 2558 "parser.c"
        break;
      case 66: /* where_opt ::= */
      case 89: /* having_opt ::= */
      case 101: /* on_cond ::= */
#line 501 "./parser.y"
{yygotominor.yy328 = NULL;}
#line 2565 "parser.c"
        break;
      case 67: /* where_opt ::= WHERE expr */
#line 502 "./parser.y"
{yygotominor.yy328 = yymsp[0].minor.yy328;  yy_destructor(127,&yymsp[-1].minor);
}
#line 2571 "parser.c"
        break;
      case 68: /* cmd ::= UPDATE opt_on_conflict fullname SET setlist where_opt */
#line 505 "./parser.y"
{
	GSList *list;
	yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_UPDATE);
	gda_sql_statement_update_take_table_name (yygotominor.yy308, yymsp[-3].minor.yy361);
	gda_sql_statement_update_take_on_conflict (yygotominor.yy308, yymsp[-4].minor.yy361);
	gda_sql_statement_update_take_condition (yygotominor.yy308, yymsp[0].minor.yy328);
	for (list = yymsp[-1].minor.yy393; list; list = list->next) {
		UpdateSet *set = (UpdateSet*) list->data;
		gda_sql_statement_update_take_set_value (yygotominor.yy308, set->fname, set->expr);
		g_free (set);
	}
	g_slist_free (yymsp[-1].minor.yy393);
  yy_destructor(128,&yymsp[-5].minor);
  yy_destructor(129,&yymsp[-2].minor);
}
#line 2590 "parser.c"
        break;
      case 69: /* setlist ::= setlist COMMA fullname EQ expr */
#line 529 "./parser.y"
{UpdateSet *set;
							 set = g_new (UpdateSet, 1);
							 set->fname = yymsp[-2].minor.yy361;
							 set->expr = yymsp[0].minor.yy328;
							 yygotominor.yy393 = g_slist_append (yymsp[-4].minor.yy393, set);
  yy_destructor(119,&yymsp[-3].minor);
  yy_destructor(74,&yymsp[-1].minor);
}
#line 2602 "parser.c"
        break;
      case 70: /* setlist ::= fullname EQ expr */
#line 535 "./parser.y"
{UpdateSet *set;
					set = g_new (UpdateSet, 1);
					set->fname = yymsp[-2].minor.yy361;
					set->expr = yymsp[0].minor.yy328;
					yygotominor.yy393 = g_slist_append (NULL, set);
  yy_destructor(74,&yymsp[-1].minor);
}
#line 2613 "parser.c"
        break;
      case 71: /* compound ::= selectcmd */
#line 546 "./parser.y"
{
	yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_COMPOUND);
	gda_sql_statement_compound_take_stmt (yygotominor.yy308, yymsp[0].minor.yy308);
}
#line 2621 "parser.c"
        break;
      case 72: /* compound ::= compound UNION opt_compound_all compound */
#line 550 "./parser.y"
{
	yygotominor.yy308 = compose_multiple_compounds (yymsp[-1].minor.yy216 ? GDA_SQL_STATEMENT_COMPOUND_UNION_ALL : GDA_SQL_STATEMENT_COMPOUND_UNION,
					yymsp[-3].minor.yy308, yymsp[0].minor.yy308);
  yy_destructor(109,&yymsp[-2].minor);
}
#line 2630 "parser.c"
        break;
      case 73: /* compound ::= compound EXCEPT opt_compound_all compound */
#line 555 "./parser.y"
{
	yygotominor.yy308 = compose_multiple_compounds (yymsp[-1].minor.yy216 ? GDA_SQL_STATEMENT_COMPOUND_EXCEPT_ALL : GDA_SQL_STATEMENT_COMPOUND_EXCEPT,
					yymsp[-3].minor.yy308, yymsp[0].minor.yy308);
  yy_destructor(110,&yymsp[-2].minor);
}
#line 2639 "parser.c"
        break;
      case 74: /* compound ::= compound INTERSECT opt_compound_all compound */
#line 560 "./parser.y"
{
	yygotominor.yy308 = compose_multiple_compounds (yymsp[-1].minor.yy216 ? GDA_SQL_STATEMENT_COMPOUND_INTERSECT_ALL : GDA_SQL_STATEMENT_COMPOUND_INTERSECT,
					yymsp[-3].minor.yy308, yymsp[0].minor.yy308);
  yy_destructor(111,&yymsp[-2].minor);
}
#line 2648 "parser.c"
        break;
      case 75: /* opt_compound_all ::= */
#line 566 "./parser.y"
{yygotominor.yy216 = FALSE;}
#line 2653 "parser.c"
        break;
      case 76: /* opt_compound_all ::= ALL */
#line 567 "./parser.y"
{yygotominor.yy216 = TRUE;  yy_destructor(130,&yymsp[0].minor);
}
#line 2659 "parser.c"
        break;
      case 77: /* selectcmd ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt */
#line 574 "./parser.y"
{
	yygotominor.yy308 = gda_sql_statement_new (GDA_SQL_STATEMENT_SELECT);
	if (yymsp[-7].minor.yy189) {
		gda_sql_statement_select_take_distinct (yygotominor.yy308, yymsp[-7].minor.yy189->distinct, yymsp[-7].minor.yy189->expr);
		g_free (yymsp[-7].minor.yy189);
	}
	gda_sql_statement_select_take_expr_list (yygotominor.yy308, yymsp[-6].minor.yy247);
	gda_sql_statement_select_take_from (yygotominor.yy308, yymsp[-5].minor.yy59);
	gda_sql_statement_select_take_where_cond (yygotominor.yy308, yymsp[-4].minor.yy328);
	gda_sql_statement_select_take_group_by (yygotominor.yy308, yymsp[-3].minor.yy393);
	gda_sql_statement_select_take_having_cond (yygotominor.yy308, yymsp[-2].minor.yy328);
	gda_sql_statement_select_take_order_by (yygotominor.yy308, yymsp[-1].minor.yy247);
	gda_sql_statement_select_take_limits (yygotominor.yy308, yymsp[0].minor.yy20.count, yymsp[0].minor.yy20.offset);
  yy_destructor(131,&yymsp[-8].minor);
}
#line 2678 "parser.c"
        break;
      case 78: /* limit_opt ::= */
#line 591 "./parser.y"
{yygotominor.yy20.count = NULL; yygotominor.yy20.offset = NULL;}
#line 2683 "parser.c"
        break;
      case 79: /* limit_opt ::= LIMIT expr */
#line 592 "./parser.y"
{yygotominor.yy20.count = yymsp[0].minor.yy328; yygotominor.yy20.offset = NULL;  yy_destructor(132,&yymsp[-1].minor);
}
#line 2689 "parser.c"
        break;
      case 80: /* limit_opt ::= LIMIT expr OFFSET expr */
#line 593 "./parser.y"
{yygotominor.yy20.count = yymsp[-2].minor.yy328; yygotominor.yy20.offset = yymsp[0].minor.yy328;  yy_destructor(132,&yymsp[-3].minor);
  yy_destructor(32,&yymsp[-1].minor);
}
#line 2696 "parser.c"
        break;
      case 81: /* limit_opt ::= LIMIT expr COMMA expr */
#line 594 "./parser.y"
{yygotominor.yy20.count = yymsp[-2].minor.yy328; yygotominor.yy20.offset = yymsp[0].minor.yy328;  yy_destructor(132,&yymsp[-3].minor);
  yy_destructor(119,&yymsp[-1].minor);
}
#line 2703 "parser.c"
        break;
      case 82: /* orderby_opt ::= */
#line 598 "./parser.y"
{yygotominor.yy247 = 0;}
#line 2708 "parser.c"
        break;
      case 83: /* orderby_opt ::= ORDER BY sortlist */
#line 599 "./parser.y"
{yygotominor.yy247 = yymsp[0].minor.yy247;  yy_destructor(133,&yymsp[-2].minor);
  yy_destructor(134,&yymsp[-1].minor);
}
#line 2715 "parser.c"
        break;
      case 84: /* sortlist ::= sortlist COMMA expr sortorder */
#line 603 "./parser.y"
{GdaSqlSelectOrder *order;
							 order = gda_sql_select_order_new (NULL);
							 order->expr = yymsp[-1].minor.yy328;
							 order->asc = yymsp[0].minor.yy216;
							 yygotominor.yy247 = g_slist_append (yymsp[-3].minor.yy247, order);
  yy_destructor(119,&yymsp[-2].minor);
}
#line 2726 "parser.c"
        break;
      case 85: /* sortlist ::= expr sortorder */
#line 609 "./parser.y"
{GdaSqlSelectOrder *order;
				       order = gda_sql_select_order_new (NULL);
				       order->expr = yymsp[-1].minor.yy328;
				       order->asc = yymsp[0].minor.yy216;
				       yygotominor.yy247 = g_slist_prepend (NULL, order);
}
#line 2736 "parser.c"
        break;
      case 86: /* sortorder ::= ASC */
#line 617 "./parser.y"
{yygotominor.yy216 = TRUE;  yy_destructor(5,&yymsp[0].minor);
}
#line 2742 "parser.c"
        break;
      case 87: /* sortorder ::= DESC */
#line 618 "./parser.y"
{yygotominor.yy216 = FALSE;  yy_destructor(14,&yymsp[0].minor);
}
#line 2748 "parser.c"
        break;
      case 88: /* sortorder ::= */
#line 619 "./parser.y"
{yygotominor.yy216 = TRUE;}
#line 2753 "parser.c"
        break;
      case 90: /* having_opt ::= HAVING expr */
#line 625 "./parser.y"
{yygotominor.yy328 = yymsp[0].minor.yy328;  yy_destructor(135,&yymsp[-1].minor);
}
#line 2759 "parser.c"
        break;
      case 91: /* groupby_opt ::= */
#line 629 "./parser.y"
{yygotominor.yy393 = 0;}
#line 2764 "parser.c"
        break;
      case 92: /* groupby_opt ::= GROUP BY nexprlist */
#line 630 "./parser.y"
{yygotominor.yy393 = yymsp[0].minor.yy247;  yy_destructor(136,&yymsp[-2].minor);
  yy_destructor(134,&yymsp[-1].minor);
}
#line 2771 "parser.c"
        break;
      case 93: /* from ::= */
      case 98: /* stl_prefix ::= */
#line 634 "./parser.y"
{yygotominor.yy59 = NULL;}
#line 2777 "parser.c"
        break;
      case 94: /* from ::= FROM seltablist */
#line 635 "./parser.y"
{yygotominor.yy59 = yymsp[0].minor.yy59;  yy_destructor(126,&yymsp[-1].minor);
}
#line 2783 "parser.c"
        break;
      case 95: /* seltablist ::= stl_prefix seltarget on_cond using_opt */
#line 642 "./parser.y"
{
	GSList *last;
	if (yymsp[-3].minor.yy59)
		yygotominor.yy59 = yymsp[-3].minor.yy59;
	else 
		yygotominor.yy59 = gda_sql_select_from_new (NULL);
	gda_sql_select_from_take_new_target (yygotominor.yy59, yymsp[-2].minor.yy224);
	last = g_slist_last (yygotominor.yy59->joins);
	if (last) {
		GdaSqlSelectJoin *join = (GdaSqlSelectJoin *) (last->data);
		join->expr = yymsp[-1].minor.yy328;
		join->position = g_slist_length (yygotominor.yy59->targets) - 1;
		join->use = yymsp[0].minor.yy393;
	}
}
#line 2802 "parser.c"
        break;
      case 96: /* using_opt ::= USING LP inscollist RP */
#line 660 "./parser.y"
{yygotominor.yy393 = yymsp[-1].minor.yy393;  yy_destructor(137,&yymsp[-3].minor);
  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 2810 "parser.c"
        break;
      case 99: /* stl_prefix ::= seltablist jointype */
#line 664 "./parser.y"
{GdaSqlSelectJoin *join;
					      yygotominor.yy59 = yymsp[-1].minor.yy59;
					      join = gda_sql_select_join_new (GDA_SQL_ANY_PART (yygotominor.yy59));
					      join->type = yymsp[0].minor.yy317;
					      gda_sql_select_from_take_new_join (yygotominor.yy59, join);
}
#line 2820 "parser.c"
        break;
      case 100: /* on_cond ::= ON expr */
#line 674 "./parser.y"
{yygotominor.yy328 = yymsp[0].minor.yy328;  yy_destructor(138,&yymsp[-1].minor);
}
#line 2826 "parser.c"
        break;
      case 102: /* jointype ::= COMMA */
#line 678 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_CROSS;  yy_destructor(119,&yymsp[0].minor);
}
#line 2832 "parser.c"
        break;
      case 103: /* jointype ::= JOIN */
#line 679 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_INNER;  yy_destructor(102,&yymsp[0].minor);
}
#line 2838 "parser.c"
        break;
      case 104: /* jointype ::= CROSS JOIN */
#line 680 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_CROSS;  yy_destructor(108,&yymsp[-1].minor);
  yy_destructor(102,&yymsp[0].minor);
}
#line 2845 "parser.c"
        break;
      case 105: /* jointype ::= INNER JOIN */
#line 681 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_INNER;  yy_destructor(103,&yymsp[-1].minor);
  yy_destructor(102,&yymsp[0].minor);
}
#line 2852 "parser.c"
        break;
      case 106: /* jointype ::= NATURAL JOIN */
#line 682 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_NATURAL;  yy_destructor(104,&yymsp[-1].minor);
  yy_destructor(102,&yymsp[0].minor);
}
#line 2859 "parser.c"
        break;
      case 107: /* jointype ::= LEFT JOIN */
#line 683 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_LEFT;  yy_destructor(105,&yymsp[-1].minor);
  yy_destructor(102,&yymsp[0].minor);
}
#line 2866 "parser.c"
        break;
      case 108: /* jointype ::= LEFT OUTER JOIN */
#line 684 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_LEFT;  yy_destructor(105,&yymsp[-2].minor);
  yy_destructor(139,&yymsp[-1].minor);
  yy_destructor(102,&yymsp[0].minor);
}
#line 2874 "parser.c"
        break;
      case 109: /* jointype ::= RIGHT JOIN */
#line 685 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_RIGHT;  yy_destructor(106,&yymsp[-1].minor);
  yy_destructor(102,&yymsp[0].minor);
}
#line 2881 "parser.c"
        break;
      case 110: /* jointype ::= RIGHT OUTER JOIN */
#line 686 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_RIGHT;  yy_destructor(106,&yymsp[-2].minor);
  yy_destructor(139,&yymsp[-1].minor);
  yy_destructor(102,&yymsp[0].minor);
}
#line 2889 "parser.c"
        break;
      case 111: /* jointype ::= FULL JOIN */
#line 687 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_FULL;  yy_destructor(107,&yymsp[-1].minor);
  yy_destructor(102,&yymsp[0].minor);
}
#line 2896 "parser.c"
        break;
      case 112: /* jointype ::= FULL OUTER JOIN */
#line 688 "./parser.y"
{yygotominor.yy317 = GDA_SQL_SELECT_JOIN_FULL;  yy_destructor(107,&yymsp[-2].minor);
  yy_destructor(139,&yymsp[-1].minor);
  yy_destructor(102,&yymsp[0].minor);
}
#line 2904 "parser.c"
        break;
      case 113: /* seltarget ::= fullname as */
#line 693 "./parser.y"
{yygotominor.yy224 = gda_sql_select_target_new (NULL);
				     gda_sql_select_target_take_alias (yygotominor.yy224, yymsp[0].minor.yy361);
				     gda_sql_select_target_take_table_name (yygotominor.yy224, yymsp[-1].minor.yy361);
}
#line 2912 "parser.c"
        break;
      case 114: /* seltarget ::= fullname ID */
#line 697 "./parser.y"
{yygotominor.yy224 = gda_sql_select_target_new (NULL);
                                     gda_sql_select_target_take_alias (yygotominor.yy224, yymsp[0].minor.yy0);
                                     gda_sql_select_target_take_table_name (yygotominor.yy224, yymsp[-1].minor.yy361);
}
#line 2920 "parser.c"
        break;
      case 115: /* seltarget ::= LP compound RP as */
#line 701 "./parser.y"
{yygotominor.yy224 = gda_sql_select_target_new (NULL);
					     gda_sql_select_target_take_alias (yygotominor.yy224, yymsp[0].minor.yy361);
					     gda_sql_select_target_take_select (yygotominor.yy224, yymsp[-2].minor.yy308);
  yy_destructor(100,&yymsp[-3].minor);
  yy_destructor(101,&yymsp[-1].minor);
}
#line 2930 "parser.c"
        break;
      case 116: /* sclp ::= selcollist COMMA */
#line 711 "./parser.y"
{yygotominor.yy247 = yymsp[-1].minor.yy247;  yy_destructor(119,&yymsp[0].minor);
}
#line 2936 "parser.c"
        break;
      case 117: /* sclp ::= */
      case 132: /* exprlist ::= */
#line 712 "./parser.y"
{yygotominor.yy247 = NULL;}
#line 2942 "parser.c"
        break;
      case 118: /* selcollist ::= sclp expr as */
#line 714 "./parser.y"
{GdaSqlSelectField *field;
					  field = gda_sql_select_field_new (NULL);
					  gda_sql_select_field_take_expr (field, yymsp[-1].minor.yy328);
					  gda_sql_select_field_take_alias (field, yymsp[0].minor.yy361); 
					  yygotominor.yy247 = g_slist_append (yymsp[-2].minor.yy247, field);}
#line 2951 "parser.c"
        break;
      case 119: /* selcollist ::= sclp starname */
#line 719 "./parser.y"
{GdaSqlSelectField *field;
					field = gda_sql_select_field_new (NULL);
					gda_sql_select_field_take_star_value (field, yymsp[0].minor.yy361);
					yygotominor.yy247 = g_slist_append (yymsp[-1].minor.yy247, field);}
#line 2959 "parser.c"
        break;
      case 121: /* starname ::= nm DOT STAR */
#line 725 "./parser.y"
{gchar *str;
				  str = g_strdup_printf ("%s.%s", g_value_get_string (yymsp[-2].minor.yy361), g_value_get_string (yymsp[0].minor.yy0));
				  yygotominor.yy361 = g_new0 (GValue, 1);
				  g_value_init (yygotominor.yy361, G_TYPE_STRING);
				  g_value_take_string (yygotominor.yy361, str);
				  g_value_reset (yymsp[-2].minor.yy361); g_free (yymsp[-2].minor.yy361);
				  g_value_reset (yymsp[0].minor.yy0); g_free (yymsp[0].minor.yy0);
  yy_destructor(140,&yymsp[-1].minor);
}
#line 2972 "parser.c"
        break;
      case 122: /* starname ::= nm DOT nm DOT STAR */
#line 734 "./parser.y"
{gchar *str;
				  str = g_strdup_printf ("%s.%s.%s", g_value_get_string (yymsp[-4].minor.yy361), 
							 g_value_get_string (yymsp[-2].minor.yy361), g_value_get_string (yymsp[0].minor.yy0));
				  yygotominor.yy361 = g_new0 (GValue, 1);
				  g_value_init (yygotominor.yy361, G_TYPE_STRING);
				  g_value_take_string (yygotominor.yy361, str);
				  g_value_reset (yymsp[-4].minor.yy361); g_free (yymsp[-4].minor.yy361);
				  g_value_reset (yymsp[-2].minor.yy361); g_free (yymsp[-2].minor.yy361);
				  g_value_reset (yymsp[0].minor.yy0); g_free (yymsp[0].minor.yy0);
  yy_destructor(140,&yymsp[-3].minor);
  yy_destructor(140,&yymsp[-1].minor);
}
#line 2988 "parser.c"
        break;
      case 123: /* as ::= AS fullname */
      case 124: /* as ::= AS value */
#line 745 "./parser.y"
{yygotominor.yy361 = yymsp[0].minor.yy361;  yy_destructor(141,&yymsp[-1].minor);
}
#line 2995 "parser.c"
        break;
      case 126: /* distinct ::= */
#line 751 "./parser.y"
{yygotominor.yy189 = NULL;}
#line 3000 "parser.c"
        break;
      case 127: /* distinct ::= ALL */
#line 752 "./parser.y"
{yygotominor.yy189 = NULL;  yy_destructor(130,&yymsp[0].minor);
}
#line 3006 "parser.c"
        break;
      case 128: /* distinct ::= DISTINCT */
#line 753 "./parser.y"
{yygotominor.yy189 = g_new0 (Distinct, 1); yygotominor.yy189->distinct = TRUE;  yy_destructor(142,&yymsp[0].minor);
}
#line 3012 "parser.c"
        break;
      case 129: /* distinct ::= DISTINCT ON expr */
#line 754 "./parser.y"
{yygotominor.yy189 = g_new0 (Distinct, 1); yygotominor.yy189->distinct = TRUE; yygotominor.yy189->expr = yymsp[0].minor.yy328;  yy_destructor(142,&yymsp[-2].minor);
  yy_destructor(138,&yymsp[-1].minor);
}
#line 3019 "parser.c"
        break;
      case 130: /* nexprlist ::= nexprlist COMMA expr */
      case 133: /* exprlist ::= exprlist COMMA expr */
#line 759 "./parser.y"
{yygotominor.yy247 = g_slist_append (yymsp[-2].minor.yy247, yymsp[0].minor.yy328);  yy_destructor(119,&yymsp[-1].minor);
}
#line 3026 "parser.c"
        break;
      case 131: /* nexprlist ::= expr */
      case 134: /* exprlist ::= expr */
#line 760 "./parser.y"
{yygotominor.yy247 = g_slist_append (NULL, yymsp[0].minor.yy328);}
#line 3032 "parser.c"
        break;
      case 135: /* expr ::= pvalue */
#line 772 "./parser.y"
{yygotominor.yy328 = yymsp[0].minor.yy328;}
#line 3037 "parser.c"
        break;
      case 136: /* expr ::= value */
      case 138: /* expr ::= fullname */
#line 773 "./parser.y"
{yygotominor.yy328 = gda_sql_expr_new (NULL); yygotominor.yy328->value = yymsp[0].minor.yy361;}
#line 3043 "parser.c"
        break;
      case 137: /* expr ::= LP expr RP */
#line 774 "./parser.y"
{yygotominor.yy328 = yymsp[-1].minor.yy328;  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 3050 "parser.c"
        break;
      case 139: /* expr ::= fullname LP exprlist RP */
#line 776 "./parser.y"
{GdaSqlFunction *func;
					    yygotominor.yy328 = gda_sql_expr_new (NULL); 
					    func = gda_sql_function_new (GDA_SQL_ANY_PART (yygotominor.yy328)); 
					    gda_sql_function_take_name (func, yymsp[-3].minor.yy361);
					    gda_sql_function_take_args_list (func, yymsp[-1].minor.yy247);
					    yygotominor.yy328->func = func;  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 3062 "parser.c"
        break;
      case 140: /* expr ::= fullname LP compound RP */
#line 782 "./parser.y"
{GdaSqlFunction *func;
					     GdaSqlExpr *expr;
					     yygotominor.yy328 = gda_sql_expr_new (NULL); 
					     func = gda_sql_function_new (GDA_SQL_ANY_PART (yygotominor.yy328)); 
					     gda_sql_function_take_name (func, yymsp[-3].minor.yy361);
					     expr = gda_sql_expr_new (GDA_SQL_ANY_PART (func)); 
					     gda_sql_expr_take_select (expr, yymsp[-1].minor.yy308);
					     gda_sql_function_take_args_list (func, g_slist_prepend (NULL, expr));
					     yygotominor.yy328->func = func;  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 3077 "parser.c"
        break;
      case 141: /* expr ::= fullname LP starname RP */
#line 791 "./parser.y"
{GdaSqlFunction *func;
					    GdaSqlExpr *expr;
					    yygotominor.yy328 = gda_sql_expr_new (NULL); 
					    func = gda_sql_function_new (GDA_SQL_ANY_PART (yygotominor.yy328));
					    gda_sql_function_take_name (func, yymsp[-3].minor.yy361);
					    expr = gda_sql_expr_new (GDA_SQL_ANY_PART (func)); 
					    expr->value = yymsp[-1].minor.yy361;
					    gda_sql_function_take_args_list (func, g_slist_prepend (NULL, expr));
					    yygotominor.yy328->func = func;  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 3092 "parser.c"
        break;
      case 142: /* expr ::= CAST LP expr AS fullname RP */
#line 800 "./parser.y"
{yygotominor.yy328 = yymsp[-3].minor.yy328;
						yymsp[-3].minor.yy328->cast_as = g_value_dup_string (yymsp[-1].minor.yy361);
						g_value_reset (yymsp[-1].minor.yy361);
						g_free (yymsp[-1].minor.yy361);  yy_destructor(10,&yymsp[-5].minor);
  yy_destructor(100,&yymsp[-4].minor);
  yy_destructor(141,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 3104 "parser.c"
        break;
      case 143: /* expr ::= expr PGCAST fullname */
#line 804 "./parser.y"
{yygotominor.yy328 = yymsp[-2].minor.yy328;
					 yymsp[-2].minor.yy328->cast_as = g_value_dup_string (yymsp[0].minor.yy361);
					 g_value_reset (yymsp[0].minor.yy361);
					 g_free (yymsp[0].minor.yy361);  yy_destructor(112,&yymsp[-1].minor);
}
#line 3113 "parser.c"
        break;
      case 144: /* expr ::= expr PLUS|MINUS expr */
#line 809 "./parser.y"
{yygotominor.yy328 = compose_multiple_expr (string_to_op_type (yymsp[-1].minor.yy0), yymsp[-2].minor.yy328, yymsp[0].minor.yy328);}
#line 3118 "parser.c"
        break;
      case 145: /* expr ::= expr STAR expr */
#line 810 "./parser.y"
{yygotominor.yy328 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_STAR, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(92,&yymsp[-1].minor);
}
#line 3124 "parser.c"
        break;
      case 146: /* expr ::= expr SLASH|REM expr */
      case 147: /* expr ::= expr BITAND|BITOR expr */
      case 153: /* expr ::= expr GT|LEQ|GEQ|LT expr */
      case 154: /* expr ::= expr DIFF|EQ expr */
      case 156: /* expr ::= expr REGEXP|REGEXP_CI|NOT_REGEXP|NOT_REGEXP_CI|SIMILAR expr */
#line 811 "./parser.y"
{yygotominor.yy328 = create_two_expr (string_to_op_type (yymsp[-1].minor.yy0), yymsp[-2].minor.yy328, yymsp[0].minor.yy328);}
#line 3133 "parser.c"
        break;
      case 148: /* expr ::= MINUS expr */
#line 814 "./parser.y"
{yygotominor.yy328 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_MINUS, yymsp[0].minor.yy328);  yy_destructor(91,&yymsp[-1].minor);
}
#line 3139 "parser.c"
        break;
      case 149: /* expr ::= PLUS expr */
#line 815 "./parser.y"
{yygotominor.yy328 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_PLUS, yymsp[0].minor.yy328);  yy_destructor(90,&yymsp[-1].minor);
}
#line 3145 "parser.c"
        break;
      case 150: /* expr ::= expr AND expr */
#line 817 "./parser.y"
{yygotominor.yy328 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_AND, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(67,&yymsp[-1].minor);
}
#line 3151 "parser.c"
        break;
      case 151: /* expr ::= expr OR expr */
#line 818 "./parser.y"
{yygotominor.yy328 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_OR, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(66,&yymsp[-1].minor);
}
#line 3157 "parser.c"
        break;
      case 152: /* expr ::= expr CONCAT expr */
#line 819 "./parser.y"
{yygotominor.yy328 = compose_multiple_expr (GDA_SQL_OPERATOR_TYPE_CONCAT, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(95,&yymsp[-1].minor);
}
#line 3163 "parser.c"
        break;
      case 155: /* expr ::= expr LIKE expr */
#line 823 "./parser.y"
{yygotominor.yy328 = create_two_expr (GDA_SQL_OPERATOR_TYPE_LIKE, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(26,&yymsp[-1].minor);
}
#line 3169 "parser.c"
        break;
      case 157: /* expr ::= expr BETWEEN expr AND expr */
#line 825 "./parser.y"
{GdaSqlOperation *cond;
						  yygotominor.yy328 = gda_sql_expr_new (NULL);
						  cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
						  yygotominor.yy328->cond = cond;
						  cond->operator_type = GDA_SQL_OPERATOR_TYPE_BETWEEN;
						  cond->operands = g_slist_append (NULL, yymsp[-4].minor.yy328);
						  GDA_SQL_ANY_PART (yymsp[-4].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
						  cond->operands = g_slist_append (cond->operands, yymsp[-2].minor.yy328);
						  GDA_SQL_ANY_PART (yymsp[-2].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
						  cond->operands = g_slist_append (cond->operands, yymsp[0].minor.yy328);
						  GDA_SQL_ANY_PART (yymsp[0].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(75,&yymsp[-3].minor);
  yy_destructor(67,&yymsp[-1].minor);
}
#line 3187 "parser.c"
        break;
      case 158: /* expr ::= expr NOT BETWEEN expr AND expr */
#line 838 "./parser.y"
{GdaSqlOperation *cond;
						      GdaSqlExpr *expr;
						      expr = gda_sql_expr_new (NULL);
						      cond = gda_sql_operation_new (GDA_SQL_ANY_PART (expr));
						      expr->cond = cond;
						      cond->operator_type = GDA_SQL_OPERATOR_TYPE_BETWEEN;
						      cond->operands = g_slist_append (NULL, yymsp[-5].minor.yy328);
						      GDA_SQL_ANY_PART (yymsp[-5].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
						      cond->operands = g_slist_append (cond->operands, yymsp[-2].minor.yy328);
						      GDA_SQL_ANY_PART (yymsp[-2].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
						      cond->operands = g_slist_append (cond->operands, yymsp[0].minor.yy328);
						      GDA_SQL_ANY_PART (yymsp[0].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);

						      yygotominor.yy328 = gda_sql_expr_new (NULL);
						      cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
						      yygotominor.yy328->cond = cond;
						      cond->operator_type = GDA_SQL_OPERATOR_TYPE_NOT;
						      cond->operands = g_slist_prepend (NULL, expr);
						      GDA_SQL_ANY_PART (expr)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(68,&yymsp[-4].minor);
  yy_destructor(75,&yymsp[-3].minor);
  yy_destructor(67,&yymsp[-1].minor);
}
#line 3214 "parser.c"
        break;
      case 159: /* expr ::= NOT expr */
#line 859 "./parser.y"
{yygotominor.yy328 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_NOT, yymsp[0].minor.yy328);  yy_destructor(68,&yymsp[-1].minor);
}
#line 3220 "parser.c"
        break;
      case 160: /* expr ::= BITNOT expr */
#line 860 "./parser.y"
{yygotominor.yy328 = create_uni_expr (GDA_SQL_OPERATOR_TYPE_BITNOT, yymsp[0].minor.yy328);  yy_destructor(99,&yymsp[-1].minor);
}
#line 3226 "parser.c"
        break;
      case 161: /* expr ::= expr uni_op */
#line 861 "./parser.y"
{yygotominor.yy328 = create_uni_expr (yymsp[0].minor.yy381, yymsp[-1].minor.yy328);}
#line 3231 "parser.c"
        break;
      case 162: /* expr ::= expr IS expr */
#line 863 "./parser.y"
{yygotominor.yy328 = create_two_expr (GDA_SQL_OPERATOR_TYPE_IS, yymsp[-2].minor.yy328, yymsp[0].minor.yy328);  yy_destructor(69,&yymsp[-1].minor);
}
#line 3237 "parser.c"
        break;
      case 163: /* expr ::= LP compound RP */
#line 864 "./parser.y"
{yygotominor.yy328 = gda_sql_expr_new (NULL); gda_sql_expr_take_select (yygotominor.yy328, yymsp[-1].minor.yy308);  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 3244 "parser.c"
        break;
      case 164: /* expr ::= expr IN LP exprlist RP */
#line 865 "./parser.y"
{GdaSqlOperation *cond;
					   GSList *list;
					   yygotominor.yy328 = gda_sql_expr_new (NULL);
					   cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
					   yygotominor.yy328->cond = cond;
					   cond->operator_type = GDA_SQL_OPERATOR_TYPE_IN;
					   cond->operands = g_slist_prepend (yymsp[-1].minor.yy247, yymsp[-4].minor.yy328);
					   for (list = cond->operands; list; list = list->next)
						   GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(70,&yymsp[-3].minor);
  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 3261 "parser.c"
        break;
      case 165: /* expr ::= expr IN LP compound RP */
#line 875 "./parser.y"
{GdaSqlOperation *cond;
					    GdaSqlExpr *expr;
					    yygotominor.yy328 = gda_sql_expr_new (NULL);
					    cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
					    yygotominor.yy328->cond = cond;
					    cond->operator_type = GDA_SQL_OPERATOR_TYPE_IN;
					    
					    expr = gda_sql_expr_new (GDA_SQL_ANY_PART (cond));
					    gda_sql_expr_take_select (expr, yymsp[-1].minor.yy308);
					    cond->operands = g_slist_prepend (NULL, expr);
					    cond->operands = g_slist_prepend (cond->operands, yymsp[-4].minor.yy328);
					    GDA_SQL_ANY_PART (yymsp[-4].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(70,&yymsp[-3].minor);
  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 3281 "parser.c"
        break;
      case 166: /* expr ::= expr NOT IN LP exprlist RP */
#line 888 "./parser.y"
{GdaSqlOperation *cond;
					       GSList *list;
					       yygotominor.yy328 = gda_sql_expr_new (NULL);
					       cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
					       yygotominor.yy328->cond = cond;
					       cond->operator_type = GDA_SQL_OPERATOR_TYPE_NOTIN;
					       cond->operands = g_slist_prepend (yymsp[-1].minor.yy247, yymsp[-5].minor.yy328);
					       for (list = cond->operands; list; list = list->next)
						       GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(68,&yymsp[-4].minor);
  yy_destructor(70,&yymsp[-3].minor);
  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 3299 "parser.c"
        break;
      case 167: /* expr ::= expr NOT IN LP compound RP */
#line 898 "./parser.y"
{GdaSqlOperation *cond;
					       GdaSqlExpr *expr;
					       yygotominor.yy328 = gda_sql_expr_new (NULL);
					       cond = gda_sql_operation_new (GDA_SQL_ANY_PART (yygotominor.yy328));
					       yygotominor.yy328->cond = cond;
					       cond->operator_type = GDA_SQL_OPERATOR_TYPE_NOTIN;
					       
					       expr = gda_sql_expr_new (GDA_SQL_ANY_PART (cond));
					       gda_sql_expr_take_select (expr, yymsp[-1].minor.yy308);
					       cond->operands = g_slist_prepend (NULL, expr);
					       cond->operands = g_slist_prepend (cond->operands, yymsp[-5].minor.yy328);
					       GDA_SQL_ANY_PART (yymsp[-5].minor.yy328)->parent = GDA_SQL_ANY_PART (cond);
  yy_destructor(68,&yymsp[-4].minor);
  yy_destructor(70,&yymsp[-3].minor);
  yy_destructor(100,&yymsp[-2].minor);
  yy_destructor(101,&yymsp[0].minor);
}
#line 3320 "parser.c"
        break;
      case 168: /* expr ::= CASE case_operand case_exprlist case_else END */
#line 911 "./parser.y"
{
	GdaSqlCase *sc;
	GSList *list;
	yygotominor.yy328 = gda_sql_expr_new (NULL);
	sc = gda_sql_case_new (GDA_SQL_ANY_PART (yygotominor.yy328));
	sc->base_expr = yymsp[-3].minor.yy122;
	sc->else_expr = yymsp[-1].minor.yy122;
	sc->when_expr_list = yymsp[-2].minor.yy263.when_list;
	sc->then_expr_list = yymsp[-2].minor.yy263.then_list;
	yygotominor.yy328->case_s = sc;
	for (list = sc->when_expr_list; list; list = list->next)
		GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (sc);
	for (list = sc->then_expr_list; list; list = list->next)
		GDA_SQL_ANY_PART (list->data)->parent = GDA_SQL_ANY_PART (sc);
  yy_destructor(143,&yymsp[-4].minor);
  yy_destructor(17,&yymsp[0].minor);
}
#line 3341 "parser.c"
        break;
      case 169: /* case_operand ::= expr */
#line 929 "./parser.y"
{yygotominor.yy122 = yymsp[0].minor.yy328;}
#line 3346 "parser.c"
        break;
      case 170: /* case_operand ::= */
      case 174: /* case_else ::= */
#line 930 "./parser.y"
{yygotominor.yy122 = NULL;}
#line 3352 "parser.c"
        break;
      case 171: /* case_exprlist ::= case_exprlist WHEN expr THEN expr */
#line 936 "./parser.y"
{
	yygotominor.yy263.when_list = g_slist_append (yymsp[-4].minor.yy263.when_list, yymsp[-2].minor.yy328);
	yygotominor.yy263.then_list = g_slist_append (yymsp[-4].minor.yy263.then_list, yymsp[0].minor.yy328);
  yy_destructor(144,&yymsp[-3].minor);
  yy_destructor(145,&yymsp[-1].minor);
}
#line 3362 "parser.c"
        break;
      case 172: /* case_exprlist ::= WHEN expr THEN expr */
#line 940 "./parser.y"
{
	yygotominor.yy263.when_list = g_slist_prepend (NULL, yymsp[-2].minor.yy328);
	yygotominor.yy263.then_list = g_slist_prepend (NULL, yymsp[0].minor.yy328);
  yy_destructor(144,&yymsp[-3].minor);
  yy_destructor(145,&yymsp[-1].minor);
}
#line 3372 "parser.c"
        break;
      case 173: /* case_else ::= ELSE expr */
#line 947 "./parser.y"
{yygotominor.yy122 = yymsp[0].minor.yy328;  yy_destructor(146,&yymsp[-1].minor);
}
#line 3378 "parser.c"
        break;
      case 175: /* uni_op ::= ISNULL */
#line 951 "./parser.y"
{yygotominor.yy381 = GDA_SQL_OPERATOR_TYPE_ISNULL;  yy_destructor(71,&yymsp[0].minor);
}
#line 3384 "parser.c"
        break;
      case 176: /* uni_op ::= IS NOTNULL */
#line 952 "./parser.y"
{yygotominor.yy381 = GDA_SQL_OPERATOR_TYPE_ISNOTNULL;  yy_destructor(69,&yymsp[-1].minor);
  yy_destructor(72,&yymsp[0].minor);
}
#line 3391 "parser.c"
        break;
      case 177: /* value ::= NULL */
#line 956 "./parser.y"
{yygotominor.yy361 = NULL;  yy_destructor(147,&yymsp[0].minor);
}
#line 3397 "parser.c"
        break;
      case 181: /* pvalue ::= UNSPECVAL LSBRACKET paramspec RSBRACKET */
#line 965 "./parser.y"
{yygotominor.yy328 = gda_sql_expr_new (NULL); yygotominor.yy328->param_spec = yymsp[-1].minor.yy405;  yy_destructor(149,&yymsp[-3].minor);
  yy_destructor(150,&yymsp[-2].minor);
  yy_destructor(151,&yymsp[0].minor);
}
#line 3405 "parser.c"
        break;
      case 182: /* pvalue ::= value LSBRACKET paramspec RSBRACKET */
#line 966 "./parser.y"
{yygotominor.yy328 = gda_sql_expr_new (NULL); yygotominor.yy328->value = yymsp[-3].minor.yy361; yygotominor.yy328->param_spec = yymsp[-1].minor.yy405;  yy_destructor(150,&yymsp[-2].minor);
  yy_destructor(151,&yymsp[0].minor);
}
#line 3412 "parser.c"
        break;
      case 183: /* pvalue ::= SIMPLEPARAM */
#line 967 "./parser.y"
{yygotominor.yy328 = gda_sql_expr_new (NULL); yygotominor.yy328->param_spec = gda_sql_param_spec_new (yymsp[0].minor.yy0);}
#line 3417 "parser.c"
        break;
      case 184: /* paramspec ::= */
#line 972 "./parser.y"
{yygotominor.yy405 = NULL;}
#line 3422 "parser.c"
        break;
      case 185: /* paramspec ::= paramspec PNAME */
#line 973 "./parser.y"
{if (!yymsp[-1].minor.yy405) yygotominor.yy405 = gda_sql_param_spec_new (NULL); else yygotominor.yy405 = yymsp[-1].minor.yy405; 
					 gda_sql_param_spec_take_name (yygotominor.yy405, yymsp[0].minor.yy0);}
#line 3428 "parser.c"
        break;
      case 186: /* paramspec ::= paramspec PDESCR */
#line 975 "./parser.y"
{if (!yymsp[-1].minor.yy405) yygotominor.yy405 = gda_sql_param_spec_new (NULL); else yygotominor.yy405 = yymsp[-1].minor.yy405; 
					 gda_sql_param_spec_take_descr (yygotominor.yy405, yymsp[0].minor.yy0);}
#line 3434 "parser.c"
        break;
      case 187: /* paramspec ::= paramspec PTYPE */
#line 977 "./parser.y"
{if (!yymsp[-1].minor.yy405) yygotominor.yy405 = gda_sql_param_spec_new (NULL); else yygotominor.yy405 = yymsp[-1].minor.yy405; 
					 gda_sql_param_spec_take_type (yygotominor.yy405, yymsp[0].minor.yy0);}
#line 3440 "parser.c"
        break;
      case 188: /* paramspec ::= paramspec PNULLOK */
#line 979 "./parser.y"
{if (!yymsp[-1].minor.yy405) yygotominor.yy405 = gda_sql_param_spec_new (NULL); else yygotominor.yy405 = yymsp[-1].minor.yy405; 
					   gda_sql_param_spec_take_nullok (yygotominor.yy405, yymsp[0].minor.yy0);}
#line 3446 "parser.c"
        break;
      case 193: /* fullname ::= nm DOT nm */
#line 990 "./parser.y"
{gchar *str;
				  str = g_strdup_printf ("%s.%s", g_value_get_string (yymsp[-2].minor.yy361), g_value_get_string (yymsp[0].minor.yy361));
				  yygotominor.yy361 = g_new0 (GValue, 1);
				  g_value_init (yygotominor.yy361, G_TYPE_STRING);
				  g_value_take_string (yygotominor.yy361, str);
				  g_value_reset (yymsp[-2].minor.yy361); g_free (yymsp[-2].minor.yy361);
				  g_value_reset (yymsp[0].minor.yy361); g_free (yymsp[0].minor.yy361);
  yy_destructor(140,&yymsp[-1].minor);
}
#line 3459 "parser.c"
        break;
      case 194: /* fullname ::= nm DOT nm DOT nm */
#line 999 "./parser.y"
{gchar *str;
				  str = g_strdup_printf ("%s.%s.%s", g_value_get_string (yymsp[-4].minor.yy361), 
							 g_value_get_string (yymsp[-2].minor.yy361), g_value_get_string (yymsp[0].minor.yy361));
				  yygotominor.yy361 = g_new0 (GValue, 1);
				  g_value_init (yygotominor.yy361, G_TYPE_STRING);
				  g_value_take_string (yygotominor.yy361, str);
				  g_value_reset (yymsp[-4].minor.yy361); g_free (yymsp[-4].minor.yy361);
				  g_value_reset (yymsp[-2].minor.yy361); g_free (yymsp[-2].minor.yy361);
				  g_value_reset (yymsp[0].minor.yy361); g_free (yymsp[0].minor.yy361);
  yy_destructor(140,&yymsp[-3].minor);
  yy_destructor(140,&yymsp[-1].minor);
}
#line 3475 "parser.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  gda_lemon_oracle_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  gda_lemon_oracle_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  gda_lemon_oracle_parserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 22 "./parser.y"

	gda_sql_parser_set_syntax_error (pdata->parser);
#line 3537 "parser.c"
  gda_lemon_oracle_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  gda_lemon_oracle_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  gda_lemon_oracle_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "gda_lemon_oracle_parserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void gda_lemon_oracle_parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  gda_lemon_oracle_parserTOKENTYPE yyminor       /* The value for the token */
  gda_lemon_oracle_parserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      memset(&yyminorunion, 0, sizeof(yyminorunion));
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  gda_lemon_oracle_parserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      assert( !yyendofinput );  /* Impossible to shift the $ token */
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
