/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 28 "../../../providers/default/sqlite/parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** A structure for holding two integers
*/
struct twoint { int a,b; };

#line 18 "../../../providers/default/sqlite/parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqliteParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqliteParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqliteParserARGDECL       is a declaration of a 3rd argument to the
**                       parser, or null if there is no extra argument.
**    sqliteParserKRARGDECL     A version of sqliteParserARGDECL for K&R C.
**    sqliteParserANSIARGDECL   A version of sqliteParserARGDECL for ANSI C.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
/*  */
#define YYCODETYPE unsigned char
#define YYNOCODE 153
#define YYACTIONTYPE int
#define sqliteParserTOKENTYPE Token
typedef union {
  sqliteParserTOKENTYPE yy0;
  struct twoint yy79;
  IdList* yy162;
  ExprList* yy192;
  Expr* yy210;
  Select* yy219;
  int yy236;
  Token yy258;
  int yy305;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqliteParserARGDECL ,pParse
#define sqliteParserXARGDECL Parse *pParse;
#define sqliteParserANSIARGDECL ,Parse *pParse
#define YYNSTATE 358
#define YYNRULE 208
#define YYERRORSYMBOL 109
#define YYERRSYMDT yy305
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)
/* Next is the action table.  Each entry in this table contains
**
**  +  An integer which is the number representing the look-ahead
**     token
**
**  +  An integer indicating what action to take.  Number (N) between
**     0 and YYNSTATE-1 mean shift the look-ahead and go to state N.
**     Numbers between YYNSTATE and YYNSTATE+YYNRULE-1 mean reduce by
**     rule N-YYNSTATE.  Number YYNSTATE+YYNRULE means that a syntax
**     error has occurred.  Number YYNSTATE+YYNRULE+1 means the parser
**     accepts its input.
**
**  +  A pointer to the next entry with the same hash value.
**
** The action table is really a series of hash tables.  Each hash
** table contains a number of entries which is a power of two.  The
** "state" table (which follows) contains information about the starting
** point and size of each hash table.
*/
struct yyActionEntry {
  YYCODETYPE   lookahead;   /* The value of the look-ahead token */
  YYACTIONTYPE action;      /* Action to take for this look-ahead */
  struct yyActionEntry *next; /* Next look-ahead with the same hash, or NULL */
};
static struct yyActionEntry yyActionTable[] = {
/* State 0 */
  {  99,   1, 0                    }, /*                cmdlist shift  1 */
  {  33, 356, 0                    }, /*                EXPLAIN shift  356 */
  {  98, 355, 0                    }, /*                    cmd shift  355 */
  { 131,  60, &yyActionTable[   0] }, /*              oneselect shift  60 */
  { 105,  30, 0                    }, /*           create_table shift  30 */
  {  69, 338, 0                    }, /*                 PRAGMA shift  338 */
  {   6,   6, 0                    }, /*                  BEGIN shift  6 */
  {  46, 301, 0                    }, /*                 INSERT shift  301 */
  {  72,  28, 0                    }, /*               ROLLBACK shift  28 */
  { 137, 284, &yyActionTable[   4] }, /*                 select shift  284 */
  {  89, 289, 0                    }, /*                 UPDATE shift  289 */
  {  75,  64, 0                    }, /*                 SELECT shift  64 */
  { 108, 357, 0                    }, /*                   ecmd shift  357 */
  {YYNOCODE,0,0}, /* Unused */
  { 110,   4, &yyActionTable[   7] }, /*                explain shift  4 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  17,  24, 0                    }, /*                 COMMIT shift  24 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  20, 329, 0                    }, /*                   COPY shift  329 */
  {  21, 265, 0                    }, /*                 CREATE shift  265 */
  {YYNOCODE,0,0}, /* Unused */
  {  23, 285, 0                    }, /*                 DELETE shift  285 */
  {YYNOCODE,0,0}, /* Unused */
  { 121, 567, &yyActionTable[  10] }, /*                  input accept */
  {YYNOCODE,0,0}, /* Unused */
  {  91, 336, 0                    }, /*                 VACUUM shift  336 */
  {  28, 279, 0                    }, /*                   DROP shift  279 */
  {  29,  26, 0                    }, /*                    END shift  26 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 1 */
  {  76,   2, &yyActionTable[  33] }, /*                   SEMI shift  2 */
  {   0, 358, 0                    }, /*                      $ reduce 0 */
/* State 2 */
  { 105,  30, 0                    }, /*           create_table shift  30 */
  {  33, 356, 0                    }, /*                EXPLAIN shift  356 */
  {  98, 355, 0                    }, /*                    cmd shift  355 */
  { 131,  60, 0                    }, /*              oneselect shift  60 */
  {  46, 301, 0                    }, /*                 INSERT shift  301 */
  {  69, 338, 0                    }, /*                 PRAGMA shift  338 */
  {   6,   6, 0                    }, /*                  BEGIN shift  6 */
  {YYNOCODE,0,0}, /* Unused */
  {  72,  28, 0                    }, /*               ROLLBACK shift  28 */
  { 137, 284, &yyActionTable[  34] }, /*                 select shift  284 */
  {YYNOCODE,0,0}, /* Unused */
  {  75,  64, 0                    }, /*                 SELECT shift  64 */
  { 108,   3, 0                    }, /*                   ecmd shift  3 */
  {YYNOCODE,0,0}, /* Unused */
  { 110,   4, &yyActionTable[  38] }, /*                explain shift  4 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  17,  24, 0                    }, /*                 COMMIT shift  24 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  20, 329, 0                    }, /*                   COPY shift  329 */
  {  21, 265, 0                    }, /*                 CREATE shift  265 */
  {YYNOCODE,0,0}, /* Unused */
  {  23, 285, 0                    }, /*                 DELETE shift  285 */
  {YYNOCODE,0,0}, /* Unused */
  {  89, 289, 0                    }, /*                 UPDATE shift  289 */
  {YYNOCODE,0,0}, /* Unused */
  {  91, 336, 0                    }, /*                 VACUUM shift  336 */
  {  28, 279, 0                    }, /*                   DROP shift  279 */
  {  29,  26, 0                    }, /*                    END shift  26 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 3 */
  {YYNOCODE,0,0}, /* Unused */
/* State 4 */
  { 105,  30, 0                    }, /*           create_table shift  30 */
  {YYNOCODE,0,0}, /* Unused */
  {  98,   5, 0                    }, /*                    cmd shift  5 */
  { 131,  60, 0                    }, /*              oneselect shift  60 */
  {YYNOCODE,0,0}, /* Unused */
  {  69, 338, 0                    }, /*                 PRAGMA shift  338 */
  {   6,   6, 0                    }, /*                  BEGIN shift  6 */
  {YYNOCODE,0,0}, /* Unused */
  {  72,  28, 0                    }, /*               ROLLBACK shift  28 */
  { 137, 284, &yyActionTable[  67] }, /*                 select shift  284 */
  {YYNOCODE,0,0}, /* Unused */
  {  75,  64, 0                    }, /*                 SELECT shift  64 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  46, 301, 0                    }, /*                 INSERT shift  301 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  17,  24, 0                    }, /*                 COMMIT shift  24 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  20, 329, 0                    }, /*                   COPY shift  329 */
  {  21, 265, 0                    }, /*                 CREATE shift  265 */
  {YYNOCODE,0,0}, /* Unused */
  {  23, 285, 0                    }, /*                 DELETE shift  285 */
  {YYNOCODE,0,0}, /* Unused */
  {  89, 289, 0                    }, /*                 UPDATE shift  289 */
  {YYNOCODE,0,0}, /* Unused */
  {  91, 336, 0                    }, /*                 VACUUM shift  336 */
  {  28, 279, 0                    }, /*                   DROP shift  279 */
  {  29,  26, 0                    }, /*                    END shift  26 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 5 */
  {YYNOCODE,0,0}, /* Unused */
/* State 6 */
  {  84,   8, 0                    }, /*            TRANSACTION shift  8 */
  { 147,   7, 0                    }, /*              trans_opt shift  7 */
/* State 7 */
  {YYNOCODE,0,0}, /* Unused */
/* State 8 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  81,  23, &yyActionTable[ 105] }, /*                 STRING shift  23 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  69,  17, &yyActionTable[ 110] }, /*                 PRAGMA shift  17 */
  { 117,  22, &yyActionTable[ 107] }, /*                     id shift  22 */
  { 118,   9, &yyActionTable[ 115] }, /*                    ids shift  9 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  29,  16, &yyActionTable[ 117] }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
/* State 9 */
  {YYNOCODE,0,0}, /* Unused */
/* State 10 */
  {YYNOCODE,0,0}, /* Unused */
/* State 11 */
  {YYNOCODE,0,0}, /* Unused */
/* State 12 */
  {YYNOCODE,0,0}, /* Unused */
/* State 13 */
  {YYNOCODE,0,0}, /* Unused */
/* State 14 */
  {YYNOCODE,0,0}, /* Unused */
/* State 15 */
  {YYNOCODE,0,0}, /* Unused */
/* State 16 */
  {YYNOCODE,0,0}, /* Unused */
/* State 17 */
  {YYNOCODE,0,0}, /* Unused */
/* State 18 */
  {YYNOCODE,0,0}, /* Unused */
/* State 19 */
  {YYNOCODE,0,0}, /* Unused */
/* State 20 */
  {YYNOCODE,0,0}, /* Unused */
/* State 21 */
  {YYNOCODE,0,0}, /* Unused */
/* State 22 */
  {YYNOCODE,0,0}, /* Unused */
/* State 23 */
  {YYNOCODE,0,0}, /* Unused */
/* State 24 */
  {  84,   8, 0                    }, /*            TRANSACTION shift  8 */
  { 147,  25, 0                    }, /*              trans_opt shift  25 */
/* State 25 */
  {YYNOCODE,0,0}, /* Unused */
/* State 26 */
  {  84,   8, 0                    }, /*            TRANSACTION shift  8 */
  { 147,  27, 0                    }, /*              trans_opt shift  27 */
/* State 27 */
  {YYNOCODE,0,0}, /* Unused */
/* State 28 */
  {  84,   8, 0                    }, /*            TRANSACTION shift  8 */
  { 147,  29, 0                    }, /*              trans_opt shift  29 */
/* State 29 */
  {YYNOCODE,0,0}, /* Unused */
/* State 30 */
  { 106,  31, &yyActionTable[ 144] }, /*      create_table_args shift  31 */
  {  56,  32, 0                    }, /*                     LP shift  32 */
/* State 31 */
  {YYNOCODE,0,0}, /* Unused */
/* State 32 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  69,  17, &yyActionTable[ 149] }, /*                 PRAGMA shift  17 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  { 100, 264, 0                    }, /*                 column shift  264 */
  { 101,  38, &yyActionTable[ 148] }, /*               columnid shift  38 */
  { 102,  33, &yyActionTable[ 153] }, /*             columnlist shift  33 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  23, 0                    }, /*                 STRING shift  23 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  22, 0                    }, /*                     id shift  22 */
  { 118, 241, 0                    }, /*                    ids shift  241 */
  {YYNOCODE,0,0}, /* Unused */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 33 */
  { 104,  34, 0                    }, /*           conslist_opt shift  34 */
  {  73, 421, 0                    }, /*                     RP reduce 63 */
  {YYNOCODE,0,0}, /* Unused */
  {  15,  36, 0                    }, /*                  COMMA shift  36 */
/* State 34 */
  {  73,  35, 0                    }, /*                     RP shift  35 */
/* State 35 */
  {YYNOCODE,0,0}, /* Unused */
/* State 36 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  69,  17, &yyActionTable[ 187] }, /*                 PRAGMA shift  17 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  { 100,  37, 0                    }, /*                 column shift  37 */
  { 101,  38, &yyActionTable[ 186] }, /*               columnid shift  38 */
  {  70, 247, &yyActionTable[ 192] }, /*                PRIMARY shift  247 */
  { 103, 242, 0                    }, /*               conslist shift  242 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  81,  23, 0                    }, /*                 STRING shift  23 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {  19, 245, 0                    }, /*             CONSTRAINT shift  245 */
  {  12, 260, 0                    }, /*                  CHECK shift  260 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  { 145, 263, &yyActionTable[ 193] }, /*                  tcons shift  263 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, &yyActionTable[ 195] }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  22, 0                    }, /*                     id shift  22 */
  { 118, 241, 0                    }, /*                    ids shift  241 */
  {YYNOCODE,0,0}, /* Unused */
  {  88, 256, &yyActionTable[ 198] }, /*                 UNIQUE shift  256 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 37 */
  {YYNOCODE,0,0}, /* Unused */
/* State 38 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  { 117,  22, 0                    }, /*                     id shift  22 */
  {YYNOCODE,0,0}, /* Unused */
  {  69,  17, &yyActionTable[ 219] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  23, 0                    }, /*                 STRING shift  23 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  { 148,  39, 0                    }, /*                   type shift  39 */
  { 149, 227, &yyActionTable[ 220] }, /*               typename shift  227 */
  { 118, 240, 0                    }, /*                    ids shift  240 */
  {YYNOCODE,0,0}, /* Unused */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 39 */
  {  96,  40, 0                    }, /*               carglist shift  40 */
/* State 40 */
  {  88,  52, 0                    }, /*                 UNIQUE shift  52 */
  {  97, 214, 0                    }, /*                  ccons shift  214 */
  {  22, 215, 0                    }, /*                DEFAULT shift  215 */
  {  19,  42, 0                    }, /*             CONSTRAINT shift  42 */
  {  12,  53, 0                    }, /*                  CHECK shift  53 */
  {  61,  45, 0                    }, /*                    NOT shift  45 */
  {  70,  47, &yyActionTable[ 252] }, /*                PRIMARY shift  47 */
  {  95,  41, 0                    }, /*                   carg shift  41 */
/* State 41 */
  {YYNOCODE,0,0}, /* Unused */
/* State 42 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  81,  23, &yyActionTable[ 261] }, /*                 STRING shift  23 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  69,  17, &yyActionTable[ 266] }, /*                 PRAGMA shift  17 */
  { 117,  22, &yyActionTable[ 263] }, /*                     id shift  22 */
  { 118,  43, &yyActionTable[ 271] }, /*                    ids shift  43 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  29,  16, &yyActionTable[ 273] }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
/* State 43 */
  {  88,  52, 0                    }, /*                 UNIQUE shift  52 */
  {  97,  44, 0                    }, /*                  ccons shift  44 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  12,  53, 0                    }, /*                  CHECK shift  53 */
  {  61,  45, 0                    }, /*                    NOT shift  45 */
  {  70,  47, 0                    }, /*                PRIMARY shift  47 */
  {YYNOCODE,0,0}, /* Unused */
/* State 44 */
  {YYNOCODE,0,0}, /* Unused */
/* State 45 */
  {  63,  46, 0                    }, /*                   NULL shift  46 */
/* State 46 */
  {YYNOCODE,0,0}, /* Unused */
/* State 47 */
  {  52,  48, 0                    }, /*                    KEY shift  48 */
/* State 48 */
  {   5,  50, 0                    }, /*                    ASC shift  50 */
  {  25,  51, &yyActionTable[ 287] }, /*                   DESC shift  51 */
  {YYNOCODE,0,0}, /* Unused */
  { 143,  49, 0                    }, /*              sortorder shift  49 */
/* State 49 */
  {YYNOCODE,0,0}, /* Unused */
/* State 50 */
  {YYNOCODE,0,0}, /* Unused */
/* State 51 */
  {YYNOCODE,0,0}, /* Unused */
/* State 52 */
  {YYNOCODE,0,0}, /* Unused */
/* State 53 */
  {  56,  54, 0                    }, /*                     LP shift  54 */
/* State 54 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[ 299] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 212, &yyActionTable[ 303] }, /*                   expr shift  212 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[ 304] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[ 307] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[ 308] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 55 */
  {  56,  56, 0                    }, /*                     LP shift  56 */
/* State 56 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[ 332] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  80, 210, 0                    }, /*                   STAR shift  210 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  { 111, 153, &yyActionTable[ 336] }, /*                   expr shift  153 */
  { 112, 166, &yyActionTable[ 337] }, /*               expritem shift  166 */
  { 113, 208, &yyActionTable[ 340] }, /*               exprlist shift  208 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[ 341] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[ 343] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[ 347] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 57 */
  {  64, 495, &yyActionTable[ 362] }, /*                 OFFSET reduce 137 */
  {   0, 495, 0                    }, /*                      $ reduce 137 */
  {  66, 495, 0                    }, /*                     OR reduce 137 */
  {  67, 495, &yyActionTable[ 372] }, /*                  ORDER reduce 137 */
  {  68, 495, &yyActionTable[ 381] }, /*                   PLUS reduce 137 */
  {  69, 495, &yyActionTable[ 382] }, /*                 PRAGMA reduce 137 */
  {  70, 495, &yyActionTable[ 383] }, /*                PRIMARY reduce 137 */
  {  71, 495, &yyActionTable[ 387] }, /*                    REM reduce 137 */
  {   8, 495, 0                    }, /*                 BITAND reduce 137 */
  {  73, 495, 0                    }, /*                     RP reduce 137 */
  {  74, 495, &yyActionTable[ 389] }, /*                 RSHIFT reduce 137 */
  {   3, 495, 0                    }, /*                    AND reduce 137 */
  {  76, 495, &yyActionTable[ 391] }, /*                   SEMI reduce 137 */
  {  13, 495, 0                    }, /*                CLUSTER reduce 137 */
  {  78, 495, 0                    }, /*                  SLASH reduce 137 */
  {  15, 495, 0                    }, /*                  COMMA reduce 137 */
  {  80, 495, 0                    }, /*                   STAR reduce 137 */
  {  81, 495, 0                    }, /*                 STRING reduce 137 */
  {  18, 495, 0                    }, /*                 CONCAT reduce 137 */
  {  83, 495, &yyActionTable[ 395] }, /*                   TEMP reduce 137 */
  {   4, 495, 0                    }, /*                     AS reduce 137 */
  {   5, 495, 0                    }, /*                    ASC reduce 137 */
  {   6, 495, 0                    }, /*                  BEGIN reduce 137 */
  {  87, 495, 0                    }, /*                  UNION reduce 137 */
  {  88, 495, &yyActionTable[ 397] }, /*                 UNIQUE reduce 137 */
  {  25, 495, 0                    }, /*                   DESC reduce 137 */
  {   7, 495, 0                    }, /*                BETWEEN reduce 137 */
  {  91, 495, &yyActionTable[ 404] }, /*                 VACUUM reduce 137 */
  {  10, 495, 0                    }, /*                  BITOR reduce 137 */
  {  93, 495, &yyActionTable[ 406] }, /*                  WHERE reduce 137 */
  {  12, 495, 0                    }, /*                  CHECK reduce 137 */
  {  31, 495, 0                    }, /*                     EQ reduce 137 */
  {  32, 495, 0                    }, /*                 EXCEPT reduce 137 */
  {  33, 495, 0                    }, /*                EXPLAIN reduce 137 */
  {  19, 495, 0                    }, /*             CONSTRAINT reduce 137 */
  {  35, 495, 0                    }, /*                   FROM reduce 137 */
  {  24, 495, 0                    }, /*             DELIMITERS reduce 137 */
  {  37, 495, 0                    }, /*                     GE reduce 137 */
  {  38, 495, 0                    }, /*                   GLOB reduce 137 */
  {  39, 495, 0                    }, /*                  GROUP reduce 137 */
  {  40, 495, 0                    }, /*                     GT reduce 137 */
  {  41, 495, 0                    }, /*                 HAVING reduce 137 */
  {  42, 495, 0                    }, /*                     ID reduce 137 */
  {  27, 393, 0                    }, /*                    DOT reduce 35 */
  {  44, 495, 0                    }, /*                     IN reduce 137 */
  {  29, 495, 0                    }, /*                    END reduce 137 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  48, 495, 0                    }, /*              INTERSECT reduce 137 */
  {YYNOCODE,0,0}, /* Unused */
  {  50, 495, 0                    }, /*                     IS reduce 137 */
  {  51, 495, 0                    }, /*                 ISNULL reduce 137 */
  {YYNOCODE,0,0}, /* Unused */
  {  53, 495, 0                    }, /*                     LE reduce 137 */
  {  54, 495, 0                    }, /*                   LIKE reduce 137 */
  {  55, 495, 0                    }, /*                  LIMIT reduce 137 */
  {YYNOCODE,0,0}, /* Unused */
  {  57, 495, 0                    }, /*                 LSHIFT reduce 137 */
  {  58, 495, 0                    }, /*                     LT reduce 137 */
  {  59, 495, 0                    }, /*                  MINUS reduce 137 */
  {  60, 495, 0                    }, /*                     NE reduce 137 */
  {  61, 495, 0                    }, /*                    NOT reduce 137 */
  {  62, 495, 0                    }, /*                NOTNULL reduce 137 */
  {YYNOCODE,0,0}, /* Unused */
/* State 58 */
  {  64, 499, &yyActionTable[ 426] }, /*                 OFFSET reduce 141 */
  {   0, 499, 0                    }, /*                      $ reduce 141 */
  {  66, 499, 0                    }, /*                     OR reduce 141 */
  {  67, 499, &yyActionTable[ 436] }, /*                  ORDER reduce 141 */
  {  68, 499, &yyActionTable[ 445] }, /*                   PLUS reduce 141 */
  {  69, 499, &yyActionTable[ 446] }, /*                 PRAGMA reduce 141 */
  {  70, 499, &yyActionTable[ 447] }, /*                PRIMARY reduce 141 */
  {  71, 499, &yyActionTable[ 451] }, /*                    REM reduce 141 */
  {   8, 499, 0                    }, /*                 BITAND reduce 141 */
  {  73, 499, 0                    }, /*                     RP reduce 141 */
  {  74, 499, &yyActionTable[ 453] }, /*                 RSHIFT reduce 141 */
  {   3, 499, 0                    }, /*                    AND reduce 141 */
  {  76, 499, &yyActionTable[ 455] }, /*                   SEMI reduce 141 */
  {  13, 499, 0                    }, /*                CLUSTER reduce 141 */
  {  78, 499, 0                    }, /*                  SLASH reduce 141 */
  {  15, 499, 0                    }, /*                  COMMA reduce 141 */
  {  80, 499, 0                    }, /*                   STAR reduce 141 */
  {  81, 499, 0                    }, /*                 STRING reduce 141 */
  {  18, 499, 0                    }, /*                 CONCAT reduce 141 */
  {  83, 499, &yyActionTable[ 459] }, /*                   TEMP reduce 141 */
  {   4, 499, 0                    }, /*                     AS reduce 141 */
  {   5, 499, 0                    }, /*                    ASC reduce 141 */
  {   6, 499, 0                    }, /*                  BEGIN reduce 141 */
  {  87, 499, 0                    }, /*                  UNION reduce 141 */
  {  88, 499, &yyActionTable[ 461] }, /*                 UNIQUE reduce 141 */
  {  25, 499, 0                    }, /*                   DESC reduce 141 */
  {   7, 499, 0                    }, /*                BETWEEN reduce 141 */
  {  91, 499, &yyActionTable[ 468] }, /*                 VACUUM reduce 141 */
  {  10, 499, 0                    }, /*                  BITOR reduce 141 */
  {  93, 499, &yyActionTable[ 470] }, /*                  WHERE reduce 141 */
  {  12, 499, 0                    }, /*                  CHECK reduce 141 */
  {  31, 499, 0                    }, /*                     EQ reduce 141 */
  {  32, 499, 0                    }, /*                 EXCEPT reduce 141 */
  {  33, 499, 0                    }, /*                EXPLAIN reduce 141 */
  {  19, 499, 0                    }, /*             CONSTRAINT reduce 141 */
  {  35, 499, 0                    }, /*                   FROM reduce 141 */
  {  24, 499, 0                    }, /*             DELIMITERS reduce 141 */
  {  37, 499, 0                    }, /*                     GE reduce 141 */
  {  38, 499, 0                    }, /*                   GLOB reduce 141 */
  {  39, 499, 0                    }, /*                  GROUP reduce 141 */
  {  40, 499, 0                    }, /*                     GT reduce 141 */
  {  41, 499, 0                    }, /*                 HAVING reduce 141 */
  {  42, 499, 0                    }, /*                     ID reduce 141 */
  {  27, 394, 0                    }, /*                    DOT reduce 36 */
  {  44, 499, 0                    }, /*                     IN reduce 141 */
  {  29, 499, 0                    }, /*                    END reduce 141 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  48, 499, 0                    }, /*              INTERSECT reduce 141 */
  {YYNOCODE,0,0}, /* Unused */
  {  50, 499, 0                    }, /*                     IS reduce 141 */
  {  51, 499, 0                    }, /*                 ISNULL reduce 141 */
  {YYNOCODE,0,0}, /* Unused */
  {  53, 499, 0                    }, /*                     LE reduce 141 */
  {  54, 499, 0                    }, /*                   LIKE reduce 141 */
  {  55, 499, 0                    }, /*                  LIMIT reduce 141 */
  {YYNOCODE,0,0}, /* Unused */
  {  57, 499, 0                    }, /*                 LSHIFT reduce 141 */
  {  58, 499, 0                    }, /*                     LT reduce 141 */
  {  59, 499, 0                    }, /*                  MINUS reduce 141 */
  {  60, 499, 0                    }, /*                     NE reduce 141 */
  {  61, 499, 0                    }, /*                    NOT reduce 141 */
  {  62, 499, 0                    }, /*                NOTNULL reduce 141 */
  {YYNOCODE,0,0}, /* Unused */
/* State 59 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  { 131,  60, 0                    }, /*              oneselect shift  60 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[ 496] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  { 137,  61, &yyActionTable[ 497] }, /*                 select shift  61 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  75,  64, 0                    }, /*                 SELECT shift  64 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  { 111, 206, &yyActionTable[ 501] }, /*                   expr shift  206 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[ 503] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[ 505] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[ 507] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 60 */
  {YYNOCODE,0,0}, /* Unused */
/* State 61 */
  {  48, 150, &yyActionTable[ 524] }, /*              INTERSECT shift  150 */
  {  73, 205, 0                    }, /*                     RP shift  205 */
  {  32, 151, 0                    }, /*                 EXCEPT shift  151 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  { 126,  62, 0                    }, /*                 joinop shift  62 */
  {  87, 148, 0                    }, /*                  UNION shift  148 */
/* State 62 */
  {  75,  64, 0                    }, /*                 SELECT shift  64 */
  { 131,  63, &yyActionTable[ 530] }, /*              oneselect shift  63 */
/* State 63 */
  {YYNOCODE,0,0}, /* Unused */
/* State 64 */
  {   2, 204, 0                    }, /*                    ALL shift  204 */
  {YYNOCODE,0,0}, /* Unused */
  {  26, 203, &yyActionTable[ 533] }, /*               DISTINCT shift  203 */
  { 107,  65, 0                    }, /*               distinct shift  65 */
/* State 65 */
  { 136,  66, &yyActionTable[ 538] }, /*             selcollist shift  66 */
  {  80, 198, 0                    }, /*                   STAR shift  198 */
  {YYNOCODE,0,0}, /* Unused */
  { 135, 199, 0                    }, /*                   sclp shift  199 */
/* State 66 */
  {  15, 189, 0                    }, /*                  COMMA shift  189 */
  {YYNOCODE,0,0}, /* Unused */
  { 114,  67, 0                    }, /*                   from shift  67 */
  {  35, 190, &yyActionTable[ 541] }, /*                   FROM shift  190 */
/* State 67 */
  {  93, 187, 0                    }, /*                  WHERE shift  187 */
  { 151,  68, &yyActionTable[ 545] }, /*              where_opt shift  68 */
/* State 68 */
  {  39, 184, 0                    }, /*                  GROUP shift  184 */
  { 115,  69, &yyActionTable[ 547] }, /*            groupby_opt shift  69 */
/* State 69 */
  { 116,  70, 0                    }, /*             having_opt shift  70 */
  {  41, 182, 0                    }, /*                 HAVING shift  182 */
/* State 70 */
  { 132,  71, 0                    }, /*            orderby_opt shift  71 */
  {  67,  79, 0                    }, /*                  ORDER shift  79 */
/* State 71 */
  {  55,  73, 0                    }, /*                  LIMIT shift  73 */
  { 127,  72, &yyActionTable[ 553] }, /*              limit_opt shift  72 */
/* State 72 */
  {YYNOCODE,0,0}, /* Unused */
/* State 73 */
  {  47,  74, 0                    }, /*                INTEGER shift  74 */
/* State 74 */
  { 128,  75, &yyActionTable[ 558] }, /*              limit_sep shift  75 */
  {  64,  77, 0                    }, /*                 OFFSET shift  77 */
  {YYNOCODE,0,0}, /* Unused */
  {  15,  78, 0                    }, /*                  COMMA shift  78 */
/* State 75 */
  {  47,  76, 0                    }, /*                INTEGER shift  76 */
/* State 76 */
  {YYNOCODE,0,0}, /* Unused */
/* State 77 */
  {  47, 469, 0                    }, /*                INTEGER reduce 111 */
/* State 78 */
  {  47, 470, 0                    }, /*                INTEGER reduce 112 */
/* State 79 */
  {  11,  80, 0                    }, /*                     BY shift  80 */
/* State 80 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[ 569] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  { 141, 180, &yyActionTable[ 573] }, /*               sortitem shift  180 */
  { 142,  81, 0                    }, /*               sortlist shift  81 */
  { 111,  85, &yyActionTable[ 574] }, /*                   expr shift  85 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[ 577] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[ 578] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[ 582] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 81 */
  {  15,  82, 0                    }, /*                  COMMA shift  82 */
/* State 82 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[ 602] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  { 141,  83, &yyActionTable[ 606] }, /*               sortitem shift  83 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  { 111,  85, &yyActionTable[ 607] }, /*                   expr shift  85 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[ 610] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[ 611] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[ 613] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 83 */
  {   5,  50, 0                    }, /*                    ASC shift  50 */
  {  25,  51, &yyActionTable[ 631] }, /*                   DESC shift  51 */
  {YYNOCODE,0,0}, /* Unused */
  { 143,  84, 0                    }, /*              sortorder shift  84 */
/* State 84 */
  {YYNOCODE,0,0}, /* Unused */
/* State 85 */
  {   7, 141, 0                    }, /*                BETWEEN shift  141 */
  {   8, 108, 0                    }, /*                 BITAND shift  108 */
  {  66,  94, 0                    }, /*                     OR shift  94 */
  {   3,  86, 0                    }, /*                    AND shift  86 */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {  37, 102, 0                    }, /*                     GE shift  102 */
  {  38, 121, 0                    }, /*                   GLOB shift  121 */
  {  71, 131, &yyActionTable[ 636] }, /*                    REM shift  131 */
  {  40,  98, &yyActionTable[ 637] }, /*                     GT shift  98 */
  {  10, 110, 0                    }, /*                  BITOR shift  110 */
  {  74, 114, &yyActionTable[ 645] }, /*                 RSHIFT shift  114 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {  44, 145, 0                    }, /*                     IN shift  145 */
  {YYNOCODE,0,0}, /* Unused */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {YYNOCODE,0,0}, /* Unused */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {YYNOCODE,0,0}, /* Unused */
  {  50, 136, &yyActionTable[ 647] }, /*                     IS shift  136 */
  {  51, 135, 0                    }, /*                 ISNULL shift  135 */
  {YYNOCODE,0,0}, /* Unused */
  {  53, 100, 0                    }, /*                     LE shift  100 */
  {  54, 116, 0                    }, /*                   LIKE shift  116 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  57, 112, 0                    }, /*                 LSHIFT shift  112 */
  {  58,  96, 0                    }, /*                     LT shift  96 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {  60, 104, 0                    }, /*                     NE shift  104 */
  {  61, 118, 0                    }, /*                    NOT shift  118 */
  {  62, 140, 0                    }, /*                NOTNULL shift  140 */
  {  31, 106, 0                    }, /*                     EQ shift  106 */
/* State 86 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[ 671] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111,  93, &yyActionTable[ 675] }, /*                   expr shift  93 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[ 676] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[ 679] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[ 680] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 87 */
  {YYNOCODE,0,0}, /* Unused */
/* State 88 */
  {  27,  89, 0                    }, /*                    DOT shift  89 */
/* State 89 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  81,  23, &yyActionTable[ 704] }, /*                 STRING shift  23 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  69,  17, &yyActionTable[ 709] }, /*                 PRAGMA shift  17 */
  { 117,  22, &yyActionTable[ 706] }, /*                     id shift  22 */
  { 118,  90, &yyActionTable[ 714] }, /*                    ids shift  90 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  29,  16, &yyActionTable[ 716] }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
/* State 90 */
  {YYNOCODE,0,0}, /* Unused */
/* State 91 */
  {YYNOCODE,0,0}, /* Unused */
/* State 92 */
  {YYNOCODE,0,0}, /* Unused */
/* State 93 */
  {   7, 141, 0                    }, /*                BETWEEN shift  141 */
  {   8, 108, 0                    }, /*                 BITAND shift  108 */
  {  10, 110, 0                    }, /*                  BITOR shift  110 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {  37, 102, 0                    }, /*                     GE shift  102 */
  {  38, 121, 0                    }, /*                   GLOB shift  121 */
  {  71, 131, &yyActionTable[ 721] }, /*                    REM shift  131 */
  {  40,  98, &yyActionTable[ 722] }, /*                     GT shift  98 */
  {YYNOCODE,0,0}, /* Unused */
  {  74, 114, &yyActionTable[ 723] }, /*                 RSHIFT shift  114 */
  {YYNOCODE,0,0}, /* Unused */
  {  44, 145, 0                    }, /*                     IN shift  145 */
  {YYNOCODE,0,0}, /* Unused */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {YYNOCODE,0,0}, /* Unused */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {YYNOCODE,0,0}, /* Unused */
  {  50, 136, &yyActionTable[ 724] }, /*                     IS shift  136 */
  {  51, 135, 0                    }, /*                 ISNULL shift  135 */
  {YYNOCODE,0,0}, /* Unused */
  {  53, 100, 0                    }, /*                     LE shift  100 */
  {  54, 116, 0                    }, /*                   LIKE shift  116 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  57, 112, 0                    }, /*                 LSHIFT shift  112 */
  {  58,  96, 0                    }, /*                     LT shift  96 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {  60, 104, 0                    }, /*                     NE shift  104 */
  {  61, 118, 0                    }, /*                    NOT shift  118 */
  {  62, 140, 0                    }, /*                NOTNULL shift  140 */
  {  31, 106, 0                    }, /*                     EQ shift  106 */
/* State 94 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[ 756] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111,  95, &yyActionTable[ 760] }, /*                   expr shift  95 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[ 761] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[ 764] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[ 765] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 95 */
  {   7, 141, 0                    }, /*                BETWEEN shift  141 */
  {   8, 108, 0                    }, /*                 BITAND shift  108 */
  {  10, 110, 0                    }, /*                  BITOR shift  110 */
  {   3,  86, 0                    }, /*                    AND shift  86 */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {  37, 102, 0                    }, /*                     GE shift  102 */
  {  38, 121, 0                    }, /*                   GLOB shift  121 */
  {  71, 131, &yyActionTable[ 785] }, /*                    REM shift  131 */
  {  40,  98, &yyActionTable[ 786] }, /*                     GT shift  98 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {  74, 114, &yyActionTable[ 787] }, /*                 RSHIFT shift  114 */
  {YYNOCODE,0,0}, /* Unused */
  {  44, 145, 0                    }, /*                     IN shift  145 */
  {YYNOCODE,0,0}, /* Unused */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {YYNOCODE,0,0}, /* Unused */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {YYNOCODE,0,0}, /* Unused */
  {  50, 136, &yyActionTable[ 794] }, /*                     IS shift  136 */
  {  51, 135, 0                    }, /*                 ISNULL shift  135 */
  {YYNOCODE,0,0}, /* Unused */
  {  53, 100, 0                    }, /*                     LE shift  100 */
  {  54, 116, 0                    }, /*                   LIKE shift  116 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  57, 112, 0                    }, /*                 LSHIFT shift  112 */
  {  58,  96, 0                    }, /*                     LT shift  96 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {  60, 104, 0                    }, /*                     NE shift  104 */
  {  61, 118, 0                    }, /*                    NOT shift  118 */
  {  62, 140, 0                    }, /*                NOTNULL shift  140 */
  {  31, 106, 0                    }, /*                     EQ shift  106 */
/* State 96 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[ 820] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111,  97, &yyActionTable[ 824] }, /*                   expr shift  97 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[ 825] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[ 828] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[ 829] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 97 */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {  10, 110, 0                    }, /*                  BITOR shift  110 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {YYNOCODE,0,0}, /* Unused */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  71, 131, 0                    }, /*                    REM shift  131 */
  {   8, 108, 0                    }, /*                 BITAND shift  108 */
  {  57, 112, 0                    }, /*                 LSHIFT shift  112 */
  {  74, 114, &yyActionTable[ 850] }, /*                 RSHIFT shift  114 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {YYNOCODE,0,0}, /* Unused */
/* State 98 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[ 868] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111,  99, &yyActionTable[ 872] }, /*                   expr shift  99 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[ 873] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[ 876] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[ 877] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 99 */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {  10, 110, 0                    }, /*                  BITOR shift  110 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {YYNOCODE,0,0}, /* Unused */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  71, 131, 0                    }, /*                    REM shift  131 */
  {   8, 108, 0                    }, /*                 BITAND shift  108 */
  {  57, 112, 0                    }, /*                 LSHIFT shift  112 */
  {  74, 114, &yyActionTable[ 898] }, /*                 RSHIFT shift  114 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {YYNOCODE,0,0}, /* Unused */
/* State 100 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[ 916] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 101, &yyActionTable[ 920] }, /*                   expr shift  101 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[ 921] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[ 924] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[ 925] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 101 */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {  10, 110, 0                    }, /*                  BITOR shift  110 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {YYNOCODE,0,0}, /* Unused */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  71, 131, 0                    }, /*                    REM shift  131 */
  {   8, 108, 0                    }, /*                 BITAND shift  108 */
  {  57, 112, 0                    }, /*                 LSHIFT shift  112 */
  {  74, 114, &yyActionTable[ 946] }, /*                 RSHIFT shift  114 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {YYNOCODE,0,0}, /* Unused */
/* State 102 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[ 964] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 103, &yyActionTable[ 968] }, /*                   expr shift  103 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[ 969] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[ 972] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[ 973] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 103 */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {  10, 110, 0                    }, /*                  BITOR shift  110 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {YYNOCODE,0,0}, /* Unused */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  71, 131, 0                    }, /*                    REM shift  131 */
  {   8, 108, 0                    }, /*                 BITAND shift  108 */
  {  57, 112, 0                    }, /*                 LSHIFT shift  112 */
  {  74, 114, &yyActionTable[ 994] }, /*                 RSHIFT shift  114 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {YYNOCODE,0,0}, /* Unused */
/* State 104 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[1012] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 105, &yyActionTable[1016] }, /*                   expr shift  105 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[1017] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[1020] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[1021] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 105 */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {  37, 102, 0                    }, /*                     GE shift  102 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {   8, 108, 0                    }, /*                 BITAND shift  108 */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {  53, 100, &yyActionTable[1042] }, /*                     LE shift  100 */
  {  58,  96, &yyActionTable[1053] }, /*                     LT shift  96 */
  {  71, 131, 0                    }, /*                    REM shift  131 */
  {  40,  98, &yyActionTable[1044] }, /*                     GT shift  98 */
  {  57, 112, 0                    }, /*                 LSHIFT shift  112 */
  {  74, 114, &yyActionTable[1047] }, /*                 RSHIFT shift  114 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {  10, 110, 0                    }, /*                  BITOR shift  110 */
  {YYNOCODE,0,0}, /* Unused */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {YYNOCODE,0,0}, /* Unused */
/* State 106 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[1060] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 107, &yyActionTable[1064] }, /*                   expr shift  107 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[1065] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[1068] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[1069] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 107 */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {  37, 102, 0                    }, /*                     GE shift  102 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {   8, 108, 0                    }, /*                 BITAND shift  108 */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {  53, 100, &yyActionTable[1090] }, /*                     LE shift  100 */
  {  58,  96, &yyActionTable[1101] }, /*                     LT shift  96 */
  {  71, 131, 0                    }, /*                    REM shift  131 */
  {  40,  98, &yyActionTable[1092] }, /*                     GT shift  98 */
  {  57, 112, 0                    }, /*                 LSHIFT shift  112 */
  {  74, 114, &yyActionTable[1095] }, /*                 RSHIFT shift  114 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {  10, 110, 0                    }, /*                  BITOR shift  110 */
  {YYNOCODE,0,0}, /* Unused */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {YYNOCODE,0,0}, /* Unused */
/* State 108 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[1108] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 109, &yyActionTable[1112] }, /*                   expr shift  109 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[1113] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[1116] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[1117] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 109 */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {YYNOCODE,0,0}, /* Unused */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {YYNOCODE,0,0}, /* Unused */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {  71, 131, 0                    }, /*                    REM shift  131 */
/* State 110 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[1148] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 111, &yyActionTable[1152] }, /*                   expr shift  111 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[1153] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[1156] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[1157] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 111 */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {YYNOCODE,0,0}, /* Unused */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {YYNOCODE,0,0}, /* Unused */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {  71, 131, 0                    }, /*                    REM shift  131 */
/* State 112 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[1188] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 113, &yyActionTable[1192] }, /*                   expr shift  113 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[1193] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[1196] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[1197] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 113 */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {YYNOCODE,0,0}, /* Unused */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {YYNOCODE,0,0}, /* Unused */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {  71, 131, 0                    }, /*                    REM shift  131 */
/* State 114 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[1228] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 115, &yyActionTable[1232] }, /*                   expr shift  115 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[1233] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[1236] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[1237] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 115 */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {YYNOCODE,0,0}, /* Unused */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {YYNOCODE,0,0}, /* Unused */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {  71, 131, 0                    }, /*                    REM shift  131 */
/* State 116 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[1268] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 117, &yyActionTable[1272] }, /*                   expr shift  117 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[1273] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[1276] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[1277] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 117 */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {  37, 102, 0                    }, /*                     GE shift  102 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {   8, 108, 0                    }, /*                 BITAND shift  108 */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {  53, 100, &yyActionTable[1298] }, /*                     LE shift  100 */
  {  58,  96, &yyActionTable[1309] }, /*                     LT shift  96 */
  {  71, 131, 0                    }, /*                    REM shift  131 */
  {  40,  98, &yyActionTable[1300] }, /*                     GT shift  98 */
  {  57, 112, 0                    }, /*                 LSHIFT shift  112 */
  {  74, 114, &yyActionTable[1303] }, /*                 RSHIFT shift  114 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {  10, 110, 0                    }, /*                  BITOR shift  110 */
  {YYNOCODE,0,0}, /* Unused */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {YYNOCODE,0,0}, /* Unused */
/* State 118 */
  {  38, 167, 0                    }, /*                   GLOB shift  167 */
  {   7, 170, 0                    }, /*                BETWEEN shift  170 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  44, 174, 0                    }, /*                     IN shift  174 */
  {YYNOCODE,0,0}, /* Unused */
  {  54, 119, &yyActionTable[1313] }, /*                   LIKE shift  119 */
  {  63, 169, &yyActionTable[1314] }, /*                   NULL shift  169 */
/* State 119 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[1324] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 120, &yyActionTable[1328] }, /*                   expr shift  120 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[1329] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[1332] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[1333] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 120 */
  {   7, 141, 0                    }, /*                BETWEEN shift  141 */
  {   8, 108, 0                    }, /*                 BITAND shift  108 */
  {  10, 110, 0                    }, /*                  BITOR shift  110 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {  37, 102, 0                    }, /*                     GE shift  102 */
  {  38, 121, 0                    }, /*                   GLOB shift  121 */
  {  71, 131, &yyActionTable[1353] }, /*                    REM shift  131 */
  {  40,  98, &yyActionTable[1354] }, /*                     GT shift  98 */
  {YYNOCODE,0,0}, /* Unused */
  {  74, 114, &yyActionTable[1355] }, /*                 RSHIFT shift  114 */
  {YYNOCODE,0,0}, /* Unused */
  {  44, 145, 0                    }, /*                     IN shift  145 */
  {YYNOCODE,0,0}, /* Unused */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {YYNOCODE,0,0}, /* Unused */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {YYNOCODE,0,0}, /* Unused */
  {  50, 136, &yyActionTable[1356] }, /*                     IS shift  136 */
  {  51, 135, 0                    }, /*                 ISNULL shift  135 */
  {YYNOCODE,0,0}, /* Unused */
  {  53, 100, 0                    }, /*                     LE shift  100 */
  {  54, 116, 0                    }, /*                   LIKE shift  116 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  57, 112, 0                    }, /*                 LSHIFT shift  112 */
  {  58,  96, 0                    }, /*                     LT shift  96 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {  60, 104, 0                    }, /*                     NE shift  104 */
  {  61, 118, 0                    }, /*                    NOT shift  118 */
  {  62, 140, 0                    }, /*                NOTNULL shift  140 */
  {  31, 106, 0                    }, /*                     EQ shift  106 */
/* State 121 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[1388] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 122, &yyActionTable[1392] }, /*                   expr shift  122 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[1393] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[1396] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[1397] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 122 */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {  37, 102, 0                    }, /*                     GE shift  102 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {   8, 108, 0                    }, /*                 BITAND shift  108 */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {  53, 100, &yyActionTable[1418] }, /*                     LE shift  100 */
  {  58,  96, &yyActionTable[1429] }, /*                     LT shift  96 */
  {  71, 131, 0                    }, /*                    REM shift  131 */
  {  40,  98, &yyActionTable[1420] }, /*                     GT shift  98 */
  {  57, 112, 0                    }, /*                 LSHIFT shift  112 */
  {  74, 114, &yyActionTable[1423] }, /*                 RSHIFT shift  114 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {  10, 110, 0                    }, /*                  BITOR shift  110 */
  {YYNOCODE,0,0}, /* Unused */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {YYNOCODE,0,0}, /* Unused */
/* State 123 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[1436] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 124, &yyActionTable[1440] }, /*                   expr shift  124 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[1441] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[1444] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[1445] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 124 */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {  78, 129, &yyActionTable[1466] }, /*                  SLASH shift  129 */
  {  71, 131, 0                    }, /*                    REM shift  131 */
/* State 125 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[1472] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 126, &yyActionTable[1476] }, /*                   expr shift  126 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[1477] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[1480] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[1481] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 126 */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {  78, 129, &yyActionTable[1502] }, /*                  SLASH shift  129 */
  {  71, 131, 0                    }, /*                    REM shift  131 */
/* State 127 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[1508] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 128, &yyActionTable[1512] }, /*                   expr shift  128 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[1513] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[1516] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[1517] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 128 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
/* State 129 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[1541] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 130, &yyActionTable[1545] }, /*                   expr shift  130 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[1546] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[1549] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[1550] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 130 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
/* State 131 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[1574] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 132, &yyActionTable[1578] }, /*                   expr shift  132 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[1579] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[1582] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[1583] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 132 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
/* State 133 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[1607] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 134, &yyActionTable[1611] }, /*                   expr shift  134 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[1612] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[1615] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[1616] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 134 */
  {YYNOCODE,0,0}, /* Unused */
/* State 135 */
  {YYNOCODE,0,0}, /* Unused */
/* State 136 */
  {  61, 138, 0                    }, /*                    NOT shift  138 */
  {  63, 137, &yyActionTable[1638] }, /*                   NULL shift  137 */
/* State 137 */
  {YYNOCODE,0,0}, /* Unused */
/* State 138 */
  {  63, 139, 0                    }, /*                   NULL shift  139 */
/* State 139 */
  {YYNOCODE,0,0}, /* Unused */
/* State 140 */
  {YYNOCODE,0,0}, /* Unused */
/* State 141 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[1647] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 142, &yyActionTable[1651] }, /*                   expr shift  142 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[1652] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[1655] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[1656] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 142 */
  {   7, 141, 0                    }, /*                BETWEEN shift  141 */
  {   8, 108, 0                    }, /*                 BITAND shift  108 */
  {  66,  94, 0                    }, /*                     OR shift  94 */
  {   3, 143, 0                    }, /*                    AND shift  143 */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {  37, 102, 0                    }, /*                     GE shift  102 */
  {  38, 121, 0                    }, /*                   GLOB shift  121 */
  {  71, 131, &yyActionTable[1676] }, /*                    REM shift  131 */
  {  40,  98, &yyActionTable[1677] }, /*                     GT shift  98 */
  {  10, 110, 0                    }, /*                  BITOR shift  110 */
  {  74, 114, &yyActionTable[1685] }, /*                 RSHIFT shift  114 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {  44, 145, 0                    }, /*                     IN shift  145 */
  {YYNOCODE,0,0}, /* Unused */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {YYNOCODE,0,0}, /* Unused */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {YYNOCODE,0,0}, /* Unused */
  {  50, 136, &yyActionTable[1687] }, /*                     IS shift  136 */
  {  51, 135, 0                    }, /*                 ISNULL shift  135 */
  {YYNOCODE,0,0}, /* Unused */
  {  53, 100, 0                    }, /*                     LE shift  100 */
  {  54, 116, 0                    }, /*                   LIKE shift  116 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  57, 112, 0                    }, /*                 LSHIFT shift  112 */
  {  58,  96, 0                    }, /*                     LT shift  96 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {  60, 104, 0                    }, /*                     NE shift  104 */
  {  61, 118, 0                    }, /*                    NOT shift  118 */
  {  62, 140, 0                    }, /*                NOTNULL shift  140 */
  {  31, 106, 0                    }, /*                     EQ shift  106 */
/* State 143 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[1711] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 144, &yyActionTable[1715] }, /*                   expr shift  144 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[1716] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[1719] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[1720] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 144 */
  {  64, 534, &yyActionTable[1741] }, /*                 OFFSET reduce 176 */
  {   0, 534, 0                    }, /*                      $ reduce 176 */
  {  66, 534, &yyActionTable[1751] }, /*                     OR reduce 176 */
  {  67, 534, &yyActionTable[1760] }, /*                  ORDER reduce 176 */
  {  68, 123, &yyActionTable[1761] }, /*                   PLUS shift  123 */
  {  69, 534, &yyActionTable[1762] }, /*                 PRAGMA reduce 176 */
  {  70, 534, &yyActionTable[1766] }, /*                PRIMARY reduce 176 */
  {  71, 131, &yyActionTable[1768] }, /*                    REM shift  131 */
  {   8, 108, 0                    }, /*                 BITAND shift  108 */
  {  73, 534, 0                    }, /*                     RP reduce 176 */
  {  74, 114, &yyActionTable[1770] }, /*                 RSHIFT shift  114 */
  {  66, 502, 0                    }, /*                     OR reduce 144 */
  {  76, 534, &yyActionTable[1774] }, /*                   SEMI reduce 176 */
  {  13, 534, 0                    }, /*                CLUSTER reduce 176 */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {  15, 534, 0                    }, /*                  COMMA reduce 176 */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {  81, 534, 0                    }, /*                 STRING reduce 176 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {  83, 534, &yyActionTable[1776] }, /*                   TEMP reduce 176 */
  {   3, 534, &yyActionTable[1783] }, /*                    AND reduce 176 */
  {   4, 534, 0                    }, /*                     AS reduce 176 */
  {   5, 534, 0                    }, /*                    ASC reduce 176 */
  {  87, 534, 0                    }, /*                  UNION reduce 176 */
  {  88, 534, &yyActionTable[1785] }, /*                 UNIQUE reduce 176 */
  {  25, 534, 0                    }, /*                   DESC reduce 176 */
  {   6, 534, 0                    }, /*                  BEGIN reduce 176 */
  {  91, 534, 0                    }, /*                 VACUUM reduce 176 */
  {   7, 534, 0                    }, /*                BETWEEN reduce 176 */
  {  93, 534, &yyActionTable[1786] }, /*                  WHERE reduce 176 */
  {  10, 110, 0                    }, /*                  BITOR shift  110 */
  {  31, 534, 0                    }, /*                     EQ reduce 176 */
  {  32, 534, 0                    }, /*                 EXCEPT reduce 176 */
  {  33, 534, 0                    }, /*                EXPLAIN reduce 176 */
  {  12, 534, 0                    }, /*                  CHECK reduce 176 */
  {  35, 534, 0                    }, /*                   FROM reduce 176 */
  {  19, 534, 0                    }, /*             CONSTRAINT reduce 176 */
  {  37, 102, 0                    }, /*                     GE shift  102 */
  {  38, 534, 0                    }, /*                   GLOB reduce 176 */
  {  39, 534, 0                    }, /*                  GROUP reduce 176 */
  {  40,  98, 0                    }, /*                     GT shift  98 */
  {  41, 534, 0                    }, /*                 HAVING reduce 176 */
  {  42, 534, 0                    }, /*                     ID reduce 176 */
  {   3, 502, 0                    }, /*                    AND reduce 144 */
  {  44, 534, 0                    }, /*                     IN reduce 176 */
  {  24, 534, 0                    }, /*             DELIMITERS reduce 176 */
  {  29, 534, 0                    }, /*                    END reduce 176 */
  {YYNOCODE,0,0}, /* Unused */
  {  48, 534, 0                    }, /*              INTERSECT reduce 176 */
  {YYNOCODE,0,0}, /* Unused */
  {  50, 534, 0                    }, /*                     IS reduce 176 */
  {  51, 534, 0                    }, /*                 ISNULL reduce 176 */
  {YYNOCODE,0,0}, /* Unused */
  {  53, 100, 0                    }, /*                     LE shift  100 */
  {  54, 534, 0                    }, /*                   LIKE reduce 176 */
  {  55, 534, 0                    }, /*                  LIMIT reduce 176 */
  {YYNOCODE,0,0}, /* Unused */
  {  57, 112, 0                    }, /*                 LSHIFT shift  112 */
  {  58,  96, 0                    }, /*                     LT shift  96 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {  60, 534, 0                    }, /*                     NE reduce 176 */
  {  61, 534, 0                    }, /*                    NOT reduce 176 */
  {  62, 534, 0                    }, /*                NOTNULL reduce 176 */
  {YYNOCODE,0,0}, /* Unused */
/* State 145 */
  {  56, 146, 0                    }, /*                     LP shift  146 */
/* State 146 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  { 131,  60, 0                    }, /*              oneselect shift  60 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[1812] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  { 137, 147, &yyActionTable[1813] }, /*                 select shift  147 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  75,  64, 0                    }, /*                 SELECT shift  64 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  { 111, 153, &yyActionTable[1817] }, /*                   expr shift  153 */
  { 112, 166, 0                    }, /*               expritem shift  166 */
  { 113, 162, &yyActionTable[1819] }, /*               exprlist shift  162 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  56,  59, &yyActionTable[1823] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[1825] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[1828] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 147 */
  {  48, 150, &yyActionTable[1839] }, /*              INTERSECT shift  150 */
  {  73, 152, 0                    }, /*                     RP shift  152 */
  {  32, 151, 0                    }, /*                 EXCEPT shift  151 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  { 126,  62, 0                    }, /*                 joinop shift  62 */
  {  87, 148, 0                    }, /*                  UNION shift  148 */
/* State 148 */
  {   2, 149, 0                    }, /*                    ALL shift  149 */
  {  75, 434, 0                    }, /*                 SELECT reduce 76 */
/* State 149 */
  {  75, 435, 0                    }, /*                 SELECT reduce 77 */
/* State 150 */
  {  75, 436, 0                    }, /*                 SELECT reduce 78 */
/* State 151 */
  {  75, 437, 0                    }, /*                 SELECT reduce 79 */
/* State 152 */
  {YYNOCODE,0,0}, /* Unused */
/* State 153 */
  {   7, 141, 0                    }, /*                BETWEEN shift  141 */
  {   8, 108, 0                    }, /*                 BITAND shift  108 */
  {  66,  94, 0                    }, /*                     OR shift  94 */
  {   3,  86, 0                    }, /*                    AND shift  86 */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {  37, 102, 0                    }, /*                     GE shift  102 */
  {  38, 121, 0                    }, /*                   GLOB shift  121 */
  {  71, 131, &yyActionTable[1851] }, /*                    REM shift  131 */
  {  40,  98, &yyActionTable[1852] }, /*                     GT shift  98 */
  {  10, 110, 0                    }, /*                  BITOR shift  110 */
  {  74, 114, &yyActionTable[1860] }, /*                 RSHIFT shift  114 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {  44, 145, 0                    }, /*                     IN shift  145 */
  {YYNOCODE,0,0}, /* Unused */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {YYNOCODE,0,0}, /* Unused */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {YYNOCODE,0,0}, /* Unused */
  {  50, 136, &yyActionTable[1862] }, /*                     IS shift  136 */
  {  51, 135, 0                    }, /*                 ISNULL shift  135 */
  {YYNOCODE,0,0}, /* Unused */
  {  53, 100, 0                    }, /*                     LE shift  100 */
  {  54, 116, 0                    }, /*                   LIKE shift  116 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  57, 112, 0                    }, /*                 LSHIFT shift  112 */
  {  58,  96, 0                    }, /*                     LT shift  96 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {  60, 104, 0                    }, /*                     NE shift  104 */
  {  61, 118, 0                    }, /*                    NOT shift  118 */
  {  62, 140, 0                    }, /*                NOTNULL shift  140 */
  {  31, 106, 0                    }, /*                     EQ shift  106 */
/* State 154 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[1886] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 155, &yyActionTable[1890] }, /*                   expr shift  155 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[1891] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[1894] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[1895] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 155 */
  {   7, 141, 0                    }, /*                BETWEEN shift  141 */
  {   8, 108, 0                    }, /*                 BITAND shift  108 */
  {  10, 110, 0                    }, /*                  BITOR shift  110 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {  37, 102, 0                    }, /*                     GE shift  102 */
  {  38, 121, 0                    }, /*                   GLOB shift  121 */
  {  71, 131, &yyActionTable[1915] }, /*                    REM shift  131 */
  {  40,  98, &yyActionTable[1916] }, /*                     GT shift  98 */
  {YYNOCODE,0,0}, /* Unused */
  {  74, 114, &yyActionTable[1917] }, /*                 RSHIFT shift  114 */
  {YYNOCODE,0,0}, /* Unused */
  {  44, 145, 0                    }, /*                     IN shift  145 */
  {YYNOCODE,0,0}, /* Unused */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {YYNOCODE,0,0}, /* Unused */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {YYNOCODE,0,0}, /* Unused */
  {  50, 136, &yyActionTable[1918] }, /*                     IS shift  136 */
  {  51, 135, 0                    }, /*                 ISNULL shift  135 */
  {YYNOCODE,0,0}, /* Unused */
  {  53, 100, 0                    }, /*                     LE shift  100 */
  {  54, 116, 0                    }, /*                   LIKE shift  116 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  57, 112, 0                    }, /*                 LSHIFT shift  112 */
  {  58,  96, 0                    }, /*                     LT shift  96 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {  60, 104, 0                    }, /*                     NE shift  104 */
  {  61, 118, 0                    }, /*                    NOT shift  118 */
  {  62, 140, 0                    }, /*                NOTNULL shift  140 */
  {  31, 106, 0                    }, /*                     EQ shift  106 */
/* State 156 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[1950] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 157, &yyActionTable[1954] }, /*                   expr shift  157 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[1955] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[1958] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[1959] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 157 */
  {YYNOCODE,0,0}, /* Unused */
/* State 158 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[1983] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 159, &yyActionTable[1987] }, /*                   expr shift  159 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[1988] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[1991] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[1992] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 159 */
  {YYNOCODE,0,0}, /* Unused */
/* State 160 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[2016] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 161, &yyActionTable[2020] }, /*                   expr shift  161 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[2021] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[2024] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[2025] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 161 */
  {YYNOCODE,0,0}, /* Unused */
/* State 162 */
  {  15, 164, 0                    }, /*                  COMMA shift  164 */
  {  73, 163, &yyActionTable[2046] }, /*                     RP shift  163 */
/* State 163 */
  {YYNOCODE,0,0}, /* Unused */
/* State 164 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[2052] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 153, &yyActionTable[2056] }, /*                   expr shift  153 */
  { 112, 165, 0                    }, /*               expritem shift  165 */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[2057] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[2060] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[2061] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 165 */
  {YYNOCODE,0,0}, /* Unused */
/* State 166 */
  {YYNOCODE,0,0}, /* Unused */
/* State 167 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[2086] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 168, &yyActionTable[2090] }, /*                   expr shift  168 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[2091] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[2094] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[2095] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 168 */
  {   7, 141, 0                    }, /*                BETWEEN shift  141 */
  {   8, 108, 0                    }, /*                 BITAND shift  108 */
  {  10, 110, 0                    }, /*                  BITOR shift  110 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {  37, 102, 0                    }, /*                     GE shift  102 */
  {  38, 121, 0                    }, /*                   GLOB shift  121 */
  {  71, 131, &yyActionTable[2115] }, /*                    REM shift  131 */
  {  40,  98, &yyActionTable[2116] }, /*                     GT shift  98 */
  {YYNOCODE,0,0}, /* Unused */
  {  74, 114, &yyActionTable[2117] }, /*                 RSHIFT shift  114 */
  {YYNOCODE,0,0}, /* Unused */
  {  44, 145, 0                    }, /*                     IN shift  145 */
  {YYNOCODE,0,0}, /* Unused */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {YYNOCODE,0,0}, /* Unused */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {YYNOCODE,0,0}, /* Unused */
  {  50, 136, &yyActionTable[2118] }, /*                     IS shift  136 */
  {  51, 135, 0                    }, /*                 ISNULL shift  135 */
  {YYNOCODE,0,0}, /* Unused */
  {  53, 100, 0                    }, /*                     LE shift  100 */
  {  54, 116, 0                    }, /*                   LIKE shift  116 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  57, 112, 0                    }, /*                 LSHIFT shift  112 */
  {  58,  96, 0                    }, /*                     LT shift  96 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {  60, 104, 0                    }, /*                     NE shift  104 */
  {  61, 118, 0                    }, /*                    NOT shift  118 */
  {  62, 140, 0                    }, /*                NOTNULL shift  140 */
  {  31, 106, 0                    }, /*                     EQ shift  106 */
/* State 169 */
  {YYNOCODE,0,0}, /* Unused */
/* State 170 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[2151] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 171, &yyActionTable[2155] }, /*                   expr shift  171 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[2156] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[2159] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[2160] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 171 */
  {   7, 141, 0                    }, /*                BETWEEN shift  141 */
  {   8, 108, 0                    }, /*                 BITAND shift  108 */
  {  66,  94, 0                    }, /*                     OR shift  94 */
  {   3, 172, 0                    }, /*                    AND shift  172 */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {  37, 102, 0                    }, /*                     GE shift  102 */
  {  38, 121, 0                    }, /*                   GLOB shift  121 */
  {  71, 131, &yyActionTable[2180] }, /*                    REM shift  131 */
  {  40,  98, &yyActionTable[2181] }, /*                     GT shift  98 */
  {  10, 110, 0                    }, /*                  BITOR shift  110 */
  {  74, 114, &yyActionTable[2189] }, /*                 RSHIFT shift  114 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {  44, 145, 0                    }, /*                     IN shift  145 */
  {YYNOCODE,0,0}, /* Unused */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {YYNOCODE,0,0}, /* Unused */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {YYNOCODE,0,0}, /* Unused */
  {  50, 136, &yyActionTable[2191] }, /*                     IS shift  136 */
  {  51, 135, 0                    }, /*                 ISNULL shift  135 */
  {YYNOCODE,0,0}, /* Unused */
  {  53, 100, 0                    }, /*                     LE shift  100 */
  {  54, 116, 0                    }, /*                   LIKE shift  116 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  57, 112, 0                    }, /*                 LSHIFT shift  112 */
  {  58,  96, 0                    }, /*                     LT shift  96 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {  60, 104, 0                    }, /*                     NE shift  104 */
  {  61, 118, 0                    }, /*                    NOT shift  118 */
  {  62, 140, 0                    }, /*                NOTNULL shift  140 */
  {  31, 106, 0                    }, /*                     EQ shift  106 */
/* State 172 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[2215] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 173, &yyActionTable[2219] }, /*                   expr shift  173 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[2220] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[2223] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[2224] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 173 */
  {  64, 535, &yyActionTable[2245] }, /*                 OFFSET reduce 177 */
  {   0, 535, 0                    }, /*                      $ reduce 177 */
  {  66, 535, &yyActionTable[2255] }, /*                     OR reduce 177 */
  {  67, 535, &yyActionTable[2264] }, /*                  ORDER reduce 177 */
  {  68, 123, &yyActionTable[2265] }, /*                   PLUS shift  123 */
  {  69, 535, &yyActionTable[2266] }, /*                 PRAGMA reduce 177 */
  {  70, 535, &yyActionTable[2270] }, /*                PRIMARY reduce 177 */
  {  71, 131, &yyActionTable[2272] }, /*                    REM shift  131 */
  {   8, 108, 0                    }, /*                 BITAND shift  108 */
  {  73, 535, 0                    }, /*                     RP reduce 177 */
  {  74, 114, &yyActionTable[2274] }, /*                 RSHIFT shift  114 */
  {  66, 502, 0                    }, /*                     OR reduce 144 */
  {  76, 535, &yyActionTable[2278] }, /*                   SEMI reduce 177 */
  {  13, 535, 0                    }, /*                CLUSTER reduce 177 */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {  15, 535, 0                    }, /*                  COMMA reduce 177 */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {  81, 535, 0                    }, /*                 STRING reduce 177 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {  83, 535, &yyActionTable[2280] }, /*                   TEMP reduce 177 */
  {   3, 535, &yyActionTable[2287] }, /*                    AND reduce 177 */
  {   4, 535, 0                    }, /*                     AS reduce 177 */
  {   5, 535, 0                    }, /*                    ASC reduce 177 */
  {  87, 535, 0                    }, /*                  UNION reduce 177 */
  {  88, 535, &yyActionTable[2289] }, /*                 UNIQUE reduce 177 */
  {  25, 535, 0                    }, /*                   DESC reduce 177 */
  {   6, 535, 0                    }, /*                  BEGIN reduce 177 */
  {  91, 535, 0                    }, /*                 VACUUM reduce 177 */
  {   7, 141, 0                    }, /*                BETWEEN shift  141 */
  {  93, 535, &yyActionTable[2290] }, /*                  WHERE reduce 177 */
  {  10, 110, 0                    }, /*                  BITOR shift  110 */
  {  31, 106, 0                    }, /*                     EQ shift  106 */
  {  32, 535, 0                    }, /*                 EXCEPT reduce 177 */
  {  33, 535, 0                    }, /*                EXPLAIN reduce 177 */
  {  12, 535, 0                    }, /*                  CHECK reduce 177 */
  {  35, 535, 0                    }, /*                   FROM reduce 177 */
  {  19, 535, 0                    }, /*             CONSTRAINT reduce 177 */
  {  37, 102, 0                    }, /*                     GE shift  102 */
  {  38, 121, 0                    }, /*                   GLOB shift  121 */
  {  39, 535, 0                    }, /*                  GROUP reduce 177 */
  {  40,  98, 0                    }, /*                     GT shift  98 */
  {  41, 535, 0                    }, /*                 HAVING reduce 177 */
  {  42, 535, 0                    }, /*                     ID reduce 177 */
  {   3, 502, 0                    }, /*                    AND reduce 144 */
  {  44, 145, 0                    }, /*                     IN shift  145 */
  {  24, 535, 0                    }, /*             DELIMITERS reduce 177 */
  {  29, 535, 0                    }, /*                    END reduce 177 */
  {YYNOCODE,0,0}, /* Unused */
  {  48, 535, 0                    }, /*              INTERSECT reduce 177 */
  {YYNOCODE,0,0}, /* Unused */
  {  50, 136, 0                    }, /*                     IS shift  136 */
  {  51, 135, 0                    }, /*                 ISNULL shift  135 */
  {YYNOCODE,0,0}, /* Unused */
  {  53, 100, 0                    }, /*                     LE shift  100 */
  {  54, 116, 0                    }, /*                   LIKE shift  116 */
  {  55, 535, 0                    }, /*                  LIMIT reduce 177 */
  {YYNOCODE,0,0}, /* Unused */
  {  57, 112, 0                    }, /*                 LSHIFT shift  112 */
  {  58,  96, 0                    }, /*                     LT shift  96 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {  60, 104, 0                    }, /*                     NE shift  104 */
  {  61, 118, 0                    }, /*                    NOT shift  118 */
  {  62, 140, 0                    }, /*                NOTNULL shift  140 */
  {YYNOCODE,0,0}, /* Unused */
/* State 174 */
  {  56, 175, 0                    }, /*                     LP shift  175 */
/* State 175 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  { 131,  60, 0                    }, /*              oneselect shift  60 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[2316] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  { 137, 176, &yyActionTable[2317] }, /*                 select shift  176 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  75,  64, 0                    }, /*                 SELECT shift  64 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  { 111, 153, &yyActionTable[2321] }, /*                   expr shift  153 */
  { 112, 166, 0                    }, /*               expritem shift  166 */
  { 113, 178, &yyActionTable[2323] }, /*               exprlist shift  178 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  56,  59, &yyActionTable[2327] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[2329] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[2332] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 176 */
  {  48, 150, &yyActionTable[2343] }, /*              INTERSECT shift  150 */
  {  73, 177, 0                    }, /*                     RP shift  177 */
  {  32, 151, 0                    }, /*                 EXCEPT shift  151 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  { 126,  62, 0                    }, /*                 joinop shift  62 */
  {  87, 148, 0                    }, /*                  UNION shift  148 */
/* State 177 */
  {YYNOCODE,0,0}, /* Unused */
/* State 178 */
  {  15, 164, 0                    }, /*                  COMMA shift  164 */
  {  73, 179, &yyActionTable[2350] }, /*                     RP shift  179 */
/* State 179 */
  {YYNOCODE,0,0}, /* Unused */
/* State 180 */
  {   5,  50, 0                    }, /*                    ASC shift  50 */
  {  25,  51, &yyActionTable[2353] }, /*                   DESC shift  51 */
  {YYNOCODE,0,0}, /* Unused */
  { 143, 181, 0                    }, /*              sortorder shift  181 */
/* State 181 */
  {YYNOCODE,0,0}, /* Unused */
/* State 182 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[2361] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 183, &yyActionTable[2365] }, /*                   expr shift  183 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[2366] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[2369] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[2370] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 183 */
  {   7, 141, 0                    }, /*                BETWEEN shift  141 */
  {   8, 108, 0                    }, /*                 BITAND shift  108 */
  {  66,  94, 0                    }, /*                     OR shift  94 */
  {   3,  86, 0                    }, /*                    AND shift  86 */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {  37, 102, 0                    }, /*                     GE shift  102 */
  {  38, 121, 0                    }, /*                   GLOB shift  121 */
  {  71, 131, &yyActionTable[2390] }, /*                    REM shift  131 */
  {  40,  98, &yyActionTable[2391] }, /*                     GT shift  98 */
  {  10, 110, 0                    }, /*                  BITOR shift  110 */
  {  74, 114, &yyActionTable[2399] }, /*                 RSHIFT shift  114 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {  44, 145, 0                    }, /*                     IN shift  145 */
  {YYNOCODE,0,0}, /* Unused */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {YYNOCODE,0,0}, /* Unused */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {YYNOCODE,0,0}, /* Unused */
  {  50, 136, &yyActionTable[2401] }, /*                     IS shift  136 */
  {  51, 135, 0                    }, /*                 ISNULL shift  135 */
  {YYNOCODE,0,0}, /* Unused */
  {  53, 100, 0                    }, /*                     LE shift  100 */
  {  54, 116, 0                    }, /*                   LIKE shift  116 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  57, 112, 0                    }, /*                 LSHIFT shift  112 */
  {  58,  96, 0                    }, /*                     LT shift  96 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {  60, 104, 0                    }, /*                     NE shift  104 */
  {  61, 118, 0                    }, /*                    NOT shift  118 */
  {  62, 140, 0                    }, /*                NOTNULL shift  140 */
  {  31, 106, 0                    }, /*                     EQ shift  106 */
/* State 184 */
  {  11, 185, 0                    }, /*                     BY shift  185 */
/* State 185 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[2426] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  { 111, 153, &yyActionTable[2430] }, /*                   expr shift  153 */
  { 112, 166, 0                    }, /*               expritem shift  166 */
  { 113, 186, &yyActionTable[2431] }, /*               exprlist shift  186 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[2434] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[2435] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[2437] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 186 */
  {  15, 164, 0                    }, /*                  COMMA shift  164 */
/* State 187 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[2459] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 188, &yyActionTable[2463] }, /*                   expr shift  188 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[2464] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[2467] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[2468] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 188 */
  {   7, 141, 0                    }, /*                BETWEEN shift  141 */
  {   8, 108, 0                    }, /*                 BITAND shift  108 */
  {  66,  94, 0                    }, /*                     OR shift  94 */
  {   3,  86, 0                    }, /*                    AND shift  86 */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {  37, 102, 0                    }, /*                     GE shift  102 */
  {  38, 121, 0                    }, /*                   GLOB shift  121 */
  {  71, 131, &yyActionTable[2488] }, /*                    REM shift  131 */
  {  40,  98, &yyActionTable[2489] }, /*                     GT shift  98 */
  {  10, 110, 0                    }, /*                  BITOR shift  110 */
  {  74, 114, &yyActionTable[2497] }, /*                 RSHIFT shift  114 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {  44, 145, 0                    }, /*                     IN shift  145 */
  {YYNOCODE,0,0}, /* Unused */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {YYNOCODE,0,0}, /* Unused */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {YYNOCODE,0,0}, /* Unused */
  {  50, 136, &yyActionTable[2499] }, /*                     IS shift  136 */
  {  51, 135, 0                    }, /*                 ISNULL shift  135 */
  {YYNOCODE,0,0}, /* Unused */
  {  53, 100, 0                    }, /*                     LE shift  100 */
  {  54, 116, 0                    }, /*                   LIKE shift  116 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  57, 112, 0                    }, /*                 LSHIFT shift  112 */
  {  58,  96, 0                    }, /*                     LT shift  96 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {  60, 104, 0                    }, /*                     NE shift  104 */
  {  61, 118, 0                    }, /*                    NOT shift  118 */
  {  62, 140, 0                    }, /*                NOTNULL shift  140 */
  {  31, 106, 0                    }, /*                     EQ shift  106 */
/* State 189 */
  {YYNOCODE,0,0}, /* Unused */
/* State 190 */
  { 144, 193, &yyActionTable[2522] }, /*             stl_prefix shift  193 */
  { 138, 191, 0                    }, /*             seltablist shift  191 */
/* State 191 */
  {  15, 192, 0                    }, /*                  COMMA shift  192 */
/* State 192 */
  {YYNOCODE,0,0}, /* Unused */
/* State 193 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  81,  23, &yyActionTable[2527] }, /*                 STRING shift  23 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  69,  17, &yyActionTable[2532] }, /*                 PRAGMA shift  17 */
  { 117,  22, &yyActionTable[2529] }, /*                     id shift  22 */
  { 118, 194, &yyActionTable[2537] }, /*                    ids shift  194 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  29,  16, &yyActionTable[2539] }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
/* State 194 */
  {  64, 447, &yyActionTable[2543] }, /*                 OFFSET reduce 89 */
  {  33, 447, 0                    }, /*                EXPLAIN reduce 89 */
  {  32, 452, &yyActionTable[2549] }, /*                 EXCEPT reduce 94 */
  {  67, 452, 0                    }, /*                  ORDER reduce 94 */
  {   4, 195, 0                    }, /*                     AS shift  195 */
  {  69, 447, &yyActionTable[2552] }, /*                 PRAGMA reduce 89 */
  {   6, 447, 0                    }, /*                  BEGIN reduce 89 */
  {  39, 452, 0                    }, /*                  GROUP reduce 94 */
  {   0, 452, 0                    }, /*                      $ reduce 94 */
  {  73, 452, &yyActionTable[2555] }, /*                     RP reduce 94 */
  {  42, 447, 0                    }, /*                     ID reduce 89 */
  {   5, 447, 0                    }, /*                    ASC reduce 89 */
  {  76, 452, 0                    }, /*                   SEMI reduce 94 */
  {  13, 447, 0                    }, /*                CLUSTER reduce 89 */
  {  41, 452, 0                    }, /*                 HAVING reduce 94 */
  {  15, 452, 0                    }, /*                  COMMA reduce 94 */
  {  48, 452, 0                    }, /*              INTERSECT reduce 94 */
  {  81, 447, 0                    }, /*                 STRING reduce 89 */
  {  55, 452, 0                    }, /*                  LIMIT reduce 94 */
  {  83, 447, 0                    }, /*                   TEMP reduce 89 */
  {  29, 447, 0                    }, /*                    END reduce 89 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  87, 452, &yyActionTable[2559] }, /*                  UNION reduce 94 */
  {  24, 447, 0                    }, /*             DELIMITERS reduce 89 */
  {  25, 447, 0                    }, /*                   DESC reduce 89 */
  {YYNOCODE,0,0}, /* Unused */
  {  91, 447, 0                    }, /*                 VACUUM reduce 89 */
  {YYNOCODE,0,0}, /* Unused */
  {  93, 452, &yyActionTable[2561] }, /*                  WHERE reduce 94 */
  {  94, 196, 0                    }, /*                     as shift  196 */
  {YYNOCODE,0,0}, /* Unused */
/* State 195 */
  {YYNOCODE,0,0}, /* Unused */
/* State 196 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  81,  23, &yyActionTable[2576] }, /*                 STRING shift  23 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  69,  17, &yyActionTable[2581] }, /*                 PRAGMA shift  17 */
  { 117,  22, &yyActionTable[2578] }, /*                     id shift  22 */
  { 118, 197, &yyActionTable[2586] }, /*                    ids shift  197 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  29,  16, &yyActionTable[2588] }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
/* State 197 */
  {YYNOCODE,0,0}, /* Unused */
/* State 198 */
  {YYNOCODE,0,0}, /* Unused */
/* State 199 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[2595] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 200, &yyActionTable[2599] }, /*                   expr shift  200 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[2600] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[2603] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[2604] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 200 */
  {  64, 447, 0                    }, /*                 OFFSET reduce 89 */
  {   4, 195, 0                    }, /*                     AS shift  195 */
  {  66,  94, 0                    }, /*                     OR shift  94 */
  {   3,  86, 0                    }, /*                    AND shift  86 */
  {  68, 123, &yyActionTable[2625] }, /*                   PLUS shift  123 */
  {  69, 447, &yyActionTable[2633] }, /*                 PRAGMA reduce 89 */
  {   6, 447, 0                    }, /*                  BEGIN reduce 89 */
  {  71, 131, &yyActionTable[2635] }, /*                    REM shift  131 */
  {   8, 108, 0                    }, /*                 BITAND shift  108 */
  {   5, 447, 0                    }, /*                    ASC reduce 89 */
  {  74, 114, &yyActionTable[2636] }, /*                 RSHIFT shift  114 */
  {   7, 141, 0                    }, /*                BETWEEN shift  141 */
  {  10, 110, 0                    }, /*                  BITOR shift  110 */
  {  13, 447, 0                    }, /*                CLUSTER reduce 89 */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {  15, 445, 0                    }, /*                  COMMA reduce 87 */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {  81, 447, 0                    }, /*                 STRING reduce 89 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {  83, 447, 0                    }, /*                   TEMP reduce 89 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  24, 447, 0                    }, /*             DELIMITERS reduce 89 */
  {  25, 447, 0                    }, /*                   DESC reduce 89 */
  {YYNOCODE,0,0}, /* Unused */
  {  91, 447, 0                    }, /*                 VACUUM reduce 89 */
  {YYNOCODE,0,0}, /* Unused */
  {  29, 447, 0                    }, /*                    END reduce 89 */
  {  94, 201, 0                    }, /*                     as shift  201 */
  {  31, 106, 0                    }, /*                     EQ shift  106 */
  {YYNOCODE,0,0}, /* Unused */
  {  33, 447, 0                    }, /*                EXPLAIN reduce 89 */
  {YYNOCODE,0,0}, /* Unused */
  {  35, 445, 0                    }, /*                   FROM reduce 87 */
  {YYNOCODE,0,0}, /* Unused */
  {  37, 102, 0                    }, /*                     GE shift  102 */
  {  38, 121, 0                    }, /*                   GLOB shift  121 */
  {YYNOCODE,0,0}, /* Unused */
  {  40,  98, 0                    }, /*                     GT shift  98 */
  {YYNOCODE,0,0}, /* Unused */
  {  42, 447, 0                    }, /*                     ID reduce 89 */
  {YYNOCODE,0,0}, /* Unused */
  {  44, 145, 0                    }, /*                     IN shift  145 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  50, 136, 0                    }, /*                     IS shift  136 */
  {  51, 135, 0                    }, /*                 ISNULL shift  135 */
  {YYNOCODE,0,0}, /* Unused */
  {  53, 100, 0                    }, /*                     LE shift  100 */
  {  54, 116, 0                    }, /*                   LIKE shift  116 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  57, 112, 0                    }, /*                 LSHIFT shift  112 */
  {  58,  96, 0                    }, /*                     LT shift  96 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {  60, 104, 0                    }, /*                     NE shift  104 */
  {  61, 118, 0                    }, /*                    NOT shift  118 */
  {  62, 140, 0                    }, /*                NOTNULL shift  140 */
  {YYNOCODE,0,0}, /* Unused */
/* State 201 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  81,  23, &yyActionTable[2690] }, /*                 STRING shift  23 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  69,  17, &yyActionTable[2695] }, /*                 PRAGMA shift  17 */
  { 117,  22, &yyActionTable[2692] }, /*                     id shift  22 */
  { 118, 202, &yyActionTable[2700] }, /*                    ids shift  202 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  29,  16, &yyActionTable[2702] }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
/* State 202 */
  {YYNOCODE,0,0}, /* Unused */
/* State 203 */
  {YYNOCODE,0,0}, /* Unused */
/* State 204 */
  {YYNOCODE,0,0}, /* Unused */
/* State 205 */
  {YYNOCODE,0,0}, /* Unused */
/* State 206 */
  {   7, 141, 0                    }, /*                BETWEEN shift  141 */
  {   8, 108, 0                    }, /*                 BITAND shift  108 */
  {  66,  94, 0                    }, /*                     OR shift  94 */
  {   3,  86, 0                    }, /*                    AND shift  86 */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {  37, 102, 0                    }, /*                     GE shift  102 */
  {  38, 121, 0                    }, /*                   GLOB shift  121 */
  {  71, 131, &yyActionTable[2708] }, /*                    REM shift  131 */
  {  40,  98, &yyActionTable[2709] }, /*                     GT shift  98 */
  {  73, 207, 0                    }, /*                     RP shift  207 */
  {  74, 114, &yyActionTable[2719] }, /*                 RSHIFT shift  114 */
  {  10, 110, 0                    }, /*                  BITOR shift  110 */
  {  44, 145, 0                    }, /*                     IN shift  145 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {YYNOCODE,0,0}, /* Unused */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {YYNOCODE,0,0}, /* Unused */
  {  50, 136, &yyActionTable[2721] }, /*                     IS shift  136 */
  {  51, 135, 0                    }, /*                 ISNULL shift  135 */
  {YYNOCODE,0,0}, /* Unused */
  {  53, 100, 0                    }, /*                     LE shift  100 */
  {  54, 116, 0                    }, /*                   LIKE shift  116 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  57, 112, 0                    }, /*                 LSHIFT shift  112 */
  {  58,  96, 0                    }, /*                     LT shift  96 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {  60, 104, 0                    }, /*                     NE shift  104 */
  {  61, 118, 0                    }, /*                    NOT shift  118 */
  {  62, 140, 0                    }, /*                NOTNULL shift  140 */
  {  31, 106, 0                    }, /*                     EQ shift  106 */
/* State 207 */
  {YYNOCODE,0,0}, /* Unused */
/* State 208 */
  {  15, 164, 0                    }, /*                  COMMA shift  164 */
  {  73, 209, &yyActionTable[2741] }, /*                     RP shift  209 */
/* State 209 */
  {YYNOCODE,0,0}, /* Unused */
/* State 210 */
  {  73, 211, 0                    }, /*                     RP shift  211 */
/* State 211 */
  {YYNOCODE,0,0}, /* Unused */
/* State 212 */
  {   7, 141, 0                    }, /*                BETWEEN shift  141 */
  {   8, 108, 0                    }, /*                 BITAND shift  108 */
  {  66,  94, 0                    }, /*                     OR shift  94 */
  {   3,  86, 0                    }, /*                    AND shift  86 */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {  37, 102, 0                    }, /*                     GE shift  102 */
  {  38, 121, 0                    }, /*                   GLOB shift  121 */
  {  71, 131, &yyActionTable[2746] }, /*                    REM shift  131 */
  {  40,  98, &yyActionTable[2747] }, /*                     GT shift  98 */
  {  73, 213, 0                    }, /*                     RP shift  213 */
  {  74, 114, &yyActionTable[2757] }, /*                 RSHIFT shift  114 */
  {  10, 110, 0                    }, /*                  BITOR shift  110 */
  {  44, 145, 0                    }, /*                     IN shift  145 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {YYNOCODE,0,0}, /* Unused */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {YYNOCODE,0,0}, /* Unused */
  {  50, 136, &yyActionTable[2759] }, /*                     IS shift  136 */
  {  51, 135, 0                    }, /*                 ISNULL shift  135 */
  {YYNOCODE,0,0}, /* Unused */
  {  53, 100, 0                    }, /*                     LE shift  100 */
  {  54, 116, 0                    }, /*                   LIKE shift  116 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  57, 112, 0                    }, /*                 LSHIFT shift  112 */
  {  58,  96, 0                    }, /*                     LT shift  96 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {  60, 104, 0                    }, /*                     NE shift  104 */
  {  61, 118, 0                    }, /*                    NOT shift  118 */
  {  62, 140, 0                    }, /*                NOTNULL shift  140 */
  {  31, 106, 0                    }, /*                     EQ shift  106 */
/* State 213 */
  {YYNOCODE,0,0}, /* Unused */
/* State 214 */
  {YYNOCODE,0,0}, /* Unused */
/* State 215 */
  {  34, 225, 0                    }, /*                  FLOAT shift  225 */
  {  81, 216, 0                    }, /*                 STRING shift  216 */
  {  42, 217, &yyActionTable[2780] }, /*                     ID shift  217 */
  {  59, 222, 0                    }, /*                  MINUS shift  222 */
  {  68, 219, 0                    }, /*                   PLUS shift  219 */
  {  47, 218, 0                    }, /*                INTEGER shift  218 */
  {YYNOCODE,0,0}, /* Unused */
  {  63, 226, &yyActionTable[2785] }, /*                   NULL shift  226 */
/* State 216 */
  {YYNOCODE,0,0}, /* Unused */
/* State 217 */
  {YYNOCODE,0,0}, /* Unused */
/* State 218 */
  {YYNOCODE,0,0}, /* Unused */
/* State 219 */
  {  34, 221, 0                    }, /*                  FLOAT shift  221 */
  {  47, 220, 0                    }, /*                INTEGER shift  220 */
/* State 220 */
  {YYNOCODE,0,0}, /* Unused */
/* State 221 */
  {YYNOCODE,0,0}, /* Unused */
/* State 222 */
  {  34, 224, 0                    }, /*                  FLOAT shift  224 */
  {  47, 223, 0                    }, /*                INTEGER shift  223 */
/* State 223 */
  {YYNOCODE,0,0}, /* Unused */
/* State 224 */
  {YYNOCODE,0,0}, /* Unused */
/* State 225 */
  {YYNOCODE,0,0}, /* Unused */
/* State 226 */
  {YYNOCODE,0,0}, /* Unused */
/* State 227 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  81,  23, &yyActionTable[2803] }, /*                 STRING shift  23 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  69,  17, &yyActionTable[2808] }, /*                 PRAGMA shift  17 */
  { 117,  22, &yyActionTable[2805] }, /*                     id shift  22 */
  { 118, 239, &yyActionTable[2813] }, /*                    ids shift  239 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  56, 228, &yyActionTable[2815] }, /*                     LP shift  228 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  29,  16, &yyActionTable[2816] }, /*                    END shift  16 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
/* State 228 */
  { 140, 229, &yyActionTable[2818] }, /*                 signed shift  229 */
  {  68, 235, 0                    }, /*                   PLUS shift  235 */
  {  47, 234, 0                    }, /*                INTEGER shift  234 */
  {  59, 237, &yyActionTable[2819] }, /*                  MINUS shift  237 */
/* State 229 */
  {  15, 231, 0                    }, /*                  COMMA shift  231 */
  {  73, 230, &yyActionTable[2821] }, /*                     RP shift  230 */
/* State 230 */
  {YYNOCODE,0,0}, /* Unused */
/* State 231 */
  { 140, 232, &yyActionTable[2825] }, /*                 signed shift  232 */
  {  68, 235, 0                    }, /*                   PLUS shift  235 */
  {  47, 234, 0                    }, /*                INTEGER shift  234 */
  {  59, 237, &yyActionTable[2826] }, /*                  MINUS shift  237 */
/* State 232 */
  {  73, 233, 0                    }, /*                     RP shift  233 */
/* State 233 */
  {YYNOCODE,0,0}, /* Unused */
/* State 234 */
  {YYNOCODE,0,0}, /* Unused */
/* State 235 */
  {  47, 236, 0                    }, /*                INTEGER shift  236 */
/* State 236 */
  {YYNOCODE,0,0}, /* Unused */
/* State 237 */
  {  47, 238, 0                    }, /*                INTEGER shift  238 */
/* State 238 */
  {YYNOCODE,0,0}, /* Unused */
/* State 239 */
  {YYNOCODE,0,0}, /* Unused */
/* State 240 */
  {YYNOCODE,0,0}, /* Unused */
/* State 241 */
  {YYNOCODE,0,0}, /* Unused */
/* State 242 */
  {  88, 256, 0                    }, /*                 UNIQUE shift  256 */
  { 145, 262, &yyActionTable[2840] }, /*                  tcons shift  262 */
  {  73, 422, 0                    }, /*                     RP reduce 64 */
  {  19, 245, 0                    }, /*             CONSTRAINT shift  245 */
  {  12, 260, 0                    }, /*                  CHECK shift  260 */
  {YYNOCODE,0,0}, /* Unused */
  {  70, 247, 0                    }, /*                PRIMARY shift  247 */
  {  15, 243, 0                    }, /*                  COMMA shift  243 */
/* State 243 */
  {  88, 256, 0                    }, /*                 UNIQUE shift  256 */
  { 145, 244, 0                    }, /*                  tcons shift  244 */
  {YYNOCODE,0,0}, /* Unused */
  {  19, 245, 0                    }, /*             CONSTRAINT shift  245 */
  {  12, 260, 0                    }, /*                  CHECK shift  260 */
  {YYNOCODE,0,0}, /* Unused */
  {  70, 247, 0                    }, /*                PRIMARY shift  247 */
  {YYNOCODE,0,0}, /* Unused */
/* State 244 */
  {YYNOCODE,0,0}, /* Unused */
/* State 245 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  81,  23, &yyActionTable[2857] }, /*                 STRING shift  23 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  69,  17, &yyActionTable[2862] }, /*                 PRAGMA shift  17 */
  { 117,  22, &yyActionTable[2859] }, /*                     id shift  22 */
  { 118, 246, &yyActionTable[2867] }, /*                    ids shift  246 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  29,  16, &yyActionTable[2869] }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
/* State 246 */
  {YYNOCODE,0,0}, /* Unused */
/* State 247 */
  {  52, 248, 0                    }, /*                    KEY shift  248 */
/* State 248 */
  {  56, 249, 0                    }, /*                     LP shift  249 */
/* State 249 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {YYNOCODE,0,0}, /* Unused */
  {  69,  17, &yyActionTable[2876] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  23, 0                    }, /*                 STRING shift  23 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  22, 0                    }, /*                     id shift  22 */
  { 118, 254, 0                    }, /*                    ids shift  254 */
  { 119, 255, 0                    }, /*                idxitem shift  255 */
  { 120, 250, &yyActionTable[2877] }, /*                idxlist shift  250 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 250 */
  {  15, 252, 0                    }, /*                  COMMA shift  252 */
  {  73, 251, &yyActionTable[2906] }, /*                     RP shift  251 */
/* State 251 */
  {YYNOCODE,0,0}, /* Unused */
/* State 252 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  81,  23, &yyActionTable[2911] }, /*                 STRING shift  23 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  69,  17, &yyActionTable[2921] }, /*                 PRAGMA shift  17 */
  { 117,  22, &yyActionTable[2913] }, /*                     id shift  22 */
  { 118, 254, &yyActionTable[2923] }, /*                    ids shift  254 */
  { 119, 253, 0                    }, /*                idxitem shift  253 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  29,  16, &yyActionTable[2924] }, /*                    END shift  16 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
/* State 253 */
  {YYNOCODE,0,0}, /* Unused */
/* State 254 */
  {YYNOCODE,0,0}, /* Unused */
/* State 255 */
  {YYNOCODE,0,0}, /* Unused */
/* State 256 */
  {  56, 257, 0                    }, /*                     LP shift  257 */
/* State 257 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {YYNOCODE,0,0}, /* Unused */
  {  69,  17, &yyActionTable[2931] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  23, 0                    }, /*                 STRING shift  23 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  22, 0                    }, /*                     id shift  22 */
  { 118, 254, 0                    }, /*                    ids shift  254 */
  { 119, 255, 0                    }, /*                idxitem shift  255 */
  { 120, 258, &yyActionTable[2932] }, /*                idxlist shift  258 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 258 */
  {  15, 252, 0                    }, /*                  COMMA shift  252 */
  {  73, 259, &yyActionTable[2961] }, /*                     RP shift  259 */
/* State 259 */
  {YYNOCODE,0,0}, /* Unused */
/* State 260 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[2967] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 261, &yyActionTable[2971] }, /*                   expr shift  261 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[2972] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[2975] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[2976] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 261 */
  {   7, 141, 0                    }, /*                BETWEEN shift  141 */
  {   8, 108, 0                    }, /*                 BITAND shift  108 */
  {  66,  94, 0                    }, /*                     OR shift  94 */
  {   3,  86, 0                    }, /*                    AND shift  86 */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {  37, 102, 0                    }, /*                     GE shift  102 */
  {  38, 121, 0                    }, /*                   GLOB shift  121 */
  {  71, 131, &yyActionTable[2996] }, /*                    REM shift  131 */
  {  40,  98, &yyActionTable[2997] }, /*                     GT shift  98 */
  {  10, 110, 0                    }, /*                  BITOR shift  110 */
  {  74, 114, &yyActionTable[3005] }, /*                 RSHIFT shift  114 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {  44, 145, 0                    }, /*                     IN shift  145 */
  {YYNOCODE,0,0}, /* Unused */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {YYNOCODE,0,0}, /* Unused */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {YYNOCODE,0,0}, /* Unused */
  {  50, 136, &yyActionTable[3007] }, /*                     IS shift  136 */
  {  51, 135, 0                    }, /*                 ISNULL shift  135 */
  {YYNOCODE,0,0}, /* Unused */
  {  53, 100, 0                    }, /*                     LE shift  100 */
  {  54, 116, 0                    }, /*                   LIKE shift  116 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  57, 112, 0                    }, /*                 LSHIFT shift  112 */
  {  58,  96, 0                    }, /*                     LT shift  96 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {  60, 104, 0                    }, /*                     NE shift  104 */
  {  61, 118, 0                    }, /*                    NOT shift  118 */
  {  62, 140, 0                    }, /*                NOTNULL shift  140 */
  {  31, 106, 0                    }, /*                     EQ shift  106 */
/* State 262 */
  {YYNOCODE,0,0}, /* Unused */
/* State 263 */
  {YYNOCODE,0,0}, /* Unused */
/* State 264 */
  {YYNOCODE,0,0}, /* Unused */
/* State 265 */
  {  88, 278, 0                    }, /*                 UNIQUE shift  278 */
  {  82, 375, 0                    }, /*                  TABLE reduce 17 */
  { 146, 266, &yyActionTable[3032] }, /*                   temp shift  266 */
  {  83, 269, 0                    }, /*                   TEMP shift  269 */
  {YYNOCODE,0,0}, /* Unused */
  {  45, 546, 0                    }, /*                  INDEX reduce 188 */
  { 150, 270, 0                    }, /*             uniqueflag shift  270 */
  {YYNOCODE,0,0}, /* Unused */
/* State 266 */
  {  82, 267, 0                    }, /*                  TABLE shift  267 */
/* State 267 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  81,  23, &yyActionTable[3042] }, /*                 STRING shift  23 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  69,  17, &yyActionTable[3047] }, /*                 PRAGMA shift  17 */
  { 117,  22, &yyActionTable[3044] }, /*                     id shift  22 */
  { 118, 268, &yyActionTable[3052] }, /*                    ids shift  268 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  29,  16, &yyActionTable[3054] }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
/* State 268 */
  {  56, 373, 0                    }, /*                     LP reduce 15 */
/* State 269 */
  {  82, 374, 0                    }, /*                  TABLE reduce 16 */
/* State 270 */
  {  45, 271, 0                    }, /*                  INDEX shift  271 */
/* State 271 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  81,  23, &yyActionTable[3061] }, /*                 STRING shift  23 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  69,  17, &yyActionTable[3066] }, /*                 PRAGMA shift  17 */
  { 117,  22, &yyActionTable[3063] }, /*                     id shift  22 */
  { 118, 272, &yyActionTable[3071] }, /*                    ids shift  272 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  29,  16, &yyActionTable[3073] }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
/* State 272 */
  {  65, 273, 0                    }, /*                     ON shift  273 */
/* State 273 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  81,  23, &yyActionTable[3078] }, /*                 STRING shift  23 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  69,  17, &yyActionTable[3083] }, /*                 PRAGMA shift  17 */
  { 117,  22, &yyActionTable[3080] }, /*                     id shift  22 */
  { 118, 274, &yyActionTable[3088] }, /*                    ids shift  274 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  29,  16, &yyActionTable[3090] }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
/* State 274 */
  {  56, 275, 0                    }, /*                     LP shift  275 */
/* State 275 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {YYNOCODE,0,0}, /* Unused */
  {  69,  17, &yyActionTable[3095] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  23, 0                    }, /*                 STRING shift  23 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  22, 0                    }, /*                     id shift  22 */
  { 118, 254, 0                    }, /*                    ids shift  254 */
  { 119, 255, 0                    }, /*                idxitem shift  255 */
  { 120, 276, &yyActionTable[3096] }, /*                idxlist shift  276 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 276 */
  {  15, 252, 0                    }, /*                  COMMA shift  252 */
  {  73, 277, &yyActionTable[3125] }, /*                     RP shift  277 */
/* State 277 */
  {YYNOCODE,0,0}, /* Unused */
/* State 278 */
  {  45, 545, 0                    }, /*                  INDEX reduce 187 */
/* State 279 */
  {  82, 280, 0                    }, /*                  TABLE shift  280 */
  {  45, 282, 0                    }, /*                  INDEX shift  282 */
/* State 280 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  81,  23, &yyActionTable[3133] }, /*                 STRING shift  23 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  69,  17, &yyActionTable[3138] }, /*                 PRAGMA shift  17 */
  { 117,  22, &yyActionTable[3135] }, /*                     id shift  22 */
  { 118, 281, &yyActionTable[3143] }, /*                    ids shift  281 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  29,  16, &yyActionTable[3145] }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
/* State 281 */
  {YYNOCODE,0,0}, /* Unused */
/* State 282 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  81,  23, &yyActionTable[3150] }, /*                 STRING shift  23 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  69,  17, &yyActionTable[3155] }, /*                 PRAGMA shift  17 */
  { 117,  22, &yyActionTable[3152] }, /*                     id shift  22 */
  { 118, 283, &yyActionTable[3160] }, /*                    ids shift  283 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  29,  16, &yyActionTable[3162] }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
/* State 283 */
  {YYNOCODE,0,0}, /* Unused */
/* State 284 */
  {  48, 150, &yyActionTable[3166] }, /*              INTERSECT shift  150 */
  {  32, 151, 0                    }, /*                 EXCEPT shift  151 */
  { 126,  62, 0                    }, /*                 joinop shift  62 */
  {  87, 148, 0                    }, /*                  UNION shift  148 */
/* State 285 */
  {  35, 286, 0                    }, /*                   FROM shift  286 */
/* State 286 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  81,  23, &yyActionTable[3172] }, /*                 STRING shift  23 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  69,  17, &yyActionTable[3177] }, /*                 PRAGMA shift  17 */
  { 117,  22, &yyActionTable[3174] }, /*                     id shift  22 */
  { 118, 287, &yyActionTable[3182] }, /*                    ids shift  287 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  29,  16, &yyActionTable[3184] }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
/* State 287 */
  {  93, 187, 0                    }, /*                  WHERE shift  187 */
  { 151, 288, &yyActionTable[3186] }, /*              where_opt shift  288 */
/* State 288 */
  {YYNOCODE,0,0}, /* Unused */
/* State 289 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  81,  23, &yyActionTable[3191] }, /*                 STRING shift  23 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  69,  17, &yyActionTable[3196] }, /*                 PRAGMA shift  17 */
  { 117,  22, &yyActionTable[3193] }, /*                     id shift  22 */
  { 118, 290, &yyActionTable[3201] }, /*                    ids shift  290 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  29,  16, &yyActionTable[3203] }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
/* State 290 */
  {  77, 291, 0                    }, /*                    SET shift  291 */
/* State 291 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  81,  23, &yyActionTable[3208] }, /*                 STRING shift  23 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  69,  17, &yyActionTable[3213] }, /*                 PRAGMA shift  17 */
  { 117,  22, &yyActionTable[3210] }, /*                     id shift  22 */
  { 118, 298, &yyActionTable[3218] }, /*                    ids shift  298 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  { 139, 292, &yyActionTable[3220] }, /*                setlist shift  292 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  29,  16, &yyActionTable[3221] }, /*                    END shift  16 */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
/* State 292 */
  {  15, 294, 0                    }, /*                  COMMA shift  294 */
  {  93, 187, 0                    }, /*                  WHERE shift  187 */
  {YYNOCODE,0,0}, /* Unused */
  { 151, 293, &yyActionTable[3222] }, /*              where_opt shift  293 */
/* State 293 */
  {YYNOCODE,0,0}, /* Unused */
/* State 294 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  81,  23, &yyActionTable[3229] }, /*                 STRING shift  23 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  69,  17, &yyActionTable[3234] }, /*                 PRAGMA shift  17 */
  { 117,  22, &yyActionTable[3231] }, /*                     id shift  22 */
  { 118, 295, &yyActionTable[3239] }, /*                    ids shift  295 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  29,  16, &yyActionTable[3241] }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
/* State 295 */
  {  31, 296, 0                    }, /*                     EQ shift  296 */
/* State 296 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[3247] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 297, &yyActionTable[3251] }, /*                   expr shift  297 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[3252] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[3255] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[3256] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 297 */
  {   7, 141, 0                    }, /*                BETWEEN shift  141 */
  {   8, 108, 0                    }, /*                 BITAND shift  108 */
  {  66,  94, 0                    }, /*                     OR shift  94 */
  {   3,  86, 0                    }, /*                    AND shift  86 */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {  37, 102, 0                    }, /*                     GE shift  102 */
  {  38, 121, 0                    }, /*                   GLOB shift  121 */
  {  71, 131, &yyActionTable[3276] }, /*                    REM shift  131 */
  {  40,  98, &yyActionTable[3277] }, /*                     GT shift  98 */
  {  10, 110, 0                    }, /*                  BITOR shift  110 */
  {  74, 114, &yyActionTable[3285] }, /*                 RSHIFT shift  114 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {  44, 145, 0                    }, /*                     IN shift  145 */
  {YYNOCODE,0,0}, /* Unused */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {YYNOCODE,0,0}, /* Unused */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {YYNOCODE,0,0}, /* Unused */
  {  50, 136, &yyActionTable[3287] }, /*                     IS shift  136 */
  {  51, 135, 0                    }, /*                 ISNULL shift  135 */
  {YYNOCODE,0,0}, /* Unused */
  {  53, 100, 0                    }, /*                     LE shift  100 */
  {  54, 116, 0                    }, /*                   LIKE shift  116 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  57, 112, 0                    }, /*                 LSHIFT shift  112 */
  {  58,  96, 0                    }, /*                     LT shift  96 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {  60, 104, 0                    }, /*                     NE shift  104 */
  {  61, 118, 0                    }, /*                    NOT shift  118 */
  {  62, 140, 0                    }, /*                NOTNULL shift  140 */
  {  31, 106, 0                    }, /*                     EQ shift  106 */
/* State 298 */
  {  31, 299, 0                    }, /*                     EQ shift  299 */
/* State 299 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  34,  92, 0                    }, /*                  FLOAT shift  92 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  68, 160, 0                    }, /*                   PLUS shift  160 */
  {  69,  17, &yyActionTable[3312] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  47,  91, 0                    }, /*                INTEGER shift  91 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {   9, 156, 0                    }, /*                 BITNOT shift  156 */
  {  42,  55, 0                    }, /*                     ID shift  55 */
  {  59, 158, 0                    }, /*                  MINUS shift  158 */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  { 111, 300, &yyActionTable[3316] }, /*                   expr shift  300 */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  58, 0                    }, /*                 STRING shift  58 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  57, 0                    }, /*                     id shift  57 */
  { 118,  88, 0                    }, /*                    ids shift  88 */
  {YYNOCODE,0,0}, /* Unused */
  {  56,  59, &yyActionTable[3317] }, /*                     LP shift  59 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[3320] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  61, 154, &yyActionTable[3321] }, /*                    NOT shift  154 */
  {YYNOCODE,0,0}, /* Unused */
  {  63,  87, 0                    }, /*                   NULL shift  87 */
/* State 300 */
  {   7, 141, 0                    }, /*                BETWEEN shift  141 */
  {   8, 108, 0                    }, /*                 BITAND shift  108 */
  {  66,  94, 0                    }, /*                     OR shift  94 */
  {   3,  86, 0                    }, /*                    AND shift  86 */
  {  68, 123, 0                    }, /*                   PLUS shift  123 */
  {  37, 102, 0                    }, /*                     GE shift  102 */
  {  38, 121, 0                    }, /*                   GLOB shift  121 */
  {  71, 131, &yyActionTable[3341] }, /*                    REM shift  131 */
  {  40,  98, &yyActionTable[3342] }, /*                     GT shift  98 */
  {  10, 110, 0                    }, /*                  BITOR shift  110 */
  {  74, 114, &yyActionTable[3350] }, /*                 RSHIFT shift  114 */
  {  18, 133, 0                    }, /*                 CONCAT shift  133 */
  {  44, 145, 0                    }, /*                     IN shift  145 */
  {YYNOCODE,0,0}, /* Unused */
  {  78, 129, 0                    }, /*                  SLASH shift  129 */
  {YYNOCODE,0,0}, /* Unused */
  {  80, 127, 0                    }, /*                   STAR shift  127 */
  {YYNOCODE,0,0}, /* Unused */
  {  50, 136, &yyActionTable[3352] }, /*                     IS shift  136 */
  {  51, 135, 0                    }, /*                 ISNULL shift  135 */
  {YYNOCODE,0,0}, /* Unused */
  {  53, 100, 0                    }, /*                     LE shift  100 */
  {  54, 116, 0                    }, /*                   LIKE shift  116 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  57, 112, 0                    }, /*                 LSHIFT shift  112 */
  {  58,  96, 0                    }, /*                     LT shift  96 */
  {  59, 125, 0                    }, /*                  MINUS shift  125 */
  {  60, 104, 0                    }, /*                     NE shift  104 */
  {  61, 118, 0                    }, /*                    NOT shift  118 */
  {  62, 140, 0                    }, /*                NOTNULL shift  140 */
  {  31, 106, 0                    }, /*                     EQ shift  106 */
/* State 301 */
  {  49, 302, 0                    }, /*                   INTO shift  302 */
/* State 302 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  81,  23, &yyActionTable[3376] }, /*                 STRING shift  23 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  69,  17, &yyActionTable[3381] }, /*                 PRAGMA shift  17 */
  { 117,  22, &yyActionTable[3378] }, /*                     id shift  22 */
  { 118, 303, &yyActionTable[3386] }, /*                    ids shift  303 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  29,  16, &yyActionTable[3388] }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
/* State 303 */
  {  56, 323, 0                    }, /*                     LP shift  323 */
  { 123, 304, 0                    }, /*         inscollist_opt shift  304 */
/* State 304 */
  {  92, 306, 0                    }, /*                 VALUES shift  306 */
  { 137, 305, 0                    }, /*                 select shift  305 */
  {  75,  64, 0                    }, /*                 SELECT shift  64 */
  { 131,  60, &yyActionTable[3394] }, /*              oneselect shift  60 */
/* State 305 */
  {  48, 150, &yyActionTable[3397] }, /*              INTERSECT shift  150 */
  {  32, 151, 0                    }, /*                 EXCEPT shift  151 */
  { 126,  62, 0                    }, /*                 joinop shift  62 */
  {  87, 148, 0                    }, /*                  UNION shift  148 */
/* State 306 */
  {  56, 307, 0                    }, /*                     LP shift  307 */
/* State 307 */
  {  68, 313, 0                    }, /*                   PLUS shift  313 */
  {  81, 320, 0                    }, /*                 STRING shift  320 */
  {  34, 319, 0                    }, /*                  FLOAT shift  319 */
  {  59, 316, 0                    }, /*                  MINUS shift  316 */
  { 124, 322, &yyActionTable[3401] }, /*                   item shift  322 */
  { 125, 308, 0                    }, /*               itemlist shift  308 */
  {  47, 312, 0                    }, /*                INTEGER shift  312 */
  {  63, 321, &yyActionTable[3407] }, /*                   NULL shift  321 */
/* State 308 */
  {  15, 310, 0                    }, /*                  COMMA shift  310 */
  {  73, 309, &yyActionTable[3409] }, /*                     RP shift  309 */
/* State 309 */
  {YYNOCODE,0,0}, /* Unused */
/* State 310 */
  {  68, 313, 0                    }, /*                   PLUS shift  313 */
  {  81, 320, 0                    }, /*                 STRING shift  320 */
  {  34, 319, 0                    }, /*                  FLOAT shift  319 */
  {  59, 316, 0                    }, /*                  MINUS shift  316 */
  { 124, 311, &yyActionTable[3412] }, /*                   item shift  311 */
  {  47, 312, 0                    }, /*                INTEGER shift  312 */
  {YYNOCODE,0,0}, /* Unused */
  {  63, 321, &yyActionTable[3417] }, /*                   NULL shift  321 */
/* State 311 */
  {YYNOCODE,0,0}, /* Unused */
/* State 312 */
  {YYNOCODE,0,0}, /* Unused */
/* State 313 */
  {  34, 315, 0                    }, /*                  FLOAT shift  315 */
  {  47, 314, 0                    }, /*                INTEGER shift  314 */
/* State 314 */
  {YYNOCODE,0,0}, /* Unused */
/* State 315 */
  {YYNOCODE,0,0}, /* Unused */
/* State 316 */
  {  34, 318, 0                    }, /*                  FLOAT shift  318 */
  {  47, 317, 0                    }, /*                INTEGER shift  317 */
/* State 317 */
  {YYNOCODE,0,0}, /* Unused */
/* State 318 */
  {YYNOCODE,0,0}, /* Unused */
/* State 319 */
  {YYNOCODE,0,0}, /* Unused */
/* State 320 */
  {YYNOCODE,0,0}, /* Unused */
/* State 321 */
  {YYNOCODE,0,0}, /* Unused */
/* State 322 */
  {YYNOCODE,0,0}, /* Unused */
/* State 323 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  81,  23, &yyActionTable[3436] }, /*                 STRING shift  23 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  69,  17, &yyActionTable[3441] }, /*                 PRAGMA shift  17 */
  { 117,  22, &yyActionTable[3438] }, /*                     id shift  22 */
  { 118, 328, &yyActionTable[3446] }, /*                    ids shift  328 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  { 122, 324, &yyActionTable[3448] }, /*             inscollist shift  324 */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  29,  16, &yyActionTable[3449] }, /*                    END shift  16 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
/* State 324 */
  {  15, 326, 0                    }, /*                  COMMA shift  326 */
  {  73, 325, &yyActionTable[3450] }, /*                     RP shift  325 */
/* State 325 */
  {YYNOCODE,0,0}, /* Unused */
/* State 326 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  81,  23, &yyActionTable[3455] }, /*                 STRING shift  23 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  69,  17, &yyActionTable[3460] }, /*                 PRAGMA shift  17 */
  { 117,  22, &yyActionTable[3457] }, /*                     id shift  22 */
  { 118, 327, &yyActionTable[3465] }, /*                    ids shift  327 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  29,  16, &yyActionTable[3467] }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
/* State 327 */
  {YYNOCODE,0,0}, /* Unused */
/* State 328 */
  {YYNOCODE,0,0}, /* Unused */
/* State 329 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  81,  23, &yyActionTable[3473] }, /*                 STRING shift  23 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  69,  17, &yyActionTable[3478] }, /*                 PRAGMA shift  17 */
  { 117,  22, &yyActionTable[3475] }, /*                     id shift  22 */
  { 118, 330, &yyActionTable[3483] }, /*                    ids shift  330 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  29,  16, &yyActionTable[3485] }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
/* State 330 */
  {  35, 331, 0                    }, /*                   FROM shift  331 */
/* State 331 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  81,  23, &yyActionTable[3490] }, /*                 STRING shift  23 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  69,  17, &yyActionTable[3495] }, /*                 PRAGMA shift  17 */
  { 117,  22, &yyActionTable[3492] }, /*                     id shift  22 */
  { 118, 332, &yyActionTable[3500] }, /*                    ids shift  332 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  29,  16, &yyActionTable[3502] }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
/* State 332 */
  {  90, 333, 0                    }, /*                  USING shift  333 */
/* State 333 */
  {  24, 334, 0                    }, /*             DELIMITERS shift  334 */
/* State 334 */
  {  81, 335, 0                    }, /*                 STRING shift  335 */
/* State 335 */
  {YYNOCODE,0,0}, /* Unused */
/* State 336 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  81,  23, &yyActionTable[3510] }, /*                 STRING shift  23 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  69,  17, &yyActionTable[3515] }, /*                 PRAGMA shift  17 */
  { 117,  22, &yyActionTable[3512] }, /*                     id shift  22 */
  { 118, 337, &yyActionTable[3520] }, /*                    ids shift  337 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  29,  16, &yyActionTable[3522] }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
/* State 337 */
  {YYNOCODE,0,0}, /* Unused */
/* State 338 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  81,  23, &yyActionTable[3527] }, /*                 STRING shift  23 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  69,  17, &yyActionTable[3532] }, /*                 PRAGMA shift  17 */
  { 117,  22, &yyActionTable[3529] }, /*                     id shift  22 */
  { 118, 339, &yyActionTable[3537] }, /*                    ids shift  339 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  29,  16, &yyActionTable[3539] }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
/* State 339 */
  {  56, 352, 0                    }, /*                     LP shift  352 */
  {  31, 340, 0                    }, /*                     EQ shift  340 */
/* State 340 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  { 129, 344, &yyActionTable[3545] }, /*              minus_num shift  344 */
  {  65, 342, &yyActionTable[3546] }, /*                     ON shift  342 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  68, 351, 0                    }, /*                   PLUS shift  351 */
  { 133, 343, &yyActionTable[3550] }, /*               plus_num shift  343 */
  { 134, 345, &yyActionTable[3551] }, /*               plus_opt shift  345 */
  {  69,  17, &yyActionTable[3552] }, /*                 PRAGMA shift  17 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {  59, 349, 0                    }, /*                  MINUS shift  349 */
  {YYNOCODE,0,0}, /* Unused */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  81,  23, 0                    }, /*                 STRING shift  23 */
  {YYNOCODE,0,0}, /* Unused */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {YYNOCODE,0,0}, /* Unused */
  { 117,  22, 0                    }, /*                     id shift  22 */
  { 118, 341, 0                    }, /*                    ids shift  341 */
  {YYNOCODE,0,0}, /* Unused */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  91,  14, &yyActionTable[3554] }, /*                 VACUUM shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  16, 0                    }, /*                    END shift  16 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 341 */
  {YYNOCODE,0,0}, /* Unused */
/* State 342 */
  {YYNOCODE,0,0}, /* Unused */
/* State 343 */
  {YYNOCODE,0,0}, /* Unused */
/* State 344 */
  {YYNOCODE,0,0}, /* Unused */
/* State 345 */
  {  34, 348, 0                    }, /*                  FLOAT shift  348 */
  {YYNOCODE,0,0}, /* Unused */
  { 130, 346, &yyActionTable[3579] }, /*                 number shift  346 */
  {  47, 347, 0                    }, /*                INTEGER shift  347 */
/* State 346 */
  {YYNOCODE,0,0}, /* Unused */
/* State 347 */
  {YYNOCODE,0,0}, /* Unused */
/* State 348 */
  {YYNOCODE,0,0}, /* Unused */
/* State 349 */
  {  34, 348, 0                    }, /*                  FLOAT shift  348 */
  {YYNOCODE,0,0}, /* Unused */
  { 130, 350, &yyActionTable[3586] }, /*                 number shift  350 */
  {  47, 347, 0                    }, /*                INTEGER shift  347 */
/* State 350 */
  {YYNOCODE,0,0}, /* Unused */
/* State 351 */
  {YYNOCODE,0,0}, /* Unused */
/* State 352 */
  {  64,  21, 0                    }, /*                 OFFSET shift  21 */
  {  81,  23, &yyActionTable[3594] }, /*                 STRING shift  23 */
  {  33,  13, 0                    }, /*                EXPLAIN shift  13 */
  {  83,  20, 0                    }, /*                   TEMP shift  20 */
  {  69,  17, &yyActionTable[3599] }, /*                 PRAGMA shift  17 */
  { 117,  22, &yyActionTable[3596] }, /*                     id shift  22 */
  { 118, 353, &yyActionTable[3604] }, /*                    ids shift  353 */
  {   5,  11, 0                    }, /*                    ASC shift  11 */
  {  24,  12, 0                    }, /*             DELIMITERS shift  12 */
  {  25,  10, 0                    }, /*                   DESC shift  10 */
  {  42,  19, 0                    }, /*                     ID shift  19 */
  {  91,  14, 0                    }, /*                 VACUUM shift  14 */
  {   6,  15, 0                    }, /*                  BEGIN shift  15 */
  {  29,  16, &yyActionTable[3606] }, /*                    END shift  16 */
  {  13,  18, 0                    }, /*                CLUSTER shift  18 */
  {YYNOCODE,0,0}, /* Unused */
/* State 353 */
  {  73, 354, 0                    }, /*                     RP shift  354 */
/* State 354 */
  {YYNOCODE,0,0}, /* Unused */
/* State 355 */
  {YYNOCODE,0,0}, /* Unused */
/* State 356 */
  {YYNOCODE,0,0}, /* Unused */
/* State 357 */
  {YYNOCODE,0,0}, /* Unused */
};

/* The state table contains information needed to look up the correct
** action in the action table, given the current state of the parser.
** Information needed includes:
**
**  +  A pointer to the start of the action hash table in yyActionTable.
**
**  +  A mask used to hash the look-ahead token.  The mask is an integer
**     which is one less than the size of the hash table.  
**
**  +  The default action.  This is the action to take if no entry for
**     the given look-ahead is found in the action hash table.
*/
struct yyStateEntry {
  struct yyActionEntry *hashtbl; /* Start of the hash table in yyActionTable */
  int mask;                      /* Mask used for hashing the look-ahead */
  YYACTIONTYPE actionDefault;    /* Default action if look-ahead not found */
};
static struct yyStateEntry yyStateTable[] = {
  { &yyActionTable[0], 31, 363},
  { &yyActionTable[32], 1, 566},
  { &yyActionTable[34], 31, 363},
  { &yyActionTable[66], 0, 360},
  { &yyActionTable[67], 31, 566},
  { &yyActionTable[99], 0, 361},
  { &yyActionTable[100], 1, 366},
  { &yyActionTable[102], 0, 365},
  { &yyActionTable[103], 15, 367},
  { &yyActionTable[119], 0, 368},
  { &yyActionTable[120], 0, 381},
  { &yyActionTable[121], 0, 382},
  { &yyActionTable[122], 0, 383},
  { &yyActionTable[123], 0, 384},
  { &yyActionTable[124], 0, 385},
  { &yyActionTable[125], 0, 386},
  { &yyActionTable[126], 0, 387},
  { &yyActionTable[127], 0, 388},
  { &yyActionTable[128], 0, 389},
  { &yyActionTable[129], 0, 390},
  { &yyActionTable[130], 0, 391},
  { &yyActionTable[131], 0, 392},
  { &yyActionTable[132], 0, 393},
  { &yyActionTable[133], 0, 394},
  { &yyActionTable[134], 1, 366},
  { &yyActionTable[136], 0, 369},
  { &yyActionTable[137], 1, 366},
  { &yyActionTable[139], 0, 370},
  { &yyActionTable[140], 1, 366},
  { &yyActionTable[142], 0, 371},
  { &yyActionTable[143], 1, 566},
  { &yyActionTable[145], 0, 372},
  { &yyActionTable[146], 31, 566},
  { &yyActionTable[178], 3, 566},
  { &yyActionTable[182], 0, 566},
  { &yyActionTable[183], 0, 376},
  { &yyActionTable[184], 31, 566},
  { &yyActionTable[216], 0, 377},
  { &yyActionTable[217], 31, 395},
  { &yyActionTable[249], 0, 405},
  { &yyActionTable[250], 7, 379},
  { &yyActionTable[258], 0, 404},
  { &yyActionTable[259], 15, 566},
  { &yyActionTable[275], 7, 566},
  { &yyActionTable[283], 0, 406},
  { &yyActionTable[284], 0, 566},
  { &yyActionTable[285], 0, 417},
  { &yyActionTable[286], 0, 566},
  { &yyActionTable[287], 3, 461},
  { &yyActionTable[291], 0, 418},
  { &yyActionTable[292], 0, 459},
  { &yyActionTable[293], 0, 460},
  { &yyActionTable[294], 0, 419},
  { &yyActionTable[295], 0, 566},
  { &yyActionTable[296], 31, 566},
  { &yyActionTable[328], 0, 390},
  { &yyActionTable[329], 31, 543},
  { &yyActionTable[361], 63, 566},
  { &yyActionTable[425], 63, 566},
  { &yyActionTable[489], 31, 566},
  { &yyActionTable[521], 0, 432},
  { &yyActionTable[522], 7, 566},
  { &yyActionTable[530], 1, 566},
  { &yyActionTable[532], 0, 433},
  { &yyActionTable[533], 3, 441},
  { &yyActionTable[537], 3, 443},
  { &yyActionTable[541], 3, 566},
  { &yyActionTable[545], 1, 472},
  { &yyActionTable[547], 1, 462},
  { &yyActionTable[549], 1, 464},
  { &yyActionTable[551], 1, 454},
  { &yyActionTable[553], 1, 466},
  { &yyActionTable[555], 0, 438},
  { &yyActionTable[556], 0, 566},
  { &yyActionTable[557], 3, 467},
  { &yyActionTable[561], 0, 566},
  { &yyActionTable[562], 0, 468},
  { &yyActionTable[563], 0, 566},
  { &yyActionTable[564], 0, 566},
  { &yyActionTable[565], 0, 566},
  { &yyActionTable[566], 31, 566},
  { &yyActionTable[598], 0, 455},
  { &yyActionTable[599], 31, 566},
  { &yyActionTable[631], 3, 461},
  { &yyActionTable[635], 0, 456},
  { &yyActionTable[636], 31, 458},
  { &yyActionTable[668], 31, 566},
  { &yyActionTable[700], 0, 494},
  { &yyActionTable[701], 0, 566},
  { &yyActionTable[702], 15, 566},
  { &yyActionTable[718], 0, 496},
  { &yyActionTable[719], 0, 497},
  { &yyActionTable[720], 0, 498},
  { &yyActionTable[721], 31, 502},
  { &yyActionTable[753], 31, 566},
  { &yyActionTable[785], 31, 503},
  { &yyActionTable[817], 31, 566},
  { &yyActionTable[849], 15, 504},
  { &yyActionTable[865], 31, 566},
  { &yyActionTable[897], 15, 505},
  { &yyActionTable[913], 31, 566},
  { &yyActionTable[945], 15, 506},
  { &yyActionTable[961], 31, 566},
  { &yyActionTable[993], 15, 507},
  { &yyActionTable[1009], 31, 566},
  { &yyActionTable[1041], 15, 508},
  { &yyActionTable[1057], 31, 566},
  { &yyActionTable[1089], 15, 509},
  { &yyActionTable[1105], 31, 566},
  { &yyActionTable[1137], 7, 510},
  { &yyActionTable[1145], 31, 566},
  { &yyActionTable[1177], 7, 511},
  { &yyActionTable[1185], 31, 566},
  { &yyActionTable[1217], 7, 512},
  { &yyActionTable[1225], 31, 566},
  { &yyActionTable[1257], 7, 513},
  { &yyActionTable[1265], 31, 566},
  { &yyActionTable[1297], 15, 514},
  { &yyActionTable[1313], 7, 566},
  { &yyActionTable[1321], 31, 566},
  { &yyActionTable[1353], 31, 515},
  { &yyActionTable[1385], 31, 566},
  { &yyActionTable[1417], 15, 516},
  { &yyActionTable[1433], 31, 566},
  { &yyActionTable[1465], 3, 518},
  { &yyActionTable[1469], 31, 566},
  { &yyActionTable[1501], 3, 519},
  { &yyActionTable[1505], 31, 566},
  { &yyActionTable[1537], 0, 520},
  { &yyActionTable[1538], 31, 566},
  { &yyActionTable[1570], 0, 521},
  { &yyActionTable[1571], 31, 566},
  { &yyActionTable[1603], 0, 522},
  { &yyActionTable[1604], 31, 566},
  { &yyActionTable[1636], 0, 523},
  { &yyActionTable[1637], 0, 524},
  { &yyActionTable[1638], 1, 566},
  { &yyActionTable[1640], 0, 525},
  { &yyActionTable[1641], 0, 566},
  { &yyActionTable[1642], 0, 528},
  { &yyActionTable[1643], 0, 526},
  { &yyActionTable[1644], 31, 566},
  { &yyActionTable[1676], 31, 566},
  { &yyActionTable[1708], 31, 566},
  { &yyActionTable[1740], 63, 566},
  { &yyActionTable[1804], 0, 566},
  { &yyActionTable[1805], 31, 543},
  { &yyActionTable[1837], 7, 566},
  { &yyActionTable[1845], 1, 566},
  { &yyActionTable[1847], 0, 566},
  { &yyActionTable[1848], 0, 566},
  { &yyActionTable[1849], 0, 566},
  { &yyActionTable[1850], 0, 537},
  { &yyActionTable[1851], 31, 542},
  { &yyActionTable[1883], 31, 566},
  { &yyActionTable[1915], 31, 529},
  { &yyActionTable[1947], 31, 566},
  { &yyActionTable[1979], 0, 530},
  { &yyActionTable[1980], 31, 566},
  { &yyActionTable[2012], 0, 531},
  { &yyActionTable[2013], 31, 566},
  { &yyActionTable[2045], 0, 532},
  { &yyActionTable[2046], 1, 566},
  { &yyActionTable[2048], 0, 536},
  { &yyActionTable[2049], 31, 543},
  { &yyActionTable[2081], 0, 540},
  { &yyActionTable[2082], 0, 541},
  { &yyActionTable[2083], 31, 566},
  { &yyActionTable[2115], 31, 517},
  { &yyActionTable[2147], 0, 527},
  { &yyActionTable[2148], 31, 566},
  { &yyActionTable[2180], 31, 566},
  { &yyActionTable[2212], 31, 566},
  { &yyActionTable[2244], 63, 566},
  { &yyActionTable[2308], 0, 566},
  { &yyActionTable[2309], 31, 543},
  { &yyActionTable[2341], 7, 566},
  { &yyActionTable[2349], 0, 539},
  { &yyActionTable[2350], 1, 566},
  { &yyActionTable[2352], 0, 538},
  { &yyActionTable[2353], 3, 461},
  { &yyActionTable[2357], 0, 457},
  { &yyActionTable[2358], 31, 566},
  { &yyActionTable[2390], 31, 465},
  { &yyActionTable[2422], 0, 566},
  { &yyActionTable[2423], 31, 543},
  { &yyActionTable[2455], 0, 463},
  { &yyActionTable[2456], 31, 566},
  { &yyActionTable[2488], 31, 473},
  { &yyActionTable[2520], 0, 442},
  { &yyActionTable[2521], 1, 451},
  { &yyActionTable[2523], 0, 449},
  { &yyActionTable[2524], 0, 450},
  { &yyActionTable[2525], 15, 566},
  { &yyActionTable[2541], 31, 566},
  { &yyActionTable[2573], 0, 448},
  { &yyActionTable[2574], 15, 566},
  { &yyActionTable[2590], 0, 453},
  { &yyActionTable[2591], 0, 444},
  { &yyActionTable[2592], 31, 566},
  { &yyActionTable[2624], 63, 566},
  { &yyActionTable[2688], 15, 566},
  { &yyActionTable[2704], 0, 446},
  { &yyActionTable[2705], 0, 439},
  { &yyActionTable[2706], 0, 440},
  { &yyActionTable[2707], 0, 533},
  { &yyActionTable[2708], 31, 566},
  { &yyActionTable[2740], 0, 493},
  { &yyActionTable[2741], 1, 566},
  { &yyActionTable[2743], 0, 500},
  { &yyActionTable[2744], 0, 566},
  { &yyActionTable[2745], 0, 501},
  { &yyActionTable[2746], 31, 566},
  { &yyActionTable[2778], 0, 420},
  { &yyActionTable[2779], 0, 407},
  { &yyActionTable[2780], 7, 566},
  { &yyActionTable[2788], 0, 408},
  { &yyActionTable[2789], 0, 409},
  { &yyActionTable[2790], 0, 410},
  { &yyActionTable[2791], 1, 566},
  { &yyActionTable[2793], 0, 411},
  { &yyActionTable[2794], 0, 414},
  { &yyActionTable[2795], 1, 566},
  { &yyActionTable[2797], 0, 412},
  { &yyActionTable[2798], 0, 415},
  { &yyActionTable[2799], 0, 413},
  { &yyActionTable[2800], 0, 416},
  { &yyActionTable[2801], 15, 396},
  { &yyActionTable[2817], 3, 566},
  { &yyActionTable[2821], 1, 566},
  { &yyActionTable[2823], 0, 397},
  { &yyActionTable[2824], 3, 566},
  { &yyActionTable[2828], 0, 566},
  { &yyActionTable[2829], 0, 398},
  { &yyActionTable[2830], 0, 401},
  { &yyActionTable[2831], 0, 566},
  { &yyActionTable[2832], 0, 402},
  { &yyActionTable[2833], 0, 566},
  { &yyActionTable[2834], 0, 403},
  { &yyActionTable[2835], 0, 400},
  { &yyActionTable[2836], 0, 399},
  { &yyActionTable[2837], 0, 380},
  { &yyActionTable[2838], 7, 566},
  { &yyActionTable[2846], 7, 566},
  { &yyActionTable[2854], 0, 423},
  { &yyActionTable[2855], 15, 566},
  { &yyActionTable[2871], 0, 426},
  { &yyActionTable[2872], 0, 566},
  { &yyActionTable[2873], 0, 566},
  { &yyActionTable[2874], 31, 566},
  { &yyActionTable[2906], 1, 566},
  { &yyActionTable[2908], 0, 427},
  { &yyActionTable[2909], 15, 566},
  { &yyActionTable[2925], 0, 547},
  { &yyActionTable[2926], 0, 549},
  { &yyActionTable[2927], 0, 548},
  { &yyActionTable[2928], 0, 566},
  { &yyActionTable[2929], 31, 566},
  { &yyActionTable[2961], 1, 566},
  { &yyActionTable[2963], 0, 428},
  { &yyActionTable[2964], 31, 566},
  { &yyActionTable[2996], 31, 429},
  { &yyActionTable[3028], 0, 424},
  { &yyActionTable[3029], 0, 425},
  { &yyActionTable[3030], 0, 378},
  { &yyActionTable[3031], 7, 566},
  { &yyActionTable[3039], 0, 566},
  { &yyActionTable[3040], 15, 566},
  { &yyActionTable[3056], 0, 566},
  { &yyActionTable[3057], 0, 566},
  { &yyActionTable[3058], 0, 566},
  { &yyActionTable[3059], 15, 566},
  { &yyActionTable[3075], 0, 566},
  { &yyActionTable[3076], 15, 566},
  { &yyActionTable[3092], 0, 566},
  { &yyActionTable[3093], 31, 566},
  { &yyActionTable[3125], 1, 566},
  { &yyActionTable[3127], 0, 544},
  { &yyActionTable[3128], 0, 566},
  { &yyActionTable[3129], 1, 566},
  { &yyActionTable[3131], 15, 566},
  { &yyActionTable[3147], 0, 430},
  { &yyActionTable[3148], 15, 566},
  { &yyActionTable[3164], 0, 550},
  { &yyActionTable[3165], 3, 431},
  { &yyActionTable[3169], 0, 566},
  { &yyActionTable[3170], 15, 566},
  { &yyActionTable[3186], 1, 472},
  { &yyActionTable[3188], 0, 471},
  { &yyActionTable[3189], 15, 566},
  { &yyActionTable[3205], 0, 566},
  { &yyActionTable[3206], 15, 566},
  { &yyActionTable[3222], 3, 472},
  { &yyActionTable[3226], 0, 474},
  { &yyActionTable[3227], 15, 566},
  { &yyActionTable[3243], 0, 566},
  { &yyActionTable[3244], 31, 566},
  { &yyActionTable[3276], 31, 475},
  { &yyActionTable[3308], 0, 566},
  { &yyActionTable[3309], 31, 566},
  { &yyActionTable[3341], 31, 476},
  { &yyActionTable[3373], 0, 566},
  { &yyActionTable[3374], 15, 566},
  { &yyActionTable[3390], 1, 489},
  { &yyActionTable[3392], 3, 566},
  { &yyActionTable[3396], 3, 478},
  { &yyActionTable[3400], 0, 566},
  { &yyActionTable[3401], 7, 566},
  { &yyActionTable[3409], 1, 566},
  { &yyActionTable[3411], 0, 477},
  { &yyActionTable[3412], 7, 566},
  { &yyActionTable[3420], 0, 479},
  { &yyActionTable[3421], 0, 481},
  { &yyActionTable[3422], 1, 566},
  { &yyActionTable[3424], 0, 482},
  { &yyActionTable[3425], 0, 485},
  { &yyActionTable[3426], 1, 566},
  { &yyActionTable[3428], 0, 483},
  { &yyActionTable[3429], 0, 486},
  { &yyActionTable[3430], 0, 484},
  { &yyActionTable[3431], 0, 487},
  { &yyActionTable[3432], 0, 488},
  { &yyActionTable[3433], 0, 480},
  { &yyActionTable[3434], 15, 566},
  { &yyActionTable[3450], 1, 566},
  { &yyActionTable[3452], 0, 490},
  { &yyActionTable[3453], 15, 566},
  { &yyActionTable[3469], 0, 491},
  { &yyActionTable[3470], 0, 492},
  { &yyActionTable[3471], 15, 566},
  { &yyActionTable[3487], 0, 566},
  { &yyActionTable[3488], 15, 566},
  { &yyActionTable[3504], 0, 552},
  { &yyActionTable[3505], 0, 566},
  { &yyActionTable[3506], 0, 566},
  { &yyActionTable[3507], 0, 551},
  { &yyActionTable[3508], 15, 553},
  { &yyActionTable[3524], 0, 554},
  { &yyActionTable[3525], 15, 566},
  { &yyActionTable[3541], 1, 566},
  { &yyActionTable[3543], 31, 565},
  { &yyActionTable[3575], 0, 555},
  { &yyActionTable[3576], 0, 556},
  { &yyActionTable[3577], 0, 557},
  { &yyActionTable[3578], 0, 558},
  { &yyActionTable[3579], 3, 566},
  { &yyActionTable[3583], 0, 560},
  { &yyActionTable[3584], 0, 562},
  { &yyActionTable[3585], 0, 563},
  { &yyActionTable[3586], 3, 566},
  { &yyActionTable[3590], 0, 561},
  { &yyActionTable[3591], 0, 564},
  { &yyActionTable[3592], 15, 566},
  { &yyActionTable[3608], 0, 566},
  { &yyActionTable[3609], 0, 559},
  { &yyActionTable[3610], 0, 362},
  { &yyActionTable[3611], 0, 364},
  { &yyActionTable[3612], 0, 359},
};

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int idx;                            /* Index of top element in stack */
  int errcnt;                         /* Shifts left before out of the error */
  struct yyStackEntry *top;           /* Pointer to the top stack element */
  struct yyStackEntry stack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;

/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqliteParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}

/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static char *yyTokenName[] = { 
  "$",             "AGG_FUNCTION",  "ALL",           "AND",         
  "AS",            "ASC",           "BEGIN",         "BETWEEN",     
  "BITAND",        "BITNOT",        "BITOR",         "BY",          
  "CHECK",         "CLUSTER",       "COLUMN",        "COMMA",       
  "COMMENT",       "COMMIT",        "CONCAT",        "CONSTRAINT",  
  "COPY",          "CREATE",        "DEFAULT",       "DELETE",      
  "DELIMITERS",    "DESC",          "DISTINCT",      "DOT",         
  "DROP",          "END",           "END_OF_FILE",   "EQ",          
  "EXCEPT",        "EXPLAIN",       "FLOAT",         "FROM",        
  "FUNCTION",      "GE",            "GLOB",          "GROUP",       
  "GT",            "HAVING",        "ID",            "ILLEGAL",     
  "IN",            "INDEX",         "INSERT",        "INTEGER",     
  "INTERSECT",     "INTO",          "IS",            "ISNULL",      
  "KEY",           "LE",            "LIKE",          "LIMIT",       
  "LP",            "LSHIFT",        "LT",            "MINUS",       
  "NE",            "NOT",           "NOTNULL",       "NULL",        
  "OFFSET",        "ON",            "OR",            "ORDER",       
  "PLUS",          "PRAGMA",        "PRIMARY",       "REM",         
  "ROLLBACK",      "RP",            "RSHIFT",        "SELECT",      
  "SEMI",          "SET",           "SLASH",         "SPACE",       
  "STAR",          "STRING",        "TABLE",         "TEMP",        
  "TRANSACTION",   "UMINUS",        "UNCLOSED_STRING",  "UNION",       
  "UNIQUE",        "UPDATE",        "USING",         "VACUUM",      
  "VALUES",        "WHERE",         "as",            "carg",        
  "carglist",      "ccons",         "cmd",           "cmdlist",     
  "column",        "columnid",      "columnlist",    "conslist",    
  "conslist_opt",  "create_table",  "create_table_args",  "distinct",    
  "ecmd",          "error",         "explain",       "expr",        
  "expritem",      "exprlist",      "from",          "groupby_opt", 
  "having_opt",    "id",            "ids",           "idxitem",     
  "idxlist",       "input",         "inscollist",    "inscollist_opt",
  "item",          "itemlist",      "joinop",        "limit_opt",   
  "limit_sep",     "minus_num",     "number",        "oneselect",   
  "orderby_opt",   "plus_num",      "plus_opt",      "sclp",        
  "selcollist",    "select",        "seltablist",    "setlist",     
  "signed",        "sortitem",      "sortlist",      "sortorder",   
  "stl_prefix",    "tcons",         "temp",          "trans_opt",   
  "type",          "typename",      "uniqueflag",    "where_opt",   
};
#define YYTRACE(X) if( yyTraceFILE ) fprintf(yyTraceFILE,"%sReduce [%s].\n",yyTracePrompt,X);
#else
#define YYTRACE(X)
#endif


/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqliteParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqliteParser and sqliteParserFree.
*/
void *sqliteParserAlloc(void *(*mallocProc)(int)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (int)sizeof(yyParser) );
  if( pParser ){
    pParser->idx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 111:
#line 353 "../../../providers/default/sqlite/parse.y"
{sqliteExprDelete((yypminor->yy210));}
#line 4630 "../../../providers/default/sqlite/parse.c"
      break;
    case 112:
#line 488 "../../../providers/default/sqlite/parse.y"
{sqliteExprDelete((yypminor->yy210));}
#line 4635 "../../../providers/default/sqlite/parse.c"
      break;
    case 113:
#line 486 "../../../providers/default/sqlite/parse.y"
{sqliteExprListDelete((yypminor->yy192));}
#line 4640 "../../../providers/default/sqlite/parse.c"
      break;
    case 114:
#line 222 "../../../providers/default/sqlite/parse.y"
{sqliteIdListDelete((yypminor->yy162));}
#line 4645 "../../../providers/default/sqlite/parse.c"
      break;
    case 115:
#line 259 "../../../providers/default/sqlite/parse.y"
{sqliteExprListDelete((yypminor->yy192));}
#line 4650 "../../../providers/default/sqlite/parse.c"
      break;
    case 116:
#line 264 "../../../providers/default/sqlite/parse.y"
{sqliteExprDelete((yypminor->yy210));}
#line 4655 "../../../providers/default/sqlite/parse.c"
      break;
    case 120:
#line 506 "../../../providers/default/sqlite/parse.y"
{sqliteIdListDelete((yypminor->yy162));}
#line 4660 "../../../providers/default/sqlite/parse.c"
      break;
    case 122:
#line 332 "../../../providers/default/sqlite/parse.y"
{sqliteIdListDelete((yypminor->yy162));}
#line 4665 "../../../providers/default/sqlite/parse.c"
      break;
    case 123:
#line 330 "../../../providers/default/sqlite/parse.y"
{sqliteIdListDelete((yypminor->yy162));}
#line 4670 "../../../providers/default/sqlite/parse.c"
      break;
    case 124:
#line 310 "../../../providers/default/sqlite/parse.y"
{sqliteExprDelete((yypminor->yy210));}
#line 4675 "../../../providers/default/sqlite/parse.c"
      break;
    case 125:
#line 308 "../../../providers/default/sqlite/parse.y"
{sqliteExprListDelete((yypminor->yy192));}
#line 4680 "../../../providers/default/sqlite/parse.c"
      break;
    case 131:
#line 172 "../../../providers/default/sqlite/parse.y"
{sqliteSelectDelete((yypminor->yy219));}
#line 4685 "../../../providers/default/sqlite/parse.c"
      break;
    case 132:
#line 234 "../../../providers/default/sqlite/parse.y"
{sqliteExprListDelete((yypminor->yy192));}
#line 4690 "../../../providers/default/sqlite/parse.c"
      break;
    case 135:
#line 207 "../../../providers/default/sqlite/parse.y"
{sqliteExprListDelete((yypminor->yy192));}
#line 4695 "../../../providers/default/sqlite/parse.c"
      break;
    case 136:
#line 205 "../../../providers/default/sqlite/parse.y"
{sqliteExprListDelete((yypminor->yy192));}
#line 4700 "../../../providers/default/sqlite/parse.c"
      break;
    case 137:
#line 170 "../../../providers/default/sqlite/parse.y"
{sqliteSelectDelete((yypminor->yy219));}
#line 4705 "../../../providers/default/sqlite/parse.c"
      break;
    case 138:
#line 218 "../../../providers/default/sqlite/parse.y"
{sqliteIdListDelete((yypminor->yy162));}
#line 4710 "../../../providers/default/sqlite/parse.c"
      break;
    case 139:
#line 288 "../../../providers/default/sqlite/parse.y"
{sqliteExprListDelete((yypminor->yy192));}
#line 4715 "../../../providers/default/sqlite/parse.c"
      break;
    case 141:
#line 238 "../../../providers/default/sqlite/parse.y"
{sqliteExprDelete((yypminor->yy210));}
#line 4720 "../../../providers/default/sqlite/parse.c"
      break;
    case 142:
#line 236 "../../../providers/default/sqlite/parse.y"
{sqliteExprListDelete((yypminor->yy192));}
#line 4725 "../../../providers/default/sqlite/parse.c"
      break;
    case 144:
#line 220 "../../../providers/default/sqlite/parse.y"
{sqliteIdListDelete((yypminor->yy162));}
#line 4730 "../../../providers/default/sqlite/parse.c"
      break;
    case 151:
#line 282 "../../../providers/default/sqlite/parse.y"
{sqliteExprDelete((yypminor->yy210));}
#line 4735 "../../../providers/default/sqlite/parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;

  if( pParser->idx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->idx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[pParser->top->major]);
  }
#endif
  yymajor = pParser->top->major;
  yy_destructor( yymajor, &pParser->top->minor);
  pParser->idx--;
  pParser->top--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqliteParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqliteParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->idx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the look-ahead token.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_parser_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead             /* The look-ahead token */
){
  struct yyStateEntry *pState;   /* Appropriate entry in the state table */
  struct yyActionEntry *pAction; /* Action appropriate for the look-ahead */
 
  /* if( pParser->idx<0 ) return YY_NO_ACTION;  */
  pState = &yyStateTable[pParser->top->stateno];
  if( iLookAhead!=YYNOCODE ){
    pAction = &pState->hashtbl[iLookAhead & pState->mask];
    while( pAction ){
      if( pAction->lookahead==iLookAhead ) return pAction->action;
      pAction = pAction->next;
    }
  }else if( pState->mask!=0 || pState->hashtbl->lookahead!=YYNOCODE ){
    return YY_NO_ACTION;
  }
  return pState->actionDefault;
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yypParser->idx++;
  yypParser->top++;
  if( yypParser->idx>=YYSTACKDEPTH ){
     yypParser->idx--;
     yypParser->top--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->idx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     return;
  }
  yypParser->top->stateno = yyNewState;
  yypParser->top->major = yyMajor;
  yypParser->top->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->idx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->idx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->stack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 121, 1 },
  { 99, 1 },
  { 99, 3 },
  { 108, 2 },
  { 108, 1 },
  { 108, 0 },
  { 110, 1 },
  { 98, 2 },
  { 147, 0 },
  { 147, 1 },
  { 147, 2 },
  { 98, 2 },
  { 98, 2 },
  { 98, 2 },
  { 98, 2 },
  { 105, 4 },
  { 146, 1 },
  { 146, 0 },
  { 106, 4 },
  { 102, 3 },
  { 102, 1 },
  { 100, 3 },
  { 101, 1 },
  { 117, 1 },
  { 117, 1 },
  { 117, 1 },
  { 117, 1 },
  { 117, 1 },
  { 117, 1 },
  { 117, 1 },
  { 117, 1 },
  { 117, 1 },
  { 117, 1 },
  { 117, 1 },
  { 117, 1 },
  { 118, 1 },
  { 118, 1 },
  { 148, 0 },
  { 148, 1 },
  { 148, 4 },
  { 148, 6 },
  { 149, 1 },
  { 149, 2 },
  { 140, 1 },
  { 140, 2 },
  { 140, 2 },
  { 96, 2 },
  { 96, 0 },
  { 95, 3 },
  { 95, 1 },
  { 95, 2 },
  { 95, 2 },
  { 95, 2 },
  { 95, 3 },
  { 95, 3 },
  { 95, 2 },
  { 95, 3 },
  { 95, 3 },
  { 95, 2 },
  { 97, 2 },
  { 97, 3 },
  { 97, 1 },
  { 97, 4 },
  { 104, 0 },
  { 104, 2 },
  { 103, 3 },
  { 103, 2 },
  { 103, 1 },
  { 145, 2 },
  { 145, 5 },
  { 145, 4 },
  { 145, 2 },
  { 98, 3 },
  { 98, 1 },
  { 137, 1 },
  { 137, 3 },
  { 126, 1 },
  { 126, 2 },
  { 126, 1 },
  { 126, 1 },
  { 131, 9 },
  { 107, 1 },
  { 107, 1 },
  { 107, 0 },
  { 135, 2 },
  { 135, 0 },
  { 136, 1 },
  { 136, 2 },
  { 136, 4 },
  { 94, 0 },
  { 94, 1 },
  { 114, 2 },
  { 144, 2 },
  { 144, 0 },
  { 138, 2 },
  { 138, 4 },
  { 132, 0 },
  { 132, 3 },
  { 142, 4 },
  { 142, 2 },
  { 141, 1 },
  { 143, 1 },
  { 143, 1 },
  { 143, 0 },
  { 115, 0 },
  { 115, 3 },
  { 116, 0 },
  { 116, 2 },
  { 127, 0 },
  { 127, 2 },
  { 127, 4 },
  { 128, 1 },
  { 128, 1 },
  { 98, 4 },
  { 151, 0 },
  { 151, 2 },
  { 98, 5 },
  { 139, 5 },
  { 139, 3 },
  { 98, 8 },
  { 98, 5 },
  { 125, 3 },
  { 125, 1 },
  { 124, 1 },
  { 124, 2 },
  { 124, 2 },
  { 124, 1 },
  { 124, 2 },
  { 124, 2 },
  { 124, 1 },
  { 124, 1 },
  { 123, 0 },
  { 123, 3 },
  { 122, 3 },
  { 122, 1 },
  { 111, 3 },
  { 111, 1 },
  { 111, 1 },
  { 111, 3 },
  { 111, 1 },
  { 111, 1 },
  { 111, 1 },
  { 111, 4 },
  { 111, 4 },
  { 111, 3 },
  { 111, 3 },
  { 111, 3 },
  { 111, 3 },
  { 111, 3 },
  { 111, 3 },
  { 111, 3 },
  { 111, 3 },
  { 111, 3 },
  { 111, 3 },
  { 111, 3 },
  { 111, 3 },
  { 111, 3 },
  { 111, 4 },
  { 111, 3 },
  { 111, 4 },
  { 111, 3 },
  { 111, 3 },
  { 111, 3 },
  { 111, 3 },
  { 111, 3 },
  { 111, 3 },
  { 111, 2 },
  { 111, 3 },
  { 111, 2 },
  { 111, 3 },
  { 111, 4 },
  { 111, 2 },
  { 111, 2 },
  { 111, 2 },
  { 111, 2 },
  { 111, 3 },
  { 111, 5 },
  { 111, 6 },
  { 111, 5 },
  { 111, 5 },
  { 111, 6 },
  { 111, 6 },
  { 113, 3 },
  { 113, 1 },
  { 112, 1 },
  { 112, 0 },
  { 98, 9 },
  { 150, 1 },
  { 150, 0 },
  { 120, 3 },
  { 120, 1 },
  { 119, 1 },
  { 98, 3 },
  { 98, 7 },
  { 98, 4 },
  { 98, 1 },
  { 98, 2 },
  { 98, 4 },
  { 98, 4 },
  { 98, 4 },
  { 98, 4 },
  { 98, 5 },
  { 133, 2 },
  { 129, 2 },
  { 130, 1 },
  { 130, 1 },
  { 134, 1 },
  { 134, 0 },
};

static void yy_accept(yyParser *  sqliteParserANSIARGDECL);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
  sqliteParserANSIARGDECL
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  struct yyStackEntry *yymsp;     /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  yymsp = yypParser->top;
  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **     YYTRACE("<text of the rule>");
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
        YYTRACE("input ::= cmdlist")
        /* No destructor defined for cmdlist */
        break;
      case 1:
        YYTRACE("cmdlist ::= ecmd")
        /* No destructor defined for ecmd */
        break;
      case 2:
        YYTRACE("cmdlist ::= cmdlist SEMI ecmd")
        /* No destructor defined for cmdlist */
        /* No destructor defined for SEMI */
        /* No destructor defined for ecmd */
        break;
      case 3:
        YYTRACE("ecmd ::= explain cmd")
#line 52 "../../../providers/default/sqlite/parse.y"
{sqliteExec(pParse);}
#line 5118 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for explain */
        /* No destructor defined for cmd */
        break;
      case 4:
        YYTRACE("ecmd ::= cmd")
#line 53 "../../../providers/default/sqlite/parse.y"
{sqliteExec(pParse);}
#line 5126 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for cmd */
        break;
      case 5:
        YYTRACE("ecmd ::=")
        break;
      case 6:
        YYTRACE("explain ::= EXPLAIN")
#line 55 "../../../providers/default/sqlite/parse.y"
{pParse->explain = 1;}
#line 5136 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for EXPLAIN */
        break;
      case 7:
        YYTRACE("cmd ::= BEGIN trans_opt")
#line 59 "../../../providers/default/sqlite/parse.y"
{sqliteBeginTransaction(pParse);}
#line 5143 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for BEGIN */
        /* No destructor defined for trans_opt */
        break;
      case 8:
        YYTRACE("trans_opt ::=")
        break;
      case 9:
        YYTRACE("trans_opt ::= TRANSACTION")
        /* No destructor defined for TRANSACTION */
        break;
      case 10:
        YYTRACE("trans_opt ::= TRANSACTION ids")
        /* No destructor defined for TRANSACTION */
        /* No destructor defined for ids */
        break;
      case 11:
        YYTRACE("cmd ::= COMMIT trans_opt")
#line 63 "../../../providers/default/sqlite/parse.y"
{sqliteCommitTransaction(pParse);}
#line 5163 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for COMMIT */
        /* No destructor defined for trans_opt */
        break;
      case 12:
        YYTRACE("cmd ::= END trans_opt")
#line 64 "../../../providers/default/sqlite/parse.y"
{sqliteCommitTransaction(pParse);}
#line 5171 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for END */
        /* No destructor defined for trans_opt */
        break;
      case 13:
        YYTRACE("cmd ::= ROLLBACK trans_opt")
#line 65 "../../../providers/default/sqlite/parse.y"
{sqliteRollbackTransaction(pParse);}
#line 5179 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for ROLLBACK */
        /* No destructor defined for trans_opt */
        break;
      case 14:
        YYTRACE("cmd ::= create_table create_table_args")
        /* No destructor defined for create_table */
        /* No destructor defined for create_table_args */
        break;
      case 15:
        YYTRACE("create_table ::= CREATE temp TABLE ids")
#line 71 "../../../providers/default/sqlite/parse.y"
{sqliteStartTable(pParse,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy258,yymsp[-2].minor.yy236);}
#line 5192 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for TABLE */
        break;
      case 16:
        YYTRACE("temp ::= TEMP")
#line 73 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy236 = 1;}
#line 5199 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for TEMP */
        break;
      case 17:
        YYTRACE("temp ::=")
#line 74 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy236 = 0;}
#line 5206 "../../../providers/default/sqlite/parse.c"
        break;
      case 18:
        YYTRACE("create_table_args ::= LP columnlist conslist_opt RP")
#line 76 "../../../providers/default/sqlite/parse.y"
{sqliteEndTable(pParse,&yymsp[0].minor.yy0);}
#line 5212 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for columnlist */
        /* No destructor defined for conslist_opt */
        break;
      case 19:
        YYTRACE("columnlist ::= columnlist COMMA column")
        /* No destructor defined for columnlist */
        /* No destructor defined for COMMA */
        /* No destructor defined for column */
        break;
      case 20:
        YYTRACE("columnlist ::= column")
        /* No destructor defined for column */
        break;
      case 21:
        YYTRACE("column ::= columnid type carglist")
        /* No destructor defined for columnid */
        /* No destructor defined for type */
        /* No destructor defined for carglist */
        break;
      case 22:
        YYTRACE("columnid ::= ids")
#line 85 "../../../providers/default/sqlite/parse.y"
{sqliteAddColumn(pParse,&yymsp[0].minor.yy258);}
#line 5237 "../../../providers/default/sqlite/parse.c"
        break;
      case 23:
        YYTRACE("id ::= DESC")
#line 93 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy258 = yymsp[0].minor.yy0;}
#line 5243 "../../../providers/default/sqlite/parse.c"
        break;
      case 24:
        YYTRACE("id ::= ASC")
#line 94 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy258 = yymsp[0].minor.yy0;}
#line 5249 "../../../providers/default/sqlite/parse.c"
        break;
      case 25:
        YYTRACE("id ::= DELIMITERS")
#line 95 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy258 = yymsp[0].minor.yy0;}
#line 5255 "../../../providers/default/sqlite/parse.c"
        break;
      case 26:
        YYTRACE("id ::= EXPLAIN")
#line 96 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy258 = yymsp[0].minor.yy0;}
#line 5261 "../../../providers/default/sqlite/parse.c"
        break;
      case 27:
        YYTRACE("id ::= VACUUM")
#line 97 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy258 = yymsp[0].minor.yy0;}
#line 5267 "../../../providers/default/sqlite/parse.c"
        break;
      case 28:
        YYTRACE("id ::= BEGIN")
#line 98 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy258 = yymsp[0].minor.yy0;}
#line 5273 "../../../providers/default/sqlite/parse.c"
        break;
      case 29:
        YYTRACE("id ::= END")
#line 99 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy258 = yymsp[0].minor.yy0;}
#line 5279 "../../../providers/default/sqlite/parse.c"
        break;
      case 30:
        YYTRACE("id ::= PRAGMA")
#line 100 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy258 = yymsp[0].minor.yy0;}
#line 5285 "../../../providers/default/sqlite/parse.c"
        break;
      case 31:
        YYTRACE("id ::= CLUSTER")
#line 101 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy258 = yymsp[0].minor.yy0;}
#line 5291 "../../../providers/default/sqlite/parse.c"
        break;
      case 32:
        YYTRACE("id ::= ID")
#line 102 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy258 = yymsp[0].minor.yy0;}
#line 5297 "../../../providers/default/sqlite/parse.c"
        break;
      case 33:
        YYTRACE("id ::= TEMP")
#line 103 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy258 = yymsp[0].minor.yy0;}
#line 5303 "../../../providers/default/sqlite/parse.c"
        break;
      case 34:
        YYTRACE("id ::= OFFSET")
#line 104 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy258 = yymsp[0].minor.yy0;}
#line 5309 "../../../providers/default/sqlite/parse.c"
        break;
      case 35:
        YYTRACE("ids ::= id")
#line 109 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy258 = yymsp[0].minor.yy258;}
#line 5315 "../../../providers/default/sqlite/parse.c"
        break;
      case 36:
        YYTRACE("ids ::= STRING")
#line 110 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy258 = yymsp[0].minor.yy0;}
#line 5321 "../../../providers/default/sqlite/parse.c"
        break;
      case 37:
        YYTRACE("type ::=")
        break;
      case 38:
        YYTRACE("type ::= typename")
#line 113 "../../../providers/default/sqlite/parse.y"
{sqliteAddColumnType(pParse,&yymsp[0].minor.yy258,&yymsp[0].minor.yy258);}
#line 5330 "../../../providers/default/sqlite/parse.c"
        break;
      case 39:
        YYTRACE("type ::= typename LP signed RP")
#line 114 "../../../providers/default/sqlite/parse.y"
{sqliteAddColumnType(pParse,&yymsp[-3].minor.yy258,&yymsp[0].minor.yy0);}
#line 5336 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for signed */
        break;
      case 40:
        YYTRACE("type ::= typename LP signed COMMA signed RP")
#line 116 "../../../providers/default/sqlite/parse.y"
{sqliteAddColumnType(pParse,&yymsp[-5].minor.yy258,&yymsp[0].minor.yy0);}
#line 5344 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for signed */
        /* No destructor defined for COMMA */
        /* No destructor defined for signed */
        break;
      case 41:
        YYTRACE("typename ::= ids")
#line 118 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy258 = yymsp[0].minor.yy258;}
#line 5354 "../../../providers/default/sqlite/parse.c"
        break;
      case 42:
        YYTRACE("typename ::= typename ids")
#line 119 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy258 = yymsp[-1].minor.yy258;}
#line 5360 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for ids */
        break;
      case 43:
        YYTRACE("signed ::= INTEGER")
        /* No destructor defined for INTEGER */
        break;
      case 44:
        YYTRACE("signed ::= PLUS INTEGER")
        /* No destructor defined for PLUS */
        /* No destructor defined for INTEGER */
        break;
      case 45:
        YYTRACE("signed ::= MINUS INTEGER")
        /* No destructor defined for MINUS */
        /* No destructor defined for INTEGER */
        break;
      case 46:
        YYTRACE("carglist ::= carglist carg")
        /* No destructor defined for carglist */
        /* No destructor defined for carg */
        break;
      case 47:
        YYTRACE("carglist ::=")
        break;
      case 48:
        YYTRACE("carg ::= CONSTRAINT ids ccons")
        /* No destructor defined for CONSTRAINT */
        /* No destructor defined for ids */
        /* No destructor defined for ccons */
        break;
      case 49:
        YYTRACE("carg ::= ccons")
        /* No destructor defined for ccons */
        break;
      case 50:
        YYTRACE("carg ::= DEFAULT STRING")
#line 127 "../../../providers/default/sqlite/parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 5399 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 51:
        YYTRACE("carg ::= DEFAULT ID")
#line 128 "../../../providers/default/sqlite/parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 5406 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 52:
        YYTRACE("carg ::= DEFAULT INTEGER")
#line 129 "../../../providers/default/sqlite/parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 5413 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 53:
        YYTRACE("carg ::= DEFAULT PLUS INTEGER")
#line 130 "../../../providers/default/sqlite/parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 5420 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for PLUS */
        break;
      case 54:
        YYTRACE("carg ::= DEFAULT MINUS INTEGER")
#line 131 "../../../providers/default/sqlite/parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,1);}
#line 5428 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for MINUS */
        break;
      case 55:
        YYTRACE("carg ::= DEFAULT FLOAT")
#line 132 "../../../providers/default/sqlite/parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 5436 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 56:
        YYTRACE("carg ::= DEFAULT PLUS FLOAT")
#line 133 "../../../providers/default/sqlite/parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 5443 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for PLUS */
        break;
      case 57:
        YYTRACE("carg ::= DEFAULT MINUS FLOAT")
#line 134 "../../../providers/default/sqlite/parse.y"
{sqliteAddDefaultValue(pParse,&yymsp[0].minor.yy0,1);}
#line 5451 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for MINUS */
        break;
      case 58:
        YYTRACE("carg ::= DEFAULT NULL")
        /* No destructor defined for DEFAULT */
        /* No destructor defined for NULL */
        break;
      case 59:
        YYTRACE("ccons ::= NOT NULL")
#line 140 "../../../providers/default/sqlite/parse.y"
{sqliteAddNotNull(pParse);}
#line 5464 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for NULL */
        break;
      case 60:
        YYTRACE("ccons ::= PRIMARY KEY sortorder")
#line 141 "../../../providers/default/sqlite/parse.y"
{sqliteCreateIndex(pParse,0,0,0,1,0,0);}
#line 5472 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for PRIMARY */
        /* No destructor defined for KEY */
        /* No destructor defined for sortorder */
        break;
      case 61:
        YYTRACE("ccons ::= UNIQUE")
#line 142 "../../../providers/default/sqlite/parse.y"
{sqliteCreateIndex(pParse,0,0,0,1,0,0);}
#line 5481 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for UNIQUE */
        break;
      case 62:
        YYTRACE("ccons ::= CHECK LP expr RP")
        /* No destructor defined for CHECK */
        /* No destructor defined for LP */
  yy_destructor(111,&yymsp[-1].minor);
        /* No destructor defined for RP */
        break;
      case 63:
        YYTRACE("conslist_opt ::=")
        break;
      case 64:
        YYTRACE("conslist_opt ::= COMMA conslist")
        /* No destructor defined for COMMA */
        /* No destructor defined for conslist */
        break;
      case 65:
        YYTRACE("conslist ::= conslist COMMA tcons")
        /* No destructor defined for conslist */
        /* No destructor defined for COMMA */
        /* No destructor defined for tcons */
        break;
      case 66:
        YYTRACE("conslist ::= conslist tcons")
        /* No destructor defined for conslist */
        /* No destructor defined for tcons */
        break;
      case 67:
        YYTRACE("conslist ::= tcons")
        /* No destructor defined for tcons */
        break;
      case 68:
        YYTRACE("tcons ::= CONSTRAINT ids")
        /* No destructor defined for CONSTRAINT */
        /* No destructor defined for ids */
        break;
      case 69:
        YYTRACE("tcons ::= PRIMARY KEY LP idxlist RP")
#line 154 "../../../providers/default/sqlite/parse.y"
{sqliteCreateIndex(pParse,0,0,yymsp[-1].minor.yy162,1,0,0);}
#line 5523 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for PRIMARY */
        /* No destructor defined for KEY */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 70:
        YYTRACE("tcons ::= UNIQUE LP idxlist RP")
#line 155 "../../../providers/default/sqlite/parse.y"
{sqliteCreateIndex(pParse,0,0,yymsp[-1].minor.yy162,1,0,0);}
#line 5533 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for UNIQUE */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 71:
        YYTRACE("tcons ::= CHECK expr")
        /* No destructor defined for CHECK */
  yy_destructor(111,&yymsp[0].minor);
        break;
      case 72:
        YYTRACE("cmd ::= DROP TABLE ids")
#line 160 "../../../providers/default/sqlite/parse.y"
{sqliteDropTable(pParse,&yymsp[0].minor.yy258);}
#line 5547 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for TABLE */
        break;
      case 73:
        YYTRACE("cmd ::= select")
#line 164 "../../../providers/default/sqlite/parse.y"
{
  sqliteSelect(pParse, yymsp[0].minor.yy219, SRT_Callback, 0);
  sqliteSelectDelete(yymsp[0].minor.yy219);
}
#line 5558 "../../../providers/default/sqlite/parse.c"
        break;
      case 74:
        YYTRACE("select ::= oneselect")
#line 174 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy219 = yymsp[0].minor.yy219;}
#line 5564 "../../../providers/default/sqlite/parse.c"
        break;
      case 75:
        YYTRACE("select ::= select joinop oneselect")
#line 175 "../../../providers/default/sqlite/parse.y"
{
  if( yymsp[0].minor.yy219 ){
    yymsp[0].minor.yy219->op = yymsp[-1].minor.yy236;
    yymsp[0].minor.yy219->pPrior = yymsp[-2].minor.yy219;
  }
  yygotominor.yy219 = yymsp[0].minor.yy219;
}
#line 5576 "../../../providers/default/sqlite/parse.c"
        break;
      case 76:
        YYTRACE("joinop ::= UNION")
#line 183 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy236 = TK_UNION;}
#line 5582 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for UNION */
        break;
      case 77:
        YYTRACE("joinop ::= UNION ALL")
#line 184 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy236 = TK_ALL;}
#line 5589 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for UNION */
        /* No destructor defined for ALL */
        break;
      case 78:
        YYTRACE("joinop ::= INTERSECT")
#line 185 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy236 = TK_INTERSECT;}
#line 5597 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for INTERSECT */
        break;
      case 79:
        YYTRACE("joinop ::= EXCEPT")
#line 186 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy236 = TK_EXCEPT;}
#line 5604 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for EXCEPT */
        break;
      case 80:
        YYTRACE("oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt")
#line 188 "../../../providers/default/sqlite/parse.y"
{
  yygotominor.yy219 = sqliteSelectNew(yymsp[-6].minor.yy192,yymsp[-5].minor.yy162,yymsp[-4].minor.yy210,yymsp[-3].minor.yy192,yymsp[-2].minor.yy210,yymsp[-1].minor.yy192,yymsp[-7].minor.yy236,yymsp[0].minor.yy79.a,yymsp[0].minor.yy79.b);
}
#line 5613 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for SELECT */
        break;
      case 81:
        YYTRACE("distinct ::= DISTINCT")
#line 196 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy236 = 1;}
#line 5620 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for DISTINCT */
        break;
      case 82:
        YYTRACE("distinct ::= ALL")
#line 197 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy236 = 0;}
#line 5627 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for ALL */
        break;
      case 83:
        YYTRACE("distinct ::=")
#line 198 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy236 = 0;}
#line 5634 "../../../providers/default/sqlite/parse.c"
        break;
      case 84:
        YYTRACE("sclp ::= selcollist COMMA")
#line 208 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy192 = yymsp[-1].minor.yy192;}
#line 5640 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for COMMA */
        break;
      case 85:
        YYTRACE("sclp ::=")
#line 209 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy192 = 0;}
#line 5647 "../../../providers/default/sqlite/parse.c"
        break;
      case 86:
        YYTRACE("selcollist ::= STAR")
#line 210 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy192 = 0;}
#line 5653 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for STAR */
        break;
      case 87:
        YYTRACE("selcollist ::= sclp expr")
#line 211 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy192 = sqliteExprListAppend(yymsp[-1].minor.yy192,yymsp[0].minor.yy210,0);}
#line 5660 "../../../providers/default/sqlite/parse.c"
        break;
      case 88:
        YYTRACE("selcollist ::= sclp expr as ids")
#line 212 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy192 = sqliteExprListAppend(yymsp[-3].minor.yy192,yymsp[-2].minor.yy210,&yymsp[0].minor.yy258);}
#line 5666 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for as */
        break;
      case 89:
        YYTRACE("as ::=")
        break;
      case 90:
        YYTRACE("as ::= AS")
        /* No destructor defined for AS */
        break;
      case 91:
        YYTRACE("from ::= FROM seltablist")
#line 224 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy162 = yymsp[0].minor.yy162;}
#line 5680 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for FROM */
        break;
      case 92:
        YYTRACE("stl_prefix ::= seltablist COMMA")
#line 225 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy162 = yymsp[-1].minor.yy162;}
#line 5687 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for COMMA */
        break;
      case 93:
        YYTRACE("stl_prefix ::=")
#line 226 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy162 = 0;}
#line 5694 "../../../providers/default/sqlite/parse.c"
        break;
      case 94:
        YYTRACE("seltablist ::= stl_prefix ids")
#line 227 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy162 = sqliteIdListAppend(yymsp[-1].minor.yy162,&yymsp[0].minor.yy258);}
#line 5700 "../../../providers/default/sqlite/parse.c"
        break;
      case 95:
        YYTRACE("seltablist ::= stl_prefix ids as ids")
#line 228 "../../../providers/default/sqlite/parse.y"
{
  yygotominor.yy162 = sqliteIdListAppend(yymsp[-3].minor.yy162,&yymsp[-2].minor.yy258);
  sqliteIdListAddAlias(yygotominor.yy162,&yymsp[0].minor.yy258);
}
#line 5709 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for as */
        break;
      case 96:
        YYTRACE("orderby_opt ::=")
#line 240 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy192 = 0;}
#line 5716 "../../../providers/default/sqlite/parse.c"
        break;
      case 97:
        YYTRACE("orderby_opt ::= ORDER BY sortlist")
#line 241 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy192 = yymsp[0].minor.yy192;}
#line 5722 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for ORDER */
        /* No destructor defined for BY */
        break;
      case 98:
        YYTRACE("sortlist ::= sortlist COMMA sortitem sortorder")
#line 242 "../../../providers/default/sqlite/parse.y"
{
  yygotominor.yy192 = sqliteExprListAppend(yymsp[-3].minor.yy192,yymsp[-1].minor.yy210,0);
  if( yygotominor.yy192 ) yygotominor.yy192->a[yygotominor.yy192->nExpr-1].sortOrder = yymsp[0].minor.yy236;  /* 0=ascending, 1=decending */
}
#line 5733 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for COMMA */
        break;
      case 99:
        YYTRACE("sortlist ::= sortitem sortorder")
#line 246 "../../../providers/default/sqlite/parse.y"
{
  yygotominor.yy192 = sqliteExprListAppend(0,yymsp[-1].minor.yy210,0);
  if( yygotominor.yy192 ) yygotominor.yy192->a[0].sortOrder = yymsp[0].minor.yy236;
}
#line 5743 "../../../providers/default/sqlite/parse.c"
        break;
      case 100:
        YYTRACE("sortitem ::= expr")
#line 250 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy210;}
#line 5749 "../../../providers/default/sqlite/parse.c"
        break;
      case 101:
        YYTRACE("sortorder ::= ASC")
#line 254 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy236 = 0;}
#line 5755 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for ASC */
        break;
      case 102:
        YYTRACE("sortorder ::= DESC")
#line 255 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy236 = 1;}
#line 5762 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for DESC */
        break;
      case 103:
        YYTRACE("sortorder ::=")
#line 256 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy236 = 0;}
#line 5769 "../../../providers/default/sqlite/parse.c"
        break;
      case 104:
        YYTRACE("groupby_opt ::=")
#line 260 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy192 = 0;}
#line 5775 "../../../providers/default/sqlite/parse.c"
        break;
      case 105:
        YYTRACE("groupby_opt ::= GROUP BY exprlist")
#line 261 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy192 = yymsp[0].minor.yy192;}
#line 5781 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for GROUP */
        /* No destructor defined for BY */
        break;
      case 106:
        YYTRACE("having_opt ::=")
#line 265 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = 0;}
#line 5789 "../../../providers/default/sqlite/parse.c"
        break;
      case 107:
        YYTRACE("having_opt ::= HAVING expr")
#line 266 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy210;}
#line 5795 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for HAVING */
        break;
      case 108:
        YYTRACE("limit_opt ::=")
#line 269 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy79.a = -1; yygotominor.yy79.b = 0;}
#line 5802 "../../../providers/default/sqlite/parse.c"
        break;
      case 109:
        YYTRACE("limit_opt ::= LIMIT INTEGER")
#line 270 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy79.a = atoi(yymsp[0].minor.yy0.z); yygotominor.yy79.b = 0;}
#line 5808 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for LIMIT */
        break;
      case 110:
        YYTRACE("limit_opt ::= LIMIT INTEGER limit_sep INTEGER")
#line 272 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy79.a = atoi(yymsp[-2].minor.yy0.z); yygotominor.yy79.b = atoi(yymsp[0].minor.yy0.z);}
#line 5815 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for LIMIT */
        /* No destructor defined for limit_sep */
        break;
      case 111:
        YYTRACE("limit_sep ::= OFFSET")
        /* No destructor defined for OFFSET */
        break;
      case 112:
        YYTRACE("limit_sep ::= COMMA")
        /* No destructor defined for COMMA */
        break;
      case 113:
        YYTRACE("cmd ::= DELETE FROM ids where_opt")
#line 279 "../../../providers/default/sqlite/parse.y"
{sqliteDeleteFrom(pParse, &yymsp[-1].minor.yy258, yymsp[0].minor.yy210);}
#line 5831 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for DELETE */
        /* No destructor defined for FROM */
        break;
      case 114:
        YYTRACE("where_opt ::=")
#line 284 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = 0;}
#line 5839 "../../../providers/default/sqlite/parse.c"
        break;
      case 115:
        YYTRACE("where_opt ::= WHERE expr")
#line 285 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy210;}
#line 5845 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for WHERE */
        break;
      case 116:
        YYTRACE("cmd ::= UPDATE ids SET setlist where_opt")
#line 293 "../../../providers/default/sqlite/parse.y"
{sqliteUpdate(pParse,&yymsp[-3].minor.yy258,yymsp[-1].minor.yy192,yymsp[0].minor.yy210);}
#line 5852 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for UPDATE */
        /* No destructor defined for SET */
        break;
      case 117:
        YYTRACE("setlist ::= setlist COMMA ids EQ expr")
#line 296 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy192 = sqliteExprListAppend(yymsp[-4].minor.yy192,yymsp[0].minor.yy210,&yymsp[-2].minor.yy258);}
#line 5860 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for COMMA */
        /* No destructor defined for EQ */
        break;
      case 118:
        YYTRACE("setlist ::= ids EQ expr")
#line 297 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy192 = sqliteExprListAppend(0,yymsp[0].minor.yy210,&yymsp[-2].minor.yy258);}
#line 5868 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for EQ */
        break;
      case 119:
        YYTRACE("cmd ::= INSERT INTO ids inscollist_opt VALUES LP itemlist RP")
#line 302 "../../../providers/default/sqlite/parse.y"
{sqliteInsert(pParse, &yymsp[-5].minor.yy258, yymsp[-1].minor.yy192, 0, yymsp[-4].minor.yy162);}
#line 5875 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for INSERT */
        /* No destructor defined for INTO */
        /* No destructor defined for VALUES */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 120:
        YYTRACE("cmd ::= INSERT INTO ids inscollist_opt select")
#line 304 "../../../providers/default/sqlite/parse.y"
{sqliteInsert(pParse, &yymsp[-2].minor.yy258, 0, yymsp[0].minor.yy219, yymsp[-1].minor.yy162);}
#line 5886 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for INSERT */
        /* No destructor defined for INTO */
        break;
      case 121:
        YYTRACE("itemlist ::= itemlist COMMA item")
#line 312 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy192 = sqliteExprListAppend(yymsp[-2].minor.yy192,yymsp[0].minor.yy210,0);}
#line 5894 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for COMMA */
        break;
      case 122:
        YYTRACE("itemlist ::= item")
#line 313 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy192 = sqliteExprListAppend(0,yymsp[0].minor.yy210,0);}
#line 5901 "../../../providers/default/sqlite/parse.c"
        break;
      case 123:
        YYTRACE("item ::= INTEGER")
#line 314 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_INTEGER, 0, 0, &yymsp[0].minor.yy0);}
#line 5907 "../../../providers/default/sqlite/parse.c"
        break;
      case 124:
        YYTRACE("item ::= PLUS INTEGER")
#line 315 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_INTEGER, 0, 0, &yymsp[0].minor.yy0);}
#line 5913 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for PLUS */
        break;
      case 125:
        YYTRACE("item ::= MINUS INTEGER")
#line 316 "../../../providers/default/sqlite/parse.y"
{
  yygotominor.yy210 = sqliteExpr(TK_UMINUS, 0, 0, 0);
  if( yygotominor.yy210 ) yygotominor.yy210->pLeft = sqliteExpr(TK_INTEGER, 0, 0, &yymsp[0].minor.yy0);
}
#line 5923 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for MINUS */
        break;
      case 126:
        YYTRACE("item ::= FLOAT")
#line 320 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_FLOAT, 0, 0, &yymsp[0].minor.yy0);}
#line 5930 "../../../providers/default/sqlite/parse.c"
        break;
      case 127:
        YYTRACE("item ::= PLUS FLOAT")
#line 321 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_FLOAT, 0, 0, &yymsp[0].minor.yy0);}
#line 5936 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for PLUS */
        break;
      case 128:
        YYTRACE("item ::= MINUS FLOAT")
#line 322 "../../../providers/default/sqlite/parse.y"
{
  yygotominor.yy210 = sqliteExpr(TK_UMINUS, 0, 0, 0);
  if( yygotominor.yy210 ) yygotominor.yy210->pLeft = sqliteExpr(TK_FLOAT, 0, 0, &yymsp[0].minor.yy0);
}
#line 5946 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for MINUS */
        break;
      case 129:
        YYTRACE("item ::= STRING")
#line 326 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_STRING, 0, 0, &yymsp[0].minor.yy0);}
#line 5953 "../../../providers/default/sqlite/parse.c"
        break;
      case 130:
        YYTRACE("item ::= NULL")
#line 327 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_NULL, 0, 0, 0);}
#line 5959 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for NULL */
        break;
      case 131:
        YYTRACE("inscollist_opt ::=")
#line 334 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy162 = 0;}
#line 5966 "../../../providers/default/sqlite/parse.c"
        break;
      case 132:
        YYTRACE("inscollist_opt ::= LP inscollist RP")
#line 335 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy162 = yymsp[-1].minor.yy162;}
#line 5972 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 133:
        YYTRACE("inscollist ::= inscollist COMMA ids")
#line 336 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy162 = sqliteIdListAppend(yymsp[-2].minor.yy162,&yymsp[0].minor.yy258);}
#line 5980 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for COMMA */
        break;
      case 134:
        YYTRACE("inscollist ::= ids")
#line 337 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy162 = sqliteIdListAppend(0,&yymsp[0].minor.yy258);}
#line 5987 "../../../providers/default/sqlite/parse.c"
        break;
      case 135:
        YYTRACE("expr ::= LP expr RP")
#line 355 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = yymsp[-1].minor.yy210; sqliteExprSpan(yygotominor.yy210,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);}
#line 5993 "../../../providers/default/sqlite/parse.c"
        break;
      case 136:
        YYTRACE("expr ::= NULL")
#line 356 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_NULL, 0, 0, &yymsp[0].minor.yy0);}
#line 5999 "../../../providers/default/sqlite/parse.c"
        break;
      case 137:
        YYTRACE("expr ::= id")
#line 357 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_ID, 0, 0, &yymsp[0].minor.yy258);}
#line 6005 "../../../providers/default/sqlite/parse.c"
        break;
      case 138:
        YYTRACE("expr ::= ids DOT ids")
#line 358 "../../../providers/default/sqlite/parse.y"
{
  Expr *temp1 = sqliteExpr(TK_ID, 0, 0, &yymsp[-2].minor.yy258);
  Expr *temp2 = sqliteExpr(TK_ID, 0, 0, &yymsp[0].minor.yy258);
  yygotominor.yy210 = sqliteExpr(TK_DOT, temp1, temp2, 0);
}
#line 6015 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for DOT */
        break;
      case 139:
        YYTRACE("expr ::= INTEGER")
#line 363 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_INTEGER, 0, 0, &yymsp[0].minor.yy0);}
#line 6022 "../../../providers/default/sqlite/parse.c"
        break;
      case 140:
        YYTRACE("expr ::= FLOAT")
#line 364 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_FLOAT, 0, 0, &yymsp[0].minor.yy0);}
#line 6028 "../../../providers/default/sqlite/parse.c"
        break;
      case 141:
        YYTRACE("expr ::= STRING")
#line 365 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_STRING, 0, 0, &yymsp[0].minor.yy0);}
#line 6034 "../../../providers/default/sqlite/parse.c"
        break;
      case 142:
        YYTRACE("expr ::= ID LP exprlist RP")
#line 366 "../../../providers/default/sqlite/parse.y"
{
  yygotominor.yy210 = sqliteExprFunction(yymsp[-1].minor.yy192, &yymsp[-3].minor.yy0);
  sqliteExprSpan(yygotominor.yy210,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 6043 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for LP */
        break;
      case 143:
        YYTRACE("expr ::= ID LP STAR RP")
#line 370 "../../../providers/default/sqlite/parse.y"
{
  yygotominor.yy210 = sqliteExprFunction(0, &yymsp[-3].minor.yy0);
  sqliteExprSpan(yygotominor.yy210,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 6053 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for STAR */
        break;
      case 144:
        YYTRACE("expr ::= expr AND expr")
#line 374 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_AND, yymsp[-2].minor.yy210, yymsp[0].minor.yy210, 0);}
#line 6061 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for AND */
        break;
      case 145:
        YYTRACE("expr ::= expr OR expr")
#line 375 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_OR, yymsp[-2].minor.yy210, yymsp[0].minor.yy210, 0);}
#line 6068 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for OR */
        break;
      case 146:
        YYTRACE("expr ::= expr LT expr")
#line 376 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_LT, yymsp[-2].minor.yy210, yymsp[0].minor.yy210, 0);}
#line 6075 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for LT */
        break;
      case 147:
        YYTRACE("expr ::= expr GT expr")
#line 377 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_GT, yymsp[-2].minor.yy210, yymsp[0].minor.yy210, 0);}
#line 6082 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for GT */
        break;
      case 148:
        YYTRACE("expr ::= expr LE expr")
#line 378 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_LE, yymsp[-2].minor.yy210, yymsp[0].minor.yy210, 0);}
#line 6089 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for LE */
        break;
      case 149:
        YYTRACE("expr ::= expr GE expr")
#line 379 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_GE, yymsp[-2].minor.yy210, yymsp[0].minor.yy210, 0);}
#line 6096 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for GE */
        break;
      case 150:
        YYTRACE("expr ::= expr NE expr")
#line 380 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_NE, yymsp[-2].minor.yy210, yymsp[0].minor.yy210, 0);}
#line 6103 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for NE */
        break;
      case 151:
        YYTRACE("expr ::= expr EQ expr")
#line 381 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_EQ, yymsp[-2].minor.yy210, yymsp[0].minor.yy210, 0);}
#line 6110 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for EQ */
        break;
      case 152:
        YYTRACE("expr ::= expr BITAND expr")
#line 382 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_BITAND, yymsp[-2].minor.yy210, yymsp[0].minor.yy210, 0);}
#line 6117 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for BITAND */
        break;
      case 153:
        YYTRACE("expr ::= expr BITOR expr")
#line 383 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_BITOR, yymsp[-2].minor.yy210, yymsp[0].minor.yy210, 0);}
#line 6124 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for BITOR */
        break;
      case 154:
        YYTRACE("expr ::= expr LSHIFT expr")
#line 384 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_LSHIFT, yymsp[-2].minor.yy210, yymsp[0].minor.yy210, 0);}
#line 6131 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for LSHIFT */
        break;
      case 155:
        YYTRACE("expr ::= expr RSHIFT expr")
#line 385 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_RSHIFT, yymsp[-2].minor.yy210, yymsp[0].minor.yy210, 0);}
#line 6138 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for RSHIFT */
        break;
      case 156:
        YYTRACE("expr ::= expr LIKE expr")
#line 386 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_LIKE, yymsp[-2].minor.yy210, yymsp[0].minor.yy210, 0);}
#line 6145 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for LIKE */
        break;
      case 157:
        YYTRACE("expr ::= expr NOT LIKE expr")
#line 387 "../../../providers/default/sqlite/parse.y"
{
  yygotominor.yy210 = sqliteExpr(TK_LIKE, yymsp[-3].minor.yy210, yymsp[0].minor.yy210, 0);
  yygotominor.yy210 = sqliteExpr(TK_NOT, yygotominor.yy210, 0, 0);
  sqliteExprSpan(yygotominor.yy210,&yymsp[-3].minor.yy210->span,&yymsp[0].minor.yy210->span);
}
#line 6156 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for LIKE */
        break;
      case 158:
        YYTRACE("expr ::= expr GLOB expr")
#line 392 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_GLOB,yymsp[-2].minor.yy210,yymsp[0].minor.yy210,0);}
#line 6164 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for GLOB */
        break;
      case 159:
        YYTRACE("expr ::= expr NOT GLOB expr")
#line 393 "../../../providers/default/sqlite/parse.y"
{
  yygotominor.yy210 = sqliteExpr(TK_GLOB, yymsp[-3].minor.yy210, yymsp[0].minor.yy210, 0);
  yygotominor.yy210 = sqliteExpr(TK_NOT, yygotominor.yy210, 0, 0);
  sqliteExprSpan(yygotominor.yy210,&yymsp[-3].minor.yy210->span,&yymsp[0].minor.yy210->span);
}
#line 6175 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for GLOB */
        break;
      case 160:
        YYTRACE("expr ::= expr PLUS expr")
#line 398 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_PLUS, yymsp[-2].minor.yy210, yymsp[0].minor.yy210, 0);}
#line 6183 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for PLUS */
        break;
      case 161:
        YYTRACE("expr ::= expr MINUS expr")
#line 399 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_MINUS, yymsp[-2].minor.yy210, yymsp[0].minor.yy210, 0);}
#line 6190 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for MINUS */
        break;
      case 162:
        YYTRACE("expr ::= expr STAR expr")
#line 400 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_STAR, yymsp[-2].minor.yy210, yymsp[0].minor.yy210, 0);}
#line 6197 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for STAR */
        break;
      case 163:
        YYTRACE("expr ::= expr SLASH expr")
#line 401 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_SLASH, yymsp[-2].minor.yy210, yymsp[0].minor.yy210, 0);}
#line 6204 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for SLASH */
        break;
      case 164:
        YYTRACE("expr ::= expr REM expr")
#line 402 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_REM, yymsp[-2].minor.yy210, yymsp[0].minor.yy210, 0);}
#line 6211 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for REM */
        break;
      case 165:
        YYTRACE("expr ::= expr CONCAT expr")
#line 403 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = sqliteExpr(TK_CONCAT, yymsp[-2].minor.yy210, yymsp[0].minor.yy210, 0);}
#line 6218 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for CONCAT */
        break;
      case 166:
        YYTRACE("expr ::= expr ISNULL")
#line 404 "../../../providers/default/sqlite/parse.y"
{
  yygotominor.yy210 = sqliteExpr(TK_ISNULL, yymsp[-1].minor.yy210, 0, 0);
  sqliteExprSpan(yygotominor.yy210,&yymsp[-1].minor.yy210->span,&yymsp[0].minor.yy0);
}
#line 6228 "../../../providers/default/sqlite/parse.c"
        break;
      case 167:
        YYTRACE("expr ::= expr IS NULL")
#line 408 "../../../providers/default/sqlite/parse.y"
{
  yygotominor.yy210 = sqliteExpr(TK_ISNULL, yymsp[-2].minor.yy210, 0, 0);
  sqliteExprSpan(yygotominor.yy210,&yymsp[-2].minor.yy210->span,&yymsp[0].minor.yy0);
}
#line 6237 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for IS */
        break;
      case 168:
        YYTRACE("expr ::= expr NOTNULL")
#line 412 "../../../providers/default/sqlite/parse.y"
{
  yygotominor.yy210 = sqliteExpr(TK_NOTNULL, yymsp[-1].minor.yy210, 0, 0);
  sqliteExprSpan(yygotominor.yy210,&yymsp[-1].minor.yy210->span,&yymsp[0].minor.yy0);
}
#line 6247 "../../../providers/default/sqlite/parse.c"
        break;
      case 169:
        YYTRACE("expr ::= expr NOT NULL")
#line 416 "../../../providers/default/sqlite/parse.y"
{
  yygotominor.yy210 = sqliteExpr(TK_NOTNULL, yymsp[-2].minor.yy210, 0, 0);
  sqliteExprSpan(yygotominor.yy210,&yymsp[-2].minor.yy210->span,&yymsp[0].minor.yy0);
}
#line 6256 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for NOT */
        break;
      case 170:
        YYTRACE("expr ::= expr IS NOT NULL")
#line 420 "../../../providers/default/sqlite/parse.y"
{
  yygotominor.yy210 = sqliteExpr(TK_NOTNULL, yymsp[-3].minor.yy210, 0, 0);
  sqliteExprSpan(yygotominor.yy210,&yymsp[-3].minor.yy210->span,&yymsp[0].minor.yy0);
}
#line 6266 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for IS */
        /* No destructor defined for NOT */
        break;
      case 171:
        YYTRACE("expr ::= NOT expr")
#line 424 "../../../providers/default/sqlite/parse.y"
{
  yygotominor.yy210 = sqliteExpr(TK_NOT, yymsp[0].minor.yy210, 0, 0);
  sqliteExprSpan(yygotominor.yy210,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy210->span);
}
#line 6277 "../../../providers/default/sqlite/parse.c"
        break;
      case 172:
        YYTRACE("expr ::= BITNOT expr")
#line 428 "../../../providers/default/sqlite/parse.y"
{
  yygotominor.yy210 = sqliteExpr(TK_BITNOT, yymsp[0].minor.yy210, 0, 0);
  sqliteExprSpan(yygotominor.yy210,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy210->span);
}
#line 6286 "../../../providers/default/sqlite/parse.c"
        break;
      case 173:
        YYTRACE("expr ::= MINUS expr")
#line 432 "../../../providers/default/sqlite/parse.y"
{
  yygotominor.yy210 = sqliteExpr(TK_UMINUS, yymsp[0].minor.yy210, 0, 0);
  sqliteExprSpan(yygotominor.yy210,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy210->span);
}
#line 6295 "../../../providers/default/sqlite/parse.c"
        break;
      case 174:
        YYTRACE("expr ::= PLUS expr")
#line 436 "../../../providers/default/sqlite/parse.y"
{
  yygotominor.yy210 = yymsp[0].minor.yy210;
  sqliteExprSpan(yygotominor.yy210,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy210->span);
}
#line 6304 "../../../providers/default/sqlite/parse.c"
        break;
      case 175:
        YYTRACE("expr ::= LP select RP")
#line 440 "../../../providers/default/sqlite/parse.y"
{
  yygotominor.yy210 = sqliteExpr(TK_SELECT, 0, 0, 0);
  if( yygotominor.yy210 ) yygotominor.yy210->pSelect = yymsp[-1].minor.yy219;
  sqliteExprSpan(yygotominor.yy210,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
}
#line 6314 "../../../providers/default/sqlite/parse.c"
        break;
      case 176:
        YYTRACE("expr ::= expr BETWEEN expr AND expr")
#line 445 "../../../providers/default/sqlite/parse.y"
{
  ExprList *pList = sqliteExprListAppend(0, yymsp[-2].minor.yy210, 0);
  pList = sqliteExprListAppend(pList, yymsp[0].minor.yy210, 0);
  yygotominor.yy210 = sqliteExpr(TK_BETWEEN, yymsp[-4].minor.yy210, 0, 0);
  if( yygotominor.yy210 ) yygotominor.yy210->pList = pList;
  sqliteExprSpan(yygotominor.yy210,&yymsp[-4].minor.yy210->span,&yymsp[0].minor.yy210->span);
}
#line 6326 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for BETWEEN */
        /* No destructor defined for AND */
        break;
      case 177:
        YYTRACE("expr ::= expr NOT BETWEEN expr AND expr")
#line 452 "../../../providers/default/sqlite/parse.y"
{
  ExprList *pList = sqliteExprListAppend(0, yymsp[-2].minor.yy210, 0);
  pList = sqliteExprListAppend(pList, yymsp[0].minor.yy210, 0);
  yygotominor.yy210 = sqliteExpr(TK_BETWEEN, yymsp[-5].minor.yy210, 0, 0);
  if( yygotominor.yy210 ) yygotominor.yy210->pList = pList;
  yygotominor.yy210 = sqliteExpr(TK_NOT, yygotominor.yy210, 0, 0);
  sqliteExprSpan(yygotominor.yy210,&yymsp[-5].minor.yy210->span,&yymsp[0].minor.yy210->span);
}
#line 6341 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for BETWEEN */
        /* No destructor defined for AND */
        break;
      case 178:
        YYTRACE("expr ::= expr IN LP exprlist RP")
#line 460 "../../../providers/default/sqlite/parse.y"
{
  yygotominor.yy210 = sqliteExpr(TK_IN, yymsp[-4].minor.yy210, 0, 0);
  if( yygotominor.yy210 ) yygotominor.yy210->pList = yymsp[-1].minor.yy192;
  sqliteExprSpan(yygotominor.yy210,&yymsp[-4].minor.yy210->span,&yymsp[0].minor.yy0);
}
#line 6354 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 179:
        YYTRACE("expr ::= expr IN LP select RP")
#line 465 "../../../providers/default/sqlite/parse.y"
{
  yygotominor.yy210 = sqliteExpr(TK_IN, yymsp[-4].minor.yy210, 0, 0);
  if( yygotominor.yy210 ) yygotominor.yy210->pSelect = yymsp[-1].minor.yy219;
  sqliteExprSpan(yygotominor.yy210,&yymsp[-4].minor.yy210->span,&yymsp[0].minor.yy0);
}
#line 6366 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 180:
        YYTRACE("expr ::= expr NOT IN LP exprlist RP")
#line 470 "../../../providers/default/sqlite/parse.y"
{
  yygotominor.yy210 = sqliteExpr(TK_IN, yymsp[-5].minor.yy210, 0, 0);
  if( yygotominor.yy210 ) yygotominor.yy210->pList = yymsp[-1].minor.yy192;
  yygotominor.yy210 = sqliteExpr(TK_NOT, yygotominor.yy210, 0, 0);
  sqliteExprSpan(yygotominor.yy210,&yymsp[-5].minor.yy210->span,&yymsp[0].minor.yy0);
}
#line 6379 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 181:
        YYTRACE("expr ::= expr NOT IN LP select RP")
#line 476 "../../../providers/default/sqlite/parse.y"
{
  yygotominor.yy210 = sqliteExpr(TK_IN, yymsp[-5].minor.yy210, 0, 0);
  if( yygotominor.yy210 ) yygotominor.yy210->pSelect = yymsp[-1].minor.yy219;
  yygotominor.yy210 = sqliteExpr(TK_NOT, yygotominor.yy210, 0, 0);
  sqliteExprSpan(yygotominor.yy210,&yymsp[-5].minor.yy210->span,&yymsp[0].minor.yy0);
}
#line 6393 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 182:
        YYTRACE("exprlist ::= exprlist COMMA expritem")
#line 491 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy192 = sqliteExprListAppend(yymsp[-2].minor.yy192,yymsp[0].minor.yy210,0);}
#line 6402 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for COMMA */
        break;
      case 183:
        YYTRACE("exprlist ::= expritem")
#line 492 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy192 = sqliteExprListAppend(0,yymsp[0].minor.yy210,0);}
#line 6409 "../../../providers/default/sqlite/parse.c"
        break;
      case 184:
        YYTRACE("expritem ::= expr")
#line 493 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = yymsp[0].minor.yy210;}
#line 6415 "../../../providers/default/sqlite/parse.c"
        break;
      case 185:
        YYTRACE("expritem ::=")
#line 494 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy210 = 0;}
#line 6421 "../../../providers/default/sqlite/parse.c"
        break;
      case 186:
        YYTRACE("cmd ::= CREATE uniqueflag INDEX ids ON ids LP idxlist RP")
#line 499 "../../../providers/default/sqlite/parse.y"
{sqliteCreateIndex(pParse, &yymsp[-5].minor.yy258, &yymsp[-3].minor.yy258, yymsp[-1].minor.yy162, yymsp[-7].minor.yy236, &yymsp[-8].minor.yy0, &yymsp[0].minor.yy0);}
#line 6427 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for INDEX */
        /* No destructor defined for ON */
        /* No destructor defined for LP */
        break;
      case 187:
        YYTRACE("uniqueflag ::= UNIQUE")
#line 502 "../../../providers/default/sqlite/parse.y"
{ yygotominor.yy236 = 1; }
#line 6436 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for UNIQUE */
        break;
      case 188:
        YYTRACE("uniqueflag ::=")
#line 503 "../../../providers/default/sqlite/parse.y"
{ yygotominor.yy236 = 0; }
#line 6443 "../../../providers/default/sqlite/parse.c"
        break;
      case 189:
        YYTRACE("idxlist ::= idxlist COMMA idxitem")
#line 510 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy162 = sqliteIdListAppend(yymsp[-2].minor.yy162,&yymsp[0].minor.yy258);}
#line 6449 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for COMMA */
        break;
      case 190:
        YYTRACE("idxlist ::= idxitem")
#line 512 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy162 = sqliteIdListAppend(0,&yymsp[0].minor.yy258);}
#line 6456 "../../../providers/default/sqlite/parse.c"
        break;
      case 191:
        YYTRACE("idxitem ::= ids")
#line 513 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy258 = yymsp[0].minor.yy258;}
#line 6462 "../../../providers/default/sqlite/parse.c"
        break;
      case 192:
        YYTRACE("cmd ::= DROP INDEX ids")
#line 518 "../../../providers/default/sqlite/parse.y"
{sqliteDropIndex(pParse, &yymsp[0].minor.yy258);}
#line 6468 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for INDEX */
        break;
      case 193:
        YYTRACE("cmd ::= COPY ids FROM ids USING DELIMITERS STRING")
#line 524 "../../../providers/default/sqlite/parse.y"
{sqliteCopy(pParse,&yymsp[-5].minor.yy258,&yymsp[-3].minor.yy258,&yymsp[0].minor.yy0);}
#line 6476 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for COPY */
        /* No destructor defined for FROM */
        /* No destructor defined for USING */
        /* No destructor defined for DELIMITERS */
        break;
      case 194:
        YYTRACE("cmd ::= COPY ids FROM ids")
#line 526 "../../../providers/default/sqlite/parse.y"
{sqliteCopy(pParse,&yymsp[-2].minor.yy258,&yymsp[0].minor.yy258,0);}
#line 6486 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for COPY */
        /* No destructor defined for FROM */
        break;
      case 195:
        YYTRACE("cmd ::= VACUUM")
#line 530 "../../../providers/default/sqlite/parse.y"
{sqliteVacuum(pParse,0);}
#line 6494 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for VACUUM */
        break;
      case 196:
        YYTRACE("cmd ::= VACUUM ids")
#line 531 "../../../providers/default/sqlite/parse.y"
{sqliteVacuum(pParse,&yymsp[0].minor.yy258);}
#line 6501 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for VACUUM */
        break;
      case 197:
        YYTRACE("cmd ::= PRAGMA ids EQ ids")
#line 535 "../../../providers/default/sqlite/parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy258,&yymsp[0].minor.yy258,0);}
#line 6508 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 198:
        YYTRACE("cmd ::= PRAGMA ids EQ ON")
#line 536 "../../../providers/default/sqlite/parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy258,&yymsp[0].minor.yy0,0);}
#line 6516 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 199:
        YYTRACE("cmd ::= PRAGMA ids EQ plus_num")
#line 537 "../../../providers/default/sqlite/parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy258,&yymsp[0].minor.yy258,0);}
#line 6524 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 200:
        YYTRACE("cmd ::= PRAGMA ids EQ minus_num")
#line 538 "../../../providers/default/sqlite/parse.y"
{sqlitePragma(pParse,&yymsp[-2].minor.yy258,&yymsp[0].minor.yy258,1);}
#line 6532 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 201:
        YYTRACE("cmd ::= PRAGMA ids LP ids RP")
#line 539 "../../../providers/default/sqlite/parse.y"
{sqlitePragma(pParse,&yymsp[-3].minor.yy258,&yymsp[-1].minor.yy258,0);}
#line 6540 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 202:
        YYTRACE("plus_num ::= plus_opt number")
#line 540 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy258 = yymsp[0].minor.yy258;}
#line 6549 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for plus_opt */
        break;
      case 203:
        YYTRACE("minus_num ::= MINUS number")
#line 541 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy258 = yymsp[0].minor.yy258;}
#line 6556 "../../../providers/default/sqlite/parse.c"
        /* No destructor defined for MINUS */
        break;
      case 204:
        YYTRACE("number ::= INTEGER")
#line 542 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy258 = yymsp[0].minor.yy0;}
#line 6563 "../../../providers/default/sqlite/parse.c"
        break;
      case 205:
        YYTRACE("number ::= FLOAT")
#line 543 "../../../providers/default/sqlite/parse.y"
{yygotominor.yy258 = yymsp[0].minor.yy0;}
#line 6569 "../../../providers/default/sqlite/parse.c"
        break;
      case 206:
        YYTRACE("plus_opt ::= PLUS")
        /* No destructor defined for PLUS */
        break;
      case 207:
        YYTRACE("plus_opt ::=")
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->idx -= yysize;
  yypParser->top -= yysize;
  yyact = yy_find_parser_action(yypParser,yygoto);
  if( yyact < YYNSTATE ){
    yy_shift(yypParser,yyact,yygoto,&yygotominor);
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser sqliteParserARGDECL);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
  sqliteParserANSIARGDECL              /* Extra arguments (if any) */
){
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->idx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
  sqliteParserANSIARGDECL               /* Extra arguments (if any) */
){
#define TOKEN (yyminor.yy0)
#line 23 "../../../providers/default/sqlite/parse.y"

  sqliteSetString(&pParse->zErrMsg,"syntax error",0);
  pParse->sErrToken = TOKEN;

#line 6623 "../../../providers/default/sqlite/parse.c"
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
  sqliteParserANSIARGDECL              /* Extra arguments (if any) */
){
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->idx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqliteParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqliteParser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqliteParserTOKENTYPE yyminor       /* The value for the token */
  sqliteParserANSIARGDECL
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->idx<0 ){
    if( yymajor==0 ) return;
    yypParser->idx = 0;
    yypParser->errcnt = -1;
    yypParser->top = &yypParser->stack[0];
    yypParser->top->stateno = 0;
    yypParser->top->major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_parser_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->errcnt--;
      if( yyendofinput && yypParser->idx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE sqliteParserARGDECL);
    }else if( yyact == YY_ERROR_ACTION ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->errcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion sqliteParserARGDECL);
      }
      if( yypParser->top->major==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->idx >= 0 &&
          yypParser->top->major != YYERRORSYMBOL &&
          (yyact = yy_find_parser_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->idx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser sqliteParserARGDECL);
          yymajor = YYNOCODE;
        }else if( yypParser->top->major!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->errcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->errcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion sqliteParserARGDECL);
      }
      yypParser->errcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser sqliteParserARGDECL);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser sqliteParserARGDECL);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->idx>=0 );
  return;
}
