/* GDA client libary
 * Copyright (C) 1998,1999 Michael Lausch
 * Copyright (C) 1999 Rodrigo Moya
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * The Gnome Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with the Gnome Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __gda_recordset_h__
#define __gda_recordset_h__ 1

#include <glib.h>
#include <gtk/gtkobject.h>
#include <orb/orbit.h>
#include <GDA.h>
#include <gda-common-defs.h>
#include <gda-field.h>

G_BEGIN_DECLS

/* The recordset object. Holds the result from executing a
 * command object. Buffering and updating data is done thrugh these
 * objects. 
 */

typedef struct _GdaRecordset GdaRecordset;
typedef struct _GdaRecordsetClass GdaRecordsetClass;

#include <gda-command.h>	/* These two need the definitions above */
#include <gda-connection.h>

#define GDA_TYPE_RECORDSET            (gda_recordset_get_type())
#define GDA_RECORDSET(obj)            GTK_CHECK_CAST(obj, GDA_TYPE_RECORDSET, GdaRecordset)
#define GDA_RECORDSET_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, GDA_TYPE_RECORDSET, GdaRecordsetClass)
#define GDA_IS_RECORDSET(obj)         GTK_CHECK_TYPE(obj, GDA_TYPE_RECORDSET)
#define GDA_IS_RECORDSET_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GDA_TYPE_RECORDSET))

#define GDA_RECORDSET_INVALID_POSITION 0xffffffff

struct _GdaRecordset {
	GtkObject object;

	GdaCommand *external_cmd;
	GdaCommand *internal_cmd;	/* used for cmd object
					   * generated by gda_recordset_open */
	CORBA_Object corba_rs;
	GdaConnection *cnc;
	CORBA_ORB orb;
	GList *chunks;
	gint chunks_length;
	GDA_Row *current_row;
	GDA_RowAttributes *field_attributes;
	/* current index(adjustment->value). 0 means invalid, 1 is the first record */
	gulong current_index;
	/* max index (adjustment->upper), 0 is invalid */
	gulong max_index;
	gulong affected_rows;
	gint maxrows;
	gint cachesize;
	gint open;
	gint eof;
	gint bof;
	gint readonly;
	GDA_CursorLocation cursor_location;
	GDA_CursorType cursor_type;
	GDA_LockType lock_type;
	gchar *name;
};

struct _GdaRecordsetClass {
	GtkObjectClass parent_class;

	void (*error) (GdaRecordset *, GList *);
	void (*eof) (GdaRecordset *);
	void (*bof) (GdaRecordset *);
	void (*row_changed) (GdaRecordset *);
};

guint gda_recordset_get_type (void);

GdaRecordset *gda_recordset_new (void);
void gda_recordset_free (GdaRecordset * rs);
void gda_recordset_set_name (GdaRecordset * rs, gchar * name);
void gda_recordset_get_name (GdaRecordset * rs, gchar * name);
void gda_recordset_close (GdaRecordset * rs);
GdaField *gda_recordset_field_name (GdaRecordset * rs, gchar * name);
GdaField *gda_recordset_field_idx (GdaRecordset * rs, gint idx);
gboolean gda_recordset_bof (GdaRecordset * rs);
gboolean gda_recordset_eof (GdaRecordset * rs);
gulong gda_recordset_move (GdaRecordset * rs,
			   gint count, gpointer bookmark);
gulong gda_recordset_move_first (GdaRecordset * rs);
gulong gda_recordset_move_last (GdaRecordset * rs);
gulong gda_recordset_move_next (GdaRecordset * rs);
gulong gda_recordset_move_prev (GdaRecordset * rs);
gint gda_recordset_rowsize (GdaRecordset * rs);
gulong gda_recordset_affected_rows (GdaRecordset * rs);
gint gda_recordset_open (GdaRecordset * rs,
			 GdaCommand * cmd,
			 GDA_CursorType cursor_type,
			 GDA_LockType lock_type, gulong options);
gint gda_recordset_open_txt (GdaRecordset * rs,
			     gchar * txt,
			     GDA_CursorType cursor_type,
			     GDA_LockType lock_type, gulong options);
gint gda_recordset_set_connection (GdaRecordset * rs,
				   GdaConnection * cnc);
GdaConnection *gda_recordset_get_connection (GdaRecordset * rs);
gint gda_recordset_add_field (GdaRecordset * rs, GdaField * field);
gint gda_recordset_create (GdaRecordset * rs);

GDA_CursorLocation gda_recordset_get_cursorloc (GdaRecordset * rs);
void gda_recordset_set_cursorloc (GdaRecordset * rs,
				  GDA_CursorLocation loc);
GDA_CursorType gda_recordset_get_cursortype (GdaRecordset * rs);
void gda_recordset_set_cursortype (GdaRecordset * rs,
				   GDA_CursorType type);

GPtrArray *gda_recordset_to_array (GdaRecordset * rs);
GList *gda_recordset_get_row (GdaRecordset *rs);
gchar *gda_recordset_get_row_as_string (GdaRecordset *rs);

G_END_DECLS

#endif
