/* gridframe.c generated by valac 0.31.1.6-4f062, the Vala compiler
 * generated from gridframe.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2015 Michael Catanzaro <mcatanzaro@gnome.org>
 *
 * This file is part of libgames-support.
 *
 * libgames-support is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libgames-support is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with libgames-support.  If not, see <http://www.gnu.org/licenses/>.
 */
/* A container that guarantees that the internal allocated space is a fixed*/
/* multiple of an integer. This is a fairly literal translation of the LGPLv2+*/
/* original by Callum McKenzie, itself based on GtkFrame and GtkAspectFrame.*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <gdk/gdk.h>


#define GAMES_TYPE_GRID_FRAME (games_grid_frame_get_type ())
#define GAMES_GRID_FRAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GRID_FRAME, GamesGridFrame))
#define GAMES_GRID_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GRID_FRAME, GamesGridFrameClass))
#define GAMES_IS_GRID_FRAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GRID_FRAME))
#define GAMES_IS_GRID_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GRID_FRAME))
#define GAMES_GRID_FRAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GRID_FRAME, GamesGridFrameClass))

typedef struct _GamesGridFrame GamesGridFrame;
typedef struct _GamesGridFrameClass GamesGridFrameClass;
typedef struct _GamesGridFramePrivate GamesGridFramePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GamesGridFrame {
	GtkBin parent_instance;
	GamesGridFramePrivate * priv;
};

struct _GamesGridFrameClass {
	GtkBinClass parent_class;
};

struct _GamesGridFramePrivate {
	gint _xpadding;
	gint _ypadding;
	gint _xmult;
	gint _ymult;
	gfloat _xalign;
	gfloat _yalign;
	GtkAllocation old_allocation;
};


static gpointer games_grid_frame_parent_class = NULL;

GType games_grid_frame_get_type (void) G_GNUC_CONST;
#define GAMES_GRID_FRAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_GRID_FRAME, GamesGridFramePrivate))
enum  {
	GAMES_GRID_FRAME_DUMMY_PROPERTY,
	GAMES_GRID_FRAME_XPADDING,
	GAMES_GRID_FRAME_YPADDING,
	GAMES_GRID_FRAME_WIDTH,
	GAMES_GRID_FRAME_HEIGHT,
	GAMES_GRID_FRAME_XALIGN,
	GAMES_GRID_FRAME_YALIGN
};
GamesGridFrame* games_grid_frame_new (gint width, gint height);
GamesGridFrame* games_grid_frame_construct (GType object_type, gint width, gint height);
void games_grid_frame_set (GamesGridFrame* self, gint width, gint height);
void games_grid_frame_set_width (GamesGridFrame* self, gint value);
void games_grid_frame_set_height (GamesGridFrame* self, gint value);
void games_grid_frame_set_padding (GamesGridFrame* self, gint xpadding, gint ypadding);
void games_grid_frame_set_xpadding (GamesGridFrame* self, gint value);
void games_grid_frame_set_ypadding (GamesGridFrame* self, gint value);
void games_grid_frame_set_alignment (GamesGridFrame* self, gfloat xalign, gfloat yalign);
void games_grid_frame_set_xalign (GamesGridFrame* self, gfloat value);
void games_grid_frame_set_yalign (GamesGridFrame* self, gfloat value);
static void games_grid_frame_real_size_allocate (GtkWidget* base, GtkAllocation* allocation);
gint games_grid_frame_get_xpadding (GamesGridFrame* self);
gint games_grid_frame_get_ypadding (GamesGridFrame* self);
gint games_grid_frame_get_width (GamesGridFrame* self);
gint games_grid_frame_get_height (GamesGridFrame* self);
gfloat games_grid_frame_get_xalign (GamesGridFrame* self);
gfloat games_grid_frame_get_yalign (GamesGridFrame* self);
static void games_grid_frame_finalize (GObject* obj);
static void _vala_games_grid_frame_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_games_grid_frame_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GamesGridFrame* games_grid_frame_construct (GType object_type, gint width, gint height) {
	GamesGridFrame * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	self = (GamesGridFrame*) g_object_new (object_type, NULL);
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp0_ = width;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp1_ = height;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	games_grid_frame_set (self, _tmp0_, _tmp1_);
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	return self;
#line 119 "gridframe.c"
}


GamesGridFrame* games_grid_frame_new (gint width, gint height) {
#line 115 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	return games_grid_frame_construct (GAMES_TYPE_GRID_FRAME, width, height);
#line 126 "gridframe.c"
}


void games_grid_frame_set (GamesGridFrame* self, gint width, gint height) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 120 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_return_if_fail (self != NULL);
#line 122 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp0_ = width;
#line 122 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	games_grid_frame_set_width (self, _tmp0_);
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp1_ = height;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	games_grid_frame_set_height (self, _tmp1_);
#line 143 "gridframe.c"
}


void games_grid_frame_set_padding (GamesGridFrame* self, gint xpadding, gint ypadding) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_return_if_fail (self != NULL);
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp0_ = xpadding;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	games_grid_frame_set_xpadding (self, _tmp0_);
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp1_ = ypadding;
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	games_grid_frame_set_ypadding (self, _tmp1_);
#line 160 "gridframe.c"
}


void games_grid_frame_set_alignment (GamesGridFrame* self, gfloat xalign, gfloat yalign) {
	gfloat _tmp0_ = 0.0F;
	gfloat _tmp1_ = 0.0F;
#line 132 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_return_if_fail (self != NULL);
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp0_ = xalign;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	games_grid_frame_set_xalign (self, _tmp0_);
#line 135 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp1_ = yalign;
#line 135 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	games_grid_frame_set_yalign (self, _tmp1_);
#line 177 "gridframe.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	return self ? g_object_ref (self) : NULL;
#line 184 "gridframe.c"
}


static void games_grid_frame_real_size_allocate (GtkWidget* base, GtkAllocation* allocation) {
	GamesGridFrame * self;
	GtkAllocation _tmp0_ = {0};
	gint xsize = 0;
	GtkAllocation _tmp1_ = {0};
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint ysize = 0;
	GtkAllocation _tmp6_ = {0};
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint size = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	GtkAllocation child_allocation = {0};
	GtkAllocation _tmp14_ = {0};
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	GtkAllocation _tmp21_ = {0};
	gint _tmp22_ = 0;
	GtkAllocation _tmp23_ = {0};
	gint _tmp24_ = 0;
	gfloat _tmp25_ = 0.0F;
	GtkAllocation _tmp26_ = {0};
	gint _tmp27_ = 0;
	GtkAllocation _tmp28_ = {0};
	gint _tmp29_ = 0;
	GtkAllocation _tmp30_ = {0};
	gint _tmp31_ = 0;
	gfloat _tmp32_ = 0.0F;
	GtkAllocation _tmp33_ = {0};
	gint _tmp34_ = 0;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	GtkWidget* child = NULL;
	GtkWidget* _tmp59_ = NULL;
	GtkWidget* _tmp60_ = NULL;
	gboolean _tmp61_ = FALSE;
	GtkWidget* _tmp62_ = NULL;
	GtkAllocation _tmp67_ = {0};
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	self = (GamesGridFrame*) base;
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_return_if_fail (allocation != NULL);
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp0_ = *allocation;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	GTK_WIDGET_CLASS (games_grid_frame_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_bin_get_type (), GtkBin), &_tmp0_);
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp1_ = *allocation;
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp2_ = _tmp1_.width;
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp3_ = self->priv->_xpadding;
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp4_ = self->priv->_xmult;
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp5_ = MAX (1, (_tmp2_ - _tmp3_) / _tmp4_);
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	xsize = _tmp5_;
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp6_ = *allocation;
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp7_ = _tmp6_.height;
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp8_ = self->priv->_ypadding;
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp9_ = self->priv->_ymult;
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp10_ = MAX (1, (_tmp7_ - _tmp8_) / _tmp9_);
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	ysize = _tmp10_;
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp11_ = xsize;
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp12_ = ysize;
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp13_ = MIN (_tmp11_, _tmp12_);
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	size = _tmp13_;
#line 146 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp14_.x = 0;
#line 146 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp14_.y = 0;
#line 146 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp14_.width = 0;
#line 146 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp14_.height = 0;
#line 146 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	child_allocation = _tmp14_;
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp15_ = size;
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp16_ = self->priv->_xmult;
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp17_ = self->priv->_xpadding;
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	child_allocation.width = (_tmp15_ * _tmp16_) + _tmp17_;
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp18_ = size;
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp19_ = self->priv->_ymult;
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp20_ = self->priv->_ypadding;
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	child_allocation.height = (_tmp18_ * _tmp19_) + _tmp20_;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp21_ = *allocation;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp22_ = _tmp21_.width;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp23_ = child_allocation;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp24_ = _tmp23_.width;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp25_ = self->priv->_xalign;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp26_ = *allocation;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp27_ = _tmp26_.x;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	child_allocation.x = (gint) (((_tmp22_ - _tmp24_) * _tmp25_) + _tmp27_);
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp28_ = *allocation;
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp29_ = _tmp28_.height;
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp30_ = child_allocation;
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp31_ = _tmp30_.height;
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp32_ = self->priv->_yalign;
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp33_ = *allocation;
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp34_ = _tmp33_.y;
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	child_allocation.y = (gint) (((_tmp29_ - _tmp31_) * _tmp32_) + _tmp34_);
#line 152 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp36_ = gtk_widget_get_mapped ((GtkWidget*) self);
#line 152 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	if (_tmp36_) {
#line 339 "gridframe.c"
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_ = FALSE;
		GtkAllocation _tmp40_ = {0};
		gint _tmp41_ = 0;
		GtkAllocation _tmp42_ = {0};
		gint _tmp43_ = 0;
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		_tmp40_ = child_allocation;
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		_tmp41_ = _tmp40_.x;
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		_tmp42_ = self->priv->old_allocation;
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		_tmp43_ = _tmp42_.x;
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		if (_tmp41_ != _tmp43_) {
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
			_tmp39_ = TRUE;
#line 359 "gridframe.c"
		} else {
			GtkAllocation _tmp44_ = {0};
			gint _tmp45_ = 0;
			GtkAllocation _tmp46_ = {0};
			gint _tmp47_ = 0;
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
			_tmp44_ = child_allocation;
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
			_tmp45_ = _tmp44_.y;
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
			_tmp46_ = self->priv->old_allocation;
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
			_tmp47_ = _tmp46_.y;
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
			_tmp39_ = _tmp45_ != _tmp47_;
#line 375 "gridframe.c"
		}
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		if (_tmp39_) {
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
			_tmp38_ = TRUE;
#line 381 "gridframe.c"
		} else {
			GtkAllocation _tmp48_ = {0};
			gint _tmp49_ = 0;
			GtkAllocation _tmp50_ = {0};
			gint _tmp51_ = 0;
#line 155 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
			_tmp48_ = child_allocation;
#line 155 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
			_tmp49_ = _tmp48_.width;
#line 155 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
			_tmp50_ = self->priv->old_allocation;
#line 155 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
			_tmp51_ = _tmp50_.width;
#line 155 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
			_tmp38_ = _tmp49_ != _tmp51_;
#line 397 "gridframe.c"
		}
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		if (_tmp38_) {
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
			_tmp37_ = TRUE;
#line 403 "gridframe.c"
		} else {
			GtkAllocation _tmp52_ = {0};
			gint _tmp53_ = 0;
			GtkAllocation _tmp54_ = {0};
			gint _tmp55_ = 0;
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
			_tmp52_ = child_allocation;
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
			_tmp53_ = _tmp52_.height;
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
			_tmp54_ = self->priv->old_allocation;
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
			_tmp55_ = _tmp54_.height;
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
			_tmp37_ = _tmp53_ != _tmp55_;
#line 419 "gridframe.c"
		}
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		_tmp35_ = _tmp37_;
#line 423 "gridframe.c"
	} else {
#line 152 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		_tmp35_ = FALSE;
#line 427 "gridframe.c"
	}
#line 152 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	if (_tmp35_) {
#line 431 "gridframe.c"
		GdkWindow* _tmp56_ = NULL;
		GtkAllocation _tmp57_ = {0};
		GdkRectangle _tmp58_ = {0};
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		_tmp56_ = gtk_widget_get_window ((GtkWidget*) self);
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		_tmp57_ = *allocation;
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		_tmp58_ = _tmp57_;
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		gdk_window_invalidate_rect (_tmp56_, &_tmp58_, FALSE);
#line 443 "gridframe.c"
	}
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp59_ = gtk_bin_get_child ((GtkBin*) self);
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp60_ = _g_object_ref0 (_tmp59_);
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	child = _tmp60_;
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp62_ = child;
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	if (_tmp62_ != NULL) {
#line 455 "gridframe.c"
		GtkWidget* _tmp63_ = NULL;
		gboolean _tmp64_ = FALSE;
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		_tmp63_ = child;
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		_tmp64_ = gtk_widget_get_visible (_tmp63_);
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		_tmp61_ = _tmp64_;
#line 464 "gridframe.c"
	} else {
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		_tmp61_ = FALSE;
#line 468 "gridframe.c"
	}
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	if (_tmp61_) {
#line 472 "gridframe.c"
		GtkWidget* _tmp65_ = NULL;
		GtkAllocation _tmp66_ = {0};
#line 163 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		_tmp65_ = child;
#line 163 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		_tmp66_ = child_allocation;
#line 163 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		gtk_widget_size_allocate (_tmp65_, &_tmp66_);
#line 481 "gridframe.c"
	}
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp67_ = child_allocation;
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	self->priv->old_allocation = _tmp67_;
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_g_object_unref0 (child);
#line 489 "gridframe.c"
}


gint games_grid_frame_get_xpadding (GamesGridFrame* self) {
	gint result;
	gint _tmp0_ = 0;
#line 32 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 32 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp0_ = self->priv->_xpadding;
#line 32 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	result = _tmp0_;
#line 32 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	return result;
#line 504 "gridframe.c"
}


void games_grid_frame_set_xpadding (GamesGridFrame* self, gint value) {
	gint _tmp0_ = 0;
#line 34 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_return_if_fail (self != NULL);
#line 36 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp0_ = value;
#line 36 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	if (_tmp0_ >= 0) {
#line 516 "gridframe.c"
		gint _tmp1_ = 0;
#line 38 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		_tmp1_ = value;
#line 38 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		self->priv->_xpadding = _tmp1_;
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		gtk_widget_queue_resize ((GtkWidget*) self);
#line 524 "gridframe.c"
	}
#line 34 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_object_notify ((GObject *) self, "xpadding");
#line 528 "gridframe.c"
}


gint games_grid_frame_get_ypadding (GamesGridFrame* self) {
	gint result;
	gint _tmp0_ = 0;
#line 47 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 47 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp0_ = self->priv->_ypadding;
#line 47 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	result = _tmp0_;
#line 47 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	return result;
#line 543 "gridframe.c"
}


void games_grid_frame_set_ypadding (GamesGridFrame* self, gint value) {
	gint _tmp0_ = 0;
#line 49 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_return_if_fail (self != NULL);
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp0_ = value;
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	if (_tmp0_ >= 0) {
#line 555 "gridframe.c"
		gint _tmp1_ = 0;
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		_tmp1_ = value;
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		self->priv->_ypadding = _tmp1_;
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		gtk_widget_queue_resize ((GtkWidget*) self);
#line 563 "gridframe.c"
	}
#line 49 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_object_notify ((GObject *) self, "ypadding");
#line 567 "gridframe.c"
}


gint games_grid_frame_get_width (GamesGridFrame* self) {
	gint result;
	gint _tmp0_ = 0;
#line 62 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 62 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp0_ = self->priv->_xmult;
#line 62 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	result = _tmp0_;
#line 62 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	return result;
#line 582 "gridframe.c"
}


void games_grid_frame_set_width (GamesGridFrame* self, gint value) {
	gint _tmp0_ = 0;
#line 64 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_return_if_fail (self != NULL);
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp0_ = value;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	if (_tmp0_ > 0) {
#line 594 "gridframe.c"
		gint _tmp1_ = 0;
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		_tmp1_ = value;
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		self->priv->_xmult = _tmp1_;
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		gtk_widget_queue_resize ((GtkWidget*) self);
#line 602 "gridframe.c"
	}
#line 64 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_object_notify ((GObject *) self, "width");
#line 606 "gridframe.c"
}


gint games_grid_frame_get_height (GamesGridFrame* self) {
	gint result;
	gint _tmp0_ = 0;
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp0_ = self->priv->_ymult;
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	result = _tmp0_;
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	return result;
#line 621 "gridframe.c"
}


void games_grid_frame_set_height (GamesGridFrame* self, gint value) {
	gint _tmp0_ = 0;
#line 79 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_return_if_fail (self != NULL);
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp0_ = value;
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	if (_tmp0_ > 0) {
#line 633 "gridframe.c"
		gint _tmp1_ = 0;
#line 83 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		_tmp1_ = value;
#line 83 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		self->priv->_ymult = _tmp1_;
#line 84 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		gtk_widget_queue_resize ((GtkWidget*) self);
#line 641 "gridframe.c"
	}
#line 79 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_object_notify ((GObject *) self, "height");
#line 645 "gridframe.c"
}


gfloat games_grid_frame_get_xalign (GamesGridFrame* self) {
	gfloat result;
	gfloat _tmp0_ = 0.0F;
#line 92 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_return_val_if_fail (self != NULL, 0.0F);
#line 92 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp0_ = self->priv->_xalign;
#line 92 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	result = _tmp0_;
#line 92 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	return result;
#line 660 "gridframe.c"
}


void games_grid_frame_set_xalign (GamesGridFrame* self, gfloat value) {
	gfloat _tmp0_ = 0.0F;
	gfloat _tmp1_ = 0.0F;
#line 94 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_return_if_fail (self != NULL);
#line 96 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp0_ = value;
#line 96 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp1_ = CLAMP (_tmp0_, 0.0f, 1.0f);
#line 96 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	self->priv->_xalign = _tmp1_;
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	gtk_widget_queue_resize ((GtkWidget*) self);
#line 94 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_object_notify ((GObject *) self, "xalign");
#line 679 "gridframe.c"
}


gfloat games_grid_frame_get_yalign (GamesGridFrame* self) {
	gfloat result;
	gfloat _tmp0_ = 0.0F;
#line 104 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_return_val_if_fail (self != NULL, 0.0F);
#line 104 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp0_ = self->priv->_yalign;
#line 104 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	result = _tmp0_;
#line 104 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	return result;
#line 694 "gridframe.c"
}


void games_grid_frame_set_yalign (GamesGridFrame* self, gfloat value) {
	gfloat _tmp0_ = 0.0F;
	gfloat _tmp1_ = 0.0F;
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_return_if_fail (self != NULL);
#line 108 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp0_ = value;
#line 108 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	_tmp1_ = CLAMP (_tmp0_, 0.0f, 1.0f);
#line 108 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	self->priv->_yalign = _tmp1_;
#line 109 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	gtk_widget_queue_resize ((GtkWidget*) self);
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_object_notify ((GObject *) self, "yalign");
#line 713 "gridframe.c"
}


static void games_grid_frame_class_init (GamesGridFrameClass * klass) {
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	games_grid_frame_parent_class = g_type_class_peek_parent (klass);
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_type_class_add_private (klass, sizeof (GamesGridFramePrivate));
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	((GtkWidgetClass *) klass)->size_allocate = games_grid_frame_real_size_allocate;
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_games_grid_frame_get_property;
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_games_grid_frame_set_property;
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	G_OBJECT_CLASS (klass)->finalize = games_grid_frame_finalize;
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GRID_FRAME_XPADDING, g_param_spec_int ("xpadding", "xpadding", "xpadding", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GRID_FRAME_YPADDING, g_param_spec_int ("ypadding", "ypadding", "ypadding", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GRID_FRAME_WIDTH, g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GRID_FRAME_HEIGHT, g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GRID_FRAME_XALIGN, g_param_spec_float ("xalign", "xalign", "xalign", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GRID_FRAME_YALIGN, g_param_spec_float ("yalign", "yalign", "yalign", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 742 "gridframe.c"
}


static void games_grid_frame_instance_init (GamesGridFrame * self) {
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	self->priv = GAMES_GRID_FRAME_GET_PRIVATE (self);
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	self->priv->_xpadding = 0;
#line 44 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	self->priv->_ypadding = 0;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	self->priv->_xmult = 1;
#line 74 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	self->priv->_ymult = 1;
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	self->priv->_xalign = 0.5f;
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	self->priv->_yalign = 0.5f;
#line 761 "gridframe.c"
}


static void games_grid_frame_finalize (GObject* obj) {
	GamesGridFrame * self;
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GRID_FRAME, GamesGridFrame);
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	G_OBJECT_CLASS (games_grid_frame_parent_class)->finalize (obj);
#line 771 "gridframe.c"
}


GType games_grid_frame_get_type (void) {
	static volatile gsize games_grid_frame_type_id__volatile = 0;
	if (g_once_init_enter (&games_grid_frame_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GamesGridFrameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_grid_frame_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesGridFrame), 0, (GInstanceInitFunc) games_grid_frame_instance_init, NULL };
		GType games_grid_frame_type_id;
		games_grid_frame_type_id = g_type_register_static (gtk_bin_get_type (), "GamesGridFrame", &g_define_type_info, 0);
		g_once_init_leave (&games_grid_frame_type_id__volatile, games_grid_frame_type_id);
	}
	return games_grid_frame_type_id__volatile;
}


static void _vala_games_grid_frame_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GamesGridFrame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GRID_FRAME, GamesGridFrame);
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	switch (property_id) {
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		case GAMES_GRID_FRAME_XPADDING:
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		g_value_set_int (value, games_grid_frame_get_xpadding (self));
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		break;
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		case GAMES_GRID_FRAME_YPADDING:
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		g_value_set_int (value, games_grid_frame_get_ypadding (self));
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		break;
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		case GAMES_GRID_FRAME_WIDTH:
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		g_value_set_int (value, games_grid_frame_get_width (self));
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		break;
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		case GAMES_GRID_FRAME_HEIGHT:
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		g_value_set_int (value, games_grid_frame_get_height (self));
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		break;
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		case GAMES_GRID_FRAME_XALIGN:
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		g_value_set_float (value, games_grid_frame_get_xalign (self));
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		break;
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		case GAMES_GRID_FRAME_YALIGN:
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		g_value_set_float (value, games_grid_frame_get_yalign (self));
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		break;
#line 828 "gridframe.c"
		default:
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		break;
#line 834 "gridframe.c"
	}
}


static void _vala_games_grid_frame_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GamesGridFrame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GRID_FRAME, GamesGridFrame);
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
	switch (property_id) {
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		case GAMES_GRID_FRAME_XPADDING:
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		games_grid_frame_set_xpadding (self, g_value_get_int (value));
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		break;
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		case GAMES_GRID_FRAME_YPADDING:
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		games_grid_frame_set_ypadding (self, g_value_get_int (value));
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		break;
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		case GAMES_GRID_FRAME_WIDTH:
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		games_grid_frame_set_width (self, g_value_get_int (value));
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		break;
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		case GAMES_GRID_FRAME_HEIGHT:
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		games_grid_frame_set_height (self, g_value_get_int (value));
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		break;
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		case GAMES_GRID_FRAME_XALIGN:
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		games_grid_frame_set_xalign (self, g_value_get_float (value));
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		break;
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		case GAMES_GRID_FRAME_YALIGN:
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		games_grid_frame_set_yalign (self, g_value_get_float (value));
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		break;
#line 880 "gridframe.c"
		default:
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 27 "/home/mcatanzaro/src/jhbuild/checkout/libgames-support/games/gridframe.vala"
		break;
#line 886 "gridframe.c"
	}
}



