/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <string.h>
#include "jg_jnu.h"
#include "gtk_java.h"
#include <libebook/e-book.h>
#include "org_gnu_libedataserver_ESourceList.h"
#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org.gnu.libedataserver.ESourceList
 * Method:    e_source_list_new
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libedataserver_ESourceList_e_1source_1list_1new
(JNIEnv *env, jclass cls)
{
    return getGObjectHandle(env, (GObject*)e_source_list_new());
}


/*
 * Class:     org.gnu.libedataserver.ESourceList
 * Method:    e_source_list_new_for_gconf_default
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libedataserver_ESourceList_e_1source_1list_1new_1for_1gconf_1default
(JNIEnv *env, jclass cls, jstring path)
{
    char* path_g = (char*)(*env)->GetStringUTFChars(env, path, 0);
    jobject result = getGObjectHandle(env, (GObject*)e_source_list_new_for_gconf_default(path_g));
    (*env)->ReleaseStringUTFChars(env, path, path_g);
    return result;
}

/*
 * Class:     org.gnu.libedataserver.ESourceList
 * Method:    e_source_list_peek_groups
 */
JNIEXPORT jobjectArray JNICALL Java_org_gnu_libedataserver_ESourceList_e_1source_1list_1peek_1groups
(JNIEnv *env, jclass cls, jobject obj)
{
    ESourceList *e_source_list_g = (ESourceList*)getPointerFromHandle(env, obj);
    return getGObjectHandlesFromGSList(env, e_source_list_peek_groups (e_source_list_g));
}

/*
 * Class:     org.gnu.libedataserver.ESourceList
 * Method:    e_source_list_peek_group_by_name
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libedataserver_ESourceList_e_1source_1list_1peek_1group_1by_1name
(JNIEnv *env, jclass cls, jobject obj, jstring name)
{
    char* name_g = (char*)(*env)->GetStringUTFChars(env, name, 0);
    ESourceList *e_source_list_g = (ESourceList*)getPointerFromHandle(env, obj);
    jobject result = getGObjectHandle(env, (GObject*)e_source_list_peek_group_by_name(e_source_list_g, name_g));
    (*env)->ReleaseStringUTFChars(env, name, name_g);
    return result;
}

/*
 * Class:     org.gnu.libedataserver.ESourceList
 * Method:    e_source_list_peek_group_by_uid
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libedataserver_ESourceList_e_1source_1list_1peek_1group_1by_1uid
(JNIEnv *env, jclass cls, jobject obj, jstring uid)
{
    char* uid_g = (char*)(*env)->GetStringUTFChars(env, uid, 0);
    ESourceList *e_source_list_g = (ESourceList*)getPointerFromHandle(env, obj);
    jobject result = getGObjectHandle(env, (GObject*)e_source_list_peek_group_by_uid(e_source_list_g, uid_g));
    (*env)->ReleaseStringUTFChars(env, uid, uid_g);
    return result;
}

/*
 * Class:     org.gnu.libedataserver.ESourceList
 * Method:    e_source_list_peek_source_by_uid
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libedataserver_ESourceList_e_1source_1list_1peek_1source_1by_1uid
(JNIEnv *env, jclass cls, jobject obj, jstring uid)
{
    char* uid_g = (char*)(*env)->GetStringUTFChars(env, uid, 0);
    ESourceList *e_source_list_g = (ESourceList*)getPointerFromHandle(env, obj);
    jobject result = getGObjectHandle(env, (GObject*)e_source_list_peek_source_by_uid(e_source_list_g, uid_g));
    (*env)->ReleaseStringUTFChars(env, uid, uid_g);
    return result;
}

/*
 * Class:     org.gnu.libedataserver.ESourceList
 * Method:    e_source_list_peek_source_any
 */
JNIEXPORT jobject JNICALL Java_org_gnu_libedataserver_ESourceList_e_1source_1list_1peek_1source_1any
(JNIEnv *env, jclass cls, jobject obj)
{
    ESourceList *e_source_list_g = (ESourceList*)getPointerFromHandle(env, obj);
    return getGObjectHandle(env, (GObject*)e_source_list_peek_source_any(e_source_list_g));
}


/*
 * Class:     org.gnu.libedataserver.ESourceList
 * Method:    e_source_list_add_group
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_libedataserver_ESourceList_e_1source_1list_1add_1group
(JNIEnv *env, jclass cls, jobject obj, jobject group, jint position)
{
    ESourceList *e_source_list_g = (ESourceList*)getPointerFromHandle(env, obj);
    ESourceGroup *e_source_group_g = (ESourceGroup*)getPointerFromHandle(env, group);
    return e_source_list_add_group(e_source_list_g, e_source_group_g, position);
}

/*
 * Class:     org.gnu.libedataserver.ESourceList
 * Method:    e_source_list_remove_group
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_libedataserver_ESourceList_e_1source_1list_1remove_1group
(JNIEnv *env, jclass cls, jobject obj, jobject group)
{
    ESourceList *e_source_list_g = (ESourceList*)getPointerFromHandle(env, obj);
    ESourceGroup *e_source_group_g = (ESourceGroup*)getPointerFromHandle(env, group);
    return e_source_list_remove_group(e_source_list_g, e_source_group_g);
}

/*
 * Class:     org.gnu.libedataserver.ESourceList
 * Method:    e_source_list_remove_group_by_uid
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_libedataserver_ESourceList_e_1source_1list_1remove_1group_1by_1uid
(JNIEnv *env, jclass cls, jobject obj, jstring uid)
{
    ESourceList *e_source_list_g = (ESourceList*)getPointerFromHandle(env, obj);
    char* uid_g = (char*)(*env)->GetStringUTFChars(env, uid, 0);
    gboolean result =  e_source_list_remove_group_by_uid(e_source_list_g, uid_g);
    (*env)->ReleaseStringUTFChars(env, uid, uid_g);
    return result;
}

/*
 * Class:     org.gnu.libedataserver.ESourceList
 * Method:    e_source_list_remove_source_by_uid
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_libedataserver_ESourceList_e_1source_1list_1remove_1source_1by_1uid
(JNIEnv *env, jclass cls, jobject obj, jstring uid)
{
    ESourceList *e_source_list_g = (ESourceList*)getPointerFromHandle(env, obj);
    char* uid_g = (char*)(*env)->GetStringUTFChars(env, uid, 0);
    gboolean result =  e_source_list_remove_source_by_uid(e_source_list_g, uid_g);
    (*env)->ReleaseStringUTFChars(env, uid, uid_g);
    return result;
}

/*
 * Class:     org.gnu.libedataserver.ESourceList
 * Method:    e_source_list_sync
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_libedataserver_ESourceList_e_1source_1list_1sync
(JNIEnv *env, jclass cls, jobject obj)
{
    ESourceList *e_source_list_g = (ESourceList*)getPointerFromHandle(env, obj);
    return e_source_list_sync(e_source_list_g, NULL);
}

#ifdef __cplusplus
}

#endif
