package org.gnu.libedataserver;

import org.gnu.glib.Handle;
import org.gnu.glib.MemStruct;

/**
 * This object sits in between every EDS object that is non GObject, but requires memory management.
 * For now, for the purpose of instantiating g_type_init along with for abstractions sake.
 */
public abstract class EDSMemStruct extends MemStruct
{
    static {
        System.loadLibrary("edsjni-" + Config.LIBEBOOK_API_VERSION);
        if (!EDSObject.isGTypeInitialized)
            EDSObject.g_type_init();
    }

    public EDSMemStruct(Handle handle)
    {
        super(handle);
    }
}
