package org.gnu.libebook;

import org.gnu.libedataserver.EDSMemStruct;
import org.gnu.glib.Handle;
import org.gnu.glib.MemStruct;

public class EVCardAttributeParam extends EDSMemStruct
{
    private boolean _shouldFinalize;

    public EVCardAttributeParam(Handle handle, boolean shouldFinalize)
    {
        super(handle);
        _shouldFinalize = shouldFinalize;
    }

    public static EVCardAttributeParam getEVCardattributeParam(Handle handle)
    {
        return getEVCardattributeParam(handle, true);
    }

    public static EVCardAttributeParam getEVCardattributeParam(Handle handle, boolean shouldFinalize)
    {
        if (handle == null)
            return null;

        EVCardAttributeParam obj = (EVCardAttributeParam) MemStruct.getMemStructFromHandle(handle);
        return obj == null ? new EVCardAttributeParam(handle, shouldFinalize) : obj;
    }

    public void addValue(String value)
    {
        e_vcard_attribute_param_add_value(getHandle(), value);
    }

    public void removeValues()
    {
        e_vcard_attribute_param_remove_values(getHandle());
    }

    public String getName()
    {
        return e_vcard_attribute_param_get_name(getHandle());
    }

    public String[] getValues()
    {
        return e_vcard_attribute_param_get_values(getHandle());
    }

    public EVCardAttributeParam copy()
    {
        return EVCardAttributeParam.getEVCardattributeParam(e_vcard_attribute_param_copy(getHandle()));
    }

    public static EVCardAttributeParam createNew(String name)
    {
        return name == null ? null : EVCardAttributeParam.getEVCardattributeParam(e_vcard_attribute_param_new(name));
    }

    protected void finalize() throws Throwable
    {
        if (_shouldFinalize)
            super.finalize();
    }

    native static Handle e_vcard_attribute_param_new(String name);

    native static Handle e_vcard_attribute_param_copy(Handle handle);

    native static void e_vcard_attribute_param_add_value(Handle handle, String value);

    native static void e_vcard_attribute_param_remove_values(Handle handle);

    native static String e_vcard_attribute_param_get_name(Handle handle);

    native static String[] e_vcard_attribute_param_get_values(Handle handle);
}