/* this file is part of libccc, criawips' cairo-based canvas
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2005 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef CC_D_RECT_H
#define CC_D_RECT_H

#include <glib-object.h>

G_BEGIN_DECLS

typedef struct {
	gdouble x1;
	gdouble y1;
	gdouble x2;
	gdouble y2;
} CcDRect;

#define CC_TYPE_D_RECT (cc_d_rect_get_type())

GType cc_d_rect_get_type(void);

CcDRect* cc_d_rect_copy     (CcDRect const* one);
gboolean cc_d_rect_equal    (CcDRect  one,
			     CcDRect  two);
gboolean cc_d_rect_intersect(CcDRect  one,
			     CcDRect  two);
void     cc_d_rect_union    (CcDRect  one,
			     CcDRect  two,
			     CcDRect* merged);

G_END_DECLS

#endif /* !CC_D_RECT_H */

