/* this file is part of libccc, criawips' cairo-based canvas
 *
 * AUTHORS
 *       Sven Herzberg        <herzi@gnome-de.org>
 *
 * Copyright (C) 2005,2006 Sven Herzberg
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <ccc/cc-view-cell-renderer.h>

#include <ccc/cc-view.h>

G_DEFINE_TYPE_WITH_CODE(CcViewCellRenderer, cc_view_cell_renderer, GTK_TYPE_CELL_RENDERER,
			G_IMPLEMENT_INTERFACE(CC_TYPE_VIEW, NULL));

GtkCellRenderer*
cc_view_cell_renderer_new(void) {
	return g_object_new(CC_TYPE_VIEW_CELL_RENDERER, NULL);
}

/* GType stuff */
enum {
	PROP_0,
	PROP_FOCUS,
	PROP_ROOT,
	PROP_SCROLLED_REGION,
	PROP_ZOOM,
	PROP_ZOOM_MODE
};

static void
cc_view_cell_renderer_init(CcViewCellRenderer* self) {}

static void
cvcr_dispose(GObject* object) {
	CcViewCellRenderer* self = CC_VIEW_CELL_RENDERER(object);

	if(self->disposed) {
		return;
	}
	self->disposed = TRUE;

	if(self->root) {
		g_object_unref(self->root);
		self->root = NULL;
	}

	G_OBJECT_CLASS(cc_view_cell_renderer_parent_class)->dispose(object);
}

static void
cvcr_get_property(GObject* object, guint prop_id, GValue* value, GParamSpec* pspec) {
	CcViewCellRenderer* self = CC_VIEW_CELL_RENDERER(object);

	switch(prop_id) {
	case PROP_ROOT:
		g_value_set_object(value, self->root);
		break;
	case PROP_ZOOM:
		g_value_set_double(value, self->zoom);
		break;
	case PROP_ZOOM_MODE:
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
		break;
	}
}

static void
cvcr_set_property(GObject* object, guint prop_id, GValue const* value, GParamSpec* pspec) {
	CcViewCellRenderer* self = CC_VIEW_CELL_RENDERER(object);

	switch(prop_id) {
	case PROP_ROOT:
		if(self->root == g_value_get_object(value)) {
			break;
		}
		if(self->root) {
			g_object_unref(self->root);
			self->root = NULL;
		}
		if(g_value_get_object(value)) {
			self->root = g_object_ref(g_value_get_object(value));
		}
		g_object_notify(object, "root");
		break;
	case PROP_ZOOM:
		// apply value
		// emit notify
		break;
	case PROP_ZOOM_MODE:
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
		break;
	}
}

static void
cvcr_get_size(GtkCellRenderer* renderer, GtkWidget* widget, GdkRectangle* renderer_area, gint* x_offset, gint* y_offset, gint* width, gint* height) {
	if(width) {
		*width = 0;
	}

	if(height) {
		*height = 0;
	}
}

static void
cvcr_render(GtkCellRenderer* renderer, GdkDrawable* window, GtkWidget* widget, GdkRectangle* background_area, GdkRectangle* cell_area, GdkRectangle* expose_area, GtkCellRendererState flags) {
	// FIXME: add implementation
}

static void
cc_view_cell_renderer_class_init(CcViewCellRendererClass* self_class) {
	GObjectClass        * go_class;
	GtkCellRendererClass* gcr_class;

	/* GObjectClass */
	go_class = G_OBJECT_CLASS(self_class);
	go_class->dispose      = cvcr_dispose;
	go_class->get_property = cvcr_get_property;
	go_class->set_property = cvcr_set_property;

	/* GtkCellRendererClass */
	gcr_class = GTK_CELL_RENDERER_CLASS(self_class);
	gcr_class->get_size = cvcr_get_size;
	gcr_class->render   = cvcr_render;

	/* CcViewIface */
	_cc_view_install_property(go_class, PROP_ROOT, PROP_SCROLLED_REGION, PROP_ZOOM, PROP_ZOOM_MODE, PROP_FOCUS);
}

