#include "uicomponent_impl.h"
#include <gtkmm/messagedialog.h>

UIComponent_impl::UIComponent_impl()
{
  add_verb_handler( SigC::slot(*this, &UIComponent_impl::on_verb_file_new), "FileNew");
  add_verb_handler( SigC::slot(*this, &UIComponent_impl::on_verb_file_open), "FileOpen");
  add_verb_handler( SigC::slot(*this, &UIComponent_impl::on_verb_file_save), "FileSave");
  add_verb_handler( SigC::slot(*this, &UIComponent_impl::on_verb_file_saveas), "FileSaveAs");
  add_verb_handler( SigC::slot(*this, &UIComponent_impl::on_verb_file_close), "FileClose");
  add_verb_handler( SigC::slot(*this, &UIComponent_impl::on_verb_file_exit), "FileExit");

  add_verb_handler( SigC::slot(*this, &UIComponent_impl::on_verb_edit_undo), "EditUndo");
  add_verb_handler( SigC::slot(*this, &UIComponent_impl::on_verb_edit_redo), "EditRedo");

  add_verb_handler( SigC::slot(*this, &UIComponent_impl::on_verb_help_about), "HelpAbout");
}

UIComponent_impl::~UIComponent_impl()
{
}

void UIComponent_impl::on_verb_file_new()
{
  show_nothing_dialog();
}

void UIComponent_impl::on_verb_file_open()
{
  show_nothing_dialog();
}

void UIComponent_impl::on_verb_file_save()
{
  show_nothing_dialog();
}

void UIComponent_impl::on_verb_file_saveas()
{
  show_nothing_dialog();
}

void UIComponent_impl::on_verb_file_close()
{
  //Can't be bothered to do multiple app window management in the C++ version - it's just a distraction.
  on_verb_file_exit();
}

void UIComponent_impl::on_verb_file_exit()
{
	/* FIXME: quit the mainloop nicely */
	exit (0);
}

void UIComponent_impl::on_verb_edit_undo()
{
  show_nothing_dialog();
}

void UIComponent_impl::on_verb_edit_redo()
{
  show_nothing_dialog();
}

void UIComponent_impl::on_verb_help_about()
{
  Gtk::MessageDialog dialog("BonoboUI-Hello.", Gtk::MESSAGE_INFO);
  dialog.run();
}

void UIComponent_impl::show_nothing_dialog()
{
  Gtk::MessageDialog dialog("This does nothing; it is only a demonstration.");
  dialog.run();
}
