/* symbols.c generated by valac 0.36.3, the Vala compiler
 * generated from symbols.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_SYMBOLS_CATEGORY_TYPE (symbols_category_type_get_type ())

#define TYPE_SYMBOLS_CATEGORY_COLUMN (symbols_category_column_get_type ())

#define TYPE_SYMBOL_COLUMN (symbol_column_get_type ())

#define TYPE_SYMBOLS (symbols_get_type ())
#define SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYMBOLS, Symbols))
#define SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYMBOLS, SymbolsClass))
#define IS_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYMBOLS))
#define IS_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYMBOLS))
#define SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYMBOLS, SymbolsClass))

typedef struct _Symbols Symbols;
typedef struct _SymbolsClass SymbolsClass;
typedef struct _SymbolsPrivate SymbolsPrivate;

#define TYPE_NORMAL_SYMBOLS (normal_symbols_get_type ())
#define NORMAL_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NORMAL_SYMBOLS, NormalSymbols))
#define NORMAL_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NORMAL_SYMBOLS, NormalSymbolsClass))
#define IS_NORMAL_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NORMAL_SYMBOLS))
#define IS_NORMAL_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NORMAL_SYMBOLS))
#define NORMAL_SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NORMAL_SYMBOLS, NormalSymbolsClass))

typedef struct _NormalSymbols NormalSymbols;
typedef struct _NormalSymbolsClass NormalSymbolsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SYMBOLS_TYPE_CATEGORY_INFO (symbols_category_info_get_type ())
typedef struct _SymbolsCategoryInfo SymbolsCategoryInfo;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MOST_USED_SYMBOLS (most_used_symbols_get_type ())
#define MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbols))
#define MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))
#define IS_MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOST_USED_SYMBOLS))
#define IS_MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOST_USED_SYMBOLS))
#define MOST_USED_SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))

typedef struct _MostUsedSymbols MostUsedSymbols;
typedef struct _MostUsedSymbolsClass MostUsedSymbolsClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _NormalSymbolsPrivate NormalSymbolsPrivate;

#define NORMAL_SYMBOLS_TYPE_SYMBOL_INFO (normal_symbols_symbol_info_get_type ())
typedef struct _NormalSymbolsSymbolInfo NormalSymbolsSymbolInfo;
#define _normal_symbols_symbol_info_free0(var) ((var == NULL) ? NULL : (var = (normal_symbols_symbol_info_free (var), NULL)))
#define _g_markup_parse_context_unref0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_unref (var), NULL)))

typedef enum  {
	SYMBOLS_CATEGORY_TYPE_NORMAL,
	SYMBOLS_CATEGORY_TYPE_MOST_USED
} SymbolsCategoryType;

typedef enum  {
	SYMBOLS_CATEGORY_COLUMN_TYPE,
	SYMBOLS_CATEGORY_COLUMN_ICON,
	SYMBOLS_CATEGORY_COLUMN_NAME,
	SYMBOLS_CATEGORY_COLUMN_SYMBOLS_STORE,
	SYMBOLS_CATEGORY_COLUMN_N_COLUMNS
} SymbolsCategoryColumn;

typedef enum  {
	SYMBOL_COLUMN_PIXBUF,
	SYMBOL_COLUMN_COMMAND,
	SYMBOL_COLUMN_TOOLTIP,
	SYMBOL_COLUMN_ID,
	SYMBOL_COLUMN_N_COLUMNS
} SymbolColumn;

struct _Symbols {
	GObject parent_instance;
	SymbolsPrivate * priv;
};

struct _SymbolsClass {
	GObjectClass parent_class;
};

struct _SymbolsPrivate {
	GtkListStore* _categories_store;
	GeeMap* _normal_symbols_map;
};

struct _SymbolsCategoryInfo {
	gchar* name;
	gchar* icon;
	gchar* id;
};

struct _NormalSymbols {
	GtkListStore parent_instance;
	NormalSymbolsPrivate * priv;
};

struct _NormalSymbolsClass {
	GtkListStoreClass parent_class;
};

struct _NormalSymbolsSymbolInfo {
	gchar* latex_command;
	gchar* package_required;
};

struct _NormalSymbolsPrivate {
	gchar* _category_id;
	gchar* _resource_path;
	GeeMap* _data;
};


static gpointer symbols_parent_class = NULL;
static Symbols* symbols__instance;
static Symbols* symbols__instance = NULL;
static gpointer normal_symbols_parent_class = NULL;

GType symbols_category_type_get_type (void) G_GNUC_CONST;
GType symbols_category_column_get_type (void) G_GNUC_CONST;
GType symbol_column_get_type (void) G_GNUC_CONST;
GType symbols_get_type (void) G_GNUC_CONST;
GType normal_symbols_get_type (void) G_GNUC_CONST;
#define SYMBOLS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SYMBOLS, SymbolsPrivate))
enum  {
	SYMBOLS_DUMMY_PROPERTY
};
static GType symbols_category_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SymbolsCategoryInfo* symbols_category_info_dup (const SymbolsCategoryInfo* self);
static void symbols_category_info_free (SymbolsCategoryInfo* self);
static void symbols_category_info_copy (const SymbolsCategoryInfo* self, SymbolsCategoryInfo* dest);
static void symbols_category_info_destroy (SymbolsCategoryInfo* self);
static Symbols* symbols_new (void);
static Symbols* symbols_construct (GType object_type);
static void symbols_add_normal_category (Symbols* self, SymbolsCategoryInfo* info);
Symbols* symbols_get_default (void);
static void symbols_add_most_used_category (Symbols* self);
GtkTreeModel* symbols_get_categories_model (Symbols* self);
gboolean symbols_get_symbol_info (Symbols* self, const gchar* id, gchar* * command, gchar* * tooltip);
gboolean normal_symbols_get_symbol_info (NormalSymbols* self, const gchar* icon_file, gchar* * command, gchar* * package);
gchar* symbols_get_tooltip (const gchar* latex_command, const gchar* package_required);
NormalSymbols* normal_symbols_new (const gchar* category_id);
NormalSymbols* normal_symbols_construct (GType object_type, const gchar* category_id);
GType most_used_symbols_get_type (void) G_GNUC_CONST;
MostUsedSymbols* most_used_symbols_get_default (void);
GtkTreeModel* most_used_symbols_get_model (MostUsedSymbols* self);
GdkPixbuf* symbols_get_pixbuf (const gchar* symbol_id);
static void symbols_finalize (GObject * obj);
static GType normal_symbols_symbol_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static NormalSymbolsSymbolInfo* normal_symbols_symbol_info_dup (const NormalSymbolsSymbolInfo* self);
static void normal_symbols_symbol_info_free (NormalSymbolsSymbolInfo* self);
static void normal_symbols_symbol_info_copy (const NormalSymbolsSymbolInfo* self, NormalSymbolsSymbolInfo* dest);
static void normal_symbols_symbol_info_destroy (NormalSymbolsSymbolInfo* self);
#define NORMAL_SYMBOLS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NORMAL_SYMBOLS, NormalSymbolsPrivate))
enum  {
	NORMAL_SYMBOLS_DUMMY_PROPERTY
};
static void normal_symbols_load_symbols (NormalSymbols* self);
const gchar* utils_get_string_from_resource (const gchar* resource_path);
static void normal_symbols_parser_start (NormalSymbols* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error);
static void _normal_symbols_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error);
static void normal_symbols_add_symbol (NormalSymbols* self, const gchar* icon_file, NormalSymbolsSymbolInfo* symbol);
static void normal_symbols_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const SymbolsCategoryInfo SYMBOLS__normal_categories[7] = {{N_ ("Greek"), "symbol_greek", "greek"}, {N_ ("Arrows"), "symbol_arrows", "arrows"}, {N_ ("Relations"), "symbol_relations", "relations"}, {N_ ("Operators"), "symbol_operators", "operators"}, {N_ ("Delimiters"), "symbol_delimiters", "delimiters"}, {N_ ("Misc math"), "symbol_misc_math", "misc-math"}, {N_ ("Misc text"), "symbol_misc_text", "misc-text"}};

GType symbols_category_type_get_type (void) {
	static volatile gsize symbols_category_type_type_id__volatile = 0;
	if (g_once_init_enter (&symbols_category_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SYMBOLS_CATEGORY_TYPE_NORMAL, "SYMBOLS_CATEGORY_TYPE_NORMAL", "normal"}, {SYMBOLS_CATEGORY_TYPE_MOST_USED, "SYMBOLS_CATEGORY_TYPE_MOST_USED", "most-used"}, {0, NULL, NULL}};
		GType symbols_category_type_type_id;
		symbols_category_type_type_id = g_enum_register_static ("SymbolsCategoryType", values);
		g_once_init_leave (&symbols_category_type_type_id__volatile, symbols_category_type_type_id);
	}
	return symbols_category_type_type_id__volatile;
}


GType symbols_category_column_get_type (void) {
	static volatile gsize symbols_category_column_type_id__volatile = 0;
	if (g_once_init_enter (&symbols_category_column_type_id__volatile)) {
		static const GEnumValue values[] = {{SYMBOLS_CATEGORY_COLUMN_TYPE, "SYMBOLS_CATEGORY_COLUMN_TYPE", "type"}, {SYMBOLS_CATEGORY_COLUMN_ICON, "SYMBOLS_CATEGORY_COLUMN_ICON", "icon"}, {SYMBOLS_CATEGORY_COLUMN_NAME, "SYMBOLS_CATEGORY_COLUMN_NAME", "name"}, {SYMBOLS_CATEGORY_COLUMN_SYMBOLS_STORE, "SYMBOLS_CATEGORY_COLUMN_SYMBOLS_STORE", "symbols-store"}, {SYMBOLS_CATEGORY_COLUMN_N_COLUMNS, "SYMBOLS_CATEGORY_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType symbols_category_column_type_id;
		symbols_category_column_type_id = g_enum_register_static ("SymbolsCategoryColumn", values);
		g_once_init_leave (&symbols_category_column_type_id__volatile, symbols_category_column_type_id);
	}
	return symbols_category_column_type_id__volatile;
}


GType symbol_column_get_type (void) {
	static volatile gsize symbol_column_type_id__volatile = 0;
	if (g_once_init_enter (&symbol_column_type_id__volatile)) {
		static const GEnumValue values[] = {{SYMBOL_COLUMN_PIXBUF, "SYMBOL_COLUMN_PIXBUF", "pixbuf"}, {SYMBOL_COLUMN_COMMAND, "SYMBOL_COLUMN_COMMAND", "command"}, {SYMBOL_COLUMN_TOOLTIP, "SYMBOL_COLUMN_TOOLTIP", "tooltip"}, {SYMBOL_COLUMN_ID, "SYMBOL_COLUMN_ID", "id"}, {SYMBOL_COLUMN_N_COLUMNS, "SYMBOL_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType symbol_column_type_id;
		symbol_column_type_id = g_enum_register_static ("SymbolColumn", values);
		g_once_init_leave (&symbol_column_type_id__volatile, symbol_column_type_id);
	}
	return symbol_column_type_id__volatile;
}


static Symbols* symbols_construct (GType object_type) {
	Symbols * self = NULL;
	GtkListStore* _tmp0_;
	GeeHashMap* _tmp1_;
	self = (Symbols*) g_object_new (object_type, NULL);
	_tmp0_ = gtk_list_store_new ((gint) SYMBOLS_CATEGORY_COLUMN_N_COLUMNS, TYPE_SYMBOLS_CATEGORY_TYPE, G_TYPE_STRING, G_TYPE_STRING, GTK_TYPE_TREE_MODEL, -1);
	_g_object_unref0 (self->priv->_categories_store);
	self->priv->_categories_store = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_NORMAL_SYMBOLS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_normal_symbols_map);
	self->priv->_normal_symbols_map = (GeeMap*) _tmp1_;
	{
		SymbolsCategoryInfo* info_collection = NULL;
		gint info_collection_length1 = 0;
		gint _info_collection_size_ = 0;
		gint info_it = 0;
		info_collection = SYMBOLS__normal_categories;
		info_collection_length1 = G_N_ELEMENTS (SYMBOLS__normal_categories);
		for (info_it = 0; info_it < G_N_ELEMENTS (SYMBOLS__normal_categories); info_it = info_it + 1) {
			SymbolsCategoryInfo _tmp2_ = {0};
			SymbolsCategoryInfo info = {0};
			symbols_category_info_copy (&info_collection[info_it], &_tmp2_);
			info = _tmp2_;
			{
				SymbolsCategoryInfo _tmp3_;
				_tmp3_ = info;
				symbols_add_normal_category (self, &_tmp3_);
				symbols_category_info_destroy (&info);
			}
		}
	}
	return self;
}


static Symbols* symbols_new (void) {
	return symbols_construct (TYPE_SYMBOLS);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Symbols* symbols_get_default (void) {
	Symbols* result = NULL;
	Symbols* _tmp0_;
	Symbols* _tmp3_;
	Symbols* _tmp4_;
	_tmp0_ = symbols__instance;
	if (_tmp0_ == NULL) {
		Symbols* _tmp1_;
		Symbols* _tmp2_;
		_tmp1_ = symbols_new ();
		_g_object_unref0 (symbols__instance);
		symbols__instance = _tmp1_;
		_tmp2_ = symbols__instance;
		symbols_add_most_used_category (_tmp2_);
	}
	_tmp3_ = symbols__instance;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	result = _tmp4_;
	return result;
}


GtkTreeModel* symbols_get_categories_model (Symbols* self) {
	GtkTreeModel* result = NULL;
	GtkListStore* _tmp0_;
	GtkTreeModel* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_categories_store;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GTK_TYPE_TREE_MODEL) ? ((GtkTreeModel*) _tmp0_) : NULL);
	result = _tmp1_;
	return result;
}


gboolean symbols_get_symbol_info (Symbols* self, const gchar* id, gchar* * command, gchar* * tooltip) {
	gchar* _vala_command = NULL;
	gchar* _vala_tooltip = NULL;
	gboolean result = FALSE;
	gchar** id_components = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint id_components_length1;
	gint _id_components_size_;
	gchar* category_id = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* icon_file = NULL;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GeeMap* _tmp7_;
	gboolean _tmp8_;
	NormalSymbols* normal_symbols = NULL;
	GeeMap* _tmp9_;
	gpointer _tmp10_;
	gchar* package = NULL;
	gboolean ok = FALSE;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gboolean _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (id != NULL, FALSE);
	_g_free0 (_vala_command);
	_vala_command = NULL;
	_g_free0 (_vala_tooltip);
	_vala_tooltip = NULL;
	_tmp0_ = id;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, "/", 0);
	id_components = _tmp2_;
	id_components_length1 = _vala_array_length (_tmp1_);
	_id_components_size_ = id_components_length1;
	g_return_val_if_fail (id_components_length1 == 2, FALSE);
	_tmp3_ = id_components[0];
	_tmp4_ = g_strdup (_tmp3_);
	category_id = _tmp4_;
	_tmp5_ = id_components[1];
	_tmp6_ = g_strdup (_tmp5_);
	icon_file = _tmp6_;
	_tmp7_ = self->priv->_normal_symbols_map;
	_tmp8_ = gee_map_has_key (_tmp7_, category_id);
	g_return_val_if_fail (_tmp8_, FALSE);
	_tmp9_ = self->priv->_normal_symbols_map;
	_tmp10_ = gee_map_get (_tmp9_, category_id);
	normal_symbols = (NormalSymbols*) _tmp10_;
	package = NULL;
	_tmp13_ = normal_symbols_get_symbol_info (normal_symbols, icon_file, &_tmp11_, &_tmp12_);
	_g_free0 (_vala_command);
	_vala_command = _tmp11_;
	_g_free0 (package);
	package = _tmp12_;
	ok = _tmp13_;
	g_return_val_if_fail (ok, FALSE);
	_tmp14_ = _vala_command;
	_tmp15_ = package;
	_tmp16_ = symbols_get_tooltip (_tmp14_, _tmp15_);
	_g_free0 (_vala_tooltip);
	_vala_tooltip = _tmp16_;
	result = TRUE;
	_g_free0 (package);
	_g_object_unref0 (normal_symbols);
	_g_free0 (icon_file);
	_g_free0 (category_id);
	id_components = (_vala_array_free (id_components, id_components_length1, (GDestroyNotify) g_free), NULL);
	if (command) {
		*command = _vala_command;
	} else {
		_g_free0 (_vala_command);
	}
	if (tooltip) {
		*tooltip = _vala_tooltip;
	} else {
		_g_free0 (_vala_tooltip);
	}
	return result;
}


static void symbols_add_normal_category (Symbols* self, SymbolsCategoryInfo* info) {
	GtkListStore* store = NULL;
	SymbolsCategoryInfo _tmp0_;
	const gchar* _tmp1_;
	NormalSymbols* _tmp2_;
	GeeMap* _tmp3_;
	SymbolsCategoryInfo _tmp4_;
	const gchar* _tmp5_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp6_;
	GtkTreeIter _tmp7_ = {0};
	GtkListStore* _tmp8_;
	GtkTreeIter _tmp9_;
	SymbolsCategoryInfo _tmp10_;
	const gchar* _tmp11_;
	SymbolsCategoryInfo _tmp12_;
	const gchar* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = *info;
	_tmp1_ = _tmp0_.id;
	_tmp2_ = normal_symbols_new (_tmp1_);
	store = (GtkListStore*) _tmp2_;
	_tmp3_ = self->priv->_normal_symbols_map;
	_tmp4_ = *info;
	_tmp5_ = _tmp4_.id;
	gee_map_set (_tmp3_, _tmp5_, G_TYPE_CHECK_INSTANCE_TYPE (store, TYPE_NORMAL_SYMBOLS) ? ((NormalSymbols*) store) : NULL);
	_tmp6_ = self->priv->_categories_store;
	gtk_list_store_append (_tmp6_, &_tmp7_);
	iter = _tmp7_;
	_tmp8_ = self->priv->_categories_store;
	_tmp9_ = iter;
	_tmp10_ = *info;
	_tmp11_ = _tmp10_.icon;
	_tmp12_ = *info;
	_tmp13_ = _tmp12_.name;
	gtk_list_store_set (_tmp8_, &_tmp9_, SYMBOLS_CATEGORY_COLUMN_TYPE, SYMBOLS_CATEGORY_TYPE_NORMAL, SYMBOLS_CATEGORY_COLUMN_ICON, _tmp11_, SYMBOLS_CATEGORY_COLUMN_NAME, _ (_tmp13_), SYMBOLS_CATEGORY_COLUMN_SYMBOLS_STORE, store, -1);
	_g_object_unref0 (store);
}


static void symbols_add_most_used_category (Symbols* self) {
	GtkTreeModel* model = NULL;
	MostUsedSymbols* _tmp0_;
	MostUsedSymbols* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp4_;
	GtkTreeIter _tmp5_ = {0};
	GtkListStore* _tmp6_;
	GtkTreeIter _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = most_used_symbols_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = most_used_symbols_get_model (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	model = _tmp3_;
	_tmp4_ = self->priv->_categories_store;
	gtk_list_store_append (_tmp4_, &_tmp5_);
	iter = _tmp5_;
	_tmp6_ = self->priv->_categories_store;
	_tmp7_ = iter;
	gtk_list_store_set (_tmp6_, &_tmp7_, SYMBOLS_CATEGORY_COLUMN_TYPE, SYMBOLS_CATEGORY_TYPE_MOST_USED, SYMBOLS_CATEGORY_COLUMN_ICON, "help-about", SYMBOLS_CATEGORY_COLUMN_NAME, _ ("Most Used"), SYMBOLS_CATEGORY_COLUMN_SYMBOLS_STORE, model, -1);
	_g_object_unref0 (model);
}


gchar* symbols_get_tooltip (const gchar* latex_command, const gchar* package_required) {
	gchar* result = NULL;
	gchar* tooltip = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (latex_command != NULL, NULL);
	_tmp0_ = latex_command;
	_tmp1_ = g_markup_escape_text (_tmp0_, (gssize) -1);
	tooltip = _tmp1_;
	_tmp2_ = package_required;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp3_ = tooltip;
		_tmp4_ = package_required;
		_tmp5_ = g_strdup_printf (" (package %s)", _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat (_tmp3_, _tmp6_, NULL);
		_g_free0 (tooltip);
		tooltip = _tmp7_;
		_g_free0 (_tmp6_);
	}
	result = tooltip;
	return result;
}


GdkPixbuf* symbols_get_pixbuf (const gchar* symbol_id) {
	GdkPixbuf* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (symbol_id != NULL, NULL);
	{
		GdkPixbuf* _tmp0_ = NULL;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp6_;
		_tmp1_ = symbol_id;
		_tmp2_ = g_strconcat ("/org/gnome/latexila/symbols/", _tmp1_, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = gdk_pixbuf_new_from_resource (_tmp3_, &_inner_error_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_tmp0_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch47_g_error;
		}
		_tmp6_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp6_;
		_g_object_unref0 (_tmp0_);
		return result;
	}
	goto __finally47;
	__catch47_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = symbol_id;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("symbols.vala:185: Impossible to load the symbol '%s': %s", _tmp7_, _tmp9_);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally47:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static void symbols_category_info_copy (const SymbolsCategoryInfo* self, SymbolsCategoryInfo* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).icon;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).icon);
	(*dest).icon = _tmp3_;
	_tmp4_ = (*self).id;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).id);
	(*dest).id = _tmp5_;
}


static void symbols_category_info_destroy (SymbolsCategoryInfo* self) {
	_g_free0 ((*self).name);
	_g_free0 ((*self).icon);
	_g_free0 ((*self).id);
}


static SymbolsCategoryInfo* symbols_category_info_dup (const SymbolsCategoryInfo* self) {
	SymbolsCategoryInfo* dup;
	dup = g_new0 (SymbolsCategoryInfo, 1);
	symbols_category_info_copy (self, dup);
	return dup;
}


static void symbols_category_info_free (SymbolsCategoryInfo* self) {
	symbols_category_info_destroy (self);
	g_free (self);
}


static GType symbols_category_info_get_type (void) {
	static volatile gsize symbols_category_info_type_id__volatile = 0;
	if (g_once_init_enter (&symbols_category_info_type_id__volatile)) {
		GType symbols_category_info_type_id;
		symbols_category_info_type_id = g_boxed_type_register_static ("SymbolsCategoryInfo", (GBoxedCopyFunc) symbols_category_info_dup, (GBoxedFreeFunc) symbols_category_info_free);
		g_once_init_leave (&symbols_category_info_type_id__volatile, symbols_category_info_type_id);
	}
	return symbols_category_info_type_id__volatile;
}


static void symbols_class_init (SymbolsClass * klass) {
	symbols_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SymbolsPrivate));
	G_OBJECT_CLASS (klass)->finalize = symbols_finalize;
}


static void symbols_instance_init (Symbols * self) {
	self->priv = SYMBOLS_GET_PRIVATE (self);
}


static void symbols_finalize (GObject * obj) {
	Symbols * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SYMBOLS, Symbols);
	_g_object_unref0 (self->priv->_categories_store);
	_g_object_unref0 (self->priv->_normal_symbols_map);
	G_OBJECT_CLASS (symbols_parent_class)->finalize (obj);
}


GType symbols_get_type (void) {
	static volatile gsize symbols_type_id__volatile = 0;
	if (g_once_init_enter (&symbols_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SymbolsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) symbols_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Symbols), 0, (GInstanceInitFunc) symbols_instance_init, NULL };
		GType symbols_type_id;
		symbols_type_id = g_type_register_static (G_TYPE_OBJECT, "Symbols", &g_define_type_info, 0);
		g_once_init_leave (&symbols_type_id__volatile, symbols_type_id);
	}
	return symbols_type_id__volatile;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


NormalSymbols* normal_symbols_construct (GType object_type, const gchar* category_id) {
	NormalSymbols * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GeeHashMap* _tmp5_;
	GType* column_types = NULL;
	GType* _tmp6_;
	gint column_types_length1;
	gint _column_types_size_;
	g_return_val_if_fail (category_id != NULL, NULL);
	self = (NormalSymbols*) g_object_new (object_type, NULL);
	_tmp0_ = category_id;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_category_id);
	self->priv->_category_id = _tmp1_;
	_tmp2_ = category_id;
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = g_strconcat ("/org/gnome/latexila/symbols/", _tmp3_, "/", NULL);
	_g_free0 (self->priv->_resource_path);
	self->priv->_resource_path = _tmp4_;
	_tmp5_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NORMAL_SYMBOLS_TYPE_SYMBOL_INFO, (GBoxedCopyFunc) normal_symbols_symbol_info_dup, (GDestroyNotify) normal_symbols_symbol_info_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_data);
	self->priv->_data = (GeeMap*) _tmp5_;
	_tmp6_ = g_new0 (GType, 4);
	_tmp6_[0] = gdk_pixbuf_get_type ();
	_tmp6_[1] = G_TYPE_STRING;
	_tmp6_[2] = G_TYPE_STRING;
	_tmp6_[3] = G_TYPE_STRING;
	column_types = _tmp6_;
	column_types_length1 = 4;
	_column_types_size_ = column_types_length1;
	gtk_list_store_set_column_types ((GtkListStore*) self, column_types_length1, column_types);
	normal_symbols_load_symbols (self);
	column_types = (g_free (column_types), NULL);
	return self;
}


NormalSymbols* normal_symbols_new (const gchar* category_id) {
	return normal_symbols_construct (TYPE_NORMAL_SYMBOLS, category_id);
}


gboolean normal_symbols_get_symbol_info (NormalSymbols* self, const gchar* icon_file, gchar* * command, gchar* * package) {
	gchar* _vala_command = NULL;
	gchar* _vala_package = NULL;
	gboolean result = FALSE;
	GeeMap* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	NormalSymbolsSymbolInfo info = {0};
	GeeMap* _tmp3_;
	const gchar* _tmp4_;
	gpointer _tmp5_;
	NormalSymbolsSymbolInfo* _tmp6_;
	NormalSymbolsSymbolInfo _tmp7_ = {0};
	NormalSymbolsSymbolInfo _tmp8_;
	NormalSymbolsSymbolInfo _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	NormalSymbolsSymbolInfo _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (icon_file != NULL, FALSE);
	_g_free0 (_vala_command);
	_vala_command = NULL;
	_g_free0 (_vala_package);
	_vala_package = NULL;
	_tmp0_ = self->priv->_data;
	_tmp1_ = icon_file;
	_tmp2_ = gee_map_has_key (_tmp0_, _tmp1_);
	if (!_tmp2_) {
		result = FALSE;
		if (command) {
			*command = _vala_command;
		} else {
			_g_free0 (_vala_command);
		}
		if (package) {
			*package = _vala_package;
		} else {
			_g_free0 (_vala_package);
		}
		return result;
	}
	_tmp3_ = self->priv->_data;
	_tmp4_ = icon_file;
	_tmp5_ = gee_map_get (_tmp3_, _tmp4_);
	_tmp6_ = (NormalSymbolsSymbolInfo*) _tmp5_;
	normal_symbols_symbol_info_copy (_tmp6_, &_tmp7_);
	_tmp8_ = _tmp7_;
	_normal_symbols_symbol_info_free0 (_tmp6_);
	info = _tmp8_;
	_tmp9_ = info;
	_tmp10_ = _tmp9_.latex_command;
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (_vala_command);
	_vala_command = _tmp11_;
	_tmp12_ = info;
	_tmp13_ = _tmp12_.package_required;
	_tmp14_ = g_strdup (_tmp13_);
	_g_free0 (_vala_package);
	_vala_package = _tmp14_;
	result = TRUE;
	normal_symbols_symbol_info_destroy (&info);
	if (command) {
		*command = _vala_command;
	} else {
		_g_free0 (_vala_command);
	}
	if (package) {
		*package = _vala_package;
	} else {
		_g_free0 (_vala_package);
	}
	return result;
}


static void _normal_symbols_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error) {
	normal_symbols_parser_start ((NormalSymbols*) self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
}


static void normal_symbols_load_symbols (NormalSymbols* self) {
	const gchar* contents = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_resource_path;
	_tmp1_ = g_strconcat (_tmp0_, "data.xml", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = utils_get_string_from_resource (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	contents = _tmp4_;
	_tmp5_ = contents;
	if (_tmp5_ == NULL) {
		return;
	}
	{
		GMarkupParser parser = {0};
		GMarkupParser _tmp6_ = {0};
		GMarkupParseContext* context = NULL;
		GMarkupParser _tmp7_;
		GMarkupParseContext* _tmp8_;
		GMarkupParseContext* _tmp9_;
		const gchar* _tmp10_;
		_tmp6_.start_element = _normal_symbols_parser_start_gmarkup_parser_start_element_func;
		_tmp6_.end_element = NULL;
		_tmp6_.text = NULL;
		_tmp6_.passthrough = NULL;
		_tmp6_.error = NULL;
		parser = _tmp6_;
		_tmp7_ = parser;
		_tmp8_ = g_markup_parse_context_new (&_tmp7_, 0, self, NULL);
		context = _tmp8_;
		_tmp9_ = context;
		_tmp10_ = contents;
		g_markup_parse_context_parse (_tmp9_, _tmp10_, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_markup_parse_context_unref0 (context);
			goto __catch48_g_error;
		}
		_g_markup_parse_context_unref0 (context);
	}
	goto __finally48;
	__catch48_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("symbols.vala:255: Impossible to load the symbols: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally48:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void normal_symbols_add_symbol (NormalSymbols* self, const gchar* icon_file, NormalSymbolsSymbolInfo* symbol) {
	GeeMap* _tmp0_;
	const gchar* _tmp1_;
	NormalSymbolsSymbolInfo _tmp2_;
	gchar* tooltip = NULL;
	NormalSymbolsSymbolInfo _tmp3_;
	const gchar* _tmp4_;
	NormalSymbolsSymbolInfo _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* id = NULL;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	GdkPixbuf* pixbuf = NULL;
	const gchar* _tmp11_;
	GdkPixbuf* _tmp12_;
	GdkPixbuf* _tmp13_;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp14_ = {0};
	GtkTreeIter _tmp15_;
	GdkPixbuf* _tmp16_;
	NormalSymbolsSymbolInfo _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_file != NULL);
	g_return_if_fail (symbol != NULL);
	_tmp0_ = self->priv->_data;
	_tmp1_ = icon_file;
	_tmp2_ = *symbol;
	gee_map_set (_tmp0_, _tmp1_, &_tmp2_);
	_tmp3_ = *symbol;
	_tmp4_ = _tmp3_.latex_command;
	_tmp5_ = *symbol;
	_tmp6_ = _tmp5_.package_required;
	_tmp7_ = symbols_get_tooltip (_tmp4_, _tmp6_);
	tooltip = _tmp7_;
	_tmp8_ = self->priv->_category_id;
	_tmp9_ = icon_file;
	_tmp10_ = g_strdup_printf ("%s/%s", _tmp8_, _tmp9_);
	id = _tmp10_;
	_tmp11_ = id;
	_tmp12_ = symbols_get_pixbuf (_tmp11_);
	pixbuf = _tmp12_;
	_tmp13_ = pixbuf;
	if (_tmp13_ == NULL) {
		_g_object_unref0 (pixbuf);
		_g_free0 (id);
		_g_free0 (tooltip);
		return;
	}
	gtk_list_store_append ((GtkListStore*) self, &_tmp14_);
	iter = _tmp14_;
	_tmp15_ = iter;
	_tmp16_ = pixbuf;
	_tmp17_ = *symbol;
	_tmp18_ = _tmp17_.latex_command;
	_tmp19_ = tooltip;
	_tmp20_ = id;
	gtk_list_store_set ((GtkListStore*) self, &_tmp15_, SYMBOL_COLUMN_PIXBUF, _tmp16_, SYMBOL_COLUMN_COMMAND, _tmp18_, SYMBOL_COLUMN_TOOLTIP, _tmp19_, SYMBOL_COLUMN_ID, _tmp20_, -1);
	_g_object_unref0 (pixbuf);
	_g_free0 (id);
	_g_free0 (tooltip);
}


static void normal_symbols_parser_start (NormalSymbols* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("symbols")))) {
		switch (0) {
			default:
			{
				return;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("symbol")))) {
		switch (0) {
			default:
			{
				NormalSymbolsSymbolInfo symbol = {0};
				gchar* icon_file = NULL;
				const gchar* _tmp35_;
				NormalSymbolsSymbolInfo _tmp36_;
				memset (&symbol, 0, sizeof (NormalSymbolsSymbolInfo));
				_g_free0 (symbol.package_required);
				symbol.package_required = NULL;
				icon_file = NULL;
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint _tmp6_;
							gchar** _tmp7_;
							gint _tmp7__length1;
							gchar** _tmp8_;
							gint _tmp8__length1;
							gint _tmp9_;
							const gchar* _tmp10_;
							const gchar* _tmp11_;
							GQuark _tmp13_ = 0U;
							static GQuark _tmp12_label0 = 0;
							static GQuark _tmp12_label1 = 0;
							static GQuark _tmp12_label2 = 0;
							if (!_tmp4_) {
								gint _tmp5_;
								_tmp5_ = i;
								i = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = i;
							_tmp7_ = attr_names;
							_tmp7__length1 = attr_names_length1;
							if (!(_tmp6_ < _tmp7__length1)) {
								break;
							}
							_tmp8_ = attr_names;
							_tmp8__length1 = attr_names_length1;
							_tmp9_ = i;
							_tmp10_ = _tmp8_[_tmp9_];
							_tmp11_ = _tmp10_;
							_tmp13_ = (NULL == _tmp11_) ? 0 : g_quark_from_string (_tmp11_);
							if (_tmp13_ == ((0 != _tmp12_label0) ? _tmp12_label0 : (_tmp12_label0 = g_quark_from_static_string ("file")))) {
								switch (0) {
									default:
									{
										gchar** _tmp14_;
										gint _tmp14__length1;
										gint _tmp15_;
										const gchar* _tmp16_;
										gchar* _tmp17_;
										_tmp14_ = attr_values;
										_tmp14__length1 = attr_values_length1;
										_tmp15_ = i;
										_tmp16_ = _tmp14_[_tmp15_];
										_tmp17_ = g_strdup (_tmp16_);
										_g_free0 (icon_file);
										icon_file = _tmp17_;
										break;
									}
								}
							} else if (_tmp13_ == ((0 != _tmp12_label1) ? _tmp12_label1 : (_tmp12_label1 = g_quark_from_static_string ("command")))) {
								switch (0) {
									default:
									{
										gchar** _tmp18_;
										gint _tmp18__length1;
										gint _tmp19_;
										const gchar* _tmp20_;
										gchar* _tmp21_;
										_tmp18_ = attr_values;
										_tmp18__length1 = attr_values_length1;
										_tmp19_ = i;
										_tmp20_ = _tmp18_[_tmp19_];
										_tmp21_ = g_strdup (_tmp20_);
										_g_free0 (symbol.latex_command);
										symbol.latex_command = _tmp21_;
										break;
									}
								}
							} else if (_tmp13_ == ((0 != _tmp12_label2) ? _tmp12_label2 : (_tmp12_label2 = g_quark_from_static_string ("package")))) {
								switch (0) {
									default:
									{
										gchar** _tmp22_;
										gint _tmp22__length1;
										gint _tmp23_;
										const gchar* _tmp24_;
										gchar* _tmp25_;
										_tmp22_ = attr_values;
										_tmp22__length1 = attr_values_length1;
										_tmp23_ = i;
										_tmp24_ = _tmp22_[_tmp23_];
										_tmp25_ = g_strdup (_tmp24_);
										_g_free0 (symbol.package_required);
										symbol.package_required = _tmp25_;
										break;
									}
								}
							} else {
								switch (0) {
									default:
									{
										gchar** _tmp26_;
										gint _tmp26__length1;
										gint _tmp27_;
										const gchar* _tmp28_;
										gchar* _tmp29_;
										gchar* _tmp30_;
										gchar* _tmp31_;
										gchar* _tmp32_;
										GError* _tmp33_;
										GError* _tmp34_;
										_tmp26_ = attr_names;
										_tmp26__length1 = attr_names_length1;
										_tmp27_ = i;
										_tmp28_ = _tmp26_[_tmp27_];
										_tmp29_ = g_strconcat ("unknown attribute \"", _tmp28_, NULL);
										_tmp30_ = _tmp29_;
										_tmp31_ = g_strconcat (_tmp30_, "\"", NULL);
										_tmp32_ = _tmp31_;
										_tmp33_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp32_);
										_tmp34_ = _tmp33_;
										_g_free0 (_tmp32_);
										_g_free0 (_tmp30_);
										_inner_error_ = _tmp34_;
										if (_inner_error_->domain == G_MARKUP_ERROR) {
											g_propagate_error (error, _inner_error_);
											_g_free0 (icon_file);
											normal_symbols_symbol_info_destroy (&symbol);
											return;
										} else {
											_g_free0 (icon_file);
											normal_symbols_symbol_info_destroy (&symbol);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
									}
								}
							}
						}
					}
				}
				_tmp35_ = icon_file;
				_tmp36_ = symbol;
				normal_symbols_add_symbol (self, _tmp35_, &_tmp36_);
				_g_free0 (icon_file);
				normal_symbols_symbol_info_destroy (&symbol);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				GError* _tmp42_;
				GError* _tmp43_;
				_tmp37_ = name;
				_tmp38_ = g_strconcat ("unknown element \"", _tmp37_, NULL);
				_tmp39_ = _tmp38_;
				_tmp40_ = g_strconcat (_tmp39_, "\"", NULL);
				_tmp41_ = _tmp40_;
				_tmp42_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp41_);
				_tmp43_ = _tmp42_;
				_g_free0 (_tmp41_);
				_g_free0 (_tmp39_);
				_inner_error_ = _tmp43_;
				if (_inner_error_->domain == G_MARKUP_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static void normal_symbols_symbol_info_copy (const NormalSymbolsSymbolInfo* self, NormalSymbolsSymbolInfo* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).latex_command;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).latex_command);
	(*dest).latex_command = _tmp1_;
	_tmp2_ = (*self).package_required;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).package_required);
	(*dest).package_required = _tmp3_;
}


static void normal_symbols_symbol_info_destroy (NormalSymbolsSymbolInfo* self) {
	_g_free0 ((*self).latex_command);
	_g_free0 ((*self).package_required);
}


static NormalSymbolsSymbolInfo* normal_symbols_symbol_info_dup (const NormalSymbolsSymbolInfo* self) {
	NormalSymbolsSymbolInfo* dup;
	dup = g_new0 (NormalSymbolsSymbolInfo, 1);
	normal_symbols_symbol_info_copy (self, dup);
	return dup;
}


static void normal_symbols_symbol_info_free (NormalSymbolsSymbolInfo* self) {
	normal_symbols_symbol_info_destroy (self);
	g_free (self);
}


static GType normal_symbols_symbol_info_get_type (void) {
	static volatile gsize normal_symbols_symbol_info_type_id__volatile = 0;
	if (g_once_init_enter (&normal_symbols_symbol_info_type_id__volatile)) {
		GType normal_symbols_symbol_info_type_id;
		normal_symbols_symbol_info_type_id = g_boxed_type_register_static ("NormalSymbolsSymbolInfo", (GBoxedCopyFunc) normal_symbols_symbol_info_dup, (GBoxedFreeFunc) normal_symbols_symbol_info_free);
		g_once_init_leave (&normal_symbols_symbol_info_type_id__volatile, normal_symbols_symbol_info_type_id);
	}
	return normal_symbols_symbol_info_type_id__volatile;
}


static void normal_symbols_class_init (NormalSymbolsClass * klass) {
	normal_symbols_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NormalSymbolsPrivate));
	G_OBJECT_CLASS (klass)->finalize = normal_symbols_finalize;
}


static void normal_symbols_instance_init (NormalSymbols * self) {
	self->priv = NORMAL_SYMBOLS_GET_PRIVATE (self);
}


static void normal_symbols_finalize (GObject * obj) {
	NormalSymbols * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NORMAL_SYMBOLS, NormalSymbols);
	_g_free0 (self->priv->_category_id);
	_g_free0 (self->priv->_resource_path);
	_g_object_unref0 (self->priv->_data);
	G_OBJECT_CLASS (normal_symbols_parent_class)->finalize (obj);
}


GType normal_symbols_get_type (void) {
	static volatile gsize normal_symbols_type_id__volatile = 0;
	if (g_once_init_enter (&normal_symbols_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NormalSymbolsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) normal_symbols_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NormalSymbols), 0, (GInstanceInitFunc) normal_symbols_instance_init, NULL };
		GType normal_symbols_type_id;
		normal_symbols_type_id = g_type_register_static (gtk_list_store_get_type (), "NormalSymbols", &g_define_type_info, 0);
		g_once_init_leave (&normal_symbols_type_id__volatile, normal_symbols_type_id);
	}
	return normal_symbols_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



