/* main_window.c generated by valac 0.36.3, the Vala compiler
 * generated from main_window.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2015 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include "config.h"
#include <latexila.h>
#include <gio/gio.h>
#include <gee.h>
#include <gtef/gtef.h>
#include <gtksourceview/gtksource.h>


#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_DOCUMENTS_PANEL (documents_panel_get_type ())
#define DOCUMENTS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENTS_PANEL, DocumentsPanel))
#define DOCUMENTS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENTS_PANEL, DocumentsPanelClass))
#define IS_DOCUMENTS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENTS_PANEL))
#define IS_DOCUMENTS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENTS_PANEL))
#define DOCUMENTS_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENTS_PANEL, DocumentsPanelClass))

typedef struct _DocumentsPanel DocumentsPanel;
typedef struct _DocumentsPanelClass DocumentsPanelClass;

#define TYPE_CUSTOM_STATUSBAR (custom_statusbar_get_type ())
#define CUSTOM_STATUSBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CUSTOM_STATUSBAR, CustomStatusbar))
#define CUSTOM_STATUSBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CUSTOM_STATUSBAR, CustomStatusbarClass))
#define IS_CUSTOM_STATUSBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CUSTOM_STATUSBAR))
#define IS_CUSTOM_STATUSBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CUSTOM_STATUSBAR))
#define CUSTOM_STATUSBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CUSTOM_STATUSBAR, CustomStatusbarClass))

typedef struct _CustomStatusbar CustomStatusbar;
typedef struct _CustomStatusbarClass CustomStatusbarClass;

#define TYPE_GOTO_LINE (goto_line_get_type ())
#define GOTO_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GOTO_LINE, GotoLine))
#define GOTO_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GOTO_LINE, GotoLineClass))
#define IS_GOTO_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GOTO_LINE))
#define IS_GOTO_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GOTO_LINE))
#define GOTO_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GOTO_LINE, GotoLineClass))

typedef struct _GotoLine GotoLine;
typedef struct _GotoLineClass GotoLineClass;

#define TYPE_SEARCH_AND_REPLACE (search_and_replace_get_type ())
#define SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplace))
#define SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))
#define IS_SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_AND_REPLACE))
#define IS_SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_AND_REPLACE))
#define SEARCH_AND_REPLACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))

typedef struct _SearchAndReplace SearchAndReplace;
typedef struct _SearchAndReplaceClass SearchAndReplaceClass;

#define TYPE_MAIN_WINDOW_FILE (main_window_file_get_type ())
#define MAIN_WINDOW_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_FILE, MainWindowFile))
#define MAIN_WINDOW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_FILE, MainWindowFileClass))
#define IS_MAIN_WINDOW_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_FILE))
#define IS_MAIN_WINDOW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_FILE))
#define MAIN_WINDOW_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_FILE, MainWindowFileClass))

typedef struct _MainWindowFile MainWindowFile;
typedef struct _MainWindowFileClass MainWindowFileClass;

#define TYPE_MAIN_WINDOW_EDIT (main_window_edit_get_type ())
#define MAIN_WINDOW_EDIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_EDIT, MainWindowEdit))
#define MAIN_WINDOW_EDIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_EDIT, MainWindowEditClass))
#define IS_MAIN_WINDOW_EDIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_EDIT))
#define IS_MAIN_WINDOW_EDIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_EDIT))
#define MAIN_WINDOW_EDIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_EDIT, MainWindowEditClass))

typedef struct _MainWindowEdit MainWindowEdit;
typedef struct _MainWindowEditClass MainWindowEditClass;

#define TYPE_MAIN_WINDOW_BUILD_TOOLS (main_window_build_tools_get_type ())
#define MAIN_WINDOW_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildTools))
#define MAIN_WINDOW_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildToolsClass))
#define IS_MAIN_WINDOW_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS))
#define IS_MAIN_WINDOW_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_BUILD_TOOLS))
#define MAIN_WINDOW_BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildToolsClass))

typedef struct _MainWindowBuildTools MainWindowBuildTools;
typedef struct _MainWindowBuildToolsClass MainWindowBuildToolsClass;

#define TYPE_MAIN_WINDOW_STRUCTURE (main_window_structure_get_type ())
#define MAIN_WINDOW_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructure))
#define MAIN_WINDOW_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructureClass))
#define IS_MAIN_WINDOW_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_STRUCTURE))
#define IS_MAIN_WINDOW_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_STRUCTURE))
#define MAIN_WINDOW_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructureClass))

typedef struct _MainWindowStructure MainWindowStructure;
typedef struct _MainWindowStructureClass MainWindowStructureClass;

#define TYPE_MAIN_WINDOW_DOCUMENTS (main_window_documents_get_type ())
#define MAIN_WINDOW_DOCUMENTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocuments))
#define MAIN_WINDOW_DOCUMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocumentsClass))
#define IS_MAIN_WINDOW_DOCUMENTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_DOCUMENTS))
#define IS_MAIN_WINDOW_DOCUMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_DOCUMENTS))
#define MAIN_WINDOW_DOCUMENTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocumentsClass))

typedef struct _MainWindowDocuments MainWindowDocuments;
typedef struct _MainWindowDocumentsClass MainWindowDocumentsClass;

#define TYPE_MAIN_WINDOW_TOOLS (main_window_tools_get_type ())
#define MAIN_WINDOW_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_TOOLS, MainWindowTools))
#define MAIN_WINDOW_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_TOOLS, MainWindowToolsClass))
#define IS_MAIN_WINDOW_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_TOOLS))
#define IS_MAIN_WINDOW_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_TOOLS))
#define MAIN_WINDOW_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_TOOLS, MainWindowToolsClass))

typedef struct _MainWindowTools MainWindowTools;
typedef struct _MainWindowToolsClass MainWindowToolsClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _main_window_file_unref0(var) ((var == NULL) ? NULL : (var = (main_window_file_unref (var), NULL)))
#define _main_window_edit_unref0(var) ((var == NULL) ? NULL : (var = (main_window_edit_unref (var), NULL)))
#define _main_window_build_tools_unref0(var) ((var == NULL) ? NULL : (var = (main_window_build_tools_unref (var), NULL)))
#define _main_window_structure_unref0(var) ((var == NULL) ? NULL : (var = (main_window_structure_unref (var), NULL)))
#define _main_window_documents_unref0(var) ((var == NULL) ? NULL : (var = (main_window_documents_unref (var), NULL)))
#define _main_window_tools_unref0(var) ((var == NULL) ? NULL : (var = (main_window_tools_unref (var), NULL)))

#define TYPE_LATEXILA_APP (latexila_app_get_type ())
#define LATEXILA_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEXILA_APP, LatexilaApp))
#define LATEXILA_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEXILA_APP, LatexilaAppClass))
#define IS_LATEXILA_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEXILA_APP))
#define IS_LATEXILA_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEXILA_APP))
#define LATEXILA_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEXILA_APP, LatexilaAppClass))

typedef struct _LatexilaApp LatexilaApp;
typedef struct _LatexilaAppClass LatexilaAppClass;

#define TYPE_SIDE_PANEL (side_panel_get_type ())
#define SIDE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SIDE_PANEL, SidePanel))
#define SIDE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SIDE_PANEL, SidePanelClass))
#define IS_SIDE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SIDE_PANEL))
#define IS_SIDE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SIDE_PANEL))
#define SIDE_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SIDE_PANEL, SidePanelClass))

typedef struct _SidePanel SidePanel;
typedef struct _SidePanelClass SidePanelClass;

#define TYPE_BOTTOM_PANEL (bottom_panel_get_type ())
#define BOTTOM_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOTTOM_PANEL, BottomPanel))
#define BOTTOM_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOTTOM_PANEL, BottomPanelClass))
#define IS_BOTTOM_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOTTOM_PANEL))
#define IS_BOTTOM_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOTTOM_PANEL))
#define BOTTOM_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOTTOM_PANEL, BottomPanelClass))

typedef struct _BottomPanel BottomPanel;
typedef struct _BottomPanelClass BottomPanelClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define TYPE_LATEX_MENU (latex_menu_get_type ())
#define LATEX_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEX_MENU, LatexMenu))
#define LATEX_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEX_MENU, LatexMenuClass))
#define IS_LATEX_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEX_MENU))
#define IS_LATEX_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEX_MENU))
#define LATEX_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEX_MENU, LatexMenuClass))

typedef struct _LatexMenu LatexMenu;
typedef struct _LatexMenuClass LatexMenuClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SYMBOLS_VIEW (symbols_view_get_type ())
#define SYMBOLS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYMBOLS_VIEW, SymbolsView))
#define SYMBOLS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYMBOLS_VIEW, SymbolsViewClass))
#define IS_SYMBOLS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYMBOLS_VIEW))
#define IS_SYMBOLS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYMBOLS_VIEW))
#define SYMBOLS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYMBOLS_VIEW, SymbolsViewClass))

typedef struct _SymbolsView SymbolsView;
typedef struct _SymbolsViewClass SymbolsViewClass;

#define TYPE_FILE_BROWSER (file_browser_get_type ())
#define FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_BROWSER, FileBrowser))
#define FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_BROWSER, FileBrowserClass))
#define IS_FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_BROWSER))
#define IS_FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_BROWSER))
#define FILE_BROWSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_BROWSER, FileBrowserClass))

typedef struct _FileBrowser FileBrowser;
typedef struct _FileBrowserClass FileBrowserClass;

#define TYPE_STRUCTURE (structure_get_type ())
#define STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRUCTURE, Structure))
#define STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRUCTURE, StructureClass))
#define IS_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRUCTURE))
#define IS_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRUCTURE))
#define STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRUCTURE, StructureClass))

typedef struct _Structure Structure;
typedef struct _StructureClass StructureClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
typedef struct _Block24Data Block24Data;
typedef struct _DocumentPrivate DocumentPrivate;
typedef struct _Block25Data Block25Data;

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	gchar* default_location;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _MainWindowPrivate {
	DocumentsPanel* _documents_panel;
	CustomStatusbar* _statusbar;
	GotoLine* _goto_line;
	SearchAndReplace* _search_and_replace;
	GtkPaned* _main_hpaned;
	GtkPaned* _vpaned;
	GtkUIManager* _ui_manager;
	GtkActionGroup* _action_group;
	GtkActionGroup* _latex_action_group;
	MainWindowFile* _main_window_file;
	MainWindowEdit* _main_window_edit;
	MainWindowBuildTools* _main_window_build_tools;
	MainWindowStructure* _main_window_structure;
	MainWindowDocuments* _main_window_documents;
	MainWindowTools* _main_window_tools;
	guint _tip_message_cid;
};

struct _Block24Data {
	int _ref_count_;
	MainWindow* self;
	DocumentTab* tab;
	GtkInfoBar* infobar;
};

struct _Document {
	GtefBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
	guint _unsaved_doc_num;
};

struct _DocumentClass {
	GtefBufferClass parent_class;
};

struct _Block25Data {
	int _ref_count_;
	MainWindow* self;
	DocumentTab* tab;
};


static gpointer main_window_parent_class = NULL;

GType main_window_get_type (void) G_GNUC_CONST;
GType documents_panel_get_type (void) G_GNUC_CONST;
GType custom_statusbar_get_type (void) G_GNUC_CONST;
GType goto_line_get_type (void) G_GNUC_CONST;
GType search_and_replace_get_type (void) G_GNUC_CONST;
gpointer main_window_file_ref (gpointer instance);
void main_window_file_unref (gpointer instance);
GParamSpec* param_spec_main_window_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_main_window_file (GValue* value, gpointer v_object);
void value_take_main_window_file (GValue* value, gpointer v_object);
gpointer value_get_main_window_file (const GValue* value);
GType main_window_file_get_type (void) G_GNUC_CONST;
gpointer main_window_edit_ref (gpointer instance);
void main_window_edit_unref (gpointer instance);
GParamSpec* param_spec_main_window_edit (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_main_window_edit (GValue* value, gpointer v_object);
void value_take_main_window_edit (GValue* value, gpointer v_object);
gpointer value_get_main_window_edit (const GValue* value);
GType main_window_edit_get_type (void) G_GNUC_CONST;
gpointer main_window_build_tools_ref (gpointer instance);
void main_window_build_tools_unref (gpointer instance);
GParamSpec* param_spec_main_window_build_tools (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_main_window_build_tools (GValue* value, gpointer v_object);
void value_take_main_window_build_tools (GValue* value, gpointer v_object);
gpointer value_get_main_window_build_tools (const GValue* value);
GType main_window_build_tools_get_type (void) G_GNUC_CONST;
gpointer main_window_structure_ref (gpointer instance);
void main_window_structure_unref (gpointer instance);
GParamSpec* param_spec_main_window_structure (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_main_window_structure (GValue* value, gpointer v_object);
void value_take_main_window_structure (GValue* value, gpointer v_object);
gpointer value_get_main_window_structure (const GValue* value);
GType main_window_structure_get_type (void) G_GNUC_CONST;
gpointer main_window_documents_ref (gpointer instance);
void main_window_documents_unref (gpointer instance);
GParamSpec* param_spec_main_window_documents (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_main_window_documents (GValue* value, gpointer v_object);
void value_take_main_window_documents (GValue* value, gpointer v_object);
gpointer value_get_main_window_documents (const GValue* value);
GType main_window_documents_get_type (void) G_GNUC_CONST;
gpointer main_window_tools_ref (gpointer instance);
void main_window_tools_unref (gpointer instance);
GParamSpec* param_spec_main_window_tools (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_main_window_tools (GValue* value, gpointer v_object);
void value_take_main_window_tools (GValue* value, gpointer v_object);
gpointer value_get_main_window_tools (const GValue* value);
GType main_window_tools_get_type (void) G_GNUC_CONST;
#define MAIN_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MAIN_WINDOW, MainWindowPrivate))
enum  {
	MAIN_WINDOW_DUMMY_PROPERTY,
	MAIN_WINDOW_ACTIVE_TAB,
	MAIN_WINDOW_ACTIVE_VIEW,
	MAIN_WINDOW_ACTIVE_DOCUMENT
};
void main_window_on_quit (MainWindow* self);
static void _main_window_on_quit_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_view_zoom_in (MainWindow* self);
static void _main_window_on_view_zoom_in_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_view_zoom_out (MainWindow* self);
static void _main_window_on_view_zoom_out_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_view_zoom_reset (MainWindow* self);
static void _main_window_on_view_zoom_reset_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_search_find (MainWindow* self);
static void _main_window_on_search_find_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_search_replace (MainWindow* self);
static void _main_window_on_search_replace_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_search_goto_line (MainWindow* self);
static void _main_window_on_search_goto_line_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_search_forward (MainWindow* self);
static void _main_window_on_search_forward_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_projects_new (MainWindow* self);
static void _main_window_on_projects_new_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_projects_config_current (MainWindow* self);
static void _main_window_on_projects_config_current_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_projects_manage (MainWindow* self);
static void _main_window_on_projects_manage_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_help_contents (MainWindow* self);
static void _main_window_on_help_contents_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_help_latex_reference (MainWindow* self);
static void _main_window_on_help_latex_reference_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_help_finance (MainWindow* self);
static void _main_window_on_help_finance_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_on_about_dialog (MainWindow* self);
static void _main_window_on_about_dialog_gtk_action_callback (GtkAction* action, gpointer self);
GType latexila_app_get_type (void) G_GNUC_CONST;
MainWindow* main_window_new (LatexilaApp* app);
MainWindow* main_window_construct (GType object_type, LatexilaApp* app);
static void main_window_initialize_ui_manager (MainWindow* self);
MainWindowFile* main_window_file_new (MainWindow* main_window, GtkUIManager* ui_manager);
MainWindowFile* main_window_file_construct (GType object_type, MainWindow* main_window, GtkUIManager* ui_manager);
MainWindowEdit* main_window_edit_new (MainWindow* main_window, GtkUIManager* ui_manager);
MainWindowEdit* main_window_edit_construct (GType object_type, MainWindow* main_window, GtkUIManager* ui_manager);
MainWindowBuildTools* main_window_build_tools_new (MainWindow* main_window, GtkUIManager* ui_manager);
MainWindowBuildTools* main_window_build_tools_construct (GType object_type, MainWindow* main_window, GtkUIManager* ui_manager);
MainWindowDocuments* main_window_documents_new (MainWindow* main_window, GtkUIManager* ui_manager);
MainWindowDocuments* main_window_documents_construct (GType object_type, MainWindow* main_window, GtkUIManager* ui_manager);
MainWindowStructure* main_window_structure_new (GtkUIManager* ui_manager);
MainWindowStructure* main_window_structure_construct (GType object_type, GtkUIManager* ui_manager);
MainWindowTools* main_window_tools_new (MainWindow* main_window, GtkUIManager* ui_manager);
MainWindowTools* main_window_tools_construct (GType object_type, MainWindow* main_window, GtkUIManager* ui_manager);
static void main_window_show_images_in_menu (MainWindow* self);
static void main_window_set_file_actions_sensitivity (MainWindow* self, gboolean sensitive);
static GtkToolbar* main_window_get_main_toolbar (MainWindow* self);
static GtkToolbar* main_window_get_edit_toolbar (MainWindow* self);
GType side_panel_get_type (void) G_GNUC_CONST;
static SidePanel* main_window_get_side_panel (MainWindow* self);
static void main_window_init_documents_panel (MainWindow* self);
GotoLine* goto_line_new (MainWindow* main_window);
GotoLine* goto_line_construct (GType object_type, MainWindow* main_window);
SearchAndReplace* search_and_replace_new (MainWindow* main_window);
SearchAndReplace* search_and_replace_construct (GType object_type, MainWindow* main_window);
GtkWidget* search_and_replace_get_widget (SearchAndReplace* self);
GType bottom_panel_get_type (void) G_GNUC_CONST;
static BottomPanel* main_window_get_bottom_panel (MainWindow* self);
void main_window_build_tools_set_bottom_panel (MainWindowBuildTools* self, BottomPanel* bottom_panel);
CustomStatusbar* custom_statusbar_new (void);
CustomStatusbar* custom_statusbar_construct (GType object_type);
static void main_window_support_drag_and_drop (MainWindow* self);
static gboolean __lambda95_ (MainWindow* self);
gboolean main_window_quit (MainWindow* self);
static gboolean ___lambda95__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void main_window_restore_state (MainWindow* self);
static void main_window_show_or_hide_widgets (MainWindow* self);
void finance_show_dialog (GtkWindow* parent_window, gboolean startup);
LatexMenu* latex_menu_new (MainWindow* main_window);
LatexMenu* latex_menu_construct (GType object_type, MainWindow* main_window);
GType latex_menu_get_type (void) G_GNUC_CONST;
static void __lambda72_ (MainWindow* self, GtkAction* action, GtkWidget* p);
static void main_window_on_menu_item_select (MainWindow* self, GtkMenuItem* proxy);
static void _main_window_on_menu_item_select_gtk_menu_item_select (GtkMenuItem* _sender, gpointer self);
static void main_window_on_menu_item_deselect (MainWindow* self, GtkMenuItem* proxy);
static void _main_window_on_menu_item_deselect_gtk_menu_item_deselect (GtkMenuItem* _sender, gpointer self);
static void ___lambda72__gtk_ui_manager_connect_proxy (GtkUIManager* _sender, GtkAction* action, GtkWidget* proxy, gpointer self);
static void __lambda73_ (MainWindow* self, GtkAction* action, GtkWidget* p);
static void ___lambda73__gtk_ui_manager_disconnect_proxy (GtkUIManager* _sender, GtkAction* action, GtkWidget* proxy, gpointer self);
GtkToolItem* main_window_file_get_toolbar_open_button (MainWindowFile* self);
SidePanel* side_panel_new (void);
SidePanel* side_panel_construct (GType object_type);
GType symbols_view_get_type (void) G_GNUC_CONST;
SymbolsView* symbols_view_new (MainWindow* main_window);
SymbolsView* symbols_view_construct (GType object_type, MainWindow* main_window);
void side_panel_add_component (SidePanel* self, const gchar* name, const gchar* icon_name, GtkGrid* component);
GType file_browser_get_type (void) G_GNUC_CONST;
FileBrowser* file_browser_new (MainWindow* main_window);
FileBrowser* file_browser_construct (GType object_type, MainWindow* main_window);
GType structure_get_type (void) G_GNUC_CONST;
Structure* structure_new (MainWindow* main_window);
Structure* structure_construct (GType object_type, MainWindow* main_window);
void main_window_structure_set_structure (MainWindowStructure* self, Structure* structure);
void side_panel_restore_state (SidePanel* self);
DocumentsPanel* documents_panel_new (MainWindow* main_window);
DocumentsPanel* documents_panel_construct (GType object_type, MainWindow* main_window);
void main_window_documents_set_documents_panel (MainWindowDocuments* self, DocumentsPanel* documents_panel);
static void __lambda90_ (MainWindow* self, GdkEventButton* event);
static void ___lambda90__documents_panel_right_click (DocumentsPanel* _sender, GdkEventButton* event, gpointer self);
static void __lambda91_ (MainWindow* self);
static void ___lambda91__gtk_notebook_page_added (GtkNotebook* _sender, GtkWidget* child, guint page_num, gpointer self);
static void __lambda92_ (MainWindow* self);
void custom_statusbar_set_cursor_position (CustomStatusbar* self, gint line, gint col);
void search_and_replace_hide (SearchAndReplace* self);
static void main_window_my_set_title (MainWindow* self);
static void ___lambda92__gtk_notebook_page_removed (GtkNotebook* _sender, GtkWidget* child, guint page_num, gpointer self);
static void __lambda93_ (MainWindow* self, GtkWidget* pg, guint page_num);
void main_window_edit_update_sensitivity (MainWindowEdit* self);
void main_window_build_tools_update_sensitivity (MainWindowBuildTools* self);
void main_window_tools_update_sensitivity (MainWindowTools* self);
void main_window_update_config_project_sensitivity (MainWindow* self);
static void main_window_update_cursor_position_statusbar (MainWindow* self);
static void ___lambda93__gtk_notebook_switch_page (GtkNotebook* _sender, GtkWidget* page, guint page_num, gpointer self);
void main_window_build_tools_set_build_view (MainWindowBuildTools* self, LatexilaBuildView* build_view);
BottomPanel* bottom_panel_new (LatexilaBuildView* build_view, GtkToolbar* toolbar);
BottomPanel* bottom_panel_construct (GType object_type, LatexilaBuildView* build_view, GtkToolbar* toolbar);
static void __lambda94_ (MainWindow* self, GdkDragContext* dc, gint x, gint y, GtkSelectionData* selection_data, guint info, guint time);
LatexilaApp* latexila_app_get_instance (void);
static void _vala_array_add6 (GFile** * array, int* length, int* size, GFile* value);
void latexila_app_open_documents (LatexilaApp* self, GFile** files, int files_length1);
static void ___lambda94__gtk_widget_drag_data_received (GtkWidget* _sender, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint info, guint time_, gpointer self);
MainWindowStructure* main_window_get_main_window_structure (MainWindow* self);
GType document_get_type (void) G_GNUC_CONST;
GeeList* main_window_get_documents (MainWindow* self);
GType document_tab_get_type (void) G_GNUC_CONST;
Document* document_tab_get_document (DocumentTab* self);
GeeList* main_window_get_unsaved_documents (MainWindow* self);
GType document_view_get_type (void) G_GNUC_CONST;
GeeList* main_window_get_views (MainWindow* self);
DocumentView* document_tab_get_view (DocumentTab* self);
DocumentTab* main_window_open_document (MainWindow* self, GFile* location, gboolean jump_to);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
GFile* document_get_location (Document* self);
void main_window_set_active_tab (MainWindow* self, DocumentTab* value);
static DocumentTab* main_window_create_tab_from_location (MainWindow* self, GFile* location, gboolean jump_to);
void document_set_readonly (Document* self, gboolean value);
GtefInfoBar* document_tab_add_message (DocumentTab* self, const gchar* primary_msg, const gchar* secondary_msg, GtkMessageType msg_type);
static void ______lambda47_ (Block24Data* _data24_, gint response_id);
static void _______lambda47__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self);
DocumentTab* main_window_create_tab (MainWindow* self, gboolean jump_to);
DocumentTab* document_tab_new (void);
DocumentTab* document_tab_construct (GType object_type);
static DocumentTab* main_window_process_create_tab (MainWindow* self, DocumentTab* tab, gboolean jump_to);
DocumentTab* document_tab_new_from_location (GFile* location);
DocumentTab* document_tab_construct_from_location (GType object_type, GFile* location);
void main_window_create_tab_with_view (MainWindow* self, DocumentView* view);
DocumentTab* document_tab_new_with_view (DocumentView* view);
DocumentTab* document_tab_construct_with_view (GType object_type, DocumentView* view);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (void * _userdata_);
static void __lambda15_ (Block25Data* _data25_);
gboolean main_window_close_tab (MainWindow* self, DocumentTab* tab, gboolean force_close);
static void ___lambda15__document_tab_close_document (DocumentTab* _sender, gpointer self);
static void __lambda18_ (Block25Data* _data25_);
DocumentTab* main_window_get_active_tab (MainWindow* self);
static void ___lambda18__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda20_ (Block25Data* _data25_);
static void ___lambda20__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda21_ (Block25Data* _data25_);
static void ___lambda21__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda22_ (Block25Data* _data25_);
static void main_window_sync_name (MainWindow* self, DocumentTab* tab);
static void ___lambda22__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda41_ (MainWindow* self);
static void ___lambda41__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda42_ (Block25Data* _data25_);
static void ___lambda42__gtk_text_buffer_modified_changed (GtkTextBuffer* _sender, gpointer self);
static void __lambda43_ (Block25Data* _data25_);
static void ___lambda43__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _main_window_update_cursor_position_statusbar_gtef_buffer_gtef_cursor_moved (GtefBuffer* _sender, gpointer self);
void documents_panel_add_tab (DocumentsPanel* self, DocumentTab* tab, gint position, gboolean jump_to);
const gchar* document_tab_get_label_text (DocumentTab* self);
gboolean main_window_save_document (MainWindow* self, Document* doc, gboolean force_save_as);
void documents_panel_remove_tab (DocumentsPanel* self, DocumentTab* tab);
void main_window_documents_update_document_name (MainWindowDocuments* self, DocumentTab* tab);
Document* main_window_get_active_document (MainWindow* self);
gchar* document_get_short_name_for_display (Document* self);
gchar* utils_str_middle_truncate (const gchar* str, guint max_length);
gchar* utils_get_dirname_for_display (GFile* location);
gboolean document_get_readonly (Document* self);
void document_save (Document* self, gboolean check_file_changed_on_disk, gboolean force);
void main_window_structure_refresh (MainWindowStructure* self);
void document_set_location (Document* self, GFile* value);
gboolean main_window_close_all_documents (MainWindow* self);
void documents_panel_remove_all_tabs (DocumentsPanel* self);
void dialogs_close_several_unsaved_documents (MainWindow* window, GeeList* unsaved_docs);
void main_window_remove_all_tabs (MainWindow* self);
DocumentView* main_window_get_active_view (MainWindow* self);
void main_window_save_state (MainWindow* self);
void main_window_structure_save_state (MainWindowStructure* self);
void main_window_build_tools_save_state (MainWindowBuildTools* self);
void main_window_jump_to_file_position (MainWindow* self, GFile* file, gint start_line, gint end_line);
void utils_flush_queue (void);
void main_window_file_update_sensitivity (MainWindowFile* self, gboolean sensitive);
gint document_get_project_id (Document* self);
static void _vala_array_add7 (gchar** * array, int* length, int* size, gchar* value);
void document_view_enlarge_font (DocumentView* self);
void document_view_shrink_font (DocumentView* self);
void document_view_set_font_from_settings (DocumentView* self);
void search_and_replace_show_search (SearchAndReplace* self);
void search_and_replace_show_search_and_replace (SearchAndReplace* self);
void goto_line_show (GotoLine* self);
GFile* document_get_main_file (Document* self);
void project_dialogs_new_project (MainWindow* main_window);
gboolean project_dialogs_configure_project (GtkWindow* main_window, gint project_id);
void project_dialogs_manage_projects (MainWindow* main_window);
DocumentTab* documents_panel_get_active_tab (DocumentsPanel* self);
static void main_window_finalize (GObject * obj);
static void _vala_main_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_main_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GtkActionEntry MAIN_WINDOW__action_entries[19] = {{"FileQuit", "application-exit", N_ ("_Quit"), "<Control>Q", N_ ("Quit the program"), (GCallback) _main_window_on_quit_gtk_action_callback}, {"View", NULL, N_ ("_View")}, {"ViewZoomIn", "zoom-in", N_ ("Zoom _In"), "<Control>plus", N_ ("Enlarge the font"), (GCallback) _main_window_on_view_zoom_in_gtk_action_callback}, {"ViewZoomOut", "zoom-out", N_ ("Zoom _Out"), "<Control>minus", N_ ("Shrink the font"), (GCallback) _main_window_on_view_zoom_out_gtk_action_callback}, {"ViewZoomReset", "zoom-original", N_ ("_Reset Zoom"), "<Control>0", N_ ("Reset the size of the font"), (GCallback) _main_window_on_view_zoom_reset_gtk_action_callback}, {"Search", NULL, N_ ("_Search")}, {"SearchFind", "edit-find", N_ ("_Find"), "<Control>F", N_ ("Search for text"), (GCallback) _main_window_on_search_find_gtk_action_callback}, {"SearchReplace", "edit-find-replace", N_ ("Find and _Replace"), "<Control>R", N_ ("Search for and replace text"), (GCallback) _main_window_on_search_replace_gtk_action_callback}, {"SearchGoToLine", "go-jump", N_ ("_Go to Line..."), "<Control>G", N_ ("Go to a specific line"), (GCallback) _main_window_on_search_goto_line_gtk_action_callback}, {"SearchForward", NULL, N_ ("_Jump to PDF"), "<Control><Alt>F", N_ ("Jump to the associated position in the PDF file. Another shortcut: Ctr" \
"l+click, which works in both directions."), (GCallback) _main_window_on_search_forward_gtk_action_callback}, {"Projects", NULL, N_ ("_Projects")}, {"ProjectsNew", "document-new", N_ ("_New Project"), "", N_ ("Create a new project"), (GCallback) _main_window_on_projects_new_gtk_action_callback}, {"ProjectsConfigCurrent", "document-properties", N_ ("_Configure Current Project"), NULL, N_ ("Change the main file of the current project"), (GCallback) _main_window_on_projects_config_current_gtk_action_callback}, {"ProjectsManage", "preferences-system", N_ ("_Manage Projects"), NULL, N_ ("Manage Projects"), (GCallback) _main_window_on_projects_manage_gtk_action_callback}, {"Help", NULL, N_ ("_Help")}, {"HelpContents", "help-browser", N_ ("_Contents"), "<Release>F1", N_ ("Open the LaTeXila documentation"), (GCallback) _main_window_on_help_contents_gtk_action_callback}, {"HelpLatexReference", NULL, N_ ("_LaTeX Reference"), NULL, N_ ("The Kile LaTeX Reference"), (GCallback) _main_window_on_help_latex_reference_gtk_action_callback}, {"HelpFinance", NULL, "LaTeXila _Fundraising", NULL, "Donate to demonstrate your appreciation of LaTeXila and help its futur" \
"e development", (GCallback) _main_window_on_help_finance_gtk_action_callback}, {"HelpAbout", "help-about", N_ ("_About"), NULL, N_ ("About LaTeXila"), (GCallback) _main_window_on_about_dialog_gtk_action_callback}};
static const GtkToggleActionEntry MAIN_WINDOW__toggle_action_entries[4] = {{"ViewMainToolbar", NULL, N_ ("_Main Toolbar"), NULL, N_ ("Show or hide the main toolbar"), (GCallback) NULL}, {"ViewEditToolbar", NULL, N_ ("_Edit Toolbar"), NULL, N_ ("Show or hide the edit toolbar"), (GCallback) NULL}, {"ViewSidePanel", NULL, N_ ("_Side panel"), "<Release>F12", N_ ("Show or hide the side panel"), (GCallback) NULL}, {"ViewBottomPanel", NULL, N_ ("_Bottom panel"), NULL, N_ ("Show or hide the bottom panel"), (GCallback) NULL}};

static void _main_window_on_quit_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_quit ((MainWindow*) self);
}


static void _main_window_on_view_zoom_in_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_view_zoom_in ((MainWindow*) self);
}


static void _main_window_on_view_zoom_out_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_view_zoom_out ((MainWindow*) self);
}


static void _main_window_on_view_zoom_reset_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_view_zoom_reset ((MainWindow*) self);
}


static void _main_window_on_search_find_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_search_find ((MainWindow*) self);
}


static void _main_window_on_search_replace_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_search_replace ((MainWindow*) self);
}


static void _main_window_on_search_goto_line_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_search_goto_line ((MainWindow*) self);
}


static void _main_window_on_search_forward_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_search_forward ((MainWindow*) self);
}


static void _main_window_on_projects_new_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_projects_new ((MainWindow*) self);
}


static void _main_window_on_projects_config_current_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_projects_config_current ((MainWindow*) self);
}


static void _main_window_on_projects_manage_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_projects_manage ((MainWindow*) self);
}


static void _main_window_on_help_contents_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_help_contents ((MainWindow*) self);
}


static void _main_window_on_help_latex_reference_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_help_latex_reference ((MainWindow*) self);
}


static void _main_window_on_help_finance_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_help_finance ((MainWindow*) self);
}


static void _main_window_on_about_dialog_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_on_about_dialog ((MainWindow*) self);
}


/*************************************************************************/
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean __lambda95_ (MainWindow* self) {
	gboolean result = FALSE;
	main_window_quit (self);
	result = TRUE;
	return result;
}


static gboolean ___lambda95__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = __lambda95_ ((MainWindow*) self);
	return result;
}


MainWindow* main_window_construct (GType object_type, LatexilaApp* app) {
	MainWindow * self = NULL;
	LatexilaApp* _tmp0_;
	GtkUIManager* _tmp1_;
	MainWindowFile* _tmp2_;
	GtkUIManager* _tmp3_;
	MainWindowEdit* _tmp4_;
	GtkUIManager* _tmp5_;
	MainWindowBuildTools* _tmp6_;
	GtkUIManager* _tmp7_;
	MainWindowDocuments* _tmp8_;
	GtkUIManager* _tmp9_;
	MainWindowStructure* _tmp10_;
	GtkUIManager* _tmp11_;
	MainWindowTools* _tmp12_;
	GtkGrid* main_vgrid = NULL;
	GtkGrid* _tmp13_;
	GtkWidget* menu = NULL;
	GtkUIManager* _tmp14_;
	GtkWidget* _tmp15_;
	GtkWidget* _tmp16_;
	GtkPaned* menu_paned = NULL;
	GtkPaned* _tmp17_;
	GtkViewport* viewport = NULL;
	GtkViewport* _tmp18_;
	GdkRGBA transparent = {0};
	GdkRGBA _tmp19_;
	GtkToolbar* main_toolbar = NULL;
	GtkToolbar* _tmp20_;
	GtkToolbar* edit_toolbar = NULL;
	GtkToolbar* _tmp21_;
	GtkPaned* _tmp22_;
	GtkPaned* _tmp23_;
	GtkPaned* _tmp24_;
	SidePanel* side_panel = NULL;
	SidePanel* _tmp25_;
	GtkPaned* _tmp26_;
	GtkPaned* _tmp27_;
	GtkPaned* _tmp28_;
	GtkPaned* _tmp29_;
	GtkPaned* _tmp30_;
	GtkGrid* docs_vgrid = NULL;
	GtkGrid* _tmp31_;
	DocumentsPanel* _tmp32_;
	GotoLine* _tmp33_;
	GotoLine* _tmp34_;
	SearchAndReplace* _tmp35_;
	SearchAndReplace* _tmp36_;
	GtkWidget* _tmp37_;
	GtkWidget* _tmp38_;
	BottomPanel* bottom_panel = NULL;
	BottomPanel* _tmp39_;
	MainWindowBuildTools* _tmp40_;
	GtkPaned* _tmp41_;
	GtkPaned* _tmp42_;
	CustomStatusbar* _tmp43_;
	CustomStatusbar* _tmp44_;
	CustomStatusbar* _tmp45_;
	CustomStatusbar* _tmp46_;
	guint _tmp47_;
	g_return_val_if_fail (app != NULL, NULL);
	_tmp0_ = app;
	self = (MainWindow*) g_object_new (object_type, "application", _tmp0_, NULL);
	gtk_window_set_title ((GtkWindow*) self, "LaTeXila");
	main_window_initialize_ui_manager (self);
	_tmp1_ = self->priv->_ui_manager;
	_tmp2_ = main_window_file_new (self, _tmp1_);
	_main_window_file_unref0 (self->priv->_main_window_file);
	self->priv->_main_window_file = _tmp2_;
	_tmp3_ = self->priv->_ui_manager;
	_tmp4_ = main_window_edit_new (self, _tmp3_);
	_main_window_edit_unref0 (self->priv->_main_window_edit);
	self->priv->_main_window_edit = _tmp4_;
	_tmp5_ = self->priv->_ui_manager;
	_tmp6_ = main_window_build_tools_new (self, _tmp5_);
	_main_window_build_tools_unref0 (self->priv->_main_window_build_tools);
	self->priv->_main_window_build_tools = _tmp6_;
	_tmp7_ = self->priv->_ui_manager;
	_tmp8_ = main_window_documents_new (self, _tmp7_);
	_main_window_documents_unref0 (self->priv->_main_window_documents);
	self->priv->_main_window_documents = _tmp8_;
	_tmp9_ = self->priv->_ui_manager;
	_tmp10_ = main_window_structure_new (_tmp9_);
	_main_window_structure_unref0 (self->priv->_main_window_structure);
	self->priv->_main_window_structure = _tmp10_;
	_tmp11_ = self->priv->_ui_manager;
	_tmp12_ = main_window_tools_new (self, _tmp11_);
	_main_window_tools_unref0 (self->priv->_main_window_tools);
	self->priv->_main_window_tools = _tmp12_;
	main_window_show_images_in_menu (self);
	main_window_set_file_actions_sensitivity (self, FALSE);
	_tmp13_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp13_);
	main_vgrid = _tmp13_;
	gtk_orientable_set_orientation ((GtkOrientable*) main_vgrid, GTK_ORIENTATION_VERTICAL);
	gtk_widget_show ((GtkWidget*) main_vgrid);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) main_vgrid);
	_tmp14_ = self->priv->_ui_manager;
	_tmp15_ = gtk_ui_manager_get_widget (_tmp14_, "/MainMenu");
	_tmp16_ = _g_object_ref0 (_tmp15_);
	menu = _tmp16_;
	_tmp17_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp17_);
	menu_paned = _tmp17_;
	_tmp18_ = (GtkViewport*) gtk_viewport_new (NULL, NULL);
	g_object_ref_sink (_tmp18_);
	viewport = _tmp18_;
	gtk_viewport_set_shadow_type (viewport, GTK_SHADOW_NONE);
	memset (&transparent, 0, sizeof (GdkRGBA));
	transparent.alpha = 0.0;
	_tmp19_ = transparent;
	gtk_widget_override_background_color ((GtkWidget*) viewport, GTK_STATE_FLAG_NORMAL, &_tmp19_);
	gtk_container_add ((GtkContainer*) viewport, menu);
	gtk_paned_add1 (menu_paned, (GtkWidget*) viewport);
	gtk_widget_show_all ((GtkWidget*) menu_paned);
	gtk_container_add ((GtkContainer*) main_vgrid, (GtkWidget*) menu_paned);
	_tmp20_ = main_window_get_main_toolbar (self);
	main_toolbar = _tmp20_;
	_tmp21_ = main_window_get_edit_toolbar (self);
	edit_toolbar = _tmp21_;
	gtk_container_add ((GtkContainer*) main_vgrid, (GtkWidget*) main_toolbar);
	gtk_container_add ((GtkContainer*) main_vgrid, (GtkWidget*) edit_toolbar);
	_tmp22_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->_main_hpaned);
	self->priv->_main_hpaned = _tmp22_;
	_tmp23_ = self->priv->_main_hpaned;
	gtk_widget_show ((GtkWidget*) _tmp23_);
	_tmp24_ = self->priv->_main_hpaned;
	gtk_container_add ((GtkContainer*) main_vgrid, (GtkWidget*) _tmp24_);
	_tmp25_ = main_window_get_side_panel (self);
	side_panel = _tmp25_;
	_tmp26_ = self->priv->_main_hpaned;
	gtk_paned_pack1 (_tmp26_, (GtkWidget*) side_panel, FALSE, FALSE);
	_tmp27_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_VERTICAL);
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->_vpaned);
	self->priv->_vpaned = _tmp27_;
	_tmp28_ = self->priv->_vpaned;
	gtk_widget_show ((GtkWidget*) _tmp28_);
	_tmp29_ = self->priv->_main_hpaned;
	_tmp30_ = self->priv->_vpaned;
	gtk_paned_add2 (_tmp29_, (GtkWidget*) _tmp30_);
	_tmp31_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp31_);
	docs_vgrid = _tmp31_;
	gtk_orientable_set_orientation ((GtkOrientable*) docs_vgrid, GTK_ORIENTATION_VERTICAL);
	gtk_grid_set_row_spacing (docs_vgrid, (guint) 2);
	gtk_widget_show ((GtkWidget*) docs_vgrid);
	main_window_init_documents_panel (self);
	_tmp32_ = self->priv->_documents_panel;
	gtk_container_add ((GtkContainer*) docs_vgrid, (GtkWidget*) _tmp32_);
	_tmp33_ = goto_line_new (self);
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->priv->_goto_line);
	self->priv->_goto_line = _tmp33_;
	_tmp34_ = self->priv->_goto_line;
	gtk_container_add ((GtkContainer*) docs_vgrid, (GtkWidget*) _tmp34_);
	_tmp35_ = search_and_replace_new (self);
	_g_object_unref0 (self->priv->_search_and_replace);
	self->priv->_search_and_replace = _tmp35_;
	_tmp36_ = self->priv->_search_and_replace;
	_tmp37_ = search_and_replace_get_widget (_tmp36_);
	_tmp38_ = _tmp37_;
	gtk_container_add ((GtkContainer*) docs_vgrid, _tmp38_);
	_g_object_unref0 (_tmp38_);
	_tmp39_ = main_window_get_bottom_panel (self);
	bottom_panel = _tmp39_;
	_tmp40_ = self->priv->_main_window_build_tools;
	main_window_build_tools_set_bottom_panel (_tmp40_, bottom_panel);
	_tmp41_ = self->priv->_vpaned;
	gtk_paned_pack1 (_tmp41_, (GtkWidget*) docs_vgrid, TRUE, TRUE);
	_tmp42_ = self->priv->_vpaned;
	gtk_paned_pack2 (_tmp42_, (GtkWidget*) bottom_panel, FALSE, FALSE);
	_tmp43_ = custom_statusbar_new ();
	g_object_ref_sink (_tmp43_);
	_g_object_unref0 (self->priv->_statusbar);
	self->priv->_statusbar = _tmp43_;
	_tmp44_ = self->priv->_statusbar;
	gtk_widget_show_all ((GtkWidget*) _tmp44_);
	_tmp45_ = self->priv->_statusbar;
	gtk_container_add ((GtkContainer*) main_vgrid, (GtkWidget*) _tmp45_);
	_tmp46_ = self->priv->_statusbar;
	_tmp47_ = gtk_statusbar_get_context_id ((GtkStatusbar*) _tmp46_, "tip_message");
	self->priv->_tip_message_cid = _tmp47_;
	main_window_support_drag_and_drop (self);
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) ___lambda95__gtk_widget_delete_event, self, 0);
	main_window_restore_state (self);
	main_window_show_or_hide_widgets (self);
	gtk_widget_show ((GtkWidget*) self);
	finance_show_dialog ((GtkWindow*) self, TRUE);
	_g_object_unref0 (bottom_panel);
	_g_object_unref0 (docs_vgrid);
	_g_object_unref0 (side_panel);
	_g_object_unref0 (edit_toolbar);
	_g_object_unref0 (main_toolbar);
	_g_object_unref0 (viewport);
	_g_object_unref0 (menu_paned);
	_g_object_unref0 (menu);
	_g_object_unref0 (main_vgrid);
	return self;
}


MainWindow* main_window_new (LatexilaApp* app) {
	return main_window_construct (TYPE_MAIN_WINDOW, app);
}


static void main_window_show_images_in_menu (MainWindow* self) {
	GtkUIManager* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_ui_manager;
	_tmp1_ = gtk_ui_manager_get_action_groups (_tmp0_);
	{
		GList* action_group_collection = NULL;
		GList* action_group_it = NULL;
		action_group_collection = _tmp1_;
		for (action_group_it = action_group_collection; action_group_it != NULL; action_group_it = action_group_it->next) {
			GtkActionGroup* _tmp2_;
			GtkActionGroup* action_group = NULL;
			_tmp2_ = _g_object_ref0 ((GtkActionGroup*) action_group_it->data);
			action_group = _tmp2_;
			{
				GtkActionGroup* _tmp3_;
				GList* _tmp4_;
				_tmp3_ = action_group;
				_tmp4_ = gtk_action_group_list_actions (_tmp3_);
				{
					GList* action_collection = NULL;
					GList* action_it = NULL;
					action_collection = _tmp4_;
					for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
						GtkAction* _tmp5_;
						GtkAction* action = NULL;
						_tmp5_ = _g_object_ref0 ((GtkAction*) action_it->data);
						action = _tmp5_;
						{
							GtkAction* _tmp6_;
							_tmp6_ = action;
							gtk_action_set_always_show_image (_tmp6_, TRUE);
							_g_object_unref0 (action);
						}
					}
					_g_list_free0 (action_collection);
				}
				_g_object_unref0 (action_group);
			}
		}
	}
}


static void _main_window_on_menu_item_select_gtk_menu_item_select (GtkMenuItem* _sender, gpointer self) {
	main_window_on_menu_item_select ((MainWindow*) self, _sender);
}


static void _main_window_on_menu_item_deselect_gtk_menu_item_deselect (GtkMenuItem* _sender, gpointer self) {
	main_window_on_menu_item_deselect ((MainWindow*) self, _sender);
}


static void __lambda72_ (MainWindow* self, GtkAction* action, GtkWidget* p) {
	GtkWidget* _tmp0_;
	g_return_if_fail (action != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = p;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_menu_item_get_type ())) {
		GtkMenuItem* proxy = NULL;
		GtkWidget* _tmp1_;
		GtkMenuItem* _tmp2_;
		GtkMenuItem* _tmp3_;
		GtkMenuItem* _tmp4_;
		_tmp1_ = p;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_menu_item_get_type ()) ? ((GtkMenuItem*) _tmp1_) : NULL);
		proxy = _tmp2_;
		_tmp3_ = proxy;
		g_signal_connect_object (_tmp3_, "select", (GCallback) _main_window_on_menu_item_select_gtk_menu_item_select, self, 0);
		_tmp4_ = proxy;
		g_signal_connect_object (_tmp4_, "deselect", (GCallback) _main_window_on_menu_item_deselect_gtk_menu_item_deselect, self, 0);
		_g_object_unref0 (proxy);
	}
}


static void ___lambda72__gtk_ui_manager_connect_proxy (GtkUIManager* _sender, GtkAction* action, GtkWidget* proxy, gpointer self) {
	__lambda72_ ((MainWindow*) self, action, proxy);
}


static void __lambda73_ (MainWindow* self, GtkAction* action, GtkWidget* p) {
	GtkWidget* _tmp0_;
	g_return_if_fail (action != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = p;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_menu_item_get_type ())) {
		GtkMenuItem* proxy = NULL;
		GtkWidget* _tmp1_;
		GtkMenuItem* _tmp2_;
		GtkMenuItem* _tmp3_;
		guint _tmp4_;
		GtkMenuItem* _tmp5_;
		guint _tmp6_;
		_tmp1_ = p;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_menu_item_get_type ()) ? ((GtkMenuItem*) _tmp1_) : NULL);
		proxy = _tmp2_;
		_tmp3_ = proxy;
		g_signal_parse_name ("select", gtk_menu_item_get_type (), &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _main_window_on_menu_item_select_gtk_menu_item_select, self);
		_tmp5_ = proxy;
		g_signal_parse_name ("deselect", gtk_menu_item_get_type (), &_tmp6_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _main_window_on_menu_item_deselect_gtk_menu_item_deselect, self);
		_g_object_unref0 (proxy);
	}
}


static void ___lambda73__gtk_ui_manager_disconnect_proxy (GtkUIManager* _sender, GtkAction* action, GtkWidget* proxy, gpointer self) {
	__lambda73_ ((MainWindow*) self, action, proxy);
}


static void main_window_initialize_ui_manager (MainWindow* self) {
	GtkActionGroup* _tmp0_;
	GtkActionGroup* _tmp1_;
	GtkActionGroup* _tmp2_;
	GtkActionGroup* _tmp3_;
	LatexMenu* _tmp4_;
	GtkUIManager* _tmp5_;
	GtkUIManager* _tmp6_;
	GtkActionGroup* _tmp7_;
	GtkUIManager* _tmp8_;
	GtkActionGroup* _tmp9_;
	GtkUIManager* _tmp13_;
	GtkAccelGroup* _tmp14_;
	GtkUIManager* _tmp15_;
	GtkUIManager* _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_action_group_new ("ActionGroup");
	_g_object_unref0 (self->priv->_action_group);
	self->priv->_action_group = _tmp0_;
	_tmp1_ = self->priv->_action_group;
	gtk_action_group_set_translation_domain (_tmp1_, GETTEXT_PACKAGE);
	_tmp2_ = self->priv->_action_group;
	gtk_action_group_add_actions (_tmp2_, MAIN_WINDOW__action_entries, G_N_ELEMENTS (MAIN_WINDOW__action_entries), self);
	_tmp3_ = self->priv->_action_group;
	gtk_action_group_add_toggle_actions (_tmp3_, MAIN_WINDOW__toggle_action_entries, G_N_ELEMENTS (MAIN_WINDOW__toggle_action_entries), self);
	_tmp4_ = latex_menu_new (self);
	_g_object_unref0 (self->priv->_latex_action_group);
	self->priv->_latex_action_group = (GtkActionGroup*) _tmp4_;
	_tmp5_ = gtk_ui_manager_new ();
	_g_object_unref0 (self->priv->_ui_manager);
	self->priv->_ui_manager = _tmp5_;
	_tmp6_ = self->priv->_ui_manager;
	_tmp7_ = self->priv->_action_group;
	gtk_ui_manager_insert_action_group (_tmp6_, _tmp7_, 0);
	_tmp8_ = self->priv->_ui_manager;
	_tmp9_ = self->priv->_latex_action_group;
	gtk_ui_manager_insert_action_group (_tmp8_, _tmp9_, 0);
	{
		gchar* path = NULL;
		gchar* _tmp10_;
		GtkUIManager* _tmp11_;
		_tmp10_ = g_build_filename (DATA_DIR, "ui", "ui.xml", NULL);
		path = _tmp10_;
		_tmp11_ = self->priv->_ui_manager;
		gtk_ui_manager_add_ui_from_file (_tmp11_, path, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (path);
			goto __catch34_g_error;
		}
		_g_free0 (path);
	}
	goto __finally34;
	__catch34_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp12_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = err->message;
		g_error ("main_window.vala:311: %s", _tmp12_);
		_g_error_free0 (err);
	}
	__finally34:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp13_ = self->priv->_ui_manager;
	_tmp14_ = gtk_ui_manager_get_accel_group (_tmp13_);
	gtk_window_add_accel_group ((GtkWindow*) self, _tmp14_);
	_tmp15_ = self->priv->_ui_manager;
	g_signal_connect_object (_tmp15_, "connect-proxy", (GCallback) ___lambda72__gtk_ui_manager_connect_proxy, self, 0);
	_tmp16_ = self->priv->_ui_manager;
	g_signal_connect_object (_tmp16_, "disconnect-proxy", (GCallback) ___lambda73__gtk_ui_manager_disconnect_proxy, self, 0);
}


static void main_window_on_menu_item_select (MainWindow* self, GtkMenuItem* proxy) {
	GtkAction* action = NULL;
	GtkMenuItem* _tmp0_;
	GtkAction* _tmp1_;
	GtkAction* _tmp2_;
	GtkAction* _tmp3_;
	GtkAction* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (proxy != NULL);
	_tmp0_ = proxy;
	_tmp1_ = gtk_activatable_get_related_action ((GtkActivatable*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	action = _tmp2_;
	_tmp3_ = action;
	g_return_if_fail (_tmp3_ != NULL);
	_tmp4_ = action;
	_tmp5_ = gtk_action_get_tooltip (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != NULL) {
		CustomStatusbar* _tmp7_;
		guint _tmp8_;
		GtkAction* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp7_ = self->priv->_statusbar;
		_tmp8_ = self->priv->_tip_message_cid;
		_tmp9_ = action;
		_tmp10_ = gtk_action_get_tooltip (_tmp9_);
		_tmp11_ = _tmp10_;
		gtk_statusbar_push ((GtkStatusbar*) _tmp7_, _tmp8_, _tmp11_);
	}
	_g_object_unref0 (action);
}


static void main_window_on_menu_item_deselect (MainWindow* self, GtkMenuItem* proxy) {
	CustomStatusbar* _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (proxy != NULL);
	_tmp0_ = self->priv->_statusbar;
	_tmp1_ = self->priv->_tip_message_cid;
	gtk_statusbar_pop ((GtkStatusbar*) _tmp0_, _tmp1_);
}


static GtkToolbar* main_window_get_main_toolbar (MainWindow* self) {
	GtkToolbar* result = NULL;
	GtkToolbar* main_toolbar = NULL;
	GtkUIManager* _tmp0_;
	GtkWidget* _tmp1_;
	GtkToolbar* _tmp2_;
	GtkToolItem* open_button = NULL;
	MainWindowFile* _tmp3_;
	GtkToolItem* _tmp4_;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp7_;
	GtkAction* _tmp8_;
	GtkToggleAction* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ui_manager;
	_tmp1_ = gtk_ui_manager_get_widget (_tmp0_, "/MainToolbar");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_toolbar_get_type ()) ? ((GtkToolbar*) _tmp1_) : NULL);
	main_toolbar = _tmp2_;
	_tmp3_ = self->priv->_main_window_file;
	_tmp4_ = main_window_file_get_toolbar_open_button (_tmp3_);
	open_button = _tmp4_;
	gtk_toolbar_insert (main_toolbar, open_button, 1);
	gtk_toolbar_set_style (main_toolbar, GTK_TOOLBAR_ICONS);
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) main_toolbar);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	context = _tmp6_;
	gtk_style_context_add_class (context, GTK_STYLE_CLASS_PRIMARY_TOOLBAR);
	gtk_widget_show_all ((GtkWidget*) main_toolbar);
	_tmp7_ = self->priv->_action_group;
	_tmp8_ = gtk_action_group_get_action (_tmp7_, "ViewMainToolbar");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp8_) : NULL);
	action = _tmp9_;
	gtk_toggle_action_set_active (action, TRUE);
	g_object_bind_property_with_closures ((GObject*) main_toolbar, "visible", (GObject*) action, "active", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	result = main_toolbar;
	_g_object_unref0 (action);
	_g_object_unref0 (context);
	_g_object_unref0 (open_button);
	return result;
}


static GtkToolbar* main_window_get_edit_toolbar (MainWindow* self) {
	GtkToolbar* result = NULL;
	GtkToolbar* edit_toolbar = NULL;
	GtkUIManager* _tmp0_;
	GtkWidget* _tmp1_;
	GtkToolbar* _tmp2_;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp5_;
	GtkAction* _tmp6_;
	GtkToggleAction* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ui_manager;
	_tmp1_ = gtk_ui_manager_get_widget (_tmp0_, "/EditToolbar");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_toolbar_get_type ()) ? ((GtkToolbar*) _tmp1_) : NULL);
	edit_toolbar = _tmp2_;
	gtk_toolbar_set_style (edit_toolbar, GTK_TOOLBAR_ICONS);
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) edit_toolbar);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	context = _tmp4_;
	gtk_style_context_add_class (context, "latexila-edit-toolbar");
	gtk_widget_show_all ((GtkWidget*) edit_toolbar);
	_tmp5_ = self->priv->_action_group;
	_tmp6_ = gtk_action_group_get_action (_tmp5_, "ViewEditToolbar");
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp6_) : NULL);
	action = _tmp7_;
	gtk_toggle_action_set_active (action, TRUE);
	g_object_bind_property_with_closures ((GObject*) edit_toolbar, "visible", (GObject*) action, "active", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	result = edit_toolbar;
	_g_object_unref0 (action);
	_g_object_unref0 (context);
	return result;
}


static SidePanel* main_window_get_side_panel (MainWindow* self) {
	SidePanel* result = NULL;
	SidePanel* side_panel = NULL;
	SidePanel* _tmp0_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp1_;
	GtkAction* _tmp2_;
	GtkToggleAction* _tmp3_;
	SymbolsView* symbols = NULL;
	SymbolsView* _tmp4_;
	FileBrowser* file_browser = NULL;
	FileBrowser* _tmp5_;
	Structure* structure = NULL;
	Structure* _tmp6_;
	MainWindowStructure* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = side_panel_new ();
	g_object_ref_sink (_tmp0_);
	side_panel = _tmp0_;
	gtk_widget_show ((GtkWidget*) side_panel);
	_tmp1_ = self->priv->_action_group;
	_tmp2_ = gtk_action_group_get_action (_tmp1_, "ViewSidePanel");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp2_) : NULL);
	action = _tmp3_;
	gtk_toggle_action_set_active (action, TRUE);
	g_object_bind_property_with_closures ((GObject*) side_panel, "visible", (GObject*) action, "active", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp4_ = symbols_view_new (self);
	g_object_ref_sink (_tmp4_);
	symbols = _tmp4_;
	side_panel_add_component (side_panel, _ ("Symbols"), "symbol_greek", (GtkGrid*) symbols);
	_tmp5_ = file_browser_new (self);
	g_object_ref_sink (_tmp5_);
	file_browser = _tmp5_;
	side_panel_add_component (side_panel, _ ("File Browser"), "document-open", (GtkGrid*) file_browser);
	_tmp6_ = structure_new (self);
	g_object_ref_sink (_tmp6_);
	structure = _tmp6_;
	_tmp7_ = self->priv->_main_window_structure;
	main_window_structure_set_structure (_tmp7_, structure);
	side_panel_add_component (side_panel, _ ("Structure"), GTK_STOCK_INDEX, (GtkGrid*) structure);
	side_panel_restore_state (side_panel);
	result = side_panel;
	_g_object_unref0 (structure);
	_g_object_unref0 (file_browser);
	_g_object_unref0 (symbols);
	_g_object_unref0 (action);
	return result;
}


static void __lambda90_ (MainWindow* self, GdkEventButton* event) {
	GtkMenu* popup_menu = NULL;
	GtkUIManager* _tmp0_;
	GtkWidget* _tmp1_;
	GtkMenu* _tmp2_;
	GdkEventButton* _tmp3_;
	guint _tmp4_;
	GdkEventButton* _tmp5_;
	guint32 _tmp6_;
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->_ui_manager;
	_tmp1_ = gtk_ui_manager_get_widget (_tmp0_, "/NotebookPopup");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_menu_get_type ()) ? ((GtkMenu*) _tmp1_) : NULL);
	popup_menu = _tmp2_;
	_tmp3_ = event;
	_tmp4_ = _tmp3_->button;
	_tmp5_ = event;
	_tmp6_ = _tmp5_->time;
	gtk_menu_popup (popup_menu, NULL, NULL, NULL, NULL, _tmp4_, _tmp6_);
	_g_object_unref0 (popup_menu);
}


static void ___lambda90__documents_panel_right_click (DocumentsPanel* _sender, GdkEventButton* event, gpointer self) {
	__lambda90_ ((MainWindow*) self, event);
}


static void __lambda91_ (MainWindow* self) {
	gint nb_pages = 0;
	DocumentsPanel* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	_tmp0_ = self->priv->_documents_panel;
	_tmp1_ = gtk_notebook_get_n_pages ((GtkNotebook*) _tmp0_);
	nb_pages = _tmp1_;
	_tmp2_ = nb_pages;
	if (_tmp2_ == 1) {
		main_window_set_file_actions_sensitivity (self, TRUE);
	}
}


static void ___lambda91__gtk_notebook_page_added (GtkNotebook* _sender, GtkWidget* child, guint page_num, gpointer self) {
	__lambda91_ ((MainWindow*) self);
}


static void __lambda92_ (MainWindow* self) {
	gint nb_pages = 0;
	DocumentsPanel* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	_tmp0_ = self->priv->_documents_panel;
	_tmp1_ = gtk_notebook_get_n_pages ((GtkNotebook*) _tmp0_);
	nb_pages = _tmp1_;
	_tmp2_ = nb_pages;
	if (_tmp2_ == 0) {
		CustomStatusbar* _tmp3_;
		GotoLine* _tmp4_;
		SearchAndReplace* _tmp5_;
		_tmp3_ = self->priv->_statusbar;
		custom_statusbar_set_cursor_position (_tmp3_, -1, -1);
		main_window_set_file_actions_sensitivity (self, FALSE);
		_tmp4_ = self->priv->_goto_line;
		gtk_widget_hide ((GtkWidget*) _tmp4_);
		_tmp5_ = self->priv->_search_and_replace;
		search_and_replace_hide (_tmp5_);
		g_object_notify ((GObject*) self, "active-tab");
		g_object_notify ((GObject*) self, "active-document");
		g_object_notify ((GObject*) self, "active-view");
	}
	main_window_my_set_title (self);
}


static void ___lambda92__gtk_notebook_page_removed (GtkNotebook* _sender, GtkWidget* child, guint page_num, gpointer self) {
	__lambda92_ ((MainWindow*) self);
}


static void __lambda93_ (MainWindow* self, GtkWidget* pg, guint page_num) {
	MainWindowEdit* _tmp0_;
	MainWindowBuildTools* _tmp1_;
	MainWindowTools* _tmp2_;
	g_return_if_fail (pg != NULL);
	_tmp0_ = self->priv->_main_window_edit;
	main_window_edit_update_sensitivity (_tmp0_);
	_tmp1_ = self->priv->_main_window_build_tools;
	main_window_build_tools_update_sensitivity (_tmp1_);
	_tmp2_ = self->priv->_main_window_tools;
	main_window_tools_update_sensitivity (_tmp2_);
	main_window_update_config_project_sensitivity (self);
	main_window_my_set_title (self);
	main_window_update_cursor_position_statusbar (self);
	g_object_notify ((GObject*) self, "active-tab");
	g_object_notify ((GObject*) self, "active-document");
	g_object_notify ((GObject*) self, "active-view");
}


static void ___lambda93__gtk_notebook_switch_page (GtkNotebook* _sender, GtkWidget* page, guint page_num, gpointer self) {
	__lambda93_ ((MainWindow*) self, page, page_num);
}


static void main_window_init_documents_panel (MainWindow* self) {
	DocumentsPanel* _tmp0_;
	DocumentsPanel* _tmp1_;
	MainWindowDocuments* _tmp2_;
	DocumentsPanel* _tmp3_;
	DocumentsPanel* _tmp4_;
	DocumentsPanel* _tmp5_;
	DocumentsPanel* _tmp6_;
	DocumentsPanel* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = documents_panel_new (self);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->_documents_panel);
	self->priv->_documents_panel = _tmp0_;
	_tmp1_ = self->priv->_documents_panel;
	gtk_widget_show_all ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->_main_window_documents;
	_tmp3_ = self->priv->_documents_panel;
	main_window_documents_set_documents_panel (_tmp2_, _tmp3_);
	_tmp4_ = self->priv->_documents_panel;
	g_signal_connect_object (_tmp4_, "right-click", (GCallback) ___lambda90__documents_panel_right_click, self, 0);
	_tmp5_ = self->priv->_documents_panel;
	g_signal_connect_object ((GtkNotebook*) _tmp5_, "page-added", (GCallback) ___lambda91__gtk_notebook_page_added, self, 0);
	_tmp6_ = self->priv->_documents_panel;
	g_signal_connect_object ((GtkNotebook*) _tmp6_, "page-removed", (GCallback) ___lambda92__gtk_notebook_page_removed, self, 0);
	_tmp7_ = self->priv->_documents_panel;
	g_signal_connect_object ((GtkNotebook*) _tmp7_, "switch-page", (GCallback) ___lambda93__gtk_notebook_switch_page, self, 0);
}


static BottomPanel* main_window_get_bottom_panel (MainWindow* self) {
	BottomPanel* result = NULL;
	LatexilaBuildView* build_view = NULL;
	LatexilaBuildView* _tmp0_;
	MainWindowBuildTools* _tmp1_;
	GtkToolbar* build_toolbar = NULL;
	GtkUIManager* _tmp2_;
	GtkWidget* _tmp3_;
	GtkToolbar* _tmp4_;
	BottomPanel* bottom_panel = NULL;
	BottomPanel* _tmp5_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp6_;
	GtkAction* _tmp7_;
	GtkToggleAction* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = latexila_build_view_new ();
	g_object_ref_sink (_tmp0_);
	build_view = _tmp0_;
	_tmp1_ = self->priv->_main_window_build_tools;
	main_window_build_tools_set_build_view (_tmp1_, build_view);
	_tmp2_ = self->priv->_ui_manager;
	_tmp3_ = gtk_ui_manager_get_widget (_tmp2_, "/BuildToolbar");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_toolbar_get_type ()) ? ((GtkToolbar*) _tmp3_) : NULL);
	build_toolbar = _tmp4_;
	gtk_toolbar_set_style (build_toolbar, GTK_TOOLBAR_ICONS);
	gtk_toolbar_set_icon_size (build_toolbar, GTK_ICON_SIZE_MENU);
	gtk_orientable_set_orientation ((GtkOrientable*) build_toolbar, GTK_ORIENTATION_VERTICAL);
	_tmp5_ = bottom_panel_new (build_view, build_toolbar);
	g_object_ref_sink (_tmp5_);
	bottom_panel = _tmp5_;
	_tmp6_ = self->priv->_action_group;
	_tmp7_ = gtk_action_group_get_action (_tmp6_, "ViewBottomPanel");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp7_) : NULL);
	action = _tmp8_;
	gtk_toggle_action_set_active (action, FALSE);
	g_object_bind_property_with_closures ((GObject*) bottom_panel, "visible", (GObject*) action, "active", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	result = bottom_panel;
	_g_object_unref0 (action);
	_g_object_unref0 (build_toolbar);
	_g_object_unref0 (build_view);
	return result;
}


static void main_window_restore_state (MainWindow* self) {
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	gint width = 0;
	gint height = 0;
	GSettings* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GdkWindowState state = 0;
	GSettings* _tmp4_;
	gint _tmp5_;
	GdkWindowState _tmp6_;
	GdkWindowState _tmp7_;
	GtkPaned* _tmp8_;
	GSettings* _tmp9_;
	gint _tmp10_;
	GtkPaned* _tmp11_;
	GSettings* _tmp12_;
	gint _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.state.window");
	settings = _tmp0_;
	_tmp1_ = settings;
	g_settings_get (_tmp1_, "size", "(ii)", &width, &height);
	_tmp2_ = width;
	_tmp3_ = height;
	gtk_window_set_default_size ((GtkWindow*) self, _tmp2_, _tmp3_);
	_tmp4_ = settings;
	_tmp5_ = g_settings_get_int (_tmp4_, "state");
	state = (GdkWindowState) _tmp5_;
	_tmp6_ = state;
	if ((_tmp6_ & GDK_WINDOW_STATE_MAXIMIZED) == GDK_WINDOW_STATE_MAXIMIZED) {
		gtk_window_maximize ((GtkWindow*) self);
	} else {
		gtk_window_unmaximize ((GtkWindow*) self);
	}
	_tmp7_ = state;
	if ((_tmp7_ & GDK_WINDOW_STATE_STICKY) == GDK_WINDOW_STATE_STICKY) {
		gtk_window_stick ((GtkWindow*) self);
	} else {
		gtk_window_unstick ((GtkWindow*) self);
	}
	_tmp8_ = self->priv->_main_hpaned;
	_tmp9_ = settings;
	_tmp10_ = g_settings_get_int (_tmp9_, "side-panel-size");
	gtk_paned_set_position (_tmp8_, _tmp10_);
	_tmp11_ = self->priv->_vpaned;
	_tmp12_ = settings;
	_tmp13_ = g_settings_get_int (_tmp12_, "vertical-paned-position");
	gtk_paned_set_position (_tmp11_, _tmp13_);
	_g_object_unref0 (settings);
}


static void _vala_array_add6 (GFile** * array, int* length, int* size, GFile* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void __lambda94_ (MainWindow* self, GdkDragContext* dc, gint x, gint y, GtkSelectionData* selection_data, guint info, guint time) {
	LatexilaApp* app = NULL;
	LatexilaApp* _tmp0_;
	GFile** files = NULL;
	GFile** _tmp1_;
	gint files_length1;
	gint _files_size_;
	GtkSelectionData* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	LatexilaApp* _tmp12_;
	GFile** _tmp13_;
	gint _tmp13__length1;
	GdkDragContext* _tmp14_;
	guint _tmp15_;
	g_return_if_fail (dc != NULL);
	g_return_if_fail (selection_data != NULL);
	_tmp0_ = latexila_app_get_instance ();
	app = _tmp0_;
	_tmp1_ = g_new0 (GFile*, 0 + 1);
	files = _tmp1_;
	files_length1 = 0;
	_files_size_ = files_length1;
	_tmp2_ = selection_data;
	_tmp4_ = _tmp3_ = gtk_selection_data_get_uris (_tmp2_);
	{
		gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = _tmp4_;
		uri_collection_length1 = _vala_array_length (_tmp3_);
		for (uri_it = 0; uri_it < _vala_array_length (_tmp3_); uri_it = uri_it + 1) {
			gchar* _tmp5_;
			gchar* uri = NULL;
			_tmp5_ = g_strdup (uri_collection[uri_it]);
			uri = _tmp5_;
			{
				const gchar* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				_tmp6_ = uri;
				_tmp7_ = strlen (_tmp6_);
				_tmp8_ = _tmp7_;
				if (0 < _tmp8_) {
					GFile** _tmp9_;
					gint _tmp9__length1;
					const gchar* _tmp10_;
					GFile* _tmp11_;
					_tmp9_ = files;
					_tmp9__length1 = files_length1;
					_tmp10_ = uri;
					_tmp11_ = g_file_new_for_uri (_tmp10_);
					_vala_array_add6 (&files, &files_length1, &_files_size_, _tmp11_);
				}
				_g_free0 (uri);
			}
		}
		uri_collection = (_vala_array_free (uri_collection, uri_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp12_ = app;
	_tmp13_ = files;
	_tmp13__length1 = files_length1;
	latexila_app_open_documents (_tmp12_, _tmp13_, _tmp13__length1);
	_tmp14_ = dc;
	_tmp15_ = time;
	gtk_drag_finish (_tmp14_, TRUE, TRUE, (guint32) _tmp15_);
	files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (app);
}


static void ___lambda94__gtk_widget_drag_data_received (GtkWidget* _sender, GdkDragContext* context, gint x, gint y, GtkSelectionData* selection_data, guint info, guint time_, gpointer self) {
	__lambda94_ ((MainWindow*) self, context, x, y, selection_data, info, time_);
}


static void main_window_support_drag_and_drop (MainWindow* self) {
	GtkTargetEntry* _tmp0_;
	GtkTargetEntry* _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (GtkTargetEntry, 0);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 0;
	gtk_drag_dest_set ((GtkWidget*) self, GTK_DEST_DEFAULT_ALL, _tmp1_, 0, GDK_ACTION_COPY);
	_tmp1_ = (g_free (_tmp1_), NULL);
	gtk_drag_dest_add_uri_targets ((GtkWidget*) self);
	g_signal_connect_object ((GtkWidget*) self, "drag-data-received", (GCallback) ___lambda94__gtk_widget_drag_data_received, self, 0);
}


static void main_window_show_or_hide_widgets (MainWindow* self) {
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp1_;
	GtkAction* _tmp2_;
	GtkToggleAction* _tmp3_;
	GtkToggleAction* _tmp4_;
	gboolean _tmp5_;
	GtkActionGroup* _tmp6_;
	GtkAction* _tmp7_;
	GtkToggleAction* _tmp8_;
	GtkToggleAction* _tmp9_;
	gboolean _tmp10_;
	GtkActionGroup* _tmp11_;
	GtkAction* _tmp12_;
	GtkToggleAction* _tmp13_;
	GtkToggleAction* _tmp14_;
	gboolean _tmp15_;
	GtkActionGroup* _tmp16_;
	GtkAction* _tmp17_;
	GtkToggleAction* _tmp18_;
	GtkToggleAction* _tmp19_;
	gboolean _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.ui");
	settings = _tmp0_;
	_tmp1_ = self->priv->_action_group;
	_tmp2_ = gtk_action_group_get_action (_tmp1_, "ViewMainToolbar");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp2_) : NULL);
	action = _tmp3_;
	_tmp4_ = action;
	_tmp5_ = g_settings_get_boolean (settings, "main-toolbar-visible");
	gtk_toggle_action_set_active (_tmp4_, _tmp5_);
	_tmp6_ = self->priv->_action_group;
	_tmp7_ = gtk_action_group_get_action (_tmp6_, "ViewEditToolbar");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp7_) : NULL);
	_g_object_unref0 (action);
	action = _tmp8_;
	_tmp9_ = action;
	_tmp10_ = g_settings_get_boolean (settings, "edit-toolbar-visible");
	gtk_toggle_action_set_active (_tmp9_, _tmp10_);
	_tmp11_ = self->priv->_action_group;
	_tmp12_ = gtk_action_group_get_action (_tmp11_, "ViewSidePanel");
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp12_) : NULL);
	_g_object_unref0 (action);
	action = _tmp13_;
	_tmp14_ = action;
	_tmp15_ = g_settings_get_boolean (settings, "side-panel-visible");
	gtk_toggle_action_set_active (_tmp14_, _tmp15_);
	_tmp16_ = self->priv->_action_group;
	_tmp17_ = gtk_action_group_get_action (_tmp16_, "ViewBottomPanel");
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp17_) : NULL);
	_g_object_unref0 (action);
	action = _tmp18_;
	_tmp19_ = action;
	_tmp20_ = g_settings_get_boolean (settings, "bottom-panel-visible");
	gtk_toggle_action_set_active (_tmp19_, _tmp20_);
	_g_object_unref0 (action);
	_g_object_unref0 (settings);
}


/*************************************************************************/
static gpointer _main_window_structure_ref0 (gpointer self) {
	return self ? main_window_structure_ref (self) : NULL;
}


MainWindowStructure* main_window_get_main_window_structure (MainWindow* self) {
	MainWindowStructure* result = NULL;
	MainWindowStructure* _tmp0_;
	MainWindowStructure* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_main_window_structure;
	_tmp1_ = _main_window_structure_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/*************************************************************************/
GeeList* main_window_get_documents (MainWindow* self) {
	GeeList* result = NULL;
	GeeList* all_documents = NULL;
	GeeLinkedList* _tmp0_;
	gint nb_documents = 0;
	DocumentsPanel* _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_linked_list_new (TYPE_DOCUMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	all_documents = (GeeList*) _tmp0_;
	_tmp1_ = self->priv->_documents_panel;
	_tmp2_ = gtk_notebook_get_n_pages ((GtkNotebook*) _tmp1_);
	nb_documents = _tmp2_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				DocumentTab* tab = NULL;
				DocumentsPanel* _tmp7_;
				gint _tmp8_;
				GtkWidget* _tmp9_;
				DocumentTab* _tmp10_;
				GeeList* _tmp11_;
				DocumentTab* _tmp12_;
				Document* _tmp13_;
				Document* _tmp14_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = nb_documents;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->_documents_panel;
				_tmp8_ = i;
				_tmp9_ = gtk_notebook_get_nth_page ((GtkNotebook*) _tmp7_, _tmp8_);
				_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, TYPE_DOCUMENT_TAB) ? ((DocumentTab*) _tmp9_) : NULL);
				tab = _tmp10_;
				_tmp11_ = all_documents;
				_tmp12_ = tab;
				_tmp13_ = document_tab_get_document (_tmp12_);
				_tmp14_ = _tmp13_;
				gee_collection_add ((GeeCollection*) _tmp11_, _tmp14_);
				_g_object_unref0 (tab);
			}
		}
	}
	result = all_documents;
	return result;
}


GeeList* main_window_get_unsaved_documents (MainWindow* self) {
	GeeList* result = NULL;
	GeeList* unsaved_documents = NULL;
	GeeLinkedList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_linked_list_new (TYPE_DOCUMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	unsaved_documents = (GeeList*) _tmp0_;
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp1_;
		gint _doc_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _doc_index = 0;
		_tmp1_ = main_window_get_documents (self);
		_doc_list = _tmp1_;
		_tmp2_ = _doc_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_doc_size = _tmp4_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			Document* doc = NULL;
			GeeList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			Document* _tmp11_;
			gboolean _tmp12_;
			_tmp5_ = _doc_index;
			_doc_index = _tmp5_ + 1;
			_tmp6_ = _doc_index;
			_tmp7_ = _doc_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _doc_list;
			_tmp9_ = _doc_index;
			_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
			doc = (Document*) _tmp10_;
			_tmp11_ = doc;
			_tmp12_ = gtk_text_buffer_get_modified ((GtkTextBuffer*) _tmp11_);
			if (_tmp12_) {
				GeeList* _tmp13_;
				Document* _tmp14_;
				_tmp13_ = unsaved_documents;
				_tmp14_ = doc;
				gee_collection_add ((GeeCollection*) _tmp13_, _tmp14_);
			}
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
	result = unsaved_documents;
	return result;
}


GeeList* main_window_get_views (MainWindow* self) {
	GeeList* result = NULL;
	GeeList* all_views = NULL;
	GeeLinkedList* _tmp0_;
	DocumentsPanel* _tmp1_;
	gint nb_documents = 0;
	DocumentsPanel* _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_linked_list_new (TYPE_DOCUMENT_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	all_views = (GeeList*) _tmp0_;
	_tmp1_ = self->priv->_documents_panel;
	if (_tmp1_ == NULL) {
		result = all_views;
		return result;
	}
	_tmp2_ = self->priv->_documents_panel;
	_tmp3_ = gtk_notebook_get_n_pages ((GtkNotebook*) _tmp2_);
	nb_documents = _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				gint _tmp7_;
				DocumentTab* tab = NULL;
				DocumentsPanel* _tmp8_;
				gint _tmp9_;
				GtkWidget* _tmp10_;
				DocumentTab* _tmp11_;
				GeeList* _tmp12_;
				DocumentTab* _tmp13_;
				DocumentView* _tmp14_;
				DocumentView* _tmp15_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = nb_documents;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				_tmp8_ = self->priv->_documents_panel;
				_tmp9_ = i;
				_tmp10_ = gtk_notebook_get_nth_page ((GtkNotebook*) _tmp8_, _tmp9_);
				_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, TYPE_DOCUMENT_TAB) ? ((DocumentTab*) _tmp10_) : NULL);
				tab = _tmp11_;
				_tmp12_ = all_views;
				_tmp13_ = tab;
				_tmp14_ = document_tab_get_view (_tmp13_);
				_tmp15_ = _tmp14_;
				gee_collection_add ((GeeCollection*) _tmp12_, _tmp15_);
				_g_object_unref0 (tab);
			}
		}
	}
	result = all_views;
	return result;
}


static Block24Data* block24_data_ref (Block24Data* _data24_) {
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}


static void block24_data_unref (void * _userdata_) {
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		MainWindow* self;
		self = _data24_->self;
		_g_object_unref0 (_data24_->infobar);
		_g_object_unref0 (_data24_->tab);
		_g_object_unref0 (self);
		g_slice_free (Block24Data, _data24_);
	}
}


static void ______lambda47_ (Block24Data* _data24_, gint response_id) {
	MainWindow* self;
	gint _tmp0_;
	GtkInfoBar* _tmp4_;
	DocumentTab* _tmp5_;
	DocumentView* _tmp6_;
	DocumentView* _tmp7_;
	self = _data24_->self;
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_YES)) {
		DocumentTab* _tmp1_;
		Document* _tmp2_;
		Document* _tmp3_;
		_tmp1_ = _data24_->tab;
		_tmp2_ = document_tab_get_document (_tmp1_);
		_tmp3_ = _tmp2_;
		document_set_readonly (_tmp3_, FALSE);
	}
	_tmp4_ = _data24_->infobar;
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
	_tmp5_ = _data24_->tab;
	_tmp6_ = document_tab_get_view (_tmp5_);
	_tmp7_ = _tmp6_;
	gtk_widget_grab_focus ((GtkWidget*) _tmp7_);
}


static void _______lambda47__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self) {
	______lambda47_ (self, response_id);
}


DocumentTab* main_window_open_document (MainWindow* self, GFile* location, gboolean jump_to) {
	DocumentTab* result = NULL;
	LatexilaApp* _tmp0_;
	LatexilaApp* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	GFile* _tmp56_;
	gboolean _tmp57_;
	DocumentTab* _tmp58_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (location != NULL, NULL);
	_tmp0_ = latexila_app_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_application_get_windows ((GtkApplication*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp3_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GtkWindow* _tmp4_;
			GtkWindow* window = NULL;
			_tmp4_ = _g_object_ref0 ((GtkWindow*) window_it->data);
			window = _tmp4_;
			{
				GtkWindow* _tmp5_;
				MainWindow* w = NULL;
				GtkWindow* _tmp6_;
				MainWindow* _tmp7_;
				_tmp5_ = window;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_MAIN_WINDOW)) {
					_g_object_unref0 (window);
					continue;
				}
				_tmp6_ = window;
				_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, TYPE_MAIN_WINDOW) ? ((MainWindow*) _tmp6_) : NULL);
				w = _tmp7_;
				{
					GeeList* _doc_list = NULL;
					MainWindow* _tmp8_;
					GeeList* _tmp9_;
					gint _doc_size = 0;
					GeeList* _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					gint _doc_index = 0;
					_tmp8_ = w;
					_tmp9_ = main_window_get_documents (_tmp8_);
					_doc_list = _tmp9_;
					_tmp10_ = _doc_list;
					_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
					_tmp12_ = _tmp11_;
					_doc_size = _tmp12_;
					_doc_index = -1;
					while (TRUE) {
						Block24Data* _data24_;
						gint _tmp13_;
						gint _tmp14_;
						gint _tmp15_;
						Document* doc = NULL;
						GeeList* _tmp16_;
						gint _tmp17_;
						gpointer _tmp18_;
						gboolean _tmp19_ = FALSE;
						Document* _tmp20_;
						GFile* _tmp21_;
						GFile* _tmp22_;
						MainWindow* _tmp28_;
						GFile* _tmp35_;
						gboolean _tmp36_;
						DocumentTab* _tmp37_;
						DocumentTab* _tmp38_;
						Document* _tmp39_;
						Document* _tmp40_;
						gchar* primary_msg = NULL;
						GFile* _tmp41_;
						gchar* _tmp42_;
						gchar* _tmp43_;
						gchar* _tmp44_;
						gchar* _tmp45_;
						gchar* secondary_msg = NULL;
						gchar* _tmp46_;
						DocumentTab* _tmp47_;
						const gchar* _tmp48_;
						const gchar* _tmp49_;
						GtefInfoBar* _tmp50_;
						GtkInfoBar* _tmp51_;
						GtkInfoBar* _tmp52_;
						GtkInfoBar* _tmp53_;
						DocumentTab* _tmp54_;
						DocumentTab* _tmp55_;
						_data24_ = g_slice_new0 (Block24Data);
						_data24_->_ref_count_ = 1;
						_data24_->self = g_object_ref (self);
						_tmp13_ = _doc_index;
						_doc_index = _tmp13_ + 1;
						_tmp14_ = _doc_index;
						_tmp15_ = _doc_size;
						if (!(_tmp14_ < _tmp15_)) {
							block24_data_unref (_data24_);
							_data24_ = NULL;
							break;
						}
						_tmp16_ = _doc_list;
						_tmp17_ = _doc_index;
						_tmp18_ = gee_list_get (_tmp16_, _tmp17_);
						doc = (Document*) _tmp18_;
						_tmp20_ = doc;
						_tmp21_ = document_get_location (_tmp20_);
						_tmp22_ = _tmp21_;
						if (_tmp22_ == NULL) {
							_tmp19_ = TRUE;
						} else {
							GFile* _tmp23_;
							Document* _tmp24_;
							GFile* _tmp25_;
							GFile* _tmp26_;
							gboolean _tmp27_;
							_tmp23_ = location;
							_tmp24_ = doc;
							_tmp25_ = document_get_location (_tmp24_);
							_tmp26_ = _tmp25_;
							_tmp27_ = g_file_equal (_tmp23_, _tmp26_);
							_tmp19_ = !_tmp27_;
						}
						if (_tmp19_) {
							_g_object_unref0 (doc);
							block24_data_unref (_data24_);
							_data24_ = NULL;
							continue;
						}
						_tmp28_ = w;
						if (self == _tmp28_) {
							gboolean _tmp29_;
							Document* _tmp32_;
							DocumentTab* _tmp33_;
							DocumentTab* _tmp34_;
							_tmp29_ = jump_to;
							if (_tmp29_) {
								Document* _tmp30_;
								DocumentTab* _tmp31_;
								_tmp30_ = doc;
								_tmp31_ = _tmp30_->tab;
								main_window_set_active_tab (self, _tmp31_);
							}
							_tmp32_ = doc;
							_tmp33_ = _tmp32_->tab;
							_tmp34_ = _g_object_ref0 (_tmp33_);
							result = _tmp34_;
							_g_object_unref0 (doc);
							block24_data_unref (_data24_);
							_data24_ = NULL;
							_g_object_unref0 (_doc_list);
							_g_object_unref0 (w);
							_g_object_unref0 (window);
							return result;
						}
						_tmp35_ = location;
						_tmp36_ = jump_to;
						_tmp37_ = main_window_create_tab_from_location (self, _tmp35_, _tmp36_);
						_data24_->tab = _tmp37_;
						_tmp38_ = _data24_->tab;
						_tmp39_ = document_tab_get_document (_tmp38_);
						_tmp40_ = _tmp39_;
						document_set_readonly (_tmp40_, TRUE);
						_tmp41_ = location;
						_tmp42_ = g_file_get_parse_name (_tmp41_);
						_tmp43_ = _tmp42_;
						_tmp44_ = g_strdup_printf (_ ("This file (%s) is already opened in another LaTeXila window."), _tmp43_);
						_tmp45_ = _tmp44_;
						_g_free0 (_tmp43_);
						primary_msg = _tmp45_;
						_tmp46_ = g_strdup (_ ("LaTeXila opened this instance of the file in a non-editable way. Do yo" \
"u want to edit it anyway?"));
						secondary_msg = _tmp46_;
						_tmp47_ = _data24_->tab;
						_tmp48_ = primary_msg;
						_tmp49_ = secondary_msg;
						_tmp50_ = document_tab_add_message (_tmp47_, _tmp48_, _tmp49_, GTK_MESSAGE_WARNING);
						_data24_->infobar = (GtkInfoBar*) _tmp50_;
						_tmp51_ = _data24_->infobar;
						gtk_info_bar_add_button (_tmp51_, _ ("Edit Anyway"), (gint) GTK_RESPONSE_YES);
						_tmp52_ = _data24_->infobar;
						gtk_info_bar_add_button (_tmp52_, _ ("Don't Edit"), (gint) GTK_RESPONSE_NO);
						_tmp53_ = _data24_->infobar;
						g_signal_connect_data (_tmp53_, "response", (GCallback) _______lambda47__gtk_info_bar_response, block24_data_ref (_data24_), (GClosureNotify) block24_data_unref, 0);
						_tmp54_ = _data24_->tab;
						_tmp55_ = _g_object_ref0 (_tmp54_);
						result = _tmp55_;
						_g_free0 (secondary_msg);
						_g_free0 (primary_msg);
						_g_object_unref0 (doc);
						block24_data_unref (_data24_);
						_data24_ = NULL;
						_g_object_unref0 (_doc_list);
						_g_object_unref0 (w);
						_g_object_unref0 (window);
						return result;
					}
					_g_object_unref0 (_doc_list);
				}
				_g_object_unref0 (w);
				_g_object_unref0 (window);
			}
		}
	}
	_tmp56_ = location;
	_tmp57_ = jump_to;
	_tmp58_ = main_window_create_tab_from_location (self, _tmp56_, _tmp57_);
	result = _tmp58_;
	return result;
}


DocumentTab* main_window_create_tab (MainWindow* self, gboolean jump_to) {
	DocumentTab* result = NULL;
	DocumentTab* tab = NULL;
	DocumentTab* _tmp0_;
	gboolean _tmp1_;
	DocumentTab* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = document_tab_new ();
	g_object_ref_sink (_tmp0_);
	tab = _tmp0_;
	_tmp1_ = jump_to;
	_tmp2_ = main_window_process_create_tab (self, tab, _tmp1_);
	result = _tmp2_;
	_g_object_unref0 (tab);
	return result;
}


static DocumentTab* main_window_create_tab_from_location (MainWindow* self, GFile* location, gboolean jump_to) {
	DocumentTab* result = NULL;
	DocumentTab* tab = NULL;
	GFile* _tmp0_;
	DocumentTab* _tmp1_;
	gboolean _tmp2_;
	DocumentTab* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (location != NULL, NULL);
	_tmp0_ = location;
	_tmp1_ = document_tab_new_from_location (_tmp0_);
	g_object_ref_sink (_tmp1_);
	tab = _tmp1_;
	_tmp2_ = jump_to;
	_tmp3_ = main_window_process_create_tab (self, tab, _tmp2_);
	result = _tmp3_;
	_g_object_unref0 (tab);
	return result;
}


void main_window_create_tab_with_view (MainWindow* self, DocumentView* view) {
	DocumentTab* tab = NULL;
	DocumentView* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	DocumentTab* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	_tmp0_ = view;
	_tmp1_ = document_tab_new_with_view (_tmp0_);
	g_object_ref_sink (_tmp1_);
	tab = _tmp1_;
	_tmp2_ = main_window_process_create_tab (self, tab, TRUE);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (tab);
}


static Block25Data* block25_data_ref (Block25Data* _data25_) {
	g_atomic_int_inc (&_data25_->_ref_count_);
	return _data25_;
}


static void block25_data_unref (void * _userdata_) {
	Block25Data* _data25_;
	_data25_ = (Block25Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
		MainWindow* self;
		self = _data25_->self;
		_g_object_unref0 (_data25_->tab);
		_g_object_unref0 (self);
		g_slice_free (Block25Data, _data25_);
	}
}


static void __lambda15_ (Block25Data* _data25_) {
	MainWindow* self;
	DocumentTab* _tmp0_;
	self = _data25_->self;
	_tmp0_ = _data25_->tab;
	main_window_close_tab (self, _tmp0_, FALSE);
}


static void ___lambda15__document_tab_close_document (DocumentTab* _sender, gpointer self) {
	__lambda15_ (self);
}


static void __lambda18_ (Block25Data* _data25_) {
	MainWindow* self;
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	self = _data25_->self;
	_tmp0_ = _data25_->tab;
	_tmp1_ = main_window_get_active_tab (self);
	_tmp2_ = _tmp1_;
	if (_tmp0_ == _tmp2_) {
		MainWindowEdit* _tmp3_;
		_tmp3_ = self->priv->_main_window_edit;
		main_window_edit_update_sensitivity (_tmp3_);
	}
}


static void ___lambda18__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda18_ (self);
}


static void __lambda20_ (Block25Data* _data25_) {
	MainWindow* self;
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	self = _data25_->self;
	_tmp0_ = _data25_->tab;
	_tmp1_ = main_window_get_active_tab (self);
	_tmp2_ = _tmp1_;
	if (_tmp0_ == _tmp2_) {
		MainWindowEdit* _tmp3_;
		_tmp3_ = self->priv->_main_window_edit;
		main_window_edit_update_sensitivity (_tmp3_);
	}
}


static void ___lambda20__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda20_ (self);
}


static void __lambda21_ (Block25Data* _data25_) {
	MainWindow* self;
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	self = _data25_->self;
	_tmp0_ = _data25_->tab;
	_tmp1_ = main_window_get_active_tab (self);
	_tmp2_ = _tmp1_;
	if (_tmp0_ == _tmp2_) {
		MainWindowEdit* _tmp3_;
		_tmp3_ = self->priv->_main_window_edit;
		main_window_edit_update_sensitivity (_tmp3_);
	}
}


static void ___lambda21__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda21_ (self);
}


static void __lambda22_ (Block25Data* _data25_) {
	MainWindow* self;
	DocumentTab* _tmp0_;
	MainWindowBuildTools* _tmp1_;
	self = _data25_->self;
	_tmp0_ = _data25_->tab;
	main_window_sync_name (self, _tmp0_);
	_tmp1_ = self->priv->_main_window_build_tools;
	main_window_build_tools_update_sensitivity (_tmp1_);
}


static void ___lambda22__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda22_ (self);
}


static void __lambda41_ (MainWindow* self) {
	MainWindowBuildTools* _tmp0_;
	_tmp0_ = self->priv->_main_window_build_tools;
	main_window_build_tools_update_sensitivity (_tmp0_);
}


static void ___lambda41__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda41_ ((MainWindow*) self);
}


static void __lambda42_ (Block25Data* _data25_) {
	MainWindow* self;
	DocumentTab* _tmp0_;
	self = _data25_->self;
	_tmp0_ = _data25_->tab;
	main_window_sync_name (self, _tmp0_);
}


static void ___lambda42__gtk_text_buffer_modified_changed (GtkTextBuffer* _sender, gpointer self) {
	__lambda42_ (self);
}


static void __lambda43_ (Block25Data* _data25_) {
	MainWindow* self;
	DocumentTab* _tmp0_;
	self = _data25_->self;
	_tmp0_ = _data25_->tab;
	main_window_sync_name (self, _tmp0_);
}


static void ___lambda43__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda43_ (self);
}


static void _main_window_update_cursor_position_statusbar_gtef_buffer_gtef_cursor_moved (GtefBuffer* _sender, gpointer self) {
	main_window_update_cursor_position_statusbar ((MainWindow*) self);
}


static DocumentTab* main_window_process_create_tab (MainWindow* self, DocumentTab* tab, gboolean jump_to) {
	DocumentTab* result = NULL;
	Block25Data* _data25_;
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	DocumentTab* _tmp3_;
	DocumentTab* _tmp4_;
	Document* _tmp5_;
	Document* _tmp6_;
	DocumentTab* _tmp7_;
	Document* _tmp8_;
	Document* _tmp9_;
	DocumentTab* _tmp10_;
	Document* _tmp11_;
	Document* _tmp12_;
	DocumentTab* _tmp13_;
	Document* _tmp14_;
	Document* _tmp15_;
	DocumentTab* _tmp16_;
	Document* _tmp17_;
	Document* _tmp18_;
	DocumentTab* _tmp19_;
	Document* _tmp20_;
	Document* _tmp21_;
	DocumentTab* _tmp22_;
	Document* _tmp23_;
	Document* _tmp24_;
	DocumentTab* _tmp25_;
	Document* _tmp26_;
	Document* _tmp27_;
	DocumentTab* _tmp28_;
	DocumentsPanel* _tmp29_;
	DocumentTab* _tmp30_;
	gboolean _tmp31_;
	MainWindowEdit* _tmp32_;
	MainWindowTools* _tmp33_;
	gboolean _tmp34_;
	DocumentTab* _tmp35_;
	DocumentTab* _tmp36_;
	g_return_val_if_fail (self != NULL, NULL);
	_data25_ = g_slice_new0 (Block25Data);
	_data25_->_ref_count_ = 1;
	_data25_->self = g_object_ref (self);
	_tmp0_ = tab;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data25_->tab);
	_data25_->tab = _tmp1_;
	_tmp2_ = _data25_->tab;
	if (_tmp2_ == NULL) {
		result = NULL;
		block25_data_unref (_data25_);
		_data25_ = NULL;
		return result;
	}
	_tmp3_ = _data25_->tab;
	g_signal_connect_data (_tmp3_, "close-document", (GCallback) ___lambda15__document_tab_close_document, block25_data_ref (_data25_), (GClosureNotify) block25_data_unref, 0);
	_tmp4_ = _data25_->tab;
	_tmp5_ = document_tab_get_document (_tmp4_);
	_tmp6_ = _tmp5_;
	g_signal_connect_data ((GObject*) _tmp6_, "notify::can-undo", (GCallback) ___lambda18__g_object_notify, block25_data_ref (_data25_), (GClosureNotify) block25_data_unref, 0);
	_tmp7_ = _data25_->tab;
	_tmp8_ = document_tab_get_document (_tmp7_);
	_tmp9_ = _tmp8_;
	g_signal_connect_data ((GObject*) _tmp9_, "notify::can-redo", (GCallback) ___lambda20__g_object_notify, block25_data_ref (_data25_), (GClosureNotify) block25_data_unref, 0);
	_tmp10_ = _data25_->tab;
	_tmp11_ = document_tab_get_document (_tmp10_);
	_tmp12_ = _tmp11_;
	g_signal_connect_data ((GObject*) _tmp12_, "notify::has-selection", (GCallback) ___lambda21__g_object_notify, block25_data_ref (_data25_), (GClosureNotify) block25_data_unref, 0);
	_tmp13_ = _data25_->tab;
	_tmp14_ = document_tab_get_document (_tmp13_);
	_tmp15_ = _tmp14_;
	g_signal_connect_data ((GObject*) _tmp15_, "notify::location", (GCallback) ___lambda22__g_object_notify, block25_data_ref (_data25_), (GClosureNotify) block25_data_unref, 0);
	_tmp16_ = _data25_->tab;
	_tmp17_ = document_tab_get_document (_tmp16_);
	_tmp18_ = _tmp17_;
	g_signal_connect_object ((GObject*) _tmp18_, "notify::project-id", (GCallback) ___lambda41__g_object_notify, self, 0);
	_tmp19_ = _data25_->tab;
	_tmp20_ = document_tab_get_document (_tmp19_);
	_tmp21_ = _tmp20_;
	g_signal_connect_data ((GtkTextBuffer*) _tmp21_, "modified-changed", (GCallback) ___lambda42__gtk_text_buffer_modified_changed, block25_data_ref (_data25_), (GClosureNotify) block25_data_unref, 0);
	_tmp22_ = _data25_->tab;
	_tmp23_ = document_tab_get_document (_tmp22_);
	_tmp24_ = _tmp23_;
	g_signal_connect_data ((GObject*) _tmp24_, "notify::readonly", (GCallback) ___lambda43__g_object_notify, block25_data_ref (_data25_), (GClosureNotify) block25_data_unref, 0);
	_tmp25_ = _data25_->tab;
	_tmp26_ = document_tab_get_document (_tmp25_);
	_tmp27_ = _tmp26_;
	g_signal_connect_object ((GtefBuffer*) _tmp27_, "gtef-cursor-moved", (GCallback) _main_window_update_cursor_position_statusbar_gtef_buffer_gtef_cursor_moved, self, 0);
	_tmp28_ = _data25_->tab;
	gtk_widget_show ((GtkWidget*) _tmp28_);
	_tmp29_ = self->priv->_documents_panel;
	_tmp30_ = _data25_->tab;
	_tmp31_ = jump_to;
	documents_panel_add_tab (_tmp29_, _tmp30_, -1, _tmp31_);
	_tmp32_ = self->priv->_main_window_edit;
	main_window_edit_update_sensitivity (_tmp32_);
	_tmp33_ = self->priv->_main_window_tools;
	main_window_tools_update_sensitivity (_tmp33_);
	_tmp34_ = gtk_widget_get_visible ((GtkWidget*) self);
	if (!_tmp34_) {
		gtk_window_present ((GtkWindow*) self);
	}
	_tmp35_ = _data25_->tab;
	_tmp36_ = _g_object_ref0 (_tmp35_);
	result = _tmp36_;
	block25_data_unref (_data25_);
	_data25_ = NULL;
	return result;
}


gboolean main_window_close_tab (MainWindow* self, DocumentTab* tab, gboolean force_close) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	DocumentsPanel* _tmp28_;
	DocumentTab* _tmp29_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tab != NULL, FALSE);
	_tmp1_ = force_close;
	if (!_tmp1_) {
		DocumentTab* _tmp2_;
		Document* _tmp3_;
		Document* _tmp4_;
		gboolean _tmp5_;
		_tmp2_ = tab;
		_tmp3_ = document_tab_get_document (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = gtk_text_buffer_get_modified ((GtkTextBuffer*) _tmp4_);
		_tmp0_ = _tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkDialog* dialog = NULL;
		DocumentTab* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		GtkMessageDialog* _tmp9_;
		GtkDialog* _tmp10_;
		DocumentTab* _tmp11_;
		Document* _tmp12_;
		Document* _tmp13_;
		GFile* _tmp14_;
		GFile* _tmp15_;
		GtkDialog* _tmp27_;
		_tmp6_ = tab;
		_tmp7_ = document_tab_get_label_text (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _ ("Save changes to document \"%s\" before closing?"), _tmp8_);
		g_object_ref_sink (_tmp9_);
		dialog = (GtkDialog*) _tmp9_;
		_tmp10_ = dialog;
		gtk_dialog_add_buttons (_tmp10_, _ ("Close _without Saving"), GTK_RESPONSE_CLOSE, _ ("_Cancel"), GTK_RESPONSE_CANCEL, NULL);
		_tmp11_ = tab;
		_tmp12_ = document_tab_get_document (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = document_get_location (_tmp13_);
		_tmp15_ = _tmp14_;
		if (_tmp15_ == NULL) {
			GtkDialog* _tmp16_;
			_tmp16_ = dialog;
			gtk_dialog_add_button (_tmp16_, _ ("Save _As"), (gint) GTK_RESPONSE_ACCEPT);
		} else {
			GtkDialog* _tmp17_;
			_tmp17_ = dialog;
			gtk_dialog_add_button (_tmp17_, _ ("_Save"), (gint) GTK_RESPONSE_ACCEPT);
		}
		while (TRUE) {
			gint res = 0;
			GtkDialog* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			_tmp18_ = dialog;
			_tmp19_ = gtk_dialog_run (_tmp18_);
			res = _tmp19_;
			_tmp20_ = res;
			if (_tmp20_ == ((gint) GTK_RESPONSE_CLOSE)) {
				break;
			} else {
				gint _tmp21_;
				_tmp21_ = res;
				if (_tmp21_ == ((gint) GTK_RESPONSE_ACCEPT)) {
					DocumentTab* _tmp22_;
					Document* _tmp23_;
					Document* _tmp24_;
					gboolean _tmp25_;
					_tmp22_ = tab;
					_tmp23_ = document_tab_get_document (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = main_window_save_document (self, _tmp24_, FALSE);
					if (_tmp25_) {
						break;
					}
					continue;
				} else {
					GtkDialog* _tmp26_;
					_tmp26_ = dialog;
					gtk_widget_destroy ((GtkWidget*) _tmp26_);
					result = FALSE;
					_g_object_unref0 (dialog);
					return result;
				}
			}
		}
		_tmp27_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp27_);
		_g_object_unref0 (dialog);
	}
	_tmp28_ = self->priv->_documents_panel;
	_tmp29_ = tab;
	documents_panel_remove_tab (_tmp28_, _tmp29_);
	result = TRUE;
	return result;
}


static void main_window_sync_name (MainWindow* self, DocumentTab* tab) {
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	MainWindowDocuments* _tmp3_;
	DocumentTab* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab != NULL);
	_tmp0_ = tab;
	_tmp1_ = main_window_get_active_tab (self);
	_tmp2_ = _tmp1_;
	if (_tmp0_ == _tmp2_) {
		main_window_my_set_title (self);
	}
	_tmp3_ = self->priv->_main_window_documents;
	_tmp4_ = tab;
	main_window_documents_update_document_name (_tmp3_, _tmp4_);
}


static void main_window_my_set_title (MainWindow* self) {
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	guint max_title_length = 0U;
	gchar* title = NULL;
	gchar* dirname = NULL;
	GFile* loc = NULL;
	Document* _tmp2_;
	Document* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	const gchar* _tmp31_ = NULL;
	Document* _tmp32_;
	Document* _tmp33_;
	gboolean _tmp34_;
	gchar* _tmp35_ = NULL;
	Document* _tmp36_;
	Document* _tmp37_;
	gboolean _tmp38_;
	gboolean _tmp39_;
	gchar* _tmp44_ = NULL;
	const gchar* _tmp45_;
	const gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		gtk_window_set_title ((GtkWindow*) self, "LaTeXila");
		return;
	}
	max_title_length = (guint) 100;
	title = NULL;
	dirname = NULL;
	_tmp2_ = main_window_get_active_document (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = document_get_location (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	loc = _tmp6_;
	_tmp7_ = loc;
	if (_tmp7_ == NULL) {
		Document* _tmp8_;
		Document* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = main_window_get_active_document (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = document_get_short_name_for_display (_tmp9_);
		_g_free0 (title);
		title = _tmp10_;
	} else {
		gchar* basename = NULL;
		GFile* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		guint _tmp16_;
		_tmp11_ = loc;
		_tmp12_ = g_file_get_basename (_tmp11_);
		basename = _tmp12_;
		_tmp13_ = basename;
		_tmp14_ = strlen (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = max_title_length;
		if (((guint) _tmp15_) > _tmp16_) {
			const gchar* _tmp17_;
			guint _tmp18_;
			gchar* _tmp19_;
			_tmp17_ = basename;
			_tmp18_ = max_title_length;
			_tmp19_ = utils_str_middle_truncate (_tmp17_, _tmp18_);
			_g_free0 (title);
			title = _tmp19_;
		} else {
			const gchar* _tmp20_;
			gchar* _tmp21_;
			GFile* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			guint _tmp25_;
			const gchar* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			glong _tmp29_;
			gchar* _tmp30_;
			_tmp20_ = basename;
			_tmp21_ = g_strdup (_tmp20_);
			_g_free0 (title);
			title = _tmp21_;
			_tmp22_ = loc;
			_tmp23_ = utils_get_dirname_for_display (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = max_title_length;
			_tmp26_ = basename;
			_tmp27_ = strlen (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = MAX ((glong) 20, (glong) (_tmp25_ - _tmp28_));
			_tmp30_ = utils_str_middle_truncate (_tmp24_, (guint) _tmp29_);
			_g_free0 (dirname);
			dirname = _tmp30_;
			_g_free0 (_tmp24_);
		}
		_g_free0 (basename);
	}
	_tmp32_ = main_window_get_active_document (self);
	_tmp33_ = _tmp32_;
	_tmp34_ = gtk_text_buffer_get_modified ((GtkTextBuffer*) _tmp33_);
	if (_tmp34_) {
		_tmp31_ = "*";
	} else {
		_tmp31_ = "";
	}
	_tmp36_ = main_window_get_active_document (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = document_get_readonly (_tmp37_);
	_tmp39_ = _tmp38_;
	if (_tmp39_) {
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		_tmp40_ = g_strconcat (" [", _ ("Read-Only"), NULL);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_strconcat (_tmp41_, "]", NULL);
		_g_free0 (_tmp35_);
		_tmp35_ = _tmp42_;
		_g_free0 (_tmp41_);
	} else {
		gchar* _tmp43_;
		_tmp43_ = g_strdup ("");
		_g_free0 (_tmp35_);
		_tmp35_ = _tmp43_;
	}
	_tmp45_ = dirname;
	if (_tmp45_ != NULL) {
		const gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		_tmp46_ = dirname;
		_tmp47_ = g_strconcat (" (", _tmp46_, NULL);
		_tmp48_ = _tmp47_;
		_tmp49_ = g_strconcat (_tmp48_, ")", NULL);
		_g_free0 (_tmp44_);
		_tmp44_ = _tmp49_;
		_g_free0 (_tmp48_);
	} else {
		gchar* _tmp50_;
		_tmp50_ = g_strdup ("");
		_g_free0 (_tmp44_);
		_tmp44_ = _tmp50_;
	}
	_tmp51_ = title;
	_tmp52_ = g_strconcat (_tmp31_, _tmp51_, NULL);
	_tmp53_ = _tmp52_;
	_tmp54_ = g_strconcat (_tmp53_, _tmp35_, NULL);
	_tmp55_ = _tmp54_;
	_tmp56_ = g_strconcat (_tmp55_, _tmp44_, NULL);
	_tmp57_ = _tmp56_;
	_tmp58_ = g_strconcat (_tmp57_, " - LaTeXila", NULL);
	_tmp59_ = _tmp58_;
	gtk_window_set_title ((GtkWindow*) self, _tmp59_);
	_g_free0 (_tmp59_);
	_g_free0 (_tmp57_);
	_g_free0 (_tmp55_);
	_g_free0 (_tmp53_);
	_g_free0 (_tmp44_);
	_g_free0 (_tmp35_);
	_g_object_unref0 (loc);
	_g_free0 (dirname);
	_g_free0 (title);
}


gboolean main_window_save_document (MainWindow* self, Document* doc, gboolean force_save_as) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	GtkFileChooserDialog* file_chooser = NULL;
	GtkFileChooserDialog* _tmp10_;
	GtkFileChooserDialog* _tmp11_;
	GtkFileChooserDialog* _tmp12_;
	Document* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	const gchar* _tmp28_;
	Document* _tmp31_;
	GFile* _tmp32_;
	GFile* _tmp33_;
	gint response = 0;
	GtkFileChooserDialog* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	GtkFileChooserDialog* _tmp46_;
	gchar* _tmp47_;
	GtkFileChooserDialog* _tmp48_;
	Document* _tmp49_;
	GFile* _tmp50_;
	GFile* _tmp51_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (doc != NULL, FALSE);
	_tmp1_ = force_save_as;
	if (!_tmp1_) {
		Document* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		_tmp2_ = doc;
		_tmp3_ = document_get_location (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Document* _tmp5_;
		Document* _tmp6_;
		Document* _tmp7_;
		Document* _tmp8_;
		_tmp5_ = doc;
		document_save (_tmp5_, TRUE, FALSE);
		_tmp6_ = doc;
		_tmp7_ = main_window_get_active_document (self);
		_tmp8_ = _tmp7_;
		if (_tmp6_ == _tmp8_) {
			MainWindowStructure* _tmp9_;
			_tmp9_ = self->priv->_main_window_structure;
			main_window_structure_refresh (_tmp9_);
		}
		result = TRUE;
		return result;
	}
	_tmp10_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Save File"), (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SAVE, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("_Save"), GTK_RESPONSE_ACCEPT, NULL);
	g_object_ref_sink (_tmp10_);
	file_chooser = _tmp10_;
	_tmp11_ = file_chooser;
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp11_, TRUE);
	_tmp12_ = file_chooser;
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp12_, FALSE);
	_tmp13_ = doc;
	_tmp14_ = document_get_location (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_ == NULL) {
		GtkFileChooserDialog* _tmp16_;
		Document* _tmp17_;
		DocumentTab* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp16_ = file_chooser;
		_tmp17_ = doc;
		_tmp18_ = _tmp17_->tab;
		_tmp19_ = document_tab_get_label_text (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat (_tmp20_, ".tex", NULL);
		_tmp22_ = _tmp21_;
		gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp16_, _tmp22_);
		_g_free0 (_tmp22_);
	} else {
		GtkFileChooserDialog* _tmp23_;
		Document* _tmp24_;
		DocumentTab* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		_tmp23_ = file_chooser;
		_tmp24_ = doc;
		_tmp25_ = _tmp24_->tab;
		_tmp26_ = document_tab_get_label_text (_tmp25_);
		_tmp27_ = _tmp26_;
		gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp23_, _tmp27_);
	}
	_tmp28_ = self->default_location;
	if (_tmp28_ != NULL) {
		GtkFileChooserDialog* _tmp29_;
		const gchar* _tmp30_;
		_tmp29_ = file_chooser;
		_tmp30_ = self->default_location;
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp29_, _tmp30_);
	}
	_tmp31_ = doc;
	_tmp32_ = document_get_location (_tmp31_);
	_tmp33_ = _tmp32_;
	if (_tmp33_ != NULL) {
		{
			GtkFileChooserDialog* _tmp34_;
			Document* _tmp35_;
			GFile* _tmp36_;
			GFile* _tmp37_;
			_tmp34_ = file_chooser;
			_tmp35_ = doc;
			_tmp36_ = document_get_location (_tmp35_);
			_tmp37_ = _tmp36_;
			gtk_file_chooser_set_file ((GtkFileChooser*) _tmp34_, _tmp37_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch35_g_error;
			}
		}
		goto __finally35;
		__catch35_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally35:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp38_ = FALSE;
			_g_object_unref0 (file_chooser);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp38_;
		}
	}
	_tmp39_ = file_chooser;
	_tmp40_ = gtk_dialog_run ((GtkDialog*) _tmp39_);
	response = _tmp40_;
	_tmp41_ = response;
	if (_tmp41_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		Document* _tmp42_;
		GtkFileChooserDialog* _tmp43_;
		GFile* _tmp44_;
		GFile* _tmp45_;
		_tmp42_ = doc;
		_tmp43_ = file_chooser;
		_tmp44_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp43_);
		_tmp45_ = _tmp44_;
		document_set_location (_tmp42_, _tmp45_);
		_g_object_unref0 (_tmp45_);
	}
	_tmp46_ = file_chooser;
	_tmp47_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) _tmp46_);
	_g_free0 (self->default_location);
	self->default_location = _tmp47_;
	_tmp48_ = file_chooser;
	gtk_widget_destroy ((GtkWidget*) _tmp48_);
	_tmp49_ = doc;
	_tmp50_ = document_get_location (_tmp49_);
	_tmp51_ = _tmp50_;
	if (_tmp51_ != NULL) {
		Document* _tmp52_;
		Document* _tmp53_;
		Document* _tmp54_;
		Document* _tmp55_;
		_tmp52_ = doc;
		document_save (_tmp52_, FALSE, TRUE);
		_tmp53_ = doc;
		_tmp54_ = main_window_get_active_document (self);
		_tmp55_ = _tmp54_;
		if (_tmp53_ == _tmp55_) {
			MainWindowStructure* _tmp56_;
			_tmp56_ = self->priv->_main_window_structure;
			main_window_structure_refresh (_tmp56_);
		}
		result = TRUE;
		_g_object_unref0 (file_chooser);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (file_chooser);
	return result;
}


gboolean main_window_close_all_documents (MainWindow* self) {
	gboolean result = FALSE;
	GeeList* unsaved_documents = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = main_window_get_unsaved_documents (self);
	unsaved_documents = _tmp0_;
	_tmp1_ = unsaved_documents;
	_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		DocumentsPanel* _tmp4_;
		_tmp4_ = self->priv->_documents_panel;
		documents_panel_remove_all_tabs (_tmp4_);
		result = TRUE;
		_g_object_unref0 (unsaved_documents);
		return result;
	} else {
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = unsaved_documents;
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == 1) {
			Document* doc = NULL;
			GeeList* _tmp8_;
			gpointer _tmp9_;
			Document* _tmp10_;
			DocumentTab* _tmp11_;
			Document* _tmp12_;
			DocumentTab* _tmp13_;
			gboolean _tmp14_;
			_tmp8_ = unsaved_documents;
			_tmp9_ = gee_list_first (_tmp8_);
			doc = (Document*) _tmp9_;
			_tmp10_ = doc;
			_tmp11_ = _tmp10_->tab;
			main_window_set_active_tab (self, _tmp11_);
			_tmp12_ = doc;
			_tmp13_ = _tmp12_->tab;
			_tmp14_ = main_window_close_tab (self, _tmp13_, FALSE);
			if (_tmp14_) {
				DocumentsPanel* _tmp15_;
				_tmp15_ = self->priv->_documents_panel;
				documents_panel_remove_all_tabs (_tmp15_);
				result = TRUE;
				_g_object_unref0 (doc);
				_g_object_unref0 (unsaved_documents);
				return result;
			}
			_g_object_unref0 (doc);
		} else {
			GeeList* _tmp16_;
			DocumentsPanel* _tmp17_;
			gint _tmp18_;
			_tmp16_ = unsaved_documents;
			dialogs_close_several_unsaved_documents (self, _tmp16_);
			_tmp17_ = self->priv->_documents_panel;
			_tmp18_ = gtk_notebook_get_n_pages ((GtkNotebook*) _tmp17_);
			if (_tmp18_ == 0) {
				result = TRUE;
				_g_object_unref0 (unsaved_documents);
				return result;
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (unsaved_documents);
	return result;
}


void main_window_remove_all_tabs (MainWindow* self) {
	DocumentsPanel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_documents_panel;
	documents_panel_remove_all_tabs (_tmp0_);
}


static void main_window_update_cursor_position_statusbar (MainWindow* self) {
	GtkTextIter iter = {0};
	Document* _tmp0_;
	Document* _tmp1_;
	Document* _tmp2_;
	Document* _tmp3_;
	GtkTextMark* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	gint row = 0;
	gint _tmp6_;
	gint col = 0;
	DocumentView* _tmp7_;
	DocumentView* _tmp8_;
	GtkTextIter _tmp9_;
	guint _tmp10_;
	CustomStatusbar* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_document (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = main_window_get_active_document (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) _tmp3_);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp1_, &_tmp5_, _tmp4_);
	iter = _tmp5_;
	_tmp6_ = gtk_text_iter_get_line (&iter);
	row = (gint) _tmp6_;
	_tmp7_ = main_window_get_active_view (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = iter;
	_tmp10_ = gtk_source_view_get_visual_column ((GtkSourceView*) _tmp8_, &_tmp9_);
	col = (gint) _tmp10_;
	_tmp11_ = self->priv->_statusbar;
	custom_statusbar_set_cursor_position (_tmp11_, row + 1, col + 1);
}


void main_window_save_state (MainWindow* self) {
	GSettings* settings_window = NULL;
	GSettings* _tmp0_;
	GdkWindowState state = 0;
	GdkWindow* _tmp1_;
	GdkWindowState _tmp2_;
	gint width = 0;
	gint height = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GtkPaned* _tmp5_;
	gint _tmp6_;
	GtkPaned* _tmp7_;
	gint _tmp8_;
	MainWindowStructure* _tmp9_;
	GSettings* settings_ui = NULL;
	GSettings* _tmp10_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp11_;
	GtkAction* _tmp12_;
	GtkToggleAction* _tmp13_;
	GtkToggleAction* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	GtkActionGroup* _tmp17_;
	GtkAction* _tmp18_;
	GtkToggleAction* _tmp19_;
	GtkToggleAction* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	GtkActionGroup* _tmp23_;
	GtkAction* _tmp24_;
	GtkToggleAction* _tmp25_;
	GtkToggleAction* _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	GtkActionGroup* _tmp29_;
	GtkAction* _tmp30_;
	GtkToggleAction* _tmp31_;
	GtkToggleAction* _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	MainWindowBuildTools* _tmp35_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.state.window");
	settings_window = _tmp0_;
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp2_ = gdk_window_get_state (_tmp1_);
	state = _tmp2_;
	g_settings_set_int (settings_window, "state", (gint) state);
	gtk_window_get_size ((GtkWindow*) self, &_tmp3_, &_tmp4_);
	width = _tmp3_;
	height = _tmp4_;
	g_settings_set (settings_window, "size", "(ii)", width, height);
	_tmp5_ = self->priv->_main_hpaned;
	_tmp6_ = gtk_paned_get_position (_tmp5_);
	g_settings_set_int (settings_window, "side-panel-size", _tmp6_);
	_tmp7_ = self->priv->_vpaned;
	_tmp8_ = gtk_paned_get_position (_tmp7_);
	g_settings_set_int (settings_window, "vertical-paned-position", _tmp8_);
	_tmp9_ = self->priv->_main_window_structure;
	main_window_structure_save_state (_tmp9_);
	_tmp10_ = g_settings_new ("org.gnome.latexila.preferences.ui");
	settings_ui = _tmp10_;
	_tmp11_ = self->priv->_action_group;
	_tmp12_ = gtk_action_group_get_action (_tmp11_, "ViewMainToolbar");
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_toggle_action_get_type (), GtkToggleAction));
	action = _tmp13_;
	_tmp14_ = action;
	_tmp15_ = gtk_toggle_action_get_active (_tmp14_);
	_tmp16_ = _tmp15_;
	g_settings_set_boolean (settings_ui, "main-toolbar-visible", _tmp16_);
	_tmp17_ = self->priv->_action_group;
	_tmp18_ = gtk_action_group_get_action (_tmp17_, "ViewEditToolbar");
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_toggle_action_get_type (), GtkToggleAction));
	_g_object_unref0 (action);
	action = _tmp19_;
	_tmp20_ = action;
	_tmp21_ = gtk_toggle_action_get_active (_tmp20_);
	_tmp22_ = _tmp21_;
	g_settings_set_boolean (settings_ui, "edit-toolbar-visible", _tmp22_);
	_tmp23_ = self->priv->_action_group;
	_tmp24_ = gtk_action_group_get_action (_tmp23_, "ViewSidePanel");
	_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_toggle_action_get_type (), GtkToggleAction));
	_g_object_unref0 (action);
	action = _tmp25_;
	_tmp26_ = action;
	_tmp27_ = gtk_toggle_action_get_active (_tmp26_);
	_tmp28_ = _tmp27_;
	g_settings_set_boolean (settings_ui, "side-panel-visible", _tmp28_);
	_tmp29_ = self->priv->_action_group;
	_tmp30_ = gtk_action_group_get_action (_tmp29_, "ViewBottomPanel");
	_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_toggle_action_get_type (), GtkToggleAction));
	_g_object_unref0 (action);
	action = _tmp31_;
	_tmp32_ = action;
	_tmp33_ = gtk_toggle_action_get_active (_tmp32_);
	_tmp34_ = _tmp33_;
	g_settings_set_boolean (settings_ui, "bottom-panel-visible", _tmp34_);
	_tmp35_ = self->priv->_main_window_build_tools;
	main_window_build_tools_save_state (_tmp35_);
	_g_object_unref0 (action);
	_g_object_unref0 (settings_ui);
	_g_object_unref0 (settings_window);
}


void main_window_jump_to_file_position (MainWindow* self, GFile* file, gint start_line, gint end_line) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	DocumentTab* tab = NULL;
	GFile* _tmp3_;
	DocumentTab* _tmp4_;
	DocumentView* _tmp5_;
	DocumentView* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp1_ = start_line;
	if (_tmp1_ >= 0) {
		gint _tmp2_;
		_tmp2_ = end_line;
		_tmp0_ = _tmp2_ >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	g_return_if_fail (_tmp0_);
	_tmp3_ = file;
	_tmp4_ = main_window_open_document (self, _tmp3_, TRUE);
	tab = _tmp4_;
	utils_flush_queue ();
	_tmp5_ = document_tab_get_view (tab);
	_tmp6_ = _tmp5_;
	_tmp7_ = start_line;
	_tmp8_ = end_line;
	gtef_view_select_lines ((GtefView*) _tmp6_, _tmp7_, _tmp8_);
	_g_object_unref0 (tab);
}


/*************************************************************************/
static void main_window_set_file_actions_sensitivity (MainWindow* self, gboolean sensitive) {
	gchar** file_actions = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gint file_actions_length1;
	gint _file_actions_size_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	GtkActionGroup* _tmp17_;
	gboolean _tmp18_;
	MainWindowFile* _tmp19_;
	gboolean _tmp20_;
	MainWindowEdit* _tmp21_;
	MainWindowBuildTools* _tmp22_;
	MainWindowTools* _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("ViewZoomIn");
	_tmp1_ = g_strdup ("ViewZoomOut");
	_tmp2_ = g_strdup ("ViewZoomReset");
	_tmp3_ = g_strdup ("SearchFind");
	_tmp4_ = g_strdup ("SearchReplace");
	_tmp5_ = g_strdup ("SearchGoToLine");
	_tmp6_ = g_strdup ("SearchForward");
	_tmp7_ = g_strdup ("ProjectsConfigCurrent");
	_tmp8_ = g_new0 (gchar*, 8 + 1);
	_tmp8_[0] = _tmp0_;
	_tmp8_[1] = _tmp1_;
	_tmp8_[2] = _tmp2_;
	_tmp8_[3] = _tmp3_;
	_tmp8_[4] = _tmp4_;
	_tmp8_[5] = _tmp5_;
	_tmp8_[6] = _tmp6_;
	_tmp8_[7] = _tmp7_;
	file_actions = _tmp8_;
	file_actions_length1 = 8;
	_file_actions_size_ = file_actions_length1;
	_tmp9_ = file_actions;
	_tmp9__length1 = file_actions_length1;
	{
		gchar** file_action_collection = NULL;
		gint file_action_collection_length1 = 0;
		gint _file_action_collection_size_ = 0;
		gint file_action_it = 0;
		file_action_collection = _tmp9_;
		file_action_collection_length1 = _tmp9__length1;
		for (file_action_it = 0; file_action_it < _tmp9__length1; file_action_it = file_action_it + 1) {
			gchar* _tmp10_;
			gchar* file_action = NULL;
			_tmp10_ = g_strdup (file_action_collection[file_action_it]);
			file_action = _tmp10_;
			{
				GtkAction* action = NULL;
				GtkActionGroup* _tmp11_;
				const gchar* _tmp12_;
				GtkAction* _tmp13_;
				GtkAction* _tmp14_;
				GtkAction* _tmp15_;
				gboolean _tmp16_;
				_tmp11_ = self->priv->_action_group;
				_tmp12_ = file_action;
				_tmp13_ = gtk_action_group_get_action (_tmp11_, _tmp12_);
				_tmp14_ = _g_object_ref0 (_tmp13_);
				action = _tmp14_;
				_tmp15_ = action;
				_tmp16_ = sensitive;
				gtk_action_set_sensitive (_tmp15_, _tmp16_);
				_g_object_unref0 (action);
				_g_free0 (file_action);
			}
		}
	}
	_tmp17_ = self->priv->_latex_action_group;
	_tmp18_ = sensitive;
	gtk_action_group_set_sensitive (_tmp17_, _tmp18_);
	_tmp19_ = self->priv->_main_window_file;
	_tmp20_ = sensitive;
	main_window_file_update_sensitivity (_tmp19_, _tmp20_);
	_tmp21_ = self->priv->_main_window_edit;
	main_window_edit_update_sensitivity (_tmp21_);
	_tmp22_ = self->priv->_main_window_build_tools;
	main_window_build_tools_update_sensitivity (_tmp22_);
	_tmp23_ = self->priv->_main_window_tools;
	main_window_tools_update_sensitivity (_tmp23_);
	file_actions = (_vala_array_free (file_actions, file_actions_length1, (GDestroyNotify) g_free), NULL);
}


void main_window_update_config_project_sensitivity (MainWindow* self) {
	GtkAction* action = NULL;
	GtkActionGroup* _tmp0_;
	GtkAction* _tmp1_;
	GtkAction* _tmp2_;
	gboolean _tmp3_ = FALSE;
	DocumentTab* _tmp4_;
	DocumentTab* _tmp5_;
	GtkAction* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_action_group;
	_tmp1_ = gtk_action_group_get_action (_tmp0_, "ProjectsConfigCurrent");
	_tmp2_ = _g_object_ref0 (_tmp1_);
	action = _tmp2_;
	_tmp4_ = main_window_get_active_tab (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		Document* _tmp6_;
		Document* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp6_ = main_window_get_active_document (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = document_get_project_id (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp3_ = _tmp9_ != -1;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp10_ = action;
	gtk_action_set_sensitive (_tmp10_, _tmp3_);
	_g_object_unref0 (action);
}


static void _vala_array_add7 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gboolean main_window_quit (MainWindow* self) {
	gboolean result = FALSE;
	gchar** list_uris = NULL;
	gchar** _tmp0_;
	gint list_uris_length1;
	gint _list_uris_size_;
	GSettings* settings = NULL;
	GSettings* _tmp19_;
	GSettings* _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gboolean _tmp22_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	list_uris = _tmp0_;
	list_uris_length1 = 0;
	_list_uris_size_ = list_uris_length1;
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp1_;
		gint _doc_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _doc_index = 0;
		_tmp1_ = main_window_get_documents (self);
		_doc_list = _tmp1_;
		_tmp2_ = _doc_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_doc_size = _tmp4_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			Document* doc = NULL;
			GeeList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			Document* _tmp11_;
			GFile* _tmp12_;
			GFile* _tmp13_;
			_tmp5_ = _doc_index;
			_doc_index = _tmp5_ + 1;
			_tmp6_ = _doc_index;
			_tmp7_ = _doc_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _doc_list;
			_tmp9_ = _doc_index;
			_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
			doc = (Document*) _tmp10_;
			_tmp11_ = doc;
			_tmp12_ = document_get_location (_tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_ != NULL) {
				gchar** _tmp14_;
				gint _tmp14__length1;
				Document* _tmp15_;
				GFile* _tmp16_;
				GFile* _tmp17_;
				gchar* _tmp18_;
				_tmp14_ = list_uris;
				_tmp14__length1 = list_uris_length1;
				_tmp15_ = doc;
				_tmp16_ = document_get_location (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_file_get_uri (_tmp17_);
				_vala_array_add7 (&list_uris, &list_uris_length1, &_list_uris_size_, _tmp18_);
			}
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
	_tmp19_ = g_settings_new ("org.gnome.latexila.state.window");
	settings = _tmp19_;
	_tmp20_ = settings;
	_tmp21_ = list_uris;
	_tmp21__length1 = list_uris_length1;
	g_settings_set_strv (_tmp20_, "documents", _tmp21_);
	_tmp22_ = main_window_close_all_documents (self);
	if (_tmp22_) {
		main_window_save_state (self);
		gtk_widget_destroy ((GtkWidget*) self);
		result = TRUE;
		_g_object_unref0 (settings);
		list_uris = (_vala_array_free (list_uris, list_uris_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (settings);
	list_uris = (_vala_array_free (list_uris, list_uris_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


/*************************************************************************/
void main_window_on_quit (MainWindow* self) {
	LatexilaApp* _tmp0_;
	LatexilaApp* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = latexila_app_get_instance ();
	_tmp1_ = _tmp0_;
	g_action_group_activate_action ((GActionGroup*) _tmp1_, "quit", NULL);
	_g_object_unref0 (_tmp1_);
}


void main_window_on_view_zoom_in (MainWindow* self) {
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentView* _tmp2_;
	DocumentView* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = main_window_get_active_view (self);
	_tmp3_ = _tmp2_;
	document_view_enlarge_font (_tmp3_);
}


void main_window_on_view_zoom_out (MainWindow* self) {
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentView* _tmp2_;
	DocumentView* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = main_window_get_active_view (self);
	_tmp3_ = _tmp2_;
	document_view_shrink_font (_tmp3_);
}


void main_window_on_view_zoom_reset (MainWindow* self) {
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentView* _tmp2_;
	DocumentView* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = main_window_get_active_view (self);
	_tmp3_ = _tmp2_;
	document_view_set_font_from_settings (_tmp3_);
}


void main_window_on_search_find (MainWindow* self) {
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	SearchAndReplace* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = self->priv->_search_and_replace;
	search_and_replace_show_search (_tmp2_);
}


void main_window_on_search_replace (MainWindow* self) {
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	SearchAndReplace* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = self->priv->_search_and_replace;
	search_and_replace_show_search_and_replace (_tmp2_);
}


void main_window_on_search_goto_line (MainWindow* self) {
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	GotoLine* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = self->priv->_goto_line;
	goto_line_show (_tmp2_);
}


void main_window_on_search_forward (MainWindow* self) {
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	LatexilaSynctex* synctex = NULL;
	LatexilaSynctex* _tmp2_;
	LatexilaSynctex* _tmp3_;
	Document* _tmp4_;
	Document* _tmp5_;
	Document* _tmp6_;
	Document* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	Document* _tmp10_;
	Document* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = latexila_synctex_get_instance ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	synctex = _tmp3_;
	_tmp4_ = main_window_get_active_document (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = main_window_get_active_document (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = document_get_location (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = main_window_get_active_document (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = document_get_main_file (_tmp11_);
	_tmp13_ = _tmp12_;
	latexila_synctex_forward_search (synctex, (GtkTextBuffer*) _tmp5_, _tmp9_, _tmp13_, (guint) GDK_CURRENT_TIME);
	_g_object_unref0 (_tmp13_);
	_g_object_unref0 (synctex);
}


void main_window_on_projects_new (MainWindow* self) {
	g_return_if_fail (self != NULL);
	project_dialogs_new_project (self);
}


void main_window_on_projects_config_current (MainWindow* self) {
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	Document* _tmp2_;
	Document* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	Document* _tmp6_;
	Document* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = main_window_get_active_document (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = document_get_project_id (_tmp3_);
	_tmp5_ = _tmp4_;
	g_return_if_fail (_tmp5_ != -1);
	_tmp6_ = main_window_get_active_document (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = document_get_project_id (_tmp7_);
	_tmp9_ = _tmp8_;
	project_dialogs_configure_project ((GtkWindow*) self, _tmp9_);
}


void main_window_on_projects_manage (MainWindow* self) {
	g_return_if_fail (self != NULL);
	project_dialogs_manage_projects (self);
}


void main_window_on_help_contents (MainWindow* self) {
	LatexilaApp* _tmp0_;
	LatexilaApp* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = latexila_app_get_instance ();
	_tmp1_ = _tmp0_;
	g_action_group_activate_action ((GActionGroup*) _tmp1_, "help", NULL);
	_g_object_unref0 (_tmp1_);
}


void main_window_on_help_latex_reference (MainWindow* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gchar* uri = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GdkScreen* _tmp4_;
		const gchar* _tmp5_;
		_tmp0_ = g_build_filename (DATA_DIR, "latexhelp.html", NULL, NULL);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_filename_to_uri (_tmp1_, NULL, &_inner_error_);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp1_);
		uri = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch36_g_error;
		}
		_tmp4_ = gtk_window_get_screen ((GtkWindow*) self);
		_tmp5_ = uri;
		gtk_show_uri (_tmp4_, _tmp5_, (guint32) GDK_CURRENT_TIME, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (uri);
			goto __catch36_g_error;
		}
		_g_free0 (uri);
	}
	goto __finally36;
	__catch36_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("main_window.vala:1163: Impossible to open the LaTeX reference: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally36:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void main_window_on_help_finance (MainWindow* self) {
	LatexilaApp* _tmp0_;
	LatexilaApp* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = latexila_app_get_instance ();
	_tmp1_ = _tmp0_;
	g_action_group_activate_action ((GActionGroup*) _tmp1_, "fundraising", NULL);
	_g_object_unref0 (_tmp1_);
}


void main_window_on_about_dialog (MainWindow* self) {
	LatexilaApp* _tmp0_;
	LatexilaApp* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = latexila_app_get_instance ();
	_tmp1_ = _tmp0_;
	g_action_group_activate_action ((GActionGroup*) _tmp1_, "about", NULL);
	_g_object_unref0 (_tmp1_);
}


DocumentTab* main_window_get_active_tab (MainWindow* self) {
	DocumentTab* result;
	gboolean _tmp0_ = FALSE;
	DocumentsPanel* _tmp1_;
	DocumentsPanel* _tmp4_;
	DocumentTab* _tmp5_;
	DocumentTab* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_documents_panel;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		DocumentsPanel* _tmp2_;
		gint _tmp3_;
		_tmp2_ = self->priv->_documents_panel;
		_tmp3_ = gtk_notebook_get_n_pages ((GtkNotebook*) _tmp2_);
		_tmp0_ = _tmp3_ == 0;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp4_ = self->priv->_documents_panel;
	_tmp5_ = documents_panel_get_active_tab (_tmp4_);
	_tmp6_ = _tmp5_;
	result = _tmp6_;
	return result;
}


void main_window_set_active_tab (MainWindow* self, DocumentTab* value) {
	gint n = 0;
	DocumentsPanel* _tmp0_;
	DocumentTab* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_documents_panel;
	_tmp1_ = value;
	_tmp2_ = gtk_notebook_page_num ((GtkNotebook*) _tmp0_, (GtkWidget*) _tmp1_);
	n = _tmp2_;
	_tmp3_ = n;
	if (_tmp3_ != -1) {
		DocumentsPanel* _tmp4_;
		gint _tmp5_;
		_tmp4_ = self->priv->_documents_panel;
		_tmp5_ = n;
		gtk_notebook_set_current_page ((GtkNotebook*) _tmp4_, _tmp5_);
	}
	g_object_notify ((GObject *) self, "active-tab");
}


DocumentView* main_window_get_active_view (MainWindow* self) {
	DocumentView* result;
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	DocumentTab* _tmp3_;
	DocumentView* _tmp4_;
	DocumentView* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = main_window_get_active_tab (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp2_ = main_window_get_active_tab (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = document_tab_get_view (_tmp3_);
	_tmp5_ = _tmp4_;
	result = _tmp5_;
	return result;
}


Document* main_window_get_active_document (MainWindow* self) {
	Document* result;
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	DocumentTab* _tmp3_;
	Document* _tmp4_;
	Document* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = main_window_get_active_tab (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp2_ = main_window_get_active_tab (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = document_tab_get_document (_tmp3_);
	_tmp5_ = _tmp4_;
	result = _tmp5_;
	return result;
}


static void main_window_class_init (MainWindowClass * klass) {
	main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MainWindowPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_main_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_main_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = main_window_finalize;
	/*************************************************************************/
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_WINDOW_ACTIVE_TAB, g_param_spec_object ("active-tab", "active-tab", "active-tab", TYPE_DOCUMENT_TAB, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_WINDOW_ACTIVE_VIEW, g_param_spec_object ("active-view", "active-view", "active-view", TYPE_DOCUMENT_VIEW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_WINDOW_ACTIVE_DOCUMENT, g_param_spec_object ("active-document", "active-document", "active-document", TYPE_DOCUMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void main_window_instance_init (MainWindow * self) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = MAIN_WINDOW_GET_PRIVATE (self);
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	self->default_location = _tmp1_;
}


static void main_window_finalize (GObject * obj) {
	MainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WINDOW, MainWindow);
	_g_free0 (self->default_location);
	_g_object_unref0 (self->priv->_documents_panel);
	_g_object_unref0 (self->priv->_statusbar);
	_g_object_unref0 (self->priv->_goto_line);
	_g_object_unref0 (self->priv->_search_and_replace);
	_g_object_unref0 (self->priv->_main_hpaned);
	_g_object_unref0 (self->priv->_vpaned);
	_g_object_unref0 (self->priv->_ui_manager);
	_g_object_unref0 (self->priv->_action_group);
	_g_object_unref0 (self->priv->_latex_action_group);
	_main_window_file_unref0 (self->priv->_main_window_file);
	_main_window_edit_unref0 (self->priv->_main_window_edit);
	_main_window_build_tools_unref0 (self->priv->_main_window_build_tools);
	_main_window_structure_unref0 (self->priv->_main_window_structure);
	_main_window_documents_unref0 (self->priv->_main_window_documents);
	_main_window_tools_unref0 (self->priv->_main_window_tools);
	G_OBJECT_CLASS (main_window_parent_class)->finalize (obj);
}


GType main_window_get_type (void) {
	static volatile gsize main_window_type_id__volatile = 0;
	if (g_once_init_enter (&main_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindow), 0, (GInstanceInitFunc) main_window_instance_init, NULL };
		GType main_window_type_id;
		main_window_type_id = g_type_register_static (gtk_application_window_get_type (), "MainWindow", &g_define_type_info, 0);
		g_once_init_leave (&main_window_type_id__volatile, main_window_type_id);
	}
	return main_window_type_id__volatile;
}


static void _vala_main_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MAIN_WINDOW, MainWindow);
	switch (property_id) {
		case MAIN_WINDOW_ACTIVE_TAB:
		g_value_set_object (value, main_window_get_active_tab (self));
		break;
		case MAIN_WINDOW_ACTIVE_VIEW:
		g_value_set_object (value, main_window_get_active_view (self));
		break;
		case MAIN_WINDOW_ACTIVE_DOCUMENT:
		g_value_set_object (value, main_window_get_active_document (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_main_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MAIN_WINDOW, MainWindow);
	switch (property_id) {
		case MAIN_WINDOW_ACTIVE_TAB:
		main_window_set_active_tab (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



