/* document_tab.c generated by valac 0.35.2.3-28fcae, the Vala compiler
 * generated from document_tab.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtef/gtef.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include "gedit-close-button.h"
#include <glib/gi18n-lib.h>


#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
typedef struct _DocumentTabPrivate DocumentTabPrivate;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))
typedef struct _Block14Data Block14Data;
enum  {
	DOCUMENT_TAB_CLOSE_DOCUMENT_SIGNAL,
	DOCUMENT_TAB_LAST_SIGNAL
};
static guint document_tab_signals[DOCUMENT_TAB_LAST_SIGNAL] = {0};

struct _DocumentTab {
	GtkGrid parent_instance;
	DocumentTabPrivate * priv;
};

struct _DocumentTabClass {
	GtkGridClass parent_class;
};

struct _DocumentTabPrivate {
	DocumentView* _view;
	Document* _document;
	gboolean ask_if_externally_modified;
	GtkGrid* _label;
	GtkLabel* _label_text;
	GtkLabel* _label_mark;
	guint auto_save_timeout;
	guint _auto_save_interval;
	gboolean _auto_save;
};

struct _Document {
	GtefBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
	guint _unsaved_doc_num;
};

struct _DocumentClass {
	GtefBufferClass parent_class;
};

struct _Project {
	GFile* directory;
	GFile* main_file;
};

struct _Block14Data {
	int _ref_count_;
	DocumentTab* self;
	GtefInfoBar* infobar;
};


static gpointer document_tab_parent_class = NULL;

GType document_tab_get_type (void) G_GNUC_CONST;
GType document_view_get_type (void) G_GNUC_CONST;
GType document_get_type (void) G_GNUC_CONST;
#define DOCUMENT_TAB_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DOCUMENT_TAB, DocumentTabPrivate))
enum  {
	DOCUMENT_TAB_DUMMY_PROPERTY,
	DOCUMENT_TAB_VIEW,
	DOCUMENT_TAB_DOCUMENT,
	DOCUMENT_TAB_LABEL,
	DOCUMENT_TAB_LABEL_TEXT,
	DOCUMENT_TAB_AUTO_SAVE_INTERVAL,
	DOCUMENT_TAB_AUTO_SAVE
};
DocumentTab* document_tab_new (void);
DocumentTab* document_tab_construct (GType object_type);
Document* document_new (void);
Document* document_construct (GType object_type);
static void document_tab_set_document (DocumentTab* self, Document* value);
Document* document_tab_get_document (DocumentTab* self);
DocumentView* document_view_new (Document* doc);
DocumentView* document_view_construct (GType object_type, Document* doc);
static void document_tab_set_view (DocumentTab* self, DocumentView* value);
static void document_tab_initialize (DocumentTab* self);
DocumentTab* document_tab_new_from_location (GFile* location);
DocumentTab* document_tab_construct_from_location (GType object_type, GFile* location);
void document_load (Document* self, GFile* location);
DocumentTab* document_tab_new_with_view (DocumentView* view);
DocumentTab* document_tab_construct_with_view (GType object_type, DocumentView* view);
static void __lambda32_ (DocumentTab* self);
static void document_tab_update_label_text (DocumentTab* self);
static void document_tab_update_label_tooltip (DocumentTab* self);
static void ___lambda32__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _document_tab_update_label_tooltip_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _document_tab_update_label_text_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda33_ (DocumentTab* self, GtkTextBuffer* s);
static void ___lambda33__gtk_text_buffer_modified_changed (GtkTextBuffer* _sender, gpointer self);
DocumentView* document_tab_get_view (DocumentTab* self);
static gboolean document_tab_view_focused_in (DocumentTab* self);
static gboolean _document_tab_view_focused_in_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void __lambda35_ (DocumentTab* self);
static void ___lambda35__gtk_button_clicked (GtkButton* _sender, gpointer self);
void document_tab_set_auto_save (DocumentTab* self, gboolean value);
void document_tab_set_auto_save_interval (DocumentTab* self, guint value);
static gboolean document_tab_install_auto_save_timeout_if_needed (DocumentTab* self);
static void __lambda36_ (DocumentTab* self);
static void ___lambda36__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
GtefInfoBar* document_tab_add_message (DocumentTab* self, const gchar* primary_msg, const gchar* secondary_msg, GtkMessageType msg_type);
gchar* utils_str_middle_truncate (const gchar* str, guint max_length);
gchar* document_get_short_name_for_display (Document* self);
static void document_tab_set_label_text (DocumentTab* self, const gchar* value);
GFile* document_get_location (Document* self);
gchar* document_get_uri_for_display (Document* self);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self, Project* dest);
void project_destroy (Project* self);
Project* document_get_project (Document* self);
static gchar* document_tab_get_main_file_relative_path (DocumentTab* self);
gchar* utils_get_relative_path (GFile* origin, GFile* target, GFile* common_dir);
gchar* document_tab_get_name (DocumentTab* self);
const gchar* document_tab_get_label_text (DocumentTab* self);
gchar* document_tab_get_menu_tip (DocumentTab* self);
gboolean document_is_local (Document* self);
gboolean document_is_externally_modified (Document* self);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static void ___lambda34_ (Block14Data* _data14_, gint response_id);
static void ____lambda34__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self);
static void document_tab_install_auto_save_timeout (DocumentTab* self);
gboolean document_tab_get_auto_save (DocumentTab* self);
guint document_tab_get_auto_save_interval (DocumentTab* self);
static gboolean document_tab_on_auto_save (DocumentTab* self);
static gboolean _document_tab_on_auto_save_gsource_func (gpointer self);
gboolean document_get_readonly (Document* self);
static void document_tab_remove_auto_save_timeout (DocumentTab* self);
void document_save (Document* self, gboolean check_file_changed_on_disk, gboolean force);
GtkGrid* document_tab_get_label (DocumentTab* self);
static void document_tab_finalize (GObject * obj);
static void _vala_document_tab_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_document_tab_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


DocumentTab* document_tab_construct (GType object_type) {
	DocumentTab * self = NULL;
	Document* _tmp0_;
	Document* _tmp1_;
	Document* _tmp2_;
	DocumentView* _tmp3_;
	DocumentView* _tmp4_;
	self = (DocumentTab*) g_object_new (object_type, NULL);
	_tmp0_ = document_new ();
	_tmp1_ = _tmp0_;
	document_tab_set_document (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->_document;
	_tmp3_ = document_view_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	document_tab_set_view (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	document_tab_initialize (self);
	return self;
}


DocumentTab* document_tab_new (void) {
	return document_tab_construct (TYPE_DOCUMENT_TAB);
}


DocumentTab* document_tab_construct_from_location (GType object_type, GFile* location) {
	DocumentTab * self = NULL;
	Document* _tmp0_;
	GFile* _tmp1_;
	g_return_val_if_fail (location != NULL, NULL);
	self = (DocumentTab*) document_tab_construct (object_type);
	_tmp0_ = self->priv->_document;
	_tmp1_ = location;
	document_load (_tmp0_, _tmp1_);
	return self;
}


DocumentTab* document_tab_new_from_location (GFile* location) {
	return document_tab_construct_from_location (TYPE_DOCUMENT_TAB, location);
}


DocumentTab* document_tab_construct_with_view (GType object_type, DocumentView* view) {
	DocumentTab * self = NULL;
	DocumentView* _tmp0_;
	DocumentView* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	g_return_val_if_fail (view != NULL, NULL);
	self = (DocumentTab*) g_object_new (object_type, NULL);
	_tmp0_ = view;
	document_tab_set_view (self, _tmp0_);
	_tmp1_ = view;
	_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp1_);
	_tmp3_ = _tmp2_;
	document_tab_set_document (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DOCUMENT, Document));
	document_tab_initialize (self);
	return self;
}


DocumentTab* document_tab_new_with_view (DocumentView* view) {
	return document_tab_construct_with_view (TYPE_DOCUMENT_TAB, view);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda32_ (DocumentTab* self) {
	document_tab_update_label_text (self);
	document_tab_update_label_tooltip (self);
}


static void ___lambda32__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda32_ ((DocumentTab*) self);
}


static void _document_tab_update_label_tooltip_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	document_tab_update_label_tooltip ((DocumentTab*) self);
}


static void _document_tab_update_label_text_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	document_tab_update_label_text ((DocumentTab*) self);
}


static void __lambda33_ (DocumentTab* self, GtkTextBuffer* s) {
	const gchar* _tmp0_ = NULL;
	Document* _tmp1_;
	gboolean _tmp2_;
	GtkLabel* _tmp3_;
	g_return_if_fail (s != NULL);
	_tmp1_ = self->priv->_document;
	_tmp2_ = gtk_text_buffer_get_modified ((GtkTextBuffer*) _tmp1_);
	if (_tmp2_) {
		_tmp0_ = "*";
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = self->priv->_label_mark;
	gtk_label_set_label (_tmp3_, _tmp0_);
}


static void ___lambda33__gtk_text_buffer_modified_changed (GtkTextBuffer* _sender, gpointer self) {
	__lambda33_ ((DocumentTab*) self, _sender);
}


static gboolean _document_tab_view_focused_in_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = document_tab_view_focused_in ((DocumentTab*) self);
	return result;
}


static void __lambda35_ (DocumentTab* self) {
	g_signal_emit (self, document_tab_signals[DOCUMENT_TAB_CLOSE_DOCUMENT_SIGNAL], 0);
}


static void ___lambda35__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda35_ ((DocumentTab*) self);
}


static void __lambda36_ (DocumentTab* self) {
	guint _tmp0_;
	_tmp0_ = self->priv->auto_save_timeout;
	if (_tmp0_ <= ((guint) 0)) {
		document_tab_install_auto_save_timeout_if_needed (self);
	}
}


static void ___lambda36__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda36_ ((DocumentTab*) self);
}


static void document_tab_initialize (DocumentTab* self) {
	gboolean reparent;
	Document* _tmp0_;
	DocumentTab* _tmp1_;
	Document* _tmp2_;
	DocumentTab* _tmp3_;
	Document* _tmp4_;
	Document* _tmp5_;
	Document* _tmp6_;
	Document* _tmp7_;
	DocumentView* _tmp8_;
	GtkScrolledWindow* sw;
	GtkScrolledWindow* _tmp9_;
	GtkScrolledWindow* _tmp10_;
	gboolean _tmp11_;
	GtkScrolledWindow* _tmp16_;
	GtkScrolledWindow* _tmp17_;
	GtkScrolledWindow* _tmp18_;
	GeditCloseButton* close_button;
	GeditCloseButton* _tmp19_;
	GtkGrid* _tmp20_;
	GtkGrid* _tmp21_;
	GtkGrid* _tmp22_;
	GtkGrid* _tmp23_;
	GtkLabel* _tmp24_;
	GtkLabel* _tmp25_;
	GtkLabel* _tmp26_;
	GtkGrid* _tmp27_;
	GtkLabel* _tmp28_;
	GtkGrid* _tmp29_;
	GtkGrid* _tmp30_;
	GSettings* settings;
	GSettings* _tmp31_;
	gboolean _tmp32_;
	guint tmp = 0U;
	Document* _tmp33_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_document;
	_tmp1_ = _tmp0_->tab;
	reparent = _tmp1_ != NULL;
	_tmp2_ = self->priv->_document;
	_tmp3_ = _g_object_ref0 (self);
	_g_object_unref0 (_tmp2_->tab);
	_tmp2_->tab = _tmp3_;
	_tmp4_ = self->priv->_document;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::location", (GCallback) ___lambda32__g_object_notify, self, 0);
	_tmp5_ = self->priv->_document;
	g_signal_connect_object ((GObject*) _tmp5_, "notify::project-id", (GCallback) _document_tab_update_label_tooltip_g_object_notify, self, 0);
	_tmp6_ = self->priv->_document;
	g_signal_connect_object ((GObject*) _tmp6_, "notify::unsaved-document-n", (GCallback) _document_tab_update_label_text_g_object_notify, self, 0);
	_tmp7_ = self->priv->_document;
	g_signal_connect_object ((GtkTextBuffer*) _tmp7_, "modified-changed", (GCallback) ___lambda33__gtk_text_buffer_modified_changed, self, 0);
	_tmp8_ = self->priv->_view;
	g_signal_connect_object ((GtkWidget*) _tmp8_, "focus-in-event", (GCallback) _document_tab_view_focused_in_gtk_widget_focus_in_event, self, 0);
	_tmp9_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp9_);
	sw = _tmp9_;
	_tmp10_ = sw;
	gtk_scrolled_window_set_overlay_scrolling (_tmp10_, FALSE);
	_tmp11_ = reparent;
	if (_tmp11_) {
		DocumentView* _tmp12_;
		GtkScrolledWindow* _tmp13_;
		_tmp12_ = self->priv->_view;
		_tmp13_ = sw;
		gtk_widget_reparent ((GtkWidget*) _tmp12_, (GtkWidget*) _tmp13_);
	} else {
		GtkScrolledWindow* _tmp14_;
		DocumentView* _tmp15_;
		_tmp14_ = sw;
		_tmp15_ = self->priv->_view;
		gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
	}
	_tmp16_ = sw;
	gtk_widget_show_all ((GtkWidget*) _tmp16_);
	_tmp17_ = sw;
	g_object_set ((GtkWidget*) _tmp17_, "expand", TRUE, NULL);
	_tmp18_ = sw;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp18_, 0, 0, 1, 1);
	document_tab_update_label_text (self);
	_tmp19_ = gedit_close_button_new ();
	g_object_ref_sink (_tmp19_);
	close_button = _tmp19_;
	gtk_widget_set_margin_start ((GtkWidget*) close_button, 2);
	gtk_widget_set_tooltip_text ((GtkWidget*) close_button, _ ("Close document"));
	g_signal_connect_object ((GtkButton*) close_button, "clicked", (GCallback) ___lambda35__gtk_button_clicked, self, 0);
	_tmp20_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->_label);
	self->priv->_label = _tmp20_;
	_tmp21_ = self->priv->_label;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp21_, FALSE);
	_tmp22_ = self->priv->_label;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp22_, GTK_ORIENTATION_HORIZONTAL);
	_tmp23_ = self->priv->_label;
	_tmp24_ = self->priv->_label_mark;
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = self->priv->_label_text;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp25_, TRUE);
	_tmp26_ = self->priv->_label_text;
	gtk_widget_set_halign ((GtkWidget*) _tmp26_, GTK_ALIGN_CENTER);
	_tmp27_ = self->priv->_label;
	_tmp28_ = self->priv->_label_text;
	gtk_container_add ((GtkContainer*) _tmp27_, (GtkWidget*) _tmp28_);
	_tmp29_ = self->priv->_label;
	gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) close_button);
	document_tab_update_label_tooltip (self);
	_tmp30_ = self->priv->_label;
	gtk_widget_show_all ((GtkWidget*) _tmp30_);
	_tmp31_ = g_settings_new ("org.gnome.latexila.preferences.editor");
	settings = _tmp31_;
	_tmp32_ = g_settings_get_boolean (settings, "auto-save");
	document_tab_set_auto_save (self, _tmp32_);
	g_settings_get (settings, "auto-save-interval", "u", &tmp);
	document_tab_set_auto_save_interval (self, tmp);
	document_tab_install_auto_save_timeout_if_needed (self);
	_tmp33_ = self->priv->_document;
	g_signal_connect_object ((GObject*) _tmp33_, "notify::location", (GCallback) ___lambda36__g_object_notify, self, 0);
	_g_object_unref0 (settings);
	_g_object_unref0 (close_button);
	_g_object_unref0 (sw);
}


GtefInfoBar* document_tab_add_message (DocumentTab* self, const gchar* primary_msg, const gchar* secondary_msg, GtkMessageType msg_type) {
	GtefInfoBar* result = NULL;
	GtefInfoBar* infobar;
	GtkMessageType _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GtefInfoBar* _tmp3_;
	GtkWidget* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (primary_msg != NULL, NULL);
	g_return_val_if_fail (secondary_msg != NULL, NULL);
	_tmp0_ = msg_type;
	_tmp1_ = primary_msg;
	_tmp2_ = secondary_msg;
	_tmp3_ = gtef_info_bar_new_simple (_tmp0_, _tmp1_, _tmp2_);
	g_object_ref_sink (_tmp3_);
	infobar = _tmp3_;
	_tmp4_ = gtk_grid_get_child_at ((GtkGrid*) self, 0, 0);
	gtk_grid_attach_next_to ((GtkGrid*) self, (GtkWidget*) infobar, _tmp4_, GTK_POS_TOP, 1, 1);
	gtk_widget_show ((GtkWidget*) infobar);
	result = infobar;
	return result;
}


static void document_tab_update_label_text (DocumentTab* self) {
	Document* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_document;
	_tmp1_ = document_get_short_name_for_display (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = utils_str_middle_truncate (_tmp2_, (guint) 42);
	_tmp4_ = _tmp3_;
	document_tab_set_label_text (self, _tmp4_);
	g_free (_tmp4_);
	g_free (_tmp2_);
}


static void document_tab_update_label_tooltip (DocumentTab* self) {
	Document* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GtkGrid* _tmp4_;
	Document* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	Project* project;
	Document* _tmp8_;
	Project* _tmp9_;
	Project* _tmp10_;
	Project* _tmp11_;
	GFile* _tmp12_;
	Document* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	gboolean _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_document;
	_tmp1_ = document_get_location (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		GtkGrid* _tmp3_;
		_tmp3_ = self->priv->_label;
		gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp3_, "");
		return;
	}
	_tmp4_ = self->priv->_label;
	_tmp5_ = self->priv->_document;
	_tmp6_ = document_get_uri_for_display (_tmp5_);
	_tmp7_ = _tmp6_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp4_, _tmp7_);
	g_free (_tmp7_);
	_tmp8_ = self->priv->_document;
	_tmp9_ = document_get_project (_tmp8_);
	project = _tmp9_;
	_tmp10_ = project;
	if (_tmp10_ == NULL) {
		_project_free0 (project);
		return;
	}
	_tmp11_ = project;
	_tmp12_ = (*_tmp11_).main_file;
	_tmp13_ = self->priv->_document;
	_tmp14_ = document_get_location (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_file_equal (_tmp12_, _tmp15_);
	if (_tmp16_) {
		GtkGrid* _tmp17_;
		GtkGrid* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp17_ = self->priv->_label;
		_tmp18_ = self->priv->_label;
		_tmp19_ = gtk_widget_get_tooltip_markup ((GtkWidget*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat ("\n<b>", _ ("Main File"), NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat (_tmp23_, "</b>", NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strconcat (_tmp21_, _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp18_, _tmp27_);
		g_free (_tmp27_);
		g_free (_tmp25_);
		g_free (_tmp23_);
		g_free (_tmp21_);
	} else {
		GtkGrid* _tmp28_;
		GtkGrid* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		_tmp28_ = self->priv->_label;
		_tmp29_ = self->priv->_label;
		_tmp30_ = gtk_widget_get_tooltip_markup ((GtkWidget*) _tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strconcat ("\n<b>", _ ("Main File:"), NULL);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_strconcat (_tmp34_, "</b> ", NULL);
		_tmp36_ = _tmp35_;
		_tmp37_ = document_tab_get_main_file_relative_path (self);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_strconcat (_tmp36_, _tmp38_, NULL);
		_tmp40_ = _tmp39_;
		_tmp41_ = g_strconcat (_tmp32_, _tmp40_, NULL);
		_tmp42_ = _tmp41_;
		gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp29_, _tmp42_);
		g_free (_tmp42_);
		g_free (_tmp40_);
		g_free (_tmp38_);
		g_free (_tmp36_);
		g_free (_tmp34_);
		g_free (_tmp32_);
	}
	_project_free0 (project);
}


static gchar* document_tab_get_main_file_relative_path (DocumentTab* self) {
	gchar* result = NULL;
	Project* project;
	Document* _tmp0_;
	Project* _tmp1_;
	Project* _tmp2_;
	GFile* origin;
	Document* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* target;
	Project* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	GFile* common_dir;
	Project* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	gchar* _tmp16_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_document;
	_tmp1_ = document_get_project (_tmp0_);
	project = _tmp1_;
	_tmp2_ = project;
	if (_tmp2_ == NULL) {
		result = NULL;
		_project_free0 (project);
		return result;
	}
	_tmp3_ = self->priv->_document;
	_tmp4_ = document_get_location (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	origin = _tmp6_;
	_tmp7_ = project;
	_tmp8_ = (*_tmp7_).main_file;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	target = _tmp9_;
	_tmp10_ = project;
	_tmp11_ = (*_tmp10_).directory;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	common_dir = _tmp12_;
	_tmp13_ = origin;
	_tmp14_ = target;
	_tmp15_ = common_dir;
	_tmp16_ = utils_get_relative_path (_tmp13_, _tmp14_, _tmp15_);
	result = _tmp16_;
	_g_object_unref0 (common_dir);
	_g_object_unref0 (target);
	_g_object_unref0 (origin);
	_project_free0 (project);
	return result;
}


gchar* document_tab_get_name (DocumentTab* self) {
	gchar* result = NULL;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label_mark;
	_tmp1_ = gtk_label_get_label (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = document_tab_get_label_text (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp2_, _tmp4_, NULL);
	result = _tmp5_;
	return result;
}


gchar* document_tab_get_menu_tip (DocumentTab* self) {
	gchar* result = NULL;
	Document* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_document;
	_tmp1_ = document_get_uri_for_display (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf (_ ("Activate '%s'"), _tmp2_);
	_tmp4_ = _tmp3_;
	g_free (_tmp2_);
	result = _tmp4_;
	return result;
}


static Block14Data* block14_data_ref (Block14Data* _data14_) {
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}


static void block14_data_unref (void * _userdata_) {
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		DocumentTab* self;
		self = _data14_->self;
		_g_object_unref0 (_data14_->infobar);
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}


static void ___lambda34_ (Block14Data* _data14_, gint response_id) {
	DocumentTab* self;
	gint _tmp0_;
	GtefInfoBar* _tmp5_;
	DocumentView* _tmp6_;
	self = _data14_->self;
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
		Document* _tmp1_;
		Document* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		_tmp1_ = self->priv->_document;
		_tmp2_ = self->priv->_document;
		_tmp3_ = document_get_location (_tmp2_);
		_tmp4_ = _tmp3_;
		document_load (_tmp1_, _tmp4_);
		self->priv->ask_if_externally_modified = FALSE;
	}
	_tmp5_ = _data14_->infobar;
	gtk_widget_destroy ((GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->_view;
	gtk_widget_grab_focus ((GtkWidget*) _tmp6_);
}


static void ____lambda34__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self) {
	___lambda34_ (self, response_id);
}


static gboolean document_tab_view_focused_in (DocumentTab* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	Document* _tmp1_;
	gboolean _tmp2_;
	Document* _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->ask_if_externally_modified;
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->_document;
	_tmp2_ = document_is_local (_tmp1_);
	if (!_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->_document;
	_tmp4_ = document_is_externally_modified (_tmp3_);
	if (_tmp4_) {
		Block14Data* _data14_;
		gchar* primary_msg;
		Document* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* secondary_msg = NULL;
		Document* _tmp12_;
		gboolean _tmp13_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		GtefInfoBar* _tmp18_;
		GtefInfoBar* _tmp19_;
		GtefInfoBar* _tmp20_;
		GtefInfoBar* _tmp21_;
		_data14_ = g_slice_new0 (Block14Data);
		_data14_->_ref_count_ = 1;
		_data14_->self = g_object_ref (self);
		self->priv->ask_if_externally_modified = TRUE;
		_tmp5_ = self->priv->_document;
		_tmp6_ = document_get_location (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_file_get_parse_name (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup_printf (_ ("The file %s changed on disk."), _tmp9_);
		_tmp11_ = _tmp10_;
		g_free (_tmp9_);
		primary_msg = _tmp11_;
		_tmp12_ = self->priv->_document;
		_tmp13_ = gtk_text_buffer_get_modified ((GtkTextBuffer*) _tmp12_);
		if (_tmp13_) {
			gchar* _tmp14_;
			_tmp14_ = g_strdup (_ ("Do you want to drop your changes and reload the file?"));
			g_free (secondary_msg);
			secondary_msg = _tmp14_;
		} else {
			gchar* _tmp15_;
			_tmp15_ = g_strdup (_ ("Do you want to reload the file?"));
			g_free (secondary_msg);
			secondary_msg = _tmp15_;
		}
		_tmp16_ = primary_msg;
		_tmp17_ = secondary_msg;
		_tmp18_ = document_tab_add_message (self, _tmp16_, _tmp17_, GTK_MESSAGE_WARNING);
		_data14_->infobar = _tmp18_;
		_tmp19_ = _data14_->infobar;
		gtk_info_bar_add_button ((GtkInfoBar*) _tmp19_, _ ("_Reload"), (gint) GTK_RESPONSE_OK);
		_tmp20_ = _data14_->infobar;
		gtk_info_bar_add_button ((GtkInfoBar*) _tmp20_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
		_tmp21_ = _data14_->infobar;
		g_signal_connect_data ((GtkInfoBar*) _tmp21_, "response", (GCallback) ____lambda34__gtk_info_bar_response, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
		g_free (secondary_msg);
		g_free (primary_msg);
		block14_data_unref (_data14_);
		_data14_ = NULL;
	}
	result = FALSE;
	return result;
}


static gboolean _document_tab_on_auto_save_gsource_func (gpointer self) {
	gboolean result;
	result = document_tab_on_auto_save ((DocumentTab*) self);
	return result;
}


static void document_tab_install_auto_save_timeout (DocumentTab* self) {
	guint _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->auto_save_timeout;
	g_return_if_fail (_tmp0_ <= ((guint) 0));
	_tmp1_ = document_tab_get_auto_save (self);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_);
	_tmp3_ = document_tab_get_auto_save_interval (self);
	_tmp4_ = _tmp3_;
	g_return_if_fail (_tmp4_ > ((guint) 0));
	_tmp5_ = document_tab_get_auto_save_interval (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, _tmp6_ * 60, _document_tab_on_auto_save_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->auto_save_timeout = _tmp7_;
}


static gboolean document_tab_install_auto_save_timeout_if_needed (DocumentTab* self) {
	gboolean result = FALSE;
	guint _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->auto_save_timeout;
	g_return_val_if_fail (_tmp0_ <= ((guint) 0), FALSE);
	_tmp3_ = document_tab_get_auto_save (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		Document* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		_tmp5_ = self->priv->_document;
		_tmp6_ = document_get_location (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp2_ = _tmp7_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		Document* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp8_ = self->priv->_document;
		_tmp9_ = document_get_readonly (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp1_ = !_tmp10_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		document_tab_install_auto_save_timeout (self);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void document_tab_remove_auto_save_timeout (DocumentTab* self) {
	guint _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->auto_save_timeout;
	g_return_if_fail (_tmp0_ > ((guint) 0));
	_tmp1_ = self->priv->auto_save_timeout;
	g_source_remove (_tmp1_);
	self->priv->auto_save_timeout = (guint) 0;
}


static gboolean document_tab_on_auto_save (DocumentTab* self) {
	gboolean result = FALSE;
	Document* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	Document* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	guint _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	Document* _tmp11_;
	gboolean _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_document;
	_tmp1_ = document_get_location (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_val_if_fail (_tmp2_ != NULL, FALSE);
	_tmp3_ = self->priv->_document;
	_tmp4_ = document_get_readonly (_tmp3_);
	_tmp5_ = _tmp4_;
	g_return_val_if_fail (!_tmp5_, FALSE);
	_tmp6_ = self->priv->auto_save_timeout;
	g_return_val_if_fail (_tmp6_ > ((guint) 0), FALSE);
	_tmp7_ = document_tab_get_auto_save (self);
	_tmp8_ = _tmp7_;
	g_return_val_if_fail (_tmp8_, FALSE);
	_tmp9_ = document_tab_get_auto_save_interval (self);
	_tmp10_ = _tmp9_;
	g_return_val_if_fail (_tmp10_ > ((guint) 0), FALSE);
	_tmp11_ = self->priv->_document;
	_tmp12_ = gtk_text_buffer_get_modified ((GtkTextBuffer*) _tmp11_);
	if (_tmp12_) {
		Document* _tmp13_;
		_tmp13_ = self->priv->_document;
		document_save (_tmp13_, TRUE, FALSE);
	}
	result = TRUE;
	return result;
}


DocumentView* document_tab_get_view (DocumentTab* self) {
	DocumentView* result;
	DocumentView* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_view;
	result = _tmp0_;
	return result;
}


static void document_tab_set_view (DocumentTab* self, DocumentView* value) {
	g_return_if_fail (self != NULL);
	if (document_tab_get_view (self) != value) {
		DocumentView* _tmp0_;
		DocumentView* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_view);
		self->priv->_view = _tmp1_;
		g_object_notify ((GObject *) self, "view");
	}
}


Document* document_tab_get_document (DocumentTab* self) {
	Document* result;
	Document* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_document;
	result = _tmp0_;
	return result;
}


static void document_tab_set_document (DocumentTab* self, Document* value) {
	g_return_if_fail (self != NULL);
	if (document_tab_get_document (self) != value) {
		Document* _tmp0_;
		Document* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_document);
		self->priv->_document = _tmp1_;
		g_object_notify ((GObject *) self, "document");
	}
}


GtkGrid* document_tab_get_label (DocumentTab* self) {
	GtkGrid* result;
	GtkGrid* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}


const gchar* document_tab_get_label_text (DocumentTab* self) {
	const gchar* result;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label_text;
	_tmp1_ = gtk_label_get_label (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void document_tab_set_label_text (DocumentTab* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, document_tab_get_label_text (self)) != 0) {
		GtkLabel* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = self->priv->_label_text;
		_tmp1_ = value;
		gtk_label_set_label (_tmp0_, _tmp1_);
		g_object_notify ((GObject *) self, "label-text");
	}
}


guint document_tab_get_auto_save_interval (DocumentTab* self) {
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_auto_save_interval;
	result = _tmp0_;
	return result;
}


void document_tab_set_auto_save_interval (DocumentTab* self, guint value) {
	g_return_if_fail (self != NULL);
	if (document_tab_get_auto_save_interval (self) != value) {
		guint _tmp0_;
		guint _tmp1_;
		guint _tmp2_;
		guint _tmp3_;
		gboolean _tmp4_;
		guint _tmp5_;
		_tmp0_ = value;
		g_return_if_fail (_tmp0_ > ((guint) 0));
		_tmp1_ = self->priv->_auto_save_interval;
		_tmp2_ = value;
		if (_tmp1_ == _tmp2_) {
			return;
		}
		_tmp3_ = value;
		self->priv->_auto_save_interval = _tmp3_;
		_tmp4_ = self->priv->_auto_save;
		if (!_tmp4_) {
			return;
		}
		_tmp5_ = self->priv->auto_save_timeout;
		if (_tmp5_ > ((guint) 0)) {
			Document* _tmp6_;
			GFile* _tmp7_;
			GFile* _tmp8_;
			Document* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp6_ = self->priv->_document;
			_tmp7_ = document_get_location (_tmp6_);
			_tmp8_ = _tmp7_;
			g_return_if_fail (_tmp8_ != NULL);
			_tmp9_ = self->priv->_document;
			_tmp10_ = document_get_readonly (_tmp9_);
			_tmp11_ = _tmp10_;
			g_return_if_fail (!_tmp11_);
			document_tab_remove_auto_save_timeout (self);
			document_tab_install_auto_save_timeout (self);
		}
		g_object_notify ((GObject *) self, "auto-save-interval");
	}
}


gboolean document_tab_get_auto_save (DocumentTab* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_auto_save;
	result = _tmp0_;
	return result;
}


void document_tab_set_auto_save (DocumentTab* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (document_tab_get_auto_save (self) != value) {
		gboolean _tmp0_;
		gboolean _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_;
		_tmp0_ = value;
		_tmp1_ = self->priv->_auto_save;
		if (_tmp0_ == _tmp1_) {
			return;
		}
		_tmp2_ = value;
		self->priv->_auto_save = _tmp2_;
		_tmp6_ = self->priv->_auto_save;
		if (_tmp6_) {
			guint _tmp7_;
			_tmp7_ = self->priv->auto_save_timeout;
			_tmp5_ = _tmp7_ <= ((guint) 0);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			Document* _tmp8_;
			GFile* _tmp9_;
			GFile* _tmp10_;
			_tmp8_ = self->priv->_document;
			_tmp9_ = document_get_location (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp4_ = _tmp10_ != NULL;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			Document* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp11_ = self->priv->_document;
			_tmp12_ = document_get_readonly (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp3_ = !_tmp13_;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			document_tab_install_auto_save_timeout (self);
			return;
		}
		_tmp15_ = self->priv->_auto_save;
		if (!_tmp15_) {
			guint _tmp16_;
			_tmp16_ = self->priv->auto_save_timeout;
			_tmp14_ = _tmp16_ > ((guint) 0);
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			document_tab_remove_auto_save_timeout (self);
			return;
		}
		_tmp20_ = self->priv->_auto_save;
		if (!_tmp20_) {
			guint _tmp21_;
			_tmp21_ = self->priv->auto_save_timeout;
			_tmp19_ = _tmp21_ <= ((guint) 0);
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			_tmp18_ = TRUE;
		} else {
			Document* _tmp22_;
			GFile* _tmp23_;
			GFile* _tmp24_;
			_tmp22_ = self->priv->_document;
			_tmp23_ = document_get_location (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp18_ = _tmp24_ == NULL;
		}
		if (_tmp18_) {
			_tmp17_ = TRUE;
		} else {
			Document* _tmp25_;
			gboolean _tmp26_;
			gboolean _tmp27_;
			_tmp25_ = self->priv->_document;
			_tmp26_ = document_get_readonly (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp17_ = _tmp27_;
		}
		g_return_if_fail (_tmp17_);
		g_object_notify ((GObject *) self, "auto-save");
	}
}


static void document_tab_class_init (DocumentTabClass * klass) {
	document_tab_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DocumentTabPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_document_tab_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_document_tab_set_property;
	G_OBJECT_CLASS (klass)->finalize = document_tab_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_TAB_VIEW, g_param_spec_object ("view", "view", "view", TYPE_DOCUMENT_VIEW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_TAB_DOCUMENT, g_param_spec_object ("document", "document", "document", TYPE_DOCUMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_TAB_LABEL, g_param_spec_object ("label", "label", "label", gtk_grid_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_TAB_LABEL_TEXT, g_param_spec_string ("label-text", "label-text", "label-text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_TAB_AUTO_SAVE_INTERVAL, g_param_spec_uint ("auto-save-interval", "auto-save-interval", "auto-save-interval", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_TAB_AUTO_SAVE, g_param_spec_boolean ("auto-save", "auto-save", "auto-save", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	document_tab_signals[DOCUMENT_TAB_CLOSE_DOCUMENT_SIGNAL] = g_signal_new ("close_document", TYPE_DOCUMENT_TAB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void document_tab_instance_init (DocumentTab * self) {
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	self->priv = DOCUMENT_TAB_GET_PRIVATE (self);
	self->priv->ask_if_externally_modified = FALSE;
	_tmp0_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp0_);
	self->priv->_label_text = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp1_);
	self->priv->_label_mark = _tmp1_;
}


static void document_tab_finalize (GObject * obj) {
	DocumentTab * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOCUMENT_TAB, DocumentTab);
	_g_object_unref0 (self->priv->_view);
	_g_object_unref0 (self->priv->_document);
	_g_object_unref0 (self->priv->_label);
	_g_object_unref0 (self->priv->_label_text);
	_g_object_unref0 (self->priv->_label_mark);
	G_OBJECT_CLASS (document_tab_parent_class)->finalize (obj);
}


GType document_tab_get_type (void) {
	static volatile gsize document_tab_type_id__volatile = 0;
	if (g_once_init_enter (&document_tab_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DocumentTabClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_tab_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DocumentTab), 0, (GInstanceInitFunc) document_tab_instance_init, NULL };
		GType document_tab_type_id;
		document_tab_type_id = g_type_register_static (gtk_grid_get_type (), "DocumentTab", &g_define_type_info, 0);
		g_once_init_leave (&document_tab_type_id__volatile, document_tab_type_id);
	}
	return document_tab_type_id__volatile;
}


static void _vala_document_tab_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DocumentTab * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT_TAB, DocumentTab);
	switch (property_id) {
		case DOCUMENT_TAB_VIEW:
		g_value_set_object (value, document_tab_get_view (self));
		break;
		case DOCUMENT_TAB_DOCUMENT:
		g_value_set_object (value, document_tab_get_document (self));
		break;
		case DOCUMENT_TAB_LABEL:
		g_value_set_object (value, document_tab_get_label (self));
		break;
		case DOCUMENT_TAB_LABEL_TEXT:
		g_value_set_string (value, document_tab_get_label_text (self));
		break;
		case DOCUMENT_TAB_AUTO_SAVE_INTERVAL:
		g_value_set_uint (value, document_tab_get_auto_save_interval (self));
		break;
		case DOCUMENT_TAB_AUTO_SAVE:
		g_value_set_boolean (value, document_tab_get_auto_save (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_document_tab_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DocumentTab * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT_TAB, DocumentTab);
	switch (property_id) {
		case DOCUMENT_TAB_VIEW:
		document_tab_set_view (self, g_value_get_object (value));
		break;
		case DOCUMENT_TAB_DOCUMENT:
		document_tab_set_document (self, g_value_get_object (value));
		break;
		case DOCUMENT_TAB_LABEL_TEXT:
		document_tab_set_label_text (self, g_value_get_string (value));
		break;
		case DOCUMENT_TAB_AUTO_SAVE_INTERVAL:
		document_tab_set_auto_save_interval (self, g_value_get_uint (value));
		break;
		case DOCUMENT_TAB_AUTO_SAVE:
		document_tab_set_auto_save (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



