/* templates.c generated by valac 0.20.1.7-00d05, the Vala compiler
 * generated from templates.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include "config.h"


#define TYPE_TEMPLATES (templates_get_type ())
#define TEMPLATES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEMPLATES, Templates))
#define TEMPLATES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEMPLATES, TemplatesClass))
#define IS_TEMPLATES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEMPLATES))
#define IS_TEMPLATES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEMPLATES))
#define TEMPLATES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEMPLATES, TemplatesClass))

typedef struct _Templates Templates;
typedef struct _TemplatesClass TemplatesClass;
typedef struct _TemplatesPrivate TemplatesPrivate;

#define TEMPLATES_TYPE_TEMPLATE_COLUMN (templates_template_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_markup_parse_context_free0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_free (var), NULL)))

struct _Templates {
	GObject parent_instance;
	TemplatesPrivate * priv;
};

struct _TemplatesClass {
	GObjectClass parent_class;
};

struct _TemplatesPrivate {
	GtkListStore* _default_store;
	GtkListStore* _personal_store;
	gint _nb_personal_templates;
	GFile* _data_dir;
	GFile* _rc_file;
	gchar* _default_template;
};

typedef enum  {
	TEMPLATES_TEMPLATE_COLUMN_PIXBUF,
	TEMPLATES_TEMPLATE_COLUMN_ICON_ID,
	TEMPLATES_TEMPLATE_COLUMN_NAME,
	TEMPLATES_TEMPLATE_COLUMN_CONTENTS,
	TEMPLATES_TEMPLATE_COLUMN_N_COLUMNS
} TemplatesTemplateColumn;


static gpointer templates_parent_class = NULL;
static Templates* templates__instance;
static Templates* templates__instance = NULL;

GType templates_get_type (void) G_GNUC_CONST;
#define TEMPLATES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TEMPLATES, TemplatesPrivate))
enum  {
	TEMPLATES_DUMMY_PROPERTY
};
static GType templates_template_column_get_type (void) G_GNUC_UNUSED;
static Templates* templates_new (void);
static Templates* templates_construct (GType object_type);
static void templates_init_default_templates (Templates* self);
static void templates_init_personal_templates (Templates* self);
Templates* templates_get_default (void);
static GtkListStore* templates_create_new_store (Templates* self);
static void templates_add_template_from_string (Templates* self, GtkListStore* store, const gchar* name, const gchar* icon_id, const gchar* contents);
static void templates_add_default_template (Templates* self, const gchar* name, const gchar* icon_id, const gchar* filename);
static GFile* templates_get_personal_template_file (Templates* self, gint template_num);
static gboolean templates_add_template_from_file (Templates* self, GtkListStore* store, const gchar* name, const gchar* icon_id, GFile* file);
gchar* utils_load_file (GFile* file);
static void templates_parser_text (Templates* self, GMarkupParseContext* context, const gchar* text, gsize text_len, GError** error);
static void _templates_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context, const gchar* text, gsize text_len, gpointer self, GError** error);
static gchar* templates_get_theme_icon (Templates* self, const gchar* icon_id);
void templates_delete_personal_template (Templates* self, GtkTreePath* template_path);
void utils_delete_file (GFile* file);
void templates_create_personal_template (Templates* self, const gchar* name, const gchar* icon_id, const gchar* contents);
void templates_save_rc_file (Templates* self);
gboolean utils_save_file (GFile* file, const gchar* contents, gboolean make_backup);
gchar* templates_get_icon_id (Templates* self, GtkTreePath* default_template_path);
gchar* templates_get_default_template_contents (Templates* self, GtkTreePath* path);
static gchar* templates_get_template_contents (Templates* self, GtkListStore* store, GtkTreePath* path);
gchar* templates_get_personal_template_contents (Templates* self, GtkTreePath* path);
GtkTreeView* templates_get_default_templates_list (Templates* self);
static GtkTreeView* templates_get_templates_list (Templates* self, GtkListStore* store);
GtkTreeView* templates_get_personal_templates_list (Templates* self);
static void templates_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static GType templates_template_column_get_type (void) {
	static volatile gsize templates_template_column_type_id__volatile = 0;
	if (g_once_init_enter (&templates_template_column_type_id__volatile)) {
		static const GEnumValue values[] = {{TEMPLATES_TEMPLATE_COLUMN_PIXBUF, "TEMPLATES_TEMPLATE_COLUMN_PIXBUF", "pixbuf"}, {TEMPLATES_TEMPLATE_COLUMN_ICON_ID, "TEMPLATES_TEMPLATE_COLUMN_ICON_ID", "icon-id"}, {TEMPLATES_TEMPLATE_COLUMN_NAME, "TEMPLATES_TEMPLATE_COLUMN_NAME", "name"}, {TEMPLATES_TEMPLATE_COLUMN_CONTENTS, "TEMPLATES_TEMPLATE_COLUMN_CONTENTS", "contents"}, {TEMPLATES_TEMPLATE_COLUMN_N_COLUMNS, "TEMPLATES_TEMPLATE_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType templates_template_column_type_id;
		templates_template_column_type_id = g_enum_register_static ("TemplatesTemplateColumn", values);
		g_once_init_leave (&templates_template_column_type_id__volatile, templates_template_column_type_id);
	}
	return templates_template_column_type_id__volatile;
}


static Templates* templates_construct (GType object_type) {
	Templates * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_;
	GFile* _tmp5_ = NULL;
	self = (Templates*) g_object_new (object_type, NULL);
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "latexila", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	_g_object_unref0 (self->priv->_data_dir);
	self->priv->_data_dir = _tmp3_;
	_g_free0 (_tmp2_);
	_tmp4_ = self->priv->_data_dir;
	_tmp5_ = g_file_get_child (_tmp4_, "templatesrc");
	_g_object_unref0 (self->priv->_rc_file);
	self->priv->_rc_file = _tmp5_;
	templates_init_default_templates (self);
	templates_init_personal_templates (self);
	return self;
}


static Templates* templates_new (void) {
	return templates_construct (TYPE_TEMPLATES);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Templates* templates_get_default (void) {
	Templates* result = NULL;
	Templates* _tmp0_;
	Templates* _tmp2_;
	Templates* _tmp3_;
	_tmp0_ = templates__instance;
	if (_tmp0_ == NULL) {
		Templates* _tmp1_;
		_tmp1_ = templates_new ();
		_g_object_unref0 (templates__instance);
		templates__instance = _tmp1_;
	}
	_tmp2_ = templates__instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static void templates_init_default_templates (Templates* self) {
	GtkListStore* _tmp0_ = NULL;
	GtkListStore* _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = templates_create_new_store (self);
	_g_object_unref0 (self->priv->_default_store);
	self->priv->_default_store = _tmp0_;
	_tmp1_ = self->priv->_default_store;
	_tmp2_ = _ ("Empty");
	templates_add_template_from_string (self, _tmp1_, _tmp2_, "empty", "");
	_tmp3_ = _ ("Article");
	templates_add_default_template (self, _tmp3_, "article", "article.xml");
	_tmp4_ = _ ("Report");
	templates_add_default_template (self, _tmp4_, "report", "report.xml");
	_tmp5_ = _ ("Book");
	templates_add_default_template (self, _tmp5_, "book", "book.xml");
	_tmp6_ = _ ("Letter");
	templates_add_default_template (self, _tmp6_, "letter", "letter.xml");
	_tmp7_ = _ ("Presentation");
	templates_add_default_template (self, _tmp7_, "beamer", "beamer.xml");
}


static void templates_init_personal_templates (Templates* self) {
	GtkListStore* _tmp0_ = NULL;
	GFile* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GKeyFile* _tmp3_;
	GKeyFile* key_file;
	gchar** names = NULL;
	gint names_length1 = 0;
	gint _names_size_ = 0;
	gchar** icons = NULL;
	gint icons_length1 = 0;
	gint _icons_size_ = 0;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gint nb_templates;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = templates_create_new_store (self);
	_g_object_unref0 (self->priv->_personal_store);
	self->priv->_personal_store = _tmp0_;
	self->priv->_nb_personal_templates = 0;
	_tmp1_ = self->priv->_rc_file;
	_tmp2_ = g_file_query_exists (_tmp1_, NULL);
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = g_key_file_new ();
	key_file = _tmp3_;
	{
		GKeyFile* _tmp4_;
		GFile* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		GKeyFile* _tmp8_;
		gsize _tmp9_;
		gchar** _tmp10_ = NULL;
		gchar** _tmp11_;
		gint _tmp11__length1;
		gint __tmp11__size_;
		GKeyFile* _tmp12_;
		gsize _tmp13_;
		gchar** _tmp14_ = NULL;
		gchar** _tmp15_;
		gint _tmp15__length1;
		gint __tmp15__size_;
		_tmp4_ = key_file;
		_tmp5_ = self->priv->_rc_file;
		_tmp6_ = g_file_get_path (_tmp5_);
		_tmp7_ = _tmp6_;
		g_key_file_load_from_file (_tmp4_, _tmp7_, G_KEY_FILE_NONE, &_inner_error_);
		_g_free0 (_tmp7_);
		if (_inner_error_ != NULL) {
			goto __catch64_g_error;
		}
		_tmp8_ = key_file;
		_tmp10_ = g_key_file_get_string_list (_tmp8_, PACKAGE_NAME, "names", &_tmp9_, &_inner_error_);
		_tmp11_ = _tmp10_;
		_tmp11__length1 = _tmp9_;
		__tmp11__size_ = _tmp11__length1;
		if (_inner_error_ != NULL) {
			goto __catch64_g_error;
		}
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
		names = _tmp11_;
		names_length1 = _tmp11__length1;
		_names_size_ = names_length1;
		_tmp12_ = key_file;
		_tmp14_ = g_key_file_get_string_list (_tmp12_, PACKAGE_NAME, "icons", &_tmp13_, &_inner_error_);
		_tmp15_ = _tmp14_;
		_tmp15__length1 = _tmp13_;
		__tmp15__size_ = _tmp15__length1;
		if (_inner_error_ != NULL) {
			goto __catch64_g_error;
		}
		icons = (_vala_array_free (icons, icons_length1, (GDestroyNotify) g_free), NULL);
		icons = _tmp15_;
		icons_length1 = _tmp15__length1;
		_icons_size_ = icons_length1;
	}
	goto __finally64;
	__catch64_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_warning ("templates.vala:108: Load templates failed: %s", _tmp17_);
		_g_error_free0 (e);
		icons = (_vala_array_free (icons, icons_length1, (GDestroyNotify) g_free), NULL);
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
		_g_key_file_unref0 (key_file);
		return;
	}
	__finally64:
	if (_inner_error_ != NULL) {
		icons = (_vala_array_free (icons, icons_length1, (GDestroyNotify) g_free), NULL);
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
		_g_key_file_unref0 (key_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp18_ = names;
	_tmp18__length1 = names_length1;
	_tmp19_ = icons;
	_tmp19__length1 = icons_length1;
	g_return_if_fail (_tmp18__length1 == _tmp19__length1);
	_tmp20_ = names;
	_tmp20__length1 = names_length1;
	nb_templates = _tmp20__length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp21_;
			_tmp21_ = TRUE;
			while (TRUE) {
				gboolean _tmp22_;
				gint _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				GFile* _tmp27_ = NULL;
				GFile* file;
				GFile* _tmp28_;
				gboolean _tmp29_ = FALSE;
				GtkListStore* _tmp33_;
				gchar** _tmp34_;
				gint _tmp34__length1;
				gint _tmp35_;
				const gchar* _tmp36_;
				gchar** _tmp37_;
				gint _tmp37__length1;
				gint _tmp38_;
				const gchar* _tmp39_;
				GFile* _tmp40_;
				gboolean _tmp41_ = FALSE;
				_tmp22_ = _tmp21_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp21_ = FALSE;
				_tmp24_ = i;
				_tmp25_ = nb_templates;
				if (!(_tmp24_ < _tmp25_)) {
					break;
				}
				_tmp26_ = i;
				_tmp27_ = templates_get_personal_template_file (self, _tmp26_);
				file = _tmp27_;
				_tmp28_ = file;
				_tmp29_ = g_file_query_exists (_tmp28_, NULL);
				if (!_tmp29_) {
					gchar** _tmp30_;
					gint _tmp30__length1;
					gint _tmp31_;
					const gchar* _tmp32_;
					_tmp30_ = names;
					_tmp30__length1 = names_length1;
					_tmp31_ = i;
					_tmp32_ = _tmp30_[_tmp31_];
					g_warning ("templates.vala:121: The template '%s' doesn't exist.", _tmp32_);
					_g_object_unref0 (file);
					continue;
				}
				_tmp33_ = self->priv->_personal_store;
				_tmp34_ = names;
				_tmp34__length1 = names_length1;
				_tmp35_ = i;
				_tmp36_ = _tmp34_[_tmp35_];
				_tmp37_ = icons;
				_tmp37__length1 = icons_length1;
				_tmp38_ = i;
				_tmp39_ = _tmp37_[_tmp38_];
				_tmp40_ = file;
				_tmp41_ = templates_add_template_from_file (self, _tmp33_, _tmp36_, _tmp39_, _tmp40_);
				if (_tmp41_) {
					gint _tmp42_;
					_tmp42_ = self->priv->_nb_personal_templates;
					self->priv->_nb_personal_templates = _tmp42_ + 1;
				}
				_g_object_unref0 (file);
			}
		}
	}
	icons = (_vala_array_free (icons, icons_length1, (GDestroyNotify) g_free), NULL);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	_g_key_file_unref0 (key_file);
}


static GtkListStore* templates_create_new_store (Templates* self) {
	GtkListStore* result = NULL;
	GtkListStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_list_store_new ((gint) TEMPLATES_TEMPLATE_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
	result = _tmp0_;
	return result;
}


static GFile* templates_get_personal_template_file (Templates* self, gint template_num) {
	GFile* result = NULL;
	gint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* filename;
	GFile* _tmp2_;
	GFile* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = template_num;
	_tmp1_ = g_strdup_printf ("%d.tex", _tmp0_);
	filename = _tmp1_;
	_tmp2_ = self->priv->_data_dir;
	_tmp3_ = g_file_get_child (_tmp2_, filename);
	result = _tmp3_;
	_g_free0 (filename);
	return result;
}


/*************************************************************************/
static void _templates_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context, const gchar* text, gsize text_len, gpointer self, GError** error) {
	templates_parser_text (self, context, text, text_len, error);
}


static void templates_add_default_template (Templates* self, const gchar* name, const gchar* icon_id, const gchar* filename) {
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* path;
	const gchar* _tmp2_;
	GFile* _tmp3_ = NULL;
	GFile* file;
	GFile* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GFile* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* contents;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GtkListStore* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (icon_id != NULL);
	g_return_if_fail (filename != NULL);
	_tmp0_ = filename;
	_tmp1_ = g_build_filename (DATA_DIR, "templates", _tmp0_, NULL);
	path = _tmp1_;
	_tmp2_ = path;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	file = _tmp3_;
	_tmp4_ = file;
	_tmp5_ = g_file_query_exists (_tmp4_, NULL);
	if (!_tmp5_) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = name;
		_tmp7_ = path;
		g_warning ("templates.vala:162: The default template '%s' doesn't exist. Path: %s", _tmp6_, _tmp7_);
		_g_object_unref0 (file);
		_g_free0 (path);
		return;
	}
	_tmp8_ = file;
	_tmp9_ = utils_load_file (_tmp8_);
	contents = _tmp9_;
	_tmp10_ = contents;
	g_return_if_fail (_tmp10_ != NULL);
	_tmp11_ = g_strdup ("");
	_g_free0 (self->priv->_default_template);
	self->priv->_default_template = _tmp11_;
	{
		GMarkupParser _tmp12_ = {0};
		GMarkupParser parser;
		GMarkupParser _tmp13_;
		GMarkupParseContext* _tmp14_;
		GMarkupParseContext* context;
		GMarkupParseContext* _tmp15_;
		const gchar* _tmp16_;
		_tmp12_.start_element = NULL;
		_tmp12_.end_element = NULL;
		_tmp12_.text = _templates_parser_text_gmarkup_parser_text_func;
		_tmp12_.passthrough = NULL;
		_tmp12_.error = NULL;
		parser = _tmp12_;
		_tmp13_ = parser;
		_tmp14_ = g_markup_parse_context_new (&_tmp13_, 0, self, NULL);
		context = _tmp14_;
		_tmp15_ = context;
		_tmp16_ = contents;
		g_markup_parse_context_parse (_tmp15_, _tmp16_, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_markup_parse_context_free0 (context);
			goto __catch65_g_error;
		}
		_g_markup_parse_context_free0 (context);
	}
	goto __finally65;
	__catch65_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp17_;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = name;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_warning ("templates.vala:181: Impossible to load the default template '%s': %s", _tmp17_, _tmp19_);
		_g_error_free0 (e);
		_g_free0 (contents);
		_g_object_unref0 (file);
		_g_free0 (path);
		return;
	}
	__finally65:
	if (_inner_error_ != NULL) {
		_g_free0 (contents);
		_g_object_unref0 (file);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp20_ = self->priv->_default_store;
	_tmp21_ = name;
	_tmp22_ = icon_id;
	_tmp23_ = self->priv->_default_template;
	templates_add_template_from_string (self, _tmp20_, _tmp21_, _tmp22_, _tmp23_);
	_g_free0 (contents);
	_g_object_unref0 (file);
	_g_free0 (path);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static void templates_parser_text (Templates* self, GMarkupParseContext* context, const gchar* text, gsize text_len, GError** error) {
	gchar* chunk;
	GMarkupParseContext* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar _tmp19_ = '\0';
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (text != NULL);
	chunk = NULL;
	_tmp0_ = context;
	_tmp1_ = g_markup_parse_context_get_element (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("chunk")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp5_ = text;
				_tmp6_ = g_strdup (_tmp5_);
				_g_free0 (chunk);
				chunk = _tmp6_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("translatableChunk")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp7_;
				const gchar* _tmp8_ = NULL;
				gchar* _tmp9_;
				_tmp7_ = text;
				_tmp8_ = _ (_tmp7_);
				_tmp9_ = g_strdup (_tmp8_);
				_g_free0 (chunk);
				chunk = _tmp9_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("babel")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp10_;
				const gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				gchar* translated_text;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp10_ = text;
				_tmp11_ = _ (_tmp10_);
				_tmp12_ = g_strdup (_tmp11_);
				translated_text = _tmp12_;
				_tmp13_ = translated_text;
				_tmp14_ = text;
				if (g_strcmp0 (_tmp13_, _tmp14_) != 0) {
					const gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp15_ = translated_text;
					_tmp16_ = g_strdup (_tmp15_);
					_g_free0 (chunk);
					chunk = _tmp16_;
				}
				_g_free0 (translated_text);
				break;
			}
		}
	}
	_tmp17_ = chunk;
	if (_tmp17_ == NULL) {
		_g_free0 (chunk);
		return;
	}
	_tmp18_ = chunk;
	_tmp19_ = string_get (_tmp18_, (glong) 0);
	if (_tmp19_ == '\n') {
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gchar* _tmp24_ = NULL;
		_tmp20_ = chunk;
		_tmp21_ = chunk;
		_tmp22_ = strlen (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = string_slice (_tmp20_, (glong) 1, (glong) _tmp23_);
		_g_free0 (chunk);
		chunk = _tmp24_;
	}
	_tmp25_ = self->priv->_default_template;
	_tmp26_ = chunk;
	_tmp27_ = g_strconcat (_tmp25_, _tmp26_, NULL);
	_g_free0 (self->priv->_default_template);
	self->priv->_default_template = _tmp27_;
	_g_free0 (chunk);
}


/*************************************************************************/
static void templates_add_template_from_string (Templates* self, GtkListStore* store, const gchar* name, const gchar* icon_id, const gchar* contents) {
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (icon_id != NULL);
	g_return_if_fail (contents != NULL);
	_tmp0_ = store;
	gtk_list_store_append (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = store;
	_tmp3_ = iter;
	_tmp4_ = icon_id;
	_tmp5_ = templates_get_theme_icon (self, _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = icon_id;
	_tmp8_ = name;
	_tmp9_ = contents;
	gtk_list_store_set (_tmp2_, &_tmp3_, TEMPLATES_TEMPLATE_COLUMN_PIXBUF, _tmp6_, TEMPLATES_TEMPLATE_COLUMN_ICON_ID, _tmp7_, TEMPLATES_TEMPLATE_COLUMN_NAME, _tmp8_, TEMPLATES_TEMPLATE_COLUMN_CONTENTS, _tmp9_, -1);
	_g_free0 (_tmp6_);
}


static gboolean templates_add_template_from_file (Templates* self, GtkListStore* store, const gchar* name, const gchar* icon_id, GFile* file) {
	gboolean result = FALSE;
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* contents;
	const gchar* _tmp2_;
	GtkListStore* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (store != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	g_return_val_if_fail (icon_id != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = file;
	_tmp1_ = utils_load_file (_tmp0_);
	contents = _tmp1_;
	_tmp2_ = contents;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_free0 (contents);
		return result;
	}
	_tmp3_ = store;
	_tmp4_ = name;
	_tmp5_ = icon_id;
	_tmp6_ = contents;
	templates_add_template_from_string (self, _tmp3_, _tmp4_, _tmp5_, _tmp6_);
	result = TRUE;
	_g_free0 (contents);
	return result;
}


void templates_delete_personal_template (Templates* self, GtkTreePath* template_path) {
	GtkListStore* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp2_;
	GtkTreePath* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	GtkListStore* _tmp5_;
	GtkTreeIter _tmp6_;
	GtkTreePath* _tmp7_;
	gint _tmp8_ = 0;
	gint* _tmp9_ = NULL;
	gint _tmp10_;
	gint template_num;
	gint _tmp11_;
	GFile* _tmp12_ = NULL;
	GFile* template_file;
	GFile* _tmp13_;
	gint _tmp28_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (template_path != NULL);
	_tmp0_ = self->priv->_personal_store;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GTK_TYPE_TREE_MODEL, GtkTreeModel));
	model = _tmp1_;
	_tmp2_ = model;
	_tmp3_ = template_path;
	gtk_tree_model_get_iter (_tmp2_, &_tmp4_, _tmp3_);
	iter = _tmp4_;
	_tmp5_ = self->priv->_personal_store;
	_tmp6_ = iter;
	gtk_list_store_remove (_tmp5_, &_tmp6_);
	_tmp7_ = template_path;
	_tmp9_ = gtk_tree_path_get_indices_with_depth (_tmp7_, &_tmp8_);
	_tmp10_ = _tmp9_[0];
	template_num = _tmp10_;
	_tmp11_ = template_num;
	_tmp12_ = templates_get_personal_template_file (self, _tmp11_);
	template_file = _tmp12_;
	_tmp13_ = template_file;
	utils_delete_file (_tmp13_);
	{
		gint _tmp14_;
		gint i;
		_tmp14_ = template_num;
		i = _tmp14_ + 1;
		{
			gboolean _tmp15_;
			_tmp15_ = TRUE;
			while (TRUE) {
				gboolean _tmp16_;
				gint _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				GFile* _tmp21_ = NULL;
				GFile* file;
				gint _tmp22_;
				GFile* _tmp23_ = NULL;
				GFile* new_file;
				_tmp16_ = _tmp15_;
				if (!_tmp16_) {
					gint _tmp17_;
					_tmp17_ = i;
					i = _tmp17_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp18_ = i;
				_tmp19_ = self->priv->_nb_personal_templates;
				if (!(_tmp18_ < _tmp19_)) {
					break;
				}
				_tmp20_ = i;
				_tmp21_ = templates_get_personal_template_file (self, _tmp20_);
				file = _tmp21_;
				_tmp22_ = i;
				_tmp23_ = templates_get_personal_template_file (self, _tmp22_ - 1);
				new_file = _tmp23_;
				{
					GFile* _tmp24_;
					GFile* _tmp25_;
					_tmp24_ = file;
					_tmp25_ = new_file;
					g_file_move (_tmp24_, _tmp25_, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch66_g_error;
					}
				}
				goto __finally66;
				__catch66_g_error:
				{
					GError* e = NULL;
					GError* _tmp26_;
					const gchar* _tmp27_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp26_ = e;
					_tmp27_ = _tmp26_->message;
					g_warning ("templates.vala:275: Delete personal template, move file failed: %s", _tmp27_);
					_g_error_free0 (e);
				}
				__finally66:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (new_file);
					_g_object_unref0 (file);
					_g_object_unref0 (template_file);
					_g_object_unref0 (model);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_object_unref0 (new_file);
				_g_object_unref0 (file);
			}
		}
	}
	_tmp28_ = self->priv->_nb_personal_templates;
	self->priv->_nb_personal_templates = _tmp28_ - 1;
	_g_object_unref0 (template_file);
	_g_object_unref0 (model);
}


void templates_create_personal_template (Templates* self, const gchar* name, const gchar* icon_id, const gchar* contents) {
	GtkListStore* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GFile* _tmp6_ = NULL;
	GFile* file;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (icon_id != NULL);
	g_return_if_fail (contents != NULL);
	_tmp0_ = self->priv->_personal_store;
	_tmp1_ = name;
	_tmp2_ = icon_id;
	_tmp3_ = contents;
	templates_add_template_from_string (self, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
	_tmp4_ = self->priv->_nb_personal_templates;
	self->priv->_nb_personal_templates = _tmp4_ + 1;
	templates_save_rc_file (self);
	_tmp5_ = self->priv->_nb_personal_templates;
	_tmp6_ = templates_get_personal_template_file (self, _tmp5_ - 1);
	file = _tmp6_;
	_tmp7_ = contents;
	utils_save_file (file, _tmp7_, FALSE);
	_g_object_unref0 (file);
}


void templates_save_rc_file (Templates* self) {
	gint _tmp0_;
	gint _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** names;
	gint names_length1;
	gint _names_size_;
	gint _tmp4_;
	gchar** _tmp5_ = NULL;
	gchar** icons;
	gint icons_length1;
	gint _icons_size_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp6_;
	GtkTreeModel* _tmp7_;
	GtkTreeModel* model;
	GtkTreeModel* _tmp8_;
	GtkTreeIter _tmp9_ = {0};
	gboolean _tmp10_ = FALSE;
	gboolean valid_iter;
	gint template_num;
	GKeyFile* _tmp21_;
	GKeyFile* key_file;
	GKeyFile* _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	GKeyFile* _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	GKeyFile* _tmp26_;
	gchar* _tmp27_ = NULL;
	gchar* key_file_data;
	GFile* _tmp28_;
	const gchar* _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_nb_personal_templates;
	if (_tmp0_ == 0) {
		GFile* _tmp1_;
		_tmp1_ = self->priv->_rc_file;
		utils_delete_file (_tmp1_);
		return;
	}
	_tmp2_ = self->priv->_nb_personal_templates;
	_tmp3_ = g_new0 (gchar*, _tmp2_ + 1);
	names = _tmp3_;
	names_length1 = _tmp2_;
	_names_size_ = names_length1;
	_tmp4_ = self->priv->_nb_personal_templates;
	_tmp5_ = g_new0 (gchar*, _tmp4_ + 1);
	icons = _tmp5_;
	icons_length1 = _tmp4_;
	_icons_size_ = icons_length1;
	_tmp6_ = self->priv->_personal_store;
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, GTK_TYPE_TREE_MODEL) ? ((GtkTreeModel*) _tmp6_) : NULL);
	model = _tmp7_;
	_tmp8_ = model;
	_tmp10_ = gtk_tree_model_get_iter_first (_tmp8_, &_tmp9_);
	iter = _tmp9_;
	valid_iter = _tmp10_;
	template_num = 0;
	while (TRUE) {
		gboolean _tmp11_;
		GtkTreeModel* _tmp12_;
		GtkTreeIter _tmp13_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		gint _tmp15_;
		gchar** _tmp16_;
		gint _tmp16__length1;
		gint _tmp17_;
		GtkTreeModel* _tmp18_;
		gboolean _tmp19_ = FALSE;
		gint _tmp20_;
		_tmp11_ = valid_iter;
		if (!_tmp11_) {
			break;
		}
		_tmp12_ = model;
		_tmp13_ = iter;
		_tmp14_ = names;
		_tmp14__length1 = names_length1;
		_tmp15_ = template_num;
		_tmp16_ = icons;
		_tmp16__length1 = icons_length1;
		_tmp17_ = template_num;
		gtk_tree_model_get (_tmp12_, &_tmp13_, TEMPLATES_TEMPLATE_COLUMN_NAME, &_tmp14_[_tmp15_], TEMPLATES_TEMPLATE_COLUMN_ICON_ID, &_tmp16_[_tmp17_], -1);
		_tmp18_ = model;
		_tmp19_ = gtk_tree_model_iter_next (_tmp18_, &iter);
		valid_iter = _tmp19_;
		_tmp20_ = template_num;
		template_num = _tmp20_ + 1;
	}
	_tmp21_ = g_key_file_new ();
	key_file = _tmp21_;
	_tmp22_ = key_file;
	_tmp23_ = names;
	_tmp23__length1 = names_length1;
	g_key_file_set_string_list (_tmp22_, PACKAGE_NAME, "names", (const gchar* const*) _tmp23_, _tmp23__length1);
	_tmp24_ = key_file;
	_tmp25_ = icons;
	_tmp25__length1 = icons_length1;
	g_key_file_set_string_list (_tmp24_, PACKAGE_NAME, "icons", (const gchar* const*) _tmp25_, _tmp25__length1);
	_tmp26_ = key_file;
	_tmp27_ = g_key_file_to_data (_tmp26_, NULL, NULL);
	key_file_data = _tmp27_;
	_tmp28_ = self->priv->_rc_file;
	_tmp29_ = key_file_data;
	utils_save_file (_tmp28_, _tmp29_, FALSE);
	_g_free0 (key_file_data);
	_g_key_file_unref0 (key_file);
	_g_object_unref0 (model);
	icons = (_vala_array_free (icons, icons_length1, (GDestroyNotify) g_free), NULL);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
}


static gchar* templates_get_theme_icon (Templates* self, const gchar* icon_id) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (icon_id != NULL, NULL);
	_tmp0_ = icon_id;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("empty")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup ("text-x-preview");
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("article")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("text-x-generic");
				result = _tmp5_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("report")))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("x-office-document");
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("book")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("accessories-dictionary");
				result = _tmp7_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("letter")))) {
		switch (0) {
			default:
			{
				gchar* _tmp8_;
				_tmp8_ = g_strdup ("emblem-mail");
				result = _tmp8_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("beamer")))) {
		switch (0) {
			default:
			{
				gchar* _tmp9_;
				_tmp9_ = g_strdup ("x-office-presentation");
				result = _tmp9_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_return_val_if_reached (NULL);
			}
		}
	}
}


/*************************************************************************/
gchar* templates_get_icon_id (Templates* self, GtkTreePath* default_template_path) {
	gchar* result = NULL;
	GtkListStore* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp2_;
	GtkTreePath* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	gchar* icon_id = NULL;
	GtkTreeModel* _tmp7_;
	GtkTreeIter _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (default_template_path != NULL, NULL);
	_tmp0_ = self->priv->_default_store;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GTK_TYPE_TREE_MODEL) ? ((GtkTreeModel*) _tmp0_) : NULL);
	model = _tmp1_;
	_tmp2_ = model;
	_tmp3_ = default_template_path;
	_tmp5_ = gtk_tree_model_get_iter (_tmp2_, &_tmp4_, _tmp3_);
	iter = _tmp4_;
	if (!_tmp5_) {
		gchar* _tmp6_;
		g_warning ("templates.vala:374: Failed to get template icon id");
		_tmp6_ = g_strdup ("");
		result = _tmp6_;
		_g_object_unref0 (model);
		return result;
	}
	_tmp7_ = model;
	_tmp8_ = iter;
	gtk_tree_model_get (_tmp7_, &_tmp8_, TEMPLATES_TEMPLATE_COLUMN_ICON_ID, &icon_id, -1);
	result = icon_id;
	_g_object_unref0 (model);
	return result;
}


gchar* templates_get_default_template_contents (Templates* self, GtkTreePath* path) {
	gchar* result = NULL;
	GtkListStore* _tmp0_;
	GtkTreePath* _tmp1_;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = self->priv->_default_store;
	_tmp1_ = path;
	_tmp2_ = templates_get_template_contents (self, _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


gchar* templates_get_personal_template_contents (Templates* self, GtkTreePath* path) {
	gchar* result = NULL;
	GtkListStore* _tmp0_;
	GtkTreePath* _tmp1_;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = self->priv->_personal_store;
	_tmp1_ = path;
	_tmp2_ = templates_get_template_contents (self, _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static gchar* templates_get_template_contents (Templates* self, GtkListStore* store, GtkTreePath* path) {
	gchar* result = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* model;
	GtkTreeModel* _tmp2_;
	GtkTreePath* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	gchar* contents = NULL;
	GtkTreeModel* _tmp7_;
	GtkTreeIter _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = store;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GTK_TYPE_TREE_MODEL) ? ((GtkTreeModel*) _tmp0_) : NULL);
	model = _tmp1_;
	_tmp2_ = model;
	_tmp3_ = path;
	_tmp5_ = gtk_tree_model_get_iter (_tmp2_, &_tmp4_, _tmp3_);
	iter = _tmp4_;
	if (!_tmp5_) {
		gchar* _tmp6_;
		g_warning ("templates.vala:400: Failed to get template contents");
		_tmp6_ = g_strdup ("");
		result = _tmp6_;
		_g_object_unref0 (model);
		return result;
	}
	_tmp7_ = model;
	_tmp8_ = iter;
	gtk_tree_model_get (_tmp7_, &_tmp8_, TEMPLATES_TEMPLATE_COLUMN_CONTENTS, &contents, -1);
	result = contents;
	_g_object_unref0 (model);
	return result;
}


/*************************************************************************/
GtkTreeView* templates_get_default_templates_list (Templates* self) {
	GtkTreeView* result = NULL;
	GtkListStore* _tmp0_;
	GtkTreeView* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_store;
	_tmp1_ = templates_get_templates_list (self, _tmp0_);
	result = _tmp1_;
	return result;
}


GtkTreeView* templates_get_personal_templates_list (Templates* self) {
	GtkTreeView* result = NULL;
	GtkListStore* _tmp0_;
	GtkTreeView* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_personal_store;
	_tmp1_ = templates_get_templates_list (self, _tmp0_);
	result = _tmp1_;
	return result;
}


static GtkTreeView* templates_get_templates_list (Templates* self, GtkListStore* store) {
	GtkTreeView* result = NULL;
	GtkListStore* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeView* view;
	GtkTreeSelection* _tmp2_ = NULL;
	GtkTreeSelection* _tmp3_;
	GtkTreeSelection* select;
	GtkCellRendererPixbuf* _tmp4_;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkTreeViewColumn* _tmp5_;
	GtkTreeViewColumn* column;
	GtkTreeViewColumn* _tmp6_;
	GtkCellRendererText* _tmp7_;
	GtkCellRendererText* text_renderer;
	GtkTreeViewColumn* _tmp8_;
	GtkTreeViewColumn* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	_tmp0_ = store;
	_tmp1_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp0_);
	g_object_ref_sink (_tmp1_);
	view = _tmp1_;
	gtk_tree_view_set_headers_visible (view, FALSE);
	g_object_set ((GtkWidget*) view, "expand", TRUE, NULL);
	_tmp2_ = gtk_tree_view_get_selection (view);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	select = _tmp3_;
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	_tmp4_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp4_);
	pixbuf_renderer = _tmp4_;
	g_object_set (pixbuf_renderer, "stock-size", (guint) GTK_ICON_SIZE_BUTTON, NULL);
	_tmp5_ = gtk_tree_view_column_new_with_attributes ("Icon", (GtkCellRenderer*) pixbuf_renderer, "icon-name", TEMPLATES_TEMPLATE_COLUMN_PIXBUF, NULL, NULL);
	g_object_ref_sink (_tmp5_);
	column = _tmp5_;
	_tmp6_ = column;
	gtk_tree_view_append_column (view, _tmp6_);
	_tmp7_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp7_);
	text_renderer = _tmp7_;
	_tmp8_ = gtk_tree_view_column_new_with_attributes ("Name", (GtkCellRenderer*) text_renderer, "text", TEMPLATES_TEMPLATE_COLUMN_NAME, NULL, NULL);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (column);
	column = _tmp8_;
	_tmp9_ = column;
	gtk_tree_view_append_column (view, _tmp9_);
	result = view;
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (column);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (select);
	return result;
}


static void templates_class_init (TemplatesClass * klass) {
	templates_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TemplatesPrivate));
	G_OBJECT_CLASS (klass)->finalize = templates_finalize;
}


static void templates_instance_init (Templates * self) {
	self->priv = TEMPLATES_GET_PRIVATE (self);
}


static void templates_finalize (GObject* obj) {
	Templates * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TEMPLATES, Templates);
	_g_object_unref0 (self->priv->_default_store);
	_g_object_unref0 (self->priv->_personal_store);
	_g_object_unref0 (self->priv->_data_dir);
	_g_object_unref0 (self->priv->_rc_file);
	_g_free0 (self->priv->_default_template);
	G_OBJECT_CLASS (templates_parent_class)->finalize (obj);
}


GType templates_get_type (void) {
	static volatile gsize templates_type_id__volatile = 0;
	if (g_once_init_enter (&templates_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TemplatesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) templates_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Templates), 0, (GInstanceInitFunc) templates_instance_init, NULL };
		GType templates_type_id;
		templates_type_id = g_type_register_static (G_TYPE_OBJECT, "Templates", &g_define_type_info, 0);
		g_once_init_leave (&templates_type_id__volatile, templates_type_id);
	}
	return templates_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



