/* synctex.c generated by valac 0.20.1.7-00d05, the Vala compiler
 * generated from synctex.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */
/* SyncTeX: forward and backward search with evince.*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gtksourceview/gtksource.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>


#define TYPE_EVINCE_DAEMON (evince_daemon_get_type ())
#define EVINCE_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVINCE_DAEMON, EvinceDaemon))
#define IS_EVINCE_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVINCE_DAEMON))
#define EVINCE_DAEMON_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_EVINCE_DAEMON, EvinceDaemonIface))

typedef struct _EvinceDaemon EvinceDaemon;
typedef struct _EvinceDaemonIface EvinceDaemonIface;

#define TYPE_EVINCE_DAEMON_PROXY (evince_daemon_proxy_get_type ())
typedef GDBusProxy EvinceDaemonProxy;
typedef GDBusProxyClass EvinceDaemonProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_EVINCE_APPLICATION (evince_application_get_type ())
#define EVINCE_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVINCE_APPLICATION, EvinceApplication))
#define IS_EVINCE_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVINCE_APPLICATION))
#define EVINCE_APPLICATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_EVINCE_APPLICATION, EvinceApplicationIface))

typedef struct _EvinceApplication EvinceApplication;
typedef struct _EvinceApplicationIface EvinceApplicationIface;

#define TYPE_EVINCE_APPLICATION_PROXY (evince_application_proxy_get_type ())
typedef GDBusProxy EvinceApplicationProxy;
typedef GDBusProxyClass EvinceApplicationProxyClass;

#define TYPE_DOC_POSITION (doc_position_get_type ())
typedef struct _DocPosition DocPosition;

#define TYPE_EVINCE_WINDOW (evince_window_get_type ())
#define EVINCE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVINCE_WINDOW, EvinceWindow))
#define IS_EVINCE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVINCE_WINDOW))
#define EVINCE_WINDOW_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_EVINCE_WINDOW, EvinceWindowIface))

typedef struct _EvinceWindow EvinceWindow;
typedef struct _EvinceWindowIface EvinceWindowIface;

#define TYPE_EVINCE_WINDOW_PROXY (evince_window_proxy_get_type ())
typedef GDBusProxy EvinceWindowProxy;
typedef GDBusProxyClass EvinceWindowProxyClass;

#define TYPE_SYNCTEX (synctex_get_type ())
#define SYNCTEX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYNCTEX, Synctex))
#define SYNCTEX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYNCTEX, SynctexClass))
#define IS_SYNCTEX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYNCTEX))
#define IS_SYNCTEX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYNCTEX))
#define SYNCTEX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYNCTEX, SynctexClass))

typedef struct _Synctex Synctex;
typedef struct _SynctexClass SynctexClass;
typedef struct _SynctexPrivate SynctexPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_LATEXILA (latexila_get_type ())
#define LATEXILA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEXILA, Latexila))
#define LATEXILA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEXILA, LatexilaClass))
#define IS_LATEXILA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEXILA))
#define IS_LATEXILA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEXILA))
#define LATEXILA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEXILA, LatexilaClass))

typedef struct _Latexila Latexila;
typedef struct _LatexilaClass LatexilaClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block33Data Block33Data;

struct _EvinceDaemonIface {
	GTypeInterface parent_iface;
	gchar* (*find_document) (EvinceDaemon* self, const gchar* uri, gboolean spawn, GError** error);
};

struct _EvinceApplicationIface {
	GTypeInterface parent_iface;
	gchar** (*get_window_list) (EvinceApplication* self, int* result_length1, GError** error);
};

struct _DocPosition {
	gint32 line;
	gint32 column;
};

struct _EvinceWindowIface {
	GTypeInterface parent_iface;
	void (*sync_view) (EvinceWindow* self, const gchar* source_file, DocPosition* source_point, guint32 timestamp, GError** error);
};

struct _Synctex {
	GObject parent_instance;
	SynctexPrivate * priv;
};

struct _SynctexClass {
	GObjectClass parent_class;
};

struct _SynctexPrivate {
	GeeHashMap* _ev_windows;
};

struct _Block33Data {
	int _ref_count_;
	Synctex * self;
	gchar* pdf_uri;
};


static gpointer synctex_parent_class = NULL;
static Synctex* synctex__instance;
static Synctex* synctex__instance = NULL;

GType evince_daemon_proxy_get_type (void) G_GNUC_CONST;
guint evince_daemon_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType evince_daemon_get_type (void) G_GNUC_CONST;
gchar* evince_daemon_find_document (EvinceDaemon* self, const gchar* uri, gboolean spawn, GError** error);
static void evince_daemon_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static gchar* evince_daemon_proxy_find_document (EvinceDaemon* self, const gchar* uri, gboolean spawn, GError** error);
static void evince_daemon_proxy_evince_daemon_interface_init (EvinceDaemonIface* iface);
static void _dbus_evince_daemon_find_document (EvinceDaemon* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void evince_daemon_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* evince_daemon_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean evince_daemon_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _evince_daemon_unregister_object (gpointer user_data);
GType evince_application_proxy_get_type (void) G_GNUC_CONST;
guint evince_application_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType evince_application_get_type (void) G_GNUC_CONST;
gchar** evince_application_get_window_list (EvinceApplication* self, int* result_length1, GError** error);
static void evince_application_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static gchar** evince_application_proxy_get_window_list (EvinceApplication* self, int* result_length1, GError** error);
static void evince_application_proxy_evince_application_interface_init (EvinceApplicationIface* iface);
static void _dbus_evince_application_get_window_list (EvinceApplication* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void evince_application_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* evince_application_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean evince_application_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _evince_application_unregister_object (gpointer user_data);
GType doc_position_get_type (void) G_GNUC_CONST;
DocPosition* doc_position_dup (const DocPosition* self);
void doc_position_free (DocPosition* self);
GType evince_window_proxy_get_type (void) G_GNUC_CONST;
guint evince_window_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType evince_window_get_type (void) G_GNUC_CONST;
void evince_window_sync_view (EvinceWindow* self, const gchar* source_file, DocPosition* source_point, guint32 timestamp, GError** error);
static void g_cclosure_user_marshal_VOID__STRING_BOXED_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void evince_window_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_evince_window_sync_source (EvinceWindow* self, GVariant* parameters);
static void _dbus_handle_evince_window_closed (EvinceWindow* self, GVariant* parameters);
static void evince_window_proxy_sync_view (EvinceWindow* self, const gchar* source_file, DocPosition* source_point, guint32 timestamp, GError** error);
static void evince_window_proxy_evince_window_interface_init (EvinceWindowIface* iface);
static void _dbus_evince_window_sync_view (EvinceWindow* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void evince_window_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* evince_window_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean evince_window_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_evince_window_sync_source (GObject* _sender, const gchar* source_file, DocPosition* source_point, guint32 timestamp, gpointer* _data);
static void _dbus_evince_window_closed (GObject* _sender, gpointer* _data);
static void _evince_window_unregister_object (gpointer user_data);
GType synctex_get_type (void) G_GNUC_CONST;
#define SYNCTEX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SYNCTEX, SynctexPrivate))
enum  {
	SYNCTEX_DUMMY_PROPERTY
};
static Synctex* synctex_new (void);
static Synctex* synctex_construct (GType object_type);
Synctex* synctex_get_default (void);
GType document_get_type (void) G_GNUC_CONST;
void synctex_forward_search (Synctex* self, Document* doc);
static gchar* synctex_get_pdf_uri (Synctex* self, Document* doc);
static void synctex_show_warning (Synctex* self, const gchar* message);
gchar* utils_get_shortname (const gchar* path);
static EvinceWindow* synctex_get_evince_window (Synctex* self, const gchar* pdf_uri);
GFile* document_get_location (Document* self);
static void synctex_get_doc_position (Synctex* self, Document* doc, DocPosition* result);
static void synctex_sync_view (Synctex* self, EvinceWindow* window, const gchar* tex_path, DocPosition* pos);
GType latexila_get_type (void) G_GNUC_CONST;
Latexila* latexila_get_instance (void);
GType main_window_get_type (void) G_GNUC_CONST;
GFile* document_get_main_file (Document* self);
gboolean synctex_create_evince_window (Synctex* self, const gchar* pdf_uri);
static void synctex_add_evince_window (Synctex* self, const gchar* pdf_uri, EvinceWindow* window);
static Block33Data* block33_data_ref (Block33Data* _data33_);
static void block33_data_unref (void * _userdata_);
static void __lambda51_ (Synctex* self, const gchar* tex_uri, DocPosition* pos, guint32 timestamp);
void main_window_jump_to_file_position (MainWindow* self, GFile* file, gint start_line, gint end_line);
static void ___lambda51__evince_window_sync_source (EvinceWindow* _sender, const gchar* source_file, DocPosition* source_point, guint32 timestamp, gpointer self);
static void __lambda52_ (Block33Data* _data33_);
static void ___lambda52__evince_window_closed (EvinceWindow* _sender, gpointer self);
static void synctex_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo _evince_daemon_dbus_arg_info_find_document_uri = {-1, "uri", "s"};
static const GDBusArgInfo _evince_daemon_dbus_arg_info_find_document_spawn = {-1, "spawn", "b"};
static const GDBusArgInfo _evince_daemon_dbus_arg_info_find_document_result = {-1, "result", "s"};
static const GDBusArgInfo * const _evince_daemon_dbus_arg_info_find_document_in[] = {&_evince_daemon_dbus_arg_info_find_document_uri, &_evince_daemon_dbus_arg_info_find_document_spawn, NULL};
static const GDBusArgInfo * const _evince_daemon_dbus_arg_info_find_document_out[] = {&_evince_daemon_dbus_arg_info_find_document_result, NULL};
static const GDBusMethodInfo _evince_daemon_dbus_method_info_find_document = {-1, "FindDocument", (GDBusArgInfo **) (&_evince_daemon_dbus_arg_info_find_document_in), (GDBusArgInfo **) (&_evince_daemon_dbus_arg_info_find_document_out)};
static const GDBusMethodInfo * const _evince_daemon_dbus_method_info[] = {&_evince_daemon_dbus_method_info_find_document, NULL};
static const GDBusSignalInfo * const _evince_daemon_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _evince_daemon_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _evince_daemon_dbus_interface_info = {-1, "org.gnome.evince.Daemon", (GDBusMethodInfo **) (&_evince_daemon_dbus_method_info), (GDBusSignalInfo **) (&_evince_daemon_dbus_signal_info), (GDBusPropertyInfo **) (&_evince_daemon_dbus_property_info)};
static const GDBusInterfaceVTable _evince_daemon_dbus_interface_vtable = {evince_daemon_dbus_interface_method_call, evince_daemon_dbus_interface_get_property, evince_daemon_dbus_interface_set_property};
static const GDBusArgInfo _evince_application_dbus_arg_info_get_window_list_result = {-1, "result", "as"};
static const GDBusArgInfo * const _evince_application_dbus_arg_info_get_window_list_in[] = {NULL};
static const GDBusArgInfo * const _evince_application_dbus_arg_info_get_window_list_out[] = {&_evince_application_dbus_arg_info_get_window_list_result, NULL};
static const GDBusMethodInfo _evince_application_dbus_method_info_get_window_list = {-1, "GetWindowList", (GDBusArgInfo **) (&_evince_application_dbus_arg_info_get_window_list_in), (GDBusArgInfo **) (&_evince_application_dbus_arg_info_get_window_list_out)};
static const GDBusMethodInfo * const _evince_application_dbus_method_info[] = {&_evince_application_dbus_method_info_get_window_list, NULL};
static const GDBusSignalInfo * const _evince_application_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _evince_application_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _evince_application_dbus_interface_info = {-1, "org.gnome.evince.Application", (GDBusMethodInfo **) (&_evince_application_dbus_method_info), (GDBusSignalInfo **) (&_evince_application_dbus_signal_info), (GDBusPropertyInfo **) (&_evince_application_dbus_property_info)};
static const GDBusInterfaceVTable _evince_application_dbus_interface_vtable = {evince_application_dbus_interface_method_call, evince_application_dbus_interface_get_property, evince_application_dbus_interface_set_property};
static const GDBusArgInfo _evince_window_dbus_arg_info_sync_view_source_file = {-1, "source_file", "s"};
static const GDBusArgInfo _evince_window_dbus_arg_info_sync_view_source_point = {-1, "source_point", "(ii)"};
static const GDBusArgInfo _evince_window_dbus_arg_info_sync_view_timestamp = {-1, "timestamp", "u"};
static const GDBusArgInfo * const _evince_window_dbus_arg_info_sync_view_in[] = {&_evince_window_dbus_arg_info_sync_view_source_file, &_evince_window_dbus_arg_info_sync_view_source_point, &_evince_window_dbus_arg_info_sync_view_timestamp, NULL};
static const GDBusArgInfo * const _evince_window_dbus_arg_info_sync_view_out[] = {NULL};
static const GDBusMethodInfo _evince_window_dbus_method_info_sync_view = {-1, "SyncView", (GDBusArgInfo **) (&_evince_window_dbus_arg_info_sync_view_in), (GDBusArgInfo **) (&_evince_window_dbus_arg_info_sync_view_out)};
static const GDBusMethodInfo * const _evince_window_dbus_method_info[] = {&_evince_window_dbus_method_info_sync_view, NULL};
static const GDBusArgInfo _evince_window_dbus_arg_info_sync_source_source_file = {-1, "source_file", "s"};
static const GDBusArgInfo _evince_window_dbus_arg_info_sync_source_source_point = {-1, "source_point", "(ii)"};
static const GDBusArgInfo _evince_window_dbus_arg_info_sync_source_timestamp = {-1, "timestamp", "u"};
static const GDBusArgInfo * const _evince_window_dbus_arg_info_sync_source[] = {&_evince_window_dbus_arg_info_sync_source_source_file, &_evince_window_dbus_arg_info_sync_source_source_point, &_evince_window_dbus_arg_info_sync_source_timestamp, NULL};
static const GDBusSignalInfo _evince_window_dbus_signal_info_sync_source = {-1, "SyncSource", (GDBusArgInfo **) (&_evince_window_dbus_arg_info_sync_source)};
static const GDBusArgInfo * const _evince_window_dbus_arg_info_closed[] = {NULL};
static const GDBusSignalInfo _evince_window_dbus_signal_info_closed = {-1, "Closed", (GDBusArgInfo **) (&_evince_window_dbus_arg_info_closed)};
static const GDBusSignalInfo * const _evince_window_dbus_signal_info[] = {&_evince_window_dbus_signal_info_sync_source, &_evince_window_dbus_signal_info_closed, NULL};
static const GDBusPropertyInfo * const _evince_window_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _evince_window_dbus_interface_info = {-1, "org.gnome.evince.Window", (GDBusMethodInfo **) (&_evince_window_dbus_method_info), (GDBusSignalInfo **) (&_evince_window_dbus_signal_info), (GDBusPropertyInfo **) (&_evince_window_dbus_property_info)};
static const GDBusInterfaceVTable _evince_window_dbus_interface_vtable = {evince_window_dbus_interface_method_call, evince_window_dbus_interface_get_property, evince_window_dbus_interface_set_property};

gchar* evince_daemon_find_document (EvinceDaemon* self, const gchar* uri, gboolean spawn, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return EVINCE_DAEMON_GET_INTERFACE (self)->find_document (self, uri, spawn, error);
}


static void evince_daemon_base_init (EvinceDaemonIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType evince_daemon_get_type (void) {
	static volatile gsize evince_daemon_type_id__volatile = 0;
	if (g_once_init_enter (&evince_daemon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EvinceDaemonIface), (GBaseInitFunc) evince_daemon_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType evince_daemon_type_id;
		evince_daemon_type_id = g_type_register_static (G_TYPE_INTERFACE, "EvinceDaemon", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (evince_daemon_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (evince_daemon_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) evince_daemon_proxy_get_type);
		g_type_set_qdata (evince_daemon_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.evince.Daemon");
		g_type_set_qdata (evince_daemon_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) evince_daemon_register_object);
		g_once_init_leave (&evince_daemon_type_id__volatile, evince_daemon_type_id);
	}
	return evince_daemon_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (EvinceDaemonProxy, evince_daemon_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_EVINCE_DAEMON, evince_daemon_proxy_evince_daemon_interface_init) )
static void evince_daemon_proxy_class_init (EvinceDaemonProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = evince_daemon_proxy_g_signal;
}


static void evince_daemon_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void evince_daemon_proxy_init (EvinceDaemonProxy* self) {
}


static gchar* evince_daemon_proxy_find_document (EvinceDaemon* self, const gchar* uri, gboolean spawn, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result;
	GVariant* _tmp0_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.evince.Daemon", "FindDocument");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (uri));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (spawn));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	g_object_unref (_reply_message);
	return _result;
}


static void evince_daemon_proxy_evince_daemon_interface_init (EvinceDaemonIface* iface) {
	iface->find_document = evince_daemon_proxy_find_document;
}


static void _dbus_evince_daemon_find_document (EvinceDaemon* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* uri = NULL;
	GVariant* _tmp1_;
	gboolean spawn = FALSE;
	GVariant* _tmp2_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	uri = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	spawn = g_variant_get_boolean (_tmp2_);
	g_variant_unref (_tmp2_);
	result = evince_daemon_find_document (self, uri, spawn, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (uri);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void evince_daemon_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "FindDocument") == 0) {
		_dbus_evince_daemon_find_document (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* evince_daemon_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean evince_daemon_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint evince_daemon_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_evince_daemon_dbus_interface_info), &_evince_daemon_dbus_interface_vtable, data, _evince_daemon_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _evince_daemon_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


gchar** evince_application_get_window_list (EvinceApplication* self, int* result_length1, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return EVINCE_APPLICATION_GET_INTERFACE (self)->get_window_list (self, result_length1, error);
}


static void evince_application_base_init (EvinceApplicationIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType evince_application_get_type (void) {
	static volatile gsize evince_application_type_id__volatile = 0;
	if (g_once_init_enter (&evince_application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EvinceApplicationIface), (GBaseInitFunc) evince_application_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType evince_application_type_id;
		evince_application_type_id = g_type_register_static (G_TYPE_INTERFACE, "EvinceApplication", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (evince_application_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (evince_application_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) evince_application_proxy_get_type);
		g_type_set_qdata (evince_application_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.evince.Application");
		g_type_set_qdata (evince_application_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) evince_application_register_object);
		g_once_init_leave (&evince_application_type_id__volatile, evince_application_type_id);
	}
	return evince_application_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (EvinceApplicationProxy, evince_application_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_EVINCE_APPLICATION, evince_application_proxy_evince_application_interface_init) )
static void evince_application_proxy_class_init (EvinceApplicationProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = evince_application_proxy_g_signal;
}


static void evince_application_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void evince_application_proxy_init (EvinceApplicationProxy* self) {
}


static gchar** evince_application_proxy_get_window_list (EvinceApplication* self, int* result_length1, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result;
	int _result_length1;
	GVariant* _tmp3_;
	gchar** _tmp4_;
	int _tmp4__length;
	int _tmp4__size;
	int _tmp4__length1;
	GVariantIter _tmp5_;
	GVariant* _tmp6_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.evince.Application", "GetWindowList");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp3_ = g_variant_iter_next_value (&_reply_iter);
	_tmp4_ = g_new (gchar*, 5);
	_tmp4__length = 0;
	_tmp4__size = 4;
	_tmp4__length1 = 0;
	g_variant_iter_init (&_tmp5_, _tmp3_);
	for (; (_tmp6_ = g_variant_iter_next_value (&_tmp5_)) != NULL; _tmp4__length1++) {
		if (_tmp4__size == _tmp4__length) {
			_tmp4__size = 2 * _tmp4__size;
			_tmp4_ = g_renew (gchar*, _tmp4_, _tmp4__size + 1);
		}
		_tmp4_[_tmp4__length++] = g_variant_dup_string (_tmp6_, NULL);
		g_variant_unref (_tmp6_);
	}
	_result_length1 = _tmp4__length1;
	_tmp4_[_tmp4__length] = NULL;
	_result = _tmp4_;
	g_variant_unref (_tmp3_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static void evince_application_proxy_evince_application_interface_init (EvinceApplicationIface* iface) {
	iface->get_window_list = evince_application_proxy_get_window_list;
}


static void _dbus_evince_application_get_window_list (EvinceApplication* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	int result_length1 = 0;
	gchar** _tmp7_;
	GVariantBuilder _tmp8_;
	int _tmp9_;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = evince_application_get_window_list (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp7_ = result;
	g_variant_builder_init (&_tmp8_, G_VARIANT_TYPE ("as"));
	for (_tmp9_ = 0; _tmp9_ < result_length1; _tmp9_++) {
		g_variant_builder_add_value (&_tmp8_, g_variant_new_string (*_tmp7_));
		_tmp7_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp8_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void evince_application_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetWindowList") == 0) {
		_dbus_evince_application_get_window_list (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* evince_application_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean evince_application_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint evince_application_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_evince_application_dbus_interface_info), &_evince_application_dbus_interface_vtable, data, _evince_application_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _evince_application_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


DocPosition* doc_position_dup (const DocPosition* self) {
	DocPosition* dup;
	dup = g_new0 (DocPosition, 1);
	memcpy (dup, self, sizeof (DocPosition));
	return dup;
}


void doc_position_free (DocPosition* self) {
	g_free (self);
}


GType doc_position_get_type (void) {
	static volatile gsize doc_position_type_id__volatile = 0;
	if (g_once_init_enter (&doc_position_type_id__volatile)) {
		GType doc_position_type_id;
		doc_position_type_id = g_boxed_type_register_static ("DocPosition", (GBoxedCopyFunc) doc_position_dup, (GBoxedFreeFunc) doc_position_free);
		g_once_init_leave (&doc_position_type_id__volatile, doc_position_type_id);
	}
	return doc_position_type_id__volatile;
}


void evince_window_sync_view (EvinceWindow* self, const gchar* source_file, DocPosition* source_point, guint32 timestamp, GError** error) {
	g_return_if_fail (self != NULL);
	EVINCE_WINDOW_GET_INTERFACE (self)->sync_view (self, source_file, source_point, timestamp, error);
}


static void g_cclosure_user_marshal_VOID__STRING_BOXED_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_BOXED_UINT) (gpointer data1, const char* arg_1, gpointer arg_2, guint32 arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOXED_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_BOXED_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boxed (param_values + 2), g_value_get_uint (param_values + 3), data2);
}


static void evince_window_base_init (EvinceWindowIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("sync_source", TYPE_EVINCE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOXED_UINT, G_TYPE_NONE, 3, G_TYPE_STRING, TYPE_DOC_POSITION, G_TYPE_UINT);
		g_signal_new ("closed", TYPE_EVINCE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	}
}


GType evince_window_get_type (void) {
	static volatile gsize evince_window_type_id__volatile = 0;
	if (g_once_init_enter (&evince_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EvinceWindowIface), (GBaseInitFunc) evince_window_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType evince_window_type_id;
		evince_window_type_id = g_type_register_static (G_TYPE_INTERFACE, "EvinceWindow", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (evince_window_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (evince_window_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) evince_window_proxy_get_type);
		g_type_set_qdata (evince_window_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.evince.Window");
		g_type_set_qdata (evince_window_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) evince_window_register_object);
		g_once_init_leave (&evince_window_type_id__volatile, evince_window_type_id);
	}
	return evince_window_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (EvinceWindowProxy, evince_window_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_EVINCE_WINDOW, evince_window_proxy_evince_window_interface_init) )
static void evince_window_proxy_class_init (EvinceWindowProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = evince_window_proxy_g_signal;
}


static void _dbus_handle_evince_window_sync_source (EvinceWindow* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* source_file = NULL;
	GVariant* _tmp10_;
	DocPosition source_point = {0};
	GVariant* _tmp11_;
	DocPosition _tmp12_;
	GVariantIter _tmp13_;
	GVariant* _tmp14_;
	GVariant* _tmp15_;
	guint32 timestamp = 0U;
	GVariant* _tmp16_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp10_ = g_variant_iter_next_value (&_arguments_iter);
	source_file = g_variant_dup_string (_tmp10_, NULL);
	g_variant_unref (_tmp10_);
	_tmp11_ = g_variant_iter_next_value (&_arguments_iter);
	g_variant_iter_init (&_tmp13_, _tmp11_);
	_tmp14_ = g_variant_iter_next_value (&_tmp13_);
	_tmp12_.line = g_variant_get_int32 (_tmp14_);
	g_variant_unref (_tmp14_);
	_tmp15_ = g_variant_iter_next_value (&_tmp13_);
	_tmp12_.column = g_variant_get_int32 (_tmp15_);
	g_variant_unref (_tmp15_);
	source_point = _tmp12_;
	g_variant_unref (_tmp11_);
	_tmp16_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp16_);
	g_variant_unref (_tmp16_);
	g_signal_emit_by_name (self, "sync-source", source_file, &source_point, timestamp);
	_g_free0 (source_file);
}


static void _dbus_handle_evince_window_closed (EvinceWindow* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "closed");
}


static void evince_window_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "SyncSource") == 0) {
		_dbus_handle_evince_window_sync_source ((EvinceWindow*) proxy, parameters);
	} else if (strcmp (signal_name, "Closed") == 0) {
		_dbus_handle_evince_window_closed ((EvinceWindow*) proxy, parameters);
	}
}


static void evince_window_proxy_init (EvinceWindowProxy* self) {
}


static void evince_window_proxy_sync_view (EvinceWindow* self, const gchar* source_file, DocPosition* source_point, guint32 timestamp, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp17_;
	GDBusMessage *_reply_message;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.evince.Window", "SyncView");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (source_file));
	g_variant_builder_init (&_tmp17_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp17_, g_variant_new_int32 ((*source_point).line));
	g_variant_builder_add_value (&_tmp17_, g_variant_new_int32 ((*source_point).column));
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp17_));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (timestamp));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void evince_window_proxy_evince_window_interface_init (EvinceWindowIface* iface) {
	iface->sync_view = evince_window_proxy_sync_view;
}


static void _dbus_evince_window_sync_view (EvinceWindow* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* source_file = NULL;
	GVariant* _tmp18_;
	DocPosition source_point = {0};
	GVariant* _tmp19_;
	DocPosition _tmp20_;
	GVariantIter _tmp21_;
	GVariant* _tmp22_;
	GVariant* _tmp23_;
	guint32 timestamp = 0U;
	GVariant* _tmp24_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp18_ = g_variant_iter_next_value (&_arguments_iter);
	source_file = g_variant_dup_string (_tmp18_, NULL);
	g_variant_unref (_tmp18_);
	_tmp19_ = g_variant_iter_next_value (&_arguments_iter);
	g_variant_iter_init (&_tmp21_, _tmp19_);
	_tmp22_ = g_variant_iter_next_value (&_tmp21_);
	_tmp20_.line = g_variant_get_int32 (_tmp22_);
	g_variant_unref (_tmp22_);
	_tmp23_ = g_variant_iter_next_value (&_tmp21_);
	_tmp20_.column = g_variant_get_int32 (_tmp23_);
	g_variant_unref (_tmp23_);
	source_point = _tmp20_;
	g_variant_unref (_tmp19_);
	_tmp24_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp24_);
	g_variant_unref (_tmp24_);
	evince_window_sync_view (self, source_file, &source_point, timestamp, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (source_file);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void evince_window_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "SyncView") == 0) {
		_dbus_evince_window_sync_view (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* evince_window_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean evince_window_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_evince_window_sync_source (GObject* _sender, const gchar* source_file, DocPosition* source_point, guint32 timestamp, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp25_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (source_file));
	g_variant_builder_init (&_tmp25_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp25_, g_variant_new_int32 ((*source_point).line));
	g_variant_builder_add_value (&_tmp25_, g_variant_new_int32 ((*source_point).column));
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp25_));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (timestamp));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.evince.Window", "SyncSource", _arguments, NULL);
}


static void _dbus_evince_window_closed (GObject* _sender, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.evince.Window", "Closed", _arguments, NULL);
}


guint evince_window_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_evince_window_dbus_interface_info), &_evince_window_dbus_interface_vtable, data, _evince_window_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "sync-source", (GCallback) _dbus_evince_window_sync_source, data);
	g_signal_connect (object, "closed", (GCallback) _dbus_evince_window_closed, data);
	return result;
}


static void _evince_window_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_evince_window_sync_source, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_evince_window_closed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static Synctex* synctex_construct (GType object_type) {
	Synctex * self = NULL;
	GeeHashMap* _tmp0_;
	self = (Synctex*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TYPE_EVINCE_WINDOW, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_ev_windows);
	self->priv->_ev_windows = _tmp0_;
	return self;
}


static Synctex* synctex_new (void) {
	return synctex_construct (TYPE_SYNCTEX);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Synctex* synctex_get_default (void) {
	Synctex* result = NULL;
	Synctex* _tmp0_;
	Synctex* _tmp2_;
	Synctex* _tmp3_;
	_tmp0_ = synctex__instance;
	if (_tmp0_ == NULL) {
		Synctex* _tmp1_;
		_tmp1_ = synctex_new ();
		_g_object_unref0 (synctex__instance);
		synctex__instance = _tmp1_;
	}
	_tmp2_ = synctex__instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


void synctex_forward_search (Synctex* self, Document* doc) {
	Document* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* pdf_uri;
	const gchar* _tmp2_;
	const gchar* _tmp4_;
	GFile* _tmp5_ = NULL;
	GFile* pdf_file;
	GFile* _tmp6_;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* synctex_uri;
	const gchar* _tmp14_;
	GFile* _tmp15_ = NULL;
	GFile* synctex_file;
	GFile* _tmp16_;
	gboolean _tmp17_ = FALSE;
	const gchar* _tmp24_;
	EvinceWindow* _tmp25_ = NULL;
	EvinceWindow* ev_window;
	EvinceWindow* _tmp26_;
	Document* _tmp28_;
	GFile* _tmp29_;
	GFile* _tmp30_;
	gchar* _tmp31_ = NULL;
	gchar* tex_path;
	Document* _tmp32_;
	DocPosition _tmp33_ = {0};
	DocPosition pos;
	EvinceWindow* _tmp34_;
	const gchar* _tmp35_;
	DocPosition _tmp36_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	_tmp0_ = doc;
	_tmp1_ = synctex_get_pdf_uri (self, _tmp0_);
	pdf_uri = _tmp1_;
	_tmp2_ = pdf_uri;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = _ ("The document is not saved.");
		synctex_show_warning (self, _tmp3_);
		_g_free0 (pdf_uri);
		return;
	}
	_tmp4_ = pdf_uri;
	_tmp5_ = g_file_new_for_uri (_tmp4_);
	pdf_file = _tmp5_;
	_tmp6_ = pdf_file;
	_tmp7_ = g_file_query_exists (_tmp6_, NULL);
	if (!_tmp7_) {
		const gchar* _tmp8_ = NULL;
		_tmp8_ = _ ("The PDF file doesn't exist.");
		synctex_show_warning (self, _tmp8_);
		_g_object_unref0 (pdf_file);
		_g_free0 (pdf_uri);
		return;
	}
	_tmp9_ = pdf_uri;
	_tmp10_ = utils_get_shortname (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, ".synctex.gz", NULL);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	synctex_uri = _tmp13_;
	_tmp14_ = synctex_uri;
	_tmp15_ = g_file_new_for_uri (_tmp14_);
	synctex_file = _tmp15_;
	_tmp16_ = synctex_file;
	_tmp17_ = g_file_query_exists (_tmp16_, NULL);
	if (!_tmp17_) {
		GFile* _tmp18_;
		gchar* _tmp19_ = NULL;
		gchar* synctex_basename;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		_tmp18_ = synctex_file;
		_tmp19_ = g_file_get_basename (_tmp18_);
		synctex_basename = _tmp19_;
		_tmp20_ = _ ("The file \"%s\" doesn't exist.");
		_tmp21_ = synctex_basename;
		_tmp22_ = g_strdup_printf (_tmp20_, _tmp21_);
		_tmp23_ = _tmp22_;
		synctex_show_warning (self, _tmp23_);
		_g_free0 (_tmp23_);
		_g_free0 (synctex_basename);
		_g_object_unref0 (synctex_file);
		_g_free0 (synctex_uri);
		_g_object_unref0 (pdf_file);
		_g_free0 (pdf_uri);
		return;
	}
	_tmp24_ = pdf_uri;
	_tmp25_ = synctex_get_evince_window (self, _tmp24_);
	ev_window = _tmp25_;
	_tmp26_ = ev_window;
	if (_tmp26_ == NULL) {
		const gchar* _tmp27_ = NULL;
		_tmp27_ = _ ("Can not communicate with evince.");
		synctex_show_warning (self, _tmp27_);
		_g_object_unref0 (ev_window);
		_g_object_unref0 (synctex_file);
		_g_free0 (synctex_uri);
		_g_object_unref0 (pdf_file);
		_g_free0 (pdf_uri);
		return;
	}
	_tmp28_ = doc;
	_tmp29_ = document_get_location (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_file_get_path (_tmp30_);
	tex_path = _tmp31_;
	_tmp32_ = doc;
	synctex_get_doc_position (self, _tmp32_, &_tmp33_);
	pos = _tmp33_;
	_tmp34_ = ev_window;
	_tmp35_ = tex_path;
	_tmp36_ = pos;
	synctex_sync_view (self, _tmp34_, _tmp35_, &_tmp36_);
	_g_free0 (tex_path);
	_g_object_unref0 (ev_window);
	_g_object_unref0 (synctex_file);
	_g_free0 (synctex_uri);
	_g_object_unref0 (pdf_file);
	_g_free0 (pdf_uri);
}


static void synctex_show_warning (Synctex* self, const gchar* message) {
	Latexila* _tmp0_ = NULL;
	Latexila* _tmp1_;
	GtkWindow* _tmp2_;
	GtkWindow* _tmp3_;
	MainWindow* _tmp4_;
	MainWindow* _tmp5_;
	MainWindow* main_window;
	const gchar* _tmp6_ = NULL;
	GtkMessageDialog* _tmp7_;
	GtkMessageDialog* dialog;
	const gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = latexila_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_application_get_active_window ((GtkApplication*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_MAIN_WINDOW) ? ((MainWindow*) _tmp3_) : NULL);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp1_);
	main_window = _tmp5_;
	_tmp6_ = _ ("Impossible to do the forward search.");
	_tmp7_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) main_window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", _tmp6_);
	g_object_ref_sink (_tmp7_);
	dialog = _tmp7_;
	_tmp8_ = message;
	gtk_message_dialog_format_secondary_text (dialog, "%s", _tmp8_);
	gtk_dialog_run ((GtkDialog*) dialog);
	gtk_widget_destroy ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
	_g_object_unref0 (main_window);
}


static void synctex_get_doc_position (Synctex* self, Document* doc, DocPosition* result) {
	GtkTextIter iter = {0};
	Document* _tmp0_;
	GtkTextMark* _tmp1_ = NULL;
	GtkTextMark* _tmp2_;
	GtkTextMark* insert;
	Document* _tmp3_;
	GtkTextIter _tmp4_ = {0};
	DocPosition pos = {0};
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	_tmp0_ = doc;
	_tmp1_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	insert = _tmp2_;
	_tmp3_ = doc;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp3_, &_tmp4_, insert);
	iter = _tmp4_;
	memset (&pos, 0, sizeof (DocPosition));
	_tmp5_ = gtk_text_iter_get_line (&iter);
	pos.line = (gint32) (_tmp5_ + 1);
	pos.column = (gint32) (-1);
	*result = pos;
	_g_object_unref0 (insert);
	return;
}


static gchar* synctex_get_pdf_uri (Synctex* self, Document* doc) {
	gchar* result = NULL;
	Document* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* main_file;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* uri;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (doc != NULL, NULL);
	_tmp0_ = doc;
	_tmp1_ = document_get_main_file (_tmp0_);
	main_file = _tmp1_;
	_tmp2_ = main_file;
	if (_tmp2_ == NULL) {
		result = NULL;
		_g_object_unref0 (main_file);
		return result;
	}
	_tmp3_ = main_file;
	_tmp4_ = g_file_get_uri (_tmp3_);
	uri = _tmp4_;
	_tmp5_ = uri;
	_tmp6_ = utils_get_shortname (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, ".pdf", NULL);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	result = _tmp9_;
	_g_free0 (uri);
	_g_object_unref0 (main_file);
	return result;
}


static EvinceWindow* synctex_get_evince_window (Synctex* self, const gchar* pdf_uri) {
	EvinceWindow* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pdf_uri != NULL, NULL);
	_tmp0_ = pdf_uri;
	_tmp1_ = synctex_create_evince_window (self, _tmp0_);
	if (_tmp1_) {
		GeeHashMap* _tmp2_;
		const gchar* _tmp3_;
		gpointer _tmp4_ = NULL;
		_tmp2_ = self->priv->_ev_windows;
		_tmp3_ = pdf_uri;
		_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, _tmp3_);
		result = (EvinceWindow*) _tmp4_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}


gboolean synctex_create_evince_window (Synctex* self, const gchar* pdf_uri) {
	gboolean result = FALSE;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	EvinceDaemon* daemon;
	gchar* owner;
	EvinceApplication* app;
	gchar** _tmp18_ = NULL;
	gchar** window_list;
	gint window_list_length1;
	gint _window_list_size_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	gchar** _tmp26_;
	gint _tmp26__length1;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* window_path;
	EvinceWindow* window;
	const gchar* _tmp35_;
	EvinceWindow* _tmp36_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (pdf_uri != NULL, FALSE);
	_tmp0_ = self->priv->_ev_windows;
	_tmp1_ = pdf_uri;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	daemon = NULL;
	{
		EvinceDaemon* _tmp3_ = NULL;
		EvinceDaemon* _tmp4_;
		_tmp3_ = g_initable_new (TYPE_EVINCE_DAEMON_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "org.gnome.evince.Daemon", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/evince/Daemon", "g-interface-name", "org.gnome.evince.Daemon", NULL);
		_tmp4_ = (EvinceDaemon*) _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch58_g_io_error;
			}
			_g_object_unref0 (daemon);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (daemon);
		daemon = _tmp4_;
	}
	goto __finally58;
	__catch58_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("synctex.vala:182: SyncTeX: can not connect to evince daemon: %s", _tmp6_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (daemon);
		return result;
	}
	__finally58:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (daemon);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	owner = NULL;
	{
		EvinceDaemon* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		_tmp7_ = daemon;
		_tmp8_ = pdf_uri;
		_tmp9_ = evince_daemon_find_document (_tmp7_, _tmp8_, TRUE, &_inner_error_);
		_tmp10_ = _tmp9_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch59_g_io_error;
			}
			_g_free0 (owner);
			_g_object_unref0 (daemon);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_free0 (owner);
		owner = _tmp10_;
	}
	goto __finally59;
	__catch59_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("synctex.vala:194: SyncTeX: find document: %s", _tmp12_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (owner);
		_g_object_unref0 (daemon);
		return result;
	}
	__finally59:
	if (_inner_error_ != NULL) {
		_g_free0 (owner);
		_g_object_unref0 (daemon);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	app = NULL;
	{
		const gchar* _tmp13_;
		EvinceApplication* _tmp14_ = NULL;
		EvinceApplication* _tmp15_;
		_tmp13_ = owner;
		_tmp14_ = g_initable_new (TYPE_EVINCE_APPLICATION_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", _tmp13_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/evince/Evince", "g-interface-name", "org.gnome.evince.Application", NULL);
		_tmp15_ = (EvinceApplication*) _tmp14_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch60_g_io_error;
			}
			_g_object_unref0 (app);
			_g_free0 (owner);
			_g_object_unref0 (daemon);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (app);
		app = _tmp15_;
	}
	goto __finally60;
	__catch60_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_warning ("synctex.vala:206: SyncTeX: can not connect to evince application: %s", _tmp17_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (app);
		_g_free0 (owner);
		_g_object_unref0 (daemon);
		return result;
	}
	__finally60:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (app);
		_g_free0 (owner);
		_g_object_unref0 (daemon);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp18_ = g_new0 (gchar*, 0 + 1);
	window_list = _tmp18_;
	window_list_length1 = 0;
	_window_list_size_ = window_list_length1;
	{
		EvinceApplication* _tmp19_;
		gint _tmp20_ = 0;
		gchar** _tmp21_ = NULL;
		gchar** _tmp22_;
		gint _tmp22__length1;
		gint __tmp22__size_;
		_tmp19_ = app;
		_tmp21_ = evince_application_get_window_list (_tmp19_, &_tmp20_, &_inner_error_);
		_tmp22_ = _tmp21_;
		_tmp22__length1 = _tmp20_;
		__tmp22__size_ = _tmp22__length1;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch61_g_io_error;
			}
			window_list = (_vala_array_free (window_list, window_list_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (app);
			_g_free0 (owner);
			_g_object_unref0 (daemon);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		window_list = (_vala_array_free (window_list, window_list_length1, (GDestroyNotify) g_free), NULL);
		window_list = _tmp22_;
		window_list_length1 = _tmp22__length1;
		_window_list_size_ = window_list_length1;
	}
	goto __finally61;
	__catch61_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		g_warning ("synctex.vala:218: SyncTeX: can not get window list: %s", _tmp24_);
		result = FALSE;
		_g_error_free0 (e);
		window_list = (_vala_array_free (window_list, window_list_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (app);
		_g_free0 (owner);
		_g_object_unref0 (daemon);
		return result;
	}
	__finally61:
	if (_inner_error_ != NULL) {
		window_list = (_vala_array_free (window_list, window_list_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (app);
		_g_free0 (owner);
		_g_object_unref0 (daemon);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp25_ = window_list;
	_tmp25__length1 = window_list_length1;
	if (_tmp25__length1 == 0) {
		g_warning ("synctex.vala:224: SyncTeX: the window list is empty.");
		result = FALSE;
		window_list = (_vala_array_free (window_list, window_list_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (app);
		_g_free0 (owner);
		_g_object_unref0 (daemon);
		return result;
	}
	_tmp26_ = window_list;
	_tmp26__length1 = window_list_length1;
	_tmp27_ = _tmp26_[0];
	_tmp28_ = g_strdup (_tmp27_);
	window_path = _tmp28_;
	window = NULL;
	{
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		EvinceWindow* _tmp31_ = NULL;
		EvinceWindow* _tmp32_;
		_tmp29_ = owner;
		_tmp30_ = window_path;
		_tmp31_ = g_initable_new (TYPE_EVINCE_WINDOW_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", _tmp29_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _tmp30_, "g-interface-name", "org.gnome.evince.Window", NULL);
		_tmp32_ = (EvinceWindow*) _tmp31_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch62_g_io_error;
			}
			_g_object_unref0 (window);
			_g_free0 (window_path);
			window_list = (_vala_array_free (window_list, window_list_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (app);
			_g_free0 (owner);
			_g_object_unref0 (daemon);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (window);
		window = _tmp32_;
	}
	goto __finally62;
	__catch62_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp33_;
		const gchar* _tmp34_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp33_ = e;
		_tmp34_ = _tmp33_->message;
		g_warning ("synctex.vala:238: SyncTeX: can not connect to evince window: %s", _tmp34_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (window);
		_g_free0 (window_path);
		window_list = (_vala_array_free (window_list, window_list_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (app);
		_g_free0 (owner);
		_g_object_unref0 (daemon);
		return result;
	}
	__finally62:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (window);
		_g_free0 (window_path);
		window_list = (_vala_array_free (window_list, window_list_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (app);
		_g_free0 (owner);
		_g_object_unref0 (daemon);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp35_ = pdf_uri;
	_tmp36_ = window;
	synctex_add_evince_window (self, _tmp35_, _tmp36_);
	result = TRUE;
	_g_object_unref0 (window);
	_g_free0 (window_path);
	window_list = (_vala_array_free (window_list, window_list_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (app);
	_g_free0 (owner);
	_g_object_unref0 (daemon);
	return result;
}


static Block33Data* block33_data_ref (Block33Data* _data33_) {
	g_atomic_int_inc (&_data33_->_ref_count_);
	return _data33_;
}


static void block33_data_unref (void * _userdata_) {
	Block33Data* _data33_;
	_data33_ = (Block33Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data33_->_ref_count_)) {
		Synctex * self;
		self = _data33_->self;
		_g_free0 (_data33_->pdf_uri);
		_g_object_unref0 (self);
		g_slice_free (Block33Data, _data33_);
	}
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void __lambda51_ (Synctex* self, const gchar* tex_uri, DocPosition* pos, guint32 timestamp) {
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* tex_file;
	GFile* _tmp2_;
	gboolean _tmp3_ = FALSE;
	Latexila* _tmp8_ = NULL;
	Latexila* _tmp9_;
	GtkWindow* _tmp10_;
	GtkWindow* _tmp11_;
	MainWindow* _tmp12_;
	MainWindow* _tmp13_;
	MainWindow* main_window;
	MainWindow* _tmp14_;
	GFile* _tmp15_;
	DocPosition _tmp16_;
	gint32 _tmp17_;
	DocPosition _tmp18_;
	gint32 _tmp19_;
	MainWindow* _tmp20_;
	guint32 _tmp21_;
	g_return_if_fail (tex_uri != NULL);
	g_return_if_fail (pos != NULL);
	_tmp0_ = tex_uri;
	_tmp1_ = g_file_new_for_uri (_tmp0_);
	tex_file = _tmp1_;
	_tmp2_ = tex_file;
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
	if (!_tmp3_) {
		const gchar* _tmp4_;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		_tmp4_ = tex_uri;
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = g_strconcat ("Backward search: the file \"", _tmp5_, "\" doesn't exist.", NULL);
		_tmp7_ = _tmp6_;
		g_warning ("synctex.vala:255: %s", _tmp7_);
		_g_free0 (_tmp7_);
		_g_object_unref0 (tex_file);
		return;
	}
	_tmp8_ = latexila_get_instance ();
	_tmp9_ = _tmp8_;
	_tmp10_ = gtk_application_get_active_window ((GtkApplication*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, TYPE_MAIN_WINDOW) ? ((MainWindow*) _tmp11_) : NULL);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp9_);
	main_window = _tmp13_;
	_tmp14_ = main_window;
	_tmp15_ = tex_file;
	_tmp16_ = *pos;
	_tmp17_ = _tmp16_.line;
	_tmp18_ = *pos;
	_tmp19_ = _tmp18_.line;
	main_window_jump_to_file_position (_tmp14_, _tmp15_, (gint) (_tmp17_ - 1), (gint) _tmp19_);
	_tmp20_ = main_window;
	_tmp21_ = timestamp;
	gtk_window_present_with_time ((GtkWindow*) _tmp20_, _tmp21_);
	_g_object_unref0 (main_window);
	_g_object_unref0 (tex_file);
}


static void ___lambda51__evince_window_sync_source (EvinceWindow* _sender, const gchar* source_file, DocPosition* source_point, guint32 timestamp, gpointer self) {
	__lambda51_ (self, source_file, source_point, timestamp);
}


static void __lambda52_ (Block33Data* _data33_) {
	Synctex * self;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	self = _data33_->self;
	_tmp0_ = self->priv->_ev_windows;
	_tmp1_ = _data33_->pdf_uri;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, _tmp1_, NULL);
}


static void ___lambda52__evince_window_closed (EvinceWindow* _sender, gpointer self) {
	__lambda52_ (self);
}


static void synctex_add_evince_window (Synctex* self, const gchar* pdf_uri, EvinceWindow* window) {
	Block33Data* _data33_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GeeHashMap* _tmp2_;
	const gchar* _tmp3_;
	EvinceWindow* _tmp4_;
	EvinceWindow* _tmp5_;
	EvinceWindow* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pdf_uri != NULL);
	g_return_if_fail (window != NULL);
	_data33_ = g_slice_new0 (Block33Data);
	_data33_->_ref_count_ = 1;
	_data33_->self = g_object_ref (self);
	_tmp0_ = pdf_uri;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data33_->pdf_uri);
	_data33_->pdf_uri = _tmp1_;
	_tmp2_ = self->priv->_ev_windows;
	_tmp3_ = _data33_->pdf_uri;
	_tmp4_ = window;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp2_, _tmp3_, _tmp4_);
	_tmp5_ = window;
	g_signal_connect_object (_tmp5_, "sync-source", (GCallback) ___lambda51__evince_window_sync_source, self, 0);
	_tmp6_ = window;
	g_signal_connect_data (_tmp6_, "closed", (GCallback) ___lambda52__evince_window_closed, block33_data_ref (_data33_), (GClosureNotify) block33_data_unref, 0);
	block33_data_unref (_data33_);
	_data33_ = NULL;
}


static void synctex_sync_view (Synctex* self, EvinceWindow* window, const gchar* tex_path, DocPosition* pos) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	g_return_if_fail (tex_path != NULL);
	g_return_if_fail (pos != NULL);
	{
		EvinceWindow* _tmp0_;
		const gchar* _tmp1_;
		DocPosition _tmp2_;
		_tmp0_ = window;
		_tmp1_ = tex_path;
		_tmp2_ = *pos;
		evince_window_sync_view (_tmp0_, _tmp1_, &_tmp2_, (guint32) GDK_CURRENT_TIME, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch63_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally63;
	__catch63_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("synctex.vala:278: SyncTeX: can not sync view: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally63:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void synctex_class_init (SynctexClass * klass) {
	synctex_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SynctexPrivate));
	G_OBJECT_CLASS (klass)->finalize = synctex_finalize;
}


static void synctex_instance_init (Synctex * self) {
	self->priv = SYNCTEX_GET_PRIVATE (self);
}


static void synctex_finalize (GObject* obj) {
	Synctex * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SYNCTEX, Synctex);
	_g_object_unref0 (self->priv->_ev_windows);
	G_OBJECT_CLASS (synctex_parent_class)->finalize (obj);
}


GType synctex_get_type (void) {
	static volatile gsize synctex_type_id__volatile = 0;
	if (g_once_init_enter (&synctex_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SynctexClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synctex_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Synctex), 0, (GInstanceInitFunc) synctex_instance_init, NULL };
		GType synctex_type_id;
		synctex_type_id = g_type_register_static (G_TYPE_OBJECT, "Synctex", &g_define_type_info, 0);
		g_once_init_leave (&synctex_type_id__volatile, synctex_type_id);
	}
	return synctex_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



