/* project_dialogs.c generated by valac 0.20.1.7-00d05, the Vala compiler
 * generated from project_dialogs.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gtksourceview/gtksource.h>
#include <gee.h>


#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _Block27Data Block27Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))

#define PROJECT_DIALOGS_TYPE_PROJECT_COLUMN (project_dialogs_project_column_get_type ())
typedef struct _Block28Data Block28Data;

struct _Block27Data {
	int _ref_count_;
	GtkFileChooserButton* directory_chooser;
	GtkFileChooserButton* main_file_chooser;
};

struct _Project {
	GFile* directory;
	GFile* main_file;
};

typedef enum  {
	PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY,
	PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE,
	PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS
} ProjectDialogsProjectColumn;

struct _Block28Data {
	int _ref_count_;
	GtkDialog* dialog;
	GtkListStore* store;
	GtkTreeView* treeview;
};



GType main_window_get_type (void) G_GNUC_CONST;
void project_dialogs_new_project (MainWindow* main_window);
static Block27Data* block27_data_ref (Block27Data* _data27_);
static void block27_data_unref (void * _userdata_);
GtkGrid* utils_get_dialog_component (const gchar* title, GtkWidget* widget);
static void __lambda113_ (Block27Data* _data27_);
static void ___lambda113__gtk_file_chooser_button_file_set (GtkFileChooserButton* _sender, gpointer self);
GType document_get_type (void) G_GNUC_CONST;
Document* main_window_get_active_document (MainWindow* self);
GFile* document_get_location (Document* self);
gboolean project_dialogs_main_file_is_in_directory (GtkWindow* window, GFile* main_file, GFile* directory);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self, Project* dest);
void project_destroy (Project* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_projects (GValue* value, gpointer v_object);
void value_take_projects (GValue* value, gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
Projects* projects_get_default (void);
gboolean projects_add (Projects* self, Project* new_project, GFile** conflict_file);
gchar* utils_replace_home_dir_with_tilde (const gchar* uri);
gboolean project_dialogs_configure_project (GtkWindow* main_window, gint project_id);
Project* projects_get (Projects* self, gint id);
gboolean projects_change_main_file (Projects* self, gint num, GFile* new_main_file);
GType project_dialogs_project_column_get_type (void) G_GNUC_CONST;
void project_dialogs_manage_projects (MainWindow* main_window);
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (void * _userdata_);
void project_dialogs_update_model (GtkListStore* model);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
static void __lambda114_ (Block28Data* _data28_);
gint utils_get_selected_row (GtkTreeView* view, GtkTreeIter* iter);
static void ___lambda114__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda115_ (Block28Data* _data28_);
void projects_delete (Projects* self, gint num);
static void ___lambda115__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda116_ (Block28Data* _data28_);
void projects_clear_all (Projects* self);
static void ___lambda116__gtk_button_clicked (GtkButton* _sender, gpointer self);
GeeIterator* projects_iterator (Projects* self);


static Block27Data* block27_data_ref (Block27Data* _data27_) {
	g_atomic_int_inc (&_data27_->_ref_count_);
	return _data27_;
}


static void block27_data_unref (void * _userdata_) {
	Block27Data* _data27_;
	_data27_ = (Block27Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data27_->_ref_count_)) {
		_g_object_unref0 (_data27_->main_file_chooser);
		_g_object_unref0 (_data27_->directory_chooser);
		g_slice_free (Block27Data, _data27_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda113_ (Block27Data* _data27_) {
	GtkFileChooserButton* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_;
	GFile* dir;
	GError * _inner_error_ = NULL;
	_tmp0_ = _data27_->directory_chooser;
	_tmp1_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	dir = _tmp2_;
	{
		GtkFileChooserButton* _tmp3_;
		_tmp3_ = _data27_->main_file_chooser;
		gtk_file_chooser_set_current_folder_file ((GtkFileChooser*) _tmp3_, dir, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch48_g_error;
		}
	}
	goto __finally48;
	__catch48_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally48:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (dir);
}


static void ___lambda113__gtk_file_chooser_button_file_set (GtkFileChooserButton* _sender, gpointer self) {
	__lambda113_ (self);
}


void project_dialogs_new_project (MainWindow* main_window) {
	Block27Data* _data27_;
	const gchar* _tmp0_ = NULL;
	MainWindow* _tmp1_;
	GtkDialog* _tmp2_;
	GtkDialog* dialog;
	GtkDialog* _tmp3_;
	GtkBox* _tmp4_ = NULL;
	GtkBox* _tmp5_;
	GtkBox* content_area;
	const gchar* _tmp6_ = NULL;
	GtkFileChooserButton* _tmp7_;
	GtkFileChooserButton* _tmp8_;
	GtkFileChooserButton* _tmp9_;
	const gchar* _tmp10_ = NULL;
	GtkFileChooserButton* _tmp11_;
	GtkGrid* _tmp12_ = NULL;
	GtkWidget* component;
	GtkBox* _tmp13_;
	GtkWidget* _tmp14_;
	const gchar* _tmp15_ = NULL;
	GtkFileChooserButton* _tmp16_;
	GtkFileChooserButton* _tmp17_;
	const gchar* _tmp18_ = NULL;
	GtkFileChooserButton* _tmp19_;
	GtkGrid* _tmp20_ = NULL;
	GtkBox* _tmp21_;
	GtkWidget* _tmp22_;
	GtkBox* _tmp23_;
	GtkFileChooserButton* _tmp24_;
	MainWindow* _tmp25_;
	Document* _tmp26_;
	Document* _tmp27_;
	Document* _tmp28_;
	Document* doc;
	gboolean _tmp29_ = FALSE;
	Document* _tmp30_;
	gboolean _tmp34_;
	GtkDialog* _tmp84_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (main_window != NULL);
	_data27_ = g_slice_new0 (Block27Data);
	_data27_->_ref_count_ = 1;
	_tmp0_ = _ ("New Project");
	_tmp1_ = main_window;
	_tmp2_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp0_, (GtkWindow*) _tmp1_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_NEW, GTK_RESPONSE_OK, NULL, NULL);
	g_object_ref_sink (_tmp2_);
	dialog = _tmp2_;
	_tmp3_ = dialog;
	_tmp4_ = gtk_dialog_get_content_area (_tmp3_);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, GTK_TYPE_BOX) ? ((GtkBox*) _tmp4_) : NULL);
	content_area = _tmp5_;
	_tmp6_ = _ ("Directory");
	_tmp7_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_tmp6_, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER);
	g_object_ref_sink (_tmp7_);
	_data27_->directory_chooser = _tmp7_;
	_tmp8_ = _data27_->directory_chooser;
	gtk_widget_set_size_request ((GtkWidget*) _tmp8_, 250, -1);
	_tmp9_ = _data27_->directory_chooser;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp9_, TRUE);
	_tmp10_ = _ ("Directory");
	_tmp11_ = _data27_->directory_chooser;
	_tmp12_ = utils_get_dialog_component (_tmp10_, (GtkWidget*) _tmp11_);
	component = (GtkWidget*) _tmp12_;
	_tmp13_ = content_area;
	_tmp14_ = component;
	gtk_box_pack_start (_tmp13_, _tmp14_, FALSE, TRUE, (guint) 0);
	_tmp15_ = _ ("Main File");
	_tmp16_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_tmp15_, GTK_FILE_CHOOSER_ACTION_OPEN);
	g_object_ref_sink (_tmp16_);
	_data27_->main_file_chooser = _tmp16_;
	_tmp17_ = _data27_->main_file_chooser;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp17_, TRUE);
	_tmp18_ = _ ("Main File");
	_tmp19_ = _data27_->main_file_chooser;
	_tmp20_ = utils_get_dialog_component (_tmp18_, (GtkWidget*) _tmp19_);
	_g_object_unref0 (component);
	component = (GtkWidget*) _tmp20_;
	_tmp21_ = content_area;
	_tmp22_ = component;
	gtk_box_pack_start (_tmp21_, _tmp22_, FALSE, TRUE, (guint) 0);
	_tmp23_ = content_area;
	gtk_widget_show_all ((GtkWidget*) _tmp23_);
	_tmp24_ = _data27_->directory_chooser;
	g_signal_connect_data (_tmp24_, "file-set", (GCallback) ___lambda113__gtk_file_chooser_button_file_set, block27_data_ref (_data27_), (GClosureNotify) block27_data_unref, 0);
	_tmp25_ = main_window;
	_tmp26_ = main_window_get_active_document (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = _g_object_ref0 (_tmp27_);
	doc = _tmp28_;
	_tmp30_ = doc;
	if (_tmp30_ != NULL) {
		Document* _tmp31_;
		GFile* _tmp32_;
		GFile* _tmp33_;
		_tmp31_ = doc;
		_tmp32_ = document_get_location (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp29_ = _tmp33_ != NULL;
	} else {
		_tmp29_ = FALSE;
	}
	_tmp34_ = _tmp29_;
	if (_tmp34_) {
		{
			GtkFileChooserButton* _tmp35_;
			Document* _tmp36_;
			GFile* _tmp37_;
			GFile* _tmp38_;
			GFile* _tmp39_ = NULL;
			GFile* _tmp40_;
			GtkFileChooserButton* _tmp41_;
			Document* _tmp42_;
			GFile* _tmp43_;
			GFile* _tmp44_;
			_tmp35_ = _data27_->directory_chooser;
			_tmp36_ = doc;
			_tmp37_ = document_get_location (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = g_file_get_parent (_tmp38_);
			_tmp40_ = _tmp39_;
			gtk_file_chooser_set_file ((GtkFileChooser*) _tmp35_, _tmp40_, &_inner_error_);
			_g_object_unref0 (_tmp40_);
			if (_inner_error_ != NULL) {
				goto __catch49_g_error;
			}
			_tmp41_ = _data27_->main_file_chooser;
			_tmp42_ = doc;
			_tmp43_ = document_get_location (_tmp42_);
			_tmp44_ = _tmp43_;
			gtk_file_chooser_set_file ((GtkFileChooser*) _tmp41_, _tmp44_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch49_g_error;
			}
		}
		goto __finally49;
		__catch49_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally49:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (doc);
			_g_object_unref0 (component);
			_g_object_unref0 (content_area);
			_g_object_unref0 (dialog);
			block27_data_unref (_data27_);
			_data27_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	while (TRUE) {
		GtkDialog* _tmp45_;
		gint _tmp46_ = 0;
		GtkFileChooserButton* _tmp47_;
		GFile* _tmp48_ = NULL;
		GFile* _tmp49_;
		GFile* directory;
		GtkFileChooserButton* _tmp50_;
		GFile* _tmp51_ = NULL;
		GFile* _tmp52_;
		GFile* main_file;
		gboolean _tmp53_ = FALSE;
		GFile* _tmp54_;
		gboolean _tmp56_;
		GtkDialog* _tmp57_;
		GFile* _tmp58_;
		GFile* _tmp59_;
		gboolean _tmp60_ = FALSE;
		Project project = {0};
		GFile* _tmp61_;
		GFile* _tmp62_;
		GFile* _tmp63_;
		GFile* _tmp64_;
		GFile* conflict = NULL;
		Projects* _tmp65_ = NULL;
		Projects* _tmp66_;
		Project _tmp67_;
		GFile* _tmp68_ = NULL;
		gboolean _tmp69_ = FALSE;
		gboolean _tmp70_;
		GtkDialog* _tmp71_;
		const gchar* _tmp72_ = NULL;
		GFile* _tmp73_;
		gchar* _tmp74_ = NULL;
		gchar* _tmp75_;
		gchar* _tmp76_ = NULL;
		gchar* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		GtkMessageDialog* _tmp80_;
		GtkDialog* _tmp81_;
		GtkDialog* error_dialog;
		GtkDialog* _tmp82_;
		GtkDialog* _tmp83_;
		_tmp45_ = dialog;
		_tmp46_ = gtk_dialog_run (_tmp45_);
		if (!(_tmp46_ == ((gint) GTK_RESPONSE_OK))) {
			break;
		}
		_tmp47_ = _data27_->directory_chooser;
		_tmp48_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp47_);
		_tmp49_ = _g_object_ref0 (_tmp48_);
		directory = _tmp49_;
		_tmp50_ = _data27_->main_file_chooser;
		_tmp51_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp50_);
		_tmp52_ = _g_object_ref0 (_tmp51_);
		main_file = _tmp52_;
		_tmp54_ = directory;
		if (_tmp54_ == NULL) {
			_tmp53_ = TRUE;
		} else {
			GFile* _tmp55_;
			_tmp55_ = main_file;
			_tmp53_ = _tmp55_ == NULL;
		}
		_tmp56_ = _tmp53_;
		if (_tmp56_) {
			_g_object_unref0 (main_file);
			_g_object_unref0 (directory);
			continue;
		}
		_tmp57_ = dialog;
		_tmp58_ = main_file;
		_tmp59_ = directory;
		_tmp60_ = project_dialogs_main_file_is_in_directory ((GtkWindow*) _tmp57_, _tmp58_, _tmp59_);
		if (!_tmp60_) {
			_g_object_unref0 (main_file);
			_g_object_unref0 (directory);
			continue;
		}
		memset (&project, 0, sizeof (Project));
		_tmp61_ = directory;
		_tmp62_ = _g_object_ref0 (_tmp61_);
		_g_object_unref0 (project.directory);
		project.directory = _tmp62_;
		_tmp63_ = main_file;
		_tmp64_ = _g_object_ref0 (_tmp63_);
		_g_object_unref0 (project.main_file);
		project.main_file = _tmp64_;
		_tmp65_ = projects_get_default ();
		_tmp66_ = _tmp65_;
		_tmp67_ = project;
		_tmp69_ = projects_add (_tmp66_, &_tmp67_, &_tmp68_);
		_g_object_unref0 (conflict);
		conflict = _tmp68_;
		_tmp70_ = _tmp69_;
		_projects_unref0 (_tmp66_);
		if (_tmp70_) {
			_g_object_unref0 (conflict);
			project_destroy (&project);
			_g_object_unref0 (main_file);
			_g_object_unref0 (directory);
			break;
		}
		_tmp71_ = dialog;
		_tmp72_ = _ ("There is a conflict with the project \"%s\".");
		_tmp73_ = conflict;
		_tmp74_ = g_file_get_parse_name (_tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = utils_replace_home_dir_with_tilde (_tmp75_);
		_tmp77_ = _tmp76_;
		_tmp78_ = g_strconcat (_tmp77_, "/", NULL);
		_tmp79_ = _tmp78_;
		_tmp80_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp71_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp72_, _tmp79_);
		g_object_ref_sink (_tmp80_);
		_tmp81_ = (GtkDialog*) _tmp80_;
		_g_free0 (_tmp79_);
		_g_free0 (_tmp77_);
		_g_free0 (_tmp75_);
		error_dialog = _tmp81_;
		_tmp82_ = error_dialog;
		gtk_dialog_run (_tmp82_);
		_tmp83_ = error_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp83_);
		_g_object_unref0 (error_dialog);
		_g_object_unref0 (conflict);
		project_destroy (&project);
		_g_object_unref0 (main_file);
		_g_object_unref0 (directory);
	}
	_tmp84_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp84_);
	_g_object_unref0 (doc);
	_g_object_unref0 (component);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
	block27_data_unref (_data27_);
	_data27_ = NULL;
}


gboolean project_dialogs_configure_project (GtkWindow* main_window, gint project_id) {
	gboolean result = FALSE;
	Projects* _tmp0_ = NULL;
	Projects* _tmp1_;
	gint _tmp2_;
	Project* _tmp3_ = NULL;
	Project* _tmp4_;
	Project* project;
	Project* _tmp5_;
	const gchar* _tmp6_ = NULL;
	GtkWindow* _tmp7_;
	GtkDialog* _tmp8_;
	GtkDialog* dialog;
	GtkDialog* _tmp9_;
	GtkBox* _tmp10_ = NULL;
	GtkBox* _tmp11_;
	GtkBox* content_area;
	Project* _tmp12_;
	GFile* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* project_dir;
	const gchar* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	GtkLabel* _tmp20_;
	GtkLabel* location;
	GtkLabel* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	const gchar* _tmp24_ = NULL;
	GtkLabel* _tmp25_;
	GtkGrid* _tmp26_ = NULL;
	GtkWidget* component;
	GtkBox* _tmp27_;
	GtkWidget* _tmp28_;
	const gchar* _tmp29_ = NULL;
	GtkFileChooserButton* _tmp30_;
	GtkFileChooserButton* main_file_chooser;
	GtkFileChooserButton* _tmp31_;
	const gchar* _tmp32_ = NULL;
	GtkFileChooserButton* _tmp33_;
	GtkGrid* _tmp34_ = NULL;
	GtkBox* _tmp35_;
	GtkWidget* _tmp36_;
	GtkBox* _tmp37_;
	gboolean ret;
	GtkDialog* _tmp57_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (main_window != NULL, FALSE);
	_tmp0_ = projects_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = project_id;
	_tmp3_ = projects_get (_tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_projects_unref0 (_tmp1_);
	project = _tmp4_;
	_tmp5_ = project;
	g_return_val_if_fail (_tmp5_ != NULL, FALSE);
	_tmp6_ = _ ("Configure Project");
	_tmp7_ = main_window;
	_tmp8_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp6_, _tmp7_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OK, GTK_RESPONSE_OK, NULL, NULL);
	g_object_ref_sink (_tmp8_);
	dialog = _tmp8_;
	_tmp9_ = dialog;
	_tmp10_ = gtk_dialog_get_content_area (_tmp9_);
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, GTK_TYPE_BOX) ? ((GtkBox*) _tmp10_) : NULL);
	content_area = _tmp11_;
	_tmp12_ = project;
	_tmp13_ = (*_tmp12_).directory;
	_tmp14_ = g_file_get_parse_name (_tmp13_);
	project_dir = _tmp14_;
	_tmp15_ = project_dir;
	_tmp16_ = utils_replace_home_dir_with_tilde (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (_tmp17_, "/", NULL);
	_g_free0 (project_dir);
	project_dir = _tmp18_;
	_g_free0 (_tmp17_);
	_tmp19_ = project_dir;
	_tmp20_ = (GtkLabel*) gtk_label_new (_tmp19_);
	g_object_ref_sink (_tmp20_);
	location = _tmp20_;
	_tmp21_ = location;
	gtk_label_set_line_wrap (_tmp21_, TRUE);
	_tmp22_ = location;
	gtk_widget_set_halign ((GtkWidget*) _tmp22_, GTK_ALIGN_START);
	_tmp23_ = location;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp23_, TRUE);
	_tmp24_ = _ ("Location of the project");
	_tmp25_ = location;
	_tmp26_ = utils_get_dialog_component (_tmp24_, (GtkWidget*) _tmp25_);
	component = (GtkWidget*) _tmp26_;
	_tmp27_ = content_area;
	_tmp28_ = component;
	gtk_box_pack_start (_tmp27_, _tmp28_, FALSE, TRUE, (guint) 0);
	_tmp29_ = _ ("Main File");
	_tmp30_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_tmp29_, GTK_FILE_CHOOSER_ACTION_OPEN);
	g_object_ref_sink (_tmp30_);
	main_file_chooser = _tmp30_;
	_tmp31_ = main_file_chooser;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp31_, TRUE);
	_tmp32_ = _ ("Main File");
	_tmp33_ = main_file_chooser;
	_tmp34_ = utils_get_dialog_component (_tmp32_, (GtkWidget*) _tmp33_);
	_g_object_unref0 (component);
	component = (GtkWidget*) _tmp34_;
	_tmp35_ = content_area;
	_tmp36_ = component;
	gtk_box_pack_start (_tmp35_, _tmp36_, FALSE, TRUE, (guint) 0);
	_tmp37_ = content_area;
	gtk_widget_show_all ((GtkWidget*) _tmp37_);
	{
		GtkFileChooserButton* _tmp38_;
		Project* _tmp39_;
		GFile* _tmp40_;
		_tmp38_ = main_file_chooser;
		_tmp39_ = project;
		_tmp40_ = (*_tmp39_).main_file;
		gtk_file_chooser_set_file ((GtkFileChooser*) _tmp38_, _tmp40_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch50_g_error;
		}
	}
	goto __finally50;
	__catch50_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally50:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (main_file_chooser);
		_g_object_unref0 (component);
		_g_object_unref0 (location);
		_g_free0 (project_dir);
		_g_object_unref0 (content_area);
		_g_object_unref0 (dialog);
		_project_free0 (project);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	ret = FALSE;
	while (TRUE) {
		GtkDialog* _tmp41_;
		gint _tmp42_ = 0;
		GtkFileChooserButton* _tmp43_;
		GFile* _tmp44_ = NULL;
		GFile* _tmp45_;
		GFile* main_file;
		GFile* _tmp46_;
		GtkDialog* _tmp47_;
		GFile* _tmp48_;
		Project* _tmp49_;
		GFile* _tmp50_;
		gboolean _tmp51_ = FALSE;
		Projects* _tmp52_ = NULL;
		Projects* _tmp53_;
		gint _tmp54_;
		GFile* _tmp55_;
		gboolean _tmp56_ = FALSE;
		_tmp41_ = dialog;
		_tmp42_ = gtk_dialog_run (_tmp41_);
		if (!(_tmp42_ == ((gint) GTK_RESPONSE_OK))) {
			break;
		}
		_tmp43_ = main_file_chooser;
		_tmp44_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp43_);
		_tmp45_ = _g_object_ref0 (_tmp44_);
		main_file = _tmp45_;
		_tmp46_ = main_file;
		if (_tmp46_ == NULL) {
			_g_object_unref0 (main_file);
			continue;
		}
		_tmp47_ = dialog;
		_tmp48_ = main_file;
		_tmp49_ = project;
		_tmp50_ = (*_tmp49_).directory;
		_tmp51_ = project_dialogs_main_file_is_in_directory ((GtkWindow*) _tmp47_, _tmp48_, _tmp50_);
		if (!_tmp51_) {
			_g_object_unref0 (main_file);
			continue;
		}
		_tmp52_ = projects_get_default ();
		_tmp53_ = _tmp52_;
		_tmp54_ = project_id;
		_tmp55_ = main_file;
		_tmp56_ = projects_change_main_file (_tmp53_, _tmp54_, _tmp55_);
		ret = _tmp56_;
		_projects_unref0 (_tmp53_);
		_g_object_unref0 (main_file);
		break;
	}
	_tmp57_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp57_);
	result = ret;
	_g_object_unref0 (main_file_chooser);
	_g_object_unref0 (component);
	_g_object_unref0 (location);
	_g_free0 (project_dir);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
	_project_free0 (project);
	return result;
}


GType project_dialogs_project_column_get_type (void) {
	static volatile gsize project_dialogs_project_column_type_id__volatile = 0;
	if (g_once_init_enter (&project_dialogs_project_column_type_id__volatile)) {
		static const GEnumValue values[] = {{PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, "PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY", "directory"}, {PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE, "PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE", "main-file"}, {PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS, "PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType project_dialogs_project_column_type_id;
		project_dialogs_project_column_type_id = g_enum_register_static ("ProjectDialogsProjectColumn", values);
		g_once_init_leave (&project_dialogs_project_column_type_id__volatile, project_dialogs_project_column_type_id);
	}
	return project_dialogs_project_column_type_id__volatile;
}


static Block28Data* block28_data_ref (Block28Data* _data28_) {
	g_atomic_int_inc (&_data28_->_ref_count_);
	return _data28_;
}


static void block28_data_unref (void * _userdata_) {
	Block28Data* _data28_;
	_data28_ = (Block28Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
		_g_object_unref0 (_data28_->treeview);
		_g_object_unref0 (_data28_->store);
		_g_object_unref0 (_data28_->dialog);
		g_slice_free (Block28Data, _data28_);
	}
}


static void __lambda114_ (Block28Data* _data28_) {
	gint _tmp0_ = 0;
	gint i;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	gboolean _tmp5_;
	_tmp0_ = utils_get_selected_row (_data28_->treeview, NULL);
	i = _tmp0_;
	_tmp2_ = i;
	if (_tmp2_ != (-1)) {
		gint _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = i;
		_tmp4_ = project_dialogs_configure_project ((GtkWindow*) _data28_->dialog, _tmp3_);
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp5_ = _tmp1_;
	if (_tmp5_) {
		project_dialogs_update_model (_data28_->store);
	}
}


static void ___lambda114__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda114_ (self);
}


static void __lambda115_ (Block28Data* _data28_) {
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint i;
	gint _tmp2_;
	gchar* directory = NULL;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* model;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_;
	GtkMessageDialog* _tmp8_;
	GtkDialog* delete_dialog;
	GtkDialog* _tmp9_;
	GtkDialog* _tmp10_;
	gint _tmp11_ = 0;
	GtkDialog* _tmp16_;
	_tmp1_ = utils_get_selected_row (_data28_->treeview, &_tmp0_);
	iter = _tmp0_;
	i = _tmp1_;
	_tmp2_ = i;
	if (_tmp2_ == (-1)) {
		return;
	}
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data28_->store, GTK_TYPE_TREE_MODEL, GtkTreeModel));
	model = _tmp3_;
	_tmp4_ = model;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, &directory, -1, -1);
	_tmp6_ = _ ("Do you really want to delete the project \"%s\"?");
	_tmp7_ = directory;
	_tmp8_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data28_->dialog, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _tmp6_, _tmp7_);
	g_object_ref_sink (_tmp8_);
	delete_dialog = (GtkDialog*) _tmp8_;
	_tmp9_ = delete_dialog;
	gtk_dialog_add_buttons (_tmp9_, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_DELETE, GTK_RESPONSE_YES, NULL);
	_tmp10_ = delete_dialog;
	_tmp11_ = gtk_dialog_run (_tmp10_);
	if (_tmp11_ == ((gint) GTK_RESPONSE_YES)) {
		GtkTreeIter _tmp12_;
		Projects* _tmp13_ = NULL;
		Projects* _tmp14_;
		gint _tmp15_;
		_tmp12_ = iter;
		gtk_list_store_remove (_data28_->store, &_tmp12_);
		_tmp13_ = projects_get_default ();
		_tmp14_ = _tmp13_;
		_tmp15_ = i;
		projects_delete (_tmp14_, _tmp15_);
		_projects_unref0 (_tmp14_);
	}
	_tmp16_ = delete_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp16_);
	_g_object_unref0 (delete_dialog);
	_g_object_unref0 (model);
	_g_free0 (directory);
}


static void ___lambda115__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda115_ (self);
}


static void __lambda116_ (Block28Data* _data28_) {
	const gchar* _tmp0_ = NULL;
	GtkMessageDialog* _tmp1_;
	GtkDialog* clear_dialog;
	GtkDialog* _tmp2_;
	const gchar* _tmp3_ = NULL;
	GtkButton* _tmp4_;
	GtkButton* button;
	GtkImage* _tmp5_;
	GtkImage* img;
	GtkButton* _tmp6_;
	GtkImage* _tmp7_;
	GtkButton* _tmp8_;
	GtkDialog* _tmp9_;
	GtkButton* _tmp10_;
	GtkDialog* _tmp11_;
	gint _tmp12_ = 0;
	GtkDialog* _tmp15_;
	_tmp0_ = _ ("Do you really want to clear all projects?");
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data28_->dialog, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _tmp0_);
	g_object_ref_sink (_tmp1_);
	clear_dialog = (GtkDialog*) _tmp1_;
	_tmp2_ = clear_dialog;
	gtk_dialog_add_button (_tmp2_, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
	_tmp3_ = _ ("Clear All");
	_tmp4_ = (GtkButton*) gtk_button_new_with_label (_tmp3_);
	g_object_ref_sink (_tmp4_);
	button = _tmp4_;
	_tmp5_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLEAR, GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp5_);
	img = _tmp5_;
	_tmp6_ = button;
	_tmp7_ = img;
	gtk_button_set_image (_tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = button;
	gtk_widget_show_all ((GtkWidget*) _tmp8_);
	_tmp9_ = clear_dialog;
	_tmp10_ = button;
	gtk_dialog_add_action_widget (_tmp9_, (GtkWidget*) _tmp10_, (gint) GTK_RESPONSE_YES);
	_tmp11_ = clear_dialog;
	_tmp12_ = gtk_dialog_run (_tmp11_);
	if (_tmp12_ == ((gint) GTK_RESPONSE_YES)) {
		Projects* _tmp13_ = NULL;
		Projects* _tmp14_;
		_tmp13_ = projects_get_default ();
		_tmp14_ = _tmp13_;
		projects_clear_all (_tmp14_);
		_projects_unref0 (_tmp14_);
		gtk_list_store_clear (_data28_->store);
	}
	_tmp15_ = clear_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp15_);
	_g_object_unref0 (img);
	_g_object_unref0 (button);
	_g_object_unref0 (clear_dialog);
}


static void ___lambda116__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda116_ (self);
}


void project_dialogs_manage_projects (MainWindow* main_window) {
	Block28Data* _data28_;
	const gchar* _tmp0_ = NULL;
	MainWindow* _tmp1_;
	GtkDialog* _tmp2_;
	GtkBox* _tmp3_ = NULL;
	GtkBox* _tmp4_;
	GtkBox* content_area;
	GtkListStore* _tmp5_;
	GtkTreeView* _tmp6_;
	GtkTreeViewColumn* _tmp7_;
	GtkTreeViewColumn* column;
	GtkTreeViewColumn* _tmp8_;
	GtkTreeViewColumn* _tmp9_;
	const gchar* _tmp10_ = NULL;
	GtkCellRendererPixbuf* _tmp11_;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkCellRendererPixbuf* _tmp12_;
	GtkTreeViewColumn* _tmp13_;
	GtkCellRendererPixbuf* _tmp14_;
	GtkCellRendererText* _tmp15_;
	GtkCellRendererText* text_renderer;
	GtkTreeViewColumn* _tmp16_;
	GtkCellRendererText* _tmp17_;
	GtkTreeViewColumn* _tmp18_;
	GtkCellRendererText* _tmp19_;
	GtkTreeViewColumn* _tmp20_;
	GtkTreeViewColumn* _tmp21_;
	GtkTreeViewColumn* _tmp22_;
	const gchar* _tmp23_ = NULL;
	GtkCellRendererPixbuf* _tmp24_;
	GtkCellRendererPixbuf* _tmp25_;
	GtkTreeViewColumn* _tmp26_;
	GtkCellRendererPixbuf* _tmp27_;
	GtkCellRendererText* _tmp28_;
	GtkTreeViewColumn* _tmp29_;
	GtkCellRendererText* _tmp30_;
	GtkTreeViewColumn* _tmp31_;
	GtkCellRendererText* _tmp32_;
	GtkTreeSelection* _tmp33_ = NULL;
	GtkTreeSelection* _tmp34_;
	GtkTreeSelection* select;
	GtkScrolledWindow* _tmp35_ = NULL;
	GtkScrolledWindow* sw;
	GtkGrid* _tmp36_;
	GtkGrid* grid;
	GtkButton* _tmp37_;
	GtkButton* edit_button;
	GtkButton* _tmp38_;
	GtkButton* delete_button;
	const gchar* _tmp39_ = NULL;
	GtkButton* _tmp40_;
	GtkButton* clear_all_button;
	GtkImage* _tmp41_;
	GtkImage* image;
	g_return_if_fail (main_window != NULL);
	_data28_ = g_slice_new0 (Block28Data);
	_data28_->_ref_count_ = 1;
	_tmp0_ = _ ("Manage Projects");
	_tmp1_ = main_window;
	_tmp2_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp0_, (GtkWindow*) _tmp1_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_CLOSE, GTK_RESPONSE_OK, NULL, NULL);
	g_object_ref_sink (_tmp2_);
	_data28_->dialog = _tmp2_;
	_tmp3_ = gtk_dialog_get_content_area (_data28_->dialog);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GTK_TYPE_BOX) ? ((GtkBox*) _tmp3_) : NULL);
	content_area = _tmp4_;
	gtk_widget_set_size_request ((GtkWidget*) content_area, 400, 250);
	_tmp5_ = gtk_list_store_new ((gint) PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING);
	_data28_->store = _tmp5_;
	project_dialogs_update_model (_data28_->store);
	_tmp6_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _data28_->store);
	g_object_ref_sink (_tmp6_);
	_data28_->treeview = _tmp6_;
	gtk_tree_view_set_rules_hint (_data28_->treeview, TRUE);
	_tmp7_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp7_);
	column = _tmp7_;
	_tmp8_ = column;
	gtk_tree_view_append_column (_data28_->treeview, _tmp8_);
	_tmp9_ = column;
	_tmp10_ = _ ("Directory");
	gtk_tree_view_column_set_title (_tmp9_, _tmp10_);
	_tmp11_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp11_);
	pixbuf_renderer = _tmp11_;
	_tmp12_ = pixbuf_renderer;
	g_object_set (_tmp12_, "stock-id", GTK_STOCK_DIRECTORY, NULL);
	_tmp13_ = column;
	_tmp14_ = pixbuf_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp13_, (GtkCellRenderer*) _tmp14_, FALSE);
	_tmp15_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp15_);
	text_renderer = _tmp15_;
	_tmp16_ = column;
	_tmp17_ = text_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp16_, (GtkCellRenderer*) _tmp17_, TRUE);
	_tmp18_ = column;
	_tmp19_ = text_renderer;
	gtk_tree_view_column_set_attributes (_tmp18_, (GtkCellRenderer*) _tmp19_, "text", PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, NULL, NULL);
	_tmp20_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (column);
	column = _tmp20_;
	_tmp21_ = column;
	gtk_tree_view_append_column (_data28_->treeview, _tmp21_);
	_tmp22_ = column;
	_tmp23_ = _ ("Main File");
	gtk_tree_view_column_set_title (_tmp22_, _tmp23_);
	_tmp24_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (pixbuf_renderer);
	pixbuf_renderer = _tmp24_;
	_tmp25_ = pixbuf_renderer;
	g_object_set (_tmp25_, "stock-id", GTK_STOCK_FILE, NULL);
	_tmp26_ = column;
	_tmp27_ = pixbuf_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp26_, (GtkCellRenderer*) _tmp27_, FALSE);
	_tmp28_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (text_renderer);
	text_renderer = _tmp28_;
	_tmp29_ = column;
	_tmp30_ = text_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp29_, (GtkCellRenderer*) _tmp30_, TRUE);
	_tmp31_ = column;
	_tmp32_ = text_renderer;
	gtk_tree_view_column_set_attributes (_tmp31_, (GtkCellRenderer*) _tmp32_, "text", PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE, NULL, NULL);
	_tmp33_ = gtk_tree_view_get_selection (_data28_->treeview);
	_tmp34_ = _g_object_ref0 (_tmp33_);
	select = _tmp34_;
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	_tmp35_ = utils_add_scrollbar ((GtkWidget*) _data28_->treeview);
	sw = _tmp35_;
	gtk_box_pack_start (content_area, (GtkWidget*) sw, TRUE, TRUE, (guint) 0);
	_tmp36_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp36_);
	grid = _tmp36_;
	gtk_orientable_set_orientation ((GtkOrientable*) grid, GTK_ORIENTATION_HORIZONTAL);
	gtk_grid_set_column_spacing (grid, (guint) 5);
	gtk_box_pack_start (content_area, (GtkWidget*) grid, FALSE, FALSE, (guint) 5);
	_tmp37_ = (GtkButton*) gtk_button_new_from_stock (GTK_STOCK_PROPERTIES);
	g_object_ref_sink (_tmp37_);
	edit_button = _tmp37_;
	_tmp38_ = (GtkButton*) gtk_button_new_from_stock (GTK_STOCK_DELETE);
	g_object_ref_sink (_tmp38_);
	delete_button = _tmp38_;
	_tmp39_ = _ ("Clear All");
	_tmp40_ = (GtkButton*) gtk_button_new_with_label (_tmp39_);
	g_object_ref_sink (_tmp40_);
	clear_all_button = _tmp40_;
	_tmp41_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLEAR, GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp41_);
	image = _tmp41_;
	gtk_button_set_image (clear_all_button, (GtkWidget*) image);
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) edit_button);
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) delete_button);
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) clear_all_button);
	gtk_widget_show_all ((GtkWidget*) content_area);
	g_signal_connect_data (edit_button, "clicked", (GCallback) ___lambda114__gtk_button_clicked, block28_data_ref (_data28_), (GClosureNotify) block28_data_unref, 0);
	g_signal_connect_data (delete_button, "clicked", (GCallback) ___lambda115__gtk_button_clicked, block28_data_ref (_data28_), (GClosureNotify) block28_data_unref, 0);
	g_signal_connect_data (clear_all_button, "clicked", (GCallback) ___lambda116__gtk_button_clicked, block28_data_ref (_data28_), (GClosureNotify) block28_data_unref, 0);
	gtk_dialog_run (_data28_->dialog);
	gtk_widget_destroy ((GtkWidget*) _data28_->dialog);
	_g_object_unref0 (image);
	_g_object_unref0 (clear_all_button);
	_g_object_unref0 (delete_button);
	_g_object_unref0 (edit_button);
	_g_object_unref0 (grid);
	_g_object_unref0 (sw);
	_g_object_unref0 (select);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (column);
	_g_object_unref0 (content_area);
	block28_data_unref (_data28_);
	_data28_ = NULL;
}


gboolean project_dialogs_main_file_is_in_directory (GtkWindow* window, GFile* main_file, GFile* directory) {
	gboolean result = FALSE;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GtkWindow* _tmp3_;
	const gchar* _tmp4_ = NULL;
	GtkMessageDialog* _tmp5_;
	GtkDialog* error_dialog;
	GtkDialog* _tmp6_;
	GtkDialog* _tmp7_;
	g_return_val_if_fail (window != NULL, FALSE);
	g_return_val_if_fail (main_file != NULL, FALSE);
	g_return_val_if_fail (directory != NULL, FALSE);
	_tmp0_ = main_file;
	_tmp1_ = directory;
	_tmp2_ = g_file_has_prefix (_tmp0_, _tmp1_);
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = window;
	_tmp4_ = _ ("The Main File is not in the directory.");
	_tmp5_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp3_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", _tmp4_);
	g_object_ref_sink (_tmp5_);
	error_dialog = (GtkDialog*) _tmp5_;
	_tmp6_ = error_dialog;
	gtk_dialog_run (_tmp6_);
	_tmp7_ = error_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp7_);
	result = FALSE;
	_g_object_unref0 (error_dialog);
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


void project_dialogs_update_model (GtkListStore* model) {
	GtkListStore* _tmp0_;
	g_return_if_fail (model != NULL);
	_tmp0_ = model;
	gtk_list_store_clear (_tmp0_);
	{
		Projects* _tmp1_ = NULL;
		Projects* _tmp2_;
		GeeIterator* _tmp3_ = NULL;
		GeeIterator* _tmp4_;
		GeeIterator* _project_it;
		_tmp1_ = projects_get_default ();
		_tmp2_ = _tmp1_;
		_tmp3_ = projects_iterator (_tmp2_);
		_tmp4_ = _tmp3_;
		_projects_unref0 (_tmp2_);
		_project_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			gboolean _tmp6_ = FALSE;
			GeeIterator* _tmp7_;
			gpointer _tmp8_ = NULL;
			Project* _tmp9_;
			Project _tmp10_ = {0};
			Project _tmp11_;
			Project project;
			Project _tmp12_;
			GFile* _tmp13_;
			gchar* _tmp14_ = NULL;
			gchar* uri_directory;
			Project _tmp15_;
			GFile* _tmp16_;
			gchar* _tmp17_ = NULL;
			gchar* uri_main_file;
			const gchar* _tmp18_;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* dir;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			const gchar* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gchar* _tmp30_ = NULL;
			gchar* main_file;
			GtkTreeIter iter = {0};
			GtkListStore* _tmp31_;
			GtkTreeIter _tmp32_ = {0};
			GtkListStore* _tmp33_;
			GtkTreeIter _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			_tmp5_ = _project_it;
			_tmp6_ = gee_iterator_next (_tmp5_);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = _project_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			_tmp9_ = (Project*) _tmp8_;
			project_copy (_tmp9_, &_tmp10_);
			_tmp11_ = _tmp10_;
			_project_free0 (_tmp9_);
			project = _tmp11_;
			_tmp12_ = project;
			_tmp13_ = _tmp12_.directory;
			_tmp14_ = g_file_get_parse_name (_tmp13_);
			uri_directory = _tmp14_;
			_tmp15_ = project;
			_tmp16_ = _tmp15_.main_file;
			_tmp17_ = g_file_get_parse_name (_tmp16_);
			uri_main_file = _tmp17_;
			_tmp18_ = uri_directory;
			_tmp19_ = utils_replace_home_dir_with_tilde (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strconcat (_tmp20_, "/", NULL);
			_tmp22_ = _tmp21_;
			_g_free0 (_tmp20_);
			dir = _tmp22_;
			_tmp23_ = uri_main_file;
			_tmp24_ = uri_directory;
			_tmp25_ = strlen (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = uri_main_file;
			_tmp28_ = strlen (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = string_slice (_tmp23_, (glong) (_tmp26_ + 1), (glong) _tmp29_);
			main_file = _tmp30_;
			_tmp31_ = model;
			gtk_list_store_append (_tmp31_, &_tmp32_);
			iter = _tmp32_;
			_tmp33_ = model;
			_tmp34_ = iter;
			_tmp35_ = dir;
			_tmp36_ = main_file;
			gtk_list_store_set (_tmp33_, &_tmp34_, PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, _tmp35_, PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE, _tmp36_, -1, -1);
			_g_free0 (main_file);
			_g_free0 (dir);
			_g_free0 (uri_main_file);
			_g_free0 (uri_directory);
			project_destroy (&project);
		}
		_g_object_unref0 (_project_it);
	}
}



