/* build_view.c generated by valac 0.20.1.7-00d05, the Vala compiler
 * generated from build_view.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <gio/gio.h>


#define TYPE_BUILD_STATE (build_state_get_type ())

#define TYPE_BUILD_MSG_TYPE (build_msg_type_get_type ())

#define TYPE_BUILD_MSG (build_msg_get_type ())
typedef struct _BuildMsg BuildMsg;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_BUILD_VIEW (build_view_get_type ())
#define BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_VIEW, BuildView))
#define BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_VIEW, BuildViewClass))
#define IS_BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_VIEW))
#define IS_BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_VIEW))
#define BUILD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_VIEW, BuildViewClass))

typedef struct _BuildView BuildView;
typedef struct _BuildViewClass BuildViewClass;
typedef struct _BuildViewPrivate BuildViewPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define BUILD_VIEW_TYPE_BUILD_MSG_COLUMN (build_view_build_msg_column_get_type ())

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define _build_msg_free0(var) ((var == NULL) ? NULL : (var = (build_msg_free (var), NULL)))

typedef enum  {
	BUILD_STATE_RUNNING,
	BUILD_STATE_SUCCEEDED,
	BUILD_STATE_FAILED,
	BUILD_STATE_ABORTED
} BuildState;

typedef enum  {
	BUILD_MSG_TYPE_TITLE,
	BUILD_MSG_TYPE_JOB_TITLE,
	BUILD_MSG_TYPE_JOB_SUB_COMMAND,
	BUILD_MSG_TYPE_ERROR,
	BUILD_MSG_TYPE_WARNING,
	BUILD_MSG_TYPE_BADBOX,
	BUILD_MSG_TYPE_INFO
} BuildMsgType;

struct _BuildMsg {
	BuildMsgType type;
	gchar* text;
	gchar* filename;
	gint start_line;
	gint end_line;
	gboolean expand;
	GeeList* children;
};

struct _BuildView {
	GtkTreeView parent_instance;
	BuildViewPrivate * priv;
};

struct _BuildViewClass {
	GtkTreeViewClass parent_class;
};

struct _BuildViewPrivate {
	gboolean _show_warnings;
	gboolean _show_badboxes;
	gboolean _show_details;
	gboolean _has_details;
	MainWindow* _main_window;
	GtkTreeStore* _store;
	GtkTreeModelFilter* _filtered_model;
};

typedef enum  {
	BUILD_VIEW_BUILD_MSG_COLUMN_ICON,
	BUILD_VIEW_BUILD_MSG_COLUMN_MESSAGE,
	BUILD_VIEW_BUILD_MSG_COLUMN_MESSAGE_TYPE,
	BUILD_VIEW_BUILD_MSG_COLUMN_WEIGHT,
	BUILD_VIEW_BUILD_MSG_COLUMN_BASENAME,
	BUILD_VIEW_BUILD_MSG_COLUMN_PATH,
	BUILD_VIEW_BUILD_MSG_COLUMN_FILE,
	BUILD_VIEW_BUILD_MSG_COLUMN_START_LINE,
	BUILD_VIEW_BUILD_MSG_COLUMN_END_LINE,
	BUILD_VIEW_BUILD_MSG_COLUMN_LINE_STR,
	BUILD_VIEW_BUILD_MSG_COLUMN_N_COLUMNS
} BuildViewBuildMsgColumn;


static gpointer build_view_parent_class = NULL;

GType build_state_get_type (void) G_GNUC_CONST;
GType build_msg_type_get_type (void) G_GNUC_CONST;
GType build_msg_get_type (void) G_GNUC_CONST;
BuildMsg* build_msg_dup (const BuildMsg* self);
void build_msg_free (BuildMsg* self);
void build_msg_copy (const BuildMsg* self, BuildMsg* dest);
void build_msg_destroy (BuildMsg* self);
void build_msg_init (BuildMsg *self);
GType build_view_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
#define BUILD_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BUILD_VIEW, BuildViewPrivate))
enum  {
	BUILD_VIEW_DUMMY_PROPERTY,
	BUILD_VIEW_SHOW_WARNINGS,
	BUILD_VIEW_SHOW_BADBOXES,
	BUILD_VIEW_SHOW_DETAILS,
	BUILD_VIEW_HAS_DETAILS
};
static GType build_view_build_msg_column_get_type (void) G_GNUC_UNUSED;
BuildView* build_view_new (MainWindow* main_window);
BuildView* build_view_construct (GType object_type, MainWindow* main_window);
static void build_view_init_tree_models (BuildView* self);
static void build_view_init_tree_view (BuildView* self);
static gboolean __lambda41_ (BuildView* self, GtkTreeModel* model, GtkTreeIter* iter);
gboolean build_view_get_show_warnings (BuildView* self);
gboolean build_view_get_show_badboxes (BuildView* self);
static gboolean ___lambda41__gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self);
static void __lambda42_ (BuildView* self);
static void ___lambda42__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda43_ (BuildView* self);
static void ___lambda43__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean __lambda44_ (BuildView* self, GtkTreeSelection* select, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected);
static gboolean build_view_select_row (BuildView* self, GtkTreeModel* model, GtkTreePath* path);
static gboolean ___lambda44__gtk_tree_selection_func (GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, gpointer self);
static void __lambda45_ (BuildView* self, GtkTreePath* path);
static void ___lambda45__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_open_document (MainWindow* self, GFile* location, gboolean jump_to);
static void build_view_jump_to_file_lines (BuildView* self, GFile* file, gint start_line, gint end_line);
void main_window_jump_to_file_position (MainWindow* self, GFile* file, gint start_line, gint end_line);
void build_view_clear (BuildView* self);
void build_view_add_main_title (BuildView* self, const gchar* main_title, BuildState state, GtkTreeIter* result);
static void build_view_add_title (BuildView* self, const gchar* msg, BuildState state, BuildMsgType type, GtkTreeIter* result);
void build_view_add_job_title (BuildView* self, const gchar* job_title, BuildState state, GtkTreeIter* result);
static gchar* build_view_get_icon_from_state (BuildView* self, BuildState state);
void build_view_set_title_state (BuildView* self, GtkTreeIter* title_id, BuildState state);
void build_view_append_messages (BuildView* self, GtkTreeIter* parent, GeeList* messages, gboolean expand);
void build_view_append_single_message (BuildView* self, GtkTreeIter* parent, BuildMsg* msg, GtkTreeIter* result);
gchar* utils_replace_home_dir_with_tilde (const gchar* uri);
static gchar* build_view_get_icon_from_msg_type (BuildView* self, BuildMsgType type);
void build_view_remove_children (BuildView* self, GtkTreeIter* parent);
void build_view_set_show_warnings (BuildView* self, gboolean value);
void build_view_set_show_badboxes (BuildView* self, gboolean value);
gboolean build_view_get_show_details (BuildView* self);
void build_view_set_show_details (BuildView* self, gboolean value);
gboolean build_view_get_has_details (BuildView* self);
void build_view_set_has_details (BuildView* self, gboolean value);
static void build_view_finalize (GObject* obj);
static void _vala_build_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_build_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType build_state_get_type (void) {
	static volatile gsize build_state_type_id__volatile = 0;
	if (g_once_init_enter (&build_state_type_id__volatile)) {
		static const GEnumValue values[] = {{BUILD_STATE_RUNNING, "BUILD_STATE_RUNNING", "running"}, {BUILD_STATE_SUCCEEDED, "BUILD_STATE_SUCCEEDED", "succeeded"}, {BUILD_STATE_FAILED, "BUILD_STATE_FAILED", "failed"}, {BUILD_STATE_ABORTED, "BUILD_STATE_ABORTED", "aborted"}, {0, NULL, NULL}};
		GType build_state_type_id;
		build_state_type_id = g_enum_register_static ("BuildState", values);
		g_once_init_leave (&build_state_type_id__volatile, build_state_type_id);
	}
	return build_state_type_id__volatile;
}


GType build_msg_type_get_type (void) {
	static volatile gsize build_msg_type_type_id__volatile = 0;
	if (g_once_init_enter (&build_msg_type_type_id__volatile)) {
		static const GEnumValue values[] = {{BUILD_MSG_TYPE_TITLE, "BUILD_MSG_TYPE_TITLE", "title"}, {BUILD_MSG_TYPE_JOB_TITLE, "BUILD_MSG_TYPE_JOB_TITLE", "job-title"}, {BUILD_MSG_TYPE_JOB_SUB_COMMAND, "BUILD_MSG_TYPE_JOB_SUB_COMMAND", "job-sub-command"}, {BUILD_MSG_TYPE_ERROR, "BUILD_MSG_TYPE_ERROR", "error"}, {BUILD_MSG_TYPE_WARNING, "BUILD_MSG_TYPE_WARNING", "warning"}, {BUILD_MSG_TYPE_BADBOX, "BUILD_MSG_TYPE_BADBOX", "badbox"}, {BUILD_MSG_TYPE_INFO, "BUILD_MSG_TYPE_INFO", "info"}, {0, NULL, NULL}};
		GType build_msg_type_type_id;
		build_msg_type_type_id = g_enum_register_static ("BuildMsgType", values);
		g_once_init_leave (&build_msg_type_type_id__volatile, build_msg_type_type_id);
	}
	return build_msg_type_type_id__volatile;
}


void build_msg_init (BuildMsg *self) {
	GeeLinkedList* _tmp0_;
	memset (self, 0, sizeof (BuildMsg));
	(*self).type = BUILD_MSG_TYPE_INFO;
	_g_free0 ((*self).text);
	(*self).text = NULL;
	_g_free0 ((*self).filename);
	(*self).filename = NULL;
	(*self).start_line = -1;
	(*self).end_line = -1;
	(*self).expand = TRUE;
	_tmp0_ = gee_linked_list_new (TYPE_BUILD_MSG, (GBoxedCopyFunc) build_msg_dup, build_msg_free, NULL);
	_g_object_unref0 ((*self).children);
	(*self).children = (GeeList*) _tmp0_;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void build_msg_copy (const BuildMsg* self, BuildMsg* dest) {
	BuildMsgType _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gboolean _tmp7_;
	GeeList* _tmp8_;
	GeeList* _tmp9_;
	_tmp0_ = (*self).type;
	(*dest).type = _tmp0_;
	_tmp1_ = (*self).text;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 ((*dest).text);
	(*dest).text = _tmp2_;
	_tmp3_ = (*self).filename;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 ((*dest).filename);
	(*dest).filename = _tmp4_;
	_tmp5_ = (*self).start_line;
	(*dest).start_line = _tmp5_;
	_tmp6_ = (*self).end_line;
	(*dest).end_line = _tmp6_;
	_tmp7_ = (*self).expand;
	(*dest).expand = _tmp7_;
	_tmp8_ = (*self).children;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 ((*dest).children);
	(*dest).children = _tmp9_;
}


void build_msg_destroy (BuildMsg* self) {
	_g_free0 ((*self).text);
	_g_free0 ((*self).filename);
	_g_object_unref0 ((*self).children);
}


BuildMsg* build_msg_dup (const BuildMsg* self) {
	BuildMsg* dup;
	dup = g_new0 (BuildMsg, 1);
	build_msg_copy (self, dup);
	return dup;
}


void build_msg_free (BuildMsg* self) {
	build_msg_destroy (self);
	g_free (self);
}


GType build_msg_get_type (void) {
	static volatile gsize build_msg_type_id__volatile = 0;
	if (g_once_init_enter (&build_msg_type_id__volatile)) {
		GType build_msg_type_id;
		build_msg_type_id = g_boxed_type_register_static ("BuildMsg", (GBoxedCopyFunc) build_msg_dup, (GBoxedFreeFunc) build_msg_free);
		g_once_init_leave (&build_msg_type_id__volatile, build_msg_type_id);
	}
	return build_msg_type_id__volatile;
}


static GType build_view_build_msg_column_get_type (void) {
	static volatile gsize build_view_build_msg_column_type_id__volatile = 0;
	if (g_once_init_enter (&build_view_build_msg_column_type_id__volatile)) {
		static const GEnumValue values[] = {{BUILD_VIEW_BUILD_MSG_COLUMN_ICON, "BUILD_VIEW_BUILD_MSG_COLUMN_ICON", "icon"}, {BUILD_VIEW_BUILD_MSG_COLUMN_MESSAGE, "BUILD_VIEW_BUILD_MSG_COLUMN_MESSAGE", "message"}, {BUILD_VIEW_BUILD_MSG_COLUMN_MESSAGE_TYPE, "BUILD_VIEW_BUILD_MSG_COLUMN_MESSAGE_TYPE", "message-type"}, {BUILD_VIEW_BUILD_MSG_COLUMN_WEIGHT, "BUILD_VIEW_BUILD_MSG_COLUMN_WEIGHT", "weight"}, {BUILD_VIEW_BUILD_MSG_COLUMN_BASENAME, "BUILD_VIEW_BUILD_MSG_COLUMN_BASENAME", "basename"}, {BUILD_VIEW_BUILD_MSG_COLUMN_PATH, "BUILD_VIEW_BUILD_MSG_COLUMN_PATH", "path"}, {BUILD_VIEW_BUILD_MSG_COLUMN_FILE, "BUILD_VIEW_BUILD_MSG_COLUMN_FILE", "file"}, {BUILD_VIEW_BUILD_MSG_COLUMN_START_LINE, "BUILD_VIEW_BUILD_MSG_COLUMN_START_LINE", "start-line"}, {BUILD_VIEW_BUILD_MSG_COLUMN_END_LINE, "BUILD_VIEW_BUILD_MSG_COLUMN_END_LINE", "end-line"}, {BUILD_VIEW_BUILD_MSG_COLUMN_LINE_STR, "BUILD_VIEW_BUILD_MSG_COLUMN_LINE_STR", "line-str"}, {BUILD_VIEW_BUILD_MSG_COLUMN_N_COLUMNS, "BUILD_VIEW_BUILD_MSG_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType build_view_build_msg_column_type_id;
		build_view_build_msg_column_type_id = g_enum_register_static ("BuildViewBuildMsgColumn", values);
		g_once_init_leave (&build_view_build_msg_column_type_id__volatile, build_view_build_msg_column_type_id);
	}
	return build_view_build_msg_column_type_id__volatile;
}


BuildView* build_view_construct (GType object_type, MainWindow* main_window) {
	BuildView * self = NULL;
	MainWindow* _tmp0_;
	g_return_val_if_fail (main_window != NULL, NULL);
	self = (BuildView*) g_object_new (object_type, NULL);
	_tmp0_ = main_window;
	self->priv->_main_window = _tmp0_;
	build_view_init_tree_models (self);
	build_view_init_tree_view (self);
	return self;
}


BuildView* build_view_new (MainWindow* main_window) {
	return build_view_construct (TYPE_BUILD_VIEW, main_window);
}


static gboolean __lambda41_ (BuildView* self, GtkTreeModel* model, GtkTreeIter* iter) {
	gboolean result = FALSE;
	BuildMsgType msg_type = 0;
	GtkTreeModel* _tmp0_;
	GtkTreeIter _tmp1_;
	BuildMsgType _tmp2_;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = model;
	_tmp1_ = *iter;
	gtk_tree_model_get (_tmp0_, &_tmp1_, BUILD_VIEW_BUILD_MSG_COLUMN_MESSAGE_TYPE, &msg_type, -1);
	_tmp2_ = msg_type;
	switch (_tmp2_) {
		case BUILD_MSG_TYPE_WARNING:
		{
			gboolean _tmp3_;
			_tmp3_ = self->priv->_show_warnings;
			result = _tmp3_;
			return result;
		}
		case BUILD_MSG_TYPE_BADBOX:
		{
			gboolean _tmp4_;
			_tmp4_ = self->priv->_show_badboxes;
			result = _tmp4_;
			return result;
		}
		default:
		{
			result = TRUE;
			return result;
		}
	}
}


static gboolean ___lambda41__gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self) {
	gboolean result;
	result = __lambda41_ (self, model, iter);
	return result;
}


static void __lambda42_ (BuildView* self) {
	GtkTreeModelFilter* _tmp0_;
	_tmp0_ = self->priv->_filtered_model;
	gtk_tree_model_filter_refilter (_tmp0_);
}


static void ___lambda42__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda42_ (self);
}


static void __lambda43_ (BuildView* self) {
	GtkTreeModelFilter* _tmp0_;
	_tmp0_ = self->priv->_filtered_model;
	gtk_tree_model_filter_refilter (_tmp0_);
}


static void ___lambda43__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda43_ (self);
}


static void build_view_init_tree_models (BuildView* self) {
	GtkTreeStore* _tmp0_;
	GtkTreeStore* _tmp1_;
	GtkTreeModelFilter* _tmp2_;
	GtkTreeModelFilter* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_tree_store_new ((gint) BUILD_VIEW_BUILD_MSG_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, TYPE_BUILD_MSG_TYPE, G_TYPE_INT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_FILE, G_TYPE_INT, G_TYPE_INT, G_TYPE_STRING);
	_g_object_unref0 (self->priv->_store);
	self->priv->_store = _tmp0_;
	_tmp1_ = self->priv->_store;
	_tmp2_ = (GtkTreeModelFilter*) gtk_tree_model_filter_new ((GtkTreeModel*) _tmp1_, NULL);
	_g_object_unref0 (self->priv->_filtered_model);
	self->priv->_filtered_model = _tmp2_;
	_tmp3_ = self->priv->_filtered_model;
	gtk_tree_model_filter_set_visible_func (_tmp3_, ___lambda41__gtk_tree_model_filter_visible_func, g_object_ref (self), g_object_unref);
	g_signal_connect_object ((GObject*) self, "notify::show-warnings", (GCallback) ___lambda42__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::show-badboxes", (GCallback) ___lambda43__g_object_notify, self, 0);
}


static gboolean __lambda44_ (BuildView* self, GtkTreeSelection* select, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreePath* _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (select != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = path_currently_selected;
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp1_ = model;
	_tmp2_ = path;
	_tmp3_ = build_view_select_row (self, _tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}


static gboolean ___lambda44__gtk_tree_selection_func (GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, gpointer self) {
	gboolean result;
	result = __lambda44_ (self, selection, model, path, path_currently_selected);
	return result;
}


static void __lambda45_ (BuildView* self, GtkTreePath* path) {
	GtkTreeModelFilter* _tmp0_;
	GtkTreePath* _tmp1_;
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->_filtered_model;
	_tmp1_ = path;
	build_view_select_row (self, (GtkTreeModel*) _tmp0_, _tmp1_);
}


static void ___lambda45__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	__lambda45_ (self, path);
}


static void build_view_init_tree_view (BuildView* self) {
	GtkTreeModelFilter* _tmp0_;
	GtkTreeViewColumn* _tmp1_;
	GtkTreeViewColumn* column_job;
	GtkCellRendererPixbuf* _tmp2_;
	GtkCellRendererPixbuf* renderer_pixbuf;
	GtkCellRendererText* _tmp3_;
	GtkCellRendererText* renderer_text;
	GtkCellRendererText* _tmp4_;
	GtkCellRendererText* _tmp5_;
	GtkCellRendererText* _tmp6_;
	GtkCellRendererText* _tmp7_;
	GtkTreeSelection* _tmp8_ = NULL;
	GtkTreeSelection* _tmp9_;
	GtkTreeSelection* select;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_filtered_model;
	gtk_tree_view_set_model ((GtkTreeView*) self, (GtkTreeModel*) _tmp0_);
	gtk_tree_view_set_headers_visible ((GtkTreeView*) self, FALSE);
	_tmp1_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp1_);
	column_job = _tmp1_;
	_tmp2_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp2_);
	renderer_pixbuf = _tmp2_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) column_job, (GtkCellRenderer*) renderer_pixbuf, FALSE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column_job, (GtkCellRenderer*) renderer_pixbuf, "stock-id", (gint) BUILD_VIEW_BUILD_MSG_COLUMN_ICON);
	_tmp3_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp3_);
	renderer_text = _tmp3_;
	g_object_set (renderer_text, "weight-set", TRUE, NULL);
	g_object_set (renderer_text, "editable", TRUE, NULL);
	g_object_set (renderer_text, "editable-set", TRUE, NULL);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column_job, (GtkCellRenderer*) renderer_text, TRUE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column_job, (GtkCellRenderer*) renderer_text, "text", (gint) BUILD_VIEW_BUILD_MSG_COLUMN_MESSAGE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column_job, (GtkCellRenderer*) renderer_text, "weight", (gint) BUILD_VIEW_BUILD_MSG_COLUMN_WEIGHT);
	gtk_tree_view_append_column ((GtkTreeView*) self, column_job);
	_tmp4_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	gtk_tree_view_insert_column_with_attributes ((GtkTreeView*) self, -1, NULL, (GtkCellRenderer*) _tmp5_, "text", BUILD_VIEW_BUILD_MSG_COLUMN_BASENAME, NULL);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	gtk_tree_view_insert_column_with_attributes ((GtkTreeView*) self, -1, NULL, (GtkCellRenderer*) _tmp7_, "text", BUILD_VIEW_BUILD_MSG_COLUMN_LINE_STR, NULL);
	_g_object_unref0 (_tmp7_);
	gtk_tree_view_set_tooltip_column ((GtkTreeView*) self, (gint) BUILD_VIEW_BUILD_MSG_COLUMN_PATH);
	_tmp8_ = gtk_tree_view_get_selection ((GtkTreeView*) self);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	select = _tmp9_;
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	gtk_tree_selection_set_select_function (select, ___lambda44__gtk_tree_selection_func, g_object_ref (self), g_object_unref);
	g_signal_connect_object ((GtkTreeView*) self, "row-activated", (GCallback) ___lambda45__gtk_tree_view_row_activated, self, 0);
	_g_object_unref0 (select);
	_g_object_unref0 (renderer_text);
	_g_object_unref0 (renderer_pixbuf);
	_g_object_unref0 (column_job);
}


static gboolean build_view_select_row (BuildView* self, GtkTreeModel* model, GtkTreePath* path) {
	gboolean result = FALSE;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_;
	gboolean _tmp6_ = FALSE;
	GFile* file = NULL;
	gint start_line = 0;
	gint end_line = 0;
	GtkTreeModel* _tmp11_;
	GtkTreeIter _tmp12_;
	GFile* _tmp13_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = model;
	_tmp1_ = path;
	_tmp3_ = gtk_tree_model_get_iter (_tmp0_, &_tmp2_, _tmp1_);
	iter = _tmp2_;
	if (!_tmp3_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = model;
	_tmp5_ = iter;
	_tmp6_ = gtk_tree_model_iter_has_child (_tmp4_, &_tmp5_);
	if (_tmp6_) {
		GtkTreePath* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp7_ = path;
		_tmp8_ = gtk_tree_view_row_expanded ((GtkTreeView*) self, _tmp7_);
		if (_tmp8_) {
			GtkTreePath* _tmp9_;
			_tmp9_ = path;
			gtk_tree_view_collapse_row ((GtkTreeView*) self, _tmp9_);
		} else {
			GtkTreePath* _tmp10_;
			_tmp10_ = path;
			gtk_tree_view_expand_to_path ((GtkTreeView*) self, _tmp10_);
		}
		result = FALSE;
		return result;
	}
	_tmp11_ = model;
	_tmp12_ = iter;
	gtk_tree_model_get (_tmp11_, &_tmp12_, BUILD_VIEW_BUILD_MSG_COLUMN_FILE, &file, BUILD_VIEW_BUILD_MSG_COLUMN_START_LINE, &start_line, BUILD_VIEW_BUILD_MSG_COLUMN_END_LINE, &end_line, -1);
	_tmp13_ = file;
	if (_tmp13_ != NULL) {
		gint _tmp14_;
		_tmp14_ = start_line;
		if (_tmp14_ == (-1)) {
			MainWindow* _tmp15_;
			GFile* _tmp16_;
			DocumentTab* _tmp17_ = NULL;
			DocumentTab* _tmp18_;
			_tmp15_ = self->priv->_main_window;
			_tmp16_ = file;
			_tmp17_ = main_window_open_document (_tmp15_, _tmp16_, TRUE);
			_tmp18_ = _tmp17_;
			_g_object_unref0 (_tmp18_);
		} else {
			GFile* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			_tmp19_ = file;
			_tmp20_ = start_line;
			_tmp21_ = end_line;
			build_view_jump_to_file_lines (self, _tmp19_, _tmp20_, _tmp21_);
		}
	}
	result = TRUE;
	_g_object_unref0 (file);
	return result;
}


static void build_view_jump_to_file_lines (BuildView* self, GFile* file, gint start_line, gint end_line) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp3_;
	MainWindow* _tmp4_;
	GFile* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp1_ = start_line;
	if (_tmp1_ >= 1) {
		gint _tmp2_;
		_tmp2_ = end_line;
		_tmp0_ = _tmp2_ >= 1;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	g_return_if_fail (_tmp3_);
	_tmp4_ = self->priv->_main_window;
	_tmp5_ = file;
	_tmp6_ = start_line;
	_tmp7_ = end_line;
	main_window_jump_to_file_position (_tmp4_, _tmp5_, _tmp6_ - 1, _tmp7_ - 1);
}


void build_view_clear (BuildView* self) {
	GtkTreeSelection* _tmp0_ = NULL;
	GtkTreeSelection* _tmp1_;
	GtkTreeSelection* select;
	GtkTreeStore* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_tree_view_get_selection ((GtkTreeView*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	select = _tmp1_;
	gtk_tree_selection_set_mode (select, GTK_SELECTION_NONE);
	_tmp2_ = self->priv->_store;
	gtk_tree_store_clear (_tmp2_);
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	gtk_tree_view_columns_autosize ((GtkTreeView*) self);
	_g_object_unref0 (select);
}


void build_view_add_main_title (BuildView* self, const gchar* main_title, BuildState state, GtkTreeIter* result) {
	const gchar* _tmp0_;
	BuildState _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_title != NULL);
	_tmp0_ = main_title;
	_tmp1_ = state;
	build_view_add_title (self, _tmp0_, _tmp1_, BUILD_MSG_TYPE_TITLE, &_tmp2_);
	*result = _tmp2_;
	return;
}


void build_view_add_job_title (BuildView* self, const gchar* job_title, BuildState state, GtkTreeIter* result) {
	const gchar* _tmp0_;
	BuildState _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (job_title != NULL);
	_tmp0_ = job_title;
	_tmp1_ = state;
	build_view_add_title (self, _tmp0_, _tmp1_, BUILD_MSG_TYPE_JOB_TITLE, &_tmp2_);
	*result = _tmp2_;
	return;
}


static void build_view_add_title (BuildView* self, const gchar* msg, BuildState state, BuildMsgType type, GtkTreeIter* result) {
	BuildMsgType _tmp0_;
	gboolean bold;
	GtkTreeIter iter = {0};
	GtkTreeStore* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gint _tmp3_ = 0;
	gboolean _tmp4_;
	GtkTreeStore* _tmp5_;
	GtkTreeIter _tmp6_;
	BuildState _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	BuildMsgType _tmp11_;
	gint _tmp12_;
	GtkTreeStore* _tmp13_;
	GtkTreeIter _tmp14_;
	GtkTreePath* _tmp15_ = NULL;
	GtkTreePath* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	_tmp0_ = type;
	bold = _tmp0_ == BUILD_MSG_TYPE_TITLE;
	_tmp1_ = self->priv->_store;
	gtk_tree_store_append (_tmp1_, &_tmp2_, NULL);
	iter = _tmp2_;
	_tmp4_ = bold;
	if (_tmp4_) {
		_tmp3_ = 800;
	} else {
		_tmp3_ = 400;
	}
	_tmp5_ = self->priv->_store;
	_tmp6_ = iter;
	_tmp7_ = state;
	_tmp8_ = build_view_get_icon_from_state (self, _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = msg;
	_tmp11_ = type;
	_tmp12_ = _tmp3_;
	gtk_tree_store_set (_tmp5_, &_tmp6_, BUILD_VIEW_BUILD_MSG_COLUMN_ICON, _tmp9_, BUILD_VIEW_BUILD_MSG_COLUMN_MESSAGE, _tmp10_, BUILD_VIEW_BUILD_MSG_COLUMN_MESSAGE_TYPE, _tmp11_, BUILD_VIEW_BUILD_MSG_COLUMN_WEIGHT, _tmp12_, -1);
	_g_free0 (_tmp9_);
	_tmp13_ = self->priv->_store;
	_tmp14_ = iter;
	_tmp15_ = gtk_tree_model_get_path ((GtkTreeModel*) _tmp13_, &_tmp14_);
	_tmp16_ = _tmp15_;
	gtk_tree_view_expand_to_path ((GtkTreeView*) self, _tmp16_);
	_gtk_tree_path_free0 (_tmp16_);
	*result = iter;
	return;
}


void build_view_set_title_state (BuildView* self, GtkTreeIter* title_id, BuildState state) {
	GtkTreeStore* _tmp0_;
	GtkTreeIter _tmp1_;
	BuildState _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title_id != NULL);
	_tmp0_ = self->priv->_store;
	_tmp1_ = *title_id;
	_tmp2_ = state;
	_tmp3_ = build_view_get_icon_from_state (self, _tmp2_);
	_tmp4_ = _tmp3_;
	gtk_tree_store_set (_tmp0_, &_tmp1_, BUILD_VIEW_BUILD_MSG_COLUMN_ICON, _tmp4_, -1);
	_g_free0 (_tmp4_);
}


void build_view_append_messages (BuildView* self, GtkTreeIter* parent, GeeList* messages, gboolean expand) {
	gboolean _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	g_return_if_fail (messages != NULL);
	{
		GeeList* _tmp0_;
		GeeList* _tmp1_;
		GeeList* _msg_list;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _msg_size;
		gint _msg_index;
		_tmp0_ = messages;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_msg_list = _tmp1_;
		_tmp2_ = _msg_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_msg_size = _tmp4_;
		_msg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			BuildMsg* _tmp11_;
			BuildMsg _tmp12_ = {0};
			BuildMsg _tmp13_;
			BuildMsg msg;
			GtkTreeIter _tmp14_;
			BuildMsg _tmp15_;
			GtkTreeIter _tmp16_ = {0};
			GtkTreeIter child;
			BuildMsg _tmp17_;
			GeeList* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			_tmp5_ = _msg_index;
			_msg_index = _tmp5_ + 1;
			_tmp6_ = _msg_index;
			_tmp7_ = _msg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _msg_list;
			_tmp9_ = _msg_index;
			_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
			_tmp11_ = (BuildMsg*) _tmp10_;
			build_msg_copy (_tmp11_, &_tmp12_);
			_tmp13_ = _tmp12_;
			_build_msg_free0 (_tmp11_);
			msg = _tmp13_;
			_tmp14_ = *parent;
			_tmp15_ = msg;
			build_view_append_single_message (self, &_tmp14_, &_tmp15_, &_tmp16_);
			child = _tmp16_;
			_tmp17_ = msg;
			_tmp18_ = _tmp17_.children;
			_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
			_tmp20_ = _tmp19_;
			if (_tmp20_ > 0) {
				GtkTreeIter _tmp21_;
				BuildMsg _tmp22_;
				GeeList* _tmp23_;
				BuildMsg _tmp24_;
				gboolean _tmp25_;
				_tmp21_ = child;
				_tmp22_ = msg;
				_tmp23_ = _tmp22_.children;
				_tmp24_ = msg;
				_tmp25_ = _tmp24_.expand;
				build_view_append_messages (self, &_tmp21_, _tmp23_, _tmp25_);
			}
			build_msg_destroy (&msg);
		}
		_g_object_unref0 (_msg_list);
	}
	_tmp26_ = expand;
	if (_tmp26_) {
		GtkTreeStore* _tmp27_;
		GtkTreeIter _tmp28_;
		GtkTreePath* _tmp29_ = NULL;
		GtkTreePath* _tmp30_;
		_tmp27_ = self->priv->_store;
		_tmp28_ = *parent;
		_tmp29_ = gtk_tree_model_get_path ((GtkTreeModel*) _tmp27_, &_tmp28_);
		_tmp30_ = _tmp29_;
		gtk_tree_view_expand_to_path ((GtkTreeView*) self, _tmp30_);
		_gtk_tree_path_free0 (_tmp30_);
	}
}


void build_view_append_single_message (BuildView* self, GtkTreeIter* parent, BuildMsg* msg, GtkTreeIter* result) {
	GFile* file;
	gchar* path;
	BuildMsg _tmp0_;
	const gchar* _tmp1_;
	gchar* line_str;
	BuildMsg _tmp10_;
	gint _tmp11_;
	BuildMsg _tmp15_;
	gint _tmp16_;
	gint end_line;
	gint _tmp17_;
	GtkTreeIter iter = {0};
	GtkTreeStore* _tmp20_;
	GtkTreeIter _tmp21_;
	GtkTreeIter _tmp22_ = {0};
	gchar* _tmp23_ = NULL;
	GFile* _tmp24_;
	GtkTreeStore* _tmp27_;
	GtkTreeIter _tmp28_;
	BuildMsg _tmp29_;
	BuildMsgType _tmp30_;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_;
	BuildMsg _tmp33_;
	const gchar* _tmp34_;
	BuildMsg _tmp35_;
	BuildMsgType _tmp36_;
	const gchar* _tmp37_;
	GFile* _tmp38_;
	const gchar* _tmp39_;
	BuildMsg _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	const gchar* _tmp43_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	g_return_if_fail (msg != NULL);
	file = NULL;
	path = NULL;
	_tmp0_ = *msg;
	_tmp1_ = _tmp0_.filename;
	if (_tmp1_ != NULL) {
		BuildMsg _tmp2_;
		const gchar* _tmp3_;
		GFile* _tmp4_ = NULL;
		BuildMsg _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_;
		gchar* _tmp9_ = NULL;
		_tmp2_ = *msg;
		_tmp3_ = _tmp2_.filename;
		_tmp4_ = g_file_new_for_path (_tmp3_);
		_g_object_unref0 (file);
		file = _tmp4_;
		_tmp5_ = *msg;
		_tmp6_ = _tmp5_.filename;
		_tmp7_ = utils_replace_home_dir_with_tilde (_tmp6_);
		_g_free0 (path);
		path = _tmp7_;
		_tmp8_ = path;
		_tmp9_ = g_markup_escape_text (_tmp8_, (gssize) (-1));
		_g_free0 (path);
		path = _tmp9_;
	}
	line_str = NULL;
	_tmp10_ = *msg;
	_tmp11_ = _tmp10_.start_line;
	if (_tmp11_ != (-1)) {
		BuildMsg _tmp12_;
		gint _tmp13_;
		gchar* _tmp14_ = NULL;
		_tmp12_ = *msg;
		_tmp13_ = _tmp12_.start_line;
		_tmp14_ = g_strdup_printf ("%i", _tmp13_);
		_g_free0 (line_str);
		line_str = _tmp14_;
	}
	_tmp15_ = *msg;
	_tmp16_ = _tmp15_.end_line;
	end_line = _tmp16_;
	_tmp17_ = end_line;
	if (_tmp17_ == (-1)) {
		BuildMsg _tmp18_;
		gint _tmp19_;
		_tmp18_ = *msg;
		_tmp19_ = _tmp18_.start_line;
		end_line = _tmp19_ + 1;
	}
	_tmp20_ = self->priv->_store;
	_tmp21_ = *parent;
	gtk_tree_store_append (_tmp20_, &_tmp22_, &_tmp21_);
	iter = _tmp22_;
	_tmp24_ = file;
	if (_tmp24_ != NULL) {
		GFile* _tmp25_;
		gchar* _tmp26_ = NULL;
		_tmp25_ = file;
		_tmp26_ = g_file_get_basename (_tmp25_);
		_g_free0 (_tmp23_);
		_tmp23_ = _tmp26_;
	} else {
		_g_free0 (_tmp23_);
		_tmp23_ = NULL;
	}
	_tmp27_ = self->priv->_store;
	_tmp28_ = iter;
	_tmp29_ = *msg;
	_tmp30_ = _tmp29_.type;
	_tmp31_ = build_view_get_icon_from_msg_type (self, _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = *msg;
	_tmp34_ = _tmp33_.text;
	_tmp35_ = *msg;
	_tmp36_ = _tmp35_.type;
	_tmp37_ = _tmp23_;
	_tmp38_ = file;
	_tmp39_ = path;
	_tmp40_ = *msg;
	_tmp41_ = _tmp40_.start_line;
	_tmp42_ = end_line;
	_tmp43_ = line_str;
	gtk_tree_store_set (_tmp27_, &_tmp28_, BUILD_VIEW_BUILD_MSG_COLUMN_ICON, _tmp32_, BUILD_VIEW_BUILD_MSG_COLUMN_MESSAGE, _tmp34_, BUILD_VIEW_BUILD_MSG_COLUMN_MESSAGE_TYPE, _tmp36_, BUILD_VIEW_BUILD_MSG_COLUMN_WEIGHT, 400, BUILD_VIEW_BUILD_MSG_COLUMN_BASENAME, _tmp37_, BUILD_VIEW_BUILD_MSG_COLUMN_FILE, _tmp38_, BUILD_VIEW_BUILD_MSG_COLUMN_PATH, _tmp39_, BUILD_VIEW_BUILD_MSG_COLUMN_START_LINE, _tmp41_, BUILD_VIEW_BUILD_MSG_COLUMN_END_LINE, _tmp42_, BUILD_VIEW_BUILD_MSG_COLUMN_LINE_STR, _tmp43_, -1);
	_g_free0 (_tmp32_);
	*result = iter;
	_g_free0 (_tmp23_);
	_g_free0 (line_str);
	_g_free0 (path);
	_g_object_unref0 (file);
	return;
}


void build_view_remove_children (BuildView* self, GtkTreeIter* parent) {
	GtkTreeIter child = {0};
	GtkTreeStore* _tmp0_;
	GtkTreeIter _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	_tmp0_ = self->priv->_store;
	_tmp1_ = *parent;
	_tmp3_ = gtk_tree_model_iter_children ((GtkTreeModel*) _tmp0_, &_tmp2_, &_tmp1_);
	child = _tmp2_;
	if (!_tmp3_) {
		return;
	}
	while (TRUE) {
		GtkTreeStore* _tmp4_;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = self->priv->_store;
		_tmp5_ = gtk_tree_store_remove (_tmp4_, &child);
		if (!_tmp5_) {
			break;
		}
	}
}


static gchar* build_view_get_icon_from_state (BuildView* self, BuildState state) {
	gchar* result = NULL;
	BuildState _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = state;
	switch (_tmp0_) {
		case BUILD_STATE_RUNNING:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (GTK_STOCK_EXECUTE);
			result = _tmp1_;
			return result;
		}
		case BUILD_STATE_SUCCEEDED:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (GTK_STOCK_APPLY);
			result = _tmp2_;
			return result;
		}
		case BUILD_STATE_FAILED:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (GTK_STOCK_DIALOG_ERROR);
			result = _tmp3_;
			return result;
		}
		case BUILD_STATE_ABORTED:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (GTK_STOCK_STOP);
			result = _tmp4_;
			return result;
		}
		default:
		{
			g_return_val_if_reached (NULL);
		}
	}
}


static gchar* build_view_get_icon_from_msg_type (BuildView* self, BuildMsgType type) {
	gchar* result = NULL;
	BuildMsgType _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = type;
	switch (_tmp0_) {
		case BUILD_MSG_TYPE_JOB_SUB_COMMAND:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("gray-square");
			result = _tmp1_;
			return result;
		}
		case BUILD_MSG_TYPE_ERROR:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (GTK_STOCK_DIALOG_ERROR);
			result = _tmp2_;
			return result;
		}
		case BUILD_MSG_TYPE_WARNING:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (GTK_STOCK_DIALOG_WARNING);
			result = _tmp3_;
			return result;
		}
		case BUILD_MSG_TYPE_BADBOX:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("badbox");
			result = _tmp4_;
			return result;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
}


gboolean build_view_get_show_warnings (BuildView* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_warnings;
	result = _tmp0_;
	return result;
}


void build_view_set_show_warnings (BuildView* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_warnings = _tmp0_;
	g_object_notify ((GObject *) self, "show-warnings");
}


gboolean build_view_get_show_badboxes (BuildView* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_badboxes;
	result = _tmp0_;
	return result;
}


void build_view_set_show_badboxes (BuildView* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_badboxes = _tmp0_;
	g_object_notify ((GObject *) self, "show-badboxes");
}


gboolean build_view_get_show_details (BuildView* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_details;
	result = _tmp0_;
	return result;
}


void build_view_set_show_details (BuildView* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_details = _tmp0_;
	g_object_notify ((GObject *) self, "show-details");
}


gboolean build_view_get_has_details (BuildView* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_has_details;
	result = _tmp0_;
	return result;
}


void build_view_set_has_details (BuildView* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_has_details = _tmp0_;
	g_object_notify ((GObject *) self, "has-details");
}


static void build_view_class_init (BuildViewClass * klass) {
	build_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BuildViewPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_build_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_build_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = build_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUILD_VIEW_SHOW_WARNINGS, g_param_spec_boolean ("show-warnings", "show-warnings", "show-warnings", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUILD_VIEW_SHOW_BADBOXES, g_param_spec_boolean ("show-badboxes", "show-badboxes", "show-badboxes", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUILD_VIEW_SHOW_DETAILS, g_param_spec_boolean ("show-details", "show-details", "show-details", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUILD_VIEW_HAS_DETAILS, g_param_spec_boolean ("has-details", "has-details", "has-details", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void build_view_instance_init (BuildView * self) {
	self->priv = BUILD_VIEW_GET_PRIVATE (self);
	self->priv->_show_details = FALSE;
	self->priv->_has_details = FALSE;
}


static void build_view_finalize (GObject* obj) {
	BuildView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BUILD_VIEW, BuildView);
	_g_object_unref0 (self->priv->_store);
	_g_object_unref0 (self->priv->_filtered_model);
	G_OBJECT_CLASS (build_view_parent_class)->finalize (obj);
}


GType build_view_get_type (void) {
	static volatile gsize build_view_type_id__volatile = 0;
	if (g_once_init_enter (&build_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BuildViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) build_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuildView), 0, (GInstanceInitFunc) build_view_instance_init, NULL };
		GType build_view_type_id;
		build_view_type_id = g_type_register_static (GTK_TYPE_TREE_VIEW, "BuildView", &g_define_type_info, 0);
		g_once_init_leave (&build_view_type_id__volatile, build_view_type_id);
	}
	return build_view_type_id__volatile;
}


static void _vala_build_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BuildView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BUILD_VIEW, BuildView);
	switch (property_id) {
		case BUILD_VIEW_SHOW_WARNINGS:
		g_value_set_boolean (value, build_view_get_show_warnings (self));
		break;
		case BUILD_VIEW_SHOW_BADBOXES:
		g_value_set_boolean (value, build_view_get_show_badboxes (self));
		break;
		case BUILD_VIEW_SHOW_DETAILS:
		g_value_set_boolean (value, build_view_get_show_details (self));
		break;
		case BUILD_VIEW_HAS_DETAILS:
		g_value_set_boolean (value, build_view_get_has_details (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_build_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BuildView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BUILD_VIEW, BuildView);
	switch (property_id) {
		case BUILD_VIEW_SHOW_WARNINGS:
		build_view_set_show_warnings (self, g_value_get_boolean (value));
		break;
		case BUILD_VIEW_SHOW_BADBOXES:
		build_view_set_show_badboxes (self, g_value_get_boolean (value));
		break;
		case BUILD_VIEW_SHOW_DETAILS:
		build_view_set_show_details (self, g_value_get_boolean (value));
		break;
		case BUILD_VIEW_HAS_DETAILS:
		build_view_set_has_details (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



