/* build_tools.c generated by valac 0.20.1.7-00d05, the Vala compiler
 * generated from build_tools.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include "config.h"


#define TYPE_POST_PROCESSOR_TYPE (post_processor_type_get_type ())

#define TYPE_BUILD_JOB (build_job_get_type ())
typedef struct _BuildJob BuildJob;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BUILD_TOOL (build_tool_get_type ())
typedef struct _BuildTool BuildTool;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_BUILD_TOOLS (build_tools_get_type ())
#define BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS, BuildTools))
#define BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS, BuildToolsClass))
#define IS_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS))
#define IS_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS))
#define BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS, BuildToolsClass))

typedef struct _BuildTools BuildTools;
typedef struct _BuildToolsClass BuildToolsClass;
typedef struct _BuildToolsPrivate BuildToolsPrivate;
#define _build_tool_free0(var) ((var == NULL) ? NULL : (var = (build_tool_free (var), NULL)))
#define _g_markup_parse_context_free0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DEFAULT_BUILD_TOOLS (default_build_tools_get_type ())
#define DEFAULT_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEFAULT_BUILD_TOOLS, DefaultBuildTools))
#define DEFAULT_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEFAULT_BUILD_TOOLS, DefaultBuildToolsClass))
#define IS_DEFAULT_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEFAULT_BUILD_TOOLS))
#define IS_DEFAULT_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEFAULT_BUILD_TOOLS))
#define DEFAULT_BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEFAULT_BUILD_TOOLS, DefaultBuildToolsClass))

typedef struct _DefaultBuildTools DefaultBuildTools;
typedef struct _DefaultBuildToolsClass DefaultBuildToolsClass;
typedef struct _DefaultBuildToolsPrivate DefaultBuildToolsPrivate;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))

#define TYPE_PERSONAL_BUILD_TOOLS (personal_build_tools_get_type ())
#define PERSONAL_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PERSONAL_BUILD_TOOLS, PersonalBuildTools))
#define PERSONAL_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PERSONAL_BUILD_TOOLS, PersonalBuildToolsClass))
#define IS_PERSONAL_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PERSONAL_BUILD_TOOLS))
#define IS_PERSONAL_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PERSONAL_BUILD_TOOLS))
#define PERSONAL_BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PERSONAL_BUILD_TOOLS, PersonalBuildToolsClass))

typedef struct _PersonalBuildTools PersonalBuildTools;
typedef struct _PersonalBuildToolsClass PersonalBuildToolsClass;
typedef struct _PersonalBuildToolsPrivate PersonalBuildToolsPrivate;
#define _build_job_free0(var) ((var == NULL) ? NULL : (var = (build_job_free (var), NULL)))

typedef enum  {
	POST_PROCESSOR_TYPE_ALL_OUTPUT = 0,
	POST_PROCESSOR_TYPE_LATEX,
	POST_PROCESSOR_TYPE_LATEXMK,
	POST_PROCESSOR_TYPE_NO_OUTPUT,
	POST_PROCESSOR_TYPE_N_POST_PROCESSORS
} PostProcessorType;

struct _BuildJob {
	PostProcessorType post_processor;
	gchar* command;
};

struct _BuildTool {
	gchar* _description;
	gchar* extensions;
	gchar* label;
	gchar* icon;
	gchar* files_to_open;
	gboolean enabled;
	GeeArrayList* jobs;
	gint id;
};

struct _BuildTools {
	GObject parent_instance;
	BuildToolsPrivate * priv;
	GeeLinkedList* _build_tools;
	GFile* _xml_file;
};

struct _BuildToolsClass {
	GObjectClass parent_class;
};

struct _BuildToolsPrivate {
	BuildTool _cur_tool;
	BuildJob _cur_job;
};

struct _DefaultBuildTools {
	BuildTools parent_instance;
	DefaultBuildToolsPrivate * priv;
};

struct _DefaultBuildToolsClass {
	BuildToolsClass parent_class;
};

struct _PersonalBuildTools {
	BuildTools parent_instance;
	PersonalBuildToolsPrivate * priv;
};

struct _PersonalBuildToolsClass {
	BuildToolsClass parent_class;
};

struct _PersonalBuildToolsPrivate {
	gboolean _modified;
};


static gpointer build_tools_parent_class = NULL;
static gchar** build_tools__post_processor_names;
static gint build_tools__post_processor_names_length1;
static gchar** build_tools__post_processor_names = NULL;
static gint build_tools__post_processor_names_length1 = 0;
static gint _build_tools__post_processor_names_size_ = 0;
static gpointer default_build_tools_parent_class = NULL;
static DefaultBuildTools* default_build_tools__instance;
static DefaultBuildTools* default_build_tools__instance = NULL;
static gpointer personal_build_tools_parent_class = NULL;
static PersonalBuildTools* personal_build_tools__instance;
static PersonalBuildTools* personal_build_tools__instance = NULL;

GType post_processor_type_get_type (void) G_GNUC_CONST;
GType build_job_get_type (void) G_GNUC_CONST;
BuildJob* build_job_dup (const BuildJob* self);
void build_job_free (BuildJob* self);
void build_job_copy (const BuildJob* self, BuildJob* dest);
void build_job_destroy (BuildJob* self);
GType build_tool_get_type (void) G_GNUC_CONST;
BuildTool* build_tool_dup (const BuildTool* self);
void build_tool_free (BuildTool* self);
void build_tool_copy (const BuildTool* self, BuildTool* dest);
void build_tool_destroy (BuildTool* self);
void build_tool_init (BuildTool *self);
gboolean build_tool_has_jobs (BuildTool *self);
void build_tool_set_description (BuildTool *self, const gchar* description);
gchar* build_tool_get_description (BuildTool *self);
GType build_tools_get_type (void) G_GNUC_CONST;
#define BUILD_TOOLS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BUILD_TOOLS, BuildToolsPrivate))
enum  {
	BUILD_TOOLS_DUMMY_PROPERTY
};
BuildTool* build_tools_get_build_tool (BuildTools* self, gint tool_num);
gboolean build_tools_is_valid_index (BuildTools* self, gint tool_num);
GeeIterator* build_tools_iterator (BuildTools* self);
gboolean build_tools_is_empty (BuildTools* self);
void build_tools_set_enabled (BuildTools* self, gint tool_num, gboolean enabled);
PostProcessorType* build_tools_get_post_processor_type_from_name (const gchar* name);
static PostProcessorType* _post_processor_type_dup (PostProcessorType* self);
gchar* build_tools_get_post_processor_name_from_type (PostProcessorType type);
void build_tools_load (BuildTools* self);
gchar* utils_load_file (GFile* file);
static void build_tools_parser_start (BuildTools* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error);
static void _build_tools_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error);
static void build_tools_parser_end (BuildTools* self, GMarkupParseContext* context, const gchar* name, GError** error);
static void _build_tools_parser_end_gmarkup_parser_end_element_func (GMarkupParseContext* context, const gchar* element_name, gpointer self, GError** error);
static void build_tools_parser_text (BuildTools* self, GMarkupParseContext* context, const gchar* text, gsize text_len, GError** error);
static void _build_tools_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context, const gchar* text, gsize text_len, gpointer self, GError** error);
BuildTools* build_tools_construct (GType object_type);
static void build_tools_finalize (GObject* obj);
GType default_build_tools_get_type (void) G_GNUC_CONST;
enum  {
	DEFAULT_BUILD_TOOLS_DUMMY_PROPERTY
};
static DefaultBuildTools* default_build_tools_new (void);
static DefaultBuildTools* default_build_tools_construct (GType object_type);
static void default_build_tools_load_enable_setting (DefaultBuildTools* self);
static void default_build_tools_save_enable_setting (DefaultBuildTools* self);
static void _default_build_tools_save_enable_setting_build_tools_modified (BuildTools* _sender, gpointer self);
DefaultBuildTools* default_build_tools_get_default (void);
static void _vala_array_add9 (gint** array, int* length, int* size, gint value);
static gboolean _vala_int_array_contains (gint* stack, int stack_length, gint needle);
static void _vala_array_add10 (gint** array, int* length, int* size, gint value);
static void default_build_tools_finalize (GObject* obj);
GType personal_build_tools_get_type (void) G_GNUC_CONST;
#define PERSONAL_BUILD_TOOLS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PERSONAL_BUILD_TOOLS, PersonalBuildToolsPrivate))
enum  {
	PERSONAL_BUILD_TOOLS_DUMMY_PROPERTY
};
static PersonalBuildTools* personal_build_tools_new (void);
static PersonalBuildTools* personal_build_tools_construct (GType object_type);
static GFile* personal_build_tools_get_user_config_file (PersonalBuildTools* self);
static void __lambda53_ (PersonalBuildTools* self);
static void ___lambda53__build_tools_modified (BuildTools* _sender, gpointer self);
PersonalBuildTools* personal_build_tools_get_default (void);
void personal_build_tools_move_up (PersonalBuildTools* self, gint tool_num);
static void personal_build_tools_swap (PersonalBuildTools* self, gint tool_num1, gint tool_num2);
void personal_build_tools_move_down (PersonalBuildTools* self, gint tool_num);
void personal_build_tools_delete (PersonalBuildTools* self, gint tool_num);
void personal_build_tools_add (PersonalBuildTools* self, BuildTool* tool);
void personal_build_tools_insert (PersonalBuildTools* self, gint pos, BuildTool* tool);
void personal_build_tools_update (PersonalBuildTools* self, gint num, BuildTool* tool);
static gboolean personal_build_tools_is_equal (PersonalBuildTools* self, BuildTool* tool1, BuildTool* tool2);
void personal_build_tools_save (PersonalBuildTools* self);
gboolean utils_save_file (GFile* file, const gchar* contents, gboolean make_backup);
static void personal_build_tools_finalize (GObject* obj);
static gint _vala_array_length (gpointer array);


GType post_processor_type_get_type (void) {
	static volatile gsize post_processor_type_type_id__volatile = 0;
	if (g_once_init_enter (&post_processor_type_type_id__volatile)) {
		static const GEnumValue values[] = {{POST_PROCESSOR_TYPE_ALL_OUTPUT, "POST_PROCESSOR_TYPE_ALL_OUTPUT", "all-output"}, {POST_PROCESSOR_TYPE_LATEX, "POST_PROCESSOR_TYPE_LATEX", "latex"}, {POST_PROCESSOR_TYPE_LATEXMK, "POST_PROCESSOR_TYPE_LATEXMK", "latexmk"}, {POST_PROCESSOR_TYPE_NO_OUTPUT, "POST_PROCESSOR_TYPE_NO_OUTPUT", "no-output"}, {POST_PROCESSOR_TYPE_N_POST_PROCESSORS, "POST_PROCESSOR_TYPE_N_POST_PROCESSORS", "n-post-processors"}, {0, NULL, NULL}};
		GType post_processor_type_type_id;
		post_processor_type_type_id = g_enum_register_static ("PostProcessorType", values);
		g_once_init_leave (&post_processor_type_type_id__volatile, post_processor_type_type_id);
	}
	return post_processor_type_type_id__volatile;
}


void build_job_copy (const BuildJob* self, BuildJob* dest) {
	PostProcessorType _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = (*self).post_processor;
	(*dest).post_processor = _tmp0_;
	_tmp1_ = (*self).command;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 ((*dest).command);
	(*dest).command = _tmp2_;
}


void build_job_destroy (BuildJob* self) {
	_g_free0 ((*self).command);
}


BuildJob* build_job_dup (const BuildJob* self) {
	BuildJob* dup;
	dup = g_new0 (BuildJob, 1);
	build_job_copy (self, dup);
	return dup;
}


void build_job_free (BuildJob* self) {
	build_job_destroy (self);
	g_free (self);
}


GType build_job_get_type (void) {
	static volatile gsize build_job_type_id__volatile = 0;
	if (g_once_init_enter (&build_job_type_id__volatile)) {
		GType build_job_type_id;
		build_job_type_id = g_boxed_type_register_static ("BuildJob", (GBoxedCopyFunc) build_job_dup, (GBoxedFreeFunc) build_job_free);
		g_once_init_leave (&build_job_type_id__volatile, build_job_type_id);
	}
	return build_job_type_id__volatile;
}


void build_tool_init (BuildTool *self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GeeArrayList* _tmp5_;
	memset (self, 0, sizeof (BuildTool));
	_tmp0_ = g_strdup ("");
	_g_free0 ((*self)._description);
	(*self)._description = _tmp0_;
	_tmp1_ = g_strdup ("");
	_g_free0 ((*self).extensions);
	(*self).extensions = _tmp1_;
	_tmp2_ = g_strdup ("");
	_g_free0 ((*self).label);
	(*self).label = _tmp2_;
	_tmp3_ = g_strdup ("");
	_g_free0 ((*self).icon);
	(*self).icon = _tmp3_;
	_tmp4_ = g_strdup ("");
	_g_free0 ((*self).files_to_open);
	(*self).files_to_open = _tmp4_;
	(*self).enabled = FALSE;
	_tmp5_ = gee_array_list_new (TYPE_BUILD_JOB, (GBoxedCopyFunc) build_job_dup, build_job_free, NULL);
	_g_object_unref0 ((*self).jobs);
	(*self).jobs = _tmp5_;
	(*self).id = 0;
}


gboolean build_tool_has_jobs (BuildTool *self) {
	gboolean result = FALSE;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	_tmp0_ = (*self).jobs;
	_tmp1_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ > 0;
	return result;
}


void build_tool_set_description (BuildTool *self, const gchar* description) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (description != NULL);
	_tmp0_ = description;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*self)._description);
	(*self)._description = _tmp1_;
}


gchar* build_tool_get_description (BuildTool *self) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	_tmp1_ = (*self)._description;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = (*self)._description;
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = (*self).label;
		_tmp5_ = g_strdup (_tmp4_);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = (*self)._description;
	_tmp7_ = g_strdup (_tmp6_);
	result = _tmp7_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void build_tool_copy (const BuildTool* self, BuildTool* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
	GeeArrayList* _tmp11_;
	GeeArrayList* _tmp12_;
	gint _tmp13_;
	_tmp0_ = (*self)._description;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest)._description);
	(*dest)._description = _tmp1_;
	_tmp2_ = (*self).extensions;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).extensions);
	(*dest).extensions = _tmp3_;
	_tmp4_ = (*self).label;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).label);
	(*dest).label = _tmp5_;
	_tmp6_ = (*self).icon;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).icon);
	(*dest).icon = _tmp7_;
	_tmp8_ = (*self).files_to_open;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 ((*dest).files_to_open);
	(*dest).files_to_open = _tmp9_;
	_tmp10_ = (*self).enabled;
	(*dest).enabled = _tmp10_;
	_tmp11_ = (*self).jobs;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_g_object_unref0 ((*dest).jobs);
	(*dest).jobs = _tmp12_;
	_tmp13_ = (*self).id;
	(*dest).id = _tmp13_;
}


void build_tool_destroy (BuildTool* self) {
	_g_free0 ((*self)._description);
	_g_free0 ((*self).extensions);
	_g_free0 ((*self).label);
	_g_free0 ((*self).icon);
	_g_free0 ((*self).files_to_open);
	_g_object_unref0 ((*self).jobs);
}


BuildTool* build_tool_dup (const BuildTool* self) {
	BuildTool* dup;
	dup = g_new0 (BuildTool, 1);
	build_tool_copy (self, dup);
	return dup;
}


void build_tool_free (BuildTool* self) {
	build_tool_destroy (self);
	g_free (self);
}


GType build_tool_get_type (void) {
	static volatile gsize build_tool_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_type_id__volatile)) {
		GType build_tool_type_id;
		build_tool_type_id = g_boxed_type_register_static ("BuildTool", (GBoxedCopyFunc) build_tool_dup, (GBoxedFreeFunc) build_tool_free);
		g_once_init_leave (&build_tool_type_id__volatile, build_tool_type_id);
	}
	return build_tool_type_id__volatile;
}


BuildTool* build_tools_get_build_tool (BuildTools* self, gint tool_num) {
	BuildTool* result = NULL;
	gint _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeLinkedList* _tmp2_;
	gint _tmp3_;
	gpointer _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = tool_num;
	_tmp1_ = build_tools_is_valid_index (self, _tmp0_);
	g_return_val_if_fail (_tmp1_, NULL);
	_tmp2_ = self->_build_tools;
	_tmp3_ = tool_num;
	_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _tmp2_, _tmp3_);
	result = (BuildTool*) _tmp4_;
	return result;
}


GeeIterator* build_tools_iterator (BuildTools* self) {
	GeeIterator* result = NULL;
	GeeLinkedList* _tmp0_;
	GeeIterator* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->_build_tools;
	_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
	result = _tmp1_;
	return result;
}


gboolean build_tools_is_empty (BuildTools* self) {
	gboolean result = FALSE;
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->_build_tools;
	_tmp1_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ == 0;
	return result;
}


void build_tools_set_enabled (BuildTools* self, gint tool_num, gboolean enabled) {
	gint _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeLinkedList* _tmp2_;
	gint _tmp3_;
	gpointer _tmp4_ = NULL;
	BuildTool* _tmp5_;
	BuildTool _tmp6_ = {0};
	BuildTool _tmp7_;
	BuildTool tool;
	BuildTool _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tool_num;
	_tmp1_ = build_tools_is_valid_index (self, _tmp0_);
	g_return_if_fail (_tmp1_);
	_tmp2_ = self->_build_tools;
	_tmp3_ = tool_num;
	_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _tmp2_, _tmp3_);
	_tmp5_ = (BuildTool*) _tmp4_;
	build_tool_copy (_tmp5_, &_tmp6_);
	_tmp7_ = _tmp6_;
	_build_tool_free0 (_tmp5_);
	tool = _tmp7_;
	_tmp8_ = tool;
	_tmp9_ = _tmp8_.enabled;
	_tmp10_ = enabled;
	if (_tmp9_ != _tmp10_) {
		gboolean _tmp11_;
		GeeLinkedList* _tmp12_;
		gint _tmp13_;
		BuildTool _tmp14_;
		_tmp11_ = enabled;
		tool.enabled = _tmp11_;
		_tmp12_ = self->_build_tools;
		_tmp13_ = tool_num;
		_tmp14_ = tool;
		gee_abstract_list_set ((GeeAbstractList*) _tmp12_, _tmp13_, &_tmp14_);
		g_signal_emit_by_name (self, "modified");
	}
	build_tool_destroy (&tool);
}


static PostProcessorType* _post_processor_type_dup (PostProcessorType* self) {
	PostProcessorType* dup;
	dup = g_new0 (PostProcessorType, 1);
	memcpy (dup, self, sizeof (PostProcessorType));
	return dup;
}


static gpointer __post_processor_type_dup0 (gpointer self) {
	return self ? _post_processor_type_dup (self) : NULL;
}


PostProcessorType* build_tools_get_post_processor_type_from_name (const gchar* name) {
	PostProcessorType* result = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	{
		gint type;
		type = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gchar** _tmp4_;
				gint _tmp4__length1;
				gint _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = type;
					type = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = type;
				if (!(_tmp3_ < ((gint) POST_PROCESSOR_TYPE_N_POST_PROCESSORS))) {
					break;
				}
				_tmp4_ = build_tools__post_processor_names;
				_tmp4__length1 = build_tools__post_processor_names_length1;
				_tmp5_ = type;
				_tmp6_ = _tmp4_[_tmp5_];
				_tmp7_ = name;
				if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
					gint _tmp8_;
					PostProcessorType _tmp9_;
					PostProcessorType* _tmp10_;
					_tmp8_ = type;
					_tmp9_ = (PostProcessorType) _tmp8_;
					_tmp10_ = __post_processor_type_dup0 (&_tmp9_);
					result = _tmp10_;
					return result;
				}
			}
		}
	}
	g_return_val_if_reached (NULL);
}


gchar* build_tools_get_post_processor_name_from_type (PostProcessorType type) {
	gchar* result = NULL;
	PostProcessorType _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	PostProcessorType _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	_tmp0_ = type;
	g_return_val_if_fail (_tmp0_ != POST_PROCESSOR_TYPE_N_POST_PROCESSORS, NULL);
	_tmp1_ = build_tools__post_processor_names;
	_tmp1__length1 = build_tools__post_processor_names_length1;
	_tmp2_ = type;
	_tmp3_ = _tmp1_[_tmp2_];
	_tmp4_ = g_strdup (_tmp3_);
	result = _tmp4_;
	return result;
}


gboolean build_tools_is_valid_index (BuildTools* self, gint tool_num) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = tool_num;
	if (0 <= _tmp1_) {
		gint _tmp2_;
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp2_ = tool_num;
		_tmp3_ = self->_build_tools;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp2_ < _tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp6_ = _tmp0_;
	result = _tmp6_;
	return result;
}


static void _build_tools_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error) {
	build_tools_parser_start (self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
}


static void _build_tools_parser_end_gmarkup_parser_end_element_func (GMarkupParseContext* context, const gchar* element_name, gpointer self, GError** error) {
	build_tools_parser_end (self, context, element_name, error);
}


static void _build_tools_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context, const gchar* text, gsize text_len, gpointer self, GError** error) {
	build_tools_parser_text (self, context, text, text_len, error);
}


void build_tools_load (BuildTools* self) {
	GeeLinkedList* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* contents;
	const gchar* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_linked_list_new (TYPE_BUILD_TOOL, (GBoxedCopyFunc) build_tool_dup, build_tool_free, NULL);
	_g_object_unref0 (self->_build_tools);
	self->_build_tools = _tmp0_;
	_tmp1_ = self->_xml_file;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = self->_xml_file;
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
	if (!_tmp3_) {
		return;
	}
	_tmp4_ = self->_xml_file;
	_tmp5_ = utils_load_file (_tmp4_);
	contents = _tmp5_;
	_tmp6_ = contents;
	if (_tmp6_ == NULL) {
		_g_free0 (contents);
		return;
	}
	{
		GMarkupParser _tmp7_ = {0};
		GMarkupParser parser;
		GMarkupParser _tmp8_;
		GMarkupParseContext* _tmp9_;
		GMarkupParseContext* context;
		GMarkupParseContext* _tmp10_;
		const gchar* _tmp11_;
		_tmp7_.start_element = _build_tools_parser_start_gmarkup_parser_start_element_func;
		_tmp7_.end_element = _build_tools_parser_end_gmarkup_parser_end_element_func;
		_tmp7_.text = _build_tools_parser_text_gmarkup_parser_text_func;
		_tmp7_.passthrough = NULL;
		_tmp7_.error = NULL;
		parser = _tmp7_;
		_tmp8_ = parser;
		_tmp9_ = g_markup_parse_context_new (&_tmp8_, 0, self, NULL);
		context = _tmp9_;
		_tmp10_ = context;
		_tmp11_ = contents;
		g_markup_parse_context_parse (_tmp10_, _tmp11_, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_markup_parse_context_free0 (context);
			goto __catch9_g_error;
		}
		_g_markup_parse_context_free0 (context);
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("build_tools.vala:179: Impossible to load build tools: %s", _tmp13_);
		_g_error_free0 (e);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (contents);
}


static gboolean bool_parse (const gchar* str) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	if (g_strcmp0 (_tmp0_, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static void build_tools_parser_start (BuildTools* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if ((((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("tools")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("label"))))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("description"))))) || (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("open"))))) {
		switch (0) {
			default:
			{
				return;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("tool")))) {
		switch (0) {
			default:
			{
				build_tool_destroy (&self->priv->_cur_tool);
				build_tool_init (&self->priv->_cur_tool);
				{
					gint i;
					i = 0;
					{
						gboolean _tmp4_;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_;
							gint _tmp7_;
							gchar** _tmp8_;
							gint _tmp8__length1;
							gchar** _tmp9_;
							gint _tmp9__length1;
							gint _tmp10_;
							const gchar* _tmp11_;
							const gchar* _tmp12_;
							GQuark _tmp14_ = 0U;
							static GQuark _tmp13_label0 = 0;
							static GQuark _tmp13_label1 = 0;
							static GQuark _tmp13_label2 = 0;
							static GQuark _tmp13_label3 = 0;
							static GQuark _tmp13_label4 = 0;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_;
								_tmp6_ = i;
								i = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = i;
							_tmp8_ = attr_names;
							_tmp8__length1 = attr_names_length1;
							if (!(_tmp7_ < _tmp8__length1)) {
								break;
							}
							_tmp9_ = attr_names;
							_tmp9__length1 = attr_names_length1;
							_tmp10_ = i;
							_tmp11_ = _tmp9_[_tmp10_];
							_tmp12_ = _tmp11_;
							_tmp14_ = (NULL == _tmp12_) ? 0 : g_quark_from_string (_tmp12_);
							if (_tmp14_ == ((0 != _tmp13_label0) ? _tmp13_label0 : (_tmp13_label0 = g_quark_from_static_string ("id")))) {
								switch (0) {
									default:
									{
										gchar** _tmp15_;
										gint _tmp15__length1;
										gint _tmp16_;
										const gchar* _tmp17_;
										gint _tmp18_ = 0;
										_tmp15_ = attr_values;
										_tmp15__length1 = attr_values_length1;
										_tmp16_ = i;
										_tmp17_ = _tmp15_[_tmp16_];
										_tmp18_ = atoi (_tmp17_);
										self->priv->_cur_tool.id = _tmp18_;
										break;
									}
								}
							} else if ((_tmp14_ == ((0 != _tmp13_label1) ? _tmp13_label1 : (_tmp13_label1 = g_quark_from_static_string ("show")))) || (_tmp14_ == ((0 != _tmp13_label2) ? _tmp13_label2 : (_tmp13_label2 = g_quark_from_static_string ("enabled"))))) {
								switch (0) {
									default:
									{
										gchar** _tmp19_;
										gint _tmp19__length1;
										gint _tmp20_;
										const gchar* _tmp21_;
										gboolean _tmp22_ = FALSE;
										_tmp19_ = attr_values;
										_tmp19__length1 = attr_values_length1;
										_tmp20_ = i;
										_tmp21_ = _tmp19_[_tmp20_];
										_tmp22_ = bool_parse (_tmp21_);
										self->priv->_cur_tool.enabled = _tmp22_;
										break;
									}
								}
							} else if (_tmp14_ == ((0 != _tmp13_label3) ? _tmp13_label3 : (_tmp13_label3 = g_quark_from_static_string ("extensions")))) {
								switch (0) {
									default:
									{
										gchar** _tmp23_;
										gint _tmp23__length1;
										gint _tmp24_;
										const gchar* _tmp25_;
										gchar* _tmp26_;
										_tmp23_ = attr_values;
										_tmp23__length1 = attr_values_length1;
										_tmp24_ = i;
										_tmp25_ = _tmp23_[_tmp24_];
										_tmp26_ = g_strdup (_tmp25_);
										_g_free0 (self->priv->_cur_tool.extensions);
										self->priv->_cur_tool.extensions = _tmp26_;
										break;
									}
								}
							} else if (_tmp14_ == ((0 != _tmp13_label4) ? _tmp13_label4 : (_tmp13_label4 = g_quark_from_static_string ("icon")))) {
								switch (0) {
									default:
									{
										gchar** _tmp27_;
										gint _tmp27__length1;
										gint _tmp28_;
										const gchar* _tmp29_;
										gchar* _tmp30_;
										_tmp27_ = attr_values;
										_tmp27__length1 = attr_values_length1;
										_tmp28_ = i;
										_tmp29_ = _tmp27_[_tmp28_];
										_tmp30_ = g_strdup (_tmp29_);
										_g_free0 (self->priv->_cur_tool.icon);
										self->priv->_cur_tool.icon = _tmp30_;
										break;
									}
								}
							} else {
								switch (0) {
									default:
									{
										gchar** _tmp31_;
										gint _tmp31__length1;
										gint _tmp32_;
										const gchar* _tmp33_;
										gchar* _tmp34_;
										gchar* _tmp35_;
										gchar* _tmp36_;
										gchar* _tmp37_;
										GError* _tmp38_;
										GError* _tmp39_;
										_tmp31_ = attr_names;
										_tmp31__length1 = attr_names_length1;
										_tmp32_ = i;
										_tmp33_ = _tmp31_[_tmp32_];
										_tmp34_ = g_strconcat ("unknown attribute \"", _tmp33_, NULL);
										_tmp35_ = _tmp34_;
										_tmp36_ = g_strconcat (_tmp35_, "\"", NULL);
										_tmp37_ = _tmp36_;
										_tmp38_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp37_);
										_tmp39_ = _tmp38_;
										_g_free0 (_tmp37_);
										_g_free0 (_tmp35_);
										_inner_error_ = _tmp39_;
										if (_inner_error_->domain == G_MARKUP_ERROR) {
											g_propagate_error (error, _inner_error_);
											return;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
									}
								}
							}
						}
					}
				}
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("job")))) {
		switch (0) {
			default:
			{
				build_job_destroy (&self->priv->_cur_job);
				memset (&self->priv->_cur_job, 0, sizeof (BuildJob));
				{
					gint i;
					i = 0;
					{
						gboolean _tmp40_;
						_tmp40_ = TRUE;
						while (TRUE) {
							gboolean _tmp41_;
							gint _tmp43_;
							gchar** _tmp44_;
							gint _tmp44__length1;
							gchar** _tmp45_;
							gint _tmp45__length1;
							gint _tmp46_;
							const gchar* _tmp47_;
							const gchar* _tmp48_;
							GQuark _tmp50_ = 0U;
							static GQuark _tmp49_label0 = 0;
							static GQuark _tmp49_label1 = 0;
							_tmp41_ = _tmp40_;
							if (!_tmp41_) {
								gint _tmp42_;
								_tmp42_ = i;
								i = _tmp42_ + 1;
							}
							_tmp40_ = FALSE;
							_tmp43_ = i;
							_tmp44_ = attr_names;
							_tmp44__length1 = attr_names_length1;
							if (!(_tmp43_ < _tmp44__length1)) {
								break;
							}
							_tmp45_ = attr_names;
							_tmp45__length1 = attr_names_length1;
							_tmp46_ = i;
							_tmp47_ = _tmp45_[_tmp46_];
							_tmp48_ = _tmp47_;
							_tmp50_ = (NULL == _tmp48_) ? 0 : g_quark_from_string (_tmp48_);
							if (_tmp50_ == ((0 != _tmp49_label0) ? _tmp49_label0 : (_tmp49_label0 = g_quark_from_static_string ("postProcessor")))) {
								switch (0) {
									default:
									{
										gchar** _tmp51_;
										gint _tmp51__length1;
										gint _tmp52_;
										const gchar* _tmp53_;
										PostProcessorType* _tmp54_ = NULL;
										PostProcessorType* _tmp55_;
										_tmp51_ = attr_values;
										_tmp51__length1 = attr_values_length1;
										_tmp52_ = i;
										_tmp53_ = _tmp51_[_tmp52_];
										_tmp54_ = build_tools_get_post_processor_type_from_name (_tmp53_);
										_tmp55_ = _tmp54_;
										self->priv->_cur_job.post_processor = *_tmp55_;
										_g_free0 (_tmp55_);
										break;
									}
								}
							} else if (_tmp50_ == ((0 != _tmp49_label1) ? _tmp49_label1 : (_tmp49_label1 = g_quark_from_static_string ("mustSucceed")))) {
								switch (0) {
									default:
									{
										break;
									}
								}
							} else {
								switch (0) {
									default:
									{
										gchar** _tmp56_;
										gint _tmp56__length1;
										gint _tmp57_;
										const gchar* _tmp58_;
										gchar* _tmp59_;
										gchar* _tmp60_;
										gchar* _tmp61_;
										gchar* _tmp62_;
										GError* _tmp63_;
										GError* _tmp64_;
										_tmp56_ = attr_names;
										_tmp56__length1 = attr_names_length1;
										_tmp57_ = i;
										_tmp58_ = _tmp56_[_tmp57_];
										_tmp59_ = g_strconcat ("unknown attribute \"", _tmp58_, NULL);
										_tmp60_ = _tmp59_;
										_tmp61_ = g_strconcat (_tmp60_, "\"", NULL);
										_tmp62_ = _tmp61_;
										_tmp63_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp62_);
										_tmp64_ = _tmp63_;
										_g_free0 (_tmp62_);
										_g_free0 (_tmp60_);
										_inner_error_ = _tmp64_;
										if (_inner_error_->domain == G_MARKUP_ERROR) {
											g_propagate_error (error, _inner_error_);
											return;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
									}
								}
							}
						}
					}
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp65_;
				gchar* _tmp66_;
				gchar* _tmp67_;
				gchar* _tmp68_;
				gchar* _tmp69_;
				GError* _tmp70_;
				GError* _tmp71_;
				_tmp65_ = name;
				_tmp66_ = g_strconcat ("unknown element \"", _tmp65_, NULL);
				_tmp67_ = _tmp66_;
				_tmp68_ = g_strconcat (_tmp67_, "\"", NULL);
				_tmp69_ = _tmp68_;
				_tmp70_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp69_);
				_tmp71_ = _tmp70_;
				_g_free0 (_tmp69_);
				_g_free0 (_tmp67_);
				_inner_error_ = _tmp71_;
				if (_inner_error_->domain == G_MARKUP_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static void build_tools_parser_end (BuildTools* self, GMarkupParseContext* context, const gchar* name, GError** error) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if ((((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("tools")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("label"))))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("description"))))) || (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("open"))))) {
		switch (0) {
			default:
			{
				return;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("tool")))) {
		switch (0) {
			default:
			{
				GeeLinkedList* _tmp4_;
				BuildTool _tmp5_;
				_tmp4_ = self->_build_tools;
				_tmp5_ = self->priv->_cur_tool;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, &_tmp5_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("job")))) {
		switch (0) {
			default:
			{
				BuildTool _tmp6_;
				GeeArrayList* _tmp7_;
				BuildJob _tmp8_;
				_tmp6_ = self->priv->_cur_tool;
				_tmp7_ = _tmp6_.jobs;
				_tmp8_ = self->priv->_cur_job;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, &_tmp8_);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				GError* _tmp14_;
				GError* _tmp15_;
				_tmp9_ = name;
				_tmp10_ = g_strconcat ("unknown element \"", _tmp9_, NULL);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_strconcat (_tmp11_, "\"", NULL);
				_tmp13_ = _tmp12_;
				_tmp14_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp13_);
				_tmp15_ = _tmp14_;
				_g_free0 (_tmp13_);
				_g_free0 (_tmp11_);
				_inner_error_ = _tmp15_;
				if (_inner_error_->domain == G_MARKUP_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void build_tools_parser_text (BuildTools* self, GMarkupParseContext* context, const gchar* text, gsize text_len, GError** error) {
	GMarkupParseContext* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	static GQuark _tmp3_label3 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = context;
	_tmp1_ = g_markup_parse_context_get_element (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("job")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp5_;
				gchar* _tmp6_ = NULL;
				_tmp5_ = text;
				_tmp6_ = string_strip (_tmp5_);
				_g_free0 (self->priv->_cur_job.command);
				self->priv->_cur_job.command = _tmp6_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("label")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp7_;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_;
				const gchar* _tmp10_ = NULL;
				gchar* _tmp11_;
				_tmp7_ = text;
				_tmp8_ = string_strip (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = _ (_tmp9_);
				_tmp11_ = g_strdup (_tmp10_);
				_g_free0 (self->priv->_cur_tool.label);
				self->priv->_cur_tool.label = _tmp11_;
				_g_free0 (_tmp9_);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("description")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp12_;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				const gchar* _tmp15_ = NULL;
				_tmp12_ = text;
				_tmp13_ = string_strip (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = _ (_tmp14_);
				build_tool_set_description (&self->priv->_cur_tool, _tmp15_);
				_g_free0 (_tmp14_);
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label3) ? _tmp3_label3 : (_tmp3_label3 = g_quark_from_static_string ("open")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp16_;
				gchar* _tmp17_ = NULL;
				_tmp16_ = text;
				_tmp17_ = string_strip (_tmp16_);
				_g_free0 (self->priv->_cur_tool.files_to_open);
				self->priv->_cur_tool.files_to_open = _tmp17_;
				break;
			}
		}
	}
}


BuildTools* build_tools_construct (GType object_type) {
	BuildTools * self = NULL;
	self = (BuildTools*) g_object_new (object_type, NULL);
	return self;
}


static void build_tools_class_init (BuildToolsClass * klass) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_ = NULL;
	build_tools_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BuildToolsPrivate));
	G_OBJECT_CLASS (klass)->finalize = build_tools_finalize;
	g_signal_new ("modified", TYPE_BUILD_TOOLS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = g_strdup ("all-output");
	_tmp1_ = g_strdup ("latex");
	_tmp2_ = g_strdup ("latexmk");
	_tmp3_ = g_strdup ("no-output");
	_tmp4_ = g_new0 (gchar*, 4 + 1);
	_tmp4_[0] = _tmp0_;
	_tmp4_[1] = _tmp1_;
	_tmp4_[2] = _tmp2_;
	_tmp4_[3] = _tmp3_;
	build_tools__post_processor_names = _tmp4_;
	build_tools__post_processor_names_length1 = 4;
}


static void build_tools_instance_init (BuildTools * self) {
	self->priv = BUILD_TOOLS_GET_PRIVATE (self);
	self->_xml_file = NULL;
}


static void build_tools_finalize (GObject* obj) {
	BuildTools * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BUILD_TOOLS, BuildTools);
	_g_object_unref0 (self->_build_tools);
	_g_object_unref0 (self->_xml_file);
	build_tool_destroy (&self->priv->_cur_tool);
	build_job_destroy (&self->priv->_cur_job);
	G_OBJECT_CLASS (build_tools_parent_class)->finalize (obj);
}


GType build_tools_get_type (void) {
	static volatile gsize build_tools_type_id__volatile = 0;
	if (g_once_init_enter (&build_tools_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BuildToolsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) build_tools_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuildTools), 0, (GInstanceInitFunc) build_tools_instance_init, NULL };
		GType build_tools_type_id;
		build_tools_type_id = g_type_register_static (G_TYPE_OBJECT, "BuildTools", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&build_tools_type_id__volatile, build_tools_type_id);
	}
	return build_tools_type_id__volatile;
}


static void _default_build_tools_save_enable_setting_build_tools_modified (BuildTools* _sender, gpointer self) {
	default_build_tools_save_enable_setting (self);
}


static DefaultBuildTools* default_build_tools_construct (GType object_type) {
	DefaultBuildTools * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* path;
	GFile* _tmp1_ = NULL;
	self = (DefaultBuildTools*) build_tools_construct (object_type);
	_tmp0_ = g_build_filename (DATA_DIR, "build_tools.xml", NULL);
	path = _tmp0_;
	_tmp1_ = g_file_new_for_path (path);
	_g_object_unref0 (((BuildTools*) self)->_xml_file);
	((BuildTools*) self)->_xml_file = _tmp1_;
	build_tools_load ((BuildTools*) self);
	default_build_tools_load_enable_setting (self);
	g_signal_connect_object ((BuildTools*) self, "modified", (GCallback) _default_build_tools_save_enable_setting_build_tools_modified, self, 0);
	_g_free0 (path);
	return self;
}


static DefaultBuildTools* default_build_tools_new (void) {
	return default_build_tools_construct (TYPE_DEFAULT_BUILD_TOOLS);
}


DefaultBuildTools* default_build_tools_get_default (void) {
	DefaultBuildTools* result = NULL;
	DefaultBuildTools* _tmp0_;
	DefaultBuildTools* _tmp2_;
	DefaultBuildTools* _tmp3_;
	_tmp0_ = default_build_tools__instance;
	if (_tmp0_ == NULL) {
		DefaultBuildTools* _tmp1_;
		_tmp1_ = default_build_tools_new ();
		_g_object_unref0 (default_build_tools__instance);
		default_build_tools__instance = _tmp1_;
	}
	_tmp2_ = default_build_tools__instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static void _vala_array_add9 (gint** array, int* length, int* size, gint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static gboolean _vala_int_array_contains (gint* stack, int stack_length, gint needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _vala_array_add10 (gint** array, int* length, int* size, gint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void default_build_tools_load_enable_setting (DefaultBuildTools* self) {
	GSettings* _tmp0_;
	GSettings* settings;
	gint* _tmp1_ = NULL;
	gint* enabled_tool_ids;
	gint enabled_tool_ids_length1;
	gint _enabled_tool_ids_size_;
	GSettings* _tmp2_;
	GVariant* _tmp3_ = NULL;
	GVariant* enabled_tools;
	GVariantIter* iter = NULL;
	GVariant* _tmp4_;
	gint enabled_tool_id = 0;
	gint tool_num;
	gint* _tmp28_ = NULL;
	gint* disabled_tool_ids;
	gint disabled_tool_ids_length1;
	gint _disabled_tool_ids_size_;
	GSettings* _tmp29_;
	GVariant* _tmp30_ = NULL;
	GVariant* disabled_tools;
	GVariant* _tmp31_;
	gint disabled_tool_id = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.latex");
	settings = _tmp0_;
	_tmp1_ = g_new0 (gint, 0);
	enabled_tool_ids = _tmp1_;
	enabled_tool_ids_length1 = 0;
	_enabled_tool_ids_size_ = enabled_tool_ids_length1;
	_tmp2_ = settings;
	_tmp3_ = g_settings_get_value (_tmp2_, "enabled-default-build-tools");
	enabled_tools = _tmp3_;
	_tmp4_ = enabled_tools;
	g_variant_get (_tmp4_, "ai", &iter, NULL);
	while (TRUE) {
		GVariantIter* _tmp5_;
		gboolean _tmp6_ = FALSE;
		gint* _tmp7_;
		gint _tmp7__length1;
		gint _tmp8_;
		_tmp5_ = iter;
		_tmp6_ = g_variant_iter_next (_tmp5_, "i", &enabled_tool_id, NULL);
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = enabled_tool_ids;
		_tmp7__length1 = enabled_tool_ids_length1;
		_tmp8_ = enabled_tool_id;
		_vala_array_add9 (&enabled_tool_ids, &enabled_tool_ids_length1, &_enabled_tool_ids_size_, _tmp8_);
	}
	tool_num = 0;
	{
		GeeLinkedList* _tmp9_;
		GeeLinkedList* _tmp10_;
		GeeLinkedList* _build_tool_list;
		GeeLinkedList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _build_tool_size;
		gint _build_tool_index;
		_tmp9_ = ((BuildTools*) self)->_build_tools;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_build_tool_list = _tmp10_;
		_tmp11_ = _build_tool_list;
		_tmp12_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_build_tool_size = _tmp13_;
		_build_tool_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			GeeLinkedList* _tmp17_;
			gint _tmp18_;
			gpointer _tmp19_ = NULL;
			BuildTool* _tmp20_;
			BuildTool _tmp21_ = {0};
			BuildTool _tmp22_;
			BuildTool build_tool;
			BuildTool _tmp23_;
			gint _tmp24_;
			gint* _tmp25_;
			gint _tmp25__length1;
			gint _tmp27_;
			_tmp14_ = _build_tool_index;
			_build_tool_index = _tmp14_ + 1;
			_tmp15_ = _build_tool_index;
			_tmp16_ = _build_tool_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _build_tool_list;
			_tmp18_ = _build_tool_index;
			_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _tmp18_);
			_tmp20_ = (BuildTool*) _tmp19_;
			build_tool_copy (_tmp20_, &_tmp21_);
			_tmp22_ = _tmp21_;
			_build_tool_free0 (_tmp20_);
			build_tool = _tmp22_;
			_tmp23_ = build_tool;
			_tmp24_ = _tmp23_.id;
			_tmp25_ = enabled_tool_ids;
			_tmp25__length1 = enabled_tool_ids_length1;
			if (_vala_int_array_contains (_tmp25_, _tmp25__length1, _tmp24_)) {
				gint _tmp26_;
				_tmp26_ = tool_num;
				build_tools_set_enabled ((BuildTools*) self, _tmp26_, TRUE);
			}
			_tmp27_ = tool_num;
			tool_num = _tmp27_ + 1;
			build_tool_destroy (&build_tool);
		}
		_g_object_unref0 (_build_tool_list);
	}
	_tmp28_ = g_new0 (gint, 0);
	disabled_tool_ids = _tmp28_;
	disabled_tool_ids_length1 = 0;
	_disabled_tool_ids_size_ = disabled_tool_ids_length1;
	_tmp29_ = settings;
	_tmp30_ = g_settings_get_value (_tmp29_, "disabled-default-build-tools");
	disabled_tools = _tmp30_;
	_tmp31_ = disabled_tools;
	g_variant_get (_tmp31_, "ai", &iter, NULL);
	while (TRUE) {
		GVariantIter* _tmp32_;
		gboolean _tmp33_ = FALSE;
		gint* _tmp34_;
		gint _tmp34__length1;
		gint _tmp35_;
		_tmp32_ = iter;
		_tmp33_ = g_variant_iter_next (_tmp32_, "i", &disabled_tool_id, NULL);
		if (!_tmp33_) {
			break;
		}
		_tmp34_ = disabled_tool_ids;
		_tmp34__length1 = disabled_tool_ids_length1;
		_tmp35_ = disabled_tool_id;
		_vala_array_add10 (&disabled_tool_ids, &disabled_tool_ids_length1, &_disabled_tool_ids_size_, _tmp35_);
	}
	tool_num = 0;
	{
		GeeLinkedList* _tmp36_;
		GeeLinkedList* _tmp37_;
		GeeLinkedList* _build_tool_list;
		GeeLinkedList* _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		gint _build_tool_size;
		gint _build_tool_index;
		_tmp36_ = ((BuildTools*) self)->_build_tools;
		_tmp37_ = _g_object_ref0 (_tmp36_);
		_build_tool_list = _tmp37_;
		_tmp38_ = _build_tool_list;
		_tmp39_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp38_);
		_tmp40_ = _tmp39_;
		_build_tool_size = _tmp40_;
		_build_tool_index = -1;
		while (TRUE) {
			gint _tmp41_;
			gint _tmp42_;
			gint _tmp43_;
			GeeLinkedList* _tmp44_;
			gint _tmp45_;
			gpointer _tmp46_ = NULL;
			BuildTool* _tmp47_;
			BuildTool _tmp48_ = {0};
			BuildTool _tmp49_;
			BuildTool build_tool;
			BuildTool _tmp50_;
			gint _tmp51_;
			gint* _tmp52_;
			gint _tmp52__length1;
			gint _tmp54_;
			_tmp41_ = _build_tool_index;
			_build_tool_index = _tmp41_ + 1;
			_tmp42_ = _build_tool_index;
			_tmp43_ = _build_tool_size;
			if (!(_tmp42_ < _tmp43_)) {
				break;
			}
			_tmp44_ = _build_tool_list;
			_tmp45_ = _build_tool_index;
			_tmp46_ = gee_abstract_list_get ((GeeAbstractList*) _tmp44_, _tmp45_);
			_tmp47_ = (BuildTool*) _tmp46_;
			build_tool_copy (_tmp47_, &_tmp48_);
			_tmp49_ = _tmp48_;
			_build_tool_free0 (_tmp47_);
			build_tool = _tmp49_;
			_tmp50_ = build_tool;
			_tmp51_ = _tmp50_.id;
			_tmp52_ = disabled_tool_ids;
			_tmp52__length1 = disabled_tool_ids_length1;
			if (_vala_int_array_contains (_tmp52_, _tmp52__length1, _tmp51_)) {
				gint _tmp53_;
				_tmp53_ = tool_num;
				build_tools_set_enabled ((BuildTools*) self, _tmp53_, FALSE);
			}
			_tmp54_ = tool_num;
			tool_num = _tmp54_ + 1;
			build_tool_destroy (&build_tool);
		}
		_g_object_unref0 (_build_tool_list);
	}
	_g_variant_unref0 (disabled_tools);
	disabled_tool_ids = (g_free (disabled_tool_ids), NULL);
	_g_variant_iter_free0 (iter);
	_g_variant_unref0 (enabled_tools);
	enabled_tool_ids = (g_free (enabled_tool_ids), NULL);
	_g_object_unref0 (settings);
}


static void default_build_tools_save_enable_setting (DefaultBuildTools* self) {
	const GVariantType* _tmp0_;
	GVariantBuilder* _tmp1_;
	GVariantBuilder* builder_enabled;
	const GVariantType* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* builder_disabled;
	GVariantBuilder* _tmp26_;
	GVariant* _tmp27_ = NULL;
	GVariant* enabled_tools;
	GVariantBuilder* _tmp28_;
	GVariant* _tmp29_ = NULL;
	GVariant* disabled_tools;
	GSettings* _tmp30_;
	GSettings* settings;
	g_return_if_fail (self != NULL);
	_tmp0_ = G_VARIANT_TYPE_ARRAY;
	_tmp1_ = g_variant_builder_new (_tmp0_);
	builder_enabled = _tmp1_;
	_tmp2_ = G_VARIANT_TYPE_ARRAY;
	_tmp3_ = g_variant_builder_new (_tmp2_);
	builder_disabled = _tmp3_;
	{
		GeeLinkedList* _tmp4_;
		GeeLinkedList* _tmp5_;
		GeeLinkedList* _build_tool_list;
		GeeLinkedList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _build_tool_size;
		gint _build_tool_index;
		_tmp4_ = ((BuildTools*) self)->_build_tools;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_build_tool_list = _tmp5_;
		_tmp6_ = _build_tool_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_build_tool_size = _tmp8_;
		_build_tool_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			GeeLinkedList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_ = NULL;
			BuildTool* _tmp15_;
			BuildTool _tmp16_ = {0};
			BuildTool _tmp17_;
			BuildTool build_tool;
			BuildTool _tmp18_;
			gboolean _tmp19_;
			_tmp9_ = _build_tool_index;
			_build_tool_index = _tmp9_ + 1;
			_tmp10_ = _build_tool_index;
			_tmp11_ = _build_tool_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _build_tool_list;
			_tmp13_ = _build_tool_index;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
			_tmp15_ = (BuildTool*) _tmp14_;
			build_tool_copy (_tmp15_, &_tmp16_);
			_tmp17_ = _tmp16_;
			_build_tool_free0 (_tmp15_);
			build_tool = _tmp17_;
			_tmp18_ = build_tool;
			_tmp19_ = _tmp18_.enabled;
			if (_tmp19_) {
				GVariantBuilder* _tmp20_;
				BuildTool _tmp21_;
				gint _tmp22_;
				_tmp20_ = builder_enabled;
				_tmp21_ = build_tool;
				_tmp22_ = _tmp21_.id;
				g_variant_builder_add (_tmp20_, "i", _tmp22_, NULL);
			} else {
				GVariantBuilder* _tmp23_;
				BuildTool _tmp24_;
				gint _tmp25_;
				_tmp23_ = builder_disabled;
				_tmp24_ = build_tool;
				_tmp25_ = _tmp24_.id;
				g_variant_builder_add (_tmp23_, "i", _tmp25_, NULL);
			}
			build_tool_destroy (&build_tool);
		}
		_g_object_unref0 (_build_tool_list);
	}
	_tmp26_ = builder_enabled;
	_tmp27_ = g_variant_builder_end (_tmp26_);
	g_variant_ref_sink (_tmp27_);
	enabled_tools = _tmp27_;
	_tmp28_ = builder_disabled;
	_tmp29_ = g_variant_builder_end (_tmp28_);
	g_variant_ref_sink (_tmp29_);
	disabled_tools = _tmp29_;
	_tmp30_ = g_settings_new ("org.gnome.latexila.preferences.latex");
	settings = _tmp30_;
	g_settings_set_value (settings, "enabled-default-build-tools", enabled_tools);
	g_settings_set_value (settings, "disabled-default-build-tools", disabled_tools);
	_g_object_unref0 (settings);
	_g_variant_unref0 (disabled_tools);
	_g_variant_unref0 (enabled_tools);
	_g_variant_builder_unref0 (builder_disabled);
	_g_variant_builder_unref0 (builder_enabled);
}


static void default_build_tools_class_init (DefaultBuildToolsClass * klass) {
	default_build_tools_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = default_build_tools_finalize;
}


static void default_build_tools_instance_init (DefaultBuildTools * self) {
}


static void default_build_tools_finalize (GObject* obj) {
	DefaultBuildTools * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DEFAULT_BUILD_TOOLS, DefaultBuildTools);
	G_OBJECT_CLASS (default_build_tools_parent_class)->finalize (obj);
}


GType default_build_tools_get_type (void) {
	static volatile gsize default_build_tools_type_id__volatile = 0;
	if (g_once_init_enter (&default_build_tools_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DefaultBuildToolsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) default_build_tools_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DefaultBuildTools), 0, (GInstanceInitFunc) default_build_tools_instance_init, NULL };
		GType default_build_tools_type_id;
		default_build_tools_type_id = g_type_register_static (TYPE_BUILD_TOOLS, "DefaultBuildTools", &g_define_type_info, 0);
		g_once_init_leave (&default_build_tools_type_id__volatile, default_build_tools_type_id);
	}
	return default_build_tools_type_id__volatile;
}


static void __lambda53_ (PersonalBuildTools* self) {
	self->priv->_modified = TRUE;
}


static void ___lambda53__build_tools_modified (BuildTools* _sender, gpointer self) {
	__lambda53_ (self);
}


static PersonalBuildTools* personal_build_tools_construct (GType object_type) {
	PersonalBuildTools * self = NULL;
	GFile* _tmp0_ = NULL;
	self = (PersonalBuildTools*) build_tools_construct (object_type);
	_tmp0_ = personal_build_tools_get_user_config_file (self);
	_g_object_unref0 (((BuildTools*) self)->_xml_file);
	((BuildTools*) self)->_xml_file = _tmp0_;
	build_tools_load ((BuildTools*) self);
	g_signal_connect_object ((BuildTools*) self, "modified", (GCallback) ___lambda53__build_tools_modified, self, 0);
	return self;
}


static PersonalBuildTools* personal_build_tools_new (void) {
	return personal_build_tools_construct (TYPE_PERSONAL_BUILD_TOOLS);
}


PersonalBuildTools* personal_build_tools_get_default (void) {
	PersonalBuildTools* result = NULL;
	PersonalBuildTools* _tmp0_;
	PersonalBuildTools* _tmp2_;
	PersonalBuildTools* _tmp3_;
	_tmp0_ = personal_build_tools__instance;
	if (_tmp0_ == NULL) {
		PersonalBuildTools* _tmp1_;
		_tmp1_ = personal_build_tools_new ();
		_g_object_unref0 (personal_build_tools__instance);
		personal_build_tools__instance = _tmp1_;
	}
	_tmp2_ = personal_build_tools__instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


void personal_build_tools_move_up (PersonalBuildTools* self, gint tool_num) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp1_ = tool_num;
	if (0 < _tmp1_) {
		gint _tmp2_;
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp2_ = tool_num;
		_tmp3_ = ((BuildTools*) self)->_build_tools;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp2_ < _tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp6_ = _tmp0_;
	g_return_if_fail (_tmp6_);
	_tmp7_ = tool_num;
	_tmp8_ = tool_num;
	personal_build_tools_swap (self, _tmp7_, _tmp8_ - 1);
}


void personal_build_tools_move_down (PersonalBuildTools* self, gint tool_num) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp1_ = tool_num;
	if (0 <= _tmp1_) {
		gint _tmp2_;
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp2_ = tool_num;
		_tmp3_ = ((BuildTools*) self)->_build_tools;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp2_ < (_tmp5_ - 1);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp6_ = _tmp0_;
	g_return_if_fail (_tmp6_);
	_tmp7_ = tool_num;
	_tmp8_ = tool_num;
	personal_build_tools_swap (self, _tmp7_, _tmp8_ + 1);
}


static void personal_build_tools_swap (PersonalBuildTools* self, gint tool_num1, gint tool_num2) {
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
	gpointer _tmp2_ = NULL;
	BuildTool* _tmp3_;
	BuildTool _tmp4_ = {0};
	BuildTool _tmp5_;
	BuildTool tool;
	GeeLinkedList* _tmp6_;
	gint _tmp7_;
	gpointer _tmp8_ = NULL;
	BuildTool* _tmp9_;
	GeeLinkedList* _tmp10_;
	gint _tmp11_;
	BuildTool _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((BuildTools*) self)->_build_tools;
	_tmp1_ = tool_num1;
	_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _tmp0_, _tmp1_);
	_tmp3_ = (BuildTool*) _tmp2_;
	build_tool_copy (_tmp3_, &_tmp4_);
	_tmp5_ = _tmp4_;
	_build_tool_free0 (_tmp3_);
	tool = _tmp5_;
	_tmp6_ = ((BuildTools*) self)->_build_tools;
	_tmp7_ = tool_num1;
	_tmp8_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp6_, _tmp7_);
	_tmp9_ = (BuildTool*) _tmp8_;
	_build_tool_free0 (_tmp9_);
	_tmp10_ = ((BuildTools*) self)->_build_tools;
	_tmp11_ = tool_num2;
	_tmp12_ = tool;
	gee_abstract_list_insert ((GeeAbstractList*) _tmp10_, _tmp11_, &_tmp12_);
	g_signal_emit_by_name ((BuildTools*) self, "modified");
	build_tool_destroy (&tool);
}


void personal_build_tools_delete (PersonalBuildTools* self, gint tool_num) {
	gint _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeLinkedList* _tmp2_;
	gint _tmp3_;
	gpointer _tmp4_ = NULL;
	BuildTool* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tool_num;
	_tmp1_ = build_tools_is_valid_index ((BuildTools*) self, _tmp0_);
	g_return_if_fail (_tmp1_);
	_tmp2_ = ((BuildTools*) self)->_build_tools;
	_tmp3_ = tool_num;
	_tmp4_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp2_, _tmp3_);
	_tmp5_ = (BuildTool*) _tmp4_;
	_build_tool_free0 (_tmp5_);
	g_signal_emit_by_name ((BuildTools*) self, "modified");
}


void personal_build_tools_add (PersonalBuildTools* self, BuildTool* tool) {
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	BuildTool _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tool != NULL);
	_tmp0_ = ((BuildTools*) self)->_build_tools;
	_tmp1_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = *tool;
	personal_build_tools_insert (self, _tmp2_, &_tmp3_);
}


void personal_build_tools_insert (PersonalBuildTools* self, gint pos, BuildTool* tool) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp6_;
	GeeLinkedList* _tmp7_;
	gint _tmp8_;
	BuildTool _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tool != NULL);
	_tmp1_ = pos;
	if (0 <= _tmp1_) {
		gint _tmp2_;
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp2_ = pos;
		_tmp3_ = ((BuildTools*) self)->_build_tools;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp2_ <= _tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp6_ = _tmp0_;
	g_return_if_fail (_tmp6_);
	_tmp7_ = ((BuildTools*) self)->_build_tools;
	_tmp8_ = pos;
	_tmp9_ = *tool;
	gee_abstract_list_insert ((GeeAbstractList*) _tmp7_, _tmp8_, &_tmp9_);
	g_signal_emit_by_name ((BuildTools*) self, "modified");
}


void personal_build_tools_update (PersonalBuildTools* self, gint num, BuildTool* tool) {
	gint _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeLinkedList* _tmp2_;
	gint _tmp3_;
	gpointer _tmp4_ = NULL;
	BuildTool* _tmp5_;
	BuildTool _tmp6_ = {0};
	BuildTool _tmp7_;
	BuildTool current_tool;
	BuildTool _tmp8_;
	BuildTool _tmp9_;
	gboolean _tmp10_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tool != NULL);
	_tmp0_ = num;
	_tmp1_ = build_tools_is_valid_index ((BuildTools*) self, _tmp0_);
	g_return_if_fail (_tmp1_);
	_tmp2_ = ((BuildTools*) self)->_build_tools;
	_tmp3_ = num;
	_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _tmp2_, _tmp3_);
	_tmp5_ = (BuildTool*) _tmp4_;
	build_tool_copy (_tmp5_, &_tmp6_);
	_tmp7_ = _tmp6_;
	_build_tool_free0 (_tmp5_);
	current_tool = _tmp7_;
	_tmp8_ = current_tool;
	_tmp9_ = *tool;
	_tmp10_ = personal_build_tools_is_equal (self, &_tmp8_, &_tmp9_);
	if (!_tmp10_) {
		GeeLinkedList* _tmp11_;
		gint _tmp12_;
		BuildTool _tmp13_;
		_tmp11_ = ((BuildTools*) self)->_build_tools;
		_tmp12_ = num;
		_tmp13_ = *tool;
		gee_abstract_list_set ((GeeAbstractList*) _tmp11_, _tmp12_, &_tmp13_);
		g_signal_emit_by_name ((BuildTools*) self, "modified");
	}
	build_tool_destroy (&current_tool);
}


static GFile* personal_build_tools_get_user_config_file (PersonalBuildTools* self) {
	GFile* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* path;
	GFile* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "latexila", "build_tools.xml", NULL);
	path = _tmp1_;
	_tmp2_ = g_file_new_for_path (path);
	result = _tmp2_;
	_g_free0 (path);
	return result;
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


void personal_build_tools_save (PersonalBuildTools* self) {
	gboolean _tmp0_;
	gchar* _tmp1_;
	gchar* content;
	const gchar* _tmp85_;
	gchar* _tmp86_;
	GFile* _tmp87_ = NULL;
	GFile* file;
	GFile* _tmp88_;
	const gchar* _tmp89_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_modified;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = g_strdup ("<tools>");
	content = _tmp1_;
	{
		GeeLinkedList* _tmp2_;
		GeeLinkedList* _tmp3_;
		GeeLinkedList* _tool_list;
		GeeLinkedList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _tool_size;
		gint _tool_index;
		_tmp2_ = ((BuildTools*) self)->_build_tools;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_tool_list = _tmp3_;
		_tmp4_ = _tool_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tool_size = _tmp6_;
		_tool_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			GeeLinkedList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_ = NULL;
			BuildTool* _tmp13_;
			BuildTool _tmp14_ = {0};
			BuildTool _tmp15_;
			BuildTool tool;
			const gchar* _tmp16_;
			BuildTool _tmp17_;
			gboolean _tmp18_;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_;
			gchar* _tmp23_;
			const gchar* _tmp24_;
			BuildTool _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_;
			gchar* _tmp29_;
			const gchar* _tmp30_;
			BuildTool _tmp31_;
			const gchar* _tmp32_;
			gchar* _tmp33_ = NULL;
			gchar* _tmp34_;
			gchar* _tmp35_;
			const gchar* _tmp36_;
			BuildTool _tmp37_;
			const gchar* _tmp38_;
			gchar* _tmp39_ = NULL;
			gchar* _tmp40_;
			gchar* _tmp41_;
			const gchar* _tmp42_;
			gchar* _tmp43_ = NULL;
			gchar* _tmp44_;
			gchar* _tmp45_ = NULL;
			gchar* _tmp46_;
			gchar* _tmp47_;
			const gchar* _tmp77_;
			BuildTool _tmp78_;
			const gchar* _tmp79_;
			gchar* _tmp80_ = NULL;
			gchar* _tmp81_;
			gchar* _tmp82_;
			const gchar* _tmp83_;
			gchar* _tmp84_;
			_tmp7_ = _tool_index;
			_tool_index = _tmp7_ + 1;
			_tmp8_ = _tool_index;
			_tmp9_ = _tool_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _tool_list;
			_tmp11_ = _tool_index;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp11_);
			_tmp13_ = (BuildTool*) _tmp12_;
			build_tool_copy (_tmp13_, &_tmp14_);
			_tmp15_ = _tmp14_;
			_build_tool_free0 (_tmp13_);
			tool = _tmp15_;
			_tmp16_ = content;
			_tmp17_ = tool;
			_tmp18_ = _tmp17_.enabled;
			_tmp19_ = bool_to_string (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strdup_printf ("\n  <tool enabled=\"%s\"", _tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strconcat (_tmp16_, _tmp22_, NULL);
			_g_free0 (content);
			content = _tmp23_;
			_g_free0 (_tmp22_);
			_g_free0 (_tmp20_);
			_tmp24_ = content;
			_tmp25_ = tool;
			_tmp26_ = _tmp25_.extensions;
			_tmp27_ = g_strdup_printf (" extensions=\"%s\"", _tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_strconcat (_tmp24_, _tmp28_, NULL);
			_g_free0 (content);
			content = _tmp29_;
			_g_free0 (_tmp28_);
			_tmp30_ = content;
			_tmp31_ = tool;
			_tmp32_ = _tmp31_.icon;
			_tmp33_ = g_strdup_printf (" icon=\"%s\">\n", _tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = g_strconcat (_tmp30_, _tmp34_, NULL);
			_g_free0 (content);
			content = _tmp35_;
			_g_free0 (_tmp34_);
			_tmp36_ = content;
			_tmp37_ = tool;
			_tmp38_ = _tmp37_.label;
			_tmp39_ = g_markup_printf_escaped ("    <label>%s</label>\n", _tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strconcat (_tmp36_, _tmp40_, NULL);
			_g_free0 (content);
			content = _tmp41_;
			_g_free0 (_tmp40_);
			_tmp42_ = content;
			_tmp43_ = build_tool_get_description (&tool);
			_tmp44_ = _tmp43_;
			_tmp45_ = g_markup_printf_escaped ("    <description>%s</description>\n", _tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = g_strconcat (_tmp42_, _tmp46_, NULL);
			_g_free0 (content);
			content = _tmp47_;
			_g_free0 (_tmp46_);
			_g_free0 (_tmp44_);
			{
				BuildTool _tmp48_;
				GeeArrayList* _tmp49_;
				GeeArrayList* _tmp50_;
				GeeArrayList* _job_list;
				GeeArrayList* _tmp51_;
				gint _tmp52_;
				gint _tmp53_;
				gint _job_size;
				gint _job_index;
				_tmp48_ = tool;
				_tmp49_ = _tmp48_.jobs;
				_tmp50_ = _g_object_ref0 (_tmp49_);
				_job_list = _tmp50_;
				_tmp51_ = _job_list;
				_tmp52_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp51_);
				_tmp53_ = _tmp52_;
				_job_size = _tmp53_;
				_job_index = -1;
				while (TRUE) {
					gint _tmp54_;
					gint _tmp55_;
					gint _tmp56_;
					GeeArrayList* _tmp57_;
					gint _tmp58_;
					gpointer _tmp59_ = NULL;
					BuildJob* _tmp60_;
					BuildJob _tmp61_ = {0};
					BuildJob _tmp62_;
					BuildJob job;
					const gchar* _tmp63_;
					BuildJob _tmp64_;
					PostProcessorType _tmp65_;
					gchar* _tmp66_ = NULL;
					gchar* _tmp67_;
					gchar* _tmp68_ = NULL;
					gchar* _tmp69_;
					gchar* _tmp70_;
					const gchar* _tmp71_;
					BuildJob _tmp72_;
					const gchar* _tmp73_;
					gchar* _tmp74_ = NULL;
					gchar* _tmp75_;
					gchar* _tmp76_;
					_tmp54_ = _job_index;
					_job_index = _tmp54_ + 1;
					_tmp55_ = _job_index;
					_tmp56_ = _job_size;
					if (!(_tmp55_ < _tmp56_)) {
						break;
					}
					_tmp57_ = _job_list;
					_tmp58_ = _job_index;
					_tmp59_ = gee_abstract_list_get ((GeeAbstractList*) _tmp57_, _tmp58_);
					_tmp60_ = (BuildJob*) _tmp59_;
					build_job_copy (_tmp60_, &_tmp61_);
					_tmp62_ = _tmp61_;
					_build_job_free0 (_tmp60_);
					job = _tmp62_;
					_tmp63_ = content;
					_tmp64_ = job;
					_tmp65_ = _tmp64_.post_processor;
					_tmp66_ = build_tools_get_post_processor_name_from_type (_tmp65_);
					_tmp67_ = _tmp66_;
					_tmp68_ = g_strdup_printf ("    <job postProcessor=\"%s\">", _tmp67_);
					_tmp69_ = _tmp68_;
					_tmp70_ = g_strconcat (_tmp63_, _tmp69_, NULL);
					_g_free0 (content);
					content = _tmp70_;
					_g_free0 (_tmp69_);
					_g_free0 (_tmp67_);
					_tmp71_ = content;
					_tmp72_ = job;
					_tmp73_ = _tmp72_.command;
					_tmp74_ = g_markup_printf_escaped ("%s</job>\n", _tmp73_);
					_tmp75_ = _tmp74_;
					_tmp76_ = g_strconcat (_tmp71_, _tmp75_, NULL);
					_g_free0 (content);
					content = _tmp76_;
					_g_free0 (_tmp75_);
					build_job_destroy (&job);
				}
				_g_object_unref0 (_job_list);
			}
			_tmp77_ = content;
			_tmp78_ = tool;
			_tmp79_ = _tmp78_.files_to_open;
			_tmp80_ = g_markup_printf_escaped ("    <open>%s</open>\n", _tmp79_);
			_tmp81_ = _tmp80_;
			_tmp82_ = g_strconcat (_tmp77_, _tmp81_, NULL);
			_g_free0 (content);
			content = _tmp82_;
			_g_free0 (_tmp81_);
			_tmp83_ = content;
			_tmp84_ = g_strconcat (_tmp83_, "  </tool>\n", NULL);
			_g_free0 (content);
			content = _tmp84_;
			build_tool_destroy (&tool);
		}
		_g_object_unref0 (_tool_list);
	}
	_tmp85_ = content;
	_tmp86_ = g_strconcat (_tmp85_, "</tools>\n", NULL);
	_g_free0 (content);
	content = _tmp86_;
	_tmp87_ = personal_build_tools_get_user_config_file (self);
	file = _tmp87_;
	_tmp88_ = file;
	_tmp89_ = content;
	utils_save_file (_tmp88_, _tmp89_, TRUE);
	_g_object_unref0 (file);
	_g_free0 (content);
}


static gboolean personal_build_tools_is_equal (PersonalBuildTools* self, BuildTool* tool1, BuildTool* tool2) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	BuildTool _tmp6_;
	gboolean _tmp7_;
	BuildTool _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp14_;
	gboolean _tmp19_;
	gboolean _tmp24_;
	gboolean _tmp29_;
	gboolean _tmp34_;
	gboolean _tmp43_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tool1 != NULL, FALSE);
	g_return_val_if_fail (tool2 != NULL, FALSE);
	_tmp6_ = *tool1;
	_tmp7_ = _tmp6_.enabled;
	_tmp8_ = *tool2;
	_tmp9_ = _tmp8_.enabled;
	if (_tmp7_ != _tmp9_) {
		_tmp5_ = TRUE;
	} else {
		BuildTool _tmp10_;
		const gchar* _tmp11_;
		BuildTool _tmp12_;
		const gchar* _tmp13_;
		_tmp10_ = *tool1;
		_tmp11_ = _tmp10_.label;
		_tmp12_ = *tool2;
		_tmp13_ = _tmp12_.label;
		_tmp5_ = g_strcmp0 (_tmp11_, _tmp13_) != 0;
	}
	_tmp14_ = _tmp5_;
	if (_tmp14_) {
		_tmp4_ = TRUE;
	} else {
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		_tmp15_ = build_tool_get_description (tool1);
		_tmp16_ = _tmp15_;
		_tmp17_ = build_tool_get_description (tool2);
		_tmp18_ = _tmp17_;
		_tmp4_ = g_strcmp0 (_tmp16_, _tmp18_) != 0;
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
	}
	_tmp19_ = _tmp4_;
	if (_tmp19_) {
		_tmp3_ = TRUE;
	} else {
		BuildTool _tmp20_;
		const gchar* _tmp21_;
		BuildTool _tmp22_;
		const gchar* _tmp23_;
		_tmp20_ = *tool1;
		_tmp21_ = _tmp20_.extensions;
		_tmp22_ = *tool2;
		_tmp23_ = _tmp22_.extensions;
		_tmp3_ = g_strcmp0 (_tmp21_, _tmp23_) != 0;
	}
	_tmp24_ = _tmp3_;
	if (_tmp24_) {
		_tmp2_ = TRUE;
	} else {
		BuildTool _tmp25_;
		const gchar* _tmp26_;
		BuildTool _tmp27_;
		const gchar* _tmp28_;
		_tmp25_ = *tool1;
		_tmp26_ = _tmp25_.icon;
		_tmp27_ = *tool2;
		_tmp28_ = _tmp27_.icon;
		_tmp2_ = g_strcmp0 (_tmp26_, _tmp28_) != 0;
	}
	_tmp29_ = _tmp2_;
	if (_tmp29_) {
		_tmp1_ = TRUE;
	} else {
		BuildTool _tmp30_;
		const gchar* _tmp31_;
		BuildTool _tmp32_;
		const gchar* _tmp33_;
		_tmp30_ = *tool1;
		_tmp31_ = _tmp30_.files_to_open;
		_tmp32_ = *tool2;
		_tmp33_ = _tmp32_.files_to_open;
		_tmp1_ = g_strcmp0 (_tmp31_, _tmp33_) != 0;
	}
	_tmp34_ = _tmp1_;
	if (_tmp34_) {
		_tmp0_ = TRUE;
	} else {
		BuildTool _tmp35_;
		GeeArrayList* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		BuildTool _tmp39_;
		GeeArrayList* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		_tmp35_ = *tool1;
		_tmp36_ = _tmp35_.jobs;
		_tmp37_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = *tool2;
		_tmp40_ = _tmp39_.jobs;
		_tmp41_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp40_);
		_tmp42_ = _tmp41_;
		_tmp0_ = _tmp38_ != _tmp42_;
	}
	_tmp43_ = _tmp0_;
	if (_tmp43_) {
		result = FALSE;
		return result;
	}
	{
		gint job_num;
		job_num = 0;
		{
			gboolean _tmp44_;
			_tmp44_ = TRUE;
			while (TRUE) {
				gboolean _tmp45_;
				gint _tmp47_;
				BuildTool _tmp48_;
				GeeArrayList* _tmp49_;
				gint _tmp50_;
				gint _tmp51_;
				BuildTool _tmp52_;
				GeeArrayList* _tmp53_;
				gint _tmp54_;
				gpointer _tmp55_ = NULL;
				BuildJob* _tmp56_;
				BuildJob _tmp57_ = {0};
				BuildJob _tmp58_;
				BuildJob job1;
				BuildTool _tmp59_;
				GeeArrayList* _tmp60_;
				gint _tmp61_;
				gpointer _tmp62_ = NULL;
				BuildJob* _tmp63_;
				BuildJob _tmp64_ = {0};
				BuildJob _tmp65_;
				BuildJob job2;
				gboolean _tmp66_ = FALSE;
				BuildJob _tmp67_;
				const gchar* _tmp68_;
				BuildJob _tmp69_;
				const gchar* _tmp70_;
				gboolean _tmp75_;
				_tmp45_ = _tmp44_;
				if (!_tmp45_) {
					gint _tmp46_;
					_tmp46_ = job_num;
					job_num = _tmp46_ + 1;
				}
				_tmp44_ = FALSE;
				_tmp47_ = job_num;
				_tmp48_ = *tool1;
				_tmp49_ = _tmp48_.jobs;
				_tmp50_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp49_);
				_tmp51_ = _tmp50_;
				if (!(_tmp47_ < _tmp51_)) {
					break;
				}
				_tmp52_ = *tool1;
				_tmp53_ = _tmp52_.jobs;
				_tmp54_ = job_num;
				_tmp55_ = gee_abstract_list_get ((GeeAbstractList*) _tmp53_, _tmp54_);
				_tmp56_ = (BuildJob*) _tmp55_;
				build_job_copy (_tmp56_, &_tmp57_);
				_tmp58_ = _tmp57_;
				_build_job_free0 (_tmp56_);
				job1 = _tmp58_;
				_tmp59_ = *tool2;
				_tmp60_ = _tmp59_.jobs;
				_tmp61_ = job_num;
				_tmp62_ = gee_abstract_list_get ((GeeAbstractList*) _tmp60_, _tmp61_);
				_tmp63_ = (BuildJob*) _tmp62_;
				build_job_copy (_tmp63_, &_tmp64_);
				_tmp65_ = _tmp64_;
				_build_job_free0 (_tmp63_);
				job2 = _tmp65_;
				_tmp67_ = job1;
				_tmp68_ = _tmp67_.command;
				_tmp69_ = job2;
				_tmp70_ = _tmp69_.command;
				if (g_strcmp0 (_tmp68_, _tmp70_) != 0) {
					_tmp66_ = TRUE;
				} else {
					BuildJob _tmp71_;
					PostProcessorType _tmp72_;
					BuildJob _tmp73_;
					PostProcessorType _tmp74_;
					_tmp71_ = job1;
					_tmp72_ = _tmp71_.post_processor;
					_tmp73_ = job2;
					_tmp74_ = _tmp73_.post_processor;
					_tmp66_ = _tmp72_ != _tmp74_;
				}
				_tmp75_ = _tmp66_;
				if (_tmp75_) {
					result = FALSE;
					build_job_destroy (&job2);
					build_job_destroy (&job1);
					return result;
				}
				build_job_destroy (&job2);
				build_job_destroy (&job1);
			}
		}
	}
	result = TRUE;
	return result;
}


static void personal_build_tools_class_init (PersonalBuildToolsClass * klass) {
	personal_build_tools_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PersonalBuildToolsPrivate));
	G_OBJECT_CLASS (klass)->finalize = personal_build_tools_finalize;
}


static void personal_build_tools_instance_init (PersonalBuildTools * self) {
	self->priv = PERSONAL_BUILD_TOOLS_GET_PRIVATE (self);
	self->priv->_modified = FALSE;
}


static void personal_build_tools_finalize (GObject* obj) {
	PersonalBuildTools * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PERSONAL_BUILD_TOOLS, PersonalBuildTools);
	G_OBJECT_CLASS (personal_build_tools_parent_class)->finalize (obj);
}


GType personal_build_tools_get_type (void) {
	static volatile gsize personal_build_tools_type_id__volatile = 0;
	if (g_once_init_enter (&personal_build_tools_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PersonalBuildToolsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) personal_build_tools_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PersonalBuildTools), 0, (GInstanceInitFunc) personal_build_tools_instance_init, NULL };
		GType personal_build_tools_type_id;
		personal_build_tools_type_id = g_type_register_static (TYPE_BUILD_TOOLS, "PersonalBuildTools", &g_define_type_info, 0);
		g_once_init_leave (&personal_build_tools_type_id__volatile, personal_build_tools_type_id);
	}
	return personal_build_tools_type_id__volatile;
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



