/* latexila.c generated by valac 0.18.0.80-b1b683, the Vala compiler
 * generated from latexila.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "config.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gee.h>
#include <gtksourceview/gtksource.h>
#include <gdk/gdk.h>


#define TYPE_LATEXILA (latexila_get_type ())
#define LATEXILA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEXILA, Latexila))
#define LATEXILA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEXILA, LatexilaClass))
#define IS_LATEXILA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEXILA))
#define IS_LATEXILA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEXILA))
#define LATEXILA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEXILA, LatexilaClass))

typedef struct _Latexila Latexila;
typedef struct _LatexilaClass LatexilaClass;
typedef struct _LatexilaPrivate LatexilaPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))

#define TYPE_BUILD_TOOLS (build_tools_get_type ())
#define BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS, BuildTools))
#define BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS, BuildToolsClass))
#define IS_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS))
#define IS_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS))
#define BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS, BuildToolsClass))

typedef struct _BuildTools BuildTools;
typedef struct _BuildToolsClass BuildToolsClass;

#define TYPE_PERSONAL_BUILD_TOOLS (personal_build_tools_get_type ())
#define PERSONAL_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PERSONAL_BUILD_TOOLS, PersonalBuildTools))
#define PERSONAL_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PERSONAL_BUILD_TOOLS, PersonalBuildToolsClass))
#define IS_PERSONAL_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PERSONAL_BUILD_TOOLS))
#define IS_PERSONAL_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PERSONAL_BUILD_TOOLS))
#define PERSONAL_BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PERSONAL_BUILD_TOOLS, PersonalBuildToolsClass))

typedef struct _PersonalBuildTools PersonalBuildTools;
typedef struct _PersonalBuildToolsClass PersonalBuildToolsClass;

#define TYPE_MOST_USED_SYMBOLS (most_used_symbols_get_type ())
#define MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbols))
#define MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))
#define IS_MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOST_USED_SYMBOLS))
#define IS_MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOST_USED_SYMBOLS))
#define MOST_USED_SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))

typedef struct _MostUsedSymbols MostUsedSymbols;
typedef struct _MostUsedSymbolsClass MostUsedSymbolsClass;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))

#define TYPE_STOCK_ICONS (stock_icons_get_type ())
#define STOCK_ICONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STOCK_ICONS, StockIcons))
#define STOCK_ICONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STOCK_ICONS, StockIconsClass))
#define IS_STOCK_ICONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STOCK_ICONS))
#define IS_STOCK_ICONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STOCK_ICONS))
#define STOCK_ICONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STOCK_ICONS, StockIconsClass))

typedef struct _StockIcons StockIcons;
typedef struct _StockIconsClass StockIconsClass;
#define _stock_icons_unref0(var) ((var == NULL) ? NULL : (var = (stock_icons_unref (var), NULL)))

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
typedef struct _Block22Data Block22Data;

struct _Latexila {
	GtkApplication parent_instance;
	LatexilaPrivate * priv;
};

struct _LatexilaClass {
	GtkApplicationClass parent_class;
};

struct _LatexilaPrivate {
	MainWindow* _active_window;
};

struct _Block22Data {
	int _ref_count_;
	Latexila * self;
	MainWindow* window;
};


static gpointer latexila_parent_class = NULL;

GType latexila_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
#define LATEXILA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LATEXILA, LatexilaPrivate))
enum  {
	LATEXILA_DUMMY_PROPERTY,
	LATEXILA_ACTIVE_WINDOW
};
Latexila* latexila_new (void);
Latexila* latexila_construct (GType object_type);
static void latexila_connect_signals (Latexila* self);
static void latexila_add_actions (Latexila* self);
static void latexila_init_primary_instance (Latexila* self);
static void _latexila_init_primary_instance_g_application_startup (GApplication* _sender, gpointer self);
static void __lambda141_ (Latexila* self);
MainWindow* latexila_get_active_window (Latexila* self);
static void ___lambda141__g_application_activate (GApplication* _sender, gpointer self);
static void __lambda142_ (Latexila* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_projects (GValue* value, gpointer v_object);
void value_take_projects (GValue* value, gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
Projects* projects_get_default (void);
void projects_save (Projects* self);
GType build_tools_get_type (void) G_GNUC_CONST;
GType personal_build_tools_get_type (void) G_GNUC_CONST;
PersonalBuildTools* personal_build_tools_get_default (void);
void personal_build_tools_save (PersonalBuildTools* self);
GType most_used_symbols_get_type (void) G_GNUC_CONST;
MostUsedSymbols* most_used_symbols_get_default (void);
void most_used_symbols_save (MostUsedSymbols* self);
static void ___lambda142__g_application_shutdown (GApplication* _sender, gpointer self);
static void __lambda143_ (Latexila* self);
static void latexila_set_active_window (Latexila* self, MainWindow* value);
static void ___lambda143__gtk_application_window_removed (GtkApplication* _sender, GtkWindow* window, gpointer self);
static void __lambda144_ (Latexila* self);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_create_tab (MainWindow* self, gboolean jump_to);
static void ___lambda144__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void __lambda145_ (Latexila* self);
MainWindow* latexila_create_window (Latexila* self);
static void ___lambda145__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void __lambda146_ (Latexila* self, GVariant* param);
static void _vala_array_add15 (GFile*** array, int* length, int* size, GFile* value);
void latexila_open_documents (Latexila* self, GFile** files, int files_length1);
static void ___lambda146__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
Latexila* latexila_get_instance (void);
static void latexila_set_application_icons (Latexila* self);
StockIcons* stock_icons_new (void);
StockIcons* stock_icons_construct (GType object_type);
gpointer stock_icons_ref (gpointer instance);
void stock_icons_unref (gpointer instance);
GParamSpec* param_spec_stock_icons (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_stock_icons (GValue* value, gpointer v_object);
void value_take_stock_icons (GValue* value, gpointer v_object);
gpointer value_get_stock_icons (const GValue* value);
GType stock_icons_get_type (void) G_GNUC_CONST;
GType app_settings_get_type (void) G_GNUC_CONST;
AppSettings* app_settings_get_default (void);
static void latexila_reopen_files (Latexila* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void _vala_array_add16 (GFile*** array, int* length, int* size, GFile* value);
GType document_get_type (void) G_GNUC_CONST;
GeeList* latexila_get_documents (Latexila* self);
GeeList* main_window_get_documents (MainWindow* self);
GType document_view_get_type (void) G_GNUC_CONST;
GeeList* latexila_get_views (Latexila* self);
GeeList* main_window_get_views (MainWindow* self);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
void main_window_save_state (MainWindow* self);
MainWindow* main_window_new (void);
MainWindow* main_window_construct (GType object_type);
static gboolean __lambda71_ (Block22Data* _data22_);
static gboolean ___lambda71__gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
DocumentTab* main_window_open_document (MainWindow* self, GFile* location, gboolean jump_to);
static void latexila_finalize (GObject* obj);
static void _vala_latexila_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_latexila_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


Latexila* latexila_construct (GType object_type) {
	Latexila * self = NULL;
	self = (Latexila*) g_object_new (object_type, "application-id", "org.gnome.latexila", NULL);
	g_set_application_name (PACKAGE_NAME);
	latexila_connect_signals (self);
	latexila_add_actions (self);
	return self;
}


Latexila* latexila_new (void) {
	return latexila_construct (TYPE_LATEXILA);
}


static void _latexila_init_primary_instance_g_application_startup (GApplication* _sender, gpointer self) {
	latexila_init_primary_instance (self);
}


static void __lambda141_ (Latexila* self) {
	MainWindow* _tmp0_;
	g_application_hold ((GApplication*) self);
	_tmp0_ = self->priv->_active_window;
	gtk_window_present ((GtkWindow*) _tmp0_);
	g_application_release ((GApplication*) self);
}


static void ___lambda141__g_application_activate (GApplication* _sender, gpointer self) {
	__lambda141_ (self);
}


static void __lambda142_ (Latexila* self) {
	Projects* _tmp0_ = NULL;
	Projects* _tmp1_;
	PersonalBuildTools* _tmp2_ = NULL;
	PersonalBuildTools* _tmp3_;
	MostUsedSymbols* _tmp4_ = NULL;
	MostUsedSymbols* _tmp5_;
	g_application_hold ((GApplication*) self);
	_tmp0_ = projects_get_default ();
	_tmp1_ = _tmp0_;
	projects_save (_tmp1_);
	_projects_unref0 (_tmp1_);
	_tmp2_ = personal_build_tools_get_default ();
	_tmp3_ = _tmp2_;
	personal_build_tools_save (_tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = most_used_symbols_get_default ();
	_tmp5_ = _tmp4_;
	most_used_symbols_save (_tmp5_);
	_g_object_unref0 (_tmp5_);
	g_application_release ((GApplication*) self);
}


static void ___lambda142__g_application_shutdown (GApplication* _sender, gpointer self) {
	__lambda142_ (self);
}


static void __lambda143_ (Latexila* self) {
	GList* _tmp0_ = NULL;
	GList* windows;
	GList* _tmp1_;
	guint _tmp2_ = 0U;
	g_application_hold ((GApplication*) self);
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
	windows = _tmp0_;
	_tmp1_ = windows;
	_tmp2_ = g_list_length (_tmp1_);
	if (((guint) 0) < _tmp2_) {
		GList* _tmp3_;
		gconstpointer _tmp4_;
		_tmp3_ = windows;
		_tmp4_ = _tmp3_->data;
		latexila_set_active_window (self, G_TYPE_CHECK_INSTANCE_TYPE ((GtkWindow*) _tmp4_, TYPE_MAIN_WINDOW) ? ((MainWindow*) ((GtkWindow*) _tmp4_)) : NULL);
	}
	g_application_release ((GApplication*) self);
}


static void ___lambda143__gtk_application_window_removed (GtkApplication* _sender, GtkWindow* window, gpointer self) {
	__lambda143_ (self);
}


static void latexila_connect_signals (Latexila* self) {
	g_return_if_fail (self != NULL);
	g_signal_connect_object ((GApplication*) self, "startup", (GCallback) _latexila_init_primary_instance_g_application_startup, self, 0);
	g_signal_connect_object ((GApplication*) self, "activate", (GCallback) ___lambda141__g_application_activate, self, 0);
	g_signal_connect_object ((GApplication*) self, "shutdown", (GCallback) ___lambda142__g_application_shutdown, self, 0);
	g_signal_connect_object ((GtkApplication*) self, "window-removed", (GCallback) ___lambda143__gtk_application_window_removed, self, 0);
}


static void __lambda144_ (Latexila* self) {
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_ = NULL;
	DocumentTab* _tmp2_;
	g_application_hold ((GApplication*) self);
	_tmp0_ = self->priv->_active_window;
	_tmp1_ = main_window_create_tab (_tmp0_, TRUE);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	g_application_release ((GApplication*) self);
}


static void ___lambda144__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	__lambda144_ (self);
}


static void __lambda145_ (Latexila* self) {
	MainWindow* _tmp0_ = NULL;
	MainWindow* _tmp1_;
	g_application_hold ((GApplication*) self);
	_tmp0_ = latexila_create_window (self);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
	g_application_release ((GApplication*) self);
}


static void ___lambda145__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	__lambda145_ (self);
}


static void _vala_array_add15 (GFile*** array, int* length, int* size, GFile* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void __lambda146_ (Latexila* self, GVariant* param) {
	GVariant* _tmp0_;
	size_t _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** uris;
	gint uris_length1;
	gint _uris_size_;
	GFile** _tmp3_ = NULL;
	GFile** files;
	gint files_length1;
	gint _files_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GFile** _tmp12_;
	gint _tmp12__length1;
	_tmp0_ = param;
	_tmp2_ = g_variant_dup_strv (_tmp0_, &_tmp1_);
	uris = _tmp2_;
	uris_length1 = _tmp1_;
	_uris_size_ = uris_length1;
	_tmp3_ = g_new0 (GFile*, 0 + 1);
	files = _tmp3_;
	files_length1 = 0;
	_files_size_ = files_length1;
	_tmp4_ = uris;
	_tmp4__length1 = uris_length1;
	{
		gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = _tmp4_;
		uri_collection_length1 = _tmp4__length1;
		for (uri_it = 0; uri_it < _tmp4__length1; uri_it = uri_it + 1) {
			gchar* _tmp5_;
			gchar* uri = NULL;
			_tmp5_ = g_strdup (uri_collection[uri_it]);
			uri = _tmp5_;
			{
				const gchar* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				_tmp6_ = uri;
				_tmp7_ = strlen (_tmp6_);
				_tmp8_ = _tmp7_;
				if (0 < _tmp8_) {
					GFile** _tmp9_;
					gint _tmp9__length1;
					const gchar* _tmp10_;
					GFile* _tmp11_ = NULL;
					_tmp9_ = files;
					_tmp9__length1 = files_length1;
					_tmp10_ = uri;
					_tmp11_ = g_file_new_for_uri (_tmp10_);
					_vala_array_add15 (&files, &files_length1, &_files_size_, _tmp11_);
				}
				_g_free0 (uri);
			}
		}
	}
	_tmp12_ = files;
	_tmp12__length1 = files_length1;
	latexila_open_documents (self, _tmp12_, _tmp12__length1);
	files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
}


static void ___lambda146__g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	__lambda146_ (self, parameter);
}


static void latexila_add_actions (Latexila* self) {
	GSimpleAction* _tmp0_;
	GSimpleAction* new_document_action;
	GSimpleAction* _tmp1_;
	GSimpleAction* new_window_action;
	GVariantType* _tmp2_;
	GVariantType* strings_array;
	GSimpleAction* _tmp3_;
	GSimpleAction* open_files_action;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_simple_action_new ("new-document", NULL);
	new_document_action = _tmp0_;
	g_action_map_add_action ((GActionMap*) self, (GAction*) new_document_action);
	g_signal_connect_object (new_document_action, "activate", (GCallback) ___lambda144__g_simple_action_activate, self, 0);
	_tmp1_ = g_simple_action_new ("new-window", NULL);
	new_window_action = _tmp1_;
	g_action_map_add_action ((GActionMap*) self, (GAction*) new_window_action);
	g_signal_connect_object (new_window_action, "activate", (GCallback) ___lambda145__g_simple_action_activate, self, 0);
	_tmp2_ = g_variant_type_new ("as");
	strings_array = _tmp2_;
	_tmp3_ = g_simple_action_new ("open-files", strings_array);
	open_files_action = _tmp3_;
	g_action_map_add_action ((GActionMap*) self, (GAction*) open_files_action);
	g_signal_connect_object (open_files_action, "activate", (GCallback) ___lambda146__g_simple_action_activate, self, 0);
	_g_object_unref0 (open_files_action);
	_g_variant_type_free0 (strings_array);
	_g_object_unref0 (new_window_action);
	_g_object_unref0 (new_document_action);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Latexila* latexila_get_instance (void) {
	Latexila* result = NULL;
	GApplication* _tmp0_ = NULL;
	Latexila* _tmp1_;
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_LATEXILA) ? ((Latexila*) _tmp0_) : NULL);
	result = _tmp1_;
	return result;
}


static void latexila_init_primary_instance (Latexila* self) {
	StockIcons* _tmp0_;
	StockIcons* _tmp1_;
	AppSettings* _tmp2_ = NULL;
	AppSettings* _tmp3_;
	MainWindow* _tmp4_ = NULL;
	MainWindow* _tmp5_;
	g_return_if_fail (self != NULL);
	g_application_hold ((GApplication*) self);
	latexila_set_application_icons (self);
	_tmp0_ = stock_icons_new ();
	_tmp1_ = _tmp0_;
	_stock_icons_unref0 (_tmp1_);
	_tmp2_ = app_settings_get_default ();
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	_tmp4_ = latexila_create_window (self);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp5_);
	latexila_reopen_files (self);
	g_application_release ((GApplication*) self);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void latexila_set_application_icons (Latexila* self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_ = NULL;
	gchar** sizes;
	gint sizes_length1;
	gint _sizes_size_;
	GList* list;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GList* _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("16x16");
	_tmp1_ = g_strdup ("22x22");
	_tmp2_ = g_strdup ("24x24");
	_tmp3_ = g_strdup ("32x32");
	_tmp4_ = g_strdup ("48x48");
	_tmp5_ = g_new0 (gchar*, 5 + 1);
	_tmp5_[0] = _tmp0_;
	_tmp5_[1] = _tmp1_;
	_tmp5_[2] = _tmp2_;
	_tmp5_[3] = _tmp3_;
	_tmp5_[4] = _tmp4_;
	sizes = _tmp5_;
	sizes_length1 = 5;
	_sizes_size_ = sizes_length1;
	list = NULL;
	_tmp6_ = sizes;
	_tmp6__length1 = sizes_length1;
	{
		gchar** size_collection = NULL;
		gint size_collection_length1 = 0;
		gint _size_collection_size_ = 0;
		gint size_it = 0;
		size_collection = _tmp6_;
		size_collection_length1 = _tmp6__length1;
		for (size_it = 0; size_it < _tmp6__length1; size_it = size_it + 1) {
			gchar* _tmp7_;
			gchar* size = NULL;
			_tmp7_ = g_strdup (size_collection[size_it]);
			size = _tmp7_;
			{
				const gchar* _tmp8_;
				gchar* _tmp9_ = NULL;
				gchar* filename;
				_tmp8_ = size;
				_tmp9_ = g_build_filename (ICONS_DIR, _tmp8_, "apps", "latexila.png", NULL);
				filename = _tmp9_;
				{
					const gchar* _tmp10_;
					GdkPixbuf* _tmp11_;
					GdkPixbuf* _tmp12_;
					_tmp10_ = filename;
					_tmp11_ = gdk_pixbuf_new_from_file (_tmp10_, &_inner_error_);
					_tmp12_ = _tmp11_;
					if (_inner_error_ != NULL) {
						goto __catch31_g_error;
					}
					list = g_list_append (list, _tmp12_);
				}
				goto __finally31;
				__catch31_g_error:
				{
					GError* e = NULL;
					GError* _tmp13_;
					const gchar* _tmp14_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp13_ = e;
					_tmp14_ = _tmp13_->message;
					g_warning ("latexila.vala:144: Application icon: %s", _tmp14_);
					_g_error_free0 (e);
				}
				__finally31:
				if (_inner_error_ != NULL) {
					_g_free0 (filename);
					_g_free0 (size);
					__g_list_free__g_object_unref0_0 (list);
					sizes = (_vala_array_free (sizes, sizes_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_free0 (filename);
				_g_free0 (size);
			}
		}
	}
	_tmp15_ = list;
	gtk_window_set_default_icon_list (_tmp15_);
	__g_list_free__g_object_unref0_0 (list);
	sizes = (_vala_array_free (sizes, sizes_length1, (GDestroyNotify) g_free), NULL);
}


static void _vala_array_add16 (GFile*** array, int* length, int* size, GFile* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void latexila_reopen_files (Latexila* self) {
	GSettings* _tmp0_;
	GSettings* editor_settings;
	GSettings* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.editor");
	editor_settings = _tmp0_;
	_tmp1_ = editor_settings;
	_tmp2_ = g_settings_get_boolean (_tmp1_, "reopen-files");
	if (_tmp2_) {
		GSettings* _tmp3_;
		GSettings* window_settings;
		GSettings* _tmp4_;
		gchar** _tmp5_;
		gchar** _tmp6_ = NULL;
		gchar** uris;
		gint uris_length1;
		gint _uris_size_;
		GFile** _tmp7_ = NULL;
		GFile** files;
		gint files_length1;
		gint _files_size_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		GFile** _tmp16_;
		gint _tmp16__length1;
		_tmp3_ = g_settings_new ("org.gnome.latexila.state.window");
		window_settings = _tmp3_;
		_tmp4_ = window_settings;
		_tmp6_ = _tmp5_ = g_settings_get_strv (_tmp4_, "documents");
		uris = _tmp6_;
		uris_length1 = _vala_array_length (_tmp5_);
		_uris_size_ = uris_length1;
		_tmp7_ = g_new0 (GFile*, 0 + 1);
		files = _tmp7_;
		files_length1 = 0;
		_files_size_ = files_length1;
		_tmp8_ = uris;
		_tmp8__length1 = uris_length1;
		{
			gchar** uri_collection = NULL;
			gint uri_collection_length1 = 0;
			gint _uri_collection_size_ = 0;
			gint uri_it = 0;
			uri_collection = _tmp8_;
			uri_collection_length1 = _tmp8__length1;
			for (uri_it = 0; uri_it < _tmp8__length1; uri_it = uri_it + 1) {
				gchar* _tmp9_;
				gchar* uri = NULL;
				_tmp9_ = g_strdup (uri_collection[uri_it]);
				uri = _tmp9_;
				{
					const gchar* _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					_tmp10_ = uri;
					_tmp11_ = strlen (_tmp10_);
					_tmp12_ = _tmp11_;
					if (0 < _tmp12_) {
						GFile** _tmp13_;
						gint _tmp13__length1;
						const gchar* _tmp14_;
						GFile* _tmp15_ = NULL;
						_tmp13_ = files;
						_tmp13__length1 = files_length1;
						_tmp14_ = uri;
						_tmp15_ = g_file_new_for_uri (_tmp14_);
						_vala_array_add16 (&files, &files_length1, &_files_size_, _tmp15_);
					}
					_g_free0 (uri);
				}
			}
		}
		_tmp16_ = files;
		_tmp16__length1 = files_length1;
		latexila_open_documents (self, _tmp16_, _tmp16__length1);
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
		uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (window_settings);
	}
	_g_object_unref0 (editor_settings);
}


GeeList* latexila_get_documents (Latexila* self) {
	GeeList* result = NULL;
	GeeLinkedList* _tmp0_;
	GeeList* all_documents;
	GList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_linked_list_new (TYPE_DOCUMENT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	all_documents = (GeeList*) _tmp0_;
	_tmp1_ = gtk_application_get_windows ((GtkApplication*) self);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp1_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GtkWindow* _tmp2_;
			GtkWindow* window = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWindow*) window_it->data);
			window = _tmp2_;
			{
				GtkWindow* _tmp3_;
				MainWindow* _tmp4_;
				MainWindow* main_window;
				GeeList* _tmp5_;
				MainWindow* _tmp6_;
				GeeList* _tmp7_ = NULL;
				GeeList* _tmp8_;
				_tmp3_ = window;
				_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_MAIN_WINDOW) ? ((MainWindow*) _tmp3_) : NULL);
				main_window = _tmp4_;
				_tmp5_ = all_documents;
				_tmp6_ = main_window;
				_tmp7_ = main_window_get_documents (_tmp6_);
				_tmp8_ = _tmp7_;
				gee_collection_add_all ((GeeCollection*) _tmp5_, (GeeCollection*) _tmp8_);
				_g_object_unref0 (_tmp8_);
				_g_object_unref0 (main_window);
				_g_object_unref0 (window);
			}
		}
	}
	result = all_documents;
	return result;
}


GeeList* latexila_get_views (Latexila* self) {
	GeeList* result = NULL;
	GeeLinkedList* _tmp0_;
	GeeList* all_views;
	GList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_linked_list_new (TYPE_DOCUMENT_VIEW, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	all_views = (GeeList*) _tmp0_;
	_tmp1_ = gtk_application_get_windows ((GtkApplication*) self);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp1_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GtkWindow* _tmp2_;
			GtkWindow* window = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWindow*) window_it->data);
			window = _tmp2_;
			{
				GtkWindow* _tmp3_;
				MainWindow* _tmp4_;
				MainWindow* main_window;
				GeeList* _tmp5_;
				MainWindow* _tmp6_;
				GeeList* _tmp7_ = NULL;
				GeeList* _tmp8_;
				_tmp3_ = window;
				_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_MAIN_WINDOW) ? ((MainWindow*) _tmp3_) : NULL);
				main_window = _tmp4_;
				_tmp5_ = all_views;
				_tmp6_ = main_window;
				_tmp7_ = main_window_get_views (_tmp6_);
				_tmp8_ = _tmp7_;
				gee_collection_add_all ((GeeCollection*) _tmp5_, (GeeCollection*) _tmp8_);
				_g_object_unref0 (_tmp8_);
				_g_object_unref0 (main_window);
				_g_object_unref0 (window);
			}
		}
	}
	result = all_views;
	return result;
}


static Block22Data* block22_data_ref (Block22Data* _data22_) {
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}


static void block22_data_unref (void * _userdata_) {
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		Latexila * self;
		self = _data22_->self;
		_g_object_unref0 (_data22_->window);
		_g_object_unref0 (self);
		g_slice_free (Block22Data, _data22_);
	}
}


static gboolean __lambda71_ (Block22Data* _data22_) {
	Latexila * self;
	gboolean result = FALSE;
	self = _data22_->self;
	latexila_set_active_window (self, _data22_->window);
	result = FALSE;
	return result;
}


static gboolean ___lambda71__gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = __lambda71_ (self);
	return result;
}


MainWindow* latexila_create_window (Latexila* self) {
	MainWindow* result = NULL;
	Block22Data* _data22_;
	MainWindow* _tmp0_;
	MainWindow* _tmp2_;
	MainWindow* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_data22_ = g_slice_new0 (Block22Data);
	_data22_->_ref_count_ = 1;
	_data22_->self = g_object_ref (self);
	_tmp0_ = self->priv->_active_window;
	if (_tmp0_ != NULL) {
		MainWindow* _tmp1_;
		_tmp1_ = self->priv->_active_window;
		main_window_save_state (_tmp1_);
	}
	_tmp2_ = main_window_new ();
	g_object_ref_sink (_tmp2_);
	_data22_->window = _tmp2_;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _data22_->window);
	latexila_set_active_window (self, _data22_->window);
	g_signal_connect_data ((GtkWidget*) _data22_->window, "focus-in-event", (GCallback) ___lambda71__gtk_widget_focus_in_event, block22_data_ref (_data22_), (GClosureNotify) block22_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data22_->window);
	_tmp3_ = _g_object_ref0 (_data22_->window);
	result = _tmp3_;
	block22_data_unref (_data22_);
	_data22_ = NULL;
	return result;
}


void latexila_open_documents (Latexila* self, GFile** files, int files_length1) {
	gboolean jump_to;
	GFile** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	jump_to = TRUE;
	_tmp0_ = files;
	_tmp0__length1 = files_length1;
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
		file_collection = _tmp0_;
		file_collection_length1 = _tmp0__length1;
		for (file_it = 0; file_it < _tmp0__length1; file_it = file_it + 1) {
			GFile* _tmp1_;
			GFile* file = NULL;
			_tmp1_ = _g_object_ref0 (file_collection[file_it]);
			file = _tmp1_;
			{
				MainWindow* _tmp2_;
				GFile* _tmp3_;
				gboolean _tmp4_;
				DocumentTab* _tmp5_ = NULL;
				DocumentTab* _tmp6_;
				_tmp2_ = self->priv->_active_window;
				_tmp3_ = file;
				_tmp4_ = jump_to;
				_tmp5_ = main_window_open_document (_tmp2_, _tmp3_, _tmp4_);
				_tmp6_ = _tmp5_;
				_g_object_unref0 (_tmp6_);
				jump_to = FALSE;
				_g_object_unref0 (file);
			}
		}
	}
}


MainWindow* latexila_get_active_window (Latexila* self) {
	MainWindow* result;
	MainWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_active_window;
	result = _tmp0_;
	return result;
}


static void latexila_set_active_window (Latexila* self, MainWindow* value) {
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_active_window);
	self->priv->_active_window = _tmp1_;
	g_object_notify ((GObject *) self, "active-window");
}


static void latexila_class_init (LatexilaClass * klass) {
	latexila_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LatexilaPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_latexila_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_latexila_set_property;
	G_OBJECT_CLASS (klass)->finalize = latexila_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), LATEXILA_ACTIVE_WINDOW, g_param_spec_object ("active-window", "active-window", "active-window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void latexila_instance_init (Latexila * self) {
	self->priv = LATEXILA_GET_PRIVATE (self);
}


static void latexila_finalize (GObject* obj) {
	Latexila * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LATEXILA, Latexila);
	_g_object_unref0 (self->priv->_active_window);
	G_OBJECT_CLASS (latexila_parent_class)->finalize (obj);
}


GType latexila_get_type (void) {
	static volatile gsize latexila_type_id__volatile = 0;
	if (g_once_init_enter (&latexila_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LatexilaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) latexila_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Latexila), 0, (GInstanceInitFunc) latexila_instance_init, NULL };
		GType latexila_type_id;
		latexila_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "Latexila", &g_define_type_info, 0);
		g_once_init_leave (&latexila_type_id__volatile, latexila_type_id);
	}
	return latexila_type_id__volatile;
}


static void _vala_latexila_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Latexila * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LATEXILA, Latexila);
	switch (property_id) {
		case LATEXILA_ACTIVE_WINDOW:
		g_value_set_object (value, latexila_get_active_window (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_latexila_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Latexila * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LATEXILA, Latexila);
	switch (property_id) {
		case LATEXILA_ACTIVE_WINDOW:
		latexila_set_active_window (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



