/* file_browser.c generated by valac 0.18.0.1-c1117, the Vala compiler
 * generated from file_browser.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <gtksourceview/gtksource.h>
#include <gee.h>


#define TYPE_FILE_BROWSER (file_browser_get_type ())
#define FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_BROWSER, FileBrowser))
#define FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_BROWSER, FileBrowserClass))
#define IS_FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_BROWSER))
#define IS_FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_BROWSER))
#define FILE_BROWSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_BROWSER, FileBrowserClass))

typedef struct _FileBrowser FileBrowser;
typedef struct _FileBrowserClass FileBrowserClass;
typedef struct _FileBrowserPrivate FileBrowserPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define FILE_BROWSER_TYPE_PARENT_DIR_COLUMN (file_browser_parent_dir_column_get_type ())

#define FILE_BROWSER_TYPE_FILE_COLUMN (file_browser_file_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block20Data Block20Data;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _Block21Data Block21Data;

struct _FileBrowser {
	GtkGrid parent_instance;
	FileBrowserPrivate * priv;
};

struct _FileBrowserClass {
	GtkGridClass parent_class;
};

struct _FileBrowserPrivate {
	MainWindow* _main_window;
	GtkListStore* _parent_dir_store;
	GtkComboBox* _combo_box;
	GtkListStore* _list_store;
	GtkTreeView* _list_view;
	GFile* _current_directory;
	GFileMonitor* _monitor;
	GtkToolButton* _parent_button;
	GSettings* _settings;
	GSettings* _latex_settings;
	guint _timeout_id;
};

typedef enum  {
	FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF,
	FILE_BROWSER_PARENT_DIR_COLUMN_NAME,
	FILE_BROWSER_PARENT_DIR_COLUMN_FILE,
	FILE_BROWSER_PARENT_DIR_COLUMN_N_COLUMNS
} FileBrowserParentDirColumn;

typedef enum  {
	FILE_BROWSER_FILE_COLUMN_PIXBUF,
	FILE_BROWSER_FILE_COLUMN_NAME,
	FILE_BROWSER_FILE_COLUMN_IS_DIR,
	FILE_BROWSER_FILE_COLUMN_N_COLUMNS
} FileBrowserFileColumn;

struct _Block20Data {
	int _ref_count_;
	FileBrowser * self;
	GtkToolButton* jump_button;
};

struct _Block21Data {
	int _ref_count_;
	FileBrowser * self;
	GtkMenu* menu;
};


static gpointer file_browser_parent_class = NULL;

GType file_browser_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
#define FILE_BROWSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_FILE_BROWSER, FileBrowserPrivate))
enum  {
	FILE_BROWSER_DUMMY_PROPERTY
};
static GType file_browser_parent_dir_column_get_type (void) G_GNUC_UNUSED;
static GType file_browser_file_column_get_type (void) G_GNUC_UNUSED;
FileBrowser* file_browser_new (MainWindow* main_window);
FileBrowser* file_browser_construct (GType object_type, MainWindow* main_window);
static void file_browser_init_settings (FileBrowser* self);
static void file_browser_init_combo_box (FileBrowser* self);
static void file_browser_init_toolbar (FileBrowser* self);
static void file_browser_init_list (FileBrowser* self);
static void file_browser_set_directory (FileBrowser* self, GFile* directory, gboolean force);
static GFile* file_browser_get_default_directory (FileBrowser* self);
static void file_browser_refresh (FileBrowser* self);
static void _file_browser_refresh_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void file_browser_delayed_refresh (FileBrowser* self);
static void _file_browser_delayed_refresh_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda125_ (FileBrowser* self);
static void ___lambda125__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static gint file_browser_on_sort (FileBrowser* self, GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b);
static gint _file_browser_on_sort_gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
static void __lambda132_ (FileBrowser* self, GtkTreePath* path);
gchar* utils_get_extension (const gchar* path);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_open_document (MainWindow* self, GFile* location, gboolean jump_to);
void utils_show_uri (GdkScreen* screen, const gchar* uri, GError** error);
static void ___lambda132__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static GtkToolButton* file_browser_get_home_button (FileBrowser* self);
static GtkToolButton* file_browser_get_parent_button (FileBrowser* self);
static GtkToolButton* file_browser_get_jump_button (FileBrowser* self);
static GtkToolButton* file_browser_get_properties_button (FileBrowser* self);
static void __lambda126_ (FileBrowser* self);
static void ___lambda126__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda127_ (FileBrowser* self);
static void ___lambda127__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
static void __lambda128_ (FileBrowser* self);
DocumentTab* main_window_get_active_tab (MainWindow* self);
GType document_get_type (void) G_GNUC_CONST;
Document* main_window_get_active_document (MainWindow* self);
GFile* document_get_location (Document* self);
static void ___lambda128__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda129_ (Block20Data* _data20_);
static void file_browser_update_jump_button_sensitivity (FileBrowser* self, GtkToolButton* jump_button);
static void ___lambda130_ (Block20Data* _data20_);
static void ____lambda130__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void ___lambda129__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static void __lambda131_ (Block21Data* _data21_);
static void ___lambda131__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void file_browser_update_parent_directories (FileBrowser* self);
static void file_browser_update_list (FileBrowser* self);
static void file_browser_handle_error (FileBrowser* self, GError* _error_);
static void file_browser_insert_file (FileBrowser* self, gboolean is_dir, const gchar* pixbuf, const gchar* basename);
static gchar* file_browser_get_extension_stock_id (FileBrowser* self, const gchar* file_extension);
static void file_browser_monitor_directory (FileBrowser* self);
static void _file_browser_refresh_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
static gboolean __lambda124_ (FileBrowser* self);
static gboolean ___lambda124__gsource_func (gpointer self);
static void file_browser_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType file_browser_parent_dir_column_get_type (void) {
	static volatile gsize file_browser_parent_dir_column_type_id__volatile = 0;
	if (g_once_init_enter (&file_browser_parent_dir_column_type_id__volatile)) {
		static const GEnumValue values[] = {{FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF, "FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF", "pixbuf"}, {FILE_BROWSER_PARENT_DIR_COLUMN_NAME, "FILE_BROWSER_PARENT_DIR_COLUMN_NAME", "name"}, {FILE_BROWSER_PARENT_DIR_COLUMN_FILE, "FILE_BROWSER_PARENT_DIR_COLUMN_FILE", "file"}, {FILE_BROWSER_PARENT_DIR_COLUMN_N_COLUMNS, "FILE_BROWSER_PARENT_DIR_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType file_browser_parent_dir_column_type_id;
		file_browser_parent_dir_column_type_id = g_enum_register_static ("FileBrowserParentDirColumn", values);
		g_once_init_leave (&file_browser_parent_dir_column_type_id__volatile, file_browser_parent_dir_column_type_id);
	}
	return file_browser_parent_dir_column_type_id__volatile;
}


static GType file_browser_file_column_get_type (void) {
	static volatile gsize file_browser_file_column_type_id__volatile = 0;
	if (g_once_init_enter (&file_browser_file_column_type_id__volatile)) {
		static const GEnumValue values[] = {{FILE_BROWSER_FILE_COLUMN_PIXBUF, "FILE_BROWSER_FILE_COLUMN_PIXBUF", "pixbuf"}, {FILE_BROWSER_FILE_COLUMN_NAME, "FILE_BROWSER_FILE_COLUMN_NAME", "name"}, {FILE_BROWSER_FILE_COLUMN_IS_DIR, "FILE_BROWSER_FILE_COLUMN_IS_DIR", "is-dir"}, {FILE_BROWSER_FILE_COLUMN_N_COLUMNS, "FILE_BROWSER_FILE_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType file_browser_file_column_type_id;
		file_browser_file_column_type_id = g_enum_register_static ("FileBrowserFileColumn", values);
		g_once_init_leave (&file_browser_file_column_type_id__volatile, file_browser_file_column_type_id);
	}
	return file_browser_file_column_type_id__volatile;
}


FileBrowser* file_browser_construct (GType object_type, MainWindow* main_window) {
	FileBrowser * self = NULL;
	MainWindow* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_;
	g_return_val_if_fail (main_window != NULL, NULL);
	self = (FileBrowser*) g_object_new (object_type, NULL);
	_tmp0_ = main_window;
	self->priv->_main_window = _tmp0_;
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	file_browser_init_settings (self);
	file_browser_init_combo_box (self);
	file_browser_init_toolbar (self);
	file_browser_init_list (self);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp1_ = file_browser_get_default_directory (self);
	_tmp2_ = _tmp1_;
	file_browser_set_directory (self, _tmp2_, FALSE);
	_g_object_unref0 (_tmp2_);
	return self;
}


FileBrowser* file_browser_new (MainWindow* main_window) {
	return file_browser_construct (TYPE_FILE_BROWSER, main_window);
}


/*************************************************************************/
static void _file_browser_refresh_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	file_browser_refresh (self);
}


static void _file_browser_delayed_refresh_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	file_browser_delayed_refresh (self);
}


static void file_browser_init_settings (FileBrowser* self) {
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.file-browser");
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp0_;
	_tmp1_ = self->priv->_settings;
	g_signal_connect_object (_tmp1_, "changed::show-build-files", (GCallback) _file_browser_refresh_g_settings_changed, self, 0);
	_tmp2_ = self->priv->_settings;
	g_signal_connect_object (_tmp2_, "changed::show-hidden-files", (GCallback) _file_browser_refresh_g_settings_changed, self, 0);
	_tmp3_ = g_settings_new ("org.gnome.latexila.preferences.latex");
	_g_object_unref0 (self->priv->_latex_settings);
	self->priv->_latex_settings = _tmp3_;
	_tmp4_ = self->priv->_latex_settings;
	g_signal_connect_object (_tmp4_, "changed::clean-extensions", (GCallback) _file_browser_delayed_refresh_g_settings_changed, self, 0);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda125_ (FileBrowser* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	_tmp0_ = self->priv->_combo_box;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		GtkComboBox* _tmp3_;
		GtkTreeModel* _tmp4_ = NULL;
		GtkTreeModel* _tmp5_;
		GtkTreeModel* model;
		GFile* file = NULL;
		GtkTreeModel* _tmp6_;
		GtkTreeIter _tmp7_;
		GFile* _tmp8_;
		_tmp3_ = self->priv->_combo_box;
		_tmp4_ = gtk_combo_box_get_model (_tmp3_);
		_tmp5_ = _g_object_ref0 (_tmp4_);
		model = _tmp5_;
		_tmp6_ = model;
		_tmp7_ = iter;
		gtk_tree_model_get (_tmp6_, &_tmp7_, FILE_BROWSER_PARENT_DIR_COLUMN_FILE, &file, -1);
		_tmp8_ = file;
		file_browser_set_directory (self, _tmp8_, FALSE);
		_g_object_unref0 (file);
		_g_object_unref0 (model);
	}
}


static void ___lambda125__gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	__lambda125_ (self);
}


static void file_browser_init_combo_box (FileBrowser* self) {
	GtkListStore* _tmp0_;
	GtkListStore* _tmp1_;
	GtkComboBox* _tmp2_;
	GtkComboBox* _tmp3_;
	GtkCellRendererPixbuf* _tmp4_;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkComboBox* _tmp5_;
	GtkComboBox* _tmp6_;
	GtkCellRendererText* _tmp7_;
	GtkCellRendererText* text_renderer;
	GtkComboBox* _tmp8_;
	GtkComboBox* _tmp9_;
	GtkComboBox* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_list_store_new ((gint) FILE_BROWSER_PARENT_DIR_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_FILE);
	_g_object_unref0 (self->priv->_parent_dir_store);
	self->priv->_parent_dir_store = _tmp0_;
	_tmp1_ = self->priv->_parent_dir_store;
	_tmp2_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) _tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->_combo_box);
	self->priv->_combo_box = _tmp2_;
	_tmp3_ = self->priv->_combo_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp3_);
	_tmp4_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp4_);
	pixbuf_renderer = _tmp4_;
	_tmp5_ = self->priv->_combo_box;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp5_, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	_tmp6_ = self->priv->_combo_box;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp6_, (GtkCellRenderer*) pixbuf_renderer, "stock-id", FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF, NULL);
	_tmp7_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp7_);
	text_renderer = _tmp7_;
	_tmp8_ = self->priv->_combo_box;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp8_, (GtkCellRenderer*) text_renderer, TRUE);
	_tmp9_ = self->priv->_combo_box;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp9_, (GtkCellRenderer*) text_renderer, "text", FILE_BROWSER_PARENT_DIR_COLUMN_NAME, NULL);
	g_object_set (text_renderer, "ellipsize-set", TRUE, NULL);
	g_object_set (text_renderer, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	_tmp10_ = self->priv->_combo_box;
	g_signal_connect_object (_tmp10_, "changed", (GCallback) ___lambda125__gtk_combo_box_changed, self, 0);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
}


static gint _file_browser_on_sort_gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self) {
	gint result;
	result = file_browser_on_sort (self, model, a, b);
	return result;
}


static void __lambda132_ (FileBrowser* self, GtkTreePath* path) {
	GtkListStore* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp2_;
	GtkTreePath* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	gchar* basename = NULL;
	gboolean is_dir = FALSE;
	GtkTreeModel* _tmp6_;
	GtkTreeIter _tmp7_;
	GFile* _tmp8_;
	const gchar* _tmp9_;
	GFile* _tmp10_ = NULL;
	GFile* file;
	gboolean _tmp11_;
	const gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* extension;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	const gchar* _tmp17_;
	gboolean _tmp19_;
	gboolean _tmp21_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->_list_store;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GTK_TYPE_TREE_MODEL) ? ((GtkTreeModel*) _tmp0_) : NULL);
	model = _tmp1_;
	_tmp2_ = model;
	_tmp3_ = path;
	_tmp5_ = gtk_tree_model_get_iter (_tmp2_, &_tmp4_, _tmp3_);
	iter = _tmp4_;
	if (!_tmp5_) {
		_g_object_unref0 (model);
		return;
	}
	_tmp6_ = model;
	_tmp7_ = iter;
	gtk_tree_model_get (_tmp6_, &_tmp7_, FILE_BROWSER_FILE_COLUMN_NAME, &basename, FILE_BROWSER_FILE_COLUMN_IS_DIR, &is_dir, -1);
	_tmp8_ = self->priv->_current_directory;
	_tmp9_ = basename;
	_tmp10_ = g_file_get_child (_tmp8_, _tmp9_);
	file = _tmp10_;
	_tmp11_ = is_dir;
	if (_tmp11_) {
		GFile* _tmp12_;
		_tmp12_ = file;
		file_browser_set_directory (self, _tmp12_, FALSE);
		_g_object_unref0 (file);
		_g_free0 (basename);
		_g_object_unref0 (model);
		return;
	}
	_tmp13_ = basename;
	_tmp14_ = utils_get_extension (_tmp13_);
	extension = _tmp14_;
	_tmp17_ = extension;
	if (g_strcmp0 (_tmp17_, ".dvi") != 0) {
		const gchar* _tmp18_;
		_tmp18_ = extension;
		_tmp16_ = g_strcmp0 (_tmp18_, ".pdf") != 0;
	} else {
		_tmp16_ = FALSE;
	}
	_tmp19_ = _tmp16_;
	if (_tmp19_) {
		const gchar* _tmp20_;
		_tmp20_ = extension;
		_tmp15_ = g_strcmp0 (_tmp20_, ".ps") != 0;
	} else {
		_tmp15_ = FALSE;
	}
	_tmp21_ = _tmp15_;
	if (_tmp21_) {
		MainWindow* _tmp22_;
		GFile* _tmp23_;
		DocumentTab* _tmp24_ = NULL;
		DocumentTab* _tmp25_;
		_tmp22_ = self->priv->_main_window;
		_tmp23_ = file;
		_tmp24_ = main_window_open_document (_tmp22_, _tmp23_, TRUE);
		_tmp25_ = _tmp24_;
		_g_object_unref0 (_tmp25_);
		_g_free0 (extension);
		_g_object_unref0 (file);
		_g_free0 (basename);
		_g_object_unref0 (model);
		return;
	}
	{
		GdkScreen* _tmp26_ = NULL;
		GFile* _tmp27_;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_;
		_tmp26_ = gtk_widget_get_screen ((GtkWidget*) self);
		_tmp27_ = file;
		_tmp28_ = g_file_get_uri (_tmp27_);
		_tmp29_ = _tmp28_;
		utils_show_uri (_tmp26_, _tmp29_, &_inner_error_);
		_g_free0 (_tmp29_);
		if (_inner_error_ != NULL) {
			goto __catch27_g_error;
		}
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError* e = NULL;
		GFile* _tmp30_;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_;
		GError* _tmp33_;
		const gchar* _tmp34_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp30_ = file;
		_tmp31_ = g_file_get_uri (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = e;
		_tmp34_ = _tmp33_->message;
		g_warning ("file_browser.vala:193: Impossible to open the file '%s': %s", _tmp32_, _tmp34_);
		_g_free0 (_tmp32_);
		_g_error_free0 (e);
	}
	__finally27:
	if (_inner_error_ != NULL) {
		_g_free0 (extension);
		_g_object_unref0 (file);
		_g_free0 (basename);
		_g_object_unref0 (model);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (extension);
	_g_object_unref0 (file);
	_g_free0 (basename);
	_g_object_unref0 (model);
}


static void ___lambda132__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	__lambda132_ (self, path);
}


static void file_browser_init_list (FileBrowser* self) {
	GtkListStore* _tmp0_;
	GtkListStore* _tmp1_;
	GtkListStore* _tmp2_;
	GtkListStore* _tmp3_;
	GtkTreeView* _tmp4_;
	GtkTreeView* _tmp5_;
	GtkTreeView* _tmp6_;
	GtkTreeView* _tmp7_;
	GtkScrolledWindow* _tmp8_ = NULL;
	GtkScrolledWindow* scrolled_window;
	GtkTreeViewColumn* _tmp9_;
	GtkTreeViewColumn* column;
	GtkTreeView* _tmp10_;
	GtkCellRendererPixbuf* _tmp11_;
	GtkCellRendererPixbuf* pixbuf_renderer;
	GtkCellRendererText* _tmp12_;
	GtkCellRendererText* text_renderer;
	GtkTreeView* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_list_store_new ((gint) FILE_BROWSER_FILE_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN);
	_g_object_unref0 (self->priv->_list_store);
	self->priv->_list_store = _tmp0_;
	_tmp1_ = self->priv->_list_store;
	gtk_tree_sortable_set_sort_func ((GtkTreeSortable*) _tmp1_, 0, _file_browser_on_sort_gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
	_tmp2_ = self->priv->_list_store;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp2_, 0, GTK_SORT_ASCENDING);
	_tmp3_ = self->priv->_list_store;
	_tmp4_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp3_);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->_list_view);
	self->priv->_list_view = _tmp4_;
	_tmp5_ = self->priv->_list_view;
	gtk_tree_view_set_headers_visible (_tmp5_, FALSE);
	_tmp6_ = self->priv->_list_view;
	g_object_set ((GtkWidget*) _tmp6_, "expand", TRUE, NULL);
	_tmp7_ = self->priv->_list_view;
	_tmp8_ = utils_add_scrollbar ((GtkWidget*) _tmp7_);
	scrolled_window = _tmp8_;
	gtk_scrolled_window_set_shadow_type (scrolled_window, GTK_SHADOW_IN);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) scrolled_window);
	_tmp9_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp9_);
	column = _tmp9_;
	_tmp10_ = self->priv->_list_view;
	gtk_tree_view_append_column (_tmp10_, column);
	_tmp11_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp11_);
	pixbuf_renderer = _tmp11_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	gtk_tree_view_column_set_attributes (column, (GtkCellRenderer*) pixbuf_renderer, "stock-id", FILE_BROWSER_FILE_COLUMN_PIXBUF, NULL);
	_tmp12_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp12_);
	text_renderer = _tmp12_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) text_renderer, TRUE);
	gtk_tree_view_column_set_attributes (column, (GtkCellRenderer*) text_renderer, "text", FILE_BROWSER_FILE_COLUMN_NAME, NULL);
	_tmp13_ = self->priv->_list_view;
	g_signal_connect_object (_tmp13_, "row-activated", (GCallback) ___lambda132__gtk_tree_view_row_activated, self, 0);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (column);
	_g_object_unref0 (scrolled_window);
}


static void file_browser_init_toolbar (FileBrowser* self) {
	GtkToolbar* _tmp0_;
	GtkToolbar* toolbar;
	GtkToolButton* _tmp1_ = NULL;
	GtkToolButton* _tmp2_;
	GtkToolButton* _tmp3_ = NULL;
	GtkToolButton* _tmp4_;
	GtkToolButton* _tmp5_ = NULL;
	GtkToolButton* _tmp6_;
	GtkToolButton* _tmp7_ = NULL;
	GtkToolButton* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp0_);
	toolbar = _tmp0_;
	gtk_toolbar_set_icon_size (toolbar, GTK_ICON_SIZE_MENU);
	gtk_toolbar_set_style (toolbar, GTK_TOOLBAR_ICONS);
	_tmp1_ = file_browser_get_home_button (self);
	_tmp2_ = _tmp1_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp2_, -1);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = file_browser_get_parent_button (self);
	_tmp4_ = _tmp3_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp4_, -1);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = file_browser_get_jump_button (self);
	_tmp6_ = _tmp5_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp6_, -1);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = file_browser_get_properties_button (self);
	_tmp8_ = _tmp7_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp8_, -1);
	_g_object_unref0 (_tmp8_);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) toolbar);
	_g_object_unref0 (toolbar);
}


static void __lambda126_ (FileBrowser* self) {
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* home_dir;
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	home_dir = _tmp1_;
	file_browser_set_directory (self, home_dir, FALSE);
	_g_object_unref0 (home_dir);
}


static void ___lambda126__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda126_ (self);
}


static GtkToolButton* file_browser_get_home_button (FileBrowser* self) {
	GtkToolButton* result = NULL;
	GtkToolButton* _tmp0_;
	GtkToolButton* home_button;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new_from_stock (GTK_STOCK_HOME);
	g_object_ref_sink (_tmp0_);
	home_button = _tmp0_;
	_tmp1_ = _ ("Go to the home directory");
	gtk_widget_set_tooltip_text ((GtkWidget*) home_button, _tmp1_);
	g_signal_connect_object (home_button, "clicked", (GCallback) ___lambda126__gtk_tool_button_clicked, self, 0);
	result = home_button;
	return result;
}


static void __lambda127_ (FileBrowser* self) {
	GFile* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* parent;
	_tmp0_ = self->priv->_current_directory;
	_tmp1_ = g_file_get_parent (_tmp0_);
	parent = _tmp1_;
	g_return_if_fail (parent != NULL);
	file_browser_set_directory (self, parent, FALSE);
	_g_object_unref0 (parent);
}


static void ___lambda127__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda127_ (self);
}


static GtkToolButton* file_browser_get_parent_button (FileBrowser* self) {
	GtkToolButton* result = NULL;
	GtkToolButton* _tmp0_;
	GtkToolButton* _tmp1_;
	const gchar* _tmp2_ = NULL;
	GtkToolButton* _tmp3_;
	GtkToolButton* _tmp4_;
	GtkToolButton* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new_from_stock (GTK_STOCK_GO_UP);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->_parent_button);
	self->priv->_parent_button = _tmp0_;
	_tmp1_ = self->priv->_parent_button;
	_tmp2_ = _ ("Go to the parent directory");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp1_, _tmp2_);
	_tmp3_ = self->priv->_parent_button;
	g_signal_connect_object (_tmp3_, "clicked", (GCallback) ___lambda127__gtk_tool_button_clicked, self, 0);
	_tmp4_ = self->priv->_parent_button;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	result = _tmp5_;
	return result;
}


static Block20Data* block20_data_ref (Block20Data* _data20_) {
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}


static void block20_data_unref (void * _userdata_) {
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		FileBrowser * self;
		self = _data20_->self;
		_g_object_unref0 (_data20_->jump_button);
		_g_object_unref0 (self);
		g_slice_free (Block20Data, _data20_);
	}
}


static void __lambda128_ (FileBrowser* self) {
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	MainWindow* _tmp3_;
	Document* _tmp4_;
	Document* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	MainWindow* _tmp8_;
	Document* _tmp9_;
	Document* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_ = NULL;
	GFile* _tmp14_;
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_main_window;
	_tmp4_ = main_window_get_active_document (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = document_get_location (_tmp5_);
	_tmp7_ = _tmp6_;
	g_return_if_fail (_tmp7_ != NULL);
	_tmp8_ = self->priv->_main_window;
	_tmp9_ = main_window_get_active_document (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = document_get_location (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_file_get_parent (_tmp12_);
	_tmp14_ = _tmp13_;
	file_browser_set_directory (self, _tmp14_, FALSE);
	_g_object_unref0 (_tmp14_);
}


static void ___lambda128__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda128_ (self);
}


static void ___lambda130_ (Block20Data* _data20_) {
	FileBrowser * self;
	self = _data20_->self;
	file_browser_update_jump_button_sensitivity (self, _data20_->jump_button);
}


static void ____lambda130__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	___lambda130_ (self);
}


static void __lambda129_ (Block20Data* _data20_) {
	FileBrowser * self;
	MainWindow* _tmp0_;
	Document* _tmp1_;
	Document* _tmp2_;
	self = _data20_->self;
	file_browser_update_jump_button_sensitivity (self, _data20_->jump_button);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_document (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		MainWindow* _tmp3_;
		Document* _tmp4_;
		Document* _tmp5_;
		_tmp3_ = self->priv->_main_window;
		_tmp4_ = main_window_get_active_document (_tmp3_);
		_tmp5_ = _tmp4_;
		g_signal_connect_data ((GObject*) _tmp5_, "notify::location", (GCallback) ____lambda130__g_object_notify, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, 0);
	}
}


static void ___lambda129__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda129_ (self);
}


static GtkToolButton* file_browser_get_jump_button (FileBrowser* self) {
	GtkToolButton* result = NULL;
	Block20Data* _data20_;
	GtkToolButton* _tmp0_;
	const gchar* _tmp1_ = NULL;
	MainWindow* _tmp2_;
	GtkToolButton* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_data20_ = g_slice_new0 (Block20Data);
	_data20_->_ref_count_ = 1;
	_data20_->self = g_object_ref (self);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new_from_stock (GTK_STOCK_JUMP_TO);
	g_object_ref_sink (_tmp0_);
	_data20_->jump_button = _tmp0_;
	_tmp1_ = _ ("Go to the active document directory");
	gtk_widget_set_tooltip_text ((GtkWidget*) _data20_->jump_button, _tmp1_);
	g_signal_connect_object (_data20_->jump_button, "clicked", (GCallback) ___lambda128__gtk_tool_button_clicked, self, 0);
	_tmp2_ = self->priv->_main_window;
	g_signal_connect_data ((GObject*) _tmp2_, "notify::active-document", (GCallback) ___lambda129__g_object_notify, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, 0);
	_tmp3_ = _g_object_ref0 (_data20_->jump_button);
	result = _tmp3_;
	block20_data_unref (_data20_);
	_data20_ = NULL;
	return result;
}


static Block21Data* block21_data_ref (Block21Data* _data21_) {
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}


static void block21_data_unref (void * _userdata_) {
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		FileBrowser * self;
		self = _data21_->self;
		_g_object_unref0 (_data21_->menu);
		_g_object_unref0 (self);
		g_slice_free (Block21Data, _data21_);
	}
}


static void __lambda131_ (Block21Data* _data21_) {
	FileBrowser * self;
	guint32 _tmp0_ = 0U;
	self = _data21_->self;
	_tmp0_ = gtk_get_current_event_time ();
	gtk_menu_popup (_data21_->menu, NULL, NULL, NULL, NULL, (guint) 0, _tmp0_);
}


static void ___lambda131__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda131_ (self);
}


static GtkToolButton* file_browser_get_properties_button (FileBrowser* self) {
	GtkToolButton* result = NULL;
	Block21Data* _data21_;
	const gchar* _tmp0_ = NULL;
	GtkCheckMenuItem* _tmp1_;
	GtkCheckMenuItem* show_build_files;
	GSettings* _tmp2_;
	const gchar* _tmp3_ = NULL;
	GtkCheckMenuItem* _tmp4_;
	GtkCheckMenuItem* show_hidden_files;
	GSettings* _tmp5_;
	GtkMenu* _tmp6_;
	GtkToolButton* _tmp7_;
	GtkToolButton* button;
	g_return_val_if_fail (self != NULL, NULL);
	_data21_ = g_slice_new0 (Block21Data);
	_data21_->_ref_count_ = 1;
	_data21_->self = g_object_ref (self);
	_tmp0_ = _ ("Show build files");
	_tmp1_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_tmp0_);
	g_object_ref_sink (_tmp1_);
	show_build_files = _tmp1_;
	_tmp2_ = self->priv->_settings;
	g_settings_bind (_tmp2_, "show-build-files", (GObject*) show_build_files, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp3_ = _ ("Show hidden files");
	_tmp4_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_tmp3_);
	g_object_ref_sink (_tmp4_);
	show_hidden_files = _tmp4_;
	_tmp5_ = self->priv->_settings;
	g_settings_bind (_tmp5_, "show-hidden-files", (GObject*) show_hidden_files, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp6_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp6_);
	_data21_->menu = _tmp6_;
	gtk_menu_shell_append ((GtkMenuShell*) _data21_->menu, (GtkWidget*) ((GtkMenuItem*) show_build_files));
	gtk_menu_shell_append ((GtkMenuShell*) _data21_->menu, (GtkWidget*) ((GtkMenuItem*) show_hidden_files));
	gtk_widget_show_all ((GtkWidget*) _data21_->menu);
	_tmp7_ = (GtkToolButton*) gtk_tool_button_new_from_stock (GTK_STOCK_PROPERTIES);
	g_object_ref_sink (_tmp7_);
	button = _tmp7_;
	g_signal_connect_data (button, "clicked", (GCallback) ___lambda131__gtk_tool_button_clicked, block21_data_ref (_data21_), (GClosureNotify) block21_data_unref, 0);
	result = button;
	_g_object_unref0 (show_hidden_files);
	_g_object_unref0 (show_build_files);
	block21_data_unref (_data21_);
	_data21_ = NULL;
	return result;
}


/*************************************************************************/
static void file_browser_update_parent_directories (FileBrowser* self) {
	GtkListStore* _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeList* parent_dirs;
	GeeList* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_ = NULL;
	GFile* parent;
	gint depth;
	GtkComboBox* _tmp44_;
	gint _tmp45_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_parent_dir_store;
	gtk_list_store_clear (_tmp0_);
	_tmp1_ = gee_linked_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	parent_dirs = (GeeList*) _tmp1_;
	_tmp2_ = parent_dirs;
	_tmp3_ = self->priv->_current_directory;
	gee_collection_add ((GeeCollection*) _tmp2_, _tmp3_);
	_tmp4_ = self->priv->_current_directory;
	_tmp5_ = g_file_get_parent (_tmp4_);
	parent = _tmp5_;
	while (TRUE) {
		GFile* _tmp6_;
		GeeList* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_ = NULL;
		_tmp6_ = parent;
		if (!(_tmp6_ != NULL)) {
			break;
		}
		_tmp7_ = parent_dirs;
		_tmp8_ = parent;
		gee_list_insert (_tmp7_, 0, _tmp8_);
		_tmp9_ = parent;
		_tmp10_ = g_file_get_parent (_tmp9_);
		_g_object_unref0 (parent);
		parent = _tmp10_;
	}
	depth = 0;
	{
		GeeList* _tmp11_;
		GeeList* _tmp12_;
		GeeList* _parent_dir_list;
		GeeList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _parent_dir_size;
		gint _parent_dir_index;
		_tmp11_ = parent_dirs;
		_tmp12_ = _g_object_ref0 (_tmp11_);
		_parent_dir_list = _tmp12_;
		_tmp13_ = _parent_dir_list;
		_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_parent_dir_size = _tmp15_;
		_parent_dir_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			GeeList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_ = NULL;
			GFile* parent_dir;
			gchar* basename = NULL;
			gint _tmp22_;
			gchar* pixbuf = NULL;
			gint _tmp27_;
			GtkTreeIter iter = {0};
			GtkListStore* _tmp36_;
			GtkTreeIter _tmp37_ = {0};
			GtkListStore* _tmp38_;
			GtkTreeIter _tmp39_;
			GFile* _tmp40_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			gint _tmp43_;
			_tmp16_ = _parent_dir_index;
			_parent_dir_index = _tmp16_ + 1;
			_tmp17_ = _parent_dir_index;
			_tmp18_ = _parent_dir_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _parent_dir_list;
			_tmp20_ = _parent_dir_index;
			_tmp21_ = gee_list_get (_tmp19_, _tmp20_);
			parent_dir = (GFile*) _tmp21_;
			_tmp22_ = depth;
			if (_tmp22_ == 0) {
				const gchar* _tmp23_ = NULL;
				gchar* _tmp24_;
				_tmp23_ = _ ("File System");
				_tmp24_ = g_strdup (_tmp23_);
				_g_free0 (basename);
				basename = _tmp24_;
			} else {
				GFile* _tmp25_;
				gchar* _tmp26_ = NULL;
				_tmp25_ = parent_dir;
				_tmp26_ = g_file_get_basename (_tmp25_);
				_g_free0 (basename);
				basename = _tmp26_;
			}
			_tmp27_ = depth;
			if (_tmp27_ == 0) {
				gchar* _tmp28_;
				_tmp28_ = g_strdup (GTK_STOCK_HARDDISK);
				_g_free0 (pixbuf);
				pixbuf = _tmp28_;
			} else {
				const gchar* _tmp29_ = NULL;
				GFile* _tmp30_;
				gchar* _tmp31_ = NULL;
				gchar* _tmp32_;
				gboolean _tmp33_;
				_tmp29_ = g_get_home_dir ();
				_tmp30_ = parent_dir;
				_tmp31_ = g_file_get_path (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = g_strcmp0 (_tmp29_, _tmp32_) == 0;
				_g_free0 (_tmp32_);
				if (_tmp33_) {
					gchar* _tmp34_;
					_tmp34_ = g_strdup (GTK_STOCK_HOME);
					_g_free0 (pixbuf);
					pixbuf = _tmp34_;
				} else {
					gchar* _tmp35_;
					_tmp35_ = g_strdup (GTK_STOCK_DIRECTORY);
					_g_free0 (pixbuf);
					pixbuf = _tmp35_;
				}
			}
			_tmp36_ = self->priv->_parent_dir_store;
			gtk_list_store_append (_tmp36_, &_tmp37_);
			iter = _tmp37_;
			_tmp38_ = self->priv->_parent_dir_store;
			_tmp39_ = iter;
			_tmp40_ = parent_dir;
			_tmp41_ = basename;
			_tmp42_ = pixbuf;
			gtk_list_store_set (_tmp38_, &_tmp39_, FILE_BROWSER_PARENT_DIR_COLUMN_FILE, _tmp40_, FILE_BROWSER_PARENT_DIR_COLUMN_NAME, _tmp41_, FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF, _tmp42_, -1);
			_tmp43_ = depth;
			depth = _tmp43_ + 1;
			_g_free0 (pixbuf);
			_g_free0 (basename);
			_g_object_unref0 (parent_dir);
		}
		_g_object_unref0 (_parent_dir_list);
	}
	_tmp44_ = self->priv->_combo_box;
	_tmp45_ = depth;
	gtk_combo_box_set_active (_tmp44_, _tmp45_ - 1);
	_g_object_unref0 (parent);
	_g_object_unref0 (parent_dirs);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void file_browser_update_list (FileBrowser* self) {
	GtkListStore* _tmp0_;
	GtkTreeView* _tmp1_;
	GSettings* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean show_build_files;
	GSettings* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean show_hidden_files;
	GSettings* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* exts;
	const gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_ = NULL;
	gchar** clean_extensions;
	gint clean_extensions_length1;
	gint _clean_extensions_size_;
	GFileEnumerator* enumerator = NULL;
	GtkListStore* _tmp45_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_list_store;
	gtk_list_store_clear (_tmp0_);
	_tmp1_ = self->priv->_list_view;
	gtk_tree_view_columns_autosize (_tmp1_);
	_tmp2_ = self->priv->_settings;
	_tmp3_ = g_settings_get_boolean (_tmp2_, "show-build-files");
	show_build_files = _tmp3_;
	_tmp4_ = self->priv->_settings;
	_tmp5_ = g_settings_get_boolean (_tmp4_, "show-hidden-files");
	show_hidden_files = _tmp5_;
	_tmp6_ = self->priv->_latex_settings;
	_tmp7_ = g_settings_get_string (_tmp6_, "clean-extensions");
	exts = _tmp7_;
	_tmp8_ = exts;
	_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, " ", 0);
	clean_extensions = _tmp10_;
	clean_extensions_length1 = _vala_array_length (_tmp9_);
	_clean_extensions_size_ = clean_extensions_length1;
	{
		GFile* _tmp11_;
		GFileEnumerator* _tmp12_ = NULL;
		GFileEnumerator* _tmp13_;
		_tmp11_ = self->priv->_current_directory;
		_tmp12_ = g_file_enumerate_children (_tmp11_, "standard::type,standard::display-name", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		_tmp13_ = _tmp12_;
		if (_inner_error_ != NULL) {
			goto __catch28_g_error;
		}
		_g_object_unref0 (enumerator);
		enumerator = _tmp13_;
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp14_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = _error_;
		file_browser_handle_error (self, _tmp14_);
		_g_error_free0 (_error_);
		_g_object_unref0 (enumerator);
		clean_extensions = (_vala_array_free (clean_extensions, clean_extensions_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (exts);
		return;
	}
	__finally28:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (enumerator);
		clean_extensions = (_vala_array_free (clean_extensions, clean_extensions_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (exts);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	while (TRUE) {
		GFileInfo* info = NULL;
		GFileInfo* _tmp19_;
		GFileInfo* _tmp20_;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		gchar* basename;
		gboolean _tmp23_ = FALSE;
		const gchar* _tmp24_;
		gchar _tmp25_ = '\0';
		gboolean _tmp27_;
		GFileInfo* _tmp28_;
		GFileType _tmp29_ = 0;
		GFileType type;
		GFileType _tmp30_;
		gboolean _tmp32_;
		const gchar* _tmp39_;
		gchar* _tmp40_ = NULL;
		gchar* extension;
		const gchar* _tmp41_;
		gchar* _tmp42_ = NULL;
		gchar* stock_id;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		{
			GFileEnumerator* _tmp15_;
			GFileInfo* _tmp16_ = NULL;
			GFileInfo* _tmp17_;
			_tmp15_ = enumerator;
			_tmp16_ = g_file_enumerator_next_file (_tmp15_, NULL, &_inner_error_);
			_tmp17_ = _tmp16_;
			if (_inner_error_ != NULL) {
				goto __catch29_g_error;
			}
			_g_object_unref0 (info);
			info = _tmp17_;
		}
		goto __finally29;
		__catch29_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp18_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp18_ = _error_;
			file_browser_handle_error (self, _tmp18_);
			_g_error_free0 (_error_);
			_g_object_unref0 (info);
			_g_object_unref0 (enumerator);
			clean_extensions = (_vala_array_free (clean_extensions, clean_extensions_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (exts);
			return;
		}
		__finally29:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (info);
			_g_object_unref0 (enumerator);
			clean_extensions = (_vala_array_free (clean_extensions, clean_extensions_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (exts);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp19_ = info;
		if (_tmp19_ == NULL) {
			_g_object_unref0 (info);
			break;
		}
		_tmp20_ = info;
		_tmp21_ = g_file_info_get_display_name (_tmp20_);
		_tmp22_ = g_strdup (_tmp21_);
		basename = _tmp22_;
		_tmp24_ = basename;
		_tmp25_ = string_get (_tmp24_, (glong) 0);
		if (_tmp25_ == '.') {
			gboolean _tmp26_;
			_tmp26_ = show_hidden_files;
			_tmp23_ = !_tmp26_;
		} else {
			_tmp23_ = FALSE;
		}
		_tmp27_ = _tmp23_;
		if (_tmp27_) {
			_g_free0 (basename);
			_g_object_unref0 (info);
			continue;
		}
		_tmp28_ = info;
		_tmp29_ = g_file_info_get_file_type (_tmp28_);
		type = _tmp29_;
		_tmp30_ = type;
		if (_tmp30_ == G_FILE_TYPE_DIRECTORY) {
			const gchar* _tmp31_;
			_tmp31_ = basename;
			file_browser_insert_file (self, TRUE, GTK_STOCK_DIRECTORY, _tmp31_);
			_g_free0 (basename);
			_g_object_unref0 (info);
			continue;
		}
		_tmp32_ = show_build_files;
		if (!_tmp32_) {
			gboolean is_build_file;
			gchar** _tmp33_;
			gint _tmp33__length1;
			gboolean _tmp38_;
			is_build_file = FALSE;
			_tmp33_ = clean_extensions;
			_tmp33__length1 = clean_extensions_length1;
			{
				gchar** ext_collection = NULL;
				gint ext_collection_length1 = 0;
				gint _ext_collection_size_ = 0;
				gint ext_it = 0;
				ext_collection = _tmp33_;
				ext_collection_length1 = _tmp33__length1;
				for (ext_it = 0; ext_it < _tmp33__length1; ext_it = ext_it + 1) {
					gchar* _tmp34_;
					gchar* ext = NULL;
					_tmp34_ = g_strdup (ext_collection[ext_it]);
					ext = _tmp34_;
					{
						const gchar* _tmp35_;
						const gchar* _tmp36_;
						gboolean _tmp37_ = FALSE;
						_tmp35_ = basename;
						_tmp36_ = ext;
						_tmp37_ = g_str_has_suffix (_tmp35_, _tmp36_);
						if (_tmp37_) {
							is_build_file = TRUE;
							_g_free0 (ext);
							break;
						}
						_g_free0 (ext);
					}
				}
			}
			_tmp38_ = is_build_file;
			if (_tmp38_) {
				_g_free0 (basename);
				_g_object_unref0 (info);
				continue;
			}
		}
		_tmp39_ = basename;
		_tmp40_ = utils_get_extension (_tmp39_);
		extension = _tmp40_;
		_tmp41_ = extension;
		_tmp42_ = file_browser_get_extension_stock_id (self, _tmp41_);
		stock_id = _tmp42_;
		_tmp43_ = stock_id;
		_tmp44_ = basename;
		file_browser_insert_file (self, FALSE, _tmp43_, _tmp44_);
		_g_free0 (stock_id);
		_g_free0 (extension);
		_g_free0 (basename);
		_g_object_unref0 (info);
	}
	_tmp45_ = self->priv->_list_store;
	gtk_tree_sortable_sort_column_changed ((GtkTreeSortable*) _tmp45_);
	_g_object_unref0 (enumerator);
	clean_extensions = (_vala_array_free (clean_extensions, clean_extensions_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (exts);
}


static void file_browser_handle_error (FileBrowser* self, GError* _error_) {
	GError* _tmp0_;
	const gchar* _tmp1_;
	MainWindow* _tmp2_;
	const gchar* _tmp3_ = NULL;
	GtkMessageDialog* _tmp4_;
	GtkMessageDialog* dialog;
	GError* _tmp5_;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _error_;
	_tmp1_ = _tmp0_->message;
	g_warning ("file_browser.vala:445: File browser: %s", _tmp1_);
	_tmp2_ = self->priv->_main_window;
	_tmp3_ = _ ("File Browser");
	_tmp4_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp2_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_WARNING, GTK_BUTTONS_CLOSE, "%s", _tmp3_);
	g_object_ref_sink (_tmp4_);
	dialog = _tmp4_;
	_tmp5_ = _error_;
	_tmp6_ = _tmp5_->message;
	gtk_message_dialog_format_secondary_text (dialog, "%s", _tmp6_);
	gtk_dialog_run ((GtkDialog*) dialog);
	gtk_widget_destroy ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}


static void file_browser_insert_file (FileBrowser* self, gboolean is_dir, const gchar* pixbuf, const gchar* basename) {
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pixbuf != NULL);
	g_return_if_fail (basename != NULL);
	_tmp0_ = self->priv->_list_store;
	gtk_list_store_append (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = self->priv->_list_store;
	_tmp3_ = iter;
	_tmp4_ = is_dir;
	_tmp5_ = pixbuf;
	_tmp6_ = basename;
	gtk_list_store_set (_tmp2_, &_tmp3_, FILE_BROWSER_FILE_COLUMN_IS_DIR, _tmp4_, FILE_BROWSER_FILE_COLUMN_PIXBUF, _tmp5_, FILE_BROWSER_FILE_COLUMN_NAME, _tmp6_, -1);
}


static void _file_browser_refresh_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	file_browser_refresh (self);
}


static void file_browser_monitor_directory (FileBrowser* self) {
	GFile* _tmp0_;
	GFileMonitor* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_directory;
	if (_tmp0_ == NULL) {
		_g_object_unref0 (self->priv->_monitor);
		self->priv->_monitor = NULL;
		return;
	}
	{
		GFile* _tmp1_;
		GFileMonitor* _tmp2_ = NULL;
		GFileMonitor* _tmp3_;
		_tmp1_ = self->priv->_current_directory;
		_tmp2_ = g_file_monitor_directory (_tmp1_, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch30_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (self->priv->_monitor);
		self->priv->_monitor = _tmp3_;
	}
	goto __finally30;
	__catch30_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("file_browser.vala:484: Can not refresh automatically the file browser:" \
" %s", _tmp5_);
		_g_error_free0 (e);
		return;
	}
	__finally30:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = self->priv->_monitor;
	g_signal_connect_object (_tmp6_, "changed", (GCallback) _file_browser_refresh_g_file_monitor_changed, self, 0);
}


/*************************************************************************/
static void file_browser_refresh (FileBrowser* self) {
	GFile* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_directory;
	file_browser_set_directory (self, _tmp0_, TRUE);
}


static gboolean __lambda124_ (FileBrowser* self) {
	gboolean result = FALSE;
	self->priv->_timeout_id = (guint) 0;
	file_browser_refresh (self);
	result = FALSE;
	return result;
}


static gboolean ___lambda124__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda124_ (self);
	return result;
}


static void file_browser_delayed_refresh (FileBrowser* self) {
	guint _tmp0_;
	guint _tmp2_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_timeout_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->_timeout_id;
		g_source_remove (_tmp1_);
	}
	_tmp2_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ___lambda124__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->_timeout_id = _tmp2_;
}


static GFile* file_browser_get_default_directory (FileBrowser* self) {
	GFile* result = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* uri;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp5_;
	const gchar* _tmp10_ = NULL;
	GFile* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "current-directory");
	uri = _tmp1_;
	_tmp3_ = uri;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = uri;
		_tmp2_ = g_strcmp0 (_tmp4_, "") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		const gchar* _tmp6_;
		GFile* _tmp7_ = NULL;
		GFile* directory;
		GFile* _tmp8_;
		gboolean _tmp9_ = FALSE;
		_tmp6_ = uri;
		_tmp7_ = g_file_new_for_uri (_tmp6_);
		directory = _tmp7_;
		_tmp8_ = directory;
		_tmp9_ = g_file_query_exists (_tmp8_, NULL);
		if (_tmp9_) {
			result = directory;
			_g_free0 (uri);
			return result;
		}
		_g_object_unref0 (directory);
	}
	_tmp10_ = g_get_home_dir ();
	_tmp11_ = g_file_new_for_path (_tmp10_);
	result = _tmp11_;
	_g_free0 (uri);
	return result;
}


static void file_browser_set_directory (FileBrowser* self, GFile* directory, gboolean force) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GSettings* _tmp7_;
	GFile* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	GtkToolButton* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_ = NULL;
	GFile* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (directory != NULL);
	_tmp1_ = force;
	if (!_tmp1_) {
		GFile* _tmp2_;
		GFile* _tmp3_;
		_tmp2_ = self->priv->_current_directory;
		_tmp3_ = directory;
		_tmp0_ = _tmp2_ == _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		return;
	}
	_tmp5_ = directory;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->priv->_current_directory);
	self->priv->_current_directory = _tmp6_;
	_tmp7_ = self->priv->_settings;
	_tmp8_ = directory;
	_tmp9_ = g_file_get_uri (_tmp8_);
	_tmp10_ = _tmp9_;
	g_settings_set_string (_tmp7_, "current-directory", _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = self->priv->_parent_button;
	_tmp12_ = directory;
	_tmp13_ = g_file_get_parent (_tmp12_);
	_tmp14_ = _tmp13_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, _tmp14_ != NULL);
	_g_object_unref0 (_tmp14_);
	file_browser_update_parent_directories (self);
	file_browser_update_list (self);
	file_browser_monitor_directory (self);
}


static void file_browser_update_jump_button_sensitivity (FileBrowser* self, GtkToolButton* jump_button) {
	gboolean _tmp0_ = FALSE;
	MainWindow* _tmp1_;
	DocumentTab* _tmp2_;
	DocumentTab* _tmp3_;
	GtkToolButton* _tmp9_;
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (jump_button != NULL);
	_tmp1_ = self->priv->_main_window;
	_tmp2_ = main_window_get_active_tab (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		MainWindow* _tmp4_;
		Document* _tmp5_;
		Document* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		_tmp4_ = self->priv->_main_window;
		_tmp5_ = main_window_get_active_document (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = document_get_location (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = _tmp8_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp9_ = jump_button;
	_tmp10_ = _tmp0_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, _tmp10_);
}


static gint file_browser_on_sort (FileBrowser* self, GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b) {
	gint result = 0;
	gboolean a_is_dir = FALSE;
	gboolean b_is_dir = FALSE;
	GtkTreeModel* _tmp0_;
	GtkTreeIter _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeIter _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gint _tmp13_ = 0;
	gboolean _tmp14_;
	gint _tmp15_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (model != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = model;
	_tmp1_ = *a;
	gtk_tree_model_get (_tmp0_, &_tmp1_, FILE_BROWSER_FILE_COLUMN_IS_DIR, &a_is_dir, -1);
	_tmp2_ = model;
	_tmp3_ = *b;
	gtk_tree_model_get (_tmp2_, &_tmp3_, FILE_BROWSER_FILE_COLUMN_IS_DIR, &b_is_dir, -1);
	_tmp4_ = a_is_dir;
	_tmp5_ = b_is_dir;
	if (_tmp4_ == _tmp5_) {
		gchar* a_name = NULL;
		gchar* b_name = NULL;
		GtkTreeModel* _tmp6_;
		GtkTreeIter _tmp7_;
		GtkTreeModel* _tmp8_;
		GtkTreeIter _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gint _tmp12_ = 0;
		_tmp6_ = model;
		_tmp7_ = *a;
		gtk_tree_model_get (_tmp6_, &_tmp7_, FILE_BROWSER_FILE_COLUMN_NAME, &a_name, -1);
		_tmp8_ = model;
		_tmp9_ = *b;
		gtk_tree_model_get (_tmp8_, &_tmp9_, FILE_BROWSER_FILE_COLUMN_NAME, &b_name, -1);
		_tmp10_ = a_name;
		_tmp11_ = b_name;
		_tmp12_ = g_utf8_collate (_tmp10_, _tmp11_);
		result = _tmp12_;
		_g_free0 (b_name);
		_g_free0 (a_name);
		return result;
	}
	_tmp14_ = a_is_dir;
	if (_tmp14_) {
		_tmp13_ = -1;
	} else {
		_tmp13_ = +1;
	}
	_tmp15_ = _tmp13_;
	result = _tmp15_;
	return result;
}


static gchar* file_browser_get_extension_stock_id (FileBrowser* self, const gchar* file_extension) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	static GQuark _tmp2_label8 = 0;
	static GQuark _tmp2_label9 = 0;
	static GQuark _tmp2_label10 = 0;
	static GQuark _tmp2_label11 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file_extension != NULL, NULL);
	_tmp0_ = file_extension;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string (".tex")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup (GTK_STOCK_EDIT);
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string (".pdf")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("view_pdf");
				result = _tmp5_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string (".dvi")))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("view_dvi");
				result = _tmp6_;
				return result;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string (".ps")))) || (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string (".eps"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("view_ps");
				result = _tmp7_;
				return result;
			}
		}
	} else if (((((((_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string (".png")))) || (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string (".jpg"))))) || (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string (".jpeg"))))) || (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string (".gif"))))) || (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string (".bmp"))))) || (_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string (".tif"))))) || (_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string (".tiff"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp8_;
				_tmp8_ = g_strdup ("image");
				result = _tmp8_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp9_;
				_tmp9_ = g_strdup (GTK_STOCK_FILE);
				result = _tmp9_;
				return result;
			}
		}
	}
}


static void file_browser_class_init (FileBrowserClass * klass) {
	file_browser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FileBrowserPrivate));
	G_OBJECT_CLASS (klass)->finalize = file_browser_finalize;
}


static void file_browser_instance_init (FileBrowser * self) {
	self->priv = FILE_BROWSER_GET_PRIVATE (self);
	self->priv->_timeout_id = (guint) 0;
}


static void file_browser_finalize (GObject* obj) {
	FileBrowser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FILE_BROWSER, FileBrowser);
	_g_object_unref0 (self->priv->_parent_dir_store);
	_g_object_unref0 (self->priv->_combo_box);
	_g_object_unref0 (self->priv->_list_store);
	_g_object_unref0 (self->priv->_list_view);
	_g_object_unref0 (self->priv->_current_directory);
	_g_object_unref0 (self->priv->_monitor);
	_g_object_unref0 (self->priv->_parent_button);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->_latex_settings);
	G_OBJECT_CLASS (file_browser_parent_class)->finalize (obj);
}


GType file_browser_get_type (void) {
	static volatile gsize file_browser_type_id__volatile = 0;
	if (g_once_init_enter (&file_browser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FileBrowserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) file_browser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FileBrowser), 0, (GInstanceInitFunc) file_browser_instance_init, NULL };
		GType file_browser_type_id;
		file_browser_type_id = g_type_register_static (GTK_TYPE_GRID, "FileBrowser", &g_define_type_info, 0);
		g_once_init_leave (&file_browser_type_id__volatile, file_browser_type_id);
	}
	return file_browser_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



