/* main_window_build_tools.c generated by valac 0.17.3.8-fd35, the Vala compiler
 * generated from main_window_build_tools.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "config.h"
#include <gtksourceview/gtksource.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_MAIN_WINDOW_BUILD_TOOLS (main_window_build_tools_get_type ())
#define MAIN_WINDOW_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildTools))
#define MAIN_WINDOW_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildToolsClass))
#define IS_MAIN_WINDOW_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS))
#define IS_MAIN_WINDOW_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_BUILD_TOOLS))
#define MAIN_WINDOW_BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildToolsClass))

typedef struct _MainWindowBuildTools MainWindowBuildTools;
typedef struct _MainWindowBuildToolsClass MainWindowBuildToolsClass;
typedef struct _MainWindowBuildToolsPrivate MainWindowBuildToolsPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_BUILD_VIEW (build_view_get_type ())
#define BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_VIEW, BuildView))
#define BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_VIEW, BuildViewClass))
#define IS_BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_VIEW))
#define IS_BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_VIEW))
#define BUILD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_VIEW, BuildViewClass))

typedef struct _BuildView BuildView;
typedef struct _BuildViewClass BuildViewClass;

#define TYPE_FILE_BROWSER (file_browser_get_type ())
#define FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_BROWSER, FileBrowser))
#define FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_BROWSER, FileBrowserClass))
#define IS_FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_BROWSER))
#define IS_FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_BROWSER))
#define FILE_BROWSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_BROWSER, FileBrowserClass))

typedef struct _FileBrowser FileBrowser;
typedef struct _FileBrowserClass FileBrowserClass;

#define TYPE_BUILD_TOOL_RUNNER (build_tool_runner_get_type ())
#define BUILD_TOOL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOL_RUNNER, BuildToolRunner))
#define BUILD_TOOL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOL_RUNNER, BuildToolRunnerClass))
#define IS_BUILD_TOOL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOL_RUNNER))
#define IS_BUILD_TOOL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOL_RUNNER))
#define BUILD_TOOL_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOL_RUNNER, BuildToolRunnerClass))

typedef struct _BuildToolRunner BuildToolRunner;
typedef struct _BuildToolRunnerClass BuildToolRunnerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_BUILD_TOOLS (build_tools_get_type ())
#define BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS, BuildTools))
#define BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS, BuildToolsClass))
#define IS_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS))
#define IS_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS))
#define BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS, BuildToolsClass))

typedef struct _BuildTools BuildTools;
typedef struct _BuildToolsClass BuildToolsClass;

#define TYPE_PERSONAL_BUILD_TOOLS (personal_build_tools_get_type ())
#define PERSONAL_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PERSONAL_BUILD_TOOLS, PersonalBuildTools))
#define PERSONAL_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PERSONAL_BUILD_TOOLS, PersonalBuildToolsClass))
#define IS_PERSONAL_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PERSONAL_BUILD_TOOLS))
#define IS_PERSONAL_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PERSONAL_BUILD_TOOLS))
#define PERSONAL_BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PERSONAL_BUILD_TOOLS, PersonalBuildToolsClass))

typedef struct _PersonalBuildTools PersonalBuildTools;
typedef struct _PersonalBuildToolsClass PersonalBuildToolsClass;

#define TYPE_DEFAULT_BUILD_TOOLS (default_build_tools_get_type ())
#define DEFAULT_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEFAULT_BUILD_TOOLS, DefaultBuildTools))
#define DEFAULT_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEFAULT_BUILD_TOOLS, DefaultBuildToolsClass))
#define IS_DEFAULT_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEFAULT_BUILD_TOOLS))
#define IS_DEFAULT_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEFAULT_BUILD_TOOLS))
#define DEFAULT_BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEFAULT_BUILD_TOOLS, DefaultBuildToolsClass))

typedef struct _DefaultBuildTools DefaultBuildTools;
typedef struct _DefaultBuildToolsClass DefaultBuildToolsClass;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_BUILD_TOOL (build_tool_get_type ())

#define TYPE_BUILD_JOB (build_job_get_type ())

#define TYPE_POST_PROCESSOR_TYPE (post_processor_type_get_type ())
typedef struct _BuildJob BuildJob;
typedef struct _BuildTool BuildTool;
#define _build_tool_free0(var) ((var == NULL) ? NULL : (var = (build_tool_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block18Data Block18Data;
#define _main_window_build_tools_unref0(var) ((var == NULL) ? NULL : (var = (main_window_build_tools_unref (var), NULL)))

#define TYPE_LATEXILA (latexila_get_type ())
#define LATEXILA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEXILA, Latexila))
#define LATEXILA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEXILA, LatexilaClass))
#define IS_LATEXILA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEXILA))
#define IS_LATEXILA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEXILA))
#define LATEXILA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEXILA, LatexilaClass))

typedef struct _Latexila Latexila;
typedef struct _LatexilaClass LatexilaClass;

#define TYPE_CLEAN_BUILD_FILES (clean_build_files_get_type ())
#define CLEAN_BUILD_FILES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLEAN_BUILD_FILES, CleanBuildFiles))
#define CLEAN_BUILD_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLEAN_BUILD_FILES, CleanBuildFilesClass))
#define IS_CLEAN_BUILD_FILES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLEAN_BUILD_FILES))
#define IS_CLEAN_BUILD_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLEAN_BUILD_FILES))
#define CLEAN_BUILD_FILES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLEAN_BUILD_FILES, CleanBuildFilesClass))

typedef struct _CleanBuildFiles CleanBuildFiles;
typedef struct _CleanBuildFilesClass CleanBuildFilesClass;

#define TYPE_BUILD_TOOLS_PREFERENCES (build_tools_preferences_get_type ())
#define BUILD_TOOLS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferences))
#define BUILD_TOOLS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesClass))
#define IS_BUILD_TOOLS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS_PREFERENCES))
#define IS_BUILD_TOOLS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS_PREFERENCES))
#define BUILD_TOOLS_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesClass))

typedef struct _BuildToolsPreferences BuildToolsPreferences;
typedef struct _BuildToolsPreferencesClass BuildToolsPreferencesClass;
typedef struct _ParamSpecMainWindowBuildTools ParamSpecMainWindowBuildTools;

struct _MainWindowBuildTools {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MainWindowBuildToolsPrivate * priv;
};

struct _MainWindowBuildToolsClass {
	GTypeClass parent_class;
	void (*finalize) (MainWindowBuildTools *self);
};

struct _MainWindowBuildToolsPrivate {
	MainWindow* _main_window;
	GtkUIManager* _ui_manager;
	BuildView* _build_view;
	FileBrowser* _file_browser;
	GtkActionGroup* _static_action_group;
	GtkActionGroup* _dynamic_action_group;
	guint _menu_ui_id;
	BuildToolRunner* _build_tool_runner;
};

typedef enum  {
	POST_PROCESSOR_TYPE_ALL_OUTPUT = 0,
	POST_PROCESSOR_TYPE_LATEX,
	POST_PROCESSOR_TYPE_LATEXMK,
	POST_PROCESSOR_TYPE_NO_OUTPUT,
	POST_PROCESSOR_TYPE_RUBBER,
	POST_PROCESSOR_TYPE_N_POST_PROCESSORS
} PostProcessorType;

struct _BuildJob {
	PostProcessorType post_processor;
	gchar* command;
};

struct _BuildTool {
	gchar* _description;
	gchar* extensions;
	gchar* label;
	gchar* icon;
	gchar* files_to_open;
	gboolean enabled;
	GeeArrayList* jobs;
	gint id;
};

struct _Block18Data {
	int _ref_count_;
	MainWindowBuildTools * self;
	BuildTool* tool;
	Document* active_doc;
	GtkAction* stop_exec;
};

struct _ParamSpecMainWindowBuildTools {
	GParamSpec parent_instance;
};


static gpointer main_window_build_tools_parent_class = NULL;

gpointer main_window_build_tools_ref (gpointer instance);
void main_window_build_tools_unref (gpointer instance);
GParamSpec* param_spec_main_window_build_tools (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_main_window_build_tools (GValue* value, gpointer v_object);
void value_take_main_window_build_tools (GValue* value, gpointer v_object);
gpointer value_get_main_window_build_tools (const GValue* value);
GType main_window_build_tools_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType build_view_get_type (void) G_GNUC_CONST;
GType file_browser_get_type (void) G_GNUC_CONST;
GType build_tool_runner_get_type (void) G_GNUC_CONST;
#define MAIN_WINDOW_BUILD_TOOLS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildToolsPrivate))
enum  {
	MAIN_WINDOW_BUILD_TOOLS_DUMMY_PROPERTY
};
void main_window_build_tools_on_clean (MainWindowBuildTools* self);
static void _main_window_build_tools_on_clean_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_build_tools_on_stop_execution (MainWindowBuildTools* self);
static void _main_window_build_tools_on_stop_execution_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_build_tools_on_view_log (MainWindowBuildTools* self);
static void _main_window_build_tools_on_view_log_gtk_action_callback (GtkAction* action, gpointer self);
void main_window_build_tools_on_preferences (MainWindowBuildTools* self);
static void _main_window_build_tools_on_preferences_gtk_action_callback (GtkAction* action, gpointer self);
MainWindowBuildTools* main_window_build_tools_new (MainWindow* main_window, GtkUIManager* ui_manager, BuildView* build_view, FileBrowser* file_browser);
MainWindowBuildTools* main_window_build_tools_construct (GType object_type, MainWindow* main_window, GtkUIManager* ui_manager, BuildView* build_view, FileBrowser* file_browser);
static void main_window_build_tools_connect_toggle_actions (MainWindowBuildTools* self);
static void main_window_build_tools_update_menu (MainWindowBuildTools* self);
GType build_tools_get_type (void) G_GNUC_CONST;
GType personal_build_tools_get_type (void) G_GNUC_CONST;
PersonalBuildTools* personal_build_tools_get_default (void);
static void __lambda63_ (MainWindowBuildTools* self);
static void ___lambda63__build_tools_modified (BuildTools* _sender, gpointer self);
GType default_build_tools_get_type (void) G_GNUC_CONST;
DefaultBuildTools* default_build_tools_get_default (void);
static void __lambda64_ (MainWindowBuildTools* self);
static void ___lambda64__build_tools_modified (BuildTools* _sender, gpointer self);
void main_window_build_tools_update_sensitivity (MainWindowBuildTools* self);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_get_active_tab (MainWindow* self);
GType document_get_type (void) G_GNUC_CONST;
Document* main_window_get_active_document (MainWindow* self);
gboolean document_is_main_file_a_tex_file (Document* self);
GType build_tool_get_type (void) G_GNUC_CONST;
GType build_job_get_type (void) G_GNUC_CONST;
GType post_processor_type_get_type (void) G_GNUC_CONST;
BuildJob* build_job_dup (const BuildJob* self);
void build_job_free (BuildJob* self);
void build_job_copy (const BuildJob* self, BuildJob* dest);
void build_job_destroy (BuildJob* self);
BuildTool* build_tool_dup (const BuildTool* self);
void build_tool_free (BuildTool* self);
void build_tool_copy (const BuildTool* self, BuildTool* dest);
void build_tool_destroy (BuildTool* self);
GeeIterator* build_tools_iterator (BuildTools* self);
static gchar* main_window_build_tools_get_default_build_tool_name (MainWindowBuildTools* self, gint tool_num);
static void main_window_build_tools_update_build_tool_sensitivity (MainWindowBuildTools* self, BuildTool* tool, const gchar* action_name);
static gchar* main_window_build_tools_get_personal_build_tool_name (MainWindowBuildTools* self, gint tool_num);
static BuildTool* main_window_build_tools_get_build_tool_from_name (MainWindowBuildTools* self, const gchar* action_name);
BuildTool* build_tools_get_build_tool (BuildTools* self, gint tool_num);
GFile* document_get_location (Document* self);
gboolean build_tool_has_jobs (BuildTool *self);
GFile* document_get_main_file (Document* self);
gchar* utils_get_extension (const gchar* path);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
void main_window_build_tools_save_state (MainWindowBuildTools* self);
static void main_window_build_tools_activate_dynamic_action (MainWindowBuildTools* self, GtkAction* action);
static void _main_window_build_tools_activate_dynamic_action_gtk_action_activate (GtkAction* _sender, gpointer self);
gboolean build_tools_is_empty (BuildTools* self);
static void main_window_build_tools_add_dynamic_action (MainWindowBuildTools* self, BuildTool* build_tool, const gchar* action_name, gint* accel_num);
static void main_window_build_tools_add_separator (MainWindowBuildTools* self);
gchar* build_tool_get_description (BuildTool *self);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
gboolean document_set_tmp_location (Document* self);
gint document_get_project_id (Document* self);
void document_save (Document* self, gboolean check_file_changed_on_disk, gboolean force);
GType latexila_get_type (void) G_GNUC_CONST;
Latexila* latexila_get_instance (void);
GeeList* latexila_get_documents (Latexila* self);
void utils_flush_queue (void);
BuildToolRunner* build_tool_runner_new (BuildTool* build_tool, GFile* on_file, BuildView* build_view);
BuildToolRunner* build_tool_runner_construct (GType object_type, BuildTool* build_tool, GFile* on_file, BuildView* build_view);
static void __lambda62_ (Block18Data* _data18_);
void file_browser_refresh_for_document (FileBrowser* self, Document* doc);
static void ___lambda62__build_tool_runner_finished (BuildToolRunner* _sender, gpointer self);
void build_tool_runner_run (BuildToolRunner* self);
void build_tool_runner_abort (BuildToolRunner* self);
CleanBuildFiles* clean_build_files_new (MainWindow* main_window, Document* doc);
CleanBuildFiles* clean_build_files_construct (GType object_type, MainWindow* main_window, Document* doc);
GType clean_build_files_get_type (void) G_GNUC_CONST;
gboolean clean_build_files_clean (CleanBuildFiles* self);
gchar* utils_get_shortname (const gchar* path);
DocumentTab* main_window_open_document (MainWindow* self, GFile* location, gboolean jump_to);
Document* document_tab_get_document (DocumentTab* self);
void document_set_readonly (Document* self, gboolean value);
BuildToolsPreferences* build_tools_preferences_new (MainWindow* main_window);
BuildToolsPreferences* build_tools_preferences_construct (GType object_type, MainWindow* main_window);
GType build_tools_preferences_get_type (void) G_GNUC_CONST;
static void main_window_build_tools_finalize (MainWindowBuildTools* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GtkActionEntry MAIN_WINDOW_BUILD_TOOLS__action_entries[5] = {{"Build", NULL, "_Build"}, {"BuildClean", GTK_STOCK_CLEAR, "Cleanup Build _Files", NULL, "Clean-up build files (*.aux, *.log, *.out, *.toc, etc)", (GCallback) _main_window_build_tools_on_clean_gtk_action_callback}, {"BuildStopExecution", GTK_STOCK_STOP, "_Stop Execution", NULL, "Stop Execution", (GCallback) _main_window_build_tools_on_stop_execution_gtk_action_callback}, {"BuildViewLog", "view_log", "View _Log", NULL, "View Log", (GCallback) _main_window_build_tools_on_view_log_gtk_action_callback}, {"BuildToolsPreferences", GTK_STOCK_PREFERENCES, "_Manage Build Tools", NULL, "Manage Build Tools", (GCallback) _main_window_build_tools_on_preferences_gtk_action_callback}};
static const GtkToggleActionEntry MAIN_WINDOW_BUILD_TOOLS__toggle_action_entries[3] = {{"BuildShowDetails", GTK_STOCK_ZOOM_IN, "Show _Details", NULL, "Show Details", (GCallback) NULL}, {"BuildShowWarnings", GTK_STOCK_DIALOG_WARNING, "Show _Warnings", NULL, "Show Warnings", (GCallback) NULL}, {"BuildShowBadBoxes", "badbox", "Show _Bad Boxes", NULL, "Show Bad Boxes", (GCallback) NULL}};

static void _main_window_build_tools_on_clean_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_build_tools_on_clean (self);
}


static void _main_window_build_tools_on_stop_execution_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_build_tools_on_stop_execution (self);
}


static void _main_window_build_tools_on_view_log_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_build_tools_on_view_log (self);
}


static void _main_window_build_tools_on_preferences_gtk_action_callback (GtkAction* action, gpointer self) {
	main_window_build_tools_on_preferences (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda63_ (MainWindowBuildTools* self) {
	main_window_build_tools_update_menu (self);
}


static void ___lambda63__build_tools_modified (BuildTools* _sender, gpointer self) {
	__lambda63_ (self);
}


static void __lambda64_ (MainWindowBuildTools* self) {
	main_window_build_tools_update_menu (self);
}


static void ___lambda64__build_tools_modified (BuildTools* _sender, gpointer self) {
	__lambda64_ (self);
}


MainWindowBuildTools* main_window_build_tools_construct (GType object_type, MainWindow* main_window, GtkUIManager* ui_manager, BuildView* build_view, FileBrowser* file_browser) {
	MainWindowBuildTools* self = NULL;
	MainWindow* _tmp0_;
	GtkUIManager* _tmp1_;
	GtkUIManager* _tmp2_;
	BuildView* _tmp3_;
	BuildView* _tmp4_;
	FileBrowser* _tmp5_;
	FileBrowser* _tmp6_;
	GtkActionGroup* _tmp7_;
	GtkActionGroup* _tmp8_;
	GtkActionGroup* _tmp9_;
	GtkActionGroup* _tmp10_;
	GtkActionGroup* _tmp11_;
	GtkAction* _tmp12_ = NULL;
	GtkAction* _tmp13_;
	GtkAction* stop_exec;
	GtkUIManager* _tmp14_;
	GtkActionGroup* _tmp15_;
	GtkActionGroup* _tmp16_;
	GtkUIManager* _tmp17_;
	GtkActionGroup* _tmp18_;
	PersonalBuildTools* _tmp19_ = NULL;
	PersonalBuildTools* personal_build_tools;
	DefaultBuildTools* _tmp20_ = NULL;
	DefaultBuildTools* default_build_tools;
	g_return_val_if_fail (main_window != NULL, NULL);
	g_return_val_if_fail (ui_manager != NULL, NULL);
	g_return_val_if_fail (build_view != NULL, NULL);
	g_return_val_if_fail (file_browser != NULL, NULL);
	self = (MainWindowBuildTools*) g_type_create_instance (object_type);
	_tmp0_ = main_window;
	self->priv->_main_window = _tmp0_;
	_tmp1_ = ui_manager;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->_ui_manager);
	self->priv->_ui_manager = _tmp2_;
	_tmp3_ = build_view;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->_build_view);
	self->priv->_build_view = _tmp4_;
	_tmp5_ = file_browser;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->priv->_file_browser);
	self->priv->_file_browser = _tmp6_;
	_tmp7_ = gtk_action_group_new ("BuildMenuActionGroup");
	_g_object_unref0 (self->priv->_static_action_group);
	self->priv->_static_action_group = _tmp7_;
	_tmp8_ = self->priv->_static_action_group;
	gtk_action_group_set_translation_domain (_tmp8_, GETTEXT_PACKAGE);
	_tmp9_ = self->priv->_static_action_group;
	gtk_action_group_add_actions (_tmp9_, MAIN_WINDOW_BUILD_TOOLS__action_entries, G_N_ELEMENTS (MAIN_WINDOW_BUILD_TOOLS__action_entries), self);
	_tmp10_ = self->priv->_static_action_group;
	gtk_action_group_add_toggle_actions (_tmp10_, MAIN_WINDOW_BUILD_TOOLS__toggle_action_entries, G_N_ELEMENTS (MAIN_WINDOW_BUILD_TOOLS__toggle_action_entries), self);
	_tmp11_ = self->priv->_static_action_group;
	_tmp12_ = gtk_action_group_get_action (_tmp11_, "BuildStopExecution");
	_tmp13_ = _g_object_ref0 (_tmp12_);
	stop_exec = _tmp13_;
	gtk_action_set_sensitive (stop_exec, FALSE);
	main_window_build_tools_connect_toggle_actions (self);
	_tmp14_ = ui_manager;
	_tmp15_ = self->priv->_static_action_group;
	gtk_ui_manager_insert_action_group (_tmp14_, _tmp15_, 0);
	_tmp16_ = gtk_action_group_new ("BuildToolsActions");
	_g_object_unref0 (self->priv->_dynamic_action_group);
	self->priv->_dynamic_action_group = _tmp16_;
	_tmp17_ = ui_manager;
	_tmp18_ = self->priv->_dynamic_action_group;
	gtk_ui_manager_insert_action_group (_tmp17_, _tmp18_, 0);
	main_window_build_tools_update_menu (self);
	_tmp19_ = personal_build_tools_get_default ();
	personal_build_tools = _tmp19_;
	g_signal_connect ((BuildTools*) personal_build_tools, "modified", (GCallback) ___lambda63__build_tools_modified, self);
	_tmp20_ = default_build_tools_get_default ();
	default_build_tools = _tmp20_;
	g_signal_connect ((BuildTools*) default_build_tools, "modified", (GCallback) ___lambda64__build_tools_modified, self);
	_g_object_unref0 (default_build_tools);
	_g_object_unref0 (personal_build_tools);
	_g_object_unref0 (stop_exec);
	return self;
}


MainWindowBuildTools* main_window_build_tools_new (MainWindow* main_window, GtkUIManager* ui_manager, BuildView* build_view, FileBrowser* file_browser) {
	return main_window_build_tools_construct (TYPE_MAIN_WINDOW_BUILD_TOOLS, main_window, ui_manager, build_view, file_browser);
}


void main_window_build_tools_update_sensitivity (MainWindowBuildTools* self) {
	GtkActionGroup* _tmp0_;
	GtkAction* _tmp1_ = NULL;
	GtkAction* _tmp2_;
	GtkAction* clean_action;
	GtkActionGroup* _tmp3_;
	GtkAction* _tmp4_ = NULL;
	GtkAction* _tmp5_;
	GtkAction* view_log_action;
	MainWindow* _tmp6_;
	DocumentTab* _tmp7_;
	DocumentTab* _tmp8_;
	GtkActionGroup* _tmp12_;
	MainWindow* _tmp13_;
	Document* _tmp14_;
	Document* _tmp15_;
	gboolean _tmp16_ = FALSE;
	gboolean is_tex;
	GtkAction* _tmp17_;
	gboolean _tmp18_;
	GtkAction* _tmp19_;
	gboolean _tmp20_;
	gint tool_num;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_static_action_group;
	_tmp1_ = gtk_action_group_get_action (_tmp0_, "BuildClean");
	_tmp2_ = _g_object_ref0 (_tmp1_);
	clean_action = _tmp2_;
	_tmp3_ = self->priv->_static_action_group;
	_tmp4_ = gtk_action_group_get_action (_tmp3_, "BuildViewLog");
	_tmp5_ = _g_object_ref0 (_tmp4_);
	view_log_action = _tmp5_;
	_tmp6_ = self->priv->_main_window;
	_tmp7_ = main_window_get_active_tab (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == NULL) {
		GtkActionGroup* _tmp9_;
		GtkAction* _tmp10_;
		GtkAction* _tmp11_;
		_tmp9_ = self->priv->_dynamic_action_group;
		gtk_action_group_set_sensitive (_tmp9_, FALSE);
		_tmp10_ = clean_action;
		gtk_action_set_sensitive (_tmp10_, FALSE);
		_tmp11_ = view_log_action;
		gtk_action_set_sensitive (_tmp11_, FALSE);
		_g_object_unref0 (view_log_action);
		_g_object_unref0 (clean_action);
		return;
	}
	_tmp12_ = self->priv->_dynamic_action_group;
	gtk_action_group_set_sensitive (_tmp12_, TRUE);
	_tmp13_ = self->priv->_main_window;
	_tmp14_ = main_window_get_active_document (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = document_is_main_file_a_tex_file (_tmp15_);
	is_tex = _tmp16_;
	_tmp17_ = clean_action;
	_tmp18_ = is_tex;
	gtk_action_set_sensitive (_tmp17_, _tmp18_);
	_tmp19_ = view_log_action;
	_tmp20_ = is_tex;
	gtk_action_set_sensitive (_tmp19_, _tmp20_);
	tool_num = 0;
	{
		DefaultBuildTools* _tmp21_ = NULL;
		DefaultBuildTools* _tmp22_;
		GeeIterator* _tmp23_ = NULL;
		GeeIterator* _tmp24_;
		GeeIterator* _tool_it;
		_tmp21_ = default_build_tools_get_default ();
		_tmp22_ = _tmp21_;
		_tmp23_ = build_tools_iterator ((BuildTools*) _tmp22_);
		_tmp24_ = _tmp23_;
		_g_object_unref0 (_tmp22_);
		_tool_it = _tmp24_;
		while (TRUE) {
			GeeIterator* _tmp25_;
			gboolean _tmp26_ = FALSE;
			GeeIterator* _tmp27_;
			gpointer _tmp28_ = NULL;
			BuildTool* _tmp29_;
			BuildTool _tmp30_ = {0};
			BuildTool _tmp31_;
			BuildTool tool;
			gint _tmp32_;
			gchar* _tmp33_ = NULL;
			gchar* action_name;
			BuildTool _tmp34_;
			const gchar* _tmp35_;
			gint _tmp36_;
			_tmp25_ = _tool_it;
			_tmp26_ = gee_iterator_next (_tmp25_);
			if (!_tmp26_) {
				break;
			}
			_tmp27_ = _tool_it;
			_tmp28_ = gee_iterator_get (_tmp27_);
			_tmp29_ = (BuildTool*) _tmp28_;
			build_tool_copy (_tmp29_, &_tmp30_);
			_tmp31_ = _tmp30_;
			_build_tool_free0 (_tmp29_);
			tool = _tmp31_;
			_tmp32_ = tool_num;
			_tmp33_ = main_window_build_tools_get_default_build_tool_name (self, _tmp32_);
			action_name = _tmp33_;
			_tmp34_ = tool;
			_tmp35_ = action_name;
			main_window_build_tools_update_build_tool_sensitivity (self, &_tmp34_, _tmp35_);
			_tmp36_ = tool_num;
			tool_num = _tmp36_ + 1;
			_g_free0 (action_name);
			build_tool_destroy (&tool);
		}
		_g_object_unref0 (_tool_it);
	}
	tool_num = 0;
	{
		PersonalBuildTools* _tmp37_ = NULL;
		PersonalBuildTools* _tmp38_;
		GeeIterator* _tmp39_ = NULL;
		GeeIterator* _tmp40_;
		GeeIterator* _tool_it;
		_tmp37_ = personal_build_tools_get_default ();
		_tmp38_ = _tmp37_;
		_tmp39_ = build_tools_iterator ((BuildTools*) _tmp38_);
		_tmp40_ = _tmp39_;
		_g_object_unref0 (_tmp38_);
		_tool_it = _tmp40_;
		while (TRUE) {
			GeeIterator* _tmp41_;
			gboolean _tmp42_ = FALSE;
			GeeIterator* _tmp43_;
			gpointer _tmp44_ = NULL;
			BuildTool* _tmp45_;
			BuildTool _tmp46_ = {0};
			BuildTool _tmp47_;
			BuildTool tool;
			gint _tmp48_;
			gchar* _tmp49_ = NULL;
			gchar* action_name;
			BuildTool _tmp50_;
			const gchar* _tmp51_;
			gint _tmp52_;
			_tmp41_ = _tool_it;
			_tmp42_ = gee_iterator_next (_tmp41_);
			if (!_tmp42_) {
				break;
			}
			_tmp43_ = _tool_it;
			_tmp44_ = gee_iterator_get (_tmp43_);
			_tmp45_ = (BuildTool*) _tmp44_;
			build_tool_copy (_tmp45_, &_tmp46_);
			_tmp47_ = _tmp46_;
			_build_tool_free0 (_tmp45_);
			tool = _tmp47_;
			_tmp48_ = tool_num;
			_tmp49_ = main_window_build_tools_get_personal_build_tool_name (self, _tmp48_);
			action_name = _tmp49_;
			_tmp50_ = tool;
			_tmp51_ = action_name;
			main_window_build_tools_update_build_tool_sensitivity (self, &_tmp50_, _tmp51_);
			_tmp52_ = tool_num;
			tool_num = _tmp52_ + 1;
			_g_free0 (action_name);
			build_tool_destroy (&tool);
		}
		_g_object_unref0 (_tool_it);
	}
	_g_object_unref0 (view_log_action);
	_g_object_unref0 (clean_action);
}


static gchar* main_window_build_tools_get_default_build_tool_name (MainWindowBuildTools* self, gint tool_num) {
	gchar* result = NULL;
	gint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = tool_num;
	_tmp1_ = g_strdup_printf ("%i", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("DefaultBuildTool_", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}


static gchar* main_window_build_tools_get_personal_build_tool_name (MainWindowBuildTools* self, gint tool_num) {
	gchar* result = NULL;
	gint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = tool_num;
	_tmp1_ = g_strdup_printf ("%i", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("PersonalBuildTool_", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}


static BuildTool* main_window_build_tools_get_build_tool_from_name (MainWindowBuildTools* self, const gchar* action_name) {
	BuildTool* result = NULL;
	BuildTools* build_tools = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_ = NULL;
	gchar** name;
	gint name_length1;
	gint _name_size_;
	const gchar* _tmp9_;
	gint _tmp10_ = 0;
	gint tool_num;
	BuildTools* _tmp11_;
	BuildTool* _tmp12_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (action_name != NULL, NULL);
	_tmp0_ = action_name;
	_tmp1_ = g_str_has_prefix (_tmp0_, "DefaultBuildTool_");
	if (_tmp1_) {
		DefaultBuildTools* _tmp2_ = NULL;
		_tmp2_ = default_build_tools_get_default ();
		_g_object_unref0 (build_tools);
		build_tools = (BuildTools*) _tmp2_;
	} else {
		const gchar* _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = action_name;
		_tmp4_ = g_str_has_prefix (_tmp3_, "PersonalBuildTool_");
		if (_tmp4_) {
			PersonalBuildTools* _tmp5_ = NULL;
			_tmp5_ = personal_build_tools_get_default ();
			_g_object_unref0 (build_tools);
			build_tools = (BuildTools*) _tmp5_;
		} else {
			g_return_val_if_reached (NULL);
		}
	}
	_tmp6_ = action_name;
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "_", 0);
	name = _tmp8_;
	name_length1 = _vala_array_length (_tmp7_);
	_name_size_ = name_length1;
	g_return_val_if_fail (name_length1 == 2, NULL);
	_tmp9_ = name[1];
	_tmp10_ = atoi (_tmp9_);
	tool_num = _tmp10_;
	_tmp11_ = build_tools;
	_tmp12_ = build_tools_get_build_tool (_tmp11_, tool_num);
	result = _tmp12_;
	name = (_vala_array_free (name, name_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (build_tools);
	return result;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void main_window_build_tools_update_build_tool_sensitivity (MainWindowBuildTools* self, BuildTool* tool, const gchar* action_name) {
	BuildTool _tmp0_;
	gboolean _tmp1_;
	GtkActionGroup* _tmp2_;
	const gchar* _tmp3_;
	GtkAction* _tmp4_ = NULL;
	GtkAction* _tmp5_;
	GtkAction* action;
	MainWindow* _tmp6_;
	Document* _tmp7_;
	Document* _tmp8_;
	Document* _tmp9_;
	Document* active_doc;
	Document* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	gboolean unsaved_doc;
	gboolean _tmp13_;
	Document* _tmp16_;
	GFile* _tmp17_ = NULL;
	GFile* _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	gchar* path;
	const gchar* _tmp21_;
	gchar* _tmp22_ = NULL;
	gchar* ext;
	BuildTool _tmp23_;
	const gchar* _tmp24_;
	gchar** _tmp25_;
	gchar** _tmp26_ = NULL;
	gchar** extensions;
	gint extensions_length1;
	gint _extensions_size_;
	gboolean _tmp27_ = FALSE;
	BuildTool _tmp28_;
	const gchar* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	gboolean _tmp34_;
	gboolean sensitive;
	GtkAction* _tmp35_;
	gboolean _tmp36_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tool != NULL);
	g_return_if_fail (action_name != NULL);
	_tmp0_ = *tool;
	_tmp1_ = _tmp0_.enabled;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->_dynamic_action_group;
	_tmp3_ = action_name;
	_tmp4_ = gtk_action_group_get_action (_tmp2_, _tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	action = _tmp5_;
	_tmp6_ = self->priv->_main_window;
	_tmp7_ = main_window_get_active_document (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	active_doc = _tmp9_;
	_tmp10_ = active_doc;
	_tmp11_ = document_get_location (_tmp10_);
	_tmp12_ = _tmp11_;
	unsaved_doc = _tmp12_ == NULL;
	_tmp13_ = unsaved_doc;
	if (_tmp13_) {
		GtkAction* _tmp14_;
		gboolean _tmp15_ = FALSE;
		_tmp14_ = action;
		_tmp15_ = build_tool_has_jobs (tool);
		gtk_action_set_sensitive (_tmp14_, _tmp15_);
		_g_object_unref0 (active_doc);
		_g_object_unref0 (action);
		return;
	}
	_tmp16_ = active_doc;
	_tmp17_ = document_get_main_file (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_file_get_parse_name (_tmp18_);
	_tmp20_ = _tmp19_;
	_g_object_unref0 (_tmp18_);
	path = _tmp20_;
	_tmp21_ = path;
	_tmp22_ = utils_get_extension (_tmp21_);
	ext = _tmp22_;
	_tmp23_ = *tool;
	_tmp24_ = _tmp23_.extensions;
	_tmp26_ = _tmp25_ = g_strsplit (_tmp24_, " ", 0);
	extensions = _tmp26_;
	extensions_length1 = _vala_array_length (_tmp25_);
	_extensions_size_ = extensions_length1;
	_tmp28_ = *tool;
	_tmp29_ = _tmp28_.extensions;
	_tmp30_ = strlen (_tmp29_);
	_tmp31_ = _tmp30_;
	if (_tmp31_ == 0) {
		_tmp27_ = TRUE;
	} else {
		const gchar* _tmp32_;
		gchar** _tmp33_;
		gint _tmp33__length1;
		_tmp32_ = ext;
		_tmp33_ = extensions;
		_tmp33__length1 = extensions_length1;
		_tmp27_ = _vala_string_array_contains (_tmp33_, _tmp33__length1, _tmp32_);
	}
	_tmp34_ = _tmp27_;
	sensitive = _tmp34_;
	_tmp35_ = action;
	_tmp36_ = sensitive;
	gtk_action_set_sensitive (_tmp35_, _tmp36_);
	extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (ext);
	_g_free0 (path);
	_g_object_unref0 (active_doc);
	_g_object_unref0 (action);
}


void main_window_build_tools_save_state (MainWindowBuildTools* self) {
	GSettings* _tmp0_;
	GSettings* settings;
	GtkActionGroup* _tmp1_;
	GtkAction* _tmp2_ = NULL;
	GtkToggleAction* _tmp3_;
	GtkToggleAction* action;
	GtkToggleAction* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GtkActionGroup* _tmp7_;
	GtkAction* _tmp8_ = NULL;
	GtkToggleAction* _tmp9_;
	GtkToggleAction* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.ui");
	settings = _tmp0_;
	_tmp1_ = self->priv->_static_action_group;
	_tmp2_ = gtk_action_group_get_action (_tmp1_, "BuildShowWarnings");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GTK_TYPE_TOGGLE_ACTION) ? ((GtkToggleAction*) _tmp2_) : NULL);
	action = _tmp3_;
	_tmp4_ = action;
	_tmp5_ = gtk_toggle_action_get_active (_tmp4_);
	_tmp6_ = _tmp5_;
	g_settings_set_boolean (settings, "show-build-warnings", _tmp6_);
	_tmp7_ = self->priv->_static_action_group;
	_tmp8_ = gtk_action_group_get_action (_tmp7_, "BuildShowBadBoxes");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, GTK_TYPE_TOGGLE_ACTION) ? ((GtkToggleAction*) _tmp8_) : NULL);
	_g_object_unref0 (action);
	action = _tmp9_;
	_tmp10_ = action;
	_tmp11_ = gtk_toggle_action_get_active (_tmp10_);
	_tmp12_ = _tmp11_;
	g_settings_set_boolean (settings, "show-build-badboxes", _tmp12_);
	_g_object_unref0 (action);
	_g_object_unref0 (settings);
}


static void _main_window_build_tools_activate_dynamic_action_gtk_action_activate (GtkAction* _sender, gpointer self) {
	main_window_build_tools_activate_dynamic_action (self, _sender);
}


static void main_window_build_tools_update_menu (MainWindowBuildTools* self) {
	GtkActionGroup* _tmp0_;
	guint _tmp1_;
	GtkActionGroup* _tmp4_;
	GList* _tmp5_ = NULL;
	DefaultBuildTools* _tmp11_ = NULL;
	DefaultBuildTools* default_build_tools;
	PersonalBuildTools* _tmp12_ = NULL;
	PersonalBuildTools* personal_build_tools;
	gboolean _tmp13_ = FALSE;
	DefaultBuildTools* _tmp14_;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp18_;
	GtkUIManager* _tmp19_;
	guint _tmp20_ = 0U;
	gint tool_num;
	gint accel_num;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_dynamic_action_group;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->_menu_ui_id;
	if (_tmp1_ != ((guint) 0)) {
		GtkUIManager* _tmp2_;
		guint _tmp3_;
		_tmp2_ = self->priv->_ui_manager;
		_tmp3_ = self->priv->_menu_ui_id;
		gtk_ui_manager_remove_ui (_tmp2_, _tmp3_);
	}
	_tmp4_ = self->priv->_dynamic_action_group;
	_tmp5_ = gtk_action_group_list_actions (_tmp4_);
	{
		GList* action_collection = NULL;
		GList* action_it = NULL;
		action_collection = _tmp5_;
		for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
			GtkAction* _tmp6_;
			GtkAction* action = NULL;
			_tmp6_ = _g_object_ref0 ((GtkAction*) action_it->data);
			action = _tmp6_;
			{
				GtkAction* _tmp7_;
				guint _tmp8_ = 0U;
				GtkActionGroup* _tmp9_;
				GtkAction* _tmp10_;
				_tmp7_ = action;
				g_signal_parse_name ("activate", GTK_TYPE_ACTION, &_tmp8_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _main_window_build_tools_activate_dynamic_action_gtk_action_activate, self);
				_tmp9_ = self->priv->_dynamic_action_group;
				_tmp10_ = action;
				gtk_action_group_remove_action (_tmp9_, _tmp10_);
				_g_object_unref0 (action);
			}
		}
		_g_list_free0 (action_collection);
	}
	_tmp11_ = default_build_tools_get_default ();
	default_build_tools = _tmp11_;
	_tmp12_ = personal_build_tools_get_default ();
	personal_build_tools = _tmp12_;
	_tmp14_ = default_build_tools;
	_tmp15_ = build_tools_is_empty ((BuildTools*) _tmp14_);
	if (_tmp15_) {
		PersonalBuildTools* _tmp16_;
		gboolean _tmp17_ = FALSE;
		_tmp16_ = personal_build_tools;
		_tmp17_ = build_tools_is_empty ((BuildTools*) _tmp16_);
		_tmp13_ = _tmp17_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp18_ = _tmp13_;
	if (_tmp18_) {
		self->priv->_menu_ui_id = (guint) 0;
		_g_object_unref0 (personal_build_tools);
		_g_object_unref0 (default_build_tools);
		return;
	}
	_tmp19_ = self->priv->_ui_manager;
	_tmp20_ = gtk_ui_manager_new_merge_id (_tmp19_);
	self->priv->_menu_ui_id = _tmp20_;
	tool_num = 0;
	accel_num = 2;
	{
		DefaultBuildTools* _tmp21_;
		GeeIterator* _tmp22_ = NULL;
		GeeIterator* _build_tool_it;
		_tmp21_ = default_build_tools;
		_tmp22_ = build_tools_iterator ((BuildTools*) _tmp21_);
		_build_tool_it = _tmp22_;
		while (TRUE) {
			GeeIterator* _tmp23_;
			gboolean _tmp24_ = FALSE;
			GeeIterator* _tmp25_;
			gpointer _tmp26_ = NULL;
			BuildTool* _tmp27_;
			BuildTool _tmp28_ = {0};
			BuildTool _tmp29_;
			BuildTool build_tool;
			gint _tmp30_;
			gchar* _tmp31_ = NULL;
			gchar* action_name;
			BuildTool _tmp32_;
			const gchar* _tmp33_;
			gint _tmp34_;
			_tmp23_ = _build_tool_it;
			_tmp24_ = gee_iterator_next (_tmp23_);
			if (!_tmp24_) {
				break;
			}
			_tmp25_ = _build_tool_it;
			_tmp26_ = gee_iterator_get (_tmp25_);
			_tmp27_ = (BuildTool*) _tmp26_;
			build_tool_copy (_tmp27_, &_tmp28_);
			_tmp29_ = _tmp28_;
			_build_tool_free0 (_tmp27_);
			build_tool = _tmp29_;
			_tmp30_ = tool_num;
			_tmp31_ = main_window_build_tools_get_default_build_tool_name (self, _tmp30_);
			action_name = _tmp31_;
			_tmp32_ = build_tool;
			_tmp33_ = action_name;
			main_window_build_tools_add_dynamic_action (self, &_tmp32_, _tmp33_, &accel_num);
			_tmp34_ = tool_num;
			tool_num = _tmp34_ + 1;
			_g_free0 (action_name);
			build_tool_destroy (&build_tool);
		}
		_g_object_unref0 (_build_tool_it);
	}
	main_window_build_tools_add_separator (self);
	tool_num = 0;
	{
		PersonalBuildTools* _tmp35_;
		GeeIterator* _tmp36_ = NULL;
		GeeIterator* _build_tool_it;
		_tmp35_ = personal_build_tools;
		_tmp36_ = build_tools_iterator ((BuildTools*) _tmp35_);
		_build_tool_it = _tmp36_;
		while (TRUE) {
			GeeIterator* _tmp37_;
			gboolean _tmp38_ = FALSE;
			GeeIterator* _tmp39_;
			gpointer _tmp40_ = NULL;
			BuildTool* _tmp41_;
			BuildTool _tmp42_ = {0};
			BuildTool _tmp43_;
			BuildTool build_tool;
			gint _tmp44_;
			gchar* _tmp45_ = NULL;
			gchar* action_name;
			BuildTool _tmp46_;
			const gchar* _tmp47_;
			gint _tmp48_;
			_tmp37_ = _build_tool_it;
			_tmp38_ = gee_iterator_next (_tmp37_);
			if (!_tmp38_) {
				break;
			}
			_tmp39_ = _build_tool_it;
			_tmp40_ = gee_iterator_get (_tmp39_);
			_tmp41_ = (BuildTool*) _tmp40_;
			build_tool_copy (_tmp41_, &_tmp42_);
			_tmp43_ = _tmp42_;
			_build_tool_free0 (_tmp41_);
			build_tool = _tmp43_;
			_tmp44_ = tool_num;
			_tmp45_ = main_window_build_tools_get_personal_build_tool_name (self, _tmp44_);
			action_name = _tmp45_;
			_tmp46_ = build_tool;
			_tmp47_ = action_name;
			main_window_build_tools_add_dynamic_action (self, &_tmp46_, _tmp47_, &accel_num);
			_tmp48_ = tool_num;
			tool_num = _tmp48_ + 1;
			_g_free0 (action_name);
			build_tool_destroy (&build_tool);
		}
		_g_object_unref0 (_build_tool_it);
	}
	main_window_build_tools_update_sensitivity (self);
	_g_object_unref0 (personal_build_tools);
	_g_object_unref0 (default_build_tools);
}


static void main_window_build_tools_add_separator (MainWindowBuildTools* self) {
	GtkUIManager* _tmp0_;
	guint _tmp1_;
	GtkUIManager* _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_ui_manager;
	_tmp1_ = self->priv->_menu_ui_id;
	gtk_ui_manager_add_ui (_tmp0_, _tmp1_, "/MainMenu/BuildMenu/BuildToolsPlaceholderMenu", "BuildToolsSeparator", NULL, GTK_UI_MANAGER_SEPARATOR, FALSE);
	_tmp2_ = self->priv->_ui_manager;
	_tmp3_ = self->priv->_menu_ui_id;
	gtk_ui_manager_add_ui (_tmp2_, _tmp3_, "/MainToolbar/BuildToolsPlaceholderToolbar", "BuildToolsSeparator", NULL, GTK_UI_MANAGER_SEPARATOR, FALSE);
}


static void main_window_build_tools_add_dynamic_action (MainWindowBuildTools* self, BuildTool* build_tool, const gchar* action_name, gint* accel_num) {
	BuildTool _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	BuildTool _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	BuildTool _tmp7_;
	const gchar* _tmp8_;
	GtkAction* _tmp9_;
	GtkAction* _tmp10_;
	GtkAction* action;
	gchar* accel;
	gint _tmp11_;
	GtkActionGroup* _tmp16_;
	GtkAction* _tmp17_;
	const gchar* _tmp18_;
	GtkAction* _tmp19_;
	GtkUIManager* _tmp20_;
	guint _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	GtkUIManager* _tmp24_;
	guint _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gint _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (build_tool != NULL);
	g_return_if_fail (action_name != NULL);
	_tmp0_ = *build_tool;
	_tmp1_ = _tmp0_.enabled;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = action_name;
	_tmp3_ = *build_tool;
	_tmp4_ = _tmp3_.label;
	_tmp5_ = build_tool_get_description (build_tool);
	_tmp6_ = _tmp5_;
	_tmp7_ = *build_tool;
	_tmp8_ = _tmp7_.icon;
	_tmp9_ = gtk_action_new (_tmp2_, _tmp4_, _tmp6_, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp6_);
	action = _tmp10_;
	accel = NULL;
	_tmp11_ = *accel_num;
	if (_tmp11_ <= 11) {
		gint _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_ = NULL;
		_tmp12_ = *accel_num;
		_tmp13_ = g_strdup_printf ("%i", _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat ("<Release>F", _tmp14_, NULL);
		_g_free0 (accel);
		accel = _tmp15_;
		_g_free0 (_tmp14_);
	}
	_tmp16_ = self->priv->_dynamic_action_group;
	_tmp17_ = action;
	_tmp18_ = accel;
	gtk_action_group_add_action_with_accel (_tmp16_, _tmp17_, _tmp18_);
	_tmp19_ = action;
	g_signal_connect (_tmp19_, "activate", (GCallback) _main_window_build_tools_activate_dynamic_action_gtk_action_activate, self);
	_tmp20_ = self->priv->_ui_manager;
	_tmp21_ = self->priv->_menu_ui_id;
	_tmp22_ = action_name;
	_tmp23_ = action_name;
	gtk_ui_manager_add_ui (_tmp20_, _tmp21_, "/MainMenu/BuildMenu/BuildToolsPlaceholderMenu", _tmp22_, _tmp23_, GTK_UI_MANAGER_MENUITEM, FALSE);
	_tmp24_ = self->priv->_ui_manager;
	_tmp25_ = self->priv->_menu_ui_id;
	_tmp26_ = action_name;
	_tmp27_ = action_name;
	gtk_ui_manager_add_ui (_tmp24_, _tmp25_, "/MainToolbar/BuildToolsPlaceholderToolbar", _tmp26_, _tmp27_, GTK_UI_MANAGER_TOOLITEM, FALSE);
	_tmp28_ = *accel_num;
	*accel_num = _tmp28_ + 1;
	_g_free0 (accel);
	_g_object_unref0 (action);
}


static Block18Data* block18_data_ref (Block18Data* _data18_) {
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}


static void block18_data_unref (void * _userdata_) {
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		MainWindowBuildTools * self;
		self = _data18_->self;
		_g_object_unref0 (_data18_->stop_exec);
		_g_object_unref0 (_data18_->active_doc);
		_build_tool_free0 (_data18_->tool);
		_main_window_build_tools_unref0 (self);
		g_slice_free (Block18Data, _data18_);
	}
}


static void __lambda62_ (Block18Data* _data18_) {
	MainWindowBuildTools * self;
	BuildTool* _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = _data18_->self;
	gtk_action_set_sensitive (_data18_->stop_exec, FALSE);
	_tmp0_ = _data18_->tool;
	_tmp1_ = build_tool_has_jobs (_tmp0_);
	if (_tmp1_) {
		FileBrowser* _tmp2_;
		Document* _tmp3_;
		_tmp2_ = self->priv->_file_browser;
		_tmp3_ = _data18_->active_doc;
		file_browser_refresh_for_document (_tmp2_, _tmp3_);
	}
}


static void ___lambda62__build_tool_runner_finished (BuildToolRunner* _sender, gpointer self) {
	__lambda62_ (self);
}


static void main_window_build_tools_activate_dynamic_action (MainWindowBuildTools* self, GtkAction* action) {
	Block18Data* _data18_;
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	GtkAction* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	BuildTool* _tmp6_ = NULL;
	BuildTool* _tmp7_;
	MainWindow* _tmp8_;
	Document* _tmp9_;
	Document* _tmp10_;
	Document* _tmp11_;
	BuildTool* _tmp12_;
	gboolean _tmp13_ = FALSE;
	BuildTool* _tmp17_;
	gboolean _tmp18_ = FALSE;
	BuildView* _tmp50_;
	GtkActionGroup* _tmp51_;
	GtkAction* _tmp52_ = NULL;
	GtkAction* _tmp53_;
	Document* _tmp54_;
	GFile* _tmp55_ = NULL;
	GFile* main_file;
	BuildTool* _tmp56_;
	BuildView* _tmp57_;
	BuildTool _tmp58_;
	BuildToolRunner* _tmp59_;
	BuildToolRunner* _tmp60_;
	BuildToolRunner* _tmp61_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_data18_ = g_slice_new0 (Block18Data);
	_data18_->_ref_count_ = 1;
	_data18_->self = main_window_build_tools_ref (self);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = action;
	_tmp4_ = gtk_action_get_name (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = main_window_build_tools_get_build_tool_from_name (self, _tmp5_);
	_data18_->tool = _tmp6_;
	_tmp7_ = _data18_->tool;
	g_return_if_fail (_tmp7_ != NULL);
	_tmp8_ = self->priv->_main_window;
	_tmp9_ = main_window_get_active_document (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_data18_->active_doc = _tmp11_;
	_tmp12_ = _data18_->tool;
	_tmp13_ = build_tool_has_jobs (_tmp12_);
	if (!_tmp13_) {
		Document* _tmp14_;
		GFile* _tmp15_;
		GFile* _tmp16_;
		_tmp14_ = _data18_->active_doc;
		_tmp15_ = document_get_location (_tmp14_);
		_tmp16_ = _tmp15_;
		g_return_if_fail (_tmp16_ != NULL);
	}
	_tmp17_ = _data18_->tool;
	_tmp18_ = build_tool_has_jobs (_tmp17_);
	if (_tmp18_) {
		Document* _tmp19_;
		GFile* _tmp20_;
		GFile* _tmp21_;
		Document* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint project_id;
		gint _tmp28_;
		_tmp19_ = _data18_->active_doc;
		_tmp20_ = document_get_location (_tmp19_);
		_tmp21_ = _tmp20_;
		if (_tmp21_ == NULL) {
			Document* _tmp22_;
			gboolean _tmp23_ = FALSE;
			gboolean tmp_location_set;
			gboolean _tmp24_;
			_tmp22_ = _data18_->active_doc;
			_tmp23_ = document_set_tmp_location (_tmp22_);
			tmp_location_set = _tmp23_;
			_tmp24_ = tmp_location_set;
			g_return_if_fail (_tmp24_);
		}
		_tmp25_ = _data18_->active_doc;
		_tmp26_ = document_get_project_id (_tmp25_);
		_tmp27_ = _tmp26_;
		project_id = _tmp27_;
		_tmp28_ = project_id;
		if (_tmp28_ == (-1)) {
			Document* _tmp29_;
			_tmp29_ = _data18_->active_doc;
			document_save (_tmp29_, TRUE, FALSE);
		} else {
			Latexila* _tmp30_ = NULL;
			Latexila* _tmp31_;
			GeeList* _tmp32_ = NULL;
			GeeList* _tmp33_;
			GeeList* docs;
			_tmp30_ = latexila_get_instance ();
			_tmp31_ = _tmp30_;
			_tmp32_ = latexila_get_documents (_tmp31_);
			_tmp33_ = _tmp32_;
			_g_object_unref0 (_tmp31_);
			docs = _tmp33_;
			{
				GeeList* _tmp34_;
				GeeList* _tmp35_;
				GeeList* _doc_list;
				GeeList* _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				gint _doc_size;
				gint _doc_index;
				_tmp34_ = docs;
				_tmp35_ = _g_object_ref0 (_tmp34_);
				_doc_list = _tmp35_;
				_tmp36_ = _doc_list;
				_tmp37_ = gee_collection_get_size ((GeeCollection*) _tmp36_);
				_tmp38_ = _tmp37_;
				_doc_size = _tmp38_;
				_doc_index = -1;
				while (TRUE) {
					gint _tmp39_;
					gint _tmp40_;
					gint _tmp41_;
					GeeList* _tmp42_;
					gint _tmp43_;
					gpointer _tmp44_ = NULL;
					Document* doc;
					Document* _tmp45_;
					gint _tmp46_;
					gint _tmp47_;
					gint _tmp48_;
					_tmp39_ = _doc_index;
					_doc_index = _tmp39_ + 1;
					_tmp40_ = _doc_index;
					_tmp41_ = _doc_size;
					if (!(_tmp40_ < _tmp41_)) {
						break;
					}
					_tmp42_ = _doc_list;
					_tmp43_ = _doc_index;
					_tmp44_ = gee_list_get (_tmp42_, _tmp43_);
					doc = (Document*) _tmp44_;
					_tmp45_ = doc;
					_tmp46_ = document_get_project_id (_tmp45_);
					_tmp47_ = _tmp46_;
					_tmp48_ = project_id;
					if (_tmp47_ == _tmp48_) {
						Document* _tmp49_;
						_tmp49_ = doc;
						document_save (_tmp49_, TRUE, FALSE);
					}
					_g_object_unref0 (doc);
				}
				_g_object_unref0 (_doc_list);
			}
			_g_object_unref0 (docs);
		}
		utils_flush_queue ();
	}
	_tmp50_ = self->priv->_build_view;
	gtk_widget_show ((GtkWidget*) _tmp50_);
	_tmp51_ = self->priv->_static_action_group;
	_tmp52_ = gtk_action_group_get_action (_tmp51_, "BuildStopExecution");
	_tmp53_ = _g_object_ref0 (_tmp52_);
	_data18_->stop_exec = _tmp53_;
	gtk_action_set_sensitive (_data18_->stop_exec, TRUE);
	_tmp54_ = _data18_->active_doc;
	_tmp55_ = document_get_main_file (_tmp54_);
	main_file = _tmp55_;
	_tmp56_ = _data18_->tool;
	_tmp57_ = self->priv->_build_view;
	_tmp58_ = *_tmp56_;
	_tmp59_ = build_tool_runner_new (&_tmp58_, main_file, _tmp57_);
	_g_object_unref0 (self->priv->_build_tool_runner);
	self->priv->_build_tool_runner = _tmp59_;
	_tmp60_ = self->priv->_build_tool_runner;
	g_signal_connect_data (_tmp60_, "finished", (GCallback) ___lambda62__build_tool_runner_finished, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
	_tmp61_ = self->priv->_build_tool_runner;
	build_tool_runner_run (_tmp61_);
	_g_object_unref0 (main_file);
	block18_data_unref (_data18_);
	_data18_ = NULL;
}


static void main_window_build_tools_connect_toggle_actions (MainWindowBuildTools* self) {
	GSettings* _tmp0_;
	GSettings* settings;
	GtkActionGroup* _tmp1_;
	GtkAction* _tmp2_ = NULL;
	GtkToggleAction* _tmp3_;
	GtkToggleAction* action_details;
	BuildView* _tmp4_;
	BuildView* _tmp5_;
	GtkActionGroup* _tmp6_;
	GtkAction* _tmp7_ = NULL;
	GtkToggleAction* _tmp8_;
	GtkToggleAction* action_warnings;
	BuildView* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GtkActionGroup* _tmp11_;
	GtkAction* _tmp12_ = NULL;
	GtkToggleAction* _tmp13_;
	GtkToggleAction* action_badboxes;
	BuildView* _tmp14_;
	gboolean _tmp15_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.ui");
	settings = _tmp0_;
	_tmp1_ = self->priv->_static_action_group;
	_tmp2_ = gtk_action_group_get_action (_tmp1_, "BuildShowDetails");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GTK_TYPE_TOGGLE_ACTION) ? ((GtkToggleAction*) _tmp2_) : NULL);
	action_details = _tmp3_;
	_tmp4_ = self->priv->_build_view;
	g_object_bind_property_with_closures ((GObject*) action_details, "active", (GObject*) _tmp4_, "show-details", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp5_ = self->priv->_build_view;
	g_object_bind_property_with_closures ((GObject*) _tmp5_, "has-details", (GObject*) action_details, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	gtk_toggle_action_set_active (action_details, FALSE);
	_tmp6_ = self->priv->_static_action_group;
	_tmp7_ = gtk_action_group_get_action (_tmp6_, "BuildShowWarnings");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, GTK_TYPE_TOGGLE_ACTION) ? ((GtkToggleAction*) _tmp7_) : NULL);
	action_warnings = _tmp8_;
	_tmp9_ = self->priv->_build_view;
	g_object_bind_property_with_closures ((GObject*) _tmp9_, "show-warnings", (GObject*) action_warnings, "active", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp10_ = g_settings_get_boolean (settings, "show-build-warnings");
	gtk_toggle_action_set_active (action_warnings, _tmp10_);
	_tmp11_ = self->priv->_static_action_group;
	_tmp12_ = gtk_action_group_get_action (_tmp11_, "BuildShowBadBoxes");
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, GTK_TYPE_TOGGLE_ACTION) ? ((GtkToggleAction*) _tmp12_) : NULL);
	action_badboxes = _tmp13_;
	_tmp14_ = self->priv->_build_view;
	g_object_bind_property_with_closures ((GObject*) _tmp14_, "show-badboxes", (GObject*) action_badboxes, "active", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
	_tmp15_ = g_settings_get_boolean (settings, "show-build-badboxes");
	gtk_toggle_action_set_active (action_badboxes, _tmp15_);
	_g_object_unref0 (action_badboxes);
	_g_object_unref0 (action_warnings);
	_g_object_unref0 (action_details);
	_g_object_unref0 (settings);
}


void main_window_build_tools_on_stop_execution (MainWindowBuildTools* self) {
	BuildToolRunner* _tmp0_;
	BuildToolRunner* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_build_tool_runner;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->_build_tool_runner;
	build_tool_runner_abort (_tmp1_);
}


void main_window_build_tools_on_clean (MainWindowBuildTools* self) {
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	MainWindow* _tmp3_;
	MainWindow* _tmp4_;
	Document* _tmp5_;
	Document* _tmp6_;
	CleanBuildFiles* _tmp7_;
	CleanBuildFiles* build_files;
	CleanBuildFiles* _tmp8_;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_main_window;
	_tmp4_ = self->priv->_main_window;
	_tmp5_ = main_window_get_active_document (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = clean_build_files_new (_tmp3_, _tmp6_);
	build_files = _tmp7_;
	_tmp8_ = build_files;
	_tmp9_ = clean_build_files_clean (_tmp8_);
	if (_tmp9_) {
		FileBrowser* _tmp10_;
		MainWindow* _tmp11_;
		Document* _tmp12_;
		Document* _tmp13_;
		_tmp10_ = self->priv->_file_browser;
		_tmp11_ = self->priv->_main_window;
		_tmp12_ = main_window_get_active_document (_tmp11_);
		_tmp13_ = _tmp12_;
		file_browser_refresh_for_document (_tmp10_, _tmp13_);
	}
	_g_object_unref0 (build_files);
}


void main_window_build_tools_on_view_log (MainWindowBuildTools* self) {
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	MainWindow* _tmp3_;
	Document* _tmp4_;
	Document* _tmp5_;
	gboolean _tmp6_ = FALSE;
	MainWindow* _tmp7_;
	Document* _tmp8_;
	Document* _tmp9_;
	GFile* _tmp10_ = NULL;
	GFile* mainfile;
	GFile* _tmp11_;
	GFile* _tmp12_ = NULL;
	GFile* directory;
	GFile* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* basename;
	GFile* _tmp20_;
	const gchar* _tmp21_;
	GFile* _tmp22_ = NULL;
	GFile* file;
	MainWindow* _tmp23_;
	GFile* _tmp24_;
	DocumentTab* _tmp25_ = NULL;
	DocumentTab* tab;
	DocumentTab* _tmp26_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_main_window;
	_tmp4_ = main_window_get_active_document (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = document_is_main_file_a_tex_file (_tmp5_);
	g_return_if_fail (_tmp6_);
	_tmp7_ = self->priv->_main_window;
	_tmp8_ = main_window_get_active_document (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = document_get_main_file (_tmp9_);
	mainfile = _tmp10_;
	_tmp11_ = mainfile;
	_tmp12_ = g_file_get_parent (_tmp11_);
	directory = _tmp12_;
	_tmp13_ = mainfile;
	_tmp14_ = g_file_get_basename (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = utils_get_shortname (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (_tmp17_, ".log", NULL);
	_tmp19_ = _tmp18_;
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	basename = _tmp19_;
	_tmp20_ = directory;
	_tmp21_ = basename;
	_tmp22_ = g_file_get_child (_tmp20_, _tmp21_);
	file = _tmp22_;
	_tmp23_ = self->priv->_main_window;
	_tmp24_ = file;
	_tmp25_ = main_window_open_document (_tmp23_, _tmp24_, TRUE);
	tab = _tmp25_;
	_tmp26_ = tab;
	if (_tmp26_ == NULL) {
		g_warning ("main_window_build_tools.vala:424: Impossible to view log");
	} else {
		DocumentTab* _tmp27_;
		Document* _tmp28_;
		Document* _tmp29_;
		_tmp27_ = tab;
		_tmp28_ = document_tab_get_document (_tmp27_);
		_tmp29_ = _tmp28_;
		document_set_readonly (_tmp29_, TRUE);
	}
	_g_object_unref0 (tab);
	_g_object_unref0 (file);
	_g_free0 (basename);
	_g_object_unref0 (directory);
	_g_object_unref0 (mainfile);
}


void main_window_build_tools_on_preferences (MainWindowBuildTools* self) {
	MainWindow* _tmp0_;
	BuildToolsPreferences* _tmp1_;
	BuildToolsPreferences* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = build_tools_preferences_new (_tmp0_);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
}


static void value_main_window_build_tools_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_main_window_build_tools_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		main_window_build_tools_unref (value->data[0].v_pointer);
	}
}


static void value_main_window_build_tools_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = main_window_build_tools_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_main_window_build_tools_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_main_window_build_tools_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		MainWindowBuildTools* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = main_window_build_tools_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_main_window_build_tools_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	MainWindowBuildTools** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = main_window_build_tools_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_main_window_build_tools (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecMainWindowBuildTools* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MAIN_WINDOW_BUILD_TOOLS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_main_window_build_tools (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_BUILD_TOOLS), NULL);
	return value->data[0].v_pointer;
}


void value_set_main_window_build_tools (GValue* value, gpointer v_object) {
	MainWindowBuildTools* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_BUILD_TOOLS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN_WINDOW_BUILD_TOOLS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		main_window_build_tools_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		main_window_build_tools_unref (old);
	}
}


void value_take_main_window_build_tools (GValue* value, gpointer v_object) {
	MainWindowBuildTools* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_BUILD_TOOLS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN_WINDOW_BUILD_TOOLS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		main_window_build_tools_unref (old);
	}
}


static void main_window_build_tools_class_init (MainWindowBuildToolsClass * klass) {
	main_window_build_tools_parent_class = g_type_class_peek_parent (klass);
	MAIN_WINDOW_BUILD_TOOLS_CLASS (klass)->finalize = main_window_build_tools_finalize;
	g_type_class_add_private (klass, sizeof (MainWindowBuildToolsPrivate));
}


static void main_window_build_tools_instance_init (MainWindowBuildTools * self) {
	self->priv = MAIN_WINDOW_BUILD_TOOLS_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void main_window_build_tools_finalize (MainWindowBuildTools* obj) {
	MainWindowBuildTools * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildTools);
	_g_object_unref0 (self->priv->_ui_manager);
	_g_object_unref0 (self->priv->_build_view);
	_g_object_unref0 (self->priv->_file_browser);
	_g_object_unref0 (self->priv->_static_action_group);
	_g_object_unref0 (self->priv->_dynamic_action_group);
	_g_object_unref0 (self->priv->_build_tool_runner);
}


GType main_window_build_tools_get_type (void) {
	static volatile gsize main_window_build_tools_type_id__volatile = 0;
	if (g_once_init_enter (&main_window_build_tools_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_main_window_build_tools_init, value_main_window_build_tools_free_value, value_main_window_build_tools_copy_value, value_main_window_build_tools_peek_pointer, "p", value_main_window_build_tools_collect_value, "p", value_main_window_build_tools_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (MainWindowBuildToolsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_build_tools_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindowBuildTools), 0, (GInstanceInitFunc) main_window_build_tools_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType main_window_build_tools_type_id;
		main_window_build_tools_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MainWindowBuildTools", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&main_window_build_tools_type_id__volatile, main_window_build_tools_type_id);
	}
	return main_window_build_tools_type_id__volatile;
}


gpointer main_window_build_tools_ref (gpointer instance) {
	MainWindowBuildTools* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void main_window_build_tools_unref (gpointer instance) {
	MainWindowBuildTools* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MAIN_WINDOW_BUILD_TOOLS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



