/* build_job_runner.c generated by valac 0.17.3.8-fd35, the Vala compiler
 * generated from build_job_runner.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>


#define TYPE_BUILD_JOB_RUNNER (build_job_runner_get_type ())
#define BUILD_JOB_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_JOB_RUNNER, BuildJobRunner))
#define BUILD_JOB_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_JOB_RUNNER, BuildJobRunnerClass))
#define IS_BUILD_JOB_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_JOB_RUNNER))
#define IS_BUILD_JOB_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_JOB_RUNNER))
#define BUILD_JOB_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_JOB_RUNNER, BuildJobRunnerClass))

typedef struct _BuildJobRunner BuildJobRunner;
typedef struct _BuildJobRunnerClass BuildJobRunnerClass;
typedef struct _BuildJobRunnerPrivate BuildJobRunnerPrivate;

#define TYPE_BUILD_JOB (build_job_get_type ())

#define TYPE_POST_PROCESSOR_TYPE (post_processor_type_get_type ())
typedef struct _BuildJob BuildJob;

#define TYPE_BUILD_COMMAND_RUNNER (build_command_runner_get_type ())
#define BUILD_COMMAND_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_COMMAND_RUNNER, BuildCommandRunner))
#define BUILD_COMMAND_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_COMMAND_RUNNER, BuildCommandRunnerClass))
#define IS_BUILD_COMMAND_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_COMMAND_RUNNER))
#define IS_BUILD_COMMAND_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_COMMAND_RUNNER))
#define BUILD_COMMAND_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_COMMAND_RUNNER, BuildCommandRunnerClass))

typedef struct _BuildCommandRunner BuildCommandRunner;
typedef struct _BuildCommandRunnerClass BuildCommandRunnerClass;

#define TYPE_POST_PROCESSOR (post_processor_get_type ())
#define POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POST_PROCESSOR, PostProcessor))
#define POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_POST_PROCESSOR, PostProcessorClass))
#define IS_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POST_PROCESSOR))
#define IS_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_POST_PROCESSOR))
#define POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_POST_PROCESSOR, PostProcessorClass))

typedef struct _PostProcessor PostProcessor;
typedef struct _PostProcessorClass PostProcessorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BUILD_MSG (build_msg_get_type ())

#define TYPE_BUILD_MSG_TYPE (build_msg_type_get_type ())
typedef struct _BuildMsg BuildMsg;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define TYPE_ALL_OUTPUT_POST_PROCESSOR (all_output_post_processor_get_type ())
#define ALL_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALL_OUTPUT_POST_PROCESSOR, AllOutputPostProcessor))
#define ALL_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALL_OUTPUT_POST_PROCESSOR, AllOutputPostProcessorClass))
#define IS_ALL_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALL_OUTPUT_POST_PROCESSOR))
#define IS_ALL_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALL_OUTPUT_POST_PROCESSOR))
#define ALL_OUTPUT_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALL_OUTPUT_POST_PROCESSOR, AllOutputPostProcessorClass))

typedef struct _AllOutputPostProcessor AllOutputPostProcessor;
typedef struct _AllOutputPostProcessorClass AllOutputPostProcessorClass;

#define TYPE_LATEX_POST_PROCESSOR (latex_post_processor_get_type ())
#define LATEX_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessor))
#define LATEX_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessorClass))
#define IS_LATEX_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEX_POST_PROCESSOR))
#define IS_LATEX_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEX_POST_PROCESSOR))
#define LATEX_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessorClass))

typedef struct _LatexPostProcessor LatexPostProcessor;
typedef struct _LatexPostProcessorClass LatexPostProcessorClass;

#define TYPE_LATEXMK_POST_PROCESSOR (latexmk_post_processor_get_type ())
#define LATEXMK_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEXMK_POST_PROCESSOR, LatexmkPostProcessor))
#define LATEXMK_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEXMK_POST_PROCESSOR, LatexmkPostProcessorClass))
#define IS_LATEXMK_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEXMK_POST_PROCESSOR))
#define IS_LATEXMK_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEXMK_POST_PROCESSOR))
#define LATEXMK_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEXMK_POST_PROCESSOR, LatexmkPostProcessorClass))

typedef struct _LatexmkPostProcessor LatexmkPostProcessor;
typedef struct _LatexmkPostProcessorClass LatexmkPostProcessorClass;

#define TYPE_NO_OUTPUT_POST_PROCESSOR (no_output_post_processor_get_type ())
#define NO_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NO_OUTPUT_POST_PROCESSOR, NoOutputPostProcessor))
#define NO_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NO_OUTPUT_POST_PROCESSOR, NoOutputPostProcessorClass))
#define IS_NO_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NO_OUTPUT_POST_PROCESSOR))
#define IS_NO_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NO_OUTPUT_POST_PROCESSOR))
#define NO_OUTPUT_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NO_OUTPUT_POST_PROCESSOR, NoOutputPostProcessorClass))

typedef struct _NoOutputPostProcessor NoOutputPostProcessor;
typedef struct _NoOutputPostProcessorClass NoOutputPostProcessorClass;

#define TYPE_RUBBER_POST_PROCESSOR (rubber_post_processor_get_type ())
#define RUBBER_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RUBBER_POST_PROCESSOR, RubberPostProcessor))
#define RUBBER_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RUBBER_POST_PROCESSOR, RubberPostProcessorClass))
#define IS_RUBBER_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RUBBER_POST_PROCESSOR))
#define IS_RUBBER_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RUBBER_POST_PROCESSOR))
#define RUBBER_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RUBBER_POST_PROCESSOR, RubberPostProcessorClass))

typedef struct _RubberPostProcessor RubberPostProcessor;
typedef struct _RubberPostProcessorClass RubberPostProcessorClass;

struct _BuildJobRunner {
	GObject parent_instance;
	BuildJobRunnerPrivate * priv;
};

struct _BuildJobRunnerClass {
	GObjectClass parent_class;
};

typedef enum  {
	POST_PROCESSOR_TYPE_ALL_OUTPUT = 0,
	POST_PROCESSOR_TYPE_LATEX,
	POST_PROCESSOR_TYPE_LATEXMK,
	POST_PROCESSOR_TYPE_NO_OUTPUT,
	POST_PROCESSOR_TYPE_RUBBER,
	POST_PROCESSOR_TYPE_N_POST_PROCESSORS
} PostProcessorType;

struct _BuildJob {
	PostProcessorType post_processor;
	gchar* command;
};

struct _BuildJobRunnerPrivate {
	BuildJob _build_job;
	GFile* _on_file;
	BuildCommandRunner* _command_runner;
	PostProcessor* _post_processor;
};

typedef enum  {
	BUILD_MSG_TYPE_TITLE,
	BUILD_MSG_TYPE_JOB_TITLE,
	BUILD_MSG_TYPE_JOB_SUB_COMMAND,
	BUILD_MSG_TYPE_ERROR,
	BUILD_MSG_TYPE_WARNING,
	BUILD_MSG_TYPE_BADBOX,
	BUILD_MSG_TYPE_INFO
} BuildMsgType;

struct _BuildMsg {
	BuildMsgType type;
	gchar* text;
	gchar* filename;
	gint start_line;
	gint end_line;
	gboolean expand;
	GeeList* children;
};


static gpointer build_job_runner_parent_class = NULL;

GType build_job_runner_get_type (void) G_GNUC_CONST;
GType build_job_get_type (void) G_GNUC_CONST;
GType post_processor_type_get_type (void) G_GNUC_CONST;
BuildJob* build_job_dup (const BuildJob* self);
void build_job_free (BuildJob* self);
void build_job_copy (const BuildJob* self, BuildJob* dest);
void build_job_destroy (BuildJob* self);
GType build_command_runner_get_type (void) G_GNUC_CONST;
GType post_processor_get_type (void) G_GNUC_CONST;
#define BUILD_JOB_RUNNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BUILD_JOB_RUNNER, BuildJobRunnerPrivate))
enum  {
	BUILD_JOB_RUNNER_DUMMY_PROPERTY
};
BuildJobRunner* build_job_runner_new (BuildJob* build_job, GFile* on_file);
BuildJobRunner* build_job_runner_construct (GType object_type, BuildJob* build_job, GFile* on_file);
gchar* build_job_runner_get_command_line (BuildJobRunner* self, GError** error);
static gchar** build_job_runner_get_command_args (BuildJobRunner* self, gboolean for_printing, int* result_length1, GError** error);
gchar* build_job_runner_get_command_name (BuildJobRunner* self);
void build_job_runner_run (BuildJobRunner* self, GError** error);
BuildCommandRunner* build_command_runner_new (gchar** command_args, int command_args_length1, const gchar* working_directory);
BuildCommandRunner* build_command_runner_construct (GType object_type, gchar** command_args, int command_args_length1, const gchar* working_directory);
static void __lambda35_ (BuildJobRunner* self, gint exit_status);
static void build_job_runner_create_post_processor (BuildJobRunner* self, gint exit_status);
void post_processor_process (PostProcessor* self, GFile* file, const gchar* output);
gchar* build_command_runner_get_output (BuildCommandRunner* self);
static void ___lambda35__build_command_runner_finished (BuildCommandRunner* _sender, gint exit_status, gpointer self);
void build_command_runner_execute_without_output (BuildCommandRunner* self, GError** error);
void build_command_runner_execute_with_output (BuildCommandRunner* self, GError** error);
gboolean build_job_runner_has_details (BuildJobRunner* self);
gboolean post_processor_has_details (PostProcessor* self);
GType build_msg_get_type (void) G_GNUC_CONST;
GType build_msg_type_get_type (void) G_GNUC_CONST;
BuildMsg* build_msg_dup (const BuildMsg* self);
void build_msg_free (BuildMsg* self);
void build_msg_copy (const BuildMsg* self, BuildMsg* dest);
void build_msg_destroy (BuildMsg* self);
GeeList* build_job_runner_get_messages (BuildJobRunner* self);
GeeList* post_processor_get_messages (PostProcessor* self);
GeeList* build_job_runner_get_detailed_messages (BuildJobRunner* self);
GeeList* post_processor_get_detailed_messages (PostProcessor* self);
void build_job_runner_abort (BuildJobRunner* self);
void build_command_runner_abort (BuildCommandRunner* self);
static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add11 (gchar*** array, int* length, int* size, gchar* value);
static gchar** _vala_array_dup1 (gchar** self, int length);
gchar* utils_get_shortname (const gchar* path);
static void _vala_array_add12 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add13 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add14 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add15 (gchar*** array, int* length, int* size, gchar* value);
AllOutputPostProcessor* all_output_post_processor_new (void);
AllOutputPostProcessor* all_output_post_processor_construct (GType object_type);
GType all_output_post_processor_get_type (void) G_GNUC_CONST;
LatexPostProcessor* latex_post_processor_new (void);
LatexPostProcessor* latex_post_processor_construct (GType object_type);
GType latex_post_processor_get_type (void) G_GNUC_CONST;
LatexmkPostProcessor* latexmk_post_processor_new (gint exit_status);
LatexmkPostProcessor* latexmk_post_processor_construct (GType object_type, gint exit_status);
GType latexmk_post_processor_get_type (void) G_GNUC_CONST;
NoOutputPostProcessor* no_output_post_processor_new (void);
NoOutputPostProcessor* no_output_post_processor_construct (GType object_type);
GType no_output_post_processor_get_type (void) G_GNUC_CONST;
RubberPostProcessor* rubber_post_processor_new (void);
RubberPostProcessor* rubber_post_processor_construct (GType object_type);
GType rubber_post_processor_get_type (void) G_GNUC_CONST;
static void build_job_runner_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


BuildJobRunner* build_job_runner_construct (GType object_type, BuildJob* build_job, GFile* on_file) {
	BuildJobRunner * self = NULL;
	BuildJob _tmp0_;
	BuildJob _tmp1_ = {0};
	GFile* _tmp2_;
	GFile* _tmp3_;
	g_return_val_if_fail (build_job != NULL, NULL);
	g_return_val_if_fail (on_file != NULL, NULL);
	self = (BuildJobRunner*) g_object_new (object_type, NULL);
	_tmp0_ = *build_job;
	build_job_copy (&_tmp0_, &_tmp1_);
	build_job_destroy (&self->priv->_build_job);
	self->priv->_build_job = _tmp1_;
	_tmp2_ = on_file;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->_on_file);
	self->priv->_on_file = _tmp3_;
	return self;
}


BuildJobRunner* build_job_runner_new (BuildJob* build_job, GFile* on_file) {
	return build_job_runner_construct (TYPE_BUILD_JOB_RUNNER, build_job, on_file);
}


gchar* build_job_runner_get_command_line (BuildJobRunner* self, GError** error) {
	gchar* result = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_ = NULL;
	gchar** command_args;
	gint command_args_length1;
	gint _command_args_size_;
	gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = build_job_runner_get_command_args (self, TRUE, &_tmp0_, &_inner_error_);
	command_args = _tmp1_;
	command_args_length1 = _tmp0_;
	_command_args_size_ = command_args_length1;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_SHELL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = g_strjoinv (" ", command_args);
	result = _tmp2_;
	command_args = (_vala_array_free (command_args, command_args_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


gchar* build_job_runner_get_command_name (BuildJobRunner* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gint _tmp0_ = 0;
		gchar** _tmp1_ = NULL;
		gchar** command_args;
		gint command_args_length1;
		gint _command_args_size_;
		gchar** _tmp2_;
		gint _tmp2__length1;
		gchar** _tmp4_;
		gint _tmp4__length1;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp1_ = build_job_runner_get_command_args (self, TRUE, &_tmp0_, &_inner_error_);
		command_args = _tmp1_;
		command_args_length1 = _tmp0_;
		_command_args_size_ = command_args_length1;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SHELL_ERROR) {
				goto __catch25_g_shell_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = command_args;
		_tmp2__length1 = command_args_length1;
		if (_tmp2__length1 == 0) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("");
			result = _tmp3_;
			command_args = (_vala_array_free (command_args, command_args_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_tmp4_ = command_args;
		_tmp4__length1 = command_args_length1;
		_tmp5_ = _tmp4_[0];
		_tmp6_ = g_strdup (_tmp5_);
		result = _tmp6_;
		command_args = (_vala_array_free (command_args, command_args_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	goto __finally25;
	__catch25_g_shell_error:
	{
		GError* e = NULL;
		gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = g_strdup ("");
		result = _tmp7_;
		_g_error_free0 (e);
		return result;
	}
	__finally25:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static void __lambda35_ (BuildJobRunner* self, gint exit_status) {
	gint _tmp0_;
	PostProcessor* _tmp1_;
	GFile* _tmp2_;
	BuildCommandRunner* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gint _tmp6_;
	_tmp0_ = exit_status;
	build_job_runner_create_post_processor (self, _tmp0_);
	_tmp1_ = self->priv->_post_processor;
	_tmp2_ = self->priv->_on_file;
	_tmp3_ = self->priv->_command_runner;
	_tmp4_ = build_command_runner_get_output (_tmp3_);
	_tmp5_ = _tmp4_;
	post_processor_process (_tmp1_, _tmp2_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = exit_status;
	g_signal_emit_by_name (self, "finished", _tmp6_ == 0);
	_g_object_unref0 (self->priv->_command_runner);
	self->priv->_command_runner = NULL;
}


static void ___lambda35__build_command_runner_finished (BuildCommandRunner* _sender, gint exit_status, gpointer self) {
	__lambda35_ (self, exit_status);
}


void build_job_runner_run (BuildJobRunner* self, GError** error) {
	gint _tmp0_ = 0;
	gchar** _tmp1_ = NULL;
	gchar** command_args;
	gint command_args_length1;
	gint _command_args_size_;
	GFile* _tmp2_;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* working_directory;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	BuildCommandRunner* _tmp9_;
	BuildCommandRunner* _tmp10_;
	BuildJob _tmp11_;
	PostProcessorType _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = build_job_runner_get_command_args (self, FALSE, &_tmp0_, &_inner_error_);
	command_args = _tmp1_;
	command_args_length1 = _tmp0_;
	_command_args_size_ = command_args_length1;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = self->priv->_on_file;
	_tmp3_ = g_file_get_parent (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_get_parse_name (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	working_directory = _tmp6_;
	_tmp7_ = command_args;
	_tmp7__length1 = command_args_length1;
	_tmp8_ = working_directory;
	_tmp9_ = build_command_runner_new (_tmp7_, _tmp7__length1, _tmp8_);
	_g_object_unref0 (self->priv->_command_runner);
	self->priv->_command_runner = _tmp9_;
	_tmp10_ = self->priv->_command_runner;
	g_signal_connect_object (_tmp10_, "finished", (GCallback) ___lambda35__build_command_runner_finished, self, 0);
	_tmp11_ = self->priv->_build_job;
	_tmp12_ = _tmp11_.post_processor;
	if (_tmp12_ == POST_PROCESSOR_TYPE_NO_OUTPUT) {
		BuildCommandRunner* _tmp13_;
		_tmp13_ = self->priv->_command_runner;
		build_command_runner_execute_without_output (_tmp13_, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (working_directory);
			command_args = (_vala_array_free (command_args, command_args_length1, (GDestroyNotify) g_free), NULL);
			return;
		}
	} else {
		BuildCommandRunner* _tmp14_;
		_tmp14_ = self->priv->_command_runner;
		build_command_runner_execute_with_output (_tmp14_, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (working_directory);
			command_args = (_vala_array_free (command_args, command_args_length1, (GDestroyNotify) g_free), NULL);
			return;
		}
	}
	_g_free0 (working_directory);
	command_args = (_vala_array_free (command_args, command_args_length1, (GDestroyNotify) g_free), NULL);
}


gboolean build_job_runner_has_details (BuildJobRunner* self) {
	gboolean result = FALSE;
	PostProcessor* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_post_processor;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	} else {
		PostProcessor* _tmp1_;
		gboolean _tmp2_ = FALSE;
		_tmp1_ = self->priv->_post_processor;
		_tmp2_ = post_processor_has_details (_tmp1_);
		result = _tmp2_;
		return result;
	}
}


GeeList* build_job_runner_get_messages (BuildJobRunner* self) {
	GeeList* result = NULL;
	PostProcessor* _tmp0_;
	PostProcessor* _tmp2_;
	GeeList* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_post_processor;
	if (_tmp0_ == NULL) {
		GeeLinkedList* _tmp1_;
		g_warning ("build_job_runner.vala:96: Build job runner: try to get messages too ea" \
"rly");
		_tmp1_ = gee_linked_list_new (TYPE_BUILD_MSG, (GBoxedCopyFunc) build_msg_dup, build_msg_free, NULL);
		result = (GeeList*) _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->_post_processor;
	_tmp3_ = post_processor_get_messages (_tmp2_);
	result = _tmp3_;
	return result;
}


GeeList* build_job_runner_get_detailed_messages (BuildJobRunner* self) {
	GeeList* result = NULL;
	PostProcessor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_post_processor;
	if (_tmp0_ == NULL) {
		GeeList* _tmp1_ = NULL;
		_tmp1_ = build_job_runner_get_messages (self);
		result = _tmp1_;
		return result;
	} else {
		PostProcessor* _tmp2_;
		GeeList* _tmp3_ = NULL;
		_tmp2_ = self->priv->_post_processor;
		_tmp3_ = post_processor_get_detailed_messages (_tmp2_);
		result = _tmp3_;
		return result;
	}
}


void build_job_runner_abort (BuildJobRunner* self) {
	BuildCommandRunner* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_command_runner;
	if (_tmp0_ != NULL) {
		BuildCommandRunner* _tmp1_;
		_tmp1_ = self->priv->_command_runner;
		build_command_runner_abort (_tmp1_);
	}
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static void _vala_array_add10 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add11 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch26_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch26_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally26;
	__catch26_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally26:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void _vala_array_add12 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add13 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add14 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add15 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar** build_job_runner_get_command_args (BuildJobRunner* self, gboolean for_printing, int* result_length1, GError** error) {
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	BuildJob _tmp1_;
	const gchar* _tmp2_;
	gchar** _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gboolean _tmp5_;
	GFile* _tmp21_;
	gchar* _tmp22_ = NULL;
	gchar* base_filename;
	const gchar* _tmp23_;
	gchar* _tmp24_ = NULL;
	gchar* base_shortname;
	gchar** _tmp25_ = NULL;
	gchar** new_args;
	gint new_args_length1;
	gint _new_args_size_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	gchar** _tmp48_;
	gint _tmp48__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	args = _tmp0_;
	args_length1 = 0;
	_args_size_ = args_length1;
	_tmp1_ = self->priv->_build_job;
	_tmp2_ = _tmp1_.command;
	g_shell_parse_argv (_tmp2_, &_tmp4_, &_tmp3_, &_inner_error_);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	args = _tmp3_;
	args_length1 = _tmp4_;
	_args_size_ = args_length1;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_SHELL_ERROR) {
			g_propagate_error (error, _inner_error_);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		} else {
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp5_ = for_printing;
	if (_tmp5_) {
		gchar** _tmp6_ = NULL;
		gchar** new_args;
		gint new_args_length1;
		gint _new_args_size_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		gchar** _tmp19_;
		gint _tmp19__length1;
		gchar** _tmp20_;
		gint _tmp20__length1;
		_tmp6_ = g_new0 (gchar*, 0 + 1);
		new_args = _tmp6_;
		new_args_length1 = 0;
		_new_args_size_ = new_args_length1;
		_tmp7_ = args;
		_tmp7__length1 = args_length1;
		{
			gchar** arg_collection = NULL;
			gint arg_collection_length1 = 0;
			gint _arg_collection_size_ = 0;
			gint arg_it = 0;
			arg_collection = _tmp7_;
			arg_collection_length1 = _tmp7__length1;
			for (arg_it = 0; arg_it < _tmp7__length1; arg_it = arg_it + 1) {
				gchar* _tmp8_;
				gchar* arg = NULL;
				_tmp8_ = g_strdup (arg_collection[arg_it]);
				arg = _tmp8_;
				{
					const gchar* _tmp9_;
					gboolean _tmp10_ = FALSE;
					_tmp9_ = arg;
					_tmp10_ = string_contains (_tmp9_, " ");
					if (_tmp10_) {
						gchar** _tmp11_;
						gint _tmp11__length1;
						const gchar* _tmp12_;
						gchar* _tmp13_;
						gchar* _tmp14_;
						gchar* _tmp15_;
						_tmp11_ = new_args;
						_tmp11__length1 = new_args_length1;
						_tmp12_ = arg;
						_tmp13_ = g_strconcat ("\"", _tmp12_, NULL);
						_tmp14_ = _tmp13_;
						_tmp15_ = g_strconcat (_tmp14_, "\"", NULL);
						_vala_array_add10 (&new_args, &new_args_length1, &_new_args_size_, _tmp15_);
						_g_free0 (_tmp14_);
					} else {
						gchar** _tmp16_;
						gint _tmp16__length1;
						const gchar* _tmp17_;
						gchar* _tmp18_;
						_tmp16_ = new_args;
						_tmp16__length1 = new_args_length1;
						_tmp17_ = arg;
						_tmp18_ = g_strdup (_tmp17_);
						_vala_array_add11 (&new_args, &new_args_length1, &_new_args_size_, _tmp18_);
					}
					_g_free0 (arg);
				}
			}
		}
		_tmp19_ = new_args;
		_tmp19__length1 = new_args_length1;
		_tmp20_ = (_tmp19_ != NULL) ? _vala_array_dup1 (_tmp19_, _tmp19__length1) : ((gpointer) _tmp19_);
		_tmp20__length1 = _tmp19__length1;
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		args = _tmp20_;
		args_length1 = _tmp20__length1;
		_args_size_ = args_length1;
		new_args = (_vala_array_free (new_args, new_args_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp21_ = self->priv->_on_file;
	_tmp22_ = g_file_get_basename (_tmp21_);
	base_filename = _tmp22_;
	_tmp23_ = base_filename;
	_tmp24_ = utils_get_shortname (_tmp23_);
	base_shortname = _tmp24_;
	_tmp25_ = g_new0 (gchar*, 0 + 1);
	new_args = _tmp25_;
	new_args_length1 = 0;
	_new_args_size_ = new_args_length1;
	_tmp26_ = args;
	_tmp26__length1 = args_length1;
	{
		gchar** arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = _tmp26_;
		arg_collection_length1 = _tmp26__length1;
		for (arg_it = 0; arg_it < _tmp26__length1; arg_it = arg_it + 1) {
			gchar* _tmp27_;
			gchar* arg = NULL;
			_tmp27_ = g_strdup (arg_collection[arg_it]);
			arg = _tmp27_;
			{
				const gchar* _tmp28_;
				gboolean _tmp29_ = FALSE;
				_tmp28_ = arg;
				_tmp29_ = string_contains (_tmp28_, "$filename");
				if (_tmp29_) {
					gchar** _tmp30_;
					gint _tmp30__length1;
					const gchar* _tmp31_;
					const gchar* _tmp32_;
					gchar* _tmp33_ = NULL;
					_tmp30_ = new_args;
					_tmp30__length1 = new_args_length1;
					_tmp31_ = arg;
					_tmp32_ = base_filename;
					_tmp33_ = string_replace (_tmp31_, "$filename", _tmp32_);
					_vala_array_add12 (&new_args, &new_args_length1, &_new_args_size_, _tmp33_);
				} else {
					const gchar* _tmp34_;
					gboolean _tmp35_ = FALSE;
					_tmp34_ = arg;
					_tmp35_ = string_contains (_tmp34_, "$shortname");
					if (_tmp35_) {
						gchar** _tmp36_;
						gint _tmp36__length1;
						const gchar* _tmp37_;
						const gchar* _tmp38_;
						gchar* _tmp39_ = NULL;
						_tmp36_ = new_args;
						_tmp36__length1 = new_args_length1;
						_tmp37_ = arg;
						_tmp38_ = base_shortname;
						_tmp39_ = string_replace (_tmp37_, "$shortname", _tmp38_);
						_vala_array_add13 (&new_args, &new_args_length1, &_new_args_size_, _tmp39_);
					} else {
						const gchar* _tmp40_;
						gboolean _tmp41_ = FALSE;
						_tmp40_ = arg;
						_tmp41_ = string_contains (_tmp40_, "$view");
						if (_tmp41_) {
							gchar** _tmp42_;
							gint _tmp42__length1;
							const gchar* _tmp43_;
							gchar* _tmp44_ = NULL;
							g_warning ("build_job_runner.vala:154: Build job runner: the '$view' placeholder i" \
"s deprecated.");
							_tmp42_ = new_args;
							_tmp42__length1 = new_args_length1;
							_tmp43_ = arg;
							_tmp44_ = string_replace (_tmp43_, "$view", "xdg-open");
							_vala_array_add14 (&new_args, &new_args_length1, &_new_args_size_, _tmp44_);
						} else {
							gchar** _tmp45_;
							gint _tmp45__length1;
							const gchar* _tmp46_;
							gchar* _tmp47_;
							_tmp45_ = new_args;
							_tmp45__length1 = new_args_length1;
							_tmp46_ = arg;
							_tmp47_ = g_strdup (_tmp46_);
							_vala_array_add15 (&new_args, &new_args_length1, &_new_args_size_, _tmp47_);
						}
					}
				}
				_g_free0 (arg);
			}
		}
	}
	_tmp48_ = new_args;
	_tmp48__length1 = new_args_length1;
	if (result_length1) {
		*result_length1 = _tmp48__length1;
	}
	result = _tmp48_;
	_g_free0 (base_shortname);
	_g_free0 (base_filename);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void build_job_runner_create_post_processor (BuildJobRunner* self, gint exit_status) {
	BuildJob _tmp0_;
	PostProcessorType _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_build_job;
	_tmp1_ = _tmp0_.post_processor;
	switch (_tmp1_) {
		case POST_PROCESSOR_TYPE_ALL_OUTPUT:
		{
			AllOutputPostProcessor* _tmp2_;
			_tmp2_ = all_output_post_processor_new ();
			_g_object_unref0 (self->priv->_post_processor);
			self->priv->_post_processor = (PostProcessor*) _tmp2_;
			break;
		}
		case POST_PROCESSOR_TYPE_LATEX:
		{
			LatexPostProcessor* _tmp3_;
			_tmp3_ = latex_post_processor_new ();
			_g_object_unref0 (self->priv->_post_processor);
			self->priv->_post_processor = (PostProcessor*) _tmp3_;
			break;
		}
		case POST_PROCESSOR_TYPE_LATEXMK:
		{
			gint _tmp4_;
			LatexmkPostProcessor* _tmp5_;
			_tmp4_ = exit_status;
			_tmp5_ = latexmk_post_processor_new (_tmp4_);
			_g_object_unref0 (self->priv->_post_processor);
			self->priv->_post_processor = (PostProcessor*) _tmp5_;
			break;
		}
		case POST_PROCESSOR_TYPE_NO_OUTPUT:
		{
			NoOutputPostProcessor* _tmp6_;
			_tmp6_ = no_output_post_processor_new ();
			_g_object_unref0 (self->priv->_post_processor);
			self->priv->_post_processor = (PostProcessor*) _tmp6_;
			break;
		}
		case POST_PROCESSOR_TYPE_RUBBER:
		{
			RubberPostProcessor* _tmp7_;
			_tmp7_ = rubber_post_processor_new ();
			_g_object_unref0 (self->priv->_post_processor);
			self->priv->_post_processor = (PostProcessor*) _tmp7_;
			break;
		}
		default:
		{
			NoOutputPostProcessor* _tmp8_;
			g_warning ("build_job_runner.vala:190: Unknown post processor. Use no-output.");
			_tmp8_ = no_output_post_processor_new ();
			_g_object_unref0 (self->priv->_post_processor);
			self->priv->_post_processor = (PostProcessor*) _tmp8_;
			break;
		}
	}
}


static void build_job_runner_class_init (BuildJobRunnerClass * klass) {
	build_job_runner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BuildJobRunnerPrivate));
	G_OBJECT_CLASS (klass)->finalize = build_job_runner_finalize;
	g_signal_new ("finished", TYPE_BUILD_JOB_RUNNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}


static void build_job_runner_instance_init (BuildJobRunner * self) {
	self->priv = BUILD_JOB_RUNNER_GET_PRIVATE (self);
	self->priv->_command_runner = NULL;
	self->priv->_post_processor = NULL;
}


static void build_job_runner_finalize (GObject* obj) {
	BuildJobRunner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BUILD_JOB_RUNNER, BuildJobRunner);
	build_job_destroy (&self->priv->_build_job);
	_g_object_unref0 (self->priv->_on_file);
	_g_object_unref0 (self->priv->_command_runner);
	_g_object_unref0 (self->priv->_post_processor);
	G_OBJECT_CLASS (build_job_runner_parent_class)->finalize (obj);
}


GType build_job_runner_get_type (void) {
	static volatile gsize build_job_runner_type_id__volatile = 0;
	if (g_once_init_enter (&build_job_runner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BuildJobRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) build_job_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuildJobRunner), 0, (GInstanceInitFunc) build_job_runner_instance_init, NULL };
		GType build_job_runner_type_id;
		build_job_runner_type_id = g_type_register_static (G_TYPE_OBJECT, "BuildJobRunner", &g_define_type_info, 0);
		g_once_init_leave (&build_job_runner_type_id__volatile, build_job_runner_type_id);
	}
	return build_job_runner_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



