/* search.c generated by valac 0.14.0.77-0077, the Vala compiler
 * generated from search.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gtksourceview/gtksourceview.h>
#include <float.h>
#include <math.h>
#include "config.h"


#define TYPE_GOTO_LINE (goto_line_get_type ())
#define GOTO_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GOTO_LINE, GotoLine))
#define GOTO_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GOTO_LINE, GotoLineClass))
#define IS_GOTO_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GOTO_LINE))
#define IS_GOTO_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GOTO_LINE))
#define GOTO_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GOTO_LINE, GotoLineClass))

typedef struct _GotoLine GotoLine;
typedef struct _GotoLineClass GotoLineClass;
typedef struct _GotoLinePrivate GotoLinePrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_SEARCH_AND_REPLACE (search_and_replace_get_type ())
#define SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplace))
#define SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))
#define IS_SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_AND_REPLACE))
#define IS_SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_AND_REPLACE))
#define SEARCH_AND_REPLACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))

typedef struct _SearchAndReplace SearchAndReplace;
typedef struct _SearchAndReplaceClass SearchAndReplaceClass;
typedef struct _SearchAndReplacePrivate SearchAndReplacePrivate;
typedef struct _Block11Data Block11Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_SELECTION_TYPE (selection_type_get_type ())

struct _GotoLine {
	GtkHBox parent_instance;
	GotoLinePrivate * priv;
};

struct _GotoLineClass {
	GtkHBoxClass parent_class;
};

struct _GotoLinePrivate {
	MainWindow* main_window;
	GtkEntry* entry;
};

struct _SearchAndReplace {
	GObject parent_instance;
	SearchAndReplacePrivate * priv;
};

struct _SearchAndReplaceClass {
	GObjectClass parent_class;
};

struct _SearchAndReplacePrivate {
	MainWindow* main_window;
	Document* working_document;
	GtkWidget* widget;
	GtkButton* button_arrow;
	GtkArrow* arrow;
	GtkEntry* entry_find;
	GtkLabel* label_find_normal;
	GtkLabel* label_find_error;
	GtkEntry* entry_replace;
	GtkFrame* frame_replace;
	GtkHBox* hbox_replace;
	GtkCheckMenuItem* check_case_sensitive;
	GtkCheckMenuItem* check_entire_word;
	gint min_nb_chars_for_incremental_search;
};

struct _Block11Data {
	int _ref_count_;
	SearchAndReplace * self;
	GtkButton* button_clear_find;
	GtkButton* button_clear_replace;
	GtkButton* button_replace;
	GtkButton* button_replace_all;
	GtkButton* button_previous;
	GtkButton* button_next;
	GtkMenu* menu;
};

typedef enum  {
	SELECTION_TYPE_NO_SELECTION,
	SELECTION_TYPE_ONE_LINE,
	SELECTION_TYPE_MULTIPLE_LINES
} SelectionType;


static gpointer goto_line_parent_class = NULL;
static gpointer search_and_replace_parent_class = NULL;

GType goto_line_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
#define GOTO_LINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GOTO_LINE, GotoLinePrivate))
enum  {
	GOTO_LINE_DUMMY_PROPERTY
};
GotoLine* goto_line_new (MainWindow* main_window);
GotoLine* goto_line_construct (GType object_type, MainWindow* main_window);
static void __lambda52_ (GotoLine* self);
static void ___lambda52__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda53_ (GotoLine* self);
static void ___lambda53__gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void __lambda54_ (GotoLine* self);
static void ___lambda54__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
static void goto_line_on_changed (GotoLine* self);
static void _goto_line_on_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
void goto_line_show (GotoLine* self);
void utils_set_entry_error (GtkWidget* entry, gboolean _error_);
GType document_get_type (void) G_GNUC_CONST;
Document* main_window_get_active_document (MainWindow* self);
gboolean document_goto_line (Document* self, gint line);
GType document_view_get_type (void) G_GNUC_CONST;
DocumentView* main_window_get_active_view (MainWindow* self);
void document_view_scroll_to_cursor (DocumentView* self, gdouble margin);
static void goto_line_finalize (GObject* obj);
GType search_and_replace_get_type (void) G_GNUC_CONST;
#define SEARCH_AND_REPLACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SEARCH_AND_REPLACE, SearchAndReplacePrivate))
enum  {
	SEARCH_AND_REPLACE_DUMMY_PROPERTY
};
SearchAndReplace* search_and_replace_new (MainWindow* main_window);
SearchAndReplace* search_and_replace_construct (GType object_type, MainWindow* main_window);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (Block11Data* _data11_);
static void ___lambda55_ (Block11Data* _data11_, GtkEntryIconPosition icon_pos, GdkEvent* event);
static void ____lambda55__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
static void ___lambda56_ (SearchAndReplace* self);
static gboolean search_and_replace_get_search_and_replace_mode (SearchAndReplace* self);
static void ____lambda56__gtk_button_clicked (GtkButton* _sender, gpointer self);
void search_and_replace_hide (SearchAndReplace* self);
static void _search_and_replace_hide_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda57_ (SearchAndReplace* self);
static void ____lambda57__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda58_ (SearchAndReplace* self);
static void ____lambda58__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda59_ (SearchAndReplace* self);
static void search_and_replace_set_search_text (SearchAndReplace* self, gboolean select);
void document_search_backward (Document* self);
static void ____lambda59__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void search_and_replace_search_forward (SearchAndReplace* self);
static void _search_and_replace_search_forward_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _search_and_replace_search_forward_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void ___lambda60_ (Block11Data* _data11_);
static void search_and_replace_clear_search (SearchAndReplace* self);
static void ____lambda60__gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void ___lambda61_ (Block11Data* _data11_);
static void ____lambda61__gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void ___lambda62_ (SearchAndReplace* self);
static void ____lambda62__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void ___lambda63_ (SearchAndReplace* self);
static void ____lambda63__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self);
static void search_and_replace_replace (SearchAndReplace* self);
static void _search_and_replace_replace_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _search_and_replace_replace_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void ___lambda65_ (SearchAndReplace* self);
void document_replace_all (Document* self, const gchar* text);
static void ____lambda65__gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean ___lambda66_ (SearchAndReplace* self, GdkEventKey* event);
void search_and_replace_show_search_and_replace (SearchAndReplace* self);
static void search_and_replace_select_selected_search_text (SearchAndReplace* self);
static gboolean ____lambda66__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
GtkWidget* search_and_replace_get_widget (SearchAndReplace* self);
void search_and_replace_show_search (SearchAndReplace* self);
static void search_and_replace_show (SearchAndReplace* self);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_get_active_tab (MainWindow* self);
static void search_and_replace_set_replace_sensitivity (SearchAndReplace* self);
GType selection_type_get_type (void) G_GNUC_CONST;
SelectionType document_get_selection_type (Document* self);
static void search_and_replace_active_document_changed (SearchAndReplace* self);
static void _search_and_replace_active_document_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void search_and_replace_set_label_text (SearchAndReplace* self, const gchar* text, gboolean _error_);
static void search_and_replace_on_search_info_updated (SearchAndReplace* self, gboolean selected, guint nb_matches, guint num_match);
static void _search_and_replace_on_search_info_updated_document_search_info_updated (Document* _sender, gboolean selected, guint nb_matches, guint num_match, gpointer self);
void document_set_search_text (Document* self, const gchar* text, gboolean case_sensitive, gboolean entire_word, guint* nb_matches, guint* num_match, gboolean select);
static gboolean search_and_replace_get_case_sensitive (SearchAndReplace* self);
static gboolean search_and_replace_get_entire_word (SearchAndReplace* self);
void document_select_selected_search_text (Document* self);
void document_search_forward (Document* self);
void document_clear_search (Document* self, gboolean disconnect_signals);
gboolean document_get_readonly (Document* self);
void document_replace (Document* self, const gchar* text);
static void search_and_replace_finalize (GObject* obj);
static void _vala_search_and_replace_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static void __lambda52_ (GotoLine* self) {
	gtk_widget_hide ((GtkWidget*) self);
}


static void ___lambda52__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda52_ (self);
}


static void __lambda53_ (GotoLine* self) {
	gtk_widget_hide ((GtkWidget*) self);
}


static void ___lambda53__gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	__lambda53_ (self);
}


static void __lambda54_ (GotoLine* self) {
	gtk_widget_hide ((GtkWidget*) self);
}


static void ___lambda54__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	__lambda54_ (self);
}


static void _goto_line_on_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	goto_line_on_changed (self);
}


GotoLine* goto_line_construct (GType object_type, MainWindow* main_window) {
	GotoLine * self = NULL;
	MainWindow* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* close_button;
	GtkImage* _tmp3_;
	GtkImage* _tmp4_;
	GtkImage* img;
	const gchar* _tmp5_ = NULL;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* label;
	GtkEntry* _tmp8_;
	GtkEntry* _tmp9_;
	GtkEntry* _tmp10_;
	GtkEntry* _tmp11_;
	GtkEntry* _tmp12_;
	GtkEntry* _tmp13_;
	const gchar* _tmp14_ = NULL;
	GtkEntry* _tmp15_;
	GtkEntry* _tmp16_;
	GtkEntry* _tmp17_;
	GtkEntry* _tmp18_;
	g_return_val_if_fail (main_window != NULL, NULL);
	self = (GotoLine*) g_object_new (object_type, NULL);
	_tmp0_ = main_window;
	self->priv->main_window = _tmp0_;
	gtk_box_set_spacing ((GtkBox*) self, 3);
	_tmp1_ = (GtkButton*) gtk_button_new ();
	_tmp2_ = g_object_ref_sink (_tmp1_);
	close_button = _tmp2_;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) close_button, FALSE, FALSE, (guint) 0);
	gtk_button_set_relief (close_button, GTK_RELIEF_NONE);
	_tmp3_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLOSE, GTK_ICON_SIZE_MENU);
	_tmp4_ = g_object_ref_sink (_tmp3_);
	img = _tmp4_;
	gtk_container_add ((GtkContainer*) close_button, (GtkWidget*) img);
	g_signal_connect_object (close_button, "clicked", (GCallback) ___lambda52__gtk_button_clicked, self, 0);
	_tmp5_ = _ ("Go to Line:");
	_tmp6_ = (GtkLabel*) gtk_label_new (_tmp5_);
	_tmp7_ = g_object_ref_sink (_tmp6_);
	label = _tmp7_;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) label, FALSE, FALSE, (guint) 2);
	_tmp8_ = (GtkEntry*) gtk_entry_new ();
	_tmp9_ = g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->entry);
	self->priv->entry = _tmp9_;
	_tmp10_ = self->priv->entry;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp10_, FALSE, FALSE, (guint) 0);
	_tmp11_ = self->priv->entry;
	gtk_entry_set_icon_from_stock (_tmp11_, GTK_ENTRY_ICON_SECONDARY, GTK_STOCK_JUMP_TO);
	_tmp12_ = self->priv->entry;
	gtk_entry_set_icon_activatable (_tmp12_, GTK_ENTRY_ICON_SECONDARY, TRUE);
	_tmp13_ = self->priv->entry;
	_tmp14_ = _ ("Line you want to move the cursor to");
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp13_, _tmp14_);
	_tmp15_ = self->priv->entry;
	gtk_widget_set_size_request ((GtkWidget*) _tmp15_, 100, -1);
	_tmp16_ = self->priv->entry;
	g_signal_connect_object (_tmp16_, "activate", (GCallback) ___lambda53__gtk_entry_activate, self, 0);
	_tmp17_ = self->priv->entry;
	g_signal_connect_object (_tmp17_, "icon-press", (GCallback) ___lambda54__gtk_entry_icon_press, self, 0);
	_tmp18_ = self->priv->entry;
	g_signal_connect_object ((GtkEditable*) _tmp18_, "changed", (GCallback) _goto_line_on_changed_gtk_editable_changed, self, 0);
	_g_object_unref0 (label);
	_g_object_unref0 (img);
	_g_object_unref0 (close_button);
	return self;
}


GotoLine* goto_line_new (MainWindow* main_window) {
	return goto_line_construct (TYPE_GOTO_LINE, main_window);
}


void goto_line_show (GotoLine* self) {
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entry;
	gtk_entry_set_text (_tmp0_, "");
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp1_ = self->priv->entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void goto_line_on_changed (GotoLine* self) {
	GtkEntry* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	GtkEntry* _tmp4_;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* text;
	const gchar* _tmp20_;
	gint _tmp21_ = 0;
	gint line;
	MainWindow* _tmp22_;
	Document* _tmp23_;
	Document* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	gboolean _tmp27_ = FALSE;
	gboolean _error_;
	GtkEntry* _tmp28_;
	gboolean _tmp29_;
	MainWindow* _tmp30_;
	DocumentView* _tmp31_;
	DocumentView* _tmp32_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entry;
	_tmp1_ = gtk_entry_get_text_length (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == ((guint) 0)) {
		GtkEntry* _tmp3_;
		_tmp3_ = self->priv->entry;
		utils_set_entry_error ((GtkWidget*) _tmp3_, FALSE);
		return;
	}
	_tmp4_ = self->priv->entry;
	_tmp5_ = gtk_entry_get_text (_tmp4_);
	_tmp6_ = g_strdup (_tmp5_);
	text = _tmp6_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_;
				gint _tmp10_;
				const gchar* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				const gchar* _tmp14_;
				gint _tmp15_;
				gchar _tmp16_ = '\0';
				gunichar c;
				gunichar _tmp17_;
				gboolean _tmp18_ = FALSE;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp10_ = i;
				_tmp11_ = text;
				_tmp12_ = strlen (_tmp11_);
				_tmp13_ = _tmp12_;
				if (!(_tmp10_ < _tmp13_)) {
					break;
				}
				_tmp14_ = text;
				_tmp15_ = i;
				_tmp16_ = string_get (_tmp14_, (glong) _tmp15_);
				c = (gunichar) _tmp16_;
				_tmp17_ = c;
				_tmp18_ = g_unichar_isdigit (_tmp17_);
				if (!_tmp18_) {
					GtkEntry* _tmp19_;
					_tmp19_ = self->priv->entry;
					utils_set_entry_error ((GtkWidget*) _tmp19_, TRUE);
					_g_free0 (text);
					return;
				}
			}
		}
	}
	_tmp20_ = text;
	_tmp21_ = atoi (_tmp20_);
	line = _tmp21_;
	_tmp22_ = self->priv->main_window;
	_tmp23_ = main_window_get_active_document (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = line;
	line = _tmp25_ - 1;
	_tmp26_ = line;
	_tmp27_ = document_goto_line (_tmp24_, _tmp26_);
	_error_ = !_tmp27_;
	_tmp28_ = self->priv->entry;
	_tmp29_ = _error_;
	utils_set_entry_error ((GtkWidget*) _tmp28_, _tmp29_);
	_tmp30_ = self->priv->main_window;
	_tmp31_ = main_window_get_active_view (_tmp30_);
	_tmp32_ = _tmp31_;
	document_view_scroll_to_cursor (_tmp32_, 0.25);
	_g_free0 (text);
}


static void goto_line_class_init (GotoLineClass * klass) {
	goto_line_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GotoLinePrivate));
	G_OBJECT_CLASS (klass)->finalize = goto_line_finalize;
}


static void goto_line_instance_init (GotoLine * self) {
	self->priv = GOTO_LINE_GET_PRIVATE (self);
}


static void goto_line_finalize (GObject* obj) {
	GotoLine * self;
	self = GOTO_LINE (obj);
	_g_object_unref0 (self->priv->entry);
	G_OBJECT_CLASS (goto_line_parent_class)->finalize (obj);
}


GType goto_line_get_type (void) {
	static volatile gsize goto_line_type_id__volatile = 0;
	if (g_once_init_enter (&goto_line_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GotoLineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) goto_line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GotoLine), 0, (GInstanceInitFunc) goto_line_instance_init, NULL };
		GType goto_line_type_id;
		goto_line_type_id = g_type_register_static (GTK_TYPE_HBOX, "GotoLine", &g_define_type_info, 0);
		g_once_init_leave (&goto_line_type_id__volatile, goto_line_type_id);
	}
	return goto_line_type_id__volatile;
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void block11_data_unref (Block11Data* _data11_) {
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		SearchAndReplace * self;
		self = _data11_->self;
		_g_object_unref0 (_data11_->menu);
		_g_object_unref0 (_data11_->button_next);
		_g_object_unref0 (_data11_->button_previous);
		_g_object_unref0 (_data11_->button_replace_all);
		_g_object_unref0 (_data11_->button_replace);
		_g_object_unref0 (_data11_->button_clear_replace);
		_g_object_unref0 (_data11_->button_clear_find);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void ___lambda55_ (Block11Data* _data11_, GtkEntryIconPosition icon_pos, GdkEvent* event) {
	SearchAndReplace * self;
	GtkEntryIconPosition _tmp0_;
	self = _data11_->self;
	g_return_if_fail (event != NULL);
	_tmp0_ = icon_pos;
	if (_tmp0_ == GTK_ENTRY_ICON_PRIMARY) {
		GtkMenu* _tmp1_;
		GdkEvent* _tmp2_;
		GdkEventButton _tmp3_;
		guint _tmp4_;
		GdkEvent* _tmp5_;
		GdkEventButton _tmp6_;
		guint32 _tmp7_;
		_tmp1_ = _data11_->menu;
		_tmp2_ = event;
		_tmp3_ = _tmp2_->button;
		_tmp4_ = _tmp3_.button;
		_tmp5_ = event;
		_tmp6_ = _tmp5_->button;
		_tmp7_ = _tmp6_.time;
		gtk_menu_popup (_tmp1_, NULL, NULL, NULL, NULL, _tmp4_, _tmp7_);
	}
}


static void ____lambda55__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	___lambda55_ (self, p0, p1);
}


static void ___lambda56_ (SearchAndReplace* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	_tmp0_ = search_and_replace_get_search_and_replace_mode (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GtkArrow* _tmp2_;
		GtkFrame* _tmp3_;
		GtkHBox* _tmp4_;
		_tmp2_ = self->priv->arrow;
		g_object_set (_tmp2_, "arrow-type", GTK_ARROW_DOWN, NULL);
		_tmp3_ = self->priv->frame_replace;
		gtk_widget_hide ((GtkWidget*) _tmp3_);
		_tmp4_ = self->priv->hbox_replace;
		gtk_widget_hide ((GtkWidget*) _tmp4_);
	} else {
		GtkArrow* _tmp5_;
		GtkFrame* _tmp6_;
		GtkHBox* _tmp7_;
		_tmp5_ = self->priv->arrow;
		g_object_set (_tmp5_, "arrow-type", GTK_ARROW_UP, NULL);
		_tmp6_ = self->priv->frame_replace;
		gtk_widget_show ((GtkWidget*) _tmp6_);
		_tmp7_ = self->priv->hbox_replace;
		gtk_widget_show ((GtkWidget*) _tmp7_);
	}
}


static void ____lambda56__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda56_ (self);
}


static void _search_and_replace_hide_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	search_and_replace_hide (self);
}


static void ___lambda57_ (SearchAndReplace* self) {
	GtkEntry* _tmp0_;
	_tmp0_ = self->priv->entry_find;
	gtk_entry_set_text (_tmp0_, "");
}


static void ____lambda57__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda57_ (self);
}


static void ___lambda58_ (SearchAndReplace* self) {
	GtkEntry* _tmp0_;
	_tmp0_ = self->priv->entry_replace;
	gtk_entry_set_text (_tmp0_, "");
}


static void ____lambda58__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda58_ (self);
}


static void ___lambda59_ (SearchAndReplace* self) {
	Document* _tmp0_;
	Document* _tmp1_;
	search_and_replace_set_search_text (self, FALSE);
	_tmp0_ = self->priv->working_document;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->working_document;
	document_search_backward (_tmp1_);
}


static void ____lambda59__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda59_ (self);
}


static void _search_and_replace_search_forward_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	search_and_replace_search_forward (self);
}


static void _search_and_replace_search_forward_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	search_and_replace_search_forward (self);
}


static void ___lambda60_ (Block11Data* _data11_) {
	SearchAndReplace * self;
	GtkEntry* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gboolean sensitive;
	GtkButton* _tmp3_;
	gboolean _tmp4_;
	GtkButton* _tmp5_;
	gboolean _tmp6_;
	GtkButton* _tmp7_;
	gboolean _tmp8_;
	GtkButton* _tmp9_;
	gboolean _tmp10_;
	GtkButton* _tmp11_;
	gboolean _tmp12_;
	GtkEntry* _tmp13_;
	guint _tmp14_;
	guint _tmp15_;
	self = _data11_->self;
	_tmp0_ = self->priv->entry_find;
	_tmp1_ = gtk_entry_get_text_length (_tmp0_);
	_tmp2_ = _tmp1_;
	sensitive = _tmp2_ > ((guint) 0);
	_tmp3_ = _data11_->button_clear_find;
	_tmp4_ = sensitive;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, _tmp4_);
	_tmp5_ = _data11_->button_previous;
	_tmp6_ = sensitive;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, _tmp6_);
	_tmp7_ = _data11_->button_next;
	_tmp8_ = sensitive;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, _tmp8_);
	_tmp9_ = _data11_->button_replace;
	_tmp10_ = sensitive;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, _tmp10_);
	_tmp11_ = _data11_->button_replace_all;
	_tmp12_ = sensitive;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, _tmp12_);
	_tmp13_ = self->priv->entry_find;
	_tmp14_ = gtk_entry_get_text_length (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_ == ((guint) 0)) {
		GtkLabel* _tmp16_;
		GtkLabel* _tmp17_;
		_tmp16_ = self->priv->label_find_normal;
		gtk_widget_hide ((GtkWidget*) _tmp16_);
		_tmp17_ = self->priv->label_find_error;
		gtk_widget_hide ((GtkWidget*) _tmp17_);
		search_and_replace_clear_search (self);
	} else {
		GtkEntry* _tmp18_;
		guint _tmp19_;
		guint _tmp20_;
		gint _tmp21_;
		_tmp18_ = self->priv->entry_find;
		_tmp19_ = gtk_entry_get_text_length (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = self->priv->min_nb_chars_for_incremental_search;
		if (_tmp20_ >= ((guint) _tmp21_)) {
			search_and_replace_set_search_text (self, TRUE);
		}
	}
}


static void ____lambda60__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	___lambda60_ (self);
}


static void ___lambda61_ (Block11Data* _data11_) {
	SearchAndReplace * self;
	GtkButton* _tmp0_;
	GtkEntry* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	self = _data11_->self;
	_tmp0_ = _data11_->button_clear_replace;
	_tmp1_ = self->priv->entry_replace;
	_tmp2_ = gtk_entry_get_text_length (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp3_ > ((guint) 0));
}


static void ____lambda61__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	___lambda61_ (self);
}


static void ___lambda62_ (SearchAndReplace* self) {
	search_and_replace_set_search_text (self, TRUE);
}


static void ____lambda62__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	___lambda62_ (self);
}


static void ___lambda63_ (SearchAndReplace* self) {
	search_and_replace_set_search_text (self, TRUE);
}


static void ____lambda63__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender, gpointer self) {
	___lambda63_ (self);
}


static void _search_and_replace_replace_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	search_and_replace_replace (self);
}


static void _search_and_replace_replace_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	search_and_replace_replace (self);
}


static void ___lambda65_ (SearchAndReplace* self) {
	GtkEntry* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	Document* _tmp3_;
	GtkEntry* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	_tmp0_ = self->priv->entry_find;
	_tmp1_ = gtk_entry_get_text_length (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != ((guint) 0));
	search_and_replace_set_search_text (self, TRUE);
	_tmp3_ = self->priv->working_document;
	_tmp4_ = self->priv->entry_replace;
	_tmp5_ = gtk_entry_get_text (_tmp4_);
	_tmp6_ = _tmp5_;
	document_replace_all (_tmp3_, _tmp6_);
}


static void ____lambda65__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda65_ (self);
}


static gboolean ___lambda66_ (SearchAndReplace* self, GdkEventKey* event) {
	gboolean result = FALSE;
	GdkEventKey _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.keyval;
	switch (_tmp1_) {
		case 0xff09:
		{
			GtkEntry* _tmp2_;
			search_and_replace_show_search_and_replace (self);
			_tmp2_ = self->priv->entry_replace;
			gtk_widget_grab_focus ((GtkWidget*) _tmp2_);
			result = TRUE;
			return result;
		}
		case 0xff1b:
		{
			search_and_replace_select_selected_search_text (self);
			search_and_replace_hide (self);
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static gboolean ____lambda66__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = ___lambda66_ (self, event);
	return result;
}


SearchAndReplace* search_and_replace_construct (GType object_type, MainWindow* main_window) {
	SearchAndReplace * self = NULL;
	MainWindow* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* path;
	GtkWidget* _tmp83_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (main_window != NULL, NULL);
	self = (SearchAndReplace*) g_object_new (object_type, NULL);
	_tmp0_ = main_window;
	self->priv->main_window = _tmp0_;
	_tmp1_ = g_build_filename (DATA_DIR, "ui", "search_and_replace.ui", NULL);
	path = _tmp1_;
	{
		Block11Data* _data11_;
		GtkBuilder* _tmp2_;
		GtkBuilder* builder;
		GObject* _tmp3_ = NULL;
		GtkWidget* _tmp4_;
		GtkWidget* _tmp5_;
		GObject* _tmp6_ = NULL;
		GtkButton* _tmp7_;
		GObject* _tmp8_ = NULL;
		GtkArrow* _tmp9_;
		GObject* _tmp10_ = NULL;
		GtkEntry* _tmp11_;
		GObject* _tmp12_ = NULL;
		GtkLabel* _tmp13_;
		GObject* _tmp14_ = NULL;
		GtkLabel* _tmp15_;
		GObject* _tmp16_ = NULL;
		GtkEventBox* _tmp17_;
		GtkEventBox* eventbox_label1;
		GObject* _tmp18_ = NULL;
		GtkEventBox* _tmp19_;
		GtkEventBox* eventbox_label2;
		GObject* _tmp20_ = NULL;
		GtkButton* _tmp21_;
		GObject* _tmp22_ = NULL;
		GtkEntry* _tmp23_;
		GObject* _tmp24_ = NULL;
		GtkFrame* _tmp25_;
		GObject* _tmp26_ = NULL;
		GtkButton* _tmp27_;
		GObject* _tmp28_ = NULL;
		GtkButton* _tmp29_;
		GObject* _tmp30_ = NULL;
		GtkButton* _tmp31_;
		GObject* _tmp32_ = NULL;
		GtkHBox* _tmp33_;
		GObject* _tmp34_ = NULL;
		GtkButton* _tmp35_;
		GObject* _tmp36_ = NULL;
		GtkButton* _tmp37_;
		GObject* _tmp38_ = NULL;
		GtkButton* _tmp39_;
		GtkButton* button_close;
		GdkColor white = {0};
		GdkColor _tmp40_ = {0};
		GtkEventBox* _tmp41_;
		GdkColor _tmp42_;
		GtkEventBox* _tmp43_;
		GdkColor _tmp44_;
		GtkMenu* _tmp45_;
		GtkMenu* _tmp46_;
		const gchar* _tmp47_ = NULL;
		GtkCheckMenuItem* _tmp48_;
		GtkCheckMenuItem* _tmp49_;
		const gchar* _tmp50_ = NULL;
		GtkCheckMenuItem* _tmp51_;
		GtkCheckMenuItem* _tmp52_;
		GtkMenu* _tmp53_;
		GtkCheckMenuItem* _tmp54_;
		GtkMenu* _tmp55_;
		GtkCheckMenuItem* _tmp56_;
		GtkMenu* _tmp57_;
		GtkEntry* _tmp58_;
		GtkButton* _tmp59_;
		GtkButton* _tmp60_;
		GtkButton* _tmp61_;
		GtkButton* _tmp62_;
		GtkButton* _tmp63_;
		GtkButton* _tmp64_;
		GtkEntry* _tmp65_;
		GtkEntry* _tmp66_;
		GtkEntry* _tmp67_;
		GtkCheckMenuItem* _tmp68_;
		GtkCheckMenuItem* _tmp69_;
		GtkButton* _tmp70_;
		GtkEntry* _tmp71_;
		GtkButton* _tmp72_;
		GtkEntry* _tmp73_;
		_data11_ = g_slice_new0 (Block11Data);
		_data11_->_ref_count_ = 1;
		_data11_->self = g_object_ref (self);
		_tmp2_ = gtk_builder_new ();
		builder = _tmp2_;
		gtk_builder_add_from_file (builder, path, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (builder);
			block11_data_unref (_data11_);
			_data11_ = NULL;
			goto __catch33_g_error;
		}
		_tmp3_ = gtk_builder_get_object (builder, "search_and_replace");
		_tmp4_ = _g_object_ref0 (GTK_WIDGET (_tmp3_));
		_g_object_unref0 (self->priv->widget);
		self->priv->widget = _tmp4_;
		_tmp5_ = self->priv->widget;
		gtk_widget_unparent (_tmp5_);
		_tmp6_ = gtk_builder_get_object (builder, "button_arrow");
		_tmp7_ = _g_object_ref0 (GTK_BUTTON (_tmp6_));
		_g_object_unref0 (self->priv->button_arrow);
		self->priv->button_arrow = _tmp7_;
		_tmp8_ = gtk_builder_get_object (builder, "arrow");
		_tmp9_ = _g_object_ref0 (GTK_ARROW (_tmp8_));
		_g_object_unref0 (self->priv->arrow);
		self->priv->arrow = _tmp9_;
		_tmp10_ = gtk_builder_get_object (builder, "entry_find");
		_tmp11_ = _g_object_ref0 (GTK_ENTRY (_tmp10_));
		_g_object_unref0 (self->priv->entry_find);
		self->priv->entry_find = _tmp11_;
		_tmp12_ = gtk_builder_get_object (builder, "label_find_normal");
		_tmp13_ = _g_object_ref0 (GTK_LABEL (_tmp12_));
		_g_object_unref0 (self->priv->label_find_normal);
		self->priv->label_find_normal = _tmp13_;
		_tmp14_ = gtk_builder_get_object (builder, "label_find_error");
		_tmp15_ = _g_object_ref0 (GTK_LABEL (_tmp14_));
		_g_object_unref0 (self->priv->label_find_error);
		self->priv->label_find_error = _tmp15_;
		_tmp16_ = gtk_builder_get_object (builder, "eventbox_label1");
		_tmp17_ = _g_object_ref0 (GTK_EVENT_BOX (_tmp16_));
		eventbox_label1 = _tmp17_;
		_tmp18_ = gtk_builder_get_object (builder, "eventbox_label2");
		_tmp19_ = _g_object_ref0 (GTK_EVENT_BOX (_tmp18_));
		eventbox_label2 = _tmp19_;
		_tmp20_ = gtk_builder_get_object (builder, "button_clear_find");
		_tmp21_ = _g_object_ref0 (GTK_BUTTON (_tmp20_));
		_data11_->button_clear_find = _tmp21_;
		_tmp22_ = gtk_builder_get_object (builder, "entry_replace");
		_tmp23_ = _g_object_ref0 (GTK_ENTRY (_tmp22_));
		_g_object_unref0 (self->priv->entry_replace);
		self->priv->entry_replace = _tmp23_;
		_tmp24_ = gtk_builder_get_object (builder, "frame_replace");
		_tmp25_ = _g_object_ref0 (GTK_FRAME (_tmp24_));
		_g_object_unref0 (self->priv->frame_replace);
		self->priv->frame_replace = _tmp25_;
		_tmp26_ = gtk_builder_get_object (builder, "button_clear_replace");
		_tmp27_ = _g_object_ref0 (GTK_BUTTON (_tmp26_));
		_data11_->button_clear_replace = _tmp27_;
		_tmp28_ = gtk_builder_get_object (builder, "button_replace");
		_tmp29_ = _g_object_ref0 (GTK_BUTTON (_tmp28_));
		_data11_->button_replace = _tmp29_;
		_tmp30_ = gtk_builder_get_object (builder, "button_replace_all");
		_tmp31_ = _g_object_ref0 (GTK_BUTTON (_tmp30_));
		_data11_->button_replace_all = _tmp31_;
		_tmp32_ = gtk_builder_get_object (builder, "hbox_replace");
		_tmp33_ = _g_object_ref0 (GTK_HBOX (_tmp32_));
		_g_object_unref0 (self->priv->hbox_replace);
		self->priv->hbox_replace = _tmp33_;
		_tmp34_ = gtk_builder_get_object (builder, "button_previous");
		_tmp35_ = _g_object_ref0 (GTK_BUTTON (_tmp34_));
		_data11_->button_previous = _tmp35_;
		_tmp36_ = gtk_builder_get_object (builder, "button_next");
		_tmp37_ = _g_object_ref0 (GTK_BUTTON (_tmp36_));
		_data11_->button_next = _tmp37_;
		_tmp38_ = gtk_builder_get_object (builder, "button_close");
		_tmp39_ = _g_object_ref0 (GTK_BUTTON (_tmp38_));
		button_close = _tmp39_;
		gdk_color_parse ("white", &_tmp40_);
		white = _tmp40_;
		_tmp41_ = eventbox_label1;
		_tmp42_ = white;
		gtk_widget_modify_bg ((GtkWidget*) _tmp41_, GTK_STATE_NORMAL, &_tmp42_);
		_tmp43_ = eventbox_label2;
		_tmp44_ = white;
		gtk_widget_modify_bg ((GtkWidget*) _tmp43_, GTK_STATE_NORMAL, &_tmp44_);
		_tmp45_ = (GtkMenu*) gtk_menu_new ();
		_tmp46_ = g_object_ref_sink (_tmp45_);
		_data11_->menu = _tmp46_;
		_tmp47_ = _ ("Case sensitive");
		_tmp48_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_tmp47_);
		_tmp49_ = g_object_ref_sink (_tmp48_);
		_g_object_unref0 (self->priv->check_case_sensitive);
		self->priv->check_case_sensitive = _tmp49_;
		_tmp50_ = _ ("Entire words only");
		_tmp51_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_tmp50_);
		_tmp52_ = g_object_ref_sink (_tmp51_);
		_g_object_unref0 (self->priv->check_entire_word);
		self->priv->check_entire_word = _tmp52_;
		_tmp53_ = _data11_->menu;
		_tmp54_ = self->priv->check_case_sensitive;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp53_, (GtkWidget*) ((GtkMenuItem*) _tmp54_));
		_tmp55_ = _data11_->menu;
		_tmp56_ = self->priv->check_entire_word;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp55_, (GtkWidget*) ((GtkMenuItem*) _tmp56_));
		_tmp57_ = _data11_->menu;
		gtk_widget_show_all ((GtkWidget*) _tmp57_);
		_tmp58_ = self->priv->entry_find;
		g_signal_connect_data (_tmp58_, "icon-press", (GCallback) ____lambda55__gtk_entry_icon_press, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
		_tmp59_ = self->priv->button_arrow;
		g_signal_connect_object (_tmp59_, "clicked", (GCallback) ____lambda56__gtk_button_clicked, self, 0);
		_tmp60_ = button_close;
		g_signal_connect_object (_tmp60_, "clicked", (GCallback) _search_and_replace_hide_gtk_button_clicked, self, 0);
		_tmp61_ = _data11_->button_clear_find;
		g_signal_connect_object (_tmp61_, "clicked", (GCallback) ____lambda57__gtk_button_clicked, self, 0);
		_tmp62_ = _data11_->button_clear_replace;
		g_signal_connect_object (_tmp62_, "clicked", (GCallback) ____lambda58__gtk_button_clicked, self, 0);
		_tmp63_ = _data11_->button_previous;
		g_signal_connect_object (_tmp63_, "clicked", (GCallback) ____lambda59__gtk_button_clicked, self, 0);
		_tmp64_ = _data11_->button_next;
		g_signal_connect_object (_tmp64_, "clicked", (GCallback) _search_and_replace_search_forward_gtk_button_clicked, self, 0);
		_tmp65_ = self->priv->entry_find;
		g_signal_connect_object (_tmp65_, "activate", (GCallback) _search_and_replace_search_forward_gtk_entry_activate, self, 0);
		_tmp66_ = self->priv->entry_find;
		g_signal_connect_data ((GtkEditable*) _tmp66_, "changed", (GCallback) ____lambda60__gtk_editable_changed, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
		_tmp67_ = self->priv->entry_replace;
		g_signal_connect_data ((GtkEditable*) _tmp67_, "changed", (GCallback) ____lambda61__gtk_editable_changed, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
		_tmp68_ = self->priv->check_case_sensitive;
		g_signal_connect_object (_tmp68_, "toggled", (GCallback) ____lambda62__gtk_check_menu_item_toggled, self, 0);
		_tmp69_ = self->priv->check_entire_word;
		g_signal_connect_object (_tmp69_, "toggled", (GCallback) ____lambda63__gtk_check_menu_item_toggled, self, 0);
		_tmp70_ = _data11_->button_replace;
		g_signal_connect_object (_tmp70_, "clicked", (GCallback) _search_and_replace_replace_gtk_button_clicked, self, 0);
		_tmp71_ = self->priv->entry_replace;
		g_signal_connect_object (_tmp71_, "activate", (GCallback) _search_and_replace_replace_gtk_entry_activate, self, 0);
		_tmp72_ = _data11_->button_replace_all;
		g_signal_connect_object (_tmp72_, "clicked", (GCallback) ____lambda65__gtk_button_clicked, self, 0);
		_tmp73_ = self->priv->entry_find;
		g_signal_connect_object ((GtkWidget*) _tmp73_, "key-press-event", (GCallback) ____lambda66__gtk_widget_key_press_event, self, 0);
		_g_object_unref0 (button_close);
		_g_object_unref0 (eventbox_label2);
		_g_object_unref0 (eventbox_label1);
		_g_object_unref0 (builder);
		block11_data_unref (_data11_);
		_data11_ = NULL;
	}
	goto __finally33;
	__catch33_g_error:
	{
		GError* e = NULL;
		GError* _tmp74_;
		const gchar* _tmp75_;
		GError* _tmp76_;
		const gchar* _tmp77_;
		GtkLabel* _tmp78_;
		GtkLabel* _tmp79_;
		GtkLabel* label;
		GtkLabel* _tmp80_;
		GtkLabel* _tmp81_;
		GtkWidget* _tmp82_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp74_ = e;
		_tmp75_ = _tmp74_->message;
		g_warning ("search.vala:288: Search and replace: %s", _tmp75_);
		_tmp76_ = e;
		_tmp77_ = _tmp76_->message;
		_tmp78_ = (GtkLabel*) gtk_label_new (_tmp77_);
		_tmp79_ = g_object_ref_sink (_tmp78_);
		label = _tmp79_;
		_tmp80_ = label;
		gtk_label_set_line_wrap (_tmp80_, TRUE);
		_tmp81_ = label;
		_tmp82_ = _g_object_ref0 ((GtkWidget*) _tmp81_);
		_g_object_unref0 (self->priv->widget);
		self->priv->widget = _tmp82_;
		_g_object_unref0 (label);
		_g_error_free0 (e);
	}
	__finally33:
	if (_inner_error_ != NULL) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp83_ = self->priv->widget;
	gtk_widget_hide (_tmp83_);
	_g_free0 (path);
	return self;
}


SearchAndReplace* search_and_replace_new (MainWindow* main_window) {
	return search_and_replace_construct (TYPE_SEARCH_AND_REPLACE, main_window);
}


GtkWidget* search_and_replace_get_widget (SearchAndReplace* self) {
	GtkWidget* result = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->widget;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


void search_and_replace_show_search (SearchAndReplace* self) {
	GtkArrow* _tmp0_;
	GtkFrame* _tmp1_;
	GtkHBox* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->arrow;
	g_object_set (_tmp0_, "arrow-type", GTK_ARROW_DOWN, NULL);
	search_and_replace_show (self);
	_tmp1_ = self->priv->frame_replace;
	gtk_widget_hide ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->hbox_replace;
	gtk_widget_hide ((GtkWidget*) _tmp2_);
}


void search_and_replace_show_search_and_replace (SearchAndReplace* self) {
	GtkArrow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->arrow;
	g_object_set (_tmp0_, "arrow-type", GTK_ARROW_UP, NULL);
	search_and_replace_show (self);
}


static void _search_and_replace_active_document_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	search_and_replace_active_document_changed (self);
}


static void search_and_replace_show (SearchAndReplace* self) {
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	GtkWidget* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkEntry* _tmp6_;
	MainWindow* _tmp7_;
	Document* _tmp8_;
	Document* _tmp9_;
	Document* _tmp10_;
	Document* doc;
	Document* _tmp11_;
	SelectionType _tmp12_ = 0;
	MainWindow* _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->widget;
	gtk_widget_show_all (_tmp3_);
	_tmp4_ = self->priv->label_find_normal;
	gtk_widget_hide ((GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->label_find_error;
	gtk_widget_hide ((GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->entry_find;
	gtk_widget_grab_focus ((GtkWidget*) _tmp6_);
	search_and_replace_set_replace_sensitivity (self);
	_tmp7_ = self->priv->main_window;
	_tmp8_ = main_window_get_active_document (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	doc = _tmp10_;
	_tmp11_ = doc;
	_tmp12_ = document_get_selection_type (_tmp11_);
	if (_tmp12_ == SELECTION_TYPE_ONE_LINE) {
		GtkTextIter start = {0};
		GtkTextIter end = {0};
		Document* _tmp13_;
		GtkTextIter _tmp14_ = {0};
		GtkTextIter _tmp15_ = {0};
		GtkEntry* _tmp16_;
		Document* _tmp17_;
		GtkTextIter _tmp18_;
		GtkTextIter _tmp19_;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		_tmp13_ = doc;
		gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) _tmp13_, &_tmp14_, &_tmp15_);
		start = _tmp14_;
		end = _tmp15_;
		_tmp16_ = self->priv->entry_find;
		_tmp17_ = doc;
		_tmp18_ = start;
		_tmp19_ = end;
		_tmp20_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp17_, &_tmp18_, &_tmp19_, FALSE);
		_tmp21_ = _tmp20_;
		gtk_entry_set_text (_tmp16_, _tmp21_);
		_g_free0 (_tmp21_);
	}
	_tmp22_ = self->priv->main_window;
	g_signal_connect_object ((GObject*) _tmp22_, "notify::active-document", (GCallback) _search_and_replace_active_document_changed_g_object_notify, self, 0);
	_g_object_unref0 (doc);
}


void search_and_replace_hide (SearchAndReplace* self) {
	GtkWidget* _tmp0_;
	Document* _tmp1_;
	MainWindow* _tmp2_;
	DocumentView* _tmp3_;
	DocumentView* _tmp4_;
	MainWindow* _tmp8_;
	guint _tmp9_ = 0U;
	GQuark _tmp10_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->widget;
	gtk_widget_hide (_tmp0_);
	_tmp1_ = self->priv->working_document;
	if (_tmp1_ != NULL) {
		search_and_replace_clear_search (self);
	}
	_tmp2_ = self->priv->main_window;
	_tmp3_ = main_window_get_active_view (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		MainWindow* _tmp5_;
		DocumentView* _tmp6_;
		DocumentView* _tmp7_;
		_tmp5_ = self->priv->main_window;
		_tmp6_ = main_window_get_active_view (_tmp5_);
		_tmp7_ = _tmp6_;
		gtk_widget_grab_focus ((GtkWidget*) _tmp7_);
	}
	_tmp8_ = self->priv->main_window;
	g_signal_parse_name ("notify::active-document", G_TYPE_OBJECT, &_tmp9_, &_tmp10_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, _tmp10_, NULL, (GCallback) _search_and_replace_active_document_changed_g_object_notify, self);
}


static void search_and_replace_set_label_text (SearchAndReplace* self, const gchar* text, gboolean _error_) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = _error_;
	if (_tmp0_) {
		GtkLabel* _tmp1_;
		const gchar* _tmp2_;
		GtkLabel* _tmp3_;
		GtkLabel* _tmp4_;
		_tmp1_ = self->priv->label_find_error;
		_tmp2_ = text;
		gtk_label_set_text (_tmp1_, _tmp2_);
		_tmp3_ = self->priv->label_find_error;
		gtk_widget_show ((GtkWidget*) _tmp3_);
		_tmp4_ = self->priv->label_find_normal;
		gtk_widget_hide ((GtkWidget*) _tmp4_);
	} else {
		GtkLabel* _tmp5_;
		const gchar* _tmp6_;
		GtkLabel* _tmp7_;
		GtkLabel* _tmp8_;
		_tmp5_ = self->priv->label_find_normal;
		_tmp6_ = text;
		gtk_label_set_text (_tmp5_, _tmp6_);
		_tmp7_ = self->priv->label_find_normal;
		gtk_widget_show ((GtkWidget*) _tmp7_);
		_tmp8_ = self->priv->label_find_error;
		gtk_widget_hide ((GtkWidget*) _tmp8_);
	}
}


static void _search_and_replace_on_search_info_updated_document_search_info_updated (Document* _sender, gboolean selected, guint nb_matches, guint num_match, gpointer self) {
	search_and_replace_on_search_info_updated (self, selected, nb_matches, num_match);
}


static void search_and_replace_set_search_text (SearchAndReplace* self, gboolean select) {
	MainWindow* _tmp0_;
	Document* _tmp1_;
	Document* _tmp2_;
	GtkEntry* _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	MainWindow* _tmp6_;
	Document* _tmp7_;
	Document* _tmp8_;
	Document* _tmp9_;
	guint nb_matches = 0U;
	guint num_match = 0U;
	Document* _tmp16_;
	GtkEntry* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	guint _tmp25_ = 0U;
	guint _tmp26_ = 0U;
	guint _tmp27_;
	guint _tmp28_;
	guint _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_window;
	_tmp1_ = main_window_get_active_document (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->entry_find;
	_tmp4_ = gtk_entry_get_text_length (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == ((guint) 0)) {
		return;
	}
	_tmp6_ = self->priv->main_window;
	_tmp7_ = main_window_get_active_document (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->working_document;
	if (_tmp8_ != _tmp9_) {
		Document* _tmp10_;
		MainWindow* _tmp11_;
		Document* _tmp12_;
		Document* _tmp13_;
		Document* _tmp14_;
		Document* _tmp15_;
		_tmp10_ = self->priv->working_document;
		if (_tmp10_ != NULL) {
			search_and_replace_clear_search (self);
		}
		_tmp11_ = self->priv->main_window;
		_tmp12_ = main_window_get_active_document (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _g_object_ref0 (_tmp13_);
		_g_object_unref0 (self->priv->working_document);
		self->priv->working_document = _tmp14_;
		_tmp15_ = self->priv->working_document;
		g_signal_connect_object (_tmp15_, "search-info-updated", (GCallback) _search_and_replace_on_search_info_updated_document_search_info_updated, self, 0);
	}
	_tmp16_ = self->priv->working_document;
	_tmp17_ = self->priv->entry_find;
	_tmp18_ = gtk_entry_get_text (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = search_and_replace_get_case_sensitive (self);
	_tmp21_ = _tmp20_;
	_tmp22_ = search_and_replace_get_entire_word (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = select;
	document_set_search_text (_tmp16_, _tmp19_, _tmp21_, _tmp23_, &_tmp25_, &_tmp26_, _tmp24_);
	nb_matches = _tmp25_;
	num_match = _tmp26_;
	_tmp27_ = nb_matches;
	_tmp28_ = nb_matches;
	_tmp29_ = num_match;
	search_and_replace_on_search_info_updated (self, _tmp27_ != ((guint) 0), _tmp28_, _tmp29_);
}


static void search_and_replace_select_selected_search_text (SearchAndReplace* self) {
	MainWindow* _tmp0_;
	Document* _tmp1_;
	Document* _tmp2_;
	Document* _tmp3_;
	Document* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_window;
	_tmp1_ = main_window_get_active_document (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->working_document;
	if (_tmp3_ != NULL) {
	}
	_tmp4_ = self->priv->working_document;
	document_select_selected_search_text (_tmp4_);
}


static void search_and_replace_search_forward (SearchAndReplace* self) {
	Document* _tmp0_;
	Document* _tmp1_;
	g_return_if_fail (self != NULL);
	search_and_replace_set_search_text (self, FALSE);
	_tmp0_ = self->priv->working_document;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->working_document;
	document_search_forward (_tmp1_);
}


static void search_and_replace_on_search_info_updated (SearchAndReplace* self, gboolean selected, guint nb_matches, guint num_match) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = selected;
	if (_tmp0_) {
		const gchar* _tmp1_ = NULL;
		guint _tmp2_;
		guint _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp1_ = _ ("%u of %u");
		_tmp2_ = num_match;
		_tmp3_ = nb_matches;
		_tmp4_ = g_strdup_printf (_tmp1_, _tmp2_, _tmp3_);
		_tmp5_ = _tmp4_;
		search_and_replace_set_label_text (self, _tmp5_, FALSE);
		_g_free0 (_tmp5_);
	} else {
		guint _tmp6_;
		_tmp6_ = nb_matches;
		if (_tmp6_ == ((guint) 0)) {
			const gchar* _tmp7_ = NULL;
			_tmp7_ = _ ("Not found");
			search_and_replace_set_label_text (self, _tmp7_, TRUE);
		} else {
			guint _tmp8_;
			_tmp8_ = nb_matches;
			if (_tmp8_ == ((guint) 1)) {
				const gchar* _tmp9_ = NULL;
				_tmp9_ = _ ("One match");
				search_and_replace_set_label_text (self, _tmp9_, FALSE);
			} else {
				const gchar* _tmp10_ = NULL;
				guint _tmp11_;
				gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				_tmp10_ = _ ("%u matches");
				_tmp11_ = nb_matches;
				_tmp12_ = g_strdup_printf (_tmp10_, _tmp11_);
				_tmp13_ = _tmp12_;
				search_and_replace_set_label_text (self, _tmp13_, FALSE);
				_g_free0 (_tmp13_);
			}
		}
	}
}


static void search_and_replace_clear_search (SearchAndReplace* self) {
	Document* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->working_document;
	if (_tmp0_ != NULL) {
		Document* _tmp1_;
		Document* _tmp2_;
		guint _tmp3_ = 0U;
		_tmp1_ = self->priv->working_document;
		document_clear_search (_tmp1_, TRUE);
		_tmp2_ = self->priv->working_document;
		g_signal_parse_name ("search-info-updated", TYPE_DOCUMENT, &_tmp3_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _search_and_replace_on_search_info_updated_document_search_info_updated, self);
		_g_object_unref0 (self->priv->working_document);
		self->priv->working_document = NULL;
	}
}


static void search_and_replace_active_document_changed (SearchAndReplace* self) {
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->label_find_normal;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->label_find_error;
	gtk_widget_hide ((GtkWidget*) _tmp1_);
	search_and_replace_set_replace_sensitivity (self);
}


static void search_and_replace_set_replace_sensitivity (SearchAndReplace* self) {
	MainWindow* _tmp0_;
	Document* _tmp1_;
	Document* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean readonly;
	GtkFrame* _tmp5_;
	GtkHBox* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_window;
	_tmp1_ = main_window_get_active_document (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = document_get_readonly (_tmp2_);
	_tmp4_ = _tmp3_;
	readonly = _tmp4_;
	_tmp5_ = self->priv->frame_replace;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, !readonly);
	_tmp6_ = self->priv->hbox_replace;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, !readonly);
}


static void search_and_replace_replace (SearchAndReplace* self) {
	GtkEntry* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	Document* _tmp3_;
	GtkEntry* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entry_find;
	_tmp1_ = gtk_entry_get_text_length (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != ((guint) 0));
	search_and_replace_set_search_text (self, TRUE);
	_tmp3_ = self->priv->working_document;
	_tmp4_ = self->priv->entry_replace;
	_tmp5_ = gtk_entry_get_text (_tmp4_);
	_tmp6_ = _tmp5_;
	document_replace (_tmp3_, _tmp6_);
}


static gboolean search_and_replace_get_search_and_replace_mode (SearchAndReplace* self) {
	gboolean result;
	GtkArrow* _tmp0_;
	GtkArrowType _tmp1_ = 0;
	GtkArrowType _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->arrow;
	g_object_get (_tmp0_, "arrow-type", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_ == GTK_ARROW_UP;
	return result;
}


static gboolean search_and_replace_get_case_sensitive (SearchAndReplace* self) {
	gboolean result;
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->check_case_sensitive;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean search_and_replace_get_entire_word (SearchAndReplace* self) {
	gboolean result;
	GtkCheckMenuItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->check_entire_word;
	_tmp1_ = gtk_check_menu_item_get_active (_tmp0_);
	result = _tmp1_;
	return result;
}


static void search_and_replace_class_init (SearchAndReplaceClass * klass) {
	search_and_replace_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SearchAndReplacePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_search_and_replace_get_property;
	G_OBJECT_CLASS (klass)->finalize = search_and_replace_finalize;
}


static void search_and_replace_instance_init (SearchAndReplace * self) {
	self->priv = SEARCH_AND_REPLACE_GET_PRIVATE (self);
	self->priv->min_nb_chars_for_incremental_search = 3;
}


static void search_and_replace_finalize (GObject* obj) {
	SearchAndReplace * self;
	self = SEARCH_AND_REPLACE (obj);
	_g_object_unref0 (self->priv->working_document);
	_g_object_unref0 (self->priv->widget);
	_g_object_unref0 (self->priv->button_arrow);
	_g_object_unref0 (self->priv->arrow);
	_g_object_unref0 (self->priv->entry_find);
	_g_object_unref0 (self->priv->label_find_normal);
	_g_object_unref0 (self->priv->label_find_error);
	_g_object_unref0 (self->priv->entry_replace);
	_g_object_unref0 (self->priv->frame_replace);
	_g_object_unref0 (self->priv->hbox_replace);
	_g_object_unref0 (self->priv->check_case_sensitive);
	_g_object_unref0 (self->priv->check_entire_word);
	G_OBJECT_CLASS (search_and_replace_parent_class)->finalize (obj);
}


GType search_and_replace_get_type (void) {
	static volatile gsize search_and_replace_type_id__volatile = 0;
	if (g_once_init_enter (&search_and_replace_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchAndReplaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_and_replace_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchAndReplace), 0, (GInstanceInitFunc) search_and_replace_instance_init, NULL };
		GType search_and_replace_type_id;
		search_and_replace_type_id = g_type_register_static (G_TYPE_OBJECT, "SearchAndReplace", &g_define_type_info, 0);
		g_once_init_leave (&search_and_replace_type_id__volatile, search_and_replace_type_id);
	}
	return search_and_replace_type_id__volatile;
}


static void _vala_search_and_replace_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SearchAndReplace * self;
	self = SEARCH_AND_REPLACE (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



