/* completion.c generated by valac 0.14.0.77-0077, the Vala compiler
 * generated from completion.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtksourceview/gtksourceview.h>
#include <gtksourceview/gtksourcecompletionitem.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtk.h>
#include "config.h"
#include <glib/gi18n-lib.h>


#define TYPE_COMPLETION_PROVIDER (completion_provider_get_type ())
#define COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_PROVIDER, CompletionProvider))
#define COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))
#define IS_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_PROVIDER))
#define IS_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_PROVIDER))
#define COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))

typedef struct _CompletionProvider CompletionProvider;
typedef struct _CompletionProviderClass CompletionProviderClass;
typedef struct _CompletionProviderPrivate CompletionProviderPrivate;

#define COMPLETION_PROVIDER_TYPE_COMPLETION_COMMAND (completion_provider_completion_command_get_type ())

#define COMPLETION_PROVIDER_TYPE_COMPLETION_ARGUMENT (completion_provider_completion_argument_get_type ())

#define COMPLETION_PROVIDER_TYPE_COMPLETION_CHOICE (completion_provider_completion_choice_get_type ())
typedef struct _CompletionProviderCompletionChoice CompletionProviderCompletionChoice;
typedef struct _CompletionProviderCompletionArgument CompletionProviderCompletionArgument;
typedef struct _CompletionProviderCompletionCommand CompletionProviderCompletionCommand;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_markup_parse_context_free0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _completion_provider_completion_command_free0(var) ((var == NULL) ? NULL : (var = (completion_provider_completion_command_free (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
#define _completion_provider_completion_choice_free0(var) ((var == NULL) ? NULL : (var = (completion_provider_completion_choice_free (var), NULL)))

#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

struct _CompletionProvider {
	GObject parent_instance;
	CompletionProviderPrivate * priv;
};

struct _CompletionProviderClass {
	GObjectClass parent_class;
};

struct _CompletionProviderCompletionChoice {
	gchar* name;
	gchar* package;
	gchar* insert;
	gchar* insert_after;
};

struct _CompletionProviderCompletionArgument {
	gchar* label;
	gboolean optional;
	CompletionProviderCompletionChoice* choices;
	gint choices_length1;
	gint _choices_size_;
};

struct _CompletionProviderCompletionCommand {
	gchar* name;
	gchar* package;
	CompletionProviderCompletionArgument* args;
	gint args_length1;
	gint _args_size_;
};

struct _CompletionProviderPrivate {
	GList* proposals;
	GeeHashMap* commands;
	GeeHashMap* environments;
	GSettings* settings;
	CompletionProviderCompletionCommand current_command;
	CompletionProviderCompletionArgument current_arg;
	CompletionProviderCompletionChoice current_choice;
	gboolean show_all_proposals;
	GdkPixbuf* icon_normal_cmd;
	GdkPixbuf* icon_normal_choice;
	GdkPixbuf* icon_package_required;
	GtkSourceCompletionInfo* calltip_window;
	GtkLabel* calltip_window_label;
	gboolean first_populate;
};

struct _Document {
	GtkSourceBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
	guint _unsaved_doc_num;
};

struct _DocumentClass {
	GtkSourceBufferClass parent_class;
};


static gpointer completion_provider_parent_class = NULL;
static CompletionProvider* completion_provider_instance;
static CompletionProvider* completion_provider_instance = NULL;
static GtkSourceCompletionProviderIface* completion_provider_gtk_source_completion_provider_parent_iface = NULL;

GType completion_provider_get_type (void) G_GNUC_CONST;
static GType completion_provider_completion_command_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType completion_provider_completion_argument_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType completion_provider_completion_choice_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static CompletionProviderCompletionChoice* completion_provider_completion_choice_dup (const CompletionProviderCompletionChoice* self);
static void completion_provider_completion_choice_free (CompletionProviderCompletionChoice* self);
static void completion_provider_completion_choice_copy (const CompletionProviderCompletionChoice* self, CompletionProviderCompletionChoice* dest);
static void completion_provider_completion_choice_destroy (CompletionProviderCompletionChoice* self);
static CompletionProviderCompletionArgument* completion_provider_completion_argument_dup (const CompletionProviderCompletionArgument* self);
static void completion_provider_completion_argument_free (CompletionProviderCompletionArgument* self);
static void completion_provider_completion_argument_copy (const CompletionProviderCompletionArgument* self, CompletionProviderCompletionArgument* dest);
static void completion_provider_completion_argument_destroy (CompletionProviderCompletionArgument* self);
static CompletionProviderCompletionCommand* completion_provider_completion_command_dup (const CompletionProviderCompletionCommand* self);
static void completion_provider_completion_command_free (CompletionProviderCompletionCommand* self);
static void completion_provider_completion_command_copy (const CompletionProviderCompletionCommand* self, CompletionProviderCompletionCommand* dest);
static void completion_provider_completion_command_destroy (CompletionProviderCompletionCommand* self);
#define COMPLETION_PROVIDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COMPLETION_PROVIDER, CompletionProviderPrivate))
enum  {
	COMPLETION_PROVIDER_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static CompletionProvider* completion_provider_new (void);
static CompletionProvider* completion_provider_construct (GType object_type);
GdkPixbuf* utils_get_pixbuf_from_stock (const gchar* stock_id, GtkIconSize size);
static void completion_provider_parser_start (CompletionProvider* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error);
static void _completion_provider_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error);
static void completion_provider_parser_end (CompletionProvider* self, GMarkupParseContext* context, const gchar* name, GError** error);
static void _completion_provider_parser_end_gmarkup_parser_end_element_func (GMarkupParseContext* context, const gchar* element_name, gpointer self, GError** error);
static void completion_provider_parser_text (CompletionProvider* self, GMarkupParseContext* context, const gchar* text, gsize text_len, GError** error);
static void _completion_provider_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context, const gchar* text, gsize text_len, gpointer self, GError** error);
static gint completion_provider_compare_proposals (GtkSourceCompletionItem* a, GtkSourceCompletionItem* b);
CompletionProvider* completion_provider_get_default (void);
static gchar* completion_provider_real_get_name (GtkSourceCompletionProvider* base);
static GtkSourceCompletionActivation completion_provider_real_get_activation (GtkSourceCompletionProvider* base);
static gboolean completion_provider_real_match (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context);
static gchar* completion_provider_get_latex_command_at_iter (CompletionProvider* self, GtkTextIter* iter);
static gboolean completion_provider_in_latex_command_argument (CompletionProvider* self, GtkTextIter* iter, gchar** cmd_name, GeeArrayList** arguments, gchar** argument_contents, gboolean* valid_arg_contents);
static void completion_provider_real_populate (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context);
static void completion_provider_clear_context (CompletionProvider* self, GtkSourceCompletionContext* context);
static GList* completion_provider_get_argument_proposals (CompletionProvider* self, CompletionProviderCompletionCommand* cmd, GeeArrayList* arguments);
void completion_provider_hide_calltip_window (CompletionProvider* self);
static gint completion_provider_get_argument_num (CompletionProvider* self, CompletionProviderCompletionArgument* all_args, int all_args_length1, GeeArrayList* args);
static gchar* completion_provider_get_command_info (CompletionProvider* self, CompletionProviderCompletionCommand* cmd, gint num);
static void completion_provider_show_calltip_info (CompletionProvider* self, const gchar* markup);
static gboolean completion_provider_real_activate_proposal (GtkSourceCompletionProvider* base, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
static void completion_provider_activate_proposal_argument_choice (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter, const gchar* cmd_name, const gchar* argument_contents);
static void completion_provider_activate_proposal_command_name (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter, const gchar* cmd);
static void completion_provider_close_environment (CompletionProvider* self, const gchar* env_name, GtkTextIter* iter);
GType document_get_type (void) G_GNUC_CONST;
void document_insert (Document* self, GtkTextIter* iter, const gchar* text, gint len);
gchar* document_get_current_indentation (Document* self, gint line);
GType document_tab_get_type (void) G_GNUC_CONST;
GType document_view_get_type (void) G_GNUC_CONST;
DocumentView* document_tab_get_view (DocumentTab* self);
gchar* document_view_get_indentation_style (DocumentView* self);
static void completion_provider_init_calltip_window (CompletionProvider* self);
GType application_get_type (void) G_GNUC_CONST;
Application* application_get_default (void);
GType main_window_get_type (void) G_GNUC_CONST;
MainWindow* application_get_active_window (Application* self);
DocumentView* main_window_get_active_view (MainWindow* self);
static gchar* completion_provider_get_text_line_at_iter (CompletionProvider* self, GtkTextIter* iter);
gboolean utils_char_is_escaped (const gchar* text, glong char_index);
static gchar* completion_provider_get_command_text (CompletionProvider* self, CompletionProviderCompletionCommand* cmd);
static void _vala_array_add10 (CompletionProviderCompletionArgument** array, int* length, int* size, const CompletionProviderCompletionArgument* value);
static void _vala_array_add11 (CompletionProviderCompletionChoice** array, int* length, int* size, const CompletionProviderCompletionChoice* value);
static gchar* completion_provider_get_latex_command_at_index (CompletionProvider* self, const gchar* text, glong index);
static void _vala_CompletionProviderCompletionArgument_array_free (CompletionProviderCompletionArgument* array, gint array_length);
static CompletionProviderCompletionArgument* _vala_array_dup1 (CompletionProviderCompletionArgument* self, int length);
static void _vala_CompletionProviderCompletionChoice_array_free (CompletionProviderCompletionChoice* array, gint array_length);
static CompletionProviderCompletionChoice* _vala_array_dup2 (CompletionProviderCompletionChoice* self, int length);
static void completion_provider_finalize (GObject* obj);
static gint _vala_array_length (gpointer array);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void _completion_provider_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error) {
	completion_provider_parser_start (self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
}


static void _completion_provider_parser_end_gmarkup_parser_end_element_func (GMarkupParseContext* context, const gchar* element_name, gpointer self, GError** error) {
	completion_provider_parser_end (self, context, element_name, error);
}


static void _completion_provider_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context, const gchar* text, gsize text_len, gpointer self, GError** error) {
	completion_provider_parser_text (self, context, text, text_len, error);
}


static CompletionProvider* completion_provider_construct (GType object_type) {
	CompletionProvider * self = NULL;
	GSettings* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	GdkPixbuf* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	self = (CompletionProvider*) g_object_new (object_type, NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.latex");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, COMPLETION_PROVIDER_TYPE_COMPLETION_COMMAND, (GBoxedCopyFunc) completion_provider_completion_command_dup, completion_provider_completion_command_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->commands);
	self->priv->commands = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, COMPLETION_PROVIDER_TYPE_COMPLETION_CHOICE, (GBoxedCopyFunc) completion_provider_completion_choice_dup, completion_provider_completion_choice_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->environments);
	self->priv->environments = _tmp2_;
	_tmp3_ = utils_get_pixbuf_from_stock ("completion_cmd", GTK_ICON_SIZE_MENU);
	_g_object_unref0 (self->priv->icon_normal_cmd);
	self->priv->icon_normal_cmd = _tmp3_;
	_tmp4_ = utils_get_pixbuf_from_stock ("completion_choice", GTK_ICON_SIZE_MENU);
	_g_object_unref0 (self->priv->icon_normal_choice);
	self->priv->icon_normal_choice = _tmp4_;
	_tmp5_ = utils_get_pixbuf_from_stock (GTK_STOCK_DIALOG_WARNING, GTK_ICON_SIZE_MENU);
	_g_object_unref0 (self->priv->icon_package_required);
	self->priv->icon_package_required = _tmp5_;
	{
		GFile* _tmp6_ = NULL;
		GFile* file;
		guint8* chars = NULL;
		gint chars_length1 = 0;
		gint _chars_size_ = 0;
		GFile* _tmp7_;
		guint8* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		guint8* _tmp10_;
		gint _tmp10__length1;
		gchar* contents;
		GMarkupParser _tmp11_ = {0};
		GMarkupParser parser;
		GMarkupParser _tmp12_;
		GMarkupParseContext* _tmp13_;
		GMarkupParseContext* context;
		GMarkupParseContext* _tmp14_;
		const gchar* _tmp15_;
		_tmp6_ = g_file_new_for_path (DATA_DIR "/completion.xml");
		file = _tmp6_;
		_tmp7_ = file;
		g_file_load_contents (_tmp7_, NULL, &_tmp8_, &_tmp9_, NULL, &_inner_error_);
		chars = (g_free (chars), NULL);
		chars = _tmp8_;
		chars_length1 = _tmp9_;
		_chars_size_ = chars_length1;
		if (_inner_error_ != NULL) {
			chars = (g_free (chars), NULL);
			_g_object_unref0 (file);
			goto __catch42_g_error;
		}
		_tmp10_ = chars;
		_tmp10__length1 = chars_length1;
		chars = NULL;
		contents = (gchar*) _tmp10_;
		_tmp11_.start_element = _completion_provider_parser_start_gmarkup_parser_start_element_func;
		_tmp11_.end_element = _completion_provider_parser_end_gmarkup_parser_end_element_func;
		_tmp11_.text = _completion_provider_parser_text_gmarkup_parser_text_func;
		_tmp11_.passthrough = NULL;
		_tmp11_.error = NULL;
		parser = _tmp11_;
		_tmp12_ = parser;
		_tmp13_ = g_markup_parse_context_new (&_tmp12_, 0, self, NULL);
		context = _tmp13_;
		_tmp14_ = context;
		_tmp15_ = contents;
		g_markup_parse_context_parse (_tmp14_, _tmp15_, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_markup_parse_context_free0 (context);
			_g_free0 (contents);
			chars = (g_free (chars), NULL);
			_g_object_unref0 (file);
			goto __catch42_g_error;
		}
		self->priv->proposals = g_list_sort (self->priv->proposals, (GCompareFunc) completion_provider_compare_proposals);
		_g_markup_parse_context_free0 (context);
		_g_free0 (contents);
		chars = (g_free (chars), NULL);
		_g_object_unref0 (file);
	}
	goto __finally42;
	__catch42_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_warning ("completion.vala:101: Impossible to load completion data: %s", _tmp17_);
		_g_error_free0 (e);
	}
	__finally42:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


static CompletionProvider* completion_provider_new (void) {
	return completion_provider_construct (TYPE_COMPLETION_PROVIDER);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


CompletionProvider* completion_provider_get_default (void) {
	CompletionProvider* result = NULL;
	CompletionProvider* _tmp0_;
	CompletionProvider* _tmp2_;
	CompletionProvider* _tmp3_;
	_tmp0_ = completion_provider_instance;
	if (_tmp0_ == NULL) {
		CompletionProvider* _tmp1_;
		_tmp1_ = completion_provider_new ();
		_g_object_unref0 (completion_provider_instance);
		completion_provider_instance = _tmp1_;
	}
	_tmp2_ = completion_provider_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static gchar* completion_provider_real_get_name (GtkSourceCompletionProvider* base) {
	CompletionProvider * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (CompletionProvider*) base;
	_tmp0_ = g_strdup ("LaTeX");
	result = _tmp0_;
	return result;
}


static GtkSourceCompletionActivation completion_provider_real_get_activation (GtkSourceCompletionProvider* base) {
	CompletionProvider * self;
	GtkSourceCompletionActivation result = 0;
	GtkSourceCompletionActivation ret;
	GSettings* _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = (CompletionProvider*) base;
	ret = GTK_SOURCE_COMPLETION_ACTIVATION_USER_REQUESTED;
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "interactive-completion");
	if (_tmp1_) {
		GtkSourceCompletionActivation _tmp2_;
		_tmp2_ = ret;
		ret = _tmp2_ | GTK_SOURCE_COMPLETION_ACTIVATION_INTERACTIVE;
	}
	result = ret;
	return result;
}


static gboolean completion_provider_real_match (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context) {
	CompletionProvider * self;
	gboolean result = FALSE;
	gboolean in_argument;
	gboolean valid_arg_contents;
	GtkSourceCompletionContext* _tmp0_;
	GtkTextIter _tmp1_ = {0};
	GtkTextIter iter;
	GtkTextBuffer* _tmp2_ = NULL;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* buf;
	GtkTextBuffer* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GtkTextIter _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* cmd;
	const gchar* _tmp9_;
	GtkSourceCompletionContext* _tmp13_;
	GtkSourceCompletionActivation _tmp14_ = 0;
	GtkSourceCompletionActivation _tmp15_;
	gboolean _tmp20_ = FALSE;
	GSettings* _tmp21_;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp27_;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_;
	gboolean _tmp31_;
	guint min_nb_chars = 0U;
	GSettings* _tmp32_;
	gboolean _tmp33_ = FALSE;
	const gchar* _tmp34_;
	gboolean _tmp39_;
	self = (CompletionProvider*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	self->priv->first_populate = TRUE;
	in_argument = FALSE;
	valid_arg_contents = FALSE;
	self->priv->show_all_proposals = FALSE;
	_tmp0_ = context;
	gtk_source_completion_context_get_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = gtk_text_iter_get_buffer (&iter);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	buf = _tmp3_;
	_tmp4_ = buf;
	_tmp5_ = gtk_text_buffer_get_has_selection (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		result = FALSE;
		_g_object_unref0 (buf);
		return result;
	}
	_tmp7_ = iter;
	_tmp8_ = completion_provider_get_latex_command_at_iter (self, &_tmp7_);
	cmd = _tmp8_;
	_tmp9_ = cmd;
	if (_tmp9_ == NULL) {
		GtkTextIter _tmp10_;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		_tmp10_ = iter;
		_tmp12_ = completion_provider_in_latex_command_argument (self, &_tmp10_, NULL, NULL, NULL, &_tmp11_);
		valid_arg_contents = _tmp11_;
		in_argument = _tmp12_;
	}
	_tmp13_ = context;
	g_object_get (_tmp13_, "activation", &_tmp14_, NULL);
	_tmp15_ = _tmp14_;
	if (_tmp15_ == GTK_SOURCE_COMPLETION_ACTIVATION_USER_REQUESTED) {
		gboolean _tmp16_ = FALSE;
		const gchar* _tmp17_;
		gboolean _tmp19_;
		_tmp17_ = cmd;
		if (_tmp17_ == NULL) {
			gboolean _tmp18_;
			_tmp18_ = in_argument;
			_tmp16_ = !_tmp18_;
		} else {
			_tmp16_ = FALSE;
		}
		_tmp19_ = _tmp16_;
		self->priv->show_all_proposals = _tmp19_;
		result = TRUE;
		_g_free0 (cmd);
		_g_object_unref0 (buf);
		return result;
	}
	_tmp21_ = self->priv->settings;
	_tmp22_ = g_settings_get_boolean (_tmp21_, "interactive-completion");
	if (!_tmp22_) {
		_tmp20_ = TRUE;
	} else {
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_;
		gboolean _tmp26_;
		_tmp24_ = in_argument;
		if (_tmp24_) {
			gboolean _tmp25_;
			_tmp25_ = valid_arg_contents;
			_tmp23_ = !_tmp25_;
		} else {
			_tmp23_ = FALSE;
		}
		_tmp26_ = _tmp23_;
		_tmp20_ = _tmp26_;
	}
	_tmp27_ = _tmp20_;
	if (_tmp27_) {
		result = FALSE;
		_g_free0 (cmd);
		_g_object_unref0 (buf);
		return result;
	}
	_tmp29_ = in_argument;
	if (_tmp29_) {
		gboolean _tmp30_;
		_tmp30_ = valid_arg_contents;
		_tmp28_ = _tmp30_;
	} else {
		_tmp28_ = FALSE;
	}
	_tmp31_ = _tmp28_;
	if (_tmp31_) {
		result = TRUE;
		_g_free0 (cmd);
		_g_object_unref0 (buf);
		return result;
	}
	_tmp32_ = self->priv->settings;
	g_settings_get (_tmp32_, "interactive-completion-num", "u", &min_nb_chars);
	_tmp34_ = cmd;
	if (_tmp34_ != NULL) {
		const gchar* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		guint _tmp38_;
		_tmp35_ = cmd;
		_tmp36_ = strlen (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = min_nb_chars;
		_tmp33_ = ((guint) _tmp37_) > _tmp38_;
	} else {
		_tmp33_ = FALSE;
	}
	_tmp39_ = _tmp33_;
	result = _tmp39_;
	_g_free0 (cmd);
	_g_object_unref0 (buf);
	return result;
}


static void completion_provider_real_populate (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context) {
	CompletionProvider * self;
	GtkSourceCompletionContext* _tmp0_;
	GtkTextIter _tmp1_ = {0};
	GtkTextIter iter;
	GtkTextIter _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* cmd;
	gboolean in_argument;
	gchar* cmd_name;
	GeeArrayList* _tmp4_;
	GeeArrayList* arguments;
	gchar* argument_contents;
	gboolean valid_arg_contents;
	const gchar* _tmp5_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_;
	gboolean _tmp18_;
	gboolean _tmp20_;
	gboolean _tmp28_;
	gboolean _tmp35_;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp38_;
	gboolean _tmp40_;
	GList* proposals_to_filter;
	gchar* prefix;
	gboolean _tmp43_;
	gboolean _tmp67_ = FALSE;
	gboolean _tmp68_;
	gboolean _tmp70_;
	GList* filtered_proposals;
	GList* _tmp91_;
	GList* _tmp102_;
	GtkSourceCompletionContext* _tmp107_;
	GList* _tmp108_;
	self = (CompletionProvider*) base;
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	gtk_source_completion_context_get_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = iter;
	_tmp3_ = completion_provider_get_latex_command_at_iter (self, &_tmp2_);
	cmd = _tmp3_;
	in_argument = FALSE;
	cmd_name = NULL;
	_tmp4_ = gee_array_list_new (G_TYPE_BOOLEAN, NULL, NULL, NULL);
	arguments = _tmp4_;
	argument_contents = NULL;
	valid_arg_contents = FALSE;
	_tmp5_ = cmd;
	if (_tmp5_ == NULL) {
		GtkTextIter _tmp6_;
		gchar* _tmp7_ = NULL;
		GeeArrayList* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		_tmp6_ = iter;
		_tmp11_ = completion_provider_in_latex_command_argument (self, &_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_);
		_g_free0 (cmd_name);
		cmd_name = _tmp7_;
		_g_object_unref0 (arguments);
		arguments = _tmp8_;
		_g_free0 (argument_contents);
		argument_contents = _tmp9_;
		valid_arg_contents = _tmp10_;
		in_argument = _tmp11_;
	}
	_tmp16_ = self->priv->show_all_proposals;
	if (!_tmp16_) {
		const gchar* _tmp17_;
		_tmp17_ = cmd;
		_tmp15_ = _tmp17_ == NULL;
	} else {
		_tmp15_ = FALSE;
	}
	_tmp18_ = _tmp15_;
	if (_tmp18_) {
		gboolean _tmp19_;
		_tmp19_ = in_argument;
		_tmp14_ = !_tmp19_;
	} else {
		_tmp14_ = FALSE;
	}
	_tmp20_ = _tmp14_;
	if (_tmp20_) {
		_tmp13_ = TRUE;
	} else {
		gboolean _tmp21_ = FALSE;
		GtkSourceCompletionContext* _tmp22_;
		GtkSourceCompletionActivation _tmp23_ = 0;
		GtkSourceCompletionActivation _tmp24_;
		gboolean _tmp27_;
		_tmp22_ = context;
		g_object_get (_tmp22_, "activation", &_tmp23_, NULL);
		_tmp24_ = _tmp23_;
		if (_tmp24_ == GTK_SOURCE_COMPLETION_ACTIVATION_INTERACTIVE) {
			GSettings* _tmp25_;
			gboolean _tmp26_ = FALSE;
			_tmp25_ = self->priv->settings;
			_tmp26_ = g_settings_get_boolean (_tmp25_, "interactive-completion");
			_tmp21_ = !_tmp26_;
		} else {
			_tmp21_ = FALSE;
		}
		_tmp27_ = _tmp21_;
		_tmp13_ = _tmp27_;
	}
	_tmp28_ = _tmp13_;
	if (_tmp28_) {
		_tmp12_ = TRUE;
	} else {
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_;
		gboolean _tmp34_;
		_tmp30_ = in_argument;
		if (_tmp30_) {
			GeeHashMap* _tmp31_;
			const gchar* _tmp32_;
			gboolean _tmp33_ = FALSE;
			_tmp31_ = self->priv->commands;
			_tmp32_ = cmd_name;
			_tmp33_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp31_, _tmp32_);
			_tmp29_ = !_tmp33_;
		} else {
			_tmp29_ = FALSE;
		}
		_tmp34_ = _tmp29_;
		_tmp12_ = _tmp34_;
	}
	_tmp35_ = _tmp12_;
	if (_tmp35_) {
		GtkSourceCompletionContext* _tmp36_;
		_tmp36_ = context;
		completion_provider_clear_context (self, _tmp36_);
		self->priv->first_populate = FALSE;
		_g_free0 (argument_contents);
		_g_object_unref0 (arguments);
		_g_free0 (cmd_name);
		_g_free0 (cmd);
		return;
	}
	_tmp38_ = self->priv->show_all_proposals;
	if (_tmp38_) {
		_tmp37_ = TRUE;
	} else {
		const gchar* _tmp39_;
		_tmp39_ = cmd;
		_tmp37_ = g_strcmp0 (_tmp39_, "\\") == 0;
	}
	_tmp40_ = _tmp37_;
	if (_tmp40_) {
		GtkSourceCompletionContext* _tmp41_;
		GList* _tmp42_;
		self->priv->show_all_proposals = FALSE;
		_tmp41_ = context;
		_tmp42_ = self->priv->proposals;
		gtk_source_completion_context_add_proposals (_tmp41_, GTK_SOURCE_COMPLETION_PROVIDER (self), _tmp42_, TRUE);
		self->priv->first_populate = FALSE;
		_g_free0 (argument_contents);
		_g_object_unref0 (arguments);
		_g_free0 (cmd_name);
		_g_free0 (cmd);
		return;
	}
	proposals_to_filter = NULL;
	prefix = NULL;
	_tmp43_ = in_argument;
	if (!_tmp43_) {
		GList* _tmp44_;
		const gchar* _tmp45_;
		gchar* _tmp46_;
		_tmp44_ = self->priv->proposals;
		proposals_to_filter = _tmp44_;
		_tmp45_ = cmd;
		_tmp46_ = g_strdup (_tmp45_);
		_g_free0 (prefix);
		prefix = _tmp46_;
	} else {
		gboolean _tmp47_ = FALSE;
		gboolean _tmp48_;
		gboolean _tmp52_;
		_tmp48_ = valid_arg_contents;
		if (_tmp48_) {
			GeeHashMap* _tmp49_;
			const gchar* _tmp50_;
			gboolean _tmp51_ = FALSE;
			_tmp49_ = self->priv->commands;
			_tmp50_ = cmd_name;
			_tmp51_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp49_, _tmp50_);
			_tmp47_ = _tmp51_;
		} else {
			_tmp47_ = FALSE;
		}
		_tmp52_ = _tmp47_;
		if (_tmp52_) {
			GeeHashMap* _tmp53_;
			const gchar* _tmp54_;
			gpointer _tmp55_ = NULL;
			CompletionProviderCompletionCommand* _tmp56_;
			GeeArrayList* _tmp57_;
			CompletionProviderCompletionCommand _tmp58_;
			GList* _tmp59_ = NULL;
			const gchar* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			const gchar* _tmp63_;
			const gchar* _tmp65_;
			gchar* _tmp66_;
			_tmp53_ = self->priv->commands;
			_tmp54_ = cmd_name;
			_tmp55_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp53_, _tmp54_);
			_tmp56_ = (CompletionProviderCompletionCommand*) _tmp55_;
			_tmp57_ = arguments;
			_tmp58_ = *_tmp56_;
			_tmp59_ = completion_provider_get_argument_proposals (self, &_tmp58_, _tmp57_);
			proposals_to_filter = _tmp59_;
			_completion_provider_completion_command_free0 (_tmp56_);
			_tmp60_ = argument_contents;
			_tmp61_ = g_strdup (_tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = _tmp62_;
			if (_tmp63_ == NULL) {
				gchar* _tmp64_;
				_tmp64_ = g_strdup ("");
				_g_free0 (_tmp62_);
				_tmp62_ = _tmp64_;
			}
			_tmp65_ = _tmp62_;
			_tmp66_ = g_strdup (_tmp65_);
			_g_free0 (prefix);
			prefix = _tmp66_;
			_g_free0 (_tmp62_);
		}
	}
	_tmp68_ = in_argument;
	if (_tmp68_) {
		GList* _tmp69_;
		_tmp69_ = proposals_to_filter;
		_tmp67_ = _tmp69_ == NULL;
	} else {
		_tmp67_ = FALSE;
	}
	_tmp70_ = _tmp67_;
	if (_tmp70_) {
		GtkSourceCompletionContext* _tmp71_;
		GtkSourceCompletionActivation _tmp72_ = 0;
		GtkSourceCompletionActivation _tmp73_;
		gboolean _tmp75_;
		_tmp71_ = context;
		g_object_get (_tmp71_, "activation", &_tmp72_, NULL);
		_tmp73_ = _tmp72_;
		if (_tmp73_ == GTK_SOURCE_COMPLETION_ACTIVATION_INTERACTIVE) {
			GtkSourceCompletionContext* _tmp74_;
			_tmp74_ = context;
			completion_provider_clear_context (self, _tmp74_);
			completion_provider_hide_calltip_window (self);
			_g_free0 (prefix);
			_g_free0 (argument_contents);
			_g_object_unref0 (arguments);
			_g_free0 (cmd_name);
			_g_free0 (cmd);
			return;
		}
		_tmp75_ = self->priv->first_populate;
		if (_tmp75_) {
			GeeHashMap* _tmp76_;
			const gchar* _tmp77_;
			gpointer _tmp78_ = NULL;
			CompletionProviderCompletionCommand* _tmp79_;
			CompletionProviderCompletionCommand _tmp80_ = {0};
			CompletionProviderCompletionCommand _tmp81_;
			CompletionProviderCompletionCommand command;
			CompletionProviderCompletionCommand _tmp82_;
			CompletionProviderCompletionArgument* _tmp83_;
			gint _tmp83__length1;
			GeeArrayList* _tmp84_;
			gint _tmp85_ = 0;
			gint num;
			gint _tmp86_;
			_tmp76_ = self->priv->commands;
			_tmp77_ = cmd_name;
			_tmp78_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp76_, _tmp77_);
			_tmp79_ = (CompletionProviderCompletionCommand*) _tmp78_;
			completion_provider_completion_command_copy (_tmp79_, &_tmp80_);
			_tmp81_ = _tmp80_;
			_completion_provider_completion_command_free0 (_tmp79_);
			command = _tmp81_;
			_tmp82_ = command;
			_tmp83_ = _tmp82_.args;
			_tmp83__length1 = _tmp82_.args_length1;
			_tmp84_ = arguments;
			_tmp85_ = completion_provider_get_argument_num (self, _tmp83_, _tmp83__length1, _tmp84_);
			num = _tmp85_;
			_tmp86_ = num;
			if (_tmp86_ != (-1)) {
				CompletionProviderCompletionCommand _tmp87_;
				gint _tmp88_;
				gchar* _tmp89_ = NULL;
				gchar* info;
				const gchar* _tmp90_;
				_tmp87_ = command;
				_tmp88_ = num;
				_tmp89_ = completion_provider_get_command_info (self, &_tmp87_, _tmp88_);
				info = _tmp89_;
				_tmp90_ = info;
				completion_provider_show_calltip_info (self, _tmp90_);
				_g_free0 (info);
			}
			completion_provider_completion_command_destroy (&command);
			_g_free0 (prefix);
			_g_free0 (argument_contents);
			_g_object_unref0 (arguments);
			_g_free0 (cmd_name);
			_g_free0 (cmd);
			return;
		}
	}
	completion_provider_hide_calltip_window (self);
	filtered_proposals = NULL;
	_tmp91_ = proposals_to_filter;
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp91_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			GtkSourceCompletionItem* _tmp92_;
			GtkSourceCompletionItem* item = NULL;
			_tmp92_ = _g_object_ref0 ((GtkSourceCompletionItem*) item_it->data);
			item = _tmp92_;
			{
				GtkSourceCompletionItem* _tmp93_;
				gchar* _tmp94_ = NULL;
				gchar* _tmp95_;
				gchar* _tmp96_;
				const gchar* _tmp97_;
				gboolean _tmp98_ = FALSE;
				gboolean _tmp99_;
				_tmp93_ = item;
				g_object_get (_tmp93_, "text", &_tmp94_, NULL);
				_tmp95_ = _tmp94_;
				_tmp96_ = _tmp95_;
				_tmp97_ = prefix;
				_tmp98_ = g_str_has_prefix (_tmp96_, _tmp97_);
				_tmp99_ = _tmp98_;
				_g_free0 (_tmp96_);
				if (_tmp99_) {
					GtkSourceCompletionItem* _tmp100_;
					GtkSourceCompletionItem* _tmp101_;
					_tmp100_ = item;
					_tmp101_ = _g_object_ref0 (_tmp100_);
					filtered_proposals = g_list_prepend (filtered_proposals, _tmp101_);
				}
				_g_object_unref0 (item);
			}
		}
	}
	_tmp102_ = filtered_proposals;
	if (_tmp102_ == NULL) {
		const gchar* _tmp103_ = NULL;
		GtkSourceCompletionItem* _tmp104_;
		GtkSourceCompletionItem* dummy_proposal;
		GtkSourceCompletionItem* _tmp105_;
		GtkSourceCompletionItem* _tmp106_;
		_tmp103_ = _ ("No matching proposal");
		_tmp104_ = gtk_source_completion_item_new (_tmp103_, "", NULL, NULL);
		dummy_proposal = _tmp104_;
		_tmp105_ = dummy_proposal;
		_tmp106_ = _g_object_ref0 (_tmp105_);
		filtered_proposals = g_list_prepend (filtered_proposals, _tmp106_);
		_g_object_unref0 (dummy_proposal);
	} else {
		filtered_proposals = g_list_reverse (filtered_proposals);
	}
	_tmp107_ = context;
	_tmp108_ = filtered_proposals;
	gtk_source_completion_context_add_proposals (_tmp107_, GTK_SOURCE_COMPLETION_PROVIDER (self), _tmp108_, TRUE);
	self->priv->first_populate = FALSE;
	__g_list_free__g_object_unref0_0 (filtered_proposals);
	_g_free0 (prefix);
	_g_free0 (argument_contents);
	_g_object_unref0 (arguments);
	_g_free0 (cmd_name);
	_g_free0 (cmd);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean completion_provider_real_activate_proposal (GtkSourceCompletionProvider* base, GtkSourceCompletionProposal* proposal, GtkTextIter* iter) {
	CompletionProvider * self;
	gboolean result = FALSE;
	GtkSourceCompletionProposal* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* text;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp5_;
	GtkTextIter _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* cmd;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	gboolean _tmp12_;
	GtkSourceCompletionProposal* _tmp22_;
	GtkTextIter _tmp23_;
	const gchar* _tmp24_;
	self = (CompletionProvider*) base;
	g_return_val_if_fail (proposal != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = proposal;
	_tmp1_ = gtk_source_completion_proposal_get_text (_tmp0_);
	text = _tmp1_;
	_tmp3_ = text;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = text;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		result = TRUE;
		_g_free0 (text);
		return result;
	}
	_tmp6_ = *iter;
	_tmp7_ = completion_provider_get_latex_command_at_iter (self, &_tmp6_);
	cmd = _tmp7_;
	_tmp9_ = cmd;
	if (_tmp9_ == NULL) {
		const gchar* _tmp10_;
		gchar _tmp11_ = '\0';
		_tmp10_ = text;
		_tmp11_ = string_get (_tmp10_, (glong) 0);
		_tmp8_ = _tmp11_ != '\\';
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	if (_tmp12_) {
		gchar* cmd_name;
		gchar* argument_contents;
		GtkTextIter _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		gboolean in_argument;
		gboolean _tmp17_;
		cmd_name = NULL;
		argument_contents = NULL;
		_tmp13_ = *iter;
		_tmp16_ = completion_provider_in_latex_command_argument (self, &_tmp13_, &_tmp14_, NULL, &_tmp15_, NULL);
		_g_free0 (cmd_name);
		cmd_name = _tmp14_;
		_g_free0 (argument_contents);
		argument_contents = _tmp15_;
		in_argument = _tmp16_;
		_tmp17_ = in_argument;
		if (_tmp17_) {
			GtkSourceCompletionProposal* _tmp18_;
			GtkTextIter _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			_tmp18_ = proposal;
			_tmp19_ = *iter;
			_tmp20_ = cmd_name;
			_tmp21_ = argument_contents;
			completion_provider_activate_proposal_argument_choice (self, _tmp18_, &_tmp19_, _tmp20_, _tmp21_);
			result = TRUE;
			_g_free0 (argument_contents);
			_g_free0 (cmd_name);
			_g_free0 (cmd);
			_g_free0 (text);
			return result;
		}
		_g_free0 (argument_contents);
		_g_free0 (cmd_name);
	}
	_tmp22_ = proposal;
	_tmp23_ = *iter;
	_tmp24_ = cmd;
	completion_provider_activate_proposal_command_name (self, _tmp22_, &_tmp23_, _tmp24_);
	result = TRUE;
	_g_free0 (cmd);
	_g_free0 (text);
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static void completion_provider_activate_proposal_command_name (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter, const gchar* cmd) {
	GtkSourceCompletionProposal* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* text;
	gint _tmp2_ = 0;
	const gchar* _tmp3_;
	gint _tmp7_;
	glong index_start;
	const gchar* _tmp8_;
	glong _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* text_to_insert;
	GtkTextBuffer* _tmp14_ = NULL;
	GtkTextBuffer* _tmp15_;
	GtkTextBuffer* doc;
	GtkTextBuffer* _tmp16_;
	GtkTextBuffer* _tmp17_;
	const gchar* _tmp18_;
	GtkTextBuffer* _tmp19_;
	gint i = 0;
	gint _tmp30_;
	const gchar* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (proposal != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = proposal;
	_tmp1_ = gtk_source_completion_proposal_get_text (_tmp0_);
	text = _tmp1_;
	_tmp3_ = cmd;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = cmd;
		_tmp5_ = strlen (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = 0;
	}
	_tmp7_ = _tmp2_;
	index_start = (glong) _tmp7_;
	_tmp8_ = text;
	_tmp9_ = index_start;
	_tmp10_ = text;
	_tmp11_ = strlen (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = string_slice (_tmp8_, _tmp9_, (glong) _tmp12_);
	text_to_insert = _tmp13_;
	_tmp14_ = gtk_text_iter_get_buffer (iter);
	_tmp15_ = _g_object_ref0 (_tmp14_);
	doc = _tmp15_;
	_tmp16_ = doc;
	gtk_text_buffer_begin_user_action (_tmp16_);
	_tmp17_ = doc;
	_tmp18_ = text_to_insert;
	gtk_text_buffer_insert (_tmp17_, iter, _tmp18_, -1);
	_tmp19_ = doc;
	gtk_text_buffer_end_user_action (_tmp19_);
	{
		gboolean _tmp20_;
		i = 0;
		_tmp20_ = TRUE;
		while (TRUE) {
			gboolean _tmp21_;
			gint _tmp23_;
			const gchar* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			const gchar* _tmp27_;
			gint _tmp28_;
			gchar _tmp29_ = '\0';
			_tmp21_ = _tmp20_;
			if (!_tmp21_) {
				gint _tmp22_;
				_tmp22_ = i;
				i = _tmp22_ + 1;
			}
			_tmp20_ = FALSE;
			_tmp23_ = i;
			_tmp24_ = text_to_insert;
			_tmp25_ = strlen (_tmp24_);
			_tmp26_ = _tmp25_;
			if (!(_tmp23_ < _tmp26_)) {
				break;
			}
			_tmp27_ = text_to_insert;
			_tmp28_ = i;
			_tmp29_ = string_get (_tmp27_, (glong) _tmp28_);
			if (_tmp29_ == '{') {
				break;
			}
		}
	}
	_tmp30_ = i;
	_tmp31_ = text_to_insert;
	_tmp32_ = strlen (_tmp31_);
	_tmp33_ = _tmp32_;
	if (_tmp30_ < _tmp33_) {
		const gchar* _tmp34_;
		gint _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gboolean _tmp38_ = FALSE;
		_tmp34_ = text_to_insert;
		_tmp35_ = strlen (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = i;
		_tmp38_ = gtk_text_iter_backward_chars (iter, (((gint) _tmp36_) - _tmp37_) - 1);
		if (_tmp38_) {
			GtkTextBuffer* _tmp39_;
			GtkTextIter _tmp40_;
			_tmp39_ = doc;
			_tmp40_ = *iter;
			gtk_text_buffer_place_cursor (_tmp39_, &_tmp40_);
		}
	}
	_g_object_unref0 (doc);
	_g_free0 (text_to_insert);
	_g_free0 (text);
}


static void completion_provider_activate_proposal_argument_choice (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter, const gchar* cmd_name, const gchar* argument_contents) {
	GtkSourceCompletionProposal* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* text;
	gint _tmp2_ = 0;
	const gchar* _tmp3_;
	gint _tmp7_;
	glong index_start;
	const gchar* _tmp8_;
	glong _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* text_to_insert;
	GtkTextBuffer* _tmp14_ = NULL;
	GtkTextBuffer* _tmp15_;
	GtkTextBuffer* doc;
	GtkTextBuffer* _tmp16_;
	GtkTextBuffer* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GtkTextBuffer* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (proposal != NULL);
	g_return_if_fail (iter != NULL);
	g_return_if_fail (cmd_name != NULL);
	_tmp0_ = proposal;
	_tmp1_ = gtk_source_completion_proposal_get_text (_tmp0_);
	text = _tmp1_;
	_tmp3_ = argument_contents;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = argument_contents;
		_tmp5_ = strlen (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = 0;
	}
	_tmp7_ = _tmp2_;
	index_start = (glong) _tmp7_;
	_tmp8_ = text;
	_tmp9_ = index_start;
	_tmp10_ = text;
	_tmp11_ = strlen (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = string_slice (_tmp8_, _tmp9_, (glong) _tmp12_);
	text_to_insert = _tmp13_;
	_tmp14_ = gtk_text_iter_get_buffer (iter);
	_tmp15_ = _g_object_ref0 (_tmp14_);
	doc = _tmp15_;
	_tmp16_ = doc;
	gtk_text_buffer_begin_user_action (_tmp16_);
	_tmp17_ = doc;
	_tmp18_ = text_to_insert;
	gtk_text_buffer_insert (_tmp17_, iter, _tmp18_, -1);
	_tmp19_ = cmd_name;
	if (g_strcmp0 (_tmp19_, "\\begin") == 0) {
		const gchar* _tmp20_;
		GtkTextIter _tmp21_;
		_tmp20_ = text;
		_tmp21_ = *iter;
		completion_provider_close_environment (self, _tmp20_, &_tmp21_);
	} else {
	}
	_tmp22_ = doc;
	gtk_text_buffer_end_user_action (_tmp22_);
	_g_object_unref0 (doc);
	_g_free0 (text_to_insert);
	_g_free0 (text);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void completion_provider_close_environment (CompletionProvider* self, const gchar* env_name, GtkTextIter* iter) {
	gint _tmp0_ = 0;
	gint line;
	GtkTextBuffer* _tmp1_ = NULL;
	Document* _tmp2_;
	Document* doc;
	GtkTextIter end_iter = {0};
	Document* _tmp3_;
	gint _tmp4_;
	GtkTextIter _tmp5_ = {0};
	Document* _tmp6_;
	GtkTextIter _tmp7_;
	GtkTextIter _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* text;
	gboolean found;
	glong i = 0L;
	gboolean _tmp24_;
	Document* _tmp27_;
	gint _tmp28_;
	gchar* _tmp29_ = NULL;
	gchar* current_indent;
	GeeHashMap* _tmp30_;
	const gchar* _tmp31_;
	gpointer _tmp32_ = NULL;
	CompletionProviderCompletionChoice* environment;
	Document* _tmp33_;
	Document* _tmp34_;
	Document* document;
	Document* _tmp35_;
	DocumentTab* _tmp36_;
	DocumentView* _tmp37_;
	DocumentView* _tmp38_;
	gchar* _tmp39_ = NULL;
	gchar* indent;
	Document* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_ = NULL;
	const gchar* _tmp43_;
	const gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_;
	gboolean _tmp47_ = FALSE;
	CompletionProviderCompletionChoice* _tmp48_;
	gboolean _tmp51_;
	Document* _tmp55_;
	GtkTextIter _tmp56_;
	GtkTextMark* _tmp57_ = NULL;
	GtkTextMark* _tmp58_;
	GtkTextMark* cursor_pos;
	gboolean _tmp59_ = FALSE;
	CompletionProviderCompletionChoice* _tmp60_;
	gboolean _tmp63_;
	Document* _tmp67_;
	const gchar* _tmp68_;
	const gchar* _tmp69_ = NULL;
	gchar* _tmp70_ = NULL;
	gchar* _tmp71_;
	const gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	Document* _tmp77_;
	GtkTextMark* _tmp78_;
	GtkTextIter _tmp79_ = {0};
	Document* _tmp80_;
	GtkTextIter _tmp81_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (env_name != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = gtk_text_iter_get_line (iter);
	line = _tmp0_;
	_tmp1_ = gtk_text_iter_get_buffer (iter);
	_tmp2_ = _g_object_ref0 (DOCUMENT (_tmp1_));
	doc = _tmp2_;
	_tmp3_ = doc;
	_tmp4_ = line;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) _tmp3_, &_tmp5_, _tmp4_ + 1);
	end_iter = _tmp5_;
	_tmp6_ = doc;
	_tmp7_ = *iter;
	_tmp8_ = end_iter;
	_tmp9_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp6_, &_tmp7_, &_tmp8_, FALSE);
	text = _tmp9_;
	found = FALSE;
	{
		gboolean _tmp10_;
		i = (glong) 0;
		_tmp10_ = TRUE;
		while (TRUE) {
			gboolean _tmp11_;
			glong _tmp13_;
			const gchar* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			const gchar* _tmp17_;
			glong _tmp18_;
			gchar _tmp19_ = '\0';
			const gchar* _tmp20_;
			glong _tmp21_;
			gchar _tmp22_ = '\0';
			gboolean _tmp23_ = FALSE;
			_tmp11_ = _tmp10_;
			if (!_tmp11_) {
				glong _tmp12_;
				_tmp12_ = i;
				i = _tmp12_ + 1;
			}
			_tmp10_ = FALSE;
			_tmp13_ = i;
			_tmp14_ = text;
			_tmp15_ = strlen (_tmp14_);
			_tmp16_ = _tmp15_;
			if (!(_tmp13_ < ((glong) _tmp16_))) {
				break;
			}
			_tmp17_ = text;
			_tmp18_ = i;
			_tmp19_ = string_get (_tmp17_, _tmp18_);
			if (_tmp19_ == '}') {
				found = TRUE;
				break;
			}
			_tmp20_ = text;
			_tmp21_ = i;
			_tmp22_ = string_get (_tmp20_, _tmp21_);
			_tmp23_ = g_ascii_isspace (_tmp22_);
			if (_tmp23_) {
				continue;
			}
			break;
		}
	}
	_tmp24_ = found;
	if (!_tmp24_) {
		Document* _tmp25_;
		_tmp25_ = doc;
		document_insert (_tmp25_, iter, "}", -1);
	} else {
		glong _tmp26_;
		_tmp26_ = i;
		gtk_text_iter_forward_chars (iter, ((gint) _tmp26_) + 1);
	}
	_tmp27_ = doc;
	_tmp28_ = line;
	_tmp29_ = document_get_current_indentation (_tmp27_, _tmp28_);
	current_indent = _tmp29_;
	_tmp30_ = self->priv->environments;
	_tmp31_ = env_name;
	_tmp32_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp30_, _tmp31_);
	environment = (CompletionProviderCompletionChoice*) _tmp32_;
	_tmp33_ = doc;
	_tmp34_ = _g_object_ref0 (DOCUMENT (_tmp33_));
	document = _tmp34_;
	_tmp35_ = document;
	_tmp36_ = _tmp35_->tab;
	_tmp37_ = document_tab_get_view (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = document_view_get_indentation_style (_tmp38_);
	indent = _tmp39_;
	_tmp40_ = doc;
	_tmp41_ = current_indent;
	_tmp42_ = string_to_string (_tmp41_);
	_tmp43_ = indent;
	_tmp44_ = string_to_string (_tmp43_);
	_tmp45_ = g_strconcat ("\n", _tmp42_, _tmp44_, NULL);
	_tmp46_ = _tmp45_;
	document_insert (_tmp40_, iter, _tmp46_, -1);
	_g_free0 (_tmp46_);
	_tmp48_ = environment;
	if (_tmp48_ != NULL) {
		CompletionProviderCompletionChoice* _tmp49_;
		const gchar* _tmp50_;
		_tmp49_ = environment;
		_tmp50_ = (*_tmp49_).insert;
		_tmp47_ = _tmp50_ != NULL;
	} else {
		_tmp47_ = FALSE;
	}
	_tmp51_ = _tmp47_;
	if (_tmp51_) {
		Document* _tmp52_;
		CompletionProviderCompletionChoice* _tmp53_;
		const gchar* _tmp54_;
		_tmp52_ = doc;
		_tmp53_ = environment;
		_tmp54_ = (*_tmp53_).insert;
		document_insert (_tmp52_, iter, _tmp54_, -1);
	}
	_tmp55_ = doc;
	_tmp56_ = *iter;
	_tmp57_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) _tmp55_, NULL, &_tmp56_, TRUE);
	_tmp58_ = _g_object_ref0 (_tmp57_);
	cursor_pos = _tmp58_;
	_tmp60_ = environment;
	if (_tmp60_ != NULL) {
		CompletionProviderCompletionChoice* _tmp61_;
		const gchar* _tmp62_;
		_tmp61_ = environment;
		_tmp62_ = (*_tmp61_).insert_after;
		_tmp59_ = _tmp62_ != NULL;
	} else {
		_tmp59_ = FALSE;
	}
	_tmp63_ = _tmp59_;
	if (_tmp63_) {
		Document* _tmp64_;
		CompletionProviderCompletionChoice* _tmp65_;
		const gchar* _tmp66_;
		_tmp64_ = doc;
		_tmp65_ = environment;
		_tmp66_ = (*_tmp65_).insert_after;
		document_insert (_tmp64_, iter, _tmp66_, -1);
	}
	_tmp67_ = doc;
	_tmp68_ = current_indent;
	_tmp69_ = string_to_string (_tmp68_);
	_tmp70_ = g_strconcat ("\n", _tmp69_, "\\end{", NULL);
	_tmp71_ = _tmp70_;
	_tmp72_ = env_name;
	_tmp73_ = g_strconcat (_tmp71_, _tmp72_, NULL);
	_tmp74_ = _tmp73_;
	_tmp75_ = g_strconcat (_tmp74_, "}", NULL);
	_tmp76_ = _tmp75_;
	document_insert (_tmp67_, iter, _tmp76_, -1);
	_g_free0 (_tmp76_);
	_g_free0 (_tmp74_);
	_g_free0 (_tmp71_);
	_tmp77_ = doc;
	_tmp78_ = cursor_pos;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp77_, &_tmp79_, _tmp78_);
	*iter = _tmp79_;
	_tmp80_ = doc;
	_tmp81_ = *iter;
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) _tmp80_, &_tmp81_);
	_g_object_unref0 (cursor_pos);
	_g_free0 (indent);
	_g_object_unref0 (document);
	_completion_provider_completion_choice_free0 (environment);
	_g_free0 (current_indent);
	_g_free0 (text);
	_g_object_unref0 (doc);
}


static void completion_provider_init_calltip_window (CompletionProvider* self) {
	Application* _tmp0_ = NULL;
	Application* app;
	GtkSourceCompletionInfo* _tmp1_;
	GtkSourceCompletionInfo* _tmp2_;
	GtkSourceCompletionInfo* _tmp3_;
	MainWindow* _tmp4_;
	MainWindow* _tmp5_;
	GtkSourceCompletionInfo* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkSourceCompletionInfo* _tmp9_;
	GtkLabel* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = application_get_default ();
	app = _tmp0_;
	_tmp1_ = gtk_source_completion_info_new ();
	_tmp2_ = g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->calltip_window);
	self->priv->calltip_window = _tmp2_;
	_tmp3_ = self->priv->calltip_window;
	_tmp4_ = application_get_active_window (app);
	_tmp5_ = _tmp4_;
	gtk_window_set_transient_for ((GtkWindow*) _tmp3_, (GtkWindow*) _tmp5_);
	_tmp6_ = self->priv->calltip_window;
	gtk_source_completion_info_set_sizing (_tmp6_, 800, 200, TRUE, TRUE);
	_tmp7_ = (GtkLabel*) gtk_label_new (NULL);
	_tmp8_ = g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->calltip_window_label);
	self->priv->calltip_window_label = _tmp8_;
	_tmp9_ = self->priv->calltip_window;
	_tmp10_ = self->priv->calltip_window_label;
	gtk_source_completion_info_set_widget (_tmp9_, (GtkWidget*) _tmp10_);
	_g_object_unref0 (app);
}


static void completion_provider_show_calltip_info (CompletionProvider* self, const gchar* markup) {
	GtkSourceCompletionInfo* _tmp0_;
	Application* _tmp1_ = NULL;
	Application* _tmp2_;
	MainWindow* _tmp3_;
	MainWindow* _tmp4_;
	MainWindow* _tmp5_;
	MainWindow* _tmp6_;
	MainWindow* win;
	GtkTextIter pos = {0};
	MainWindow* _tmp7_;
	DocumentView* _tmp8_;
	DocumentView* _tmp9_;
	GtkTextBuffer* _tmp10_;
	GtkTextBuffer* _tmp11_;
	GtkTextBuffer* _tmp12_;
	GtkTextBuffer* buffer;
	GtkTextBuffer* _tmp13_;
	GtkTextBuffer* _tmp14_;
	GtkTextMark* _tmp15_ = NULL;
	GtkTextIter _tmp16_ = {0};
	GtkTextIter _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* text;
	GtkLabel* _tmp41_;
	const gchar* _tmp42_;
	GtkSourceCompletionInfo* _tmp43_;
	MainWindow* _tmp44_;
	GtkSourceCompletionInfo* _tmp45_;
	MainWindow* _tmp46_;
	DocumentView* _tmp47_;
	DocumentView* _tmp48_;
	GtkTextIter _tmp49_;
	GtkSourceCompletionInfo* _tmp50_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (markup != NULL);
	_tmp0_ = self->priv->calltip_window;
	if (_tmp0_ == NULL) {
		completion_provider_init_calltip_window (self);
	}
	_tmp1_ = application_get_default ();
	_tmp2_ = _tmp1_;
	_tmp3_ = application_get_active_window (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp2_);
	win = _tmp6_;
	_tmp7_ = win;
	_tmp8_ = main_window_get_active_view (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	buffer = _tmp12_;
	_tmp13_ = buffer;
	_tmp14_ = buffer;
	_tmp15_ = gtk_text_buffer_get_insert (_tmp14_);
	gtk_text_buffer_get_iter_at_mark (_tmp13_, &_tmp16_, _tmp15_);
	pos = _tmp16_;
	_tmp17_ = pos;
	_tmp18_ = completion_provider_get_text_line_at_iter (self, &_tmp17_);
	text = _tmp18_;
	{
		const gchar* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		glong i;
		_tmp19_ = text;
		_tmp20_ = strlen (_tmp19_);
		_tmp21_ = _tmp20_;
		i = (glong) (_tmp21_ - 1);
		{
			gboolean _tmp22_;
			_tmp22_ = TRUE;
			while (TRUE) {
				gboolean _tmp23_;
				glong _tmp25_;
				gboolean _tmp26_ = FALSE;
				const gchar* _tmp27_;
				glong _tmp28_;
				gchar _tmp29_ = '\0';
				gboolean _tmp33_;
				_tmp23_ = _tmp22_;
				if (!_tmp23_) {
					glong _tmp24_;
					_tmp24_ = i;
					i = _tmp24_ - 1;
				}
				_tmp22_ = FALSE;
				_tmp25_ = i;
				if (!(_tmp25_ >= ((glong) 0))) {
					break;
				}
				_tmp27_ = text;
				_tmp28_ = i;
				_tmp29_ = string_get (_tmp27_, _tmp28_);
				if (_tmp29_ == '[') {
					_tmp26_ = TRUE;
				} else {
					const gchar* _tmp30_;
					glong _tmp31_;
					gchar _tmp32_ = '\0';
					_tmp30_ = text;
					_tmp31_ = i;
					_tmp32_ = string_get (_tmp30_, _tmp31_);
					_tmp26_ = _tmp32_ == '{';
				}
				_tmp33_ = _tmp26_;
				if (_tmp33_) {
					const gchar* _tmp34_;
					glong _tmp35_;
					gboolean _tmp36_ = FALSE;
					const gchar* _tmp37_;
					gint _tmp38_;
					gint _tmp39_;
					glong _tmp40_;
					_tmp34_ = text;
					_tmp35_ = i;
					_tmp36_ = utils_char_is_escaped (_tmp34_, _tmp35_);
					if (_tmp36_) {
						continue;
					}
					_tmp37_ = text;
					_tmp38_ = strlen (_tmp37_);
					_tmp39_ = _tmp38_;
					_tmp40_ = i;
					gtk_text_iter_backward_chars (&pos, (gint) ((_tmp39_ - 1) - _tmp40_));
					break;
				}
			}
		}
	}
	_tmp41_ = self->priv->calltip_window_label;
	_tmp42_ = markup;
	gtk_label_set_markup (_tmp41_, _tmp42_);
	_tmp43_ = self->priv->calltip_window;
	_tmp44_ = win;
	gtk_window_set_transient_for ((GtkWindow*) _tmp43_, (GtkWindow*) _tmp44_);
	_tmp45_ = self->priv->calltip_window;
	_tmp46_ = win;
	_tmp47_ = main_window_get_active_view (_tmp46_);
	_tmp48_ = _tmp47_;
	_tmp49_ = pos;
	gtk_source_completion_info_move_to_iter (_tmp45_, (GtkTextView*) _tmp48_, &_tmp49_);
	_tmp50_ = self->priv->calltip_window;
	gtk_widget_show_all ((GtkWidget*) _tmp50_);
	_g_free0 (text);
	_g_object_unref0 (buffer);
	_g_object_unref0 (win);
}


void completion_provider_hide_calltip_window (CompletionProvider* self) {
	GtkSourceCompletionInfo* _tmp0_;
	GtkSourceCompletionInfo* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->calltip_window;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->calltip_window;
	gtk_widget_hide ((GtkWidget*) _tmp1_);
}


static void completion_provider_parser_start (CompletionProvider* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("commands")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("command")))) {
		switch (0) {
			default:
			{
				CompletionProviderCompletionCommand _tmp4_ = {0};
				memset (&_tmp4_, 0, sizeof (CompletionProviderCompletionCommand));
				completion_provider_completion_command_destroy (&self->priv->current_command);
				self->priv->current_command = _tmp4_;
				{
					gint i;
					i = 0;
					{
						gboolean _tmp5_;
						_tmp5_ = TRUE;
						while (TRUE) {
							gboolean _tmp6_;
							gint _tmp8_;
							gchar** _tmp9_;
							gint _tmp9__length1;
							gchar** _tmp10_;
							gint _tmp10__length1;
							gint _tmp11_;
							const gchar* _tmp12_;
							const gchar* _tmp13_;
							GQuark _tmp15_ = 0U;
							static GQuark _tmp14_label0 = 0;
							static GQuark _tmp14_label1 = 0;
							static GQuark _tmp14_label2 = 0;
							_tmp6_ = _tmp5_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = i;
								i = _tmp7_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp8_ = i;
							_tmp9_ = attr_names;
							_tmp9__length1 = attr_names_length1;
							if (!(_tmp8_ < _tmp9__length1)) {
								break;
							}
							_tmp10_ = attr_names;
							_tmp10__length1 = attr_names_length1;
							_tmp11_ = i;
							_tmp12_ = _tmp10_[_tmp11_];
							_tmp13_ = _tmp12_;
							_tmp15_ = (NULL == _tmp13_) ? 0 : g_quark_from_string (_tmp13_);
							if (_tmp15_ == ((0 != _tmp14_label0) ? _tmp14_label0 : (_tmp14_label0 = g_quark_from_static_string ("name")))) {
								switch (0) {
									default:
									{
										gchar** _tmp16_;
										gint _tmp16__length1;
										gint _tmp17_;
										const gchar* _tmp18_;
										gchar* _tmp19_;
										_tmp16_ = attr_values;
										_tmp16__length1 = attr_values_length1;
										_tmp17_ = i;
										_tmp18_ = _tmp16_[_tmp17_];
										_tmp19_ = g_strconcat ("\\", _tmp18_, NULL);
										_g_free0 (self->priv->current_command.name);
										self->priv->current_command.name = _tmp19_;
										break;
									}
								}
							} else if (_tmp15_ == ((0 != _tmp14_label1) ? _tmp14_label1 : (_tmp14_label1 = g_quark_from_static_string ("package")))) {
								switch (0) {
									default:
									{
										gchar** _tmp20_;
										gint _tmp20__length1;
										gint _tmp21_;
										const gchar* _tmp22_;
										gchar* _tmp23_;
										_tmp20_ = attr_values;
										_tmp20__length1 = attr_values_length1;
										_tmp21_ = i;
										_tmp22_ = _tmp20_[_tmp21_];
										_tmp23_ = g_strdup (_tmp22_);
										_g_free0 (self->priv->current_command.package);
										self->priv->current_command.package = _tmp23_;
										break;
									}
								}
							} else if (_tmp15_ == ((0 != _tmp14_label2) ? _tmp14_label2 : (_tmp14_label2 = g_quark_from_static_string ("environment")))) {
								switch (0) {
									default:
									{
										break;
									}
								}
							} else {
								switch (0) {
									default:
									{
										gchar** _tmp24_;
										gint _tmp24__length1;
										gint _tmp25_;
										const gchar* _tmp26_;
										gchar* _tmp27_;
										gchar* _tmp28_;
										gchar* _tmp29_;
										gchar* _tmp30_;
										GError* _tmp31_;
										GError* _tmp32_;
										_tmp24_ = attr_names;
										_tmp24__length1 = attr_names_length1;
										_tmp25_ = i;
										_tmp26_ = _tmp24_[_tmp25_];
										_tmp27_ = g_strconcat ("unknown command attribute \"", _tmp26_, NULL);
										_tmp28_ = _tmp27_;
										_tmp29_ = g_strconcat (_tmp28_, "\"", NULL);
										_tmp30_ = _tmp29_;
										_tmp31_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp30_);
										_tmp32_ = _tmp31_;
										_g_free0 (_tmp30_);
										_g_free0 (_tmp28_);
										_inner_error_ = _tmp32_;
										if (_inner_error_->domain == G_MARKUP_ERROR) {
											g_propagate_error (error, _inner_error_);
											return;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
									}
								}
							}
						}
					}
				}
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("argument")))) {
		switch (0) {
			default:
			{
				CompletionProviderCompletionArgument _tmp33_ = {0};
				memset (&_tmp33_, 0, sizeof (CompletionProviderCompletionArgument));
				completion_provider_completion_argument_destroy (&self->priv->current_arg);
				self->priv->current_arg = _tmp33_;
				self->priv->current_arg.optional = FALSE;
				{
					gint i;
					i = 0;
					{
						gboolean _tmp34_;
						_tmp34_ = TRUE;
						while (TRUE) {
							gboolean _tmp35_;
							gint _tmp37_;
							gchar** _tmp38_;
							gint _tmp38__length1;
							gchar** _tmp39_;
							gint _tmp39__length1;
							gint _tmp40_;
							const gchar* _tmp41_;
							const gchar* _tmp42_;
							GQuark _tmp44_ = 0U;
							static GQuark _tmp43_label0 = 0;
							static GQuark _tmp43_label1 = 0;
							_tmp35_ = _tmp34_;
							if (!_tmp35_) {
								gint _tmp36_;
								_tmp36_ = i;
								i = _tmp36_ + 1;
							}
							_tmp34_ = FALSE;
							_tmp37_ = i;
							_tmp38_ = attr_names;
							_tmp38__length1 = attr_names_length1;
							if (!(_tmp37_ < _tmp38__length1)) {
								break;
							}
							_tmp39_ = attr_names;
							_tmp39__length1 = attr_names_length1;
							_tmp40_ = i;
							_tmp41_ = _tmp39_[_tmp40_];
							_tmp42_ = _tmp41_;
							_tmp44_ = (NULL == _tmp42_) ? 0 : g_quark_from_string (_tmp42_);
							if (_tmp44_ == ((0 != _tmp43_label0) ? _tmp43_label0 : (_tmp43_label0 = g_quark_from_static_string ("label")))) {
								switch (0) {
									default:
									{
										gchar** _tmp45_;
										gint _tmp45__length1;
										gint _tmp46_;
										const gchar* _tmp47_;
										gchar* _tmp48_;
										_tmp45_ = attr_values;
										_tmp45__length1 = attr_values_length1;
										_tmp46_ = i;
										_tmp47_ = _tmp45_[_tmp46_];
										_tmp48_ = g_strdup (_tmp47_);
										_g_free0 (self->priv->current_arg.label);
										self->priv->current_arg.label = _tmp48_;
										break;
									}
								}
							} else if (_tmp44_ == ((0 != _tmp43_label1) ? _tmp43_label1 : (_tmp43_label1 = g_quark_from_static_string ("type")))) {
								switch (0) {
									default:
									{
										gchar** _tmp49_;
										gint _tmp49__length1;
										gint _tmp50_;
										const gchar* _tmp51_;
										_tmp49_ = attr_values;
										_tmp49__length1 = attr_values_length1;
										_tmp50_ = i;
										_tmp51_ = _tmp49_[_tmp50_];
										self->priv->current_arg.optional = g_strcmp0 (_tmp51_, "optional") == 0;
										break;
									}
								}
							} else {
								switch (0) {
									default:
									{
										gchar** _tmp52_;
										gint _tmp52__length1;
										gint _tmp53_;
										const gchar* _tmp54_;
										gchar* _tmp55_;
										gchar* _tmp56_;
										gchar* _tmp57_;
										gchar* _tmp58_;
										GError* _tmp59_;
										GError* _tmp60_;
										_tmp52_ = attr_names;
										_tmp52__length1 = attr_names_length1;
										_tmp53_ = i;
										_tmp54_ = _tmp52_[_tmp53_];
										_tmp55_ = g_strconcat ("unknown argument attribute \"", _tmp54_, NULL);
										_tmp56_ = _tmp55_;
										_tmp57_ = g_strconcat (_tmp56_, "\"", NULL);
										_tmp58_ = _tmp57_;
										_tmp59_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp58_);
										_tmp60_ = _tmp59_;
										_g_free0 (_tmp58_);
										_g_free0 (_tmp56_);
										_inner_error_ = _tmp60_;
										if (_inner_error_->domain == G_MARKUP_ERROR) {
											g_propagate_error (error, _inner_error_);
											return;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
									}
								}
							}
						}
					}
				}
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("choice")))) {
		switch (0) {
			default:
			{
				CompletionProviderCompletionChoice _tmp61_ = {0};
				memset (&_tmp61_, 0, sizeof (CompletionProviderCompletionChoice));
				completion_provider_completion_choice_destroy (&self->priv->current_choice);
				self->priv->current_choice = _tmp61_;
				{
					gint i;
					i = 0;
					{
						gboolean _tmp62_;
						_tmp62_ = TRUE;
						while (TRUE) {
							gboolean _tmp63_;
							gint _tmp65_;
							gchar** _tmp66_;
							gint _tmp66__length1;
							gchar** _tmp67_;
							gint _tmp67__length1;
							gint _tmp68_;
							const gchar* _tmp69_;
							const gchar* _tmp70_;
							GQuark _tmp72_ = 0U;
							static GQuark _tmp71_label0 = 0;
							static GQuark _tmp71_label1 = 0;
							_tmp63_ = _tmp62_;
							if (!_tmp63_) {
								gint _tmp64_;
								_tmp64_ = i;
								i = _tmp64_ + 1;
							}
							_tmp62_ = FALSE;
							_tmp65_ = i;
							_tmp66_ = attr_names;
							_tmp66__length1 = attr_names_length1;
							if (!(_tmp65_ < _tmp66__length1)) {
								break;
							}
							_tmp67_ = attr_names;
							_tmp67__length1 = attr_names_length1;
							_tmp68_ = i;
							_tmp69_ = _tmp67_[_tmp68_];
							_tmp70_ = _tmp69_;
							_tmp72_ = (NULL == _tmp70_) ? 0 : g_quark_from_string (_tmp70_);
							if (_tmp72_ == ((0 != _tmp71_label0) ? _tmp71_label0 : (_tmp71_label0 = g_quark_from_static_string ("name")))) {
								switch (0) {
									default:
									{
										gchar** _tmp73_;
										gint _tmp73__length1;
										gint _tmp74_;
										const gchar* _tmp75_;
										gchar* _tmp76_;
										_tmp73_ = attr_values;
										_tmp73__length1 = attr_values_length1;
										_tmp74_ = i;
										_tmp75_ = _tmp73_[_tmp74_];
										_tmp76_ = g_strdup (_tmp75_);
										_g_free0 (self->priv->current_choice.name);
										self->priv->current_choice.name = _tmp76_;
										break;
									}
								}
							} else if (_tmp72_ == ((0 != _tmp71_label1) ? _tmp71_label1 : (_tmp71_label1 = g_quark_from_static_string ("package")))) {
								switch (0) {
									default:
									{
										gchar** _tmp77_;
										gint _tmp77__length1;
										gint _tmp78_;
										const gchar* _tmp79_;
										gchar* _tmp80_;
										_tmp77_ = attr_values;
										_tmp77__length1 = attr_values_length1;
										_tmp78_ = i;
										_tmp79_ = _tmp77_[_tmp78_];
										_tmp80_ = g_strdup (_tmp79_);
										_g_free0 (self->priv->current_choice.package);
										self->priv->current_choice.package = _tmp80_;
										break;
									}
								}
							} else {
								switch (0) {
									default:
									{
										gchar** _tmp81_;
										gint _tmp81__length1;
										gint _tmp82_;
										const gchar* _tmp83_;
										gchar* _tmp84_;
										gchar* _tmp85_;
										gchar* _tmp86_;
										gchar* _tmp87_;
										GError* _tmp88_;
										GError* _tmp89_;
										_tmp81_ = attr_names;
										_tmp81__length1 = attr_names_length1;
										_tmp82_ = i;
										_tmp83_ = _tmp81_[_tmp82_];
										_tmp84_ = g_strconcat ("unknown choice attribute \"", _tmp83_, NULL);
										_tmp85_ = _tmp84_;
										_tmp86_ = g_strconcat (_tmp85_, "\"", NULL);
										_tmp87_ = _tmp86_;
										_tmp88_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp87_);
										_tmp89_ = _tmp88_;
										_g_free0 (_tmp87_);
										_g_free0 (_tmp85_);
										_inner_error_ = _tmp89_;
										if (_inner_error_->domain == G_MARKUP_ERROR) {
											g_propagate_error (error, _inner_error_);
											return;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
									}
								}
							}
						}
					}
				}
				break;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("insert")))) || (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("insert_after"))))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("placeholder")))) || (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("component"))))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp90_;
				gchar* _tmp91_;
				gchar* _tmp92_;
				gchar* _tmp93_;
				gchar* _tmp94_;
				GError* _tmp95_;
				GError* _tmp96_;
				_tmp90_ = name;
				_tmp91_ = g_strconcat ("unknown element \"", _tmp90_, NULL);
				_tmp92_ = _tmp91_;
				_tmp93_ = g_strconcat (_tmp92_, "\"", NULL);
				_tmp94_ = _tmp93_;
				_tmp95_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp94_);
				_tmp96_ = _tmp95_;
				_g_free0 (_tmp94_);
				_g_free0 (_tmp92_);
				_inner_error_ = _tmp96_;
				if (_inner_error_->domain == G_MARKUP_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static void _vala_array_add10 (CompletionProviderCompletionArgument** array, int* length, int* size, const CompletionProviderCompletionArgument* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (CompletionProviderCompletionArgument, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void _vala_array_add11 (CompletionProviderCompletionChoice** array, int* length, int* size, const CompletionProviderCompletionChoice* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (CompletionProviderCompletionChoice, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void completion_provider_parser_end (CompletionProvider* self, GMarkupParseContext* context, const gchar* name, GError** error) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("command")))) {
		switch (0) {
			default:
			{
				GdkPixbuf* _tmp4_ = NULL;
				CompletionProviderCompletionCommand _tmp5_;
				const gchar* _tmp6_;
				GdkPixbuf* _tmp9_;
				GdkPixbuf* _tmp10_;
				GdkPixbuf* pixbuf;
				CompletionProviderCompletionCommand _tmp11_;
				const gchar* _tmp12_;
				CompletionProviderCompletionCommand _tmp13_;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				GdkPixbuf* _tmp16_;
				CompletionProviderCompletionCommand _tmp17_;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_;
				GtkSourceCompletionItem* _tmp20_;
				GtkSourceCompletionItem* _tmp21_;
				GtkSourceCompletionItem* item;
				GtkSourceCompletionItem* _tmp22_;
				GtkSourceCompletionItem* _tmp23_;
				CompletionProviderCompletionCommand _tmp24_;
				CompletionProviderCompletionArgument* _tmp25_;
				gint _tmp25__length1;
				_tmp5_ = self->priv->current_command;
				_tmp6_ = _tmp5_.package;
				if (_tmp6_ != NULL) {
					GdkPixbuf* _tmp7_;
					_tmp7_ = self->priv->icon_package_required;
					_tmp4_ = _tmp7_;
				} else {
					GdkPixbuf* _tmp8_;
					_tmp8_ = self->priv->icon_normal_cmd;
					_tmp4_ = _tmp8_;
				}
				_tmp9_ = _tmp4_;
				_tmp10_ = _g_object_ref0 (_tmp9_);
				pixbuf = _tmp10_;
				_tmp11_ = self->priv->current_command;
				_tmp12_ = _tmp11_.name;
				_tmp13_ = self->priv->current_command;
				_tmp14_ = completion_provider_get_command_text (self, &_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = pixbuf;
				_tmp17_ = self->priv->current_command;
				_tmp18_ = completion_provider_get_command_info (self, &_tmp17_, -1);
				_tmp19_ = _tmp18_;
				_tmp20_ = gtk_source_completion_item_new (_tmp12_, _tmp15_, _tmp16_, _tmp19_);
				_tmp21_ = _tmp20_;
				_g_free0 (_tmp19_);
				_g_free0 (_tmp15_);
				item = _tmp21_;
				_tmp22_ = item;
				_tmp23_ = _g_object_ref0 (_tmp22_);
				self->priv->proposals = g_list_append (self->priv->proposals, _tmp23_);
				_tmp24_ = self->priv->current_command;
				_tmp25_ = _tmp24_.args;
				_tmp25__length1 = _tmp24_.args_length1;
				if (_tmp25__length1 > 0) {
					GeeHashMap* _tmp26_;
					CompletionProviderCompletionCommand _tmp27_;
					const gchar* _tmp28_;
					CompletionProviderCompletionCommand _tmp29_;
					_tmp26_ = self->priv->commands;
					_tmp27_ = self->priv->current_command;
					_tmp28_ = _tmp27_.name;
					_tmp29_ = self->priv->current_command;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp26_, _tmp28_, &_tmp29_);
				}
				_g_object_unref0 (item);
				_g_object_unref0 (pixbuf);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("argument")))) {
		switch (0) {
			default:
			{
				CompletionProviderCompletionArgument* _tmp30_;
				gint _tmp30__length1;
				CompletionProviderCompletionArgument _tmp31_;
				CompletionProviderCompletionArgument _tmp32_ = {0};
				_tmp30_ = self->priv->current_command.args;
				_tmp30__length1 = self->priv->current_command.args_length1;
				_tmp31_ = self->priv->current_arg;
				completion_provider_completion_argument_copy (&_tmp31_, &_tmp32_);
				_vala_array_add10 (&self->priv->current_command.args, &self->priv->current_command.args_length1, &self->priv->current_command._args_size_, &_tmp32_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("choice")))) {
		switch (0) {
			default:
			{
				CompletionProviderCompletionChoice* _tmp33_;
				gint _tmp33__length1;
				CompletionProviderCompletionChoice _tmp34_;
				CompletionProviderCompletionChoice _tmp35_ = {0};
				gboolean _tmp36_ = FALSE;
				CompletionProviderCompletionChoice _tmp37_;
				const gchar* _tmp38_;
				gboolean _tmp41_;
				_tmp33_ = self->priv->current_arg.choices;
				_tmp33__length1 = self->priv->current_arg.choices_length1;
				_tmp34_ = self->priv->current_choice;
				completion_provider_completion_choice_copy (&_tmp34_, &_tmp35_);
				_vala_array_add11 (&self->priv->current_arg.choices, &self->priv->current_arg.choices_length1, &self->priv->current_arg._choices_size_, &_tmp35_);
				_tmp37_ = self->priv->current_choice;
				_tmp38_ = _tmp37_.insert;
				if (_tmp38_ != NULL) {
					_tmp36_ = TRUE;
				} else {
					CompletionProviderCompletionChoice _tmp39_;
					const gchar* _tmp40_;
					_tmp39_ = self->priv->current_choice;
					_tmp40_ = _tmp39_.insert_after;
					_tmp36_ = _tmp40_ != NULL;
				}
				_tmp41_ = _tmp36_;
				if (_tmp41_) {
					GeeHashMap* _tmp42_;
					CompletionProviderCompletionChoice _tmp43_;
					const gchar* _tmp44_;
					CompletionProviderCompletionChoice _tmp45_;
					_tmp42_ = self->priv->environments;
					_tmp43_ = self->priv->current_choice;
					_tmp44_ = _tmp43_.name;
					_tmp45_ = self->priv->current_choice;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp42_, _tmp44_, &_tmp45_);
				}
				break;
			}
		}
	}
}


static void completion_provider_parser_text (CompletionProvider* self, GMarkupParseContext* context, const gchar* text, gsize text_len, GError** error) {
	GMarkupParseContext* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = context;
	_tmp1_ = g_markup_parse_context_get_element (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("insert")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp5_ = text;
				_tmp6_ = g_strdup (_tmp5_);
				_g_free0 (self->priv->current_choice.insert);
				self->priv->current_choice.insert = _tmp6_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("insert_after")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = text;
				_tmp8_ = g_strdup (_tmp7_);
				_g_free0 (self->priv->current_choice.insert_after);
				self->priv->current_choice.insert_after = _tmp8_;
				break;
			}
		}
	}
}


static GList* completion_provider_get_argument_proposals (CompletionProvider* self, CompletionProviderCompletionCommand* cmd, GeeArrayList* arguments) {
	GList* result = NULL;
	CompletionProviderCompletionCommand _tmp0_;
	CompletionProviderCompletionArgument* _tmp1_;
	gint _tmp1__length1;
	CompletionProviderCompletionCommand _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* info;
	CompletionProviderCompletionCommand _tmp4_;
	CompletionProviderCompletionArgument* _tmp5_;
	gint _tmp5__length1;
	GeeArrayList* _tmp6_;
	gint _tmp7_ = 0;
	gint num;
	gint _tmp8_;
	CompletionProviderCompletionCommand _tmp9_;
	CompletionProviderCompletionArgument* _tmp10_;
	gint _tmp10__length1;
	gint _tmp11_;
	CompletionProviderCompletionArgument _tmp12_;
	CompletionProviderCompletionArgument _tmp13_ = {0};
	CompletionProviderCompletionArgument arg;
	GList* items;
	CompletionProviderCompletionArgument _tmp14_;
	CompletionProviderCompletionChoice* _tmp15_;
	gint _tmp15__length1;
	GList* _tmp44_;
	GList* _tmp45_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cmd != NULL, NULL);
	g_return_val_if_fail (arguments != NULL, NULL);
	_tmp0_ = *cmd;
	_tmp1_ = _tmp0_.args;
	_tmp1__length1 = _tmp0_.args_length1;
	if (_tmp1__length1 == 0) {
		result = NULL;
		return result;
	}
	_tmp2_ = *cmd;
	_tmp3_ = completion_provider_get_command_info (self, &_tmp2_, -1);
	info = _tmp3_;
	_tmp4_ = *cmd;
	_tmp5_ = _tmp4_.args;
	_tmp5__length1 = _tmp4_.args_length1;
	_tmp6_ = arguments;
	_tmp7_ = completion_provider_get_argument_num (self, _tmp5_, _tmp5__length1, _tmp6_);
	num = _tmp7_;
	_tmp8_ = num;
	if (_tmp8_ == (-1)) {
		result = NULL;
		_g_free0 (info);
		return result;
	}
	_tmp9_ = *cmd;
	_tmp10_ = _tmp9_.args;
	_tmp10__length1 = _tmp9_.args_length1;
	_tmp11_ = num;
	_tmp12_ = _tmp10_[_tmp11_ - 1];
	completion_provider_completion_argument_copy (&_tmp12_, &_tmp13_);
	arg = _tmp13_;
	items = NULL;
	_tmp14_ = arg;
	_tmp15_ = _tmp14_.choices;
	_tmp15__length1 = _tmp14_.choices_length1;
	{
		CompletionProviderCompletionChoice* choice_collection = NULL;
		gint choice_collection_length1 = 0;
		gint _choice_collection_size_ = 0;
		gint choice_it = 0;
		choice_collection = _tmp15_;
		choice_collection_length1 = _tmp15__length1;
		for (choice_it = 0; choice_it < _tmp15__length1; choice_it = choice_it + 1) {
			CompletionProviderCompletionChoice _tmp16_ = {0};
			CompletionProviderCompletionChoice choice = {0};
			completion_provider_completion_choice_copy (&choice_collection[choice_it], &_tmp16_);
			choice = _tmp16_;
			{
				gchar* info2;
				GdkPixbuf* pixbuf = NULL;
				CompletionProviderCompletionChoice _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				const gchar* _tmp32_;
				CompletionProviderCompletionChoice _tmp35_;
				const gchar* _tmp36_;
				CompletionProviderCompletionChoice _tmp37_;
				const gchar* _tmp38_;
				GdkPixbuf* _tmp39_;
				const gchar* _tmp40_;
				GtkSourceCompletionItem* _tmp41_;
				GtkSourceCompletionItem* item;
				GtkSourceCompletionItem* _tmp42_;
				GtkSourceCompletionItem* _tmp43_;
				info2 = NULL;
				_tmp17_ = choice;
				_tmp18_ = _tmp17_.package;
				if (_tmp18_ != NULL) {
					const gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					CompletionProviderCompletionChoice _tmp22_;
					const gchar* _tmp23_;
					gchar* _tmp24_;
					GdkPixbuf* _tmp25_;
					GdkPixbuf* _tmp26_;
					_tmp19_ = info;
					_tmp20_ = g_strconcat (_tmp19_, "\nPackage: ", NULL);
					_tmp21_ = _tmp20_;
					_tmp22_ = choice;
					_tmp23_ = _tmp22_.package;
					_tmp24_ = g_strconcat (_tmp21_, _tmp23_, NULL);
					_g_free0 (info2);
					info2 = _tmp24_;
					_g_free0 (_tmp21_);
					_tmp25_ = self->priv->icon_package_required;
					_tmp26_ = _g_object_ref0 (_tmp25_);
					_g_object_unref0 (pixbuf);
					pixbuf = _tmp26_;
				} else {
					GdkPixbuf* _tmp27_;
					GdkPixbuf* _tmp28_;
					_tmp27_ = self->priv->icon_normal_choice;
					_tmp28_ = _g_object_ref0 (_tmp27_);
					_g_object_unref0 (pixbuf);
					pixbuf = _tmp28_;
				}
				_tmp29_ = info2;
				_tmp30_ = g_strdup (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = _tmp31_;
				if (_tmp32_ == NULL) {
					const gchar* _tmp33_;
					gchar* _tmp34_;
					_tmp33_ = info;
					_tmp34_ = g_strdup (_tmp33_);
					_g_free0 (_tmp31_);
					_tmp31_ = _tmp34_;
				}
				_tmp35_ = choice;
				_tmp36_ = _tmp35_.name;
				_tmp37_ = choice;
				_tmp38_ = _tmp37_.name;
				_tmp39_ = pixbuf;
				_tmp40_ = _tmp31_;
				_tmp41_ = gtk_source_completion_item_new (_tmp36_, _tmp38_, _tmp39_, _tmp40_);
				item = _tmp41_;
				_tmp42_ = item;
				_tmp43_ = _g_object_ref0 (_tmp42_);
				items = g_list_prepend (items, _tmp43_);
				_g_object_unref0 (item);
				_g_free0 (_tmp31_);
				_g_object_unref0 (pixbuf);
				_g_free0 (info2);
				completion_provider_completion_choice_destroy (&choice);
			}
		}
	}
	_tmp44_ = items;
	if (_tmp44_ == NULL) {
		result = NULL;
		completion_provider_completion_argument_destroy (&arg);
		_g_free0 (info);
		return result;
	}
	items = g_list_sort (items, (GCompareFunc) completion_provider_compare_proposals);
	_tmp45_ = items;
	result = _tmp45_;
	completion_provider_completion_argument_destroy (&arg);
	_g_free0 (info);
	return result;
}


static gint completion_provider_get_argument_num (CompletionProvider* self, CompletionProviderCompletionArgument* all_args, int all_args_length1, GeeArrayList* args) {
	gint result = 0;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	CompletionProviderCompletionArgument* _tmp3_;
	gint _tmp3__length1;
	gint num;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (args != NULL, 0);
	_tmp0_ = args;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = all_args;
	_tmp3__length1 = all_args_length1;
	g_return_val_if_fail (_tmp2_ <= _tmp3__length1, -1);
	num = 0;
	{
		GeeArrayList* _tmp4_;
		GeeArrayList* _tmp5_;
		GeeArrayList* _arg_list;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _arg_size;
		gint _arg_index;
		_tmp4_ = args;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_arg_list = _tmp5_;
		_tmp6_ = _arg_list;
		_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_arg_size = _tmp8_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			GeeArrayList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_ = NULL;
			gboolean arg;
			gint _tmp27_;
			_tmp9_ = _arg_index;
			_arg_index = _tmp9_ + 1;
			_tmp10_ = _arg_index;
			_tmp11_ = _arg_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _arg_list;
			_tmp13_ = _arg_index;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
			arg = GPOINTER_TO_INT (_tmp14_);
			while (TRUE) {
				gint _tmp15_;
				CompletionProviderCompletionArgument* _tmp16_;
				gint _tmp16__length1;
				CompletionProviderCompletionArgument* _tmp17_;
				gint _tmp17__length1;
				gint _tmp18_;
				CompletionProviderCompletionArgument _tmp19_;
				gboolean _tmp20_;
				gboolean _tmp21_;
				gint _tmp26_;
				_tmp15_ = num;
				_tmp16_ = all_args;
				_tmp16__length1 = all_args_length1;
				if (_tmp15_ >= _tmp16__length1) {
					result = -1;
					_g_object_unref0 (_arg_list);
					return result;
				}
				_tmp17_ = all_args;
				_tmp17__length1 = all_args_length1;
				_tmp18_ = num;
				_tmp19_ = _tmp17_[_tmp18_];
				_tmp20_ = _tmp19_.optional;
				_tmp21_ = arg;
				if (_tmp20_ == _tmp21_) {
					break;
				} else {
					CompletionProviderCompletionArgument* _tmp22_;
					gint _tmp22__length1;
					gint _tmp23_;
					CompletionProviderCompletionArgument _tmp24_;
					gboolean _tmp25_;
					_tmp22_ = all_args;
					_tmp22__length1 = all_args_length1;
					_tmp23_ = num;
					_tmp24_ = _tmp22_[_tmp23_];
					_tmp25_ = _tmp24_.optional;
					if (!_tmp25_) {
						result = -1;
						_g_object_unref0 (_arg_list);
						return result;
					}
				}
				_tmp26_ = num;
				num = _tmp26_ + 1;
			}
			_tmp27_ = num;
			num = _tmp27_ + 1;
		}
		_g_object_unref0 (_arg_list);
	}
	result = num;
	return result;
}


static gchar* completion_provider_get_command_text (CompletionProvider* self, CompletionProviderCompletionCommand* cmd) {
	gchar* result = NULL;
	CompletionProviderCompletionCommand _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* text_to_insert;
	CompletionProviderCompletionCommand _tmp3_;
	CompletionProviderCompletionArgument* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cmd != NULL, NULL);
	_tmp0_ = *cmd;
	_tmp1_ = _tmp0_.name;
	_tmp2_ = g_strdup (_tmp1_);
	text_to_insert = _tmp2_;
	_tmp3_ = *cmd;
	_tmp4_ = _tmp3_.args;
	_tmp4__length1 = _tmp3_.args_length1;
	{
		CompletionProviderCompletionArgument* arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = _tmp4_;
		arg_collection_length1 = _tmp4__length1;
		for (arg_it = 0; arg_it < _tmp4__length1; arg_it = arg_it + 1) {
			CompletionProviderCompletionArgument _tmp5_ = {0};
			CompletionProviderCompletionArgument arg = {0};
			completion_provider_completion_argument_copy (&arg_collection[arg_it], &_tmp5_);
			arg = _tmp5_;
			{
				CompletionProviderCompletionArgument _tmp6_;
				gboolean _tmp7_;
				_tmp6_ = arg;
				_tmp7_ = _tmp6_.optional;
				if (!_tmp7_) {
					const gchar* _tmp8_;
					gchar* _tmp9_;
					_tmp8_ = text_to_insert;
					_tmp9_ = g_strconcat (_tmp8_, "{}", NULL);
					_g_free0 (text_to_insert);
					text_to_insert = _tmp9_;
				}
				completion_provider_completion_argument_destroy (&arg);
			}
		}
	}
	result = text_to_insert;
	return result;
}


static gchar* completion_provider_get_command_info (CompletionProvider* self, CompletionProviderCompletionCommand* cmd, gint num) {
	gchar* result = NULL;
	CompletionProviderCompletionCommand _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* info;
	gint i;
	CompletionProviderCompletionCommand _tmp3_;
	CompletionProviderCompletionArgument* _tmp4_;
	gint _tmp4__length1;
	CompletionProviderCompletionCommand _tmp33_;
	const gchar* _tmp34_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cmd != NULL, NULL);
	_tmp0_ = *cmd;
	_tmp1_ = _tmp0_.name;
	_tmp2_ = g_strdup (_tmp1_);
	info = _tmp2_;
	i = 1;
	_tmp3_ = *cmd;
	_tmp4_ = _tmp3_.args;
	_tmp4__length1 = _tmp3_.args_length1;
	{
		CompletionProviderCompletionArgument* arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = _tmp4_;
		arg_collection_length1 = _tmp4__length1;
		for (arg_it = 0; arg_it < _tmp4__length1; arg_it = arg_it + 1) {
			CompletionProviderCompletionArgument _tmp5_ = {0};
			CompletionProviderCompletionArgument arg = {0};
			completion_provider_completion_argument_copy (&arg_collection[arg_it], &_tmp5_);
			arg = _tmp5_;
			{
				gint _tmp6_;
				gint _tmp7_;
				CompletionProviderCompletionArgument _tmp10_;
				gboolean _tmp11_;
				gint _tmp28_;
				gint _tmp29_;
				gint _tmp32_;
				_tmp6_ = num;
				_tmp7_ = i;
				if (_tmp6_ == _tmp7_) {
					const gchar* _tmp8_;
					gchar* _tmp9_;
					_tmp8_ = info;
					_tmp9_ = g_strconcat (_tmp8_, "<b>", NULL);
					_g_free0 (info);
					info = _tmp9_;
				}
				_tmp10_ = arg;
				_tmp11_ = _tmp10_.optional;
				if (_tmp11_) {
					const gchar* _tmp12_;
					CompletionProviderCompletionArgument _tmp13_;
					const gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp12_ = info;
					_tmp13_ = arg;
					_tmp14_ = _tmp13_.label;
					_tmp15_ = g_strconcat ("[", _tmp14_, NULL);
					_tmp16_ = _tmp15_;
					_tmp17_ = g_strconcat (_tmp16_, "]", NULL);
					_tmp18_ = _tmp17_;
					_tmp19_ = g_strconcat (_tmp12_, _tmp18_, NULL);
					_g_free0 (info);
					info = _tmp19_;
					_g_free0 (_tmp18_);
					_g_free0 (_tmp16_);
				} else {
					const gchar* _tmp20_;
					CompletionProviderCompletionArgument _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					_tmp20_ = info;
					_tmp21_ = arg;
					_tmp22_ = _tmp21_.label;
					_tmp23_ = g_strconcat ("{", _tmp22_, NULL);
					_tmp24_ = _tmp23_;
					_tmp25_ = g_strconcat (_tmp24_, "}", NULL);
					_tmp26_ = _tmp25_;
					_tmp27_ = g_strconcat (_tmp20_, _tmp26_, NULL);
					_g_free0 (info);
					info = _tmp27_;
					_g_free0 (_tmp26_);
					_g_free0 (_tmp24_);
				}
				_tmp28_ = num;
				_tmp29_ = i;
				if (_tmp28_ == _tmp29_) {
					const gchar* _tmp30_;
					gchar* _tmp31_;
					_tmp30_ = info;
					_tmp31_ = g_strconcat (_tmp30_, "</b>", NULL);
					_g_free0 (info);
					info = _tmp31_;
				}
				_tmp32_ = i;
				i = _tmp32_ + 1;
				completion_provider_completion_argument_destroy (&arg);
			}
		}
	}
	_tmp33_ = *cmd;
	_tmp34_ = _tmp33_.package;
	if (_tmp34_ != NULL) {
		const gchar* _tmp35_;
		CompletionProviderCompletionCommand _tmp36_;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		_tmp35_ = info;
		_tmp36_ = *cmd;
		_tmp37_ = _tmp36_.package;
		_tmp38_ = g_strconcat ("\nPackage: ", _tmp37_, NULL);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_strconcat (_tmp35_, _tmp39_, NULL);
		_g_free0 (info);
		info = _tmp40_;
		_g_free0 (_tmp39_);
	}
	result = info;
	return result;
}


static gchar* completion_provider_get_latex_command_at_iter (CompletionProvider* self, GtkTextIter* iter) {
	gchar* result = NULL;
	GtkTextIter _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* text;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = *iter;
	_tmp1_ = completion_provider_get_text_line_at_iter (self, &_tmp0_);
	text = _tmp1_;
	_tmp2_ = strlen (text);
	_tmp3_ = _tmp2_;
	_tmp4_ = completion_provider_get_latex_command_at_index (self, text, (glong) (_tmp3_ - 1));
	result = _tmp4_;
	_g_free0 (text);
	return result;
}


static gchar* completion_provider_get_text_line_at_iter (CompletionProvider* self, GtkTextIter* iter) {
	gchar* result = NULL;
	gint _tmp0_ = 0;
	gint line;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* doc;
	GtkTextIter iter_start = {0};
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_;
	GtkTextIter _tmp5_;
	gchar* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = gtk_text_iter_get_line (iter);
	line = _tmp0_;
	_tmp1_ = gtk_text_iter_get_buffer (iter);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	doc = _tmp2_;
	gtk_text_buffer_get_iter_at_line (doc, &_tmp3_, line);
	iter_start = _tmp3_;
	_tmp4_ = iter_start;
	_tmp5_ = *iter;
	_tmp6_ = gtk_text_buffer_get_text (doc, &_tmp4_, &_tmp5_, FALSE);
	result = _tmp6_;
	_g_object_unref0 (doc);
	return result;
}


static gchar* completion_provider_get_latex_command_at_index (CompletionProvider* self, const gchar* text, glong index) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	glong _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = text;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = index;
	g_return_val_if_fail (((glong) _tmp2_) > _tmp3_, NULL);
	{
		glong _tmp4_;
		glong i;
		_tmp4_ = index;
		i = _tmp4_;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_;
				glong _tmp8_;
				const gchar* _tmp9_;
				glong _tmp10_;
				gchar _tmp11_ = '\0';
				gboolean _tmp19_ = FALSE;
				const gchar* _tmp20_;
				glong _tmp21_;
				gchar _tmp22_ = '\0';
				gboolean _tmp23_ = FALSE;
				gboolean _tmp27_;
				_tmp6_ = _tmp5_;
				if (!_tmp6_) {
					glong _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ - 1;
				}
				_tmp5_ = FALSE;
				_tmp8_ = i;
				if (!(_tmp8_ >= ((glong) 0))) {
					break;
				}
				_tmp9_ = text;
				_tmp10_ = i;
				_tmp11_ = string_get (_tmp9_, _tmp10_);
				if (_tmp11_ == '\\') {
					const gchar* _tmp12_;
					glong _tmp13_;
					gboolean _tmp14_ = FALSE;
					const gchar* _tmp15_;
					glong _tmp16_;
					glong _tmp17_;
					gchar* _tmp18_ = NULL;
					_tmp12_ = text;
					_tmp13_ = i;
					_tmp14_ = utils_char_is_escaped (_tmp12_, _tmp13_);
					if (_tmp14_) {
						break;
					}
					_tmp15_ = text;
					_tmp16_ = i;
					_tmp17_ = index;
					_tmp18_ = string_slice (_tmp15_, _tmp16_, _tmp17_ + 1);
					result = _tmp18_;
					return result;
				}
				_tmp20_ = text;
				_tmp21_ = i;
				_tmp22_ = string_get (_tmp20_, _tmp21_);
				_tmp23_ = g_ascii_isalpha (_tmp22_);
				if (!_tmp23_) {
					const gchar* _tmp24_;
					glong _tmp25_;
					gchar _tmp26_ = '\0';
					_tmp24_ = text;
					_tmp25_ = i;
					_tmp26_ = string_get (_tmp24_, _tmp25_);
					_tmp19_ = _tmp26_ != '*';
				} else {
					_tmp19_ = FALSE;
				}
				_tmp27_ = _tmp19_;
				if (_tmp27_) {
					break;
				}
			}
		}
	}
	result = NULL;
	return result;
}


static gboolean completion_provider_in_latex_command_argument (CompletionProvider* self, GtkTextIter* iter, gchar** cmd_name, GeeArrayList** arguments, gchar** argument_contents, gboolean* valid_arg_contents) {
	gchar* _vala_cmd_name = NULL;
	GeeArrayList* _vala_arguments = NULL;
	gchar* _vala_argument_contents = NULL;
	gboolean _vala_valid_arg_contents = FALSE;
	gboolean result = FALSE;
	GtkTextIter _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* text;
	gboolean fetch_argument_contents;
	glong index_start_argument_contents;
	gboolean in_other_argument;
	gchar other_argument_opening_bracket;
	GeeArrayList* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_g_free0 (_vala_cmd_name);
	_vala_cmd_name = NULL;
	_g_free0 (_vala_argument_contents);
	_vala_argument_contents = NULL;
	_tmp0_ = *iter;
	_tmp1_ = completion_provider_get_text_line_at_iter (self, &_tmp0_);
	text = _tmp1_;
	fetch_argument_contents = TRUE;
	index_start_argument_contents = (glong) (-1);
	in_other_argument = FALSE;
	other_argument_opening_bracket = '{';
	_tmp2_ = gee_array_list_new (G_TYPE_BOOLEAN, NULL, NULL, NULL);
	_g_object_unref0 (_vala_arguments);
	_vala_arguments = _tmp2_;
	_vala_valid_arg_contents = TRUE;
	{
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		glong i;
		_tmp3_ = text;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		i = (glong) (_tmp5_ - 1);
		{
			gboolean _tmp6_;
			_tmp6_ = TRUE;
			while (TRUE) {
				gboolean _tmp7_;
				glong _tmp9_;
				gboolean _tmp10_;
				_tmp7_ = _tmp6_;
				if (!_tmp7_) {
					glong _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ - 1;
				}
				_tmp6_ = FALSE;
				_tmp9_ = i;
				if (!(_tmp9_ >= ((glong) 0))) {
					break;
				}
				_tmp10_ = fetch_argument_contents;
				if (_tmp10_) {
					gboolean _tmp11_ = FALSE;
					gboolean _tmp12_ = FALSE;
					const gchar* _tmp13_;
					glong _tmp14_;
					gchar _tmp15_ = '\0';
					gboolean _tmp19_;
					gboolean _tmp23_;
					gboolean _tmp35_ = FALSE;
					const gchar* _tmp36_;
					glong _tmp37_;
					gchar _tmp38_ = '\0';
					gboolean _tmp39_ = FALSE;
					gboolean _tmp43_;
					glong _tmp44_;
					_tmp13_ = text;
					_tmp14_ = i;
					_tmp15_ = string_get (_tmp13_, _tmp14_);
					if (_tmp15_ == '{') {
						_tmp12_ = TRUE;
					} else {
						const gchar* _tmp16_;
						glong _tmp17_;
						gchar _tmp18_ = '\0';
						_tmp16_ = text;
						_tmp17_ = i;
						_tmp18_ = string_get (_tmp16_, _tmp17_);
						_tmp12_ = _tmp18_ == '[';
					}
					_tmp19_ = _tmp12_;
					if (_tmp19_) {
						const gchar* _tmp20_;
						glong _tmp21_;
						gboolean _tmp22_ = FALSE;
						_tmp20_ = text;
						_tmp21_ = i;
						_tmp22_ = utils_char_is_escaped (_tmp20_, _tmp21_);
						_tmp11_ = !_tmp22_;
					} else {
						_tmp11_ = FALSE;
					}
					_tmp23_ = _tmp11_;
					if (_tmp23_) {
						GeeArrayList* _tmp24_;
						const gchar* _tmp25_;
						glong _tmp26_;
						gchar _tmp27_ = '\0';
						glong _tmp28_;
						_tmp24_ = _vala_arguments;
						_tmp25_ = text;
						_tmp26_ = i;
						_tmp27_ = string_get (_tmp25_, _tmp26_);
						gee_abstract_list_insert ((GeeAbstractList*) _tmp24_, 0, GINT_TO_POINTER (_tmp27_ == '['));
						_tmp28_ = index_start_argument_contents;
						if (_tmp28_ != ((glong) (-1))) {
							const gchar* _tmp29_;
							glong _tmp30_;
							const gchar* _tmp31_;
							gint _tmp32_;
							gint _tmp33_;
							gchar* _tmp34_ = NULL;
							_tmp29_ = text;
							_tmp30_ = index_start_argument_contents;
							_tmp31_ = text;
							_tmp32_ = strlen (_tmp31_);
							_tmp33_ = _tmp32_;
							_tmp34_ = string_slice (_tmp29_, _tmp30_, (glong) _tmp33_);
							_g_free0 (_vala_argument_contents);
							_vala_argument_contents = _tmp34_;
						}
						fetch_argument_contents = FALSE;
						continue;
					}
					_tmp36_ = text;
					_tmp37_ = i;
					_tmp38_ = string_get (_tmp36_, _tmp37_);
					_tmp39_ = g_ascii_isalpha (_tmp38_);
					if (!_tmp39_) {
						const gchar* _tmp40_;
						glong _tmp41_;
						gchar _tmp42_ = '\0';
						_tmp40_ = text;
						_tmp41_ = i;
						_tmp42_ = string_get (_tmp40_, _tmp41_);
						_tmp35_ = _tmp42_ != '*';
					} else {
						_tmp35_ = FALSE;
					}
					_tmp43_ = _tmp35_;
					if (_tmp43_) {
						_vala_valid_arg_contents = FALSE;
					}
					_tmp44_ = i;
					index_start_argument_contents = _tmp44_;
				} else {
					gboolean _tmp45_;
					_tmp45_ = in_other_argument;
					if (_tmp45_) {
						const gchar* _tmp46_;
						glong _tmp47_;
						gchar _tmp48_ = '\0';
						gchar _tmp49_;
						_tmp46_ = text;
						_tmp47_ = i;
						_tmp48_ = string_get (_tmp46_, _tmp47_);
						_tmp49_ = other_argument_opening_bracket;
						if (_tmp48_ == _tmp49_) {
							const gchar* _tmp50_;
							glong _tmp51_;
							gboolean _tmp52_ = FALSE;
							_tmp50_ = text;
							_tmp51_ = i;
							_tmp52_ = utils_char_is_escaped (_tmp50_, _tmp51_);
							in_other_argument = _tmp52_;
						}
						continue;
					} else {
						const gchar* _tmp53_;
						glong _tmp54_;
						gchar _tmp55_ = '\0';
						gboolean _tmp56_ = FALSE;
						gboolean _tmp57_ = FALSE;
						const gchar* _tmp58_;
						glong _tmp59_;
						gchar _tmp60_ = '\0';
						gboolean _tmp61_ = FALSE;
						gboolean _tmp65_;
						gboolean _tmp70_ = FALSE;
						const gchar* _tmp71_;
						glong _tmp72_;
						gchar _tmp73_ = '\0';
						gboolean _tmp77_;
						_tmp53_ = text;
						_tmp54_ = i;
						_tmp55_ = string_get (_tmp53_, _tmp54_);
						_tmp56_ = g_ascii_isspace (_tmp55_);
						if (_tmp56_) {
							continue;
						}
						_tmp58_ = text;
						_tmp59_ = i;
						_tmp60_ = string_get (_tmp58_, _tmp59_);
						_tmp61_ = g_ascii_isalpha (_tmp60_);
						if (_tmp61_) {
							_tmp57_ = TRUE;
						} else {
							const gchar* _tmp62_;
							glong _tmp63_;
							gchar _tmp64_ = '\0';
							_tmp62_ = text;
							_tmp63_ = i;
							_tmp64_ = string_get (_tmp62_, _tmp63_);
							_tmp57_ = _tmp64_ == '*';
						}
						_tmp65_ = _tmp57_;
						if (_tmp65_) {
							const gchar* _tmp66_;
							glong _tmp67_;
							gchar* _tmp68_ = NULL;
							const gchar* _tmp69_;
							_tmp66_ = text;
							_tmp67_ = i;
							_tmp68_ = completion_provider_get_latex_command_at_index (self, _tmp66_, _tmp67_);
							_g_free0 (_vala_cmd_name);
							_vala_cmd_name = _tmp68_;
							_tmp69_ = _vala_cmd_name;
							result = _tmp69_ != NULL;
							_g_free0 (text);
							if (cmd_name) {
								*cmd_name = _vala_cmd_name;
							} else {
								_g_free0 (_vala_cmd_name);
							}
							if (arguments) {
								*arguments = _vala_arguments;
							} else {
								_g_object_unref0 (_vala_arguments);
							}
							if (argument_contents) {
								*argument_contents = _vala_argument_contents;
							} else {
								_g_free0 (_vala_argument_contents);
							}
							if (valid_arg_contents) {
								*valid_arg_contents = _vala_valid_arg_contents;
							}
							return result;
						}
						_tmp71_ = text;
						_tmp72_ = i;
						_tmp73_ = string_get (_tmp71_, _tmp72_);
						if (_tmp73_ == '}') {
							_tmp70_ = TRUE;
						} else {
							const gchar* _tmp74_;
							glong _tmp75_;
							gchar _tmp76_ = '\0';
							_tmp74_ = text;
							_tmp75_ = i;
							_tmp76_ = string_get (_tmp74_, _tmp75_);
							_tmp70_ = _tmp76_ == ']';
						}
						_tmp77_ = _tmp70_;
						if (_tmp77_) {
							const gchar* _tmp78_;
							glong _tmp79_;
							gboolean _tmp80_ = FALSE;
							gchar _tmp81_ = '\0';
							const gchar* _tmp82_;
							glong _tmp83_;
							gchar _tmp84_ = '\0';
							gchar _tmp85_;
							GeeArrayList* _tmp86_;
							const gchar* _tmp87_;
							glong _tmp88_;
							gchar _tmp89_ = '\0';
							_tmp78_ = text;
							_tmp79_ = i;
							_tmp80_ = utils_char_is_escaped (_tmp78_, _tmp79_);
							if (_tmp80_) {
								result = FALSE;
								_g_free0 (text);
								if (cmd_name) {
									*cmd_name = _vala_cmd_name;
								} else {
									_g_free0 (_vala_cmd_name);
								}
								if (arguments) {
									*arguments = _vala_arguments;
								} else {
									_g_object_unref0 (_vala_arguments);
								}
								if (argument_contents) {
									*argument_contents = _vala_argument_contents;
								} else {
									_g_free0 (_vala_argument_contents);
								}
								if (valid_arg_contents) {
									*valid_arg_contents = _vala_valid_arg_contents;
								}
								return result;
							}
							in_other_argument = TRUE;
							_tmp82_ = text;
							_tmp83_ = i;
							_tmp84_ = string_get (_tmp82_, _tmp83_);
							if (_tmp84_ == '}') {
								_tmp81_ = '{';
							} else {
								_tmp81_ = '[';
							}
							_tmp85_ = _tmp81_;
							other_argument_opening_bracket = _tmp85_;
							_tmp86_ = _vala_arguments;
							_tmp87_ = text;
							_tmp88_ = i;
							_tmp89_ = string_get (_tmp87_, _tmp88_);
							gee_abstract_list_insert ((GeeAbstractList*) _tmp86_, 0, GINT_TO_POINTER (_tmp89_ == ']'));
							continue;
						}
						result = FALSE;
						_g_free0 (text);
						if (cmd_name) {
							*cmd_name = _vala_cmd_name;
						} else {
							_g_free0 (_vala_cmd_name);
						}
						if (arguments) {
							*arguments = _vala_arguments;
						} else {
							_g_object_unref0 (_vala_arguments);
						}
						if (argument_contents) {
							*argument_contents = _vala_argument_contents;
						} else {
							_g_free0 (_vala_argument_contents);
						}
						if (valid_arg_contents) {
							*valid_arg_contents = _vala_valid_arg_contents;
						}
						return result;
					}
				}
			}
		}
	}
	result = FALSE;
	_g_free0 (text);
	if (cmd_name) {
		*cmd_name = _vala_cmd_name;
	} else {
		_g_free0 (_vala_cmd_name);
	}
	if (arguments) {
		*arguments = _vala_arguments;
	} else {
		_g_object_unref0 (_vala_arguments);
	}
	if (argument_contents) {
		*argument_contents = _vala_argument_contents;
	} else {
		_g_free0 (_vala_argument_contents);
	}
	if (valid_arg_contents) {
		*valid_arg_contents = _vala_valid_arg_contents;
	}
	return result;
}


static gint completion_provider_compare_proposals (GtkSourceCompletionItem* a, GtkSourceCompletionItem* b) {
	gint result = 0;
	GtkSourceCompletionItem* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkSourceCompletionItem* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gint _tmp8_ = 0;
	gint _tmp9_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	g_object_get (_tmp0_, "text", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = b;
	g_object_get (_tmp4_, "text", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp8_ = g_utf8_collate (_tmp3_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp3_);
	result = _tmp9_;
	return result;
}


static void completion_provider_clear_context (CompletionProvider* self, GtkSourceCompletionContext* context) {
	GList* empty_proposals;
	GtkSourceCompletionContext* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	empty_proposals = NULL;
	_tmp0_ = context;
	gtk_source_completion_context_add_proposals (_tmp0_, GTK_SOURCE_COMPLETION_PROVIDER (self), empty_proposals, TRUE);
	__g_list_free__g_object_unref0_0 (empty_proposals);
}


static void _vala_CompletionProviderCompletionArgument_array_free (CompletionProviderCompletionArgument* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			completion_provider_completion_argument_destroy (&array[i]);
		}
	}
	g_free (array);
}


static CompletionProviderCompletionArgument* _vala_array_dup1 (CompletionProviderCompletionArgument* self, int length) {
	CompletionProviderCompletionArgument* result;
	int i;
	result = g_new0 (CompletionProviderCompletionArgument, length);
	for (i = 0; i < length; i++) {
		CompletionProviderCompletionArgument _tmp0_ = {0};
		completion_provider_completion_argument_copy (&self[i], &_tmp0_);
		result[i] = _tmp0_;
	}
	return result;
}


static void completion_provider_completion_command_copy (const CompletionProviderCompletionCommand* self, CompletionProviderCompletionCommand* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	CompletionProviderCompletionArgument* _tmp4_;
	gint _tmp4__length1;
	CompletionProviderCompletionArgument* _tmp5_;
	gint _tmp5__length1;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).package;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).package);
	(*dest).package = _tmp3_;
	_tmp4_ = (*self).args;
	_tmp4__length1 = (*self).args_length1;
	_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup1 (_tmp4_, _tmp4__length1) : ((gpointer) _tmp4_);
	_tmp5__length1 = _tmp4__length1;
	(*dest).args = (_vala_CompletionProviderCompletionArgument_array_free ((*dest).args, (*dest).args_length1), NULL);
	(*dest).args = _tmp5_;
	(*dest).args_length1 = _tmp5__length1;
	(*dest)._args_size_ = (*dest).args_length1;
}


static void completion_provider_completion_command_destroy (CompletionProviderCompletionCommand* self) {
	_g_free0 ((*self).name);
	_g_free0 ((*self).package);
	(*self).args = (_vala_CompletionProviderCompletionArgument_array_free ((*self).args, (*self).args_length1), NULL);
}


static CompletionProviderCompletionCommand* completion_provider_completion_command_dup (const CompletionProviderCompletionCommand* self) {
	CompletionProviderCompletionCommand* dup;
	dup = g_new0 (CompletionProviderCompletionCommand, 1);
	completion_provider_completion_command_copy (self, dup);
	return dup;
}


static void completion_provider_completion_command_free (CompletionProviderCompletionCommand* self) {
	completion_provider_completion_command_destroy (self);
	g_free (self);
}


static GType completion_provider_completion_command_get_type (void) {
	static volatile gsize completion_provider_completion_command_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_completion_command_type_id__volatile)) {
		GType completion_provider_completion_command_type_id;
		completion_provider_completion_command_type_id = g_boxed_type_register_static ("CompletionProviderCompletionCommand", (GBoxedCopyFunc) completion_provider_completion_command_dup, (GBoxedFreeFunc) completion_provider_completion_command_free);
		g_once_init_leave (&completion_provider_completion_command_type_id__volatile, completion_provider_completion_command_type_id);
	}
	return completion_provider_completion_command_type_id__volatile;
}


static void _vala_CompletionProviderCompletionChoice_array_free (CompletionProviderCompletionChoice* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			completion_provider_completion_choice_destroy (&array[i]);
		}
	}
	g_free (array);
}


static CompletionProviderCompletionChoice* _vala_array_dup2 (CompletionProviderCompletionChoice* self, int length) {
	CompletionProviderCompletionChoice* result;
	int i;
	result = g_new0 (CompletionProviderCompletionChoice, length);
	for (i = 0; i < length; i++) {
		CompletionProviderCompletionChoice _tmp0_ = {0};
		completion_provider_completion_choice_copy (&self[i], &_tmp0_);
		result[i] = _tmp0_;
	}
	return result;
}


static void completion_provider_completion_argument_copy (const CompletionProviderCompletionArgument* self, CompletionProviderCompletionArgument* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	CompletionProviderCompletionChoice* _tmp3_;
	gint _tmp3__length1;
	CompletionProviderCompletionChoice* _tmp4_;
	gint _tmp4__length1;
	_tmp0_ = (*self).label;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).label);
	(*dest).label = _tmp1_;
	_tmp2_ = (*self).optional;
	(*dest).optional = _tmp2_;
	_tmp3_ = (*self).choices;
	_tmp3__length1 = (*self).choices_length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup2 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp3__length1;
	(*dest).choices = (_vala_CompletionProviderCompletionChoice_array_free ((*dest).choices, (*dest).choices_length1), NULL);
	(*dest).choices = _tmp4_;
	(*dest).choices_length1 = _tmp4__length1;
	(*dest)._choices_size_ = (*dest).choices_length1;
}


static void completion_provider_completion_argument_destroy (CompletionProviderCompletionArgument* self) {
	_g_free0 ((*self).label);
	(*self).choices = (_vala_CompletionProviderCompletionChoice_array_free ((*self).choices, (*self).choices_length1), NULL);
}


static CompletionProviderCompletionArgument* completion_provider_completion_argument_dup (const CompletionProviderCompletionArgument* self) {
	CompletionProviderCompletionArgument* dup;
	dup = g_new0 (CompletionProviderCompletionArgument, 1);
	completion_provider_completion_argument_copy (self, dup);
	return dup;
}


static void completion_provider_completion_argument_free (CompletionProviderCompletionArgument* self) {
	completion_provider_completion_argument_destroy (self);
	g_free (self);
}


static GType completion_provider_completion_argument_get_type (void) {
	static volatile gsize completion_provider_completion_argument_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_completion_argument_type_id__volatile)) {
		GType completion_provider_completion_argument_type_id;
		completion_provider_completion_argument_type_id = g_boxed_type_register_static ("CompletionProviderCompletionArgument", (GBoxedCopyFunc) completion_provider_completion_argument_dup, (GBoxedFreeFunc) completion_provider_completion_argument_free);
		g_once_init_leave (&completion_provider_completion_argument_type_id__volatile, completion_provider_completion_argument_type_id);
	}
	return completion_provider_completion_argument_type_id__volatile;
}


static void completion_provider_completion_choice_copy (const CompletionProviderCompletionChoice* self, CompletionProviderCompletionChoice* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).package;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).package);
	(*dest).package = _tmp3_;
	_tmp4_ = (*self).insert;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).insert);
	(*dest).insert = _tmp5_;
	_tmp6_ = (*self).insert_after;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).insert_after);
	(*dest).insert_after = _tmp7_;
}


static void completion_provider_completion_choice_destroy (CompletionProviderCompletionChoice* self) {
	_g_free0 ((*self).name);
	_g_free0 ((*self).package);
	_g_free0 ((*self).insert);
	_g_free0 ((*self).insert_after);
}


static CompletionProviderCompletionChoice* completion_provider_completion_choice_dup (const CompletionProviderCompletionChoice* self) {
	CompletionProviderCompletionChoice* dup;
	dup = g_new0 (CompletionProviderCompletionChoice, 1);
	completion_provider_completion_choice_copy (self, dup);
	return dup;
}


static void completion_provider_completion_choice_free (CompletionProviderCompletionChoice* self) {
	completion_provider_completion_choice_destroy (self);
	g_free (self);
}


static GType completion_provider_completion_choice_get_type (void) {
	static volatile gsize completion_provider_completion_choice_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_completion_choice_type_id__volatile)) {
		GType completion_provider_completion_choice_type_id;
		completion_provider_completion_choice_type_id = g_boxed_type_register_static ("CompletionProviderCompletionChoice", (GBoxedCopyFunc) completion_provider_completion_choice_dup, (GBoxedFreeFunc) completion_provider_completion_choice_free);
		g_once_init_leave (&completion_provider_completion_choice_type_id__volatile, completion_provider_completion_choice_type_id);
	}
	return completion_provider_completion_choice_type_id__volatile;
}


static void completion_provider_class_init (CompletionProviderClass * klass) {
	completion_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CompletionProviderPrivate));
	G_OBJECT_CLASS (klass)->finalize = completion_provider_finalize;
}


static void completion_provider_gtk_source_completion_provider_interface_init (GtkSourceCompletionProviderIface * iface) {
	completion_provider_gtk_source_completion_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_name = (gchar* (*)(GtkSourceCompletionProvider*)) completion_provider_real_get_name;
	iface->get_activation = (GtkSourceCompletionActivation (*)(GtkSourceCompletionProvider*)) completion_provider_real_get_activation;
	iface->match = (gboolean (*)(GtkSourceCompletionProvider*, GtkSourceCompletionContext*)) completion_provider_real_match;
	iface->populate = (void (*)(GtkSourceCompletionProvider*, GtkSourceCompletionContext*)) completion_provider_real_populate;
	iface->activate_proposal = (gboolean (*)(GtkSourceCompletionProvider*, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_real_activate_proposal;
}


static void completion_provider_instance_init (CompletionProvider * self) {
	self->priv = COMPLETION_PROVIDER_GET_PRIVATE (self);
	self->priv->show_all_proposals = FALSE;
	self->priv->calltip_window = NULL;
	self->priv->calltip_window_label = NULL;
	self->priv->first_populate = TRUE;
}


static void completion_provider_finalize (GObject* obj) {
	CompletionProvider * self;
	self = COMPLETION_PROVIDER (obj);
	__g_list_free__g_object_unref0_0 (self->priv->proposals);
	_g_object_unref0 (self->priv->commands);
	_g_object_unref0 (self->priv->environments);
	_g_object_unref0 (self->priv->settings);
	completion_provider_completion_command_destroy (&self->priv->current_command);
	completion_provider_completion_argument_destroy (&self->priv->current_arg);
	completion_provider_completion_choice_destroy (&self->priv->current_choice);
	_g_object_unref0 (self->priv->icon_normal_cmd);
	_g_object_unref0 (self->priv->icon_normal_choice);
	_g_object_unref0 (self->priv->icon_package_required);
	_g_object_unref0 (self->priv->calltip_window);
	_g_object_unref0 (self->priv->calltip_window_label);
	G_OBJECT_CLASS (completion_provider_parent_class)->finalize (obj);
}


GType completion_provider_get_type (void) {
	static volatile gsize completion_provider_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CompletionProvider), 0, (GInstanceInitFunc) completion_provider_instance_init, NULL };
		static const GInterfaceInfo gtk_source_completion_provider_info = { (GInterfaceInitFunc) completion_provider_gtk_source_completion_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType completion_provider_type_id;
		completion_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "CompletionProvider", &g_define_type_info, 0);
		g_type_add_interface_static (completion_provider_type_id, GTK_TYPE_SOURCE_COMPLETION_PROVIDER, &gtk_source_completion_provider_info);
		g_once_init_leave (&completion_provider_type_id__volatile, completion_provider_type_id);
	}
	return completion_provider_type_id__volatile;
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



