/* clean_build_files.c generated by valac 0.14.0.77-0077, the Vala compiler
 * generated from clean_build_files.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtksourceview/gtksourceview.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>


#define TYPE_CLEAN_BUILD_FILES (clean_build_files_get_type ())
#define CLEAN_BUILD_FILES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLEAN_BUILD_FILES, CleanBuildFiles))
#define CLEAN_BUILD_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLEAN_BUILD_FILES, CleanBuildFilesClass))
#define IS_CLEAN_BUILD_FILES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLEAN_BUILD_FILES))
#define IS_CLEAN_BUILD_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLEAN_BUILD_FILES))
#define CLEAN_BUILD_FILES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLEAN_BUILD_FILES, CleanBuildFilesClass))

typedef struct _CleanBuildFiles CleanBuildFiles;
typedef struct _CleanBuildFilesClass CleanBuildFilesClass;
typedef struct _CleanBuildFilesPrivate CleanBuildFilesPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define CLEAN_BUILD_FILES_TYPE_CLEAN_FILE_COLUMN (clean_build_files_clean_file_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block14Data Block14Data;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

struct _CleanBuildFiles {
	GObject parent_instance;
	CleanBuildFilesPrivate * priv;
};

struct _CleanBuildFilesClass {
	GObjectClass parent_class;
};

struct _CleanBuildFilesPrivate {
	MainWindow* _main_window;
	Document* _doc;
	gchar** _extensions;
	gint _extensions_length1;
	gint __extensions_size_;
	gboolean _no_confirm;
};

typedef enum  {
	CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE,
	CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME,
	CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_FILE,
	CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_N_COLUMNS
} CleanBuildFilesCleanFileColumn;

struct _Project {
	GFile* directory;
	GFile* main_file;
};

struct _Block14Data {
	int _ref_count_;
	CleanBuildFiles * self;
	GtkListStore* store;
};


static gpointer clean_build_files_parent_class = NULL;

GType clean_build_files_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType document_get_type (void) G_GNUC_CONST;
#define CLEAN_BUILD_FILES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CLEAN_BUILD_FILES, CleanBuildFilesPrivate))
enum  {
	CLEAN_BUILD_FILES_DUMMY_PROPERTY
};
static GType clean_build_files_clean_file_column_get_type (void) G_GNUC_UNUSED;
CleanBuildFiles* clean_build_files_new (MainWindow* main_window, Document* doc);
CleanBuildFiles* clean_build_files_construct (GType object_type, MainWindow* main_window, Document* doc);
gboolean clean_build_files_clean (CleanBuildFiles* self);
gboolean document_is_main_file_a_tex_file (Document* self);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self, Project* dest);
void project_destroy (Project* self);
Project* document_get_project (Document* self);
static GeeArrayList* clean_build_files_get_build_files_in_directory (CleanBuildFiles* self, GFile* directory);
GFile* document_get_location (Document* self);
static GeeArrayList* clean_build_files_get_build_files_simple (CleanBuildFiles* self);
static void clean_build_files_show_info_no_file (CleanBuildFiles* self);
void utils_delete_file (GFile* file);
static gboolean clean_build_files_confirm_cleanup (CleanBuildFiles* self, GeeArrayList* files_to_delete, GFile* directory);
gchar* utils_get_shortname (const gchar* path);
gchar* utils_get_extension (const gchar* path);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static GtkTreeView* clean_build_files_get_list_files (CleanBuildFiles* self, GeeArrayList* files_to_delete, GFile* directory);
static GtkDialog* clean_build_files_get_dialog (CleanBuildFiles* self, GtkTreeView* list_files);
static gboolean clean_build_files_run_dialog (CleanBuildFiles* self, GtkDialog* dialog, GtkTreeModel* list_store);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (Block14Data* _data14_);
static gint clean_build_files_on_sort_list_files (CleanBuildFiles* self, GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b);
static gint _clean_build_files_on_sort_list_files_gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self);
gchar* utils_get_relative_path (GFile* origin, GFile* target, GFile* common_dir);
static void __lambda51_ (Block14Data* _data14_, const gchar* path_str);
static void ___lambda51__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self);
GtkWidget* utils_add_scrollbar (GtkWidget* child);
static void _vala_array_add12 (GFile*** array, int* length, int* size, GFile* value);
static void clean_build_files_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType clean_build_files_clean_file_column_get_type (void) {
	static volatile gsize clean_build_files_clean_file_column_type_id__volatile = 0;
	if (g_once_init_enter (&clean_build_files_clean_file_column_type_id__volatile)) {
		static const GEnumValue values[] = {{CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE, "CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE", "delete"}, {CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME, "CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME", "name"}, {CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_FILE, "CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_FILE", "file"}, {CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_N_COLUMNS, "CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType clean_build_files_clean_file_column_type_id;
		clean_build_files_clean_file_column_type_id = g_enum_register_static ("CleanBuildFilesCleanFileColumn", values);
		g_once_init_leave (&clean_build_files_clean_file_column_type_id__volatile, clean_build_files_clean_file_column_type_id);
	}
	return clean_build_files_clean_file_column_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


CleanBuildFiles* clean_build_files_construct (GType object_type, MainWindow* main_window, Document* doc) {
	CleanBuildFiles * self = NULL;
	MainWindow* _tmp0_;
	Document* _tmp1_;
	Document* _tmp2_;
	GSettings* _tmp3_;
	GSettings* settings;
	gchar* _tmp4_ = NULL;
	gchar* exts;
	gchar** _tmp5_;
	gchar** _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	g_return_val_if_fail (main_window != NULL, NULL);
	g_return_val_if_fail (doc != NULL, NULL);
	self = (CleanBuildFiles*) g_object_new (object_type, NULL);
	_tmp0_ = main_window;
	self->priv->_main_window = _tmp0_;
	_tmp1_ = doc;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->_doc);
	self->priv->_doc = _tmp2_;
	_tmp3_ = g_settings_new ("org.gnome.latexila.preferences.latex");
	settings = _tmp3_;
	_tmp4_ = g_settings_get_string (settings, "clean-extensions");
	exts = _tmp4_;
	_tmp6_ = _tmp5_ = g_strsplit (exts, " ", 0);
	self->priv->_extensions = (_vala_array_free (self->priv->_extensions, self->priv->_extensions_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_extensions = _tmp6_;
	self->priv->_extensions_length1 = _vala_array_length (_tmp5_);
	self->priv->__extensions_size_ = self->priv->_extensions_length1;
	_tmp7_ = g_settings_get_boolean (settings, "no-confirm-clean");
	self->priv->_no_confirm = _tmp7_;
	_g_free0 (exts);
	_g_object_unref0 (settings);
	return self;
}


CleanBuildFiles* clean_build_files_new (MainWindow* main_window, Document* doc) {
	return clean_build_files_construct (TYPE_CLEAN_BUILD_FILES, main_window, doc);
}


gboolean clean_build_files_clean (CleanBuildFiles* self) {
	gboolean result = FALSE;
	Document* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeArrayList* files_to_delete = NULL;
	GFile* directory = NULL;
	Document* _tmp2_;
	Project* _tmp3_ = NULL;
	Project* project;
	Project* _tmp4_;
	GeeArrayList* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gboolean _tmp19_;
	GeeArrayList* _tmp32_;
	GFile* _tmp33_;
	gboolean _tmp34_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_doc;
	_tmp1_ = document_is_main_file_a_tex_file (_tmp0_);
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->_doc;
	_tmp3_ = document_get_project (_tmp2_);
	project = _tmp3_;
	_tmp4_ = project;
	if (_tmp4_ != NULL) {
		Project* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		GeeArrayList* _tmp9_ = NULL;
		_tmp5_ = project;
		_tmp6_ = (*_tmp5_).directory;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (directory);
		directory = _tmp7_;
		_tmp8_ = directory;
		_tmp9_ = clean_build_files_get_build_files_in_directory (self, _tmp8_);
		_g_object_unref0 (files_to_delete);
		files_to_delete = _tmp9_;
	} else {
		Document* _tmp10_;
		GFile* _tmp11_;
		GFile* _tmp12_;
		GFile* _tmp13_ = NULL;
		GeeArrayList* _tmp14_ = NULL;
		_tmp10_ = self->priv->_doc;
		_tmp11_ = document_get_location (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_file_get_parent (_tmp12_);
		_g_object_unref0 (directory);
		directory = _tmp13_;
		_tmp14_ = clean_build_files_get_build_files_simple (self);
		_g_object_unref0 (files_to_delete);
		files_to_delete = _tmp14_;
	}
	_tmp15_ = files_to_delete;
	_tmp16_ = gee_collection_get_size ((GeeCollection*) _tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ == 0) {
		gboolean _tmp18_;
		_tmp18_ = self->priv->_no_confirm;
		if (!_tmp18_) {
			clean_build_files_show_info_no_file (self);
		}
		result = FALSE;
		_project_free0 (project);
		_g_object_unref0 (directory);
		_g_object_unref0 (files_to_delete);
		return result;
	}
	_tmp19_ = self->priv->_no_confirm;
	if (_tmp19_) {
		{
			GeeArrayList* _tmp20_;
			GeeArrayList* _tmp21_;
			GeeArrayList* _file_to_delete_list;
			GeeArrayList* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			gint _file_to_delete_size;
			gint _file_to_delete_index;
			_tmp20_ = files_to_delete;
			_tmp21_ = _g_object_ref0 (_tmp20_);
			_file_to_delete_list = _tmp21_;
			_tmp22_ = _file_to_delete_list;
			_tmp23_ = gee_collection_get_size ((GeeCollection*) _tmp22_);
			_tmp24_ = _tmp23_;
			_file_to_delete_size = _tmp24_;
			_file_to_delete_index = -1;
			while (TRUE) {
				gint _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				GeeArrayList* _tmp28_;
				gint _tmp29_;
				gpointer _tmp30_ = NULL;
				GFile* file_to_delete;
				GFile* _tmp31_;
				_tmp25_ = _file_to_delete_index;
				_file_to_delete_index = _tmp25_ + 1;
				_tmp26_ = _file_to_delete_index;
				_tmp27_ = _file_to_delete_size;
				if (!(_tmp26_ < _tmp27_)) {
					break;
				}
				_tmp28_ = _file_to_delete_list;
				_tmp29_ = _file_to_delete_index;
				_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _tmp29_);
				file_to_delete = (GFile*) _tmp30_;
				_tmp31_ = file_to_delete;
				utils_delete_file (_tmp31_);
				_g_object_unref0 (file_to_delete);
			}
			_g_object_unref0 (_file_to_delete_list);
		}
		result = TRUE;
		_project_free0 (project);
		_g_object_unref0 (directory);
		_g_object_unref0 (files_to_delete);
		return result;
	}
	_tmp32_ = files_to_delete;
	_tmp33_ = directory;
	_tmp34_ = clean_build_files_confirm_cleanup (self, _tmp32_, _tmp33_);
	result = _tmp34_;
	_project_free0 (project);
	_g_object_unref0 (directory);
	_g_object_unref0 (files_to_delete);
	return result;
}


static GeeArrayList* clean_build_files_get_build_files_simple (CleanBuildFiles* self) {
	GeeArrayList* result = NULL;
	Document* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* location;
	GFile* _tmp4_;
	GFile* _tmp5_ = NULL;
	GFile* directory;
	GFile* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* shortname;
	GeeArrayList* _tmp11_;
	GeeArrayList* files_to_delete;
	gchar** _tmp12_;
	gint _tmp12__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_doc;
	_tmp1_ = document_get_location (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	location = _tmp3_;
	_tmp4_ = location;
	_tmp5_ = g_file_get_parent (_tmp4_);
	directory = _tmp5_;
	_tmp6_ = location;
	_tmp7_ = g_file_get_basename (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = utils_get_shortname (_tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	shortname = _tmp10_;
	_tmp11_ = gee_array_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	files_to_delete = _tmp11_;
	_tmp12_ = self->priv->_extensions;
	_tmp12__length1 = self->priv->_extensions_length1;
	{
		gchar** extension_collection = NULL;
		gint extension_collection_length1 = 0;
		gint _extension_collection_size_ = 0;
		gint extension_it = 0;
		extension_collection = _tmp12_;
		extension_collection_length1 = _tmp12__length1;
		for (extension_it = 0; extension_it < _tmp12__length1; extension_it = extension_it + 1) {
			gchar* _tmp13_;
			gchar* extension = NULL;
			_tmp13_ = g_strdup (extension_collection[extension_it]);
			extension = _tmp13_;
			{
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* basename;
				GFile* _tmp17_;
				const gchar* _tmp18_;
				GFile* _tmp19_ = NULL;
				GFile* file;
				GFile* _tmp20_;
				gboolean _tmp21_ = FALSE;
				_tmp14_ = shortname;
				_tmp15_ = extension;
				_tmp16_ = g_strconcat (_tmp14_, _tmp15_, NULL);
				basename = _tmp16_;
				_tmp17_ = directory;
				_tmp18_ = basename;
				_tmp19_ = g_file_get_child (_tmp17_, _tmp18_);
				file = _tmp19_;
				_tmp20_ = file;
				_tmp21_ = g_file_query_exists (_tmp20_, NULL);
				if (_tmp21_) {
					GeeArrayList* _tmp22_;
					GFile* _tmp23_;
					_tmp22_ = files_to_delete;
					_tmp23_ = file;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
				}
				_g_object_unref0 (file);
				_g_free0 (basename);
				_g_free0 (extension);
			}
		}
	}
	result = files_to_delete;
	_g_free0 (shortname);
	_g_object_unref0 (directory);
	_g_object_unref0 (location);
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static GeeArrayList* clean_build_files_get_build_files_in_directory (CleanBuildFiles* self, GFile* directory) {
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* files_to_delete;
	GFileEnumerator* enumerator = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (directory != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	files_to_delete = _tmp0_;
	{
		GFile* _tmp1_;
		GFileEnumerator* _tmp2_ = NULL;
		GFileEnumerator* _tmp3_;
		_tmp1_ = directory;
		_tmp2_ = g_file_enumerate_children (_tmp1_, "standard::type,standard::name", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch47_g_error;
		}
		_g_object_unref0 (enumerator);
		enumerator = _tmp3_;
	}
	goto __finally47;
	__catch47_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("clean_build_files.vala:122: Clean build files: %s", _tmp5_);
		result = files_to_delete;
		_g_error_free0 (e);
		_g_object_unref0 (enumerator);
		return result;
	}
	__finally47:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (enumerator);
		_g_object_unref0 (files_to_delete);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	while (TRUE) {
		GFileInfo* info;
		GFileInfo* _tmp11_;
		GFileInfo* _tmp12_;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		gchar* name;
		const gchar* _tmp15_;
		gchar _tmp16_ = '\0';
		GFile* _tmp17_;
		const gchar* _tmp18_;
		GFile* _tmp19_ = NULL;
		GFile* file;
		GFileInfo* _tmp20_;
		GFileType _tmp21_ = 0;
		GFileType type;
		GFileType _tmp22_;
		const gchar* _tmp27_;
		gchar* _tmp28_ = NULL;
		gchar* extension;
		const gchar* _tmp29_;
		gchar** _tmp30_;
		gint _tmp30__length1;
		info = NULL;
		{
			GFileEnumerator* _tmp6_;
			GFileInfo* _tmp7_ = NULL;
			GFileInfo* _tmp8_;
			_tmp6_ = enumerator;
			_tmp7_ = g_file_enumerator_next_file (_tmp6_, NULL, &_inner_error_);
			_tmp8_ = _tmp7_;
			if (_inner_error_ != NULL) {
				goto __catch48_g_error;
			}
			_g_object_unref0 (info);
			info = _tmp8_;
		}
		goto __finally48;
		__catch48_g_error:
		{
			GError* e = NULL;
			GError* _tmp9_;
			const gchar* _tmp10_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			g_warning ("clean_build_files.vala:136: Clean build files: %s", _tmp10_);
			_g_error_free0 (e);
			_g_object_unref0 (info);
			break;
		}
		__finally48:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (info);
			_g_object_unref0 (enumerator);
			_g_object_unref0 (files_to_delete);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp11_ = info;
		if (_tmp11_ == NULL) {
			_g_object_unref0 (info);
			break;
		}
		_tmp12_ = info;
		_tmp13_ = g_file_info_get_name (_tmp12_);
		_tmp14_ = g_strdup (_tmp13_);
		name = _tmp14_;
		_tmp15_ = name;
		_tmp16_ = string_get (_tmp15_, (glong) 0);
		if (_tmp16_ == '.') {
			_g_free0 (name);
			_g_object_unref0 (info);
			continue;
		}
		_tmp17_ = directory;
		_tmp18_ = name;
		_tmp19_ = g_file_get_child (_tmp17_, _tmp18_);
		file = _tmp19_;
		_tmp20_ = info;
		_tmp21_ = g_file_info_get_file_type (_tmp20_);
		type = _tmp21_;
		_tmp22_ = type;
		if (_tmp22_ == G_FILE_TYPE_DIRECTORY) {
			GFile* _tmp23_;
			GeeArrayList* _tmp24_ = NULL;
			GeeArrayList* files_to_delete_in_dir;
			GeeArrayList* _tmp25_;
			GeeArrayList* _tmp26_;
			_tmp23_ = file;
			_tmp24_ = clean_build_files_get_build_files_in_directory (self, _tmp23_);
			files_to_delete_in_dir = _tmp24_;
			_tmp25_ = files_to_delete;
			_tmp26_ = files_to_delete_in_dir;
			gee_abstract_collection_add_all ((GeeAbstractCollection*) _tmp25_, (GeeCollection*) _tmp26_);
			_g_object_unref0 (files_to_delete_in_dir);
			_g_object_unref0 (file);
			_g_free0 (name);
			_g_object_unref0 (info);
			continue;
		}
		_tmp27_ = name;
		_tmp28_ = utils_get_extension (_tmp27_);
		extension = _tmp28_;
		_tmp29_ = extension;
		_tmp30_ = self->priv->_extensions;
		_tmp30__length1 = self->priv->_extensions_length1;
		if (_vala_string_array_contains (_tmp30_, _tmp30__length1, _tmp29_)) {
			GeeArrayList* _tmp31_;
			GFile* _tmp32_;
			_tmp31_ = files_to_delete;
			_tmp32_ = file;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp31_, _tmp32_);
		}
		_g_free0 (extension);
		_g_object_unref0 (file);
		_g_free0 (name);
		_g_object_unref0 (info);
	}
	result = files_to_delete;
	_g_object_unref0 (enumerator);
	return result;
}


static gboolean clean_build_files_confirm_cleanup (CleanBuildFiles* self, GeeArrayList* files_to_delete, GFile* directory) {
	gboolean result = FALSE;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeArrayList* _tmp3_;
	GFile* _tmp4_;
	GtkTreeView* _tmp5_ = NULL;
	GtkTreeView* list_files;
	GtkDialog* _tmp6_ = NULL;
	GtkDialog* dialog;
	GtkTreeModel* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (files_to_delete != NULL, FALSE);
	g_return_val_if_fail (directory != NULL, FALSE);
	_tmp0_ = files_to_delete;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	g_return_val_if_fail (0 < _tmp2_, FALSE);
	_tmp3_ = files_to_delete;
	_tmp4_ = directory;
	_tmp5_ = clean_build_files_get_list_files (self, _tmp3_, _tmp4_);
	list_files = _tmp5_;
	_tmp6_ = clean_build_files_get_dialog (self, list_files);
	dialog = _tmp6_;
	_tmp7_ = gtk_tree_view_get_model (list_files);
	_tmp8_ = clean_build_files_run_dialog (self, dialog, _tmp7_);
	result = _tmp8_;
	_g_object_unref0 (dialog);
	_g_object_unref0 (list_files);
	return result;
}


static Block14Data* block14_data_ref (Block14Data* _data14_) {
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}


static void block14_data_unref (Block14Data* _data14_) {
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		CleanBuildFiles * self;
		self = _data14_->self;
		_g_object_unref0 (_data14_->store);
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}


static gint _clean_build_files_on_sort_list_files_gtk_tree_iter_compare_func (GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b, gpointer self) {
	gint result;
	result = clean_build_files_on_sort_list_files (self, model, a, b);
	return result;
}


static void __lambda51_ (Block14Data* _data14_, const gchar* path_str) {
	CleanBuildFiles * self;
	const gchar* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* path;
	GtkTreeIter iter = {0};
	gboolean active = FALSE;
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_ = {0};
	GtkListStore* _tmp4_;
	GtkTreeIter _tmp5_;
	GtkListStore* _tmp6_;
	GtkTreeIter _tmp7_;
	self = _data14_->self;
	g_return_if_fail (path_str != NULL);
	_tmp0_ = path_str;
	_tmp1_ = gtk_tree_path_new_from_string (_tmp0_);
	path = _tmp1_;
	_tmp2_ = _data14_->store;
	gtk_tree_model_get_iter ((GtkTreeModel*) _tmp2_, &_tmp3_, path);
	iter = _tmp3_;
	_tmp4_ = _data14_->store;
	_tmp5_ = iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp4_, &_tmp5_, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE, &active, -1, -1);
	_tmp6_ = _data14_->store;
	_tmp7_ = iter;
	gtk_list_store_set (_tmp6_, &_tmp7_, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE, !active, -1, -1);
	_gtk_tree_path_free0 (path);
}


static void ___lambda51__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self) {
	__lambda51_ (self, path);
}


static GtkTreeView* clean_build_files_get_list_files (CleanBuildFiles* self, GeeArrayList* files_to_delete, GFile* directory) {
	GtkTreeView* result = NULL;
	Block14Data* _data14_;
	GtkTreeView* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeView* treeview;
	GtkTreeView* _tmp2_;
	GtkTreeView* _tmp3_;
	GtkTreeView* _tmp4_;
	GtkListStore* _tmp5_;
	GtkListStore* _tmp6_;
	GtkListStore* _tmp7_;
	GtkTreeView* _tmp29_;
	GtkListStore* _tmp30_;
	GtkCellRendererToggle* _tmp31_;
	GtkCellRendererToggle* _tmp32_;
	GtkCellRendererToggle* toggle_renderer;
	GtkTreeViewColumn* _tmp33_;
	GtkTreeViewColumn* _tmp34_;
	GtkTreeViewColumn* column;
	GtkTreeView* _tmp35_;
	GtkTreeViewColumn* _tmp36_;
	GtkCellRendererText* _tmp37_;
	GtkCellRendererText* _tmp38_;
	GtkCellRendererText* text_renderer;
	GtkTreeViewColumn* _tmp39_;
	GtkTreeViewColumn* _tmp40_;
	GtkTreeView* _tmp41_;
	GtkTreeViewColumn* _tmp42_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (files_to_delete != NULL, NULL);
	g_return_val_if_fail (directory != NULL, NULL);
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->self = g_object_ref (self);
	_tmp0_ = (GtkTreeView*) gtk_tree_view_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	treeview = _tmp1_;
	_tmp2_ = treeview;
	gtk_widget_set_size_request ((GtkWidget*) _tmp2_, 260, 120);
	_tmp3_ = treeview;
	gtk_tree_view_set_headers_visible (_tmp3_, FALSE);
	_tmp4_ = treeview;
	gtk_tree_view_set_enable_search (_tmp4_, FALSE);
	_tmp5_ = gtk_list_store_new ((gint) CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_N_COLUMNS, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_FILE);
	_data14_->store = _tmp5_;
	_tmp6_ = _data14_->store;
	gtk_tree_sortable_set_sort_func ((GtkTreeSortable*) _tmp6_, 0, _clean_build_files_on_sort_list_files_gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
	_tmp7_ = _data14_->store;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp7_, 0, GTK_SORT_ASCENDING);
	{
		GeeArrayList* _tmp8_;
		GeeArrayList* _tmp9_;
		GeeArrayList* _file_to_delete_list;
		GeeArrayList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _file_to_delete_size;
		gint _file_to_delete_index;
		_tmp8_ = files_to_delete;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_file_to_delete_list = _tmp9_;
		_tmp10_ = _file_to_delete_list;
		_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_file_to_delete_size = _tmp12_;
		_file_to_delete_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			GeeArrayList* _tmp16_;
			gint _tmp17_;
			gpointer _tmp18_ = NULL;
			GFile* file_to_delete;
			GFile* _tmp19_;
			GFile* _tmp20_;
			GFile* _tmp21_;
			gchar* _tmp22_ = NULL;
			gchar* relative_path;
			GtkTreeIter iter = {0};
			GtkListStore* _tmp23_;
			GtkTreeIter _tmp24_ = {0};
			GtkListStore* _tmp25_;
			GtkTreeIter _tmp26_;
			const gchar* _tmp27_;
			GFile* _tmp28_;
			_tmp13_ = _file_to_delete_index;
			_file_to_delete_index = _tmp13_ + 1;
			_tmp14_ = _file_to_delete_index;
			_tmp15_ = _file_to_delete_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _file_to_delete_list;
			_tmp17_ = _file_to_delete_index;
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
			file_to_delete = (GFile*) _tmp18_;
			_tmp19_ = directory;
			_tmp20_ = file_to_delete;
			_tmp21_ = directory;
			_tmp22_ = utils_get_relative_path (_tmp19_, _tmp20_, _tmp21_);
			relative_path = _tmp22_;
			_tmp23_ = _data14_->store;
			gtk_list_store_append (_tmp23_, &_tmp24_);
			iter = _tmp24_;
			_tmp25_ = _data14_->store;
			_tmp26_ = iter;
			_tmp27_ = relative_path;
			_tmp28_ = file_to_delete;
			gtk_list_store_set (_tmp25_, &_tmp26_, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE, TRUE, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME, _tmp27_, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_FILE, _tmp28_, -1, -1);
			_g_free0 (relative_path);
			_g_object_unref0 (file_to_delete);
		}
		_g_object_unref0 (_file_to_delete_list);
	}
	_tmp29_ = treeview;
	_tmp30_ = _data14_->store;
	gtk_tree_view_set_model (_tmp29_, (GtkTreeModel*) _tmp30_);
	_tmp31_ = (GtkCellRendererToggle*) gtk_cell_renderer_toggle_new ();
	_tmp32_ = g_object_ref_sink (_tmp31_);
	toggle_renderer = _tmp32_;
	g_signal_connect_data (toggle_renderer, "toggled", (GCallback) ___lambda51__gtk_cell_renderer_toggle_toggled, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
	_tmp33_ = gtk_tree_view_column_new_with_attributes ("Delete?", (GtkCellRenderer*) toggle_renderer, "active", CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE, NULL, NULL);
	_tmp34_ = g_object_ref_sink (_tmp33_);
	column = _tmp34_;
	_tmp35_ = treeview;
	_tmp36_ = column;
	gtk_tree_view_append_column (_tmp35_, _tmp36_);
	_tmp37_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp38_ = g_object_ref_sink (_tmp37_);
	text_renderer = _tmp38_;
	_tmp39_ = gtk_tree_view_column_new_with_attributes ("Name", (GtkCellRenderer*) text_renderer, "text", CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME, NULL, NULL);
	_tmp40_ = g_object_ref_sink (_tmp39_);
	_g_object_unref0 (column);
	column = _tmp40_;
	_tmp41_ = treeview;
	_tmp42_ = column;
	gtk_tree_view_append_column (_tmp41_, _tmp42_);
	result = treeview;
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (column);
	_g_object_unref0 (toggle_renderer);
	block14_data_unref (_data14_);
	_data14_ = NULL;
	return result;
}


static GtkDialog* clean_build_files_get_dialog (CleanBuildFiles* self, GtkTreeView* list_files) {
	GtkDialog* result = NULL;
	MainWindow* _tmp0_;
	GtkDialog* _tmp1_;
	GtkDialog* _tmp2_;
	GtkDialog* dialog;
	GtkHBox* _tmp3_;
	GtkHBox* _tmp4_;
	GtkHBox* hbox;
	GtkWidget* _tmp5_ = NULL;
	GtkVBox* _tmp6_;
	GtkVBox* content_area;
	GtkImage* _tmp7_;
	GtkImage* _tmp8_;
	GtkImage* image;
	GtkVBox* _tmp9_;
	GtkVBox* _tmp10_;
	GtkVBox* vbox;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* primary_label;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GtkVBox* _tmp18_;
	GtkVBox* _tmp19_;
	GtkVBox* vbox2;
	const gchar* _tmp20_ = NULL;
	GtkLabel* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* select_label;
	GtkTreeView* _tmp23_;
	GtkWidget* _tmp24_ = NULL;
	GtkScrolledWindow* sw;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (list_files != NULL, NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = (GtkDialog*) gtk_dialog_new_with_buttons (NULL, (GtkWindow*) _tmp0_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_DELETE, GTK_RESPONSE_ACCEPT, NULL, NULL);
	_tmp2_ = g_object_ref_sink (_tmp1_);
	dialog = _tmp2_;
	gtk_dialog_set_has_separator (dialog, FALSE);
	_tmp3_ = (GtkHBox*) gtk_hbox_new (FALSE, 12);
	_tmp4_ = g_object_ref_sink (_tmp3_);
	hbox = _tmp4_;
	gtk_container_set_border_width ((GtkContainer*) hbox, (guint) 5);
	_tmp5_ = gtk_dialog_get_content_area (dialog);
	_tmp6_ = _g_object_ref0 (GTK_IS_VBOX (_tmp5_) ? ((GtkVBox*) _tmp5_) : NULL);
	content_area = _tmp6_;
	gtk_box_pack_start ((GtkBox*) content_area, (GtkWidget*) hbox, TRUE, TRUE, (guint) 0);
	_tmp7_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_DIALOG_WARNING, GTK_ICON_SIZE_DIALOG);
	_tmp8_ = g_object_ref_sink (_tmp7_);
	image = _tmp8_;
	gtk_misc_set_alignment ((GtkMisc*) image, (gfloat) 0.5, (gfloat) 0.0);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
	_tmp9_ = (GtkVBox*) gtk_vbox_new (FALSE, 12);
	_tmp10_ = g_object_ref_sink (_tmp9_);
	vbox = _tmp10_;
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) vbox, TRUE, TRUE, (guint) 0);
	_tmp11_ = (GtkLabel*) gtk_label_new (NULL);
	_tmp12_ = g_object_ref_sink (_tmp11_);
	primary_label = _tmp12_;
	gtk_label_set_line_wrap (primary_label, TRUE);
	gtk_label_set_use_markup (primary_label, TRUE);
	gtk_misc_set_alignment ((GtkMisc*) primary_label, (gfloat) 0.0, (gfloat) 0.5);
	gtk_label_set_selectable (primary_label, TRUE);
	_tmp13_ = _ ("Do you really want to delete these files?");
	_tmp14_ = g_strconcat ("<span weight=\"bold\" size=\"larger\">", _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strconcat (_tmp15_, "</span>", NULL);
	_tmp17_ = _tmp16_;
	gtk_label_set_markup (primary_label, _tmp17_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) primary_label, FALSE, FALSE, (guint) 0);
	_tmp18_ = (GtkVBox*) gtk_vbox_new (FALSE, 8);
	_tmp19_ = g_object_ref_sink (_tmp18_);
	vbox2 = _tmp19_;
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) vbox2, TRUE, TRUE, (guint) 0);
	_tmp20_ = _ ("Select the files you want to delete:");
	_tmp21_ = (GtkLabel*) gtk_label_new (_tmp20_);
	_tmp22_ = g_object_ref_sink (_tmp21_);
	select_label = _tmp22_;
	gtk_label_set_line_wrap (select_label, TRUE);
	gtk_misc_set_alignment ((GtkMisc*) select_label, (gfloat) 0.0, (gfloat) 0.5);
	gtk_box_pack_start ((GtkBox*) vbox2, (GtkWidget*) select_label, FALSE, FALSE, (guint) 0);
	_tmp23_ = list_files;
	_tmp24_ = utils_add_scrollbar ((GtkWidget*) _tmp23_);
	sw = GTK_IS_SCROLLED_WINDOW (_tmp24_) ? ((GtkScrolledWindow*) _tmp24_) : NULL;
	gtk_scrolled_window_set_shadow_type (sw, GTK_SHADOW_IN);
	gtk_box_pack_start ((GtkBox*) vbox2, (GtkWidget*) sw, TRUE, TRUE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) hbox);
	result = dialog;
	_g_object_unref0 (sw);
	_g_object_unref0 (select_label);
	_g_object_unref0 (vbox2);
	_g_object_unref0 (primary_label);
	_g_object_unref0 (vbox);
	_g_object_unref0 (image);
	_g_object_unref0 (content_area);
	_g_object_unref0 (hbox);
	return result;
}


static void _vala_array_add12 (GFile*** array, int* length, int* size, GFile* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean clean_build_files_run_dialog (CleanBuildFiles* self, GtkDialog* dialog, GtkTreeModel* list_store) {
	gboolean result = FALSE;
	gboolean ret;
	GtkDialog* _tmp0_;
	gint _tmp1_ = 0;
	GtkDialog* _tmp19_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dialog != NULL, FALSE);
	g_return_val_if_fail (list_store != NULL, FALSE);
	ret = FALSE;
	_tmp0_ = dialog;
	_tmp1_ = gtk_dialog_run (_tmp0_);
	if (_tmp1_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		GFile** _tmp2_ = NULL;
		GFile** selected_files;
		gint selected_files_length1;
		gint _selected_files_size_;
		GtkTreeIter iter = {0};
		GtkTreeModel* _tmp3_;
		GtkTreeIter _tmp4_ = {0};
		gboolean _tmp5_ = FALSE;
		gboolean valid;
		GFile** _tmp15_;
		gint _tmp15__length1;
		GFile** _tmp16_;
		gint _tmp16__length1;
		_tmp2_ = g_new0 (GFile*, 0 + 1);
		selected_files = _tmp2_;
		selected_files_length1 = 0;
		_selected_files_size_ = selected_files_length1;
		_tmp3_ = list_store;
		_tmp5_ = gtk_tree_model_get_iter_first (_tmp3_, &_tmp4_);
		iter = _tmp4_;
		valid = _tmp5_;
		while (TRUE) {
			gboolean _tmp6_;
			gboolean selected = FALSE;
			GFile* file_to_delete = NULL;
			GtkTreeModel* _tmp7_;
			GtkTreeIter _tmp8_;
			gboolean _tmp9_;
			GtkTreeModel* _tmp13_;
			gboolean _tmp14_ = FALSE;
			_tmp6_ = valid;
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = list_store;
			_tmp8_ = iter;
			gtk_tree_model_get (_tmp7_, &_tmp8_, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE, &selected, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_FILE, &file_to_delete, -1, -1);
			_tmp9_ = selected;
			if (_tmp9_) {
				GFile** _tmp10_;
				gint _tmp10__length1;
				GFile* _tmp11_;
				GFile* _tmp12_;
				_tmp10_ = selected_files;
				_tmp10__length1 = selected_files_length1;
				_tmp11_ = file_to_delete;
				_tmp12_ = _g_object_ref0 (_tmp11_);
				_vala_array_add12 (&selected_files, &selected_files_length1, &_selected_files_size_, _tmp12_);
			}
			_tmp13_ = list_store;
			_tmp14_ = gtk_tree_model_iter_next (_tmp13_, &iter);
			valid = _tmp14_;
			_g_object_unref0 (file_to_delete);
		}
		_tmp15_ = selected_files;
		_tmp15__length1 = selected_files_length1;
		ret = 0 < _tmp15__length1;
		_tmp16_ = selected_files;
		_tmp16__length1 = selected_files_length1;
		{
			GFile** file_to_delete_collection = NULL;
			gint file_to_delete_collection_length1 = 0;
			gint _file_to_delete_collection_size_ = 0;
			gint file_to_delete_it = 0;
			file_to_delete_collection = _tmp16_;
			file_to_delete_collection_length1 = _tmp16__length1;
			for (file_to_delete_it = 0; file_to_delete_it < _tmp16__length1; file_to_delete_it = file_to_delete_it + 1) {
				GFile* _tmp17_;
				GFile* file_to_delete = NULL;
				_tmp17_ = _g_object_ref0 (file_to_delete_collection[file_to_delete_it]);
				file_to_delete = _tmp17_;
				{
					GFile* _tmp18_;
					_tmp18_ = file_to_delete;
					utils_delete_file (_tmp18_);
					_g_object_unref0 (file_to_delete);
				}
			}
		}
		selected_files = (_vala_array_free (selected_files, selected_files_length1, (GDestroyNotify) g_object_unref), NULL);
	}
	_tmp19_ = dialog;
	gtk_object_destroy ((GtkObject*) _tmp19_);
	result = ret;
	return result;
}


static gint clean_build_files_on_sort_list_files (CleanBuildFiles* self, GtkTreeModel* model, GtkTreeIter* a, GtkTreeIter* b) {
	gint result = 0;
	gchar* name_a = NULL;
	gchar* name_b = NULL;
	GtkTreeModel* _tmp0_;
	GtkTreeIter _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeIter _tmp3_;
	gint _tmp4_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (model != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = model;
	_tmp1_ = *a;
	gtk_tree_model_get (_tmp0_, &_tmp1_, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME, &name_a, -1, -1);
	_tmp2_ = model;
	_tmp3_ = *b;
	gtk_tree_model_get (_tmp2_, &_tmp3_, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME, &name_b, -1, -1);
	_tmp4_ = g_utf8_collate (name_a, name_b);
	result = _tmp4_;
	_g_free0 (name_b);
	_g_free0 (name_a);
	return result;
}


static void clean_build_files_show_info_no_file (CleanBuildFiles* self) {
	MainWindow* _tmp0_;
	const gchar* _tmp1_ = NULL;
	GtkMessageDialog* _tmp2_;
	GtkDialog* _tmp3_;
	GtkDialog* dialog;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = _ ("No build file to clean up.");
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp0_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "%s", _tmp1_);
	_tmp3_ = (GtkDialog*) g_object_ref_sink (_tmp2_);
	dialog = _tmp3_;
	gtk_dialog_run (dialog);
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (dialog);
}


static void clean_build_files_class_init (CleanBuildFilesClass * klass) {
	clean_build_files_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CleanBuildFilesPrivate));
	G_OBJECT_CLASS (klass)->finalize = clean_build_files_finalize;
}


static void clean_build_files_instance_init (CleanBuildFiles * self) {
	self->priv = CLEAN_BUILD_FILES_GET_PRIVATE (self);
}


static void clean_build_files_finalize (GObject* obj) {
	CleanBuildFiles * self;
	self = CLEAN_BUILD_FILES (obj);
	_g_object_unref0 (self->priv->_doc);
	self->priv->_extensions = (_vala_array_free (self->priv->_extensions, self->priv->_extensions_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (clean_build_files_parent_class)->finalize (obj);
}


GType clean_build_files_get_type (void) {
	static volatile gsize clean_build_files_type_id__volatile = 0;
	if (g_once_init_enter (&clean_build_files_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CleanBuildFilesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clean_build_files_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CleanBuildFiles), 0, (GInstanceInitFunc) clean_build_files_instance_init, NULL };
		GType clean_build_files_type_id;
		clean_build_files_type_id = g_type_register_static (G_TYPE_OBJECT, "CleanBuildFiles", &g_define_type_info, 0);
		g_once_init_leave (&clean_build_files_type_id__volatile, clean_build_files_type_id);
	}
	return clean_build_files_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



