/* build_tools.c generated by valac 0.14.0.77-0077, the Vala compiler
 * generated from build_tools.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include "config.h"
#include <gobject/gvaluecollector.h>


#define TYPE_POST_PROCESSOR_TYPE (post_processor_type_get_type ())

#define TYPE_BUILD_JOB (build_job_get_type ())
typedef struct _BuildJob BuildJob;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BUILD_TOOL (build_tool_get_type ())
typedef struct _BuildTool BuildTool;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DOC_TYPE (doc_type_get_type ())

#define TYPE_BUILD_TOOLS (build_tools_get_type ())
#define BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS, BuildTools))
#define BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS, BuildToolsClass))
#define IS_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS))
#define IS_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS))
#define BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS, BuildToolsClass))

typedef struct _BuildTools BuildTools;
typedef struct _BuildToolsClass BuildToolsClass;
typedef struct _BuildToolsPrivate BuildToolsPrivate;
#define _build_tools_unref0(var) ((var == NULL) ? NULL : (var = (build_tools_unref (var), NULL)))
#define _build_tool_free0(var) ((var == NULL) ? NULL : (var = (build_tool_free (var), NULL)))
#define _build_job_free0(var) ((var == NULL) ? NULL : (var = (build_job_free (var), NULL)))

#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_markup_parse_context_free0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecBuildTools ParamSpecBuildTools;

typedef enum  {
	POST_PROCESSOR_TYPE_ALL_OUTPUT = 0,
	POST_PROCESSOR_TYPE_LATEX,
	POST_PROCESSOR_TYPE_LATEXMK,
	POST_PROCESSOR_TYPE_NO_OUTPUT,
	POST_PROCESSOR_TYPE_RUBBER,
	POST_PROCESSOR_TYPE_N_POST_PROCESSORS
} PostProcessorType;

struct _BuildJob {
	gboolean must_succeed;
	PostProcessorType post_processor;
	gchar* command;
};

struct _BuildTool {
	gchar* description;
	gchar* extensions;
	gchar* label;
	gchar* icon;
	gboolean show;
	gboolean compilation;
	GeeArrayList* jobs;
};

typedef enum  {
	DOC_TYPE_DVI,
	DOC_TYPE_PDF,
	DOC_TYPE_PS,
	DOC_TYPE_LAST
} DocType;

struct _BuildTools {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BuildToolsPrivate * priv;
};

struct _BuildToolsClass {
	GTypeClass parent_class;
	void (*finalize) (BuildTools *self);
};

struct _BuildToolsPrivate {
	GeeLinkedList* _build_tools;
	BuildTool _cur_tool;
	BuildJob _cur_job;
	gboolean _modified;
};

struct _ParamSpecBuildTools {
	GParamSpec parent_instance;
};


static gpointer build_tools_parent_class = NULL;
static BuildTools* build_tools__instance;
static BuildTools* build_tools__instance = NULL;
static gchar** build_tools__post_processor_names;
static gint build_tools__post_processor_names_length1;
static gchar** build_tools__post_processor_names = NULL;
static gint build_tools__post_processor_names_length1 = 0;
static gint _build_tools__post_processor_names_size_ = 0;

GType post_processor_type_get_type (void) G_GNUC_CONST;
GType build_job_get_type (void) G_GNUC_CONST;
BuildJob* build_job_dup (const BuildJob* self);
void build_job_free (BuildJob* self);
void build_job_copy (const BuildJob* self, BuildJob* dest);
void build_job_destroy (BuildJob* self);
GType build_tool_get_type (void) G_GNUC_CONST;
BuildTool* build_tool_dup (const BuildTool* self);
void build_tool_free (BuildTool* self);
void build_tool_copy (const BuildTool* self, BuildTool* dest);
void build_tool_destroy (BuildTool* self);
GType doc_type_get_type (void) G_GNUC_CONST;
gpointer build_tools_ref (gpointer instance);
void build_tools_unref (gpointer instance);
GParamSpec* param_spec_build_tools (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_build_tools (GValue* value, gpointer v_object);
void value_take_build_tools (GValue* value, gpointer v_object);
gpointer value_get_build_tools (const GValue* value);
GType build_tools_get_type (void) G_GNUC_CONST;
#define BUILD_TOOLS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BUILD_TOOLS, BuildToolsPrivate))
enum  {
	BUILD_TOOLS_DUMMY_PROPERTY
};
static BuildTools* build_tools_new (void);
static BuildTools* build_tools_construct (GType object_type);
static void build_tools_load (BuildTools* self);
BuildTools* build_tools_get_default (void);
BuildTool* build_tools_get (BuildTools* self, gint id);
GeeIterator* build_tools_iterator (BuildTools* self);
BuildTool* build_tools_get_view_doc (BuildTools* self, DocType type);
gboolean build_tools_is_empty (BuildTools* self);
void build_tools_move_up (BuildTools* self, gint num);
static void build_tools_swap (BuildTools* self, gint num1, gint num2);
void build_tools_move_down (BuildTools* self, gint num);
static void build_tools_update_all_menus (BuildTools* self);
void build_tools_delete (BuildTools* self, gint num);
void build_tools_add (BuildTools* self, BuildTool* tool);
void build_tools_insert (BuildTools* self, gint pos, BuildTool* tool);
static gboolean build_tools_is_compilation (BuildTools* self, const gchar* icon);
void build_tools_update (BuildTools* self, gint num, BuildTool* tool, gboolean keep_show);
static gboolean build_tools_is_equal (BuildTools* self, BuildTool* tool1, BuildTool* tool2);
void build_tools_reset_all (BuildTools* self);
static GFile* build_tools_get_user_config_file (BuildTools* self);
void utils_delete_file (GFile* file);
GType application_get_type (void) G_GNUC_CONST;
Application* application_get_default (void);
GType main_window_get_type (void) G_GNUC_CONST;
GList* application_get_windows (Application* self);
void main_window_update_build_tools_menu (MainWindow* self);
static void _vala_array_add7 (GFile*** array, int* length, int* size, GFile* value);
static void _vala_array_add8 (GFile*** array, int* length, int* size, GFile* value);
static void build_tools_parser_start (BuildTools* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error);
static void _build_tools_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error);
static void build_tools_parser_end (BuildTools* self, GMarkupParseContext* context, const gchar* name, GError** error);
static void _build_tools_parser_end_gmarkup_parser_end_element_func (GMarkupParseContext* context, const gchar* element_name, gpointer self, GError** error);
static void build_tools_parser_text (BuildTools* self, GMarkupParseContext* context, const gchar* text, gsize text_len, GError** error);
static void _build_tools_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context, const gchar* text, gsize text_len, gpointer self, GError** error);
PostProcessorType* build_tools_get_post_processor_type_from_name (const gchar* name);
void build_tools_save (BuildTools* self);
gchar* build_tools_get_post_processor_name_from_type (PostProcessorType type);
static PostProcessorType* _post_processor_type_dup (PostProcessorType* self);
static void build_tools_finalize (BuildTools* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType post_processor_type_get_type (void) {
	static volatile gsize post_processor_type_type_id__volatile = 0;
	if (g_once_init_enter (&post_processor_type_type_id__volatile)) {
		static const GEnumValue values[] = {{POST_PROCESSOR_TYPE_ALL_OUTPUT, "POST_PROCESSOR_TYPE_ALL_OUTPUT", "all-output"}, {POST_PROCESSOR_TYPE_LATEX, "POST_PROCESSOR_TYPE_LATEX", "latex"}, {POST_PROCESSOR_TYPE_LATEXMK, "POST_PROCESSOR_TYPE_LATEXMK", "latexmk"}, {POST_PROCESSOR_TYPE_NO_OUTPUT, "POST_PROCESSOR_TYPE_NO_OUTPUT", "no-output"}, {POST_PROCESSOR_TYPE_RUBBER, "POST_PROCESSOR_TYPE_RUBBER", "rubber"}, {POST_PROCESSOR_TYPE_N_POST_PROCESSORS, "POST_PROCESSOR_TYPE_N_POST_PROCESSORS", "n-post-processors"}, {0, NULL, NULL}};
		GType post_processor_type_type_id;
		post_processor_type_type_id = g_enum_register_static ("PostProcessorType", values);
		g_once_init_leave (&post_processor_type_type_id__volatile, post_processor_type_type_id);
	}
	return post_processor_type_type_id__volatile;
}


void build_job_copy (const BuildJob* self, BuildJob* dest) {
	gboolean _tmp0_;
	PostProcessorType _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).must_succeed;
	(*dest).must_succeed = _tmp0_;
	_tmp1_ = (*self).post_processor;
	(*dest).post_processor = _tmp1_;
	_tmp2_ = (*self).command;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).command);
	(*dest).command = _tmp3_;
}


void build_job_destroy (BuildJob* self) {
	_g_free0 ((*self).command);
}


BuildJob* build_job_dup (const BuildJob* self) {
	BuildJob* dup;
	dup = g_new0 (BuildJob, 1);
	build_job_copy (self, dup);
	return dup;
}


void build_job_free (BuildJob* self) {
	build_job_destroy (self);
	g_free (self);
}


GType build_job_get_type (void) {
	static volatile gsize build_job_type_id__volatile = 0;
	if (g_once_init_enter (&build_job_type_id__volatile)) {
		GType build_job_type_id;
		build_job_type_id = g_boxed_type_register_static ("BuildJob", (GBoxedCopyFunc) build_job_dup, (GBoxedFreeFunc) build_job_free);
		g_once_init_leave (&build_job_type_id__volatile, build_job_type_id);
	}
	return build_job_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void build_tool_copy (const BuildTool* self, BuildTool* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
	_tmp0_ = (*self).description;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).description);
	(*dest).description = _tmp1_;
	_tmp2_ = (*self).extensions;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).extensions);
	(*dest).extensions = _tmp3_;
	_tmp4_ = (*self).label;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).label);
	(*dest).label = _tmp5_;
	_tmp6_ = (*self).icon;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).icon);
	(*dest).icon = _tmp7_;
	_tmp8_ = (*self).show;
	(*dest).show = _tmp8_;
	_tmp9_ = (*self).compilation;
	(*dest).compilation = _tmp9_;
	_tmp10_ = (*self).jobs;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_g_object_unref0 ((*dest).jobs);
	(*dest).jobs = _tmp11_;
}


void build_tool_destroy (BuildTool* self) {
	_g_free0 ((*self).description);
	_g_free0 ((*self).extensions);
	_g_free0 ((*self).label);
	_g_free0 ((*self).icon);
	_g_object_unref0 ((*self).jobs);
}


BuildTool* build_tool_dup (const BuildTool* self) {
	BuildTool* dup;
	dup = g_new0 (BuildTool, 1);
	build_tool_copy (self, dup);
	return dup;
}


void build_tool_free (BuildTool* self) {
	build_tool_destroy (self);
	g_free (self);
}


GType build_tool_get_type (void) {
	static volatile gsize build_tool_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_type_id__volatile)) {
		GType build_tool_type_id;
		build_tool_type_id = g_boxed_type_register_static ("BuildTool", (GBoxedCopyFunc) build_tool_dup, (GBoxedFreeFunc) build_tool_free);
		g_once_init_leave (&build_tool_type_id__volatile, build_tool_type_id);
	}
	return build_tool_type_id__volatile;
}


GType doc_type_get_type (void) {
	static volatile gsize doc_type_type_id__volatile = 0;
	if (g_once_init_enter (&doc_type_type_id__volatile)) {
		static const GEnumValue values[] = {{DOC_TYPE_DVI, "DOC_TYPE_DVI", "dvi"}, {DOC_TYPE_PDF, "DOC_TYPE_PDF", "pdf"}, {DOC_TYPE_PS, "DOC_TYPE_PS", "ps"}, {DOC_TYPE_LAST, "DOC_TYPE_LAST", "last"}, {0, NULL, NULL}};
		GType doc_type_type_id;
		doc_type_type_id = g_enum_register_static ("DocType", values);
		g_once_init_leave (&doc_type_type_id__volatile, doc_type_type_id);
	}
	return doc_type_type_id__volatile;
}


static BuildTools* build_tools_construct (GType object_type) {
	BuildTools* self = NULL;
	self = (BuildTools*) g_type_create_instance (object_type);
	build_tools_load (self);
	return self;
}


static BuildTools* build_tools_new (void) {
	return build_tools_construct (TYPE_BUILD_TOOLS);
}


static gpointer _build_tools_ref0 (gpointer self) {
	return self ? build_tools_ref (self) : NULL;
}


BuildTools* build_tools_get_default (void) {
	BuildTools* result = NULL;
	BuildTools* _tmp0_;
	BuildTools* _tmp2_;
	BuildTools* _tmp3_;
	_tmp0_ = build_tools__instance;
	if (_tmp0_ == NULL) {
		BuildTools* _tmp1_;
		_tmp1_ = build_tools_new ();
		_build_tools_unref0 (build_tools__instance);
		build_tools__instance = _tmp1_;
	}
	_tmp2_ = build_tools__instance;
	_tmp3_ = _build_tools_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


BuildTool* build_tools_get (BuildTools* self, gint id) {
	BuildTool* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp6_;
	GeeLinkedList* _tmp7_;
	gint _tmp8_;
	gpointer _tmp9_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = id;
	if (_tmp1_ >= 0) {
		gint _tmp2_;
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp2_ = id;
		_tmp3_ = self->priv->_build_tools;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp2_ < _tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp6_ = _tmp0_;
	g_return_val_if_fail (_tmp6_, NULL);
	_tmp7_ = self->priv->_build_tools;
	_tmp8_ = id;
	_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _tmp8_);
	result = (BuildTool*) _tmp9_;
	return result;
}


GeeIterator* build_tools_iterator (BuildTools* self) {
	GeeIterator* result = NULL;
	GeeLinkedList* _tmp0_;
	GeeIterator* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_build_tools;
	_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
	result = GEE_ITERATOR (_tmp1_);
	return result;
}


static gpointer _build_tool_dup0 (gpointer self) {
	return self ? build_tool_dup (self) : NULL;
}


BuildTool* build_tools_get_view_doc (BuildTools* self, DocType type) {
	BuildTool* result = NULL;
	gchar** _tmp0_ = NULL;
	gchar** icon;
	gint icon_length1;
	gint _icon_size_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, DOC_TYPE_LAST + 1);
	icon = _tmp0_;
	icon_length1 = DOC_TYPE_LAST;
	_icon_size_ = icon_length1;
	_tmp1_ = icon;
	_tmp1__length1 = icon_length1;
	_tmp2_ = g_strdup ("view_dvi");
	_g_free0 (_tmp1_[DOC_TYPE_DVI]);
	_tmp1_[DOC_TYPE_DVI] = _tmp2_;
	_tmp3_ = _tmp1_[DOC_TYPE_DVI];
	_tmp4_ = icon;
	_tmp4__length1 = icon_length1;
	_tmp5_ = g_strdup ("view_pdf");
	_g_free0 (_tmp4_[DOC_TYPE_PDF]);
	_tmp4_[DOC_TYPE_PDF] = _tmp5_;
	_tmp6_ = _tmp4_[DOC_TYPE_PDF];
	_tmp7_ = icon;
	_tmp7__length1 = icon_length1;
	_tmp8_ = g_strdup ("view_ps");
	_g_free0 (_tmp7_[DOC_TYPE_PS]);
	_tmp7_[DOC_TYPE_PS] = _tmp8_;
	_tmp9_ = _tmp7_[DOC_TYPE_PS];
	{
		GeeLinkedList* _tmp10_;
		GeeLinkedList* _tmp11_;
		GeeLinkedList* _build_tool_list;
		GeeLinkedList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _build_tool_size;
		gint _build_tool_index;
		_tmp10_ = self->priv->_build_tools;
		_tmp11_ = _g_object_ref0 (_tmp10_);
		_build_tool_list = _tmp11_;
		_tmp12_ = _build_tool_list;
		_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_build_tool_size = _tmp14_;
		_build_tool_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			GeeLinkedList* _tmp18_;
			gint _tmp19_;
			gpointer _tmp20_ = NULL;
			BuildTool* _tmp21_;
			BuildTool _tmp22_ = {0};
			BuildTool _tmp23_;
			BuildTool build_tool;
			BuildTool _tmp24_;
			const gchar* _tmp25_;
			gchar** _tmp26_;
			gint _tmp26__length1;
			DocType _tmp27_;
			const gchar* _tmp28_;
			_tmp15_ = _build_tool_index;
			_build_tool_index = _tmp15_ + 1;
			_tmp16_ = _build_tool_index;
			_tmp17_ = _build_tool_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _build_tool_list;
			_tmp19_ = _build_tool_index;
			_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _tmp19_);
			_tmp21_ = (BuildTool*) _tmp20_;
			build_tool_copy (_tmp21_, &_tmp22_);
			_tmp23_ = _tmp22_;
			_build_tool_free0 (_tmp21_);
			build_tool = _tmp23_;
			_tmp24_ = build_tool;
			_tmp25_ = _tmp24_.icon;
			_tmp26_ = icon;
			_tmp26__length1 = icon_length1;
			_tmp27_ = type;
			_tmp28_ = _tmp26_[_tmp27_];
			if (g_strcmp0 (_tmp25_, _tmp28_) == 0) {
				BuildTool _tmp29_;
				BuildTool* _tmp30_;
				BuildTool* _tmp31_;
				_tmp29_ = build_tool;
				_tmp30_ = _build_tool_dup0 (&_tmp29_);
				_tmp31_ = _tmp30_;
				build_tool_destroy (&_tmp29_);
				result = _tmp31_;
				_g_object_unref0 (_build_tool_list);
				icon = (_vala_array_free (icon, icon_length1, (GDestroyNotify) g_free), NULL);
				return result;
			}
			build_tool_destroy (&build_tool);
		}
		_g_object_unref0 (_build_tool_list);
	}
	result = NULL;
	icon = (_vala_array_free (icon, icon_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


gboolean build_tools_is_empty (BuildTools* self) {
	gboolean result = FALSE;
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_build_tools;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ == 0;
	return result;
}


void build_tools_move_up (BuildTools* self, gint num) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = num;
	g_return_if_fail (_tmp0_ > 0);
	_tmp1_ = num;
	_tmp2_ = num;
	build_tools_swap (self, _tmp1_, _tmp2_ - 1);
}


void build_tools_move_down (BuildTools* self, gint num) {
	gint _tmp0_;
	GeeLinkedList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = num;
	_tmp1_ = self->priv->_build_tools;
	_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	g_return_if_fail (_tmp0_ < (_tmp3_ - 1));
	_tmp4_ = num;
	_tmp5_ = num;
	build_tools_swap (self, _tmp4_, _tmp5_ + 1);
}


static void build_tools_swap (BuildTools* self, gint num1, gint num2) {
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	gint _tmp2_;
	gpointer _tmp3_ = NULL;
	BuildTool* _tmp4_;
	BuildTool _tmp5_ = {0};
	BuildTool _tmp6_;
	BuildTool tool;
	GeeLinkedList* _tmp7_;
	gint _tmp8_;
	gpointer _tmp9_ = NULL;
	BuildTool* _tmp10_;
	GeeLinkedList* _tmp11_;
	gint _tmp12_;
	BuildTool _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_build_tools;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->_build_tools;
	_tmp2_ = num1;
	_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) _tmp1_, _tmp2_);
	_tmp4_ = (BuildTool*) _tmp3_;
	build_tool_copy (_tmp4_, &_tmp5_);
	_tmp6_ = _tmp5_;
	_build_tool_free0 (_tmp4_);
	tool = _tmp6_;
	_tmp7_ = self->priv->_build_tools;
	_tmp8_ = num1;
	_tmp9_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp7_, _tmp8_);
	_tmp10_ = (BuildTool*) _tmp9_;
	_build_tool_free0 (_tmp10_);
	_tmp11_ = self->priv->_build_tools;
	_tmp12_ = num2;
	_tmp13_ = tool;
	gee_abstract_list_insert ((GeeAbstractList*) _tmp11_, _tmp12_, &_tmp13_);
	build_tools_update_all_menus (self);
	build_tool_destroy (&tool);
}


void build_tools_delete (BuildTools* self, gint num) {
	GeeLinkedList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	gboolean _tmp7_;
	GeeLinkedList* _tmp8_;
	gint _tmp9_;
	gpointer _tmp10_ = NULL;
	BuildTool* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_build_tools;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp2_ = num;
	if (_tmp2_ >= 0) {
		gint _tmp3_;
		GeeLinkedList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp3_ = num;
		_tmp4_ = self->priv->_build_tools;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp3_ < _tmp6_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp7_ = _tmp1_;
	g_return_if_fail (_tmp7_);
	_tmp8_ = self->priv->_build_tools;
	_tmp9_ = num;
	_tmp10_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp8_, _tmp9_);
	_tmp11_ = (BuildTool*) _tmp10_;
	_build_tool_free0 (_tmp11_);
	build_tools_update_all_menus (self);
}


void build_tools_add (BuildTools* self, BuildTool* tool) {
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	BuildTool _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tool != NULL);
	_tmp0_ = self->priv->_build_tools;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->_build_tools;
	_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = *tool;
	build_tools_insert (self, _tmp3_, &_tmp4_);
}


void build_tools_insert (BuildTools* self, gint pos, BuildTool* tool) {
	GeeLinkedList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	gboolean _tmp7_;
	BuildTool _tmp8_;
	const gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GeeLinkedList* _tmp11_;
	gint _tmp12_;
	BuildTool _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tool != NULL);
	_tmp0_ = self->priv->_build_tools;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp2_ = pos;
	if (0 <= _tmp2_) {
		gint _tmp3_;
		GeeLinkedList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp3_ = pos;
		_tmp4_ = self->priv->_build_tools;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp3_ <= _tmp6_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp7_ = _tmp1_;
	g_return_if_fail (_tmp7_);
	_tmp8_ = *tool;
	_tmp9_ = _tmp8_.icon;
	_tmp10_ = build_tools_is_compilation (self, _tmp9_);
	(*tool).compilation = _tmp10_;
	_tmp11_ = self->priv->_build_tools;
	_tmp12_ = pos;
	_tmp13_ = *tool;
	gee_abstract_list_insert ((GeeAbstractList*) _tmp11_, _tmp12_, &_tmp13_);
	build_tools_update_all_menus (self);
}


void build_tools_update (BuildTools* self, gint num, BuildTool* tool, gboolean keep_show) {
	GeeLinkedList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	gboolean _tmp7_;
	GeeLinkedList* _tmp8_;
	gint _tmp9_;
	gpointer _tmp10_ = NULL;
	BuildTool* _tmp11_;
	BuildTool _tmp12_ = {0};
	BuildTool _tmp13_;
	BuildTool current_tool;
	gboolean _tmp14_;
	BuildTool _tmp17_;
	BuildTool _tmp18_;
	gboolean _tmp19_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tool != NULL);
	_tmp0_ = self->priv->_build_tools;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp2_ = num;
	if (_tmp2_ >= 0) {
		gint _tmp3_;
		GeeLinkedList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp3_ = num;
		_tmp4_ = self->priv->_build_tools;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp3_ < _tmp6_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp7_ = _tmp1_;
	g_return_if_fail (_tmp7_);
	_tmp8_ = self->priv->_build_tools;
	_tmp9_ = num;
	_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
	_tmp11_ = (BuildTool*) _tmp10_;
	build_tool_copy (_tmp11_, &_tmp12_);
	_tmp13_ = _tmp12_;
	_build_tool_free0 (_tmp11_);
	current_tool = _tmp13_;
	_tmp14_ = keep_show;
	if (_tmp14_) {
		BuildTool _tmp15_;
		gboolean _tmp16_;
		_tmp15_ = current_tool;
		_tmp16_ = _tmp15_.show;
		(*tool).show = _tmp16_;
	}
	_tmp17_ = current_tool;
	_tmp18_ = *tool;
	_tmp19_ = build_tools_is_equal (self, &_tmp17_, &_tmp18_);
	if (!_tmp19_) {
		BuildTool _tmp20_;
		const gchar* _tmp21_;
		gboolean _tmp22_ = FALSE;
		GeeLinkedList* _tmp23_;
		gint _tmp24_;
		gpointer _tmp25_ = NULL;
		BuildTool* _tmp26_;
		GeeLinkedList* _tmp27_;
		gint _tmp28_;
		BuildTool _tmp29_;
		_tmp20_ = *tool;
		_tmp21_ = _tmp20_.icon;
		_tmp22_ = build_tools_is_compilation (self, _tmp21_);
		(*tool).compilation = _tmp22_;
		_tmp23_ = self->priv->_build_tools;
		_tmp24_ = num;
		_tmp25_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp23_, _tmp24_);
		_tmp26_ = (BuildTool*) _tmp25_;
		_build_tool_free0 (_tmp26_);
		_tmp27_ = self->priv->_build_tools;
		_tmp28_ = num;
		_tmp29_ = *tool;
		gee_abstract_list_insert ((GeeAbstractList*) _tmp27_, _tmp28_, &_tmp29_);
		build_tools_update_all_menus (self);
	}
	build_tool_destroy (&current_tool);
}


void build_tools_reset_all (BuildTools* self) {
	GFile* _tmp0_ = NULL;
	GFile* file;
	GFile* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = build_tools_get_user_config_file (self);
	file = _tmp0_;
	_tmp1_ = file;
	_tmp2_ = g_file_query_exists (_tmp1_, NULL);
	if (_tmp2_) {
		GFile* _tmp3_;
		_tmp3_ = file;
		utils_delete_file (_tmp3_);
	}
	build_tools_load (self);
	build_tools_update_all_menus (self);
	_g_object_unref0 (file);
}


static gboolean build_tools_is_equal (BuildTools* self, BuildTool* tool1, BuildTool* tool2) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	BuildTool _tmp5_;
	gboolean _tmp6_;
	BuildTool _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp13_;
	gboolean _tmp18_;
	gboolean _tmp23_;
	gboolean _tmp28_;
	gboolean _tmp37_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tool1 != NULL, FALSE);
	g_return_val_if_fail (tool2 != NULL, FALSE);
	_tmp5_ = *tool1;
	_tmp6_ = _tmp5_.show;
	_tmp7_ = *tool2;
	_tmp8_ = _tmp7_.show;
	if (_tmp6_ != _tmp8_) {
		_tmp4_ = TRUE;
	} else {
		BuildTool _tmp9_;
		const gchar* _tmp10_;
		BuildTool _tmp11_;
		const gchar* _tmp12_;
		_tmp9_ = *tool1;
		_tmp10_ = _tmp9_.label;
		_tmp11_ = *tool2;
		_tmp12_ = _tmp11_.label;
		_tmp4_ = g_strcmp0 (_tmp10_, _tmp12_) != 0;
	}
	_tmp13_ = _tmp4_;
	if (_tmp13_) {
		_tmp3_ = TRUE;
	} else {
		BuildTool _tmp14_;
		const gchar* _tmp15_;
		BuildTool _tmp16_;
		const gchar* _tmp17_;
		_tmp14_ = *tool1;
		_tmp15_ = _tmp14_.description;
		_tmp16_ = *tool2;
		_tmp17_ = _tmp16_.description;
		_tmp3_ = g_strcmp0 (_tmp15_, _tmp17_) != 0;
	}
	_tmp18_ = _tmp3_;
	if (_tmp18_) {
		_tmp2_ = TRUE;
	} else {
		BuildTool _tmp19_;
		const gchar* _tmp20_;
		BuildTool _tmp21_;
		const gchar* _tmp22_;
		_tmp19_ = *tool1;
		_tmp20_ = _tmp19_.extensions;
		_tmp21_ = *tool2;
		_tmp22_ = _tmp21_.extensions;
		_tmp2_ = g_strcmp0 (_tmp20_, _tmp22_) != 0;
	}
	_tmp23_ = _tmp2_;
	if (_tmp23_) {
		_tmp1_ = TRUE;
	} else {
		BuildTool _tmp24_;
		const gchar* _tmp25_;
		BuildTool _tmp26_;
		const gchar* _tmp27_;
		_tmp24_ = *tool1;
		_tmp25_ = _tmp24_.icon;
		_tmp26_ = *tool2;
		_tmp27_ = _tmp26_.icon;
		_tmp1_ = g_strcmp0 (_tmp25_, _tmp27_) != 0;
	}
	_tmp28_ = _tmp1_;
	if (_tmp28_) {
		_tmp0_ = TRUE;
	} else {
		BuildTool _tmp29_;
		GeeArrayList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		BuildTool _tmp33_;
		GeeArrayList* _tmp34_;
		gint _tmp35_;
		gint _tmp36_;
		_tmp29_ = *tool1;
		_tmp30_ = _tmp29_.jobs;
		_tmp31_ = gee_collection_get_size ((GeeCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = *tool2;
		_tmp34_ = _tmp33_.jobs;
		_tmp35_ = gee_collection_get_size ((GeeCollection*) _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp0_ = _tmp32_ != _tmp36_;
	}
	_tmp37_ = _tmp0_;
	if (_tmp37_) {
		result = FALSE;
		return result;
	}
	{
		gint job_num;
		job_num = 0;
		{
			gboolean _tmp38_;
			_tmp38_ = TRUE;
			while (TRUE) {
				gboolean _tmp39_;
				gint _tmp41_;
				BuildTool _tmp42_;
				GeeArrayList* _tmp43_;
				gint _tmp44_;
				gint _tmp45_;
				BuildTool _tmp46_;
				GeeArrayList* _tmp47_;
				gint _tmp48_;
				gpointer _tmp49_ = NULL;
				BuildJob* _tmp50_;
				BuildJob _tmp51_ = {0};
				BuildJob _tmp52_;
				BuildJob job1;
				BuildTool _tmp53_;
				GeeArrayList* _tmp54_;
				gint _tmp55_;
				gpointer _tmp56_ = NULL;
				BuildJob* _tmp57_;
				BuildJob _tmp58_ = {0};
				BuildJob _tmp59_;
				BuildJob job2;
				gboolean _tmp60_ = FALSE;
				gboolean _tmp61_ = FALSE;
				BuildJob _tmp62_;
				const gchar* _tmp63_;
				BuildJob _tmp64_;
				const gchar* _tmp65_;
				gboolean _tmp70_;
				gboolean _tmp75_;
				_tmp39_ = _tmp38_;
				if (!_tmp39_) {
					gint _tmp40_;
					_tmp40_ = job_num;
					job_num = _tmp40_ + 1;
				}
				_tmp38_ = FALSE;
				_tmp41_ = job_num;
				_tmp42_ = *tool1;
				_tmp43_ = _tmp42_.jobs;
				_tmp44_ = gee_collection_get_size ((GeeCollection*) _tmp43_);
				_tmp45_ = _tmp44_;
				if (!(_tmp41_ < _tmp45_)) {
					break;
				}
				_tmp46_ = *tool1;
				_tmp47_ = _tmp46_.jobs;
				_tmp48_ = job_num;
				_tmp49_ = gee_abstract_list_get ((GeeAbstractList*) _tmp47_, _tmp48_);
				_tmp50_ = (BuildJob*) _tmp49_;
				build_job_copy (_tmp50_, &_tmp51_);
				_tmp52_ = _tmp51_;
				_build_job_free0 (_tmp50_);
				job1 = _tmp52_;
				_tmp53_ = *tool2;
				_tmp54_ = _tmp53_.jobs;
				_tmp55_ = job_num;
				_tmp56_ = gee_abstract_list_get ((GeeAbstractList*) _tmp54_, _tmp55_);
				_tmp57_ = (BuildJob*) _tmp56_;
				build_job_copy (_tmp57_, &_tmp58_);
				_tmp59_ = _tmp58_;
				_build_job_free0 (_tmp57_);
				job2 = _tmp59_;
				_tmp62_ = job1;
				_tmp63_ = _tmp62_.command;
				_tmp64_ = job2;
				_tmp65_ = _tmp64_.command;
				if (g_strcmp0 (_tmp63_, _tmp65_) != 0) {
					_tmp61_ = TRUE;
				} else {
					BuildJob _tmp66_;
					gboolean _tmp67_;
					BuildJob _tmp68_;
					gboolean _tmp69_;
					_tmp66_ = job1;
					_tmp67_ = _tmp66_.must_succeed;
					_tmp68_ = job2;
					_tmp69_ = _tmp68_.must_succeed;
					_tmp61_ = _tmp67_ != _tmp69_;
				}
				_tmp70_ = _tmp61_;
				if (_tmp70_) {
					_tmp60_ = TRUE;
				} else {
					BuildJob _tmp71_;
					PostProcessorType _tmp72_;
					BuildJob _tmp73_;
					PostProcessorType _tmp74_;
					_tmp71_ = job1;
					_tmp72_ = _tmp71_.post_processor;
					_tmp73_ = job2;
					_tmp74_ = _tmp73_.post_processor;
					_tmp60_ = _tmp72_ != _tmp74_;
				}
				_tmp75_ = _tmp60_;
				if (_tmp75_) {
					result = FALSE;
					build_job_destroy (&job2);
					build_job_destroy (&job1);
					return result;
				}
				build_job_destroy (&job2);
				build_job_destroy (&job1);
			}
		}
	}
	result = TRUE;
	return result;
}


static void build_tools_update_all_menus (BuildTools* self) {
	Application* _tmp0_ = NULL;
	Application* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	g_return_if_fail (self != NULL);
	self->priv->_modified = TRUE;
	_tmp0_ = application_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = application_get_windows (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp4_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MainWindow* _tmp5_;
			MainWindow* window = NULL;
			_tmp5_ = _g_object_ref0 ((MainWindow*) window_it->data);
			window = _tmp5_;
			{
				MainWindow* _tmp6_;
				_tmp6_ = window;
				main_window_update_build_tools_menu (_tmp6_);
				_g_object_unref0 (window);
			}
		}
	}
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gboolean build_tools_is_compilation (BuildTools* self, const gchar* icon) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp5_;
	gboolean _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (icon != NULL, FALSE);
	_tmp2_ = icon;
	_tmp3_ = string_contains (_tmp2_, "compile");
	if (_tmp3_) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = icon;
		_tmp1_ = g_strcmp0 (_tmp4_, GTK_STOCK_EXECUTE) == 0;
	}
	_tmp5_ = _tmp1_;
	if (_tmp5_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = icon;
		_tmp0_ = g_strcmp0 (_tmp6_, GTK_STOCK_CONVERT) == 0;
	}
	_tmp7_ = _tmp0_;
	result = _tmp7_;
	return result;
}


static void _vala_array_add7 (GFile*** array, int* length, int* size, GFile* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add8 (GFile*** array, int* length, int* size, GFile* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _build_tools_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error) {
	build_tools_parser_start (self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
}


static void _build_tools_parser_end_gmarkup_parser_end_element_func (GMarkupParseContext* context, const gchar* element_name, gpointer self, GError** error) {
	build_tools_parser_end (self, context, element_name, error);
}


static void _build_tools_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context, const gchar* text, gsize text_len, gpointer self, GError** error) {
	build_tools_parser_text (self, context, text, text_len, error);
}


static void build_tools_load (BuildTools* self) {
	GeeLinkedList* _tmp0_;
	GFile** _tmp1_ = NULL;
	GFile** files;
	gint files_length1;
	gint _files_size_;
	GFile** _tmp2_;
	gint _tmp2__length1;
	GFile* _tmp3_ = NULL;
	gchar** _tmp4_;
	gchar** _tmp5_ = NULL;
	gchar** language_names;
	gint language_names_length1;
	gint _language_names_size_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GFile** _tmp13_;
	gint _tmp13__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_linked_list_new (TYPE_BUILD_TOOL, (GBoxedCopyFunc) build_tool_dup, build_tool_free, NULL);
	_g_object_unref0 (self->priv->_build_tools);
	self->priv->_build_tools = _tmp0_;
	_tmp1_ = g_new0 (GFile*, 0 + 1);
	files = _tmp1_;
	files_length1 = 0;
	_files_size_ = files_length1;
	_tmp2_ = files;
	_tmp2__length1 = files_length1;
	_tmp3_ = build_tools_get_user_config_file (self);
	_vala_array_add7 (&files, &files_length1, &_files_size_, _tmp3_);
	_tmp5_ = _tmp4_ = g_get_language_names ();
	language_names = _tmp5_;
	language_names_length1 = _vala_array_length (_tmp4_);
	_language_names_size_ = language_names_length1;
	_tmp6_ = language_names;
	_tmp6__length1 = language_names_length1;
	{
		gchar** language_name_collection = NULL;
		gint language_name_collection_length1 = 0;
		gint _language_name_collection_size_ = 0;
		gint language_name_it = 0;
		language_name_collection = _tmp6_;
		language_name_collection_length1 = _tmp6__length1;
		for (language_name_it = 0; language_name_it < _tmp6__length1; language_name_it = language_name_it + 1) {
			gchar* _tmp7_;
			gchar* language_name = NULL;
			_tmp7_ = g_strdup (language_name_collection[language_name_it]);
			language_name = _tmp7_;
			{
				GFile** _tmp8_;
				gint _tmp8__length1;
				const gchar* _tmp9_;
				gchar* _tmp10_ = NULL;
				gchar* _tmp11_;
				GFile* _tmp12_ = NULL;
				_tmp8_ = files;
				_tmp8__length1 = files_length1;
				_tmp9_ = language_name;
				_tmp10_ = g_build_filename (DATA_DIR, "build_tools", _tmp9_, "build_tools.xml", NULL);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_file_new_for_path (_tmp11_);
				_vala_array_add8 (&files, &files_length1, &_files_size_, _tmp12_);
				_g_free0 (_tmp11_);
				_g_free0 (language_name);
			}
		}
	}
	_tmp13_ = files;
	_tmp13__length1 = files_length1;
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
		file_collection = _tmp13_;
		file_collection_length1 = _tmp13__length1;
		for (file_it = 0; file_it < _tmp13__length1; file_it = file_it + 1) {
			GFile* _tmp14_;
			GFile* file = NULL;
			_tmp14_ = _g_object_ref0 (file_collection[file_it]);
			file = _tmp14_;
			{
				{
					GFile* _tmp15_;
					gboolean _tmp16_ = FALSE;
					guint8* chars = NULL;
					gint chars_length1 = 0;
					gint _chars_size_ = 0;
					GFile* _tmp17_;
					guint8* _tmp18_ = NULL;
					gint _tmp19_ = 0;
					guint8* _tmp20_;
					gint _tmp20__length1;
					gchar* contents;
					GMarkupParser _tmp21_ = {0};
					GMarkupParser parser;
					GMarkupParser _tmp22_;
					GMarkupParseContext* _tmp23_;
					GMarkupParseContext* context;
					GMarkupParseContext* _tmp24_;
					const gchar* _tmp25_;
					_tmp15_ = file;
					_tmp16_ = g_file_query_exists (_tmp15_, NULL);
					if (!_tmp16_) {
						_g_object_unref0 (file);
						continue;
					}
					_tmp17_ = file;
					g_file_load_contents (_tmp17_, NULL, &_tmp18_, &_tmp19_, NULL, &_inner_error_);
					chars = (g_free (chars), NULL);
					chars = _tmp18_;
					chars_length1 = _tmp19_;
					_chars_size_ = chars_length1;
					if (_inner_error_ != NULL) {
						chars = (g_free (chars), NULL);
						goto __catch24_g_error;
					}
					_tmp20_ = chars;
					_tmp20__length1 = chars_length1;
					chars = NULL;
					contents = (gchar*) _tmp20_;
					_tmp21_.start_element = _build_tools_parser_start_gmarkup_parser_start_element_func;
					_tmp21_.end_element = _build_tools_parser_end_gmarkup_parser_end_element_func;
					_tmp21_.text = _build_tools_parser_text_gmarkup_parser_text_func;
					_tmp21_.passthrough = NULL;
					_tmp21_.error = NULL;
					parser = _tmp21_;
					_tmp22_ = parser;
					_tmp23_ = g_markup_parse_context_new (&_tmp22_, 0, self, NULL);
					context = _tmp23_;
					_tmp24_ = context;
					_tmp25_ = contents;
					g_markup_parse_context_parse (_tmp24_, _tmp25_, (gssize) (-1), &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_markup_parse_context_free0 (context);
						_g_free0 (contents);
						chars = (g_free (chars), NULL);
						goto __catch24_g_error;
					}
					_g_markup_parse_context_free0 (context);
					_g_free0 (contents);
					chars = (g_free (chars), NULL);
					_g_object_unref0 (file);
					break;
				}
				goto __finally24;
				__catch24_g_error:
				{
					GError* e = NULL;
					GError* _tmp26_;
					const gchar* _tmp27_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp26_ = e;
					_tmp27_ = _tmp26_->message;
					g_warning ("build_tools.vala:284: Impossible to load build tools: %s", _tmp27_);
					_g_error_free0 (e);
				}
				__finally24:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (file);
					files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_object_unref0 (file);
			}
		}
	}
	files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
}


static gboolean bool_parse (const gchar* str) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	if (g_strcmp0 (_tmp0_, "true") == 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static void build_tools_parser_start (BuildTools* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("tools")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("label"))))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("description"))))) {
		switch (0) {
			default:
			{
				return;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("tool")))) {
		switch (0) {
			default:
			{
				BuildTool _tmp4_ = {0};
				GeeArrayList* _tmp5_;
				memset (&_tmp4_, 0, sizeof (BuildTool));
				build_tool_destroy (&self->priv->_cur_tool);
				self->priv->_cur_tool = _tmp4_;
				self->priv->_cur_tool.compilation = FALSE;
				_tmp5_ = gee_array_list_new (TYPE_BUILD_JOB, (GBoxedCopyFunc) build_job_dup, build_job_free, NULL);
				_g_object_unref0 (self->priv->_cur_tool.jobs);
				self->priv->_cur_tool.jobs = _tmp5_;
				{
					gint i;
					i = 0;
					{
						gboolean _tmp6_;
						_tmp6_ = TRUE;
						while (TRUE) {
							gboolean _tmp7_;
							gint _tmp9_;
							gchar** _tmp10_;
							gint _tmp10__length1;
							gchar** _tmp11_;
							gint _tmp11__length1;
							gint _tmp12_;
							const gchar* _tmp13_;
							const gchar* _tmp14_;
							GQuark _tmp16_ = 0U;
							static GQuark _tmp15_label0 = 0;
							static GQuark _tmp15_label1 = 0;
							static GQuark _tmp15_label2 = 0;
							_tmp7_ = _tmp6_;
							if (!_tmp7_) {
								gint _tmp8_;
								_tmp8_ = i;
								i = _tmp8_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp9_ = i;
							_tmp10_ = attr_names;
							_tmp10__length1 = attr_names_length1;
							if (!(_tmp9_ < _tmp10__length1)) {
								break;
							}
							_tmp11_ = attr_names;
							_tmp11__length1 = attr_names_length1;
							_tmp12_ = i;
							_tmp13_ = _tmp11_[_tmp12_];
							_tmp14_ = _tmp13_;
							_tmp16_ = (NULL == _tmp14_) ? 0 : g_quark_from_string (_tmp14_);
							if (_tmp16_ == ((0 != _tmp15_label0) ? _tmp15_label0 : (_tmp15_label0 = g_quark_from_static_string ("show")))) {
								switch (0) {
									default:
									{
										gchar** _tmp17_;
										gint _tmp17__length1;
										gint _tmp18_;
										const gchar* _tmp19_;
										gboolean _tmp20_ = FALSE;
										_tmp17_ = attr_values;
										_tmp17__length1 = attr_values_length1;
										_tmp18_ = i;
										_tmp19_ = _tmp17_[_tmp18_];
										_tmp20_ = bool_parse (_tmp19_);
										self->priv->_cur_tool.show = _tmp20_;
										break;
									}
								}
							} else if (_tmp16_ == ((0 != _tmp15_label1) ? _tmp15_label1 : (_tmp15_label1 = g_quark_from_static_string ("extensions")))) {
								switch (0) {
									default:
									{
										gchar** _tmp21_;
										gint _tmp21__length1;
										gint _tmp22_;
										const gchar* _tmp23_;
										gchar* _tmp24_;
										_tmp21_ = attr_values;
										_tmp21__length1 = attr_values_length1;
										_tmp22_ = i;
										_tmp23_ = _tmp21_[_tmp22_];
										_tmp24_ = g_strdup (_tmp23_);
										_g_free0 (self->priv->_cur_tool.extensions);
										self->priv->_cur_tool.extensions = _tmp24_;
										break;
									}
								}
							} else if (_tmp16_ == ((0 != _tmp15_label2) ? _tmp15_label2 : (_tmp15_label2 = g_quark_from_static_string ("icon")))) {
								switch (0) {
									default:
									{
										gchar** _tmp25_;
										gint _tmp25__length1;
										gint _tmp26_;
										const gchar* _tmp27_;
										gchar* _tmp28_;
										gchar** _tmp29_;
										gint _tmp29__length1;
										gint _tmp30_;
										const gchar* _tmp31_;
										gboolean _tmp32_ = FALSE;
										_tmp25_ = attr_values;
										_tmp25__length1 = attr_values_length1;
										_tmp26_ = i;
										_tmp27_ = _tmp25_[_tmp26_];
										_tmp28_ = g_strdup (_tmp27_);
										_g_free0 (self->priv->_cur_tool.icon);
										self->priv->_cur_tool.icon = _tmp28_;
										_tmp29_ = attr_values;
										_tmp29__length1 = attr_values_length1;
										_tmp30_ = i;
										_tmp31_ = _tmp29_[_tmp30_];
										_tmp32_ = build_tools_is_compilation (self, _tmp31_);
										self->priv->_cur_tool.compilation = _tmp32_;
										break;
									}
								}
							} else {
								switch (0) {
									default:
									{
										gchar** _tmp33_;
										gint _tmp33__length1;
										gint _tmp34_;
										const gchar* _tmp35_;
										gchar* _tmp36_;
										gchar* _tmp37_;
										gchar* _tmp38_;
										gchar* _tmp39_;
										GError* _tmp40_;
										GError* _tmp41_;
										_tmp33_ = attr_names;
										_tmp33__length1 = attr_names_length1;
										_tmp34_ = i;
										_tmp35_ = _tmp33_[_tmp34_];
										_tmp36_ = g_strconcat ("unknown attribute \"", _tmp35_, NULL);
										_tmp37_ = _tmp36_;
										_tmp38_ = g_strconcat (_tmp37_, "\"", NULL);
										_tmp39_ = _tmp38_;
										_tmp40_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp39_);
										_tmp41_ = _tmp40_;
										_g_free0 (_tmp39_);
										_g_free0 (_tmp37_);
										_inner_error_ = _tmp41_;
										if (_inner_error_->domain == G_MARKUP_ERROR) {
											g_propagate_error (error, _inner_error_);
											return;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
									}
								}
							}
						}
					}
				}
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("job")))) {
		switch (0) {
			default:
			{
				BuildJob _tmp42_ = {0};
				memset (&_tmp42_, 0, sizeof (BuildJob));
				build_job_destroy (&self->priv->_cur_job);
				self->priv->_cur_job = _tmp42_;
				{
					gint i;
					i = 0;
					{
						gboolean _tmp43_;
						_tmp43_ = TRUE;
						while (TRUE) {
							gboolean _tmp44_;
							gint _tmp46_;
							gchar** _tmp47_;
							gint _tmp47__length1;
							gchar** _tmp48_;
							gint _tmp48__length1;
							gint _tmp49_;
							const gchar* _tmp50_;
							const gchar* _tmp51_;
							GQuark _tmp53_ = 0U;
							static GQuark _tmp52_label0 = 0;
							static GQuark _tmp52_label1 = 0;
							_tmp44_ = _tmp43_;
							if (!_tmp44_) {
								gint _tmp45_;
								_tmp45_ = i;
								i = _tmp45_ + 1;
							}
							_tmp43_ = FALSE;
							_tmp46_ = i;
							_tmp47_ = attr_names;
							_tmp47__length1 = attr_names_length1;
							if (!(_tmp46_ < _tmp47__length1)) {
								break;
							}
							_tmp48_ = attr_names;
							_tmp48__length1 = attr_names_length1;
							_tmp49_ = i;
							_tmp50_ = _tmp48_[_tmp49_];
							_tmp51_ = _tmp50_;
							_tmp53_ = (NULL == _tmp51_) ? 0 : g_quark_from_string (_tmp51_);
							if (_tmp53_ == ((0 != _tmp52_label0) ? _tmp52_label0 : (_tmp52_label0 = g_quark_from_static_string ("mustSucceed")))) {
								switch (0) {
									default:
									{
										gchar** _tmp54_;
										gint _tmp54__length1;
										gint _tmp55_;
										const gchar* _tmp56_;
										gboolean _tmp57_ = FALSE;
										_tmp54_ = attr_values;
										_tmp54__length1 = attr_values_length1;
										_tmp55_ = i;
										_tmp56_ = _tmp54_[_tmp55_];
										_tmp57_ = bool_parse (_tmp56_);
										self->priv->_cur_job.must_succeed = _tmp57_;
										break;
									}
								}
							} else if (_tmp53_ == ((0 != _tmp52_label1) ? _tmp52_label1 : (_tmp52_label1 = g_quark_from_static_string ("postProcessor")))) {
								switch (0) {
									default:
									{
										gchar** _tmp58_;
										gint _tmp58__length1;
										gint _tmp59_;
										const gchar* _tmp60_;
										PostProcessorType* _tmp61_ = 0;
										PostProcessorType* _tmp62_;
										_tmp58_ = attr_values;
										_tmp58__length1 = attr_values_length1;
										_tmp59_ = i;
										_tmp60_ = _tmp58_[_tmp59_];
										_tmp61_ = build_tools_get_post_processor_type_from_name (_tmp60_);
										_tmp62_ = _tmp61_;
										self->priv->_cur_job.post_processor = *_tmp62_;
										_g_free0 (_tmp62_);
										break;
									}
								}
							} else {
								switch (0) {
									default:
									{
										gchar** _tmp63_;
										gint _tmp63__length1;
										gint _tmp64_;
										const gchar* _tmp65_;
										gchar* _tmp66_;
										gchar* _tmp67_;
										gchar* _tmp68_;
										gchar* _tmp69_;
										GError* _tmp70_;
										GError* _tmp71_;
										_tmp63_ = attr_names;
										_tmp63__length1 = attr_names_length1;
										_tmp64_ = i;
										_tmp65_ = _tmp63_[_tmp64_];
										_tmp66_ = g_strconcat ("unknown attribute \"", _tmp65_, NULL);
										_tmp67_ = _tmp66_;
										_tmp68_ = g_strconcat (_tmp67_, "\"", NULL);
										_tmp69_ = _tmp68_;
										_tmp70_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp69_);
										_tmp71_ = _tmp70_;
										_g_free0 (_tmp69_);
										_g_free0 (_tmp67_);
										_inner_error_ = _tmp71_;
										if (_inner_error_->domain == G_MARKUP_ERROR) {
											g_propagate_error (error, _inner_error_);
											return;
										} else {
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
									}
								}
							}
						}
					}
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp72_;
				gchar* _tmp73_;
				gchar* _tmp74_;
				gchar* _tmp75_;
				gchar* _tmp76_;
				GError* _tmp77_;
				GError* _tmp78_;
				_tmp72_ = name;
				_tmp73_ = g_strconcat ("unknown element \"", _tmp72_, NULL);
				_tmp74_ = _tmp73_;
				_tmp75_ = g_strconcat (_tmp74_, "\"", NULL);
				_tmp76_ = _tmp75_;
				_tmp77_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp76_);
				_tmp78_ = _tmp77_;
				_g_free0 (_tmp76_);
				_g_free0 (_tmp74_);
				_inner_error_ = _tmp78_;
				if (_inner_error_->domain == G_MARKUP_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static void build_tools_parser_end (BuildTools* self, GMarkupParseContext* context, const gchar* name, GError** error) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("tools")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("label"))))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("description"))))) {
		switch (0) {
			default:
			{
				return;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("tool")))) {
		switch (0) {
			default:
			{
				BuildTool _tmp4_;
				const gchar* _tmp5_;
				GeeLinkedList* _tmp9_;
				BuildTool _tmp10_;
				_tmp4_ = self->priv->_cur_tool;
				_tmp5_ = _tmp4_.description;
				if (_tmp5_ == NULL) {
					BuildTool _tmp6_;
					const gchar* _tmp7_;
					gchar* _tmp8_;
					_tmp6_ = self->priv->_cur_tool;
					_tmp7_ = _tmp6_.label;
					_tmp8_ = g_strdup (_tmp7_);
					_g_free0 (self->priv->_cur_tool.description);
					self->priv->_cur_tool.description = _tmp8_;
				}
				_tmp9_ = self->priv->_build_tools;
				_tmp10_ = self->priv->_cur_tool;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, &_tmp10_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("job")))) {
		switch (0) {
			default:
			{
				BuildTool _tmp11_;
				GeeArrayList* _tmp12_;
				BuildJob _tmp13_;
				_tmp11_ = self->priv->_cur_tool;
				_tmp12_ = _tmp11_.jobs;
				_tmp13_ = self->priv->_cur_job;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, &_tmp13_);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				GError* _tmp19_;
				GError* _tmp20_;
				_tmp14_ = name;
				_tmp15_ = g_strconcat ("unknown element \"", _tmp14_, NULL);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_strconcat (_tmp16_, "\"", NULL);
				_tmp18_ = _tmp17_;
				_tmp19_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp18_);
				_tmp20_ = _tmp19_;
				_g_free0 (_tmp18_);
				_g_free0 (_tmp16_);
				_inner_error_ = _tmp20_;
				if (_inner_error_->domain == G_MARKUP_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void build_tools_parser_text (BuildTools* self, GMarkupParseContext* context, const gchar* text, gsize text_len, GError** error) {
	GMarkupParseContext* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = context;
	_tmp1_ = g_markup_parse_context_get_element (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("job")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp5_;
				gchar* _tmp6_ = NULL;
				_tmp5_ = text;
				_tmp6_ = string_strip (_tmp5_);
				_g_free0 (self->priv->_cur_job.command);
				self->priv->_cur_job.command = _tmp6_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("label")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp7_;
				gchar* _tmp8_ = NULL;
				_tmp7_ = text;
				_tmp8_ = string_strip (_tmp7_);
				_g_free0 (self->priv->_cur_tool.label);
				self->priv->_cur_tool.label = _tmp8_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("description")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp9_;
				gchar* _tmp10_ = NULL;
				_tmp9_ = text;
				_tmp10_ = string_strip (_tmp9_);
				_g_free0 (self->priv->_cur_tool.description);
				self->priv->_cur_tool.description = _tmp10_;
				break;
			}
		}
	}
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


void build_tools_save (BuildTools* self) {
	GeeLinkedList* _tmp0_;
	gboolean _tmp1_;
	gchar* _tmp2_;
	gchar* content;
	const gchar* _tmp76_;
	gchar* _tmp77_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_build_tools;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->_modified;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = g_strdup ("<tools>");
	content = _tmp2_;
	{
		GeeLinkedList* _tmp3_;
		GeeLinkedList* _tmp4_;
		GeeLinkedList* _tool_list;
		GeeLinkedList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tool_size;
		gint _tool_index;
		_tmp3_ = self->priv->_build_tools;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_tool_list = _tmp4_;
		_tmp5_ = _tool_list;
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tool_size = _tmp7_;
		_tool_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			GeeLinkedList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_ = NULL;
			BuildTool* _tmp14_;
			BuildTool _tmp15_ = {0};
			BuildTool _tmp16_;
			BuildTool tool;
			const gchar* _tmp17_;
			BuildTool _tmp18_;
			gboolean _tmp19_;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_;
			BuildTool _tmp22_;
			const gchar* _tmp23_;
			BuildTool _tmp24_;
			const gchar* _tmp25_;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_;
			gchar* _tmp28_;
			const gchar* _tmp29_;
			BuildTool _tmp30_;
			const gchar* _tmp31_;
			gchar* _tmp32_ = NULL;
			gchar* _tmp33_;
			gchar* _tmp34_;
			const gchar* _tmp35_;
			BuildTool _tmp36_;
			const gchar* _tmp37_;
			gchar* _tmp38_ = NULL;
			gchar* _tmp39_;
			gchar* _tmp40_;
			const gchar* _tmp74_;
			gchar* _tmp75_;
			_tmp8_ = _tool_index;
			_tool_index = _tmp8_ + 1;
			_tmp9_ = _tool_index;
			_tmp10_ = _tool_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _tool_list;
			_tmp12_ = _tool_index;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp12_);
			_tmp14_ = (BuildTool*) _tmp13_;
			build_tool_copy (_tmp14_, &_tmp15_);
			_tmp16_ = _tmp15_;
			_build_tool_free0 (_tmp14_);
			tool = _tmp16_;
			_tmp17_ = content;
			_tmp18_ = tool;
			_tmp19_ = _tmp18_.show;
			_tmp20_ = bool_to_string (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = tool;
			_tmp23_ = _tmp22_.extensions;
			_tmp24_ = tool;
			_tmp25_ = _tmp24_.icon;
			_tmp26_ = g_strdup_printf ("\n  <tool show=\"%s\" extensions=\"%s\" icon=\"%s\">\n", _tmp21_, _tmp23_, _tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_strconcat (_tmp17_, _tmp27_, NULL);
			_g_free0 (content);
			content = _tmp28_;
			_g_free0 (_tmp27_);
			_g_free0 (_tmp21_);
			_tmp29_ = content;
			_tmp30_ = tool;
			_tmp31_ = _tmp30_.label;
			_tmp32_ = g_markup_printf_escaped ("    <label>%s</label>\n", _tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = g_strconcat (_tmp29_, _tmp33_, NULL);
			_g_free0 (content);
			content = _tmp34_;
			_g_free0 (_tmp33_);
			_tmp35_ = content;
			_tmp36_ = tool;
			_tmp37_ = _tmp36_.description;
			_tmp38_ = g_markup_printf_escaped ("    <description>%s</description>\n", _tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strconcat (_tmp35_, _tmp39_, NULL);
			_g_free0 (content);
			content = _tmp40_;
			_g_free0 (_tmp39_);
			{
				BuildTool _tmp41_;
				GeeArrayList* _tmp42_;
				GeeArrayList* _tmp43_;
				GeeArrayList* _job_list;
				GeeArrayList* _tmp44_;
				gint _tmp45_;
				gint _tmp46_;
				gint _job_size;
				gint _job_index;
				_tmp41_ = tool;
				_tmp42_ = _tmp41_.jobs;
				_tmp43_ = _g_object_ref0 (_tmp42_);
				_job_list = _tmp43_;
				_tmp44_ = _job_list;
				_tmp45_ = gee_collection_get_size ((GeeCollection*) _tmp44_);
				_tmp46_ = _tmp45_;
				_job_size = _tmp46_;
				_job_index = -1;
				while (TRUE) {
					gint _tmp47_;
					gint _tmp48_;
					gint _tmp49_;
					GeeArrayList* _tmp50_;
					gint _tmp51_;
					gpointer _tmp52_ = NULL;
					BuildJob* _tmp53_;
					BuildJob _tmp54_ = {0};
					BuildJob _tmp55_;
					BuildJob job;
					const gchar* _tmp56_;
					BuildJob _tmp57_;
					gboolean _tmp58_;
					gchar* _tmp59_ = NULL;
					gchar* _tmp60_;
					BuildJob _tmp61_;
					PostProcessorType _tmp62_;
					gchar* _tmp63_ = NULL;
					gchar* _tmp64_;
					gchar* _tmp65_ = NULL;
					gchar* _tmp66_;
					gchar* _tmp67_;
					const gchar* _tmp68_;
					BuildJob _tmp69_;
					const gchar* _tmp70_;
					gchar* _tmp71_ = NULL;
					gchar* _tmp72_;
					gchar* _tmp73_;
					_tmp47_ = _job_index;
					_job_index = _tmp47_ + 1;
					_tmp48_ = _job_index;
					_tmp49_ = _job_size;
					if (!(_tmp48_ < _tmp49_)) {
						break;
					}
					_tmp50_ = _job_list;
					_tmp51_ = _job_index;
					_tmp52_ = gee_abstract_list_get ((GeeAbstractList*) _tmp50_, _tmp51_);
					_tmp53_ = (BuildJob*) _tmp52_;
					build_job_copy (_tmp53_, &_tmp54_);
					_tmp55_ = _tmp54_;
					_build_job_free0 (_tmp53_);
					job = _tmp55_;
					_tmp56_ = content;
					_tmp57_ = job;
					_tmp58_ = _tmp57_.must_succeed;
					_tmp59_ = bool_to_string (_tmp58_);
					_tmp60_ = _tmp59_;
					_tmp61_ = job;
					_tmp62_ = _tmp61_.post_processor;
					_tmp63_ = build_tools_get_post_processor_name_from_type (_tmp62_);
					_tmp64_ = _tmp63_;
					_tmp65_ = g_strdup_printf ("    <job mustSucceed=\"%s\" postProcessor=\"%s\">", _tmp60_, _tmp64_);
					_tmp66_ = _tmp65_;
					_tmp67_ = g_strconcat (_tmp56_, _tmp66_, NULL);
					_g_free0 (content);
					content = _tmp67_;
					_g_free0 (_tmp66_);
					_g_free0 (_tmp64_);
					_g_free0 (_tmp60_);
					_tmp68_ = content;
					_tmp69_ = job;
					_tmp70_ = _tmp69_.command;
					_tmp71_ = g_markup_printf_escaped ("%s</job>\n", _tmp70_);
					_tmp72_ = _tmp71_;
					_tmp73_ = g_strconcat (_tmp68_, _tmp72_, NULL);
					_g_free0 (content);
					content = _tmp73_;
					_g_free0 (_tmp72_);
					build_job_destroy (&job);
				}
				_g_object_unref0 (_job_list);
			}
			_tmp74_ = content;
			_tmp75_ = g_strconcat (_tmp74_, "  </tool>\n", NULL);
			_g_free0 (content);
			content = _tmp75_;
			build_tool_destroy (&tool);
		}
		_g_object_unref0 (_tool_list);
	}
	_tmp76_ = content;
	_tmp77_ = g_strconcat (_tmp76_, "</tools>\n", NULL);
	_g_free0 (content);
	content = _tmp77_;
	{
		GFile* _tmp78_ = NULL;
		GFile* file;
		GFile* _tmp79_;
		GFile* _tmp80_ = NULL;
		GFile* parent;
		gboolean _tmp81_ = FALSE;
		GFile* _tmp82_;
		gboolean _tmp85_;
		GFile* _tmp87_;
		const gchar* _tmp88_;
		const gchar* _tmp89_;
		gint _tmp90_;
		gint _tmp91_;
		_tmp78_ = build_tools_get_user_config_file (self);
		file = _tmp78_;
		_tmp79_ = file;
		_tmp80_ = g_file_get_parent (_tmp79_);
		parent = _tmp80_;
		_tmp82_ = parent;
		if (_tmp82_ != NULL) {
			GFile* _tmp83_;
			gboolean _tmp84_ = FALSE;
			_tmp83_ = parent;
			_tmp84_ = g_file_query_exists (_tmp83_, NULL);
			_tmp81_ = !_tmp84_;
		} else {
			_tmp81_ = FALSE;
		}
		_tmp85_ = _tmp81_;
		if (_tmp85_) {
			GFile* _tmp86_;
			_tmp86_ = parent;
			g_file_make_directory_with_parents (_tmp86_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (parent);
				_g_object_unref0 (file);
				goto __catch25_g_error;
			}
		}
		_tmp87_ = file;
		_tmp88_ = content;
		_tmp89_ = content;
		_tmp90_ = strlen (_tmp89_);
		_tmp91_ = _tmp90_;
		g_file_replace_contents (_tmp87_, _tmp88_, (gsize) _tmp91_, NULL, TRUE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parent);
			_g_object_unref0 (file);
			goto __catch25_g_error;
		}
		_g_object_unref0 (parent);
		_g_object_unref0 (file);
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* e = NULL;
		GError* _tmp92_;
		const gchar* _tmp93_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp92_ = e;
		_tmp93_ = _tmp92_->message;
		g_warning ("build_tools.vala:438: Impossible to save build tools: %s", _tmp93_);
		_g_error_free0 (e);
	}
	__finally25:
	if (_inner_error_ != NULL) {
		_g_free0 (content);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (content);
}


static GFile* build_tools_get_user_config_file (BuildTools* self) {
	GFile* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* path;
	GFile* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "latexila", "build_tools.xml", NULL, NULL);
	path = _tmp1_;
	_tmp2_ = g_file_new_for_path (path);
	result = _tmp2_;
	_g_free0 (path);
	return result;
}


static PostProcessorType* _post_processor_type_dup (PostProcessorType* self) {
	PostProcessorType* dup;
	dup = g_new0 (PostProcessorType, 1);
	memcpy (dup, self, sizeof (PostProcessorType));
	return dup;
}


static gpointer __post_processor_type_dup0 (gpointer self) {
	return self ? _post_processor_type_dup (self) : NULL;
}


PostProcessorType* build_tools_get_post_processor_type_from_name (const gchar* name) {
	PostProcessorType* result = 0;
	g_return_val_if_fail (name != NULL, 0);
	{
		gint type;
		type = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gchar** _tmp4_;
				gint _tmp4__length1;
				gint _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = type;
					type = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = type;
				if (!(_tmp3_ < ((gint) POST_PROCESSOR_TYPE_N_POST_PROCESSORS))) {
					break;
				}
				_tmp4_ = build_tools__post_processor_names;
				_tmp4__length1 = build_tools__post_processor_names_length1;
				_tmp5_ = type;
				_tmp6_ = _tmp4_[_tmp5_];
				_tmp7_ = name;
				if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
					gint _tmp8_;
					PostProcessorType _tmp9_;
					PostProcessorType* _tmp10_;
					_tmp8_ = type;
					_tmp9_ = (PostProcessorType) _tmp8_;
					_tmp10_ = __post_processor_type_dup0 (&_tmp9_);
					result = _tmp10_;
					return result;
				}
			}
		}
	}
	g_return_val_if_reached (NULL);
}


gchar* build_tools_get_post_processor_name_from_type (PostProcessorType type) {
	gchar* result = NULL;
	PostProcessorType _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	PostProcessorType _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	_tmp0_ = type;
	g_return_val_if_fail (_tmp0_ != POST_PROCESSOR_TYPE_N_POST_PROCESSORS, NULL);
	_tmp1_ = build_tools__post_processor_names;
	_tmp1__length1 = build_tools__post_processor_names_length1;
	_tmp2_ = type;
	_tmp3_ = _tmp1_[_tmp2_];
	_tmp4_ = g_strdup (_tmp3_);
	result = _tmp4_;
	return result;
}


static void value_build_tools_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_build_tools_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		build_tools_unref (value->data[0].v_pointer);
	}
}


static void value_build_tools_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = build_tools_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_build_tools_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_build_tools_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		BuildTools* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = build_tools_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_build_tools_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	BuildTools** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = build_tools_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_build_tools (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecBuildTools* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BUILD_TOOLS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_build_tools (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BUILD_TOOLS), NULL);
	return value->data[0].v_pointer;
}


void value_set_build_tools (GValue* value, gpointer v_object) {
	BuildTools* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BUILD_TOOLS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BUILD_TOOLS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		build_tools_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		build_tools_unref (old);
	}
}


void value_take_build_tools (GValue* value, gpointer v_object) {
	BuildTools* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BUILD_TOOLS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BUILD_TOOLS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		build_tools_unref (old);
	}
}


static void build_tools_class_init (BuildToolsClass * klass) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_ = NULL;
	build_tools_parent_class = g_type_class_peek_parent (klass);
	BUILD_TOOLS_CLASS (klass)->finalize = build_tools_finalize;
	g_type_class_add_private (klass, sizeof (BuildToolsPrivate));
	_tmp0_ = g_strdup ("all-output");
	_tmp1_ = g_strdup ("latex");
	_tmp2_ = g_strdup ("latexmk");
	_tmp3_ = g_strdup ("no-output");
	_tmp4_ = g_strdup ("rubber");
	_tmp5_ = g_new0 (gchar*, 5 + 1);
	_tmp5_[0] = _tmp0_;
	_tmp5_[1] = _tmp1_;
	_tmp5_[2] = _tmp2_;
	_tmp5_[3] = _tmp3_;
	_tmp5_[4] = _tmp4_;
	build_tools__post_processor_names = _tmp5_;
	build_tools__post_processor_names_length1 = 5;
}


static void build_tools_instance_init (BuildTools * self) {
	self->priv = BUILD_TOOLS_GET_PRIVATE (self);
	self->priv->_modified = FALSE;
	self->ref_count = 1;
}


static void build_tools_finalize (BuildTools* obj) {
	BuildTools * self;
	self = BUILD_TOOLS (obj);
	_g_object_unref0 (self->priv->_build_tools);
	build_tool_destroy (&self->priv->_cur_tool);
	build_job_destroy (&self->priv->_cur_job);
}


GType build_tools_get_type (void) {
	static volatile gsize build_tools_type_id__volatile = 0;
	if (g_once_init_enter (&build_tools_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_build_tools_init, value_build_tools_free_value, value_build_tools_copy_value, value_build_tools_peek_pointer, "p", value_build_tools_collect_value, "p", value_build_tools_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BuildToolsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) build_tools_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuildTools), 0, (GInstanceInitFunc) build_tools_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType build_tools_type_id;
		build_tools_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BuildTools", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&build_tools_type_id__volatile, build_tools_type_id);
	}
	return build_tools_type_id__volatile;
}


gpointer build_tools_ref (gpointer instance) {
	BuildTools* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void build_tools_unref (gpointer instance) {
	BuildTools* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BUILD_TOOLS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



