/* document.c generated by valac 0.24.0.38-0a8fb, the Vala compiler
 * generated from document.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtksourceview/gtksource.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>


#define TYPE_SELECTION_TYPE (selection_type_get_type ())

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT_STRUCTURE (document_structure_get_type ())
#define DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructure))
#define DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))
#define IS_DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_STRUCTURE))
#define IS_DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_STRUCTURE))
#define DOCUMENT_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))

typedef struct _DocumentStructure DocumentStructure;
typedef struct _DocumentStructureClass DocumentStructureClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block15Data Block15Data;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_TAB_INFO_BAR (tab_info_bar_get_type ())
#define TAB_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAB_INFO_BAR, TabInfoBar))
#define TAB_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAB_INFO_BAR, TabInfoBarClass))
#define IS_TAB_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAB_INFO_BAR))
#define IS_TAB_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAB_INFO_BAR))
#define TAB_INFO_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAB_INFO_BAR, TabInfoBarClass))

typedef struct _TabInfoBar TabInfoBar;
typedef struct _TabInfoBarClass TabInfoBarClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block16Data Block16Data;

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))

#define TYPE_LATEXILA (latexila_get_type ())
#define LATEXILA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEXILA, Latexila))
#define LATEXILA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEXILA, LatexilaClass))
#define IS_LATEXILA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEXILA))
#define IS_LATEXILA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEXILA))
#define LATEXILA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEXILA, LatexilaClass))

typedef struct _Latexila Latexila;
typedef struct _LatexilaClass LatexilaClass;
typedef struct _Block17Data Block17Data;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

typedef enum  {
	SELECTION_TYPE_NO_SELECTION,
	SELECTION_TYPE_ONE_LINE,
	SELECTION_TYPE_MULTIPLE_LINES
} SelectionType;

struct _Document {
	GtkSourceBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
	guint _unsaved_doc_num;
};

struct _DocumentClass {
	GtkSourceBufferClass parent_class;
};

struct _DocumentPrivate {
	GFile* _location;
	gboolean _readonly;
	gint _project_id;
	gboolean backup_made;
	gchar* _etag;
	gchar* encoding;
	gboolean new_file;
	DocumentStructure* _structure;
};

struct _Block15Data {
	int _ref_count_;
	Document* self;
	GtkSourceCompletion* completion;
};

struct _Block16Data {
	int _ref_count_;
	Document* self;
	TabInfoBar* infobar;
};

struct _Project {
	GFile* directory;
	GFile* main_file;
};

struct _Block17Data {
	int _ref_count_;
	Document* self;
	TabInfoBar* infobar;
};


static gpointer document_parent_class = NULL;

GType selection_type_get_type (void) G_GNUC_CONST;
GType document_get_type (void) G_GNUC_CONST;
GType document_tab_get_type (void) G_GNUC_CONST;
GType document_structure_get_type (void) G_GNUC_CONST;
#define DOCUMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DOCUMENT, DocumentPrivate))
enum  {
	DOCUMENT_DUMMY_PROPERTY,
	DOCUMENT_LOCATION,
	DOCUMENT_READONLY,
	DOCUMENT_PROJECT_ID
};
Document* document_new (void);
Document* document_construct (GType object_type);
static void __lambda87_ (Document* self);
static void document_update_syntax_highlighting (Document* self);
static void document_update_project_id (Document* self);
static void ___lambda87__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda88_ (Document* self, GtkTextIter* location, GtkTextMark* mark);
static void ___lambda88__gtk_text_buffer_mark_set (GtkTextBuffer* _sender, GtkTextIter* location, GtkTextMark* mark, gpointer self);
static void __lambda89_ (Document* self);
static void ___lambda89__gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self);
gboolean document_get_modified (Document* self);
void document_insert (Document* self, GtkTextIter* iter, const gchar* text, gint len);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
GType document_view_get_type (void) G_GNUC_CONST;
DocumentView* document_tab_get_view (DocumentTab* self);
static gboolean __lambda19_ (Block15Data* _data15_);
static gboolean ___lambda19__gsource_func (gpointer self);
void document_load (Document* self, GFile* location);
void document_set_location (Document* self, GFile* value);
void document_set_contents (Document* self, const gchar* contents);
static gchar* document_to_utf8 (Document* self, const gchar* text, GError** error);
GType tab_info_bar_get_type (void) G_GNUC_CONST;
TabInfoBar* document_tab_add_message (DocumentTab* self, const gchar* primary_msg, const gchar* secondary_msg, GtkMessageType msg_type);
void document_save (Document* self, gboolean check_file_changed_on_disk, gboolean force);
GFile* document_get_location (Document* self);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
void tab_info_bar_add_stock_button_with_text (TabInfoBar* self, const gchar* text, const gchar* stock_id, gint response_id);
static void ____lambda16_ (Block16Data* _data16_, gint response_id);
static void _____lambda16__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self);
void tab_info_bar_add_ok_button (TabInfoBar* self);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self, Project* dest);
void project_destroy (Project* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_projects (GValue* value, gpointer v_object);
void value_take_projects (GValue* value, gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
Projects* projects_get_default (void);
GeeIterator* projects_iterator (Projects* self);
void document_set_project_id (Document* self, gint value);
gchar* document_get_uri_for_display (Document* self);
static gchar* document_get_unsaved_document_name (Document* self);
gchar* utils_replace_home_dir_with_tilde (const gchar* uri);
gchar* document_get_short_name_for_display (Document* self);
static guint document_get_unsaved_document_num (Document* self);
GType latexila_get_type (void) G_GNUC_CONST;
Latexila* latexila_get_instance (void);
GeeList* latexila_get_documents (Latexila* self);
static void _vala_array_add14 (guint** array, int* length, int* size, guint value);
static gboolean _vala_uint_array_contains (guint* stack, int stack_length, guint needle);
gboolean document_is_local (Document* self);
gboolean document_is_externally_modified (Document* self);
void document_set_style_scheme_from_string (Document* self, const gchar* scheme_id);
void document_comment_selected_lines (Document* self);
void document_comment_between (Document* self, GtkTextIter* start_iter, GtkTextIter* end_iter, gboolean end_iter_set);
void document_uncomment_selected_lines (Document* self);
void document_select_lines (Document* self, gint start, gint end);
void document_view_scroll_to_cursor (DocumentView* self, gdouble margin);
SelectionType document_get_selection_type (Document* self);
gboolean document_goto_line (Document* self, gint line);
Project* document_get_project (Document* self);
gint document_get_project_id (Document* self);
Project* projects_get (Projects* self, gint id);
GFile* document_get_main_file (Document* self);
gboolean document_is_main_file_a_tex_file (Document* self);
gchar* document_get_current_indentation (Document* self, GtkTextIter* iter);
DocumentStructure* document_get_structure (Document* self);
DocumentStructure* document_structure_new (Document* doc);
DocumentStructure* document_structure_construct (GType object_type, Document* doc);
void document_structure_parse (DocumentStructure* self);
gboolean document_set_tmp_location (Document* self);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static void __lambda77_ (Block17Data* _data17_, gint response_id);
GType main_window_get_type (void) G_GNUC_CONST;
GtkWindow* utils_get_toplevel_window (GtkWidget* widget);
gboolean main_window_save_document (MainWindow* self, Document* doc, gboolean force_save_as);
static void ___lambda77__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self);
gboolean document_get_readonly (Document* self);
void document_set_readonly (Document* self, gboolean value);
static void document_finalize (GObject* obj);
static void _vala_document_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_document_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

extern const gchar* ENCODINGS_CHARSETS[60];

GType selection_type_get_type (void) {
	static volatile gsize selection_type_type_id__volatile = 0;
	if (g_once_init_enter (&selection_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SELECTION_TYPE_NO_SELECTION, "SELECTION_TYPE_NO_SELECTION", "no-selection"}, {SELECTION_TYPE_ONE_LINE, "SELECTION_TYPE_ONE_LINE", "one-line"}, {SELECTION_TYPE_MULTIPLE_LINES, "SELECTION_TYPE_MULTIPLE_LINES", "multiple-lines"}, {0, NULL, NULL}};
		GType selection_type_type_id;
		selection_type_type_id = g_enum_register_static ("SelectionType", values);
		g_once_init_leave (&selection_type_type_id__volatile, selection_type_type_id);
	}
	return selection_type_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda87_ (Document* self) {
	document_update_syntax_highlighting (self);
	document_update_project_id (self);
}


static void ___lambda87__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda87_ ((Document*) self);
}


static void __lambda88_ (Document* self, GtkTextIter* location, GtkTextMark* mark) {
	GtkTextMark* _tmp0_ = NULL;
	GtkTextMark* _tmp1_ = NULL;
	g_return_if_fail (location != NULL);
	g_return_if_fail (mark != NULL);
	_tmp0_ = mark;
	_tmp1_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
	if (_tmp0_ == _tmp1_) {
		g_signal_emit_by_name (self, "cursor-moved");
	}
}


static void ___lambda88__gtk_text_buffer_mark_set (GtkTextBuffer* _sender, GtkTextIter* location, GtkTextMark* mark, gpointer self) {
	__lambda88_ ((Document*) self, location, mark);
}


static void __lambda89_ (Document* self) {
	self->priv->new_file = FALSE;
	g_signal_emit_by_name (self, "cursor-moved");
}


static void ___lambda89__gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self) {
	__lambda89_ ((Document*) self);
}


Document* document_construct (GType object_type) {
	Document * self = NULL;
	GtkSourceLanguageManager* lm = NULL;
	GtkSourceLanguageManager* _tmp0_ = NULL;
	GtkSourceLanguageManager* _tmp1_ = NULL;
	GtkSourceLanguage* _tmp2_ = NULL;
	self = (Document*) g_object_new (object_type, NULL);
	_tmp0_ = gtk_source_language_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	lm = _tmp1_;
	_tmp2_ = gtk_source_language_manager_get_language (lm, "latex");
	gtk_source_buffer_set_language ((GtkSourceBuffer*) self, _tmp2_);
	g_signal_connect_object ((GObject*) self, "notify::location", (GCallback) ___lambda87__g_object_notify, self, 0);
	g_signal_connect_object ((GtkTextBuffer*) self, "mark-set", (GCallback) ___lambda88__gtk_text_buffer_mark_set, self, 0);
	g_signal_connect_object ((GtkTextBuffer*) self, "changed", (GCallback) ___lambda89__gtk_text_buffer_changed, self, 0);
	_g_object_unref0 (lm);
	return self;
}


Document* document_new (void) {
	return document_construct (TYPE_DOCUMENT);
}


gboolean document_get_modified (Document* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->new_file;
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = gtk_text_buffer_get_modified ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_buffer_get_type (), GtkSourceBuffer));
	result = _tmp1_;
	return result;
}


static Block15Data* block15_data_ref (Block15Data* _data15_) {
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}


static void block15_data_unref (void * _userdata_) {
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		Document* self;
		self = _data15_->self;
		_g_object_unref0 (_data15_->completion);
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}


static gboolean __lambda19_ (Block15Data* _data15_) {
	Document* self;
	gboolean result = FALSE;
	self = _data15_->self;
	gtk_source_completion_unblock_interactive (_data15_->completion);
	result = FALSE;
	return result;
}


static gboolean ___lambda19__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda19_ (self);
	return result;
}


void document_insert (Document* self, GtkTextIter* iter, const gchar* text, gint len) {
	Block15Data* _data15_;
	DocumentTab* _tmp0_ = NULL;
	DocumentView* _tmp1_ = NULL;
	DocumentView* _tmp2_ = NULL;
	GtkSourceCompletion* _tmp3_ = NULL;
	GtkSourceCompletion* _tmp4_ = NULL;
	GtkSourceCompletion* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	g_return_if_fail (text != NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	_tmp0_ = self->tab;
	_tmp1_ = document_tab_get_view (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_source_view_get_completion ((GtkSourceView*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_data15_->completion = _tmp5_;
	gtk_source_completion_block_interactive (_data15_->completion);
	_tmp6_ = text;
	_tmp7_ = len;
	gtk_text_buffer_insert ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_buffer_get_type (), GtkSourceBuffer), iter, _tmp6_, _tmp7_);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ___lambda19__gsource_func, block15_data_ref (_data15_), block15_data_unref);
	block15_data_unref (_data15_);
	_data15_ = NULL;
}


void document_load (Document* self, GFile* location) {
	GFile* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = location;
	document_set_location (self, _tmp0_);
	{
		guint8* chars = NULL;
		gint chars_length1 = 0;
		gint _chars_size_ = 0;
		GFile* _tmp1_ = NULL;
		guint8* _tmp2_ = NULL;
		gsize _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* text = NULL;
		guint8* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		const gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		GtkRecentManager* _tmp12_ = NULL;
		GFile* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		_tmp1_ = location;
		g_file_load_contents (_tmp1_, NULL, &_tmp2_, &_tmp3_, &_tmp4_, &_inner_error_);
		chars = (g_free (chars), NULL);
		chars = _tmp2_;
		chars_length1 = _tmp3_;
		_chars_size_ = chars_length1;
		_g_free0 (self->priv->_etag);
		self->priv->_etag = _tmp4_;
		if (_inner_error_ != NULL) {
			chars = (g_free (chars), NULL);
			goto __catch18_g_error;
		}
		_tmp5_ = chars;
		_tmp5__length1 = chars_length1;
		chars = NULL;
		chars_length1 = 0;
		text = (gchar*) _tmp5_;
		_tmp6_ = text;
		_tmp7_ = g_utf8_validate (_tmp6_, (gssize) (-1), NULL);
		if (_tmp7_) {
			const gchar* _tmp8_ = NULL;
			_tmp8_ = text;
			document_set_contents (self, _tmp8_);
		} else {
			gchar* utf8_text = NULL;
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			_tmp9_ = text;
			_tmp10_ = document_to_utf8 (self, _tmp9_, &_inner_error_);
			utf8_text = _tmp10_;
			if (_inner_error_ != NULL) {
				_g_free0 (text);
				chars = (g_free (chars), NULL);
				goto __catch18_g_error;
			}
			_tmp11_ = utf8_text;
			document_set_contents (self, _tmp11_);
			_g_free0 (utf8_text);
		}
		document_update_syntax_highlighting (self);
		_tmp12_ = gtk_recent_manager_get_default ();
		_tmp13_ = location;
		_tmp14_ = g_file_get_uri (_tmp13_);
		_tmp15_ = _tmp14_;
		gtk_recent_manager_add_item (_tmp12_, _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (text);
		chars = (g_free (chars), NULL);
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gchar* primary_msg = NULL;
		const gchar* _tmp18_ = NULL;
		GFile* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		DocumentTab* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		GError* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		TabInfoBar* _tmp28_ = NULL;
		TabInfoBar* _tmp29_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_warning ("document.vala:119: %s", _tmp17_);
		_tmp18_ = _ ("Impossible to load the file '%s'.");
		_tmp19_ = location;
		_tmp20_ = g_file_get_parse_name (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strdup_printf (_tmp18_, _tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp21_);
		primary_msg = _tmp23_;
		_tmp24_ = self->tab;
		_tmp25_ = primary_msg;
		_tmp26_ = e;
		_tmp27_ = _tmp26_->message;
		_tmp28_ = document_tab_add_message (_tmp24_, _tmp25_, _tmp27_, GTK_MESSAGE_ERROR);
		_tmp29_ = _tmp28_;
		_g_object_unref0 (_tmp29_);
		_g_free0 (primary_msg);
		_g_error_free0 (e);
	}
	__finally18:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


void document_set_contents (Document* self, const gchar* contents) {
	gchar* contents2 = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar _tmp4_ = '\0';
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GtkTextIter iter = {0};
	GtkTextIter _tmp10_ = {0};
	GtkTextIter _tmp11_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (contents != NULL);
	contents2 = NULL;
	_tmp0_ = contents;
	_tmp1_ = contents;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_get (_tmp0_, (glong) (_tmp3_ - 1));
	if (_tmp4_ == '\n') {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = contents;
		_tmp6_ = string_slice (_tmp5_, (glong) 0, (glong) (-1));
		_g_free0 (contents2);
		contents2 = _tmp6_;
	}
	gtk_source_buffer_begin_not_undoable_action ((GtkSourceBuffer*) self);
	_tmp8_ = contents2;
	_tmp7_ = _tmp8_;
	if (_tmp7_ == NULL) {
		const gchar* _tmp9_ = NULL;
		_tmp9_ = contents;
		_tmp7_ = _tmp9_;
	}
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, _tmp7_, -1);
	self->priv->new_file = TRUE;
	gtk_text_buffer_set_modified ((GtkTextBuffer*) self, FALSE);
	gtk_source_buffer_end_not_undoable_action ((GtkSourceBuffer*) self);
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &_tmp10_);
	iter = _tmp10_;
	_tmp11_ = iter;
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) self, &_tmp11_);
	_g_free0 (contents2);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static Block16Data* block16_data_ref (Block16Data* _data16_) {
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}


static void block16_data_unref (void * _userdata_) {
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		Document* self;
		self = _data16_->self;
		_g_object_unref0 (_data16_->infobar);
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}


static void ____lambda16_ (Block16Data* _data16_, gint response_id) {
	Document* self;
	gint _tmp0_ = 0;
	TabInfoBar* _tmp1_ = NULL;
	self = _data16_->self;
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_YES)) {
		document_save (self, FALSE, FALSE);
	}
	_tmp1_ = _data16_->infobar;
	gtk_widget_destroy ((GtkWidget*) _tmp1_);
}


static void _____lambda16__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self) {
	____lambda16_ (self, response_id);
}


void document_save (Document* self, gboolean check_file_changed_on_disk, gboolean force) {
	GFile* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp6_ = {0};
	GtkTextIter _tmp7_ = {0};
	gchar* text = NULL;
	GtkTextIter _tmp8_ = {0};
	GtkTextIter _tmp9_ = {0};
	gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gchar _tmp15_ = '\0';
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_location;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp3_ = force;
	if (!_tmp3_) {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = self->priv->new_file;
		_tmp2_ = !_tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp5_ = FALSE;
		_tmp5_ = document_get_modified (self);
		_tmp1_ = !_tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		return;
	}
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self, &_tmp6_, &_tmp7_);
	start = _tmp6_;
	end = _tmp7_;
	_tmp8_ = start;
	_tmp9_ = end;
	_tmp10_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp8_, &_tmp9_, FALSE);
	text = _tmp10_;
	_tmp11_ = text;
	_tmp12_ = text;
	_tmp13_ = strlen (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = string_get (_tmp11_, (glong) (_tmp14_ - 1));
	if (_tmp15_ != '\n') {
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		_tmp16_ = text;
		_tmp17_ = string_to_string (_tmp16_);
		_tmp18_ = g_strconcat (_tmp17_, "\n", NULL);
		_g_free0 (text);
		text = _tmp18_;
	}
	{
		GSettings* settings = NULL;
		GSettings* _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		gboolean make_backup = FALSE;
		const gchar* _tmp24_ = NULL;
		gboolean _tmp25_ = FALSE;
		gchar* etag = NULL;
		gchar* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		GFile* parent = NULL;
		GFile* _tmp44_ = NULL;
		GFile* _tmp45_ = NULL;
		gboolean _tmp46_ = FALSE;
		GFile* _tmp47_ = NULL;
		GFile* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
		guint8* _tmp53_ = NULL;
		gint _tmp53__length1 = 0;
		guint8* _tmp54_ = NULL;
		gint _tmp54__length1 = 0;
		const gchar* _tmp55_ = NULL;
		gboolean _tmp56_ = FALSE;
		gchar* _tmp57_ = NULL;
		GtkRecentManager* _tmp58_ = NULL;
		GFile* _tmp59_ = NULL;
		gchar* _tmp60_ = NULL;
		gchar* _tmp61_ = NULL;
		_tmp19_ = g_settings_new ("org.gnome.latexila.preferences.editor");
		settings = _tmp19_;
		_tmp21_ = self->priv->backup_made;
		if (!_tmp21_) {
			GSettings* _tmp22_ = NULL;
			gboolean _tmp23_ = FALSE;
			_tmp22_ = settings;
			_tmp23_ = g_settings_get_boolean (_tmp22_, "create-backup-copy");
			_tmp20_ = _tmp23_;
		} else {
			_tmp20_ = FALSE;
		}
		make_backup = _tmp20_;
		_tmp25_ = check_file_changed_on_disk;
		if (_tmp25_) {
			const gchar* _tmp26_ = NULL;
			_tmp26_ = self->priv->_etag;
			_tmp24_ = _tmp26_;
		} else {
			_tmp24_ = NULL;
		}
		_tmp27_ = g_strdup (_tmp24_);
		etag = _tmp27_;
		_tmp28_ = self->priv->encoding;
		if (_tmp28_ != NULL) {
			gchar* _tmp29_ = NULL;
			const gchar* _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
			gint _tmp32_ = 0;
			gint _tmp33_ = 0;
			const gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			_tmp30_ = text;
			_tmp31_ = text;
			_tmp32_ = strlen (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = self->priv->encoding;
			_tmp35_ = g_convert (_tmp30_, (gssize) _tmp33_, _tmp34_, "UTF-8", NULL, NULL, &_inner_error_);
			_tmp29_ = _tmp35_;
			if (_inner_error_ != NULL) {
				_g_free0 (etag);
				_g_object_unref0 (settings);
				goto __catch19_g_error;
			}
			_tmp36_ = _tmp29_;
			_tmp29_ = NULL;
			_g_free0 (text);
			text = _tmp36_;
			_g_free0 (_tmp29_);
		} else {
			gchar* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
			const gchar* _tmp39_ = NULL;
			gint _tmp40_ = 0;
			gint _tmp41_ = 0;
			gchar* _tmp42_ = NULL;
			gchar* _tmp43_ = NULL;
			_tmp38_ = text;
			_tmp39_ = text;
			_tmp40_ = strlen (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_filename_from_utf8 (_tmp38_, (gssize) _tmp41_, NULL, NULL, &_inner_error_);
			_tmp37_ = _tmp42_;
			if (_inner_error_ != NULL) {
				_g_free0 (etag);
				_g_object_unref0 (settings);
				goto __catch19_g_error;
			}
			_tmp43_ = _tmp37_;
			_tmp37_ = NULL;
			_g_free0 (text);
			text = _tmp43_;
			_g_free0 (_tmp37_);
		}
		_tmp44_ = self->priv->_location;
		_tmp45_ = g_file_get_parent (_tmp44_);
		parent = _tmp45_;
		_tmp47_ = parent;
		if (_tmp47_ != NULL) {
			GFile* _tmp48_ = NULL;
			gboolean _tmp49_ = FALSE;
			_tmp48_ = parent;
			_tmp49_ = g_file_query_exists (_tmp48_, NULL);
			_tmp46_ = !_tmp49_;
		} else {
			_tmp46_ = FALSE;
		}
		if (_tmp46_) {
			GFile* _tmp50_ = NULL;
			_tmp50_ = parent;
			g_file_make_directory_with_parents (_tmp50_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (parent);
				_g_free0 (etag);
				_g_object_unref0 (settings);
				goto __catch19_g_error;
			}
		}
		_tmp51_ = self->priv->_location;
		_tmp52_ = text;
		_tmp53_ = string_get_data (_tmp52_, &_tmp53__length1);
		_tmp54_ = _tmp53_;
		_tmp54__length1 = _tmp53__length1;
		_tmp55_ = etag;
		_tmp56_ = make_backup;
		g_file_replace_contents (_tmp51_, _tmp54_, (gsize) _tmp54__length1, _tmp55_, _tmp56_, G_FILE_CREATE_NONE, &_tmp57_, NULL, &_inner_error_);
		_g_free0 (self->priv->_etag);
		self->priv->_etag = _tmp57_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parent);
			_g_free0 (etag);
			_g_object_unref0 (settings);
			goto __catch19_g_error;
		}
		gtk_text_buffer_set_modified ((GtkTextBuffer*) self, FALSE);
		_tmp58_ = gtk_recent_manager_get_default ();
		_tmp59_ = self->priv->_location;
		_tmp60_ = g_file_get_uri (_tmp59_);
		_tmp61_ = _tmp60_;
		gtk_recent_manager_add_item (_tmp58_, _tmp61_);
		_g_free0 (_tmp61_);
		self->priv->backup_made = TRUE;
		_g_object_unref0 (parent);
		_g_free0 (etag);
		_g_object_unref0 (settings);
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* e = NULL;
		GError* _tmp62_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp62_ = e;
		if (g_error_matches (_tmp62_, G_IO_ERROR, G_IO_ERROR_WRONG_ETAG)) {
			Block16Data* _data16_;
			gchar* primary_msg = NULL;
			const gchar* _tmp63_ = NULL;
			GFile* _tmp64_ = NULL;
			gchar* _tmp65_ = NULL;
			gchar* _tmp66_ = NULL;
			gchar* _tmp67_ = NULL;
			gchar* _tmp68_ = NULL;
			gchar* secondary_msg = NULL;
			const gchar* _tmp69_ = NULL;
			gchar* _tmp70_ = NULL;
			DocumentTab* _tmp71_ = NULL;
			const gchar* _tmp72_ = NULL;
			const gchar* _tmp73_ = NULL;
			TabInfoBar* _tmp74_ = NULL;
			TabInfoBar* _tmp75_ = NULL;
			const gchar* _tmp76_ = NULL;
			TabInfoBar* _tmp77_ = NULL;
			const gchar* _tmp78_ = NULL;
			TabInfoBar* _tmp79_ = NULL;
			_data16_ = g_slice_new0 (Block16Data);
			_data16_->_ref_count_ = 1;
			_data16_->self = g_object_ref (self);
			_tmp63_ = _ ("The file %s has been modified since reading it.");
			_tmp64_ = self->priv->_location;
			_tmp65_ = g_file_get_parse_name (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = g_strdup_printf (_tmp63_, _tmp66_);
			_tmp68_ = _tmp67_;
			_g_free0 (_tmp66_);
			primary_msg = _tmp68_;
			_tmp69_ = _ ("If you save it, all the external changes could be lost. Save it anyway" \
"?");
			_tmp70_ = g_strdup (_tmp69_);
			secondary_msg = _tmp70_;
			_tmp71_ = self->tab;
			_tmp72_ = primary_msg;
			_tmp73_ = secondary_msg;
			_tmp74_ = document_tab_add_message (_tmp71_, _tmp72_, _tmp73_, GTK_MESSAGE_WARNING);
			_data16_->infobar = _tmp74_;
			_tmp75_ = _data16_->infobar;
			_tmp76_ = _ ("Save Anyway");
			tab_info_bar_add_stock_button_with_text (_tmp75_, _tmp76_, GTK_STOCK_SAVE, (gint) GTK_RESPONSE_YES);
			_tmp77_ = _data16_->infobar;
			_tmp78_ = _ ("Don't Save");
			gtk_info_bar_add_button ((GtkInfoBar*) _tmp77_, _tmp78_, (gint) GTK_RESPONSE_CANCEL);
			_tmp79_ = _data16_->infobar;
			g_signal_connect_data ((GtkInfoBar*) _tmp79_, "response", (GCallback) _____lambda16__gtk_info_bar_response, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
			_g_free0 (secondary_msg);
			_g_free0 (primary_msg);
			block16_data_unref (_data16_);
			_data16_ = NULL;
		} else {
			GError* _tmp80_ = NULL;
			const gchar* _tmp81_ = NULL;
			gchar* primary_msg = NULL;
			const gchar* _tmp82_ = NULL;
			gchar* _tmp83_ = NULL;
			TabInfoBar* infobar = NULL;
			DocumentTab* _tmp84_ = NULL;
			const gchar* _tmp85_ = NULL;
			GError* _tmp86_ = NULL;
			const gchar* _tmp87_ = NULL;
			TabInfoBar* _tmp88_ = NULL;
			TabInfoBar* _tmp89_ = NULL;
			_tmp80_ = e;
			_tmp81_ = _tmp80_->message;
			g_warning ("document.vala:215: %s", _tmp81_);
			_tmp82_ = _ ("Impossible to save the file.");
			_tmp83_ = g_strdup (_tmp82_);
			primary_msg = _tmp83_;
			_tmp84_ = self->tab;
			_tmp85_ = primary_msg;
			_tmp86_ = e;
			_tmp87_ = _tmp86_->message;
			_tmp88_ = document_tab_add_message (_tmp84_, _tmp85_, _tmp87_, GTK_MESSAGE_ERROR);
			infobar = _tmp88_;
			_tmp89_ = infobar;
			tab_info_bar_add_ok_button (_tmp89_);
			_g_object_unref0 (infobar);
			_g_free0 (primary_msg);
		}
		_g_error_free0 (e);
	}
	__finally19:
	if (_inner_error_ != NULL) {
		_g_free0 (text);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (text);
}


static gchar* document_to_utf8 (Document* self, const gchar* text, GError** error) {
	gchar* result = NULL;
	const gchar* _tmp9_ = NULL;
	GError* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	{
		const gchar** charset_collection = NULL;
		gint charset_collection_length1 = 0;
		gint _charset_collection_size_ = 0;
		gint charset_it = 0;
		charset_collection = ENCODINGS_CHARSETS;
		charset_collection_length1 = G_N_ELEMENTS (ENCODINGS_CHARSETS);
		for (charset_it = 0; charset_it < G_N_ELEMENTS (ENCODINGS_CHARSETS); charset_it = charset_it + 1) {
			gchar* _tmp0_ = NULL;
			gchar* charset = NULL;
			_tmp0_ = g_strdup (charset_collection[charset_it]);
			charset = _tmp0_;
			{
				{
					gchar* utf8_text = NULL;
					const gchar* _tmp1_ = NULL;
					const gchar* _tmp2_ = NULL;
					gint _tmp3_ = 0;
					gint _tmp4_ = 0;
					const gchar* _tmp5_ = NULL;
					gchar* _tmp6_ = NULL;
					const gchar* _tmp7_ = NULL;
					gchar* _tmp8_ = NULL;
					_tmp1_ = text;
					_tmp2_ = text;
					_tmp3_ = strlen (_tmp2_);
					_tmp4_ = _tmp3_;
					_tmp5_ = charset;
					_tmp6_ = g_convert (_tmp1_, (gssize) _tmp4_, "UTF-8", _tmp5_, NULL, NULL, &_inner_error_);
					utf8_text = _tmp6_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == G_CONVERT_ERROR) {
							goto __catch20_g_convert_error;
						}
						_g_free0 (charset);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_tmp7_ = charset;
					_tmp8_ = g_strdup (_tmp7_);
					_g_free0 (self->priv->encoding);
					self->priv->encoding = _tmp8_;
					result = utf8_text;
					_g_free0 (charset);
					return result;
				}
				goto __finally20;
				__catch20_g_convert_error:
				{
					GError* e = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (e);
					_g_free0 (charset);
					continue;
				}
				__finally20:
				if (_inner_error_->domain == G_CONVERT_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (charset);
					return NULL;
				} else {
					_g_free0 (charset);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_free0 (charset);
			}
		}
	}
	_tmp9_ = _ ("Error trying to convert the document to UTF-8");
	_tmp10_ = g_error_new_literal (G_CONVERT_ERROR, G_CONVERT_ERROR_FAILED, _tmp9_);
	_inner_error_ = _tmp10_;
	if (_inner_error_->domain == G_CONVERT_ERROR) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void document_update_syntax_highlighting (Document* self) {
	GtkSourceLanguageManager* lm = NULL;
	GtkSourceLanguageManager* _tmp0_ = NULL;
	GtkSourceLanguageManager* _tmp1_ = NULL;
	gchar* content_type = NULL;
	GtkSourceLanguage* lang = NULL;
	GFile* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkSourceLanguage* _tmp10_ = NULL;
	GtkSourceLanguage* _tmp11_ = NULL;
	GtkSourceLanguage* _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_source_language_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	lm = _tmp1_;
	content_type = NULL;
	{
		GFileInfo* info = NULL;
		GFile* _tmp2_ = NULL;
		GFileInfo* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp2_ = self->priv->_location;
		_tmp3_ = g_file_query_info (_tmp2_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		info = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch21_g_error;
		}
		_tmp4_ = g_file_info_get_content_type (info);
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (content_type);
		content_type = _tmp5_;
		_g_object_unref0 (info);
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally21:
	if (_inner_error_ != NULL) {
		_g_free0 (content_type);
		_g_object_unref0 (lm);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = self->priv->_location;
	_tmp7_ = g_file_get_parse_name (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = content_type;
	_tmp10_ = gtk_source_language_manager_guess_language (lm, _tmp8_, _tmp9_);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp8_);
	lang = _tmp12_;
	gtk_source_buffer_set_language ((GtkSourceBuffer*) self, lang);
	_g_object_unref0 (lang);
	_g_free0 (content_type);
	_g_object_unref0 (lm);
}


static void document_update_project_id (Document* self) {
	gint i = 0;
	g_return_if_fail (self != NULL);
	i = 0;
	{
		GeeIterator* _project_it = NULL;
		Projects* _tmp0_ = NULL;
		Projects* _tmp1_ = NULL;
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _tmp3_ = NULL;
		_tmp0_ = projects_get_default ();
		_tmp1_ = _tmp0_;
		_tmp2_ = projects_iterator (_tmp1_);
		_tmp3_ = _tmp2_;
		_projects_unref0 (_tmp1_);
		_project_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			Project project = {0};
			GeeIterator* _tmp6_ = NULL;
			gpointer _tmp7_ = NULL;
			Project* _tmp8_ = NULL;
			Project _tmp9_ = {0};
			Project _tmp10_ = {0};
			GFile* _tmp11_ = NULL;
			Project _tmp12_ = {0};
			GFile* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			gint _tmp16_ = 0;
			_tmp4_ = _project_it;
			_tmp5_ = gee_iterator_next (_tmp4_);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = _project_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			_tmp8_ = (Project*) _tmp7_;
			project_copy (_tmp8_, &_tmp9_);
			_tmp10_ = _tmp9_;
			_project_free0 (_tmp8_);
			project = _tmp10_;
			_tmp11_ = self->priv->_location;
			_tmp12_ = project;
			_tmp13_ = _tmp12_.directory;
			_tmp14_ = g_file_has_prefix (_tmp11_, _tmp13_);
			if (_tmp14_) {
				gint _tmp15_ = 0;
				_tmp15_ = i;
				document_set_project_id (self, _tmp15_);
				project_destroy (&project);
				_g_object_unref0 (_project_it);
				return;
			}
			_tmp16_ = i;
			i = _tmp16_ + 1;
			project_destroy (&project);
		}
		_g_object_unref0 (_project_it);
	}
	document_set_project_id (self, -1);
}


gchar* document_get_uri_for_display (Document* self) {
	gchar* result = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = document_get_unsaved_document_name (self);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->_location;
	_tmp3_ = g_file_get_parse_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = utils_replace_home_dir_with_tilde (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	result = _tmp6_;
	return result;
}


gchar* document_get_short_name_for_display (Document* self) {
	gchar* result = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = document_get_unsaved_document_name (self);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->_location;
	_tmp3_ = g_file_get_basename (_tmp2_);
	result = _tmp3_;
	return result;
}


static gchar* document_get_unsaved_document_name (Document* self) {
	gchar* result = NULL;
	guint num = 0U;
	guint _tmp0_ = 0U;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = document_get_unsaved_document_num (self);
	num = _tmp0_;
	_tmp1_ = _ ("Unsaved Document");
	_tmp2_ = g_strdup_printf ("%u", num);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (" ", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp1_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	result = _tmp7_;
	return result;
}


static void _vala_array_add14 (guint** array, int* length, int* size, guint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static gboolean _vala_uint_array_contains (guint* stack, int stack_length, guint needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}


static guint document_get_unsaved_document_num (Document* self) {
	guint result = 0U;
	GFile* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint* all_nums = NULL;
	guint* _tmp3_ = NULL;
	gint all_nums_length1 = 0;
	gint _all_nums_size_ = 0;
	guint num = 0U;
	guint _tmp27_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_location;
	g_return_val_if_fail (_tmp0_ == NULL, 0);
	_tmp1_ = self->_unsaved_doc_num;
	if (_tmp1_ > ((guint) 0)) {
		guint _tmp2_ = 0U;
		_tmp2_ = self->_unsaved_doc_num;
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_new0 (guint, 0);
	all_nums = _tmp3_;
	all_nums_length1 = 0;
	_all_nums_size_ = all_nums_length1;
	{
		GeeList* _doc_list = NULL;
		Latexila* _tmp4_ = NULL;
		Latexila* _tmp5_ = NULL;
		GeeList* _tmp6_ = NULL;
		GeeList* _tmp7_ = NULL;
		gint _doc_size = 0;
		GeeList* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _doc_index = 0;
		_tmp4_ = latexila_get_instance ();
		_tmp5_ = _tmp4_;
		_tmp6_ = latexila_get_documents (_tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_doc_list = _tmp7_;
		_tmp8_ = _doc_list;
		_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_doc_size = _tmp10_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			Document* doc = NULL;
			GeeList* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			gpointer _tmp16_ = NULL;
			Document* _tmp17_ = NULL;
			Document* _tmp18_ = NULL;
			GFile* _tmp19_ = NULL;
			_tmp11_ = _doc_index;
			_doc_index = _tmp11_ + 1;
			_tmp12_ = _doc_index;
			_tmp13_ = _doc_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _doc_list;
			_tmp15_ = _doc_index;
			_tmp16_ = gee_list_get (_tmp14_, _tmp15_);
			doc = (Document*) _tmp16_;
			_tmp17_ = doc;
			if (_tmp17_ == self) {
				_g_object_unref0 (doc);
				continue;
			}
			_tmp18_ = doc;
			_tmp19_ = _tmp18_->priv->_location;
			if (_tmp19_ == NULL) {
				guint* _tmp20_ = NULL;
				gint _tmp20__length1 = 0;
				Document* _tmp21_ = NULL;
				guint _tmp22_ = 0U;
				_tmp20_ = all_nums;
				_tmp20__length1 = all_nums_length1;
				_tmp21_ = doc;
				_tmp22_ = document_get_unsaved_document_num (_tmp21_);
				_vala_array_add14 (&all_nums, &all_nums_length1, &_all_nums_size_, _tmp22_);
			}
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
	{
		gboolean _tmp23_ = FALSE;
		num = (guint) 1;
		_tmp23_ = TRUE;
		while (TRUE) {
			guint _tmp25_ = 0U;
			guint* _tmp26_ = NULL;
			gint _tmp26__length1 = 0;
			if (!_tmp23_) {
				guint _tmp24_ = 0U;
				_tmp24_ = num;
				num = _tmp24_ + 1;
			}
			_tmp23_ = FALSE;
			_tmp25_ = num;
			_tmp26_ = all_nums;
			_tmp26__length1 = all_nums_length1;
			if (!_vala_uint_array_contains (_tmp26_, _tmp26__length1, _tmp25_)) {
				break;
			}
		}
	}
	_tmp27_ = num;
	self->_unsaved_doc_num = _tmp27_;
	result = num;
	all_nums = (g_free (all_nums), NULL);
	return result;
}


gboolean document_is_local (Document* self) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_location;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->_location;
	_tmp2_ = g_file_has_uri_scheme (_tmp1_, "file");
	result = _tmp2_;
	return result;
}


gboolean document_is_externally_modified (Document* self) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	gchar* current_etag = NULL;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_location;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	current_etag = NULL;
	{
		GFileInfo* file_info = NULL;
		GFile* _tmp1_ = NULL;
		GFileInfo* _tmp2_ = NULL;
		GFileInfo* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp1_ = self->priv->_location;
		_tmp2_ = g_file_query_info (_tmp1_, G_FILE_ATTRIBUTE_ETAG_VALUE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		file_info = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch22_g_error;
		}
		_tmp3_ = file_info;
		_tmp4_ = g_file_info_get_etag (_tmp3_);
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (current_etag);
		current_etag = _tmp5_;
		_g_object_unref0 (file_info);
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (current_etag);
		return result;
	}
	__finally22:
	if (_inner_error_ != NULL) {
		_g_free0 (current_etag);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp7_ = current_etag;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_tmp8_ = current_etag;
		_tmp9_ = self->priv->_etag;
		_tmp6_ = g_strcmp0 (_tmp8_, _tmp9_) != 0;
	} else {
		_tmp6_ = FALSE;
	}
	result = _tmp6_;
	_g_free0 (current_etag);
	return result;
}


void document_set_style_scheme_from_string (Document* self, const gchar* scheme_id) {
	GtkSourceStyleSchemeManager* manager = NULL;
	GtkSourceStyleSchemeManager* _tmp0_ = NULL;
	GtkSourceStyleSchemeManager* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkSourceStyleScheme* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scheme_id != NULL);
	_tmp0_ = gtk_source_style_scheme_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	manager = _tmp1_;
	_tmp2_ = scheme_id;
	_tmp3_ = gtk_source_style_scheme_manager_get_scheme (manager, _tmp2_);
	gtk_source_buffer_set_style_scheme ((GtkSourceBuffer*) self, _tmp3_);
	_g_object_unref0 (manager);
}


void document_comment_selected_lines (Document* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_ = {0};
	GtkTextIter _tmp3_ = {0};
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
	start = _tmp0_;
	end = _tmp1_;
	_tmp2_ = start;
	_tmp3_ = end;
	document_comment_between (self, &_tmp2_, &_tmp3_, TRUE);
}


void document_comment_between (Document* self, GtkTextIter* start_iter, GtkTextIter* end_iter, gboolean end_iter_set) {
	gint start_line = 0;
	gint _tmp0_ = 0;
	gint end_line = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	GtkTextIter cur_iter = {0};
	gint _tmp4_ = 0;
	GtkTextIter _tmp5_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (start_iter != NULL);
	g_return_if_fail (end_iter != NULL);
	_tmp0_ = gtk_text_iter_get_line (start_iter);
	start_line = _tmp0_;
	_tmp1_ = start_line;
	end_line = _tmp1_;
	_tmp2_ = end_iter_set;
	if (_tmp2_) {
		gint _tmp3_ = 0;
		_tmp3_ = gtk_text_iter_get_line (end_iter);
		end_line = _tmp3_;
	}
	_tmp4_ = start_line;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp5_, _tmp4_);
	cur_iter = _tmp5_;
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self);
	{
		gint line_num = 0;
		gint _tmp6_ = 0;
		_tmp6_ = start_line;
		line_num = _tmp6_;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				if (!_tmp7_) {
					gint _tmp8_ = 0;
					_tmp8_ = line_num;
					line_num = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = line_num;
				_tmp10_ = end_line;
				if (!(_tmp9_ <= _tmp10_)) {
					break;
				}
				document_insert (self, &cur_iter, "% ", -1);
				gtk_text_iter_forward_line (&cur_iter);
			}
		}
	}
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) self);
}


void document_uncomment_selected_lines (Document* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gint start_line = 0;
	gint _tmp2_ = 0;
	gint end_line = 0;
	gint _tmp3_ = 0;
	gint line_count = 0;
	gint _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
	start = _tmp0_;
	end = _tmp1_;
	_tmp2_ = gtk_text_iter_get_line (&start);
	start_line = _tmp2_;
	_tmp3_ = gtk_text_iter_get_line (&end);
	end_line = _tmp3_;
	_tmp4_ = gtk_text_buffer_get_line_count ((GtkTextBuffer*) self);
	line_count = _tmp4_;
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self);
	{
		gint i = 0;
		gint _tmp5_ = 0;
		_tmp5_ = start_line;
		i = _tmp5_;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				GtkTextIter _tmp11_ = {0};
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gchar* line = NULL;
				GtkTextIter _tmp17_ = {0};
				GtkTextIter _tmp18_ = {0};
				gchar* _tmp19_ = NULL;
				gint j = 0;
				gint start_delete = 0;
				gint stop_delete = 0;
				gint _tmp40_ = 0;
				gint _tmp41_ = 0;
				gint _tmp42_ = 0;
				GtkTextIter _tmp43_ = {0};
				gint _tmp44_ = 0;
				gint _tmp45_ = 0;
				GtkTextIter _tmp46_ = {0};
				if (!_tmp6_) {
					gint _tmp7_ = 0;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = i;
				_tmp9_ = end_line;
				if (!(_tmp8_ <= _tmp9_)) {
					break;
				}
				_tmp10_ = i;
				gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp11_, _tmp10_);
				start = _tmp11_;
				_tmp12_ = i;
				_tmp13_ = line_count;
				if (_tmp12_ == (_tmp13_ - 1)) {
					GtkTextIter _tmp14_ = {0};
					gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &_tmp14_);
					end = _tmp14_;
				} else {
					gint _tmp15_ = 0;
					GtkTextIter _tmp16_ = {0};
					_tmp15_ = i;
					gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp16_, _tmp15_ + 1);
					end = _tmp16_;
				}
				_tmp17_ = start;
				_tmp18_ = end;
				_tmp19_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp17_, &_tmp18_, FALSE);
				line = _tmp19_;
				j = 0;
				start_delete = -1;
				stop_delete = -1;
				while (TRUE) {
					const gchar* _tmp20_ = NULL;
					gint _tmp21_ = 0;
					gchar _tmp22_ = '\0';
					const gchar* _tmp23_ = NULL;
					gint _tmp24_ = 0;
					gchar _tmp25_ = '\0';
					gint _tmp39_ = 0;
					_tmp20_ = line;
					_tmp21_ = j;
					_tmp22_ = string_get (_tmp20_, (glong) _tmp21_);
					if (!(_tmp22_ != '\0')) {
						break;
					}
					_tmp23_ = line;
					_tmp24_ = j;
					_tmp25_ = string_get (_tmp23_, (glong) _tmp24_);
					if (_tmp25_ == '%') {
						gint _tmp26_ = 0;
						gint _tmp27_ = 0;
						const gchar* _tmp28_ = NULL;
						gint _tmp29_ = 0;
						gchar _tmp30_ = '\0';
						_tmp26_ = j;
						start_delete = _tmp26_;
						_tmp27_ = j;
						stop_delete = _tmp27_ + 1;
						_tmp28_ = line;
						_tmp29_ = j;
						_tmp30_ = string_get (_tmp28_, (glong) (_tmp29_ + 1));
						if (_tmp30_ == ' ') {
							gint _tmp31_ = 0;
							_tmp31_ = stop_delete;
							stop_delete = _tmp31_ + 1;
						}
						break;
					} else {
						gboolean _tmp32_ = FALSE;
						const gchar* _tmp33_ = NULL;
						gint _tmp34_ = 0;
						gchar _tmp35_ = '\0';
						_tmp33_ = line;
						_tmp34_ = j;
						_tmp35_ = string_get (_tmp33_, (glong) _tmp34_);
						if (_tmp35_ != ' ') {
							const gchar* _tmp36_ = NULL;
							gint _tmp37_ = 0;
							gchar _tmp38_ = '\0';
							_tmp36_ = line;
							_tmp37_ = j;
							_tmp38_ = string_get (_tmp36_, (glong) _tmp37_);
							_tmp32_ = _tmp38_ != '\t';
						} else {
							_tmp32_ = FALSE;
						}
						if (_tmp32_) {
							break;
						}
					}
					_tmp39_ = j;
					j = _tmp39_ + 1;
				}
				_tmp40_ = start_delete;
				if (_tmp40_ == (-1)) {
					_g_free0 (line);
					continue;
				}
				_tmp41_ = i;
				_tmp42_ = start_delete;
				gtk_text_buffer_get_iter_at_line_offset ((GtkTextBuffer*) self, &_tmp43_, _tmp41_, _tmp42_);
				start = _tmp43_;
				_tmp44_ = i;
				_tmp45_ = stop_delete;
				gtk_text_buffer_get_iter_at_line_offset ((GtkTextBuffer*) self, &_tmp46_, _tmp44_, _tmp45_);
				end = _tmp46_;
				gtk_text_buffer_delete ((GtkTextBuffer*) self, &start, &end);
				_g_free0 (line);
			}
		}
	}
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) self);
}


void document_select_lines (Document* self, gint start, gint end) {
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	gint _tmp0_ = 0;
	GtkTextIter _tmp1_ = {0};
	gint _tmp2_ = 0;
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_ = {0};
	GtkTextIter _tmp5_ = {0};
	DocumentTab* _tmp6_ = NULL;
	DocumentView* _tmp7_ = NULL;
	DocumentView* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = start;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp1_, _tmp0_);
	start_iter = _tmp1_;
	_tmp2_ = end;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp3_, _tmp2_);
	end_iter = _tmp3_;
	_tmp4_ = start_iter;
	_tmp5_ = end_iter;
	gtk_text_buffer_select_range ((GtkTextBuffer*) self, &_tmp4_, &_tmp5_);
	_tmp6_ = self->tab;
	_tmp7_ = document_tab_get_view (_tmp6_);
	_tmp8_ = _tmp7_;
	document_view_scroll_to_cursor (_tmp8_, 0.25);
}


SelectionType document_get_selection_type (Document* self) {
	SelectionType result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp2_ = {0};
	GtkTextIter _tmp3_ = {0};
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		result = SELECTION_TYPE_NO_SELECTION;
		return result;
	}
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &_tmp2_, &_tmp3_);
	start = _tmp2_;
	end = _tmp3_;
	_tmp4_ = gtk_text_iter_get_line (&start);
	_tmp5_ = gtk_text_iter_get_line (&end);
	if (_tmp4_ == _tmp5_) {
		result = SELECTION_TYPE_ONE_LINE;
		return result;
	}
	result = SELECTION_TYPE_MULTIPLE_LINES;
	return result;
}


gboolean document_goto_line (Document* self, gint line) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gboolean ret = FALSE;
	GtkTextIter iter = {0};
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkTextIter _tmp6_ = {0};
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = line;
	g_return_val_if_fail (_tmp0_ >= (-1), FALSE);
	ret = TRUE;
	_tmp1_ = line;
	_tmp2_ = gtk_text_buffer_get_line_count ((GtkTextBuffer*) self);
	if (_tmp1_ >= _tmp2_) {
		GtkTextIter _tmp3_ = {0};
		ret = FALSE;
		gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &_tmp3_);
		iter = _tmp3_;
	} else {
		gint _tmp4_ = 0;
		GtkTextIter _tmp5_ = {0};
		_tmp4_ = line;
		gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp5_, _tmp4_);
		iter = _tmp5_;
	}
	_tmp6_ = iter;
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) self, &_tmp6_);
	result = ret;
	return result;
}


Project* document_get_project (Document* self) {
	Project* result = NULL;
	gint _tmp0_ = 0;
	Projects* _tmp1_ = NULL;
	Projects* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Project* _tmp4_ = NULL;
	Project* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_project_id;
	if (_tmp0_ == (-1)) {
		result = NULL;
		return result;
	}
	_tmp1_ = projects_get_default ();
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_project_id;
	_tmp4_ = projects_get (_tmp2_, _tmp3_);
	_tmp5_ = _tmp4_;
	_projects_unref0 (_tmp2_);
	result = _tmp5_;
	return result;
}


GFile* document_get_main_file (Document* self) {
	GFile* result = NULL;
	GFile* _tmp0_ = NULL;
	Project* project = NULL;
	Project* _tmp1_ = NULL;
	Project* _tmp2_ = NULL;
	Project* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	GFile* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = document_get_project (self);
	project = _tmp1_;
	_tmp2_ = project;
	if (_tmp2_ == NULL) {
		GFile* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		_tmp3_ = self->priv->_location;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		result = _tmp4_;
		_project_free0 (project);
		return result;
	}
	_tmp5_ = project;
	_tmp6_ = (*_tmp5_).main_file;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	result = _tmp7_;
	_project_free0 (project);
	return result;
}


gboolean document_is_main_file_a_tex_file (Document* self) {
	gboolean result = FALSE;
	GFile* main_file = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gchar* path = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = document_get_main_file (self);
	main_file = _tmp0_;
	_tmp1_ = main_file;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (main_file);
		return result;
	}
	_tmp2_ = main_file;
	_tmp3_ = g_file_get_parse_name (_tmp2_);
	path = _tmp3_;
	_tmp4_ = path;
	_tmp5_ = g_str_has_suffix (_tmp4_, ".tex");
	result = _tmp5_;
	_g_free0 (path);
	_g_object_unref0 (main_file);
	return result;
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


gchar* document_get_current_indentation (Document* self, GtkTextIter* iter) {
	gchar* result = NULL;
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	gint line = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GtkTextIter _tmp2_ = {0};
	gint _tmp3_ = 0;
	GtkTextIter _tmp4_ = {0};
	gchar* text = NULL;
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_ = {0};
	gchar* _tmp7_ = NULL;
	gchar* current_indent = NULL;
	gchar* _tmp8_ = NULL;
	gint index = 0;
	gunichar cur_char = 0U;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = gtk_text_iter_get_line (iter);
	line = _tmp0_;
	_tmp1_ = line;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp2_, _tmp1_);
	start_iter = _tmp2_;
	_tmp3_ = line;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp4_, _tmp3_ + 1);
	end_iter = _tmp4_;
	_tmp5_ = start_iter;
	_tmp6_ = end_iter;
	_tmp7_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp5_, &_tmp6_, FALSE);
	text = _tmp7_;
	_tmp8_ = g_strdup ("");
	current_indent = _tmp8_;
	index = 0;
	while (TRUE) {
		const gchar* _tmp9_ = NULL;
		gunichar _tmp10_ = 0U;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gunichar _tmp13_ = 0U;
		_tmp9_ = text;
		_tmp11_ = string_get_next_char (_tmp9_, &index, &_tmp10_);
		cur_char = _tmp10_;
		if (!_tmp11_) {
			break;
		}
		_tmp13_ = cur_char;
		if (_tmp13_ == ((gunichar) ' ')) {
			_tmp12_ = TRUE;
		} else {
			gunichar _tmp14_ = 0U;
			_tmp14_ = cur_char;
			_tmp12_ = _tmp14_ == ((gunichar) '\t');
		}
		if (_tmp12_) {
			const gchar* _tmp15_ = NULL;
			gunichar _tmp16_ = 0U;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			_tmp15_ = current_indent;
			_tmp16_ = cur_char;
			_tmp17_ = g_unichar_to_string (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strconcat (_tmp15_, _tmp18_, NULL);
			_g_free0 (current_indent);
			current_indent = _tmp19_;
			_g_free0 (_tmp18_);
		} else {
			break;
		}
	}
	result = current_indent;
	_g_free0 (text);
	return result;
}


DocumentStructure* document_get_structure (Document* self) {
	DocumentStructure* result = NULL;
	DocumentStructure* _tmp0_ = NULL;
	DocumentStructure* _tmp3_ = NULL;
	DocumentStructure* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_structure;
	if (_tmp0_ == NULL) {
		DocumentStructure* _tmp1_ = NULL;
		DocumentStructure* _tmp2_ = NULL;
		_tmp1_ = document_structure_new (self);
		_g_object_unref0 (self->priv->_structure);
		self->priv->_structure = _tmp1_;
		_tmp2_ = self->priv->_structure;
		document_structure_parse (_tmp2_);
	}
	_tmp3_ = self->priv->_structure;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	result = _tmp4_;
	return result;
}


static Block17Data* block17_data_ref (Block17Data* _data17_) {
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}


static void block17_data_unref (void * _userdata_) {
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		Document* self;
		self = _data17_->self;
		_g_object_unref0 (_data17_->infobar);
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}


static void __lambda77_ (Block17Data* _data17_, gint response_id) {
	Document* self;
	gint _tmp0_ = 0;
	TabInfoBar* _tmp5_ = NULL;
	self = _data17_->self;
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_YES)) {
		MainWindow* main_window = NULL;
		DocumentTab* _tmp1_ = NULL;
		GtkWindow* _tmp2_ = NULL;
		MainWindow* _tmp3_ = NULL;
		_tmp1_ = self->tab;
		_tmp2_ = utils_get_toplevel_window ((GtkWidget*) _tmp1_);
		main_window = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, TYPE_MAIN_WINDOW) ? ((MainWindow*) _tmp2_) : NULL;
		_tmp3_ = main_window;
		if (_tmp3_ != NULL) {
			MainWindow* _tmp4_ = NULL;
			_tmp4_ = main_window;
			main_window_save_document (_tmp4_, self, TRUE);
		}
	}
	_tmp5_ = _data17_->infobar;
	gtk_widget_destroy ((GtkWidget*) _tmp5_);
}


static void ___lambda77__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self) {
	__lambda77_ (self, response_id);
}


gboolean document_set_tmp_location (Document* self) {
	gboolean result = FALSE;
	Block17Data* _data17_;
	gchar* template = NULL;
	gchar* _tmp0_ = NULL;
	gchar* tmp_dir = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	GFile* _tmp10_ = NULL;
	GFile* _tmp11_ = NULL;
	DocumentTab* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	TabInfoBar* _tmp15_ = NULL;
	TabInfoBar* _tmp16_ = NULL;
	TabInfoBar* _tmp17_ = NULL;
	TabInfoBar* _tmp18_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->self = g_object_ref (self);
	_tmp0_ = g_strdup ("latexila-XXXXXX");
	template = _tmp0_;
	{
		gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp2_ = template;
		_tmp3_ = g_dir_make_tmp (_tmp2_, &_inner_error_);
		_tmp1_ = _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch23_g_file_error;
			}
			_g_free0 (tmp_dir);
			_g_free0 (template);
			block17_data_unref (_data17_);
			_data17_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		_g_free0 (tmp_dir);
		tmp_dir = _tmp4_;
		_g_free0 (_tmp1_);
	}
	goto __finally23;
	__catch23_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("document.vala:565: Impossible to create temporary directory: %s", _tmp6_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (tmp_dir);
		_g_free0 (template);
		block17_data_unref (_data17_);
		_data17_ = NULL;
		return result;
	}
	__finally23:
	if (_inner_error_ != NULL) {
		_g_free0 (tmp_dir);
		_g_free0 (template);
		block17_data_unref (_data17_);
		_data17_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp7_ = tmp_dir;
	_tmp8_ = g_build_filename (_tmp7_, "tmp.tex", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_file_new_for_path (_tmp9_);
	_tmp11_ = _tmp10_;
	document_set_location (self, _tmp11_);
	_g_object_unref0 (_tmp11_);
	_g_free0 (_tmp9_);
	_tmp12_ = self->tab;
	_tmp13_ = _ ("The file has a temporary location. The data can be lost after rebootin" \
"g your computer.");
	_tmp14_ = _ ("Do you want to save the file in a safer place?");
	_tmp15_ = document_tab_add_message (_tmp12_, _tmp13_, _tmp14_, GTK_MESSAGE_WARNING);
	_data17_->infobar = _tmp15_;
	_tmp16_ = _data17_->infobar;
	gtk_info_bar_add_button ((GtkInfoBar*) _tmp16_, GTK_STOCK_SAVE_AS, (gint) GTK_RESPONSE_YES);
	_tmp17_ = _data17_->infobar;
	gtk_info_bar_add_button ((GtkInfoBar*) _tmp17_, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_NO);
	_tmp18_ = _data17_->infobar;
	g_signal_connect_data ((GtkInfoBar*) _tmp18_, "response", (GCallback) ___lambda77__gtk_info_bar_response, block17_data_ref (_data17_), (GClosureNotify) block17_data_unref, 0);
	result = TRUE;
	_g_free0 (tmp_dir);
	_g_free0 (template);
	block17_data_unref (_data17_);
	_data17_ = NULL;
	return result;
}


GFile* document_get_location (Document* self) {
	GFile* result;
	GFile* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	result = _tmp0_;
	return result;
}


void document_set_location (Document* self, GFile* value) {
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_location);
	self->priv->_location = _tmp1_;
	g_object_notify ((GObject *) self, "location");
}


gboolean document_get_readonly (Document* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_readonly;
	result = _tmp0_;
	return result;
}


void document_set_readonly (Document* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_readonly = _tmp0_;
	g_object_notify ((GObject *) self, "readonly");
}


gint document_get_project_id (Document* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_project_id;
	result = _tmp0_;
	return result;
}


void document_set_project_id (Document* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_project_id = _tmp0_;
	g_object_notify ((GObject *) self, "project-id");
}


static void document_class_init (DocumentClass * klass) {
	document_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DocumentPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_document_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_document_set_property;
	G_OBJECT_CLASS (klass)->finalize = document_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_LOCATION, g_param_spec_object ("location", "location", "location", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_READONLY, g_param_spec_boolean ("readonly", "readonly", "readonly", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_PROJECT_ID, g_param_spec_int ("project-id", "project-id", "project-id", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("cursor_moved", TYPE_DOCUMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void document_instance_init (Document * self) {
	self->priv = DOCUMENT_GET_PRIVATE (self);
	self->priv->_readonly = FALSE;
	self->_unsaved_doc_num = (guint) 0;
	self->priv->_project_id = -1;
	self->priv->backup_made = FALSE;
	self->priv->encoding = NULL;
	self->priv->new_file = TRUE;
	self->priv->_structure = NULL;
}


static void document_finalize (GObject* obj) {
	Document * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOCUMENT, Document);
	_g_object_unref0 (self->priv->_location);
	_g_object_unref0 (self->tab);
	_g_free0 (self->priv->_etag);
	_g_free0 (self->priv->encoding);
	_g_object_unref0 (self->priv->_structure);
	G_OBJECT_CLASS (document_parent_class)->finalize (obj);
}


GType document_get_type (void) {
	static volatile gsize document_type_id__volatile = 0;
	if (g_once_init_enter (&document_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DocumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Document), 0, (GInstanceInitFunc) document_instance_init, NULL };
		GType document_type_id;
		document_type_id = g_type_register_static (gtk_source_buffer_get_type (), "Document", &g_define_type_info, 0);
		g_once_init_leave (&document_type_id__volatile, document_type_id);
	}
	return document_type_id__volatile;
}


static void _vala_document_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Document * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT, Document);
	switch (property_id) {
		case DOCUMENT_LOCATION:
		g_value_set_object (value, document_get_location (self));
		break;
		case DOCUMENT_READONLY:
		g_value_set_boolean (value, document_get_readonly (self));
		break;
		case DOCUMENT_PROJECT_ID:
		g_value_set_int (value, document_get_project_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_document_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Document * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT, Document);
	switch (property_id) {
		case DOCUMENT_LOCATION:
		document_set_location (self, g_value_get_object (value));
		break;
		case DOCUMENT_READONLY:
		document_set_readonly (self, g_value_get_boolean (value));
		break;
		case DOCUMENT_PROJECT_ID:
		document_set_project_id (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



