/* Lasem
 *
 * Copyright © 2007-2008 Emmanuel Pacaud
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author:
 * 	Emmanuel Pacaud <emmanuel@gnome.org>
 */

#include <lsmmathmloperatordictionary.h>
#include <lsmdomentities.h>
#include <stdio.h>

/* Automatically generated using a slightly modified version of gnumerator parser */
/* http://numerator.sourceforge.net/ */

static const LsmMathmlOperatorDictionaryEntry lsm_mathml_operator_entries[] = {
	{
		"(", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, TRUE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		")", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, TRUE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"[", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, TRUE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"]", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, TRUE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"{", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, TRUE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"}", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, TRUE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"CloseCurlyDoubleQuote", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE, TRUE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"CloseCurlyQuote", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE, TRUE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftAngleBracket", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, TRUE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftCeiling", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, TRUE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftDoubleBracket", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, TRUE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftFloor", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, TRUE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"OpenCurlyDoubleQuote", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE, TRUE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"OpenCurlyQuote", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE, TRUE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"RightAngleBracket", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, TRUE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"RightCeiling", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, TRUE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"RightDoubleBracket", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, TRUE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"RightFloor", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, TRUE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"InvisibleComma", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		",", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_VERY_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"HorizontalLine", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"VerticalLine", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		";", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		";", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE, FALSE, FALSE, FALSE, FALSE, TRUE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		":=", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Assign", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Because", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Therefore", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"VerticalSeparator", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"//", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Colon", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"amp", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"amp", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"*=", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"-=", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"+=", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"/=", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"->", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		":", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"..", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_MEDIUM, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"...", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_MEDIUM, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"SuchThat", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DoubleLeftTee", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DoubleRightTee", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DownTee", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftTee", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"RightTee", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Implies", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"RoundImplies", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"|", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"||", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_MEDIUM, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_MEDIUM, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Or", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_MEDIUM, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_MEDIUM, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"&&", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"And", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_MEDIUM, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_MEDIUM, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"amp", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"!", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Not", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Exists", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"ForAll", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotExists", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Element", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotElement", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotReverseElement", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotSquareSubset", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotSquareSubsetEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotSquareSuperset", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotSquareSupersetEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotSubset", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotSubsetEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotSuperset", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotSupersetEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"ReverseElement", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"SquareSubset", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"SquareSubsetEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"SquareSuperset", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"SquareSupersetEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Subset", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"SubsetEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Superset", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"SupersetEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DoubleLeftArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DoubleLeftRightArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DoubleRightArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DownLeftRightVector", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DownLeftTeeVector", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DownLeftVector", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DownLeftVectorBar", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DownRightTeeVector", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DownRightVector", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DownRightVectorBar", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftArrowBar", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftArrowRightArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftRightArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftRightVector", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftTeeArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftTeeVector", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftVector", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftVectorBar", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LowerLeftArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LowerRightArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"RightArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"RightArrowBar", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"RightArrowLeftArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"RightTeeArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"RightTeeVector", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"RightVector", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"RightVectorBar", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"ShortLeftArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"ShortRightArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"UpperLeftArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"UpperRightArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"=", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"lt", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		">", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"!=", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"==", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"<=", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		">=", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Congruent", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"CupCap", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DotEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DoubleVerticalBar", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Equal", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"EqualTilde", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Equilibrium", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"GreaterEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"GreaterEqualLess", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"GreaterFullEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"GreaterGreater", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"GreaterLess", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"GreaterSlantEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"GreaterTilde", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"HumpDownHump", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"HumpEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftTriangle", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftTriangleBar", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftTriangleEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"le", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LessEqualGreater", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LessFullEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LessGreater", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LessLess", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LessSlantEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LessTilde", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NestedGreaterGreater", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NestedLessLess", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotCongruent", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotCupCap", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotDoubleVerticalBar", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotEqualTilde", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotGreater", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotGreaterEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotGreaterFullEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotGreaterGreater", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotGreaterLess", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotGreaterSlantEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotGreaterTilde", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotHumpDownHump", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotHumpEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotLeftTriangle", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotLeftTriangleBar", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotLeftTriangleEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotLess", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotLessEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotLessGreater", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotLessLess", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotLessSlantEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotLessTilde", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotNestedGreaterGreater", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotNestedLessLess", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotPrecedes", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotPrecedesEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotPrecedesSlantEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotRightTriangle", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotRightTriangleBar", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotRightTriangleEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotSucceeds", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotSucceedsEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotSucceedsSlantEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotSucceedsTilde", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotTilde", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotTildeEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotTildeFullEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotTildeTilde", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"NotVerticalBar", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Precedes", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"PrecedesEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"PrecedesSlantEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"PrecedesTilde", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Proportion", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Proportional", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"ReverseEquilibrium", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"RightTriangle", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"RightTriangleBar", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"RightTriangleEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Succeeds", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"SucceedsEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"SucceedsSlantEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"SucceedsTilde", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Tilde", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"TildeEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"TildeFullEqual", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"TildeTilde", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"UpTee", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"VerticalBar", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"SquareUnion", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_MEDIUM, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_MEDIUM, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Union", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_MEDIUM, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_MEDIUM, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"UnionPlus", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_MEDIUM, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_MEDIUM, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"−", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_MEDIUM, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_MEDIUM, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"+", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_MEDIUM, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_MEDIUM, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Intersection", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_MEDIUM, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_MEDIUM, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"MinusPlus", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_MEDIUM, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_MEDIUM, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"PlusMinus", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_MEDIUM, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_MEDIUM, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"SquareIntersection", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_MEDIUM, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_MEDIUM, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Vee", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, TRUE, TRUE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"CircleMinus", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, TRUE, TRUE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"CirclePlus", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, TRUE, TRUE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Sum", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		FALSE /*TRUE*/, FALSE, FALSE, TRUE, TRUE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Union", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, TRUE, TRUE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"UnionPlus", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, TRUE, TRUE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"lim", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, TRUE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"max", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, TRUE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"min", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, TRUE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"CircleMinus", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"CirclePlus", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"ClockwiseContourIntegral", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE /*TRUE*/, FALSE, FALSE, TRUE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"ContourIntegral", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE /*TRUE*/, FALSE, FALSE, TRUE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"CounterClockwiseContourIntegral", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE /*TRUE*/, FALSE, FALSE, TRUE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DoubleContourIntegral", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE /*TRUE*/, FALSE, FALSE, TRUE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Integral", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE /*TRUE*/, FALSE, FALSE, TRUE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Cup", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, TRUE /* FALSE */, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Cap", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, TRUE /* FALSE */, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"VerticalTilde", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Wedge", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, TRUE, TRUE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"CircleTimes", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, TRUE, TRUE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Coproduct", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		FALSE /*TRUE*/, FALSE, FALSE, TRUE, TRUE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Product", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		FALSE /*TRUE*/, FALSE, FALSE, TRUE, TRUE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Intersection", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, TRUE, TRUE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	/*
	{
		"Coproduct", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	*/
	{
		"Star", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"CircleDot", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, TRUE, TRUE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"*", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"InvisibleTimes", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"CenterDot", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"CircleTimes", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Vee", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Wedge", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Diamond", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Backslash", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"/", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"−", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_VERY_VERY_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"+", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_VERY_VERY_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"MinusPlus", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_VERY_VERY_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"PlusMinus", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_VERY_VERY_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		".", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Cross", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"**", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"CircleDot", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"SmallCircle", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Square", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Del", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"PartialD", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"CapitalDifferentialD", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DifferentialD", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Sqrt", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DoubleDownArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		FALSE /* TRUE */
	},
	{
		"DoubleLongLeftArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DoubleLongLeftRightArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DoubleLongRightArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DoubleUpArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		FALSE /* TRUE */
	},
	{
		"DoubleUpDownArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		FALSE /* TRUE */
	},
	{
		"DownArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		FALSE /* TRUE */
	},
	{
		"DownArrowBar", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		FALSE /* TRUE */
	},
	{
		"DownArrowUpArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		FALSE /* TRUE */
	},
	{
		"DownTeeArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftDownTeeVector", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftDownVector", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftDownVectorBar", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftUpDownVector", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftUpTeeVector", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftUpVector", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftUpVectorBar", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LongLeftArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LongLeftRightArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LongRightArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"ReverseUpEquilibrium", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"RightDownTeeVector", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"RightDownVector", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"RightDownVectorBar", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"RightUpDownVector", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"RightUpTeeVector", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"RightUpVector", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"RightUpVectorBar", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"ShortDownArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		FALSE /* TRUE */
	},
	{
		"ShortUpArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		FALSE /* TRUE */
	},
	{
		"UpArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		FALSE /* TRUE */
	},
	{
		"UpArrowBar", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		FALSE /* TRUE */
	},
	{
		"UpArrowDownArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		FALSE /* TRUE */
	},
	{
		"UpDownArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		FALSE /* TRUE */
	},
	{
		"UpEquilibrium", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"UpTeeArrow", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"^", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"^", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"<>", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"'", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"!", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"!!", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"∼", LSM_MATHML_FORM_INFIX,		/* Tilde - 0x223C */
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
#if 0
	{
		"∼", LSM_MATHML_FORM_POSTFIX,		/* Tilde - 0x223C */
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"~", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
#endif
	{
		"~", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"@", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"--", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"--", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"++", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"++", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"ApplyFunction", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"?", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"_", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_VERY_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Breve", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Cedilla", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DiacriticalGrave", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DiacriticalDot", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DiacriticalDoubleAcute", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftArrow", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftRightArrow", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftRightVector", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"LeftVector", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DiacriticalAcute", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"RightArrow", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"RightVector", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DiacriticalTilde", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DoubleDot", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"DownBreve", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Hacek", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"Hat", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"OverBar", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"OverBrace", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"OverBracket", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"OverParenthesis", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"TripleDot", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"UnderBar", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"UnderBrace", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"UnderBracket", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"UnderParenthesis", LSM_MATHML_FORM_POSTFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		TRUE, FALSE, TRUE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	/* lsmmathml additions */
	{
		"Int", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE /*TRUE*/, FALSE, FALSE, TRUE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"iiint", LSM_MATHML_FORM_PREFIX,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		{ LSM_MATHML_SPACE_NAME_ERROR, { 0.0, LSM_MATHML_UNIT_EM}},
		FALSE /*TRUE*/, FALSE, FALSE, TRUE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"vee", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"wedge", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"cup", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, TRUE /* FALSE */, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	},
	{
		"cap", LSM_MATHML_FORM_INFIX,
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		{ LSM_MATHML_SPACE_NAME_THIN, { 0.0, 0}},
		FALSE, FALSE, FALSE, FALSE, TRUE /* FALSE */, FALSE,
		{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
		{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
		TRUE
	}
};

static GHashTable *
_get_operator_dictionary (void)
{
	static GHashTable *operator_hash = NULL;
	const char *utf8, *prefix;
	char *key;
	int i;

	if (operator_hash != NULL)
		return operator_hash;

	operator_hash = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);

	for (i = 0; i < G_N_ELEMENTS (lsm_mathml_operator_entries); i++) {
		utf8 = lsm_dom_get_entity (lsm_mathml_operator_entries[i].name);

		switch (lsm_mathml_operator_entries[i].form) {
			case LSM_MATHML_FORM_PREFIX:
				prefix = "E*";
				break;
			case LSM_MATHML_FORM_POSTFIX:
				prefix = "O*";
				break;
			case LSM_MATHML_FORM_INFIX:
			default:
				prefix = "I*";
				break;
		}
		key = g_strconcat (prefix, utf8, NULL);

		if (g_hash_table_lookup (operator_hash, key) == NULL)
			g_hash_table_insert (operator_hash, key,
					     (void *) &lsm_mathml_operator_entries[i]);
	}

	return operator_hash;
}

static const LsmMathmlOperatorDictionaryEntry lsm_mathml_operator_dictionary_default_entry =
{
	"Default", LSM_MATHML_FORM_INFIX,
	{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
	{ LSM_MATHML_SPACE_NAME_THICK, { 0.0, 0}},
	FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
	{ LSM_MATHML_SPACE_NAME_ERROR, { 1, LSM_MATHML_UNIT_PX}},
	{ LSM_MATHML_SPACE_NAME_INFINITY, {0.0, 0}},
	TRUE
};

const LsmMathmlOperatorDictionaryEntry *
lsm_mathml_operator_dictionary_lookup (const char *utf8, LsmMathmlForm form)
{
	const LsmMathmlOperatorDictionaryEntry *entry;
	const char *prefix;
	char *key;

	switch (form) {
		case LSM_MATHML_FORM_PREFIX:
			prefix = "E*";
			break;
		case LSM_MATHML_FORM_POSTFIX:
			prefix = "O*";
			break;
		case LSM_MATHML_FORM_INFIX:
		default:
			prefix = "I*";
			break;
	}

	key = g_strconcat (prefix, utf8, NULL);
	entry = g_hash_table_lookup (_get_operator_dictionary (), key);
	g_free (key);

	if (entry != NULL)
		return entry;

	if (form != LSM_MATHML_FORM_INFIX) {
		key = g_strconcat ("I*", utf8, NULL);
		entry = g_hash_table_lookup (_get_operator_dictionary (), key);
		g_free (key);

		if (entry != NULL) {
			lsm_debug_update ("[OperatorDictionary::lookup] Return infix entry instead of %s for %s",
					  prefix, utf8);
			return entry;
		}
	}

	if (form != LSM_MATHML_FORM_POSTFIX) {
		key = g_strconcat ("O*", utf8, NULL);
		entry = g_hash_table_lookup (_get_operator_dictionary (), key);
		g_free (key);

		if (entry != NULL) {
			lsm_debug_update ("[OperatorDictionary::lookup] Return postfix entry instead of %s for %s",
					  prefix, utf8);
			return entry;
		}
	}

	if (form != LSM_MATHML_FORM_PREFIX) {
		key = g_strconcat ("E*", utf8, NULL);
		entry = g_hash_table_lookup (_get_operator_dictionary (), key);
		g_free (key);

		if (entry != NULL) {
			lsm_debug_update ("[OperatorDictionary::lookup] Return prefix entry instead of %s for %s",
					  prefix, utf8);
			return entry;
		}
	}

	lsm_debug_update ("[OperatorDictionary::lookup] Return default entry instead of %s for %s",
			  prefix, utf8);

	return &lsm_mathml_operator_dictionary_default_entry;
}
