/* -*- mode: C; c-file-style: "gnu" -*- */
/*
 * Copyright (C) 2003 Richard Hult <richard@imendio.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __SONG_DB_H__
#define __SONG_DB_H__

#include <glib-object.h>
#include <gdbm.h>
#include "song.h"

#define SONG_DB_VERSION 1

#define TYPE_SONG_DB            (song_db_get_type ())
#define SONG_DB(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SONG_DB, SongDB))
#define SONG_DB_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SONG_DB, SongDBClass))
#define IS_SONG_DB(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SONG_DB))
#define IS_SONG_DB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SONG_DB))
#define SONG_DB_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SONG_DB, SongDBClass))

typedef struct _SongDB      SongDB;
typedef struct _SongDBClass SongDBClass;


typedef gboolean (*SongDBAddProgressFunc) (SongDB *, const char *, gpointer);

struct _SongDB
{
  GObject    parent;
  GDBM_FILE  dbf;
  GList     *songs;
  gboolean   readonly;
};

struct _SongDBClass
{
  GObjectClass parent_class;
};

GType        song_db_get_type          (void);
SongDB *     song_db_new               (const gchar           *filename,
					gboolean               readonly);
void         song_db_read_songs        (SongDB                *db);
void         song_db_add_dir           (SongDB                *db,
					const char            *path,
					SongDBAddProgressFunc  progress_callback,
					gpointer               user_data);
void         song_db_add_file          (SongDB                *db,
					const char            *filename);
void         song_db_update_song       (SongDB                *db,
					Song                  *song);
gboolean     song_db_remove_song       (SongDB                *db,
					Song                  *song);
void         song_db_dump              (SongDB                *db);
int          song_db_get_version       (SongDB                *db);
void         song_db_set_version       (SongDB                *db,
					int                    version);
void         song_db_rebuild           (SongDB                *db);


#endif /* __SONG_DB_H__ */
