/* -*- mode: C; c-file-style: "gnu" -*- */
/*
 * Copyright (C) 2003 Richard Hult <richard@imendio.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __DBUS_H__
#define __DBUS_H__

#include <dbus/dbus-glib.h>

#define JAMBOREE_DBUS_SERVICE "org.imendio.jamboree"

#define JAMBOREE_DBUS_PLAYER_INTERFACE "org.imendio.jamboree.Player"
#define JAMBOREE_DBUS_PLAYER_OBJECT "/org/imendio/jamboree/Player"
#define JAMBOREE_DBUS_PLAYER_PLAY "Play"
#define JAMBOREE_DBUS_PLAYER_STOP "Stop"
#define JAMBOREE_DBUS_PLAYER_PREV "Prev"
#define JAMBOREE_DBUS_PLAYER_NEXT "Next"
#define JAMBOREE_DBUS_PLAYER_PUSH_MUTE "PushMute"
#define JAMBOREE_DBUS_PLAYER_POP_MUTE "PopMute"
#define JAMBOREE_DBUS_PLAYER_GET_CURRENT_SONG "get_CurrentSong"
#define JAMBOREE_DBUS_PLAYER_QUIT "Quit"

void         dbus_init_handler               (void);
gboolean     dbus_init_service               (void);
gboolean     dbus_send_remote_cmd            (const gchar *msg,
					      gboolean    *invalid_arg);
DBusMessage *dbus_send_remote_cmd_with_reply (const gchar *msg);
Song        *dbus_message_to_song            (DBusMessage *message);

#endif /* __DBUS_H__ */
