/* -*- mode: C; c-file-style: "gnu" -*- */
/*
 * Copyright (C) 2003 Richard Hult <richard@imendio.com>
 * Copyright (C) 2003 Anders Carlsson <andersca@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include "song.h"

void
song_free (Song *song)
{
  g_free (song->filename);
  g_free (song->title);
  g_free (song->album);
  g_free (song->artist);

  g_free (song->title_key);
  g_free (song->artist_key);
  g_free (song->album_key);

  g_free (song);
}

static char *
collate_key (const char *p)
{
  GString *string;
  gunichar c;
  gboolean is_space = FALSE, last_was_space = FALSE;
  char *ret;

  string = g_string_new (NULL);

  if (g_ascii_strncasecmp (p, "the", 3) == 0)
    p += 3;
  
  while (*p)
    {
      c = g_utf8_get_char (p);
      if (g_unichar_isspace (c))
	{
	  if (last_was_space)
	    {
	      p = g_utf8_next_char (p);
	      continue;
	    }
	  
	  is_space = TRUE;
	}
      
      if (c == '(' || c == ')' || c == '"' || c == '\'' || c == '-' || c == '.' || c == '[' || c == ']' || c == '{' || c == '}')
	{
	  if (!last_was_space)
	    g_string_append_c (string, ' ');

	  last_was_space = TRUE;
	}
      else
	{
	  g_string_append_unichar (string, c);
	  last_was_space = is_space;
	}
      
      p = g_utf8_next_char (p);
    }

  ret = g_utf8_collate_key (string->str, -1);
  g_string_free (string, TRUE);
  
  return ret;
}

void
_song_calculate_collate_keys (Song *song)
{
  song->title_key = collate_key (song->title);
  song->artist_key = collate_key (song->artist);
  song->album_key = collate_key (song->album);
}

void
_song_dump (Song *song)
{
  g_print ("-------------------------------------\n");
  g_print ("Filename: %s\n", song->filename);
  g_print ("Title   : %s\n", song->title);
  g_print ("Album   : %s\n", song->album);
  g_print ("Artist  : %s\n", song->artist);
  g_print ("Genre   : %d\n", song->genre);
  g_print ("Year    : %d\n", song->year);
}
  
