/* -*- mode: C; c-file-style: "gnu" -*- */
/*
 * Copyright (C) 2003 Richard Hult <richard@imendio.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __SONG_LIST_MODEL_H__
#define __SONG_LIST_MODEL_H__

#include <gtk/gtktreemodel.h>
#include "song.h"
#include "gsequence.h"

#define TYPE_SONG_LIST_MODEL		 (song_list_model_get_type ())
#define SONG_LIST_MODEL(obj)		 (GTK_CHECK_CAST ((obj), TYPE_SONG_LIST_MODEL, SongListModel))
#define SONG_LIST_MODEL_CLASS(klass)	 (GTK_CHECK_CLASS_CAST ((klass), TYPE_SONG_LIST_MODEL, SongListModelClass))
#define IS_SONG_LIST_MODEL(obj)	         (GTK_CHECK_TYPE ((obj), TYPE_SONG_LIST_MODEL))
#define IS_SONG_LIST_MODEL_CLASS(klass)  (GTK_CHECK_CLASS_TYPE ((obj), TYPE_SONG_LIST_MODEL))
#define SONG_LIST_MODEL_GET_CLASS(obj)   (GTK_CHECK_GET_CLASS ((obj), TYPE_SONG_LIST_MODEL, SongListModelClass))

typedef struct _SongListModel SongListModel;
typedef struct _SongListModelClass SongListModelClass;

typedef enum {
  SONG_SORT_ID_DEFAULT = 0,
  SONG_SORT_ID_TITLE,
  SONG_SORT_ID_ARTIST,
  SONG_SORT_ID_TIME,
  SONG_SORT_ID_ALBUM,
  SONG_SORT_ID_GENRE,
  SONG_SORT_ID_YEAR,
  SONG_SORT_ID_RATING,
  SONG_SORT_ID_TRACK_NUMBER,
  SONG_SORT_ID_LAST_PLAYED,
  SONG_SORT_ID_PLAY_COUNT,
  SONG_SORT_ID_NO_COLUMNS
} SongSortId;

struct _SongListModel {
  GObject      parent_instance;
  
  int          stamp;

  SongSortId   sort_id;
  GtkSortType  sort_type;

  gboolean     shuffle;

  int         *indices;
  int          current_index;
  
  GSequence   *songs;
  GHashTable  *reverse_map;
};

struct _SongListModelClass {
  GObjectClass parent_class;
};


GType         song_list_model_get_type      (void);
GtkTreeModel *song_list_model_new           (void);
gboolean      song_list_model_add           (SongListModel *model,
					     Song          *song);
void          song_list_model_remove        (SongListModel *model,
					     Song          *song);
void          song_list_model_clear         (SongListModel *model);
void          song_list_model_set_sorting   (SongListModel *model,
					     SongSortId     id,
					     GtkSortType    type);
gboolean      song_list_model_song_get_iter (SongListModel *model,
					     Song          *song,
					     GtkTreeIter   *iter);
Song *        song_list_model_get_song      (SongListModel *model,
					     GtkTreeIter   *iter);
GList *       song_list_model_get_songs     (SongListModel *model);
void          song_list_model_remove_delta  (SongListModel *model,
					     GList         *songs);
Song *        song_list_model_get_current   (SongListModel *model);
gboolean      song_list_model_set_current   (SongListModel *model,
					     Song          *song);
Song *        song_list_model_next          (SongListModel *model);
Song *        song_list_model_prev          (SongListModel *model);
Song *        song_list_model_first         (SongListModel *model);

void          song_list_model_set_shuffle   (SongListModel *model,
					     gboolean       shuffle);

gboolean      song_list_model_has_next      (SongListModel *model);
gboolean      song_list_model_has_prev      (SongListModel *model);

#endif /* __SONG_LIST_MODEL_H__ */

