/* Hipo - iPod management tool
 *
 * Pedro Villavicencio Garrido <pvillavi@gnome.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * (C) Copyright 2006-2007 Pedro Villavicencio Garrido <pvillavi@gnome.org>.
 */


using System;
using System.IO;
using System.Threading;
using TagLib;
using IPod;
using Gtk;
using Gnome.Vfs;
using Mono.Unix;

namespace Hipo
{
	public class TracksView
	{
		private Gtk.ListStore store;
		
		public enum Column {
			Artist,
			Album,
			Title,
			Genre,
			Id
		}
		
		public TracksView ()
		{
			store = new Gtk.ListStore (typeof (string), typeof (string),
						   typeof (string), typeof (string),
						   typeof (long));
		}

		public Gtk.ListStore GetModel ()
		{
			return this.store;
		}
		
		public void AddTrackToStore (Track track)
		{
			Gtk.Application.Invoke (delegate {
					store.AppendValues (track.Artist, track.Album,
							    track.Title, track.Genre,
							    track.Id);
				});
		}
		
		public void UpdateStore (Track track, TreeIter iter)
		{
			store.SetValue (iter, (int)Column.Artist, track.Artist);
			store.SetValue (iter, (int)Column.Album, track.Album);
			store.SetValue (iter, (int)Column.Title, track.Title);
			store.SetValue (iter, (int)Column.Genre, track.Genre);
		}
		
		public bool AddTrack (TrackDatabase db, string path)
		{
			string ext = Path.GetExtension (path);

			if ((ext.ToLower () == ".mp3") || (ext.ToLower () == ".mp4") ||
			    (ext.ToLower () == ".m4a")) {
				
				
				TagLib.File file = TagLib.File.Create (path);

				Track track = db.CreateTrack ();
				
				if ((file.Tag.FirstArtist == null) || (file.Tag.FirstArtist == String.Empty))
					track.Artist = "Unknown";
				else
					track.Artist = file.Tag.FirstArtist;
				
				if ((file.Tag.Title == null) || (file.Tag.Title == String.Empty))
					track.Title = "Unknown";
				else
					track.Title = file.Tag.Title;
				
				if ((file.Tag.Album == null) || (file.Tag.Album == String.Empty))
					track.Album = "Unknown";
				else
					track.Album = file.Tag.Album;
				
				if ((file.Tag.FirstGenre == null) || (file.Tag.FirstGenre == String.Empty))
					track.Genre = "Unknown";
				else
					track.Genre = file.Tag.FirstGenre;
				
				track.FileName = path;
				track.Duration = file.Properties.Duration;
				track.TrackNumber = (int) file.Tag.Track;
				
				AddTrackToStore (track);
				
				return true;
			} else {
				return false;
			}
		}

		public bool AddFolder (TrackDatabase db, string[] dirs)
		{
			// returns true if at least one track has been added
			bool trackAdded = false;
			
			foreach (string path in dirs)
			{
				if (path == null)
					return false;

				System.Uri uri = new System.Uri (path);

				UnixDirectoryInfo info = new UnixDirectoryInfo (uri.LocalPath);
				foreach (UnixFileSystemInfo file in info.GetFileSystemEntries ())
				{
					// |= gives true as soon as one of the arguments is true
					if (!file.IsDirectory) {
						trackAdded |= AddTrack (db, file.FullName);
					} else {
						string[] tmp = { file.FullName };
						trackAdded |= AddFolder (db, tmp);
					}
				}
			}

			return trackAdded;
		}

		public bool RemoveTracks (TrackDatabase db, long tracksId)
		{
			Track track = GetTrackbyId (db, tracksId);

			if (track == null)
				return false;
			
			db.RemoveTrack (track);
			
			return false;
		}

		public void RemoveTracks (Gtk.TreeIter iter)
		{
			this.store.Remove (ref iter);
                }


		public Track GetTrackbyId (TrackDatabase db, long trackId)
		{
			 foreach (Track track in db.Tracks)
			 {
				 if (track.Id == trackId)
					 return track;
			 }

			 return null;
		}

		public void Clear ()
		{
			this.store.Clear ();
		}
	}
}
