/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* gturing.h - a Turing machine simulator.
 * Copyright (C) 1998 The Free Software Foundation
 * Copyright (C) 2001-2002 German Poo-Caaman~o
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/* External functions from turing_table_editor.h */
extern void turing_table_editor_set_model (GtkTreeView * treeview_editor, turing * tm);
extern GtkWidget * turing_table_editor_new (GtkTreeView ** tree, turing * tm);
static GnomeUIInfo helper_toolbar[];
static GnomeUIInfo helper_action_menu[];

/* Internal functions and callbacks */

turing *tm;

void power_do (void);
void save_call (GtkWidget * w, gpointer data);
void prompt (char *title, char *msg, GtkSignalFunc callback, char *def);
void open_call (GtkWidget * w, gpointer data);
void tape_call (GtkWidget * w, gpointer data);
void view_comment_call (GtkWidget * w, gpointer data);
void exit_call (GtkWidget * w, gpointer data);
void playspeed_call (GtkWidget * w, gpointer data);
void help_call (GtkWidget * w, gpointer data);
void about_call (GtkWidget * w, gpointer data);

void set_save_sens (gboolean saves);
void set_toolbar_sens (gboolean powers, gboolean stops, gboolean plays, gboolean steps);
void set_tape (char *str);
void view_comment (void);

void set_states_fname (char *str);
void states_fname_examples_callback (GtkWidget * ok_button, gpointer data);
void states_fname_callback (GtkWidget * ok_button, gpointer data);

void tape_string_callback (GtkWidget * ok_button, gpointer data);
void speed_callback (gpointer data);

void cancel_callback (GtkWidget * widget, gpointer data);

int next_state (turing * t);

gint do_play (gpointer data);
void play_callback (GtkWidget * play_button, gpointer data);
void step_callback (GtkWidget * step_buttton, gpointer data);
void stop_callback (GtkWidget * stop_button, gpointer data);



void create_machine (void);
void init_interface (int argc, char *argv[]);
void init_globals (gchar *filename);
