/*
 *  Copyright (C) 1999-2001 Bruno Pires Marinho
 *  Copyright (C) 2000-2001 Matthew Tuck
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <gnome.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include "gtm.h"
#include "file-data.h"
#include "download-dirs.h"
#include "dialog-common-elements.h"

static GtkTargetEntry private_target_table[] = {
    { "text/uri-list", 0, 0 },
    { "text/plain", 0, 0 },
    { "x-url/http", 0, 0 },
    { "x-url/ftp", 0, 0 },
    { "_NETSCAPE_URL", 0, 0 }
};

void
add_download_policy_widget (GtkWidget *dlg, DlPolicyWidgets *widgets,
			    gchar *initial_download_dir,
                            GtkSignalFunc match_handler, void *data)
{
    GtkWidget *hbox, *label, *file_entry, *match_button;

    /* Download directory */
    label = gtk_label_new (_ ("Download dir:"));
    gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dlg)->vbox), 
                        label, FALSE, FALSE, 0);
    file_entry = gnome_file_entry_new ("NewDownloadDir", 
                                       _ ("Download Dir"));
    widgets->download_dir = 
	gnome_file_entry_gtk_entry (GNOME_FILE_ENTRY (file_entry));
    gnome_file_entry_set_directory (GNOME_FILE_ENTRY (file_entry), 1);
    gtk_entry_set_text (GTK_ENTRY (widgets->download_dir), 
                        initial_download_dir);
    gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dlg)->vbox),
                        file_entry, FALSE, FALSE, 0);

    if (match_handler != NULL) {
        /* match button, only show if user has defined some rules */
	if (download_dirs_get_total_dirs() > 0) {
	    match_button = gtk_button_new_with_label 
		(_ ("Suggest directory by pattern matching"));
	    hbox = gtk_hbox_new(FALSE, FALSE);
	    gtk_box_pack_start (GTK_BOX (hbox), match_button,
				TRUE, FALSE, 0);
	    gtk_box_pack_start
		(GTK_BOX (GNOME_DIALOG (dlg)->vbox),
		 hbox, FALSE, FALSE, 0);
	    gtk_signal_connect (GTK_OBJECT (match_button), 
				"clicked", 
				GTK_SIGNAL_FUNC (match_handler),
				(gpointer) data);
	}
    }

    /* Download policy checkboxes */
    hbox = gtk_hbox_new (FALSE, FALSE);

    widgets->use_proxy = 
	gtk_check_button_new_with_label (_ ("Use proxy"));
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widgets->use_proxy),
                                  TRUE);
    gtk_box_pack_start (GTK_BOX (hbox), widgets->use_proxy,
                        FALSE, FALSE, 0);

    widgets->use_auto_dl =
        gtk_check_button_new_with_label (_ ("Use auto download"));
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widgets->use_auto_dl),
                                  TRUE);
    gtk_box_pack_start (GTK_BOX (hbox), widgets->use_auto_dl,
                        FALSE, FALSE, 0);

    gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dlg)->vbox),
                        hbox, FALSE, FALSE, 0);

}

void
get_dl_policy_data (DlPolicyData *data, DlPolicyWidgets *widgets)
{
    /* Get download directory data */
    data->download_dir =
        gtk_entry_get_text (GTK_ENTRY (widgets->download_dir));

    /* Get the use proxy option data */
    data->use_proxy =
        gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (
            widgets->use_proxy));

    /* Get the use auto download option data */
    data->use_auto_dl = 
        gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (
	    widgets->use_auto_dl));
}

FileData *
dl_policy_file_data_create (gchar *url, DlPolicyData *data)
{
    return file_data_create (url, data->download_dir, data->use_proxy,
                             data->use_auto_dl);
}

gchar *
download_dir_canonical_dup (gchar *download_dir)
{
    gint length;

    length = strlen (download_dir);
    if (length != 0 && download_dir[length - 1] != '/')
        return g_strconcat (download_dir, "/", NULL);
    else
        return g_strdup (download_dir);
}

/* If download dialog changes default download dir update the def dl dir */
void
change_default_download_dir (gchar *download_dir)
{
    if (gtm_pref.addnew_changes_def_dl_dir) {
        g_free (gtm_pref.def_download_dir);
	gtm_pref.def_download_dir =
            download_dir_canonical_dup (download_dir);
    }
}

/* Get the filename from a URL */
gchar *
get_filename (gchar *url)
{
    gchar *filename;

    filename = &url[strlen (url)];
    while (*filename != '/' && filename != url)
	filename--;
    filename++;

    return filename;
}

GtkTargetEntry *
target_table (void)
{
    return private_target_table;
}

gint
target_table_count (void)
{
    return sizeof(private_target_table) / sizeof (private_target_table[0]);
}

void
configure_ok_cancel_dialog (GnomeDialog *dlg, 
                            GtkSignalFunc ok_callback,
                            GtkSignalFunc cancel_callback,
                            gpointer data)
{
    gnome_dialog_set_close (dlg, FALSE);
    gnome_dialog_set_default (dlg, GNOME_OK);

    gnome_dialog_button_connect (dlg, GNOME_OK, ok_callback, data);
    gnome_dialog_button_connect (dlg, GNOME_CANCEL, cancel_callback, data);
}

void
dir_suggested_check (gchar *dir, DlPolicyWidgets *dl_policy, GtkWidget *dlg)
{
    GtkWidget *error;

    if (dir == NULL) {
        error = gnome_error_dialog_parented (_ ("No directory matched."),
                                             GTK_WINDOW (dlg));
        gnome_dialog_run_and_close (GNOME_DIALOG (error));
    } else {
        gtk_entry_set_text (GTK_ENTRY (dl_policy->download_dir), dir);
    }
}

gboolean
download_not_dir_check (gchar *url, GtkWidget *dlg)
{
    GtkWidget *error;
    gchar *filename = get_filename (url);

    /* TODO: If filename == NULL instead of reminding the user that it is not
     * possible yet to do multiple downloads, when the group stuff is 
     * implemented this should enter a new dialog like dialog-multiple and 
     * ask there for download depth and get the available files to download. 
     * Then the user can remove what he doesn't want. */
    if (strlen (filename) == 0) {
        error = gnome_error_dialog_parented (_ ("Multiple download not "
                                             "implemented yet"),
                                             GTK_WINDOW (dlg));
        gnome_dialog_run_and_close (GNOME_DIALOG (error));
        return FALSE;
    } else {
	return TRUE;
    }
}
