// Generated by gmmproc 2.49.2 -- DO NOT MODIFY!
#ifndef _GTKSOURCEVIEWMM_STYLESCHEME_H
#define _GTKSOURCEVIEWMM_STYLESCHEME_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* stylescheme.h
 *
 * Copyright (C) 2004-2005 Jae Jang
 * Copyright (C) 2005-2006 Rob Page
 * Copyright (C) 2006 Dodji Seketeli
 * Copyright (C) 2009, 2010, 2011 Krzesimir Nowak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <vector>

#include <gtksourceview/gtksource.h>

#include <glibmm/object.h>

#include <gtksourceviewmm/style.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkSourceStyleScheme = struct _GtkSourceStyleScheme;
using GtkSourceStyleSchemeClass = struct _GtkSourceStyleSchemeClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gsv
{ class StyleScheme_Class; } // namespace Gsv
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gsv
{


/** Object controlling appearance of View.
 *
 * StyleScheme contains all the text styles to be used in View and
 * Buffer. For instance, it contains text styles for syntax highlighting,
 * it may contain foreground and background color for non-highlighted text,
 * color for the line numbers, etc.
 *
 * Style schemes are stored in XML files. The format of a scheme file is
 * the documented in the C library gtksourceview documentation.
 *
 * @newin{2,2}
 */

class StyleScheme : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = StyleScheme;
  using CppClassType = StyleScheme_Class;
  using BaseObjectType = GtkSourceStyleScheme;
  using BaseClassType = GtkSourceStyleSchemeClass;

  // noncopyable
  StyleScheme(const StyleScheme&) = delete;
  StyleScheme& operator=(const StyleScheme&) = delete;

private:  friend class StyleScheme_Class;
  static CppClassType stylescheme_class_;

protected:
  explicit StyleScheme(const Glib::ConstructParams& construct_params);
  explicit StyleScheme(GtkSourceStyleScheme* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  StyleScheme(StyleScheme&& src) noexcept;
  StyleScheme& operator=(StyleScheme&& src) noexcept;

  ~StyleScheme() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkSourceStyleScheme*       gobj()       { return reinterpret_cast<GtkSourceStyleScheme*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkSourceStyleScheme* gobj() const { return reinterpret_cast<GtkSourceStyleScheme*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkSourceStyleScheme* gobj_copy();

private:


public:

  
  /** Gets scheme id.
   *
   * @return Scheme id.
   *
   * @newin{2,2}
   */
  Glib::ustring get_id() const;

  
  /** Gets scheme name.
   *
   * @return Scheme name.
   *
   * @newin{2,2}
   */
  Glib::ustring get_name() const;

  
  /** Gets scheme description.
   *
   * @return Scheme description.
   *
   * @newin{2,2}
   */
  Glib::ustring get_description() const;

 
  /** Gets scheme authors.
   *
   * @return Array with scheme authors.
   *
   * @newin{2,2}
   */
  std::vector<Glib::ustring> get_authors() const;

  
  /** Gets scheme filename.
   *
   * @return Scheme file name if the scheme was created parsing a style scheme
   * file or empty string in the other cases.
   *
   * @newin{2,2}
   */
  std::string get_filename() const;

  
  /** Gets style corresponding to @a style_id in scheme.
   *
   * @param style_id Id of the style to retrieve.
   *
   * @return Style which corresponds to @a style_id in the scheme,
   * or empty Glib::RefPtr when no style with this name found.
   *
   * @newin{2,2}
   */
  Glib::RefPtr<Style> get_style(const Glib::ustring& style_id);

  
  /** Gets style corresponding to @a style_id in scheme.
   *
   * @param style_id Id of the style to retrieve.
   *
   * @return Style which corresponds to @a style_id in the scheme,
   * or empty Glib::RefPtr when no style with this name found.
   *
   * @newin{2,2}
   */
  Glib::RefPtr<const Style> get_style(const Glib::ustring& style_id) const;

  /** Style scheme id.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< std::string > property_id() const;


  /** Style scheme name.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_name() const;


  /** Style scheme description.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_description() const;


  /** Style scheme filename.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< std::string > property_filename() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};//end class StyleScheme

}//end namespace Gsv


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gsv::StyleScheme
   */
  Glib::RefPtr<Gsv::StyleScheme> wrap(GtkSourceStyleScheme* object, bool take_copy = false);
}


#endif /* _GTKSOURCEVIEWMM_STYLESCHEME_H */

