// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKSOURCEVIEWMM_SOURCEGUTTERRENDERER_H
#define _GTKSOURCEVIEWMM_SOURCEGUTTERRENDERER_H


#include <glibmm.h>

/* sourcegutterrenderer.h
 *
 * Copyright (C) 2010 Krzesimir Nowak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/// \file
/// \brief SourceGutterRenderer class

#include <gtkmm/object.h>
#include <gtkmm/tooltip.h>
#include <gtksourceviewmm/sourceview.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkSourceGutterRenderer GtkSourceGutterRenderer;
typedef struct _GtkSourceGutterRendererClass GtkSourceGutterRendererClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gsv
{ class SourceGutterRenderer_Class; } // namespace Gsv
namespace Gsv
{

/** @addtogroup gtksourceviewmmEnums gtksourceviewmm Enums and Flags */

/**
 * @ingroup gtksourceviewmmEnums
 * @par Bitwise operators:
 * <tt>%SourceGutterRendererState operator|(SourceGutterRendererState, SourceGutterRendererState)</tt><br>
 * <tt>%SourceGutterRendererState operator&(SourceGutterRendererState, SourceGutterRendererState)</tt><br>
 * <tt>%SourceGutterRendererState operator^(SourceGutterRendererState, SourceGutterRendererState)</tt><br>
 * <tt>%SourceGutterRendererState operator~(SourceGutterRendererState)</tt><br>
 * <tt>%SourceGutterRendererState& operator|=(SourceGutterRendererState&, SourceGutterRendererState)</tt><br>
 * <tt>%SourceGutterRendererState& operator&=(SourceGutterRendererState&, SourceGutterRendererState)</tt><br>
 * <tt>%SourceGutterRendererState& operator^=(SourceGutterRendererState&, SourceGutterRendererState)</tt><br>
 */
enum SourceGutterRendererState
{
  SOURCE_GUTTER_RENDERER_STATE_NORMAL = 0x0,
  SOURCE_GUTTER_RENDERER_STATE_CURSOR = 1 << 0,
  SOURCE_GUTTER_RENDERER_STATE_PRELIT = 1 << 1,
  SOURCE_GUTTER_RENDERER_STATE_SELECTED = 1 << 2
};

/** @ingroup gtksourceviewmmEnums */
inline SourceGutterRendererState operator|(SourceGutterRendererState lhs, SourceGutterRendererState rhs)
  { return static_cast<SourceGutterRendererState>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtksourceviewmmEnums */
inline SourceGutterRendererState operator&(SourceGutterRendererState lhs, SourceGutterRendererState rhs)
  { return static_cast<SourceGutterRendererState>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtksourceviewmmEnums */
inline SourceGutterRendererState operator^(SourceGutterRendererState lhs, SourceGutterRendererState rhs)
  { return static_cast<SourceGutterRendererState>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtksourceviewmmEnums */
inline SourceGutterRendererState operator~(SourceGutterRendererState flags)
  { return static_cast<SourceGutterRendererState>(~static_cast<unsigned>(flags)); }

/** @ingroup gtksourceviewmmEnums */
inline SourceGutterRendererState& operator|=(SourceGutterRendererState& lhs, SourceGutterRendererState rhs)
  { return (lhs = static_cast<SourceGutterRendererState>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtksourceviewmmEnums */
inline SourceGutterRendererState& operator&=(SourceGutterRendererState& lhs, SourceGutterRendererState rhs)
  { return (lhs = static_cast<SourceGutterRendererState>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtksourceviewmmEnums */
inline SourceGutterRendererState& operator^=(SourceGutterRendererState& lhs, SourceGutterRendererState rhs)
  { return (lhs = static_cast<SourceGutterRendererState>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gsv


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gsv::SourceGutterRendererState> : public Glib::Value_Flags<Gsv::SourceGutterRendererState>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gsv
{


/**
 * @ingroup gtksourceviewmmEnums
 */
enum SourceGutterRendererAlignmentMode
{
  SOURCE_GUTTER_RENDERER_ALIGNMENT_MODE_CELL,
  SOURCE_GUTTER_RENDERER_ALIGNMENT_MODE_FIRST,
  SOURCE_GUTTER_RENDERER_ALIGNMENT_MODE_LAST
};

} // namespace Gsv


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gsv::SourceGutterRendererAlignmentMode> : public Glib::Value_Enum<Gsv::SourceGutterRendererAlignmentMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gsv
{


// TODO: write docs.

class SourceGutterRenderer : public Gtk::Object
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef SourceGutterRenderer CppObjectType;
  typedef SourceGutterRenderer_Class CppClassType;
  typedef GtkSourceGutterRenderer BaseObjectType;
  typedef GtkSourceGutterRendererClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~SourceGutterRenderer();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class SourceGutterRenderer_Class;
  static CppClassType sourcegutterrenderer_class_;

  // noncopyable
  SourceGutterRenderer(const SourceGutterRenderer&);
  SourceGutterRenderer& operator=(const SourceGutterRenderer&);

protected:
  explicit SourceGutterRenderer(const Glib::ConstructParams& construct_params);
  explicit SourceGutterRenderer(GtkSourceGutterRenderer* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkSourceGutterRenderer*       gobj()       { return reinterpret_cast<GtkSourceGutterRenderer*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkSourceGutterRenderer* gobj() const { return reinterpret_cast<GtkSourceGutterRenderer*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual bool on_query_tooltip(const Gtk::TextIter& iter, const Gdk::Rectangle& area, int x, int y, const Glib::RefPtr<Gtk::Tooltip>& tooltip);
  virtual void on_activate(const Gtk::TextIter& iter, const Gdk::Rectangle& area, GdkEvent* event);
  virtual void on_queue_draw();
  virtual void on_query_data(const Gtk::TextIter& start, const Gtk::TextIter& end, SourceGutterRendererState state);
  virtual bool on_query_activatable(const Gtk::TextIter& iter, const Gdk::Rectangle& area, GdkEvent* event);


private:

public:
 

  /** Called when drawing a region begins. The region to be drawn is indicated
   * by @a start and @a end. The purpose is to allow the implementation to precompute
   * some state before the ::draw method is called for each cell.
   * @param cr A #cairo_t.
   * @param background_area A Gdk::Rectangle.
   * @param cell_area A Gdk::Rectangle.
   * @param start A Gtk::TextIter.
   * @param end A Gtk::TextIter.
   */
  void begin(
                  const Cairo::RefPtr<Cairo::Context>& cr,
                  const Gdk::Rectangle& background_area,
                  const Gdk::Rectangle& cell_area,
                  Gtk::TextIter& start,
                  Gtk::TextIter& end);

  
  /** Main renderering method. Implementations should implement this method to
   * draw onto the cairo context. The @a background_area indicates total area of
   * the cell (without padding or margin) to be drawn. The @a cell_area indicates
   * the area where content can be drawn (text, images, etc).
   * 
   * The @a state argument indicates the current state of the renderer and should
   * be taken into account to properly draw the different possible states
   * (cursor, prelit, selected) if appropriate.
   * @param cr The cairo render context.
   * @param background_area A Gdk::Rectangle indicating the total area to be drawn.
   * @param cell_area A Gdk::Rectangle indicating the area to draw content.
   * @param start A Gtk::TextIter.
   * @param end A Gtk::TextIter.
   * @param state A Gtk::SourceGutterRendererState.
   */
  void draw(
                  const Cairo::RefPtr<Cairo::Context>& cr,
                  const Gdk::Rectangle& background_area,
                  const Gdk::Rectangle& cell_area,
                  Gtk::TextIter& start,
                  Gtk::TextIter& end,
                  SourceGutterRendererState);

  
  /** Called when drawing a region of lines has ended.
   */
  void end();

  
  /** Get the size of the renderer.
   * @return The size of the renderer.
   */
  int get_size() const;

  
  /** Sets the size of the renderer. A value of -1 specifies that the size
   * is to be determined dynamically.
   * @param size The size.
   */
  void set_size(int size);

  
  /** Get whether the gutter renderer is visible.
   * @return <tt>true</tt> if the renderer is visible, <tt>false</tt> otherwise.
   */
  bool get_visible() const;

  
  /** Set whether the gutter renderer is visible.
   * @param visible The visibility.
   */
  void set_visible(bool visible);

// TODO: write padding class. krnowak

  
  /** Get the x-padding and y-padding of the gutter renderer.
   * @param xpad Return location for the x-padding (can be <tt>0</tt>).
   * @param ypad Return location for the y-padding (can be <tt>0</tt>).
   */
  void get_padding(int& xpad, int& ypad) const;

  
  /** Set the padding of the gutter renderer. Both @a xpad and @a ypad can be
   * -1, which means the values will not be changed (this allows changing only
   * one of the values).
   * @param xpad The x-padding.
   * @param ypad The y-padding.
   */
  void set_padding(int xpad, int ypad);

// TODO: write alignment class. krnowak

  
  /** Get the x-alignment and y-alignment of the gutter renderer.
   * @param xalign Return location for the x-alignment (can be <tt>0</tt>).
   * @param yalign Return location for the y-alignment (can be <tt>0</tt>).
   */
  void get_alignment(float& xalign, float& yalign) const;

  
  /** Set the alignment of the gutter renderer. Both @a xalign and @a yalign can be
   * -1, which means the values will not be changed (this allows changing only
   * one of the values).
   * @param xalign The x-alignment.
   * @param yalign The y-alignment.
   */
  void set_alignment(float xalign, float yalign);

  
  /** Get the alignment mode. The alignment mode describes the manner in which the
   * renderer is aligned (see :xalign and :yalign).
   * @return A Gtk::SourceGutterRendererAlignmentMode.
   */
  SourceGutterRendererAlignmentMode get_alignment_mode() const;

  
  /** Set the alignment mode. The alignment mode describes the manner in which the
   * renderer is aligned (see :xalign and :yalign).
   * @param mode A Gtk::SourceGutterRendererAlignmentMode.
   */
  void set_alignment_mode(SourceGutterRendererAlignmentMode mode);

  
  /** Get the Gtk::TextWindowType associated with the gutter renderer.
   * @return A Gtk::TextWindowType.
   */
  Gtk::TextWindowType get_window_type() const;

 
  /** Get the view associated to the gutter renderer
   * @return A Gtk::TextView.
   */
  Gtk::TextView* get_view();

  
  /** Get the view associated to the gutter renderer
   * @return A Gtk::TextView.
   */
  const Gtk::TextView* get_view() const;

// TODO: use std::pair? krnowak

 
  /** Get the background color of the renderer.
   * @param color Return value for a Gdk::RGBA.
   * @return <tt>true</tt> if the background color is set, <tt>false</tt> otherwise.
   */
  bool get_background(Gdk::RGBA& color) const;

  bool is_background_set() const;

 
  /** Set the background color of the renderer. If @a color is set to <tt>0</tt>, the
   * renderer will not have a background color.
   * @param color A Gdk::RGBA or <tt>0</tt>.
   */
  void set_background(const Gdk::RGBA& color);

  
  /** Emits the ::queue-draw signal of the renderer. Call this from an
   * implementation to inform that the renderer has changed such that it needs
   * to redraw.
   */
  void queue_draw();

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_visible() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_visible() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The x-padding.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_xpad() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The x-padding.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_xpad() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The y-padding.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_ypad() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The y-padding.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_ypad() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The x-alignment.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<float> property_xalign() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The x-alignment.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<float> property_xalign() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The y-alignment.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<float> property_yalign() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The y-alignment.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<float> property_yalign() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The view.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gtk::TextView*> property_view() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The alignment mode.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<SourceGutterRendererAlignmentMode> property_alignment_mode() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The alignment mode.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<SourceGutterRendererAlignmentMode> property_alignment_mode() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The window type.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gtk::TextWindowType> property_window_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The size.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_size() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The size.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_size() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The background color.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Gdk::RGBA> property_background_rgba() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The background color.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gdk::RGBA> property_background_rgba() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the background color is set.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_background_set() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the background color is set.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_background_set() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  /**
   * @par Prototype:
   * <tt>bool on_my_%query_tooltip(const Gtk::TextIter& iter, const Gdk::Rectangle& area, int x, int y, const Glib::RefPtr<Gtk::Tooltip>& tooltip)</tt>
   */

  Glib::SignalProxy5< bool,const Gtk::TextIter&,const Gdk::Rectangle&,int,int,const Glib::RefPtr<Gtk::Tooltip>& > signal_query_tooltip();


  /**
   * @par Prototype:
   * <tt>void on_my_%activate(const Gtk::TextIter& iter, const Gdk::Rectangle& area, GdkEvent* event)</tt>
   */

  Glib::SignalProxy3< void,const Gtk::TextIter&,const Gdk::Rectangle&,GdkEvent* > signal_activate();


  /**
   * @par Prototype:
   * <tt>void on_my_%queue_draw()</tt>
   */

  Glib::SignalProxy0< void > signal_queue_draw();


  /**
   * @par Prototype:
   * <tt>void on_my_%query_data(const Gtk::TextIter& start, const Gtk::TextIter& end, SourceGutterRendererState state)</tt>
   */

  Glib::SignalProxy3< void,const Gtk::TextIter&,const Gtk::TextIter&,SourceGutterRendererState > signal_query_data();


  /**
   * @par Prototype:
   * <tt>bool on_my_%query_activatable(const Gtk::TextIter& iter, const Gdk::Rectangle& area, GdkEvent* event)</tt>
   */

  Glib::SignalProxy3< bool,const Gtk::TextIter&,const Gdk::Rectangle&,GdkEvent* > signal_query_activatable();


protected:
  SourceGutterRenderer();

 
    virtual void begin_vfunc(const Cairo::RefPtr<Cairo::Context>& cr, const Gdk::Rectangle& background_area, const Gdk::Rectangle& cell_area, Gtk::TextIter& start, Gtk::TextIter& end);


    virtual void draw_vfunc(const Cairo::RefPtr<Cairo::Context>& cr, const Gdk::Rectangle& background_area, const Gdk::Rectangle& cell_area, Gtk::TextIter& start, Gtk::TextIter& end, SourceGutterRendererState p6);


    virtual void end_vfunc();


    virtual void change_view_vfunc(Gtk::TextView* old_view);


    virtual void change_buffer_vfunc(const Glib::RefPtr<Gtk::TextBuffer>& old_buffer);


};

} // namespace Gsv


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gsv::SourceGutterRenderer
   */
  Gsv::SourceGutterRenderer* wrap(GtkSourceGutterRenderer* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKSOURCEVIEWMM_SOURCEGUTTERRENDERER_H */

