// Generated by gmmproc 2.74.0 -- DO NOT MODIFY!
#ifndef _GTKMM_FILEDIALOG_H
#define _GTKMM_FILEDIALOG_H

#include <gtkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2022 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glibmm/object.h>
#include <giomm/asyncresult.h>
#include <giomm/cancellable.h>
#include <giomm/listmodel.h>
#include <giomm/file.h>
#include <gtkmm/filefilter.h>
#include <gtk/gtk.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class GTKMM_API FileDialog_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{
class Window;

/** A %Gtk::FileDialog object collects the arguments that
 * are needed to present a file chooser dialog to the
 * user, such as a title for the dialog and whether it
 * should be modal.
 *
 * The dialog is shown with open(), save(), etc. These APIs follow the
 * GIO async pattern, and the result can be obtained by calling
 * the corresponding finish function, for example open_finish().
 *
 * @ingroup Dialogs
 * @newin{4,10}
 */

class GTKMM_API FileDialog : public Glib::Object
{
   
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = FileDialog;
  using CppClassType = FileDialog_Class;
  using BaseObjectType = GtkFileDialog;
  using BaseClassType = GtkFileDialogClass;

  // noncopyable
  FileDialog(const FileDialog&) = delete;
  FileDialog& operator=(const FileDialog&) = delete;

private:  friend class FileDialog_Class;
  static CppClassType filedialog_class_;

protected:
  explicit FileDialog(const Glib::ConstructParams& construct_params);
  explicit FileDialog(GtkFileDialog* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  FileDialog(FileDialog&& src) noexcept;
  FileDialog& operator=(FileDialog&& src) noexcept;

  ~FileDialog() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkFileDialog*       gobj()       { return reinterpret_cast<GtkFileDialog*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkFileDialog* gobj() const { return reinterpret_cast<GtkFileDialog*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkFileDialog* gobj_copy();

private:

     
protected:
  FileDialog();

public:
  
  static Glib::RefPtr<FileDialog> create();


  /** Returns the title that will be shown on the
   * file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The title.
   */
  Glib::ustring get_title() const;
  
  /** Sets the title that will be shown on the
   * file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @param title The new title.
   */
  void set_title(const Glib::ustring& title);
  
  /** Returns whether the file chooser dialog
   * blocks interaction with the parent window
   * while it is presented.
   * 
   * @newin{4,10}
   * 
   * @return <tt>true</tt> if the file chooser dialog is modal.
   */
  bool get_modal() const;
  
  /** Sets whether the file chooser dialog
   * blocks interaction with the parent window
   * while it is presented.
   * 
   * @newin{4,10}
   * 
   * @param modal The new value.
   */
  void set_modal(bool modal =  true);

  
  /** Gets the filters that will be offered to the user
   * in the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The filters, as
   * a `Gio::ListModel` of `Gtk::FileFilters`.
   */
  Glib::RefPtr<Gio::ListModel> get_filters();
  
  /** Gets the filters that will be offered to the user
   * in the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The filters, as
   * a `Gio::ListModel` of `Gtk::FileFilters`.
   */
  Glib::RefPtr<const Gio::ListModel> get_filters() const;
  
  /** Sets the filters that will be offered to the user
   * in the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @param filters A `Gio::ListModel` of `Gtk::FileFilters`.
   */
  void set_filters(const Glib::RefPtr<Gio::ListModel>& filters);

  
  /** Gets the filter that will be selected by default
   * in the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The current filter.
   */
  Glib::RefPtr<FileFilter> get_current_filter();
  
  /** Gets the filter that will be selected by default
   * in the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The current filter.
   */
  Glib::RefPtr<const FileFilter> get_current_filter() const;
  
  /** Sets the filters that will be selected by default
   * in the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @param filter A `Gtk::FileFilter`.
   */
  void set_current_filter(const Glib::RefPtr<FileFilter>& filter);

  
  /** Gets the shortcut folders that will be available to
   * the user in the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The shortcut
   * folders, as a `Gio::ListModel` of `Files`.
   */
  Glib::RefPtr<Gio::ListModel> get_shortcut_folders();
  
  /** Gets the shortcut folders that will be available to
   * the user in the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The shortcut
   * folders, as a `Gio::ListModel` of `Files`.
   */
  Glib::RefPtr<const Gio::ListModel> get_shortcut_folders() const;
  
  /** Sets the shortcut folders that will be available to
   * the user in the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @param shortcut_folders A `Gio::ListModel` of `Files`.
   */
  void set_shortcut_folders(const Glib::RefPtr<Gio::ListModel>& shortcut_folders);

  
  /** Gets the folder that will be set as the
   * initial folder in the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The folder.
   */
  Glib::RefPtr<Gio::File> get_current_folder();
  
  /** Gets the folder that will be set as the
   * initial folder in the file chooser dialog.
   * 
   * @newin{4,10}
   * 
   * @return The folder.
   */
  Glib::RefPtr<const Gio::File> get_current_folder() const;
  
  /** Sets the folder that will be set as the
   * initial folder in the file chooser dialog,
   * unless overridden by parameters of the async
   * call.
   * 
   * @newin{4,10}
   * 
   * @param folder A `Gio::File`.
   */
  void set_current_folder(const Glib::RefPtr<Gio::File>& folder);

  
  /** This function initiates a file selection operation by
   * presenting a file chooser dialog to the user.
   * 
   * If you pass @a current_file, the file chooser will initially be
   * opened in the parent directory of that file, otherwise, it
   * will be in the directory property_current_folder().
   * 
   * The @a slot will be called when the dialog is dismissed.
   * It should call open_finish()
   * to obtain the result.
   * 
   * @newin{4,10}
   * 
   * @param parent The parent `Gtk::Window`.
   * @param current_file The file to select initially.
   * @param cancellable A `Cancellable` to cancel the operation.
   * @param slot A callback to call when the operation is complete.
   */
  void open(Window& parent, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::File>& current_file =  {}, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {}) const;

  /// A open() convenience overload.
  void open(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::File>& current_file =  {}, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {}) const;
  
  /** Finishes the open() call and
   * returns the resulting file.
   * 
   * @newin{4,10}
   * 
   * @param result A `Gio::AsyncResult`.
   * @return The file that was selected.
   * Otherwise, <tt>nullptr</tt> is returned and @a error is set.
   * 
   * @throws Glib::Error
   */
  Glib::RefPtr<Gio::File> open_finish(const Glib::RefPtr<Gio::AsyncResult>& result) const;

  
  /** This function initiates a directory selection operation by
   * presenting a file chooser dialog to the user.
   * 
   * If you pass @a current_folder, the file chooser will initially be
   * opened in the parent directory of that folder, otherwise, it
   * will be in the directory property_current_folder().
   * 
   * The @a slot will be called when the dialog is dismissed.
   * It should call select_folder_finish()
   * to obtain the result.
   * 
   * @newin{4,10}
   * 
   * @param parent The parent `Gtk::Window`.
   * @param current_folder The folder to select initially.
   * @param cancellable A `Cancellable` to cancel the operation.
   * @param slot A callback to call when the operation is complete.
   */
  void select_folder(Window& parent, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::File>& current_folder =  {}, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {}) const;

  /// A select_folder() convenience overload.
  void select_folder(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::File>& current_folder =  {}, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {}) const;
  
  /** Finishes the select_folder() call and
   * returns the resulting file.
   * 
   * @newin{4,10}
   * 
   * @param result A `Gio::AsyncResult`.
   * @return The file that was selected.
   * Otherwise, <tt>nullptr</tt> is returned and @a error is set.
   * 
   * @throws Glib::Error
   */
  Glib::RefPtr<Gio::File> select_folder_finish(const Glib::RefPtr<Gio::AsyncResult>& result) const;

  
  /** This function initiates a file save operation by
   * presenting a file chooser dialog to the user.
   * 
   * You should pass either @a current_file if you have a file to
   * save to, or @a current_name, if you are creating a new file.
   * 
   * If you pass @a current_file, the file chooser will initially be
   * opened in the parent directory of that file, otherwise, it
   * will be in the directory property_current_folder().
   * 
   * The @a slot will be called when the dialog is dismissed.
   * It should call save_finish()
   * to obtain the result.
   * 
   * @newin{4,10}
   * 
   * @param parent The parent `Gtk::Window`.
   * @param current_file The initial file.
   * @param current_name The initial filename to offer.
   * @param cancellable A `Cancellable` to cancel the operation.
   * @param slot A callback to call when the operation is complete.
   */
  void save(Window& parent, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::File>& current_file =  {}, const std::string& current_name =  {}, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {}) const;

  /// A save() convenience overload.
  void save(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::File>& current_file =  {}, const std::string& current_name =  {}, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {}) const;
  
  /** Finishes the save() call and
   * returns the resulting file.
   * 
   * @newin{4,10}
   * 
   * @param result A `Gio::AsyncResult`.
   * @return The file that was selected.
   * Otherwise, <tt>nullptr</tt> is returned and @a error is set.
   * 
   * @throws Glib::Error
   */
  Glib::RefPtr<Gio::File> save_finish(const Glib::RefPtr<Gio::AsyncResult>& result) const;

  
  /** This function initiates a multi-file selection operation by
   * presenting a file chooser dialog to the user.
   * 
   * The file chooser will initially be opened in the directory
   * property_current_folder().
   * 
   * The @a slot will be called when the dialog is dismissed.
   * It should call open_multiple_finish()
   * to obtain the result.
   * 
   * @newin{4,10}
   * 
   * @param parent The parent `Gtk::Window`.
   * @param cancellable A `Cancellable` to cancel the operation.
   * @param slot A callback to call when the operation is complete.
   */
  void open_multiple(Window& parent, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {}) const;

  /// A open_multiple() convenience overload.
  void open_multiple(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {}) const;
  
  /** Finishes the open() call and
   * returns the resulting files in a `Gio::ListModel`.
   * 
   * @newin{4,10}
   * 
   * @param result A `Gio::AsyncResult`.
   * @return The file that was selected,
   * as a `Gio::ListModel` of `Files`. Otherwise, <tt>nullptr</tt> is returned
   * and @a error is set.
   * 
   * @throws Glib::Error
   */
  Glib::RefPtr<Gio::ListModel> open_multiple_finish(const Glib::RefPtr<Gio::AsyncResult>& result) const;

  
  /** This function initiates a multi-directory selection operation by
   * presenting a file chooser dialog to the user.
   * 
   * The file chooser will initially be opened in the directory
   * property_current_folder().
   * 
   * The @a slot will be called when the dialog is dismissed.
   * It should call select_multiple_folders_finish()
   * to obtain the result.
   * 
   * @newin{4,10}
   * 
   * @param parent The parent `Gtk::Window`.
   * @param cancellable A `Cancellable` to cancel the operation.
   * @param slot A callback to call when the operation is complete.
   */
  void select_multiple_folders(Window& parent, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {}) const;

  /// A select_multiple_folders() convenience overload.
  void select_multiple_folders(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable =  {}) const;
  
  /** Finishes the select_multiple_folders()
   * call and returns the resulting files in a `Gio::ListModel`.
   * 
   * @newin{4,10}
   * 
   * @param result A `Gio::AsyncResult`.
   * @return The file that was selected,
   * as a `Gio::ListModel` of `Files`. Otherwise, <tt>nullptr</tt> is returned
   * and @a error is set.
   * 
   * @throws Glib::Error
   */
  Glib::RefPtr<Gio::ListModel> select_multiple_folders_finish(const Glib::RefPtr<Gio::AsyncResult>& result) const;

  /** A title that may be shown on the file chooser dialog.
   * 
   * @newin{4,10}
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_title() ;

/** A title that may be shown on the file chooser dialog.
   * 
   * @newin{4,10}
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_title() const;

  /** Whether the file chooser dialog is modal.
   * 
   * @newin{4,10}
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_modal() ;

/** Whether the file chooser dialog is modal.
   * 
   * @newin{4,10}
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_modal() const;

  /** The list of filters.
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gio::ListModel> > property_filters() ;

/** The list of filters.
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::ListModel> > property_filters() const;

  /** The list of shortcut folders.
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gio::ListModel> > property_shortcut_folders() ;

/** The list of shortcut folders.
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::ListModel> > property_shortcut_folders() const;

  /** The current filter, that is, the filter that is initially
   * active in the file chooser dialog.
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<FileFilter> > property_current_filter() ;

/** The current filter, that is, the filter that is initially
   * active in the file chooser dialog.
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<FileFilter> > property_current_filter() const;

  /** The current folder, that is, the directory that is initially
   * opened in the file chooser dialog, unless overridden by parameters
   * of the async call.
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gio::File> > property_current_folder() ;

/** The current folder, that is, the directory that is initially
   * opened in the file chooser dialog, unless overridden by parameters
   * of the async call.
   * 
   * @newin{4,10}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::File> > property_current_folder() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::FileDialog
   */
  GTKMM_API
  Glib::RefPtr<Gtk::FileDialog> wrap(GtkFileDialog* object, bool take_copy = false);
}


#endif /* _GTKMM_FILEDIALOG_H */

