// Generated by gmmproc 2.68.1 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gdkmm/clipboard.h>
#include <gdkmm/private/clipboard_p.h>


/* Copyright (C) 2017 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */
 
#include <giomm/cancellable.h>
#include <giomm/slot_async.h>
#include <giomm/inputstream.h>

namespace Gdk
{
bool Clipboard::unset_content()
{
  return gdk_clipboard_set_content(gobj(), nullptr);
}
} // namespace Gdk

namespace
{


static const Glib::SignalProxyInfo Clipboard_signal_changed_info =
{
  "changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gdk::Clipboard> wrap(GdkClipboard* object, bool take_copy)
{
  return Glib::make_refptr_for_instance<Gdk::Clipboard>( dynamic_cast<Gdk::Clipboard*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gdk
{


/* The *_Class implementation: */

const Glib::Class& Clipboard_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Clipboard_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gdk_clipboard_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Clipboard_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


}


Glib::ObjectBase* Clipboard_Class::wrap_new(GObject* object)
{
  return new Clipboard((GdkClipboard*)object);
}


/* The implementation: */

GdkClipboard* Clipboard::gobj_copy()
{
  reference();
  return gobj();
}

Clipboard::Clipboard(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

Clipboard::Clipboard(GdkClipboard* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


Clipboard::Clipboard(Clipboard&& src) noexcept
: Glib::Object(std::move(src))
{}

Clipboard& Clipboard::operator=(Clipboard&& src) noexcept
{
  Glib::Object::operator=(std::move(src));
  return *this;
}


Clipboard::~Clipboard() noexcept
{}


Clipboard::CppClassType Clipboard::clipboard_class_; // initialize static member

GType Clipboard::get_type()
{
  return clipboard_class_.init().get_type();
}


GType Clipboard::get_base_type()
{
  return gdk_clipboard_get_type();
}


Glib::RefPtr<Display> Clipboard::get_display()
{
  auto retvalue = Glib::wrap(gdk_clipboard_get_display(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Display> Clipboard::get_display() const
{
  return const_cast<Clipboard*>(this)->get_display();
}

Glib::RefPtr<ContentFormats> Clipboard::get_formats()
{
  auto retvalue = Glib::wrap(gdk_clipboard_get_formats(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const ContentFormats> Clipboard::get_formats() const
{
  return const_cast<Clipboard*>(this)->get_formats();
}

bool Clipboard::is_local() const
{
  return gdk_clipboard_is_local(const_cast<GdkClipboard*>(gobj()));
}

Glib::RefPtr<ContentProvider> Clipboard::get_content()
{
  auto retvalue = Glib::wrap(gdk_clipboard_get_content(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const ContentProvider> Clipboard::get_content() const
{
  return const_cast<Clipboard*>(this)->get_content();
}

void Clipboard::read_async(const std::vector<Glib::ustring>& mime_types, int io_priority, const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable)
{
  // Create a copy of the slot.
  auto slot_copy = new Gio::SlotAsyncReady(slot); 

  gdk_clipboard_read_async(gobj(), Glib::ArrayHandler<Glib::ustring>::vector_to_array(mime_types).data(), io_priority, const_cast<GCancellable*>(Glib::unwrap(cancellable)), &Gio::SignalProxy_async_callback, slot_copy);
}

void Clipboard::read_async(const std::vector<Glib::ustring>& mime_types, int io_priority, const Gio::SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  auto slot_copy = new Gio::SlotAsyncReady(slot); 

  gdk_clipboard_read_async(gobj(), Glib::ArrayHandler<Glib::ustring>::vector_to_array(mime_types).data(), io_priority, nullptr, &Gio::SignalProxy_async_callback, slot_copy);
}

Glib::RefPtr<Gio::InputStream> Clipboard::read_finish(const Glib::RefPtr<Gio::AsyncResult>& result, Glib::ustring& out_mime_type)
{
  GError* gerror = nullptr;
  const char* g_out_mime_type = nullptr;
  auto retvalue = Glib::wrap(gdk_clipboard_read_finish(gobj(), Glib::unwrap(result), &g_out_mime_type, &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
out_mime_type = Glib::convert_const_gchar_ptr_to_ustring(g_out_mime_type);
  return retvalue;
}

void Clipboard::read_texture_async(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable)
{
  // Create a copy of the slot.
  auto slot_copy = new Gio::SlotAsyncReady(slot); 

  gdk_clipboard_read_texture_async(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &Gio::SignalProxy_async_callback, slot_copy);
}

void Clipboard::read_texture_async(const Gio::SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  auto slot_copy = new Gio::SlotAsyncReady(slot); 

  gdk_clipboard_read_texture_async(gobj(), nullptr, &Gio::SignalProxy_async_callback, slot_copy);
}

Glib::RefPtr<Texture> Clipboard::read_texture_finish(const Glib::RefPtr<Gio::AsyncResult>& result)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(gdk_clipboard_read_texture_finish(gobj(), Glib::unwrap(result), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

void Clipboard::read_text_async(const Gio::SlotAsyncReady& slot, const Glib::RefPtr<Gio::Cancellable>& cancellable)
{
  // Create a copy of the slot.
  auto slot_copy = new Gio::SlotAsyncReady(slot); 

  gdk_clipboard_read_text_async(gobj(), const_cast<GCancellable*>(Glib::unwrap(cancellable)), &Gio::SignalProxy_async_callback, slot_copy);
}

void Clipboard::read_text_async(const Gio::SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  auto slot_copy = new Gio::SlotAsyncReady(slot); 

  gdk_clipboard_read_text_async(gobj(), nullptr, &Gio::SignalProxy_async_callback, slot_copy);
}

Glib::ustring Clipboard::read_text_finish(const Glib::RefPtr<Gio::AsyncResult>& result)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::convert_return_gchar_ptr_to_ustring(gdk_clipboard_read_text_finish(gobj(), Glib::unwrap(result), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

bool Clipboard::set_content(const Glib::RefPtr<const ContentProvider>& provider)
{
  return gdk_clipboard_set_content(gobj(), const_cast<GdkContentProvider*>(Glib::unwrap(provider)));
}

void Clipboard::set_text(const Glib::ustring& text)
{
  gdk_clipboard_set_text(gobj(), text.c_str());
}

void Clipboard::set_texture(const Glib::RefPtr<const Texture>& texture)
{
  gdk_clipboard_set_texture(gobj(), const_cast<GdkTexture*>(Glib::unwrap(texture)));
}


Glib::SignalProxy<void()> Clipboard::signal_changed()
{
  return Glib::SignalProxy<void() >(this, &Clipboard_signal_changed_info);
}


static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<Display>>::value,
  "Type Glib::RefPtr<Display> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Display> > Clipboard::property_display() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Display> >(this, "display");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<ContentFormats>>::value,
  "Type Glib::RefPtr<ContentFormats> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<ContentFormats> > Clipboard::property_formats() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<ContentFormats> >(this, "formats");
}

Glib::PropertyProxy_ReadOnly< bool > Clipboard::property_local() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "local");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<ContentProvider>>::value,
  "Type Glib::RefPtr<ContentProvider> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<ContentProvider> > Clipboard::property_content() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<ContentProvider> >(this, "content");
}


} // namespace Gdk


