// Generated by gmmproc 2.80.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gdkmm/texture.h>
#include <gdkmm/private/texture_p.h>


/* Copyright (C) 2017 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glibmm/bytes.h>
#include <giomm/file.h>
#include <gdkmm/colorstate.h>
#include <gdkmm/pixbuf.h>
#include <gdk/gdk.h>

namespace
{
} // anonymous namespace


Gdk::TextureError::TextureError(Gdk::TextureError::Code error_code, const Glib::ustring& error_message)
:
  Glib::Error (GDK_TEXTURE_ERROR, error_code, error_message)
{}

Gdk::TextureError::TextureError(GError* gobject)
:
  Glib::Error (gobject)
{}

Gdk::TextureError::Code Gdk::TextureError::code() const
{
  return static_cast<Code>(Glib::Error::code());
}

void Gdk::TextureError::throw_func(GError* gobject)
{
  throw Gdk::TextureError(gobject);
}

// static
GType Glib::Value<Gdk::TextureError::Code>::value_type()
{
  return gdk_texture_error_get_type();
}


namespace Glib
{

Glib::RefPtr<Gdk::Texture> wrap(GdkTexture* object, bool take_copy)
{
  return Glib::make_refptr_for_instance<Gdk::Texture>( dynamic_cast<Gdk::Texture*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gdk
{


/* The *_Class implementation: */

const Glib::Class& Texture_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Texture_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gdk_texture_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  Paintable::add_interface(get_type());

  }

  return *this;
}


void Texture_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


}


Glib::ObjectBase* Texture_Class::wrap_new(GObject* object)
{
  return new Texture((GdkTexture*)object);
}


/* The implementation: */

GdkTexture* Texture::gobj_copy()
{
  reference();
  return gobj();
}

Texture::Texture(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

Texture::Texture(GdkTexture* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


Texture::Texture(Texture&& src) noexcept
: Glib::Object(std::move(src))
  , Paintable(std::move(src))
{}

Texture& Texture::operator=(Texture&& src) noexcept
{
  Glib::Object::operator=(std::move(src));
  Paintable::operator=(std::move(src));
  return *this;
}


Texture::~Texture() noexcept
{}


Texture::CppClassType Texture::texture_class_; // initialize static member

GType Texture::get_type()
{
  return texture_class_.init().get_type();
}


GType Texture::get_base_type()
{
  return gdk_texture_get_type();
}


Texture::Texture()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Glib::Object(Glib::ConstructParams(texture_class_.init()))
{
  

}

Glib::RefPtr<Texture> Texture::create_for_pixbuf(const Glib::RefPtr<Pixbuf>& pixbuf)
{
  return Glib::wrap(gdk_texture_new_for_pixbuf(Glib::unwrap(pixbuf)));
}

Glib::RefPtr<Texture> Texture::create_from_resource(const std::string& resource_path)
{
  return Glib::wrap(gdk_texture_new_from_resource(resource_path.c_str()));
}

Glib::RefPtr<Texture> Texture::create_from_file(const Glib::RefPtr<Gio::File>& file)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(gdk_texture_new_from_file(const_cast<GFile*>(Glib::unwrap<Gio::File>(file)), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<Texture> Texture::create_from_filename(const std::string& path)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(gdk_texture_new_from_filename(path.c_str(), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

Glib::RefPtr<Texture> Texture::create_from_bytes(const Glib::RefPtr<const Glib::Bytes>& bytes)
{
  GError* gerror = nullptr;
  auto retvalue = Glib::wrap(gdk_texture_new_from_bytes(const_cast<GBytes*>(Glib::unwrap<Glib::Bytes>(bytes)), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retvalue;
}

int Texture::get_width() const
{
  return gdk_texture_get_width(const_cast<GdkTexture*>(gobj()));
}

int Texture::get_height() const
{
  return gdk_texture_get_height(const_cast<GdkTexture*>(gobj()));
}

MemoryFormat Texture::get_format() const
{
  return static_cast<MemoryFormat>(gdk_texture_get_format(const_cast<GdkTexture*>(gobj())));
}

Glib::RefPtr<ColorState> Texture::get_color_state() const
{
  auto retvalue = Glib::wrap(gdk_texture_get_color_state(const_cast<GdkTexture*>(gobj())));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

void Texture::download(guchar* data, gsize stride) const
{
  gdk_texture_download(const_cast<GdkTexture*>(gobj()), data, stride);
}

bool Texture::save_to_png(const Glib::ustring& filename) const
{
  return gdk_texture_save_to_png(const_cast<GdkTexture*>(gobj()), filename.c_str());
}

Glib::RefPtr<Glib::Bytes> Texture::save_to_png_bytes() const
{
  return Glib::wrap(gdk_texture_save_to_png_bytes(const_cast<GdkTexture*>(gobj())));
}

bool Texture::save_to_tiff(const std::string& filename) const
{
  return gdk_texture_save_to_tiff(const_cast<GdkTexture*>(gobj()), filename.c_str());
}

Glib::RefPtr<Glib::Bytes> Texture::save_to_tiff_bytes() const
{
  return Glib::wrap(gdk_texture_save_to_tiff_bytes(const_cast<GdkTexture*>(gobj())));
}


Glib::PropertyProxy_ReadOnly< int > Texture::property_width() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "width");
}

Glib::PropertyProxy_ReadOnly< int > Texture::property_height() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "height");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<ColorState>>::value,
  "Type Glib::RefPtr<ColorState> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<ColorState> > Texture::property_color_state() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<ColorState> >(this, "color-state");
}


} // namespace Gdk


