// Generated by gmmproc 2.80.0 -- DO NOT MODIFY!
#ifndef _GDKMM_MEMORYTEXTUREBUILDER_H
#define _GDKMM_MEMORYTEXTUREBUILDER_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2024 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glibmm/object.h>
#include <glibmm/bytes.h>
#include <gdkmm/enums.h>
#include <cairomm/region.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GdkMemoryTextureBuilder = struct _GdkMemoryTextureBuilder;
using GdkMemoryTextureBuilderClass = struct _GdkMemoryTextureBuilderClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gdk
{ class GDKMM_API MemoryTextureBuilder_Class; } // namespace Gdk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gdk
{
class GDKMM_API ColorState;
class GDKMM_API Texture;

/** %Gdk::MemoryTextureBuilder is a builder used to construct Gdk::Texture objects
 * from system memory provided via Glib::Bytes.
 *
 * The operation is quite simple: Create a texture builder, set all the necessary
 * properties - keep in mind that property_bytes(), property_stride(),
 * property_width(), and property_height() are mandatory - and then call
 * build() to create the new texture.
 *
 * %Gdk::MemoryTextureBuilder can be used for quick one-shot construction of
 * textures as well as kept around and reused to construct multiple textures.
 *
 * @newin{4,16}
 */

class GDKMM_API MemoryTextureBuilder : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = MemoryTextureBuilder;
  using CppClassType = MemoryTextureBuilder_Class;
  using BaseObjectType = GdkMemoryTextureBuilder;
  using BaseClassType = GdkMemoryTextureBuilderClass;

  // noncopyable
  MemoryTextureBuilder(const MemoryTextureBuilder&) = delete;
  MemoryTextureBuilder& operator=(const MemoryTextureBuilder&) = delete;

private:  friend class MemoryTextureBuilder_Class;
  static CppClassType memorytexturebuilder_class_;

protected:
  explicit MemoryTextureBuilder(const Glib::ConstructParams& construct_params);
  explicit MemoryTextureBuilder(GdkMemoryTextureBuilder* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  MemoryTextureBuilder(MemoryTextureBuilder&& src) noexcept;
  MemoryTextureBuilder& operator=(MemoryTextureBuilder&& src) noexcept;

  ~MemoryTextureBuilder() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkMemoryTextureBuilder*       gobj()       { return reinterpret_cast<GdkMemoryTextureBuilder*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkMemoryTextureBuilder* gobj() const { return reinterpret_cast<GdkMemoryTextureBuilder*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdkMemoryTextureBuilder* gobj_copy();

private:

   
protected:
  MemoryTextureBuilder();

public:
  
  static Glib::RefPtr<MemoryTextureBuilder> create();


  // Glib::Bytes and Gdk::ColorState are immutable. No need for non-const get-methods.
  
  /** Gets the bytes previously set via set_bytes()
   * or <tt>nullptr</tt> if none was set.
   * 
   * @newin{4,16}
   * 
   * @return The bytes.
   */
  Glib::RefPtr<Glib::Bytes> get_bytes() const;
  
  /** Sets the data to be shown but the texture.
   * 
   * The bytes must be set before calling build().
   * 
   * @newin{4,16}
   * 
   * @param context The bytes the texture shows or <tt>nullptr</tt> to unset.
   */
  void set_bytes(const Glib::RefPtr<const Glib::Bytes>& context);

  
  /** Gets the stride previously set via set_stride().
   * 
   * @newin{4,16}
   * 
   * @return The stride.
   */
  gsize get_stride() const;
  
  /** Sets the rowstride of the bytes used.
   * 
   * The rowstride must be set before calling build().
   * 
   * @newin{4,16}
   * 
   * @param stride The stride or 0 to unset.
   */
  void set_stride(gsize stride);

  
  /** Gets the width previously set via set_width()
   * or 0 if the width wasn't set.
   * 
   * @newin{4,16}
   * 
   * @return The width.
   */
  int get_width() const;
  
  /** Sets the width of the texture.
   * 
   * The width must be set before calling build().
   * 
   * @newin{4,16}
   * 
   * @param width The texture's width or 0 to unset.
   */
  void set_width(int width);

  
  /** Gets the height previously set via set_height()
   * or 0 if the height wasn't set.
   * 
   * @newin{4,16}
   * 
   * @return The height.
   */
  int get_height() const;
  
  /** Sets the height of the texture.
   * 
   * The height must be set before calling build().
   * 
   * @newin{4,16}
   * 
   * @param height The texture's height or 0 to unset.
   */
  void set_height(int height);

  
  /** Gets the format previously set via set_format().
   * 
   * @newin{4,16}
   * 
   * @return The format.
   */
  MemoryFormat get_format() const;
  
  /** Sets the format of the bytes.
   * 
   * The default is `Gdk::MemoryFormat::R8G8B8A8_PREMULTIPLIED`.
   * 
   * @newin{4,16}
   * 
   * @param format The texture's format.
   */
  void set_format(MemoryFormat format);

  
  /** Gets the colorstate previously set via set_color_state().
   * 
   * @newin{4,16}
   * 
   * @return The colorstate.
   */
  Glib::RefPtr<ColorState> get_color_state() const;
  
  /** Sets the colorstate describing the data.
   * 
   * By default, the sRGB colorstate is used. If you don't know
   * what colorstates are, this is probably the right thing.
   * 
   * @newin{4,16}
   * 
   * @param color_state The colorstate describing the data.
   */
  void set_color_state(const Glib::RefPtr<const ColorState>& color_state);

  
  /** Gets the texture previously set via set_update_texture()
   * or <tt>nullptr</tt> if none was set.
   * 
   * @newin{4,16}
   * 
   * @return The update texture.
   */
  Glib::RefPtr<Texture> get_update_texture();
  
  /** Gets the texture previously set via set_update_texture()
   * or <tt>nullptr</tt> if none was set.
   * 
   * @newin{4,16}
   * 
   * @return The update texture.
   */
  Glib::RefPtr<const Texture> get_update_texture() const;
  
  /** Sets the texture to be updated by this texture.
   * 
   * See set_update_region() for an explanation.
   * 
   * @newin{4,16}
   * 
   * @param texture The texture to update.
   */
  void set_update_texture(const Glib::RefPtr<Texture>& texture);

  
  /** Gets the region previously set via set_update_region()
   * or <tt>nullptr</tt> if none was set.
   * 
   * @newin{4,16}
   * 
   * @return The update region.
   */
  ::Cairo::RefPtr< ::Cairo::Region> get_update_region();
  
  /** Gets the region previously set via set_update_region()
   * or <tt>nullptr</tt> if none was set.
   * 
   * @newin{4,16}
   * 
   * @return The update region.
   */
  ::Cairo::RefPtr<const ::Cairo::Region> get_update_region() const;
  
  /** Sets the region to be updated by this texture.
   * 
   * Together with property_update_texture(),
   * this describes an update of a previous texture.
   * 
   * When rendering animations of large textures, it is possible that
   * consecutive textures are only updating contents in parts of the texture.
   * It is then possible to describe this update via these two properties,
   * so that GTK can avoid rerendering parts that did not change.
   * 
   * An example would be a screen recording where only the mouse pointer moves.
   * 
   * @newin{4,16}
   * 
   * @param region The region to update.
   */
  void set_update_region(const ::Cairo::RefPtr< ::Cairo::Region>& region);

  
  /** Builds a new `Gdk::Texture` with the values set up in the builder.
   * 
   * Note that it is a programming error to call this function if any mandatory
   * property has not been set.
   * 
   * It is possible to call this function multiple times to create multiple textures,
   * possibly with changing properties in between.
   * 
   * @newin{4,16}
   * 
   * @return A newly built `Gdk::Texture`.
   */
  Glib::RefPtr<Texture> build();

  /** The bytes holding the data.
   * 
   * @newin{4,16}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Glib::Bytes> > property_bytes() ;

/** The bytes holding the data.
   * 
   * @newin{4,16}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Glib::Bytes> > property_bytes() const;

  /** The colorstate describing the data.
   * 
   * @newin{4,16}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<ColorState> > property_color_state() ;

/** The colorstate describing the data.
   * 
   * @newin{4,16}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<ColorState> > property_color_state() const;

  /** The format of the data.
   * 
   * @newin{4,16}
   *
   * Default value: Gdk::MemoryFormat::R8G8B8A8_PREMULTIPLIED
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< MemoryFormat > property_format() ;

/** The format of the data.
   * 
   * @newin{4,16}
   *
   * Default value: Gdk::MemoryFormat::R8G8B8A8_PREMULTIPLIED
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< MemoryFormat > property_format() const;

  /** The height of the texture.
   * 
   * @newin{4,16}
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_height() ;

/** The height of the texture.
   * 
   * @newin{4,16}
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_height() const;

  /** The rowstride of the texture.
   * 
   * The rowstride is the number of bytes between the first pixel
   * in a row of image data, and the first pixel in the next row.
   * 
   * @newin{4,16}
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< gsize > property_stride() ;

/** The rowstride of the texture.
   * 
   * The rowstride is the number of bytes between the first pixel
   * in a row of image data, and the first pixel in the next row.
   * 
   * @newin{4,16}
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< gsize > property_stride() const;

  /** The update region for property_update_texture().
   * 
   * @newin{4,16}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< ::Cairo::RefPtr< ::Cairo::Region> > property_update_region() ;

/** The update region for property_update_texture().
   * 
   * @newin{4,16}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< ::Cairo::RefPtr< ::Cairo::Region> > property_update_region() const;

  /** The texture property_update_region() is an update for.
   * 
   * @newin{4,16}
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Texture> > property_update_texture() ;

/** The texture property_update_region() is an update for.
   * 
   * @newin{4,16}
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Texture> > property_update_texture() const;

  /** The width of the texture.
   * 
   * @newin{4,16}
   *
   * Default value: 0
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_width() ;

/** The width of the texture.
   * 
   * @newin{4,16}
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_width() const;


  // There are no signals or public vfuncs.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gdk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gdk::MemoryTextureBuilder
   */
  GDKMM_API
  Glib::RefPtr<Gdk::MemoryTextureBuilder> wrap(GdkMemoryTextureBuilder* object, bool take_copy = false);
}


#endif /* _GDKMM_MEMORYTEXTUREBUILDER_H */

