// Generated by gmmproc 2.78.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gtkmm/window.h>
#include <gtkmm/private/window_p.h>


/*
 * Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glibmm/vectorutils.h>
#include <giomm/listmodel.h>
#include <gdkmm/monitor.h>
#include <gtkmm/application.h>
#include <gtk/gtk.h>

namespace
{
using Window_dispose_vfunc_functype = void (*)(GObject* self);
Window_dispose_vfunc_functype Window_dispose_vfunc_funcptr;

extern "C"
{
static void Window_dispose_vfunc_c_callback(GObject* self)
{
  Window_dispose_vfunc_funcptr(self);
}
} // extern "C"
} // anonymous namespace

namespace Gtk
{

// All constructors are hand-coded, because they connect a signal handler
// that removes the window from its application when the window is closed (hidden).
Window::Window(const Glib::ConstructParams& construct_params)
:
  Gtk::Widget(construct_params)
{
  signal_hide().connect(sigc::mem_fun(*this, &Window::on_window_hide));
}

Window::Window(GtkWindow* castitem)
:
  Gtk::Widget((GtkWidget*)castitem)
{
  signal_hide().connect(sigc::mem_fun(*this, &Window::on_window_hide));
}

Window::Window(Window&& src) noexcept
: Gtk::Widget(std::move(src))
  , Native(std::move(src))
  , Root(std::move(src))
{
  try
  {
    signal_hide().connect(sigc::mem_fun(*this, &Window::on_window_hide));
  }
  catch (...)
  {
    // Ignore exceptions.
    // The move ctor shall be noexcept. It can be called from a move ctor
    // in a subclass, such as Gtk::Dialog.
  }
}

// The move assignment is identical to the one that gmmproc can generate.
// _CUSTOM_MOVE_OPERATIONS() suppresses both move contructor and move assignment. 
Window& Window::operator=(Window&& src) noexcept
{
  Gtk::Widget::operator=(std::move(src));
  Native::operator=(std::move(src));
  Root::operator=(std::move(src));
  return *this;
}

Window::Window()
: // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Gtk::Widget(Glib::ConstructParams(window_class_.init()))
{
  signal_hide().connect(sigc::mem_fun(*this, &Window::on_window_hide));
}

void Window::on_window_hide()
{
  #ifdef GLIBMM_DEBUG_REFCOUNTING
  g_warning("Gtk::Window::on_window_hide() gobject_=%p\n", (void*) gobject_);
  #endif

  auto appl = get_application();
  if (appl)
  {
    #ifdef GLIBMM_DEBUG_REFCOUNTING
    g_warning("Gtk::Window::on_window_hide(): before remove_window().");
    #endif

    // Tell GtkApplication to forget the window.
    // This can cause Application::run() to return, if it is the last window.
    // Otherwise, GtkApplication waits for the window to be _destroyed_,
    // which is just not something that it should care about.
    // See https://bugzilla.gnome.org/show_bug.cgi?id=639931
    appl->remove_window(*this);
  }
}

void Window::set_manage()
{
  // This C++ wrapper is deleted by Gtk::Object::destroy_notify_() when the
  // underlying C instance is destroyed.
  referenced_ = false; // Managed
}

void Window::destroy_()
{
  //Called from destructors.
  //overridden so that the correct _release_c_instance() ends up being called by the destructor.
  //The destructors that call destroy_() are virtual, but _release_c_instance() is not.

  //GTKMM_LIFECYCLE

  #ifdef GLIBMM_DEBUG_REFCOUNTING
  g_warning("Gtk::Window::destroy_(): gobject_: %p\n", (void*) gobject_);
  if(gobject_)
   g_warning("  gtypename: %s\n", G_OBJECT_TYPE_NAME(gobject_));
  #endif

  if ( !cpp_destruction_in_progress_ )
  {
    cpp_destruction_in_progress_ = true;

    //destroy the C instance:
    _release_c_instance();
  }

  //The C++ destructor will be reached later. This function was called by a destructor.
}

void Window::_release_c_instance()
{
  //We override this, (though it's not virtual - we just call it from this class),
  //because top-level windows can only be destroyed with gtk_window_destroy, according to Owen Taylor. murrayc.
  #ifdef GLIBMM_DEBUG_REFCOUNTING
  g_warning("Gtk::Window::_release_c_instance() gobject_=%p\n", (void*) gobject_);
  #endif

  cpp_destruction_in_progress_ = true;

  // remove our hook.
  if (gobj())
  {
    //Windows can not be unrefed. They are "self-owning".
    gtk_window_destroy(gobj());

    //If the GObject still exists, disconnect the C++ wrapper from it.
    //The C++ wrapper is being deleted right now.
    disconnect_cpp_wrapper();

    //Glib::Object::~Object() will not g_object_unref() it too, because gobject_ is now 0.
  }
}

void Window_Class::dispose_vfunc_callback(GObject* self)
{
  #ifdef GLIBMM_DEBUG_REFCOUNTING
  g_warning("Window_Class::dispose_vfunc_callback(): gobject_: %p\n", (void*)self);
  #endif

  const auto obj = dynamic_cast<Widget*>(
      Glib::ObjectBase::_get_current_wrapper(self));

  // This function might be invoked recursively because we're triggering
  // several signal emissions, particularly signal_hide().  Therefore we
  // have to test for cpp_destruction_in_progress_ at this point.

  if(obj && !obj->_cpp_destruction_is_in_progress()) //When it should really be destroyed, we zero gobj_.
  {
    const auto pWidget = obj->gobj();
    g_return_if_fail(pWidget == GTK_WIDGET(self));

    #ifdef GLIBMM_DEBUG_REFCOUNTING
    g_warning("Window_Class::dispose_vfunc_callback(): before gtk_widget_set_visible(pWidget, false).");
    #endif

    // The window may have been hidden with a call to the static (i.e. private)
    // gtk_window_hide(), which does not send the "hide" signal.
    // In that case gtk_widget_set_visible(pWidget, false) has no effect,
    // and on_window_hide() won't be called indirectly from
    // gtk_widget_set_visible(pWidget, false).
    const auto win = dynamic_cast<Window*>(obj);
    if (win)
      win->on_window_hide();

    // Now hide the widget.  The C++ object must _not_ be accessed anymore
    // after this call, because a signal_hide() handler might delete it.
    gtk_widget_set_visible(pWidget, false);

    #ifdef GLIBMM_DEBUG_REFCOUNTING
    g_warning("Window_Class::dispose_vfunc_callback(): after gtk_widget_set_visible(pWidget, false).");
    #endif
  }

  // The "dispose" vfunc in GtkWindow does much more in gtk4 than in gtk3.
  // It would be difficult to make the deletion of windows work without letting
  // the gtk4 dispose vfunc do its job. /Kjell 2020-05-19
  // GTKMM_LIFECYCLE

  const auto base = static_cast<GObjectClass*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)));

  #ifdef GLIBMM_DEBUG_REFCOUNTING
  g_warning("Window_Class::dispose_vfunc_callback(): before calling base->dispose.");
  #endif

  if(base->dispose)
    (*base->dispose)(self);

  #ifdef GLIBMM_DEBUG_REFCOUNTING
  g_warning("Window_Class::dispose_vfunc_callback(): after calling base->dispose.");
  #endif
}

void Window::destroy()
{
  // Don't crash if destroy() is called twice.
  // gobj() can be nullptr after the first call to destroy().
  if (gobj())
    gtk_window_destroy(gobj());
}

void Window::unset_focus()
{
  gtk_window_set_focus(gobj(), nullptr /* See GTK+ docs */);
}

void Window::unset_default_widget()
{
  gtk_window_set_default_widget(gobj(), nullptr /* See GTK+ docs */);
}

void Window::unset_transient_for()
{
  gtk_window_set_transient_for(gobj(), nullptr /* See GTK+ docs */);
}

void Window::unset_child()
{
  gtk_window_set_child(gobj(), nullptr);
}

void Window::unset_application()
{
  gtk_window_set_application(gobj(), nullptr /* See GTK+ docs */);
}

void Window::unset_titlebar()
{
  gtk_window_set_titlebar(gobj(), nullptr);
}

} // namespace Gtk

namespace
{

#ifndef GTKMM_DISABLE_DEPRECATED


static const Glib::SignalProxyInfo Window_signal_keys_changed_info =
{
  "keys_changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};

#endif // GTKMM_DISABLE_DEPRECATED


#ifndef GTKMM_DISABLE_DEPRECATED

using Window_signal_keys_changed_functype = void (*)(GtkWindow* self);
Window_signal_keys_changed_functype Window_signal_keys_changed_funcptr;
extern "C" {
static void Window_signal_keys_changed_default_callback(GtkWindow* self)
{
  Window_signal_keys_changed_funcptr( self);
}
} // extern "C"
#endif // GTKMM_DISABLE_DEPRECATED


extern "C" {
static gboolean Window_signal_close_request_connect_callback(GtkWindow* self, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool()>;

  auto obj = dynamic_cast<Window*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))());
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Window_signal_close_request_notify_callback(GtkWindow* self,  void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void()>;

  auto obj = dynamic_cast<Window*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}
} // extern "C"

static const Glib::SignalProxyInfo Window_signal_close_request_info =
{
  "close-request",
  (GCallback) &Window_signal_close_request_connect_callback,
  (GCallback) &Window_signal_close_request_notify_callback
};


using Window_signal_close_request_functype = gboolean (*)(GtkWindow* self);
Window_signal_close_request_functype Window_signal_close_request_funcptr;
extern "C" {
static gboolean Window_signal_close_request_default_callback(GtkWindow* self)
{
  return Window_signal_close_request_funcptr( self);
}
} // extern "C"
} // anonymous namespace


namespace Glib
{

Gtk::Window* wrap(GtkWindow* object, bool take_copy)
{
  return dynamic_cast<Gtk::Window *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& Window_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Window_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_window_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  Native::add_interface(get_type());
  ShortcutManager::add_interface(get_type());
  Root::add_interface(get_type());

  }

  return *this;
}


void Window_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

    reinterpret_cast<GObjectClass*>(klass)->dispose = &Window_dispose_vfunc_c_callback;
    Window_dispose_vfunc_funcptr = &dispose_vfunc_callback;
  
#ifndef GTKMM_DISABLE_DEPRECATED

  klass->keys_changed = &Window_signal_keys_changed_default_callback;
  Window_signal_keys_changed_funcptr = &keys_changed_callback;
#endif // GTKMM_DISABLE_DEPRECATED

  klass->close_request = &Window_signal_close_request_default_callback;
  Window_signal_close_request_funcptr = &close_request_callback;
}


#ifndef GTKMM_DISABLE_DEPRECATED

void Window_Class::keys_changed_callback(GtkWindow* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_keys_changed();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->keys_changed)
    (*base->keys_changed)(self);
}
#endif // GTKMM_DISABLE_DEPRECATED

gboolean Window_Class::close_request_callback(GtkWindow* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_close_request());
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->close_request)
    return (*base->close_request)(self);

  using RType = gboolean;
  return RType();
}


Glib::ObjectBase* Window_Class::wrap_new(GObject* o)
{
  return new Window((GtkWindow*)(o)); //top-level windows can not be manage()ed.

}


/* The implementation: */


Window::~Window() noexcept
{
  destroy_();
}

Window::CppClassType Window::window_class_; // initialize static member

GType Window::get_type()
{
  return window_class_.init().get_type();
}


GType Window::get_base_type()
{
  return gtk_window_get_type();
}


void Window::set_title(const Glib::ustring& title)
{
  gtk_window_set_title(gobj(), title.c_str());
}

Glib::ustring Window::get_title() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_window_get_title(const_cast<GtkWindow*>(gobj())));
}

void Window::set_startup_id(const Glib::ustring& startup_id)
{
  gtk_window_set_startup_id(gobj(), startup_id.c_str());
}

void Window::set_focus(Gtk::Widget& focus)
{
  gtk_window_set_focus(gobj(), (focus).gobj());
}

Widget* Window::get_focus()
{
  return Glib::wrap(gtk_window_get_focus(gobj()));
}

const Widget* Window::get_focus() const
{
  return const_cast<Window*>(this)->get_focus();
}

void Window::set_default_widget(Gtk::Widget& default_widget)
{
  gtk_window_set_default_widget(gobj(), (default_widget).gobj());
}

Widget* Window::get_default_widget()
{
  return Glib::wrap(gtk_window_get_default_widget(gobj()));
}

const Widget* Window::get_default_widget() const
{
  return const_cast<Window*>(this)->get_default_widget();
}

void Window::set_transient_for(Window& parent)
{
  gtk_window_set_transient_for(gobj(), (parent).gobj());
}

Window* Window::get_transient_for()
{
  return Glib::wrap(gtk_window_get_transient_for(gobj()));
}

const Window* Window::get_transient_for() const
{
  return const_cast<Window*>(this)->get_transient_for();
}

void Window::set_destroy_with_parent(bool setting)
{
  gtk_window_set_destroy_with_parent(gobj(), static_cast<int>(setting));
}

bool Window::get_destroy_with_parent() const
{
  return gtk_window_get_destroy_with_parent(const_cast<GtkWindow*>(gobj()));
}

void Window::set_hide_on_close(bool setting)
{
  gtk_window_set_hide_on_close(gobj(), static_cast<int>(setting));
}

bool Window::get_hide_on_close() const
{
  return gtk_window_get_hide_on_close(const_cast<GtkWindow*>(gobj()));
}

void Window::set_mnemonics_visible(bool setting)
{
  gtk_window_set_mnemonics_visible(gobj(), static_cast<int>(setting));
}

bool Window::get_mnemonics_visible() const
{
  return gtk_window_get_mnemonics_visible(const_cast<GtkWindow*>(gobj()));
}

void Window::set_focus_visible(bool setting)
{
  gtk_window_set_focus_visible(gobj(), static_cast<int>(setting));
}

bool Window::get_focus_visible() const
{
  return gtk_window_get_focus_visible(const_cast<GtkWindow*>(gobj()));
}

void Window::set_resizable(bool resizable)
{
  gtk_window_set_resizable(gobj(), static_cast<int>(resizable));
}

bool Window::get_resizable() const
{
  return gtk_window_get_resizable(const_cast<GtkWindow*>(gobj()));
}

void Window::set_display(const Glib::RefPtr<Gdk::Display>& display)
{
  gtk_window_set_display(gobj(), Glib::unwrap(display));
}

bool Window::is_active() const
{
  return gtk_window_is_active(const_cast<GtkWindow*>(gobj()));
}

void Window::set_decorated(bool setting)
{
  gtk_window_set_decorated(gobj(), static_cast<int>(setting));
}

bool Window::get_decorated() const
{
  return gtk_window_get_decorated(const_cast<GtkWindow*>(gobj()));
}

void Window::set_deletable(bool setting)
{
  gtk_window_set_deletable(gobj(), static_cast<int>(setting));
}

bool Window::get_deletable() const
{
  return gtk_window_get_deletable(const_cast<GtkWindow*>(gobj()));
}

void Window::set_icon_name(const Glib::ustring& name)
{
  gtk_window_set_icon_name(gobj(), name.c_str());
}

Glib::ustring Window::get_icon_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_window_get_icon_name(const_cast<GtkWindow*>(gobj())));
}

void Window::set_default_icon_name(const Glib::ustring& name)
{
  gtk_window_set_default_icon_name(name.c_str());
}

Glib::ustring Window::get_default_icon_name()
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_window_get_default_icon_name());
}

void Window::set_auto_startup_notification(bool setting)
{
  gtk_window_set_auto_startup_notification(static_cast<int>(setting));
}

void Window::set_modal(bool modal)
{
  gtk_window_set_modal(gobj(), static_cast<int>(modal));
}

bool Window::get_modal() const
{
  return gtk_window_get_modal(const_cast<GtkWindow*>(gobj()));
}

Glib::RefPtr<Gio::ListModel> Window::get_toplevels()
{

  auto retvalue = Glib::wrap(gtk_window_get_toplevels());
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us
  return retvalue;
}

std::vector<Window*> Window::list_toplevels()
{
  return Glib::ListHandler<Window*>::list_to_vector(gtk_window_list_toplevels(), Glib::OWNERSHIP_SHALLOW);
}

void Window::present()
{
  gtk_window_present(gobj());
}

#ifndef GTKMM_DISABLE_DEPRECATED
G_GNUC_BEGIN_IGNORE_DEPRECATIONS
void Window::present(guint32 timestamp)
{
  gtk_window_present_with_time(gobj(), timestamp);
}
G_GNUC_END_IGNORE_DEPRECATIONS
#endif // GTKMM_DISABLE_DEPRECATED

void Window::minimize()
{
  gtk_window_minimize(gobj());
}

void Window::unminimize()
{
  gtk_window_unminimize(gobj());
}

void Window::maximize()
{
  gtk_window_maximize(gobj());
}

void Window::unmaximize()
{
  gtk_window_unmaximize(gobj());
}

void Window::fullscreen()
{
  gtk_window_fullscreen(gobj());
}

void Window::unfullscreen()
{
  gtk_window_unfullscreen(gobj());
}

void Window::fullscreen_on_monitor(const Glib::RefPtr<Gdk::Monitor>& monitor)
{
  gtk_window_fullscreen_on_monitor(gobj(), Glib::unwrap(monitor));
}

void Window::close()
{
  gtk_window_close(gobj());
}

void Window::set_default_size(int width, int height)
{
  gtk_window_set_default_size(gobj(), width, height);
}

void Window::get_default_size(int& width, int& height) const
{
  gtk_window_get_default_size(const_cast<GtkWindow*>(gobj()), &(width), &(height));
}

Glib::RefPtr<WindowGroup> Window::get_group()
{
  auto retvalue = Glib::wrap(gtk_window_get_group(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const WindowGroup> Window::get_group() const
{
  return const_cast<Window*>(this)->get_group();
}

bool Window::has_group() const
{
  return gtk_window_has_group(const_cast<GtkWindow*>(gobj()));
}

Glib::RefPtr<Application> Window::get_application()
{
  auto retvalue = Glib::wrap(gtk_window_get_application(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Application> Window::get_application() const
{
  auto retvalue = Glib::wrap(gtk_window_get_application(const_cast<GtkWindow*>(gobj())));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

void Window::set_application(const Glib::RefPtr<Application>& application)
{
  gtk_window_set_application(gobj(), Glib::unwrap(application));
}

void Window::set_child(Widget& child)
{
  gtk_window_set_child(gobj(), (child).gobj());
}

Widget* Window::get_child()
{
  return Glib::wrap(gtk_window_get_child(gobj()));
}

const Widget* Window::get_child() const
{
  return const_cast<Window*>(this)->get_child();
}

void Window::set_titlebar(Widget& titlebar)
{
  gtk_window_set_titlebar(gobj(), (titlebar).gobj());
}

Widget* Window::get_titlebar()
{
  return Glib::wrap(gtk_window_get_titlebar(gobj()));
}

const Widget* Window::get_titlebar() const
{
  return const_cast<Window*>(this)->get_titlebar();
}

bool Window::is_maximized() const
{
  return gtk_window_is_maximized(const_cast<GtkWindow*>(gobj()));
}

bool Window::is_fullscreen() const
{
  return gtk_window_is_fullscreen(const_cast<GtkWindow*>(gobj()));
}

bool Window::is_suspended() const
{
  return gtk_window_is_suspended(const_cast<GtkWindow*>(gobj()));
}

void Window::set_handle_menubar_accel(bool handle_menubar_accel)
{
  gtk_window_set_handle_menubar_accel(gobj(), static_cast<int>(handle_menubar_accel));
}

bool Window::get_handle_menubar_accel() const
{
  return gtk_window_get_handle_menubar_accel(const_cast<GtkWindow*>(gobj()));
}


#ifndef GTKMM_DISABLE_DEPRECATED

Glib::SignalProxy<void()> Window::signal_keys_changed()
{
  return Glib::SignalProxy<void() >(this, &Window_signal_keys_changed_info);
}
#endif // GTKMM_DISABLE_DEPRECATED


Glib::SignalProxy<bool()> Window::signal_close_request()
{
  return Glib::SignalProxy<bool() >(this, &Window_signal_close_request_info);
}


Glib::PropertyProxy< Glib::ustring > Window::property_title() 
{
  return Glib::PropertyProxy< Glib::ustring >(this, "title");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > Window::property_title() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "title");
}

Glib::PropertyProxy_WriteOnly< Glib::ustring > Window::property_startup_id() 
{
  return Glib::PropertyProxy_WriteOnly< Glib::ustring >(this, "startup-id");
}

Glib::PropertyProxy< bool > Window::property_resizable() 
{
  return Glib::PropertyProxy< bool >(this, "resizable");
}

Glib::PropertyProxy_ReadOnly< bool > Window::property_resizable() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "resizable");
}

Glib::PropertyProxy< bool > Window::property_modal() 
{
  return Glib::PropertyProxy< bool >(this, "modal");
}

Glib::PropertyProxy_ReadOnly< bool > Window::property_modal() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "modal");
}

Glib::PropertyProxy< int > Window::property_default_width() 
{
  return Glib::PropertyProxy< int >(this, "default-width");
}

Glib::PropertyProxy_ReadOnly< int > Window::property_default_width() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "default-width");
}

Glib::PropertyProxy< int > Window::property_default_height() 
{
  return Glib::PropertyProxy< int >(this, "default-height");
}

Glib::PropertyProxy_ReadOnly< int > Window::property_default_height() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "default-height");
}

Glib::PropertyProxy< bool > Window::property_destroy_with_parent() 
{
  return Glib::PropertyProxy< bool >(this, "destroy-with-parent");
}

Glib::PropertyProxy_ReadOnly< bool > Window::property_destroy_with_parent() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "destroy-with-parent");
}

Glib::PropertyProxy< bool > Window::property_hide_on_close() 
{
  return Glib::PropertyProxy< bool >(this, "hide-on-close");
}

Glib::PropertyProxy_ReadOnly< bool > Window::property_hide_on_close() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "hide-on-close");
}

Glib::PropertyProxy< bool > Window::property_mnemonics_visible() 
{
  return Glib::PropertyProxy< bool >(this, "mnemonics-visible");
}

Glib::PropertyProxy_ReadOnly< bool > Window::property_mnemonics_visible() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "mnemonics-visible");
}

Glib::PropertyProxy< Glib::ustring > Window::property_icon_name() 
{
  return Glib::PropertyProxy< Glib::ustring >(this, "icon-name");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > Window::property_icon_name() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "icon-name");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<Gdk::Display>>::value,
  "Type Glib::RefPtr<Gdk::Display> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy< Glib::RefPtr<Gdk::Display> > Window::property_display() 
{
  return Glib::PropertyProxy< Glib::RefPtr<Gdk::Display> >(this, "display");
}

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Display> > Window::property_display() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Display> >(this, "display");
}

Glib::PropertyProxy_ReadOnly< bool > Window::property_is_active() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "is-active");
}

Glib::PropertyProxy< bool > Window::property_decorated() 
{
  return Glib::PropertyProxy< bool >(this, "decorated");
}

Glib::PropertyProxy_ReadOnly< bool > Window::property_decorated() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "decorated");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Window*>::value,
  "Type Window* cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy< Window* > Window::property_transient_for() 
{
  return Glib::PropertyProxy< Window* >(this, "transient-for");
}

Glib::PropertyProxy_ReadOnly< Window* > Window::property_transient_for() const
{
  return Glib::PropertyProxy_ReadOnly< Window* >(this, "transient-for");
}

Glib::PropertyProxy< bool > Window::property_deletable() 
{
  return Glib::PropertyProxy< bool >(this, "deletable");
}

Glib::PropertyProxy_ReadOnly< bool > Window::property_deletable() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "deletable");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<Application>>::value,
  "Type Glib::RefPtr<Application> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy< Glib::RefPtr<Application> > Window::property_application() 
{
  return Glib::PropertyProxy< Glib::RefPtr<Application> >(this, "application");
}

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Application> > Window::property_application() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Application> >(this, "application");
}

Glib::PropertyProxy< bool > Window::property_focus_visible() 
{
  return Glib::PropertyProxy< bool >(this, "focus-visible");
}

Glib::PropertyProxy_ReadOnly< bool > Window::property_focus_visible() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "focus-visible");
}

Glib::PropertyProxy< bool > Window::property_maximized() 
{
  return Glib::PropertyProxy< bool >(this, "maximized");
}

Glib::PropertyProxy_ReadOnly< bool > Window::property_maximized() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "maximized");
}

Glib::PropertyProxy< bool > Window::property_fullscreened() 
{
  return Glib::PropertyProxy< bool >(this, "fullscreened");
}

Glib::PropertyProxy_ReadOnly< bool > Window::property_fullscreened() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "fullscreened");
}

Glib::PropertyProxy_ReadOnly< bool > Window::property_suspended() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "suspended");
}

Glib::PropertyProxy< Widget* > Window::property_default_widget() 
{
  return Glib::PropertyProxy< Widget* >(this, "default-widget");
}

Glib::PropertyProxy_ReadOnly< Widget* > Window::property_default_widget() const
{
  return Glib::PropertyProxy_ReadOnly< Widget* >(this, "default-widget");
}

Glib::PropertyProxy< Widget* > Window::property_focus_widget() 
{
  return Glib::PropertyProxy< Widget* >(this, "focus-widget");
}

Glib::PropertyProxy_ReadOnly< Widget* > Window::property_focus_widget() const
{
  return Glib::PropertyProxy_ReadOnly< Widget* >(this, "focus-widget");
}

Glib::PropertyProxy< Widget* > Window::property_child() 
{
  return Glib::PropertyProxy< Widget* >(this, "child");
}

Glib::PropertyProxy_ReadOnly< Widget* > Window::property_child() const
{
  return Glib::PropertyProxy_ReadOnly< Widget* >(this, "child");
}

Glib::PropertyProxy< Widget* > Window::property_titlebar() 
{
  return Glib::PropertyProxy< Widget* >(this, "titlebar");
}

Glib::PropertyProxy_ReadOnly< Widget* > Window::property_titlebar() const
{
  return Glib::PropertyProxy_ReadOnly< Widget* >(this, "titlebar");
}

Glib::PropertyProxy< bool > Window::property_handle_menubar_accel() 
{
  return Glib::PropertyProxy< bool >(this, "handle-menubar-accel");
}

Glib::PropertyProxy_ReadOnly< bool > Window::property_handle_menubar_accel() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "handle-menubar-accel");
}


void Gtk::Window::on_keys_changed()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->keys_changed)
    (*base->keys_changed)(gobj());
}
bool Gtk::Window::on_close_request()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->close_request)
    return (*base->close_request)(gobj());

  using RType = bool;
  return RType();
}


} // namespace Gtk


