// Generated by gmmproc 2.68.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gtkmm/treeview.h>
#include <gtkmm/private/treeview_p.h>

#include <gtk/gtk.h>

/* Copyright 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <climits> // INT_MIN, etc.
#include <glibmm/vectorutils.h>
#include <gdkmm/contentformats.h>
#include <gtkmm/treeviewcolumn.h>
#include <gtkmm/treeview_private.h>
#include <gtkmm/treemodel.h>
#include <gtkmm/treemodelfilter.h>
#include <gtkmm/treemodelsort.h>
#include <gtkmm/entry.h>
#include <gtk/gtk.h>

using GridLines = Gtk::TreeView::GridLines;

static void SignalProxy_Mapping_gtk_callback(GtkTreeView* tree_view, GtkTreePath* path, void* data)
{
  auto the_slot = static_cast<Gtk::TreeView::SlotMapping*>(data);

  try
  {
    (*the_slot)(Glib::wrap(tree_view), Gtk::TreePath(path, true));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

static gboolean SignalProxy_SearchEqual_gtk_callback(GtkTreeModel* model, int column, const char* key,
                                               GtkTreeIter* iter, void* data)
{
  auto the_slot = static_cast<Gtk::TreeView::SlotSearchEqual*>(data);

  try
  {
    return (*the_slot)(Glib::wrap(model, true), column, key, Gtk::TreeModel::const_iterator(model, iter));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  return 0; // arbitrary value
}

static void SignalProxy_SearchEqual_gtk_callback_destroy(void* data)
{
  delete static_cast<Gtk::TreeView::SlotSearchEqual*>(data);
}

static gboolean SignalProxy_ColumnDrop_gtk_callback(GtkTreeView* tree_view, GtkTreeViewColumn* column,
                                              GtkTreeViewColumn* prev_column,
                                              GtkTreeViewColumn* next_column, void* data)
{
  auto the_slot = static_cast<Gtk::TreeView::SlotColumnDrop*>(data);

  try
  {
    return (*the_slot)(Glib::wrap(tree_view), Glib::wrap(column),
                         Glib::wrap(prev_column), Glib::wrap(next_column));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  return 0; // arbitrary value
}

static void SignalProxy_ColumnDrop_gtk_callback_destroy(void* data)
{
  delete static_cast<Gtk::TreeView::SlotColumnDrop*>(data);
}

namespace Gtk
{

int TreeView::insert_column_with_data_func(int position, const Glib::ustring& title, CellRenderer& cell, const SlotTreeCellData& slot)
{
  //Create a copy of the slot. A pointer to this will be passed through the callback's data parameter.
  //It will be deleted when TreeView_Private::SignalProxy_CellData_gtk_callback_destroy() is called.
  auto slot_copy = new SlotTreeCellData(slot);

  return gtk_tree_view_insert_column_with_data_func(
      gobj(), position, title.c_str(), cell.gobj(),
      &TreeView_Private::SignalProxy_CellData_gtk_callback, slot_copy,
      &TreeView_Private::SignalProxy_CellData_gtk_callback_destroy);
}

void TreeView::set_cursor(const TreeModel::Path& path)
{
  gtk_tree_view_set_cursor(gobj(), const_cast<GtkTreePath*>(path.gobj()), nullptr, false);
}

void TreeView::get_cursor(TreeModel::Path& path, TreeViewColumn*& focus_column)
{
  GtkTreePath* pTreePath = nullptr;
  GtkTreeViewColumn* pTreeViewColumn = nullptr;
  gtk_tree_view_get_cursor(gobj(), &pTreePath, &pTreeViewColumn);

  path = TreeModel::Path(pTreePath, false); /* Use the existing underlying GtkTreePath instance without copying and freeing, because gtk_tree_view_get_cursor() gives us ownernship. */
  focus_column = Glib::wrap(pTreeViewColumn);
}

void TreeView::enable_model_drag_source(Gdk::ModifierType start_button_mask, Gdk::DragAction actions)
{
  enable_model_drag_source(Gdk::ContentFormats::create(GTK_TYPE_TREE_ROW_DATA), start_button_mask, actions);
}

void TreeView::enable_model_drag_dest(Gdk::DragAction actions)
{
  enable_model_drag_dest(Gdk::ContentFormats::create(GTK_TYPE_TREE_ROW_DATA), actions);
}

bool TreeView::get_path_at_pos(int x, int y, TreeModel::Path& path, TreeViewColumn*& column, int& cell_x, int& cell_y) const
{
  GtkTreePath* pTreePath = nullptr;
  GtkTreeViewColumn* pTreeViewColumn = nullptr;
  const bool result = gtk_tree_view_get_path_at_pos(const_cast<GtkTreeView*>(gobj()), x, y, &pTreePath, &pTreeViewColumn, &cell_x, &cell_y);

  path = TreeModel::Path(pTreePath, false /* don't take a copy, because the gtk_tree_view_get_path_at_pos() docs say that we must free the path */ );
  column = Glib::wrap(pTreeViewColumn);
  return result;
}

bool TreeView::get_path_at_pos(int x, int y, TreeModel::Path& path) const
{
  GtkTreePath* pTreePath = nullptr;
  const bool result = gtk_tree_view_get_path_at_pos(const_cast<GtkTreeView*>(gobj()), x, y, &pTreePath, nullptr, nullptr, nullptr);

  path = TreeModel::Path(pTreePath, false /* don't take a copy, because the gtk_tree_view_get_path_at_pos() docs say that we must free the path */ );
  return result;
}

int TreeView::insert_column(const Glib::ustring& title, CellRenderer& cell, int position)
{
  return gtk_tree_view_insert_column_with_attributes(
      gobj(), position, const_cast<char*>(title.c_str()), cell.gobj(), nullptr);
}

int TreeView::append_column(const Glib::ustring& title, CellRenderer& cell)
{
  return insert_column(title, cell, -1 /* at the end */);
}

void TreeView::get_drag_dest_row(TreeModel::Path& path, DropPosition& pos) const
{
  GtkTreePath* pTreePath = nullptr;
  gtk_tree_view_get_drag_dest_row(const_cast<GtkTreeView*>(gobj()), &pTreePath, (GtkTreeViewDropPosition*) &pos);
  path = TreeModel::Path(pTreePath, true); //true = take_copy.
}

bool TreeView::get_dest_row_at_pos(int drag_x, int drag_y, TreeModel::Path& path, DropPosition& pos) const
{
  GtkTreePath* pTreePath = nullptr;
  const bool bResult = gtk_tree_view_get_dest_row_at_pos(
      const_cast<GtkTreeView*>(gobj()), drag_x, drag_y, &pTreePath, (GtkTreeViewDropPosition*) &pos);

  path = TreeModel::Path(pTreePath, true); //true = take_copy.
  return bResult;
}

void TreeView::map_expanded_rows(const SlotMapping& slot)
{
  gtk_tree_view_map_expanded_rows(gobj(), &SignalProxy_Mapping_gtk_callback, const_cast<SlotMapping*>(&slot));
}

void TreeView::set_search_equal_func(const SlotSearchEqual& slot)
{
  //Create a copy of the slot. A pointer to this will be passed through the callback's data parameter.
  //It will be deleted when SignalProxy_SearchEqual_gtk_callback_destroy() is called.
  auto slot_copy = new SlotSearchEqual(slot);

  gtk_tree_view_set_search_equal_func(gobj(),
      &SignalProxy_SearchEqual_gtk_callback, slot_copy,
      &SignalProxy_SearchEqual_gtk_callback_destroy);
}

void TreeView::set_column_drag_function(const SlotColumnDrop& slot)
{
  //Create a copt of the slot. A pointer to this will be passed through the callback's data parameter.
  //It will be deleted when SignalProxy_ColumnDrop_gtk_callback_destroy() is called.
  auto slot_copy = new SlotColumnDrop(slot);

  gtk_tree_view_set_column_drag_function(gobj(),
      &SignalProxy_ColumnDrop_gtk_callback, slot_copy,
      &SignalProxy_ColumnDrop_gtk_callback_destroy);

}

void TreeView::unset_column_drag_function()
{
  gtk_tree_view_set_column_drag_function(gobj(),
      nullptr, nullptr, nullptr); /* See GTK+ docs about the nullptrs. */
}

void TreeView::scroll_to_cell(const TreeModel::Path& path, TreeViewColumn& column, float row_align, float col_align)
{
  gtk_tree_view_scroll_to_cell(gobj(), const_cast<GtkTreePath*>(path.gobj()), column.gobj(), TRUE, row_align, col_align);
}

void TreeView::scroll_to_cell(const TreeModel::Path& path, TreeViewColumn& column)
{
  gtk_tree_view_scroll_to_cell(gobj(), const_cast<GtkTreePath*>(path.gobj()), column.gobj(), FALSE, 0.0, 0.0);
}

void TreeView::scroll_to_row(const TreeModel::Path& path, float row_align)
{
  gtk_tree_view_scroll_to_cell(gobj(), const_cast<GtkTreePath*>(path.gobj()), nullptr, TRUE, row_align, 0.0);
}

void TreeView::scroll_to_row(const TreeModel::Path& path)
{
  gtk_tree_view_scroll_to_cell(gobj(), const_cast<GtkTreePath*>(path.gobj()), nullptr, FALSE, 0.0, 0.0);
}

void TreeView::scroll_to_column(TreeViewColumn& column, float col_align)
{
  gtk_tree_view_scroll_to_cell(gobj(), nullptr, column.gobj(), TRUE, 0.0, col_align);
}

void TreeView::scroll_to_column(TreeViewColumn& column)
{
  gtk_tree_view_scroll_to_cell(gobj(), nullptr, column.gobj(), FALSE, 0.0, 0.0);
}

void TreeView::remove_all_columns()
{
  //This method is not in GTK+, but it seems useful.

  //Remove all View columns:
  std::vector<Gtk::TreeView::Column*> vecViewColumns (get_columns());

  for (std::vector<Gtk::TreeView::Column*>::iterator iter (vecViewColumns.begin ()), columns_end (vecViewColumns.end ());
    iter != columns_end;
    ++iter)
  {
    Gtk::TreeView::Column* pViewColumn (*iter);

    if(pViewColumn)
    {
      remove_column(*pViewColumn);
    }
  }
}


CellRenderer* TreeView::get_column_cell_renderer(int n)
{
  auto pColumn = get_column(n);
  if(pColumn)
    return pColumn->get_first_cell();
  else
    return nullptr;
}


const CellRenderer* TreeView::get_column_cell_renderer(int n) const
{
   //Do some const_cast-ing to avoid repetition of code:
  auto pRenderer = const_cast<TreeView*>(this)->get_column_cell_renderer(n);
  return pRenderer;
}

void TreeView::reset_expander_column()
{
  gtk_tree_view_set_expander_column(gobj(), nullptr /* see C docs */);
}

void TreeView::_auto_store_on_cellrenderer_toggle_edited_with_model(const Glib::ustring& path_string,
                                                         int model_column, const Glib::RefPtr<Gtk::TreeModel>& model)
{
  Gtk::TreePath path (path_string);

  //Get the row from the path:
  if(model)
  {
    auto iter = model->get_iter(path);
    if(iter)
    {
      auto row = *iter;

      //Get the new value:
      //This seems to get the old value, not the new one,
      //so we will just NOT the model value ourselves.
      //bool bActive = cell_renderer->get_active();
      bool bActive = false;
      row.get_value(model_column, bActive);
      bActive = !bActive;

      //Store the user's new text in the model:
      row.set_value(model_column, bActive);
    }
  }
}

void TreeView::move_column_to_start(TreeViewColumn& column)
{
  gtk_tree_view_move_column_after(gobj(), (column).gobj(), nullptr /* See C docs */);
}

void TreeView::set_row_separator_func(const SlotRowSeparator& slot)
{
  //Create a copy of the slot. A pointer to this will be passed through the callback's data parameter.
  //It will be deleted when SignalProxy_RowSeparator_gtk_callback_destroy() is called.
  auto slot_copy = new SlotRowSeparator(slot);

  gtk_tree_view_set_row_separator_func(gobj(),
      &TreeView_Private::SignalProxy_RowSeparator_gtk_callback, slot_copy,
      &TreeView_Private::SignalProxy_RowSeparator_gtk_callback_destroy);
}

bool TreeView::get_visible_range(TreeModel::Path& start_path, TreeModel::Path& end_path) const
{
  GtkTreePath* pTreePathStart = nullptr;
  GtkTreePath* pTreePathEnd = nullptr;
  bool result = gtk_tree_view_get_visible_range(const_cast<GtkTreeView*>(gobj()), &pTreePathStart, &pTreePathEnd);

  start_path = TreeModel::Path(pTreePathStart, false /* don't take a copy, because the gtk_tree_view_get_visible_range() docs say that we must free the path */ );
  end_path = TreeModel::Path(pTreePathEnd, false /* don't take a copy, because the gtk_tree_view_get_visible_range() docs say that we must free the path */ );
  return result;
}

void TreeView::unset_model()
{
  gtk_tree_view_set_model(gobj(), nullptr);
}

bool
TreeView::get_tooltip_context_path(int x, int y,
                                   bool keyboard_tip,
                                   TreeModel::Path& path)
{
  GtkTreePath* cpath = nullptr;

  gboolean result =
    gtk_tree_view_get_tooltip_context(gobj(),
                                      x, y,
                                      keyboard_tip,
                                      nullptr,
                                      &cpath,
                                      nullptr);

  //If result is false, cpath is not modified, it's still nullptr.
  //wrap() can handle that situation.
  path = Glib::wrap(cpath, false /* take_copy=false */);

  return result;
}

bool
TreeView::get_tooltip_context_iter(int x, int y,
                                   bool keyboard_tip,
                                   Gtk::TreeModel::iterator& iter)
{
  GtkTreeIter src_iter;

  gboolean result =
    gtk_tree_view_get_tooltip_context(gobj(),
                                      x, y,
                                      keyboard_tip,
                                      nullptr,
                                      nullptr,
                                      &src_iter);

  iter = TreeModel::iterator(gtk_tree_view_get_model(this->gobj()), &src_iter);

  return result;
}

bool TreeView::is_blank_at_pos(int x, int y, TreePath& path, TreeViewColumn*& column, int& cell_x, int& cell_y) const
{
  GtkTreePath* cpath = nullptr;
  GtkTreeViewColumn* pcolumn = nullptr;
  const bool result = gtk_tree_view_is_blank_at_pos(const_cast<GtkTreeView*>(gobj()), x, y, &cpath, &pcolumn, &(cell_x), &(cell_y));

  path = TreePath(cpath, false /* take ownership instead of taking a copy */);
  column = Glib::wrap(pcolumn);
  return result;
}

bool TreeView::is_blank_at_pos(int x, int y) const
{
  return gtk_tree_view_is_blank_at_pos(const_cast<GtkTreeView*>(gobj()), x, y, nullptr, nullptr, nullptr, nullptr);
}

void TreeView::unset_drag_dest_row()
{
  // The C docs specify that a 0 path means unset.
  gtk_tree_view_set_drag_dest_row(gobj(), nullptr, GTK_TREE_VIEW_DROP_BEFORE /* Arbitrary. Ignored anyway. */);
}

void TreeView::unset_row_separator_func()
{
  gtk_tree_view_set_row_separator_func(gobj(), nullptr, nullptr, nullptr);
}

namespace TreeView_Private
{
// Specializations of _connect_auto_store_editable_signal_handler()

//bool specialization:
template<>
void _connect_auto_store_editable_signal_handler<bool>(Gtk::TreeView* this_p,
  Gtk::CellRenderer* pCellRenderer, const Gtk::TreeModelColumn<bool>& model_column)
{
  Gtk::CellRendererToggle* pCellToggle = dynamic_cast<Gtk::CellRendererToggle*>(pCellRenderer);
  if(pCellToggle)
  {
    //Set the appropriate property,
    pCellToggle->property_activatable() = true;

    //Connect to the appropriate signal, sending the model_column too

    sigc::slot<void(const Glib::ustring&, int)> slot_temp =
      sigc::bind<-1>(
        sigc::mem_fun(*this_p, &Gtk::TreeView::_auto_store_on_cellrenderer_toggle_edited_with_model),
        this_p->get_model()
      );

    pCellToggle->signal_toggled().connect(
      sigc::bind<-1>(
        slot_temp,
        model_column.index()
      )
    );

    //We use bind<-1> instead of bind because some compilers need the extra hint.
  }
}

//int specialization:
template<>
void _connect_auto_store_editable_signal_handler<int>(Gtk::TreeView* this_p,
  Gtk::CellRenderer* pCellRenderer, const Gtk::TreeModelColumn<int>& model_column)
{
  _connect_auto_store_numeric_editable_signal_handler<int>(this_p, pCellRenderer, model_column);
}

//unsigned int specialization:
template<>
void _connect_auto_store_editable_signal_handler<unsigned int>(Gtk::TreeView* this_p,
  Gtk::CellRenderer* pCellRenderer, const Gtk::TreeModelColumn<unsigned int>& model_column)
{
  _connect_auto_store_numeric_editable_signal_handler<unsigned int>(this_p, pCellRenderer, model_column);
}

//long specialization:
template<>
void _connect_auto_store_editable_signal_handler<long>(Gtk::TreeView* this_p,
  Gtk::CellRenderer* pCellRenderer, const Gtk::TreeModelColumn<long>& model_column)
{
  _connect_auto_store_numeric_editable_signal_handler<long>(this_p, pCellRenderer, model_column);
}

//unsigned long specialization:
template<>
void _connect_auto_store_editable_signal_handler<unsigned long>(Gtk::TreeView* this_p,
  Gtk::CellRenderer* pCellRenderer, const Gtk::TreeModelColumn<unsigned long>& model_column)
{
  _connect_auto_store_numeric_editable_signal_handler<unsigned long>(this_p, pCellRenderer, model_column);
}

//float specialization:
template<>
void _connect_auto_store_editable_signal_handler<float>(Gtk::TreeView* this_p,
  Gtk::CellRenderer* pCellRenderer, const Gtk::TreeModelColumn<float>& model_column)
{
  _connect_auto_store_numeric_editable_signal_handler<float>(this_p, pCellRenderer, model_column);
}

//double specialization:
template<>
void _connect_auto_store_editable_signal_handler<double>(Gtk::TreeView* this_p,
  Gtk::CellRenderer* pCellRenderer, const Gtk::TreeModelColumn<double>& model_column)
{
  _connect_auto_store_numeric_editable_signal_handler<double>(this_p, pCellRenderer, model_column);
}

// Specializations of _convert_from_ustring_to_numeric_type()

// Floating point specializations
template<>
float _convert_from_ustring_to_numeric_type<float>(const Glib::ustring& text)
{
  return std::strtof(text.c_str(), nullptr);
}

template<>
long double _convert_from_ustring_to_numeric_type<long double>(const Glib::ustring& text)
{
  return std::strtold(text.c_str(), nullptr);
}

// Integral specializations
template<>
short _convert_from_ustring_to_numeric_type<short>(const Glib::ustring& text)
{
  const auto result = std::strtol(text.c_str(), nullptr, 0);
  return (result < SHRT_MIN) ? SHRT_MIN :
        ((result > SHRT_MAX) ? SHRT_MAX : static_cast<short>(result));
}

template<>
unsigned short _convert_from_ustring_to_numeric_type<unsigned short>(const Glib::ustring& text)
{
  const auto result = std::strtoul(text.c_str(), nullptr, 0);
  return (result > USHRT_MAX) ? USHRT_MAX : static_cast<unsigned short>(result);
}

template<>
int _convert_from_ustring_to_numeric_type<int>(const Glib::ustring& text)
{
  const auto result = std::strtol(text.c_str(), nullptr, 0);
  return (result < INT_MIN) ? INT_MIN :
        ((result > INT_MAX) ? INT_MAX : static_cast<int>(result));
}

template<>
unsigned int _convert_from_ustring_to_numeric_type<unsigned int>(const Glib::ustring& text)
{
  const auto result = std::strtoul(text.c_str(), nullptr, 0);
  return (result > UINT_MAX) ? UINT_MAX : static_cast<unsigned int>(result);
}

template<>
long _convert_from_ustring_to_numeric_type<long>(const Glib::ustring& text)
{
  return std::strtol(text.c_str(), nullptr, 0);
}

template<>
unsigned long _convert_from_ustring_to_numeric_type<unsigned long>(const Glib::ustring& text)
{
  return std::strtoul(text.c_str(), nullptr, 0);
}

template<>
long long _convert_from_ustring_to_numeric_type<long long>(const Glib::ustring& text)
{
  return std::strtoll(text.c_str(), nullptr, 0);
}

template<>
unsigned long long _convert_from_ustring_to_numeric_type<unsigned long long>(const Glib::ustring& text)
{
  return std::strtoull(text.c_str(), nullptr, 0);
}

} // namespace TreeView_Private

} // namespace Gtk

namespace
{


static void TreeView_signal_row_activated_callback(GtkTreeView* self, GtkTreePath* p0,GtkTreeViewColumn* p1,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(const TreeModel::Path&, TreeViewColumn*)>;

  auto obj = dynamic_cast<TreeView*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gtk::TreePath(p0, true)
, Glib::wrap(p1)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo TreeView_signal_row_activated_info =
{
  "row-activated",
  (GCallback) &TreeView_signal_row_activated_callback,
  (GCallback) &TreeView_signal_row_activated_callback
};


static gboolean TreeView_signal_test_expand_row_callback(GtkTreeView* self, GtkTreeIter* p0,GtkTreePath* p1,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(const TreeModel::iterator&, const TreeModel::Path&)>;

  auto obj = dynamic_cast<TreeView*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(TreeModel::iterator(gtk_tree_view_get_model(self), p0)
, Gtk::TreePath(p1, true)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean TreeView_signal_test_expand_row_notify_callback(GtkTreeView* self, GtkTreeIter* p0,GtkTreePath* p1, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(const TreeModel::iterator&, const TreeModel::Path&)>;

  auto obj = dynamic_cast<TreeView*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(TreeModel::iterator(gtk_tree_view_get_model(self), p0)
, Gtk::TreePath(p1, true)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo TreeView_signal_test_expand_row_info =
{
  "test-expand-row",
  (GCallback) &TreeView_signal_test_expand_row_callback,
  (GCallback) &TreeView_signal_test_expand_row_notify_callback
};


static gboolean TreeView_signal_test_collapse_row_callback(GtkTreeView* self, GtkTreeIter* p0,GtkTreePath* p1,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(const TreeModel::iterator&, const TreeModel::Path&)>;

  auto obj = dynamic_cast<TreeView*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(TreeModel::iterator(gtk_tree_view_get_model(self), p0)
, Gtk::TreePath(p1, true)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean TreeView_signal_test_collapse_row_notify_callback(GtkTreeView* self, GtkTreeIter* p0,GtkTreePath* p1, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(const TreeModel::iterator&, const TreeModel::Path&)>;

  auto obj = dynamic_cast<TreeView*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(TreeModel::iterator(gtk_tree_view_get_model(self), p0)
, Gtk::TreePath(p1, true)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo TreeView_signal_test_collapse_row_info =
{
  "test-collapse-row",
  (GCallback) &TreeView_signal_test_collapse_row_callback,
  (GCallback) &TreeView_signal_test_collapse_row_notify_callback
};


static void TreeView_signal_row_expanded_callback(GtkTreeView* self, GtkTreeIter* p0,GtkTreePath* p1,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(const TreeModel::iterator&, const TreeModel::Path&)>;

  auto obj = dynamic_cast<TreeView*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(TreeModel::iterator(gtk_tree_view_get_model(self), p0)
, Gtk::TreePath(p1, true)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo TreeView_signal_row_expanded_info =
{
  "row-expanded",
  (GCallback) &TreeView_signal_row_expanded_callback,
  (GCallback) &TreeView_signal_row_expanded_callback
};


static void TreeView_signal_row_collapsed_callback(GtkTreeView* self, GtkTreeIter* p0,GtkTreePath* p1,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(const TreeModel::iterator&, const TreeModel::Path&)>;

  auto obj = dynamic_cast<TreeView*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(TreeModel::iterator(gtk_tree_view_get_model(self), p0)
, Gtk::TreePath(p1, true)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo TreeView_signal_row_collapsed_info =
{
  "row-collapsed",
  (GCallback) &TreeView_signal_row_collapsed_callback,
  (GCallback) &TreeView_signal_row_collapsed_callback
};


static const Glib::SignalProxyInfo TreeView_signal_cursor_changed_info =
{
  "cursor-changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo TreeView_signal_columns_changed_info =
{
  "columns-changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


} // anonymous namespace

// static
GType Glib::Value<Gtk::TreeView::DropPosition>::value_type()
{
  return gtk_tree_view_drop_position_get_type();
}

// static
GType Glib::Value<Gtk::TreeView::GridLines>::value_type()
{
  return gtk_tree_view_grid_lines_get_type();
}


namespace Glib
{

Gtk::TreeView* wrap(GtkTreeView* object, bool take_copy)
{
  return dynamic_cast<Gtk::TreeView *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& TreeView_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &TreeView_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_tree_view_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  Scrollable::add_interface(get_type());

  }

  return *this;
}


void TreeView_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


}


Glib::ObjectBase* TreeView_Class::wrap_new(GObject* o)
{
  return manage(new TreeView((GtkTreeView*)(o)));

}


/* The implementation: */

TreeView::TreeView(const Glib::ConstructParams& construct_params)
:
  Gtk::Widget(construct_params)
{
  }

TreeView::TreeView(GtkTreeView* castitem)
:
  Gtk::Widget((GtkWidget*)(castitem))
{
  }


TreeView::TreeView(TreeView&& src) noexcept
: Gtk::Widget(std::move(src))
  , Scrollable(std::move(src))
{}

TreeView& TreeView::operator=(TreeView&& src) noexcept
{
  Gtk::Widget::operator=(std::move(src));
  Scrollable::operator=(std::move(src));
  return *this;
}

TreeView::~TreeView() noexcept
{
  destroy_();
}

TreeView::CppClassType TreeView::treeview_class_; // initialize static member

GType TreeView::get_type()
{
  return treeview_class_.init().get_type();
}


GType TreeView::get_base_type()
{
  return gtk_tree_view_get_type();
}


TreeView::TreeView()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Gtk::Widget(Glib::ConstructParams(treeview_class_.init()))
{
  

}

TreeView::TreeView(const Glib::RefPtr<TreeModel>& model)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Gtk::Widget(Glib::ConstructParams(treeview_class_.init(), "model", Glib::unwrap(model), nullptr))
{
  

}

Glib::RefPtr<TreeModel> TreeView::get_model()
{
  auto retvalue = Glib::wrap(gtk_tree_view_get_model(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const TreeModel> TreeView::get_model() const
{
  auto retvalue = Glib::wrap(gtk_tree_view_get_model(const_cast<GtkTreeView*>(gobj())));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

void TreeView::set_model(const Glib::RefPtr<TreeModel>& model)
{
  gtk_tree_view_set_model(gobj(), Glib::unwrap(model));
}

Glib::RefPtr<TreeSelection> TreeView::get_selection()
{
  auto retvalue = Glib::wrap(gtk_tree_view_get_selection(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const TreeSelection> TreeView::get_selection() const
{
  return const_cast<TreeView*>(this)->get_selection();
}

bool TreeView::get_headers_visible() const
{
  return gtk_tree_view_get_headers_visible(const_cast<GtkTreeView*>(gobj()));
}

void TreeView::set_headers_visible(bool headers_visible)
{
  gtk_tree_view_set_headers_visible(gobj(), static_cast<int>(headers_visible));
}

void TreeView::columns_autosize()
{
  gtk_tree_view_columns_autosize(gobj());
}

bool TreeView::get_headers_clickable() const
{
  return gtk_tree_view_get_headers_clickable(const_cast<GtkTreeView*>(gobj()));
}

void TreeView::set_headers_clickable(bool setting)
{
  gtk_tree_view_set_headers_clickable(gobj(), static_cast<int>(setting));
}

void TreeView::set_activate_on_single_click(bool single)
{
  gtk_tree_view_set_activate_on_single_click(gobj(), static_cast<int>(single));
}

bool TreeView::get_activate_on_single_click() const
{
  return gtk_tree_view_get_activate_on_single_click(const_cast<GtkTreeView*>(gobj()));
}

int TreeView::append_column(TreeViewColumn& column)
{
  return gtk_tree_view_append_column(gobj(), (column).gobj());
}

int TreeView::remove_column(TreeViewColumn& column)
{
  return gtk_tree_view_remove_column(gobj(), (column).gobj());
}

int TreeView::insert_column(TreeViewColumn& column, int position)
{
  return gtk_tree_view_insert_column(gobj(), (column).gobj(), position);
}

guint TreeView::get_n_columns() const
{
  return gtk_tree_view_get_n_columns(const_cast<GtkTreeView*>(gobj()));
}

TreeViewColumn* TreeView::get_column(int n)
{
  return Glib::wrap(gtk_tree_view_get_column(gobj(), n));
}

const TreeViewColumn* TreeView::get_column(int n) const
{
  return const_cast<TreeView*>(this)->get_column(n);
}

std::vector<TreeViewColumn*> TreeView::get_columns()
{
  return Glib::ListHandler<TreeViewColumn*>::list_to_vector(gtk_tree_view_get_columns(gobj()), Glib::OWNERSHIP_SHALLOW);
}

std::vector<const TreeViewColumn*> TreeView::get_columns() const
{
  return Glib::ListHandler<const TreeViewColumn*>::list_to_vector(gtk_tree_view_get_columns(const_cast<GtkTreeView*>(gobj())), Glib::OWNERSHIP_SHALLOW);
}

void TreeView::move_column_after(TreeViewColumn& column, TreeViewColumn& base_column)
{
  gtk_tree_view_move_column_after(gobj(), (column).gobj(), (base_column).gobj());
}

void TreeView::set_expander_column(TreeViewColumn& column)
{
  gtk_tree_view_set_expander_column(gobj(), (column).gobj());
}

TreeViewColumn* TreeView::get_expander_column()
{
  return Glib::wrap(gtk_tree_view_get_expander_column(gobj()));
}

const TreeViewColumn* TreeView::get_expander_column() const
{
  return const_cast<TreeView*>(this)->get_expander_column();
}

void TreeView::scroll_to_point(int tree_x, int tree_y)
{
  gtk_tree_view_scroll_to_point(gobj(), tree_x, tree_y);
}

void TreeView::row_activated(const TreeModel::Path& path, TreeViewColumn& column)
{
  gtk_tree_view_row_activated(gobj(), const_cast<GtkTreePath*>((path).gobj()), (column).gobj());
}

void TreeView::expand_all()
{
  gtk_tree_view_expand_all(gobj());
}

void TreeView::collapse_all()
{
  gtk_tree_view_collapse_all(gobj());
}

void TreeView::expand_to_path(const TreeModel::Path& path)
{
  gtk_tree_view_expand_to_path(gobj(), const_cast<GtkTreePath*>((path).gobj()));
}

bool TreeView::expand_row(const TreeModel::Path& path, bool open_all)
{
  return gtk_tree_view_expand_row(gobj(), const_cast<GtkTreePath*>((path).gobj()), static_cast<int>(open_all));
}

bool TreeView::collapse_row(const TreeModel::Path& path)
{
  return gtk_tree_view_collapse_row(gobj(), const_cast<GtkTreePath*>((path).gobj()));
}

bool TreeView::row_expanded(const TreeModel::Path& path)
{
  return gtk_tree_view_row_expanded(gobj(), const_cast<GtkTreePath*>((path).gobj()));
}

void TreeView::set_reorderable(bool reorderable)
{
  gtk_tree_view_set_reorderable(gobj(), static_cast<int>(reorderable));
}

bool TreeView::get_reorderable() const
{
  return gtk_tree_view_get_reorderable(const_cast<GtkTreeView*>(gobj()));
}

void TreeView::set_cursor(const TreeModel::Path& path, TreeViewColumn& focus_column, bool start_editing)
{
  gtk_tree_view_set_cursor(gobj(), const_cast<GtkTreePath*>((path).gobj()), (focus_column).gobj(), static_cast<int>(start_editing));
}

void TreeView::set_cursor(const TreeModel::Path& path, TreeViewColumn& focus_column, CellRenderer& focus_cell, bool start_editing)
{
  gtk_tree_view_set_cursor_on_cell(gobj(), const_cast<GtkTreePath*>((path).gobj()), (focus_column).gobj(), (focus_cell).gobj(), static_cast<int>(start_editing));
}

void TreeView::get_cell_area(const TreeModel::Path& path, TreeViewColumn& column, Gdk::Rectangle& rect) const
{
  gtk_tree_view_get_cell_area(const_cast<GtkTreeView*>(gobj()), const_cast<GtkTreePath*>((path).gobj()), (column).gobj(), (rect).gobj());
}

void TreeView::get_background_area(const TreeModel::Path& path, TreeViewColumn& column, Gdk::Rectangle& rect) const
{
  gtk_tree_view_get_background_area(const_cast<GtkTreeView*>(gobj()), const_cast<GtkTreePath*>((path).gobj()), (column).gobj(), (rect).gobj());
}

void TreeView::get_visible_rect(Gdk::Rectangle& visible_rect) const
{
  gtk_tree_view_get_visible_rect(const_cast<GtkTreeView*>(gobj()), (visible_rect).gobj());
}

void TreeView::enable_model_drag_source(const Glib::RefPtr<const Gdk::ContentFormats>& formats, Gdk::ModifierType start_button_mask, Gdk::DragAction actions)
{
  gtk_tree_view_enable_model_drag_source(gobj(), static_cast<GdkModifierType>(start_button_mask), const_cast<GdkContentFormats*>(Glib::unwrap(formats)), static_cast<GdkDragAction>(actions));
}

void TreeView::enable_model_drag_dest(const Glib::RefPtr<const Gdk::ContentFormats>& formats, Gdk::DragAction actions)
{
  gtk_tree_view_enable_model_drag_dest(gobj(), const_cast<GdkContentFormats*>(Glib::unwrap(formats)), static_cast<GdkDragAction>(actions));
}

void TreeView::unset_rows_drag_source()
{
  gtk_tree_view_unset_rows_drag_source(gobj());
}

void TreeView::unset_rows_drag_dest()
{
  gtk_tree_view_unset_rows_drag_dest(gobj());
}

void TreeView::set_drag_dest_row(const TreeModel::Path& path, DropPosition pos)
{
  gtk_tree_view_set_drag_dest_row(gobj(), const_cast<GtkTreePath*>((path).gobj()), static_cast<GtkTreeViewDropPosition>(pos));
}

Glib::RefPtr<Gdk::Paintable> TreeView::create_row_drag_icon(const TreeModel::Path& path) const
{
  return Glib::wrap(gtk_tree_view_create_row_drag_icon(const_cast<GtkTreeView*>(gobj()), const_cast<GtkTreePath*>((path).gobj())));
}

void TreeView::set_enable_search(bool enable_search)
{
  gtk_tree_view_set_enable_search(gobj(), static_cast<int>(enable_search));
}

bool TreeView::get_enable_search() const
{
  return gtk_tree_view_get_enable_search(const_cast<GtkTreeView*>(gobj()));
}

int TreeView::get_search_column() const
{
  return gtk_tree_view_get_search_column(const_cast<GtkTreeView*>(gobj()));
}

void TreeView::set_search_column(const TreeModelColumnBase& column)
{
  gtk_tree_view_set_search_column(gobj(), (column).index());
}

void TreeView::set_search_column(int column)
{
  gtk_tree_view_set_search_column(gobj(), column);
}

Editable* TreeView::get_search_entry()
{
  return dynamic_cast<Editable*>(Glib::wrap_auto((GObject*)(gtk_tree_view_get_search_entry(gobj())), false));
}

const Editable* TreeView::get_search_entry() const
{
  return const_cast<TreeView*>(this)->get_search_entry();
}

void TreeView::set_search_entry(Editable& entry)
{
  gtk_tree_view_set_search_entry(gobj(), (entry).gobj());
}

void TreeView::convert_widget_to_tree_coords(int wx, int wy, int& tx, int& ty) const
{
  gtk_tree_view_convert_widget_to_tree_coords(const_cast<GtkTreeView*>(gobj()), wx, wy, &(tx), &(ty));
}

void TreeView::convert_tree_to_widget_coords(int tx, int ty, int& wx, int& wy) const
{
  gtk_tree_view_convert_tree_to_widget_coords(const_cast<GtkTreeView*>(gobj()), tx, ty, &(wx), &(wy));
}

void TreeView::convert_widget_to_bin_window_coords(int wx, int wy, int& bx, int& by) const
{
  gtk_tree_view_convert_widget_to_bin_window_coords(const_cast<GtkTreeView*>(gobj()), wx, wy, &(bx), &(by));
}

void TreeView::convert_bin_window_to_widget_coords(int bx, int by, int& wx, int& wy) const
{
  gtk_tree_view_convert_bin_window_to_widget_coords(const_cast<GtkTreeView*>(gobj()), bx, by, &(wx), &(wy));
}

void TreeView::convert_tree_to_bin_window_coords(int tx, int ty, int& bx, int& by) const
{
  gtk_tree_view_convert_tree_to_bin_window_coords(const_cast<GtkTreeView*>(gobj()), tx, ty, &(bx), &(by));
}

void TreeView::convert_bin_window_to_tree_coords(int bx, int by, int& tx, int& ty) const
{
  gtk_tree_view_convert_bin_window_to_tree_coords(const_cast<GtkTreeView*>(gobj()), bx, by, &(tx), &(ty));
}

void TreeView::set_fixed_height_mode(bool enable)
{
  gtk_tree_view_set_fixed_height_mode(gobj(), static_cast<int>(enable));
}

bool TreeView::get_fixed_height_mode() const
{
  return gtk_tree_view_get_fixed_height_mode(const_cast<GtkTreeView*>(gobj()));
}

void TreeView::set_hover_selection(bool hover)
{
  gtk_tree_view_set_hover_selection(gobj(), static_cast<int>(hover));
}

bool TreeView::get_hover_selection() const
{
  return gtk_tree_view_get_hover_selection(const_cast<GtkTreeView*>(gobj()));
}

void TreeView::set_hover_expand(bool expand)
{
  gtk_tree_view_set_hover_expand(gobj(), static_cast<int>(expand));
}

bool TreeView::get_hover_expand() const
{
  return gtk_tree_view_get_hover_expand(const_cast<GtkTreeView*>(gobj()));
}

void TreeView::set_rubber_banding(bool enable)
{
  gtk_tree_view_set_rubber_banding(gobj(), static_cast<int>(enable));
}

bool TreeView::get_rubber_banding() const
{
  return gtk_tree_view_get_rubber_banding(const_cast<GtkTreeView*>(gobj()));
}

bool TreeView::is_rubber_banding_active() const
{
  return gtk_tree_view_is_rubber_banding_active(const_cast<GtkTreeView*>(gobj()));
}

void TreeView::set_grid_lines(GridLines grid_lines)
{
  gtk_tree_view_set_grid_lines(gobj(), static_cast<GtkTreeViewGridLines>(grid_lines));
}

GridLines TreeView::get_grid_lines() const
{
  return static_cast<GridLines>(gtk_tree_view_get_grid_lines(const_cast<GtkTreeView*>(gobj())));
}

void TreeView::set_enable_tree_lines(bool enable)
{
  gtk_tree_view_set_enable_tree_lines(gobj(), static_cast<int>(enable));
}

bool TreeView::get_enable_tree_lines() const
{
  return gtk_tree_view_get_enable_tree_lines(const_cast<GtkTreeView*>(gobj()));
}

void TreeView::set_show_expanders(bool enabled)
{
  gtk_tree_view_set_show_expanders(gobj(), static_cast<int>(enabled));
}

bool TreeView::get_show_expanders() const
{
  return gtk_tree_view_get_show_expanders(const_cast<GtkTreeView*>(gobj()));
}

void TreeView::set_level_indentation(int indentation)
{
  gtk_tree_view_set_level_indentation(gobj(), indentation);
}

int TreeView::get_level_indentation() const
{
  return gtk_tree_view_get_level_indentation(const_cast<GtkTreeView*>(gobj()));
}

void TreeView::set_tooltip_row(const Glib::RefPtr<Tooltip>& tooltip, const TreePath& path)
{
  gtk_tree_view_set_tooltip_row(gobj(), Glib::unwrap(tooltip), const_cast<GtkTreePath*>((path).gobj()));
}

void TreeView::set_tooltip_cell(const Glib::RefPtr<Tooltip>& tooltip, const TreeModel::Path* path, TreeViewColumn* column, CellRenderer* cell)
{
  gtk_tree_view_set_tooltip_cell(gobj(), Glib::unwrap(tooltip), ((path) ? const_cast<GtkTreePath*>((path)->gobj()) : nullptr), (GtkTreeViewColumn*)Glib::unwrap(column), (GtkCellRenderer*)Glib::unwrap(cell));
}

void TreeView::set_tooltip_column(int column)
{
  gtk_tree_view_set_tooltip_column(gobj(), column);
}

int TreeView::get_tooltip_column() const
{
  return gtk_tree_view_get_tooltip_column(const_cast<GtkTreeView*>(gobj()));
}


Glib::SignalProxy<void(const TreeModel::Path&, TreeViewColumn*)> TreeView::signal_row_activated()
{
  return Glib::SignalProxy<void(const TreeModel::Path&, TreeViewColumn*) >(this, &TreeView_signal_row_activated_info);
}


Glib::SignalProxy<bool(const TreeModel::iterator&, const TreeModel::Path&)> TreeView::signal_test_expand_row()
{
  return Glib::SignalProxy<bool(const TreeModel::iterator&, const TreeModel::Path&) >(this, &TreeView_signal_test_expand_row_info);
}


Glib::SignalProxy<bool(const TreeModel::iterator&, const TreeModel::Path&)> TreeView::signal_test_collapse_row()
{
  return Glib::SignalProxy<bool(const TreeModel::iterator&, const TreeModel::Path&) >(this, &TreeView_signal_test_collapse_row_info);
}


Glib::SignalProxy<void(const TreeModel::iterator&, const TreeModel::Path&)> TreeView::signal_row_expanded()
{
  return Glib::SignalProxy<void(const TreeModel::iterator&, const TreeModel::Path&) >(this, &TreeView_signal_row_expanded_info);
}


Glib::SignalProxy<void(const TreeModel::iterator&, const TreeModel::Path&)> TreeView::signal_row_collapsed()
{
  return Glib::SignalProxy<void(const TreeModel::iterator&, const TreeModel::Path&) >(this, &TreeView_signal_row_collapsed_info);
}


Glib::SignalProxy<void()> TreeView::signal_cursor_changed()
{
  return Glib::SignalProxy<void() >(this, &TreeView_signal_cursor_changed_info);
}


Glib::SignalProxy<void()> TreeView::signal_columns_changed()
{
  return Glib::SignalProxy<void() >(this, &TreeView_signal_columns_changed_info);
}


static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<Glib::RefPtr<TreeModel>>::value,
  "Type Glib::RefPtr<TreeModel> cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy< Glib::RefPtr<TreeModel> > TreeView::property_model() 
{
  return Glib::PropertyProxy< Glib::RefPtr<TreeModel> >(this, "model");
}

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<TreeModel> > TreeView::property_model() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<TreeModel> >(this, "model");
}

Glib::PropertyProxy< bool > TreeView::property_headers_visible() 
{
  return Glib::PropertyProxy< bool >(this, "headers-visible");
}

Glib::PropertyProxy_ReadOnly< bool > TreeView::property_headers_visible() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "headers-visible");
}

Glib::PropertyProxy< bool > TreeView::property_headers_clickable() 
{
  return Glib::PropertyProxy< bool >(this, "headers-clickable");
}

Glib::PropertyProxy_ReadOnly< bool > TreeView::property_headers_clickable() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "headers-clickable");
}

static_assert(Glib::Traits::ValueCompatibleWithWrapProperty<TreeViewColumn*>::value,
  "Type TreeViewColumn* cannot be used in _WRAP_PROPERTY. "
  "There is no suitable template specialization of Glib::Value<>.");

Glib::PropertyProxy< TreeViewColumn* > TreeView::property_expander_column() 
{
  return Glib::PropertyProxy< TreeViewColumn* >(this, "expander-column");
}

Glib::PropertyProxy_ReadOnly< TreeViewColumn* > TreeView::property_expander_column() const
{
  return Glib::PropertyProxy_ReadOnly< TreeViewColumn* >(this, "expander-column");
}

Glib::PropertyProxy< bool > TreeView::property_reorderable() 
{
  return Glib::PropertyProxy< bool >(this, "reorderable");
}

Glib::PropertyProxy_ReadOnly< bool > TreeView::property_reorderable() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "reorderable");
}

Glib::PropertyProxy< bool > TreeView::property_enable_search() 
{
  return Glib::PropertyProxy< bool >(this, "enable-search");
}

Glib::PropertyProxy_ReadOnly< bool > TreeView::property_enable_search() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "enable-search");
}

Glib::PropertyProxy< int > TreeView::property_search_column() 
{
  return Glib::PropertyProxy< int >(this, "search-column");
}

Glib::PropertyProxy_ReadOnly< int > TreeView::property_search_column() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "search-column");
}

Glib::PropertyProxy< bool > TreeView::property_fixed_height_mode() 
{
  return Glib::PropertyProxy< bool >(this, "fixed-height-mode");
}

Glib::PropertyProxy_ReadOnly< bool > TreeView::property_fixed_height_mode() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "fixed-height-mode");
}

Glib::PropertyProxy< bool > TreeView::property_hover_selection() 
{
  return Glib::PropertyProxy< bool >(this, "hover-selection");
}

Glib::PropertyProxy_ReadOnly< bool > TreeView::property_hover_selection() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "hover-selection");
}

Glib::PropertyProxy< bool > TreeView::property_hover_expand() 
{
  return Glib::PropertyProxy< bool >(this, "hover-expand");
}

Glib::PropertyProxy_ReadOnly< bool > TreeView::property_hover_expand() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "hover-expand");
}

Glib::PropertyProxy< bool > TreeView::property_show_expanders() 
{
  return Glib::PropertyProxy< bool >(this, "show-expanders");
}

Glib::PropertyProxy_ReadOnly< bool > TreeView::property_show_expanders() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "show-expanders");
}

Glib::PropertyProxy< bool > TreeView::property_level_indentation() 
{
  return Glib::PropertyProxy< bool >(this, "level-indentation");
}

Glib::PropertyProxy_ReadOnly< bool > TreeView::property_level_indentation() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "level-indentation");
}

Glib::PropertyProxy< bool > TreeView::property_rubber_banding() 
{
  return Glib::PropertyProxy< bool >(this, "rubber-banding");
}

Glib::PropertyProxy_ReadOnly< bool > TreeView::property_rubber_banding() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "rubber-banding");
}

Glib::PropertyProxy< bool > TreeView::property_enable_grid_lines() 
{
  return Glib::PropertyProxy< bool >(this, "enable-grid-lines");
}

Glib::PropertyProxy_ReadOnly< bool > TreeView::property_enable_grid_lines() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "enable-grid-lines");
}

Glib::PropertyProxy< bool > TreeView::property_enable_tree_lines() 
{
  return Glib::PropertyProxy< bool >(this, "enable-tree-lines");
}

Glib::PropertyProxy_ReadOnly< bool > TreeView::property_enable_tree_lines() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "enable-tree-lines");
}

Glib::PropertyProxy< int > TreeView::property_tooltip_column() 
{
  return Glib::PropertyProxy< int >(this, "tooltip-column");
}

Glib::PropertyProxy_ReadOnly< int > TreeView::property_tooltip_column() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "tooltip-column");
}

Glib::PropertyProxy< bool > TreeView::property_activate_on_single_click() 
{
  return Glib::PropertyProxy< bool >(this, "activate-on-single-click");
}

Glib::PropertyProxy_ReadOnly< bool > TreeView::property_activate_on_single_click() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "activate-on-single-click");
}


} // namespace Gtk


