// Generated by gmmproc 2.68.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gtkmm/snapshot.h>
#include <gtkmm/private/snapshot_p.h>


/* Copyright (C) 2017 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <gdkmm/cairoutils.h>
#include <gdkmm/rgba.h>
#include <gdkmm/texture.h>
#include <memory>

namespace
{
std::unique_ptr<graphene_rect_t>
gdk_rect_to_graphene_rect(const Gdk::Rectangle& gdk_rect)
{
  graphene_rect_t* graphene_rect = new graphene_rect_t;
  graphene_rect_init(graphene_rect, gdk_rect.get_x(), gdk_rect.get_y(),
    gdk_rect.get_width(), gdk_rect.get_height());
  return std::unique_ptr<graphene_rect_t>(graphene_rect);
}
} // anonymous namespace

namespace Gtk
{

void Snapshot::push_debug(const Glib::ustring& name)
{
  if (name.empty())
    gtk_snapshot_push_debug(gobj(), nullptr);
  else
    gtk_snapshot_push_debug(gobj(),"%s", name.c_str());
}

} //namespace Gtk

namespace Glib
{

Glib::RefPtr<Gtk::Snapshot> wrap_gtk_snapshot(GtkSnapshot* object, bool take_copy)
{
  return Glib::make_refptr_for_instance<Gtk::Snapshot>( dynamic_cast<Gtk::Snapshot*> (Glib::wrap_auto((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */

namespace
{
} // anonymous namespace


namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& Snapshot_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Snapshot_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_snapshot_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Snapshot_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


}


Glib::ObjectBase* Snapshot_Class::wrap_new(GObject* object)
{
  return new Snapshot((GtkSnapshot*)object);
}


/* The implementation: */

GtkSnapshot* Snapshot::gobj_copy()
{
  reference();
  return gobj();
}

Snapshot::Snapshot(const Glib::ConstructParams& construct_params)
:
  Gdk::Snapshot(construct_params)
{

}

Snapshot::Snapshot(GtkSnapshot* castitem)
:
  Gdk::Snapshot((GdkSnapshot*)(castitem))
{}


Snapshot::Snapshot(Snapshot&& src) noexcept
: Gdk::Snapshot(std::move(src))
{}

Snapshot& Snapshot::operator=(Snapshot&& src) noexcept
{
  Gdk::Snapshot::operator=(std::move(src));
  return *this;
}


Snapshot::~Snapshot() noexcept
{}


Snapshot::CppClassType Snapshot::snapshot_class_; // initialize static member

GType Snapshot::get_type()
{
  return snapshot_class_.init().get_type();
}


GType Snapshot::get_base_type()
{
  return gtk_snapshot_get_type();
}


Glib::RefPtr<Snapshot> Snapshot::create()
{
  return Glib::wrap_gtk_snapshot(gtk_snapshot_new());
}

void Snapshot::push_opacity(double opacity)
{
  gtk_snapshot_push_opacity(gobj(), opacity);
}

void Snapshot::push_blur(double radius)
{
  gtk_snapshot_push_blur(gobj(), radius);
}

void Snapshot::push_repeat(const graphene_rect_t* bounds, const graphene_rect_t* child_bounds)
{
  gtk_snapshot_push_repeat(gobj(), bounds, child_bounds);
}

void Snapshot::push_repeat(const Gdk::Rectangle& bounds, const Gdk::Rectangle& child_bounds)
{
  gtk_snapshot_push_repeat(gobj(), gdk_rect_to_graphene_rect(bounds).get(), gdk_rect_to_graphene_rect(child_bounds).get());
}

void Snapshot::push_repeat(const Gdk::Rectangle& bounds)
{
  gtk_snapshot_push_repeat(gobj(), gdk_rect_to_graphene_rect(bounds).get(), nullptr);
}

void Snapshot::push_clip(const graphene_rect_t* bounds)
{
  gtk_snapshot_push_clip(gobj(), bounds);
}

void Snapshot::push_clip(const Gdk::Rectangle& bounds)
{
  gtk_snapshot_push_clip(gobj(), gdk_rect_to_graphene_rect(bounds).get());
}

void Snapshot::push_cross_fade(double progress)
{
  gtk_snapshot_push_cross_fade(gobj(), progress);
}

void Snapshot::gl_shader_pop_texture()
{
  gtk_snapshot_gl_shader_pop_texture(gobj());
}

void Snapshot::pop()
{
  gtk_snapshot_pop(gobj());
}

void Snapshot::save()
{
  gtk_snapshot_save(gobj());
}

void Snapshot::restore()
{
  gtk_snapshot_restore(gobj());
}

void Snapshot::rotate(float angle)
{
  gtk_snapshot_rotate(gobj(), angle);
}

void Snapshot::scale(float factor_x, float factor_y)
{
  gtk_snapshot_scale(gobj(), factor_x, factor_y);
}

void Snapshot::scale(float factor_x, float factor_y, float factor_z)
{
  gtk_snapshot_scale_3d(gobj(), factor_x, factor_y, factor_z);
}

void Snapshot::perspective(float depth)
{
  gtk_snapshot_perspective(gobj(), depth);
}

Cairo::RefPtr<Cairo::Context> Snapshot::append_cairo(const graphene_rect_t* bounds)
{
  return Gdk::Cairo::wrap(gtk_snapshot_append_cairo(gobj(), bounds));
}

Cairo::RefPtr<Cairo::Context> Snapshot::append_cairo(const Gdk::Rectangle& bounds)
{
  return Gdk::Cairo::wrap(gtk_snapshot_append_cairo(gobj(), gdk_rect_to_graphene_rect(bounds).get()));
}

void Snapshot::append_texture(const Glib::RefPtr<Gdk::Texture>& texture, const graphene_rect_t* bounds)
{
  gtk_snapshot_append_texture(gobj(), Glib::unwrap(texture), bounds);
}

void Snapshot::append_texture(const Glib::RefPtr<Gdk::Texture>& texture, const Gdk::Rectangle& bounds)
{
  gtk_snapshot_append_texture(gobj(), Glib::unwrap(texture), gdk_rect_to_graphene_rect(bounds).get());
}

void Snapshot::append_color(const Gdk::RGBA& color, const graphene_rect_t* bounds)
{
  gtk_snapshot_append_color(gobj(), (color).gobj(), bounds);
}

void Snapshot::append_color(const Gdk::RGBA& color, const Gdk::Rectangle& bounds)
{
  gtk_snapshot_append_color(gobj(), (color).gobj(), gdk_rect_to_graphene_rect(bounds).get());
}

void Snapshot::append_layout(const Glib::RefPtr<Pango::Layout>& layout, const Gdk::RGBA& color)
{
  gtk_snapshot_append_layout(gobj(), Glib::unwrap(layout), (color).gobj());
}

void Snapshot::render_backgrount(const Glib::RefPtr<StyleContext>& context, double x, double y, double width, double height)
{
  gtk_snapshot_render_background(gobj(), Glib::unwrap(context), x, y, width, height);
}

void Snapshot::render_frame(const Glib::RefPtr<StyleContext>& context, double x, double y, double width, double height)
{
  gtk_snapshot_render_frame(gobj(), Glib::unwrap(context), x, y, width, height);
}

void Snapshot::render_focus(const Glib::RefPtr<StyleContext>& context, double x, double y, double width, double height)
{
  gtk_snapshot_render_focus(gobj(), Glib::unwrap(context), x, y, width, height);
}

void Snapshot::render_layout(const Glib::RefPtr<StyleContext>& context, double x, double y, const Glib::RefPtr<Pango::Layout>& layout)
{
  gtk_snapshot_render_layout(gobj(), Glib::unwrap(context), x, y, Glib::unwrap(layout));
}

void Snapshot::render_insertion_cursor(const Glib::RefPtr<StyleContext>& context, double x, double y, const Glib::RefPtr<Pango::Layout>& layout, int index, Pango::Direction direction)
{
  gtk_snapshot_render_insertion_cursor(gobj(), Glib::unwrap(context), x, y, Glib::unwrap(layout), index, static_cast<PangoDirection>(direction));
}


} // namespace Gtk


