// -*- c++ -*-
// Generated by gmmproc 2.37.7 -- DO NOT MODIFY!
#ifndef _GTKMM_STYLECONTEXT_H
#define _GTKMM_STYLECONTEXT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2010 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <gtkmm/styleprovider.h>
#include <gtkmm/border.h>
#include <gtkmm/enums.h>
#include <gdkmm/window.h>
#include <gdkmm/screen.h>

#include <gtkmm/enums.h>
#include <gtkmm/iconsource.h>
#include <gtkmm/iconset.h>
#include <gtkmm/widgetpath.h>
#include <pangomm/context.h>
#include <pangomm/fontdescription.h>
#include <pangomm/layout.h>
#include <gtkmmconfig.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkStyleContext GtkStyleContext;
typedef struct _GtkStyleContextClass GtkStyleContextClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class StyleContext_Class; } // namespace Gtk
namespace Gtk
{

class IconSet;

//TODO: Add (and translate to C++) the code examples from the C documentation.
/** This object stores styling information affecting a widget defined by WidgetPath.
 *
 * In order to construct the final style information, StyleContext
 * queries information from all attached StyleProviders. Style providers
 * can be either attached explicitly to the context through
 * add_provider(), or to the screen through
 * add_provider_for_screen(). The resulting style is a
 * combination of all providers' information in priority order.
 *
 * For GTK+ widgets, any StyleContext returned by
 * Widget::get_style_context() will already have a WidgetPath, a
 * Gdk::Screen and RTL/LTR information set, The style context will be also
 * updated automatically if any of these settings change on the widget.
 *
 * If you are using the theming layer standalone, you will need to set a
 * widget path and a screen yourself to the created style context through
 * set_path() and set_screen(), as well
 * as updating the context yourself using invalidate()
 * whenever any of the conditions change, such as a change in the
 * Settings::property_gtk_theme_name() setting or a hierarchy change in the rendered
 * widget.
 *
 * <h2>Transition animations</h2>
 *
 * StyleContext has built-in support for state change transitions.
 * Note that these animations respect the Settings::property_gtk_enable_animations()
 * setting.
 *
 * For simple widgets where state changes affect the whole widget area,
 * calling notify_state_change() with a no region
 * is sufficient to trigger the transition animation. And GTK+ already
 * does that when Widget::set_state() or Widget::set_state_flags()
 * are called.
 *
 * If a widget needs to declare several animatable regions (i.e. not
 * affecting the whole widget area), its Widget::signal_draw() signal handler
 * needs to wrap the render operations for the different regions with
 * calls to push_animatable_region() and
 * pop_animatable_region(). These methods take an
 * identifier for the region which must be unique within the style context.
 * For simple widgets with a fixed set of animatable regions, using an
 * enumeration works well.
 *
 * For complex widgets with an arbitrary number of animatable regions, it
 * is up to the implementation to come up with a way to uniquely identify
 * each animatable region. Using pointers to internal objects is one way
 * to achieve this.
 *
 * The widget also needs to notify the style context about a state change
 * for a given animatable region so the animation is triggered.
 * notify_state_change() can take no region IDs, meaning that the whole widget
 * area will be updated by the animation.
 *
 * @newin{3,0}
 */

class StyleContext : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef StyleContext CppObjectType;
  typedef StyleContext_Class CppClassType;
  typedef GtkStyleContext BaseObjectType;
  typedef GtkStyleContextClass BaseClassType;

private:  friend class StyleContext_Class;
  static CppClassType stylecontext_class_;

private:
  // noncopyable
  StyleContext(const StyleContext&);
  StyleContext& operator=(const StyleContext&);

protected:
  explicit StyleContext(const Glib::ConstructParams& construct_params);
  explicit StyleContext(GtkStyleContext* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~StyleContext();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkStyleContext*       gobj()       { return reinterpret_cast<GtkStyleContext*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkStyleContext* gobj() const { return reinterpret_cast<GtkStyleContext*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkStyleContext* gobj_copy();

private:

protected:
  StyleContext();

public:
  
  static Glib::RefPtr<StyleContext> create();

  
  /** Adds a global style provider to @a screen, which will be used
   * in style construction for all Gtk::StyleContexts under @a screen.
   * 
   * GTK+ uses this to make styling information from Gtk::Settings
   * available.
   * 
   * <note>If both priorities are the same, A Gtk::StyleProvider
   * added through add_provider() takes precedence
   * over another added through this function.</note>
   * 
   * @newin{3,0}
   * @param screen A Gdk::Screen.
   * @param provider A Gtk::StyleProvider.
   * @param priority The priority of the style provider. The lower
   * it is, the earlier it will be used in the style
   * construction. Typically this will be in the range
   * between Gtk::STYLE_PROVIDER_PRIORITY_FALLBACK and
   * Gtk::STYLE_PROVIDER_PRIORITY_USER.
   */
  static void add_provider_for_screen(const Glib::RefPtr<Gdk::Screen>& screen, const Glib::RefPtr<StyleProvider>& provider, guint priority);
  
  /** Removes @a provider from the global style providers list in @a screen.
   * 
   * @newin{3,0}
   * @param screen A Gdk::Screen.
   * @param provider A Gtk::StyleProvider.
   */
  static void remove_provider_for_screen(const Glib::RefPtr<Gdk::Screen>& screen, const Glib::RefPtr<StyleProvider>& provider);

  
  /** Adds a style provider to @a context, to be used in style construction.
   * Note that a style provider added by this function only affects
   * the style of the widget to which @a context belongs. If you want
   * to affect the style of all widgets, use
   * add_provider_for_screen().
   * 
   * <note>If both priorities are the same, A Gtk::StyleProvider
   * added through this function takes precedence over another added
   * through add_provider_for_screen().</note>
   * 
   * @newin{3,0}
   * @param provider A Gtk::StyleProvider.
   * @param priority The priority of the style provider. The lower
   * it is, the earlier it will be used in the style
   * construction. Typically this will be in the range
   * between Gtk::STYLE_PROVIDER_PRIORITY_FALLBACK and
   * Gtk::STYLE_PROVIDER_PRIORITY_USER.
   */
  void add_provider(const Glib::RefPtr<StyleProvider>& provider, guint priority);

  
  /** Removes @a provider from the style providers list in @a context.
   * 
   * @newin{3,0}
   * @param provider A Gtk::StyleProvider.
   */
  void remove_provider(const Glib::RefPtr<StyleProvider>& provider);

  
  /** Saves the @a context state, so all modifications done through
   * add_class(), remove_class(),
   * add_region(), remove_region()
   * or set_junction_sides() can be reverted in one
   * go through restore().
   * 
   * @newin{3,0}
   */
  void context_save();
  
  /** Restores @a context state to a previous stage.
   * See save().
   * 
   * @newin{3,0}
   */
  void context_restore();

//TODO: GtkCssSection * gtk_style_context_get_section (GtkStyleContext *context, const gchar     *property);
/* TODO:
  _WRAP_METHOD(void get_property (
                                     const Glib::ustring& property,
                                     StateFlags    state,
                                     GValue          *value), gtk_style_context_get_property)
  _WRAP_METHOD(void get_valist   (
                                     StateFlags    state,
                                     va_list          args), gtk_style_context_get_valist)
  _WRAP_METHOD(void get          (
                                     StateFlags    state,
                                     ...) G_GNUC_NULL_TERMINATED;
*/

  
  /** Sets the state to be used when rendering with any
   * of the gtk_render_*() functions.
   * 
   * @newin{3,0}
   * @param flags State to represent.
   */
  void set_state(StateFlags flags);
  
  /** Returns the state used when rendering.
   * 
   * @newin{3,0}
   * @return The state flags.
   */
  StateFlags get_state() const;

  
#ifndef GTKMM_DISABLE_DEPRECATED

  /** Returns <tt>true</tt> if there is a transition animation running for the
   * current region (see push_animatable_region()).
   * 
   * If @a progress is not <tt>0</tt>, the animation progress will be returned
   * there, 0.0 means the state is closest to being unset, while 1.0 means
   * it's closest to being set. This means transition animation will
   * run from 0 to 1 when @a state is being set and from 1 to 0 when
   * it's being unset.
   * 
   * @newin{3,0}
   * 
   * Deprecated: 3.6: This function always returns <tt>false</tt>
   * @deprecated This function always returns <tt>false</tt>.
   * @param state A widget state.
   * @param progress Return location for the transition progress.
   * @return <tt>true</tt> if there is a running transition animation for @a state.
   */
  bool state_is_running(StateType state, gdouble* progress);
#endif // GTKMM_DISABLE_DEPRECATED


  /** Sets the Gtk::WidgetPath used for style matching. As a
   * consequence, the style will be regenerated to match
   * the new given path.
   * 
   * If you are using a Gtk::StyleContext returned from
   * Gtk::Widget::get_style_context(), you do not need to call
   * this yourself.
   * 
   * @newin{3,0}
   * @param path A Gtk::WidgetPath.
   */
  void set_path(const WidgetPath& path);

 
  /** Returns the widget path used for style matching.
   * 
   * @newin{3,0}
   * @return A Gtk::WidgetPath.
   */
  WidgetPath get_path() const;

  
  /** Sets the parent style context for @a context. The parent style
   * context is used to implement
   * inheritance
   * of properties.
   * 
   * If you are using a Gtk::StyleContext returned from
   * Gtk::Widget::get_style_context(), the parent will be set for you.
   * 
   * @newin{3,4}
   * @param parent The new parent or <tt>0</tt>.
   */
  void set_parent(const Glib::RefPtr<StyleContext>& parent);
  void unset_parent();

  
  /** Gets the parent context set via set_parent().
   * See that function for details.
   * 
   * @newin{3,4}
   * @return The parent context or <tt>0</tt>.
   */
  Glib::RefPtr<StyleContext> get_parent();
  
  /** Gets the parent context set via set_parent().
   * See that function for details.
   * 
   * @newin{3,4}
   * @return The parent context or <tt>0</tt>.
   */
  Glib::RefPtr<const StyleContext> get_parent() const;

 
  /** Returns the list of classes currently defined in @a context.
   * 
   * @newin{3,0}
   * @return A List of
   * strings with the currently defined classes. The contents
   * of the list are owned by GTK+, but you must free the list
   * itself with Glib::list_free() when you are done with it.
   */
  std::vector<Glib::ustring> list_classes() const;

  
  /** Adds a style class to @a context, so posterior calls to
   * get() or any of the gtk_render_*()
   * functions will make use of this new class for styling.
   * 
   * In the CSS file format, a Gtk::Entry defining an "entry"
   * class, would be matched by:
   * 
   * 
   * GtkEntry.entry { ... }
   * 
   * 
   * While any widget defining an "entry" class would be
   * matched by:
   * 
   * .entry { ... }
   * 
   * 
   * @newin{3,0}
   * @param class_name Class name to use in styling.
   */
  void add_class(const Glib::ustring& class_name);
  
  /** Removes @a class_name from @a context.
   * 
   * @newin{3,0}
   * @param class_name Class name to remove.
   */
  void remove_class(const Glib::ustring& class_name);
  
  /** Returns <tt>true</tt> if @a context currently has defined the
   * given class name
   * 
   * @newin{3,0}
   * @param class_name A class name.
   * @return <tt>true</tt> if @a context has @a class_name defined.
   */
  bool has_class(const Glib::ustring& class_name);

  
  /** Returns the list of regions currently defined in @a context.
   * 
   * @newin{3,0}
   * @return A List of
   * strings with the currently defined regions. The contents
   * of the list are owned by GTK+, but you must free the list
   * itself with Glib::list_free() when you are done with it.
   */
  GList* list_regions();

  
  /** Adds a region to @a context, so posterior calls to
   * get() or any of the gtk_render_*()
   * functions will make use of this new region for styling.
   * 
   * In the CSS file format, a Gtk::TreeView defining a "row"
   * region, would be matched by:
   * 
   * 
   * GtkTreeView row { ... }
   * 
   * 
   * Pseudo-classes are used for matching @a flags, so the two
   * following rules:
   * 
   * GtkTreeView row:nth-child(even) { ... }
   * GtkTreeView row:nth-child(odd) { ... }
   * 
   * 
   * would apply to even and odd rows, respectively.
   * 
   * <note>Region names must only contain lowercase letters
   * and '-', starting always with a lowercase letter.</note>
   * 
   * @newin{3,0}
   * @param region_name Region name to use in styling.
   * @param flags Flags that apply to the region.
   */
  void add_region(const Glib::ustring& region_name, RegionFlags flags);
  
  /** Removes a region from @a context.
   * 
   * @newin{3,0}
   * @param region_name Region name to unset.
   */
  void remove_region(const Glib::ustring& region_name);
  
  /** Returns <tt>true</tt> if @a context has the region defined.
   * If @a flags_return is not <tt>0</tt>, it is set to the flags
   * affecting the region.
   * 
   * @newin{3,0}
   * @param region_name A region name.
   * @param flags_return Return location for region flags.
   * @return <tt>true</tt> if region is defined.
   */
  bool has_region(const Glib::ustring& region_name, RegionFlags& flags_return);

  /** Gets the value of a style property
   * @param property_name The name of a style property.
   * @param value Location to return the property value.
   */
  template <class PropertyType>
  void get_style_property(const Glib::ustring& property_name, PropertyType& value) const;

  
  /** Gets the value for a widget style property.
   * 
   * When @a value is no longer needed, Glib::value_unset() must be called
   * to free any allocated memory.
   * @param property_name The name of the widget style property.
   * @param value Return location for the property value.
   */
  void get_style_property_value(const Glib::ustring& property_name, Glib::ValueBase& value) const;

  
#ifndef GTKMM_DISABLE_DEPRECATED

  /** Looks up @a stock_id in the icon factories associated to @a context and
   * the default icon factory, returning an icon set if found, otherwise
   * <tt>0</tt>.
   * 
   * Deprecated: 3.10: Use Gtk::IconTheme::lookup_icon() instead.
   * @deprecated Use IconTheme::lookup_icon() instead.
   * @param stock_id An icon name.
   * @return The looked  up Gtk::IconSet, or <tt>0</tt>.
   */
  Glib::RefPtr<IconSet> lookup_icon_set(const Glib::ustring& stock_id);
#endif // GTKMM_DISABLE_DEPRECATED


  // gtk_icon_set_render_icon_pixbuf() in gtkstylecontext.h is wrapped in IconSet::render_icon_pixbuf().

  
  /** Attaches @a context to the given screen.
   * 
   * The screen is used to add style information from 'global' style
   * providers, such as the screens Gtk::Settings instance.
   * 
   * If you are using a Gtk::StyleContext returned from
   * Gtk::Widget::get_style_context(), you do not need to
   * call this yourself.
   * 
   * @newin{3,0}
   * @param screen A Gdk::Screen.
   */
  void set_screen(const Glib::RefPtr<Gdk::Screen>& screen);

  
  /** Returns the Gdk::Screen to which @a context is attached.
   * @return A Gdk::Screen.
   */
  Glib::RefPtr<Gdk::Screen> get_screen();
  
  /** Returns the Gdk::Screen to which @a context is attached.
   * @return A Gdk::Screen.
   */
  Glib::RefPtr<const Gdk::Screen> get_screen() const;

  
#ifndef GTKMM_DISABLE_DEPRECATED

  /** Sets the reading direction for rendering purposes.
   * 
   * If you are using a Gtk::StyleContext returned from
   * Gtk::Widget::get_style_context(), you do not need to
   * call this yourself.
   * 
   * @newin{3,0}
   * 
   * Deprecated: 3.8: Use set_state() with
   * Gtk::STATE_FLAG_DIR_LTR and Gtk::STATE_FLAG_DIR_RTL
   * instead.
   * @deprecated Use set_state() with StateFlags::STATE_FLAG_DIR_LTR and StateFlags::STATE_FLAG_DIR_RTL instead.
   * @param direction The new direction.
   */
  void set_direction(TextDirection direction);
#endif // GTKMM_DISABLE_DEPRECATED


#ifndef GTKMM_DISABLE_DEPRECATED

  /** Returns the widget direction used for rendering.
   * 
   * @newin{3,0}
   * 
   * Deprecated: 3.8: Use get_state() and
   * check for Gtk::STATE_FLAG_DIR_LTR and
   * Gtk::STATE_FLAG_DIR_RTL instead.
   * @deprecated Use get_state() and check for StateFlags::STATE_FLAG_DIR_LTR and StateFlags::STATE_FLAG_DIR_RTL instead.
   * @return The widget direction.
   */
  TextDirection get_direction() const;
#endif // GTKMM_DISABLE_DEPRECATED


  /** Sets the sides where rendered elements (mostly through
   * gtk_render_frame()) will visually connect with other visual elements.
   * 
   * This is merely a hint that may or may not be honored
   * by theming engines.
   * 
   * Container widgets are expected to set junction hints as appropriate
   * for their children, so it should not normally be necessary to call
   * this function manually.
   * 
   * @newin{3,0}
   * @param sides Sides where rendered elements are visually connected to
   * other elements.
   */
  void set_junction_sides(JunctionSides sides);
  
  /** Returns the sides where rendered elements connect visually with others.
   * 
   * @newin{3,0}
   * @return The junction sides.
   */
  JunctionSides get_junction_sides() const;

  
  /** Looks up and resolves a color name in the @a context color map.
   * @param color_name Color name to lookup.
   * @param color Return location for the looked up color.
   * @return <tt>true</tt> if @a color_name was found and resolved, <tt>false</tt> otherwise.
   */
  bool lookup_color(const Glib::ustring& color_name, Gdk::RGBA& color);

  
#ifndef GTKMM_DISABLE_DEPRECATED

  /** Notifies a state change on @a context, so if the current style makes use
   * of transition animations, one will be started so all rendered elements
   * under @a region_id are animated for state @a state being set to value
   *  @a state_value.
   * 
   * The @a window parameter is used in order to invalidate the rendered area
   * as the animation runs, so make sure it is the same window that is being
   * rendered on by the gtk_render_*() functions.
   * 
   * If @a region_id is <tt>0</tt>, all rendered elements using @a context will be
   * affected by this state transition.
   * 
   * As a practical example, a Gtk::Button notifying a state transition on
   * the prelight state:
   * 
   * gtk_style_context_notify_state_change (context,
   * gtk_widget_get_window (widget),
   * <tt>0</tt>,
   * GTK_STATE_PRELIGHT,
   * button->in_button);
   * 
   * 
   * Can be handled in the CSS file like this:
   * 
   * GtkButton {
   * background-color: #f00
   * }
   * 
   * GtkButton:hover {
   * background-color: #fff;
   * transition: 200ms linear
   * }
   * 
   * 
   * This combination will animate the button background from red to white
   * if a pointer enters the button, and back to red if the pointer leaves
   * the button.
   * 
   * Note that @a state is used when finding the transition parameters, which
   * is why the style places the transition under the :hover pseudo-class.
   * 
   * @newin{3,0}
   * 
   * Deprecated: 3.6: This function does nothing.
   * @deprecated This function does nothing.
   * @param window A Gdk::Window.
   * @param region_id Animatable region to notify on, or <tt>0</tt>.
   * See push_animatable_region().
   * @param state State to trigger transition for.
   * @param state_value <tt>true</tt> if @a state is the state we are changing to,
   * <tt>false</tt> if we are changing away from it.
   */
  void notify_state_change(const Glib::RefPtr<Gdk::Window>& window, gpointer region_id, StateType state, bool state_value);
#endif // GTKMM_DISABLE_DEPRECATED


#ifndef GTKMM_DISABLE_DEPRECATED

  /** Stops all running animations for @a region_id and all animatable
   * regions underneath.
   * 
   * A <tt>0</tt> @a region_id will stop all ongoing animations in @a context,
   * when dealing with a Gtk::StyleContext obtained through
   * Gtk::Widget::get_style_context(), this is normally done for you
   * in all circumstances you would expect all widget to be stopped,
   * so this should be only used in complex widgets with different
   * animatable regions.
   * 
   * @newin{3,0}
   * 
   * Deprecated: 3.6: This function does nothing.
   * @deprecated This function does nothing.
   * @param region_id Animatable region to stop, or <tt>0</tt>.
   * See push_animatable_region().
   */
  void cancel_animations(gpointer region_id);
#endif // GTKMM_DISABLE_DEPRECATED


#ifndef GTKMM_DISABLE_DEPRECATED

  /** This function is analogous to gdk_window_scroll(), and
   * should be called together with it so the invalidation
   * areas for any ongoing animation are scrolled together
   * with it.
   * 
   * @newin{3,0}
   * 
   * Deprecated: 3.6: This function does nothing.
   * @deprecated This function does nothing.
   * @param window A Gdk::Window used previously in
   * notify_state_change().
   * @param dx Amount to scroll in the X axis.
   * @param dy Amount to scroll in the Y axis.
   */
  void scroll_animations(const Glib::RefPtr<Gdk::Window>& window, int dx, int dy);
#endif // GTKMM_DISABLE_DEPRECATED


#ifndef GTKMM_DISABLE_DEPRECATED

  /** Pushes an animatable region, so all further gtk_render_*() calls between
   * this call and the following pop_animatable_region()
   * will potentially show transition animations for this region if
   * notify_state_change() is called for a given state,
   * and the current theme/style defines transition animations for state
   * changes.
   * 
   * The @a region_id used must be unique in @a context so the theming engine
   * can uniquely identify rendered elements subject to a state transition.
   * 
   * @newin{3,0}
   * 
   * Deprecated: 3.6: This function does nothing.
   * @deprecated This function does nothing.
   * @param region_id Unique identifier for the animatable region.
   */
  void push_animatable_region(gpointer region_id);
#endif // GTKMM_DISABLE_DEPRECATED


#ifndef GTKMM_DISABLE_DEPRECATED

  /** Pops an animatable region from @a context.
   * See push_animatable_region().
   * 
   * @newin{3,0}
   * 
   * Deprecated: 3.6: This function does nothing.
   * @deprecated This function does nothing.
   */
  void pop_animatable_region();
#endif // GTKMM_DISABLE_DEPRECATED


  //TODO: Documentation
  Gdk::RGBA get_color(StateFlags state = (StateFlags)0) const;
  

  Gdk::RGBA get_background_color(StateFlags state = (StateFlags)0) const;
  

  Gdk::RGBA  get_border_color(StateFlags state = (StateFlags)0) const;
  

  /** Returns the font description for a given state.
   * 
   * @newin{3,0}
   * 
   * @param state State to retrieve the font for.
   * @return The Pango::FontDescription for the given state.
   */
  Pango::FontDescription get_font(StateFlags state =  (StateFlags)0) const;
  

  Border get_border(StateFlags state = (StateFlags)0) const;
  

  Border get_padding(StateFlags state = (StateFlags)0) const;
  

  Border get_margin (StateFlags state = (StateFlags)0) const;
  

  /** Invalidates @a context style information, so it will be reconstructed
   * again.
   * 
   * If you're using a Gtk::StyleContext returned from
   * Gtk::Widget::get_style_context(), you do not need to
   * call this yourself.
   * 
   * @newin{3,0}
   */
  void invalidate();
  //TODO: _WRAP_METHOD(void reset_widgets(const Glib::RefPtr<Gdk::Screen>& screen), gtk_style_context_reset_widgets)

  
  /** Sets the background of @a window to the background pattern or
   * color specified in @a context for its current state.
   * 
   * @newin{3,0}
   * @param window A Gdk::Window.
   */
  void set_background(const Glib::RefPtr<Gdk::Window>& window);

  
  /** Renders a checkmark (as in a Gtk::CheckButton).
   * 
   * The Gtk::STATE_FLAG_ACTIVE state determines whether the check is
   * on or off, and Gtk::STATE_FLAG_INCONSISTENT determines whether it
   * should be marked as undefined.
   * 
   * <example>
   * <title>Typical checkmark rendering</title>
   * <inlinegraphic fileref="checks.png" format="PNG"/>
   * </example>
   * 
   * @newin{3,0}
   * @param context A Gtk::StyleContext.
   * @param cr A #cairo_t.
   * @param x X origin of the rectangle.
   * @param y Y origin of the rectangle.
   * @param width Rectangle width.
   * @param height Rectangle height.
   */
  void render_check(const ::Cairo::RefPtr< ::Cairo::Context>& cr, double x, double y, double width, double height);
  
  /** Renders an option mark (as in a Gtk::RadioButton), the Gtk::STATE_FLAG_ACTIVE
   * state will determine whether the option is on or off, and
   * Gtk::STATE_FLAG_INCONSISTENT whether it should be marked as undefined.
   * 
   * <example>
   * <title>Typical option mark rendering</title>
   * <inlinegraphic fileref="options.png" format="PNG"/>
   * </example>
   * 
   * @newin{3,0}
   * @param context A Gtk::StyleContext.
   * @param cr A #cairo_t.
   * @param x X origin of the rectangle.
   * @param y Y origin of the rectangle.
   * @param width Rectangle width.
   * @param height Rectangle height.
   */
  void render_option(const ::Cairo::RefPtr< ::Cairo::Context>& cr, double x, double y, double width, double height);
  
  /** Renders an arrow pointing to @a angle.
   * 
   * <example>
   * <title>Typical arrow rendering at 0, 1/2 ∏, ∏ and 3/2 ∏</title>
   * <inlinegraphic fileref="arrows.png" format="PNG"/>
   * </example>
   * 
   * @newin{3,0}
   * @param context A Gtk::StyleContext.
   * @param cr A #cairo_t.
   * @param angle Arrow angle from 0 to 2 * PI, being 0 the arrow pointing to the north.
   * @param x X origin of the render area.
   * @param y Y origin of the render area.
   * @param size Square side for render area.
   */
  void render_arrow(const ::Cairo::RefPtr< ::Cairo::Context>& cr, double angle, double x, double y, double size);
  
  /** Renders the background of an element.
   * 
   * <example>
   * <title>Typical background rendering, showing the effect of
   * <parameter>background-image</parameter>,
   * <parameter>border-width</parameter> and
   * <parameter>border-radius</parameter></title>
   * <inlinegraphic fileref="background.png" format="PNG"/>
   * </example>
   * 
   * @newin{3,0}
   * @param context A Gtk::StyleContext.
   * @param cr A #cairo_t.
   * @param x X origin of the rectangle.
   * @param y Y origin of the rectangle.
   * @param width Rectangle width.
   * @param height Rectangle height.
   */
  void render_background(const ::Cairo::RefPtr< ::Cairo::Context>& cr, double x, double y, double width, double height);
  
  /** Renders a frame around the rectangle defined by @a x, @a y, @a width, @a height.
   * 
   * <example>
   * <title>Examples of frame rendering, showing the effect of
   * <parameter>border-image</parameter>,
   * <parameter>border-color</parameter>,
   * <parameter>border-width</parameter>,
   * <parameter>border-radius</parameter> and
   * junctions</title>
   * <inlinegraphic fileref="frames.png" format="PNG"/>
   * </example>
   * 
   * @newin{3,0}
   * @param context A Gtk::StyleContext.
   * @param cr A #cairo_t.
   * @param x X origin of the rectangle.
   * @param y Y origin of the rectangle.
   * @param width Rectangle width.
   * @param height Rectangle height.
   */
  void render_frame(const ::Cairo::RefPtr< ::Cairo::Context>& cr, double x, double y, double width, double height);
  
  /** Renders an expander (as used in Gtk::TreeView and Gtk::Expander) in the area
   * defined by @a x, @a y, @a width, @a height. The state Gtk::STATE_FLAG_ACTIVE
   * determines whether the expander is collapsed or expanded.
   * 
   * <example>
   * <title>Typical expander rendering</title>
   * <inlinegraphic fileref="expanders.png" format="PNG"/>
   * </example>
   * 
   * @newin{3,0}
   * @param context A Gtk::StyleContext.
   * @param cr A #cairo_t.
   * @param x X origin of the rectangle.
   * @param y Y origin of the rectangle.
   * @param width Rectangle width.
   * @param height Rectangle height.
   */
  void render_expander(const ::Cairo::RefPtr< ::Cairo::Context>& cr, double x, double y, double width, double height);
  
  /** Renders a focus indicator on the rectangle determined by @a x, @a y, @a width, @a height.
   * <example>
   * <title>Typical focus rendering</title>
   * <inlinegraphic fileref="focus.png" format="PNG"/>
   * </example>
   * 
   * @newin{3,0}
   * @param context A Gtk::StyleContext.
   * @param cr A #cairo_t.
   * @param x X origin of the rectangle.
   * @param y Y origin of the rectangle.
   * @param width Rectangle width.
   * @param height Rectangle height.
   */
  void render_focus(const ::Cairo::RefPtr< ::Cairo::Context>& cr, double x, double y, double width, double height);
  
#ifndef GTKMM_DISABLE_DEPRECATED

  /** Renders @a layout on the coordinates @a x, @a y
   * 
   * @newin{3,0}
   * @deprecated Use the render_layout() taking a const Glib::RefPtr<Pango::Layout>& layout.
   * @param context A Gtk::StyleContext.
   * @param cr A #cairo_t.
   * @param x X origin.
   * @param y Y origin.
   * @param layout The Pango::Layout to render.
   */
  void render_layout(const ::Cairo::RefPtr< ::Cairo::Context>& cr, double x, double y, PangoLayout* layout);
#endif // GTKMM_DISABLE_DEPRECATED


  /** Renders @a layout on the coordinates @a x, @a y
   * 
   * @newin{3,0}
   * @param context A Gtk::StyleContext.
   * @param cr A #cairo_t.
   * @param x X origin.
   * @param y Y origin.
   * @param layout The Pango::Layout to render.
   */
  void render_layout(const ::Cairo::RefPtr< ::Cairo::Context>& cr, double x, double y, const Glib::RefPtr<Pango::Layout>& layout);
  
  /** Renders a line from (x0, y0) to (x1, y1).
   * 
   * @newin{3,0}
   * @param context A Gtk::StyleContext.
   * @param cr A #cairo_t.
   * @param x0 X coordinate for the origin of the line.
   * @param y0 Y coordinate for the origin of the line.
   * @param x1 X coordinate for the end of the line.
   * @param y1 Y coordinate for the end of the line.
   */
  void render_line(const ::Cairo::RefPtr< ::Cairo::Context>& cr, double x0, double y0, double x1, double y1);
  
  /** Renders a slider (as in Gtk::Scale) in the rectangle defined by @a x, @a y,
   *  @a width, @a height. @a orientation defines whether the slider is vertical
   * or horizontal.
   * 
   * <example>
   * <title>Typical slider rendering</title>
   * <inlinegraphic fileref="sliders.png" format="PNG"/>
   * </example>
   * 
   * @newin{3,0}
   * @param context A Gtk::StyleContext.
   * @param cr A #cairo_t.
   * @param x X origin of the rectangle.
   * @param y Y origin of the rectangle.
   * @param width Rectangle width.
   * @param height Rectangle height.
   * @param orientation Orientation of the slider.
   */
  void render_slider(const ::Cairo::RefPtr< ::Cairo::Context>& cr, double x, double y, double width, double height, Orientation orientation);
  
  /** Renders a frame around the rectangle defined by ( @a x, @a y, @a width, @a height),
   * leaving a gap on one side. @a xy0_gap and @a xy1_gap will mean X coordinates
   * for Gtk::POS_TOP and Gtk::POS_BOTTOM gap sides, and Y coordinates for
   * Gtk::POS_LEFT and Gtk::POS_RIGHT.
   * 
   * <example>
   * <title>Typical rendering of a frame with a gap</title>
   * <inlinegraphic fileref="frame-gap.png" format="PNG"/>
   * </example>
   * 
   * @newin{3,0}
   * @param context A Gtk::StyleContext.
   * @param cr A #cairo_t.
   * @param x X origin of the rectangle.
   * @param y Y origin of the rectangle.
   * @param width Rectangle width.
   * @param height Rectangle height.
   * @param gap_side Side where the gap is.
   * @param xy0_gap Initial coordinate (X or Y depending on @a gap_side) for the gap.
   * @param xy1_gap End coordinate (X or Y depending on @a gap_side) for the gap.
   */
  void render_frame_gap(const ::Cairo::RefPtr< ::Cairo::Context>& cr, double x, double y, double width, double height, PositionType gap_side, double xy0_gap, double xy1_gap);
  
  /** Renders a extension (as in a Gtk::Notebook tab) in the rectangle
   * defined by @a x, @a y, @a width, @a height. The side where the extension
   * connects to is defined by @a gap_side.
   * 
   * <example>
   * <title>Typical extension rendering</title>
   * <inlinegraphic fileref="extensions.png" format="PNG"/>
   * </example>
   * 
   * @newin{3,0}
   * @param context A Gtk::StyleContext.
   * @param cr A #cairo_t.
   * @param x X origin of the rectangle.
   * @param y Y origin of the rectangle.
   * @param width Rectangle width.
   * @param height Rectangle height.
   * @param gap_side Side where the gap is.
   */
  void render_extension(const ::Cairo::RefPtr< ::Cairo::Context>& cr, double x, double y, double width, double height, PositionType gap_side);
  
  /** Renders a handle (as in Gtk::HandleBox, Gtk::Paned and
   * Gtk::Window<!-- -->'s resize grip), in the rectangle
   * determined by @a x, @a y, @a width, @a height.
   * 
   * <example>
   * <title>Handles rendered for the paned and grip classes</title>
   * <inlinegraphic fileref="handles.png" format="PNG"/>
   * </example>
   * 
   * @newin{3,0}
   * @param context A Gtk::StyleContext.
   * @param cr A #cairo_t.
   * @param x X origin of the rectangle.
   * @param y Y origin of the rectangle.
   * @param width Rectangle width.
   * @param height Rectangle height.
   */
  void render_handle(const ::Cairo::RefPtr< ::Cairo::Context>& cr, double x, double y, double width, double height);
  
  /** Renders an activity area (Such as in Gtk::Spinner or the
   * fill line in Gtk::Range), the state Gtk::STATE_FLAG_ACTIVE
   * determines whether there is activity going on.
   * 
   * @newin{3,0}
   * @param context A Gtk::StyleContext.
   * @param cr A #cairo_t.
   * @param x X origin of the rectangle.
   * @param y Y origin of the rectangle.
   * @param width Rectangle width.
   * @param height Rectangle height.
   */
  void render_activity(const ::Cairo::RefPtr< ::Cairo::Context>& cr, double x, double y, double width, double height);
  
#ifndef GTKMM_DISABLE_DEPRECATED

  /** Renders the icon specified by @a source at the given @a size, returning the result
   * in a pixbuf.
   * 
   * @newin{3,0}
   * 
   * Deprecated: 3.10: Use Gtk::IconTheme::load_icon() instead.
   * @deprecated Use IconTheme::load_icon() instead.
   * @param context A Gtk::StyleContext.
   * @param source The Gtk::IconSource specifying the icon to render.
   * @param size The size to render the icon at. A size of (GtkIconSize) -1
   * means render at the size of the source and don't scale.
   * @return A newly-created Gdk::Pixbuf containing the rendered icon.
   */
  Glib::RefPtr<Gdk::Pixbuf> render_icon_pixbuf(const IconSource& source, IconSize size);
#endif // GTKMM_DISABLE_DEPRECATED


  /** Renders the icon in @a pixbuf at the specified @a x and @a y coordinates.
   * 
   * @newin{3,2}
   * @param context A Gtk::StyleContext.
   * @param cr A #cairo_t.
   * @param pixbuf A Gdk::Pixbuf containing the icon to draw.
   * @param x X position for the @a pixbuf.
   * @param y Y position for the @a pixbuf.
   */
  void render_icon(const ::Cairo::RefPtr< ::Cairo::Context>& cr, const Glib::RefPtr<Gdk::Pixbuf>& pixbuf, double x, double y);
  
  /** Draws a text caret on @a cr at the specified index of @a layout.
   * 
   * @newin{3,4}
   * @param context A Gtk::StyleContext.
   * @param cr A #cairo_t.
   * @param x X origin.
   * @param y Y origin.
   * @param layout The Pango::Layout of the text.
   * @param index The index in the Pango::Layout.
   * @param direction The Pango::Direction of the text.
   */
  void render_insertion_cursor(const ::Cairo::RefPtr< ::Cairo::Context>& cr, double x, double y, const Glib::RefPtr<Pango::Layout>& layout, int index, Pango::Direction direction);


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%changed()</tt>
   *
   */

  Glib::SignalProxy0< void > signal_changed();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The associated GdkScreen.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gdk::Screen> > property_screen() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The associated GdkScreen.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Screen> > property_screen() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Text direction.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< TextDirection > property_direction() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Text direction.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< TextDirection > property_direction() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The parent style context.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<StyleContext> > property_parent() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The parent style context.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<StyleContext> > property_parent() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_changed().
  virtual void on_changed();


};

#ifndef DOXYGEN_SHOULD_SKIP_THIS

template <class PropertyType>
void StyleContext::get_style_property(const Glib::ustring& property_name, PropertyType& value) const
{
  Glib::Value<PropertyType> property_value;
  property_value.init(Glib::Value<PropertyType>::value_type());

  this->get_style_property_value(property_name, property_value);

  value = property_value.get();
}

#endif
} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::StyleContext
   */
  Glib::RefPtr<Gtk::StyleContext> wrap(GtkStyleContext* object, bool take_copy = false);
}


#endif /* _GTKMM_STYLECONTEXT_H */

