// Generated by gmmproc 2.51.2 -- DO NOT MODIFY!
#ifndef _GTKMM_SEARCHENTRY_H
#define _GTKMM_SEARCHENTRY_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2012 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtkmm/entry.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkSearchEntry = struct _GtkSearchEntry;
using GtkSearchEntryClass = struct _GtkSearchEntryClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class SearchEntry_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

/** This is a subclass of Gtk::Entry that has
 * been tailored for use as a search entry.
 *
 * It will show an inactive symbolic "find" icon when the
 * search entry is empty, and a symbolic "clear" icon when
 * there is text. Clicking on the "clear" icon will empty
 * the search entry.
 *
 * Note that the search/clear icon is shown using a secondary
 * icon, and thus does not work if you are using the secondary
 * icon position for some other purpose.
 *
 * To make filtering appear more reactive, it is a good idea to
 * not react to every change in the entry text immediately, but
 * only after a short delay. To support this, Gtk::SearchEntry
 * emits the signal_search_changed() signal which can
 * be used instead of the Gtk::Editable::signal_changed() signal.
 *
 * The signal_previous_match(), signal_next_match()
 * and signal_stop_search() signals can be uesd to implement
 * moving between search results and ending the search.
 *
 * Often, Gtk::SearchEntry will be fed events by means of being
 * placed inside a Gtk::SearchBar. If that is not the case,
 * you can use handle_event() to pass events.
 *
 * @ingroup Widgets
 * @newin{3,6}
 */

class SearchEntry
: public Entry
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef SearchEntry CppObjectType;
  typedef SearchEntry_Class CppClassType;
  typedef GtkSearchEntry BaseObjectType;
  typedef GtkSearchEntryClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  SearchEntry(SearchEntry&& src) noexcept;
  SearchEntry& operator=(SearchEntry&& src) noexcept;

  // noncopyable
  SearchEntry(const SearchEntry&) = delete;
  SearchEntry& operator=(const SearchEntry&) = delete;

  ~SearchEntry() noexcept override;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class SearchEntry_Class;
  static CppClassType searchentry_class_;

protected:
  explicit SearchEntry(const Glib::ConstructParams& construct_params);
  explicit SearchEntry(GtkSearchEntry* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkSearchEntry*       gobj()       { return reinterpret_cast<GtkSearchEntry*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkSearchEntry* gobj() const { return reinterpret_cast<GtkSearchEntry*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_search_changed().
  virtual void on_search_changed();
  /// This is a default handler for the signal signal_next_match().
  virtual void on_next_match();
  /// This is a default handler for the signal signal_previous_match().
  virtual void on_previous_match();
  /// This is a default handler for the signal signal_stop_search().
  virtual void on_stop_search();


private:

public:

  SearchEntry();

  //TODO: Use Gdk::EventKey, if we ever use Gdk::Event elsewhere in the API:
//We use GdkEventKey* rather than GdkEvent*. See GTK+ bug https://bugzilla.gnome.org/show_bug.cgi?id=709544
 

  /** This function should be called when the top-level window
   * which contains the search entry received a key event. If
   * the entry is part of a Gtk::SearchBar, it is preferable
   * to call Gtk::SearchBar::handle_event() instead, which will
   * reveal the entry in addition to passing the event to this
   * function.
   * 
   * If the key event is handled by the search entry and starts
   * or continues a search, Gdk::EVENT_STOP will be returned.
   * The caller should ensure that the entry is shown in this
   * case, and not propagate the event further.
   * 
   * @newin{3,16}
   * 
   * @param gdk_event A key event.
   * @return Gdk::EVENT_STOP if the key press event resulted
   * in a search beginning or continuing, Gdk::EVENT_PROPAGATE
   * otherwise.
   */
  bool handle_event(GdkEventKey* gdk_event);

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%search_changed()</tt>
   *
   * The Gtk::SearchEntry::signal_search_changed() signal is emitted with a short
   * delay of 150 milliseconds after the last change to the entry text.
   * 
   * @newin{3,10}
   */

  Glib::SignalProxy<void()> signal_search_changed();

  // Although next-match, previous-match and stop-search are keybinding signals,
  // applications shall connect to them.
  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%next_match()</tt>
   *
   * The signal_next_match() signal is a [keybinding signal][GtkBindingSignal]
   * which gets emitted when the user initiates a move to the next match
   * for the current search string.
   * 
   * Applications should connect to it, to implement moving between
   * matches.
   * 
   * The default bindings for this signal is Ctrl-g.
   * 
   * @newin{3,16}
   */

  Glib::SignalProxy<void()> signal_next_match();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%previous_match()</tt>
   *
   * The signal_previous_match() signal is a [keybinding signal][GtkBindingSignal]
   * which gets emitted when the user initiates a move to the previous match
   * for the current search string.
   * 
   * Applications should connect to it, to implement moving between
   * matches.
   * 
   * The default bindings for this signal is Ctrl-Shift-g.
   * 
   * @newin{3,16}
   */

  Glib::SignalProxy<void()> signal_previous_match();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%stop_search()</tt>
   *
   * The signal_stop_search() signal is a [keybinding signal][GtkBindingSignal]
   * which gets emitted when the user stops a search via keyboard input.
   * 
   * Applications should connect to it, to implement hiding the search
   * entry in this case.
   * 
   * The default bindings for this signal is Escape.
   * 
   * @newin{3,16}
   */

  Glib::SignalProxy<void()> signal_stop_search();


  // Gtk::SearchEntry has no properties nor vfuncs as of 3.16.


};

} /* namespace Gtk */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::SearchEntry
   */
  Gtk::SearchEntry* wrap(GtkSearchEntry* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_SEARCHENTRY_H */

