// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_DRAWABLE_H
#define _GDKMM_DRAWABLE_H


#include <glibmm.h>

/* $Id: drawable.hg,v 1.12 2006/12/03 17:21:37 murrayc Exp $ */

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdk/gdk.h>
#include <pangomm/font.h>
#include <pangomm/layout.h>
#include <pangomm/layoutline.h>
#include <pangomm/glyphstring.h>
#include <gdkmm/color.h>
#include <gdkmm/visual.h>
#include <gdkmm/types.h>
#include <cairomm/context.h>
#include <cairomm/region.h>
//#include <gdkmm/pixbuf.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdkDrawable GdkDrawable;
typedef struct _GdkDrawableClass GdkDrawableClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{ class Drawable_Class; } // namespace Gdk
namespace Gdk
{

class Pixbuf;

/** Drawing Primitives.
 * Gdk::Drawable is the base class for all of the objects that accept drawing
 * commands.  The available drawables include pixmaps, windows, and bitmaps.
 * Drawable is abstract as there is no such type on the server side.
 *
 * To use a drawable, create a concrete Drawable of the type you wish to use
 * and a Gdk::GC (graphics context) for that Drawable.  With the GC you can
 * draw lines, text, arcs and such.
 *
 * An alternative is to create a Cairo::Context with get_cairo_context()
 * while you handle the 'exposed' event of the drawable. For more about
 * this, please see "Using cairo with GTK+" in the "Common questions" section
 * of the GTK+ Reference Manual.
 */

class Drawable : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Drawable CppObjectType;
  typedef Drawable_Class CppClassType;
  typedef GdkDrawable BaseObjectType;
  typedef GdkDrawableClass BaseClassType;

private:  friend class Drawable_Class;
  static CppClassType drawable_class_;

private:
  // noncopyable
  Drawable(const Drawable&);
  Drawable& operator=(const Drawable&);

protected:
  explicit Drawable(const Glib::ConstructParams& construct_params);
  explicit Drawable(GdkDrawable* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Drawable();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkDrawable*       gobj()       { return reinterpret_cast<GdkDrawable*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkDrawable* gobj() const { return reinterpret_cast<GdkDrawable*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdkDrawable* gobj_copy();

private:

  
protected:
  Drawable();

public:
  
  static Glib::RefPtr<Drawable> create();


  /** Fills * @a width and * @a height with the size of @a drawable.
   *  @a width or @a height can be <tt>0</tt> if you only want the other one.
   * 
   * On the X11 platform, if @a drawable is a Gdk::Window, the returned
   * size is the size reported in the most-recently-processed configure
   * event, rather than the current size on the X server.
   * @param width Location to store drawable's width, or <tt>0</tt>.
   * @param height Location to store drawable's height, or <tt>0</tt>.
   */
  void get_size(int& width, int& height) const;
  
  /** Obtains the bit depth of the drawable, that is, the number of bits
   * that make up a pixel in the drawable's visual. Examples are 8 bits
   * per pixel, 24 bits per pixel, etc.
   * @return Number of bits per pixel.
   */
  int get_depth() const;

  
  /** Sets the colormap associated with @a drawable. Normally this will
   * happen automatically when the drawable is created; you only need to
   * use this function if the drawable-creating function did not have a
   * way to determine the colormap, and you then use drawable operations
   * that require a colormap. The colormap for all drawables and
   * graphics contexts you intend to use together should match. i.e.
   * when using a Gdk::GC to draw to a drawable, or copying one drawable
   * to another, the colormaps should match.
   * @param colormap A Gdk::Colormap.
   */
  void set_colormap(const Glib::RefPtr<Colormap>& colormap);
  
  /** Gets the colormap for @a drawable, if one is set; returns
   * <tt>0</tt> otherwise.
   * @return The colormap, or <tt>0</tt>.
   */
  Glib::RefPtr<Colormap> get_colormap();
  
  /** Gets the Gdk::Visual describing the pixel format of @a drawable.
   * @return A Gdk::Visual.
   */
  Glib::RefPtr<Visual> get_visual();

   
  //This is const because it returns a copy (though that is not very clear from the C documentation)
  
  /** Computes the region of a drawable that potentially can be written
   * to by drawing primitives. This region will not take into account
   * the clip region for the GC, and may also not take into account
   * other factors such as if the window is obscured by other windows,
   * but no area outside of this region will be affected by drawing
   * primitives.
   * @return A Gdk::Region. This must be freed with Gdk::Region::destroy()
   * when you are done.
   */
  Cairo::RefPtr<Cairo::Region> get_clip_region() const;

  //This is const because it returns a copy (though that is not very clear from the C documentation)
  
  /** Computes the region of a drawable that is potentially visible.
   * This does not necessarily take into account if the window is
   * obscured by other windows, but no area outside of this region
   * is visible.
   * @return A Gdk::Region. This must be freed with Gdk::Region::destroy()
   * when you are done.
   */
  Cairo::RefPtr<Cairo::Region> get_visible_region() const;

  
  /** Gets the Gdk::Screen associated with a Gdk::Drawable.
   * 
   * @newin{2,2}
   * @return The Gdk::Screen associated with @a drawable.
   */
  Glib::RefPtr<Screen> get_screen();
  
  /** Gets the Gdk::Screen associated with a Gdk::Drawable.
   * 
   * @newin{2,2}
   * @return The Gdk::Screen associated with @a drawable.
   */
  Glib::RefPtr<const Screen> get_screen() const;

  
  /** Gets the Gdk::Display associated with a Gdk::Drawable.
   * 
   * @newin{2,2}
   * @return The Gdk::Display associated with @a drawable.
   */
  Glib::RefPtr<Display> get_display();
  
  /** Gets the Gdk::Display associated with a Gdk::Drawable.
   * 
   * @newin{2,2}
   * @return The Gdk::Display associated with @a drawable.
   */
  Glib::RefPtr<const Display> get_display() const;

   
  /** Creates a Cairo context for drawing to @a drawable.
   * @return A newly created Cairo context.
   * 
   * @newin{2,10}.
   */
  Cairo::RefPtr<Cairo::Context> create_cairo_context();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gdk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gdk::Drawable
   */
  Glib::RefPtr<Gdk::Drawable> wrap(GdkDrawable* object, bool take_copy = false);
}


#endif /* _GDKMM_DRAWABLE_H */

